import sqlalchemy as sa
from sqlalchemy import orm
from sqlalchemy.orm import scoped_session, sessionmaker
from sqlalchemy.ext.declarative import declarative_base
import sqlalchemy as sa
from sqlalchemy_utils import database_exists, create_database
from datetime import datetime as dt



class DbSqlA():
    base        = declarative_base()
    def __init__(self,ConnectionString):
        self.engine                 = sa.create_engine(ConnectionString)
        self.session                = scoped_session(sessionmaker(autocommit=False,autoflush=False,bind=self.engine))
        self.base.query             = self.session.query_property()
        self.orm_session            = orm.scoped_session(orm.sessionmaker())(bind=self.engine)
        self.base.metadata.bind     = self.engine    

    def create_all(self):
        if not database_exists(self.engine.url):
            create_database(self.engine.url)
        self.base.metadata.create_all(self.engine)

    def save(self):
        try:
            if not self.id:
                self.session.add(self)
            self.session.commit()
        except:
            self.session.rollback()
            raise

    def delete(self):
        self.session.rollback()
        self.session.delete(self)
        self.session.commit()


class auxDB():
    id      = sa.Column(sa.Integer,primary_key=True,autoincrement=True)


