"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.LambdaInsightsVersion = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const core_1 = require("@aws-cdk/core");
const region_info_1 = require("@aws-cdk/region-info");
const architecture_1 = require("./architecture");
// To add new versions, update fact-tables.ts `CLOUDWATCH_LAMBDA_INSIGHTS_ARNS` and create a new `public static readonly VERSION_A_B_C_D`
/**
 * Version of CloudWatch Lambda Insights
 */
class LambdaInsightsVersion {
    constructor() {
        /**
         * The arn of the Lambda Insights extension
         */
        this.layerVersionArn = '';
    }
    /**
     * Use the insights extension associated with the provided ARN. Make sure the ARN is associated
     * with same region as your function
     *
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/Lambda-Insights-extension-versions.html
     */
    static fromInsightVersionArn(arn) {
        class InsightsArn extends LambdaInsightsVersion {
            constructor() {
                super(...arguments);
                this.layerVersionArn = arn;
            }
            _bind(_scope, _function) {
                return { arn };
            }
        }
        return new InsightsArn();
    }
    // Use the verison to build the object. Not meant to be called by the user -- user should use e.g. VERSION_1_0_54_0
    static fromInsightsVersion(insightsVersion) {
        class InsightsVersion extends LambdaInsightsVersion {
            constructor() {
                super(...arguments);
                this.layerVersionArn = core_1.Lazy.uncachedString({
                    produce: (context) => getVersionArn(context.scope, insightsVersion),
                });
            }
            _bind(_scope, _function) {
                const arch = _function.architecture?.name ?? architecture_1.Architecture.X86_64.name;
                // Check if insights version is valid. This should only happen if one of the public static readonly versions are set incorrectly
                // or if the version is not available for the Lambda Architecture
                const versionExists = region_info_1.RegionInfo.regions.some(regionInfo => regionInfo.cloudwatchLambdaInsightsArn(insightsVersion, arch));
                if (!versionExists) {
                    throw new Error(`Insights version ${insightsVersion} does not exist.`);
                }
                return {
                    arn: getVersionArn(_scope, insightsVersion, arch),
                };
            }
        }
        return new InsightsVersion();
    }
}
exports.LambdaInsightsVersion = LambdaInsightsVersion;
_a = JSII_RTTI_SYMBOL_1;
LambdaInsightsVersion[_a] = { fqn: "@aws-cdk/aws-lambda.LambdaInsightsVersion", version: "1.163.0" };
/**
 * Version 1.0.54.0
 */
LambdaInsightsVersion.VERSION_1_0_54_0 = LambdaInsightsVersion.fromInsightsVersion('1.0.54.0');
/**
 * Version 1.0.86.0
 */
LambdaInsightsVersion.VERSION_1_0_86_0 = LambdaInsightsVersion.fromInsightsVersion('1.0.86.0');
/**
 * Version 1.0.89.0
 */
LambdaInsightsVersion.VERSION_1_0_89_0 = LambdaInsightsVersion.fromInsightsVersion('1.0.89.0');
/**
 * Version 1.0.98.0
 */
LambdaInsightsVersion.VERSION_1_0_98_0 = LambdaInsightsVersion.fromInsightsVersion('1.0.98.0');
/**
 * Version 1.0.119.0
 */
LambdaInsightsVersion.VERSION_1_0_119_0 = LambdaInsightsVersion.fromInsightsVersion('1.0.119.0');
/**
 * Version 1.0.135.0
 */
LambdaInsightsVersion.VERSION_1_0_135_0 = LambdaInsightsVersion.fromInsightsVersion('1.0.135.0');
/**
 * Function to retrieve the correct Lambda Insights ARN from RegionInfo,
 * or create a mapping to look it up at stack deployment time.
 *
 * This function is run on CDK synthesis.
 */
function getVersionArn(scope, insightsVersion, architecture) {
    const scopeStack = core_1.Stack.of(scope);
    const region = scopeStack.region;
    const arch = architecture ?? architecture_1.Architecture.X86_64.name;
    // Region is defined, look up the arn, or throw an error if the version isn't supported by a region
    if (region !== undefined && !core_1.Token.isUnresolved(region)) {
        const arn = region_info_1.RegionInfo.get(region).cloudwatchLambdaInsightsArn(insightsVersion, arch);
        if (arn === undefined) {
            throw new Error(`Insights version ${insightsVersion} is not supported in region ${region}`);
        }
        return arn;
    }
    // Otherwise, need to add a mapping to be looked up at deployment time
    return scopeStack.regionalFact(region_info_1.FactName.cloudwatchLambdaInsightsVersion(insightsVersion, arch));
}
//# sourceMappingURL=data:application/json;base64,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