# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class TranscriptionsTopicTranscriptionMessage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        TranscriptionsTopicTranscriptionMessage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'event_time': 'datetime',
            'batch_interval_ms': 'int',
            'organization_id': 'str',
            'conversation_id': 'str',
            'communication_id': 'str',
            'session_id': 'str',
            'transcripts': 'list[TranscriptionsTopicTranscriptResult]'
        }

        self.attribute_map = {
            'event_time': 'eventTime',
            'batch_interval_ms': 'batchIntervalMs',
            'organization_id': 'organizationId',
            'conversation_id': 'conversationId',
            'communication_id': 'communicationId',
            'session_id': 'sessionId',
            'transcripts': 'transcripts'
        }

        self._event_time = None
        self._batch_interval_ms = None
        self._organization_id = None
        self._conversation_id = None
        self._communication_id = None
        self._session_id = None
        self._transcripts = None

    @property
    def event_time(self):
        """
        Gets the event_time of this TranscriptionsTopicTranscriptionMessage.


        :return: The event_time of this TranscriptionsTopicTranscriptionMessage.
        :rtype: datetime
        """
        return self._event_time

    @event_time.setter
    def event_time(self, event_time):
        """
        Sets the event_time of this TranscriptionsTopicTranscriptionMessage.


        :param event_time: The event_time of this TranscriptionsTopicTranscriptionMessage.
        :type: datetime
        """
        
        self._event_time = event_time

    @property
    def batch_interval_ms(self):
        """
        Gets the batch_interval_ms of this TranscriptionsTopicTranscriptionMessage.


        :return: The batch_interval_ms of this TranscriptionsTopicTranscriptionMessage.
        :rtype: int
        """
        return self._batch_interval_ms

    @batch_interval_ms.setter
    def batch_interval_ms(self, batch_interval_ms):
        """
        Sets the batch_interval_ms of this TranscriptionsTopicTranscriptionMessage.


        :param batch_interval_ms: The batch_interval_ms of this TranscriptionsTopicTranscriptionMessage.
        :type: int
        """
        
        self._batch_interval_ms = batch_interval_ms

    @property
    def organization_id(self):
        """
        Gets the organization_id of this TranscriptionsTopicTranscriptionMessage.


        :return: The organization_id of this TranscriptionsTopicTranscriptionMessage.
        :rtype: str
        """
        return self._organization_id

    @organization_id.setter
    def organization_id(self, organization_id):
        """
        Sets the organization_id of this TranscriptionsTopicTranscriptionMessage.


        :param organization_id: The organization_id of this TranscriptionsTopicTranscriptionMessage.
        :type: str
        """
        
        self._organization_id = organization_id

    @property
    def conversation_id(self):
        """
        Gets the conversation_id of this TranscriptionsTopicTranscriptionMessage.


        :return: The conversation_id of this TranscriptionsTopicTranscriptionMessage.
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id):
        """
        Sets the conversation_id of this TranscriptionsTopicTranscriptionMessage.


        :param conversation_id: The conversation_id of this TranscriptionsTopicTranscriptionMessage.
        :type: str
        """
        
        self._conversation_id = conversation_id

    @property
    def communication_id(self):
        """
        Gets the communication_id of this TranscriptionsTopicTranscriptionMessage.


        :return: The communication_id of this TranscriptionsTopicTranscriptionMessage.
        :rtype: str
        """
        return self._communication_id

    @communication_id.setter
    def communication_id(self, communication_id):
        """
        Sets the communication_id of this TranscriptionsTopicTranscriptionMessage.


        :param communication_id: The communication_id of this TranscriptionsTopicTranscriptionMessage.
        :type: str
        """
        
        self._communication_id = communication_id

    @property
    def session_id(self):
        """
        Gets the session_id of this TranscriptionsTopicTranscriptionMessage.


        :return: The session_id of this TranscriptionsTopicTranscriptionMessage.
        :rtype: str
        """
        return self._session_id

    @session_id.setter
    def session_id(self, session_id):
        """
        Sets the session_id of this TranscriptionsTopicTranscriptionMessage.


        :param session_id: The session_id of this TranscriptionsTopicTranscriptionMessage.
        :type: str
        """
        
        self._session_id = session_id

    @property
    def transcripts(self):
        """
        Gets the transcripts of this TranscriptionsTopicTranscriptionMessage.


        :return: The transcripts of this TranscriptionsTopicTranscriptionMessage.
        :rtype: list[TranscriptionsTopicTranscriptResult]
        """
        return self._transcripts

    @transcripts.setter
    def transcripts(self, transcripts):
        """
        Sets the transcripts of this TranscriptionsTopicTranscriptionMessage.


        :param transcripts: The transcripts of this TranscriptionsTopicTranscriptionMessage.
        :type: list[TranscriptionsTopicTranscriptResult]
        """
        
        self._transcripts = transcripts

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

