# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class TranscriptionsTopicTranscriptAlternative(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        TranscriptionsTopicTranscriptAlternative - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'confidence': 'float',
            'transcript': 'str',
            'words': 'list[TranscriptionsTopicTranscriptWord]'
        }

        self.attribute_map = {
            'confidence': 'confidence',
            'transcript': 'transcript',
            'words': 'words'
        }

        self._confidence = None
        self._transcript = None
        self._words = None

    @property
    def confidence(self):
        """
        Gets the confidence of this TranscriptionsTopicTranscriptAlternative.


        :return: The confidence of this TranscriptionsTopicTranscriptAlternative.
        :rtype: float
        """
        return self._confidence

    @confidence.setter
    def confidence(self, confidence):
        """
        Sets the confidence of this TranscriptionsTopicTranscriptAlternative.


        :param confidence: The confidence of this TranscriptionsTopicTranscriptAlternative.
        :type: float
        """
        
        self._confidence = confidence

    @property
    def transcript(self):
        """
        Gets the transcript of this TranscriptionsTopicTranscriptAlternative.


        :return: The transcript of this TranscriptionsTopicTranscriptAlternative.
        :rtype: str
        """
        return self._transcript

    @transcript.setter
    def transcript(self, transcript):
        """
        Sets the transcript of this TranscriptionsTopicTranscriptAlternative.


        :param transcript: The transcript of this TranscriptionsTopicTranscriptAlternative.
        :type: str
        """
        
        self._transcript = transcript

    @property
    def words(self):
        """
        Gets the words of this TranscriptionsTopicTranscriptAlternative.


        :return: The words of this TranscriptionsTopicTranscriptAlternative.
        :rtype: list[TranscriptionsTopicTranscriptWord]
        """
        return self._words

    @words.setter
    def words(self, words):
        """
        Sets the words of this TranscriptionsTopicTranscriptAlternative.


        :param words: The words of this TranscriptionsTopicTranscriptAlternative.
        :type: list[TranscriptionsTopicTranscriptWord]
        """
        
        self._words = words

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

