# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from pprint import pformat
from six import iteritems
import re
import json

from ..utils import sanitize_for_serialization

class DialerCampaignRuleConfigChangeCampaignRule(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self):
        """
        DialerCampaignRuleConfigChangeCampaignRule - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'version': 'int',
            'campaign_rule_entities': 'DialerCampaignRuleConfigChangeCampaignRuleEntities',
            'campaign_rule_conditions': 'list[DialerCampaignRuleConfigChangeCampaignRuleCondition]',
            'campaign_rule_actions': 'list[DialerCampaignRuleConfigChangeCampaignRuleAction]',
            'match_any_conditions': 'bool',
            'enabled': 'bool',
            'additional_properties': 'object'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'version': 'version',
            'campaign_rule_entities': 'campaignRuleEntities',
            'campaign_rule_conditions': 'campaignRuleConditions',
            'campaign_rule_actions': 'campaignRuleActions',
            'match_any_conditions': 'matchAnyConditions',
            'enabled': 'enabled',
            'additional_properties': 'additionalProperties'
        }

        self._id = None
        self._name = None
        self._date_created = None
        self._date_modified = None
        self._version = None
        self._campaign_rule_entities = None
        self._campaign_rule_conditions = None
        self._campaign_rule_actions = None
        self._match_any_conditions = None
        self._enabled = None
        self._additional_properties = None

    @property
    def id(self):
        """
        Gets the id of this DialerCampaignRuleConfigChangeCampaignRule.


        :return: The id of this DialerCampaignRuleConfigChangeCampaignRule.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this DialerCampaignRuleConfigChangeCampaignRule.


        :param id: The id of this DialerCampaignRuleConfigChangeCampaignRule.
        :type: str
        """
        
        self._id = id

    @property
    def name(self):
        """
        Gets the name of this DialerCampaignRuleConfigChangeCampaignRule.


        :return: The name of this DialerCampaignRuleConfigChangeCampaignRule.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this DialerCampaignRuleConfigChangeCampaignRule.


        :param name: The name of this DialerCampaignRuleConfigChangeCampaignRule.
        :type: str
        """
        
        self._name = name

    @property
    def date_created(self):
        """
        Gets the date_created of this DialerCampaignRuleConfigChangeCampaignRule.


        :return: The date_created of this DialerCampaignRuleConfigChangeCampaignRule.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created):
        """
        Sets the date_created of this DialerCampaignRuleConfigChangeCampaignRule.


        :param date_created: The date_created of this DialerCampaignRuleConfigChangeCampaignRule.
        :type: datetime
        """
        
        self._date_created = date_created

    @property
    def date_modified(self):
        """
        Gets the date_modified of this DialerCampaignRuleConfigChangeCampaignRule.


        :return: The date_modified of this DialerCampaignRuleConfigChangeCampaignRule.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified):
        """
        Sets the date_modified of this DialerCampaignRuleConfigChangeCampaignRule.


        :param date_modified: The date_modified of this DialerCampaignRuleConfigChangeCampaignRule.
        :type: datetime
        """
        
        self._date_modified = date_modified

    @property
    def version(self):
        """
        Gets the version of this DialerCampaignRuleConfigChangeCampaignRule.


        :return: The version of this DialerCampaignRuleConfigChangeCampaignRule.
        :rtype: int
        """
        return self._version

    @version.setter
    def version(self, version):
        """
        Sets the version of this DialerCampaignRuleConfigChangeCampaignRule.


        :param version: The version of this DialerCampaignRuleConfigChangeCampaignRule.
        :type: int
        """
        
        self._version = version

    @property
    def campaign_rule_entities(self):
        """
        Gets the campaign_rule_entities of this DialerCampaignRuleConfigChangeCampaignRule.


        :return: The campaign_rule_entities of this DialerCampaignRuleConfigChangeCampaignRule.
        :rtype: DialerCampaignRuleConfigChangeCampaignRuleEntities
        """
        return self._campaign_rule_entities

    @campaign_rule_entities.setter
    def campaign_rule_entities(self, campaign_rule_entities):
        """
        Sets the campaign_rule_entities of this DialerCampaignRuleConfigChangeCampaignRule.


        :param campaign_rule_entities: The campaign_rule_entities of this DialerCampaignRuleConfigChangeCampaignRule.
        :type: DialerCampaignRuleConfigChangeCampaignRuleEntities
        """
        
        self._campaign_rule_entities = campaign_rule_entities

    @property
    def campaign_rule_conditions(self):
        """
        Gets the campaign_rule_conditions of this DialerCampaignRuleConfigChangeCampaignRule.


        :return: The campaign_rule_conditions of this DialerCampaignRuleConfigChangeCampaignRule.
        :rtype: list[DialerCampaignRuleConfigChangeCampaignRuleCondition]
        """
        return self._campaign_rule_conditions

    @campaign_rule_conditions.setter
    def campaign_rule_conditions(self, campaign_rule_conditions):
        """
        Sets the campaign_rule_conditions of this DialerCampaignRuleConfigChangeCampaignRule.


        :param campaign_rule_conditions: The campaign_rule_conditions of this DialerCampaignRuleConfigChangeCampaignRule.
        :type: list[DialerCampaignRuleConfigChangeCampaignRuleCondition]
        """
        
        self._campaign_rule_conditions = campaign_rule_conditions

    @property
    def campaign_rule_actions(self):
        """
        Gets the campaign_rule_actions of this DialerCampaignRuleConfigChangeCampaignRule.


        :return: The campaign_rule_actions of this DialerCampaignRuleConfigChangeCampaignRule.
        :rtype: list[DialerCampaignRuleConfigChangeCampaignRuleAction]
        """
        return self._campaign_rule_actions

    @campaign_rule_actions.setter
    def campaign_rule_actions(self, campaign_rule_actions):
        """
        Sets the campaign_rule_actions of this DialerCampaignRuleConfigChangeCampaignRule.


        :param campaign_rule_actions: The campaign_rule_actions of this DialerCampaignRuleConfigChangeCampaignRule.
        :type: list[DialerCampaignRuleConfigChangeCampaignRuleAction]
        """
        
        self._campaign_rule_actions = campaign_rule_actions

    @property
    def match_any_conditions(self):
        """
        Gets the match_any_conditions of this DialerCampaignRuleConfigChangeCampaignRule.


        :return: The match_any_conditions of this DialerCampaignRuleConfigChangeCampaignRule.
        :rtype: bool
        """
        return self._match_any_conditions

    @match_any_conditions.setter
    def match_any_conditions(self, match_any_conditions):
        """
        Sets the match_any_conditions of this DialerCampaignRuleConfigChangeCampaignRule.


        :param match_any_conditions: The match_any_conditions of this DialerCampaignRuleConfigChangeCampaignRule.
        :type: bool
        """
        
        self._match_any_conditions = match_any_conditions

    @property
    def enabled(self):
        """
        Gets the enabled of this DialerCampaignRuleConfigChangeCampaignRule.


        :return: The enabled of this DialerCampaignRuleConfigChangeCampaignRule.
        :rtype: bool
        """
        return self._enabled

    @enabled.setter
    def enabled(self, enabled):
        """
        Sets the enabled of this DialerCampaignRuleConfigChangeCampaignRule.


        :param enabled: The enabled of this DialerCampaignRuleConfigChangeCampaignRule.
        :type: bool
        """
        
        self._enabled = enabled

    @property
    def additional_properties(self):
        """
        Gets the additional_properties of this DialerCampaignRuleConfigChangeCampaignRule.


        :return: The additional_properties of this DialerCampaignRuleConfigChangeCampaignRule.
        :rtype: object
        """
        return self._additional_properties

    @additional_properties.setter
    def additional_properties(self, additional_properties):
        """
        Sets the additional_properties of this DialerCampaignRuleConfigChangeCampaignRule.


        :param additional_properties: The additional_properties of this DialerCampaignRuleConfigChangeCampaignRule.
        :type: object
        """
        
        self._additional_properties = additional_properties

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

