# coding: utf-8

"""
ArchitectApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

# python 2 and python 3 compatibility library
from six import iteritems

from ..configuration import Configuration
from ..api_client import ApiClient


class ArchitectApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_architect_emergencygroup(self, emergency_group_id, **kwargs):
        """
        Deletes a emergency group by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_architect_emergencygroup(emergency_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str emergency_group_id: Emergency group ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['emergency_group_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_architect_emergencygroup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'emergency_group_id' is set
        if ('emergency_group_id' not in params) or (params['emergency_group_id'] is None):
            raise ValueError("Missing the required parameter `emergency_group_id` when calling `delete_architect_emergencygroup`")


        resource_path = '/api/v2/architect/emergencygroups/{emergencyGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'emergency_group_id' in params:
            path_params['emergencyGroupId'] = params['emergency_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_architect_ivr(self, ivr_id, **kwargs):
        """
        Delete an IVR Config.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_architect_ivr(ivr_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str ivr_id: IVR id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ivr_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_architect_ivr" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'ivr_id' is set
        if ('ivr_id' not in params) or (params['ivr_id'] is None):
            raise ValueError("Missing the required parameter `ivr_id` when calling `delete_architect_ivr`")


        resource_path = '/api/v2/architect/ivrs/{ivrId}'.replace('{format}', 'json')
        path_params = {}
        if 'ivr_id' in params:
            path_params['ivrId'] = params['ivr_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_architect_prompt(self, prompt_id, **kwargs):
        """
        Delete specified user prompt
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_architect_prompt(prompt_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param bool all_resources: Whether or not to delete all the prompt resources
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'all_resources']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_architect_prompt" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `delete_architect_prompt`")


        resource_path = '/api/v2/architect/prompts/{promptId}'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']

        query_params = {}
        if 'all_resources' in params:
            query_params['allResources'] = params['all_resources']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_architect_prompt_resource(self, prompt_id, language_code, **kwargs):
        """
        Delete specified user prompt resource
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_architect_prompt_resource(prompt_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param str language_code: Language (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'language_code']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_architect_prompt_resource" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `delete_architect_prompt_resource`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `delete_architect_prompt_resource`")


        resource_path = '/api/v2/architect/prompts/{promptId}/resources/{languageCode}'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_architect_prompt_resource_audio(self, prompt_id, language_code, **kwargs):
        """
        Delete specified user prompt resource audio
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_architect_prompt_resource_audio(prompt_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param str language_code: Language (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'language_code']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_architect_prompt_resource_audio" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `delete_architect_prompt_resource_audio`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `delete_architect_prompt_resource_audio`")


        resource_path = '/api/v2/architect/prompts/{promptId}/resources/{languageCode}/audio'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_architect_prompts(self, id, **kwargs):
        """
        Batch-delete a list of prompts
        Multiple IDs can be specified, in which case all specified prompts will be deleted.  Asynchronous.  Notification topic: v2.architect.prompts.{promptId}

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_architect_prompts(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] id: List of Prompt IDs (required)
        :return: Operation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_architect_prompts" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_architect_prompts`")


        resource_path = '/api/v2/architect/prompts'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'id' in params:
            query_params['id'] = params['id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Operation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_architect_schedule(self, schedule_id, **kwargs):
        """
        Delete a schedule by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_architect_schedule(schedule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schedule_id: Schedule ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schedule_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_architect_schedule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schedule_id' is set
        if ('schedule_id' not in params) or (params['schedule_id'] is None):
            raise ValueError("Missing the required parameter `schedule_id` when calling `delete_architect_schedule`")


        resource_path = '/api/v2/architect/schedules/{scheduleId}'.replace('{format}', 'json')
        path_params = {}
        if 'schedule_id' in params:
            path_params['scheduleId'] = params['schedule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_architect_schedulegroup(self, schedule_group_id, **kwargs):
        """
        Deletes a schedule group by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_architect_schedulegroup(schedule_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schedule_group_id: Schedule group ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schedule_group_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_architect_schedulegroup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schedule_group_id' is set
        if ('schedule_group_id' not in params) or (params['schedule_group_id'] is None):
            raise ValueError("Missing the required parameter `schedule_group_id` when calling `delete_architect_schedulegroup`")


        resource_path = '/api/v2/architect/schedulegroups/{scheduleGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'schedule_group_id' in params:
            path_params['scheduleGroupId'] = params['schedule_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_architect_systemprompt_resource(self, prompt_id, language_code, **kwargs):
        """
        Delete a system prompt resource override.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_architect_systemprompt_resource(prompt_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param str language_code: Language (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'language_code']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_architect_systemprompt_resource" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `delete_architect_systemprompt_resource`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `delete_architect_systemprompt_resource`")


        resource_path = '/api/v2/architect/systemprompts/{promptId}/resources/{languageCode}'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_flow(self, flow_id, **kwargs):
        """
        Delete flow
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_flow(flow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: Flow ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_flow" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `delete_flow`")


        resource_path = '/api/v2/flows/{flowId}'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_flows(self, id, **kwargs):
        """
        Batch-delete a list of flows
        Multiple IDs can be specified, in which case all specified flows will be deleted.  Asynchronous.  Notification topic: v2.flows.{flowId}

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_flows(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] id: List of Flow IDs (required)
        :return: Operation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_flows" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_flows`")


        resource_path = '/api/v2/flows'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'id' in params:
            query_params['id'] = params['id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Operation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_flows_datatable(self, datatable_id, **kwargs):
        """
        deletes a specific datatable by id
        Deletes an entire datatable (including the schema and data) with a given datatableId

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_flows_datatable(datatable_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param bool force: force delete, even if in use
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'force']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_flows_datatable" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `delete_flows_datatable`")


        resource_path = '/api/v2/flows/datatables/{datatableId}'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']

        query_params = {}
        if 'force' in params:
            query_params['force'] = params['force']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_flows_datatable_row(self, datatable_id, row_id, **kwargs):
        """
        Delete a row entry
        Deletes a row with a given rowId (the value of the key field).

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_flows_datatable_row(datatable_id, row_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param str row_id: the key for the row (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'row_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_flows_datatable_row" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `delete_flows_datatable_row`")
        # verify the required parameter 'row_id' is set
        if ('row_id' not in params) or (params['row_id'] is None):
            raise ValueError("Missing the required parameter `row_id` when calling `delete_flows_datatable_row`")


        resource_path = '/api/v2/flows/datatables/{datatableId}/rows/{rowId}'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']
        if 'row_id' in params:
            path_params['rowId'] = params['row_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_flows_milestone(self, milestone_id, **kwargs):
        """
        Delete a flow milestone.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_flows_milestone(milestone_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str milestone_id: flow milestone ID (required)
        :return: Empty
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['milestone_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_flows_milestone" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'milestone_id' is set
        if ('milestone_id' not in params) or (params['milestone_id'] is None):
            raise ValueError("Missing the required parameter `milestone_id` when calling `delete_flows_milestone`")


        resource_path = '/api/v2/flows/milestones/{milestoneId}'.replace('{format}', 'json')
        path_params = {}
        if 'milestone_id' in params:
            path_params['milestoneId'] = params['milestone_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Empty',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_dependencytracking(self, name, **kwargs):
        """
        Get Dependency Tracking objects that have a given display name
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_dependencytracking(name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Object name to search for (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :param list[str] object_type: Object type(s) to search for
        :param bool consumed_resources: Include resources each result item consumes
        :param bool consuming_resources: Include resources that consume each result item
        :param list[str] consumed_resource_type: Types of consumed resources to return, if consumed resources are requested
        :param list[str] consuming_resource_type: Types of consuming resources to return, if consuming resources are requested
        :return: DependencyObjectEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'page_number', 'page_size', 'object_type', 'consumed_resources', 'consuming_resources', 'consumed_resource_type', 'consuming_resource_type']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_dependencytracking" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'name' is set
        if ('name' not in params) or (params['name'] is None):
            raise ValueError("Missing the required parameter `name` when calling `get_architect_dependencytracking`")


        resource_path = '/api/v2/architect/dependencytracking'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'object_type' in params:
            query_params['objectType'] = params['object_type']
        if 'consumed_resources' in params:
            query_params['consumedResources'] = params['consumed_resources']
        if 'consuming_resources' in params:
            query_params['consumingResources'] = params['consuming_resources']
        if 'consumed_resource_type' in params:
            query_params['consumedResourceType'] = params['consumed_resource_type']
        if 'consuming_resource_type' in params:
            query_params['consumingResourceType'] = params['consuming_resource_type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DependencyObjectEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_dependencytracking_build(self, **kwargs):
        """
        Get Dependency Tracking build status for an organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_dependencytracking_build(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: DependencyStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_dependencytracking_build" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/dependencytracking/build'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DependencyStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_dependencytracking_consumedresources(self, id, version, object_type, **kwargs):
        """
        Get resources that are consumed by a given Dependency Tracking object
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_dependencytracking_consumedresources(id, version, object_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: Consuming object ID (required)
        :param str version: Consuming object version (required)
        :param str object_type: Consuming object type.  Only versioned types are allowed here. (required)
        :param list[str] resource_type: Types of consumed resources to show
        :param int page_number: Page number
        :param int page_size: Page size
        :return: ConsumedResourcesEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'version', 'object_type', 'resource_type', 'page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_dependencytracking_consumedresources" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_architect_dependencytracking_consumedresources`")
        # verify the required parameter 'version' is set
        if ('version' not in params) or (params['version'] is None):
            raise ValueError("Missing the required parameter `version` when calling `get_architect_dependencytracking_consumedresources`")
        # verify the required parameter 'object_type' is set
        if ('object_type' not in params) or (params['object_type'] is None):
            raise ValueError("Missing the required parameter `object_type` when calling `get_architect_dependencytracking_consumedresources`")


        resource_path = '/api/v2/architect/dependencytracking/consumedresources'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'id' in params:
            query_params['id'] = params['id']
        if 'version' in params:
            query_params['version'] = params['version']
        if 'object_type' in params:
            query_params['objectType'] = params['object_type']
        if 'resource_type' in params:
            query_params['resourceType'] = params['resource_type']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ConsumedResourcesEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_dependencytracking_consumingresources(self, id, object_type, **kwargs):
        """
        Get resources that consume a given Dependency Tracking object
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_dependencytracking_consumingresources(id, object_type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: Consumed object ID (required)
        :param str object_type: Consumed object type (required)
        :param list[str] resource_type: Types of consuming resources to show.  Only versioned types are allowed here.
        :param str version: Object version
        :param int page_number: Page number
        :param int page_size: Page size
        :param str flow_filter: Show only checkedIn or published flows
        :return: ConsumingResourcesEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'object_type', 'resource_type', 'version', 'page_number', 'page_size', 'flow_filter']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_dependencytracking_consumingresources" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_architect_dependencytracking_consumingresources`")
        # verify the required parameter 'object_type' is set
        if ('object_type' not in params) or (params['object_type'] is None):
            raise ValueError("Missing the required parameter `object_type` when calling `get_architect_dependencytracking_consumingresources`")


        resource_path = '/api/v2/architect/dependencytracking/consumingresources'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'id' in params:
            query_params['id'] = params['id']
        if 'object_type' in params:
            query_params['objectType'] = params['object_type']
        if 'resource_type' in params:
            query_params['resourceType'] = params['resource_type']
        if 'version' in params:
            query_params['version'] = params['version']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'flow_filter' in params:
            query_params['flowFilter'] = params['flow_filter']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ConsumingResourcesEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_dependencytracking_deletedresourceconsumers(self, **kwargs):
        """
        Get Dependency Tracking objects that consume deleted resources
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_dependencytracking_deletedresourceconsumers(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Name to search for
        :param list[str] object_type: Object type(s) to search for
        :param str flow_filter: Show only checkedIn or published flows
        :param bool consumed_resources: Return consumed resources?
        :param list[str] consumed_resource_type: Resource type(s) to return
        :param int page_number: Page number
        :param int page_size: Page size
        :return: DependencyObjectEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'object_type', 'flow_filter', 'consumed_resources', 'consumed_resource_type', 'page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_dependencytracking_deletedresourceconsumers" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/dependencytracking/deletedresourceconsumers'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'name' in params:
            query_params['name'] = params['name']
        if 'object_type' in params:
            query_params['objectType'] = params['object_type']
        if 'flow_filter' in params:
            query_params['flowFilter'] = params['flow_filter']
        if 'consumed_resources' in params:
            query_params['consumedResources'] = params['consumed_resources']
        if 'consumed_resource_type' in params:
            query_params['consumedResourceType'] = params['consumed_resource_type']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DependencyObjectEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_dependencytracking_object(self, id, **kwargs):
        """
        Get a Dependency Tracking object
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_dependencytracking_object(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str id: Object ID (required)
        :param str version: Object version
        :param str object_type: Object type
        :param bool consumed_resources: Include resources this item consumes
        :param bool consuming_resources: Include resources that consume this item
        :param list[str] consumed_resource_type: Types of consumed resources to return, if consumed resources are requested
        :param list[str] consuming_resource_type: Types of consuming resources to return, if consuming resources are requested
        :param bool consumed_resource_request: Indicate that this is going to look up a consumed resource object
        :return: DependencyObject
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'version', 'object_type', 'consumed_resources', 'consuming_resources', 'consumed_resource_type', 'consuming_resource_type', 'consumed_resource_request']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_dependencytracking_object" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `get_architect_dependencytracking_object`")


        resource_path = '/api/v2/architect/dependencytracking/object'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'id' in params:
            query_params['id'] = params['id']
        if 'version' in params:
            query_params['version'] = params['version']
        if 'object_type' in params:
            query_params['objectType'] = params['object_type']
        if 'consumed_resources' in params:
            query_params['consumedResources'] = params['consumed_resources']
        if 'consuming_resources' in params:
            query_params['consumingResources'] = params['consuming_resources']
        if 'consumed_resource_type' in params:
            query_params['consumedResourceType'] = params['consumed_resource_type']
        if 'consuming_resource_type' in params:
            query_params['consumingResourceType'] = params['consuming_resource_type']
        if 'consumed_resource_request' in params:
            query_params['consumedResourceRequest'] = params['consumed_resource_request']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DependencyObject',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_dependencytracking_type(self, type_id, **kwargs):
        """
        Get a Dependency Tracking type.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_dependencytracking_type(type_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str type_id: Type ID (required)
        :return: DependencyType
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_dependencytracking_type" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'type_id' is set
        if ('type_id' not in params) or (params['type_id'] is None):
            raise ValueError("Missing the required parameter `type_id` when calling `get_architect_dependencytracking_type`")


        resource_path = '/api/v2/architect/dependencytracking/types/{typeId}'.replace('{format}', 'json')
        path_params = {}
        if 'type_id' in params:
            path_params['typeId'] = params['type_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DependencyType',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_dependencytracking_types(self, **kwargs):
        """
        Get Dependency Tracking types.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_dependencytracking_types(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :return: DependencyTypeEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_dependencytracking_types" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/dependencytracking/types'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DependencyTypeEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_dependencytracking_updatedresourceconsumers(self, **kwargs):
        """
        Get Dependency Tracking objects that depend on updated resources
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_dependencytracking_updatedresourceconsumers(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Name to search for
        :param list[str] object_type: Object type(s) to search for
        :param bool consumed_resources: Return consumed resources?
        :param list[str] consumed_resource_type: Resource type(s) to return
        :param int page_number: Page number
        :param int page_size: Page size
        :return: DependencyObjectEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'object_type', 'consumed_resources', 'consumed_resource_type', 'page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_dependencytracking_updatedresourceconsumers" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/dependencytracking/updatedresourceconsumers'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'name' in params:
            query_params['name'] = params['name']
        if 'object_type' in params:
            query_params['objectType'] = params['object_type']
        if 'consumed_resources' in params:
            query_params['consumedResources'] = params['consumed_resources']
        if 'consumed_resource_type' in params:
            query_params['consumedResourceType'] = params['consumed_resource_type']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DependencyObjectEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_emergencygroup(self, emergency_group_id, **kwargs):
        """
        Gets a emergency group by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_emergencygroup(emergency_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str emergency_group_id: Emergency group ID (required)
        :return: EmergencyGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['emergency_group_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_emergencygroup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'emergency_group_id' is set
        if ('emergency_group_id' not in params) or (params['emergency_group_id'] is None):
            raise ValueError("Missing the required parameter `emergency_group_id` when calling `get_architect_emergencygroup`")


        resource_path = '/api/v2/architect/emergencygroups/{emergencyGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'emergency_group_id' in params:
            path_params['emergencyGroupId'] = params['emergency_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EmergencyGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_emergencygroups(self, **kwargs):
        """
        Get a list of emergency groups.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_emergencygroups(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param str name: Name of the Emergency Group to filter by.
        :return: EmergencyGroupListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_emergencygroups" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/emergencygroups'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'name' in params:
            query_params['name'] = params['name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EmergencyGroupListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_ivr(self, ivr_id, **kwargs):
        """
        Get an IVR config.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_ivr(ivr_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str ivr_id: IVR id (required)
        :return: IVR
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ivr_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_ivr" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'ivr_id' is set
        if ('ivr_id' not in params) or (params['ivr_id'] is None):
            raise ValueError("Missing the required parameter `ivr_id` when calling `get_architect_ivr`")


        resource_path = '/api/v2/architect/ivrs/{ivrId}'.replace('{format}', 'json')
        path_params = {}
        if 'ivr_id' in params:
            path_params['ivrId'] = params['ivr_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='IVR',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_ivrs(self, **kwargs):
        """
        Get IVR configs.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_ivrs(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param str name: Name of the IVR to filter by.
        :return: IVREntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_ivrs" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/ivrs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'name' in params:
            query_params['name'] = params['name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='IVREntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_prompt(self, prompt_id, **kwargs):
        """
        Get specified user prompt
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_prompt(prompt_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :return: Prompt
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_prompt" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `get_architect_prompt`")


        resource_path = '/api/v2/architect/prompts/{promptId}'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Prompt',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_prompt_history_history_id(self, prompt_id, history_id, **kwargs):
        """
        Get generated prompt history
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_prompt_history_history_id(prompt_id, history_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param str history_id: History request ID (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_order: Sort order
        :param str sort_by: Sort by
        :param list[str] action: Flow actions to include (omit to include all)
        :return: HistoryListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'history_id', 'page_number', 'page_size', 'sort_order', 'sort_by', 'action']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_prompt_history_history_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `get_architect_prompt_history_history_id`")
        # verify the required parameter 'history_id' is set
        if ('history_id' not in params) or (params['history_id'] is None):
            raise ValueError("Missing the required parameter `history_id` when calling `get_architect_prompt_history_history_id`")


        resource_path = '/api/v2/architect/prompts/{promptId}/history/{historyId}'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']
        if 'history_id' in params:
            path_params['historyId'] = params['history_id']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'action' in params:
            query_params['action'] = params['action']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='HistoryListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_prompt_resource(self, prompt_id, language_code, **kwargs):
        """
        Get specified user prompt resource
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_prompt_resource(prompt_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param str language_code: Language (required)
        :return: PromptAsset
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'language_code']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_prompt_resource" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `get_architect_prompt_resource`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `get_architect_prompt_resource`")


        resource_path = '/api/v2/architect/prompts/{promptId}/resources/{languageCode}'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PromptAsset',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_prompt_resources(self, prompt_id, **kwargs):
        """
        Get a pageable list of user prompt resources
        The returned list is pageable, and query parameters can be used for filtering.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_prompt_resources(prompt_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :return: PromptAssetEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_prompt_resources" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `get_architect_prompt_resources`")


        resource_path = '/api/v2/architect/prompts/{promptId}/resources'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PromptAssetEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_prompts(self, **kwargs):
        """
        Get a pageable list of user prompts
        The returned list is pageable, and query parameters can be used for filtering.  Multiple names can be specified, in which case all matching prompts will be returned, and no other filters will be evaluated.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_prompts(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param list[str] name: Name
        :param str description: Description
        :param str name_or_description: Name or description
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: PromptEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'name', 'description', 'name_or_description', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_prompts" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/prompts'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'description' in params:
            query_params['description'] = params['description']
        if 'name_or_description' in params:
            query_params['nameOrDescription'] = params['name_or_description']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PromptEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_schedule(self, schedule_id, **kwargs):
        """
        Get a schedule by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_schedule(schedule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schedule_id: Schedule ID (required)
        :return: Schedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schedule_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_schedule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schedule_id' is set
        if ('schedule_id' not in params) or (params['schedule_id'] is None):
            raise ValueError("Missing the required parameter `schedule_id` when calling `get_architect_schedule`")


        resource_path = '/api/v2/architect/schedules/{scheduleId}'.replace('{format}', 'json')
        path_params = {}
        if 'schedule_id' in params:
            path_params['scheduleId'] = params['schedule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Schedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_schedulegroup(self, schedule_group_id, **kwargs):
        """
        Gets a schedule group by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_schedulegroup(schedule_group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schedule_group_id: Schedule group ID (required)
        :return: ScheduleGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schedule_group_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_schedulegroup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schedule_group_id' is set
        if ('schedule_group_id' not in params) or (params['schedule_group_id'] is None):
            raise ValueError("Missing the required parameter `schedule_group_id` when calling `get_architect_schedulegroup`")


        resource_path = '/api/v2/architect/schedulegroups/{scheduleGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'schedule_group_id' in params:
            path_params['scheduleGroupId'] = params['schedule_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ScheduleGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_schedulegroups(self, **kwargs):
        """
        Get a list of schedule groups.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_schedulegroups(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param str name: Name of the Schedule Group to filter by.
        :param str schedule_ids: A comma-delimited list of Schedule IDs to filter by.
        :return: ScheduleGroupEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'name', 'schedule_ids']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_schedulegroups" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/schedulegroups'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'schedule_ids' in params:
            query_params['scheduleIds'] = params['schedule_ids']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ScheduleGroupEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_schedules(self, **kwargs):
        """
        Get a list of schedules.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_schedules(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param str name: Name of the Schedule to filter by.
        :return: ScheduleEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_schedules" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/schedules'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'name' in params:
            query_params['name'] = params['name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ScheduleEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_systemprompt(self, prompt_id, **kwargs):
        """
        Get a system prompt
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_systemprompt(prompt_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: promptId (required)
        :return: SystemPrompt
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_systemprompt" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `get_architect_systemprompt`")


        resource_path = '/api/v2/architect/systemprompts/{promptId}'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SystemPrompt',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_systemprompt_history_history_id(self, prompt_id, history_id, **kwargs):
        """
        Get generated prompt history
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_systemprompt_history_history_id(prompt_id, history_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: promptId (required)
        :param str history_id: History request ID (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_order: Sort order
        :param str sort_by: Sort by
        :param list[str] action: Flow actions to include (omit to include all)
        :return: HistoryListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'history_id', 'page_number', 'page_size', 'sort_order', 'sort_by', 'action']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_systemprompt_history_history_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `get_architect_systemprompt_history_history_id`")
        # verify the required parameter 'history_id' is set
        if ('history_id' not in params) or (params['history_id'] is None):
            raise ValueError("Missing the required parameter `history_id` when calling `get_architect_systemprompt_history_history_id`")


        resource_path = '/api/v2/architect/systemprompts/{promptId}/history/{historyId}'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']
        if 'history_id' in params:
            path_params['historyId'] = params['history_id']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'action' in params:
            query_params['action'] = params['action']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='HistoryListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_systemprompt_resource(self, prompt_id, language_code, **kwargs):
        """
        Get a system prompt resource.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_systemprompt_resource(prompt_id, language_code, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param str language_code: Language (required)
        :return: SystemPromptAsset
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'language_code']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_systemprompt_resource" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `get_architect_systemprompt_resource`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `get_architect_systemprompt_resource`")


        resource_path = '/api/v2/architect/systemprompts/{promptId}/resources/{languageCode}'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SystemPromptAsset',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_systemprompt_resources(self, prompt_id, **kwargs):
        """
        Get system prompt resources.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_systemprompt_resources(prompt_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: SystemPromptAssetEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'page_number', 'page_size', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_systemprompt_resources" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `get_architect_systemprompt_resources`")


        resource_path = '/api/v2/architect/systemprompts/{promptId}/resources'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SystemPromptAssetEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_architect_systemprompts(self, **kwargs):
        """
        Get System Prompts
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_architect_systemprompts(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param str name: Name
        :param str description: Description
        :param str name_or_description: Name or description
        :return: SystemPromptEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'name', 'description', 'name_or_description']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_architect_systemprompts" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/systemprompts'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'description' in params:
            query_params['description'] = params['description']
        if 'name_or_description' in params:
            query_params['nameOrDescription'] = params['name_or_description']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SystemPromptEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flow(self, flow_id, **kwargs):
        """
        Get flow
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow(flow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: Flow ID (required)
        :param bool deleted: Deleted flows
        :return: Flow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id', 'deleted']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flow" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `get_flow`")


        resource_path = '/api/v2/flows/{flowId}'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = {}
        if 'deleted' in params:
            query_params['deleted'] = params['deleted']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Flow',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flow_history_history_id(self, flow_id, history_id, **kwargs):
        """
        Get generated flow history
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow_history_history_id(flow_id, history_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: Flow ID (required)
        :param str history_id: History request ID (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_order: Sort order
        :param str sort_by: Sort by
        :param list[str] action: Flow actions to include (omit to include all)
        :return: HistoryListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id', 'history_id', 'page_number', 'page_size', 'sort_order', 'sort_by', 'action']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flow_history_history_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `get_flow_history_history_id`")
        # verify the required parameter 'history_id' is set
        if ('history_id' not in params) or (params['history_id'] is None):
            raise ValueError("Missing the required parameter `history_id` when calling `get_flow_history_history_id`")


        resource_path = '/api/v2/flows/{flowId}/history/{historyId}'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']
        if 'history_id' in params:
            path_params['historyId'] = params['history_id']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'action' in params:
            query_params['action'] = params['action']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='HistoryListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flow_latestconfiguration(self, flow_id, **kwargs):
        """
        Get the latest configuration for flow
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow_latestconfiguration(flow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: Flow ID (required)
        :param bool deleted: Deleted flows
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id', 'deleted']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flow_latestconfiguration" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `get_flow_latestconfiguration`")


        resource_path = '/api/v2/flows/{flowId}/latestconfiguration'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = {}
        if 'deleted' in params:
            query_params['deleted'] = params['deleted']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flow_version(self, flow_id, version_id, **kwargs):
        """
        Get flow version
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow_version(flow_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: Flow ID (required)
        :param str version_id: Version ID (required)
        :param str deleted: Deleted flows
        :return: FlowVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id', 'version_id', 'deleted']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flow_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `get_flow_version`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `get_flow_version`")


        resource_path = '/api/v2/flows/{flowId}/versions/{versionId}'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}
        if 'deleted' in params:
            query_params['deleted'] = params['deleted']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flow_version_configuration(self, flow_id, version_id, **kwargs):
        """
        Create flow version configuration
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow_version_configuration(flow_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: Flow ID (required)
        :param str version_id: Version ID (required)
        :param str deleted: Deleted flows
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id', 'version_id', 'deleted']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flow_version_configuration" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `get_flow_version_configuration`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `get_flow_version_configuration`")


        resource_path = '/api/v2/flows/{flowId}/versions/{versionId}/configuration'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}
        if 'deleted' in params:
            query_params['deleted'] = params['deleted']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flow_versions(self, flow_id, **kwargs):
        """
        Get flow version list
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flow_versions(flow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: Flow ID (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :param bool deleted: Include Deleted flows
        :return: FlowVersionEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id', 'page_number', 'page_size', 'deleted']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flow_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `get_flow_versions`")


        resource_path = '/api/v2/flows/{flowId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'deleted' in params:
            query_params['deleted'] = params['deleted']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowVersionEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows(self, **kwargs):
        """
        Get a pageable list of flows, filtered by query parameters
        If one or more IDs are specified, the search will fetch flows that match the given ID(s) and not use any additional supplied query parameters in the search.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] type: Type
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param list[str] id: ID
        :param str name: Name
        :param str description: Description
        :param str name_or_description: Name or description
        :param str publish_version_id: Publish version ID
        :param str editable_by: Editable by
        :param str locked_by: Locked by
        :param str locked_by_client_id: Locked by client ID
        :param str secure: Secure
        :param bool deleted: Include deleted
        :param bool include_schemas: Include variable schemas
        :param str published_after: Published after
        :param str published_before: Published before
        :param list[str] division_id: division ID(s)
        :return: FlowEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'page_number', 'page_size', 'sort_by', 'sort_order', 'id', 'name', 'description', 'name_or_description', 'publish_version_id', 'editable_by', 'locked_by', 'locked_by_client_id', 'secure', 'deleted', 'include_schemas', 'published_after', 'published_before', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'type' in params:
            query_params['type'] = params['type']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'description' in params:
            query_params['description'] = params['description']
        if 'name_or_description' in params:
            query_params['nameOrDescription'] = params['name_or_description']
        if 'publish_version_id' in params:
            query_params['publishVersionId'] = params['publish_version_id']
        if 'editable_by' in params:
            query_params['editableBy'] = params['editable_by']
        if 'locked_by' in params:
            query_params['lockedBy'] = params['locked_by']
        if 'locked_by_client_id' in params:
            query_params['lockedByClientId'] = params['locked_by_client_id']
        if 'secure' in params:
            query_params['secure'] = params['secure']
        if 'deleted' in params:
            query_params['deleted'] = params['deleted']
        if 'include_schemas' in params:
            query_params['includeSchemas'] = params['include_schemas']
        if 'published_after' in params:
            query_params['publishedAfter'] = params['published_after']
        if 'published_before' in params:
            query_params['publishedBefore'] = params['published_before']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_datatable(self, datatable_id, **kwargs):
        """
        Returns a specific datatable by id
        Given a datatableId returns the datatable object and schema associated with it.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_datatable(datatable_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param str expand: Expand instructions for the result
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_datatable" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `get_flows_datatable`")


        resource_path = '/api/v2/flows/datatables/{datatableId}'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataTable',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_datatable_export_job(self, datatable_id, export_job_id, **kwargs):
        """
        Returns the state information about an export job
        Returns the state information about an export job.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_datatable_export_job(datatable_id, export_job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param str export_job_id: id of export job (required)
        :return: DataTableExportJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'export_job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_datatable_export_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `get_flows_datatable_export_job`")
        # verify the required parameter 'export_job_id' is set
        if ('export_job_id' not in params) or (params['export_job_id'] is None):
            raise ValueError("Missing the required parameter `export_job_id` when calling `get_flows_datatable_export_job`")


        resource_path = '/api/v2/flows/datatables/{datatableId}/export/jobs/{exportJobId}'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']
        if 'export_job_id' in params:
            path_params['exportJobId'] = params['export_job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataTableExportJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_datatable_import_job(self, datatable_id, import_job_id, **kwargs):
        """
        Returns the state information about an import job
        Returns the state information about an import job.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_datatable_import_job(datatable_id, import_job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param str import_job_id: id of import job (required)
        :return: DataTableImportJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'import_job_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_datatable_import_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `get_flows_datatable_import_job`")
        # verify the required parameter 'import_job_id' is set
        if ('import_job_id' not in params) or (params['import_job_id'] is None):
            raise ValueError("Missing the required parameter `import_job_id` when calling `get_flows_datatable_import_job`")


        resource_path = '/api/v2/flows/datatables/{datatableId}/import/jobs/{importJobId}'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']
        if 'import_job_id' in params:
            path_params['importJobId'] = params['import_job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataTableImportJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_datatable_import_jobs(self, datatable_id, **kwargs):
        """
        Get all recent import jobs
        Get all recent import jobs

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_datatable_import_jobs(datatable_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :return: EntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_datatable_import_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `get_flows_datatable_import_jobs`")


        resource_path = '/api/v2/flows/datatables/{datatableId}/import/jobs'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_datatable_row(self, datatable_id, row_id, **kwargs):
        """
        Returns a specific row for the datatable
        Given a datatableId and a rowId (the value of the key field) this will return the full row contents for that rowId.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_datatable_row(datatable_id, row_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param str row_id: The key for the row (required)
        :param bool showbrief: if true returns just the key field for the row
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'row_id', 'showbrief']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_datatable_row" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `get_flows_datatable_row`")
        # verify the required parameter 'row_id' is set
        if ('row_id' not in params) or (params['row_id'] is None):
            raise ValueError("Missing the required parameter `row_id` when calling `get_flows_datatable_row`")


        resource_path = '/api/v2/flows/datatables/{datatableId}/rows/{rowId}'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']
        if 'row_id' in params:
            path_params['rowId'] = params['row_id']

        query_params = {}
        if 'showbrief' in params:
            query_params['showbrief'] = params['showbrief']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='dict(str, object)',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_datatable_rows(self, datatable_id, **kwargs):
        """
        Returns the rows for the datatable with the given id
        Returns all of the rows for the datatable with the given datatableId.  By default this will just be a truncated list returning the key for each row. Set showBrief to false to return all of the row contents.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_datatable_rows(datatable_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :param bool showbrief: If true returns just the key value of the row
        :return: DataTableRowEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'page_number', 'page_size', 'showbrief']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_datatable_rows" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `get_flows_datatable_rows`")


        resource_path = '/api/v2/flows/datatables/{datatableId}/rows'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'showbrief' in params:
            query_params['showbrief'] = params['showbrief']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataTableRowEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_datatables(self, **kwargs):
        """
        Retrieve a list of datatables for the org
        Returns a metadata list of the datatables associated with this org, including datatableId, name and description.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_datatables(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str expand: Expand instructions for the result
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param list[str] division_id: division ID(s)
        :return: DataTablesDomainEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['expand', 'page_number', 'page_size', 'sort_by', 'sort_order', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_datatables" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows/datatables'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataTablesDomainEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_divisionviews(self, **kwargs):
        """
        Get a pageable list of basic flow information objects filterable by query parameters.
        This returns a simplified version of /flow consisting of name and type. If one or more IDs are specified, the search will fetch flows that match the given ID(s) and not use any additional supplied query parameters in the search.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_divisionviews(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] type: Type
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param list[str] id: ID
        :param str name: Name
        :param str publish_version_id: Publish version ID
        :param str published_after: Published after
        :param str published_before: Published before
        :param list[str] division_id: division ID(s)
        :param bool include_schemas: Include variable schemas
        :return: FlowDivisionViewEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type', 'page_number', 'page_size', 'sort_by', 'sort_order', 'id', 'name', 'publish_version_id', 'published_after', 'published_before', 'division_id', 'include_schemas']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'type' in params:
            query_params['type'] = params['type']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'publish_version_id' in params:
            query_params['publishVersionId'] = params['publish_version_id']
        if 'published_after' in params:
            query_params['publishedAfter'] = params['published_after']
        if 'published_before' in params:
            query_params['publishedBefore'] = params['published_before']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']
        if 'include_schemas' in params:
            query_params['includeSchemas'] = params['include_schemas']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowDivisionViewEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_execution(self, flow_execution_id, **kwargs):
        """
        Get a flow execution's details. Flow execution details are available for several days after the flow is started.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_execution(flow_execution_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_execution_id: flow execution ID (required)
        :return: FlowRuntimeExecution
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_execution_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_execution" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_execution_id' is set
        if ('flow_execution_id' not in params) or (params['flow_execution_id'] is None):
            raise ValueError("Missing the required parameter `flow_execution_id` when calling `get_flows_execution`")


        resource_path = '/api/v2/flows/executions/{flowExecutionId}'.replace('{format}', 'json')
        path_params = {}
        if 'flow_execution_id' in params:
            path_params['flowExecutionId'] = params['flow_execution_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowRuntimeExecution',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_milestone(self, milestone_id, **kwargs):
        """
        Get a flow milestone
        Returns a specified flow milestone

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_milestone(milestone_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str milestone_id: flow milestone ID (required)
        :return: FlowMilestone
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['milestone_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_milestone" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'milestone_id' is set
        if ('milestone_id' not in params) or (params['milestone_id'] is None):
            raise ValueError("Missing the required parameter `milestone_id` when calling `get_flows_milestone`")


        resource_path = '/api/v2/flows/milestones/{milestoneId}'.replace('{format}', 'json')
        path_params = {}
        if 'milestone_id' in params:
            path_params['milestoneId'] = params['milestone_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowMilestone',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_milestones(self, **kwargs):
        """
        Get a pageable list of flow milestones, filtered by query parameters
        Multiple IDs can be specified, in which case all matching flow milestones will be returned, and no other parameters will be evaluated.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_milestones(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param list[str] id: ID
        :param str name: Name
        :param str description: Description
        :param str name_or_description: Name or description
        :param list[str] division_id: division ID(s)
        :return: FlowMilestoneListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'id', 'name', 'description', 'name_or_description', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_milestones" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows/milestones'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'description' in params:
            query_params['description'] = params['description']
        if 'name_or_description' in params:
            query_params['nameOrDescription'] = params['name_or_description']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowMilestoneListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_milestones_divisionviews(self, **kwargs):
        """
        Get a pageable list of basic flow milestone information objects filterable by query parameters.
        This returns flow milestones consisting of name and division. If one or more IDs are specified, the search will fetch flow milestones that match the given ID(s) and not use any additional supplied query parameters in the search.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_milestones_divisionviews(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param list[str] id: ID
        :param str name: Name
        :param list[str] division_id: division ID(s)
        :return: FlowMilestoneDivisionViewEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'id', 'name', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_milestones_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows/milestones/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowMilestoneDivisionViewEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_outcome(self, flow_outcome_id, **kwargs):
        """
        Get a flow outcome
        Returns a specified flow outcome

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_outcome(flow_outcome_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_outcome_id: flow outcome ID (required)
        :return: FlowOutcome
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_outcome_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_outcome" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_outcome_id' is set
        if ('flow_outcome_id' not in params) or (params['flow_outcome_id'] is None):
            raise ValueError("Missing the required parameter `flow_outcome_id` when calling `get_flows_outcome`")


        resource_path = '/api/v2/flows/outcomes/{flowOutcomeId}'.replace('{format}', 'json')
        path_params = {}
        if 'flow_outcome_id' in params:
            path_params['flowOutcomeId'] = params['flow_outcome_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowOutcome',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_outcomes(self, **kwargs):
        """
        Get a pageable list of flow outcomes, filtered by query parameters
        Multiple IDs can be specified, in which case all matching flow outcomes will be returned, and no other parameters will be evaluated.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_outcomes(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param list[str] id: ID
        :param str name: Name
        :param str description: Description
        :param str name_or_description: Name or description
        :param list[str] division_id: division ID(s)
        :return: FlowOutcomeListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'id', 'name', 'description', 'name_or_description', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_outcomes" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows/outcomes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'description' in params:
            query_params['description'] = params['description']
        if 'name_or_description' in params:
            query_params['nameOrDescription'] = params['name_or_description']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowOutcomeListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_flows_outcomes_divisionviews(self, **kwargs):
        """
        Get a pageable list of basic flow outcome information objects filterable by query parameters.
        This returns flow outcomes consisting of name and division. If one or more IDs are specified, the search will fetch flow outcomes that match the given ID(s) and not use any additional supplied query parameters in the search.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_flows_outcomes_divisionviews(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_number: Page number
        :param int page_size: Page size
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param list[str] id: ID
        :param str name: Name
        :param list[str] division_id: division ID(s)
        :return: FlowOutcomeDivisionViewEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_number', 'page_size', 'sort_by', 'sort_order', 'id', 'name', 'division_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_flows_outcomes_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows/outcomes/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowOutcomeDivisionViewEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_dependencytracking_build(self, **kwargs):
        """
        Rebuild Dependency Tracking data for an organization
        Asynchronous.  Notification topic: v2.architect.dependencytracking.build

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_dependencytracking_build(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_dependencytracking_build" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/architect/dependencytracking/build'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_emergencygroups(self, body, **kwargs):
        """
        Creates a new emergency group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_emergencygroups(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param EmergencyGroup body:  (required)
        :return: EmergencyGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_emergencygroups" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_architect_emergencygroups`")


        resource_path = '/api/v2/architect/emergencygroups'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EmergencyGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_ivrs(self, body, **kwargs):
        """
        Create IVR config.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_ivrs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param IVR body:  (required)
        :return: IVR
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_ivrs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_architect_ivrs`")


        resource_path = '/api/v2/architect/ivrs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='IVR',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_prompt_history(self, prompt_id, **kwargs):
        """
        Generate prompt history
        Asynchronous.  Notification topic: v2.architect.prompts.{promptId}

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_prompt_history(prompt_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :return: Operation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_prompt_history" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `post_architect_prompt_history`")


        resource_path = '/api/v2/architect/prompts/{promptId}/history'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Operation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_prompt_resources(self, prompt_id, body, **kwargs):
        """
        Create a new user prompt resource
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_prompt_resources(prompt_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param PromptAssetCreate body:  (required)
        :return: PromptAsset
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_prompt_resources" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `post_architect_prompt_resources`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_architect_prompt_resources`")


        resource_path = '/api/v2/architect/prompts/{promptId}/resources'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PromptAsset',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_prompts(self, body, **kwargs):
        """
        Create a new user prompt
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_prompts(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Prompt body:  (required)
        :return: Prompt
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_prompts" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_architect_prompts`")


        resource_path = '/api/v2/architect/prompts'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Prompt',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_schedulegroups(self, body, **kwargs):
        """
        Creates a new schedule group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_schedulegroups(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ScheduleGroup body:  (required)
        :return: ScheduleGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_schedulegroups" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_architect_schedulegroups`")


        resource_path = '/api/v2/architect/schedulegroups'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ScheduleGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_schedules(self, body, **kwargs):
        """
        Create a new schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_schedules(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Schedule body:  (required)
        :return: Schedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_schedules" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_architect_schedules`")


        resource_path = '/api/v2/architect/schedules'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Schedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_systemprompt_history(self, prompt_id, **kwargs):
        """
        Generate system prompt history
        Asynchronous.  Notification topic: v2.architect.systemprompts.{systemPromptId}

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_systemprompt_history(prompt_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: promptId (required)
        :return: Operation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_systemprompt_history" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `post_architect_systemprompt_history`")


        resource_path = '/api/v2/architect/systemprompts/{promptId}/history'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Operation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_architect_systemprompt_resources(self, prompt_id, body, **kwargs):
        """
        Create system prompt resource override.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_architect_systemprompt_resources(prompt_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param SystemPromptAsset body:  (required)
        :return: SystemPromptAsset
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_architect_systemprompt_resources" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `post_architect_systemprompt_resources`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_architect_systemprompt_resources`")


        resource_path = '/api/v2/architect/systemprompts/{promptId}/resources'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SystemPromptAsset',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flow_history(self, flow_id, **kwargs):
        """
        Generate flow history
        Asynchronous.  Notification topic: v2.flows.{flowId}

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flow_history(flow_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: Flow ID (required)
        :return: Operation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flow_history" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `post_flow_history`")


        resource_path = '/api/v2/flows/{flowId}/history'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Operation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flow_versions(self, flow_id, body, **kwargs):
        """
        Create flow version
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flow_versions(flow_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: Flow ID (required)
        :param object body:  (required)
        :return: FlowVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flow_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `post_flow_versions`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_flow_versions`")


        resource_path = '/api/v2/flows/{flowId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows(self, body, **kwargs):
        """
        Create flow
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Flow body:  (required)
        :param str language: Language
        :return: Flow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'language']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_flows`")


        resource_path = '/api/v2/flows'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'language' in params:
            query_params['language'] = params['language']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Flow',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_actions_checkin(self, flow, **kwargs):
        """
        Check-in flow
        Asynchronous.  Notification topic: v2.flows.{flowId}

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_actions_checkin(flow, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow: Flow ID (required)
        :return: Operation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_actions_checkin" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow' is set
        if ('flow' not in params) or (params['flow'] is None):
            raise ValueError("Missing the required parameter `flow` when calling `post_flows_actions_checkin`")


        resource_path = '/api/v2/flows/actions/checkin'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'flow' in params:
            query_params['flow'] = params['flow']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Operation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_actions_checkout(self, flow, **kwargs):
        """
        Check-out flow
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_actions_checkout(flow, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow: Flow ID (required)
        :return: Flow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_actions_checkout" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow' is set
        if ('flow' not in params) or (params['flow'] is None):
            raise ValueError("Missing the required parameter `flow` when calling `post_flows_actions_checkout`")


        resource_path = '/api/v2/flows/actions/checkout'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'flow' in params:
            query_params['flow'] = params['flow']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Flow',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_actions_deactivate(self, flow, **kwargs):
        """
        Deactivate flow
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_actions_deactivate(flow, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow: Flow ID (required)
        :return: Flow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_actions_deactivate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow' is set
        if ('flow' not in params) or (params['flow'] is None):
            raise ValueError("Missing the required parameter `flow` when calling `post_flows_actions_deactivate`")


        resource_path = '/api/v2/flows/actions/deactivate'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'flow' in params:
            query_params['flow'] = params['flow']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Flow',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_actions_publish(self, flow, **kwargs):
        """
        Publish flow
        Asynchronous.  Notification topic: v2.flows.{flowId}

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_actions_publish(flow, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow: Flow ID (required)
        :param str version: version
        :return: Operation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow', 'version']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_actions_publish" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow' is set
        if ('flow' not in params) or (params['flow'] is None):
            raise ValueError("Missing the required parameter `flow` when calling `post_flows_actions_publish`")


        resource_path = '/api/v2/flows/actions/publish'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'flow' in params:
            query_params['flow'] = params['flow']
        if 'version' in params:
            query_params['version'] = params['version']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Operation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_actions_revert(self, flow, **kwargs):
        """
        Revert flow
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_actions_revert(flow, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow: Flow ID (required)
        :return: Flow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_actions_revert" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow' is set
        if ('flow' not in params) or (params['flow'] is None):
            raise ValueError("Missing the required parameter `flow` when calling `post_flows_actions_revert`")


        resource_path = '/api/v2/flows/actions/revert'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'flow' in params:
            query_params['flow'] = params['flow']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Flow',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_actions_unlock(self, flow, **kwargs):
        """
        Unlock flow
        Allows for unlocking a flow in the case where there is no flow configuration available, and thus a check-in will not unlock the flow. The user must have Architect Admin permissions to perform this action.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_actions_unlock(flow, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow: Flow ID (required)
        :return: Flow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_actions_unlock" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow' is set
        if ('flow' not in params) or (params['flow'] is None):
            raise ValueError("Missing the required parameter `flow` when calling `post_flows_actions_unlock`")


        resource_path = '/api/v2/flows/actions/unlock'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'flow' in params:
            query_params['flow'] = params['flow']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Flow',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_datatable_export_jobs(self, datatable_id, **kwargs):
        """
        Begin an export process for exporting all rows from a datatable
        Create an export job for exporting rows. The caller can then poll for status of the export using the token returned in the response

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_datatable_export_jobs(datatable_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :return: DataTableExportJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_datatable_export_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `post_flows_datatable_export_jobs`")


        resource_path = '/api/v2/flows/datatables/{datatableId}/export/jobs'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataTableExportJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_datatable_import_jobs(self, datatable_id, body, **kwargs):
        """
        Begin an import process for importing rows into a datatable
        Create an import job for importing rows. The caller can then poll for status of the import using the token returned in the response

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_datatable_import_jobs(datatable_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param DataTableImportJob body: import job information (required)
        :return: DataTableImportJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_datatable_import_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `post_flows_datatable_import_jobs`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_flows_datatable_import_jobs`")


        resource_path = '/api/v2/flows/datatables/{datatableId}/import/jobs'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataTableImportJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_datatable_rows(self, datatable_id, data_table_row, **kwargs):
        """
        Create a new row entry for the datatable.
        Will add the passed in row entry to the datatable with the given datatableId after verifying it against the schema.  The DataTableRow should be a json-ized' stream of key -> value pairs {      \"Field1\": \"XYZZY\",      \"Field2\": false,      \"KEY\": \"27272\"  }

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_datatable_rows(datatable_id, data_table_row, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param object data_table_row:  (required)
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'data_table_row']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_datatable_rows" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `post_flows_datatable_rows`")
        # verify the required parameter 'data_table_row' is set
        if ('data_table_row' not in params) or (params['data_table_row'] is None):
            raise ValueError("Missing the required parameter `data_table_row` when calling `post_flows_datatable_rows`")


        resource_path = '/api/v2/flows/datatables/{datatableId}/rows'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'data_table_row' in params:
            body_params = params['data_table_row']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='dict(str, object)',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_datatables(self, body, **kwargs):
        """
        Create a new datatable with the specified json-schema definition
        This will create a new datatable with fields that match the property definitions in the JSON schema.  The schema's title field will be overridden by the name field in the DataTable object.  See also http://json-schema.org/

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_datatables(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DataTable body: datatable json-schema (required)
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_datatables" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_flows_datatables`")


        resource_path = '/api/v2/flows/datatables'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataTable',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_executions(self, flow_launch_request, **kwargs):
        """
        Launch an instance of a flow definition, for flow types that support it such as the 'workflow' type.
        The launch is asynchronous, it returns as soon as the flow starts. You can use the returned ID to query its status if you need.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_executions(flow_launch_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FlowExecutionLaunchRequest flow_launch_request:  (required)
        :return: FlowExecutionLaunchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_launch_request']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_executions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_launch_request' is set
        if ('flow_launch_request' not in params) or (params['flow_launch_request'] is None):
            raise ValueError("Missing the required parameter `flow_launch_request` when calling `post_flows_executions`")


        resource_path = '/api/v2/flows/executions'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'flow_launch_request' in params:
            body_params = params['flow_launch_request']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowExecutionLaunchResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_milestones(self, **kwargs):
        """
        Create a flow milestone
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_milestones(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FlowMilestone body: 
        :return: FlowMilestone
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_milestones" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows/milestones'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowMilestone',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_flows_outcomes(self, **kwargs):
        """
        Create a flow outcome
        Asynchronous.  Notification topic: v2.flows.outcomes.{flowOutcomeId}

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_flows_outcomes(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FlowOutcome body: 
        :return: FlowOutcome
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_flows_outcomes" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/flows/outcomes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowOutcome',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_architect_emergencygroup(self, emergency_group_id, body, **kwargs):
        """
        Updates a emergency group by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_architect_emergencygroup(emergency_group_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str emergency_group_id: Emergency group ID (required)
        :param EmergencyGroup body:  (required)
        :return: EmergencyGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['emergency_group_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_architect_emergencygroup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'emergency_group_id' is set
        if ('emergency_group_id' not in params) or (params['emergency_group_id'] is None):
            raise ValueError("Missing the required parameter `emergency_group_id` when calling `put_architect_emergencygroup`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_architect_emergencygroup`")


        resource_path = '/api/v2/architect/emergencygroups/{emergencyGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'emergency_group_id' in params:
            path_params['emergencyGroupId'] = params['emergency_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EmergencyGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_architect_ivr(self, ivr_id, body, **kwargs):
        """
        Update an IVR Config.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_architect_ivr(ivr_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str ivr_id: IVR id (required)
        :param IVR body:  (required)
        :return: IVR
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['ivr_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_architect_ivr" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'ivr_id' is set
        if ('ivr_id' not in params) or (params['ivr_id'] is None):
            raise ValueError("Missing the required parameter `ivr_id` when calling `put_architect_ivr`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_architect_ivr`")


        resource_path = '/api/v2/architect/ivrs/{ivrId}'.replace('{format}', 'json')
        path_params = {}
        if 'ivr_id' in params:
            path_params['ivrId'] = params['ivr_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='IVR',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_architect_prompt(self, prompt_id, body, **kwargs):
        """
        Update specified user prompt
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_architect_prompt(prompt_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param Prompt body:  (required)
        :return: Prompt
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_architect_prompt" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `put_architect_prompt`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_architect_prompt`")


        resource_path = '/api/v2/architect/prompts/{promptId}'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Prompt',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_architect_prompt_resource(self, prompt_id, language_code, body, **kwargs):
        """
        Update specified user prompt resource
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_architect_prompt_resource(prompt_id, language_code, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param str language_code: Language (required)
        :param PromptAsset body:  (required)
        :return: PromptAsset
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'language_code', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_architect_prompt_resource" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `put_architect_prompt_resource`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `put_architect_prompt_resource`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_architect_prompt_resource`")


        resource_path = '/api/v2/architect/prompts/{promptId}/resources/{languageCode}'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PromptAsset',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_architect_schedule(self, schedule_id, body, **kwargs):
        """
        Update schedule by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_architect_schedule(schedule_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schedule_id: Schedule ID (required)
        :param Schedule body:  (required)
        :return: Schedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schedule_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_architect_schedule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schedule_id' is set
        if ('schedule_id' not in params) or (params['schedule_id'] is None):
            raise ValueError("Missing the required parameter `schedule_id` when calling `put_architect_schedule`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_architect_schedule`")


        resource_path = '/api/v2/architect/schedules/{scheduleId}'.replace('{format}', 'json')
        path_params = {}
        if 'schedule_id' in params:
            path_params['scheduleId'] = params['schedule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Schedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_architect_schedulegroup(self, schedule_group_id, body, **kwargs):
        """
        Updates a schedule group by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_architect_schedulegroup(schedule_group_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schedule_group_id: Schedule group ID (required)
        :param ScheduleGroup body:  (required)
        :return: ScheduleGroup
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schedule_group_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_architect_schedulegroup" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schedule_group_id' is set
        if ('schedule_group_id' not in params) or (params['schedule_group_id'] is None):
            raise ValueError("Missing the required parameter `schedule_group_id` when calling `put_architect_schedulegroup`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_architect_schedulegroup`")


        resource_path = '/api/v2/architect/schedulegroups/{scheduleGroupId}'.replace('{format}', 'json')
        path_params = {}
        if 'schedule_group_id' in params:
            path_params['scheduleGroupId'] = params['schedule_group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ScheduleGroup',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_architect_systemprompt_resource(self, prompt_id, language_code, body, **kwargs):
        """
        Updates a system prompt resource override.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_architect_systemprompt_resource(prompt_id, language_code, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str prompt_id: Prompt ID (required)
        :param str language_code: Language (required)
        :param SystemPromptAsset body:  (required)
        :return: SystemPromptAsset
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['prompt_id', 'language_code', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_architect_systemprompt_resource" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'prompt_id' is set
        if ('prompt_id' not in params) or (params['prompt_id'] is None):
            raise ValueError("Missing the required parameter `prompt_id` when calling `put_architect_systemprompt_resource`")
        # verify the required parameter 'language_code' is set
        if ('language_code' not in params) or (params['language_code'] is None):
            raise ValueError("Missing the required parameter `language_code` when calling `put_architect_systemprompt_resource`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_architect_systemprompt_resource`")


        resource_path = '/api/v2/architect/systemprompts/{promptId}/resources/{languageCode}'.replace('{format}', 'json')
        path_params = {}
        if 'prompt_id' in params:
            path_params['promptId'] = params['prompt_id']
        if 'language_code' in params:
            path_params['languageCode'] = params['language_code']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SystemPromptAsset',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_flow(self, flow_id, body, **kwargs):
        """
        Update flow
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_flow(flow_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_id: Flow ID (required)
        :param Flow body:  (required)
        :return: Flow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_flow" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_id' is set
        if ('flow_id' not in params) or (params['flow_id'] is None):
            raise ValueError("Missing the required parameter `flow_id` when calling `put_flow`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_flow`")


        resource_path = '/api/v2/flows/{flowId}'.replace('{format}', 'json')
        path_params = {}
        if 'flow_id' in params:
            path_params['flowId'] = params['flow_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Flow',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_flows_datatable(self, datatable_id, **kwargs):
        """
        Updates a specific datatable by id
        Updates a schema for a datatable with the given datatableId -updates allow only new fields to be added in the schema, no changes or removals of existing fields.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_flows_datatable(datatable_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param str expand: Expand instructions for the result
        :param DataTable body: datatable json-schema
        :return: DataTable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'expand', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_flows_datatable" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `put_flows_datatable`")


        resource_path = '/api/v2/flows/datatables/{datatableId}'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']

        query_params = {}
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataTable',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_flows_datatable_row(self, datatable_id, row_id, **kwargs):
        """
        Update a row entry
        Updates a row with the given rowId (the value of the key field) to the new values.  The DataTableRow should be a json-ized' stream of key -> value pairs {     \"Field1\": \"XYZZY\",     \"Field2\": false,     \"KEY\": \"27272\" }

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_flows_datatable_row(datatable_id, row_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str datatable_id: id of datatable (required)
        :param str row_id: the key for the row (required)
        :param object body: datatable row
        :return: dict(str, object)
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['datatable_id', 'row_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_flows_datatable_row" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'datatable_id' is set
        if ('datatable_id' not in params) or (params['datatable_id'] is None):
            raise ValueError("Missing the required parameter `datatable_id` when calling `put_flows_datatable_row`")
        # verify the required parameter 'row_id' is set
        if ('row_id' not in params) or (params['row_id'] is None):
            raise ValueError("Missing the required parameter `row_id` when calling `put_flows_datatable_row`")


        resource_path = '/api/v2/flows/datatables/{datatableId}/rows/{rowId}'.replace('{format}', 'json')
        path_params = {}
        if 'datatable_id' in params:
            path_params['datatableId'] = params['datatable_id']
        if 'row_id' in params:
            path_params['rowId'] = params['row_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='dict(str, object)',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_flows_milestone(self, milestone_id, **kwargs):
        """
        Updates a flow milestone
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_flows_milestone(milestone_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str milestone_id: flow milestone ID (required)
        :param FlowMilestone body: 
        :return: FlowMilestone
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['milestone_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_flows_milestone" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'milestone_id' is set
        if ('milestone_id' not in params) or (params['milestone_id'] is None):
            raise ValueError("Missing the required parameter `milestone_id` when calling `put_flows_milestone`")


        resource_path = '/api/v2/flows/milestones/{milestoneId}'.replace('{format}', 'json')
        path_params = {}
        if 'milestone_id' in params:
            path_params['milestoneId'] = params['milestone_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FlowMilestone',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_flows_outcome(self, flow_outcome_id, **kwargs):
        """
        Updates a flow outcome
        Updates a flow outcome.  Asynchronous.  Notification topic: v2.flowoutcomes.{flowoutcomeId}

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_flows_outcome(flow_outcome_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str flow_outcome_id: flow outcome ID (required)
        :param FlowOutcome body: 
        :return: Operation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['flow_outcome_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_flows_outcome" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'flow_outcome_id' is set
        if ('flow_outcome_id' not in params) or (params['flow_outcome_id'] is None):
            raise ValueError("Missing the required parameter `flow_outcome_id` when calling `put_flows_outcome`")


        resource_path = '/api/v2/flows/outcomes/{flowOutcomeId}'.replace('{format}', 'json')
        path_params = {}
        if 'flow_outcome_id' in params:
            path_params['flowOutcomeId'] = params['flow_outcome_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Operation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
