# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class HeatmapReportRequest(Model):
    """HeatmapReportRequest.

    All required parameters must be populated in order to send to Azure.

    :param aggregate_level: Required. The level at which to aggregate the
     results. Possible values include: 'Indicator', 'MonitoringPoint', 'Asset'
    :type aggregate_level: str or ~smartdiagnostics_sdk.models.enum
    :param hours_per_bin: Required. The size (in hours) to use to split the
     given time range into parts
    :type hours_per_bin: int
    :param filter_id: The filter to use. Optional
    :type filter_id: str
    :param start_date: Required. The start date of the time range to get the
     report for. Nullable so Required can catch nulls, will not
     be null later.
    :type start_date: datetime
    :param end_date: Required. The end date of the time range to get the
     values for. Nullable so Required can catch nulls, will not
     be null later.
    :type end_date: datetime
    :param file_name: Required. The filename to use for the report
    :type file_name: str
    """

    _validation = {
        'aggregate_level': {'required': True},
        'hours_per_bin': {'required': True},
        'start_date': {'required': True},
        'end_date': {'required': True},
        'file_name': {'required': True},
    }

    _attribute_map = {
        'aggregate_level': {'key': 'AggregateLevel', 'type': 'str'},
        'hours_per_bin': {'key': 'HoursPerBin', 'type': 'int'},
        'filter_id': {'key': 'FilterId', 'type': 'str'},
        'start_date': {'key': 'StartDate', 'type': 'iso-8601'},
        'end_date': {'key': 'EndDate', 'type': 'iso-8601'},
        'file_name': {'key': 'FileName', 'type': 'str'},
    }

    def __init__(self, **kwargs):
        super(HeatmapReportRequest, self).__init__(**kwargs)
        self.aggregate_level = kwargs.get('aggregate_level', None)
        self.hours_per_bin = kwargs.get('hours_per_bin', None)
        self.filter_id = kwargs.get('filter_id', None)
        self.start_date = kwargs.get('start_date', None)
        self.end_date = kwargs.get('end_date', None)
        self.file_name = kwargs.get('file_name', None)
