# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ActivityResponse(Model):
    """ActivityResponse.

    All required parameters must be populated in order to send to Azure.

    :param id: Required.
    :type id: str
    :param location: Required.
    :type location: ~smartdiagnostics_sdk.models.LocationChild
    :param date_occurred: Required.
    :type date_occurred: datetime
    :param description: Required.
    :type description: str
    :param activity_category: Required. Possible values include: 'None',
     'OperationalCondition', 'Fault', 'RootCause', 'Evidence', 'Inspection',
     'PreventativeMaintenance', 'CorrectiveMaintenance', 'Observation',
     'Document', 'Description', 'SamplingFrequencyChange',
     'PendingSamplingFrequencyChange', 'AutoInvalidBurstData',
     'UserInvalidBurstData'
    :type activity_category: str or ~smartdiagnostics_sdk.models.enum
    :param group:
    :type group: ~smartdiagnostics_sdk.models.GroupChild
    :param indicator:
    :type indicator: ~smartdiagnostics_sdk.models.IndicatorChild
    :param activity_codes: Required.
    :type activity_codes: list[~smartdiagnostics_sdk.models.ActivityCodeChild]
    :param activity_document: Required.
    :type activity_document: ~smartdiagnostics_sdk.models.DocumentChild
    :param title: Required.
    :type title: str
    :param evidence_indicator:
    :type evidence_indicator: ~smartdiagnostics_sdk.models.IndicatorChild
    :param created: Required.
    :type created: datetime
    :param created_by: Required.
    :type created_by: str
    :param modified: Required.
    :type modified: datetime
    :param modified_by: Required.
    :type modified_by: str
    :param savings: Required.
    :type savings: float
    :param hierarchy: Required.
    :type hierarchy: list[~smartdiagnostics_sdk.models.HierarchyChild]
    """

    _validation = {
        'id': {'required': True},
        'location': {'required': True},
        'date_occurred': {'required': True},
        'description': {'required': True},
        'activity_category': {'required': True},
        'activity_codes': {'required': True},
        'activity_document': {'required': True},
        'title': {'required': True},
        'created': {'required': True},
        'created_by': {'required': True},
        'modified': {'required': True},
        'modified_by': {'required': True},
        'savings': {'required': True},
        'hierarchy': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'Id', 'type': 'str'},
        'location': {'key': 'Location', 'type': 'LocationChild'},
        'date_occurred': {'key': 'DateOccurred', 'type': 'iso-8601'},
        'description': {'key': 'Description', 'type': 'str'},
        'activity_category': {'key': 'ActivityCategory', 'type': 'str'},
        'group': {'key': 'Group', 'type': 'GroupChild'},
        'indicator': {'key': 'Indicator', 'type': 'IndicatorChild'},
        'activity_codes': {'key': 'ActivityCodes', 'type': '[ActivityCodeChild]'},
        'activity_document': {'key': 'ActivityDocument', 'type': 'DocumentChild'},
        'title': {'key': 'Title', 'type': 'str'},
        'evidence_indicator': {'key': 'EvidenceIndicator', 'type': 'IndicatorChild'},
        'created': {'key': 'Created', 'type': 'iso-8601'},
        'created_by': {'key': 'CreatedBy', 'type': 'str'},
        'modified': {'key': 'Modified', 'type': 'iso-8601'},
        'modified_by': {'key': 'ModifiedBy', 'type': 'str'},
        'savings': {'key': 'Savings', 'type': 'float'},
        'hierarchy': {'key': 'Hierarchy', 'type': '[HierarchyChild]'},
    }

    def __init__(self, **kwargs):
        super(ActivityResponse, self).__init__(**kwargs)
        self.id = kwargs.get('id', None)
        self.location = kwargs.get('location', None)
        self.date_occurred = kwargs.get('date_occurred', None)
        self.description = kwargs.get('description', None)
        self.activity_category = kwargs.get('activity_category', None)
        self.group = kwargs.get('group', None)
        self.indicator = kwargs.get('indicator', None)
        self.activity_codes = kwargs.get('activity_codes', None)
        self.activity_document = kwargs.get('activity_document', None)
        self.title = kwargs.get('title', None)
        self.evidence_indicator = kwargs.get('evidence_indicator', None)
        self.created = kwargs.get('created', None)
        self.created_by = kwargs.get('created_by', None)
        self.modified = kwargs.get('modified', None)
        self.modified_by = kwargs.get('modified_by', None)
        self.savings = kwargs.get('savings', None)
        self.hierarchy = kwargs.get('hierarchy', None)
