# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ActivityEventCreateRequest(Model):
    """ActivityEventCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param location_id: Required.
    :type location_id: str
    :param category_id:
    :type category_id: int
    :param category_code:
    :type category_code: str
    :param title: Required.
    :type title: str
    :param description:
    :type description: str
    :param start_date_time:
    :type start_date_time: datetime
    :param end_date_time:
    :type end_date_time: datetime
    :param subcategories:
    :type subcategories:
     list[~smartdiagnostics_sdk.models.ActivityEventSubcategoryEntryRequest]
    :param binds:
    :type binds: list[~smartdiagnostics_sdk.models.ActivityEventBindRequest]
    :param fields:
    :type fields:
     list[~smartdiagnostics_sdk.models.ActivityEventFieldEntryRequest]
    """

    _validation = {
        'location_id': {'required': True},
        'title': {'required': True, 'max_length': 50, 'min_length': 0},
        'description': {'max_length': 1000, 'min_length': 0},
    }

    _attribute_map = {
        'location_id': {'key': 'LocationId', 'type': 'str'},
        'category_id': {'key': 'CategoryId', 'type': 'int'},
        'category_code': {'key': 'CategoryCode', 'type': 'str'},
        'title': {'key': 'Title', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'start_date_time': {'key': 'StartDateTime', 'type': 'iso-8601'},
        'end_date_time': {'key': 'EndDateTime', 'type': 'iso-8601'},
        'subcategories': {'key': 'Subcategories', 'type': '[ActivityEventSubcategoryEntryRequest]'},
        'binds': {'key': 'Binds', 'type': '[ActivityEventBindRequest]'},
        'fields': {'key': 'Fields', 'type': '[ActivityEventFieldEntryRequest]'},
    }

    def __init__(self, **kwargs):
        super(ActivityEventCreateRequest, self).__init__(**kwargs)
        self.location_id = kwargs.get('location_id', None)
        self.category_id = kwargs.get('category_id', None)
        self.category_code = kwargs.get('category_code', None)
        self.title = kwargs.get('title', None)
        self.description = kwargs.get('description', None)
        self.start_date_time = kwargs.get('start_date_time', None)
        self.end_date_time = kwargs.get('end_date_time', None)
        self.subcategories = kwargs.get('subcategories', None)
        self.binds = kwargs.get('binds', None)
        self.fields = kwargs.get('fields', None)
