# coding=utf-8
# --------------------------------------------------------------------------
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is
# regenerated.
# --------------------------------------------------------------------------

from msrest.serialization import Model


class ActivityCreateRequest(Model):
    """ActivityCreateRequest.

    All required parameters must be populated in order to send to Azure.

    :param date_occurred: Required.
    :type date_occurred: datetime
    :param activity_category: Required. Possible values include: 'None',
     'OperationalCondition', 'Fault', 'RootCause', 'Evidence', 'Inspection',
     'PreventativeMaintenance', 'CorrectiveMaintenance', 'Observation',
     'Document', 'Description', 'SamplingFrequencyChange',
     'PendingSamplingFrequencyChange', 'AutoInvalidBurstData',
     'UserInvalidBurstData'
    :type activity_category: str or ~smartdiagnostics_sdk.models.enum
    :param title: Required.
    :type title: str
    :param description:
    :type description: str
    :param activity_document:
    :type activity_document: ~smartdiagnostics_sdk.models.DocumentChild
    :param group_id:
    :type group_id: str
    :param indicator_id:
    :type indicator_id: str
    :param activity_code_ids:
    :type activity_code_ids: list[str]
    :param evidence_indicator_id:
    :type evidence_indicator_id: str
    :param savings:
    :type savings: float
    """

    _validation = {
        'date_occurred': {'required': True},
        'activity_category': {'required': True},
        'title': {'required': True, 'max_length': 50, 'min_length': 0},
        'description': {'max_length': 1000, 'min_length': 0},
    }

    _attribute_map = {
        'date_occurred': {'key': 'DateOccurred', 'type': 'iso-8601'},
        'activity_category': {'key': 'ActivityCategory', 'type': 'str'},
        'title': {'key': 'Title', 'type': 'str'},
        'description': {'key': 'Description', 'type': 'str'},
        'activity_document': {'key': 'ActivityDocument', 'type': 'DocumentChild'},
        'group_id': {'key': 'GroupId', 'type': 'str'},
        'indicator_id': {'key': 'IndicatorId', 'type': 'str'},
        'activity_code_ids': {'key': 'ActivityCodeIds', 'type': '[str]'},
        'evidence_indicator_id': {'key': 'EvidenceIndicatorId', 'type': 'str'},
        'savings': {'key': 'Savings', 'type': 'float'},
    }

    def __init__(self, **kwargs):
        super(ActivityCreateRequest, self).__init__(**kwargs)
        self.date_occurred = kwargs.get('date_occurred', None)
        self.activity_category = kwargs.get('activity_category', None)
        self.title = kwargs.get('title', None)
        self.description = kwargs.get('description', None)
        self.activity_document = kwargs.get('activity_document', None)
        self.group_id = kwargs.get('group_id', None)
        self.indicator_id = kwargs.get('indicator_id', None)
        self.activity_code_ids = kwargs.get('activity_code_ids', None)
        self.evidence_indicator_id = kwargs.get('evidence_indicator_id', None)
        self.savings = kwargs.get('savings', None)
