# coding: utf-8

"""
    cloudFPGA Resource Manager API

    No description provided (generated by Swagger Codegen https://github.com/swagger-api/swagger-codegen)  # noqa: E501

    OpenAPI spec version: 0.8
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class AdministrationAdminOnlyApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def cf_manager_rest_api_admin_test_instance(self, body, username, password, instance_id, **kwargs):  # noqa: E501
        """Test the instance **if not used**  # noqa: E501

        This call helps admins to test a specific instance, **if this instance is not used by another user**. This is **intended only for single instances**, not to update one instance out of a cluster.  **If this call fails with `507`** and the FPGA worked without any problems before, then the submitted image probably doesn't work (i.e. `507` doesn't imply a failure of the FPGA board). This will also assign a new ip address to this instance.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_admin_test_instance(body, username, password, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TestInstanceInstanceIdBody body: (required)
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str instance_id: ROLE instance unique identifier (required)
        :param int dont_verify_memory: If 1, don't verify the DDR4 memory during setup
        :return: InlineResponse2001
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_admin_test_instance_with_http_info(body, username, password, instance_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_admin_test_instance_with_http_info(body, username, password, instance_id, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_admin_test_instance_with_http_info(self, body, username, password, instance_id, **kwargs):  # noqa: E501
        """Test the instance **if not used**  # noqa: E501

        This call helps admins to test a specific instance, **if this instance is not used by another user**. This is **intended only for single instances**, not to update one instance out of a cluster.  **If this call fails with `507`** and the FPGA worked without any problems before, then the submitted image probably doesn't work (i.e. `507` doesn't imply a failure of the FPGA board). This will also assign a new ip address to this instance.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_admin_test_instance_with_http_info(body, username, password, instance_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param TestInstanceInstanceIdBody body: (required)
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str instance_id: ROLE instance unique identifier (required)
        :param int dont_verify_memory: If 1, don't verify the DDR4 memory during setup
        :return: InlineResponse2001
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'username', 'password', 'instance_id', 'dont_verify_memory']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_admin_test_instance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'body' is set
        if ('body' not in params or
                params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `cf_manager_rest_api_admin_test_instance`")  # noqa: E501
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_admin_test_instance`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_admin_test_instance`")  # noqa: E501
        # verify the required parameter 'instance_id' is set
        if ('instance_id' not in params or
                params['instance_id'] is None):
            raise ValueError("Missing the required parameter `instance_id` when calling `cf_manager_rest_api_admin_test_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'instance_id' in params:
            path_params['instance_id'] = params['instance_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501
        if 'dont_verify_memory' in params:
            query_params.append(('dont_verify_memory', params['dont_verify_memory']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/administration/test_instance/{instance_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='InlineResponse2001',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_admin_update_flash(self, username, password, resource_id, pl_id, **kwargs):  # noqa: E501
        """Update the flash of a resource **if not used**  # noqa: E501

        This call allows admins to update the flash file of a resource, **if this instance is not used by another user**. If successful, the resource's shell_type is updated and the resource is marked as AVAILABLE.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_admin_update_flash(username, password, resource_id, pl_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str resource_id: cloudFPGA resource unique identifier (required)
        :param str pl_id: Platform logic unique identifier (required)
        :return: Resource
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_admin_update_flash_with_http_info(username, password, resource_id, pl_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_admin_update_flash_with_http_info(username, password, resource_id, pl_id, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_admin_update_flash_with_http_info(self, username, password, resource_id, pl_id, **kwargs):  # noqa: E501
        """Update the flash of a resource **if not used**  # noqa: E501

        This call allows admins to update the flash file of a resource, **if this instance is not used by another user**. If successful, the resource's shell_type is updated and the resource is marked as AVAILABLE.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_admin_update_flash_with_http_info(username, password, resource_id, pl_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str resource_id: cloudFPGA resource unique identifier (required)
        :param str pl_id: Platform logic unique identifier (required)
        :return: Resource
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'resource_id', 'pl_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_admin_update_flash" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_admin_update_flash`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_admin_update_flash`")  # noqa: E501
        # verify the required parameter 'resource_id' is set
        if ('resource_id' not in params or
                params['resource_id'] is None):
            raise ValueError("Missing the required parameter `resource_id` when calling `cf_manager_rest_api_admin_update_flash`")  # noqa: E501
        # verify the required parameter 'pl_id' is set
        if ('pl_id' not in params or
                params['pl_id'] is None):
            raise ValueError("Missing the required parameter `pl_id` when calling `cf_manager_rest_api_admin_update_flash`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'resource_id' in params:
            path_params['resource_id'] = params['resource_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501
        if 'pl_id' in params:
            query_params.append(('pl_id', params['pl_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/administration/update_flash/{resource_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Resource',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_delete_ippool(self, username, password, subnet_string, **kwargs):  # noqa: E501
        """Remove a /24 subnet  # noqa: E501

        Marks the submitted `/24` subnet as `DELETED`. *Note: this will not delete all ip addresses immediately*, `USED` ip addresses remains used until the corresponding `instance` is deleted. For now *only /24 subnets* are supported, so it is enough to submit the subnet base, *e.g. `10.12.200.0`*!   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_delete_ippool(username, password, subnet_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str subnet_string: A /24 subnet (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_delete_ippool_with_http_info(username, password, subnet_string, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_delete_ippool_with_http_info(username, password, subnet_string, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_delete_ippool_with_http_info(self, username, password, subnet_string, **kwargs):  # noqa: E501
        """Remove a /24 subnet  # noqa: E501

        Marks the submitted `/24` subnet as `DELETED`. *Note: this will not delete all ip addresses immediately*, `USED` ip addresses remains used until the corresponding `instance` is deleted. For now *only /24 subnets* are supported, so it is enough to submit the subnet base, *e.g. `10.12.200.0`*!   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_delete_ippool_with_http_info(username, password, subnet_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str subnet_string: A /24 subnet (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'subnet_string']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_delete_ippool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_delete_ippool`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_delete_ippool`")  # noqa: E501
        # verify the required parameter 'subnet_string' is set
        if ('subnet_string' not in params or
                params['subnet_string'] is None):
            raise ValueError("Missing the required parameter `subnet_string` when calling `cf_manager_rest_api_delete_ippool`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501
        if 'subnet_string' in params:
            query_params.append(('subnet_string', params['subnet_string']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/administration/ippool/', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_get_all_composable_logic(self, username, password, **kwargs):  # noqa: E501
        """Get list of all composable logic  # noqa: E501

        This API call also checks if DEPRECATED or DISCHARGED PLs are still programmed to some resources.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_all_composable_logic(username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_get_all_composable_logic_with_http_info(username, password, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_get_all_composable_logic_with_http_info(username, password, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_get_all_composable_logic_with_http_info(self, username, password, **kwargs):  # noqa: E501
        """Get list of all composable logic  # noqa: E501

        This API call also checks if DEPRECATED or DISCHARGED PLs are still programmed to some resources.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_all_composable_logic_with_http_info(username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_get_all_composable_logic" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_get_all_composable_logic`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_get_all_composable_logic`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/administration/composablelogic/all/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_get_buildscripts_all(self, username, password, **kwargs):  # noqa: E501
        """Get all registered build script versions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_buildscripts_all(username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :return: list[BuildScript]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_get_buildscripts_all_with_http_info(username, password, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_get_buildscripts_all_with_http_info(username, password, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_get_buildscripts_all_with_http_info(self, username, password, **kwargs):  # noqa: E501
        """Get all registered build script versions  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_buildscripts_all_with_http_info(username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :return: list[BuildScript]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_get_buildscripts_all" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_get_buildscripts_all`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_get_buildscripts_all`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/administration/buildscripts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[BuildScript]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_get_ippool(self, username, password, **kwargs):  # noqa: E501
        """Get all ip addresses in the current pool  # noqa: E501

        This call returns a list of *all* ip addresses that are currently known, regardless their state. That includes also ip addresses that are marked as `DELETED` but are still in use.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_ippool(username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :return: list[InlineResponse200]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_get_ippool_with_http_info(username, password, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_get_ippool_with_http_info(username, password, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_get_ippool_with_http_info(self, username, password, **kwargs):  # noqa: E501
        """Get all ip addresses in the current pool  # noqa: E501

        This call returns a list of *all* ip addresses that are currently known, regardless their state. That includes also ip addresses that are marked as `DELETED` but are still in use.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_ippool_with_http_info(username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :return: list[InlineResponse200]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_get_ippool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_get_ippool`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_get_ippool`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/administration/ippool/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[InlineResponse200]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_get_mantle_logic_all(self, username, password, **kwargs):  # noqa: E501
        """Get all mantle logics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_mantle_logic_all(username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_get_mantle_logic_all_with_http_info(username, password, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_get_mantle_logic_all_with_http_info(username, password, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_get_mantle_logic_all_with_http_info(self, username, password, **kwargs):  # noqa: E501
        """Get all mantle logics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_mantle_logic_all_with_http_info(username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_get_mantle_logic_all" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_get_mantle_logic_all`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_get_mantle_logic_all`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/administration/mantle_logic', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_get_platform_logic_all(self, username, password, **kwargs):  # noqa: E501
        """Get all platform logics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_platform_logic_all(username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_get_platform_logic_all_with_http_info(username, password, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_get_platform_logic_all_with_http_info(username, password, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_get_platform_logic_all_with_http_info(self, username, password, **kwargs):  # noqa: E501
        """Get all platform logics  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_platform_logic_all_with_http_info(username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_get_platform_logic_all" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_get_platform_logic_all`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_get_platform_logic_all`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/administration/platform_logic', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_get_single_buildscript(self, username, password, bs_id, **kwargs):  # noqa: E501
        """Get details of one registered build script  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_single_buildscript(username, password, bs_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int bs_id: ID of a registered build script (required)
        :return: BuildScript
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_get_single_buildscript_with_http_info(username, password, bs_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_get_single_buildscript_with_http_info(username, password, bs_id, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_get_single_buildscript_with_http_info(self, username, password, bs_id, **kwargs):  # noqa: E501
        """Get details of one registered build script  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_single_buildscript_with_http_info(username, password, bs_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int bs_id: ID of a registered build script (required)
        :return: BuildScript
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'bs_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_get_single_buildscript" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_get_single_buildscript`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_get_single_buildscript`")  # noqa: E501
        # verify the required parameter 'bs_id' is set
        if ('bs_id' not in params or
                params['bs_id'] is None):
            raise ValueError("Missing the required parameter `bs_id` when calling `cf_manager_rest_api_get_single_buildscript`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bs_id' in params:
            path_params['bs_id'] = params['bs_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/administration/buildscripts/{bs_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BuildScript',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_get_single_composable_logic(self, username, password, cl_id, **kwargs):  # noqa: E501
        """Get details of one composable logic  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_single_composable_logic(username, password, cl_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int cl_id: ID of a composable logic (Static Shell or Mantles) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_get_single_composable_logic_with_http_info(username, password, cl_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_get_single_composable_logic_with_http_info(username, password, cl_id, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_get_single_composable_logic_with_http_info(self, username, password, cl_id, **kwargs):  # noqa: E501
        """Get details of one composable logic  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_get_single_composable_logic_with_http_info(username, password, cl_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int cl_id: ID of a composable logic (Static Shell or Mantles) (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'cl_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_get_single_composable_logic" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_get_single_composable_logic`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_get_single_composable_logic`")  # noqa: E501
        # verify the required parameter 'cl_id' is set
        if ('cl_id' not in params or
                params['cl_id'] is None):
            raise ValueError("Missing the required parameter `cl_id` when calling `cf_manager_rest_api_get_single_composable_logic`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cl_id' in params:
            path_params['cl_id'] = params['cl_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/administration/composablelogic/{cl_id}/', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_post_buildscript(self, username, password, **kwargs):  # noqa: E501
        """Register a new build script version  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_post_buildscript(username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param BuildScript body:
        :return: BuildScript
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_post_buildscript_with_http_info(username, password, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_post_buildscript_with_http_info(username, password, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_post_buildscript_with_http_info(self, username, password, **kwargs):  # noqa: E501
        """Register a new build script version  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_post_buildscript_with_http_info(username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param BuildScript body:
        :return: BuildScript
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_post_buildscript" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_post_buildscript`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_post_buildscript`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/administration/buildscripts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BuildScript',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_post_ippool(self, username, password, subnet_string, gateway_string, mask_string, **kwargs):  # noqa: E501
        """Post a new `/24` ip pool (subnet)  # noqa: E501

        Introduces a new `/24` ip pool that is available for assignment to FPGAs.  For now, **only /24 subnets as ip pool** are supported, so it is enough to submit the subnet base, *e.g. `10.12.200.0`*!  The submitted *gateway*, e.g. `10.12.0.1`, will be used as gateway address for all FPGAs that get an ip address out of this subnet assigned. Multiple ip pools can have the same gateway. Subnetmasks, e.g. `255.255.0.0` are used in a similar way.  Hence, the subnetmask **can not** be derived from the subnet itself. Maybe it is possible that the FPGAs of a new subnet can also talk to other subnets, so the subnet mask must be submitted separately.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_post_ippool(username, password, subnet_string, gateway_string, mask_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str subnet_string: A /24 subnet (required)
        :param str gateway_string: The gateway for this subnet (required)
        :param str mask_string: The subnetmask for this subnet (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_post_ippool_with_http_info(username, password, subnet_string, gateway_string, mask_string, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_post_ippool_with_http_info(username, password, subnet_string, gateway_string, mask_string, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_post_ippool_with_http_info(self, username, password, subnet_string, gateway_string, mask_string, **kwargs):  # noqa: E501
        """Post a new `/24` ip pool (subnet)  # noqa: E501

        Introduces a new `/24` ip pool that is available for assignment to FPGAs.  For now, **only /24 subnets as ip pool** are supported, so it is enough to submit the subnet base, *e.g. `10.12.200.0`*!  The submitted *gateway*, e.g. `10.12.0.1`, will be used as gateway address for all FPGAs that get an ip address out of this subnet assigned. Multiple ip pools can have the same gateway. Subnetmasks, e.g. `255.255.0.0` are used in a similar way.  Hence, the subnetmask **can not** be derived from the subnet itself. Maybe it is possible that the FPGAs of a new subnet can also talk to other subnets, so the subnet mask must be submitted separately.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_post_ippool_with_http_info(username, password, subnet_string, gateway_string, mask_string, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param str subnet_string: A /24 subnet (required)
        :param str gateway_string: The gateway for this subnet (required)
        :param str mask_string: The subnetmask for this subnet (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'subnet_string', 'gateway_string', 'mask_string']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_post_ippool" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_post_ippool`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_post_ippool`")  # noqa: E501
        # verify the required parameter 'subnet_string' is set
        if ('subnet_string' not in params or
                params['subnet_string'] is None):
            raise ValueError("Missing the required parameter `subnet_string` when calling `cf_manager_rest_api_post_ippool`")  # noqa: E501
        # verify the required parameter 'gateway_string' is set
        if ('gateway_string' not in params or
                params['gateway_string'] is None):
            raise ValueError("Missing the required parameter `gateway_string` when calling `cf_manager_rest_api_post_ippool`")  # noqa: E501
        # verify the required parameter 'mask_string' is set
        if ('mask_string' not in params or
                params['mask_string'] is None):
            raise ValueError("Missing the required parameter `mask_string` when calling `cf_manager_rest_api_post_ippool`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501
        if 'subnet_string' in params:
            query_params.append(('subnet_string', params['subnet_string']))  # noqa: E501
        if 'gateway_string' in params:
            query_params.append(('gateway_string', params['gateway_string']))  # noqa: E501
        if 'mask_string' in params:
            query_params.append(('mask_string', params['mask_string']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/administration/ippool/', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_post_mantle_logic(self, image_details, bin_file, sig_file, pr_verify_rpt, username, password, **kwargs):  # noqa: E501
        """Upload a new dynamic platform logic  # noqa: E501

        This uploads an new Image for the DYNAMIC PLATFORM LOGIC (aka FPGA PR binfile). It **must** contain the corresponding .sig file that was produced by the build.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_post_mantle_logic(image_details, bin_file, sig_file, pr_verify_rpt, username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_details: (required)
        :param str bin_file: (required)
        :param str sig_file: (required)
        :param str pr_verify_rpt: (required)
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_post_mantle_logic_with_http_info(image_details, bin_file, sig_file, pr_verify_rpt, username, password, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_post_mantle_logic_with_http_info(image_details, bin_file, sig_file, pr_verify_rpt, username, password, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_post_mantle_logic_with_http_info(self, image_details, bin_file, sig_file, pr_verify_rpt, username, password, **kwargs):  # noqa: E501
        """Upload a new dynamic platform logic  # noqa: E501

        This uploads an new Image for the DYNAMIC PLATFORM LOGIC (aka FPGA PR binfile). It **must** contain the corresponding .sig file that was produced by the build.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_post_mantle_logic_with_http_info(image_details, bin_file, sig_file, pr_verify_rpt, username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_details: (required)
        :param str bin_file: (required)
        :param str sig_file: (required)
        :param str pr_verify_rpt: (required)
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image_details', 'bin_file', 'sig_file', 'pr_verify_rpt', 'username', 'password']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_post_mantle_logic" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'image_details' is set
        if ('image_details' not in params or
                params['image_details'] is None):
            raise ValueError("Missing the required parameter `image_details` when calling `cf_manager_rest_api_post_mantle_logic`")  # noqa: E501
        # verify the required parameter 'bin_file' is set
        if ('bin_file' not in params or
                params['bin_file'] is None):
            raise ValueError("Missing the required parameter `bin_file` when calling `cf_manager_rest_api_post_mantle_logic`")  # noqa: E501
        # verify the required parameter 'sig_file' is set
        if ('sig_file' not in params or
                params['sig_file'] is None):
            raise ValueError("Missing the required parameter `sig_file` when calling `cf_manager_rest_api_post_mantle_logic`")  # noqa: E501
        # verify the required parameter 'pr_verify_rpt' is set
        if ('pr_verify_rpt' not in params or
                params['pr_verify_rpt'] is None):
            raise ValueError("Missing the required parameter `pr_verify_rpt` when calling `cf_manager_rest_api_post_mantle_logic`")  # noqa: E501
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_post_mantle_logic`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_post_mantle_logic`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image_details' in params:
            form_params.append(('image_details', params['image_details']))  # noqa: E501
        if 'bin_file' in params:
            local_var_files['bin_file'] = params['bin_file']  # noqa: E501
        if 'sig_file' in params:
            local_var_files['sig_file'] = params['sig_file']  # noqa: E501
        if 'pr_verify_rpt' in params:
            local_var_files['pr_verify_rpt'] = params['pr_verify_rpt']  # noqa: E501

        body_params = None
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/administration/mantle_logic', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_post_platform_logic(self, image_details, dcp_file, bit_file, mcs_file, sig_file, pr_verify_rpt, username, password, **kwargs):  # noqa: E501
        """Upload a new platform logic  # noqa: E501

        This uploads an new Image for the STATIC PLATFORM LOGIC (aka FPGA bitfile and flash mcsfile) and the corresponding dcp, for app / mantle builds. It also **must** contain the corresponding admin.sig file that was produced by the build.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_post_platform_logic(image_details, dcp_file, bit_file, mcs_file, sig_file, pr_verify_rpt, username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_details: (required)
        :param str dcp_file: (required)
        :param str bit_file: (required)
        :param str mcs_file: (required)
        :param str sig_file: (required)
        :param str pr_verify_rpt: (required)
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_post_platform_logic_with_http_info(image_details, dcp_file, bit_file, mcs_file, sig_file, pr_verify_rpt, username, password, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_post_platform_logic_with_http_info(image_details, dcp_file, bit_file, mcs_file, sig_file, pr_verify_rpt, username, password, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_post_platform_logic_with_http_info(self, image_details, dcp_file, bit_file, mcs_file, sig_file, pr_verify_rpt, username, password, **kwargs):  # noqa: E501
        """Upload a new platform logic  # noqa: E501

        This uploads an new Image for the STATIC PLATFORM LOGIC (aka FPGA bitfile and flash mcsfile) and the corresponding dcp, for app / mantle builds. It also **must** contain the corresponding admin.sig file that was produced by the build.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_post_platform_logic_with_http_info(image_details, dcp_file, bit_file, mcs_file, sig_file, pr_verify_rpt, username, password, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str image_details: (required)
        :param str dcp_file: (required)
        :param str bit_file: (required)
        :param str mcs_file: (required)
        :param str sig_file: (required)
        :param str pr_verify_rpt: (required)
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['image_details', 'dcp_file', 'bit_file', 'mcs_file', 'sig_file', 'pr_verify_rpt', 'username', 'password']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_post_platform_logic" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'image_details' is set
        if ('image_details' not in params or
                params['image_details'] is None):
            raise ValueError("Missing the required parameter `image_details` when calling `cf_manager_rest_api_post_platform_logic`")  # noqa: E501
        # verify the required parameter 'dcp_file' is set
        if ('dcp_file' not in params or
                params['dcp_file'] is None):
            raise ValueError("Missing the required parameter `dcp_file` when calling `cf_manager_rest_api_post_platform_logic`")  # noqa: E501
        # verify the required parameter 'bit_file' is set
        if ('bit_file' not in params or
                params['bit_file'] is None):
            raise ValueError("Missing the required parameter `bit_file` when calling `cf_manager_rest_api_post_platform_logic`")  # noqa: E501
        # verify the required parameter 'mcs_file' is set
        if ('mcs_file' not in params or
                params['mcs_file'] is None):
            raise ValueError("Missing the required parameter `mcs_file` when calling `cf_manager_rest_api_post_platform_logic`")  # noqa: E501
        # verify the required parameter 'sig_file' is set
        if ('sig_file' not in params or
                params['sig_file'] is None):
            raise ValueError("Missing the required parameter `sig_file` when calling `cf_manager_rest_api_post_platform_logic`")  # noqa: E501
        # verify the required parameter 'pr_verify_rpt' is set
        if ('pr_verify_rpt' not in params or
                params['pr_verify_rpt'] is None):
            raise ValueError("Missing the required parameter `pr_verify_rpt` when calling `cf_manager_rest_api_post_platform_logic`")  # noqa: E501
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_post_platform_logic`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_post_platform_logic`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'image_details' in params:
            form_params.append(('image_details', params['image_details']))  # noqa: E501
        if 'dcp_file' in params:
            local_var_files['dcp_file'] = params['dcp_file']  # noqa: E501
        if 'bit_file' in params:
            local_var_files['bit_file'] = params['bit_file']  # noqa: E501
        if 'mcs_file' in params:
            local_var_files['mcs_file'] = params['mcs_file']  # noqa: E501
        if 'sig_file' in params:
            local_var_files['sig_file'] = params['sig_file']  # noqa: E501
        if 'pr_verify_rpt' in params:
            local_var_files['pr_verify_rpt'] = params['pr_verify_rpt']  # noqa: E501

        body_params = None
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/administration/platform_logic', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_put_buildscript(self, username, password, bs_id, **kwargs):  # noqa: E501
        """Update a registered build script  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_put_buildscript(username, password, bs_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int bs_id: ID of a registered build script (required)
        :param BuildScript body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_put_buildscript_with_http_info(username, password, bs_id, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_put_buildscript_with_http_info(username, password, bs_id, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_put_buildscript_with_http_info(self, username, password, bs_id, **kwargs):  # noqa: E501
        """Update a registered build script  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_put_buildscript_with_http_info(username, password, bs_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int bs_id: ID of a registered build script (required)
        :param BuildScript body:
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'bs_id', 'body']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_put_buildscript" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_put_buildscript`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_put_buildscript`")  # noqa: E501
        # verify the required parameter 'bs_id' is set
        if ('bs_id' not in params or
                params['bs_id'] is None):
            raise ValueError("Missing the required parameter `bs_id` when calling `cf_manager_rest_api_put_buildscript`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'bs_id' in params:
            path_params['bs_id'] = params['bs_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/administration/buildscripts/{bs_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def cf_manager_rest_api_put_composable_logic_status(self, username, password, cl_id, new_status, **kwargs):  # noqa: E501
        """Update status of a composable logic  # noqa: E501

        This call changes the status of a composable logic, to reflect the CL lifecycle (see doc).  If the status is changed to DEPRECATED or DISCHARGED, all resources are checked if some still use this CL. If yes, a warning is issued and the list of affected resources returned (response 202).  Currently, *only* the status can be changed, since all the other properties of a CL are considered static and if they should be changed, it is better to upload a new CL.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_put_composable_logic_status(username, password, cl_id, new_status, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int cl_id: ID of a composable logic (Static Shell or Mantles) (required)
        :param str new_status: New status of the composable logic (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.cf_manager_rest_api_put_composable_logic_status_with_http_info(username, password, cl_id, new_status, **kwargs)  # noqa: E501
        else:
            (data) = self.cf_manager_rest_api_put_composable_logic_status_with_http_info(username, password, cl_id, new_status, **kwargs)  # noqa: E501
            return data

    def cf_manager_rest_api_put_composable_logic_status_with_http_info(self, username, password, cl_id, new_status, **kwargs):  # noqa: E501
        """Update status of a composable logic  # noqa: E501

        This call changes the status of a composable logic, to reflect the CL lifecycle (see doc).  If the status is changed to DEPRECATED or DISCHARGED, all resources are checked if some still use this CL. If yes, a warning is issued and the list of affected resources returned (response 202).  Currently, *only* the status can be changed, since all the other properties of a CL are considered static and if they should be changed, it is better to upload a new CL.   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.cf_manager_rest_api_put_composable_logic_status_with_http_info(username, password, cl_id, new_status, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str username: OpenStack username (required)
        :param str password: OpenStack password (required)
        :param int cl_id: ID of a composable logic (Static Shell or Mantles) (required)
        :param str new_status: New status of the composable logic (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['username', 'password', 'cl_id', 'new_status']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method cf_manager_rest_api_put_composable_logic_status" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'username' is set
        if ('username' not in params or
                params['username'] is None):
            raise ValueError("Missing the required parameter `username` when calling `cf_manager_rest_api_put_composable_logic_status`")  # noqa: E501
        # verify the required parameter 'password' is set
        if ('password' not in params or
                params['password'] is None):
            raise ValueError("Missing the required parameter `password` when calling `cf_manager_rest_api_put_composable_logic_status`")  # noqa: E501
        # verify the required parameter 'cl_id' is set
        if ('cl_id' not in params or
                params['cl_id'] is None):
            raise ValueError("Missing the required parameter `cl_id` when calling `cf_manager_rest_api_put_composable_logic_status`")  # noqa: E501
        # verify the required parameter 'new_status' is set
        if ('new_status' not in params or
                params['new_status'] is None):
            raise ValueError("Missing the required parameter `new_status` when calling `cf_manager_rest_api_put_composable_logic_status`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'cl_id' in params:
            path_params['cl_id'] = params['cl_id']  # noqa: E501

        query_params = []
        if 'username' in params:
            query_params.append(('username', params['username']))  # noqa: E501
        if 'password' in params:
            query_params.append(('password', params['password']))  # noqa: E501
        if 'new_status' in params:
            query_params.append(('new_status', params['new_status']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/administration/composablelogic/{cl_id}/status/', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
