/**
 * All known Lambda runtime families.
 */
export declare enum RuntimeFamily {
    /**
     * All Lambda runtimes that depend on Node.js.
     */
    NODEJS = 0,
    /**
     * All lambda runtimes that depend on Python.
     */
    PYTHON = 1,
    /**
     * Any future runtime family.
     */
    OTHER = 2
}
/**
 * Runtime options for a canary
 */
export declare class Runtime {
    readonly name: string;
    readonly family: RuntimeFamily;
    /**
     * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
     *
     * `syn-1.0` includes the following:
     *
     * - Synthetics library 1.0
     * - Synthetics handler code 1.0
     * - Lambda runtime Node.js 10.x
     * - Puppeteer-core version 1.14.0
     * - The Chromium version that matches Puppeteer-core 1.14.0
     *
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-1.0
     */
    static readonly SYNTHETICS_1_0: Runtime;
    /**
     * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
     *
     * `syn-nodejs-2.0` includes the following:
     * - Lambda runtime Node.js 10.x
     * - Puppeteer-core version 3.3.0
     * - Chromium version 83.0.4103.0
     *
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.0
     */
    static readonly SYNTHETICS_NODEJS_2_0: Runtime;
    /**
     * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
     *
     * `syn-nodejs-2.1` includes the following:
     * - Lambda runtime Node.js 10.x
     * - Puppeteer-core version 3.3.0
     * - Chromium version 83.0.4103.0
     *
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.1
     */
    static readonly SYNTHETICS_NODEJS_2_1: Runtime;
    /**
     * **Deprecated by AWS Synthetics. You can't create canaries with deprecated runtimes.**
     *
     * `syn-nodejs-2.2` includes the following:
     * - Lambda runtime Node.js 10.x
     * - Puppeteer-core version 3.3.0
     * - Chromium version 83.0.4103.0
     *
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-2.2
     */
    static readonly SYNTHETICS_NODEJS_2_2: Runtime;
    /**
     * `syn-nodejs-puppeteer-3.0` includes the following:
     * - Lambda runtime Node.js 12.x
     * - Puppeteer-core version 5.5.0
     * - Chromium version 88.0.4298.0
     *
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.0
     */
    static readonly SYNTHETICS_NODEJS_PUPPETEER_3_0: Runtime;
    /**
     * `syn-nodejs-puppeteer-3.1` includes the following:
     * - Lambda runtime Node.js 12.x
     * - Puppeteer-core version 5.5.0
     * - Chromium version 88.0.4298.0
     *
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.1
     */
    static readonly SYNTHETICS_NODEJS_PUPPETEER_3_1: Runtime;
    /**
     * `syn-nodejs-puppeteer-3.2` includes the following:
     * - Lambda runtime Node.js 12.x
     * - Puppeteer-core version 5.5.0
     * - Chromium version 88.0.4298.0
     *
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.2
     */
    static readonly SYNTHETICS_NODEJS_PUPPETEER_3_2: Runtime;
    /**
     * `syn-nodejs-puppeteer-3.3` includes the following:
     * - Lambda runtime Node.js 12.x
     * - Puppeteer-core version 5.5.0
     * - Chromium version 88.0.4298.0
     *
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.3
     */
    static readonly SYNTHETICS_NODEJS_PUPPETEER_3_3: Runtime;
    /**
     * `syn-nodejs-puppeteer-3.4` includes the following:
     * - Lambda runtime Node.js 12.x
     * - Puppeteer-core version 5.5.0
     * - Chromium version 88.0.4298.0
     *
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.4
     */
    static readonly SYNTHETICS_NODEJS_PUPPETEER_3_4: Runtime;
    /**
     * `syn-nodejs-puppeteer-3.5` includes the following:
     * - Lambda runtime Node.js 14.x
     * - Puppeteer-core version 10.1.0
     * - Chromium version 92.0.4512
     *
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_nodejs_puppeteer.html#CloudWatch_Synthetics_runtimeversion-nodejs-puppeteer-3.5
     */
    static readonly SYNTHETICS_NODEJS_PUPPETEER_3_5: Runtime;
    /**
     * `syn-python-selenium-1.0` includes the following:
     * - Lambda runtime Python 3.8
     * - Selenium version 3.141.0
     * - Chromium version 83.0.4103.0
     *
     * @see https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Library_python_selenium.html
     */
    static readonly SYNTHETICS_PYTHON_SELENIUM_1_0: Runtime;
    /**
      * @param name The name of the runtime version
      * @param family The Lambda runtime family
      */
    constructor(name: string, family: RuntimeFamily);
}
