# coding=utf-8
# *** WARNING: this file was generated by Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['AWSInstanceArgs', 'AWSInstance']

@pulumi.input_type
class AWSInstanceArgs:
    def __init__(__self__, *,
                 image: pulumi.Input[str],
                 port: pulumi.Input[int]):
        """
        The set of arguments for constructing a AWSInstance resource.
        :param pulumi.Input[str] image: The image you want to run
        """
        pulumi.set(__self__, "image", image)
        pulumi.set(__self__, "port", port)

    @property
    @pulumi.getter
    def image(self) -> pulumi.Input[str]:
        """
        The image you want to run
        """
        return pulumi.get(self, "image")

    @image.setter
    def image(self, value: pulumi.Input[str]):
        pulumi.set(self, "image", value)

    @property
    @pulumi.getter
    def port(self) -> pulumi.Input[int]:
        return pulumi.get(self, "port")

    @port.setter
    def port(self, value: pulumi.Input[int]):
        pulumi.set(self, "port", value)


class AWSInstance(pulumi.ComponentResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        Create a AWSInstance resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] image: The image you want to run
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AWSInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Create a AWSInstance resource with the given unique name, props, and options.
        :param str resource_name: The name of the resource.
        :param AWSInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AWSInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 image: Optional[pulumi.Input[str]] = None,
                 port: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is not None:
            raise ValueError('ComponentResource classes do not support opts.id')
        else:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AWSInstanceArgs.__new__(AWSInstanceArgs)

            if image is None and not opts.urn:
                raise TypeError("Missing required property 'image'")
            __props__.__dict__["image"] = image
            if port is None and not opts.urn:
                raise TypeError("Missing required property 'port'")
            __props__.__dict__["port"] = port
            __props__.__dict__["url"] = None
        super(AWSInstance, __self__).__init__(
            'rdc:index:AWSInstance',
            resource_name,
            __props__,
            opts,
            remote=True)

    @property
    @pulumi.getter
    def url(self) -> pulumi.Output[str]:
        """
        url of your running container
        """
        return pulumi.get(self, "url")

