# Generated by Django 3.1.14 on 2022-03-30 15:04

from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('ipam', '0005_auto_slug'),
        ('dcim', '0007_device_secrets_group'),
    ]

    operations = [
        migrations.CreateModel(
            name='EthernetSegment',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('segment_id', models.IntegerField(unique=True)),
                ('name', models.CharField(max_length=256)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='VLANVRFList',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('vlan', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='ipam.vlan')),
                ('vrf', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ipam.vrf')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='VLANVRF',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('vlan', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='ipam.vlan')),
                ('vrf', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='ipam.vrf')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EthernetSegmentMembership',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('interface', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='dcim.interface')),
                ('segment', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='nautobot_evpn.ethernetsegment')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AnycastIP',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('ip', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='ipam.ipaddress')),
                ('vlan', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ipam.vlan')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='AnycastDummyIP',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False, unique=True)),
                ('ip', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, to='ipam.ipaddress')),
                ('vlan', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='ipam.vlan')),
            ],
            options={
                'abstract': False,
            },
        ),
    ]
