# Generated by Django 3.0.10 on 2020-10-01 16:53

from django.db import migrations, models
import django.db.models.deletion
import exchange.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('manufacturers', '0002_manufacturer_new_name'),
        ('suppliers', '0001_initial'),
    ]

    operations = [
        migrations.CreateModel(
            name='SupplierProduct',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('price_retail', models.FloatField(verbose_name='Retail price')),
                ('price_wholesale', models.FloatField(default=0, verbose_name='Wholesale price')),
                ('price_usd', models.FloatField(default=0)),
                ('price_eur', models.FloatField(default=0)),
                ('price_uah', models.FloatField(default=0)),
                ('initial_currency', exchange.models.CurrencyField(choices=[(980, 'UAH'), (840, 'USD'), (978, 'EUR')], default=980, verbose_name='Currency')),
                ('index', models.CharField(max_length=255, verbose_name='Index')),
                ('clean_index', models.CharField(db_index=True, max_length=255)),
                ('stock', models.CharField(max_length=255, verbose_name='Stock')),
                ('description', models.TextField(blank=True, max_length=2000, verbose_name='Description')),
                ('manufacturer', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, related_name='supplier_products', to='manufacturers.Manufacturer', verbose_name='Manufacturer')),
                ('supplier', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, related_name='products', to='suppliers.Supplier', verbose_name='Supplier')),
                ('warehouse', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='suppliers.SupplierWarehouse', verbose_name='Supplier warehouse')),
            ],
            options={
                'verbose_name': 'Supplier product',
                'verbose_name_plural': 'Supplier products',
            },
        ),
        migrations.CreateModel(
            name='ImportTask',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created', models.DateTimeField(auto_now_add=True, verbose_name='Creation date')),
                ('file', models.FileField(blank=True, null=True, upload_to='import_cache', verbose_name='File')),
                ('is_completed', models.BooleanField(default=False, verbose_name='Is completed')),
                ('is_processing', models.BooleanField(default=False, verbose_name='Is processing')),
                ('status', models.CharField(blank=True, max_length=255, verbose_name='Status')),
                ('percent', models.CharField(blank=True, max_length=10, verbose_name='Percent')),
                ('should_data_be_cleaned', models.BooleanField(default=False, verbose_name='Clean previous prices')),
                ('supplier', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='suppliers.Supplier', verbose_name='Supplier')),
                ('warehouse', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='suppliers.SupplierWarehouse', verbose_name='Supplier warehouse')),
            ],
            options={
                'verbose_name': 'Import task',
                'verbose_name_plural': 'Import tasks',
                'ordering': ['-created'],
                'abstract': False,
            },
        ),
    ]
