# mypy: ignore-errors
# -*- coding: utf-8 -*-
#
# TARGET arch is: ['-include', '/tmp/open-gpu-kernel-modules-d6b75a34094b0f56c2ccadf14e5d0bd515ed1ab6/src/common/sdk/nvidia/inc/nvtypes.h', '-I/tmp/open-gpu-kernel-modules-d6b75a34094b0f56c2ccadf14e5d0bd515ed1ab6/src/common/inc', '-I/tmp/open-gpu-kernel-modules-d6b75a34094b0f56c2ccadf14e5d0bd515ed1ab6/kernel-open/nvidia-uvm', '-I/tmp/open-gpu-kernel-modules-d6b75a34094b0f56c2ccadf14e5d0bd515ed1ab6/kernel-open/common/inc', '-I/tmp/open-gpu-kernel-modules-d6b75a34094b0f56c2ccadf14e5d0bd515ed1ab6/src/common/sdk/nvidia/inc', '-I/tmp/open-gpu-kernel-modules-d6b75a34094b0f56c2ccadf14e5d0bd515ed1ab6/src/nvidia/arch/nvalloc/unix/include', '-I/tmp/open-gpu-kernel-modules-d6b75a34094b0f56c2ccadf14e5d0bd515ed1ab6/src/common/sdk/nvidia/inc/ctrl']
# WORD_SIZE is: 8
# POINTER_SIZE is: 8
# LONGDOUBLE_SIZE is: 16
#
import ctypes, os


class AsDictMixin:
    @classmethod
    def as_dict(cls, self):
        result = {}
        if not isinstance(self, AsDictMixin):
            # not a structure, assume it's already a python object
            return self
        if not hasattr(cls, "_fields_"):
            return result
        # sys.version_info >= (3, 5)
        # for (field, *_) in cls._fields_:  # noqa
        for field_tuple in cls._fields_:  # noqa
            field = field_tuple[0]
            if field.startswith('PADDING_'):
                continue
            value = getattr(self, field)
            type_ = type(value)
            if hasattr(value, "_length_") and hasattr(value, "_type_"):
                # array
                if not hasattr(type_, "as_dict"):
                    value = [v for v in value]
                else:
                    type_ = type_._type_
                    value = [type_.as_dict(v) for v in value]
            elif hasattr(value, "contents") and hasattr(value, "_type_"):
                # pointer
                try:
                    if not hasattr(type_, "as_dict"):
                        value = value.contents
                    else:
                        type_ = type_._type_
                        value = type_.as_dict(value.contents)
                except ValueError:
                    # nullptr
                    value = None
            elif isinstance(value, AsDictMixin):
                # other structure
                value = type_.as_dict(value)
            result[field] = value
        return result


class Structure(ctypes.Structure, AsDictMixin):

    def __init__(self, *args, **kwds):
        # We don't want to use positional arguments fill PADDING_* fields

        args = dict(zip(self.__class__._field_names_(), args))
        args.update(kwds)
        super(Structure, self).__init__(**args)

    @classmethod
    def _field_names_(cls):
        if hasattr(cls, '_fields_'):
            return (f[0] for f in cls._fields_ if not f[0].startswith('PADDING'))
        else:
            return ()

    @classmethod
    def get_type(cls, field):
        for f in cls._fields_:
            if f[0] == field:
                return f[1]
        return None

    @classmethod
    def bind(cls, bound_fields):
        fields = {}
        for name, type_ in cls._fields_:
            if hasattr(type_, "restype"):
                if name in bound_fields:
                    if bound_fields[name] is None:
                        fields[name] = type_()
                    else:
                        # use a closure to capture the callback from the loop scope
                        fields[name] = (
                            type_((lambda callback: lambda *args: callback(*args))(
                                bound_fields[name]))
                        )
                    del bound_fields[name]
                else:
                    # default callback implementation (does nothing)
                    try:
                        default_ = type_(0).restype().value
                    except TypeError:
                        default_ = None
                    fields[name] = type_((
                        lambda default_: lambda *args: default_)(default_))
            else:
                # not a callback function, use default initialization
                if name in bound_fields:
                    fields[name] = bound_fields[name]
                    del bound_fields[name]
                else:
                    fields[name] = type_()
        if len(bound_fields) != 0:
            raise ValueError(
                "Cannot bind the following unknown callback(s) {}.{}".format(
                    cls.__name__, bound_fields.keys()
            ))
        return cls(**fields)


class Union(ctypes.Union, AsDictMixin):
    pass



c_int128 = ctypes.c_ubyte*16
c_uint128 = c_int128
void = None
if ctypes.sizeof(ctypes.c_longdouble) == 16:
    c_long_double_t = ctypes.c_longdouble
else:
    c_long_double_t = ctypes.c_ubyte*16

def string_cast(char_pointer, encoding='utf-8', errors='strict'):
    value = ctypes.cast(char_pointer, ctypes.c_char_p).value
    if value is not None and encoding is not None:
        value = value.decode(encoding, errors=errors)
    return value


def char_pointer_cast(string, encoding='utf-8'):
    if encoding is not None:
        try:
            string = string.encode(encoding)
        except AttributeError:
            # In Python3, bytes has no encode attribute
            pass
    string = ctypes.c_char_p(string)
    return ctypes.cast(string, ctypes.POINTER(ctypes.c_char))





__CLC6C0QMD_H__ = True # macro
NVC6C0_QMDV02_03_OUTER_PUT = (30 , 0) # macro
NVC6C0_QMDV02_03_OUTER_OVERFLOW = (31 , 31) # macro
NVC6C0_QMDV02_03_OUTER_GET = (62 , 32) # macro
NVC6C0_QMDV02_03_OUTER_STICKY_OVERFLOW = (63 , 63) # macro
NVC6C0_QMDV02_03_INNER_GET = (94 , 64) # macro
NVC6C0_QMDV02_03_INNER_OVERFLOW = (95 , 95) # macro
NVC6C0_QMDV02_03_INNER_PUT = (126 , 96) # macro
NVC6C0_QMDV02_03_INNER_STICKY_OVERFLOW = (127 , 127) # macro
NVC6C0_QMDV02_03_QMD_GROUP_ID = (133 , 128) # macro
NVC6C0_QMDV02_03_SM_GLOBAL_CACHING_ENABLE = (134 , 134) # macro
NVC6C0_QMDV02_03_RUN_CTA_IN_ONE_SM_PARTITION = (135 , 135) # macro
NVC6C0_QMDV02_03_RUN_CTA_IN_ONE_SM_PARTITION_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_03_RUN_CTA_IN_ONE_SM_PARTITION_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_03_IS_QUEUE = (136 , 136) # macro
NVC6C0_QMDV02_03_IS_QUEUE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_03_IS_QUEUE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_03_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST = (137 , 137) # macro
NVC6C0_QMDV02_03_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_03_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_03_SEMAPHORE_RELEASE_ENABLE0 = (138 , 138) # macro
NVC6C0_QMDV02_03_SEMAPHORE_RELEASE_ENABLE0_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_03_SEMAPHORE_RELEASE_ENABLE0_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_03_SEMAPHORE_RELEASE_ENABLE1 = (139 , 139) # macro
NVC6C0_QMDV02_03_SEMAPHORE_RELEASE_ENABLE1_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_03_SEMAPHORE_RELEASE_ENABLE1_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_03_REQUIRE_SCHEDULING_PCAS = (140 , 140) # macro
NVC6C0_QMDV02_03_REQUIRE_SCHEDULING_PCAS_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_03_REQUIRE_SCHEDULING_PCAS_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_03_DEPENDENT_QMD_SCHEDULE_ENABLE = (141 , 141) # macro
NVC6C0_QMDV02_03_DEPENDENT_QMD_SCHEDULE_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_03_DEPENDENT_QMD_SCHEDULE_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_03_DEPENDENT_QMD_TYPE = (142 , 142) # macro
NVC6C0_QMDV02_03_DEPENDENT_QMD_TYPE_QUEUE = 0x00000000 # macro
NVC6C0_QMDV02_03_DEPENDENT_QMD_TYPE_GRID = 0x00000001 # macro
NVC6C0_QMDV02_03_DEPENDENT_QMD_FIELD_COPY = (143 , 143) # macro
NVC6C0_QMDV02_03_DEPENDENT_QMD_FIELD_COPY_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_03_DEPENDENT_QMD_FIELD_COPY_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_03_QMD_RESERVED_B = (159 , 144) # macro
NVC6C0_QMDV02_03_CIRCULAR_QUEUE_SIZE = (184 , 160) # macro
NVC6C0_QMDV02_03_QMD_RESERVED_C = (185 , 185) # macro
NVC6C0_QMDV02_03_INVALIDATE_TEXTURE_HEADER_CACHE = (186 , 186) # macro
NVC6C0_QMDV02_03_INVALIDATE_TEXTURE_HEADER_CACHE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_03_INVALIDATE_TEXTURE_HEADER_CACHE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_03_INVALIDATE_TEXTURE_SAMPLER_CACHE = (187 , 187) # macro
NVC6C0_QMDV02_03_INVALIDATE_TEXTURE_SAMPLER_CACHE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_03_INVALIDATE_TEXTURE_SAMPLER_CACHE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_03_INVALIDATE_TEXTURE_DATA_CACHE = (188 , 188) # macro
NVC6C0_QMDV02_03_INVALIDATE_TEXTURE_DATA_CACHE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_03_INVALIDATE_TEXTURE_DATA_CACHE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_03_INVALIDATE_SHADER_DATA_CACHE = (189 , 189) # macro
NVC6C0_QMDV02_03_INVALIDATE_SHADER_DATA_CACHE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_03_INVALIDATE_SHADER_DATA_CACHE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_03_INVALIDATE_INSTRUCTION_CACHE = (190 , 190) # macro
NVC6C0_QMDV02_03_INVALIDATE_INSTRUCTION_CACHE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_03_INVALIDATE_INSTRUCTION_CACHE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_03_INVALIDATE_SHADER_CONSTANT_CACHE = (191 , 191) # macro
NVC6C0_QMDV02_03_INVALIDATE_SHADER_CONSTANT_CACHE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_03_INVALIDATE_SHADER_CONSTANT_CACHE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_03_CTA_RASTER_WIDTH_RESUME = (223 , 192) # macro
NVC6C0_QMDV02_03_CTA_RASTER_HEIGHT_RESUME = (239 , 224) # macro
NVC6C0_QMDV02_03_CTA_RASTER_DEPTH_RESUME = (255 , 240) # macro
NVC6C0_QMDV02_03_PROGRAM_PREFETCH_ADDR_LOWER_SHIFTED = (287 , 256) # macro
NVC6C0_QMDV02_03_CIRCULAR_QUEUE_ADDR_LOWER = (319 , 288) # macro
NVC6C0_QMDV02_03_CIRCULAR_QUEUE_ADDR_UPPER = (327 , 320) # macro
NVC6C0_QMDV02_03_QMD_RESERVED_D = (335 , 328) # macro
NVC6C0_QMDV02_03_CIRCULAR_QUEUE_ENTRY_SIZE = (351 , 336) # macro
NVC6C0_QMDV02_03_CWD_REFERENCE_COUNT_ID = (357 , 352) # macro
NVC6C0_QMDV02_03_CWD_REFERENCE_COUNT_DELTA_MINUS_ONE = (365 , 358) # macro
NVC6C0_QMDV02_03_RELEASE_MEMBAR_TYPE = (366 , 366) # macro
NVC6C0_QMDV02_03_RELEASE_MEMBAR_TYPE_FE_NONE = 0x00000000 # macro
NVC6C0_QMDV02_03_RELEASE_MEMBAR_TYPE_FE_SYSMEMBAR = 0x00000001 # macro
NVC6C0_QMDV02_03_CWD_REFERENCE_COUNT_INCR_ENABLE = (367 , 367) # macro
NVC6C0_QMDV02_03_CWD_REFERENCE_COUNT_INCR_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_03_CWD_REFERENCE_COUNT_INCR_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_03_CWD_MEMBAR_TYPE = (369 , 368) # macro
NVC6C0_QMDV02_03_CWD_MEMBAR_TYPE_L1_NONE = 0x00000000 # macro
NVC6C0_QMDV02_03_CWD_MEMBAR_TYPE_L1_SYSMEMBAR = 0x00000001 # macro
NVC6C0_QMDV02_03_CWD_MEMBAR_TYPE_L1_MEMBAR = 0x00000003 # macro
NVC6C0_QMDV02_03_SEQUENTIALLY_RUN_CTAS = (370 , 370) # macro
NVC6C0_QMDV02_03_SEQUENTIALLY_RUN_CTAS_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_03_SEQUENTIALLY_RUN_CTAS_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_03_CWD_REFERENCE_COUNT_DECR_ENABLE = (371 , 371) # macro
NVC6C0_QMDV02_03_CWD_REFERENCE_COUNT_DECR_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_03_CWD_REFERENCE_COUNT_DECR_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_03_API_VISIBLE_CALL_LIMIT = (378 , 378) # macro
NVC6C0_QMDV02_03_API_VISIBLE_CALL_LIMIT__32 = 0x00000000 # macro
NVC6C0_QMDV02_03_API_VISIBLE_CALL_LIMIT_NO_CHECK = 0x00000001 # macro
NVC6C0_QMDV02_03_SAMPLER_INDEX = (382 , 382) # macro
NVC6C0_QMDV02_03_SAMPLER_INDEX_INDEPENDENTLY = 0x00000000 # macro
NVC6C0_QMDV02_03_SAMPLER_INDEX_VIA_HEADER_INDEX = 0x00000001 # macro
NVC6C0_QMDV02_03_CTA_RASTER_WIDTH = (415 , 384) # macro
NVC6C0_QMDV02_03_CTA_RASTER_HEIGHT = (431 , 416) # macro
NVC6C0_QMDV02_03_QMD_RESERVED13A = (447 , 432) # macro
NVC6C0_QMDV02_03_CTA_RASTER_DEPTH = (463 , 448) # macro
NVC6C0_QMDV02_03_QMD_RESERVED14A = (479 , 464) # macro
NVC6C0_QMDV02_03_DEPENDENT_QMD_POINTER = (511 , 480) # macro
NVC6C0_QMDV02_03_COALESCE_WAITING_PERIOD = (529 , 522) # macro
NVC6C0_QMDV02_03_QUEUE_ENTRIES_PER_CTA_LOG2 = (534 , 530) # macro
NVC6C0_QMDV02_03_SHARED_MEMORY_SIZE = (561 , 544) # macro
NVC6C0_QMDV02_03_MIN_SM_CONFIG_SHARED_MEM_SIZE = (568 , 562) # macro
NVC6C0_QMDV02_03_MAX_SM_CONFIG_SHARED_MEM_SIZE = (575 , 569) # macro
NVC6C0_QMDV02_03_QMD_VERSION = (579 , 576) # macro
NVC6C0_QMDV02_03_QMD_MAJOR_VERSION = (583 , 580) # macro
NVC6C0_QMDV02_03_QMD_RESERVED_H = (591 , 584) # macro
NVC6C0_QMDV02_03_CTA_THREAD_DIMENSION0 = (607 , 592) # macro
NVC6C0_QMDV02_03_CTA_THREAD_DIMENSION1 = (623 , 608) # macro
NVC6C0_QMDV02_03_CTA_THREAD_DIMENSION2 = (639 , 624) # macro
def NVC6C0_QMDV02_03_CONSTANT_BUFFER_VALID(i):  # macro
    return ((640+(i)*1) , (640+(i)*1))
NVC6C0_QMDV02_03_CONSTANT_BUFFER_VALID_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_03_CONSTANT_BUFFER_VALID_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_03_REGISTER_COUNT_V = (656 , 648) # macro
NVC6C0_QMDV02_03_TARGET_SM_CONFIG_SHARED_MEM_SIZE = (663 , 657) # macro
NVC6C0_QMDV02_03_FREE_CTA_SLOTS_EMPTY_SM = (671 , 664) # macro
NVC6C0_QMDV02_03_SM_DISABLE_MASK_LOWER = (703 , 672) # macro
NVC6C0_QMDV02_03_SM_DISABLE_MASK_UPPER = (735 , 704) # macro
NVC6C0_QMDV02_03_RELEASE0_ADDRESS_LOWER = (767 , 736) # macro
NVC6C0_QMDV02_03_RELEASE0_ADDRESS_UPPER = (775 , 768) # macro
NVC6C0_QMDV02_03_QMD_RESERVED_J = (783 , 776) # macro
NVC6C0_QMDV02_03_RELEASE0_REDUCTION_OP = (790 , 788) # macro
NVC6C0_QMDV02_03_RELEASE0_REDUCTION_OP_RED_ADD = 0x00000000 # macro
NVC6C0_QMDV02_03_RELEASE0_REDUCTION_OP_RED_MIN = 0x00000001 # macro
NVC6C0_QMDV02_03_RELEASE0_REDUCTION_OP_RED_MAX = 0x00000002 # macro
NVC6C0_QMDV02_03_RELEASE0_REDUCTION_OP_RED_INC = 0x00000003 # macro
NVC6C0_QMDV02_03_RELEASE0_REDUCTION_OP_RED_DEC = 0x00000004 # macro
NVC6C0_QMDV02_03_RELEASE0_REDUCTION_OP_RED_AND = 0x00000005 # macro
NVC6C0_QMDV02_03_RELEASE0_REDUCTION_OP_RED_OR = 0x00000006 # macro
NVC6C0_QMDV02_03_RELEASE0_REDUCTION_OP_RED_XOR = 0x00000007 # macro
NVC6C0_QMDV02_03_QMD_RESERVED_K = (791 , 791) # macro
NVC6C0_QMDV02_03_RELEASE0_REDUCTION_FORMAT = (793 , 792) # macro
NVC6C0_QMDV02_03_RELEASE0_REDUCTION_FORMAT_UNSIGNED_32 = 0x00000000 # macro
NVC6C0_QMDV02_03_RELEASE0_REDUCTION_FORMAT_SIGNED_32 = 0x00000001 # macro
NVC6C0_QMDV02_03_RELEASE0_REDUCTION_ENABLE = (794 , 794) # macro
NVC6C0_QMDV02_03_RELEASE0_REDUCTION_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_03_RELEASE0_REDUCTION_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_03_RELEASE0_STRUCTURE_SIZE = (799 , 799) # macro
NVC6C0_QMDV02_03_RELEASE0_STRUCTURE_SIZE_FOUR_WORDS = 0x00000000 # macro
NVC6C0_QMDV02_03_RELEASE0_STRUCTURE_SIZE_ONE_WORD = 0x00000001 # macro
NVC6C0_QMDV02_03_RELEASE0_PAYLOAD = (831 , 800) # macro
NVC6C0_QMDV02_03_RELEASE1_ADDRESS_LOWER = (863 , 832) # macro
NVC6C0_QMDV02_03_RELEASE1_ADDRESS_UPPER = (871 , 864) # macro
NVC6C0_QMDV02_03_QMD_RESERVED_L = (879 , 872) # macro
NVC6C0_QMDV02_03_RELEASE1_REDUCTION_OP = (886 , 884) # macro
NVC6C0_QMDV02_03_RELEASE1_REDUCTION_OP_RED_ADD = 0x00000000 # macro
NVC6C0_QMDV02_03_RELEASE1_REDUCTION_OP_RED_MIN = 0x00000001 # macro
NVC6C0_QMDV02_03_RELEASE1_REDUCTION_OP_RED_MAX = 0x00000002 # macro
NVC6C0_QMDV02_03_RELEASE1_REDUCTION_OP_RED_INC = 0x00000003 # macro
NVC6C0_QMDV02_03_RELEASE1_REDUCTION_OP_RED_DEC = 0x00000004 # macro
NVC6C0_QMDV02_03_RELEASE1_REDUCTION_OP_RED_AND = 0x00000005 # macro
NVC6C0_QMDV02_03_RELEASE1_REDUCTION_OP_RED_OR = 0x00000006 # macro
NVC6C0_QMDV02_03_RELEASE1_REDUCTION_OP_RED_XOR = 0x00000007 # macro
NVC6C0_QMDV02_03_QMD_RESERVED_M = (887 , 887) # macro
NVC6C0_QMDV02_03_RELEASE1_REDUCTION_FORMAT = (889 , 888) # macro
NVC6C0_QMDV02_03_RELEASE1_REDUCTION_FORMAT_UNSIGNED_32 = 0x00000000 # macro
NVC6C0_QMDV02_03_RELEASE1_REDUCTION_FORMAT_SIGNED_32 = 0x00000001 # macro
NVC6C0_QMDV02_03_RELEASE1_REDUCTION_ENABLE = (890 , 890) # macro
NVC6C0_QMDV02_03_RELEASE1_REDUCTION_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_03_RELEASE1_REDUCTION_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_03_RELEASE1_STRUCTURE_SIZE = (895 , 895) # macro
NVC6C0_QMDV02_03_RELEASE1_STRUCTURE_SIZE_FOUR_WORDS = 0x00000000 # macro
NVC6C0_QMDV02_03_RELEASE1_STRUCTURE_SIZE_ONE_WORD = 0x00000001 # macro
NVC6C0_QMDV02_03_RELEASE1_PAYLOAD = (927 , 896) # macro
NVC6C0_QMDV02_03_SHADER_LOCAL_MEMORY_LOW_SIZE = (951 , 928) # macro
NVC6C0_QMDV02_03_QMD_RESERVED_N = (954 , 952) # macro
NVC6C0_QMDV02_03_BARRIER_COUNT = (959 , 955) # macro
NVC6C0_QMDV02_03_SHADER_LOCAL_MEMORY_HIGH_SIZE = (983 , 960) # macro
NVC6C0_QMDV02_03_REGISTER_COUNT = (991 , 984) # macro
NVC6C0_QMDV02_03_PROGRAM_PREFETCH_ADDR_UPPER_SHIFTED = (1000 , 992) # macro
NVC6C0_QMDV02_03_PROGRAM_PREFETCH_SIZE = (1009 , 1001) # macro
NVC6C0_QMDV02_03_QMD_RESERVED_A = (1015 , 1010) # macro
NVC6C0_QMDV02_03_SASS_VERSION = (1023 , 1016) # macro
def NVC6C0_QMDV02_03_CONSTANT_BUFFER_ADDR_LOWER(i):  # macro
    return ((1055+(i)*64) , (1024+(i)*64))
def NVC6C0_QMDV02_03_CONSTANT_BUFFER_ADDR_UPPER(i):  # macro
    return ((1072+(i)*64) , (1056+(i)*64))
def NVC6C0_QMDV02_03_CONSTANT_BUFFER_PREFETCH_POST(i):  # macro
    return ((1073+(i)*64) , (1073+(i)*64))
NVC6C0_QMDV02_03_CONSTANT_BUFFER_PREFETCH_POST_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_03_CONSTANT_BUFFER_PREFETCH_POST_TRUE = 0x00000001 # macro
def NVC6C0_QMDV02_03_CONSTANT_BUFFER_INVALIDATE(i):  # macro
    return ((1074+(i)*64) , (1074+(i)*64))
NVC6C0_QMDV02_03_CONSTANT_BUFFER_INVALIDATE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_03_CONSTANT_BUFFER_INVALIDATE_TRUE = 0x00000001 # macro
def NVC6C0_QMDV02_03_CONSTANT_BUFFER_SIZE_SHIFTED4(i):  # macro
    return ((1087+(i)*64) , (1075+(i)*64))
NVC6C0_QMDV02_03_PROGRAM_ADDRESS_LOWER = (1567 , 1536) # macro
NVC6C0_QMDV02_03_PROGRAM_ADDRESS_UPPER = (1584 , 1568) # macro
NVC6C0_QMDV02_03_QMD_RESERVED_S = (1599 , 1585) # macro
NVC6C0_QMDV02_03_HW_ONLY_INNER_GET = (1630 , 1600) # macro
NVC6C0_QMDV02_03_HW_ONLY_REQUIRE_SCHEDULING_PCAS = (1631 , 1631) # macro
NVC6C0_QMDV02_03_HW_ONLY_INNER_PUT = (1662 , 1632) # macro
NVC6C0_QMDV02_03_HW_ONLY_SCG_TYPE = (1663 , 1663) # macro
NVC6C0_QMDV02_03_HW_ONLY_SPAN_LIST_HEAD_INDEX = (1693 , 1664) # macro
NVC6C0_QMDV02_03_QMD_RESERVED_Q = (1694 , 1694) # macro
NVC6C0_QMDV02_03_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID = (1695 , 1695) # macro
NVC6C0_QMDV02_03_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_03_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_03_HW_ONLY_SKED_NEXT_QMD_POINTER = (1727 , 1696) # macro
NVC6C0_QMDV02_03_QMD_SPARE_G = (1759 , 1728) # macro
NVC6C0_QMDV02_03_QMD_SPARE_H = (1791 , 1760) # macro
NVC6C0_QMDV02_03_QMD_SPARE_I = (1823 , 1792) # macro
NVC6C0_QMDV02_03_QMD_SPARE_J = (1855 , 1824) # macro
NVC6C0_QMDV02_03_QMD_SPARE_K = (1887 , 1856) # macro
NVC6C0_QMDV02_03_QMD_SPARE_L = (1919 , 1888) # macro
NVC6C0_QMDV02_03_QMD_SPARE_M = (1951 , 1920) # macro
NVC6C0_QMDV02_03_QMD_SPARE_N = (1983 , 1952) # macro
NVC6C0_QMDV02_03_DEBUG_ID_UPPER = (2015 , 1984) # macro
NVC6C0_QMDV02_03_DEBUG_ID_LOWER = (2047 , 2016) # macro
NVC6C0_QMDV02_04_OUTER_PUT = (30 , 0) # macro
NVC6C0_QMDV02_04_OUTER_OVERFLOW = (31 , 31) # macro
NVC6C0_QMDV02_04_OUTER_GET = (62 , 32) # macro
NVC6C0_QMDV02_04_OUTER_STICKY_OVERFLOW = (63 , 63) # macro
NVC6C0_QMDV02_04_INNER_GET = (94 , 64) # macro
NVC6C0_QMDV02_04_INNER_OVERFLOW = (95 , 95) # macro
NVC6C0_QMDV02_04_INNER_PUT = (126 , 96) # macro
NVC6C0_QMDV02_04_INNER_STICKY_OVERFLOW = (127 , 127) # macro
NVC6C0_QMDV02_04_QMD_GROUP_ID = (133 , 128) # macro
NVC6C0_QMDV02_04_SM_GLOBAL_CACHING_ENABLE = (134 , 134) # macro
NVC6C0_QMDV02_04_RUN_CTA_IN_ONE_SM_PARTITION = (135 , 135) # macro
NVC6C0_QMDV02_04_RUN_CTA_IN_ONE_SM_PARTITION_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_RUN_CTA_IN_ONE_SM_PARTITION_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_IS_QUEUE = (136 , 136) # macro
NVC6C0_QMDV02_04_IS_QUEUE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_IS_QUEUE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST = (137 , 137) # macro
NVC6C0_QMDV02_04_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_SEMAPHORE_RELEASE_ENABLE0 = (138 , 138) # macro
NVC6C0_QMDV02_04_SEMAPHORE_RELEASE_ENABLE0_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_SEMAPHORE_RELEASE_ENABLE0_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_SEMAPHORE_RELEASE_ENABLE1 = (139 , 139) # macro
NVC6C0_QMDV02_04_SEMAPHORE_RELEASE_ENABLE1_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_SEMAPHORE_RELEASE_ENABLE1_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_REQUIRE_SCHEDULING_PCAS = (140 , 140) # macro
NVC6C0_QMDV02_04_REQUIRE_SCHEDULING_PCAS_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_REQUIRE_SCHEDULING_PCAS_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_DEPENDENT_QMD0_ENABLE = (141 , 141) # macro
NVC6C0_QMDV02_04_DEPENDENT_QMD0_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_DEPENDENT_QMD0_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_DEPENDENT_QMD0_ACTION = (144 , 142) # macro
NVC6C0_QMDV02_04_DEPENDENT_QMD0_ACTION_QMD_INCREMENT_PUT = 0x00000000 # macro
NVC6C0_QMDV02_04_DEPENDENT_QMD0_ACTION_QMD_SCHEDULE = 0x00000001 # macro
NVC6C0_QMDV02_04_DEPENDENT_QMD0_ACTION_QMD_INVALIDATE_COPY_SCHEDULE = 0x00000003 # macro
NVC6C0_QMDV02_04_DEPENDENT_QMD0_ACTION_QMD_DECREMENT_DEPENDENCE = 0x00000004 # macro
NVC6C0_QMDV02_04_DEPENDENT_QMD0_PREFETCH = (145 , 145) # macro
NVC6C0_QMDV02_04_DEPENDENT_QMD0_PREFETCH_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_DEPENDENT_QMD0_PREFETCH_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_DEPENDENT_QMD1_ENABLE = (146 , 146) # macro
NVC6C0_QMDV02_04_DEPENDENT_QMD1_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_DEPENDENT_QMD1_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_DEPENDENT_QMD1_ACTION = (149 , 147) # macro
NVC6C0_QMDV02_04_DEPENDENT_QMD1_ACTION_QMD_INCREMENT_PUT = 0x00000000 # macro
NVC6C0_QMDV02_04_DEPENDENT_QMD1_ACTION_QMD_SCHEDULE = 0x00000001 # macro
NVC6C0_QMDV02_04_DEPENDENT_QMD1_ACTION_QMD_INVALIDATE_COPY_SCHEDULE = 0x00000003 # macro
NVC6C0_QMDV02_04_DEPENDENT_QMD1_ACTION_QMD_DECREMENT_DEPENDENCE = 0x00000004 # macro
NVC6C0_QMDV02_04_DEPENDENT_QMD1_PREFETCH = (150 , 150) # macro
NVC6C0_QMDV02_04_DEPENDENT_QMD1_PREFETCH_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_DEPENDENT_QMD1_PREFETCH_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_DEPENDENCE_COUNTER = (157 , 151) # macro
NVC6C0_QMDV02_04_SELF_COPY_ON_COMPLETION = (158 , 158) # macro
NVC6C0_QMDV02_04_SELF_COPY_ON_COMPLETION_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_SELF_COPY_ON_COMPLETION_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_QMD_RESERVED_B = (159 , 159) # macro
NVC6C0_QMDV02_04_CIRCULAR_QUEUE_SIZE = (184 , 160) # macro
NVC6C0_QMDV02_04_DEMOTE_L2_EVICT_LAST = (185 , 185) # macro
NVC6C0_QMDV02_04_INVALIDATE_TEXTURE_HEADER_CACHE = (186 , 186) # macro
NVC6C0_QMDV02_04_INVALIDATE_TEXTURE_HEADER_CACHE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_INVALIDATE_TEXTURE_HEADER_CACHE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_INVALIDATE_TEXTURE_SAMPLER_CACHE = (187 , 187) # macro
NVC6C0_QMDV02_04_INVALIDATE_TEXTURE_SAMPLER_CACHE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_INVALIDATE_TEXTURE_SAMPLER_CACHE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_INVALIDATE_TEXTURE_DATA_CACHE = (188 , 188) # macro
NVC6C0_QMDV02_04_INVALIDATE_TEXTURE_DATA_CACHE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_INVALIDATE_TEXTURE_DATA_CACHE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_INVALIDATE_SHADER_DATA_CACHE = (189 , 189) # macro
NVC6C0_QMDV02_04_INVALIDATE_SHADER_DATA_CACHE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_INVALIDATE_SHADER_DATA_CACHE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_INVALIDATE_INSTRUCTION_CACHE = (190 , 190) # macro
NVC6C0_QMDV02_04_INVALIDATE_INSTRUCTION_CACHE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_INVALIDATE_INSTRUCTION_CACHE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_INVALIDATE_SHADER_CONSTANT_CACHE = (191 , 191) # macro
NVC6C0_QMDV02_04_INVALIDATE_SHADER_CONSTANT_CACHE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_INVALIDATE_SHADER_CONSTANT_CACHE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_CTA_RASTER_WIDTH_RESUME = (223 , 192) # macro
NVC6C0_QMDV02_04_CTA_RASTER_HEIGHT_RESUME = (239 , 224) # macro
NVC6C0_QMDV02_04_CTA_RASTER_DEPTH_RESUME = (255 , 240) # macro
NVC6C0_QMDV02_04_PROGRAM_PREFETCH_ADDR_LOWER_SHIFTED = (287 , 256) # macro
NVC6C0_QMDV02_04_CIRCULAR_QUEUE_ADDR_LOWER = (319 , 288) # macro
NVC6C0_QMDV02_04_CIRCULAR_QUEUE_ADDR_UPPER = (327 , 320) # macro
NVC6C0_QMDV02_04_QMD_RESERVED_D = (335 , 328) # macro
NVC6C0_QMDV02_04_CIRCULAR_QUEUE_ENTRY_SIZE = (351 , 336) # macro
NVC6C0_QMDV02_04_CWD_REFERENCE_COUNT_ID = (357 , 352) # macro
NVC6C0_QMDV02_04_CWD_REFERENCE_COUNT_DELTA_MINUS_ONE = (365 , 358) # macro
NVC6C0_QMDV02_04_RELEASE_MEMBAR_TYPE = (366 , 366) # macro
NVC6C0_QMDV02_04_RELEASE_MEMBAR_TYPE_FE_NONE = 0x00000000 # macro
NVC6C0_QMDV02_04_RELEASE_MEMBAR_TYPE_FE_SYSMEMBAR = 0x00000001 # macro
NVC6C0_QMDV02_04_CWD_REFERENCE_COUNT_INCR_ENABLE = (367 , 367) # macro
NVC6C0_QMDV02_04_CWD_REFERENCE_COUNT_INCR_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_CWD_REFERENCE_COUNT_INCR_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_CWD_MEMBAR_TYPE = (369 , 368) # macro
NVC6C0_QMDV02_04_CWD_MEMBAR_TYPE_L1_NONE = 0x00000000 # macro
NVC6C0_QMDV02_04_CWD_MEMBAR_TYPE_L1_SYSMEMBAR = 0x00000001 # macro
NVC6C0_QMDV02_04_CWD_MEMBAR_TYPE_L1_MEMBAR = 0x00000003 # macro
NVC6C0_QMDV02_04_SEQUENTIALLY_RUN_CTAS = (370 , 370) # macro
NVC6C0_QMDV02_04_SEQUENTIALLY_RUN_CTAS_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_SEQUENTIALLY_RUN_CTAS_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_CWD_REFERENCE_COUNT_DECR_ENABLE = (371 , 371) # macro
NVC6C0_QMDV02_04_CWD_REFERENCE_COUNT_DECR_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_CWD_REFERENCE_COUNT_DECR_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_API_VISIBLE_CALL_LIMIT = (378 , 378) # macro
NVC6C0_QMDV02_04_API_VISIBLE_CALL_LIMIT__32 = 0x00000000 # macro
NVC6C0_QMDV02_04_API_VISIBLE_CALL_LIMIT_NO_CHECK = 0x00000001 # macro
NVC6C0_QMDV02_04_SAMPLER_INDEX = (382 , 382) # macro
NVC6C0_QMDV02_04_SAMPLER_INDEX_INDEPENDENTLY = 0x00000000 # macro
NVC6C0_QMDV02_04_SAMPLER_INDEX_VIA_HEADER_INDEX = 0x00000001 # macro
NVC6C0_QMDV02_04_DISABLE_AUTO_INVALIDATE = (383 , 383) # macro
NVC6C0_QMDV02_04_DISABLE_AUTO_INVALIDATE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_DISABLE_AUTO_INVALIDATE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_CTA_RASTER_WIDTH = (415 , 384) # macro
NVC6C0_QMDV02_04_CTA_RASTER_HEIGHT = (431 , 416) # macro
NVC6C0_QMDV02_04_QMD_RESERVED13A = (447 , 432) # macro
NVC6C0_QMDV02_04_CTA_RASTER_DEPTH = (463 , 448) # macro
NVC6C0_QMDV02_04_QMD_RESERVED14A = (479 , 464) # macro
NVC6C0_QMDV02_04_DEPENDENT_QMD0_POINTER = (511 , 480) # macro
NVC6C0_QMDV02_04_COALESCE_WAITING_PERIOD = (529 , 522) # macro
NVC6C0_QMDV02_04_QUEUE_ENTRIES_PER_CTA_LOG2 = (534 , 530) # macro
NVC6C0_QMDV02_04_SHARED_MEMORY_SIZE = (561 , 544) # macro
NVC6C0_QMDV02_04_MIN_SM_CONFIG_SHARED_MEM_SIZE = (568 , 562) # macro
NVC6C0_QMDV02_04_MAX_SM_CONFIG_SHARED_MEM_SIZE = (575 , 569) # macro
NVC6C0_QMDV02_04_QMD_VERSION = (579 , 576) # macro
NVC6C0_QMDV02_04_QMD_MAJOR_VERSION = (583 , 580) # macro
NVC6C0_QMDV02_04_QMD_RESERVED_H = (591 , 584) # macro
NVC6C0_QMDV02_04_CTA_THREAD_DIMENSION0 = (607 , 592) # macro
NVC6C0_QMDV02_04_CTA_THREAD_DIMENSION1 = (623 , 608) # macro
NVC6C0_QMDV02_04_CTA_THREAD_DIMENSION2 = (639 , 624) # macro
def NVC6C0_QMDV02_04_CONSTANT_BUFFER_VALID(i):  # macro
    return ((640+(i)*1) , (640+(i)*1))
NVC6C0_QMDV02_04_CONSTANT_BUFFER_VALID_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_CONSTANT_BUFFER_VALID_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_REGISTER_COUNT_V = (656 , 648) # macro
NVC6C0_QMDV02_04_TARGET_SM_CONFIG_SHARED_MEM_SIZE = (663 , 657) # macro
NVC6C0_QMDV02_04_FREE_CTA_SLOTS_EMPTY_SM = (671 , 664) # macro
NVC6C0_QMDV02_04_SM_DISABLE_MASK_LOWER = (703 , 672) # macro
NVC6C0_QMDV02_04_SM_DISABLE_MASK_UPPER = (735 , 704) # macro
NVC6C0_QMDV02_04_RELEASE0_ADDRESS_LOWER = (767 , 736) # macro
NVC6C0_QMDV02_04_RELEASE0_ADDRESS_UPPER = (775 , 768) # macro
NVC6C0_QMDV02_04_QMD_RESERVED_J = (783 , 776) # macro
NVC6C0_QMDV02_04_RELEASE0_REDUCTION_OP = (790 , 788) # macro
NVC6C0_QMDV02_04_RELEASE0_REDUCTION_OP_RED_ADD = 0x00000000 # macro
NVC6C0_QMDV02_04_RELEASE0_REDUCTION_OP_RED_MIN = 0x00000001 # macro
NVC6C0_QMDV02_04_RELEASE0_REDUCTION_OP_RED_MAX = 0x00000002 # macro
NVC6C0_QMDV02_04_RELEASE0_REDUCTION_OP_RED_INC = 0x00000003 # macro
NVC6C0_QMDV02_04_RELEASE0_REDUCTION_OP_RED_DEC = 0x00000004 # macro
NVC6C0_QMDV02_04_RELEASE0_REDUCTION_OP_RED_AND = 0x00000005 # macro
NVC6C0_QMDV02_04_RELEASE0_REDUCTION_OP_RED_OR = 0x00000006 # macro
NVC6C0_QMDV02_04_RELEASE0_REDUCTION_OP_RED_XOR = 0x00000007 # macro
NVC6C0_QMDV02_04_QMD_RESERVED_K = (791 , 791) # macro
NVC6C0_QMDV02_04_RELEASE0_REDUCTION_FORMAT = (793 , 792) # macro
NVC6C0_QMDV02_04_RELEASE0_REDUCTION_FORMAT_UNSIGNED_32 = 0x00000000 # macro
NVC6C0_QMDV02_04_RELEASE0_REDUCTION_FORMAT_SIGNED_32 = 0x00000001 # macro
NVC6C0_QMDV02_04_RELEASE0_REDUCTION_ENABLE = (794 , 794) # macro
NVC6C0_QMDV02_04_RELEASE0_REDUCTION_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_RELEASE0_REDUCTION_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_RELEASE0_STRUCTURE_SIZE = (799 , 799) # macro
NVC6C0_QMDV02_04_RELEASE0_STRUCTURE_SIZE_FOUR_WORDS = 0x00000000 # macro
NVC6C0_QMDV02_04_RELEASE0_STRUCTURE_SIZE_ONE_WORD = 0x00000001 # macro
NVC6C0_QMDV02_04_RELEASE0_PAYLOAD = (831 , 800) # macro
NVC6C0_QMDV02_04_RELEASE1_ADDRESS_LOWER = (863 , 832) # macro
NVC6C0_QMDV02_04_RELEASE1_ADDRESS_UPPER = (871 , 864) # macro
NVC6C0_QMDV02_04_QMD_RESERVED_L = (879 , 872) # macro
NVC6C0_QMDV02_04_RELEASE1_REDUCTION_OP = (886 , 884) # macro
NVC6C0_QMDV02_04_RELEASE1_REDUCTION_OP_RED_ADD = 0x00000000 # macro
NVC6C0_QMDV02_04_RELEASE1_REDUCTION_OP_RED_MIN = 0x00000001 # macro
NVC6C0_QMDV02_04_RELEASE1_REDUCTION_OP_RED_MAX = 0x00000002 # macro
NVC6C0_QMDV02_04_RELEASE1_REDUCTION_OP_RED_INC = 0x00000003 # macro
NVC6C0_QMDV02_04_RELEASE1_REDUCTION_OP_RED_DEC = 0x00000004 # macro
NVC6C0_QMDV02_04_RELEASE1_REDUCTION_OP_RED_AND = 0x00000005 # macro
NVC6C0_QMDV02_04_RELEASE1_REDUCTION_OP_RED_OR = 0x00000006 # macro
NVC6C0_QMDV02_04_RELEASE1_REDUCTION_OP_RED_XOR = 0x00000007 # macro
NVC6C0_QMDV02_04_QMD_RESERVED_M = (887 , 887) # macro
NVC6C0_QMDV02_04_RELEASE1_REDUCTION_FORMAT = (889 , 888) # macro
NVC6C0_QMDV02_04_RELEASE1_REDUCTION_FORMAT_UNSIGNED_32 = 0x00000000 # macro
NVC6C0_QMDV02_04_RELEASE1_REDUCTION_FORMAT_SIGNED_32 = 0x00000001 # macro
NVC6C0_QMDV02_04_RELEASE1_REDUCTION_ENABLE = (890 , 890) # macro
NVC6C0_QMDV02_04_RELEASE1_REDUCTION_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_RELEASE1_REDUCTION_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_RELEASE1_STRUCTURE_SIZE = (895 , 895) # macro
NVC6C0_QMDV02_04_RELEASE1_STRUCTURE_SIZE_FOUR_WORDS = 0x00000000 # macro
NVC6C0_QMDV02_04_RELEASE1_STRUCTURE_SIZE_ONE_WORD = 0x00000001 # macro
NVC6C0_QMDV02_04_RELEASE1_PAYLOAD = (927 , 896) # macro
NVC6C0_QMDV02_04_SHADER_LOCAL_MEMORY_LOW_SIZE = (951 , 928) # macro
NVC6C0_QMDV02_04_QMD_RESERVED_N = (954 , 952) # macro
NVC6C0_QMDV02_04_BARRIER_COUNT = (959 , 955) # macro
NVC6C0_QMDV02_04_SHADER_LOCAL_MEMORY_HIGH_SIZE = (983 , 960) # macro
NVC6C0_QMDV02_04_QMD_RESERVED_G = (991 , 984) # macro
NVC6C0_QMDV02_04_PROGRAM_PREFETCH_ADDR_UPPER_SHIFTED = (1000 , 992) # macro
NVC6C0_QMDV02_04_PROGRAM_PREFETCH_SIZE = (1009 , 1001) # macro
NVC6C0_QMDV02_04_PROGRAM_PREFETCH_TYPE = (1011 , 1010) # macro
NVC6C0_QMDV02_04_PROGRAM_PREFETCH_TYPE_PREFETCH_LAUNCH = 0x00000000 # macro
NVC6C0_QMDV02_04_PROGRAM_PREFETCH_TYPE_PREFTECH_POST = 0x00000001 # macro
NVC6C0_QMDV02_04_QMD_RESERVED_A = (1015 , 1012) # macro
NVC6C0_QMDV02_04_SASS_VERSION = (1023 , 1016) # macro
def NVC6C0_QMDV02_04_CONSTANT_BUFFER_ADDR_LOWER(i):  # macro
    return ((1055+(i)*64) , (1024+(i)*64))
def NVC6C0_QMDV02_04_CONSTANT_BUFFER_ADDR_UPPER(i):  # macro
    return ((1072+(i)*64) , (1056+(i)*64))
def NVC6C0_QMDV02_04_CONSTANT_BUFFER_PREFETCH_POST(i):  # macro
    return ((1073+(i)*64) , (1073+(i)*64))
NVC6C0_QMDV02_04_CONSTANT_BUFFER_PREFETCH_POST_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_CONSTANT_BUFFER_PREFETCH_POST_TRUE = 0x00000001 # macro
def NVC6C0_QMDV02_04_CONSTANT_BUFFER_INVALIDATE(i):  # macro
    return ((1074+(i)*64) , (1074+(i)*64))
NVC6C0_QMDV02_04_CONSTANT_BUFFER_INVALIDATE_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_CONSTANT_BUFFER_INVALIDATE_TRUE = 0x00000001 # macro
def NVC6C0_QMDV02_04_CONSTANT_BUFFER_SIZE_SHIFTED4(i):  # macro
    return ((1087+(i)*64) , (1075+(i)*64))
NVC6C0_QMDV02_04_PROGRAM_ADDRESS_LOWER = (1567 , 1536) # macro
NVC6C0_QMDV02_04_PROGRAM_ADDRESS_UPPER = (1584 , 1568) # macro
NVC6C0_QMDV02_04_QMD_RESERVED_S = (1599 , 1585) # macro
NVC6C0_QMDV02_04_HW_ONLY_INNER_GET = (1630 , 1600) # macro
NVC6C0_QMDV02_04_HW_ONLY_REQUIRE_SCHEDULING_PCAS = (1631 , 1631) # macro
NVC6C0_QMDV02_04_HW_ONLY_INNER_PUT = (1662 , 1632) # macro
NVC6C0_QMDV02_04_HW_ONLY_SCG_TYPE = (1663 , 1663) # macro
NVC6C0_QMDV02_04_HW_ONLY_SPAN_LIST_HEAD_INDEX = (1693 , 1664) # macro
NVC6C0_QMDV02_04_QMD_RESERVED_Q = (1694 , 1694) # macro
NVC6C0_QMDV02_04_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID = (1695 , 1695) # macro
NVC6C0_QMDV02_04_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID_FALSE = 0x00000000 # macro
NVC6C0_QMDV02_04_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID_TRUE = 0x00000001 # macro
NVC6C0_QMDV02_04_HW_ONLY_SKED_NEXT_QMD_POINTER = (1727 , 1696) # macro
NVC6C0_QMDV02_04_HW_ONLY_DEPENDENCE_COUNTER = (1734 , 1728) # macro
NVC6C0_QMDV02_04_QMD_RESERVED_I = (1759 , 1735) # macro
NVC6C0_QMDV02_04_QMD_SPARE_H = (1791 , 1760) # macro
NVC6C0_QMDV02_04_QMD_SPARE_I = (1823 , 1792) # macro
NVC6C0_QMDV02_04_QMD_SPARE_J = (1855 , 1824) # macro
NVC6C0_QMDV02_04_QMD_SPARE_K = (1887 , 1856) # macro
NVC6C0_QMDV02_04_QMD_SPARE_L = (1919 , 1888) # macro
NVC6C0_QMDV02_04_QMD_SPARE_M = (1951 , 1920) # macro
NVC6C0_QMDV02_04_QMD_SPARE_N = (1983 , 1952) # macro
NVC6C0_QMDV02_04_DEBUG_ID_UPPER = (2015 , 1984) # macro
NVC6C0_QMDV02_04_DEBUG_ID_LOWER = (2047 , 2016) # macro
NVC6C0_QMDV03_00_OUTER_PUT = (30 , 0) # macro
NVC6C0_QMDV03_00_OUTER_OVERFLOW = (31 , 31) # macro
NVC6C0_QMDV03_00_OUTER_GET = (62 , 32) # macro
NVC6C0_QMDV03_00_OUTER_STICKY_OVERFLOW = (63 , 63) # macro
NVC6C0_QMDV03_00_INNER_GET = (94 , 64) # macro
NVC6C0_QMDV03_00_INNER_OVERFLOW = (95 , 95) # macro
NVC6C0_QMDV03_00_INNER_PUT = (126 , 96) # macro
NVC6C0_QMDV03_00_INNER_STICKY_OVERFLOW = (127 , 127) # macro
NVC6C0_QMDV03_00_QMD_GROUP_ID = (133 , 128) # macro
NVC6C0_QMDV03_00_SM_GLOBAL_CACHING_ENABLE = (134 , 134) # macro
NVC6C0_QMDV03_00_RUN_CTA_IN_ONE_SM_PARTITION = (135 , 135) # macro
NVC6C0_QMDV03_00_RUN_CTA_IN_ONE_SM_PARTITION_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_RUN_CTA_IN_ONE_SM_PARTITION_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_IS_QUEUE = (136 , 136) # macro
NVC6C0_QMDV03_00_IS_QUEUE_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_IS_QUEUE_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST = (137 , 137) # macro
NVC6C0_QMDV03_00_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_ADD_TO_HEAD_OF_QMD_GROUP_LINKED_LIST_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_QMD_RESERVED04A = (139 , 138) # macro
NVC6C0_QMDV03_00_REQUIRE_SCHEDULING_PCAS = (140 , 140) # macro
NVC6C0_QMDV03_00_REQUIRE_SCHEDULING_PCAS_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_REQUIRE_SCHEDULING_PCAS_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_QMD_RESERVED04B = (141 , 141) # macro
NVC6C0_QMDV03_00_DEPENDENCE_COUNTER = (157 , 142) # macro
NVC6C0_QMDV03_00_SELF_COPY_ON_COMPLETION = (158 , 158) # macro
NVC6C0_QMDV03_00_SELF_COPY_ON_COMPLETION_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_SELF_COPY_ON_COMPLETION_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_QMD_RESERVED04C = (159 , 159) # macro
NVC6C0_QMDV03_00_CIRCULAR_QUEUE_SIZE = (184 , 160) # macro
NVC6C0_QMDV03_00_DEMOTE_L2_EVICT_LAST = (185 , 185) # macro
NVC6C0_QMDV03_00_INVALIDATE_TEXTURE_HEADER_CACHE = (186 , 186) # macro
NVC6C0_QMDV03_00_INVALIDATE_TEXTURE_HEADER_CACHE_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_INVALIDATE_TEXTURE_HEADER_CACHE_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_INVALIDATE_TEXTURE_SAMPLER_CACHE = (187 , 187) # macro
NVC6C0_QMDV03_00_INVALIDATE_TEXTURE_SAMPLER_CACHE_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_INVALIDATE_TEXTURE_SAMPLER_CACHE_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_INVALIDATE_TEXTURE_DATA_CACHE = (188 , 188) # macro
NVC6C0_QMDV03_00_INVALIDATE_TEXTURE_DATA_CACHE_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_INVALIDATE_TEXTURE_DATA_CACHE_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_INVALIDATE_SHADER_DATA_CACHE = (189 , 189) # macro
NVC6C0_QMDV03_00_INVALIDATE_SHADER_DATA_CACHE_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_INVALIDATE_SHADER_DATA_CACHE_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_INVALIDATE_INSTRUCTION_CACHE = (190 , 190) # macro
NVC6C0_QMDV03_00_INVALIDATE_INSTRUCTION_CACHE_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_INVALIDATE_INSTRUCTION_CACHE_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_INVALIDATE_SHADER_CONSTANT_CACHE = (191 , 191) # macro
NVC6C0_QMDV03_00_INVALIDATE_SHADER_CONSTANT_CACHE_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_INVALIDATE_SHADER_CONSTANT_CACHE_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_CTA_RASTER_WIDTH_RESUME = (223 , 192) # macro
NVC6C0_QMDV03_00_CTA_RASTER_HEIGHT_RESUME = (239 , 224) # macro
NVC6C0_QMDV03_00_CTA_RASTER_DEPTH_RESUME = (255 , 240) # macro
NVC6C0_QMDV03_00_PROGRAM_PREFETCH_ADDR_LOWER_SHIFTED = (287 , 256) # macro
NVC6C0_QMDV03_00_CIRCULAR_QUEUE_ADDR_LOWER = (319 , 288) # macro
NVC6C0_QMDV03_00_CIRCULAR_QUEUE_ADDR_UPPER = (327 , 320) # macro
NVC6C0_QMDV03_00_QMD_RESERVED_D = (335 , 328) # macro
NVC6C0_QMDV03_00_CIRCULAR_QUEUE_ENTRY_SIZE = (351 , 336) # macro
NVC6C0_QMDV03_00_CWD_REFERENCE_COUNT_ID = (357 , 352) # macro
NVC6C0_QMDV03_00_CWD_REFERENCE_COUNT_DELTA_MINUS_ONE = (365 , 358) # macro
NVC6C0_QMDV03_00_QMD_RESERVED11A = (366 , 366) # macro
NVC6C0_QMDV03_00_CWD_REFERENCE_COUNT_INCR_ENABLE = (367 , 367) # macro
NVC6C0_QMDV03_00_CWD_REFERENCE_COUNT_INCR_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_CWD_REFERENCE_COUNT_INCR_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_CWD_MEMBAR_TYPE = (369 , 368) # macro
NVC6C0_QMDV03_00_CWD_MEMBAR_TYPE_L1_NONE = 0x00000000 # macro
NVC6C0_QMDV03_00_CWD_MEMBAR_TYPE_L1_SYSMEMBAR = 0x00000001 # macro
NVC6C0_QMDV03_00_CWD_MEMBAR_TYPE_L1_MEMBAR = 0x00000003 # macro
NVC6C0_QMDV03_00_SEQUENTIALLY_RUN_CTAS = (370 , 370) # macro
NVC6C0_QMDV03_00_SEQUENTIALLY_RUN_CTAS_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_SEQUENTIALLY_RUN_CTAS_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_CWD_REFERENCE_COUNT_DECR_ENABLE = (371 , 371) # macro
NVC6C0_QMDV03_00_CWD_REFERENCE_COUNT_DECR_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_CWD_REFERENCE_COUNT_DECR_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_QMD_RESERVED11B = (377 , 372) # macro
NVC6C0_QMDV03_00_API_VISIBLE_CALL_LIMIT = (378 , 378) # macro
NVC6C0_QMDV03_00_API_VISIBLE_CALL_LIMIT__32 = 0x00000000 # macro
NVC6C0_QMDV03_00_API_VISIBLE_CALL_LIMIT_NO_CHECK = 0x00000001 # macro
NVC6C0_QMDV03_00_QMD_RESERVED11C = (381 , 379) # macro
NVC6C0_QMDV03_00_SAMPLER_INDEX = (382 , 382) # macro
NVC6C0_QMDV03_00_SAMPLER_INDEX_INDEPENDENTLY = 0x00000000 # macro
NVC6C0_QMDV03_00_SAMPLER_INDEX_VIA_HEADER_INDEX = 0x00000001 # macro
NVC6C0_QMDV03_00_DISABLE_AUTO_INVALIDATE = (383 , 383) # macro
NVC6C0_QMDV03_00_DISABLE_AUTO_INVALIDATE_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_DISABLE_AUTO_INVALIDATE_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_CTA_RASTER_WIDTH = (415 , 384) # macro
NVC6C0_QMDV03_00_CTA_RASTER_HEIGHT = (431 , 416) # macro
NVC6C0_QMDV03_00_CTA_RASTER_DEPTH = (463 , 448) # macro
NVC6C0_QMDV03_00_DEPENDENT_QMD0_POINTER = (511 , 480) # macro
NVC6C0_QMDV03_00_DEPENDENT_QMD0_ENABLE = (512 , 512) # macro
NVC6C0_QMDV03_00_DEPENDENT_QMD0_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_DEPENDENT_QMD0_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_DEPENDENT_QMD0_ACTION = (515 , 513) # macro
NVC6C0_QMDV03_00_DEPENDENT_QMD0_ACTION_QMD_INCREMENT_PUT = 0x00000000 # macro
NVC6C0_QMDV03_00_DEPENDENT_QMD0_ACTION_QMD_SCHEDULE = 0x00000001 # macro
NVC6C0_QMDV03_00_DEPENDENT_QMD0_ACTION_QMD_INVALIDATE_COPY_SCHEDULE = 0x00000003 # macro
NVC6C0_QMDV03_00_DEPENDENT_QMD0_ACTION_QMD_DECREMENT_DEPENDENCE = 0x00000004 # macro
NVC6C0_QMDV03_00_DEPENDENT_QMD0_PREFETCH = (516 , 516) # macro
NVC6C0_QMDV03_00_DEPENDENT_QMD0_PREFETCH_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_DEPENDENT_QMD0_PREFETCH_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_DEPENDENT_QMD1_ENABLE = (517 , 517) # macro
NVC6C0_QMDV03_00_DEPENDENT_QMD1_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_DEPENDENT_QMD1_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_DEPENDENT_QMD1_ACTION = (520 , 518) # macro
NVC6C0_QMDV03_00_DEPENDENT_QMD1_ACTION_QMD_INCREMENT_PUT = 0x00000000 # macro
NVC6C0_QMDV03_00_DEPENDENT_QMD1_ACTION_QMD_SCHEDULE = 0x00000001 # macro
NVC6C0_QMDV03_00_DEPENDENT_QMD1_ACTION_QMD_INVALIDATE_COPY_SCHEDULE = 0x00000003 # macro
NVC6C0_QMDV03_00_DEPENDENT_QMD1_ACTION_QMD_DECREMENT_DEPENDENCE = 0x00000004 # macro
NVC6C0_QMDV03_00_DEPENDENT_QMD1_PREFETCH = (521 , 521) # macro
NVC6C0_QMDV03_00_DEPENDENT_QMD1_PREFETCH_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_DEPENDENT_QMD1_PREFETCH_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_COALESCE_WAITING_PERIOD = (529 , 522) # macro
NVC6C0_QMDV03_00_QUEUE_ENTRIES_PER_CTA_LOG2 = (534 , 530) # macro
NVC6C0_QMDV03_00_SHARED_MEMORY_SIZE = (561 , 544) # macro
NVC6C0_QMDV03_00_MIN_SM_CONFIG_SHARED_MEM_SIZE = (567 , 562) # macro
NVC6C0_QMDV03_00_QMD_RESERVED17A = (568 , 568) # macro
NVC6C0_QMDV03_00_MAX_SM_CONFIG_SHARED_MEM_SIZE = (574 , 569) # macro
NVC6C0_QMDV03_00_QMD_RESERVED17B = (575 , 575) # macro
NVC6C0_QMDV03_00_QMD_VERSION = (579 , 576) # macro
NVC6C0_QMDV03_00_QMD_MAJOR_VERSION = (583 , 580) # macro
NVC6C0_QMDV03_00_CTA_THREAD_DIMENSION0 = (607 , 592) # macro
NVC6C0_QMDV03_00_CTA_THREAD_DIMENSION1 = (623 , 608) # macro
NVC6C0_QMDV03_00_CTA_THREAD_DIMENSION2 = (639 , 624) # macro
def NVC6C0_QMDV03_00_CONSTANT_BUFFER_VALID(i):  # macro
    return ((640+(i)*1) , (640+(i)*1))
NVC6C0_QMDV03_00_CONSTANT_BUFFER_VALID_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_CONSTANT_BUFFER_VALID_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_REGISTER_COUNT_V = (656 , 648) # macro
NVC6C0_QMDV03_00_TARGET_SM_CONFIG_SHARED_MEM_SIZE = (662 , 657) # macro
NVC6C0_QMDV03_00_SHARED_ALLOCATION_ENABLE = (663 , 663) # macro
NVC6C0_QMDV03_00_SHARED_ALLOCATION_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_SHARED_ALLOCATION_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_FREE_CTA_SLOTS_EMPTY_SM = (671 , 664) # macro
NVC6C0_QMDV03_00_SM_DISABLE_MASK_LOWER = (703 , 672) # macro
NVC6C0_QMDV03_00_SM_DISABLE_MASK_UPPER = (735 , 704) # macro
NVC6C0_QMDV03_00_SHADER_LOCAL_MEMORY_LOW_SIZE = (759 , 736) # macro
NVC6C0_QMDV03_00_BARRIER_COUNT = (767 , 763) # macro
NVC6C0_QMDV03_00_RELEASE0_ADDRESS_LOWER = (799 , 768) # macro
NVC6C0_QMDV03_00_RELEASE0_ADDRESS_UPPER = (807 , 800) # macro
NVC6C0_QMDV03_00_SEMAPHORE_RESERVED25A = (818 , 808) # macro
NVC6C0_QMDV03_00_RELEASE0_MEMBAR_TYPE = (819 , 819) # macro
NVC6C0_QMDV03_00_RELEASE0_MEMBAR_TYPE_FE_NONE = 0x00000000 # macro
NVC6C0_QMDV03_00_RELEASE0_MEMBAR_TYPE_FE_SYSMEMBAR = 0x00000001 # macro
NVC6C0_QMDV03_00_RELEASE0_REDUCTION_OP = (822 , 820) # macro
NVC6C0_QMDV03_00_RELEASE0_REDUCTION_OP_RED_ADD = 0x00000000 # macro
NVC6C0_QMDV03_00_RELEASE0_REDUCTION_OP_RED_MIN = 0x00000001 # macro
NVC6C0_QMDV03_00_RELEASE0_REDUCTION_OP_RED_MAX = 0x00000002 # macro
NVC6C0_QMDV03_00_RELEASE0_REDUCTION_OP_RED_INC = 0x00000003 # macro
NVC6C0_QMDV03_00_RELEASE0_REDUCTION_OP_RED_DEC = 0x00000004 # macro
NVC6C0_QMDV03_00_RELEASE0_REDUCTION_OP_RED_AND = 0x00000005 # macro
NVC6C0_QMDV03_00_RELEASE0_REDUCTION_OP_RED_OR = 0x00000006 # macro
NVC6C0_QMDV03_00_RELEASE0_REDUCTION_OP_RED_XOR = 0x00000007 # macro
NVC6C0_QMDV03_00_RELEASE0_ENABLE = (823 , 823) # macro
NVC6C0_QMDV03_00_RELEASE0_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_RELEASE0_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_RELEASE0_REDUCTION_FORMAT = (825 , 824) # macro
NVC6C0_QMDV03_00_RELEASE0_REDUCTION_FORMAT_UNSIGNED_32 = 0x00000000 # macro
NVC6C0_QMDV03_00_RELEASE0_REDUCTION_FORMAT_SIGNED_32 = 0x00000001 # macro
NVC6C0_QMDV03_00_RELEASE0_REDUCTION_ENABLE = (826 , 826) # macro
NVC6C0_QMDV03_00_RELEASE0_REDUCTION_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_RELEASE0_REDUCTION_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_RELEASE0_NON_BLOCKING_INTR_TYPE = (828 , 827) # macro
NVC6C0_QMDV03_00_RELEASE0_NON_BLOCKING_INTR_TYPE_NONE = 0x00000000 # macro
NVC6C0_QMDV03_00_RELEASE0_NON_BLOCKING_INTR_TYPE_TRAP = 0x00000001 # macro
NVC6C0_QMDV03_00_RELEASE0_NON_BLOCKING_INTR_TYPE_CONDITIONAL_TRAP = 0x00000002 # macro
NVC6C0_QMDV03_00_RELEASE0_PAYLOAD64B = (829 , 829) # macro
NVC6C0_QMDV03_00_RELEASE0_PAYLOAD64B_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_RELEASE0_PAYLOAD64B_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_RELEASE0_STRUCTURE_SIZE = (831 , 830) # macro
NVC6C0_QMDV03_00_RELEASE0_STRUCTURE_SIZE_SEMAPHORE_FOUR_WORDS = 0x00000000 # macro
NVC6C0_QMDV03_00_RELEASE0_STRUCTURE_SIZE_SEMAPHORE_ONE_WORD = 0x00000001 # macro
NVC6C0_QMDV03_00_RELEASE0_STRUCTURE_SIZE_SEMAPHORE_TWO_WORDS = 0x00000002 # macro
NVC6C0_QMDV03_00_RELEASE0_PAYLOAD_LOWER = (863 , 832) # macro
NVC6C0_QMDV03_00_RELEASE0_PAYLOAD_UPPER = (895 , 864) # macro
NVC6C0_QMDV03_00_RELEASE1_ADDRESS_LOWER = (927 , 896) # macro
NVC6C0_QMDV03_00_RELEASE1_ADDRESS_UPPER = (935 , 928) # macro
NVC6C0_QMDV03_00_SEMAPHORE_RESERVED29A = (946 , 936) # macro
NVC6C0_QMDV03_00_RELEASE1_MEMBAR_TYPE = (947 , 947) # macro
NVC6C0_QMDV03_00_RELEASE1_MEMBAR_TYPE_FE_NONE = 0x00000000 # macro
NVC6C0_QMDV03_00_RELEASE1_MEMBAR_TYPE_FE_SYSMEMBAR = 0x00000001 # macro
NVC6C0_QMDV03_00_RELEASE1_REDUCTION_OP = (950 , 948) # macro
NVC6C0_QMDV03_00_RELEASE1_REDUCTION_OP_RED_ADD = 0x00000000 # macro
NVC6C0_QMDV03_00_RELEASE1_REDUCTION_OP_RED_MIN = 0x00000001 # macro
NVC6C0_QMDV03_00_RELEASE1_REDUCTION_OP_RED_MAX = 0x00000002 # macro
NVC6C0_QMDV03_00_RELEASE1_REDUCTION_OP_RED_INC = 0x00000003 # macro
NVC6C0_QMDV03_00_RELEASE1_REDUCTION_OP_RED_DEC = 0x00000004 # macro
NVC6C0_QMDV03_00_RELEASE1_REDUCTION_OP_RED_AND = 0x00000005 # macro
NVC6C0_QMDV03_00_RELEASE1_REDUCTION_OP_RED_OR = 0x00000006 # macro
NVC6C0_QMDV03_00_RELEASE1_REDUCTION_OP_RED_XOR = 0x00000007 # macro
NVC6C0_QMDV03_00_RELEASE1_ENABLE = (951 , 951) # macro
NVC6C0_QMDV03_00_RELEASE1_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_RELEASE1_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_RELEASE1_REDUCTION_FORMAT = (953 , 952) # macro
NVC6C0_QMDV03_00_RELEASE1_REDUCTION_FORMAT_UNSIGNED_32 = 0x00000000 # macro
NVC6C0_QMDV03_00_RELEASE1_REDUCTION_FORMAT_SIGNED_32 = 0x00000001 # macro
NVC6C0_QMDV03_00_RELEASE1_REDUCTION_ENABLE = (954 , 954) # macro
NVC6C0_QMDV03_00_RELEASE1_REDUCTION_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_RELEASE1_REDUCTION_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_RELEASE1_NON_BLOCKING_INTR_TYPE = (956 , 955) # macro
NVC6C0_QMDV03_00_RELEASE1_NON_BLOCKING_INTR_TYPE_NONE = 0x00000000 # macro
NVC6C0_QMDV03_00_RELEASE1_NON_BLOCKING_INTR_TYPE_TRAP = 0x00000001 # macro
NVC6C0_QMDV03_00_RELEASE1_NON_BLOCKING_INTR_TYPE_CONDITIONAL_TRAP = 0x00000002 # macro
NVC6C0_QMDV03_00_RELEASE1_PAYLOAD64B = (957 , 957) # macro
NVC6C0_QMDV03_00_RELEASE1_PAYLOAD64B_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_RELEASE1_PAYLOAD64B_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_RELEASE1_STRUCTURE_SIZE = (959 , 958) # macro
NVC6C0_QMDV03_00_RELEASE1_STRUCTURE_SIZE_SEMAPHORE_FOUR_WORDS = 0x00000000 # macro
NVC6C0_QMDV03_00_RELEASE1_STRUCTURE_SIZE_SEMAPHORE_ONE_WORD = 0x00000001 # macro
NVC6C0_QMDV03_00_RELEASE1_STRUCTURE_SIZE_SEMAPHORE_TWO_WORDS = 0x00000002 # macro
NVC6C0_QMDV03_00_RELEASE1_PAYLOAD_LOWER = (991 , 960) # macro
NVC6C0_QMDV03_00_RELEASE1_PAYLOAD_UPPER = (1023 , 992) # macro
def NVC6C0_QMDV03_00_CONSTANT_BUFFER_ADDR_LOWER(i):  # macro
    return ((1055+(i)*64) , (1024+(i)*64))
def NVC6C0_QMDV03_00_CONSTANT_BUFFER_ADDR_UPPER(i):  # macro
    return ((1072+(i)*64) , (1056+(i)*64))
def NVC6C0_QMDV03_00_CONSTANT_BUFFER_PREFETCH_POST(i):  # macro
    return ((1073+(i)*64) , (1073+(i)*64))
NVC6C0_QMDV03_00_CONSTANT_BUFFER_PREFETCH_POST_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_CONSTANT_BUFFER_PREFETCH_POST_TRUE = 0x00000001 # macro
def NVC6C0_QMDV03_00_CONSTANT_BUFFER_INVALIDATE(i):  # macro
    return ((1074+(i)*64) , (1074+(i)*64))
NVC6C0_QMDV03_00_CONSTANT_BUFFER_INVALIDATE_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_CONSTANT_BUFFER_INVALIDATE_TRUE = 0x00000001 # macro
def NVC6C0_QMDV03_00_CONSTANT_BUFFER_SIZE_SHIFTED4(i):  # macro
    return ((1087+(i)*64) , (1075+(i)*64))
NVC6C0_QMDV03_00_PROGRAM_ADDRESS_LOWER = (1567 , 1536) # macro
NVC6C0_QMDV03_00_PROGRAM_ADDRESS_UPPER = (1584 , 1568) # macro
NVC6C0_QMDV03_00_SHADER_LOCAL_MEMORY_HIGH_SIZE = (1623 , 1600) # macro
NVC6C0_QMDV03_00_PROGRAM_PREFETCH_ADDR_UPPER_SHIFTED = (1640 , 1632) # macro
NVC6C0_QMDV03_00_PROGRAM_PREFETCH_SIZE = (1649 , 1641) # macro
NVC6C0_QMDV03_00_PROGRAM_PREFETCH_TYPE = (1651 , 1650) # macro
NVC6C0_QMDV03_00_PROGRAM_PREFETCH_TYPE_PREFETCH_LAUNCH = 0x00000000 # macro
NVC6C0_QMDV03_00_PROGRAM_PREFETCH_TYPE_PREFTECH_POST = 0x00000001 # macro
NVC6C0_QMDV03_00_SASS_VERSION = (1663 , 1656) # macro
NVC6C0_QMDV03_00_RELEASE2_ADDRESS_LOWER = (1695 , 1664) # macro
NVC6C0_QMDV03_00_RELEASE2_ADDRESS_UPPER = (1703 , 1696) # macro
NVC6C0_QMDV03_00_SEMAPHORE_RESERVED53A = (1714 , 1704) # macro
NVC6C0_QMDV03_00_RELEASE2_MEMBAR_TYPE = (1715 , 1715) # macro
NVC6C0_QMDV03_00_RELEASE2_MEMBAR_TYPE_FE_NONE = 0x00000000 # macro
NVC6C0_QMDV03_00_RELEASE2_MEMBAR_TYPE_FE_SYSMEMBAR = 0x00000001 # macro
NVC6C0_QMDV03_00_RELEASE2_REDUCTION_OP = (1718 , 1716) # macro
NVC6C0_QMDV03_00_RELEASE2_REDUCTION_OP_RED_ADD = 0x00000000 # macro
NVC6C0_QMDV03_00_RELEASE2_REDUCTION_OP_RED_MIN = 0x00000001 # macro
NVC6C0_QMDV03_00_RELEASE2_REDUCTION_OP_RED_MAX = 0x00000002 # macro
NVC6C0_QMDV03_00_RELEASE2_REDUCTION_OP_RED_INC = 0x00000003 # macro
NVC6C0_QMDV03_00_RELEASE2_REDUCTION_OP_RED_DEC = 0x00000004 # macro
NVC6C0_QMDV03_00_RELEASE2_REDUCTION_OP_RED_AND = 0x00000005 # macro
NVC6C0_QMDV03_00_RELEASE2_REDUCTION_OP_RED_OR = 0x00000006 # macro
NVC6C0_QMDV03_00_RELEASE2_REDUCTION_OP_RED_XOR = 0x00000007 # macro
NVC6C0_QMDV03_00_RELEASE2_ENABLE = (1719 , 1719) # macro
NVC6C0_QMDV03_00_RELEASE2_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_RELEASE2_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_RELEASE2_REDUCTION_FORMAT = (1721 , 1720) # macro
NVC6C0_QMDV03_00_RELEASE2_REDUCTION_FORMAT_UNSIGNED_32 = 0x00000000 # macro
NVC6C0_QMDV03_00_RELEASE2_REDUCTION_FORMAT_SIGNED_32 = 0x00000001 # macro
NVC6C0_QMDV03_00_RELEASE2_REDUCTION_ENABLE = (1722 , 1722) # macro
NVC6C0_QMDV03_00_RELEASE2_REDUCTION_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_RELEASE2_REDUCTION_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_RELEASE2_NON_BLOCKING_INTR_TYPE = (1724 , 1723) # macro
NVC6C0_QMDV03_00_RELEASE2_NON_BLOCKING_INTR_TYPE_NONE = 0x00000000 # macro
NVC6C0_QMDV03_00_RELEASE2_NON_BLOCKING_INTR_TYPE_TRAP = 0x00000001 # macro
NVC6C0_QMDV03_00_RELEASE2_NON_BLOCKING_INTR_TYPE_CONDITIONAL_TRAP = 0x00000002 # macro
NVC6C0_QMDV03_00_RELEASE2_PAYLOAD64B = (1725 , 1725) # macro
NVC6C0_QMDV03_00_RELEASE2_PAYLOAD64B_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_RELEASE2_PAYLOAD64B_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_RELEASE2_STRUCTURE_SIZE = (1727 , 1726) # macro
NVC6C0_QMDV03_00_RELEASE2_STRUCTURE_SIZE_SEMAPHORE_FOUR_WORDS = 0x00000000 # macro
NVC6C0_QMDV03_00_RELEASE2_STRUCTURE_SIZE_SEMAPHORE_ONE_WORD = 0x00000001 # macro
NVC6C0_QMDV03_00_RELEASE2_STRUCTURE_SIZE_SEMAPHORE_TWO_WORDS = 0x00000002 # macro
NVC6C0_QMDV03_00_RELEASE2_PAYLOAD_LOWER = (1759 , 1728) # macro
NVC6C0_QMDV03_00_RELEASE2_PAYLOAD_UPPER = (1791 , 1760) # macro
NVC6C0_QMDV03_00_QMD_SPARE_I = (1823 , 1792) # macro
NVC6C0_QMDV03_00_HW_ONLY_INNER_GET = (1854 , 1824) # macro
NVC6C0_QMDV03_00_HW_ONLY_REQUIRE_SCHEDULING_PCAS = (1855 , 1855) # macro
NVC6C0_QMDV03_00_HW_ONLY_INNER_PUT = (1886 , 1856) # macro
NVC6C0_QMDV03_00_HW_ONLY_SPAN_LIST_HEAD_INDEX = (1917 , 1888) # macro
NVC6C0_QMDV03_00_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID = (1919 , 1919) # macro
NVC6C0_QMDV03_00_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID_FALSE = 0x00000000 # macro
NVC6C0_QMDV03_00_HW_ONLY_SPAN_LIST_HEAD_INDEX_VALID_TRUE = 0x00000001 # macro
NVC6C0_QMDV03_00_HW_ONLY_SKED_NEXT_QMD_POINTER = (1951 , 1920) # macro
NVC6C0_QMDV03_00_HW_ONLY_DEPENDENCE_COUNTER = (1958 , 1952) # macro
NVC6C0_QMDV03_00_DEBUG_ID_UPPER = (2015 , 1984) # macro
NVC6C0_QMDV03_00_DEBUG_ID_LOWER = (2047 , 2016) # macro
NV01_DEVICE_0 = (0x00000080) # macro
# NV0080_MAX_DEVICES = NV_MAX_DEVICES # macro
NV0080_ALLOC_PARAMETERS_MESSAGE_ID = (0x0080) # macro
class struct_NV0080_ALLOC_PARAMETERS(Structure):
    pass

struct_NV0080_ALLOC_PARAMETERS._pack_ = 1 # source:False
struct_NV0080_ALLOC_PARAMETERS._fields_ = [
    ('deviceId', ctypes.c_uint32),
    ('hClientShare', ctypes.c_uint32),
    ('hTargetClient', ctypes.c_uint32),
    ('hTargetDevice', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('vaSpaceSize', ctypes.c_uint64),
    ('vaStartInternal', ctypes.c_uint64),
    ('vaLimitInternal', ctypes.c_uint64),
    ('vaMode', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

NV0080_ALLOC_PARAMETERS = struct_NV0080_ALLOC_PARAMETERS
_cl2080_notification_h_ = True # macro
NV2080_NOTIFIERS_SW = (0) # macro
NV2080_NOTIFIERS_HOTPLUG = (1) # macro
NV2080_NOTIFIERS_POWER_CONNECTOR = (2) # macro
NV2080_NOTIFIERS_THERMAL_SW = (3) # macro
NV2080_NOTIFIERS_THERMAL_HW = (4) # macro
NV2080_NOTIFIERS_FULL_SCREEN_CHANGE = (5) # macro
NV2080_NOTIFIERS_EVENTBUFFER = (6) # macro
NV2080_NOTIFIERS_DP_IRQ = (7) # macro
NV2080_NOTIFIERS_GR_DEBUG_INTR = (8) # macro
NV2080_NOTIFIERS_PMU_EVENT = (9) # macro
NV2080_NOTIFIERS_PMU_COMMAND = (10) # macro
NV2080_NOTIFIERS_TIMER = (11) # macro
NV2080_NOTIFIERS_GRAPHICS = (12) # macro
NV2080_NOTIFIERS_PPP = (13) # macro
NV2080_NOTIFIERS_VLD = (14) # macro
NV2080_NOTIFIERS_NVDEC0 = (14) # macro
NV2080_NOTIFIERS_NVDEC1 = (15) # macro
NV2080_NOTIFIERS_NVDEC2 = (16) # macro
NV2080_NOTIFIERS_NVDEC3 = (17) # macro
NV2080_NOTIFIERS_NVDEC4 = (18) # macro
NV2080_NOTIFIERS_NVDEC5 = (19) # macro
NV2080_NOTIFIERS_NVDEC6 = (20) # macro
NV2080_NOTIFIERS_NVDEC7 = (21) # macro
NV2080_NOTIFIERS_PDEC = (22) # macro
NV2080_NOTIFIERS_CE0 = (23) # macro
NV2080_NOTIFIERS_CE1 = (24) # macro
NV2080_NOTIFIERS_CE2 = (25) # macro
NV2080_NOTIFIERS_CE3 = (26) # macro
NV2080_NOTIFIERS_CE4 = (27) # macro
NV2080_NOTIFIERS_CE5 = (28) # macro
NV2080_NOTIFIERS_CE6 = (29) # macro
NV2080_NOTIFIERS_CE7 = (30) # macro
NV2080_NOTIFIERS_CE8 = (31) # macro
NV2080_NOTIFIERS_CE9 = (32) # macro
NV2080_NOTIFIERS_PSTATE_CHANGE = (33) # macro
NV2080_NOTIFIERS_HDCP_STATUS_CHANGE = (34) # macro
NV2080_NOTIFIERS_FIFO_EVENT_MTHD = (35) # macro
NV2080_NOTIFIERS_PRIV_RING_HANG = (36) # macro
NV2080_NOTIFIERS_RC_ERROR = (37) # macro
NV2080_NOTIFIERS_MSENC = (38) # macro
NV2080_NOTIFIERS_NVENC0 = (38) # macro
NV2080_NOTIFIERS_NVENC1 = (39) # macro
NV2080_NOTIFIERS_NVENC2 = (40) # macro
NV2080_NOTIFIERS_UNUSED_0 = (41) # macro
NV2080_NOTIFIERS_ACPI_NOTIFY = (42) # macro
NV2080_NOTIFIERS_COOLER_DIAG_ZONE = (43) # macro
NV2080_NOTIFIERS_THERMAL_DIAG_ZONE = (44) # macro
NV2080_NOTIFIERS_AUDIO_HDCP_REQUEST = (45) # macro
NV2080_NOTIFIERS_WORKLOAD_MODULATION_CHANGE = (46) # macro
NV2080_NOTIFIERS_GPIO_0_RISING_INTERRUPT = (47) # macro
NV2080_NOTIFIERS_GPIO_1_RISING_INTERRUPT = (48) # macro
NV2080_NOTIFIERS_GPIO_2_RISING_INTERRUPT = (49) # macro
NV2080_NOTIFIERS_GPIO_3_RISING_INTERRUPT = (50) # macro
NV2080_NOTIFIERS_GPIO_4_RISING_INTERRUPT = (51) # macro
NV2080_NOTIFIERS_GPIO_5_RISING_INTERRUPT = (52) # macro
NV2080_NOTIFIERS_GPIO_6_RISING_INTERRUPT = (53) # macro
NV2080_NOTIFIERS_GPIO_7_RISING_INTERRUPT = (54) # macro
NV2080_NOTIFIERS_GPIO_8_RISING_INTERRUPT = (55) # macro
NV2080_NOTIFIERS_GPIO_9_RISING_INTERRUPT = (56) # macro
NV2080_NOTIFIERS_GPIO_10_RISING_INTERRUPT = (57) # macro
NV2080_NOTIFIERS_GPIO_11_RISING_INTERRUPT = (58) # macro
NV2080_NOTIFIERS_GPIO_12_RISING_INTERRUPT = (59) # macro
NV2080_NOTIFIERS_GPIO_13_RISING_INTERRUPT = (60) # macro
NV2080_NOTIFIERS_GPIO_14_RISING_INTERRUPT = (61) # macro
NV2080_NOTIFIERS_GPIO_15_RISING_INTERRUPT = (62) # macro
NV2080_NOTIFIERS_GPIO_16_RISING_INTERRUPT = (63) # macro
NV2080_NOTIFIERS_GPIO_17_RISING_INTERRUPT = (64) # macro
NV2080_NOTIFIERS_GPIO_18_RISING_INTERRUPT = (65) # macro
NV2080_NOTIFIERS_GPIO_19_RISING_INTERRUPT = (66) # macro
NV2080_NOTIFIERS_GPIO_20_RISING_INTERRUPT = (67) # macro
NV2080_NOTIFIERS_GPIO_21_RISING_INTERRUPT = (68) # macro
NV2080_NOTIFIERS_GPIO_22_RISING_INTERRUPT = (69) # macro
NV2080_NOTIFIERS_GPIO_23_RISING_INTERRUPT = (70) # macro
NV2080_NOTIFIERS_GPIO_24_RISING_INTERRUPT = (71) # macro
NV2080_NOTIFIERS_GPIO_25_RISING_INTERRUPT = (72) # macro
NV2080_NOTIFIERS_GPIO_26_RISING_INTERRUPT = (73) # macro
NV2080_NOTIFIERS_GPIO_27_RISING_INTERRUPT = (74) # macro
NV2080_NOTIFIERS_GPIO_28_RISING_INTERRUPT = (75) # macro
NV2080_NOTIFIERS_GPIO_29_RISING_INTERRUPT = (76) # macro
NV2080_NOTIFIERS_GPIO_30_RISING_INTERRUPT = (77) # macro
NV2080_NOTIFIERS_GPIO_31_RISING_INTERRUPT = (78) # macro
NV2080_NOTIFIERS_GPIO_0_FALLING_INTERRUPT = (79) # macro
NV2080_NOTIFIERS_GPIO_1_FALLING_INTERRUPT = (80) # macro
NV2080_NOTIFIERS_GPIO_2_FALLING_INTERRUPT = (81) # macro
NV2080_NOTIFIERS_GPIO_3_FALLING_INTERRUPT = (82) # macro
NV2080_NOTIFIERS_GPIO_4_FALLING_INTERRUPT = (83) # macro
NV2080_NOTIFIERS_GPIO_5_FALLING_INTERRUPT = (84) # macro
NV2080_NOTIFIERS_GPIO_6_FALLING_INTERRUPT = (85) # macro
NV2080_NOTIFIERS_GPIO_7_FALLING_INTERRUPT = (86) # macro
NV2080_NOTIFIERS_GPIO_8_FALLING_INTERRUPT = (87) # macro
NV2080_NOTIFIERS_GPIO_9_FALLING_INTERRUPT = (88) # macro
NV2080_NOTIFIERS_GPIO_10_FALLING_INTERRUPT = (89) # macro
NV2080_NOTIFIERS_GPIO_11_FALLING_INTERRUPT = (90) # macro
NV2080_NOTIFIERS_GPIO_12_FALLING_INTERRUPT = (91) # macro
NV2080_NOTIFIERS_GPIO_13_FALLING_INTERRUPT = (92) # macro
NV2080_NOTIFIERS_GPIO_14_FALLING_INTERRUPT = (93) # macro
NV2080_NOTIFIERS_GPIO_15_FALLING_INTERRUPT = (94) # macro
NV2080_NOTIFIERS_GPIO_16_FALLING_INTERRUPT = (95) # macro
NV2080_NOTIFIERS_GPIO_17_FALLING_INTERRUPT = (96) # macro
NV2080_NOTIFIERS_GPIO_18_FALLING_INTERRUPT = (97) # macro
NV2080_NOTIFIERS_GPIO_19_FALLING_INTERRUPT = (98) # macro
NV2080_NOTIFIERS_GPIO_20_FALLING_INTERRUPT = (99) # macro
NV2080_NOTIFIERS_GPIO_21_FALLING_INTERRUPT = (100) # macro
NV2080_NOTIFIERS_GPIO_22_FALLING_INTERRUPT = (101) # macro
NV2080_NOTIFIERS_GPIO_23_FALLING_INTERRUPT = (102) # macro
NV2080_NOTIFIERS_GPIO_24_FALLING_INTERRUPT = (103) # macro
NV2080_NOTIFIERS_GPIO_25_FALLING_INTERRUPT = (104) # macro
NV2080_NOTIFIERS_GPIO_26_FALLING_INTERRUPT = (105) # macro
NV2080_NOTIFIERS_GPIO_27_FALLING_INTERRUPT = (106) # macro
NV2080_NOTIFIERS_GPIO_28_FALLING_INTERRUPT = (107) # macro
NV2080_NOTIFIERS_GPIO_29_FALLING_INTERRUPT = (108) # macro
NV2080_NOTIFIERS_GPIO_30_FALLING_INTERRUPT = (109) # macro
NV2080_NOTIFIERS_GPIO_31_FALLING_INTERRUPT = (110) # macro
NV2080_NOTIFIERS_ECC_SBE = (111) # macro
NV2080_NOTIFIERS_ECC_DBE = (112) # macro
NV2080_NOTIFIERS_STEREO_EMITTER_DETECTION = (113) # macro
NV2080_NOTIFIERS_GC5_GPU_READY = (114) # macro
NV2080_NOTIFIERS_SEC2 = (115) # macro
NV2080_NOTIFIERS_GC6_REFCOUNT_INC = (116) # macro
NV2080_NOTIFIERS_GC6_REFCOUNT_DEC = (117) # macro
NV2080_NOTIFIERS_POWER_EVENT = (118) # macro
NV2080_NOTIFIERS_CLOCKS_CHANGE = (119) # macro
NV2080_NOTIFIERS_HOTPLUG_PROCESSING_COMPLETE = (120) # macro
NV2080_NOTIFIERS_PHYSICAL_PAGE_FAULT = (121) # macro
NV2080_NOTIFIERS_RESERVED122 = (122) # macro
NV2080_NOTIFIERS_NVLINK_ERROR_FATAL = (123) # macro
NV2080_NOTIFIERS_PRIV_REG_ACCESS_FAULT = (124) # macro
NV2080_NOTIFIERS_NVLINK_ERROR_RECOVERY_REQUIRED = (125) # macro
NV2080_NOTIFIERS_NVJPG = (126) # macro
NV2080_NOTIFIERS_NVJPEG0 = (126) # macro
NV2080_NOTIFIERS_NVJPEG1 = (127) # macro
NV2080_NOTIFIERS_NVJPEG2 = (128) # macro
NV2080_NOTIFIERS_NVJPEG3 = (129) # macro
NV2080_NOTIFIERS_NVJPEG4 = (130) # macro
NV2080_NOTIFIERS_NVJPEG5 = (131) # macro
NV2080_NOTIFIERS_NVJPEG6 = (132) # macro
NV2080_NOTIFIERS_NVJPEG7 = (133) # macro
NV2080_NOTIFIERS_RUNLIST_AND_ENG_IDLE = (134) # macro
NV2080_NOTIFIERS_RUNLIST_ACQUIRE = (135) # macro
NV2080_NOTIFIERS_RUNLIST_ACQUIRE_AND_ENG_IDLE = (136) # macro
NV2080_NOTIFIERS_RUNLIST_IDLE = (137) # macro
NV2080_NOTIFIERS_TSG_PREEMPT_COMPLETE = (138) # macro
NV2080_NOTIFIERS_RUNLIST_PREEMPT_COMPLETE = (139) # macro
NV2080_NOTIFIERS_CTXSW_TIMEOUT = (140) # macro
NV2080_NOTIFIERS_INFOROM_ECC_OBJECT_UPDATED = (141) # macro
NV2080_NOTIFIERS_NVTELEMETRY_REPORT_EVENT = (142) # macro
NV2080_NOTIFIERS_DSTATE_XUSB_PPC = (143) # macro
NV2080_NOTIFIERS_FECS_CTX_SWITCH = (144) # macro
NV2080_NOTIFIERS_XUSB_PPC_CONNECTED = (145) # macro
NV2080_NOTIFIERS_GR0 = (12) # macro
NV2080_NOTIFIERS_GR1 = (146) # macro
NV2080_NOTIFIERS_GR2 = (147) # macro
NV2080_NOTIFIERS_GR3 = (148) # macro
NV2080_NOTIFIERS_GR4 = (149) # macro
NV2080_NOTIFIERS_GR5 = (150) # macro
NV2080_NOTIFIERS_GR6 = (151) # macro
NV2080_NOTIFIERS_GR7 = (152) # macro
NV2080_NOTIFIERS_OFA = (153) # macro
NV2080_NOTIFIERS_OFA0 = (153) # macro
NV2080_NOTIFIERS_DSTATE_HDA = (154) # macro
NV2080_NOTIFIERS_POISON_ERROR_NON_FATAL = (155) # macro
NV2080_NOTIFIERS_POISON_ERROR_FATAL = (156) # macro
NV2080_NOTIFIERS_UCODE_RESET = (157) # macro
NV2080_NOTIFIERS_PLATFORM_POWER_MODE_CHANGE = (158) # macro
NV2080_NOTIFIERS_SMC_CONFIG_UPDATE = (159) # macro
NV2080_NOTIFIERS_INFOROM_RRL_OBJECT_UPDATED = (160) # macro
NV2080_NOTIFIERS_INFOROM_PBL_OBJECT_UPDATED = (161) # macro
NV2080_NOTIFIERS_LPWR_DIFR_PREFETCH_REQUEST = (162) # macro
NV2080_NOTIFIERS_SEC_FAULT_ERROR = (163) # macro
NV2080_NOTIFIERS_POSSIBLE_ERROR = (164) # macro
NV2080_NOTIFIERS_NVLINK_INFO_LINK_UP = (165) # macro
NV2080_NOTIFIERS_RESERVED166 = (166) # macro
NV2080_NOTIFIERS_RESERVED167 = (167) # macro
NV2080_NOTIFIERS_RESERVED168 = (168) # macro
NV2080_NOTIFIERS_RESERVED169 = (169) # macro
NV2080_NOTIFIERS_RESERVED170 = (170) # macro
NV2080_NOTIFIERS_RESERVED171 = (171) # macro
NV2080_NOTIFIERS_RESERVED172 = (172) # macro
NV2080_NOTIFIERS_RESERVED173 = (173) # macro
NV2080_NOTIFIERS_RESERVED174 = (174) # macro
NV2080_NOTIFIERS_RESERVED175 = (175) # macro
NV2080_NOTIFIERS_NVLINK_INFO_LINK_DOWN = (176) # macro
NV2080_NOTIFIERS_NVPCF_EVENTS = (177) # macro
NV2080_NOTIFIERS_HDMI_FRL_RETRAINING_REQUEST = (178) # macro
NV2080_NOTIFIERS_VRR_SET_TIMEOUT = (179) # macro
NV2080_NOTIFIERS_RESERVED180 = (180) # macro
NV2080_NOTIFIERS_AUX_POWER_EVENT = (181) # macro
NV2080_NOTIFIERS_AUX_POWER_STATE_CHANGE = (182) # macro
NV2080_NOTIFIERS_RESERVED_183 = (183) # macro
NV2080_NOTIFIERS_GSP_PERF_TRACE = (184) # macro
NV2080_NOTIFIERS_INBAND_RESPONSE = (185) # macro
NV2080_NOTIFIERS_RESERVED_186 = (186) # macro
NV2080_NOTIFIERS_MAXCOUNT = (187) # macro
# def NV2080_NOTIFIERS_GR(x):  # macro
#    return ((x==0)?((12)):((146)+(x-1)))
# def NV2080_NOTIFIERS_GR_IDX(x):  # macro
#    return ((x)-(12))
# def NV2080_NOTIFIER_TYPE_IS_GR(x):  # macro
#    return (((x)==(12))||(((x)>=(146))&&((x)<=(152))))
# def NV2080_NOTIFIERS_CE(x):  # macro
#    return ((23)+(x))
# def NV2080_NOTIFIERS_CE_IDX(x):  # macro
#    return ((x)-(23))
# def NV2080_NOTIFIER_TYPE_IS_CE(x):  # macro
#    return (((x)>=(23))&&((x)<=(32)))
# def NV2080_NOTIFIERS_NVENC(x):  # macro
#    return ((38)+(x))
# def NV2080_NOTIFIERS_NVENC_IDX(x):  # macro
#    return ((x)-(38))
# def NV2080_NOTIFIER_TYPE_IS_NVENC(x):  # macro
#    return (((x)>=(38))&&((x)<=(40)))
# def NV2080_NOTIFIERS_NVDEC(x):  # macro
#    return ((14)+(x))
# def NV2080_NOTIFIERS_NVDEC_IDX(x):  # macro
#    return ((x)-(14))
# def NV2080_NOTIFIER_TYPE_IS_NVDEC(x):  # macro
#    return (((x)>=(14))&&((x)<=(21)))
# def NV2080_NOTIFIERS_NVJPEG(x):  # macro
#    return ((126)+(x))
# def NV2080_NOTIFIERS_NVJPEG_IDX(x):  # macro
#    return ((x)-(126))
# def NV2080_NOTIFIER_TYPE_IS_NVJPEG(x):  # macro
#    return (((x)>=(126))&&((x)<=(133)))
# def NV2080_NOTIFIERS_OFAn(x):  # macro
#    return ((x==0)?((153)):((187)))
# def NV2080_NOTIFIERS_OFA_IDX(x):  # macro
#    return ((x==(153))?(0):(-1))
# def NV2080_NOTIFIER_TYPE_IS_OFA(x):  # macro
#    return (((x)==(153)))
# def NV2080_NOTIFIERS_GPIO_RISING_INTERRUPT(pin):  # macro
#    return ((47)+(pin))
# def NV2080_NOTIFIERS_GPIO_FALLING_INTERRUPT(pin):  # macro
#    return ((79)+(pin))
NV2080_SUBDEVICE_NOTIFICATION_STATUS_IN_PROGRESS = (0x8000) # macro
NV2080_SUBDEVICE_NOTIFICATION_STATUS_BAD_ARGUMENT = (0x4000) # macro
NV2080_SUBDEVICE_NOTIFICATION_STATUS_ERROR_INVALID_STATE = (0x2000) # macro
NV2080_SUBDEVICE_NOTIFICATION_STATUS_ERROR_STATE_IN_USE = (0x1000) # macro
NV2080_SUBDEVICE_NOTIFICATION_STATUS_DONE_SUCCESS = (0x0000) # macro
NV2080_ENGINE_TYPE_NULL = (0x00000000) # macro
NV2080_ENGINE_TYPE_GRAPHICS = (0x00000001) # macro
NV2080_ENGINE_TYPE_GR0 = (0x00000001) # macro
NV2080_ENGINE_TYPE_GR1 = (0x00000002) # macro
NV2080_ENGINE_TYPE_GR2 = (0x00000003) # macro
NV2080_ENGINE_TYPE_GR3 = (0x00000004) # macro
NV2080_ENGINE_TYPE_GR4 = (0x00000005) # macro
NV2080_ENGINE_TYPE_GR5 = (0x00000006) # macro
NV2080_ENGINE_TYPE_GR6 = (0x00000007) # macro
NV2080_ENGINE_TYPE_GR7 = (0x00000008) # macro
NV2080_ENGINE_TYPE_COPY0 = (0x00000009) # macro
NV2080_ENGINE_TYPE_COPY1 = (0x0000000a) # macro
NV2080_ENGINE_TYPE_COPY2 = (0x0000000b) # macro
NV2080_ENGINE_TYPE_COPY3 = (0x0000000c) # macro
NV2080_ENGINE_TYPE_COPY4 = (0x0000000d) # macro
NV2080_ENGINE_TYPE_COPY5 = (0x0000000e) # macro
NV2080_ENGINE_TYPE_COPY6 = (0x0000000f) # macro
NV2080_ENGINE_TYPE_COPY7 = (0x00000010) # macro
NV2080_ENGINE_TYPE_COPY8 = (0x00000011) # macro
NV2080_ENGINE_TYPE_COPY9 = (0x00000012) # macro
NV2080_ENGINE_TYPE_BSP = (0x00000013) # macro
NV2080_ENGINE_TYPE_NVDEC0 = (0x00000013) # macro
NV2080_ENGINE_TYPE_NVDEC1 = (0x00000014) # macro
NV2080_ENGINE_TYPE_NVDEC2 = (0x00000015) # macro
NV2080_ENGINE_TYPE_NVDEC3 = (0x00000016) # macro
NV2080_ENGINE_TYPE_NVDEC4 = (0x00000017) # macro
NV2080_ENGINE_TYPE_NVDEC5 = (0x00000018) # macro
NV2080_ENGINE_TYPE_NVDEC6 = (0x00000019) # macro
NV2080_ENGINE_TYPE_NVDEC7 = (0x0000001a) # macro
NV2080_ENGINE_TYPE_MSENC = (0x0000001b) # macro
NV2080_ENGINE_TYPE_NVENC0 = (0x0000001b) # macro
NV2080_ENGINE_TYPE_NVENC1 = (0x0000001c) # macro
NV2080_ENGINE_TYPE_NVENC2 = (0x0000001d) # macro
NV2080_ENGINE_TYPE_VP = (0x0000001e) # macro
NV2080_ENGINE_TYPE_ME = (0x0000001f) # macro
NV2080_ENGINE_TYPE_PPP = (0x00000020) # macro
NV2080_ENGINE_TYPE_MPEG = (0x00000021) # macro
NV2080_ENGINE_TYPE_SW = (0x00000022) # macro
NV2080_ENGINE_TYPE_CIPHER = (0x00000023) # macro
NV2080_ENGINE_TYPE_TSEC = (0x00000023) # macro
NV2080_ENGINE_TYPE_VIC = (0x00000024) # macro
NV2080_ENGINE_TYPE_MP = (0x00000025) # macro
NV2080_ENGINE_TYPE_SEC2 = (0x00000026) # macro
NV2080_ENGINE_TYPE_HOST = (0x00000027) # macro
NV2080_ENGINE_TYPE_DPU = (0x00000028) # macro
NV2080_ENGINE_TYPE_PMU = (0x00000029) # macro
NV2080_ENGINE_TYPE_FBFLCN = (0x0000002a) # macro
NV2080_ENGINE_TYPE_NVJPG = (0x0000002b) # macro
NV2080_ENGINE_TYPE_NVJPEG0 = (0x0000002b) # macro
NV2080_ENGINE_TYPE_NVJPEG1 = (0x0000002c) # macro
NV2080_ENGINE_TYPE_NVJPEG2 = (0x0000002d) # macro
NV2080_ENGINE_TYPE_NVJPEG3 = (0x0000002e) # macro
NV2080_ENGINE_TYPE_NVJPEG4 = (0x0000002f) # macro
NV2080_ENGINE_TYPE_NVJPEG5 = (0x00000030) # macro
NV2080_ENGINE_TYPE_NVJPEG6 = (0x00000031) # macro
NV2080_ENGINE_TYPE_NVJPEG7 = (0x00000032) # macro
NV2080_ENGINE_TYPE_OFA = (0x00000033) # macro
NV2080_ENGINE_TYPE_OFA0 = (0x00000033) # macro
NV2080_ENGINE_TYPE_RESERVED34 = (0x00000034) # macro
NV2080_ENGINE_TYPE_RESERVED35 = (0x00000035) # macro
NV2080_ENGINE_TYPE_RESERVED36 = (0x00000036) # macro
NV2080_ENGINE_TYPE_RESERVED37 = (0x00000037) # macro
NV2080_ENGINE_TYPE_RESERVED38 = (0x00000038) # macro
NV2080_ENGINE_TYPE_RESERVED39 = (0x00000039) # macro
NV2080_ENGINE_TYPE_RESERVED3a = (0x0000003a) # macro
NV2080_ENGINE_TYPE_RESERVED3b = (0x0000003b) # macro
NV2080_ENGINE_TYPE_RESERVED3c = (0x0000003c) # macro
NV2080_ENGINE_TYPE_RESERVED3d = (0x0000003d) # macro
NV2080_ENGINE_TYPE_RESERVED3e = (0x0000003e) # macro
NV2080_ENGINE_TYPE_RESERVED3f = (0x0000003f) # macro
NV2080_ENGINE_TYPE_LAST = (0x00000040) # macro
NV2080_ENGINE_TYPE_ALLENGINES = (0xffffffff) # macro
NV2080_ENGINE_TYPE_COPY_SIZE = 64 # macro
NV2080_ENGINE_TYPE_NVENC_SIZE = 3 # macro
NV2080_ENGINE_TYPE_NVJPEG_SIZE = 8 # macro
NV2080_ENGINE_TYPE_NVDEC_SIZE = 8 # macro
NV2080_ENGINE_TYPE_GR_SIZE = 8 # macro
NV2080_ENGINE_TYPE_OFA_SIZE = 1 # macro
# def NV2080_ENGINE_TYPE_COPY(i):  # macro
#    return ((0x00000009)+(i))
# def NV2080_ENGINE_TYPE_IS_COPY(i):  # macro
#    return (((i)>=(0x00000009))&&((i)<=(0x00000012)))
# def NV2080_ENGINE_TYPE_COPY_IDX(i):  # macro
#    return ((i)-(0x00000009))
# def NV2080_ENGINE_TYPE_NVENC(i):  # macro
#    return ((0x0000001b)+(i))
# def NV2080_ENGINE_TYPE_IS_NVENC(i):  # macro
#    return (((i)>=(0x0000001b))&&((i)<((0x0000001b)+(i))(3)))
# def NV2080_ENGINE_TYPE_NVENC_IDX(i):  # macro
#    return ((i)-(0x0000001b))
# def NV2080_ENGINE_TYPE_NVDEC(i):  # macro
#    return ((0x00000013)+(i))
# def NV2080_ENGINE_TYPE_IS_NVDEC(i):  # macro
#    return (((i)>=(0x00000013))&&((i)<((0x00000013)+(i))(8)))
# def NV2080_ENGINE_TYPE_NVDEC_IDX(i):  # macro
#    return ((i)-(0x00000013))
# def NV2080_ENGINE_TYPE_NVJPEG(i):  # macro
#    return ((0x0000002b)+(i))
# def NV2080_ENGINE_TYPE_IS_NVJPEG(i):  # macro
#    return (((i)>=(0x0000002b))&&((i)<((0x0000002b)+(i))(8)))
# def NV2080_ENGINE_TYPE_NVJPEG_IDX(i):  # macro
#    return ((i)-(0x0000002b))
# def NV2080_ENGINE_TYPE_GR(i):  # macro
#    return ((0x00000001)+(i))
# def NV2080_ENGINE_TYPE_IS_GR(i):  # macro
#    return (((i)>=(0x00000001))&&((i)<((0x00000001)+(i))(8)))
# def NV2080_ENGINE_TYPE_GR_IDX(i):  # macro
#    return ((i)-(0x00000001))
# def NV2080_ENGINE_TYPE_OFAn(i):  # macro
#    return ((i==0)?((0x00000033)):((0x00000040)))
# def NV2080_ENGINE_TYPE_IS_OFA(i):  # macro
#    return (((i)==(0x00000033)))
# def NV2080_ENGINE_TYPE_OFA_IDX(i):  # macro
#    return ((i==(0x00000033))?(0):(-1))
# def NV2080_ENGINE_TYPE_IS_VALID(i):  # macro
#    return (((i)>((0x00000000)))&&((i)<((0x00000040))))
NV2080_CLIENT_TYPE_TEX = (0x00000001) # macro
NV2080_CLIENT_TYPE_COLOR = (0x00000002) # macro
NV2080_CLIENT_TYPE_DEPTH = (0x00000003) # macro
NV2080_CLIENT_TYPE_DA = (0x00000004) # macro
NV2080_CLIENT_TYPE_FE = (0x00000005) # macro
NV2080_CLIENT_TYPE_SCC = (0x00000006) # macro
NV2080_CLIENT_TYPE_WID = (0x00000007) # macro
NV2080_CLIENT_TYPE_MSVLD = (0x00000008) # macro
NV2080_CLIENT_TYPE_MSPDEC = (0x00000009) # macro
NV2080_CLIENT_TYPE_MSPPP = (0x0000000a) # macro
NV2080_CLIENT_TYPE_VIC = (0x0000000b) # macro
NV2080_CLIENT_TYPE_ALLCLIENTS = (0xffffffff) # macro
NV2080_GC5_EXIT_COMPLETE = (0x00000001) # macro
NV2080_GC5_ENTRY_ABORTED = (0x00000002) # macro
NV2080_PLATFORM_POWER_MODE_CHANGE_COMPLETION = (0x00000000) # macro
NV2080_PLATFORM_POWER_MODE_CHANGE_ACPI_NOTIFICATION = (0x00000001) # macro
NV2080_NOTIFICATION_STATUS_ERROR_PROTECTION_FAULT = (0x4000) # macro
# NV2080_TYPEDEF = Nv20Subdevice0 # macro
NV2080_PLATFORM_POWER_MODE_CHANGE_INFO_INDEX = ['7', ':', '0'] # macro
NV2080_PLATFORM_POWER_MODE_CHANGE_INFO_MASK = ['15', ':', '8'] # macro
NV2080_PLATFORM_POWER_MODE_CHANGE_INFO_REASON = ['23', ':', '16'] # macro
class struct__cl2080_tag0(Structure):
    pass

struct__cl2080_tag0._pack_ = 1 # source:False
struct__cl2080_tag0._fields_ = [
    ('Reserved00', ctypes.c_uint32 * 1984),
]

Nv2080Typedef = struct__cl2080_tag0
Nv20Subdevice0 = struct__cl2080_tag0
class struct_Nv2080HdcpStatusChangeNotificationRec(Structure):
    pass

struct_Nv2080HdcpStatusChangeNotificationRec._pack_ = 1 # source:False
struct_Nv2080HdcpStatusChangeNotificationRec._fields_ = [
    ('displayId', ctypes.c_uint32),
    ('hdcpStatusChangeNotif', ctypes.c_uint32),
]

Nv2080HdcpStatusChangeNotification = struct_Nv2080HdcpStatusChangeNotificationRec
class struct_Nv2080PStateChangeNotificationRec(Structure):
    pass

class struct_Nv2080PStateChangeNotificationRec_timeStamp(Structure):
    pass

struct_Nv2080PStateChangeNotificationRec_timeStamp._pack_ = 1 # source:False
struct_Nv2080PStateChangeNotificationRec_timeStamp._fields_ = [
    ('nanoseconds', ctypes.c_uint32 * 2),
]

struct_Nv2080PStateChangeNotificationRec._pack_ = 1 # source:False
struct_Nv2080PStateChangeNotificationRec._fields_ = [
    ('timeStamp', struct_Nv2080PStateChangeNotificationRec_timeStamp),
    ('NewPstate', ctypes.c_uint32),
]

Nv2080PStateChangeNotification = struct_Nv2080PStateChangeNotificationRec
class struct_Nv2080ClocksChangeNotificationRec(Structure):
    pass

class struct_Nv2080ClocksChangeNotificationRec_timeStamp(Structure):
    pass

struct_Nv2080ClocksChangeNotificationRec_timeStamp._pack_ = 1 # source:False
struct_Nv2080ClocksChangeNotificationRec_timeStamp._fields_ = [
    ('nanoseconds', ctypes.c_uint32 * 2),
]

struct_Nv2080ClocksChangeNotificationRec._pack_ = 1 # source:False
struct_Nv2080ClocksChangeNotificationRec._fields_ = [
    ('timeStamp', struct_Nv2080ClocksChangeNotificationRec_timeStamp),
]

Nv2080ClocksChangeNotification = struct_Nv2080ClocksChangeNotificationRec
class struct_Nv2080WorkloadModulationChangeNotificationRec(Structure):
    pass

class struct_Nv2080WorkloadModulationChangeNotificationRec_timeStamp(Structure):
    pass

struct_Nv2080WorkloadModulationChangeNotificationRec_timeStamp._pack_ = 1 # source:False
struct_Nv2080WorkloadModulationChangeNotificationRec_timeStamp._fields_ = [
    ('nanoseconds', ctypes.c_uint32 * 2),
]

struct_Nv2080WorkloadModulationChangeNotificationRec._pack_ = 1 # source:False
struct_Nv2080WorkloadModulationChangeNotificationRec._fields_ = [
    ('timeStamp', struct_Nv2080WorkloadModulationChangeNotificationRec_timeStamp),
    ('WorkloadModulationEnabled', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

Nv2080WorkloadModulationChangeNotification = struct_Nv2080WorkloadModulationChangeNotificationRec
class struct_c__SA_Nv2080HotplugNotification(Structure):
    pass

struct_c__SA_Nv2080HotplugNotification._pack_ = 1 # source:False
struct_c__SA_Nv2080HotplugNotification._fields_ = [
    ('plugDisplayMask', ctypes.c_uint32),
    ('unplugDisplayMask', ctypes.c_uint32),
]

Nv2080HotplugNotification = struct_c__SA_Nv2080HotplugNotification
class struct_c__SA_Nv2080PowerEventNotification(Structure):
    pass

struct_c__SA_Nv2080PowerEventNotification._pack_ = 1 # source:False
struct_c__SA_Nv2080PowerEventNotification._fields_ = [
    ('bSwitchToAC', ctypes.c_ubyte),
    ('bGPUCapabilityChanged', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 2),
    ('displayMaskAffected', ctypes.c_uint32),
]

Nv2080PowerEventNotification = struct_c__SA_Nv2080PowerEventNotification
class struct_Nv2080DpIrqNotificationRec(Structure):
    pass

struct_Nv2080DpIrqNotificationRec._pack_ = 1 # source:False
struct_Nv2080DpIrqNotificationRec._fields_ = [
    ('displayId', ctypes.c_uint32),
]

Nv2080DpIrqNotification = struct_Nv2080DpIrqNotificationRec
class struct_Nv2080DstateXusbPpcNotificationRec(Structure):
    pass

struct_Nv2080DstateXusbPpcNotificationRec._pack_ = 1 # source:False
struct_Nv2080DstateXusbPpcNotificationRec._fields_ = [
    ('dstateXusb', ctypes.c_uint32),
    ('dstatePpc', ctypes.c_uint32),
]

Nv2080DstateXusbPpcNotification = struct_Nv2080DstateXusbPpcNotificationRec
class struct_Nv2080XusbPpcConnectStateNotificationRec(Structure):
    pass

struct_Nv2080XusbPpcConnectStateNotificationRec._pack_ = 1 # source:False
struct_Nv2080XusbPpcConnectStateNotificationRec._fields_ = [
    ('bConnected', ctypes.c_ubyte),
]

Nv2080XusbPpcConnectStateNotification = struct_Nv2080XusbPpcConnectStateNotificationRec
class struct_Nv2080ACPIEvent(Structure):
    pass

struct_Nv2080ACPIEvent._pack_ = 1 # source:False
struct_Nv2080ACPIEvent._fields_ = [
    ('event', ctypes.c_uint32),
]

Nv2080ACPIEvent = struct_Nv2080ACPIEvent
class struct__NV2080_COOLER_DIAG_ZONE_NOTIFICATION_REC(Structure):
    pass

struct__NV2080_COOLER_DIAG_ZONE_NOTIFICATION_REC._pack_ = 1 # source:False
struct__NV2080_COOLER_DIAG_ZONE_NOTIFICATION_REC._fields_ = [
    ('currentZone', ctypes.c_uint32),
]

NV2080_COOLER_DIAG_ZONE_NOTIFICATION_REC = struct__NV2080_COOLER_DIAG_ZONE_NOTIFICATION_REC
class struct__NV2080_THERM_DIAG_ZONE_NOTIFICATION_REC(Structure):
    pass

struct__NV2080_THERM_DIAG_ZONE_NOTIFICATION_REC._pack_ = 1 # source:False
struct__NV2080_THERM_DIAG_ZONE_NOTIFICATION_REC._fields_ = [
    ('currentZone', ctypes.c_uint32),
]

NV2080_THERM_DIAG_ZONE_NOTIFICATION_REC = struct__NV2080_THERM_DIAG_ZONE_NOTIFICATION_REC
class struct_Nv2080AudioHdcpRequestRec(Structure):
    pass

struct_Nv2080AudioHdcpRequestRec._pack_ = 1 # source:False
struct_Nv2080AudioHdcpRequestRec._fields_ = [
    ('displayId', ctypes.c_uint32),
    ('requestedState', ctypes.c_uint32),
]

Nv2080AudioHdcpRequest = struct_Nv2080AudioHdcpRequestRec
class struct_Nv2080GC5GpuReadyParams(Structure):
    pass

struct_Nv2080GC5GpuReadyParams._pack_ = 1 # source:False
struct_Nv2080GC5GpuReadyParams._fields_ = [
    ('event', ctypes.c_uint32),
    ('sciIntr0', ctypes.c_uint32),
    ('sciIntr1', ctypes.c_uint32),
]

Nv2080GC5GpuReadyParams = struct_Nv2080GC5GpuReadyParams
class struct_c__SA_Nv2080PrivRegAccessFaultNotification(Structure):
    pass

struct_c__SA_Nv2080PrivRegAccessFaultNotification._pack_ = 1 # source:False
struct_c__SA_Nv2080PrivRegAccessFaultNotification._fields_ = [
    ('errAddr', ctypes.c_uint32),
]

Nv2080PrivRegAccessFaultNotification = struct_c__SA_Nv2080PrivRegAccessFaultNotification
class struct_Nv2080DstateHdaCodecNotificationRec(Structure):
    pass

struct_Nv2080DstateHdaCodecNotificationRec._pack_ = 1 # source:False
struct_Nv2080DstateHdaCodecNotificationRec._fields_ = [
    ('dstateHdaCodec', ctypes.c_uint32),
]

Nv2080DstateHdaCodecNotification = struct_Nv2080DstateHdaCodecNotificationRec
class struct_Nv2080HdmiFrlRequestNotificationRec(Structure):
    pass

struct_Nv2080HdmiFrlRequestNotificationRec._pack_ = 1 # source:False
struct_Nv2080HdmiFrlRequestNotificationRec._fields_ = [
    ('displayId', ctypes.c_uint32),
]

Nv2080HdmiFrlRequestNotification = struct_Nv2080HdmiFrlRequestNotificationRec
class struct__NV2080_PLATFORM_POWER_MODE_CHANGE_STATUS(Structure):
    pass

struct__NV2080_PLATFORM_POWER_MODE_CHANGE_STATUS._pack_ = 1 # source:False
struct__NV2080_PLATFORM_POWER_MODE_CHANGE_STATUS._fields_ = [
    ('platformPowerModeIndex', ctypes.c_ubyte),
    ('platformPowerModeMask', ctypes.c_ubyte),
    ('eventReason', ctypes.c_ubyte),
]

NV2080_PLATFORM_POWER_MODE_CHANGE_STATUS = struct__NV2080_PLATFORM_POWER_MODE_CHANGE_STATUS
class struct_c__SA_Nv2080QosIntrNotification(Structure):
    pass

struct_c__SA_Nv2080QosIntrNotification._pack_ = 1 # source:False
struct_c__SA_Nv2080QosIntrNotification._fields_ = [
    ('engineType', ctypes.c_uint32),
]

Nv2080QosIntrNotification = struct_c__SA_Nv2080QosIntrNotification
class struct_c__SA_Nv2080EccDbeNotification(Structure):
    pass

struct_c__SA_Nv2080EccDbeNotification._pack_ = 1 # source:False
struct_c__SA_Nv2080EccDbeNotification._fields_ = [
    ('physAddress', ctypes.c_uint64),
]

Nv2080EccDbeNotification = struct_c__SA_Nv2080EccDbeNotification
class struct_c__SA_Nv2080LpwrDifrPrefetchNotification(Structure):
    pass

struct_c__SA_Nv2080LpwrDifrPrefetchNotification._pack_ = 1 # source:False
struct_c__SA_Nv2080LpwrDifrPrefetchNotification._fields_ = [
    ('l2CacheSize', ctypes.c_uint32),
]

Nv2080LpwrDifrPrefetchNotification = struct_c__SA_Nv2080LpwrDifrPrefetchNotification
class struct_c__SA_Nv2080NvlinkLnkChangeNotification(Structure):
    pass

struct_c__SA_Nv2080NvlinkLnkChangeNotification._pack_ = 1 # source:False
struct_c__SA_Nv2080NvlinkLnkChangeNotification._fields_ = [
    ('GpuId', ctypes.c_uint32),
    ('linkId', ctypes.c_uint32),
]

Nv2080NvlinkLnkChangeNotification = struct_c__SA_Nv2080NvlinkLnkChangeNotification
class struct_c__SA_Nv2080VrrSetTimeoutNotification(Structure):
    pass

struct_c__SA_Nv2080VrrSetTimeoutNotification._pack_ = 1 # source:False
struct_c__SA_Nv2080VrrSetTimeoutNotification._fields_ = [
    ('head', ctypes.c_uint32),
]

Nv2080VrrSetTimeoutNotification = struct_c__SA_Nv2080VrrSetTimeoutNotification
_clc56f_h_ = True # macro
AMPERE_CHANNEL_GPFIFO_A = (0x0000c56f) # macro
# NVC56F_TYPEDEF = AMPERE_CHANNELChannelGPFifoA # macro
NVC56F_NUMBER_OF_SUBCHANNELS = (8) # macro
NVC56F_SET_OBJECT = (0x00000000) # macro
NVC56F_SET_OBJECT_NVCLASS = ['15', ':', '0'] # macro
NVC56F_SET_OBJECT_ENGINE = ['20', ':', '16'] # macro
NVC56F_SET_OBJECT_ENGINE_SW = 0x0000001f # macro
NVC56F_ILLEGAL = (0x00000004) # macro
NVC56F_ILLEGAL_HANDLE = ['31', ':', '0'] # macro
NVC56F_NOP = (0x00000008) # macro
NVC56F_NOP_HANDLE = ['31', ':', '0'] # macro
NVC56F_SEMAPHOREA = (0x00000010) # macro
NVC56F_SEMAPHOREA_OFFSET_UPPER = ['7', ':', '0'] # macro
NVC56F_SEMAPHOREB = (0x00000014) # macro
NVC56F_SEMAPHOREB_OFFSET_LOWER = ['31', ':', '2'] # macro
NVC56F_SEMAPHOREC = (0x00000018) # macro
NVC56F_SEMAPHOREC_PAYLOAD = ['31', ':', '0'] # macro
NVC56F_SEMAPHORED = (0x0000001C) # macro
NVC56F_SEMAPHORED_OPERATION = ['4', ':', '0'] # macro
NVC56F_SEMAPHORED_OPERATION_ACQUIRE = 0x00000001 # macro
NVC56F_SEMAPHORED_OPERATION_RELEASE = 0x00000002 # macro
NVC56F_SEMAPHORED_OPERATION_ACQ_GEQ = 0x00000004 # macro
NVC56F_SEMAPHORED_OPERATION_ACQ_AND = 0x00000008 # macro
NVC56F_SEMAPHORED_OPERATION_REDUCTION = 0x00000010 # macro
NVC56F_SEMAPHORED_ACQUIRE_SWITCH = ['12', ':', '12'] # macro
NVC56F_SEMAPHORED_ACQUIRE_SWITCH_DISABLED = 0x00000000 # macro
NVC56F_SEMAPHORED_ACQUIRE_SWITCH_ENABLED = 0x00000001 # macro
NVC56F_SEMAPHORED_RELEASE_WFI = ['20', ':', '20'] # macro
NVC56F_SEMAPHORED_RELEASE_WFI_EN = 0x00000000 # macro
NVC56F_SEMAPHORED_RELEASE_WFI_DIS = 0x00000001 # macro
NVC56F_SEMAPHORED_RELEASE_SIZE = ['24', ':', '24'] # macro
NVC56F_SEMAPHORED_RELEASE_SIZE_16BYTE = 0x00000000 # macro
NVC56F_SEMAPHORED_RELEASE_SIZE_4BYTE = 0x00000001 # macro
NVC56F_SEMAPHORED_REDUCTION = ['30', ':', '27'] # macro
NVC56F_SEMAPHORED_REDUCTION_MIN = 0x00000000 # macro
NVC56F_SEMAPHORED_REDUCTION_MAX = 0x00000001 # macro
NVC56F_SEMAPHORED_REDUCTION_XOR = 0x00000002 # macro
NVC56F_SEMAPHORED_REDUCTION_AND = 0x00000003 # macro
NVC56F_SEMAPHORED_REDUCTION_OR = 0x00000004 # macro
NVC56F_SEMAPHORED_REDUCTION_ADD = 0x00000005 # macro
NVC56F_SEMAPHORED_REDUCTION_INC = 0x00000006 # macro
NVC56F_SEMAPHORED_REDUCTION_DEC = 0x00000007 # macro
NVC56F_SEMAPHORED_FORMAT = ['31', ':', '31'] # macro
NVC56F_SEMAPHORED_FORMAT_SIGNED = 0x00000000 # macro
NVC56F_SEMAPHORED_FORMAT_UNSIGNED = 0x00000001 # macro
NVC56F_NON_STALL_INTERRUPT = (0x00000020) # macro
NVC56F_NON_STALL_INTERRUPT_HANDLE = ['31', ':', '0'] # macro
NVC56F_FB_FLUSH = (0x00000024) # macro
NVC56F_FB_FLUSH_HANDLE = ['31', ':', '0'] # macro
NVC56F_MEM_OP_A = (0x00000028) # macro
NVC56F_MEM_OP_A_TLB_INVALIDATE_CANCEL_TARGET_CLIENT_UNIT_ID = ['5', ':', '0'] # macro
NVC56F_MEM_OP_A_TLB_INVALIDATE_INVALIDATION_SIZE = ['5', ':', '0'] # macro
NVC56F_MEM_OP_A_TLB_INVALIDATE_CANCEL_TARGET_GPC_ID = ['10', ':', '6'] # macro
NVC56F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE = ['7', ':', '6'] # macro
NVC56F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_ALL_TLBS = 0 # macro
NVC56F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_LINK_TLBS = 1 # macro
NVC56F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_NON_LINK_TLBS = 2 # macro
NVC56F_MEM_OP_A_TLB_INVALIDATE_INVAL_SCOPE_RSVRVD = 3 # macro
NVC56F_MEM_OP_A_TLB_INVALIDATE_CANCEL_MMU_ENGINE_ID = ['6', ':', '0'] # macro
NVC56F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR = ['11', ':', '11'] # macro
NVC56F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_EN = 0x00000001 # macro
NVC56F_MEM_OP_A_TLB_INVALIDATE_SYSMEMBAR_DIS = 0x00000000 # macro
NVC56F_MEM_OP_A_TLB_INVALIDATE_TARGET_ADDR_LO = ['31', ':', '12'] # macro
NVC56F_MEM_OP_B = (0x0000002c) # macro
NVC56F_MEM_OP_B_TLB_INVALIDATE_TARGET_ADDR_HI = ['31', ':', '0'] # macro
NVC56F_MEM_OP_C = (0x00000030) # macro
NVC56F_MEM_OP_C_MEMBAR_TYPE = ['2', ':', '0'] # macro
NVC56F_MEM_OP_C_MEMBAR_TYPE_SYS_MEMBAR = 0x00000000 # macro
NVC56F_MEM_OP_C_MEMBAR_TYPE_MEMBAR = 0x00000001 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_PDB = ['0', ':', '0'] # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_PDB_ONE = 0x00000000 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_PDB_ALL = 0x00000001 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_GPC = ['1', ':', '1'] # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_GPC_ENABLE = 0x00000000 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_GPC_DISABLE = 0x00000001 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_REPLAY = ['4', ':', '2'] # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_REPLAY_NONE = 0x00000000 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_REPLAY_START = 0x00000001 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_REPLAY_START_ACK_ALL = 0x00000002 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_REPLAY_CANCEL_TARGETED = 0x00000003 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_REPLAY_CANCEL_GLOBAL = 0x00000004 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_REPLAY_CANCEL_VA_GLOBAL = 0x00000005 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE = ['6', ':', '5'] # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_NONE = 0x00000000 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_GLOBALLY = 0x00000001 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_ACK_TYPE_INTRANODE = 0x00000002 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE = ['9', ':', '7'] # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_READ = 0 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_WRITE = 1 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_ATOMIC_STRONG = 2 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_RSVRVD = 3 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_ATOMIC_WEAK = 4 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_ATOMIC_ALL = 5 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_WRITE_AND_ATOMIC = 6 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_ACCESS_TYPE_VIRT_ALL = 7 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL = ['9', ':', '7'] # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_ALL = 0x00000000 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_PTE_ONLY = 0x00000001 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE0 = 0x00000002 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE1 = 0x00000003 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE2 = 0x00000004 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE3 = 0x00000005 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE4 = 0x00000006 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_PAGE_TABLE_LEVEL_UP_TO_PDE5 = 0x00000007 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE = ['11', ':', '10'] # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_VID_MEM = 0x00000000 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_COHERENT = 0x00000002 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_PDB_APERTURE_SYS_MEM_NONCOHERENT = 0x00000003 # macro
NVC56F_MEM_OP_C_TLB_INVALIDATE_PDB_ADDR_LO = ['31', ':', '12'] # macro
NVC56F_MEM_OP_C_ACCESS_COUNTER_CLR_TARGETED_NOTIFY_TAG = ['19', ':', '0'] # macro
NVC56F_MEM_OP_D = (0x00000034) # macro
NVC56F_MEM_OP_D_TLB_INVALIDATE_PDB_ADDR_HI = ['26', ':', '0'] # macro
NVC56F_MEM_OP_D_OPERATION = ['31', ':', '27'] # macro
NVC56F_MEM_OP_D_OPERATION_MEMBAR = 0x00000005 # macro
NVC56F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE = 0x00000009 # macro
NVC56F_MEM_OP_D_OPERATION_MMU_TLB_INVALIDATE_TARGETED = 0x0000000a # macro
NVC56F_MEM_OP_D_OPERATION_L2_PEERMEM_INVALIDATE = 0x0000000d # macro
NVC56F_MEM_OP_D_OPERATION_L2_SYSMEM_INVALIDATE = 0x0000000e # macro
NVC56F_MEM_OP_B_OPERATION_L2_INVALIDATE_CLEAN_LINES = 0x0000000e # macro
NVC56F_MEM_OP_D_OPERATION_L2_CLEAN_COMPTAGS = 0x0000000f # macro
NVC56F_MEM_OP_D_OPERATION_L2_FLUSH_DIRTY = 0x00000010 # macro
NVC56F_MEM_OP_D_OPERATION_L2_WAIT_FOR_SYS_PENDING_READS = 0x00000015 # macro
NVC56F_MEM_OP_D_OPERATION_ACCESS_COUNTER_CLR = 0x00000016 # macro
NVC56F_MEM_OP_D_ACCESS_COUNTER_CLR_TYPE = ['1', ':', '0'] # macro
NVC56F_MEM_OP_D_ACCESS_COUNTER_CLR_TYPE_MIMC = 0x00000000 # macro
NVC56F_MEM_OP_D_ACCESS_COUNTER_CLR_TYPE_MOMC = 0x00000001 # macro
NVC56F_MEM_OP_D_ACCESS_COUNTER_CLR_TYPE_ALL = 0x00000002 # macro
NVC56F_MEM_OP_D_ACCESS_COUNTER_CLR_TYPE_TARGETED = 0x00000003 # macro
NVC56F_MEM_OP_D_ACCESS_COUNTER_CLR_TARGETED_TYPE = ['2', ':', '2'] # macro
NVC56F_MEM_OP_D_ACCESS_COUNTER_CLR_TARGETED_TYPE_MIMC = 0x00000000 # macro
NVC56F_MEM_OP_D_ACCESS_COUNTER_CLR_TARGETED_TYPE_MOMC = 0x00000001 # macro
NVC56F_MEM_OP_D_ACCESS_COUNTER_CLR_TARGETED_BANK = ['6', ':', '3'] # macro
NVC56F_SET_REFERENCE = (0x00000050) # macro
NVC56F_SET_REFERENCE_COUNT = ['31', ':', '0'] # macro
NVC56F_SEM_ADDR_LO = (0x0000005c) # macro
NVC56F_SEM_ADDR_LO_OFFSET = ['31', ':', '2'] # macro
NVC56F_SEM_ADDR_HI = (0x00000060) # macro
NVC56F_SEM_ADDR_HI_OFFSET = ['7', ':', '0'] # macro
NVC56F_SEM_PAYLOAD_LO = (0x00000064) # macro
NVC56F_SEM_PAYLOAD_LO_PAYLOAD = ['31', ':', '0'] # macro
NVC56F_SEM_PAYLOAD_HI = (0x00000068) # macro
NVC56F_SEM_PAYLOAD_HI_PAYLOAD = ['31', ':', '0'] # macro
NVC56F_SEM_EXECUTE = (0x0000006c) # macro
NVC56F_SEM_EXECUTE_OPERATION = ['2', ':', '0'] # macro
NVC56F_SEM_EXECUTE_OPERATION_ACQUIRE = 0x00000000 # macro
NVC56F_SEM_EXECUTE_OPERATION_RELEASE = 0x00000001 # macro
NVC56F_SEM_EXECUTE_OPERATION_ACQ_STRICT_GEQ = 0x00000002 # macro
NVC56F_SEM_EXECUTE_OPERATION_ACQ_CIRC_GEQ = 0x00000003 # macro
NVC56F_SEM_EXECUTE_OPERATION_ACQ_AND = 0x00000004 # macro
NVC56F_SEM_EXECUTE_OPERATION_ACQ_NOR = 0x00000005 # macro
NVC56F_SEM_EXECUTE_OPERATION_REDUCTION = 0x00000006 # macro
NVC56F_SEM_EXECUTE_ACQUIRE_SWITCH_TSG = ['12', ':', '12'] # macro
NVC56F_SEM_EXECUTE_ACQUIRE_SWITCH_TSG_DIS = 0x00000000 # macro
NVC56F_SEM_EXECUTE_ACQUIRE_SWITCH_TSG_EN = 0x00000001 # macro
NVC56F_SEM_EXECUTE_RELEASE_WFI = ['20', ':', '20'] # macro
NVC56F_SEM_EXECUTE_RELEASE_WFI_DIS = 0x00000000 # macro
NVC56F_SEM_EXECUTE_RELEASE_WFI_EN = 0x00000001 # macro
NVC56F_SEM_EXECUTE_PAYLOAD_SIZE = ['24', ':', '24'] # macro
NVC56F_SEM_EXECUTE_PAYLOAD_SIZE_32BIT = 0x00000000 # macro
NVC56F_SEM_EXECUTE_PAYLOAD_SIZE_64BIT = 0x00000001 # macro
NVC56F_SEM_EXECUTE_RELEASE_TIMESTAMP = ['25', ':', '25'] # macro
NVC56F_SEM_EXECUTE_RELEASE_TIMESTAMP_DIS = 0x00000000 # macro
NVC56F_SEM_EXECUTE_RELEASE_TIMESTAMP_EN = 0x00000001 # macro
NVC56F_SEM_EXECUTE_REDUCTION = ['30', ':', '27'] # macro
NVC56F_SEM_EXECUTE_REDUCTION_IMIN = 0x00000000 # macro
NVC56F_SEM_EXECUTE_REDUCTION_IMAX = 0x00000001 # macro
NVC56F_SEM_EXECUTE_REDUCTION_IXOR = 0x00000002 # macro
NVC56F_SEM_EXECUTE_REDUCTION_IAND = 0x00000003 # macro
NVC56F_SEM_EXECUTE_REDUCTION_IOR = 0x00000004 # macro
NVC56F_SEM_EXECUTE_REDUCTION_IADD = 0x00000005 # macro
NVC56F_SEM_EXECUTE_REDUCTION_INC = 0x00000006 # macro
NVC56F_SEM_EXECUTE_REDUCTION_DEC = 0x00000007 # macro
NVC56F_SEM_EXECUTE_REDUCTION_FORMAT = ['31', ':', '31'] # macro
NVC56F_SEM_EXECUTE_REDUCTION_FORMAT_SIGNED = 0x00000000 # macro
NVC56F_SEM_EXECUTE_REDUCTION_FORMAT_UNSIGNED = 0x00000001 # macro
NVC56F_WFI = (0x00000078) # macro
NVC56F_WFI_SCOPE = ['0', ':', '0'] # macro
NVC56F_WFI_SCOPE_CURRENT_SCG_TYPE = 0x00000000 # macro
NVC56F_WFI_SCOPE_CURRENT_VEID = 0x00000000 # macro
NVC56F_WFI_SCOPE_ALL = 0x00000001 # macro
NVC56F_YIELD = (0x00000080) # macro
NVC56F_YIELD_OP = ['1', ':', '0'] # macro
NVC56F_YIELD_OP_NOP = 0x00000000 # macro
NVC56F_YIELD_OP_TSG = 0x00000003 # macro
NVC56F_CLEAR_FAULTED = (0x00000084) # macro
NVC56F_CLEAR_FAULTED_HANDLE = ['30', ':', '0'] # macro
NVC56F_CLEAR_FAULTED_TYPE = ['31', ':', '31'] # macro
NVC56F_CLEAR_FAULTED_TYPE_PBDMA_FAULTED = 0x00000000 # macro
NVC56F_CLEAR_FAULTED_TYPE_ENG_FAULTED = 0x00000001 # macro
NVC56F_GP_ENTRY__SIZE = 8 # macro
NVC56F_GP_ENTRY0_FETCH = ['0', ':', '0'] # macro
NVC56F_GP_ENTRY0_FETCH_UNCONDITIONAL = 0x00000000 # macro
NVC56F_GP_ENTRY0_FETCH_CONDITIONAL = 0x00000001 # macro
NVC56F_GP_ENTRY0_GET = ['31', ':', '2'] # macro
NVC56F_GP_ENTRY0_OPERAND = ['31', ':', '0'] # macro
NVC56F_GP_ENTRY1_GET_HI = ['7', ':', '0'] # macro
NVC56F_GP_ENTRY1_LEVEL = ['9', ':', '9'] # macro
NVC56F_GP_ENTRY1_LEVEL_MAIN = 0x00000000 # macro
NVC56F_GP_ENTRY1_LEVEL_SUBROUTINE = 0x00000001 # macro
NVC56F_GP_ENTRY1_LENGTH = ['30', ':', '10'] # macro
NVC56F_GP_ENTRY1_SYNC = ['31', ':', '31'] # macro
NVC56F_GP_ENTRY1_SYNC_PROCEED = 0x00000000 # macro
NVC56F_GP_ENTRY1_SYNC_WAIT = 0x00000001 # macro
NVC56F_GP_ENTRY1_OPCODE = ['7', ':', '0'] # macro
NVC56F_GP_ENTRY1_OPCODE_NOP = 0x00000000 # macro
NVC56F_GP_ENTRY1_OPCODE_ILLEGAL = 0x00000001 # macro
NVC56F_GP_ENTRY1_OPCODE_GP_CRC = 0x00000002 # macro
NVC56F_GP_ENTRY1_OPCODE_PB_CRC = 0x00000003 # macro
NVC56F_DMA_METHOD_ADDRESS_OLD = ['12', ':', '2'] # macro
NVC56F_DMA_METHOD_ADDRESS = ['11', ':', '0'] # macro
NVC56F_DMA_SUBDEVICE_MASK = ['15', ':', '4'] # macro
NVC56F_DMA_METHOD_SUBCHANNEL = ['15', ':', '13'] # macro
NVC56F_DMA_TERT_OP = ['17', ':', '16'] # macro
NVC56F_DMA_TERT_OP_GRP0_INC_METHOD = (0x00000000) # macro
NVC56F_DMA_TERT_OP_GRP0_SET_SUB_DEV_MASK = (0x00000001) # macro
NVC56F_DMA_TERT_OP_GRP0_STORE_SUB_DEV_MASK = (0x00000002) # macro
NVC56F_DMA_TERT_OP_GRP0_USE_SUB_DEV_MASK = (0x00000003) # macro
NVC56F_DMA_TERT_OP_GRP2_NON_INC_METHOD = (0x00000000) # macro
NVC56F_DMA_METHOD_COUNT_OLD = ['28', ':', '18'] # macro
NVC56F_DMA_METHOD_COUNT = ['28', ':', '16'] # macro
NVC56F_DMA_IMMD_DATA = ['28', ':', '16'] # macro
NVC56F_DMA_SEC_OP = ['31', ':', '29'] # macro
NVC56F_DMA_SEC_OP_GRP0_USE_TERT = (0x00000000) # macro
NVC56F_DMA_SEC_OP_INC_METHOD = (0x00000001) # macro
NVC56F_DMA_SEC_OP_GRP2_USE_TERT = (0x00000002) # macro
NVC56F_DMA_SEC_OP_NON_INC_METHOD = (0x00000003) # macro
NVC56F_DMA_SEC_OP_IMMD_DATA_METHOD = (0x00000004) # macro
NVC56F_DMA_SEC_OP_ONE_INC = (0x00000005) # macro
NVC56F_DMA_SEC_OP_RESERVED6 = (0x00000006) # macro
NVC56F_DMA_SEC_OP_END_PB_SEGMENT = (0x00000007) # macro
NVC56F_DMA_INCR_ADDRESS = ['11', ':', '0'] # macro
NVC56F_DMA_INCR_SUBCHANNEL = ['15', ':', '13'] # macro
NVC56F_DMA_INCR_COUNT = ['28', ':', '16'] # macro
NVC56F_DMA_INCR_OPCODE = ['31', ':', '29'] # macro
NVC56F_DMA_INCR_OPCODE_VALUE = (0x00000001) # macro
NVC56F_DMA_INCR_DATA = ['31', ':', '0'] # macro
NVC56F_DMA_NONINCR_ADDRESS = ['11', ':', '0'] # macro
NVC56F_DMA_NONINCR_SUBCHANNEL = ['15', ':', '13'] # macro
NVC56F_DMA_NONINCR_COUNT = ['28', ':', '16'] # macro
NVC56F_DMA_NONINCR_OPCODE = ['31', ':', '29'] # macro
NVC56F_DMA_NONINCR_OPCODE_VALUE = (0x00000003) # macro
NVC56F_DMA_NONINCR_DATA = ['31', ':', '0'] # macro
NVC56F_DMA_ONEINCR_ADDRESS = ['11', ':', '0'] # macro
NVC56F_DMA_ONEINCR_SUBCHANNEL = ['15', ':', '13'] # macro
NVC56F_DMA_ONEINCR_COUNT = ['28', ':', '16'] # macro
NVC56F_DMA_ONEINCR_OPCODE = ['31', ':', '29'] # macro
NVC56F_DMA_ONEINCR_OPCODE_VALUE = (0x00000005) # macro
NVC56F_DMA_ONEINCR_DATA = ['31', ':', '0'] # macro
NVC56F_DMA_NOP = (0x00000000) # macro
NVC56F_DMA_IMMD_ADDRESS = ['11', ':', '0'] # macro
NVC56F_DMA_IMMD_SUBCHANNEL = ['15', ':', '13'] # macro
NVC56F_DMA_IMMD_OPCODE = ['31', ':', '29'] # macro
NVC56F_DMA_IMMD_OPCODE_VALUE = (0x00000004) # macro
NVC56F_DMA_SET_SUBDEVICE_MASK_VALUE = ['15', ':', '4'] # macro
NVC56F_DMA_SET_SUBDEVICE_MASK_OPCODE = ['31', ':', '16'] # macro
NVC56F_DMA_SET_SUBDEVICE_MASK_OPCODE_VALUE = (0x00000001) # macro
NVC56F_DMA_STORE_SUBDEVICE_MASK_VALUE = ['15', ':', '4'] # macro
NVC56F_DMA_STORE_SUBDEVICE_MASK_OPCODE = ['31', ':', '16'] # macro
NVC56F_DMA_STORE_SUBDEVICE_MASK_OPCODE_VALUE = (0x00000002) # macro
NVC56F_DMA_USE_SUBDEVICE_MASK_OPCODE = ['31', ':', '16'] # macro
NVC56F_DMA_USE_SUBDEVICE_MASK_OPCODE_VALUE = (0x00000003) # macro
NVC56F_DMA_ENDSEG_OPCODE = ['31', ':', '29'] # macro
NVC56F_DMA_ENDSEG_OPCODE_VALUE = (0x00000007) # macro
NVC56F_DMA_ADDRESS = ['12', ':', '2'] # macro
NVC56F_DMA_SUBCH = ['15', ':', '13'] # macro
NVC56F_DMA_OPCODE3 = ['17', ':', '16'] # macro
NVC56F_DMA_OPCODE3_NONE = (0x00000000) # macro
NVC56F_DMA_COUNT = ['28', ':', '18'] # macro
NVC56F_DMA_OPCODE = ['31', ':', '29'] # macro
NVC56F_DMA_OPCODE_METHOD = (0x00000000) # macro
NVC56F_DMA_OPCODE_NONINC_METHOD = (0x00000002) # macro
NVC56F_DMA_DATA = ['31', ':', '0'] # macro
class struct_Nvc56fControl_struct(Structure):
    pass

struct_Nvc56fControl_struct._pack_ = 1 # source:False
struct_Nvc56fControl_struct._fields_ = [
    ('Ignored00', ctypes.c_uint32 * 16),
    ('Put', ctypes.c_uint32),
    ('Get', ctypes.c_uint32),
    ('Reference', ctypes.c_uint32),
    ('PutHi', ctypes.c_uint32),
    ('Ignored01', ctypes.c_uint32 * 2),
    ('TopLevelGet', ctypes.c_uint32),
    ('TopLevelGetHi', ctypes.c_uint32),
    ('GetHi', ctypes.c_uint32),
    ('Ignored02', ctypes.c_uint32 * 7),
    ('Ignored03', ctypes.c_uint32),
    ('Ignored04', ctypes.c_uint32 * 1),
    ('GPGet', ctypes.c_uint32),
    ('GPPut', ctypes.c_uint32),
    ('Ignored05', ctypes.c_uint32 * 92),
]

Nvc56fControl = struct_Nvc56fControl_struct
AmpereAControlGPFifo = struct_Nvc56fControl_struct
NV01_ROOT = (0x0) # macro
NV1_ROOT = (0x00000000) # macro
NV01_NULL_OBJECT = (0x00000000) # macro
NV1_NULL_OBJECT = (0x00000000) # macro
NV01_ROOT_NON_PRIV = (0x00000001) # macro
NV1_ROOT_NON_PRIV = (0x00000001) # macro
NV01_ROOT_CLIENT = (0x00000041) # macro
FABRIC_MANAGER_SESSION = (0x0000000f) # macro
NV0020_GPU_MANAGEMENT = (0x00000020) # macro
NV20_SUBDEVICE_0 = (0x00002080) # macro
NV2081_BINAPI = (0x00002081) # macro
NV2082_BINAPI_PRIVILEGED = (0x00002082) # macro
NV20_SUBDEVICE_DIAG = (0x0000208f) # macro
NV01_CONTEXT_DMA = (0x00000002) # macro
NV01_MEMORY_SYSTEM = (0x0000003e) # macro
NV1_MEMORY_SYSTEM = (0x0000003e) # macro
NV01_MEMORY_LOCAL_PRIVILEGED = (0x0000003f) # macro
NV1_MEMORY_LOCAL_PRIVILEGED = (0x0000003f) # macro
NV01_MEMORY_PRIVILEGED = (0x0000003f) # macro
NV1_MEMORY_PRIVILEGED = (0x0000003f) # macro
NV01_MEMORY_LOCAL_USER = (0x00000040) # macro
NV1_MEMORY_LOCAL_USER = (0x00000040) # macro
NV01_MEMORY_USER = (0x00000040) # macro
NV1_MEMORY_USER = (0x00000040) # macro
NV_MEMORY_EXTENDED_USER = (0x00000042) # macro
NV01_MEMORY_VIRTUAL = (0x00000070) # macro
NV01_MEMORY_SYSTEM_DYNAMIC = (0x00000070) # macro
NV1_MEMORY_SYSTEM_DYNAMIC = (0x00000070) # macro
NV_MEMORY_MAPPER = (0x000000fe) # macro
NV01_MEMORY_LOCAL_PHYSICAL = (0x000000c2) # macro
NV01_MEMORY_SYSTEM_OS_DESCRIPTOR = (0x00000071) # macro
NV01_MEMORY_DEVICELESS = (0x000090ce) # macro
NV01_MEMORY_FRAMEBUFFER_CONSOLE = (0x00000076) # macro
NV01_MEMORY_HW_RESOURCES = (0x000000b1) # macro
NV01_MEMORY_LIST_SYSTEM = (0x00000081) # macro
NV01_MEMORY_LIST_FBMEM = (0x00000082) # macro
NV01_MEMORY_LIST_OBJECT = (0x00000083) # macro
NV_IMEX_SESSION = (0x000000f1) # macro
NV01_MEMORY_FLA = (0x000000f3) # macro
NV_MEMORY_EXPORT = (0x000000e0) # macro
NV_CE_UTILS = (0x00000050) # macro
NV_MEMORY_FABRIC = (0x000000f8) # macro
NV_MEMORY_FABRIC_IMPORT_V2 = (0x000000f9) # macro
NV_MEMORY_FABRIC_IMPORTED_REF = (0x000000fb) # macro
FABRIC_VASPACE_A = (0x000000fc) # macro
NV_MEMORY_MULTICAST_FABRIC = (0x000000fd) # macro
IO_VASPACE_A = (0x000000f2) # macro
NV01_NULL = (0x00000030) # macro
NV1_NULL = (0x00000030) # macro
NV01_EVENT = (0x00000005) # macro
NV1_EVENT = (0x00000005) # macro
NV01_EVENT_KERNEL_CALLBACK = (0x00000078) # macro
NV1_EVENT_KERNEL_CALLBACK = (0x00000078) # macro
NV01_EVENT_OS_EVENT = (0x00000079) # macro
NV1_EVENT_OS_EVENT = (0x00000079) # macro
NV01_EVENT_WIN32_EVENT = (0x00000079) # macro
NV1_EVENT_WIN32_EVENT = (0x00000079) # macro
NV01_EVENT_KERNEL_CALLBACK_EX = (0x0000007E) # macro
NV1_EVENT_KERNEL_CALLBACK_EX = (0x0000007e) # macro
NV01_TIMER = (0x00000004) # macro
NV1_TIMER = (0x00000004) # macro
KERNEL_GRAPHICS_CONTEXT = (0x00000090) # macro
NV50_CHANNEL_GPFIFO = (0x0000506f) # macro
GF100_CHANNEL_GPFIFO = (0x0000906f) # macro
KEPLER_CHANNEL_GPFIFO_A = (0x0000a06f) # macro
UVM_CHANNEL_RETAINER = (0x0000c574) # macro
KEPLER_CHANNEL_GPFIFO_B = (0x0000a16f) # macro
MAXWELL_CHANNEL_GPFIFO_A = (0x0000b06f) # macro
PASCAL_CHANNEL_GPFIFO_A = (0x0000c06f) # macro
VOLTA_CHANNEL_GPFIFO_A = (0x0000c36f) # macro
TURING_CHANNEL_GPFIFO_A = (0x0000c46f) # macro
HOPPER_CHANNEL_GPFIFO_A = (0x0000c86f) # macro
NV04_SOFTWARE_TEST = (0x0000007d) # macro
NV4_SOFTWARE_TEST = (0x0000007d) # macro
NV30_GSYNC = (0x000030f1) # macro
VOLTA_USERMODE_A = (0x0000c361) # macro
TURING_USERMODE_A = (0x0000c461) # macro
AMPERE_USERMODE_A = (0x0000c561) # macro
HOPPER_USERMODE_A = (0x0000c661) # macro
NVC371_DISP_SF_USER = (0x0000c371) # macro
NVC372_DISPLAY_SW = (0x0000c372) # macro
NVC573_DISP_CAPABILITIES = (0x0000c573) # macro
NVC673_DISP_CAPABILITIES = (0x0000c673) # macro
NVC773_DISP_CAPABILITIES = (0x0000c773) # macro
NV04_DISPLAY_COMMON = (0x00000073) # macro
NV50_DEFERRED_API_CLASS = (0x00005080) # macro
MPS_COMPUTE = (0x0000900e) # macro
NVC570_DISPLAY = (0x0000c570) # macro
NVC57A_CURSOR_IMM_CHANNEL_PIO = (0x0000c57a) # macro
NVC57B_WINDOW_IMM_CHANNEL_DMA = (0x0000c57b) # macro
NVC57D_CORE_CHANNEL_DMA = (0x0000c57d) # macro
NVC57E_WINDOW_CHANNEL_DMA = (0x0000c57e) # macro
NVC670_DISPLAY = (0x0000c670) # macro
NVC671_DISP_SF_USER = (0x0000c671) # macro
NVC67A_CURSOR_IMM_CHANNEL_PIO = (0x0000c67a) # macro
NVC67B_WINDOW_IMM_CHANNEL_DMA = (0x0000c67b) # macro
NVC67D_CORE_CHANNEL_DMA = (0x0000c67d) # macro
NVC67E_WINDOW_CHANNEL_DMA = (0x0000c67e) # macro
NVC77F_ANY_CHANNEL_DMA = (0x0000c77f) # macro
NVC770_DISPLAY = (0x0000c770) # macro
NVC771_DISP_SF_USER = (0x0000c771) # macro
NVC77D_CORE_CHANNEL_DMA = (0x0000c77d) # macro
NV9010_VBLANK_CALLBACK = (0x00009010) # macro
GF100_PROFILER = (0x000090cc) # macro
MAXWELL_PROFILER = (0x0000b0cc) # macro
MAXWELL_PROFILER_DEVICE = (0x0000b2cc) # macro
GF100_SUBDEVICE_MASTER = (0x000090e6) # macro
GF100_SUBDEVICE_INFOROM = (0x000090e7) # macro
GF100_ZBC_CLEAR = (0x00009096) # macro
GF100_DISP_SW = (0x00009072) # macro
GF100_TIMED_SEMAPHORE_SW = (0x00009074) # macro
G84_PERFBUFFER = (0x0000844c) # macro
NV50_MEMORY_VIRTUAL = (0x000050a0) # macro
NV50_P2P = (0x0000503b) # macro
NV50_THIRD_PARTY_P2P = (0x0000503c) # macro
FERMI_TWOD_A = (0x0000902d) # macro
FERMI_VASPACE_A = (0x000090f1) # macro
HOPPER_SEC2_WORK_LAUNCH_A = (0x0000cba2) # macro
GF100_HDACODEC = (0x000090ec) # macro
NVB8B0_VIDEO_DECODER = (0x0000b8b0) # macro
NVC4B0_VIDEO_DECODER = (0x0000c4b0) # macro
NVC6B0_VIDEO_DECODER = (0x0000c6b0) # macro
NVC7B0_VIDEO_DECODER = (0x0000c7b0) # macro
NVC9B0_VIDEO_DECODER = (0x0000c9b0) # macro
NVC4B7_VIDEO_ENCODER = (0x0000c4b7) # macro
NVB4B7_VIDEO_ENCODER = (0x0000b4b7) # macro
NVC7B7_VIDEO_ENCODER = (0x0000c7b7) # macro
NVC9B7_VIDEO_ENCODER = (0x0000c9b7) # macro
NVB8D1_VIDEO_NVJPG = (0x0000b8d1) # macro
NVC4D1_VIDEO_NVJPG = (0x0000c4d1) # macro
NVC9D1_VIDEO_NVJPG = (0x0000c9d1) # macro
NVB8FA_VIDEO_OFA = (0x0000b8fa) # macro
NVC6FA_VIDEO_OFA = (0x0000c6fa) # macro
NVC7FA_VIDEO_OFA = (0x0000c7fa) # macro
NVC9FA_VIDEO_OFA = (0x0000c9fa) # macro
KEPLER_INLINE_TO_MEMORY_B = (0x0000a140) # macro
FERMI_CONTEXT_SHARE_A = (0x00009067) # macro
KEPLER_CHANNEL_GROUP_A = (0x0000a06c) # macro
PASCAL_DMA_COPY_A = (0x0000c0b5) # macro
TURING_DMA_COPY_A = (0x0000c5b5) # macro
AMPERE_DMA_COPY_A = (0x0000C6B5) # macro
AMPERE_DMA_COPY_B = (0x0000c7b5) # macro
HOPPER_DMA_COPY_A = (0x0000c8b5) # macro
MAXWELL_DMA_COPY_A = (0x0000b0b5) # macro
ACCESS_COUNTER_NOTIFY_BUFFER = (0x0000c365) # macro
MMU_FAULT_BUFFER = (0x0000c369) # macro
MMU_VIDMEM_ACCESS_BIT_BUFFER = (0x0000c763) # macro
TURING_A = (0x0000c597) # macro
TURING_COMPUTE_A = (0x0000c5c0) # macro
AMPERE_A = (0x0000c697) # macro
AMPERE_COMPUTE_A = 0xC6C0 # macro
AMPERE_B = (0x0000c797) # macro
AMPERE_COMPUTE_B = (0x0000c7c0) # macro
ADA_A = (0x0000c997) # macro
ADA_COMPUTE_A = (0x0000c9c0) # macro
AMPERE_SMC_PARTITION_REF = (0x0000c637) # macro
AMPERE_SMC_EXEC_PARTITION_REF = (0x0000c638) # macro
AMPERE_SMC_CONFIG_SESSION = (0x0000c639) # macro
NV0092_RG_LINE_CALLBACK = (0x00000092) # macro
AMPERE_SMC_MONITOR_SESSION = (0x0000c640) # macro
HOPPER_A = (0x0000cb97) # macro
HOPPER_COMPUTE_A = (0x0000cbc0) # macro
NV40_DEBUG_BUFFER = (0x000000db) # macro
RM_USER_SHARED_DATA = (0x000000de) # macro
GT200_DEBUGGER = (0x000083de) # macro
NV40_I2C = (0x0000402c) # macro
KEPLER_DEVICE_VGPU = (0x0000a080) # macro
NVA081_VGPU_CONFIG = (0x0000a081) # macro
NVA084_KERNEL_HOST_VGPU_DEVICE = (0x0000a084) # macro
NV0060_SYNC_GPU_BOOST = (0x00000060) # macro
GP100_UVM_SW = (0x0000c076) # macro
NVENC_SW_SESSION = (0x0000a0bc) # macro
NV_EVENT_BUFFER = (0x000090cd) # macro
NVFBC_SW_SESSION = (0x0000a0bd) # macro
NV_CONFIDENTIAL_COMPUTE = (0x0000cb33) # macro
NV_COUNTER_COLLECTION_UNIT = (0x0000cbca) # macro
NV_SEMAPHORE_SURFACE = (0x000000da) # macro
_cl_ampere_compute_a_h_ = True # macro
NVC6C0_SET_OBJECT = 0x0000 # macro
NVC6C0_SET_OBJECT_CLASS_ID = ['15', ':', '0'] # macro
NVC6C0_SET_OBJECT_ENGINE_ID = ['20', ':', '16'] # macro
NVC6C0_NO_OPERATION = 0x0100 # macro
NVC6C0_NO_OPERATION_V = ['31', ':', '0'] # macro
NVC6C0_SET_NOTIFY_A = 0x0104 # macro
NVC6C0_SET_NOTIFY_A_ADDRESS_UPPER = ['7', ':', '0'] # macro
NVC6C0_SET_NOTIFY_B = 0x0108 # macro
NVC6C0_SET_NOTIFY_B_ADDRESS_LOWER = ['31', ':', '0'] # macro
NVC6C0_NOTIFY = 0x010c # macro
NVC6C0_NOTIFY_TYPE = ['31', ':', '0'] # macro
NVC6C0_NOTIFY_TYPE_WRITE_ONLY = 0x00000000 # macro
NVC6C0_NOTIFY_TYPE_WRITE_THEN_AWAKEN = 0x00000001 # macro
NVC6C0_WAIT_FOR_IDLE = 0x0110 # macro
NVC6C0_WAIT_FOR_IDLE_V = ['31', ':', '0'] # macro
NVC6C0_SET_GLOBAL_RENDER_ENABLE_A = 0x0130 # macro
NVC6C0_SET_GLOBAL_RENDER_ENABLE_A_OFFSET_UPPER = ['7', ':', '0'] # macro
NVC6C0_SET_GLOBAL_RENDER_ENABLE_B = 0x0134 # macro
NVC6C0_SET_GLOBAL_RENDER_ENABLE_B_OFFSET_LOWER = ['31', ':', '0'] # macro
NVC6C0_SET_GLOBAL_RENDER_ENABLE_C = 0x0138 # macro
NVC6C0_SET_GLOBAL_RENDER_ENABLE_C_MODE = ['2', ':', '0'] # macro
NVC6C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_FALSE = 0x00000000 # macro
NVC6C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_TRUE = 0x00000001 # macro
NVC6C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_CONDITIONAL = 0x00000002 # macro
NVC6C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL = 0x00000003 # macro
NVC6C0_SET_GLOBAL_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL = 0x00000004 # macro
NVC6C0_SEND_GO_IDLE = 0x013c # macro
NVC6C0_SEND_GO_IDLE_V = ['31', ':', '0'] # macro
NVC6C0_PM_TRIGGER = 0x0140 # macro
NVC6C0_PM_TRIGGER_V = ['31', ':', '0'] # macro
NVC6C0_PM_TRIGGER_WFI = 0x0144 # macro
NVC6C0_PM_TRIGGER_WFI_V = ['31', ':', '0'] # macro
NVC6C0_FE_ATOMIC_SEQUENCE_BEGIN = 0x0148 # macro
NVC6C0_FE_ATOMIC_SEQUENCE_BEGIN_V = ['31', ':', '0'] # macro
NVC6C0_FE_ATOMIC_SEQUENCE_END = 0x014c # macro
NVC6C0_FE_ATOMIC_SEQUENCE_END_V = ['31', ':', '0'] # macro
NVC6C0_SET_INSTRUMENTATION_METHOD_HEADER = 0x0150 # macro
NVC6C0_SET_INSTRUMENTATION_METHOD_HEADER_V = ['31', ':', '0'] # macro
NVC6C0_SET_INSTRUMENTATION_METHOD_DATA = 0x0154 # macro
NVC6C0_SET_INSTRUMENTATION_METHOD_DATA_V = ['31', ':', '0'] # macro
NVC6C0_LINE_LENGTH_IN = 0x0180 # macro
NVC6C0_LINE_LENGTH_IN_VALUE = ['31', ':', '0'] # macro
NVC6C0_LINE_COUNT = 0x0184 # macro
NVC6C0_LINE_COUNT_VALUE = ['31', ':', '0'] # macro
NVC6C0_OFFSET_OUT_UPPER = 0x0188 # macro
NVC6C0_OFFSET_OUT_UPPER_VALUE = ['16', ':', '0'] # macro
NVC6C0_OFFSET_OUT = 0x018c # macro
NVC6C0_OFFSET_OUT_VALUE = ['31', ':', '0'] # macro
NVC6C0_PITCH_OUT = 0x0190 # macro
NVC6C0_PITCH_OUT_VALUE = ['31', ':', '0'] # macro
NVC6C0_SET_DST_BLOCK_SIZE = 0x0194 # macro
NVC6C0_SET_DST_BLOCK_SIZE_WIDTH = ['3', ':', '0'] # macro
NVC6C0_SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB = 0x00000000 # macro
NVC6C0_SET_DST_BLOCK_SIZE_HEIGHT = ['7', ':', '4'] # macro
NVC6C0_SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB = 0x00000000 # macro
NVC6C0_SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS = 0x00000001 # macro
NVC6C0_SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS = 0x00000002 # macro
NVC6C0_SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS = 0x00000003 # macro
NVC6C0_SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS = 0x00000004 # macro
NVC6C0_SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS = 0x00000005 # macro
NVC6C0_SET_DST_BLOCK_SIZE_DEPTH = ['11', ':', '8'] # macro
NVC6C0_SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB = 0x00000000 # macro
NVC6C0_SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS = 0x00000001 # macro
NVC6C0_SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS = 0x00000002 # macro
NVC6C0_SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS = 0x00000003 # macro
NVC6C0_SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS = 0x00000004 # macro
NVC6C0_SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS = 0x00000005 # macro
NVC6C0_SET_DST_WIDTH = 0x0198 # macro
NVC6C0_SET_DST_WIDTH_V = ['31', ':', '0'] # macro
NVC6C0_SET_DST_HEIGHT = 0x019c # macro
NVC6C0_SET_DST_HEIGHT_V = ['31', ':', '0'] # macro
NVC6C0_SET_DST_DEPTH = 0x01a0 # macro
NVC6C0_SET_DST_DEPTH_V = ['31', ':', '0'] # macro
NVC6C0_SET_DST_LAYER = 0x01a4 # macro
NVC6C0_SET_DST_LAYER_V = ['31', ':', '0'] # macro
NVC6C0_SET_DST_ORIGIN_BYTES_X = 0x01a8 # macro
NVC6C0_SET_DST_ORIGIN_BYTES_X_V = ['20', ':', '0'] # macro
NVC6C0_SET_DST_ORIGIN_SAMPLES_Y = 0x01ac # macro
NVC6C0_SET_DST_ORIGIN_SAMPLES_Y_V = ['16', ':', '0'] # macro
NVC6C0_LAUNCH_DMA = 0x01b0 # macro
NVC6C0_LAUNCH_DMA_DST_MEMORY_LAYOUT = ['0', ':', '0'] # macro
NVC6C0_LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR = 0x00000000 # macro
NVC6C0_LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH = 0x00000001 # macro
NVC6C0_LAUNCH_DMA_COMPLETION_TYPE = ['5', ':', '4'] # macro
NVC6C0_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_DISABLE = 0x00000000 # macro
NVC6C0_LAUNCH_DMA_COMPLETION_TYPE_FLUSH_ONLY = 0x00000001 # macro
NVC6C0_LAUNCH_DMA_COMPLETION_TYPE_RELEASE_SEMAPHORE = 0x00000002 # macro
NVC6C0_LAUNCH_DMA_INTERRUPT_TYPE = ['9', ':', '8'] # macro
NVC6C0_LAUNCH_DMA_INTERRUPT_TYPE_NONE = 0x00000000 # macro
NVC6C0_LAUNCH_DMA_INTERRUPT_TYPE_INTERRUPT = 0x00000001 # macro
NVC6C0_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE = ['12', ':', '12'] # macro
NVC6C0_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_FOUR_WORDS = 0x00000000 # macro
NVC6C0_LAUNCH_DMA_SEMAPHORE_STRUCT_SIZE_ONE_WORD = 0x00000001 # macro
NVC6C0_LAUNCH_DMA_REDUCTION_ENABLE = ['1', ':', '1'] # macro
NVC6C0_LAUNCH_DMA_REDUCTION_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_LAUNCH_DMA_REDUCTION_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_LAUNCH_DMA_REDUCTION_OP = ['15', ':', '13'] # macro
NVC6C0_LAUNCH_DMA_REDUCTION_OP_RED_ADD = 0x00000000 # macro
NVC6C0_LAUNCH_DMA_REDUCTION_OP_RED_MIN = 0x00000001 # macro
NVC6C0_LAUNCH_DMA_REDUCTION_OP_RED_MAX = 0x00000002 # macro
NVC6C0_LAUNCH_DMA_REDUCTION_OP_RED_INC = 0x00000003 # macro
NVC6C0_LAUNCH_DMA_REDUCTION_OP_RED_DEC = 0x00000004 # macro
NVC6C0_LAUNCH_DMA_REDUCTION_OP_RED_AND = 0x00000005 # macro
NVC6C0_LAUNCH_DMA_REDUCTION_OP_RED_OR = 0x00000006 # macro
NVC6C0_LAUNCH_DMA_REDUCTION_OP_RED_XOR = 0x00000007 # macro
NVC6C0_LAUNCH_DMA_REDUCTION_FORMAT = ['3', ':', '2'] # macro
NVC6C0_LAUNCH_DMA_REDUCTION_FORMAT_UNSIGNED_32 = 0x00000000 # macro
NVC6C0_LAUNCH_DMA_REDUCTION_FORMAT_SIGNED_32 = 0x00000001 # macro
NVC6C0_LAUNCH_DMA_SYSMEMBAR_DISABLE = ['6', ':', '6'] # macro
NVC6C0_LAUNCH_DMA_SYSMEMBAR_DISABLE_FALSE = 0x00000000 # macro
NVC6C0_LAUNCH_DMA_SYSMEMBAR_DISABLE_TRUE = 0x00000001 # macro
NVC6C0_LOAD_INLINE_DATA = 0x01b4 # macro
NVC6C0_LOAD_INLINE_DATA_V = ['31', ':', '0'] # macro
NVC6C0_SET_I2M_SEMAPHORE_A = 0x01dc # macro
NVC6C0_SET_I2M_SEMAPHORE_A_OFFSET_UPPER = ['7', ':', '0'] # macro
NVC6C0_SET_I2M_SEMAPHORE_B = 0x01e0 # macro
NVC6C0_SET_I2M_SEMAPHORE_B_OFFSET_LOWER = ['31', ':', '0'] # macro
NVC6C0_SET_I2M_SEMAPHORE_C = 0x01e4 # macro
NVC6C0_SET_I2M_SEMAPHORE_C_PAYLOAD = ['31', ':', '0'] # macro
NVC6C0_SET_SM_SCG_CONTROL = 0x01e8 # macro
NVC6C0_SET_SM_SCG_CONTROL_COMPUTE_IN_GRAPHICS = ['0', ':', '0'] # macro
NVC6C0_SET_SM_SCG_CONTROL_COMPUTE_IN_GRAPHICS_FALSE = 0x00000000 # macro
NVC6C0_SET_SM_SCG_CONTROL_COMPUTE_IN_GRAPHICS_TRUE = 0x00000001 # macro
NVC6C0_SET_I2M_SPARE_NOOP00 = 0x01f0 # macro
NVC6C0_SET_I2M_SPARE_NOOP00_V = ['31', ':', '0'] # macro
NVC6C0_SET_I2M_SPARE_NOOP01 = 0x01f4 # macro
NVC6C0_SET_I2M_SPARE_NOOP01_V = ['31', ':', '0'] # macro
NVC6C0_SET_I2M_SPARE_NOOP02 = 0x01f8 # macro
NVC6C0_SET_I2M_SPARE_NOOP02_V = ['31', ':', '0'] # macro
NVC6C0_SET_I2M_SPARE_NOOP03 = 0x01fc # macro
NVC6C0_SET_I2M_SPARE_NOOP03_V = ['31', ':', '0'] # macro
NVC6C0_SET_VALID_SPAN_OVERFLOW_AREA_A = 0x0200 # macro
NVC6C0_SET_VALID_SPAN_OVERFLOW_AREA_A_ADDRESS_UPPER = ['7', ':', '0'] # macro
NVC6C0_SET_VALID_SPAN_OVERFLOW_AREA_B = 0x0204 # macro
NVC6C0_SET_VALID_SPAN_OVERFLOW_AREA_B_ADDRESS_LOWER = ['31', ':', '0'] # macro
NVC6C0_SET_VALID_SPAN_OVERFLOW_AREA_C = 0x0208 # macro
NVC6C0_SET_VALID_SPAN_OVERFLOW_AREA_C_SIZE = ['31', ':', '0'] # macro
NVC6C0_PERFMON_TRANSFER = 0x0210 # macro
NVC6C0_PERFMON_TRANSFER_V = ['31', ':', '0'] # macro
NVC6C0_SET_QMD_VIRTUALIZATION_BASE_A = 0x0214 # macro
NVC6C0_SET_QMD_VIRTUALIZATION_BASE_A_ADDRESS_UPPER = ['7', ':', '0'] # macro
NVC6C0_SET_QMD_VIRTUALIZATION_BASE_B = 0x0218 # macro
NVC6C0_SET_QMD_VIRTUALIZATION_BASE_B_ADDRESS_LOWER = ['31', ':', '0'] # macro
NVC6C0_INVALIDATE_SHADER_CACHES = 0x021c # macro
NVC6C0_INVALIDATE_SHADER_CACHES_INSTRUCTION = ['0', ':', '0'] # macro
NVC6C0_INVALIDATE_SHADER_CACHES_INSTRUCTION_FALSE = 0x00000000 # macro
NVC6C0_INVALIDATE_SHADER_CACHES_INSTRUCTION_TRUE = 0x00000001 # macro
NVC6C0_INVALIDATE_SHADER_CACHES_DATA = ['4', ':', '4'] # macro
NVC6C0_INVALIDATE_SHADER_CACHES_DATA_FALSE = 0x00000000 # macro
NVC6C0_INVALIDATE_SHADER_CACHES_DATA_TRUE = 0x00000001 # macro
NVC6C0_INVALIDATE_SHADER_CACHES_CONSTANT = ['12', ':', '12'] # macro
NVC6C0_INVALIDATE_SHADER_CACHES_CONSTANT_FALSE = 0x00000000 # macro
NVC6C0_INVALIDATE_SHADER_CACHES_CONSTANT_TRUE = 0x00000001 # macro
NVC6C0_INVALIDATE_SHADER_CACHES_LOCKS = ['1', ':', '1'] # macro
NVC6C0_INVALIDATE_SHADER_CACHES_LOCKS_FALSE = 0x00000000 # macro
NVC6C0_INVALIDATE_SHADER_CACHES_LOCKS_TRUE = 0x00000001 # macro
NVC6C0_INVALIDATE_SHADER_CACHES_FLUSH_DATA = ['2', ':', '2'] # macro
NVC6C0_INVALIDATE_SHADER_CACHES_FLUSH_DATA_FALSE = 0x00000000 # macro
NVC6C0_INVALIDATE_SHADER_CACHES_FLUSH_DATA_TRUE = 0x00000001 # macro
NVC6C0_SET_RESERVED_SW_METHOD00 = 0x0220 # macro
NVC6C0_SET_RESERVED_SW_METHOD00_V = ['31', ':', '0'] # macro
NVC6C0_SET_RESERVED_SW_METHOD01 = 0x0224 # macro
NVC6C0_SET_RESERVED_SW_METHOD01_V = ['31', ':', '0'] # macro
NVC6C0_SET_RESERVED_SW_METHOD02 = 0x0228 # macro
NVC6C0_SET_RESERVED_SW_METHOD02_V = ['31', ':', '0'] # macro
NVC6C0_SET_RESERVED_SW_METHOD03 = 0x022c # macro
NVC6C0_SET_RESERVED_SW_METHOD03_V = ['31', ':', '0'] # macro
NVC6C0_SET_RESERVED_SW_METHOD04 = 0x0230 # macro
NVC6C0_SET_RESERVED_SW_METHOD04_V = ['31', ':', '0'] # macro
NVC6C0_SET_RESERVED_SW_METHOD05 = 0x0234 # macro
NVC6C0_SET_RESERVED_SW_METHOD05_V = ['31', ':', '0'] # macro
NVC6C0_SET_RESERVED_SW_METHOD06 = 0x0238 # macro
NVC6C0_SET_RESERVED_SW_METHOD06_V = ['31', ':', '0'] # macro
NVC6C0_SET_RESERVED_SW_METHOD07 = 0x023c # macro
NVC6C0_SET_RESERVED_SW_METHOD07_V = ['31', ':', '0'] # macro
NVC6C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI = 0x0244 # macro
NVC6C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES = ['0', ':', '0'] # macro
NVC6C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ALL = 0x00000000 # macro
NVC6C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_LINES_ONE = 0x00000001 # macro
NVC6C0_INVALIDATE_TEXTURE_HEADER_CACHE_NO_WFI_TAG = ['25', ':', '4'] # macro
NVC6C0_SET_CWD_REF_COUNTER = 0x0248 # macro
NVC6C0_SET_CWD_REF_COUNTER_SELECT = ['5', ':', '0'] # macro
NVC6C0_SET_CWD_REF_COUNTER_VALUE = ['23', ':', '8'] # macro
NVC6C0_SET_RESERVED_SW_METHOD08 = 0x024c # macro
NVC6C0_SET_RESERVED_SW_METHOD08_V = ['31', ':', '0'] # macro
NVC6C0_SET_RESERVED_SW_METHOD09 = 0x0250 # macro
NVC6C0_SET_RESERVED_SW_METHOD09_V = ['31', ':', '0'] # macro
NVC6C0_SET_RESERVED_SW_METHOD10 = 0x0254 # macro
NVC6C0_SET_RESERVED_SW_METHOD10_V = ['31', ':', '0'] # macro
NVC6C0_SET_RESERVED_SW_METHOD11 = 0x0258 # macro
NVC6C0_SET_RESERVED_SW_METHOD11_V = ['31', ':', '0'] # macro
NVC6C0_SET_RESERVED_SW_METHOD12 = 0x025c # macro
NVC6C0_SET_RESERVED_SW_METHOD12_V = ['31', ':', '0'] # macro
NVC6C0_SET_RESERVED_SW_METHOD13 = 0x0260 # macro
NVC6C0_SET_RESERVED_SW_METHOD13_V = ['31', ':', '0'] # macro
NVC6C0_SET_RESERVED_SW_METHOD14 = 0x0264 # macro
NVC6C0_SET_RESERVED_SW_METHOD14_V = ['31', ':', '0'] # macro
NVC6C0_SET_RESERVED_SW_METHOD15 = 0x0268 # macro
NVC6C0_SET_RESERVED_SW_METHOD15_V = ['31', ':', '0'] # macro
NVC6C0_SET_SCG_CONTROL = 0x0270 # macro
NVC6C0_SET_SCG_CONTROL_COMPUTE1_MAX_SM_COUNT = ['8', ':', '0'] # macro
NVC6C0_SET_SCG_CONTROL_COMPUTE1_MIN_SM_COUNT = ['20', ':', '12'] # macro
NVC6C0_SET_SCG_CONTROL_DISABLE_COMPUTE1_LIMIT_IN_ALL_COMPUTE = ['24', ':', '24'] # macro
NVC6C0_SET_SCG_CONTROL_DISABLE_COMPUTE1_LIMIT_IN_ALL_COMPUTE_FALSE = 0x00000000 # macro
NVC6C0_SET_SCG_CONTROL_DISABLE_COMPUTE1_LIMIT_IN_ALL_COMPUTE_TRUE = 0x00000001 # macro
NVC6C0_SET_COMPUTE_CLASS_VERSION = 0x0280 # macro
NVC6C0_SET_COMPUTE_CLASS_VERSION_CURRENT = ['15', ':', '0'] # macro
NVC6C0_SET_COMPUTE_CLASS_VERSION_OLDEST_SUPPORTED = ['31', ':', '16'] # macro
NVC6C0_CHECK_COMPUTE_CLASS_VERSION = 0x0284 # macro
NVC6C0_CHECK_COMPUTE_CLASS_VERSION_CURRENT = ['15', ':', '0'] # macro
NVC6C0_CHECK_COMPUTE_CLASS_VERSION_OLDEST_SUPPORTED = ['31', ':', '16'] # macro
NVC6C0_SET_QMD_VERSION = 0x0288 # macro
NVC6C0_SET_QMD_VERSION_CURRENT = ['15', ':', '0'] # macro
NVC6C0_SET_QMD_VERSION_OLDEST_SUPPORTED = ['31', ':', '16'] # macro
NVC6C0_CHECK_QMD_VERSION = 0x0290 # macro
NVC6C0_CHECK_QMD_VERSION_CURRENT = ['15', ':', '0'] # macro
NVC6C0_CHECK_QMD_VERSION_OLDEST_SUPPORTED = ['31', ':', '16'] # macro
NVC6C0_INVALIDATE_SKED_CACHES = 0x0298 # macro
NVC6C0_INVALIDATE_SKED_CACHES_V = ['0', ':', '0'] # macro
NVC6C0_SET_QMD_VIRTUALIZATION_CONTROL = 0x029c # macro
NVC6C0_SET_QMD_VIRTUALIZATION_CONTROL_CONSTANT_BUFFER_MASK = ['7', ':', '0'] # macro
NVC6C0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_ADDR_ENABLE = ['8', ':', '8'] # macro
NVC6C0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_ADDR_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_ADDR_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_CONSTANT_BUFFER_ENABLE = ['12', ':', '12'] # macro
NVC6C0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_CONSTANT_BUFFER_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_SET_QMD_VIRTUALIZATION_CONTROL_I2M_CONSTANT_BUFFER_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_ADDR_ENABLE = ['16', ':', '16'] # macro
NVC6C0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_ADDR_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_ADDR_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_CONSTANT_BUFFER_ENABLE = ['20', ':', '20'] # macro
NVC6C0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_CONSTANT_BUFFER_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_SET_QMD_VIRTUALIZATION_CONTROL_IQ2M_CONSTANT_BUFFER_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_SET_QMD_VIRTUALIZATION_CONTROL_SEND_PCAS_ENABLE = ['24', ':', '24'] # macro
NVC6C0_SET_QMD_VIRTUALIZATION_CONTROL_SEND_PCAS_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_SET_QMD_VIRTUALIZATION_CONTROL_SEND_PCAS_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_SET_SHADER_SHARED_MEMORY_WINDOW_A = 0x02a0 # macro
NVC6C0_SET_SHADER_SHARED_MEMORY_WINDOW_A_BASE_ADDRESS_UPPER = ['16', ':', '0'] # macro
NVC6C0_SET_SHADER_SHARED_MEMORY_WINDOW_B = 0x02a4 # macro
NVC6C0_SET_SHADER_SHARED_MEMORY_WINDOW_B_BASE_ADDRESS = ['31', ':', '0'] # macro
NVC6C0_SCG_HYSTERESIS_CONTROL = 0x02a8 # macro
NVC6C0_SCG_HYSTERESIS_CONTROL_USE_TIMEOUT_ONCE = ['0', ':', '0'] # macro
NVC6C0_SCG_HYSTERESIS_CONTROL_USE_TIMEOUT_ONCE_FALSE = 0x00000000 # macro
NVC6C0_SCG_HYSTERESIS_CONTROL_USE_TIMEOUT_ONCE_TRUE = 0x00000001 # macro
NVC6C0_SCG_HYSTERESIS_CONTROL_USE_NULL_TIMEOUT_ONCE = ['1', ':', '1'] # macro
NVC6C0_SCG_HYSTERESIS_CONTROL_USE_NULL_TIMEOUT_ONCE_FALSE = 0x00000000 # macro
NVC6C0_SCG_HYSTERESIS_CONTROL_USE_NULL_TIMEOUT_ONCE_TRUE = 0x00000001 # macro
NVC6C0_SET_CWD_SLOT_COUNT = 0x02b0 # macro
NVC6C0_SET_CWD_SLOT_COUNT_V = ['7', ':', '0'] # macro
NVC6C0_SEND_PCAS_A = 0x02b4 # macro
NVC6C0_SEND_PCAS_A_QMD_ADDRESS_SHIFTED8 = ['31', ':', '0'] # macro
NVC6C0_SEND_PCAS_B = 0x02b8 # macro
NVC6C0_SEND_PCAS_B_FROM = ['23', ':', '0'] # macro
NVC6C0_SEND_PCAS_B_DELTA = ['31', ':', '24'] # macro
NVC6C0_SEND_SIGNALING_PCAS_B = 0x02bc # macro
NVC6C0_SEND_SIGNALING_PCAS_B_INVALIDATE = ['0', ':', '0'] # macro
NVC6C0_SEND_SIGNALING_PCAS_B_INVALIDATE_FALSE = 0x00000000 # macro
NVC6C0_SEND_SIGNALING_PCAS_B_INVALIDATE_TRUE = 0x00000001 # macro
NVC6C0_SEND_SIGNALING_PCAS_B_SCHEDULE = ['1', ':', '1'] # macro
NVC6C0_SEND_SIGNALING_PCAS_B_SCHEDULE_FALSE = 0x00000000 # macro
NVC6C0_SEND_SIGNALING_PCAS_B_SCHEDULE_TRUE = 0x00000001 # macro
NVC6C0_SEND_SIGNALING_PCAS2_B = 0x02c0 # macro
NVC6C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION = ['3', ':', '0'] # macro
NVC6C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_NOP = 0x00000000 # macro
NVC6C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INVALIDATE = 0x00000001 # macro
NVC6C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_SCHEDULE = 0x00000002 # macro
NVC6C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INVALIDATE_COPY_SCHEDULE = 0x00000003 # macro
NVC6C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INCREMENT_PUT = 0x00000006 # macro
NVC6C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_DECREMENT_DEPENDENCE = 0x00000007 # macro
NVC6C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_PREFETCH = 0x00000008 # macro
NVC6C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_PREFETCH_SCHEDULE = 0x00000009 # macro
NVC6C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INVALIDATE_PREFETCH_COPY_SCHEDULE = 0x0000000A # macro
NVC6C0_SEND_SIGNALING_PCAS2_B_PCAS_ACTION_INVALIDATE_PREFETCH_COPY_FORCE_REQUIRE_SCHEDULING = 0x0000000B # macro
NVC6C0_SET_SKED_CACHE_CONTROL = 0x02cc # macro
NVC6C0_SET_SKED_CACHE_CONTROL_IGNORE_VEID = ['0', ':', '0'] # macro
NVC6C0_SET_SKED_CACHE_CONTROL_IGNORE_VEID_FALSE = 0x00000000 # macro
NVC6C0_SET_SKED_CACHE_CONTROL_IGNORE_VEID_TRUE = 0x00000001 # macro
NVC6C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_A = 0x02e4 # macro
NVC6C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_A_SIZE_UPPER = ['7', ':', '0'] # macro
NVC6C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_B = 0x02e8 # macro
NVC6C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_B_SIZE_LOWER = ['31', ':', '0'] # macro
NVC6C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_C = 0x02ec # macro
NVC6C0_SET_SHADER_LOCAL_MEMORY_NON_THROTTLED_C_MAX_SM_COUNT = ['8', ':', '0'] # macro
NVC6C0_SET_SPA_VERSION = 0x0310 # macro
NVC6C0_SET_SPA_VERSION_MINOR = ['7', ':', '0'] # macro
NVC6C0_SET_SPA_VERSION_MAJOR = ['15', ':', '8'] # macro
NVC6C0_SET_INLINE_QMD_ADDRESS_A = 0x0318 # macro
NVC6C0_SET_INLINE_QMD_ADDRESS_A_QMD_ADDRESS_SHIFTED8_UPPER = ['31', ':', '0'] # macro
NVC6C0_SET_INLINE_QMD_ADDRESS_B = 0x031c # macro
NVC6C0_SET_INLINE_QMD_ADDRESS_B_QMD_ADDRESS_SHIFTED8_LOWER = ['31', ':', '0'] # macro
# def NVC6C0_LOAD_INLINE_QMD_DATA(i):  # macro
#    return (0x0320+(i)*4)
NVC6C0_LOAD_INLINE_QMD_DATA_V = ['31', ':', '0'] # macro
NVC6C0_SET_FALCON00 = 0x0500 # macro
NVC6C0_SET_FALCON00_V = ['31', ':', '0'] # macro
NVC6C0_SET_FALCON01 = 0x0504 # macro
NVC6C0_SET_FALCON01_V = ['31', ':', '0'] # macro
NVC6C0_SET_FALCON02 = 0x0508 # macro
NVC6C0_SET_FALCON02_V = ['31', ':', '0'] # macro
NVC6C0_SET_FALCON03 = 0x050c # macro
NVC6C0_SET_FALCON03_V = ['31', ':', '0'] # macro
NVC6C0_SET_FALCON04 = 0x0510 # macro
NVC6C0_SET_FALCON04_V = ['31', ':', '0'] # macro
NVC6C0_SET_FALCON05 = 0x0514 # macro
NVC6C0_SET_FALCON05_V = ['31', ':', '0'] # macro
NVC6C0_SET_FALCON06 = 0x0518 # macro
NVC6C0_SET_FALCON06_V = ['31', ':', '0'] # macro
NVC6C0_SET_FALCON07 = 0x051c # macro
NVC6C0_SET_FALCON07_V = ['31', ':', '0'] # macro
NVC6C0_SET_FALCON08 = 0x0520 # macro
NVC6C0_SET_FALCON08_V = ['31', ':', '0'] # macro
NVC6C0_SET_FALCON09 = 0x0524 # macro
NVC6C0_SET_FALCON09_V = ['31', ':', '0'] # macro
NVC6C0_SET_FALCON10 = 0x0528 # macro
NVC6C0_SET_FALCON10_V = ['31', ':', '0'] # macro
NVC6C0_SET_FALCON11 = 0x052c # macro
NVC6C0_SET_FALCON11_V = ['31', ':', '0'] # macro
NVC6C0_SET_FALCON12 = 0x0530 # macro
NVC6C0_SET_FALCON12_V = ['31', ':', '0'] # macro
NVC6C0_SET_FALCON13 = 0x0534 # macro
NVC6C0_SET_FALCON13_V = ['31', ':', '0'] # macro
NVC6C0_SET_FALCON14 = 0x0538 # macro
NVC6C0_SET_FALCON14_V = ['31', ':', '0'] # macro
NVC6C0_SET_FALCON15 = 0x053c # macro
NVC6C0_SET_FALCON15_V = ['31', ':', '0'] # macro
NVC6C0_SET_SHADER_LOCAL_MEMORY_A = 0x0790 # macro
NVC6C0_SET_SHADER_LOCAL_MEMORY_A_ADDRESS_UPPER = ['16', ':', '0'] # macro
NVC6C0_SET_SHADER_LOCAL_MEMORY_B = 0x0794 # macro
NVC6C0_SET_SHADER_LOCAL_MEMORY_B_ADDRESS_LOWER = ['31', ':', '0'] # macro
NVC6C0_SET_SHADER_LOCAL_MEMORY_WINDOW_A = 0x07b0 # macro
NVC6C0_SET_SHADER_LOCAL_MEMORY_WINDOW_A_BASE_ADDRESS_UPPER = ['16', ':', '0'] # macro
NVC6C0_SET_SHADER_LOCAL_MEMORY_WINDOW_B = 0x07b4 # macro
NVC6C0_SET_SHADER_LOCAL_MEMORY_WINDOW_B_BASE_ADDRESS = ['31', ':', '0'] # macro
NVC6C0_SET_SHADER_CACHE_CONTROL = 0x0d94 # macro
NVC6C0_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE = ['0', ':', '0'] # macro
NVC6C0_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_SET_SHADER_CACHE_CONTROL_ICACHE_PREFETCH_ENABLE_TRUE = 0x00000001 # macro
# def NVC6C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS(i):  # macro
#    return (0x0da0+(i)*4)
NVC6C0_SET_SCG_COMPUTE_SCHEDULING_PARAMETERS_V = ['31', ':', '0'] # macro
NVC6C0_SET_SM_TIMEOUT_INTERVAL = 0x0de4 # macro
NVC6C0_SET_SM_TIMEOUT_INTERVAL_COUNTER_BIT = ['5', ':', '0'] # macro
NVC6C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI = 0x1288 # macro
NVC6C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES = ['0', ':', '0'] # macro
NVC6C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ALL = 0x00000000 # macro
NVC6C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_LINES_ONE = 0x00000001 # macro
NVC6C0_INVALIDATE_TEXTURE_DATA_CACHE_NO_WFI_TAG = ['25', ':', '4'] # macro
NVC6C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT = 0x12a8 # macro
NVC6C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT_ALL = ['0', ':', '0'] # macro
NVC6C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT_ALL_FALSE = 0x00000000 # macro
NVC6C0_ACTIVATE_PERF_SETTINGS_FOR_COMPUTE_CONTEXT_ALL_TRUE = 0x00000001 # macro
NVC6C0_INVALIDATE_SAMPLER_CACHE = 0x1330 # macro
NVC6C0_INVALIDATE_SAMPLER_CACHE_LINES = ['0', ':', '0'] # macro
NVC6C0_INVALIDATE_SAMPLER_CACHE_LINES_ALL = 0x00000000 # macro
NVC6C0_INVALIDATE_SAMPLER_CACHE_LINES_ONE = 0x00000001 # macro
NVC6C0_INVALIDATE_SAMPLER_CACHE_TAG = ['25', ':', '4'] # macro
NVC6C0_INVALIDATE_TEXTURE_HEADER_CACHE = 0x1334 # macro
NVC6C0_INVALIDATE_TEXTURE_HEADER_CACHE_LINES = ['0', ':', '0'] # macro
NVC6C0_INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ALL = 0x00000000 # macro
NVC6C0_INVALIDATE_TEXTURE_HEADER_CACHE_LINES_ONE = 0x00000001 # macro
NVC6C0_INVALIDATE_TEXTURE_HEADER_CACHE_TAG = ['25', ':', '4'] # macro
NVC6C0_INVALIDATE_TEXTURE_DATA_CACHE = 0x1338 # macro
NVC6C0_INVALIDATE_TEXTURE_DATA_CACHE_LINES = ['0', ':', '0'] # macro
NVC6C0_INVALIDATE_TEXTURE_DATA_CACHE_LINES_ALL = 0x00000000 # macro
NVC6C0_INVALIDATE_TEXTURE_DATA_CACHE_LINES_ONE = 0x00000001 # macro
NVC6C0_INVALIDATE_TEXTURE_DATA_CACHE_TAG = ['25', ':', '4'] # macro
NVC6C0_INVALIDATE_SAMPLER_CACHE_NO_WFI = 0x1424 # macro
NVC6C0_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES = ['0', ':', '0'] # macro
NVC6C0_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ALL = 0x00000000 # macro
NVC6C0_INVALIDATE_SAMPLER_CACHE_NO_WFI_LINES_ONE = 0x00000001 # macro
NVC6C0_INVALIDATE_SAMPLER_CACHE_NO_WFI_TAG = ['25', ':', '4'] # macro
NVC6C0_SET_SHADER_EXCEPTIONS = 0x1528 # macro
NVC6C0_SET_SHADER_EXCEPTIONS_ENABLE = ['0', ':', '0'] # macro
NVC6C0_SET_SHADER_EXCEPTIONS_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_SET_SHADER_EXCEPTIONS_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_SET_RENDER_ENABLE_A = 0x1550 # macro
NVC6C0_SET_RENDER_ENABLE_A_OFFSET_UPPER = ['7', ':', '0'] # macro
NVC6C0_SET_RENDER_ENABLE_B = 0x1554 # macro
NVC6C0_SET_RENDER_ENABLE_B_OFFSET_LOWER = ['31', ':', '0'] # macro
NVC6C0_SET_RENDER_ENABLE_C = 0x1558 # macro
NVC6C0_SET_RENDER_ENABLE_C_MODE = ['2', ':', '0'] # macro
NVC6C0_SET_RENDER_ENABLE_C_MODE_FALSE = 0x00000000 # macro
NVC6C0_SET_RENDER_ENABLE_C_MODE_TRUE = 0x00000001 # macro
NVC6C0_SET_RENDER_ENABLE_C_MODE_CONDITIONAL = 0x00000002 # macro
NVC6C0_SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL = 0x00000003 # macro
NVC6C0_SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL = 0x00000004 # macro
NVC6C0_SET_TEX_SAMPLER_POOL_A = 0x155c # macro
NVC6C0_SET_TEX_SAMPLER_POOL_A_OFFSET_UPPER = ['16', ':', '0'] # macro
NVC6C0_SET_TEX_SAMPLER_POOL_B = 0x1560 # macro
NVC6C0_SET_TEX_SAMPLER_POOL_B_OFFSET_LOWER = ['31', ':', '0'] # macro
NVC6C0_SET_TEX_SAMPLER_POOL_C = 0x1564 # macro
NVC6C0_SET_TEX_SAMPLER_POOL_C_MAXIMUM_INDEX = ['19', ':', '0'] # macro
NVC6C0_SET_TEX_HEADER_POOL_A = 0x1574 # macro
NVC6C0_SET_TEX_HEADER_POOL_A_OFFSET_UPPER = ['16', ':', '0'] # macro
NVC6C0_SET_TEX_HEADER_POOL_B = 0x1578 # macro
NVC6C0_SET_TEX_HEADER_POOL_B_OFFSET_LOWER = ['31', ':', '0'] # macro
NVC6C0_SET_TEX_HEADER_POOL_C = 0x157c # macro
NVC6C0_SET_TEX_HEADER_POOL_C_MAXIMUM_INDEX = ['21', ':', '0'] # macro
NVC6C0_INVALIDATE_SHADER_CACHES_NO_WFI = 0x1698 # macro
NVC6C0_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION = ['0', ':', '0'] # macro
NVC6C0_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_FALSE = 0x00000000 # macro
NVC6C0_INVALIDATE_SHADER_CACHES_NO_WFI_INSTRUCTION_TRUE = 0x00000001 # macro
NVC6C0_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA = ['4', ':', '4'] # macro
NVC6C0_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_FALSE = 0x00000000 # macro
NVC6C0_INVALIDATE_SHADER_CACHES_NO_WFI_GLOBAL_DATA_TRUE = 0x00000001 # macro
NVC6C0_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT = ['12', ':', '12'] # macro
NVC6C0_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_FALSE = 0x00000000 # macro
NVC6C0_INVALIDATE_SHADER_CACHES_NO_WFI_CONSTANT_TRUE = 0x00000001 # macro
NVC6C0_SET_RENDER_ENABLE_OVERRIDE = 0x1944 # macro
NVC6C0_SET_RENDER_ENABLE_OVERRIDE_MODE = ['1', ':', '0'] # macro
NVC6C0_SET_RENDER_ENABLE_OVERRIDE_MODE_USE_RENDER_ENABLE = 0x00000000 # macro
NVC6C0_SET_RENDER_ENABLE_OVERRIDE_MODE_ALWAYS_RENDER = 0x00000001 # macro
NVC6C0_SET_RENDER_ENABLE_OVERRIDE_MODE_NEVER_RENDER = 0x00000002 # macro
NVC6C0_PIPE_NOP = 0x1a2c # macro
NVC6C0_PIPE_NOP_V = ['31', ':', '0'] # macro
NVC6C0_SET_SPARE00 = 0x1a30 # macro
NVC6C0_SET_SPARE00_V = ['31', ':', '0'] # macro
NVC6C0_SET_SPARE01 = 0x1a34 # macro
NVC6C0_SET_SPARE01_V = ['31', ':', '0'] # macro
NVC6C0_SET_SPARE02 = 0x1a38 # macro
NVC6C0_SET_SPARE02_V = ['31', ':', '0'] # macro
NVC6C0_SET_SPARE03 = 0x1a3c # macro
NVC6C0_SET_SPARE03_V = ['31', ':', '0'] # macro
NVC6C0_SET_REPORT_SEMAPHORE_A = 0x1b00 # macro
NVC6C0_SET_REPORT_SEMAPHORE_A_OFFSET_UPPER = ['7', ':', '0'] # macro
NVC6C0_SET_REPORT_SEMAPHORE_B = 0x1b04 # macro
NVC6C0_SET_REPORT_SEMAPHORE_B_OFFSET_LOWER = ['31', ':', '0'] # macro
NVC6C0_SET_REPORT_SEMAPHORE_C = 0x1b08 # macro
NVC6C0_SET_REPORT_SEMAPHORE_C_PAYLOAD = ['31', ':', '0'] # macro
NVC6C0_SET_REPORT_SEMAPHORE_D = 0x1b0c # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_OPERATION = ['1', ':', '0'] # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_OPERATION_RELEASE = 0x00000000 # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_OPERATION_TRAP = 0x00000003 # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE = ['20', ':', '20'] # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_AWAKEN_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE = ['28', ':', '28'] # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_FOUR_WORDS = 0x00000000 # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_STRUCTURE_SIZE_ONE_WORD = 0x00000001 # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE = ['2', ':', '2'] # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_FALSE = 0x00000000 # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_FLUSH_DISABLE_TRUE = 0x00000001 # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE = ['3', ':', '3'] # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_FALSE = 0x00000000 # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_REDUCTION_ENABLE_TRUE = 0x00000001 # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP = ['11', ':', '9'] # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_ADD = 0x00000000 # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MIN = 0x00000001 # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_MAX = 0x00000002 # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_INC = 0x00000003 # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_DEC = 0x00000004 # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_AND = 0x00000005 # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_OR = 0x00000006 # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_REDUCTION_OP_RED_XOR = 0x00000007 # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT = ['18', ':', '17'] # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_UNSIGNED_32 = 0x00000000 # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_REDUCTION_FORMAT_SIGNED_32 = 0x00000001 # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_CONDITIONAL_TRAP = ['19', ':', '19'] # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_CONDITIONAL_TRAP_FALSE = 0x00000000 # macro
NVC6C0_SET_REPORT_SEMAPHORE_D_CONDITIONAL_TRAP_TRUE = 0x00000001 # macro
NVC6C0_SET_TRAP_HANDLER_A = 0x25f8 # macro
NVC6C0_SET_TRAP_HANDLER_A_ADDRESS_UPPER = ['16', ':', '0'] # macro
NVC6C0_SET_TRAP_HANDLER_B = 0x25fc # macro
NVC6C0_SET_TRAP_HANDLER_B_ADDRESS_LOWER = ['31', ':', '0'] # macro
NVC6C0_SET_BINDLESS_TEXTURE = 0x2608 # macro
NVC6C0_SET_BINDLESS_TEXTURE_CONSTANT_BUFFER_SLOT_SELECT = ['2', ':', '0'] # macro
# def NVC6C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE(i):  # macro
#    return (0x32f4+(i)*4)
NVC6C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_V = ['31', ':', '0'] # macro
# def NVC6C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER(i):  # macro
#    return (0x3314+(i)*4)
NVC6C0_SET_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_VALUE_UPPER_V = ['31', ':', '0'] # macro
NVC6C0_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER = 0x3334 # macro
NVC6C0_ENABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_V = ['0', ':', '0'] # macro
NVC6C0_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER = 0x3338 # macro
NVC6C0_DISABLE_SHADER_PERFORMANCE_SNAPSHOT_COUNTER_V = ['0', ':', '0'] # macro
# def NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER(i):  # macro
#    return (0x333c+(i)*4)
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_UPPER_V = ['31', ':', '0'] # macro
# def NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE(i):  # macro
#    return (0x335c+(i)*4)
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_VALUE_V = ['31', ':', '0'] # macro
# def NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT(i):  # macro
#    return (0x337c+(i)*4)
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_EVENT_EVENT = ['7', ':', '0'] # macro
# def NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A(i):  # macro
#    return (0x339c+(i)*4)
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_EVENT0 = ['1', ':', '0'] # macro
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_BIT_SELECT0 = ['4', ':', '2'] # macro
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_EVENT1 = ['6', ':', '5'] # macro
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_BIT_SELECT1 = ['9', ':', '7'] # macro
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_EVENT2 = ['11', ':', '10'] # macro
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_BIT_SELECT2 = ['14', ':', '12'] # macro
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_EVENT3 = ['16', ':', '15'] # macro
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_BIT_SELECT3 = ['19', ':', '17'] # macro
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_EVENT4 = ['21', ':', '20'] # macro
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_BIT_SELECT4 = ['24', ':', '22'] # macro
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_EVENT5 = ['26', ':', '25'] # macro
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_BIT_SELECT5 = ['29', ':', '27'] # macro
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_A_SPARE = ['31', ':', '30'] # macro
# def NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B(i):  # macro
#    return (0x33bc+(i)*4)
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B_EDGE = ['0', ':', '0'] # macro
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B_MODE = ['2', ':', '1'] # macro
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B_WINDOWED = ['3', ':', '3'] # macro
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_CONTROL_B_FUNC = ['19', ':', '4'] # macro
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL = 0x33dc # macro
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_TRAP_CONTROL_MASK = ['7', ':', '0'] # macro
NVC6C0_START_SHADER_PERFORMANCE_COUNTER = 0x33e0 # macro
NVC6C0_START_SHADER_PERFORMANCE_COUNTER_COUNTER_MASK = ['7', ':', '0'] # macro
NVC6C0_STOP_SHADER_PERFORMANCE_COUNTER = 0x33e4 # macro
NVC6C0_STOP_SHADER_PERFORMANCE_COUNTER_COUNTER_MASK = ['7', ':', '0'] # macro
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER = 0x33e8 # macro
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_SCTL_FILTER_V = ['31', ':', '0'] # macro
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER = 0x33ec # macro
NVC6C0_SET_SHADER_PERFORMANCE_COUNTER_CORE_MIO_FILTER_V = ['31', ':', '0'] # macro
# def NVC6C0_SET_MME_SHADOW_SCRATCH(i):  # macro
#    return (0x3400+(i)*4)
NVC6C0_SET_MME_SHADOW_SCRATCH_V = ['31', ':', '0'] # macro
_clc6b5_h_ = True # macro
NVC6B5_NOP = (0x00000100) # macro
NVC6B5_NOP_PARAMETER = ['31', ':', '0'] # macro
NVC6B5_PM_TRIGGER = (0x00000140) # macro
NVC6B5_PM_TRIGGER_V = ['31', ':', '0'] # macro
NVC6B5_SET_SEMAPHORE_A = (0x00000240) # macro
NVC6B5_SET_SEMAPHORE_A_UPPER = ['16', ':', '0'] # macro
NVC6B5_SET_SEMAPHORE_B = (0x00000244) # macro
NVC6B5_SET_SEMAPHORE_B_LOWER = ['31', ':', '0'] # macro
NVC6B5_SET_SEMAPHORE_PAYLOAD = (0x00000248) # macro
NVC6B5_SET_SEMAPHORE_PAYLOAD_PAYLOAD = ['31', ':', '0'] # macro
NVC6B5_SET_RENDER_ENABLE_A = (0x00000254) # macro
NVC6B5_SET_RENDER_ENABLE_A_UPPER = ['7', ':', '0'] # macro
NVC6B5_SET_RENDER_ENABLE_B = (0x00000258) # macro
NVC6B5_SET_RENDER_ENABLE_B_LOWER = ['31', ':', '0'] # macro
NVC6B5_SET_RENDER_ENABLE_C = (0x0000025C) # macro
NVC6B5_SET_RENDER_ENABLE_C_MODE = ['2', ':', '0'] # macro
NVC6B5_SET_RENDER_ENABLE_C_MODE_FALSE = (0x00000000) # macro
NVC6B5_SET_RENDER_ENABLE_C_MODE_TRUE = (0x00000001) # macro
NVC6B5_SET_RENDER_ENABLE_C_MODE_CONDITIONAL = (0x00000002) # macro
NVC6B5_SET_RENDER_ENABLE_C_MODE_RENDER_IF_EQUAL = (0x00000003) # macro
NVC6B5_SET_RENDER_ENABLE_C_MODE_RENDER_IF_NOT_EQUAL = (0x00000004) # macro
NVC6B5_SET_SRC_PHYS_MODE = (0x00000260) # macro
NVC6B5_SET_SRC_PHYS_MODE_TARGET = ['1', ':', '0'] # macro
NVC6B5_SET_SRC_PHYS_MODE_TARGET_LOCAL_FB = (0x00000000) # macro
NVC6B5_SET_SRC_PHYS_MODE_TARGET_COHERENT_SYSMEM = (0x00000001) # macro
NVC6B5_SET_SRC_PHYS_MODE_TARGET_NONCOHERENT_SYSMEM = (0x00000002) # macro
NVC6B5_SET_SRC_PHYS_MODE_TARGET_PEERMEM = (0x00000003) # macro
NVC6B5_SET_SRC_PHYS_MODE_BASIC_KIND = ['5', ':', '2'] # macro
NVC6B5_SET_SRC_PHYS_MODE_PEER_ID = ['8', ':', '6'] # macro
NVC6B5_SET_SRC_PHYS_MODE_FLA = ['9', ':', '9'] # macro
NVC6B5_SET_DST_PHYS_MODE = (0x00000264) # macro
NVC6B5_SET_DST_PHYS_MODE_TARGET = ['1', ':', '0'] # macro
NVC6B5_SET_DST_PHYS_MODE_TARGET_LOCAL_FB = (0x00000000) # macro
NVC6B5_SET_DST_PHYS_MODE_TARGET_COHERENT_SYSMEM = (0x00000001) # macro
NVC6B5_SET_DST_PHYS_MODE_TARGET_NONCOHERENT_SYSMEM = (0x00000002) # macro
NVC6B5_SET_DST_PHYS_MODE_TARGET_PEERMEM = (0x00000003) # macro
NVC6B5_SET_DST_PHYS_MODE_BASIC_KIND = ['5', ':', '2'] # macro
NVC6B5_SET_DST_PHYS_MODE_PEER_ID = ['8', ':', '6'] # macro
NVC6B5_SET_DST_PHYS_MODE_FLA = ['9', ':', '9'] # macro
NVC6B5_SET_GLOBAL_COUNTER_UPPER = (0x00000280) # macro
NVC6B5_SET_GLOBAL_COUNTER_UPPER_V = ['31', ':', '0'] # macro
NVC6B5_SET_GLOBAL_COUNTER_LOWER = (0x00000284) # macro
NVC6B5_SET_GLOBAL_COUNTER_LOWER_V = ['31', ':', '0'] # macro
NVC6B5_SET_PAGEOUT_START_PAUPPER = (0x00000288) # macro
NVC6B5_SET_PAGEOUT_START_PAUPPER_V = ['4', ':', '0'] # macro
NVC6B5_SET_PAGEOUT_START_PALOWER = (0x0000028C) # macro
NVC6B5_SET_PAGEOUT_START_PALOWER_V = ['31', ':', '0'] # macro
NVC6B5_LAUNCH_DMA = (0x00000300) # macro
NVC6B5_LAUNCH_DMA_DATA_TRANSFER_TYPE = ['1', ':', '0'] # macro
NVC6B5_LAUNCH_DMA_DATA_TRANSFER_TYPE_NONE = (0x00000000) # macro
NVC6B5_LAUNCH_DMA_DATA_TRANSFER_TYPE_PIPELINED = (0x00000001) # macro
NVC6B5_LAUNCH_DMA_DATA_TRANSFER_TYPE_NON_PIPELINED = (0x00000002) # macro
NVC6B5_LAUNCH_DMA_FLUSH_ENABLE = ['2', ':', '2'] # macro
NVC6B5_LAUNCH_DMA_FLUSH_ENABLE_FALSE = (0x00000000) # macro
NVC6B5_LAUNCH_DMA_FLUSH_ENABLE_TRUE = (0x00000001) # macro
NVC6B5_LAUNCH_DMA_FLUSH_TYPE = ['25', ':', '25'] # macro
NVC6B5_LAUNCH_DMA_FLUSH_TYPE_SYS = (0x00000000) # macro
NVC6B5_LAUNCH_DMA_FLUSH_TYPE_GL = (0x00000001) # macro
NVC6B5_LAUNCH_DMA_SEMAPHORE_TYPE = ['4', ':', '3'] # macro
NVC6B5_LAUNCH_DMA_SEMAPHORE_TYPE_NONE = (0x00000000) # macro
NVC6B5_LAUNCH_DMA_SEMAPHORE_TYPE_RELEASE_ONE_WORD_SEMAPHORE = (0x00000001) # macro
NVC6B5_LAUNCH_DMA_SEMAPHORE_TYPE_RELEASE_FOUR_WORD_SEMAPHORE = (0x00000002) # macro
NVC6B5_LAUNCH_DMA_SEMAPHORE_TYPE_RELEASE_CONDITIONAL_INTR_SEMAPHORE = (0x00000003) # macro
NVC6B5_LAUNCH_DMA_INTERRUPT_TYPE = ['6', ':', '5'] # macro
NVC6B5_LAUNCH_DMA_INTERRUPT_TYPE_NONE = (0x00000000) # macro
NVC6B5_LAUNCH_DMA_INTERRUPT_TYPE_BLOCKING = (0x00000001) # macro
NVC6B5_LAUNCH_DMA_INTERRUPT_TYPE_NON_BLOCKING = (0x00000002) # macro
NVC6B5_LAUNCH_DMA_SRC_MEMORY_LAYOUT = ['7', ':', '7'] # macro
NVC6B5_LAUNCH_DMA_SRC_MEMORY_LAYOUT_BLOCKLINEAR = (0x00000000) # macro
NVC6B5_LAUNCH_DMA_SRC_MEMORY_LAYOUT_PITCH = (0x00000001) # macro
NVC6B5_LAUNCH_DMA_DST_MEMORY_LAYOUT = ['8', ':', '8'] # macro
NVC6B5_LAUNCH_DMA_DST_MEMORY_LAYOUT_BLOCKLINEAR = (0x00000000) # macro
NVC6B5_LAUNCH_DMA_DST_MEMORY_LAYOUT_PITCH = (0x00000001) # macro
NVC6B5_LAUNCH_DMA_MULTI_LINE_ENABLE = ['9', ':', '9'] # macro
NVC6B5_LAUNCH_DMA_MULTI_LINE_ENABLE_FALSE = (0x00000000) # macro
NVC6B5_LAUNCH_DMA_MULTI_LINE_ENABLE_TRUE = (0x00000001) # macro
NVC6B5_LAUNCH_DMA_REMAP_ENABLE = ['10', ':', '10'] # macro
NVC6B5_LAUNCH_DMA_REMAP_ENABLE_FALSE = (0x00000000) # macro
NVC6B5_LAUNCH_DMA_REMAP_ENABLE_TRUE = (0x00000001) # macro
NVC6B5_LAUNCH_DMA_FORCE_RMWDISABLE = ['11', ':', '11'] # macro
NVC6B5_LAUNCH_DMA_FORCE_RMWDISABLE_FALSE = (0x00000000) # macro
NVC6B5_LAUNCH_DMA_FORCE_RMWDISABLE_TRUE = (0x00000001) # macro
NVC6B5_LAUNCH_DMA_SRC_TYPE = ['12', ':', '12'] # macro
NVC6B5_LAUNCH_DMA_SRC_TYPE_VIRTUAL = (0x00000000) # macro
NVC6B5_LAUNCH_DMA_SRC_TYPE_PHYSICAL = (0x00000001) # macro
NVC6B5_LAUNCH_DMA_DST_TYPE = ['13', ':', '13'] # macro
NVC6B5_LAUNCH_DMA_DST_TYPE_VIRTUAL = (0x00000000) # macro
NVC6B5_LAUNCH_DMA_DST_TYPE_PHYSICAL = (0x00000001) # macro
NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION = ['17', ':', '14'] # macro
NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IMIN = (0x00000000) # macro
NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IMAX = (0x00000001) # macro
NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IXOR = (0x00000002) # macro
NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IAND = (0x00000003) # macro
NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IOR = (0x00000004) # macro
NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_IADD = (0x00000005) # macro
NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_INC = (0x00000006) # macro
NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_DEC = (0x00000007) # macro
NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_FADD = (0x0000000A) # macro
NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_SIGN = ['18', ':', '18'] # macro
NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_SIGN_SIGNED = (0x00000000) # macro
NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_SIGN_UNSIGNED = (0x00000001) # macro
NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_ENABLE = ['19', ':', '19'] # macro
NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_ENABLE_FALSE = (0x00000000) # macro
NVC6B5_LAUNCH_DMA_SEMAPHORE_REDUCTION_ENABLE_TRUE = (0x00000001) # macro
NVC6B5_LAUNCH_DMA_VPRMODE = ['23', ':', '22'] # macro
NVC6B5_LAUNCH_DMA_VPRMODE_VPR_NONE = (0x00000000) # macro
NVC6B5_LAUNCH_DMA_VPRMODE_VPR_VID2VID = (0x00000001) # macro
NVC6B5_LAUNCH_DMA_VPRMODE_VPR_VID2SYS = (0x00000002) # macro
NVC6B5_LAUNCH_DMA_VPRMODE_VPR_SYS2VID = (0x00000003) # macro
NVC6B5_LAUNCH_DMA_RESERVED_START_OF_COPY = ['24', ':', '24'] # macro
NVC6B5_LAUNCH_DMA_DISABLE_PLC = ['26', ':', '26'] # macro
NVC6B5_LAUNCH_DMA_DISABLE_PLC_FALSE = (0x00000000) # macro
NVC6B5_LAUNCH_DMA_DISABLE_PLC_TRUE = (0x00000001) # macro
NVC6B5_LAUNCH_DMA_RESERVED_ERR_CODE = ['31', ':', '28'] # macro
NVC6B5_OFFSET_IN_UPPER = (0x00000400) # macro
NVC6B5_OFFSET_IN_UPPER_UPPER = ['16', ':', '0'] # macro
NVC6B5_OFFSET_IN_LOWER = (0x00000404) # macro
NVC6B5_OFFSET_IN_LOWER_VALUE = ['31', ':', '0'] # macro
NVC6B5_OFFSET_OUT_UPPER = (0x00000408) # macro
NVC6B5_OFFSET_OUT_UPPER_UPPER = ['16', ':', '0'] # macro
NVC6B5_OFFSET_OUT_LOWER = (0x0000040C) # macro
NVC6B5_OFFSET_OUT_LOWER_VALUE = ['31', ':', '0'] # macro
NVC6B5_PITCH_IN = (0x00000410) # macro
NVC6B5_PITCH_IN_VALUE = ['31', ':', '0'] # macro
NVC6B5_PITCH_OUT = (0x00000414) # macro
NVC6B5_PITCH_OUT_VALUE = ['31', ':', '0'] # macro
NVC6B5_LINE_LENGTH_IN = (0x00000418) # macro
NVC6B5_LINE_LENGTH_IN_VALUE = ['31', ':', '0'] # macro
NVC6B5_LINE_COUNT = (0x0000041C) # macro
NVC6B5_LINE_COUNT_VALUE = ['31', ':', '0'] # macro
NVC6B5_SET_REMAP_CONST_A = (0x00000700) # macro
NVC6B5_SET_REMAP_CONST_A_V = ['31', ':', '0'] # macro
NVC6B5_SET_REMAP_CONST_B = (0x00000704) # macro
NVC6B5_SET_REMAP_CONST_B_V = ['31', ':', '0'] # macro
NVC6B5_SET_REMAP_COMPONENTS = (0x00000708) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_X = ['2', ':', '0'] # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_X_SRC_X = (0x00000000) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_X_SRC_Y = (0x00000001) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_X_SRC_Z = (0x00000002) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_X_SRC_W = (0x00000003) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_X_CONST_A = (0x00000004) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_X_CONST_B = (0x00000005) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_X_NO_WRITE = (0x00000006) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_Y = ['6', ':', '4'] # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_Y_SRC_X = (0x00000000) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_Y_SRC_Y = (0x00000001) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_Y_SRC_Z = (0x00000002) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_Y_SRC_W = (0x00000003) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_Y_CONST_A = (0x00000004) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_Y_CONST_B = (0x00000005) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_Y_NO_WRITE = (0x00000006) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_Z = ['10', ':', '8'] # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_Z_SRC_X = (0x00000000) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_Z_SRC_Y = (0x00000001) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_Z_SRC_Z = (0x00000002) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_Z_SRC_W = (0x00000003) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_Z_CONST_A = (0x00000004) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_Z_CONST_B = (0x00000005) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_Z_NO_WRITE = (0x00000006) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_W = ['14', ':', '12'] # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_W_SRC_X = (0x00000000) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_W_SRC_Y = (0x00000001) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_W_SRC_Z = (0x00000002) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_W_SRC_W = (0x00000003) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_W_CONST_A = (0x00000004) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_W_CONST_B = (0x00000005) # macro
NVC6B5_SET_REMAP_COMPONENTS_DST_W_NO_WRITE = (0x00000006) # macro
NVC6B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE = ['17', ':', '16'] # macro
NVC6B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE_ONE = (0x00000000) # macro
NVC6B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE_TWO = (0x00000001) # macro
NVC6B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE_THREE = (0x00000002) # macro
NVC6B5_SET_REMAP_COMPONENTS_COMPONENT_SIZE_FOUR = (0x00000003) # macro
NVC6B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS = ['21', ':', '20'] # macro
NVC6B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS_ONE = (0x00000000) # macro
NVC6B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS_TWO = (0x00000001) # macro
NVC6B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS_THREE = (0x00000002) # macro
NVC6B5_SET_REMAP_COMPONENTS_NUM_SRC_COMPONENTS_FOUR = (0x00000003) # macro
NVC6B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS = ['25', ':', '24'] # macro
NVC6B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS_ONE = (0x00000000) # macro
NVC6B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS_TWO = (0x00000001) # macro
NVC6B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS_THREE = (0x00000002) # macro
NVC6B5_SET_REMAP_COMPONENTS_NUM_DST_COMPONENTS_FOUR = (0x00000003) # macro
NVC6B5_SET_DST_BLOCK_SIZE = (0x0000070C) # macro
NVC6B5_SET_DST_BLOCK_SIZE_WIDTH = ['3', ':', '0'] # macro
NVC6B5_SET_DST_BLOCK_SIZE_WIDTH_ONE_GOB = (0x00000000) # macro
NVC6B5_SET_DST_BLOCK_SIZE_HEIGHT = ['7', ':', '4'] # macro
NVC6B5_SET_DST_BLOCK_SIZE_HEIGHT_ONE_GOB = (0x00000000) # macro
NVC6B5_SET_DST_BLOCK_SIZE_HEIGHT_TWO_GOBS = (0x00000001) # macro
NVC6B5_SET_DST_BLOCK_SIZE_HEIGHT_FOUR_GOBS = (0x00000002) # macro
NVC6B5_SET_DST_BLOCK_SIZE_HEIGHT_EIGHT_GOBS = (0x00000003) # macro
NVC6B5_SET_DST_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS = (0x00000004) # macro
NVC6B5_SET_DST_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS = (0x00000005) # macro
NVC6B5_SET_DST_BLOCK_SIZE_DEPTH = ['11', ':', '8'] # macro
NVC6B5_SET_DST_BLOCK_SIZE_DEPTH_ONE_GOB = (0x00000000) # macro
NVC6B5_SET_DST_BLOCK_SIZE_DEPTH_TWO_GOBS = (0x00000001) # macro
NVC6B5_SET_DST_BLOCK_SIZE_DEPTH_FOUR_GOBS = (0x00000002) # macro
NVC6B5_SET_DST_BLOCK_SIZE_DEPTH_EIGHT_GOBS = (0x00000003) # macro
NVC6B5_SET_DST_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS = (0x00000004) # macro
NVC6B5_SET_DST_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS = (0x00000005) # macro
NVC6B5_SET_DST_BLOCK_SIZE_GOB_HEIGHT = ['15', ':', '12'] # macro
NVC6B5_SET_DST_BLOCK_SIZE_GOB_HEIGHT_GOB_HEIGHT_FERMI_8 = (0x00000001) # macro
NVC6B5_SET_DST_WIDTH = (0x00000710) # macro
NVC6B5_SET_DST_WIDTH_V = ['31', ':', '0'] # macro
NVC6B5_SET_DST_HEIGHT = (0x00000714) # macro
NVC6B5_SET_DST_HEIGHT_V = ['31', ':', '0'] # macro
NVC6B5_SET_DST_DEPTH = (0x00000718) # macro
NVC6B5_SET_DST_DEPTH_V = ['31', ':', '0'] # macro
NVC6B5_SET_DST_LAYER = (0x0000071C) # macro
NVC6B5_SET_DST_LAYER_V = ['31', ':', '0'] # macro
NVC6B5_SET_DST_ORIGIN = (0x00000720) # macro
NVC6B5_SET_DST_ORIGIN_X = ['15', ':', '0'] # macro
NVC6B5_SET_DST_ORIGIN_Y = ['31', ':', '16'] # macro
NVC6B5_SET_SRC_BLOCK_SIZE = (0x00000728) # macro
NVC6B5_SET_SRC_BLOCK_SIZE_WIDTH = ['3', ':', '0'] # macro
NVC6B5_SET_SRC_BLOCK_SIZE_WIDTH_ONE_GOB = (0x00000000) # macro
NVC6B5_SET_SRC_BLOCK_SIZE_HEIGHT = ['7', ':', '4'] # macro
NVC6B5_SET_SRC_BLOCK_SIZE_HEIGHT_ONE_GOB = (0x00000000) # macro
NVC6B5_SET_SRC_BLOCK_SIZE_HEIGHT_TWO_GOBS = (0x00000001) # macro
NVC6B5_SET_SRC_BLOCK_SIZE_HEIGHT_FOUR_GOBS = (0x00000002) # macro
NVC6B5_SET_SRC_BLOCK_SIZE_HEIGHT_EIGHT_GOBS = (0x00000003) # macro
NVC6B5_SET_SRC_BLOCK_SIZE_HEIGHT_SIXTEEN_GOBS = (0x00000004) # macro
NVC6B5_SET_SRC_BLOCK_SIZE_HEIGHT_THIRTYTWO_GOBS = (0x00000005) # macro
NVC6B5_SET_SRC_BLOCK_SIZE_DEPTH = ['11', ':', '8'] # macro
NVC6B5_SET_SRC_BLOCK_SIZE_DEPTH_ONE_GOB = (0x00000000) # macro
NVC6B5_SET_SRC_BLOCK_SIZE_DEPTH_TWO_GOBS = (0x00000001) # macro
NVC6B5_SET_SRC_BLOCK_SIZE_DEPTH_FOUR_GOBS = (0x00000002) # macro
NVC6B5_SET_SRC_BLOCK_SIZE_DEPTH_EIGHT_GOBS = (0x00000003) # macro
NVC6B5_SET_SRC_BLOCK_SIZE_DEPTH_SIXTEEN_GOBS = (0x00000004) # macro
NVC6B5_SET_SRC_BLOCK_SIZE_DEPTH_THIRTYTWO_GOBS = (0x00000005) # macro
NVC6B5_SET_SRC_BLOCK_SIZE_GOB_HEIGHT = ['15', ':', '12'] # macro
NVC6B5_SET_SRC_BLOCK_SIZE_GOB_HEIGHT_GOB_HEIGHT_FERMI_8 = (0x00000001) # macro
NVC6B5_SET_SRC_WIDTH = (0x0000072C) # macro
NVC6B5_SET_SRC_WIDTH_V = ['31', ':', '0'] # macro
NVC6B5_SET_SRC_HEIGHT = (0x00000730) # macro
NVC6B5_SET_SRC_HEIGHT_V = ['31', ':', '0'] # macro
NVC6B5_SET_SRC_DEPTH = (0x00000734) # macro
NVC6B5_SET_SRC_DEPTH_V = ['31', ':', '0'] # macro
NVC6B5_SET_SRC_LAYER = (0x00000738) # macro
NVC6B5_SET_SRC_LAYER_V = ['31', ':', '0'] # macro
NVC6B5_SET_SRC_ORIGIN = (0x0000073C) # macro
NVC6B5_SET_SRC_ORIGIN_X = ['15', ':', '0'] # macro
NVC6B5_SET_SRC_ORIGIN_Y = ['31', ':', '16'] # macro
NVC6B5_SRC_ORIGIN_X = (0x00000744) # macro
NVC6B5_SRC_ORIGIN_X_VALUE = ['31', ':', '0'] # macro
NVC6B5_SRC_ORIGIN_Y = (0x00000748) # macro
NVC6B5_SRC_ORIGIN_Y_VALUE = ['31', ':', '0'] # macro
NVC6B5_DST_ORIGIN_X = (0x0000074C) # macro
NVC6B5_DST_ORIGIN_X_VALUE = ['31', ':', '0'] # macro
NVC6B5_DST_ORIGIN_Y = (0x00000750) # macro
NVC6B5_DST_ORIGIN_Y_VALUE = ['31', ':', '0'] # macro
NVC6B5_PM_TRIGGER_END = (0x00001114) # macro
NVC6B5_PM_TRIGGER_END_V = ['31', ':', '0'] # macro
class struct__clc6b5_tag0(Structure):
    pass

struct__clc6b5_tag0._pack_ = 1 # source:False
struct__clc6b5_tag0._fields_ = [
    ('Reserved00', ctypes.c_uint32 * 64),
    ('Nop', ctypes.c_uint32),
    ('Reserved01', ctypes.c_uint32 * 15),
    ('PmTrigger', ctypes.c_uint32),
    ('Reserved02', ctypes.c_uint32 * 63),
    ('SetSemaphoreA', ctypes.c_uint32),
    ('SetSemaphoreB', ctypes.c_uint32),
    ('SetSemaphorePayload', ctypes.c_uint32),
    ('Reserved03', ctypes.c_uint32 * 2),
    ('SetRenderEnableA', ctypes.c_uint32),
    ('SetRenderEnableB', ctypes.c_uint32),
    ('SetRenderEnableC', ctypes.c_uint32),
    ('SetSrcPhysMode', ctypes.c_uint32),
    ('SetDstPhysMode', ctypes.c_uint32),
    ('Reserved04', ctypes.c_uint32 * 6),
    ('SetGlobalCounterUpper', ctypes.c_uint32),
    ('SetGlobalCounterLower', ctypes.c_uint32),
    ('SetPageoutStartPAUpper', ctypes.c_uint32),
    ('SetPageoutStartPALower', ctypes.c_uint32),
    ('Reserved05', ctypes.c_uint32 * 28),
    ('LaunchDma', ctypes.c_uint32),
    ('Reserved06', ctypes.c_uint32 * 63),
    ('OffsetInUpper', ctypes.c_uint32),
    ('OffsetInLower', ctypes.c_uint32),
    ('OffsetOutUpper', ctypes.c_uint32),
    ('OffsetOutLower', ctypes.c_uint32),
    ('PitchIn', ctypes.c_uint32),
    ('PitchOut', ctypes.c_uint32),
    ('LineLengthIn', ctypes.c_uint32),
    ('LineCount', ctypes.c_uint32),
    ('Reserved07', ctypes.c_uint32 * 184),
    ('SetRemapConstA', ctypes.c_uint32),
    ('SetRemapConstB', ctypes.c_uint32),
    ('SetRemapComponents', ctypes.c_uint32),
    ('SetDstBlockSize', ctypes.c_uint32),
    ('SetDstWidth', ctypes.c_uint32),
    ('SetDstHeight', ctypes.c_uint32),
    ('SetDstDepth', ctypes.c_uint32),
    ('SetDstLayer', ctypes.c_uint32),
    ('SetDstOrigin', ctypes.c_uint32),
    ('Reserved08', ctypes.c_uint32 * 1),
    ('SetSrcBlockSize', ctypes.c_uint32),
    ('SetSrcWidth', ctypes.c_uint32),
    ('SetSrcHeight', ctypes.c_uint32),
    ('SetSrcDepth', ctypes.c_uint32),
    ('SetSrcLayer', ctypes.c_uint32),
    ('SetSrcOrigin', ctypes.c_uint32),
    ('Reserved09', ctypes.c_uint32 * 1),
    ('SrcOriginX', ctypes.c_uint32),
    ('SrcOriginY', ctypes.c_uint32),
    ('DstOriginX', ctypes.c_uint32),
    ('DstOriginY', ctypes.c_uint32),
    ('Reserved10', ctypes.c_uint32 * 624),
    ('PmTriggerEnd', ctypes.c_uint32),
    ('Reserved11', ctypes.c_uint32 * 954),
]

ampere_dma_copy_aControlPio = struct__clc6b5_tag0
_UVM_IOCTL_H = True # macro
# def UVM_IOCTL_BASE(i):  # macro
#    return i
UVM_RESERVE_VA = 1 # macro
UVM_RELEASE_VA = 2 # macro
UVM_REGION_COMMIT = 3 # macro
UVM_REGION_DECOMMIT = 4 # macro
UVM_REGION_SET_STREAM = 5 # macro
UVM_SET_STREAM_RUNNING = 6 # macro
UVM_MAX_STREAMS_PER_IOCTL_CALL = 32 # macro
UVM_SET_STREAM_STOPPED = 7 # macro
UVM_RUN_TEST = 9 # macro
UVM_EVENTS_OFFSET_BASE = (1<<63) # macro
UVM_COUNTERS_OFFSET_BASE = (1<<62) # macro
UVM_ADD_SESSION = 10 # macro
UVM_REMOVE_SESSION = 11 # macro
UVM_MAX_COUNTERS_PER_IOCTL_CALL = 32 # macro
UVM_ENABLE_COUNTERS = 12 # macro
UVM_MAP_COUNTER = 13 # macro
UVM_CREATE_EVENT_QUEUE = 14 # macro
UVM_REMOVE_EVENT_QUEUE = 15 # macro
UVM_MAP_EVENT_QUEUE = 16 # macro
UVM_EVENT_CTRL = 17 # macro
UVM_REGISTER_MPS_SERVER = 18 # macro
UVM_REGISTER_MPS_CLIENT = 19 # macro
UVM_GET_GPU_UUID_TABLE = 20 # macro
UVM_CREATE_RANGE_GROUP = 23 # macro
UVM_DESTROY_RANGE_GROUP = 24 # macro
UVM_REGISTER_GPU_VASPACE = 25 # macro
UVM_UNREGISTER_GPU_VASPACE = 26 # macro
UVM_REGISTER_CHANNEL = 27 # macro
UVM_UNREGISTER_CHANNEL = 28 # macro
UVM_ENABLE_PEER_ACCESS = 29 # macro
UVM_DISABLE_PEER_ACCESS = 30 # macro
UVM_SET_RANGE_GROUP = 31 # macro
UVM_MAP_EXTERNAL_ALLOCATION = 33 # macro
UVM_FREE = 34 # macro
UVM_MEM_MAP = 35 # macro
UVM_DEBUG_ACCESS_MEMORY = 36 # macro
UVM_REGISTER_GPU = 37 # macro
UVM_UNREGISTER_GPU = 38 # macro
UVM_PAGEABLE_MEM_ACCESS = 39 # macro
UVM_MAX_RANGE_GROUPS_PER_IOCTL_CALL = 32 # macro
UVM_PREVENT_MIGRATION_RANGE_GROUPS = 40 # macro
UVM_ALLOW_MIGRATION_RANGE_GROUPS = 41 # macro
UVM_SET_PREFERRED_LOCATION = 42 # macro
UVM_UNSET_PREFERRED_LOCATION = 43 # macro
UVM_ENABLE_READ_DUPLICATION = 44 # macro
UVM_DISABLE_READ_DUPLICATION = 45 # macro
UVM_SET_ACCESSED_BY = 46 # macro
UVM_UNSET_ACCESSED_BY = 47 # macro
UVM_MIGRATE_FLAG_ASYNC = 0x00000001 # macro
UVM_MIGRATE_FLAG_SKIP_CPU_MAP = 0x00000002 # macro
UVM_MIGRATE_FLAG_NO_GPU_VA_SPACE = 0x00000004 # macro
UVM_MIGRATE_FLAGS_TEST_ALL = (0x00000002|0x00000004) # macro
UVM_MIGRATE_FLAGS_ALL = (0x00000001|(0x00000002|0x00000004)) # macro
UVM_MIGRATE = 51 # macro
UVM_MIGRATE_RANGE_GROUP = 53 # macro
UVM_ENABLE_SYSTEM_WIDE_ATOMICS = 54 # macro
UVM_DISABLE_SYSTEM_WIDE_ATOMICS = 55 # macro
UVM_TOOLS_INIT_EVENT_TRACKER = 56 # macro
UVM_TOOLS_SET_NOTIFICATION_THRESHOLD = 57 # macro
UVM_TOOLS_EVENT_QUEUE_ENABLE_EVENTS = 58 # macro
UVM_TOOLS_EVENT_QUEUE_DISABLE_EVENTS = 59 # macro
UVM_TOOLS_ENABLE_COUNTERS = 60 # macro
UVM_TOOLS_DISABLE_COUNTERS = 61 # macro
UVM_TOOLS_READ_PROCESS_MEMORY = 62 # macro
UVM_TOOLS_WRITE_PROCESS_MEMORY = 63 # macro
UVM_TOOLS_GET_PROCESSOR_UUID_TABLE = 64 # macro
UVM_MAP_DYNAMIC_PARALLELISM_REGION = 65 # macro
UVM_UNMAP_EXTERNAL = 66 # macro
UVM_TOOLS_FLUSH_EVENTS = 67 # macro
UVM_ALLOC_SEMAPHORE_POOL = 68 # macro
UVM_CLEAN_UP_ZOMBIE_RESOURCES = 69 # macro
UVM_PAGEABLE_MEM_ACCESS_ON_GPU = 70 # macro
UVM_POPULATE_PAGEABLE = 71 # macro
UVM_POPULATE_PAGEABLE_FLAG_ALLOW_MANAGED = 0x00000001 # macro
UVM_POPULATE_PAGEABLE_FLAG_SKIP_PROT_CHECK = 0x00000002 # macro
UVM_POPULATE_PAGEABLE_FLAGS_TEST_ALL = (0x00000001|0x00000002) # macro
UVM_POPULATE_PAGEABLE_FLAGS_ALL = (0x00000001|0x00000002) # macro
UVM_VALIDATE_VA_RANGE = 72 # macro
UVM_CREATE_EXTERNAL_RANGE = 73 # macro
UVM_MAP_EXTERNAL_SPARSE = 74 # macro
UVM_MM_INITIALIZE = 75 # macro
UVM_IS_8_SUPPORTED = 2047 # macro
class struct_c__SA_UVM_RESERVE_VA_PARAMS(Structure):
    pass

struct_c__SA_UVM_RESERVE_VA_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_RESERVE_VA_PARAMS._fields_ = [
    ('requestedBase', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_RESERVE_VA_PARAMS = struct_c__SA_UVM_RESERVE_VA_PARAMS
class struct_c__SA_UVM_RELEASE_VA_PARAMS(Structure):
    pass

struct_c__SA_UVM_RELEASE_VA_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_RELEASE_VA_PARAMS._fields_ = [
    ('requestedBase', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_RELEASE_VA_PARAMS = struct_c__SA_UVM_RELEASE_VA_PARAMS
class struct_c__SA_UVM_REGION_COMMIT_PARAMS(Structure):
    pass

class struct_nv_uuid(Structure):
    pass

struct_nv_uuid._pack_ = 1 # source:False
struct_nv_uuid._fields_ = [
    ('uuid', ctypes.c_ubyte * 16),
]

struct_c__SA_UVM_REGION_COMMIT_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_REGION_COMMIT_PARAMS._fields_ = [
    ('requestedBase', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('streamId', ctypes.c_uint64),
    ('gpuUuid', struct_nv_uuid),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_REGION_COMMIT_PARAMS = struct_c__SA_UVM_REGION_COMMIT_PARAMS
class struct_c__SA_UVM_REGION_DECOMMIT_PARAMS(Structure):
    pass

struct_c__SA_UVM_REGION_DECOMMIT_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_REGION_DECOMMIT_PARAMS._fields_ = [
    ('requestedBase', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_REGION_DECOMMIT_PARAMS = struct_c__SA_UVM_REGION_DECOMMIT_PARAMS
class struct_c__SA_UVM_REGION_SET_STREAM_PARAMS(Structure):
    pass

struct_c__SA_UVM_REGION_SET_STREAM_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_REGION_SET_STREAM_PARAMS._fields_ = [
    ('requestedBase', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('newStreamId', ctypes.c_uint64),
    ('gpuUuid', struct_nv_uuid),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_REGION_SET_STREAM_PARAMS = struct_c__SA_UVM_REGION_SET_STREAM_PARAMS
class struct_c__SA_UVM_SET_STREAM_RUNNING_PARAMS(Structure):
    pass

struct_c__SA_UVM_SET_STREAM_RUNNING_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_SET_STREAM_RUNNING_PARAMS._fields_ = [
    ('streamId', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_SET_STREAM_RUNNING_PARAMS = struct_c__SA_UVM_SET_STREAM_RUNNING_PARAMS
class struct_c__SA_UVM_SET_STREAM_STOPPED_PARAMS(Structure):
    pass

struct_c__SA_UVM_SET_STREAM_STOPPED_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_SET_STREAM_STOPPED_PARAMS._fields_ = [
    ('streamIdArray', ctypes.c_uint64 * 32),
    ('nStreams', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_SET_STREAM_STOPPED_PARAMS = struct_c__SA_UVM_SET_STREAM_STOPPED_PARAMS
class struct_c__SA_UVM_RUN_TEST_PARAMS(Structure):
    pass

class struct_c__SA_UVM_RUN_TEST_PARAMS_multiGpu(Structure):
    pass

struct_c__SA_UVM_RUN_TEST_PARAMS_multiGpu._pack_ = 1 # source:False
struct_c__SA_UVM_RUN_TEST_PARAMS_multiGpu._fields_ = [
    ('peerGpuUuid', struct_nv_uuid),
    ('peerId', ctypes.c_uint32),
]

struct_c__SA_UVM_RUN_TEST_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_RUN_TEST_PARAMS._fields_ = [
    ('gpuUuid', struct_nv_uuid),
    ('test', ctypes.c_uint32),
    ('multiGpu', struct_c__SA_UVM_RUN_TEST_PARAMS_multiGpu),
    ('rmStatus', ctypes.c_uint32),
]

UVM_RUN_TEST_PARAMS = struct_c__SA_UVM_RUN_TEST_PARAMS
class struct_c__SA_UVM_ADD_SESSION_PARAMS(Structure):
    pass

struct_c__SA_UVM_ADD_SESSION_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_ADD_SESSION_PARAMS._fields_ = [
    ('pidTarget', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('countersBaseAddress', ctypes.POINTER(None)),
    ('sessionIndex', ctypes.c_int32),
    ('rmStatus', ctypes.c_uint32),
]

UVM_ADD_SESSION_PARAMS = struct_c__SA_UVM_ADD_SESSION_PARAMS
class struct_c__SA_UVM_REMOVE_SESSION_PARAMS(Structure):
    pass

struct_c__SA_UVM_REMOVE_SESSION_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_REMOVE_SESSION_PARAMS._fields_ = [
    ('sessionIndex', ctypes.c_int32),
    ('rmStatus', ctypes.c_uint32),
]

UVM_REMOVE_SESSION_PARAMS = struct_c__SA_UVM_REMOVE_SESSION_PARAMS
class struct_c__SA_UVM_ENABLE_COUNTERS_PARAMS(Structure):
    pass

class struct_c__SA_UvmCounterConfig(Structure):
    pass

struct_c__SA_UvmCounterConfig._pack_ = 1 # source:False
struct_c__SA_UvmCounterConfig._fields_ = [
    ('scope', ctypes.c_uint32),
    ('name', ctypes.c_uint32),
    ('gpuid', struct_nv_uuid),
    ('state', ctypes.c_uint32),
]

struct_c__SA_UVM_ENABLE_COUNTERS_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_ENABLE_COUNTERS_PARAMS._fields_ = [
    ('sessionIndex', ctypes.c_int32),
    ('config', struct_c__SA_UvmCounterConfig * 32),
    ('count', ctypes.c_uint32),
    ('rmStatus', ctypes.c_uint32),
]

UVM_ENABLE_COUNTERS_PARAMS = struct_c__SA_UVM_ENABLE_COUNTERS_PARAMS
class struct_c__SA_UVM_MAP_COUNTER_PARAMS(Structure):
    pass

struct_c__SA_UVM_MAP_COUNTER_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_MAP_COUNTER_PARAMS._fields_ = [
    ('sessionIndex', ctypes.c_int32),
    ('scope', ctypes.c_uint32),
    ('counterName', ctypes.c_uint32),
    ('gpuUuid', struct_nv_uuid),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('addr', ctypes.POINTER(None)),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

UVM_MAP_COUNTER_PARAMS = struct_c__SA_UVM_MAP_COUNTER_PARAMS
class struct_c__SA_UVM_CREATE_EVENT_QUEUE_PARAMS(Structure):
    pass

struct_c__SA_UVM_CREATE_EVENT_QUEUE_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_CREATE_EVENT_QUEUE_PARAMS._fields_ = [
    ('sessionIndex', ctypes.c_int32),
    ('eventQueueIndex', ctypes.c_uint32),
    ('queueSize', ctypes.c_uint64),
    ('notificationCount', ctypes.c_uint64),
    ('timeStampType', ctypes.c_uint32),
    ('rmStatus', ctypes.c_uint32),
]

UVM_CREATE_EVENT_QUEUE_PARAMS = struct_c__SA_UVM_CREATE_EVENT_QUEUE_PARAMS
class struct_c__SA_UVM_REMOVE_EVENT_QUEUE_PARAMS(Structure):
    pass

struct_c__SA_UVM_REMOVE_EVENT_QUEUE_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_REMOVE_EVENT_QUEUE_PARAMS._fields_ = [
    ('sessionIndex', ctypes.c_int32),
    ('eventQueueIndex', ctypes.c_uint32),
    ('rmStatus', ctypes.c_uint32),
]

UVM_REMOVE_EVENT_QUEUE_PARAMS = struct_c__SA_UVM_REMOVE_EVENT_QUEUE_PARAMS
class struct_c__SA_UVM_MAP_EVENT_QUEUE_PARAMS(Structure):
    pass

struct_c__SA_UVM_MAP_EVENT_QUEUE_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_MAP_EVENT_QUEUE_PARAMS._fields_ = [
    ('sessionIndex', ctypes.c_int32),
    ('eventQueueIndex', ctypes.c_uint32),
    ('userRODataAddr', ctypes.POINTER(None)),
    ('userRWDataAddr', ctypes.POINTER(None)),
    ('readIndexAddr', ctypes.POINTER(None)),
    ('writeIndexAddr', ctypes.POINTER(None)),
    ('queueBufferAddr', ctypes.POINTER(None)),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_MAP_EVENT_QUEUE_PARAMS = struct_c__SA_UVM_MAP_EVENT_QUEUE_PARAMS
class struct_c__SA_UVM_EVENT_CTRL_PARAMS(Structure):
    pass

struct_c__SA_UVM_EVENT_CTRL_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_EVENT_CTRL_PARAMS._fields_ = [
    ('sessionIndex', ctypes.c_int32),
    ('eventQueueIndex', ctypes.c_uint32),
    ('eventType', ctypes.c_int32),
    ('enable', ctypes.c_uint32),
    ('rmStatus', ctypes.c_uint32),
]

UVM_EVENT_CTRL_PARAMS = struct_c__SA_UVM_EVENT_CTRL_PARAMS
class struct_c__SA_UVM_REGISTER_MPS_SERVER_PARAMS(Structure):
    pass

struct_c__SA_UVM_REGISTER_MPS_SERVER_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_REGISTER_MPS_SERVER_PARAMS._fields_ = [
    ('gpuUuidArray', struct_nv_uuid * 32),
    ('numGpus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('serverId', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

UVM_REGISTER_MPS_SERVER_PARAMS = struct_c__SA_UVM_REGISTER_MPS_SERVER_PARAMS
class struct_c__SA_UVM_REGISTER_MPS_CLIENT_PARAMS(Structure):
    pass

struct_c__SA_UVM_REGISTER_MPS_CLIENT_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_REGISTER_MPS_CLIENT_PARAMS._fields_ = [
    ('serverId', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_REGISTER_MPS_CLIENT_PARAMS = struct_c__SA_UVM_REGISTER_MPS_CLIENT_PARAMS
class struct_c__SA_UVM_GET_GPU_UUID_TABLE_PARAMS(Structure):
    pass

struct_c__SA_UVM_GET_GPU_UUID_TABLE_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_GET_GPU_UUID_TABLE_PARAMS._fields_ = [
    ('gpuUuidArray', struct_nv_uuid * 32),
    ('validCount', ctypes.c_uint32),
    ('rmStatus', ctypes.c_uint32),
]

UVM_GET_GPU_UUID_TABLE_PARAMS = struct_c__SA_UVM_GET_GPU_UUID_TABLE_PARAMS
class struct_c__SA_UVM_CREATE_RANGE_GROUP_PARAMS(Structure):
    pass

struct_c__SA_UVM_CREATE_RANGE_GROUP_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_CREATE_RANGE_GROUP_PARAMS._fields_ = [
    ('rangeGroupId', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_CREATE_RANGE_GROUP_PARAMS = struct_c__SA_UVM_CREATE_RANGE_GROUP_PARAMS
class struct_c__SA_UVM_DESTROY_RANGE_GROUP_PARAMS(Structure):
    pass

struct_c__SA_UVM_DESTROY_RANGE_GROUP_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_DESTROY_RANGE_GROUP_PARAMS._fields_ = [
    ('rangeGroupId', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_DESTROY_RANGE_GROUP_PARAMS = struct_c__SA_UVM_DESTROY_RANGE_GROUP_PARAMS
class struct_c__SA_UVM_REGISTER_GPU_VASPACE_PARAMS(Structure):
    pass

struct_c__SA_UVM_REGISTER_GPU_VASPACE_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_REGISTER_GPU_VASPACE_PARAMS._fields_ = [
    ('gpuUuid', struct_nv_uuid),
    ('rmCtrlFd', ctypes.c_int32),
    ('hClient', ctypes.c_uint32),
    ('hVaSpace', ctypes.c_uint32),
    ('rmStatus', ctypes.c_uint32),
]

UVM_REGISTER_GPU_VASPACE_PARAMS = struct_c__SA_UVM_REGISTER_GPU_VASPACE_PARAMS
class struct_c__SA_UVM_UNREGISTER_GPU_VASPACE_PARAMS(Structure):
    pass

struct_c__SA_UVM_UNREGISTER_GPU_VASPACE_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_UNREGISTER_GPU_VASPACE_PARAMS._fields_ = [
    ('gpuUuid', struct_nv_uuid),
    ('rmStatus', ctypes.c_uint32),
]

UVM_UNREGISTER_GPU_VASPACE_PARAMS = struct_c__SA_UVM_UNREGISTER_GPU_VASPACE_PARAMS
class struct_c__SA_UVM_REGISTER_CHANNEL_PARAMS(Structure):
    pass

struct_c__SA_UVM_REGISTER_CHANNEL_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_REGISTER_CHANNEL_PARAMS._fields_ = [
    ('gpuUuid', struct_nv_uuid),
    ('rmCtrlFd', ctypes.c_int32),
    ('hClient', ctypes.c_uint32),
    ('hChannel', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('base', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

UVM_REGISTER_CHANNEL_PARAMS = struct_c__SA_UVM_REGISTER_CHANNEL_PARAMS
class struct_c__SA_UVM_UNREGISTER_CHANNEL_PARAMS(Structure):
    pass

struct_c__SA_UVM_UNREGISTER_CHANNEL_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_UNREGISTER_CHANNEL_PARAMS._fields_ = [
    ('gpuUuid', struct_nv_uuid),
    ('hClient', ctypes.c_uint32),
    ('hChannel', ctypes.c_uint32),
    ('rmStatus', ctypes.c_uint32),
]

UVM_UNREGISTER_CHANNEL_PARAMS = struct_c__SA_UVM_UNREGISTER_CHANNEL_PARAMS
class struct_c__SA_UVM_ENABLE_PEER_ACCESS_PARAMS(Structure):
    pass

struct_c__SA_UVM_ENABLE_PEER_ACCESS_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_ENABLE_PEER_ACCESS_PARAMS._fields_ = [
    ('gpuUuidA', struct_nv_uuid),
    ('gpuUuidB', struct_nv_uuid),
    ('rmStatus', ctypes.c_uint32),
]

UVM_ENABLE_PEER_ACCESS_PARAMS = struct_c__SA_UVM_ENABLE_PEER_ACCESS_PARAMS
class struct_c__SA_UVM_DISABLE_PEER_ACCESS_PARAMS(Structure):
    pass

struct_c__SA_UVM_DISABLE_PEER_ACCESS_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_DISABLE_PEER_ACCESS_PARAMS._fields_ = [
    ('gpuUuidA', struct_nv_uuid),
    ('gpuUuidB', struct_nv_uuid),
    ('rmStatus', ctypes.c_uint32),
]

UVM_DISABLE_PEER_ACCESS_PARAMS = struct_c__SA_UVM_DISABLE_PEER_ACCESS_PARAMS
class struct_c__SA_UVM_SET_RANGE_GROUP_PARAMS(Structure):
    pass

struct_c__SA_UVM_SET_RANGE_GROUP_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_SET_RANGE_GROUP_PARAMS._fields_ = [
    ('rangeGroupId', ctypes.c_uint64),
    ('requestedBase', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_SET_RANGE_GROUP_PARAMS = struct_c__SA_UVM_SET_RANGE_GROUP_PARAMS
class struct_c__SA_UVM_MAP_EXTERNAL_ALLOCATION_PARAMS(Structure):
    pass

class struct_c__SA_UvmGpuMappingAttributes(Structure):
    pass

struct_c__SA_UvmGpuMappingAttributes._pack_ = 1 # source:False
struct_c__SA_UvmGpuMappingAttributes._fields_ = [
    ('gpuUuid', struct_nv_uuid),
    ('gpuMappingType', ctypes.c_uint32),
    ('gpuCachingType', ctypes.c_uint32),
    ('gpuFormatType', ctypes.c_uint32),
    ('gpuElementBits', ctypes.c_uint32),
    ('gpuCompressionType', ctypes.c_uint32),
]

struct_c__SA_UVM_MAP_EXTERNAL_ALLOCATION_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_MAP_EXTERNAL_ALLOCATION_PARAMS._fields_ = [
    ('base', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('offset', ctypes.c_uint64),
    ('perGpuAttributes', struct_c__SA_UvmGpuMappingAttributes * 256),
    ('gpuAttributesCount', ctypes.c_uint64),
    ('rmCtrlFd', ctypes.c_int32),
    ('hClient', ctypes.c_uint32),
    ('hMemory', ctypes.c_uint32),
    ('rmStatus', ctypes.c_uint32),
]

UVM_MAP_EXTERNAL_ALLOCATION_PARAMS = struct_c__SA_UVM_MAP_EXTERNAL_ALLOCATION_PARAMS
class struct_c__SA_UVM_FREE_PARAMS(Structure):
    pass

struct_c__SA_UVM_FREE_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_FREE_PARAMS._fields_ = [
    ('base', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_FREE_PARAMS = struct_c__SA_UVM_FREE_PARAMS
class struct_c__SA_UVM_MEM_MAP_PARAMS(Structure):
    pass

struct_c__SA_UVM_MEM_MAP_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_MEM_MAP_PARAMS._fields_ = [
    ('regionBase', ctypes.POINTER(None)),
    ('regionLength', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_MEM_MAP_PARAMS = struct_c__SA_UVM_MEM_MAP_PARAMS
class struct_c__SA_UVM_DEBUG_ACCESS_MEMORY_PARAMS(Structure):
    pass

struct_c__SA_UVM_DEBUG_ACCESS_MEMORY_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_DEBUG_ACCESS_MEMORY_PARAMS._fields_ = [
    ('sessionIndex', ctypes.c_int32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('baseAddress', ctypes.c_uint64),
    ('sizeInBytes', ctypes.c_uint64),
    ('accessType', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
    ('buffer', ctypes.c_uint64),
    ('isBitmaskSet', ctypes.c_ubyte),
    ('PADDING_2', ctypes.c_ubyte * 7),
    ('bitmask', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_3', ctypes.c_ubyte * 4),
]

UVM_DEBUG_ACCESS_MEMORY_PARAMS = struct_c__SA_UVM_DEBUG_ACCESS_MEMORY_PARAMS
class struct_c__SA_UVM_REGISTER_GPU_PARAMS(Structure):
    pass

struct_c__SA_UVM_REGISTER_GPU_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_REGISTER_GPU_PARAMS._fields_ = [
    ('gpu_uuid', struct_nv_uuid),
    ('numaEnabled', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('numaNodeId', ctypes.c_int32),
    ('rmCtrlFd', ctypes.c_int32),
    ('hClient', ctypes.c_uint32),
    ('hSmcPartRef', ctypes.c_uint32),
    ('rmStatus', ctypes.c_uint32),
]

UVM_REGISTER_GPU_PARAMS = struct_c__SA_UVM_REGISTER_GPU_PARAMS
class struct_c__SA_UVM_UNREGISTER_GPU_PARAMS(Structure):
    pass

struct_c__SA_UVM_UNREGISTER_GPU_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_UNREGISTER_GPU_PARAMS._fields_ = [
    ('gpu_uuid', struct_nv_uuid),
    ('rmStatus', ctypes.c_uint32),
]

UVM_UNREGISTER_GPU_PARAMS = struct_c__SA_UVM_UNREGISTER_GPU_PARAMS
class struct_c__SA_UVM_PAGEABLE_MEM_ACCESS_PARAMS(Structure):
    pass

struct_c__SA_UVM_PAGEABLE_MEM_ACCESS_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_PAGEABLE_MEM_ACCESS_PARAMS._fields_ = [
    ('pageableMemAccess', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('rmStatus', ctypes.c_uint32),
]

UVM_PAGEABLE_MEM_ACCESS_PARAMS = struct_c__SA_UVM_PAGEABLE_MEM_ACCESS_PARAMS
class struct_c__SA_UVM_PREVENT_MIGRATION_RANGE_GROUPS_PARAMS(Structure):
    pass

struct_c__SA_UVM_PREVENT_MIGRATION_RANGE_GROUPS_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_PREVENT_MIGRATION_RANGE_GROUPS_PARAMS._fields_ = [
    ('rangeGroupIds', ctypes.c_uint64 * 32),
    ('numGroupIds', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_PREVENT_MIGRATION_RANGE_GROUPS_PARAMS = struct_c__SA_UVM_PREVENT_MIGRATION_RANGE_GROUPS_PARAMS
class struct_c__SA_UVM_ALLOW_MIGRATION_RANGE_GROUPS_PARAMS(Structure):
    pass

struct_c__SA_UVM_ALLOW_MIGRATION_RANGE_GROUPS_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_ALLOW_MIGRATION_RANGE_GROUPS_PARAMS._fields_ = [
    ('rangeGroupIds', ctypes.c_uint64 * 32),
    ('numGroupIds', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_ALLOW_MIGRATION_RANGE_GROUPS_PARAMS = struct_c__SA_UVM_ALLOW_MIGRATION_RANGE_GROUPS_PARAMS
class struct_c__SA_UVM_SET_PREFERRED_LOCATION_PARAMS(Structure):
    pass

struct_c__SA_UVM_SET_PREFERRED_LOCATION_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_SET_PREFERRED_LOCATION_PARAMS._fields_ = [
    ('requestedBase', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('preferredLocation', struct_nv_uuid),
    ('preferredCpuNumaNode', ctypes.c_int32),
    ('rmStatus', ctypes.c_uint32),
]

UVM_SET_PREFERRED_LOCATION_PARAMS = struct_c__SA_UVM_SET_PREFERRED_LOCATION_PARAMS
class struct_c__SA_UVM_UNSET_PREFERRED_LOCATION_PARAMS(Structure):
    pass

struct_c__SA_UVM_UNSET_PREFERRED_LOCATION_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_UNSET_PREFERRED_LOCATION_PARAMS._fields_ = [
    ('requestedBase', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_UNSET_PREFERRED_LOCATION_PARAMS = struct_c__SA_UVM_UNSET_PREFERRED_LOCATION_PARAMS
class struct_c__SA_UVM_ENABLE_READ_DUPLICATION_PARAMS(Structure):
    pass

struct_c__SA_UVM_ENABLE_READ_DUPLICATION_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_ENABLE_READ_DUPLICATION_PARAMS._fields_ = [
    ('requestedBase', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_ENABLE_READ_DUPLICATION_PARAMS = struct_c__SA_UVM_ENABLE_READ_DUPLICATION_PARAMS
class struct_c__SA_UVM_DISABLE_READ_DUPLICATION_PARAMS(Structure):
    pass

struct_c__SA_UVM_DISABLE_READ_DUPLICATION_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_DISABLE_READ_DUPLICATION_PARAMS._fields_ = [
    ('requestedBase', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_DISABLE_READ_DUPLICATION_PARAMS = struct_c__SA_UVM_DISABLE_READ_DUPLICATION_PARAMS
class struct_c__SA_UVM_SET_ACCESSED_BY_PARAMS(Structure):
    pass

struct_c__SA_UVM_SET_ACCESSED_BY_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_SET_ACCESSED_BY_PARAMS._fields_ = [
    ('requestedBase', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('accessedByUuid', struct_nv_uuid),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_SET_ACCESSED_BY_PARAMS = struct_c__SA_UVM_SET_ACCESSED_BY_PARAMS
class struct_c__SA_UVM_UNSET_ACCESSED_BY_PARAMS(Structure):
    pass

struct_c__SA_UVM_UNSET_ACCESSED_BY_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_UNSET_ACCESSED_BY_PARAMS._fields_ = [
    ('requestedBase', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('accessedByUuid', struct_nv_uuid),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_UNSET_ACCESSED_BY_PARAMS = struct_c__SA_UVM_UNSET_ACCESSED_BY_PARAMS
class struct_c__SA_UVM_MIGRATE_PARAMS(Structure):
    pass

struct_c__SA_UVM_MIGRATE_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_MIGRATE_PARAMS._fields_ = [
    ('base', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('destinationUuid', struct_nv_uuid),
    ('flags', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('semaphoreAddress', ctypes.c_uint64),
    ('semaphorePayload', ctypes.c_uint32),
    ('cpuNumaNode', ctypes.c_int32),
    ('userSpaceStart', ctypes.c_uint64),
    ('userSpaceLength', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

UVM_MIGRATE_PARAMS = struct_c__SA_UVM_MIGRATE_PARAMS
class struct_c__SA_UVM_MIGRATE_RANGE_GROUP_PARAMS(Structure):
    pass

struct_c__SA_UVM_MIGRATE_RANGE_GROUP_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_MIGRATE_RANGE_GROUP_PARAMS._fields_ = [
    ('rangeGroupId', ctypes.c_uint64),
    ('destinationUuid', struct_nv_uuid),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_MIGRATE_RANGE_GROUP_PARAMS = struct_c__SA_UVM_MIGRATE_RANGE_GROUP_PARAMS
class struct_c__SA_UVM_ENABLE_SYSTEM_WIDE_ATOMICS_PARAMS(Structure):
    pass

struct_c__SA_UVM_ENABLE_SYSTEM_WIDE_ATOMICS_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_ENABLE_SYSTEM_WIDE_ATOMICS_PARAMS._fields_ = [
    ('gpu_uuid', struct_nv_uuid),
    ('rmStatus', ctypes.c_uint32),
]

UVM_ENABLE_SYSTEM_WIDE_ATOMICS_PARAMS = struct_c__SA_UVM_ENABLE_SYSTEM_WIDE_ATOMICS_PARAMS
class struct_c__SA_UVM_DISABLE_SYSTEM_WIDE_ATOMICS_PARAMS(Structure):
    pass

struct_c__SA_UVM_DISABLE_SYSTEM_WIDE_ATOMICS_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_DISABLE_SYSTEM_WIDE_ATOMICS_PARAMS._fields_ = [
    ('gpu_uuid', struct_nv_uuid),
    ('rmStatus', ctypes.c_uint32),
]

UVM_DISABLE_SYSTEM_WIDE_ATOMICS_PARAMS = struct_c__SA_UVM_DISABLE_SYSTEM_WIDE_ATOMICS_PARAMS
class struct_c__SA_UVM_TOOLS_INIT_EVENT_TRACKER_PARAMS(Structure):
    pass

struct_c__SA_UVM_TOOLS_INIT_EVENT_TRACKER_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_TOOLS_INIT_EVENT_TRACKER_PARAMS._fields_ = [
    ('queueBuffer', ctypes.c_uint64),
    ('queueBufferSize', ctypes.c_uint64),
    ('controlBuffer', ctypes.c_uint64),
    ('processor', struct_nv_uuid),
    ('allProcessors', ctypes.c_uint32),
    ('uvmFd', ctypes.c_uint32),
    ('rmStatus', ctypes.c_uint32),
    ('requestedVersion', ctypes.c_uint32),
    ('grantedVersion', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_TOOLS_INIT_EVENT_TRACKER_PARAMS = struct_c__SA_UVM_TOOLS_INIT_EVENT_TRACKER_PARAMS
class struct_c__SA_UVM_TOOLS_SET_NOTIFICATION_THRESHOLD_PARAMS(Structure):
    pass

struct_c__SA_UVM_TOOLS_SET_NOTIFICATION_THRESHOLD_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_TOOLS_SET_NOTIFICATION_THRESHOLD_PARAMS._fields_ = [
    ('notificationThreshold', ctypes.c_uint32),
    ('rmStatus', ctypes.c_uint32),
]

UVM_TOOLS_SET_NOTIFICATION_THRESHOLD_PARAMS = struct_c__SA_UVM_TOOLS_SET_NOTIFICATION_THRESHOLD_PARAMS
class struct_c__SA_UVM_TOOLS_EVENT_QUEUE_ENABLE_EVENTS_PARAMS(Structure):
    pass

struct_c__SA_UVM_TOOLS_EVENT_QUEUE_ENABLE_EVENTS_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_TOOLS_EVENT_QUEUE_ENABLE_EVENTS_PARAMS._fields_ = [
    ('eventTypeFlags', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_TOOLS_EVENT_QUEUE_ENABLE_EVENTS_PARAMS = struct_c__SA_UVM_TOOLS_EVENT_QUEUE_ENABLE_EVENTS_PARAMS
class struct_c__SA_UVM_TOOLS_EVENT_QUEUE_DISABLE_EVENTS_PARAMS(Structure):
    pass

struct_c__SA_UVM_TOOLS_EVENT_QUEUE_DISABLE_EVENTS_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_TOOLS_EVENT_QUEUE_DISABLE_EVENTS_PARAMS._fields_ = [
    ('eventTypeFlags', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_TOOLS_EVENT_QUEUE_DISABLE_EVENTS_PARAMS = struct_c__SA_UVM_TOOLS_EVENT_QUEUE_DISABLE_EVENTS_PARAMS
class struct_c__SA_UVM_TOOLS_ENABLE_COUNTERS_PARAMS(Structure):
    pass

struct_c__SA_UVM_TOOLS_ENABLE_COUNTERS_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_TOOLS_ENABLE_COUNTERS_PARAMS._fields_ = [
    ('counterTypeFlags', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_TOOLS_ENABLE_COUNTERS_PARAMS = struct_c__SA_UVM_TOOLS_ENABLE_COUNTERS_PARAMS
class struct_c__SA_UVM_TOOLS_DISABLE_COUNTERS_PARAMS(Structure):
    pass

struct_c__SA_UVM_TOOLS_DISABLE_COUNTERS_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_TOOLS_DISABLE_COUNTERS_PARAMS._fields_ = [
    ('counterTypeFlags', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_TOOLS_DISABLE_COUNTERS_PARAMS = struct_c__SA_UVM_TOOLS_DISABLE_COUNTERS_PARAMS
class struct_c__SA_UVM_TOOLS_READ_PROCESS_MEMORY_PARAMS(Structure):
    pass

struct_c__SA_UVM_TOOLS_READ_PROCESS_MEMORY_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_TOOLS_READ_PROCESS_MEMORY_PARAMS._fields_ = [
    ('buffer', ctypes.c_uint64),
    ('size', ctypes.c_uint64),
    ('targetVa', ctypes.c_uint64),
    ('bytesRead', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_TOOLS_READ_PROCESS_MEMORY_PARAMS = struct_c__SA_UVM_TOOLS_READ_PROCESS_MEMORY_PARAMS
class struct_c__SA_UVM_TOOLS_WRITE_PROCESS_MEMORY_PARAMS(Structure):
    pass

struct_c__SA_UVM_TOOLS_WRITE_PROCESS_MEMORY_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_TOOLS_WRITE_PROCESS_MEMORY_PARAMS._fields_ = [
    ('buffer', ctypes.c_uint64),
    ('size', ctypes.c_uint64),
    ('targetVa', ctypes.c_uint64),
    ('bytesWritten', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_TOOLS_WRITE_PROCESS_MEMORY_PARAMS = struct_c__SA_UVM_TOOLS_WRITE_PROCESS_MEMORY_PARAMS
class struct_c__SA_UVM_TOOLS_GET_PROCESSOR_UUID_TABLE_PARAMS(Structure):
    pass

struct_c__SA_UVM_TOOLS_GET_PROCESSOR_UUID_TABLE_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_TOOLS_GET_PROCESSOR_UUID_TABLE_PARAMS._fields_ = [
    ('tablePtr', ctypes.c_uint64),
    ('count', ctypes.c_uint32),
    ('rmStatus', ctypes.c_uint32),
    ('version', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_TOOLS_GET_PROCESSOR_UUID_TABLE_PARAMS = struct_c__SA_UVM_TOOLS_GET_PROCESSOR_UUID_TABLE_PARAMS
class struct_c__SA_UVM_MAP_DYNAMIC_PARALLELISM_REGION_PARAMS(Structure):
    pass

struct_c__SA_UVM_MAP_DYNAMIC_PARALLELISM_REGION_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_MAP_DYNAMIC_PARALLELISM_REGION_PARAMS._fields_ = [
    ('base', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('gpuUuid', struct_nv_uuid),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_MAP_DYNAMIC_PARALLELISM_REGION_PARAMS = struct_c__SA_UVM_MAP_DYNAMIC_PARALLELISM_REGION_PARAMS
class struct_c__SA_UVM_UNMAP_EXTERNAL_PARAMS(Structure):
    pass

struct_c__SA_UVM_UNMAP_EXTERNAL_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_UNMAP_EXTERNAL_PARAMS._fields_ = [
    ('base', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('gpuUuid', struct_nv_uuid),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_UNMAP_EXTERNAL_PARAMS = struct_c__SA_UVM_UNMAP_EXTERNAL_PARAMS
class struct_c__SA_UVM_TOOLS_FLUSH_EVENTS_PARAMS(Structure):
    pass

struct_c__SA_UVM_TOOLS_FLUSH_EVENTS_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_TOOLS_FLUSH_EVENTS_PARAMS._fields_ = [
    ('rmStatus', ctypes.c_uint32),
]

UVM_TOOLS_FLUSH_EVENTS_PARAMS = struct_c__SA_UVM_TOOLS_FLUSH_EVENTS_PARAMS
class struct_c__SA_UVM_ALLOC_SEMAPHORE_POOL_PARAMS(Structure):
    pass

struct_c__SA_UVM_ALLOC_SEMAPHORE_POOL_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_ALLOC_SEMAPHORE_POOL_PARAMS._fields_ = [
    ('base', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('perGpuAttributes', struct_c__SA_UvmGpuMappingAttributes * 256),
    ('gpuAttributesCount', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_ALLOC_SEMAPHORE_POOL_PARAMS = struct_c__SA_UVM_ALLOC_SEMAPHORE_POOL_PARAMS
class struct_c__SA_UVM_CLEAN_UP_ZOMBIE_RESOURCES_PARAMS(Structure):
    pass

struct_c__SA_UVM_CLEAN_UP_ZOMBIE_RESOURCES_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_CLEAN_UP_ZOMBIE_RESOURCES_PARAMS._fields_ = [
    ('rmStatus', ctypes.c_uint32),
]

UVM_CLEAN_UP_ZOMBIE_RESOURCES_PARAMS = struct_c__SA_UVM_CLEAN_UP_ZOMBIE_RESOURCES_PARAMS
class struct_c__SA_UVM_PAGEABLE_MEM_ACCESS_ON_GPU_PARAMS(Structure):
    pass

struct_c__SA_UVM_PAGEABLE_MEM_ACCESS_ON_GPU_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_PAGEABLE_MEM_ACCESS_ON_GPU_PARAMS._fields_ = [
    ('gpu_uuid', struct_nv_uuid),
    ('pageableMemAccess', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('rmStatus', ctypes.c_uint32),
]

UVM_PAGEABLE_MEM_ACCESS_ON_GPU_PARAMS = struct_c__SA_UVM_PAGEABLE_MEM_ACCESS_ON_GPU_PARAMS
class struct_c__SA_UVM_POPULATE_PAGEABLE_PARAMS(Structure):
    pass

struct_c__SA_UVM_POPULATE_PAGEABLE_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_POPULATE_PAGEABLE_PARAMS._fields_ = [
    ('base', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('flags', ctypes.c_uint32),
    ('rmStatus', ctypes.c_uint32),
]

UVM_POPULATE_PAGEABLE_PARAMS = struct_c__SA_UVM_POPULATE_PAGEABLE_PARAMS
class struct_c__SA_UVM_VALIDATE_VA_RANGE_PARAMS(Structure):
    pass

struct_c__SA_UVM_VALIDATE_VA_RANGE_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_VALIDATE_VA_RANGE_PARAMS._fields_ = [
    ('base', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_VALIDATE_VA_RANGE_PARAMS = struct_c__SA_UVM_VALIDATE_VA_RANGE_PARAMS
class struct_c__SA_UVM_CREATE_EXTERNAL_RANGE_PARAMS(Structure):
    pass

struct_c__SA_UVM_CREATE_EXTERNAL_RANGE_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_CREATE_EXTERNAL_RANGE_PARAMS._fields_ = [
    ('base', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_CREATE_EXTERNAL_RANGE_PARAMS = struct_c__SA_UVM_CREATE_EXTERNAL_RANGE_PARAMS
class struct_c__SA_UVM_MAP_EXTERNAL_SPARSE_PARAMS(Structure):
    pass

struct_c__SA_UVM_MAP_EXTERNAL_SPARSE_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_MAP_EXTERNAL_SPARSE_PARAMS._fields_ = [
    ('base', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('gpuUuid', struct_nv_uuid),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_MAP_EXTERNAL_SPARSE_PARAMS = struct_c__SA_UVM_MAP_EXTERNAL_SPARSE_PARAMS
class struct_c__SA_UVM_MM_INITIALIZE_PARAMS(Structure):
    pass

struct_c__SA_UVM_MM_INITIALIZE_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_MM_INITIALIZE_PARAMS._fields_ = [
    ('uvmFd', ctypes.c_int32),
    ('rmStatus', ctypes.c_uint32),
]

UVM_MM_INITIALIZE_PARAMS = struct_c__SA_UVM_MM_INITIALIZE_PARAMS
class struct_c__SA_UVM_IS_8_SUPPORTED_PARAMS(Structure):
    pass

struct_c__SA_UVM_IS_8_SUPPORTED_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_IS_8_SUPPORTED_PARAMS._fields_ = [
    ('is8Supported', ctypes.c_uint32),
    ('rmStatus', ctypes.c_uint32),
]

UVM_IS_8_SUPPORTED_PARAMS = struct_c__SA_UVM_IS_8_SUPPORTED_PARAMS
_UVM_LINUX_IOCTL_H = True # macro
UVM_INITIALIZE = 0x30000001 # macro
UVM_DEINITIALIZE = 0x30000002 # macro
class struct_c__SA_UVM_INITIALIZE_PARAMS(Structure):
    pass

struct_c__SA_UVM_INITIALIZE_PARAMS._pack_ = 1 # source:False
struct_c__SA_UVM_INITIALIZE_PARAMS._fields_ = [
    ('flags', ctypes.c_uint64),
    ('rmStatus', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

UVM_INITIALIZE_PARAMS = struct_c__SA_UVM_INITIALIZE_PARAMS
NV_ESCAPE_H_INCLUDED = True # macro
NV_ESC_RM_ALLOC_MEMORY = 0x27 # macro
NV_ESC_RM_ALLOC_OBJECT = 0x28 # macro
NV_ESC_RM_FREE = 0x29 # macro
NV_ESC_RM_CONTROL = 0x2A # macro
NV_ESC_RM_ALLOC = 0x2B # macro
NV_ESC_RM_CONFIG_GET = 0x32 # macro
NV_ESC_RM_CONFIG_SET = 0x33 # macro
NV_ESC_RM_DUP_OBJECT = 0x34 # macro
NV_ESC_RM_SHARE = 0x35 # macro
NV_ESC_RM_CONFIG_GET_EX = 0x37 # macro
NV_ESC_RM_CONFIG_SET_EX = 0x38 # macro
NV_ESC_RM_I2C_ACCESS = 0x39 # macro
NV_ESC_RM_IDLE_CHANNELS = 0x41 # macro
NV_ESC_RM_VID_HEAP_CONTROL = 0x4A # macro
NV_ESC_RM_ACCESS_REGISTRY = 0x4D # macro
NV_ESC_RM_MAP_MEMORY = 0x4E # macro
NV_ESC_RM_UNMAP_MEMORY = 0x4F # macro
NV_ESC_RM_GET_EVENT_DATA = 0x52 # macro
NV_ESC_RM_ALLOC_CONTEXT_DMA2 = 0x54 # macro
NV_ESC_RM_ADD_VBLANK_CALLBACK = 0x56 # macro
NV_ESC_RM_MAP_MEMORY_DMA = 0x57 # macro
NV_ESC_RM_UNMAP_MEMORY_DMA = 0x58 # macro
NV_ESC_RM_BIND_CONTEXT_DMA = 0x59 # macro
NV_ESC_RM_EXPORT_OBJECT_TO_FD = 0x5C # macro
NV_ESC_RM_IMPORT_OBJECT_FROM_FD = 0x5D # macro
NV_ESC_RM_UPDATE_DEVICE_MAPPING_INFO = 0x5E # macro
NV_ESC_RM_LOCKLESS_DIAGNOSTIC = 0x5F # macro
NV_IOCTL_H = True # macro
NV_RM_API_VERSION_STRING_LENGTH = 64 # macro
NV_RM_API_VERSION_CMD_STRICT = 0 # macro
NV_RM_API_VERSION_CMD_RELAXED = '1' # macro
NV_RM_API_VERSION_CMD_QUERY = '2' # macro
NV_RM_API_VERSION_REPLY_UNRECOGNIZED = 0 # macro
NV_RM_API_VERSION_REPLY_RECOGNIZED = 1 # macro
NV_DMABUF_EXPORT_MAX_HANDLES = 128 # macro
class struct_c__SA_nv_pci_info_t(Structure):
    pass

struct_c__SA_nv_pci_info_t._pack_ = 1 # source:False
struct_c__SA_nv_pci_info_t._fields_ = [
    ('domain', ctypes.c_uint32),
    ('bus', ctypes.c_ubyte),
    ('slot', ctypes.c_ubyte),
    ('function', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte),
    ('vendor_id', ctypes.c_uint16),
    ('device_id', ctypes.c_uint16),
]

nv_pci_info_t = struct_c__SA_nv_pci_info_t
class struct_nv_ioctl_xfer(Structure):
    pass

struct_nv_ioctl_xfer._pack_ = 1 # source:False
struct_nv_ioctl_xfer._fields_ = [
    ('cmd', ctypes.c_uint32),
    ('size', ctypes.c_uint32),
    ('ptr', ctypes.POINTER(None)),
]

nv_ioctl_xfer_t = struct_nv_ioctl_xfer
class struct_nv_ioctl_card_info(Structure):
    pass

struct_nv_ioctl_card_info._pack_ = 1 # source:False
struct_nv_ioctl_card_info._fields_ = [
    ('valid', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('pci_info', nv_pci_info_t),
    ('gpu_id', ctypes.c_uint32),
    ('interrupt_line', ctypes.c_uint16),
    ('PADDING_1', ctypes.c_ubyte * 2),
    ('reg_address', ctypes.c_uint64),
    ('reg_size', ctypes.c_uint64),
    ('fb_address', ctypes.c_uint64),
    ('fb_size', ctypes.c_uint64),
    ('minor_number', ctypes.c_uint32),
    ('dev_name', ctypes.c_ubyte * 10),
    ('PADDING_2', ctypes.c_ubyte * 2),
]

nv_ioctl_card_info_t = struct_nv_ioctl_card_info
class struct_nv_ioctl_alloc_os_event(Structure):
    pass

struct_nv_ioctl_alloc_os_event._pack_ = 1 # source:False
struct_nv_ioctl_alloc_os_event._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hDevice', ctypes.c_uint32),
    ('fd', ctypes.c_uint32),
    ('Status', ctypes.c_uint32),
]

nv_ioctl_alloc_os_event_t = struct_nv_ioctl_alloc_os_event
class struct_nv_ioctl_free_os_event(Structure):
    pass

struct_nv_ioctl_free_os_event._pack_ = 1 # source:False
struct_nv_ioctl_free_os_event._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hDevice', ctypes.c_uint32),
    ('fd', ctypes.c_uint32),
    ('Status', ctypes.c_uint32),
]

nv_ioctl_free_os_event_t = struct_nv_ioctl_free_os_event
class struct_nv_ioctl_status_code(Structure):
    pass

struct_nv_ioctl_status_code._pack_ = 1 # source:False
struct_nv_ioctl_status_code._fields_ = [
    ('domain', ctypes.c_uint32),
    ('bus', ctypes.c_ubyte),
    ('slot', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 2),
    ('status', ctypes.c_uint32),
]

nv_ioctl_status_code_t = struct_nv_ioctl_status_code
class struct_nv_ioctl_rm_api_version(Structure):
    pass

struct_nv_ioctl_rm_api_version._pack_ = 1 # source:False
struct_nv_ioctl_rm_api_version._fields_ = [
    ('cmd', ctypes.c_uint32),
    ('reply', ctypes.c_uint32),
    ('versionString', ctypes.c_char * 64),
]

nv_ioctl_rm_api_version_t = struct_nv_ioctl_rm_api_version
class struct_nv_ioctl_query_device_intr(Structure):
    pass

struct_nv_ioctl_query_device_intr._pack_ = 1 # source:False
struct_nv_ioctl_query_device_intr._fields_ = [
    ('intrStatus', ctypes.c_uint32),
    ('status', ctypes.c_uint32),
]

nv_ioctl_query_device_intr = struct_nv_ioctl_query_device_intr
class struct_nv_ioctl_sys_params(Structure):
    pass

struct_nv_ioctl_sys_params._pack_ = 1 # source:False
struct_nv_ioctl_sys_params._fields_ = [
    ('memblock_size', ctypes.c_uint64),
]

nv_ioctl_sys_params_t = struct_nv_ioctl_sys_params
class struct_nv_ioctl_register_fd(Structure):
    pass

struct_nv_ioctl_register_fd._pack_ = 1 # source:False
struct_nv_ioctl_register_fd._fields_ = [
    ('ctl_fd', ctypes.c_int32),
]

nv_ioctl_register_fd_t = struct_nv_ioctl_register_fd
class struct_nv_ioctl_export_to_dma_buf_fd(Structure):
    pass

struct_nv_ioctl_export_to_dma_buf_fd._pack_ = 1 # source:False
struct_nv_ioctl_export_to_dma_buf_fd._fields_ = [
    ('fd', ctypes.c_int32),
    ('hClient', ctypes.c_uint32),
    ('totalObjects', ctypes.c_uint32),
    ('numObjects', ctypes.c_uint32),
    ('index', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('totalSize', ctypes.c_uint64),
    ('handles', ctypes.c_uint32 * 128),
    ('offsets', ctypes.c_uint64 * 128),
    ('sizes', ctypes.c_uint64 * 128),
    ('status', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

nv_ioctl_export_to_dma_buf_fd_t = struct_nv_ioctl_export_to_dma_buf_fd
class struct_nv_ioctl_wait_open_complete(Structure):
    pass

struct_nv_ioctl_wait_open_complete._pack_ = 1 # source:False
struct_nv_ioctl_wait_open_complete._fields_ = [
    ('rc', ctypes.c_int32),
    ('adapterStatus', ctypes.c_uint32),
]

nv_ioctl_wait_open_complete_t = struct_nv_ioctl_wait_open_complete
NV_IOCTL_NUMBERS_H = True # macro
NV_IOCTL_MAGIC = 'F' # macro
NV_IOCTL_BASE = 200 # macro
NV_ESC_CARD_INFO = (200+0) # macro
NV_ESC_REGISTER_FD = (200+1) # macro
NV_ESC_ALLOC_OS_EVENT = (200+6) # macro
NV_ESC_FREE_OS_EVENT = (200+7) # macro
NV_ESC_STATUS_CODE = (200+9) # macro
NV_ESC_CHECK_VERSION_STR = (200+10) # macro
NV_ESC_IOCTL_XFER_CMD = (200+11) # macro
NV_ESC_ATTACH_GPUS_TO_FD = (200+12) # macro
NV_ESC_QUERY_DEVICE_INTR = (200+13) # macro
NV_ESC_SYS_PARAMS = (200+14) # macro
NV_ESC_EXPORT_TO_DMABUF_FD = (200+17) # macro
NV_ESC_WAIT_OPEN_COMPLETE = (200+18) # macro
NV_IOCTL_NUMA_H = True # macro
# def __aligned(n):  # macro
#    return __attribute__((aligned(n)))
NV_ESC_NUMA_INFO = (200+15) # macro
NV_ESC_SET_NUMA_STATUS = (200+16) # macro
NV_IOCTL_NUMA_INFO_MAX_OFFLINE_ADDRESSES = 64 # macro
NV_IOCTL_NUMA_STATUS_DISABLED = 0 # macro
NV_IOCTL_NUMA_STATUS_OFFLINE = 1 # macro
NV_IOCTL_NUMA_STATUS_ONLINE_IN_PROGRESS = 2 # macro
NV_IOCTL_NUMA_STATUS_ONLINE = 3 # macro
NV_IOCTL_NUMA_STATUS_ONLINE_FAILED = 4 # macro
NV_IOCTL_NUMA_STATUS_OFFLINE_IN_PROGRESS = 5 # macro
NV_IOCTL_NUMA_STATUS_OFFLINE_FAILED = 6 # macro
class struct_offline_addresses(Structure):
    pass

struct_offline_addresses._pack_ = 1 # source:False
struct_offline_addresses._fields_ = [
    ('addresses', ctypes.c_uint64 * 64),
    ('numEntries', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

nv_offline_addresses_t = struct_offline_addresses
class struct_nv_ioctl_numa_info(Structure):
    pass

struct_nv_ioctl_numa_info._pack_ = 1 # source:False
struct_nv_ioctl_numa_info._fields_ = [
    ('nid', ctypes.c_int32),
    ('status', ctypes.c_int32),
    ('memblock_size', ctypes.c_uint64),
    ('numa_mem_addr', ctypes.c_uint64),
    ('numa_mem_size', ctypes.c_uint64),
    ('use_auto_online', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 7),
    ('offline_addresses', nv_offline_addresses_t),
]

nv_ioctl_numa_info_t = struct_nv_ioctl_numa_info
class struct_nv_ioctl_set_numa_status(Structure):
    pass

struct_nv_ioctl_set_numa_status._pack_ = 1 # source:False
struct_nv_ioctl_set_numa_status._fields_ = [
    ('status', ctypes.c_int32),
]

nv_ioctl_set_numa_status_t = struct_nv_ioctl_set_numa_status
_NV_UNIX_NVOS_PARAMS_WRAPPERS_H_ = True # macro
NVOS_INCLUDED = True # macro
NVOS04_FLAGS_CHANNEL_TYPE = ['1', ':', '0'] # macro
NVOS04_FLAGS_CHANNEL_TYPE_PHYSICAL = 0x00000000 # macro
NVOS04_FLAGS_CHANNEL_TYPE_VIRTUAL = 0x00000001 # macro
NVOS04_FLAGS_CHANNEL_TYPE_PHYSICAL_FOR_VIRTUAL = 0x00000002 # macro
NVOS04_FLAGS_VPR = ['2', ':', '2'] # macro
NVOS04_FLAGS_VPR_FALSE = 0x00000000 # macro
NVOS04_FLAGS_VPR_TRUE = 0x00000001 # macro
NVOS04_FLAGS_CC_SECURE = ['2', ':', '2'] # macro
NVOS04_FLAGS_CC_SECURE_FALSE = 0x00000000 # macro
NVOS04_FLAGS_CC_SECURE_TRUE = 0x00000001 # macro
NVOS04_FLAGS_CHANNEL_SKIP_MAP_REFCOUNTING = ['3', ':', '3'] # macro
NVOS04_FLAGS_CHANNEL_SKIP_MAP_REFCOUNTING_FALSE = 0x00000000 # macro
NVOS04_FLAGS_CHANNEL_SKIP_MAP_REFCOUNTING_TRUE = 0x00000001 # macro
NVOS04_FLAGS_GROUP_CHANNEL_RUNQUEUE = ['4', ':', '4'] # macro
NVOS04_FLAGS_GROUP_CHANNEL_RUNQUEUE_DEFAULT = 0x00000000 # macro
NVOS04_FLAGS_GROUP_CHANNEL_RUNQUEUE_ONE = 0x00000001 # macro
NVOS04_FLAGS_PRIVILEGED_CHANNEL = ['5', ':', '5'] # macro
NVOS04_FLAGS_PRIVILEGED_CHANNEL_FALSE = 0x00000000 # macro
NVOS04_FLAGS_PRIVILEGED_CHANNEL_TRUE = 0x00000001 # macro
NVOS04_FLAGS_DELAY_CHANNEL_SCHEDULING = ['6', ':', '6'] # macro
NVOS04_FLAGS_DELAY_CHANNEL_SCHEDULING_FALSE = 0x00000000 # macro
NVOS04_FLAGS_DELAY_CHANNEL_SCHEDULING_TRUE = 0x00000001 # macro
NVOS04_FLAGS_CHANNEL_DENY_PHYSICAL_MODE_CE = ['7', ':', '7'] # macro
NVOS04_FLAGS_CHANNEL_DENY_PHYSICAL_MODE_CE_FALSE = 0x00000000 # macro
NVOS04_FLAGS_CHANNEL_DENY_PHYSICAL_MODE_CE_TRUE = 0x00000001 # macro
NVOS04_FLAGS_CHANNEL_USERD_INDEX_VALUE = ['10', ':', '8'] # macro
NVOS04_FLAGS_CHANNEL_USERD_INDEX_FIXED = ['11', ':', '11'] # macro
NVOS04_FLAGS_CHANNEL_USERD_INDEX_FIXED_FALSE = 0x00000000 # macro
NVOS04_FLAGS_CHANNEL_USERD_INDEX_FIXED_TRUE = 0x00000001 # macro
NVOS04_FLAGS_CHANNEL_USERD_INDEX_PAGE_VALUE = ['20', ':', '12'] # macro
NVOS04_FLAGS_CHANNEL_USERD_INDEX_PAGE_FIXED = ['21', ':', '21'] # macro
NVOS04_FLAGS_CHANNEL_USERD_INDEX_PAGE_FIXED_FALSE = 0x00000000 # macro
NVOS04_FLAGS_CHANNEL_USERD_INDEX_PAGE_FIXED_TRUE = 0x00000001 # macro
NVOS04_FLAGS_CHANNEL_DENY_AUTH_LEVEL_PRIV = ['22', ':', '22'] # macro
NVOS04_FLAGS_CHANNEL_DENY_AUTH_LEVEL_PRIV_FALSE = 0x00000000 # macro
NVOS04_FLAGS_CHANNEL_DENY_AUTH_LEVEL_PRIV_TRUE = 0x00000001 # macro
NVOS04_FLAGS_CHANNEL_SKIP_SCRUBBER = ['23', ':', '23'] # macro
NVOS04_FLAGS_CHANNEL_SKIP_SCRUBBER_FALSE = 0x00000000 # macro
NVOS04_FLAGS_CHANNEL_SKIP_SCRUBBER_TRUE = 0x00000001 # macro
NVOS04_FLAGS_CHANNEL_CLIENT_MAP_FIFO = ['24', ':', '24'] # macro
NVOS04_FLAGS_CHANNEL_CLIENT_MAP_FIFO_FALSE = 0x00000000 # macro
NVOS04_FLAGS_CHANNEL_CLIENT_MAP_FIFO_TRUE = 0x00000001 # macro
NVOS04_FLAGS_SET_EVICT_LAST_CE_PREFETCH_CHANNEL = ['25', ':', '25'] # macro
NVOS04_FLAGS_SET_EVICT_LAST_CE_PREFETCH_CHANNEL_FALSE = 0x00000000 # macro
NVOS04_FLAGS_SET_EVICT_LAST_CE_PREFETCH_CHANNEL_TRUE = 0x00000001 # macro
NVOS04_FLAGS_CHANNEL_VGPU_PLUGIN_CONTEXT = ['26', ':', '26'] # macro
NVOS04_FLAGS_CHANNEL_VGPU_PLUGIN_CONTEXT_FALSE = 0x00000000 # macro
NVOS04_FLAGS_CHANNEL_VGPU_PLUGIN_CONTEXT_TRUE = 0x00000001 # macro
NVOS04_FLAGS_CHANNEL_PBDMA_ACQUIRE_TIMEOUT = ['27', ':', '27'] # macro
NVOS04_FLAGS_CHANNEL_PBDMA_ACQUIRE_TIMEOUT_FALSE = 0x00000000 # macro
NVOS04_FLAGS_CHANNEL_PBDMA_ACQUIRE_TIMEOUT_TRUE = 0x00000001 # macro
NVOS04_FLAGS_GROUP_CHANNEL_THREAD = ['29', ':', '28'] # macro
NVOS04_FLAGS_GROUP_CHANNEL_THREAD_DEFAULT = 0x00000000 # macro
NVOS04_FLAGS_GROUP_CHANNEL_THREAD_ONE = 0x00000001 # macro
NVOS04_FLAGS_GROUP_CHANNEL_THREAD_TWO = 0x00000002 # macro
NVOS04_FLAGS_MAP_CHANNEL = ['30', ':', '30'] # macro
NVOS04_FLAGS_MAP_CHANNEL_FALSE = 0x00000000 # macro
NVOS04_FLAGS_MAP_CHANNEL_TRUE = 0x00000001 # macro
NVOS04_FLAGS_SKIP_CTXBUFFER_ALLOC = ['31', ':', '31'] # macro
NVOS04_FLAGS_SKIP_CTXBUFFER_ALLOC_FALSE = 0x00000000 # macro
NVOS04_FLAGS_SKIP_CTXBUFFER_ALLOC_TRUE = 0x00000001 # macro
CC_CHAN_ALLOC_IV_SIZE_DWORD = 3 # macro
CC_CHAN_ALLOC_NONCE_SIZE_DWORD = 8 # macro
NV_CHANNEL_ALLOC_PARAMS_MESSAGE_ID = (0x906f) # macro
FILE_DEVICE_NV = 0x00008000 # macro
NV_IOCTL_FCT_BASE = 0x00000800 # macro
NVOS_MAX_SUBDEVICES = 8 # macro
UNIFIED_NV_STATUS = 1 # macro
# NVOS_STATUS = NV_STATUS # macro
# NVOS_STATUS_SUCCESS = NV_OK # macro
# NVOS_STATUS_ERROR_CARD_NOT_PRESENT = NV_ERR_CARD_NOT_PRESENT # macro
# NVOS_STATUS_ERROR_DUAL_LINK_INUSE = NV_ERR_DUAL_LINK_INUSE # macro
# NVOS_STATUS_ERROR_GENERIC = NV_ERR_GENERIC # macro
# NVOS_STATUS_ERROR_GPU_NOT_FULL_POWER = NV_ERR_GPU_NOT_FULL_POWER # macro
# NVOS_STATUS_ERROR_ILLEGAL_ACTION = NV_ERR_ILLEGAL_ACTION # macro
# NVOS_STATUS_ERROR_IN_USE = NV_ERR_STATE_IN_USE # macro
# NVOS_STATUS_ERROR_INSUFFICIENT_RESOURCES = NV_ERR_INSUFFICIENT_RESOURCES # macro
# NVOS_STATUS_ERROR_INVALID_ACCESS_TYPE = NV_ERR_INVALID_ACCESS_TYPE # macro
# NVOS_STATUS_ERROR_INVALID_ARGUMENT = NV_ERR_INVALID_ARGUMENT # macro
# NVOS_STATUS_ERROR_INVALID_BASE = NV_ERR_INVALID_BASE # macro
# NVOS_STATUS_ERROR_INVALID_CHANNEL = NV_ERR_INVALID_CHANNEL # macro
# NVOS_STATUS_ERROR_INVALID_CLASS = NV_ERR_INVALID_CLASS # macro
# NVOS_STATUS_ERROR_INVALID_CLIENT = NV_ERR_INVALID_CLIENT # macro
# NVOS_STATUS_ERROR_INVALID_COMMAND = NV_ERR_INVALID_COMMAND # macro
# NVOS_STATUS_ERROR_INVALID_DATA = NV_ERR_INVALID_DATA # macro
# NVOS_STATUS_ERROR_INVALID_DEVICE = NV_ERR_INVALID_DEVICE # macro
# NVOS_STATUS_ERROR_INVALID_DMA_SPECIFIER = NV_ERR_INVALID_DMA_SPECIFIER # macro
# NVOS_STATUS_ERROR_INVALID_EVENT = NV_ERR_INVALID_EVENT # macro
# NVOS_STATUS_ERROR_INVALID_FLAGS = NV_ERR_INVALID_FLAGS # macro
# NVOS_STATUS_ERROR_INVALID_FUNCTION = NV_ERR_INVALID_FUNCTION # macro
# NVOS_STATUS_ERROR_INVALID_HEAP = NV_ERR_INVALID_HEAP # macro
# NVOS_STATUS_ERROR_INVALID_INDEX = NV_ERR_INVALID_INDEX # macro
# NVOS_STATUS_ERROR_INVALID_LIMIT = NV_ERR_INVALID_LIMIT # macro
# NVOS_STATUS_ERROR_INVALID_METHOD = NV_ERR_INVALID_METHOD # macro
# NVOS_STATUS_ERROR_INVALID_OBJECT_BUFFER = NV_ERR_BUFFER_TOO_SMALL # macro
# NVOS_STATUS_ERROR_INVALID_OBJECT_ERROR = NV_ERR_INVALID_OBJECT # macro
# NVOS_STATUS_ERROR_INVALID_OBJECT_HANDLE = NV_ERR_INVALID_OBJECT_HANDLE # macro
# NVOS_STATUS_ERROR_INVALID_OBJECT_NEW = NV_ERR_INVALID_OBJECT_NEW # macro
# NVOS_STATUS_ERROR_INVALID_OBJECT_OLD = NV_ERR_INVALID_OBJECT_OLD # macro
# NVOS_STATUS_ERROR_INVALID_OBJECT_PARENT = NV_ERR_INVALID_OBJECT_PARENT # macro
# NVOS_STATUS_ERROR_INVALID_OFFSET = NV_ERR_INVALID_OFFSET # macro
# NVOS_STATUS_ERROR_INVALID_OWNER = NV_ERR_INVALID_OWNER # macro
# NVOS_STATUS_ERROR_INVALID_PARAM_STRUCT = NV_ERR_INVALID_PARAM_STRUCT # macro
# NVOS_STATUS_ERROR_INVALID_PARAMETER = NV_ERR_INVALID_PARAMETER # macro
# NVOS_STATUS_ERROR_INVALID_POINTER = NV_ERR_INVALID_POINTER # macro
# NVOS_STATUS_ERROR_INVALID_REGISTRY_KEY = NV_ERR_INVALID_REGISTRY_KEY # macro
# NVOS_STATUS_ERROR_INVALID_STATE = NV_ERR_INVALID_STATE # macro
# NVOS_STATUS_ERROR_INVALID_STRING_LENGTH = NV_ERR_INVALID_STRING_LENGTH # macro
# NVOS_STATUS_ERROR_INVALID_XLATE = NV_ERR_INVALID_XLATE # macro
# NVOS_STATUS_ERROR_IRQ_NOT_FIRING = NV_ERR_IRQ_NOT_FIRING # macro
# NVOS_STATUS_ERROR_MULTIPLE_MEMORY_TYPES = NV_ERR_MULTIPLE_MEMORY_TYPES # macro
# NVOS_STATUS_ERROR_NOT_SUPPORTED = NV_ERR_NOT_SUPPORTED # macro
# NVOS_STATUS_ERROR_OPERATING_SYSTEM = NV_ERR_OPERATING_SYSTEM # macro
# NVOS_STATUS_ERROR_LIB_RM_VERSION_MISMATCH = NV_ERR_LIB_RM_VERSION_MISMATCH # macro
# NVOS_STATUS_ERROR_PROTECTION_FAULT = NV_ERR_PROTECTION_FAULT # macro
# NVOS_STATUS_ERROR_TIMEOUT = NV_ERR_TIMEOUT # macro
# NVOS_STATUS_ERROR_TOO_MANY_PRIMARIES = NV_ERR_TOO_MANY_PRIMARIES # macro
# NVOS_STATUS_ERROR_IRQ_EDGE_TRIGGERED = NV_ERR_IRQ_EDGE_TRIGGERED # macro
# NVOS_STATUS_ERROR_INVALID_OPERATION = NV_ERR_INVALID_OPERATION # macro
# NVOS_STATUS_ERROR_NOT_COMPATIBLE = NV_ERR_NOT_COMPATIBLE # macro
# NVOS_STATUS_ERROR_MORE_PROCESSING_REQUIRED = NV_WARN_MORE_PROCESSING_REQUIRED # macro
# NVOS_STATUS_ERROR_INSUFFICIENT_PERMISSIONS = NV_ERR_INSUFFICIENT_PERMISSIONS # macro
# NVOS_STATUS_ERROR_TIMEOUT_RETRY = NV_ERR_TIMEOUT_RETRY # macro
# NVOS_STATUS_ERROR_NOT_READY = NV_ERR_NOT_READY # macro
# NVOS_STATUS_ERROR_GPU_IS_LOST = NV_ERR_GPU_IS_LOST # macro
# NVOS_STATUS_ERROR_IN_FULLCHIP_RESET = NV_ERR_GPU_IN_FULLCHIP_RESET # macro
# NVOS_STATUS_ERROR_INVALID_LOCK_STATE = NV_ERR_INVALID_LOCK_STATE # macro
# NVOS_STATUS_ERROR_INVALID_ADDRESS = NV_ERR_INVALID_ADDRESS # macro
# NVOS_STATUS_ERROR_INVALID_IRQ_LEVEL = NV_ERR_INVALID_IRQ_LEVEL # macro
# NVOS_STATUS_ERROR_MEMORY_TRAINING_FAILED = NV_ERR_MEMORY_TRAINING_FAILED # macro
# NVOS_STATUS_ERROR_BUSY_RETRY = NV_ERR_BUSY_RETRY # macro
# NVOS_STATUS_ERROR_INSUFFICIENT_POWER = NV_ERR_INSUFFICIENT_POWER # macro
# NVOS_STATUS_ERROR_OBJECT_NOT_FOUND = NV_ERR_OBJECT_NOT_FOUND # macro
# NVOS_STATUS_ERROR_RESOURCE_LOST = NV_ERR_RESOURCE_LOST # macro
# NVOS_STATUS_ERROR_BUFFER_TOO_SMALL = NV_ERR_BUFFER_TOO_SMALL # macro
# NVOS_STATUS_ERROR_RESET_REQUIRED = NV_ERR_RESET_REQUIRED # macro
# NVOS_STATUS_ERROR_INVALID_REQUEST = NV_ERR_INVALID_REQUEST # macro
# NVOS_STATUS_ERROR_PRIV_SEC_VIOLATION = NV_ERR_PRIV_SEC_VIOLATION # macro
# NVOS_STATUS_ERROR_GPU_IN_DEBUG_MODE = NV_ERR_GPU_IN_DEBUG_MODE # macro
# NVOS_STATUS_ERROR_ALREADY_SIGNALLED = NV_ERR_ALREADY_SIGNALLED # macro
NV01_FREE = (0x00000000) # macro
NV01_ROOT_USER = (0x00000041) # macro
NV01_ALLOC_MEMORY = (0x00000002) # macro
NVOS02_FLAGS_PHYSICALITY = ['7', ':', '4'] # macro
NVOS02_FLAGS_PHYSICALITY_CONTIGUOUS = (0x00000000) # macro
NVOS02_FLAGS_PHYSICALITY_NONCONTIGUOUS = (0x00000001) # macro
NVOS02_FLAGS_LOCATION = ['11', ':', '8'] # macro
NVOS02_FLAGS_LOCATION_PCI = (0x00000000) # macro
NVOS02_FLAGS_LOCATION_AGP = (0x00000001) # macro
NVOS02_FLAGS_LOCATION_VIDMEM = (0x00000002) # macro
NVOS02_FLAGS_COHERENCY = ['15', ':', '12'] # macro
NVOS02_FLAGS_COHERENCY_UNCACHED = (0x00000000) # macro
NVOS02_FLAGS_COHERENCY_CACHED = (0x00000001) # macro
NVOS02_FLAGS_COHERENCY_WRITE_COMBINE = (0x00000002) # macro
NVOS02_FLAGS_COHERENCY_WRITE_THROUGH = (0x00000003) # macro
NVOS02_FLAGS_COHERENCY_WRITE_PROTECT = (0x00000004) # macro
NVOS02_FLAGS_COHERENCY_WRITE_BACK = (0x00000005) # macro
NVOS02_FLAGS_ALLOC = ['17', ':', '16'] # macro
NVOS02_FLAGS_ALLOC_NONE = (0x00000001) # macro
NVOS02_FLAGS_GPU_CACHEABLE = ['18', ':', '18'] # macro
NVOS02_FLAGS_GPU_CACHEABLE_NO = (0x00000000) # macro
NVOS02_FLAGS_GPU_CACHEABLE_YES = (0x00000001) # macro
NVOS02_FLAGS_KERNEL_MAPPING = ['19', ':', '19'] # macro
NVOS02_FLAGS_KERNEL_MAPPING_NO_MAP = (0x00000000) # macro
NVOS02_FLAGS_KERNEL_MAPPING_MAP = (0x00000001) # macro
NVOS02_FLAGS_ALLOC_NISO_DISPLAY = ['20', ':', '20'] # macro
NVOS02_FLAGS_ALLOC_NISO_DISPLAY_NO = (0x00000000) # macro
NVOS02_FLAGS_ALLOC_NISO_DISPLAY_YES = (0x00000001) # macro
NVOS02_FLAGS_ALLOC_USER_READ_ONLY = ['21', ':', '21'] # macro
NVOS02_FLAGS_ALLOC_USER_READ_ONLY_NO = (0x00000000) # macro
NVOS02_FLAGS_ALLOC_USER_READ_ONLY_YES = (0x00000001) # macro
NVOS02_FLAGS_ALLOC_DEVICE_READ_ONLY = ['22', ':', '22'] # macro
NVOS02_FLAGS_ALLOC_DEVICE_READ_ONLY_NO = (0x00000000) # macro
NVOS02_FLAGS_ALLOC_DEVICE_READ_ONLY_YES = (0x00000001) # macro
NVOS02_FLAGS_PEER_MAP_OVERRIDE = ['23', ':', '23'] # macro
NVOS02_FLAGS_PEER_MAP_OVERRIDE_DEFAULT = (0x00000000) # macro
NVOS02_FLAGS_PEER_MAP_OVERRIDE_REQUIRED = (0x00000001) # macro
NVOS02_FLAGS_ALLOC_TYPE_SYNCPOINT = ['24', ':', '24'] # macro
NVOS02_FLAGS_ALLOC_TYPE_SYNCPOINT_APERTURE = (0x00000001) # macro
NVOS02_FLAGS_MEMORY_PROTECTION = ['26', ':', '25'] # macro
NVOS02_FLAGS_MEMORY_PROTECTION_DEFAULT = (0x00000000) # macro
NVOS02_FLAGS_MEMORY_PROTECTION_PROTECTED = (0x00000001) # macro
NVOS02_FLAGS_MEMORY_PROTECTION_UNPROTECTED = (0x00000002) # macro
NVOS02_FLAGS_MAPPING = ['31', ':', '30'] # macro
NVOS02_FLAGS_MAPPING_DEFAULT = (0x00000000) # macro
NVOS02_FLAGS_MAPPING_NO_MAP = (0x00000001) # macro
NVOS02_FLAGS_MAPPING_NEVER_MAP = (0x00000002) # macro
NVOS03_FLAGS_ACCESS = ['1', ':', '0'] # macro
NVOS03_FLAGS_ACCESS_READ_WRITE = (0x00000000) # macro
NVOS03_FLAGS_ACCESS_READ_ONLY = (0x00000001) # macro
NVOS03_FLAGS_ACCESS_WRITE_ONLY = (0x00000002) # macro
NVOS03_FLAGS_PREALLOCATE = ['2', ':', '2'] # macro
NVOS03_FLAGS_PREALLOCATE_DISABLE = (0x00000000) # macro
NVOS03_FLAGS_PREALLOCATE_ENABLE = (0x00000001) # macro
NVOS03_FLAGS_GPU_MAPPABLE = ['15', ':', '15'] # macro
NVOS03_FLAGS_GPU_MAPPABLE_DISABLE = (0x00000000) # macro
NVOS03_FLAGS_GPU_MAPPABLE_ENABLE = (0x00000001) # macro
NVOS03_FLAGS_PTE_KIND_BL_OVERRIDE = ['16', ':', '16'] # macro
NVOS03_FLAGS_PTE_KIND_BL_OVERRIDE_FALSE = (0x00000000) # macro
NVOS03_FLAGS_PTE_KIND_BL_OVERRIDE_TRUE = (0x00000001) # macro
NVOS03_FLAGS_PTE_KIND = ['17', ':', '16'] # macro
NVOS03_FLAGS_PTE_KIND_NONE = (0x00000000) # macro
NVOS03_FLAGS_PTE_KIND_BL = (0x00000001) # macro
NVOS03_FLAGS_PTE_KIND_PITCH = (0x00000002) # macro
NVOS03_FLAGS_TYPE = ['23', ':', '20'] # macro
NVOS03_FLAGS_TYPE_NOTIFIER = (0x00000001) # macro
NVOS03_FLAGS_MAPPING = ['20', ':', '20'] # macro
NVOS03_FLAGS_MAPPING_NONE = (0x00000000) # macro
NVOS03_FLAGS_MAPPING_KERNEL = (0x00000001) # macro
NVOS03_FLAGS_CACHE_SNOOP = ['28', ':', '28'] # macro
NVOS03_FLAGS_CACHE_SNOOP_ENABLE = (0x00000000) # macro
NVOS03_FLAGS_CACHE_SNOOP_DISABLE = (0x00000001) # macro
NVOS03_FLAGS_HASH_TABLE = ['29', ':', '29'] # macro
NVOS03_FLAGS_HASH_TABLE_ENABLE = (0x00000000) # macro
NVOS03_FLAGS_HASH_TABLE_DISABLE = (0x00000001) # macro
NV01_ALLOC_OBJECT = (0x00000005) # macro
NV01_EVENT_BROADCAST = (0x80000000) # macro
NV01_EVENT_PERMIT_NON_ROOT_EVENT_KERNEL_CALLBACK_CREATION = (0x40000000) # macro
NV01_EVENT_SUBDEVICE_SPECIFIC = (0x20000000) # macro
NV01_EVENT_WITHOUT_EVENT_DATA = (0x10000000) # macro
NV01_EVENT_NONSTALL_INTR = (0x08000000) # macro
NV01_EVENT_CLIENT_RM = (0x04000000) # macro
NV04_I2C_ACCESS = (0x00000013) # macro
NVOS_I2C_ACCESS_MAX_BUFFER_SIZE = 2048 # macro
NVOS20_COMMAND_unused0001 = 0x0001 # macro
NVOS20_COMMAND_unused0002 = 0x0002 # macro
NVOS20_COMMAND_STRING_PRINT = 0x0003 # macro
NV04_ALLOC = (0x00000015) # macro
NVOS64_FLAGS_NONE = (0x00000000) # macro
NVOS64_FLAGS_FINN_SERIALIZED = (0x00000001) # macro
NVOS65_PARAMETERS_VERSION_MAGIC = 0x77FEF81E # macro
NV04_IDLE_CHANNELS = (0x0000001E) # macro
NVOS30_FLAGS_BEHAVIOR = ['3', ':', '0'] # macro
NVOS30_FLAGS_BEHAVIOR_SPIN = (0x00000000) # macro
NVOS30_FLAGS_BEHAVIOR_SLEEP = (0x00000001) # macro
NVOS30_FLAGS_BEHAVIOR_QUERY = (0x00000002) # macro
NVOS30_FLAGS_BEHAVIOR_FORCE_BUSY_CHECK = (0x00000003) # macro
NVOS30_FLAGS_CHANNEL = ['7', ':', '4'] # macro
NVOS30_FLAGS_CHANNEL_LIST = (0x00000000) # macro
NVOS30_FLAGS_CHANNEL_SINGLE = (0x00000001) # macro
NVOS30_FLAGS_IDLE = ['30', ':', '8'] # macro
NVOS30_FLAGS_IDLE_PUSH_BUFFER = (0x00000001) # macro
NVOS30_FLAGS_IDLE_CACHE1 = (0x00000002) # macro
NVOS30_FLAGS_IDLE_GRAPHICS = (0x00000004) # macro
NVOS30_FLAGS_IDLE_MPEG = (0x00000008) # macro
NVOS30_FLAGS_IDLE_MOTION_ESTIMATION = (0x00000010) # macro
NVOS30_FLAGS_IDLE_VIDEO_PROCESSOR = (0x00000020) # macro
NVOS30_FLAGS_IDLE_MSPDEC = (0x00000020) # macro
NVOS30_FLAGS_IDLE_BITSTREAM_PROCESSOR = (0x00000040) # macro
NVOS30_FLAGS_IDLE_MSVLD = (0x00000040) # macro
NVOS30_FLAGS_IDLE_NVDEC0 = (0x00000040) # macro
NVOS30_FLAGS_IDLE_CIPHER_DMA = (0x00000080) # macro
NVOS30_FLAGS_IDLE_SEC = (0x00000080) # macro
NVOS30_FLAGS_IDLE_CALLBACKS = (0x00000100) # macro
NVOS30_FLAGS_IDLE_MSPPP = (0x00000200) # macro
NVOS30_FLAGS_IDLE_CE0 = (0x00000400) # macro
NVOS30_FLAGS_IDLE_CE1 = (0x00000800) # macro
NVOS30_FLAGS_IDLE_CE2 = (0x00001000) # macro
NVOS30_FLAGS_IDLE_CE3 = (0x00002000) # macro
NVOS30_FLAGS_IDLE_CE4 = (0x00004000) # macro
NVOS30_FLAGS_IDLE_CE5 = (0x00008000) # macro
NVOS30_FLAGS_IDLE_VIC = (0x00010000) # macro
NVOS30_FLAGS_IDLE_MSENC = (0x00020000) # macro
NVOS30_FLAGS_IDLE_NVENC0 = (0x00020000) # macro
NVOS30_FLAGS_IDLE_NVENC1 = (0x00040000) # macro
NVOS30_FLAGS_IDLE_NVENC2 = (0x00080000) # macro
NVOS30_FLAGS_IDLE_NVJPG = (0x00100000) # macro
NVOS30_FLAGS_IDLE_NVDEC1 = (0x00200000) # macro
NVOS30_FLAGS_IDLE_NVDEC2 = (0x00400000) # macro
NVOS30_FLAGS_IDLE_ACTIVECHANNELS = (0x00800000) # macro
NVOS30_FLAGS_IDLE_ALL_ENGINES = ((0x00000004)|(0x00000008)|(0x00000010)|(0x00000020)|(0x00000040)|(0x00000080)|(0x00000020)|(0x00000040)|(0x00000080)|(0x00000200)|(0x00000400)|(0x00000800)|(0x00001000)|(0x00002000)|(0x00004000)|(0x00008000)|(0x00020000)|(0x00040000)|(0x00080000)|(0x00010000)|(0x00100000)|(0x00200000)|(0x00400000)) # macro
NVOS30_FLAGS_WAIT_FOR_ELPG_ON = ['31', ':', '31'] # macro
NVOS30_FLAGS_WAIT_FOR_ELPG_ON_NO = (0x00000000) # macro
NVOS30_FLAGS_WAIT_FOR_ELPG_ON_YES = (0x00000001) # macro
NV04_VID_HEAP_CONTROL = (0x00000020) # macro
NVOS32_DESCRIPTOR_TYPE_VIRTUAL_ADDRESS = 0 # macro
NVOS32_DESCRIPTOR_TYPE_OS_PAGE_ARRAY = 1 # macro
NVOS32_DESCRIPTOR_TYPE_OS_IO_MEMORY = 2 # macro
NVOS32_DESCRIPTOR_TYPE_OS_PHYS_ADDR = 3 # macro
NVOS32_DESCRIPTOR_TYPE_OS_FILE_HANDLE = 4 # macro
NVOS32_DESCRIPTOR_TYPE_OS_DMA_BUF_PTR = 5 # macro
NVOS32_DESCRIPTOR_TYPE_OS_SGT_PTR = 6 # macro
NVOS32_DESCRIPTOR_TYPE_KERNEL_VIRTUAL_ADDRESS = 7 # macro
NVOS32_FUNCTION_ALLOC_SIZE = 2 # macro
NVOS32_FUNCTION_FREE = 3 # macro
NVOS32_FUNCTION_INFO = 5 # macro
NVOS32_FUNCTION_ALLOC_TILED_PITCH_HEIGHT = 6 # macro
NVOS32_FUNCTION_DUMP = 11 # macro
NVOS32_FUNCTION_ALLOC_SIZE_RANGE = 14 # macro
NVOS32_FUNCTION_REACQUIRE_COMPR = 15 # macro
NVOS32_FUNCTION_RELEASE_COMPR = 16 # macro
NVOS32_FUNCTION_GET_MEM_ALIGNMENT = 18 # macro
NVOS32_FUNCTION_HW_ALLOC = 19 # macro
NVOS32_FUNCTION_HW_FREE = 20 # macro
NVOS32_FUNCTION_ALLOC_OS_DESCRIPTOR = 27 # macro
NVOS32_FLAGS_BLOCKINFO_VISIBILITY_CPU = (0x00000001) # macro
NVOS32_IVC_HEAP_NUMBER_DONT_ALLOCATE_ON_IVC_HEAP = 0 # macro
NVAL_MAX_BANKS = (4) # macro
NVAL_MAP_DIRECTION = ['0', ':', '0'] # macro
NVAL_MAP_DIRECTION_DOWN = 0x00000000 # macro
NVAL_MAP_DIRECTION_UP = 0x00000001 # macro
NV_RM_OS32_ALLOC_OS_DESCRIPTOR_WITH_OS32_ATTR = 1 # macro
NVOS32_DELETE_RESOURCES_ALL = 0 # macro
NVOS32_TYPE_IMAGE = 0 # macro
NVOS32_TYPE_DEPTH = 1 # macro
NVOS32_TYPE_TEXTURE = 2 # macro
NVOS32_TYPE_VIDEO = 3 # macro
NVOS32_TYPE_FONT = 4 # macro
NVOS32_TYPE_CURSOR = 5 # macro
NVOS32_TYPE_DMA = 6 # macro
NVOS32_TYPE_INSTANCE = 7 # macro
NVOS32_TYPE_PRIMARY = 8 # macro
NVOS32_TYPE_ZCULL = 9 # macro
NVOS32_TYPE_UNUSED = 10 # macro
NVOS32_TYPE_SHADER_PROGRAM = 11 # macro
NVOS32_TYPE_OWNER_RM = 12 # macro
NVOS32_TYPE_NOTIFIER = 13 # macro
NVOS32_TYPE_RESERVED = 14 # macro
NVOS32_TYPE_PMA = 15 # macro
NVOS32_TYPE_STENCIL = 16 # macro
NVOS32_NUM_MEM_TYPES = 17 # macro
NVOS32_ATTR_NONE = 0x00000000 # macro
NVOS32_ATTR_DEPTH = ['2', ':', '0'] # macro
NVOS32_ATTR_DEPTH_UNKNOWN = 0x00000000 # macro
NVOS32_ATTR_DEPTH_8 = 0x00000001 # macro
NVOS32_ATTR_DEPTH_16 = 0x00000002 # macro
NVOS32_ATTR_DEPTH_24 = 0x00000003 # macro
NVOS32_ATTR_DEPTH_32 = 0x00000004 # macro
NVOS32_ATTR_DEPTH_64 = 0x00000005 # macro
NVOS32_ATTR_DEPTH_128 = 0x00000006 # macro
NVOS32_ATTR_COMPR_COVG = ['3', ':', '3'] # macro
NVOS32_ATTR_COMPR_COVG_DEFAULT = 0x00000000 # macro
NVOS32_ATTR_COMPR_COVG_PROVIDED = 0x00000001 # macro
NVOS32_ATTR_AA_SAMPLES = ['7', ':', '4'] # macro
NVOS32_ATTR_AA_SAMPLES_1 = 0x00000000 # macro
NVOS32_ATTR_AA_SAMPLES_2 = 0x00000001 # macro
NVOS32_ATTR_AA_SAMPLES_4 = 0x00000002 # macro
NVOS32_ATTR_AA_SAMPLES_4_ROTATED = 0x00000003 # macro
NVOS32_ATTR_AA_SAMPLES_6 = 0x00000004 # macro
NVOS32_ATTR_AA_SAMPLES_8 = 0x00000005 # macro
NVOS32_ATTR_AA_SAMPLES_16 = 0x00000006 # macro
NVOS32_ATTR_AA_SAMPLES_4_VIRTUAL_8 = 0x00000007 # macro
NVOS32_ATTR_AA_SAMPLES_4_VIRTUAL_16 = 0x00000008 # macro
NVOS32_ATTR_AA_SAMPLES_8_VIRTUAL_16 = 0x00000009 # macro
NVOS32_ATTR_AA_SAMPLES_8_VIRTUAL_32 = 0x0000000A # macro
NVOS32_ATTR_ZCULL = ['11', ':', '10'] # macro
NVOS32_ATTR_ZCULL_NONE = 0x00000000 # macro
NVOS32_ATTR_ZCULL_REQUIRED = 0x00000001 # macro
NVOS32_ATTR_ZCULL_ANY = 0x00000002 # macro
NVOS32_ATTR_ZCULL_SHARED = 0x00000003 # macro
NVOS32_ATTR_COMPR = ['13', ':', '12'] # macro
NVOS32_ATTR_COMPR_NONE = 0x00000000 # macro
NVOS32_ATTR_COMPR_REQUIRED = 0x00000001 # macro
NVOS32_ATTR_COMPR_ANY = 0x00000002 # macro
NVOS32_ATTR_COMPR_PLC_REQUIRED = 0x00000001 # macro
NVOS32_ATTR_COMPR_PLC_ANY = 0x00000002 # macro
NVOS32_ATTR_COMPR_DISABLE_PLC_ANY = 0x00000003 # macro
NVOS32_ATTR_ALLOCATE_FROM_RESERVED_HEAP = ['14', ':', '14'] # macro
NVOS32_ATTR_ALLOCATE_FROM_RESERVED_HEAP_NO = 0x00000000 # macro
NVOS32_ATTR_ALLOCATE_FROM_RESERVED_HEAP_YES = 0x00000001 # macro
NVOS32_ATTR_FORMAT = ['17', ':', '16'] # macro
NVOS32_ATTR_FORMAT_LOW_FIELD = 16 # macro
NVOS32_ATTR_FORMAT_HIGH_FIELD = 17 # macro
NVOS32_ATTR_FORMAT_PITCH = 0x00000000 # macro
NVOS32_ATTR_FORMAT_SWIZZLED = 0x00000001 # macro
NVOS32_ATTR_FORMAT_BLOCK_LINEAR = 0x00000002 # macro
NVOS32_ATTR_Z_TYPE = ['18', ':', '18'] # macro
NVOS32_ATTR_Z_TYPE_FIXED = 0x00000000 # macro
NVOS32_ATTR_Z_TYPE_FLOAT = 0x00000001 # macro
NVOS32_ATTR_ZS_PACKING = ['21', ':', '19'] # macro
NVOS32_ATTR_ZS_PACKING_S8 = 0x00000000 # macro
NVOS32_ATTR_ZS_PACKING_Z24S8 = 0x00000000 # macro
NVOS32_ATTR_ZS_PACKING_S8Z24 = 0x00000001 # macro
NVOS32_ATTR_ZS_PACKING_Z32 = 0x00000002 # macro
NVOS32_ATTR_ZS_PACKING_Z24X8 = 0x00000003 # macro
NVOS32_ATTR_ZS_PACKING_X8Z24 = 0x00000004 # macro
NVOS32_ATTR_ZS_PACKING_Z32_X24S8 = 0x00000005 # macro
NVOS32_ATTR_ZS_PACKING_X8Z24_X24S8 = 0x00000006 # macro
NVOS32_ATTR_ZS_PACKING_Z16 = 0x00000007 # macro
NVOS32_ATTR_COLOR_PACKING = ['21', ':', '19'] # macro
NVOS32_ATTR_COLOR_PACKING_A8R8G8B8 = 0x00000000 # macro
NVOS32_ATTR_COLOR_PACKING_X8R8G8B8 = 0x00000001 # macro
NVOS32_ATTR_PAGE_SIZE = ['24', ':', '23'] # macro
NVOS32_ATTR_PAGE_SIZE_DEFAULT = 0x00000000 # macro
NVOS32_ATTR_PAGE_SIZE_4KB = 0x00000001 # macro
NVOS32_ATTR_PAGE_SIZE_BIG = 0x00000002 # macro
NVOS32_ATTR_PAGE_SIZE_HUGE = 0x00000003 # macro
NVOS32_ATTR_LOCATION = ['26', ':', '25'] # macro
NVOS32_ATTR_LOCATION_VIDMEM = 0x00000000 # macro
NVOS32_ATTR_LOCATION_PCI = 0x00000001 # macro
NVOS32_ATTR_LOCATION_AGP = 0x00000002 # macro
NVOS32_ATTR_LOCATION_ANY = 0x00000003 # macro
NVOS32_ATTR_PHYSICALITY = ['28', ':', '27'] # macro
NVOS32_ATTR_PHYSICALITY_DEFAULT = 0x00000000 # macro
NVOS32_ATTR_PHYSICALITY_NONCONTIGUOUS = 0x00000001 # macro
NVOS32_ATTR_PHYSICALITY_CONTIGUOUS = 0x00000002 # macro
NVOS32_ATTR_PHYSICALITY_ALLOW_NONCONTIGUOUS = 0x00000003 # macro
NVOS32_ATTR_COHERENCY = ['31', ':', '29'] # macro
NVOS32_ATTR_COHERENCY_UNCACHED = 0x00000000 # macro
NVOS32_ATTR_COHERENCY_CACHED = 0x00000001 # macro
NVOS32_ATTR_COHERENCY_WRITE_COMBINE = 0x00000002 # macro
NVOS32_ATTR_COHERENCY_WRITE_THROUGH = 0x00000003 # macro
NVOS32_ATTR_COHERENCY_WRITE_PROTECT = 0x00000004 # macro
NVOS32_ATTR_COHERENCY_WRITE_BACK = 0x00000005 # macro
NVOS32_ATTR2_NONE = 0x00000000 # macro
NVOS32_ATTR2_ZBC = ['1', ':', '0'] # macro
NVOS32_ATTR2_ZBC_DEFAULT = 0x00000000 # macro
NVOS32_ATTR2_ZBC_PREFER_NO_ZBC = 0x00000001 # macro
NVOS32_ATTR2_ZBC_PREFER_ZBC = 0x00000002 # macro
NVOS32_ATTR2_ZBC_REQUIRE_ONLY_ZBC = 0x00000003 # macro
NVOS32_ATTR2_ZBC_INVALID = 0x00000003 # macro
NVOS32_ATTR2_GPU_CACHEABLE = ['3', ':', '2'] # macro
NVOS32_ATTR2_GPU_CACHEABLE_DEFAULT = 0x00000000 # macro
NVOS32_ATTR2_GPU_CACHEABLE_YES = 0x00000001 # macro
NVOS32_ATTR2_GPU_CACHEABLE_NO = 0x00000002 # macro
NVOS32_ATTR2_GPU_CACHEABLE_INVALID = 0x00000003 # macro
NVOS32_ATTR2_P2P_GPU_CACHEABLE = ['5', ':', '4'] # macro
NVOS32_ATTR2_P2P_GPU_CACHEABLE_DEFAULT = 0x00000000 # macro
NVOS32_ATTR2_P2P_GPU_CACHEABLE_YES = 0x00000001 # macro
NVOS32_ATTR2_P2P_GPU_CACHEABLE_NO = 0x00000002 # macro
NVOS32_ATTR2_32BIT_POINTER = ['6', ':', '6'] # macro
NVOS32_ATTR2_32BIT_POINTER_DISABLE = 0x00000000 # macro
NVOS32_ATTR2_32BIT_POINTER_ENABLE = 0x00000001 # macro
NVOS32_ATTR2_FIXED_NUMA_NODE_ID = ['7', ':', '7'] # macro
NVOS32_ATTR2_FIXED_NUMA_NODE_ID_NO = 0x00000000 # macro
NVOS32_ATTR2_FIXED_NUMA_NODE_ID_YES = 0x00000001 # macro
NVOS32_ATTR2_SMMU_ON_GPU = ['10', ':', '8'] # macro
NVOS32_ATTR2_SMMU_ON_GPU_DEFAULT = 0x00000000 # macro
NVOS32_ATTR2_SMMU_ON_GPU_DISABLE = 0x00000001 # macro
NVOS32_ATTR2_SMMU_ON_GPU_ENABLE = 0x00000002 # macro
NVOS32_ATTR2_ALLOC_COMPCACHELINE_ALIGN = ['11', ':', '11'] # macro
NVOS32_ATTR2_ALLOC_COMPCACHELINE_ALIGN_OFF = 0x0 # macro
NVOS32_ATTR2_ALLOC_COMPCACHELINE_ALIGN_ON = 0x1 # macro
NVOS32_ATTR2_ALLOC_COMPCACHELINE_ALIGN_DEFAULT = 0x0 # macro
NVOS32_ATTR2_PRIORITY = ['13', ':', '12'] # macro
NVOS32_ATTR2_PRIORITY_DEFAULT = 0x0 # macro
NVOS32_ATTR2_PRIORITY_HIGH = 0x1 # macro
NVOS32_ATTR2_PRIORITY_LOW = 0x2 # macro
NVOS32_ATTR2_INTERNAL = ['14', ':', '14'] # macro
NVOS32_ATTR2_INTERNAL_NO = 0x0 # macro
NVOS32_ATTR2_INTERNAL_YES = 0x1 # macro
NVOS32_ATTR2_PREFER_2C = ['15', ':', '15'] # macro
NVOS32_ATTR2_PREFER_2C_NO = 0x00000000 # macro
NVOS32_ATTR2_PREFER_2C_YES = 0x00000001 # macro
NVOS32_ATTR2_NISO_DISPLAY = ['16', ':', '16'] # macro
NVOS32_ATTR2_NISO_DISPLAY_NO = 0x00000000 # macro
NVOS32_ATTR2_NISO_DISPLAY_YES = 0x00000001 # macro
NVOS32_ATTR2_ZBC_SKIP_ZBCREFCOUNT = ['17', ':', '17'] # macro
NVOS32_ATTR2_ZBC_SKIP_ZBCREFCOUNT_NO = 0x00000000 # macro
NVOS32_ATTR2_ZBC_SKIP_ZBCREFCOUNT_YES = 0x00000001 # macro
NVOS32_ATTR2_ISO = ['18', ':', '18'] # macro
NVOS32_ATTR2_ISO_NO = 0x00000000 # macro
NVOS32_ATTR2_ISO_YES = 0x00000001 # macro
NVOS32_ATTR2_BLACKLIST = ['19', ':', '19'] # macro
NVOS32_ATTR2_BLACKLIST_ON = 0x00000000 # macro
NVOS32_ATTR2_BLACKLIST_OFF = 0x00000001 # macro
NVOS32_ATTR2_PAGE_OFFLINING = ['19', ':', '19'] # macro
NVOS32_ATTR2_PAGE_OFFLINING_ON = 0x00000000 # macro
NVOS32_ATTR2_PAGE_OFFLINING_OFF = 0x00000001 # macro
NVOS32_ATTR2_PAGE_SIZE_HUGE = ['21', ':', '20'] # macro
NVOS32_ATTR2_PAGE_SIZE_HUGE_DEFAULT = 0x00000000 # macro
NVOS32_ATTR2_PAGE_SIZE_HUGE_2MB = 0x00000001 # macro
NVOS32_ATTR2_PAGE_SIZE_HUGE_512MB = 0x00000002 # macro
NVOS32_ATTR2_PROTECTION_USER = ['22', ':', '22'] # macro
NVOS32_ATTR2_PROTECTION_USER_READ_WRITE = 0x00000000 # macro
NVOS32_ATTR2_PROTECTION_USER_READ_ONLY = 0x00000001 # macro
NVOS32_ATTR2_PROTECTION_DEVICE = ['23', ':', '23'] # macro
NVOS32_ATTR2_PROTECTION_DEVICE_READ_WRITE = 0x00000000 # macro
NVOS32_ATTR2_PROTECTION_DEVICE_READ_ONLY = 0x00000001 # macro
NVOS32_ATTR2_USE_EGM = ['24', ':', '24'] # macro
NVOS32_ATTR2_USE_EGM_FALSE = 0x00000000 # macro
NVOS32_ATTR2_USE_EGM_TRUE = 0x00000001 # macro
NVOS32_ATTR2_MEMORY_PROTECTION = ['26', ':', '25'] # macro
NVOS32_ATTR2_MEMORY_PROTECTION_DEFAULT = 0x00000000 # macro
NVOS32_ATTR2_MEMORY_PROTECTION_PROTECTED = 0x00000001 # macro
NVOS32_ATTR2_MEMORY_PROTECTION_UNPROTECTED = 0x00000002 # macro
NVOS32_ATTR2_ALLOCATE_FROM_SUBHEAP = ['27', ':', '27'] # macro
NVOS32_ATTR2_ALLOCATE_FROM_SUBHEAP_NO = 0x00000000 # macro
NVOS32_ATTR2_ALLOCATE_FROM_SUBHEAP_YES = 0x00000001 # macro
NVOS32_ATTR2_REGISTER_MEMDESC_TO_PHYS_RM = ['31', ':', '31'] # macro
NVOS32_ATTR2_REGISTER_MEMDESC_TO_PHYS_RM_FALSE = 0x00000000 # macro
NVOS32_ATTR2_REGISTER_MEMDESC_TO_PHYS_RM_TRUE = 0x00000001 # macro
NVOS32_ALLOC_FLAGS_IGNORE_BANK_PLACEMENT = 0x00000001 # macro
NVOS32_ALLOC_FLAGS_FORCE_MEM_GROWS_UP = 0x00000002 # macro
NVOS32_ALLOC_FLAGS_FORCE_MEM_GROWS_DOWN = 0x00000004 # macro
NVOS32_ALLOC_FLAGS_FORCE_ALIGN_HOST_PAGE = 0x00000008 # macro
NVOS32_ALLOC_FLAGS_FIXED_ADDRESS_ALLOCATE = 0x00000010 # macro
NVOS32_ALLOC_FLAGS_BANK_HINT = 0x00000020 # macro
NVOS32_ALLOC_FLAGS_BANK_FORCE = 0x00000040 # macro
NVOS32_ALLOC_FLAGS_ALIGNMENT_HINT = 0x00000080 # macro
NVOS32_ALLOC_FLAGS_ALIGNMENT_FORCE = 0x00000100 # macro
NVOS32_ALLOC_FLAGS_BANK_GROW_UP = 0x00000000 # macro
NVOS32_ALLOC_FLAGS_BANK_GROW_DOWN = 0x00000200 # macro
NVOS32_ALLOC_FLAGS_LAZY = 0x00000400 # macro
NVOS32_ALLOC_FLAGS_FORCE_REVERSE_ALLOC = 0x00000800 # macro
NVOS32_ALLOC_FLAGS_NO_SCANOUT = 0x00001000 # macro
NVOS32_ALLOC_FLAGS_PITCH_FORCE = 0x00002000 # macro
NVOS32_ALLOC_FLAGS_MEMORY_HANDLE_PROVIDED = 0x00004000 # macro
NVOS32_ALLOC_FLAGS_MAP_NOT_REQUIRED = 0x00008000 # macro
NVOS32_ALLOC_FLAGS_PERSISTENT_VIDMEM = 0x00010000 # macro
NVOS32_ALLOC_FLAGS_USE_BEGIN_END = 0x00020000 # macro
NVOS32_ALLOC_FLAGS_TURBO_CIPHER_ENCRYPTED = 0x00040000 # macro
NVOS32_ALLOC_FLAGS_VIRTUAL = 0x00080000 # macro
NVOS32_ALLOC_FLAGS_FORCE_INTERNAL_INDEX = 0x00100000 # macro
NVOS32_ALLOC_FLAGS_ZCULL_COVG_SPECIFIED = 0x00200000 # macro
NVOS32_ALLOC_FLAGS_EXTERNALLY_MANAGED = 0x00400000 # macro
NVOS32_ALLOC_FLAGS_FORCE_DEDICATED_PDE = 0x00800000 # macro
NVOS32_ALLOC_FLAGS_PROTECTED = 0x01000000 # macro
NVOS32_ALLOC_FLAGS_KERNEL_MAPPING_MAP = 0x02000000 # macro
NVOS32_ALLOC_FLAGS_MAXIMIZE_ADDRESS_SPACE = 0x02000000 # macro
NVOS32_ALLOC_FLAGS_SPARSE = 0x04000000 # macro
NVOS32_ALLOC_FLAGS_USER_READ_ONLY = 0x04000000 # macro
NVOS32_ALLOC_FLAGS_DEVICE_READ_ONLY = 0x08000000 # macro
NVOS32_ALLOC_FLAGS_ALLOCATE_KERNEL_PRIVILEGED = 0x08000000 # macro
NVOS32_ALLOC_FLAGS_SKIP_RESOURCE_ALLOC = 0x10000000 # macro
NVOS32_ALLOC_FLAGS_PREFER_PTES_IN_SYSMEMORY = 0x20000000 # macro
NVOS32_ALLOC_FLAGS_SKIP_ALIGN_PAD = 0x40000000 # macro
NVOS32_ALLOC_FLAGS_WPR1 = 0x40000000 # macro
NVOS32_ALLOC_FLAGS_ZCULL_DONT_ALLOCATE_SHARED_1X = 0x80000000 # macro
NVOS32_ALLOC_FLAGS_WPR2 = 0x80000000 # macro
NVOS32_ALLOC_INTERNAL_FLAGS_CLIENTALLOC = 0x00000001 # macro
NVOS32_ALLOC_INTERNAL_FLAGS_SKIP_SCRUB = 0x00000004 # macro
NVOS32_ALLOC_FLAGS_MAXIMIZE_4GB_ADDRESS_SPACE = 0x02000000 # macro
NVOS32_ALLOC_FLAGS_VIRTUAL_ONLY = (0x00080000|0x00000400|0x00400000|0x04000000|0x02000000|0x20000000) # macro
NVOS32_ALLOC_COMPR_COVG_SCALE = 10 # macro
NVOS32_ALLOC_COMPR_COVG_BITS = ['1', ':', '0'] # macro
NVOS32_ALLOC_COMPR_COVG_BITS_DEFAULT = 0x00000000 # macro
NVOS32_ALLOC_COMPR_COVG_BITS_1 = 0x00000001 # macro
NVOS32_ALLOC_COMPR_COVG_BITS_2 = 0x00000002 # macro
NVOS32_ALLOC_COMPR_COVG_BITS_4 = 0x00000003 # macro
NVOS32_ALLOC_COMPR_COVG_MAX = ['11', ':', '2'] # macro
NVOS32_ALLOC_COMPR_COVG_MIN = ['21', ':', '12'] # macro
NVOS32_ALLOC_COMPR_COVG_START = ['31', ':', '22'] # macro
NVOS32_ALLOC_ZCULL_COVG_FORMAT = ['3', ':', '0'] # macro
NVOS32_ALLOC_ZCULL_COVG_FORMAT_LOW_RES_Z = 0x00000000 # macro
NVOS32_ALLOC_ZCULL_COVG_FORMAT_HIGH_RES_Z = 0x00000002 # macro
NVOS32_ALLOC_ZCULL_COVG_FORMAT_LOW_RES_ZS = 0x00000003 # macro
NVOS32_ALLOC_ZCULL_COVG_FALLBACK = ['4', ':', '4'] # macro
NVOS32_ALLOC_ZCULL_COVG_FALLBACK_DISALLOW = 0x00000000 # macro
NVOS32_ALLOC_ZCULL_COVG_FALLBACK_ALLOW = 0x00000001 # macro
NVOS32_ALLOC_COMPTAG_OFFSET_START = ['19', ':', '0'] # macro
NVOS32_ALLOC_COMPTAG_OFFSET_START_DEFAULT = 0x00000000 # macro
NVOS32_ALLOC_COMPTAG_OFFSET_USAGE = ['31', ':', '30'] # macro
NVOS32_ALLOC_COMPTAG_OFFSET_USAGE_DEFAULT = 0x00000000 # macro
NVOS32_ALLOC_COMPTAG_OFFSET_USAGE_OFF = 0x00000000 # macro
NVOS32_ALLOC_COMPTAG_OFFSET_USAGE_FIXED = 0x00000001 # macro
NVOS32_ALLOC_COMPTAG_OFFSET_USAGE_MIN = 0x00000002 # macro
NVOS32_REALLOC_FLAGS_GROW_ALLOCATION = 0x00000000 # macro
NVOS32_REALLOC_FLAGS_SHRINK_ALLOCATION = 0x00000001 # macro
NVOS32_REALLOC_FLAGS_REALLOC_UP = 0x00000000 # macro
NVOS32_REALLOC_FLAGS_REALLOC_DOWN = 0x00000002 # macro
NVOS32_RELEASE_COMPR_FLAGS_MEMORY_HANDLE_PROVIDED = 0x000000001 # macro
NVOS32_REACQUIRE_COMPR_FLAGS_MEMORY_HANDLE_PROVIDED = 0x000000001 # macro
NVOS32_FREE_FLAGS_MEMORY_HANDLE_PROVIDED = 0x00000001 # macro
NVOS32_DUMP_FLAGS_TYPE = ['1', ':', '0'] # macro
NVOS32_DUMP_FLAGS_TYPE_FB = 0x00000000 # macro
NVOS32_DUMP_FLAGS_TYPE_CLIENT_PD = 0x00000001 # macro
NVOS32_DUMP_FLAGS_TYPE_CLIENT_VA = 0x00000002 # macro
NVOS32_DUMP_FLAGS_TYPE_CLIENT_VAPTE = 0x00000003 # macro
NVOS32_BLOCK_TYPE_FREE = 0xFFFFFFFF # macro
NVOS32_INVALID_BLOCK_FREE_OFFSET = 0xFFFFFFFF # macro
NVOS32_MEM_TAG_NONE = 0x00000000 # macro
NV04_MAP_MEMORY = (0x00000021) # macro
NV04_MAP_MEMORY_FLAGS_NONE = (0x00000000) # macro
NV04_MAP_MEMORY_FLAGS_USER = (0x00004000) # macro
NVOS33_FLAGS_ACCESS = ['1', ':', '0'] # macro
NVOS33_FLAGS_ACCESS_READ_WRITE = (0x00000000) # macro
NVOS33_FLAGS_ACCESS_READ_ONLY = (0x00000001) # macro
NVOS33_FLAGS_ACCESS_WRITE_ONLY = (0x00000002) # macro
NVOS33_FLAGS_PERSISTENT = ['4', ':', '4'] # macro
NVOS33_FLAGS_PERSISTENT_DISABLE = (0x00000000) # macro
NVOS33_FLAGS_PERSISTENT_ENABLE = (0x00000001) # macro
NVOS33_FLAGS_SKIP_SIZE_CHECK = ['8', ':', '8'] # macro
NVOS33_FLAGS_SKIP_SIZE_CHECK_DISABLE = (0x00000000) # macro
NVOS33_FLAGS_SKIP_SIZE_CHECK_ENABLE = (0x00000001) # macro
NVOS33_FLAGS_MEM_SPACE = ['14', ':', '14'] # macro
NVOS33_FLAGS_MEM_SPACE_CLIENT = (0x00000000) # macro
NVOS33_FLAGS_MEM_SPACE_USER = (0x00000001) # macro
NVOS33_FLAGS_MAPPING = ['16', ':', '15'] # macro
NVOS33_FLAGS_MAPPING_DEFAULT = (0x00000000) # macro
NVOS33_FLAGS_MAPPING_DIRECT = (0x00000001) # macro
NVOS33_FLAGS_MAPPING_REFLECTED = (0x00000002) # macro
NVOS33_FLAGS_FIFO_MAPPING = ['17', ':', '17'] # macro
NVOS33_FLAGS_FIFO_MAPPING_DEFAULT = (0x00000000) # macro
NVOS33_FLAGS_FIFO_MAPPING_ENABLE = (0x00000001) # macro
NVOS33_FLAGS_MAP_FIXED = ['18', ':', '18'] # macro
NVOS33_FLAGS_MAP_FIXED_DISABLE = (0x00000000) # macro
NVOS33_FLAGS_MAP_FIXED_ENABLE = (0x00000001) # macro
NVOS33_FLAGS_RESERVE_ON_UNMAP = ['19', ':', '19'] # macro
NVOS33_FLAGS_RESERVE_ON_UNMAP_DISABLE = (0x00000000) # macro
NVOS33_FLAGS_RESERVE_ON_UNMAP_ENABLE = (0x00000001) # macro
NVOS33_FLAGS_OS_DESCRIPTOR = ['22', ':', '22'] # macro
NVOS33_FLAGS_OS_DESCRIPTOR_DISABLE = (0x00000000) # macro
NVOS33_FLAGS_OS_DESCRIPTOR_ENABLE = (0x00000001) # macro
NVOS33_FLAGS_CACHING_TYPE = ['25', ':', '23'] # macro
NVOS33_FLAGS_CACHING_TYPE_CACHED = 0 # macro
NVOS33_FLAGS_CACHING_TYPE_UNCACHED = 1 # macro
NVOS33_FLAGS_CACHING_TYPE_WRITECOMBINED = 2 # macro
NVOS33_FLAGS_CACHING_TYPE_WRITEBACK = 5 # macro
NVOS33_FLAGS_CACHING_TYPE_DEFAULT = 6 # macro
NVOS33_FLAGS_CACHING_TYPE_UNCACHED_WEAK = 7 # macro
NVOS33_FLAGS_ALLOW_MAPPING_ON_HCC = ['26', ':', '26'] # macro
NVOS33_FLAGS_ALLOW_MAPPING_ON_HCC_NO = (0x00000000) # macro
NVOS33_FLAGS_ALLOW_MAPPING_ON_HCC_YES = (0x00000001) # macro
NV04_UNMAP_MEMORY = (0x00000022) # macro
NV04_ACCESS_REGISTRY = (0x00000026) # macro
NVOS38_ACCESS_TYPE_READ_DWORD = 1 # macro
NVOS38_ACCESS_TYPE_WRITE_DWORD = 2 # macro
NVOS38_ACCESS_TYPE_READ_BINARY = 6 # macro
NVOS38_ACCESS_TYPE_WRITE_BINARY = 7 # macro
NVOS38_MAX_REGISTRY_STRING_LENGTH = 256 # macro
NVOS38_MAX_REGISTRY_BINARY_LENGTH = 256 # macro
NV04_ALLOC_CONTEXT_DMA = (0x00000027) # macro
NV04_GET_EVENT_DATA = (0x00000028) # macro
NVSIM01_BUS_XACT = (0x0000002C) # macro
NV04_MAP_MEMORY_DMA = (0x0000002E) # macro
NVOS46_FLAGS_ACCESS = ['1', ':', '0'] # macro
NVOS46_FLAGS_ACCESS_READ_WRITE = (0x00000000) # macro
NVOS46_FLAGS_ACCESS_READ_ONLY = (0x00000001) # macro
NVOS46_FLAGS_ACCESS_WRITE_ONLY = (0x00000002) # macro
NVOS46_FLAGS_32BIT_POINTER = ['2', ':', '2'] # macro
NVOS46_FLAGS_32BIT_POINTER_DISABLE = (0x00000000) # macro
NVOS46_FLAGS_32BIT_POINTER_ENABLE = (0x00000001) # macro
NVOS46_FLAGS_PAGE_KIND = ['3', ':', '3'] # macro
NVOS46_FLAGS_PAGE_KIND_PHYSICAL = (0x00000000) # macro
NVOS46_FLAGS_PAGE_KIND_VIRTUAL = (0x00000001) # macro
NVOS46_FLAGS_CACHE_SNOOP = ['4', ':', '4'] # macro
NVOS46_FLAGS_CACHE_SNOOP_DISABLE = (0x00000000) # macro
NVOS46_FLAGS_CACHE_SNOOP_ENABLE = (0x00000001) # macro
NVOS46_FLAGS_KERNEL_MAPPING = ['5', ':', '5'] # macro
NVOS46_FLAGS_KERNEL_MAPPING_NONE = (0x00000000) # macro
NVOS46_FLAGS_KERNEL_MAPPING_ENABLE = (0x00000001) # macro
NVOS46_FLAGS_SHADER_ACCESS = ['7', ':', '6'] # macro
NVOS46_FLAGS_SHADER_ACCESS_DEFAULT = (0x00000000) # macro
NVOS46_FLAGS_SHADER_ACCESS_READ_ONLY = (0x00000001) # macro
NVOS46_FLAGS_SHADER_ACCESS_WRITE_ONLY = (0x00000002) # macro
NVOS46_FLAGS_SHADER_ACCESS_READ_WRITE = (0x00000003) # macro
NVOS46_FLAGS_PAGE_SIZE = ['11', ':', '8'] # macro
NVOS46_FLAGS_PAGE_SIZE_DEFAULT = (0x00000000) # macro
NVOS46_FLAGS_PAGE_SIZE_4KB = (0x00000001) # macro
NVOS46_FLAGS_PAGE_SIZE_BIG = (0x00000002) # macro
NVOS46_FLAGS_PAGE_SIZE_BOTH = (0x00000003) # macro
NVOS46_FLAGS_PAGE_SIZE_HUGE = (0x00000004) # macro
NVOS46_FLAGS_SYSTEM_L3_ALLOC = ['13', ':', '13'] # macro
NVOS46_FLAGS_SYSTEM_L3_ALLOC_DEFAULT = (0x00000000) # macro
NVOS46_FLAGS_SYSTEM_L3_ALLOC_ENABLE_HINT = (0x00000001) # macro
NVOS46_FLAGS_DMA_OFFSET_GROWS = ['14', ':', '14'] # macro
NVOS46_FLAGS_DMA_OFFSET_GROWS_UP = (0x00000000) # macro
NVOS46_FLAGS_DMA_OFFSET_GROWS_DOWN = (0x00000001) # macro
NVOS46_FLAGS_DMA_OFFSET_FIXED = ['15', ':', '15'] # macro
NVOS46_FLAGS_DMA_OFFSET_FIXED_FALSE = (0x00000000) # macro
NVOS46_FLAGS_DMA_OFFSET_FIXED_TRUE = (0x00000001) # macro
NVOS46_FLAGS_PTE_COALESCE_LEVEL_CAP = ['19', ':', '16'] # macro
NVOS46_FLAGS_PTE_COALESCE_LEVEL_CAP_DEFAULT = (0x00000000) # macro
NVOS46_FLAGS_PTE_COALESCE_LEVEL_CAP_1 = (0x00000001) # macro
NVOS46_FLAGS_PTE_COALESCE_LEVEL_CAP_2 = (0x00000002) # macro
NVOS46_FLAGS_PTE_COALESCE_LEVEL_CAP_4 = (0x00000003) # macro
NVOS46_FLAGS_PTE_COALESCE_LEVEL_CAP_8 = (0x00000004) # macro
NVOS46_FLAGS_PTE_COALESCE_LEVEL_CAP_16 = (0x00000005) # macro
NVOS46_FLAGS_PTE_COALESCE_LEVEL_CAP_32 = (0x00000006) # macro
NVOS46_FLAGS_PTE_COALESCE_LEVEL_CAP_64 = (0x00000007) # macro
NVOS46_FLAGS_PTE_COALESCE_LEVEL_CAP_128 = (0x00000008) # macro
NVOS46_FLAGS_P2P = ['27', ':', '20'] # macro
NVOS46_FLAGS_P2P_ENABLE = ['21', ':', '20'] # macro
NVOS46_FLAGS_P2P_ENABLE_NO = (0x00000000) # macro
NVOS46_FLAGS_P2P_ENABLE_YES = (0x00000001) # macro
NVOS46_FLAGS_P2P_ENABLE_NONE = (0x00000000) # macro
NVOS46_FLAGS_P2P_ENABLE_SLI = (0x00000001) # macro
NVOS46_FLAGS_P2P_ENABLE_NOSLI = (0x00000002) # macro
NVOS46_FLAGS_P2P_SUBDEVICE_ID = ['24', ':', '22'] # macro
NVOS46_FLAGS_P2P_SUBDEV_ID_SRC = ['24', ':', '22'] # macro
NVOS46_FLAGS_P2P_SUBDEV_ID_TGT = ['27', ':', '25'] # macro
NVOS46_FLAGS_TLB_LOCK = ['28', ':', '28'] # macro
NVOS46_FLAGS_TLB_LOCK_DISABLE = (0x00000000) # macro
NVOS46_FLAGS_TLB_LOCK_ENABLE = (0x00000001) # macro
NVOS46_FLAGS_DMA_UNICAST_REUSE_ALLOC = ['29', ':', '29'] # macro
NVOS46_FLAGS_DMA_UNICAST_REUSE_ALLOC_FALSE = (0x00000000) # macro
NVOS46_FLAGS_DMA_UNICAST_REUSE_ALLOC_TRUE = (0x00000001) # macro
NVOS46_FLAGS_DEFER_TLB_INVALIDATION = ['31', ':', '31'] # macro
NVOS46_FLAGS_DEFER_TLB_INVALIDATION_FALSE = (0x00000000) # macro
NVOS46_FLAGS_DEFER_TLB_INVALIDATION_TRUE = (0x00000001) # macro
NV04_UNMAP_MEMORY_DMA = (0x0000002F) # macro
NVOS47_FLAGS_DEFER_TLB_INVALIDATION = ['0', ':', '0'] # macro
NVOS47_FLAGS_DEFER_TLB_INVALIDATION_FALSE = (0x00000000) # macro
NVOS47_FLAGS_DEFER_TLB_INVALIDATION_TRUE = (0x00000001) # macro
NV04_BIND_CONTEXT_DMA = (0x00000031) # macro
NV04_CONTROL = (0x00000036) # macro
NVOS54_FLAGS_NONE = (0x00000000) # macro
NVOS54_FLAGS_IRQL_RAISED = (0x00000001) # macro
NVOS54_FLAGS_LOCK_BYPASS = (0x00000002) # macro
NVOS54_FLAGS_FINN_SERIALIZED = (0x00000004) # macro
NV04_DUP_OBJECT = (0x00000037) # macro
NV04_DUP_HANDLE_FLAGS_NONE = (0x00000000) # macro
NV04_DUP_HANDLE_FLAGS_REJECT_KERNEL_DUP_PRIVILEGE = (0x00000001) # macro
NV04_UPDATE_DEVICE_MAPPING_INFO = (0x00000038) # macro
NV04_SHARE = (0x0000003E) # macro
NV_DEVICE_ALLOCATION_SZNAME_MAXLEN = 128 # macro
NV_DEVICE_ALLOCATION_FLAGS_NONE = (0x00000000) # macro
NV_DEVICE_ALLOCATION_FLAGS_MAP_PTE_GLOBALLY = (0x00000001) # macro
NV_DEVICE_ALLOCATION_FLAGS_MINIMIZE_PTETABLE_SIZE = (0x00000002) # macro
NV_DEVICE_ALLOCATION_FLAGS_RETRY_PTE_ALLOC_IN_SYS = (0x00000004) # macro
NV_DEVICE_ALLOCATION_FLAGS_VASPACE_SIZE = (0x00000008) # macro
NV_DEVICE_ALLOCATION_FLAGS_MAP_PTE = (0x00000010) # macro
NV_DEVICE_ALLOCATION_FLAGS_VASPACE_IS_TARGET = (0x00000020) # macro
NV_DEVICE_ALLOCATION_FLAGS_VASPACE_SHARED_MANAGEMENT = (0x00000100) # macro
NV_DEVICE_ALLOCATION_FLAGS_VASPACE_BIG_PAGE_SIZE_64k = (0x00000200) # macro
NV_DEVICE_ALLOCATION_FLAGS_VASPACE_BIG_PAGE_SIZE_128k = (0x00000400) # macro
NV_DEVICE_ALLOCATION_FLAGS_RESTRICT_RESERVED_VALIMITS = (0x00000800) # macro
NV_DEVICE_ALLOCATION_FLAGS_VASPACE_IS_MIRRORED = (0x00000040) # macro
NV_DEVICE_ALLOCATION_FLAGS_VASPACE_PTABLE_PMA_MANAGED = (0x00001000) # macro
NV_DEVICE_ALLOCATION_FLAGS_HOST_VGPU_DEVICE = (0x00002000) # macro
NV_DEVICE_ALLOCATION_FLAGS_PLUGIN_CONTEXT = (0x00004000) # macro
NV_DEVICE_ALLOCATION_FLAGS_VASPACE_REQUIRE_FIXED_OFFSET = (0x00008000) # macro
NV_DEVICE_ALLOCATION_VAMODE_OPTIONAL_MULTIPLE_VASPACES = (0x00000000) # macro
NV_DEVICE_ALLOCATION_VAMODE_SINGLE_VASPACE = (0x00000001) # macro
NV_DEVICE_ALLOCATION_VAMODE_MULTIPLE_VASPACES = (0x00000002) # macro
NV_CHANNELGPFIFO_NOTIFICATION_TYPE_ERROR = 0x00000000 # macro
NV_CHANNELGPFIFO_NOTIFICATION_TYPE_WORK_SUBMIT_TOKEN = 0x00000001 # macro
NV_CHANNELGPFIFO_NOTIFICATION_TYPE_KEY_ROTATION_STATUS = 0x00000002 # macro
NV_CHANNELGPFIFO_NOTIFICATION_TYPE__SIZE_1 = 3 # macro
NV_CHANNELGPFIFO_NOTIFICATION_STATUS_VALUE = ['14', ':', '0'] # macro
NV_CHANNELGPFIFO_NOTIFICATION_STATUS_IN_PROGRESS = ['15', ':', '15'] # macro
NV_CHANNELGPFIFO_NOTIFICATION_STATUS_IN_PROGRESS_TRUE = 0x1 # macro
NV_CHANNELGPFIFO_NOTIFICATION_STATUS_IN_PROGRESS_FALSE = 0x0 # macro
NV50VAIO_CHANNELDMA_ALLOCATION_FLAGS_CONNECT_PB_AT_GRAB = ['1', ':', '1'] # macro
NV50VAIO_CHANNELDMA_ALLOCATION_FLAGS_CONNECT_PB_AT_GRAB_YES = 0x00000000 # macro
NV50VAIO_CHANNELDMA_ALLOCATION_FLAGS_CONNECT_PB_AT_GRAB_NO = 0x00000001 # macro
NV_SWRUNLIST_QOS_INTR_NONE = 0x00000000 # macro
NV_SWRUNLIST_QOS_INTR_RUNLIST_AND_ENG_IDLE_ENABLE  = (1 << 0) # macro
NV_SWRUNLIST_QOS_INTR_RUNLIST_IDLE_ENABLE  = (1 << 1) # macro
NV_SWRUNLIST_QOS_INTR_RUNLIST_ACQUIRE_ENABLE  = (1 << 2) # macro
NV_SWRUNLIST_QOS_INTR_RUNLIST_ACQUIRE_AND_ENG_IDLE_ENABLE  = (1 << 3) # macro
NV_VP_ALLOCATION_FLAGS_STANDARD_UCODE = (0x00000000) # macro
NV_VP_ALLOCATION_FLAGS_STATIC_UCODE = (0x00000001) # macro
NV_VP_ALLOCATION_FLAGS_DYNAMIC_UCODE = (0x00000002) # macro
NV_VP_ALLOCATION_FLAGS_AVP_CLIENT_VIDEO = (0x00000000) # macro
NV_VP_ALLOCATION_FLAGS_AVP_CLIENT_AUDIO = (0x00000001) # macro
NV04_ADD_VBLANK_CALLBACK = (0x0000003D) # macro
NV_VASPACE_ALLOCATION_FLAGS_NONE = (0x00000000) # macro
NV_VASPACE_ALLOCATION_FLAGS_MINIMIZE_PTETABLE_SIZE  = (1 << 0) # macro
NV_VASPACE_ALLOCATION_FLAGS_RETRY_PTE_ALLOC_IN_SYS  = (1 << 1) # macro
NV_VASPACE_ALLOCATION_FLAGS_SHARED_MANAGEMENT  = (1 << 2) # macro
NV_VASPACE_ALLOCATION_FLAGS_IS_EXTERNALLY_OWNED  = (1 << 3) # macro
NV_VASPACE_ALLOCATION_FLAGS_ENABLE_NVLINK_ATS  = (1 << 4) # macro
NV_VASPACE_ALLOCATION_FLAGS_IS_MIRRORED  = (1 << 5) # macro
NV_VASPACE_ALLOCATION_FLAGS_ENABLE_PAGE_FAULTING  = (1 << 6) # macro
NV_VASPACE_ALLOCATION_FLAGS_VA_INTERNAL_LIMIT  = (1 << 7) # macro
NV_VASPACE_ALLOCATION_FLAGS_ALLOW_ZERO_ADDRESS  = (1 << 8) # macro
NV_VASPACE_ALLOCATION_FLAGS_IS_FLA  = (1 << 9) # macro
NV_VASPACE_ALLOCATION_FLAGS_SKIP_SCRUB_MEMPOOL  = (1 << 10) # macro
NV_VASPACE_ALLOCATION_FLAGS_OPTIMIZE_PTETABLE_MEMPOOL_USAGE  = (1 << 11) # macro
NV_VASPACE_ALLOCATION_FLAGS_REQUIRE_FIXED_OFFSET  = (1 << 12) # macro
NV_VASPACE_ALLOCATION_FLAGS_PTETABLE_HEAP_MANAGED  = (1 << 13) # macro
NV_VASPACE_ALLOCATION_INDEX_GPU_NEW = 0x00 # macro
NV_VASPACE_ALLOCATION_INDEX_GPU_HOST = 0x01 # macro
NV_VASPACE_ALLOCATION_INDEX_GPU_GLOBAL = 0x02 # macro
NV_VASPACE_ALLOCATION_INDEX_GPU_DEVICE = 0x03 # macro
NV_VASPACE_ALLOCATION_INDEX_GPU_FLA = 0x04 # macro
NV_VASPACE_ALLOCATION_INDEX_GPU_MAX = 0x05 # macro
NV_VASPACE_BIG_PAGE_SIZE_64K = (64*1024) # macro
NV_VASPACE_BIG_PAGE_SIZE_128K = (128*1024) # macro
NV_CTXSHARE_ALLOCATION_FLAGS_SUBCONTEXT = ['1', ':', '0'] # macro
NV_CTXSHARE_ALLOCATION_FLAGS_SUBCONTEXT_SYNC = (0x00000000) # macro
NV_CTXSHARE_ALLOCATION_FLAGS_SUBCONTEXT_ASYNC = (0x00000001) # macro
NV_CTXSHARE_ALLOCATION_FLAGS_SUBCONTEXT_SPECIFIED = (0x00000002) # macro
NV_TIMEOUT_CONTROL_CMD_SET_DEVICE_TIMEOUT = (0x00000002) # macro
NV_TIMEOUT_CONTROL_CMD_RESET_DEVICE_TIMEOUT = (0x00000003) # macro
class struct_NV_MEMORY_DESC_PARAMS(Structure):
    pass

struct_NV_MEMORY_DESC_PARAMS._pack_ = 1 # source:False
struct_NV_MEMORY_DESC_PARAMS._fields_ = [
    ('base', ctypes.c_uint64),
    ('size', ctypes.c_uint64),
    ('addressSpace', ctypes.c_uint32),
    ('cacheAttrib', ctypes.c_uint32),
]

NV_MEMORY_DESC_PARAMS = struct_NV_MEMORY_DESC_PARAMS
class struct_NV_CHANNEL_ALLOC_PARAMS(Structure):
    pass

struct_NV_CHANNEL_ALLOC_PARAMS._pack_ = 1 # source:False
struct_NV_CHANNEL_ALLOC_PARAMS._fields_ = [
    ('hObjectError', ctypes.c_uint32),
    ('hObjectBuffer', ctypes.c_uint32),
    ('gpFifoOffset', ctypes.c_uint64),
    ('gpFifoEntries', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('hContextShare', ctypes.c_uint32),
    ('hVASpace', ctypes.c_uint32),
    ('hUserdMemory', ctypes.c_uint32 * 8),
    ('userdOffset', ctypes.c_uint64 * 8),
    ('engineType', ctypes.c_uint32),
    ('cid', ctypes.c_uint32),
    ('subDeviceId', ctypes.c_uint32),
    ('hObjectEccError', ctypes.c_uint32),
    ('instanceMem', NV_MEMORY_DESC_PARAMS),
    ('userdMem', NV_MEMORY_DESC_PARAMS),
    ('ramfcMem', NV_MEMORY_DESC_PARAMS),
    ('mthdbufMem', NV_MEMORY_DESC_PARAMS),
    ('hPhysChannelGroup', ctypes.c_uint32),
    ('internalFlags', ctypes.c_uint32),
    ('errorNotifierMem', NV_MEMORY_DESC_PARAMS),
    ('eccErrorNotifierMem', NV_MEMORY_DESC_PARAMS),
    ('ProcessID', ctypes.c_uint32),
    ('SubProcessID', ctypes.c_uint32),
    ('encryptIv', ctypes.c_uint32 * 3),
    ('decryptIv', ctypes.c_uint32 * 3),
    ('hmacNonce', ctypes.c_uint32 * 8),
]

NV_CHANNEL_ALLOC_PARAMS = struct_NV_CHANNEL_ALLOC_PARAMS
NV_CHANNELGPFIFO_ALLOCATION_PARAMETERS = struct_NV_CHANNEL_ALLOC_PARAMS
class struct_c__SA_NVOS00_PARAMETERS(Structure):
    pass

struct_c__SA_NVOS00_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS00_PARAMETERS._fields_ = [
    ('hRoot', ctypes.c_uint32),
    ('hObjectParent', ctypes.c_uint32),
    ('hObjectOld', ctypes.c_uint32),
    ('status', ctypes.c_uint32),
]

NVOS00_PARAMETERS = struct_c__SA_NVOS00_PARAMETERS
class struct_c__SA_NVOS02_PARAMETERS(Structure):
    pass

struct_c__SA_NVOS02_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS02_PARAMETERS._fields_ = [
    ('hRoot', ctypes.c_uint32),
    ('hObjectParent', ctypes.c_uint32),
    ('hObjectNew', ctypes.c_uint32),
    ('hClass', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('pMemory', ctypes.POINTER(None)),
    ('limit', ctypes.c_uint64),
    ('status', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

NVOS02_PARAMETERS = struct_c__SA_NVOS02_PARAMETERS
class struct_c__SA_NVOS05_PARAMETERS(Structure):
    pass

struct_c__SA_NVOS05_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS05_PARAMETERS._fields_ = [
    ('hRoot', ctypes.c_uint32),
    ('hObjectParent', ctypes.c_uint32),
    ('hObjectNew', ctypes.c_uint32),
    ('hClass', ctypes.c_uint32),
    ('status', ctypes.c_uint32),
]

NVOS05_PARAMETERS = struct_c__SA_NVOS05_PARAMETERS
Callback1ArgVoidReturn = ctypes.CFUNCTYPE(None, ctypes.POINTER(None))
Callback5ArgVoidReturn = ctypes.CFUNCTYPE(None, ctypes.POINTER(None), ctypes.POINTER(None), ctypes.c_uint32, ctypes.c_uint32, ctypes.c_uint32)
class struct_c__SA_NVOS10_EVENT_KERNEL_CALLBACK(Structure):
    pass

struct_c__SA_NVOS10_EVENT_KERNEL_CALLBACK._pack_ = 1 # source:False
struct_c__SA_NVOS10_EVENT_KERNEL_CALLBACK._fields_ = [
    ('func', ctypes.CFUNCTYPE(None, ctypes.POINTER(None))),
    ('arg', ctypes.POINTER(None)),
]

NVOS10_EVENT_KERNEL_CALLBACK = struct_c__SA_NVOS10_EVENT_KERNEL_CALLBACK
class struct_c__SA_NVOS10_EVENT_KERNEL_CALLBACK_EX(Structure):
    pass

struct_c__SA_NVOS10_EVENT_KERNEL_CALLBACK_EX._pack_ = 1 # source:False
struct_c__SA_NVOS10_EVENT_KERNEL_CALLBACK_EX._fields_ = [
    ('func', ctypes.CFUNCTYPE(None, ctypes.POINTER(None), ctypes.POINTER(None), ctypes.c_uint32, ctypes.c_uint32, ctypes.c_uint32)),
    ('arg', ctypes.POINTER(None)),
]

NVOS10_EVENT_KERNEL_CALLBACK_EX = struct_c__SA_NVOS10_EVENT_KERNEL_CALLBACK_EX
class struct_c__SA_NVOS_I2C_ACCESS_PARAMS(Structure):
    pass

struct_c__SA_NVOS_I2C_ACCESS_PARAMS._pack_ = 1 # source:False
struct_c__SA_NVOS_I2C_ACCESS_PARAMS._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hDevice', ctypes.c_uint32),
    ('paramSize', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('paramStructPtr', ctypes.POINTER(None)),
    ('status', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

NVOS_I2C_ACCESS_PARAMS = struct_c__SA_NVOS_I2C_ACCESS_PARAMS
class struct_c__SA_NVOS21_PARAMETERS(Structure):
    pass

struct_c__SA_NVOS21_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS21_PARAMETERS._fields_ = [
    ('hRoot', ctypes.c_uint32),
    ('hObjectParent', ctypes.c_uint32),
    ('hObjectNew', ctypes.c_uint32),
    ('hClass', ctypes.c_uint32),
    ('pAllocParms', ctypes.POINTER(None)),
    ('paramsSize', ctypes.c_uint32),
    ('status', ctypes.c_uint32),
]

NVOS21_PARAMETERS = struct_c__SA_NVOS21_PARAMETERS
class struct_c__SA_NVOS64_PARAMETERS(Structure):
    pass

struct_c__SA_NVOS64_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS64_PARAMETERS._fields_ = [
    ('hRoot', ctypes.c_uint32),
    ('hObjectParent', ctypes.c_uint32),
    ('hObjectNew', ctypes.c_uint32),
    ('hClass', ctypes.c_uint32),
    ('pAllocParms', ctypes.POINTER(None)),
    ('pRightsRequested', ctypes.POINTER(None)),
    ('paramsSize', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('status', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NVOS64_PARAMETERS = struct_c__SA_NVOS64_PARAMETERS
class struct_c__SA_NVOS62_PARAMETERS(Structure):
    pass

struct_c__SA_NVOS62_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS62_PARAMETERS._fields_ = [
    ('hRoot', ctypes.c_uint32),
    ('hObjectParent', ctypes.c_uint32),
    ('hObjectNew', ctypes.c_uint32),
    ('hClass', ctypes.c_uint32),
    ('paramSize', ctypes.c_uint32),
    ('status', ctypes.c_uint32),
]

NVOS62_PARAMETERS = struct_c__SA_NVOS62_PARAMETERS
class struct_c__SA_NVOS65_PARAMETERS(Structure):
    pass

struct_c__SA_NVOS65_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS65_PARAMETERS._fields_ = [
    ('hRoot', ctypes.c_uint32),
    ('hObjectParent', ctypes.c_uint32),
    ('hObjectNew', ctypes.c_uint32),
    ('hClass', ctypes.c_uint32),
    ('paramSize', ctypes.c_uint32),
    ('versionMagic', ctypes.c_uint32),
    ('maskSize', ctypes.c_uint32),
    ('status', ctypes.c_uint32),
]

NVOS65_PARAMETERS = struct_c__SA_NVOS65_PARAMETERS
class struct_c__SA_NVOS30_PARAMETERS(Structure):
    pass

struct_c__SA_NVOS30_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS30_PARAMETERS._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hDevice', ctypes.c_uint32),
    ('hChannel', ctypes.c_uint32),
    ('numChannels', ctypes.c_uint32),
    ('phClients', ctypes.POINTER(None)),
    ('phDevices', ctypes.POINTER(None)),
    ('phChannels', ctypes.POINTER(None)),
    ('flags', ctypes.c_uint32),
    ('timeout', ctypes.c_uint32),
    ('status', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NVOS30_PARAMETERS = struct_c__SA_NVOS30_PARAMETERS
BindResultFunc = ctypes.CFUNCTYPE(None, ctypes.POINTER(None), ctypes.c_uint32, ctypes.c_uint32, ctypes.c_uint32)
class struct_c__SA_NVOS32_DESCRIPTOR_TYPE_OS_SGT_PTR_PARAMETERS(Structure):
    pass

struct_c__SA_NVOS32_DESCRIPTOR_TYPE_OS_SGT_PTR_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS32_DESCRIPTOR_TYPE_OS_SGT_PTR_PARAMETERS._fields_ = [
    ('sgt', ctypes.POINTER(None)),
    ('gem', ctypes.POINTER(None)),
]

NVOS32_DESCRIPTOR_TYPE_OS_SGT_PTR_PARAMETERS = struct_c__SA_NVOS32_DESCRIPTOR_TYPE_OS_SGT_PTR_PARAMETERS
class struct_c__SA_NVOS32_BLOCKINFO(Structure):
    pass

struct_c__SA_NVOS32_BLOCKINFO._pack_ = 1 # source:False
struct_c__SA_NVOS32_BLOCKINFO._fields_ = [
    ('startOffset', ctypes.c_uint64),
    ('size', ctypes.c_uint64),
    ('flags', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NVOS32_BLOCKINFO = struct_c__SA_NVOS32_BLOCKINFO
class struct_c__SA_NVOS32_PARAMETERS(Structure):
    pass

class union_c__SA_NVOS32_PARAMETERS_data(Union):
    pass

class struct_c__SA_NVOS32_PARAMETERS_0_AllocSize(Structure):
    pass

struct_c__SA_NVOS32_PARAMETERS_0_AllocSize._pack_ = 1 # source:False
struct_c__SA_NVOS32_PARAMETERS_0_AllocSize._fields_ = [
    ('owner', ctypes.c_uint32),
    ('hMemory', ctypes.c_uint32),
    ('type', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('attr', ctypes.c_uint32),
    ('format', ctypes.c_uint32),
    ('comprCovg', ctypes.c_uint32),
    ('zcullCovg', ctypes.c_uint32),
    ('partitionStride', ctypes.c_uint32),
    ('width', ctypes.c_uint32),
    ('height', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('size', ctypes.c_uint64),
    ('alignment', ctypes.c_uint64),
    ('offset', ctypes.c_uint64),
    ('limit', ctypes.c_uint64),
    ('address', ctypes.POINTER(None)),
    ('rangeBegin', ctypes.c_uint64),
    ('rangeEnd', ctypes.c_uint64),
    ('attr2', ctypes.c_uint32),
    ('ctagOffset', ctypes.c_uint32),
    ('numaNode', ctypes.c_int32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

class struct_c__SA_NVOS32_PARAMETERS_0_AllocTiledPitchHeight(Structure):
    pass

struct_c__SA_NVOS32_PARAMETERS_0_AllocTiledPitchHeight._pack_ = 1 # source:False
struct_c__SA_NVOS32_PARAMETERS_0_AllocTiledPitchHeight._fields_ = [
    ('owner', ctypes.c_uint32),
    ('hMemory', ctypes.c_uint32),
    ('type', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('height', ctypes.c_uint32),
    ('pitch', ctypes.c_int32),
    ('attr', ctypes.c_uint32),
    ('width', ctypes.c_uint32),
    ('format', ctypes.c_uint32),
    ('comprCovg', ctypes.c_uint32),
    ('zcullCovg', ctypes.c_uint32),
    ('partitionStride', ctypes.c_uint32),
    ('size', ctypes.c_uint64),
    ('alignment', ctypes.c_uint64),
    ('offset', ctypes.c_uint64),
    ('limit', ctypes.c_uint64),
    ('address', ctypes.POINTER(None)),
    ('rangeBegin', ctypes.c_uint64),
    ('rangeEnd', ctypes.c_uint64),
    ('attr2', ctypes.c_uint32),
    ('ctagOffset', ctypes.c_uint32),
    ('numaNode', ctypes.c_int32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

class struct_c__SA_NVOS32_PARAMETERS_0_Free(Structure):
    pass

struct_c__SA_NVOS32_PARAMETERS_0_Free._pack_ = 1 # source:False
struct_c__SA_NVOS32_PARAMETERS_0_Free._fields_ = [
    ('owner', ctypes.c_uint32),
    ('hMemory', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
]

class struct_c__SA_NVOS32_PARAMETERS_0_ReleaseCompr(Structure):
    pass

struct_c__SA_NVOS32_PARAMETERS_0_ReleaseCompr._pack_ = 1 # source:False
struct_c__SA_NVOS32_PARAMETERS_0_ReleaseCompr._fields_ = [
    ('owner', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('hMemory', ctypes.c_uint32),
]

class struct_c__SA_NVOS32_PARAMETERS_0_ReacquireCompr(Structure):
    pass

struct_c__SA_NVOS32_PARAMETERS_0_ReacquireCompr._pack_ = 1 # source:False
struct_c__SA_NVOS32_PARAMETERS_0_ReacquireCompr._fields_ = [
    ('owner', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('hMemory', ctypes.c_uint32),
]

class struct_c__SA_NVOS32_PARAMETERS_0_Info(Structure):
    pass

struct_c__SA_NVOS32_PARAMETERS_0_Info._pack_ = 1 # source:False
struct_c__SA_NVOS32_PARAMETERS_0_Info._fields_ = [
    ('attr', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('offset', ctypes.c_uint64),
    ('size', ctypes.c_uint64),
    ('base', ctypes.c_uint64),
]

class struct_c__SA_NVOS32_PARAMETERS_0_Dump(Structure):
    pass

struct_c__SA_NVOS32_PARAMETERS_0_Dump._pack_ = 1 # source:False
struct_c__SA_NVOS32_PARAMETERS_0_Dump._fields_ = [
    ('flags', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('pBuffer', ctypes.POINTER(None)),
    ('numBlocks', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

class struct_c__SA_NVOS32_PARAMETERS_0_AllocSizeRange(Structure):
    pass

struct_c__SA_NVOS32_PARAMETERS_0_AllocSizeRange._pack_ = 1 # source:False
struct_c__SA_NVOS32_PARAMETERS_0_AllocSizeRange._fields_ = [
    ('owner', ctypes.c_uint32),
    ('hMemory', ctypes.c_uint32),
    ('type', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('attr', ctypes.c_uint32),
    ('format', ctypes.c_uint32),
    ('comprCovg', ctypes.c_uint32),
    ('zcullCovg', ctypes.c_uint32),
    ('partitionStride', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('size', ctypes.c_uint64),
    ('alignment', ctypes.c_uint64),
    ('offset', ctypes.c_uint64),
    ('limit', ctypes.c_uint64),
    ('rangeBegin', ctypes.c_uint64),
    ('rangeEnd', ctypes.c_uint64),
    ('address', ctypes.POINTER(None)),
    ('attr2', ctypes.c_uint32),
    ('ctagOffset', ctypes.c_uint32),
    ('numaNode', ctypes.c_int32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

class struct_c__SA_NVOS32_PARAMETERS_0_AllocHintAlignment(Structure):
    pass

struct_c__SA_NVOS32_PARAMETERS_0_AllocHintAlignment._pack_ = 1 # source:False
struct_c__SA_NVOS32_PARAMETERS_0_AllocHintAlignment._fields_ = [
    ('alignType', ctypes.c_uint32),
    ('alignAttr', ctypes.c_uint32),
    ('alignInputFlags', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('alignSize', ctypes.c_uint64),
    ('alignHeight', ctypes.c_uint32),
    ('alignWidth', ctypes.c_uint32),
    ('alignPitch', ctypes.c_uint32),
    ('alignPad', ctypes.c_uint32),
    ('alignMask', ctypes.c_uint32),
    ('alignOutputFlags', ctypes.c_uint32 * 4),
    ('alignBank', ctypes.c_uint32 * 4),
    ('alignKind', ctypes.c_uint32),
    ('alignAdjust', ctypes.c_uint32),
    ('alignAttr2', ctypes.c_uint32),
]

class struct_c__SA_NVOS32_PARAMETERS_0_HwAlloc(Structure):
    pass

class struct_c__SA_NVOS32_PARAMETERS_0_9_comprInfo(Structure):
    pass

struct_c__SA_NVOS32_PARAMETERS_0_9_comprInfo._pack_ = 1 # source:False
struct_c__SA_NVOS32_PARAMETERS_0_9_comprInfo._fields_ = [
    ('compPageShift', ctypes.c_uint32),
    ('compressedKind', ctypes.c_uint32),
    ('compTagLineMin', ctypes.c_uint32),
    ('compPageIndexLo', ctypes.c_uint32),
    ('compPageIndexHi', ctypes.c_uint32),
    ('compTagLineMultiplier', ctypes.c_uint32),
]

struct_c__SA_NVOS32_PARAMETERS_0_HwAlloc._pack_ = 1 # source:False
struct_c__SA_NVOS32_PARAMETERS_0_HwAlloc._fields_ = [
    ('allocOwner', ctypes.c_uint32),
    ('allochMemory', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('allocType', ctypes.c_uint32),
    ('allocAttr', ctypes.c_uint32),
    ('allocInputFlags', ctypes.c_uint32),
    ('allocSize', ctypes.c_uint64),
    ('allocHeight', ctypes.c_uint32),
    ('allocWidth', ctypes.c_uint32),
    ('allocPitch', ctypes.c_uint32),
    ('allocMask', ctypes.c_uint32),
    ('allocComprCovg', ctypes.c_uint32),
    ('allocZcullCovg', ctypes.c_uint32),
    ('bindResultFunc', ctypes.POINTER(None)),
    ('pHandle', ctypes.POINTER(None)),
    ('hResourceHandle', ctypes.c_uint32),
    ('retAttr', ctypes.c_uint32),
    ('kind', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('osDeviceHandle', ctypes.c_uint64),
    ('allocAttr2', ctypes.c_uint32),
    ('retAttr2', ctypes.c_uint32),
    ('allocAddr', ctypes.c_uint64),
    ('comprInfo', struct_c__SA_NVOS32_PARAMETERS_0_9_comprInfo),
    ('uncompressedKind', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

class struct_c__SA_NVOS32_PARAMETERS_0_HwFree(Structure):
    pass

struct_c__SA_NVOS32_PARAMETERS_0_HwFree._pack_ = 1 # source:False
struct_c__SA_NVOS32_PARAMETERS_0_HwFree._fields_ = [
    ('hResourceHandle', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
]

class struct_c__SA_NVOS32_PARAMETERS_0_AllocOsDesc(Structure):
    pass

struct_c__SA_NVOS32_PARAMETERS_0_AllocOsDesc._pack_ = 1 # source:False
struct_c__SA_NVOS32_PARAMETERS_0_AllocOsDesc._fields_ = [
    ('hMemory', ctypes.c_uint32),
    ('type', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('attr', ctypes.c_uint32),
    ('attr2', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('descriptor', ctypes.POINTER(None)),
    ('limit', ctypes.c_uint64),
    ('descriptorType', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

union_c__SA_NVOS32_PARAMETERS_data._pack_ = 1 # source:False
union_c__SA_NVOS32_PARAMETERS_data._fields_ = [
    ('AllocSize', struct_c__SA_NVOS32_PARAMETERS_0_AllocSize),
    ('AllocTiledPitchHeight', struct_c__SA_NVOS32_PARAMETERS_0_AllocTiledPitchHeight),
    ('Free', struct_c__SA_NVOS32_PARAMETERS_0_Free),
    ('ReleaseCompr', struct_c__SA_NVOS32_PARAMETERS_0_ReleaseCompr),
    ('ReacquireCompr', struct_c__SA_NVOS32_PARAMETERS_0_ReacquireCompr),
    ('Info', struct_c__SA_NVOS32_PARAMETERS_0_Info),
    ('Dump', struct_c__SA_NVOS32_PARAMETERS_0_Dump),
    ('AllocSizeRange', struct_c__SA_NVOS32_PARAMETERS_0_AllocSizeRange),
    ('AllocHintAlignment', struct_c__SA_NVOS32_PARAMETERS_0_AllocHintAlignment),
    ('HwAlloc', struct_c__SA_NVOS32_PARAMETERS_0_HwAlloc),
    ('HwFree', struct_c__SA_NVOS32_PARAMETERS_0_HwFree),
    ('AllocOsDesc', struct_c__SA_NVOS32_PARAMETERS_0_AllocOsDesc),
    ('PADDING_0', ctypes.c_ubyte * 96),
]

struct_c__SA_NVOS32_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS32_PARAMETERS._fields_ = [
    ('hRoot', ctypes.c_uint32),
    ('hObjectParent', ctypes.c_uint32),
    ('function', ctypes.c_uint32),
    ('hVASpace', ctypes.c_uint32),
    ('ivcHeapNumber', ctypes.c_int16),
    ('PADDING_0', ctypes.c_ubyte * 2),
    ('status', ctypes.c_uint32),
    ('total', ctypes.c_uint64),
    ('free', ctypes.c_uint64),
    ('data', union_c__SA_NVOS32_PARAMETERS_data),
]

NVOS32_PARAMETERS = struct_c__SA_NVOS32_PARAMETERS
class struct_c__SA_NVOS32_HEAP_DUMP_BLOCK(Structure):
    pass

struct_c__SA_NVOS32_HEAP_DUMP_BLOCK._pack_ = 1 # source:False
struct_c__SA_NVOS32_HEAP_DUMP_BLOCK._fields_ = [
    ('owner', ctypes.c_uint32),
    ('format', ctypes.c_uint32),
    ('begin', ctypes.c_uint64),
    ('align', ctypes.c_uint64),
    ('end', ctypes.c_uint64),
]

NVOS32_HEAP_DUMP_BLOCK = struct_c__SA_NVOS32_HEAP_DUMP_BLOCK
class struct_c__SA_NV_CONTEXT_DMA_ALLOCATION_PARAMS(Structure):
    pass

struct_c__SA_NV_CONTEXT_DMA_ALLOCATION_PARAMS._pack_ = 1 # source:False
struct_c__SA_NV_CONTEXT_DMA_ALLOCATION_PARAMS._fields_ = [
    ('hSubDevice', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('hMemory', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('offset', ctypes.c_uint64),
    ('limit', ctypes.c_uint64),
]

NV_CONTEXT_DMA_ALLOCATION_PARAMS = struct_c__SA_NV_CONTEXT_DMA_ALLOCATION_PARAMS
class struct_c__SA_NV_MEMORY_ALLOCATION_PARAMS(Structure):
    pass

struct_c__SA_NV_MEMORY_ALLOCATION_PARAMS._pack_ = 1 # source:False
struct_c__SA_NV_MEMORY_ALLOCATION_PARAMS._fields_ = [
    ('owner', ctypes.c_uint32),
    ('type', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('width', ctypes.c_uint32),
    ('height', ctypes.c_uint32),
    ('pitch', ctypes.c_int32),
    ('attr', ctypes.c_uint32),
    ('attr2', ctypes.c_uint32),
    ('format', ctypes.c_uint32),
    ('comprCovg', ctypes.c_uint32),
    ('zcullCovg', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('rangeLo', ctypes.c_uint64),
    ('rangeHi', ctypes.c_uint64),
    ('size', ctypes.c_uint64),
    ('alignment', ctypes.c_uint64),
    ('offset', ctypes.c_uint64),
    ('limit', ctypes.c_uint64),
    ('address', ctypes.POINTER(None)),
    ('ctagOffset', ctypes.c_uint32),
    ('hVASpace', ctypes.c_uint32),
    ('internalflags', ctypes.c_uint32),
    ('tag', ctypes.c_uint32),
    ('numaNode', ctypes.c_int32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

NV_MEMORY_ALLOCATION_PARAMS = struct_c__SA_NV_MEMORY_ALLOCATION_PARAMS
class struct_c__SA_NV_OS_DESC_MEMORY_ALLOCATION_PARAMS(Structure):
    pass

struct_c__SA_NV_OS_DESC_MEMORY_ALLOCATION_PARAMS._pack_ = 1 # source:False
struct_c__SA_NV_OS_DESC_MEMORY_ALLOCATION_PARAMS._fields_ = [
    ('type', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('attr', ctypes.c_uint32),
    ('attr2', ctypes.c_uint32),
    ('descriptor', ctypes.POINTER(None)),
    ('limit', ctypes.c_uint64),
    ('descriptorType', ctypes.c_uint32),
    ('tag', ctypes.c_uint32),
]

NV_OS_DESC_MEMORY_ALLOCATION_PARAMS = struct_c__SA_NV_OS_DESC_MEMORY_ALLOCATION_PARAMS
class struct_c__SA_NV_USER_LOCAL_DESC_MEMORY_ALLOCATION_PARAMS(Structure):
    pass

struct_c__SA_NV_USER_LOCAL_DESC_MEMORY_ALLOCATION_PARAMS._pack_ = 1 # source:False
struct_c__SA_NV_USER_LOCAL_DESC_MEMORY_ALLOCATION_PARAMS._fields_ = [
    ('flags', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('physAddr', ctypes.c_uint64),
    ('size', ctypes.c_uint64),
    ('tag', ctypes.c_uint32),
    ('bGuestAllocated', ctypes.c_ubyte),
    ('PADDING_1', ctypes.c_ubyte * 3),
]

NV_USER_LOCAL_DESC_MEMORY_ALLOCATION_PARAMS = struct_c__SA_NV_USER_LOCAL_DESC_MEMORY_ALLOCATION_PARAMS
class struct_c__SA_NV_MEMORY_HW_RESOURCES_ALLOCATION_PARAMS(Structure):
    pass

struct_c__SA_NV_MEMORY_HW_RESOURCES_ALLOCATION_PARAMS._pack_ = 1 # source:False
struct_c__SA_NV_MEMORY_HW_RESOURCES_ALLOCATION_PARAMS._fields_ = [
    ('owner', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('type', ctypes.c_uint32),
    ('attr', ctypes.c_uint32),
    ('attr2', ctypes.c_uint32),
    ('height', ctypes.c_uint32),
    ('width', ctypes.c_uint32),
    ('pitch', ctypes.c_uint32),
    ('alignment', ctypes.c_uint32),
    ('comprCovg', ctypes.c_uint32),
    ('zcullCovg', ctypes.c_uint32),
    ('kind', ctypes.c_uint32),
    ('bindResultFunc', ctypes.POINTER(None)),
    ('pHandle', ctypes.POINTER(None)),
    ('osDeviceHandle', ctypes.c_uint64),
    ('size', ctypes.c_uint64),
    ('allocAddr', ctypes.c_uint64),
    ('compPageShift', ctypes.c_uint32),
    ('compressedKind', ctypes.c_uint32),
    ('compTagLineMin', ctypes.c_uint32),
    ('compPageIndexLo', ctypes.c_uint32),
    ('compPageIndexHi', ctypes.c_uint32),
    ('compTagLineMultiplier', ctypes.c_uint32),
    ('uncompressedKind', ctypes.c_uint32),
    ('tag', ctypes.c_uint32),
]

NV_MEMORY_HW_RESOURCES_ALLOCATION_PARAMS = struct_c__SA_NV_MEMORY_HW_RESOURCES_ALLOCATION_PARAMS
class struct_c__SA_NVOS33_PARAMETERS(Structure):
    pass

struct_c__SA_NVOS33_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS33_PARAMETERS._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hDevice', ctypes.c_uint32),
    ('hMemory', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('offset', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('pLinearAddress', ctypes.POINTER(None)),
    ('status', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
]

NVOS33_PARAMETERS = struct_c__SA_NVOS33_PARAMETERS
class struct_c__SA_NVOS34_PARAMETERS(Structure):
    pass

struct_c__SA_NVOS34_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS34_PARAMETERS._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hDevice', ctypes.c_uint32),
    ('hMemory', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('pLinearAddress', ctypes.POINTER(None)),
    ('status', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
]

NVOS34_PARAMETERS = struct_c__SA_NVOS34_PARAMETERS
class struct_c__SA_NVOS38_PARAMETERS(Structure):
    pass

struct_c__SA_NVOS38_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS38_PARAMETERS._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hObject', ctypes.c_uint32),
    ('AccessType', ctypes.c_uint32),
    ('DevNodeLength', ctypes.c_uint32),
    ('pDevNode', ctypes.POINTER(None)),
    ('ParmStrLength', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('pParmStr', ctypes.POINTER(None)),
    ('BinaryDataLength', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
    ('pBinaryData', ctypes.POINTER(None)),
    ('Data', ctypes.c_uint32),
    ('Entry', ctypes.c_uint32),
    ('status', ctypes.c_uint32),
    ('PADDING_2', ctypes.c_ubyte * 4),
]

NVOS38_PARAMETERS = struct_c__SA_NVOS38_PARAMETERS
class struct_c__SA_NVOS39_PARAMETERS(Structure):
    pass

struct_c__SA_NVOS39_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS39_PARAMETERS._fields_ = [
    ('hObjectParent', ctypes.c_uint32),
    ('hSubDevice', ctypes.c_uint32),
    ('hObjectNew', ctypes.c_uint32),
    ('hClass', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('selector', ctypes.c_uint32),
    ('hMemory', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('offset', ctypes.c_uint64),
    ('limit', ctypes.c_uint64),
    ('status', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

NVOS39_PARAMETERS = struct_c__SA_NVOS39_PARAMETERS
class struct_c__SA_NvUnixEvent(Structure):
    pass

struct_c__SA_NvUnixEvent._pack_ = 1 # source:False
struct_c__SA_NvUnixEvent._fields_ = [
    ('hObject', ctypes.c_uint32),
    ('NotifyIndex', ctypes.c_uint32),
    ('info32', ctypes.c_uint32),
    ('info16', ctypes.c_uint16),
    ('PADDING_0', ctypes.c_ubyte * 2),
]

NvUnixEvent = struct_c__SA_NvUnixEvent
class struct_c__SA_NVOS41_PARAMETERS(Structure):
    pass

struct_c__SA_NVOS41_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS41_PARAMETERS._fields_ = [
    ('pEvent', ctypes.POINTER(None)),
    ('MoreEvents', ctypes.c_uint32),
    ('status', ctypes.c_uint32),
]

NVOS41_PARAMETERS = struct_c__SA_NVOS41_PARAMETERS
class struct_c__SA_NVOS2C_PARAMETERS(Structure):
    pass

struct_c__SA_NVOS2C_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS2C_PARAMETERS._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hDevice', ctypes.c_uint32),
    ('offset', ctypes.c_uint32),
    ('bar', ctypes.c_uint32),
    ('bytes', ctypes.c_uint32),
    ('write', ctypes.c_uint32),
    ('data', ctypes.c_uint32),
    ('status', ctypes.c_uint32),
]

NVOS2C_PARAMETERS = struct_c__SA_NVOS2C_PARAMETERS
class struct_c__SA_NVOS46_PARAMETERS(Structure):
    pass

struct_c__SA_NVOS46_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS46_PARAMETERS._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hDevice', ctypes.c_uint32),
    ('hDma', ctypes.c_uint32),
    ('hMemory', ctypes.c_uint32),
    ('offset', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('flags', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('dmaOffset', ctypes.c_uint64),
    ('status', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

NVOS46_PARAMETERS = struct_c__SA_NVOS46_PARAMETERS
class struct_c__SA_NVOS47_PARAMETERS(Structure):
    pass

struct_c__SA_NVOS47_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS47_PARAMETERS._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hDevice', ctypes.c_uint32),
    ('hDma', ctypes.c_uint32),
    ('hMemory', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('dmaOffset', ctypes.c_uint64),
    ('size', ctypes.c_uint64),
    ('status', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

NVOS47_PARAMETERS = struct_c__SA_NVOS47_PARAMETERS
class struct_c__SA_NVOS49_PARAMETERS(Structure):
    pass

struct_c__SA_NVOS49_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS49_PARAMETERS._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hChannel', ctypes.c_uint32),
    ('hCtxDma', ctypes.c_uint32),
    ('status', ctypes.c_uint32),
]

NVOS49_PARAMETERS = struct_c__SA_NVOS49_PARAMETERS
class struct_c__SA_NVOS54_PARAMETERS(Structure):
    pass

struct_c__SA_NVOS54_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS54_PARAMETERS._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hObject', ctypes.c_uint32),
    ('cmd', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('params', ctypes.POINTER(None)),
    ('paramsSize', ctypes.c_uint32),
    ('status', ctypes.c_uint32),
]

NVOS54_PARAMETERS = struct_c__SA_NVOS54_PARAMETERS
class struct_c__SA_NVOS63_PARAMETERS(Structure):
    pass

struct_c__SA_NVOS63_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS63_PARAMETERS._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hObject', ctypes.c_uint32),
    ('cmd', ctypes.c_uint32),
    ('paramsSize', ctypes.c_uint32),
    ('status', ctypes.c_uint32),
]

NVOS63_PARAMETERS = struct_c__SA_NVOS63_PARAMETERS
class struct_c__SA_NVOS55_PARAMETERS(Structure):
    pass

struct_c__SA_NVOS55_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS55_PARAMETERS._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hParent', ctypes.c_uint32),
    ('hObject', ctypes.c_uint32),
    ('hClientSrc', ctypes.c_uint32),
    ('hObjectSrc', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('status', ctypes.c_uint32),
]

NVOS55_PARAMETERS = struct_c__SA_NVOS55_PARAMETERS
class struct_c__SA_NVOS56_PARAMETERS(Structure):
    pass

struct_c__SA_NVOS56_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS56_PARAMETERS._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hDevice', ctypes.c_uint32),
    ('hMemory', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('pOldCpuAddress', ctypes.POINTER(None)),
    ('pNewCpuAddress', ctypes.POINTER(None)),
    ('status', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

NVOS56_PARAMETERS = struct_c__SA_NVOS56_PARAMETERS
class struct_c__SA_NVOS57_PARAMETERS(Structure):
    pass

class struct_RS_SHARE_POLICY(Structure):
    pass

class struct_RS_ACCESS_MASK(Structure):
    pass

struct_RS_ACCESS_MASK._pack_ = 1 # source:False
struct_RS_ACCESS_MASK._fields_ = [
    ('limbs', ctypes.c_uint32 * 1),
]

struct_RS_SHARE_POLICY._pack_ = 1 # source:False
struct_RS_SHARE_POLICY._fields_ = [
    ('target', ctypes.c_uint32),
    ('accessMask', struct_RS_ACCESS_MASK),
    ('type', ctypes.c_uint16),
    ('action', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte),
]

struct_c__SA_NVOS57_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS57_PARAMETERS._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hObject', ctypes.c_uint32),
    ('sharePolicy', struct_RS_SHARE_POLICY),
    ('status', ctypes.c_uint32),
]

NVOS57_PARAMETERS = struct_c__SA_NVOS57_PARAMETERS
class struct_c__SA_NVPOWERSTATE_PARAMETERS(Structure):
    pass

struct_c__SA_NVPOWERSTATE_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVPOWERSTATE_PARAMETERS._fields_ = [
    ('deviceReference', ctypes.c_uint32),
    ('head', ctypes.c_uint32),
    ('state', ctypes.c_uint32),
    ('forceMonitorState', ctypes.c_ubyte),
    ('bForcePerfBiosLevel', ctypes.c_ubyte),
    ('bIsD3HotTransition', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte),
    ('fastBootPowerState', ctypes.c_uint32),
]

NVPOWERSTATE_PARAMETERS = struct_c__SA_NVPOWERSTATE_PARAMETERS
PNVPOWERSTATE_PARAMETERS = ctypes.POINTER(struct_c__SA_NVPOWERSTATE_PARAMETERS)
class struct_c__SA_NV_GR_ALLOCATION_PARAMETERS(Structure):
    pass

struct_c__SA_NV_GR_ALLOCATION_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NV_GR_ALLOCATION_PARAMETERS._fields_ = [
    ('version', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('size', ctypes.c_uint32),
    ('caps', ctypes.c_uint32),
]

NV_GR_ALLOCATION_PARAMETERS = struct_c__SA_NV_GR_ALLOCATION_PARAMETERS
class struct_c__SA_NV50VAIO_CHANNELDMA_ALLOCATION_PARAMETERS(Structure):
    pass

struct_c__SA_NV50VAIO_CHANNELDMA_ALLOCATION_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NV50VAIO_CHANNELDMA_ALLOCATION_PARAMETERS._fields_ = [
    ('channelInstance', ctypes.c_uint32),
    ('hObjectBuffer', ctypes.c_uint32),
    ('hObjectNotify', ctypes.c_uint32),
    ('offset', ctypes.c_uint32),
    ('pControl', ctypes.POINTER(None)),
    ('flags', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NV50VAIO_CHANNELDMA_ALLOCATION_PARAMETERS = struct_c__SA_NV50VAIO_CHANNELDMA_ALLOCATION_PARAMETERS
class struct_c__SA_NV50VAIO_CHANNELPIO_ALLOCATION_PARAMETERS(Structure):
    pass

struct_c__SA_NV50VAIO_CHANNELPIO_ALLOCATION_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NV50VAIO_CHANNELPIO_ALLOCATION_PARAMETERS._fields_ = [
    ('channelInstance', ctypes.c_uint32),
    ('hObjectNotify', ctypes.c_uint32),
    ('pControl', ctypes.POINTER(None)),
]

NV50VAIO_CHANNELPIO_ALLOCATION_PARAMETERS = struct_c__SA_NV50VAIO_CHANNELPIO_ALLOCATION_PARAMETERS
class struct_c__SA_NV_CHANNEL_GROUP_ALLOCATION_PARAMETERS(Structure):
    pass

struct_c__SA_NV_CHANNEL_GROUP_ALLOCATION_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NV_CHANNEL_GROUP_ALLOCATION_PARAMETERS._fields_ = [
    ('hObjectError', ctypes.c_uint32),
    ('hObjectEccError', ctypes.c_uint32),
    ('hVASpace', ctypes.c_uint32),
    ('engineType', ctypes.c_uint32),
    ('bIsCallingContextVgpuPlugin', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV_CHANNEL_GROUP_ALLOCATION_PARAMETERS = struct_c__SA_NV_CHANNEL_GROUP_ALLOCATION_PARAMETERS
class struct_c__SA_NV_SWRUNLIST_ALLOCATION_PARAMS(Structure):
    pass

struct_c__SA_NV_SWRUNLIST_ALLOCATION_PARAMS._pack_ = 1 # source:False
struct_c__SA_NV_SWRUNLIST_ALLOCATION_PARAMS._fields_ = [
    ('engineId', ctypes.c_uint32),
    ('maxTSGs', ctypes.c_uint32),
    ('qosIntrEnableMask', ctypes.c_uint32),
]

NV_SWRUNLIST_ALLOCATION_PARAMS = struct_c__SA_NV_SWRUNLIST_ALLOCATION_PARAMS
class struct_c__SA_NV_ME_ALLOCATION_PARAMETERS(Structure):
    pass

struct_c__SA_NV_ME_ALLOCATION_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NV_ME_ALLOCATION_PARAMETERS._fields_ = [
    ('size', ctypes.c_uint32),
    ('caps', ctypes.c_uint32),
]

NV_ME_ALLOCATION_PARAMETERS = struct_c__SA_NV_ME_ALLOCATION_PARAMETERS
class struct_c__SA_NV_BSP_ALLOCATION_PARAMETERS(Structure):
    pass

struct_c__SA_NV_BSP_ALLOCATION_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NV_BSP_ALLOCATION_PARAMETERS._fields_ = [
    ('size', ctypes.c_uint32),
    ('prohibitMultipleInstances', ctypes.c_uint32),
    ('engineInstance', ctypes.c_uint32),
]

NV_BSP_ALLOCATION_PARAMETERS = struct_c__SA_NV_BSP_ALLOCATION_PARAMETERS
class struct_c__SA_NV_VP_ALLOCATION_PARAMETERS(Structure):
    pass

struct_c__SA_NV_VP_ALLOCATION_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NV_VP_ALLOCATION_PARAMETERS._fields_ = [
    ('size', ctypes.c_uint32),
    ('caps', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('altUcode', ctypes.c_uint32),
    ('rawUcode', ctypes.POINTER(None)),
    ('rawUcodeSize', ctypes.c_uint32),
    ('numSubClasses', ctypes.c_uint32),
    ('numSubSets', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('subClasses', ctypes.POINTER(None)),
    ('prohibitMultipleInstances', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
    ('pControl', ctypes.POINTER(None)),
    ('hMemoryCmdBuffer', ctypes.c_uint32),
    ('PADDING_2', ctypes.c_ubyte * 4),
    ('offset', ctypes.c_uint64),
]

NV_VP_ALLOCATION_PARAMETERS = struct_c__SA_NV_VP_ALLOCATION_PARAMETERS
class struct_c__SA_NV_PPP_ALLOCATION_PARAMETERS(Structure):
    pass

struct_c__SA_NV_PPP_ALLOCATION_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NV_PPP_ALLOCATION_PARAMETERS._fields_ = [
    ('size', ctypes.c_uint32),
    ('prohibitMultipleInstances', ctypes.c_uint32),
]

NV_PPP_ALLOCATION_PARAMETERS = struct_c__SA_NV_PPP_ALLOCATION_PARAMETERS
class struct_c__SA_NV_MSENC_ALLOCATION_PARAMETERS(Structure):
    pass

struct_c__SA_NV_MSENC_ALLOCATION_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NV_MSENC_ALLOCATION_PARAMETERS._fields_ = [
    ('size', ctypes.c_uint32),
    ('prohibitMultipleInstances', ctypes.c_uint32),
    ('engineInstance', ctypes.c_uint32),
]

NV_MSENC_ALLOCATION_PARAMETERS = struct_c__SA_NV_MSENC_ALLOCATION_PARAMETERS
class struct_c__SA_NV_SEC2_ALLOCATION_PARAMETERS(Structure):
    pass

struct_c__SA_NV_SEC2_ALLOCATION_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NV_SEC2_ALLOCATION_PARAMETERS._fields_ = [
    ('size', ctypes.c_uint32),
    ('prohibitMultipleInstances', ctypes.c_uint32),
]

NV_SEC2_ALLOCATION_PARAMETERS = struct_c__SA_NV_SEC2_ALLOCATION_PARAMETERS
class struct_c__SA_NV_NVJPG_ALLOCATION_PARAMETERS(Structure):
    pass

struct_c__SA_NV_NVJPG_ALLOCATION_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NV_NVJPG_ALLOCATION_PARAMETERS._fields_ = [
    ('size', ctypes.c_uint32),
    ('prohibitMultipleInstances', ctypes.c_uint32),
    ('engineInstance', ctypes.c_uint32),
]

NV_NVJPG_ALLOCATION_PARAMETERS = struct_c__SA_NV_NVJPG_ALLOCATION_PARAMETERS
class struct_c__SA_NV_OFA_ALLOCATION_PARAMETERS(Structure):
    pass

struct_c__SA_NV_OFA_ALLOCATION_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NV_OFA_ALLOCATION_PARAMETERS._fields_ = [
    ('size', ctypes.c_uint32),
    ('prohibitMultipleInstances', ctypes.c_uint32),
    ('engineInstance', ctypes.c_uint32),
]

NV_OFA_ALLOCATION_PARAMETERS = struct_c__SA_NV_OFA_ALLOCATION_PARAMETERS
class struct_c__SA_NVOS61_PARAMETERS(Structure):
    pass

struct_c__SA_NVOS61_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NVOS61_PARAMETERS._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hDevice', ctypes.c_uint32),
    ('hVblank', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('pProc', ctypes.CFUNCTYPE(None, ctypes.POINTER(None), ctypes.POINTER(None))),
    ('LogicalHead', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
    ('pParm1', ctypes.POINTER(None)),
    ('pParm2', ctypes.POINTER(None)),
    ('bAdd', ctypes.c_uint32),
    ('status', ctypes.c_uint32),
]

NVOS61_PARAMETERS = struct_c__SA_NVOS61_PARAMETERS
class struct_c__SA_NV_VASPACE_ALLOCATION_PARAMETERS(Structure):
    pass

struct_c__SA_NV_VASPACE_ALLOCATION_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NV_VASPACE_ALLOCATION_PARAMETERS._fields_ = [
    ('index', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('vaSize', ctypes.c_uint64),
    ('vaStartInternal', ctypes.c_uint64),
    ('vaLimitInternal', ctypes.c_uint64),
    ('bigPageSize', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('vaBase', ctypes.c_uint64),
]

NV_VASPACE_ALLOCATION_PARAMETERS = struct_c__SA_NV_VASPACE_ALLOCATION_PARAMETERS
class struct_c__SA_NV_CTXSHARE_ALLOCATION_PARAMETERS(Structure):
    pass

struct_c__SA_NV_CTXSHARE_ALLOCATION_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NV_CTXSHARE_ALLOCATION_PARAMETERS._fields_ = [
    ('hVASpace', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('subctxId', ctypes.c_uint32),
]

NV_CTXSHARE_ALLOCATION_PARAMETERS = struct_c__SA_NV_CTXSHARE_ALLOCATION_PARAMETERS
class struct_c__SA_NV_TIMEOUT_CONTROL_PARAMETERS(Structure):
    pass

struct_c__SA_NV_TIMEOUT_CONTROL_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NV_TIMEOUT_CONTROL_PARAMETERS._fields_ = [
    ('cmd', ctypes.c_uint32),
    ('timeoutInMs', ctypes.c_uint32),
    ('deviceInstance', ctypes.c_uint32),
]

NV_TIMEOUT_CONTROL_PARAMETERS = struct_c__SA_NV_TIMEOUT_CONTROL_PARAMETERS
class struct_c__SA_NV_GSP_TEST_GET_MSG_BLOCK_PARAMETERS(Structure):
    pass

struct_c__SA_NV_GSP_TEST_GET_MSG_BLOCK_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NV_GSP_TEST_GET_MSG_BLOCK_PARAMETERS._fields_ = [
    ('blockNum', ctypes.c_uint32),
    ('bufferSize', ctypes.c_uint32),
    ('pBuffer', ctypes.POINTER(None)),
    ('status', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NV_GSP_TEST_GET_MSG_BLOCK_PARAMETERS = struct_c__SA_NV_GSP_TEST_GET_MSG_BLOCK_PARAMETERS
class struct_c__SA_NV_GSP_TEST_SEND_MSG_RESPONSE_PARAMETERS(Structure):
    pass

struct_c__SA_NV_GSP_TEST_SEND_MSG_RESPONSE_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NV_GSP_TEST_SEND_MSG_RESPONSE_PARAMETERS._fields_ = [
    ('bufferSize', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('pBuffer', ctypes.POINTER(None)),
    ('status', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

NV_GSP_TEST_SEND_MSG_RESPONSE_PARAMETERS = struct_c__SA_NV_GSP_TEST_SEND_MSG_RESPONSE_PARAMETERS
class struct_c__SA_NV_GSP_TEST_SEND_EVENT_NOTIFICATION_PARAMETERS(Structure):
    pass

struct_c__SA_NV_GSP_TEST_SEND_EVENT_NOTIFICATION_PARAMETERS._pack_ = 1 # source:False
struct_c__SA_NV_GSP_TEST_SEND_EVENT_NOTIFICATION_PARAMETERS._fields_ = [
    ('hParentClient', ctypes.c_uint32),
    ('hSrcResource', ctypes.c_uint32),
    ('hClass', ctypes.c_uint32),
    ('notifyIndex', ctypes.c_uint32),
    ('status', ctypes.c_uint32),
]

NV_GSP_TEST_SEND_EVENT_NOTIFICATION_PARAMETERS = struct_c__SA_NV_GSP_TEST_SEND_EVENT_NOTIFICATION_PARAMETERS

# values for enumeration 'c__EA_NV_VIDMEM_ACCESS_BIT_ALLOCATION_PARAMS_ADDR_SPACE'
c__EA_NV_VIDMEM_ACCESS_BIT_ALLOCATION_PARAMS_ADDR_SPACE__enumvalues = {
    0: 'NV_VIDMEM_ACCESS_BIT_BUFFER_ADDR_SPACE_DEFAULT',
    1: 'NV_VIDMEM_ACCESS_BIT_BUFFER_ADDR_SPACE_COH',
    2: 'NV_VIDMEM_ACCESS_BIT_BUFFER_ADDR_SPACE_NCOH',
    3: 'NV_VIDMEM_ACCESS_BIT_BUFFER_ADDR_SPACE_VID',
}
NV_VIDMEM_ACCESS_BIT_BUFFER_ADDR_SPACE_DEFAULT = 0
NV_VIDMEM_ACCESS_BIT_BUFFER_ADDR_SPACE_COH = 1
NV_VIDMEM_ACCESS_BIT_BUFFER_ADDR_SPACE_NCOH = 2
NV_VIDMEM_ACCESS_BIT_BUFFER_ADDR_SPACE_VID = 3
c__EA_NV_VIDMEM_ACCESS_BIT_ALLOCATION_PARAMS_ADDR_SPACE = ctypes.c_uint32 # enum
NV_VIDMEM_ACCESS_BIT_ALLOCATION_PARAMS_ADDR_SPACE = c__EA_NV_VIDMEM_ACCESS_BIT_ALLOCATION_PARAMS_ADDR_SPACE
NV_VIDMEM_ACCESS_BIT_ALLOCATION_PARAMS_ADDR_SPACE__enumvalues = c__EA_NV_VIDMEM_ACCESS_BIT_ALLOCATION_PARAMS_ADDR_SPACE__enumvalues
class struct_c__SA_NV_VIDMEM_ACCESS_BIT_ALLOCATION_PARAMS(Structure):
    pass

struct_c__SA_NV_VIDMEM_ACCESS_BIT_ALLOCATION_PARAMS._pack_ = 1 # source:False
struct_c__SA_NV_VIDMEM_ACCESS_BIT_ALLOCATION_PARAMS._fields_ = [
    ('bDirtyTracking', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('granularity', ctypes.c_uint32),
    ('accessBitMask', ctypes.c_uint64 * 64),
    ('noOfEntries', ctypes.c_uint32),
    ('addrSpace', NV_VIDMEM_ACCESS_BIT_ALLOCATION_PARAMS_ADDR_SPACE),
]

NV_VIDMEM_ACCESS_BIT_ALLOCATION_PARAMS = struct_c__SA_NV_VIDMEM_ACCESS_BIT_ALLOCATION_PARAMS
class struct_c__SA_NV_HOPPER_USERMODE_A_PARAMS(Structure):
    pass

struct_c__SA_NV_HOPPER_USERMODE_A_PARAMS._pack_ = 1 # source:False
struct_c__SA_NV_HOPPER_USERMODE_A_PARAMS._fields_ = [
    ('bBar1Mapping', ctypes.c_ubyte),
    ('bPriv', ctypes.c_ubyte),
]

NV_HOPPER_USERMODE_A_PARAMS = struct_c__SA_NV_HOPPER_USERMODE_A_PARAMS
class struct_c__SA_nv_ioctl_nvos02_parameters_with_fd(Structure):
    pass

struct_c__SA_nv_ioctl_nvos02_parameters_with_fd._pack_ = 1 # source:False
struct_c__SA_nv_ioctl_nvos02_parameters_with_fd._fields_ = [
    ('params', NVOS02_PARAMETERS),
    ('fd', ctypes.c_int32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

nv_ioctl_nvos02_parameters_with_fd = struct_c__SA_nv_ioctl_nvos02_parameters_with_fd
class struct_c__SA_nv_ioctl_nvos33_parameters_with_fd(Structure):
    pass

struct_c__SA_nv_ioctl_nvos33_parameters_with_fd._pack_ = 1 # source:False
struct_c__SA_nv_ioctl_nvos33_parameters_with_fd._fields_ = [
    ('params', NVOS33_PARAMETERS),
    ('fd', ctypes.c_int32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

nv_ioctl_nvos33_parameters_with_fd = struct_c__SA_nv_ioctl_nvos33_parameters_with_fd
# def NV0000_CTRL_CMD(cat, idx):  # macro
#    return NVXXXX_CTRL_CMD(0x0000,NV0000_CTRL_##cat,idx)
NV0000_CTRL_RESERVED = (0x00) # macro
NV0000_CTRL_SYSTEM = (0x01) # macro
NV0000_CTRL_GPU = (0x02) # macro
NV0000_CTRL_GSYNC = (0x03) # macro
NV0000_CTRL_DIAG = (0x04) # macro
NV0000_CTRL_EVENT = (0x05) # macro
NV0000_CTRL_NVD = (0x06) # macro
NV0000_CTRL_SWINSTR = (0x07) # macro
NV0000_CTRL_PROC = (0x09) # macro
NV0000_CTRL_SYNC_GPU_BOOST = (0x0A) # macro
NV0000_CTRL_GPUACCT = (0x0B) # macro
NV0000_CTRL_VGPU = (0x0C) # macro
NV0000_CTRL_CLIENT = (0x0D) # macro
NV0000_CTRL_OS_WINDOWS = (0x3F) # macro
NV0000_CTRL_OS_MACOS = (0x3E) # macro
NV0000_CTRL_OS_UNIX = (0x3D) # macro
NV0000_CTRL_CMD_NULL = (0x0) # macro
NV0000_CTRL_CMD_CLIENT_GET_ADDR_SPACE_TYPE = (0xd01) # macro
NV0000_CTRL_CLIENT_GET_ADDR_SPACE_TYPE_PARAMS_MESSAGE_ID = (0x1) # macro
NV0000_CTRL_CMD_CLIENT_GET_ADDR_SPACE_TYPE_INVALID = 0x00000000 # macro
NV0000_CTRL_CMD_CLIENT_GET_ADDR_SPACE_TYPE_SYSMEM = 0x00000001 # macro
NV0000_CTRL_CMD_CLIENT_GET_ADDR_SPACE_TYPE_VIDMEM = 0x00000002 # macro
NV0000_CTRL_CMD_CLIENT_GET_ADDR_SPACE_TYPE_REGMEM = 0x00000003 # macro
NV0000_CTRL_CMD_CLIENT_GET_ADDR_SPACE_TYPE_FABRIC = 0x00000004 # macro
NV0000_CTRL_CMD_CLIENT_GET_HANDLE_INFO = (0xd02) # macro
NV0000_CTRL_CLIENT_GET_HANDLE_INFO_PARAMS_MESSAGE_ID = (0x2) # macro
NV0000_CTRL_CMD_CLIENT_GET_HANDLE_INFO_INDEX_INVALID = 0x00000000 # macro
NV0000_CTRL_CMD_CLIENT_GET_HANDLE_INFO_INDEX_PARENT = 0x00000001 # macro
NV0000_CTRL_CMD_CLIENT_GET_HANDLE_INFO_INDEX_CLASSID = 0x00000002 # macro
NV0000_CTRL_CMD_CLIENT_GET_ACCESS_RIGHTS = (0xd03) # macro
NV0000_CTRL_CLIENT_GET_ACCESS_RIGHTS_PARAMS_MESSAGE_ID = (0x3) # macro
NV0000_CTRL_CMD_CLIENT_SET_INHERITED_SHARE_POLICY = (0xd04) # macro
NV0000_CTRL_CLIENT_SET_INHERITED_SHARE_POLICY_PARAMS_MESSAGE_ID = (0x4) # macro
NV0000_CTRL_CMD_CLIENT_GET_CHILD_HANDLE = (0xd05) # macro
NV0000_CTRL_CMD_CLIENT_GET_CHILD_HANDLE_PARAMS_MESSAGE_ID = (0x5) # macro
NV0000_CTRL_CMD_CLIENT_SHARE_OBJECT = (0xd06) # macro
NV0000_CTRL_CLIENT_SHARE_OBJECT_PARAMS_MESSAGE_ID = (0x6) # macro
NV0000_CTRL_CMD_CLIENT_OBJECTS_ARE_DUPLICATES = (0xd07) # macro
NV0000_CTRL_CLIENT_OBJECTS_ARE_DUPLICATES_PARAMS_MESSAGE_ID = (0x7) # macro
NV0000_CTRL_CMD_CLIENT_SUBSCRIBE_TO_IMEX_CHANNEL = (0xd08) # macro
NV0000_CTRL_CLIENT_SUBSCRIBE_TO_IMEX_CHANNEL_PARAMS_MESSAGE_ID = (0x8) # macro
class struct_NV0000_CTRL_CLIENT_GET_ADDR_SPACE_TYPE_PARAMS(Structure):
    pass

struct_NV0000_CTRL_CLIENT_GET_ADDR_SPACE_TYPE_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_CLIENT_GET_ADDR_SPACE_TYPE_PARAMS._fields_ = [
    ('hObject', ctypes.c_uint32),
    ('mapFlags', ctypes.c_uint32),
    ('addrSpaceType', ctypes.c_uint32),
]

NV0000_CTRL_CLIENT_GET_ADDR_SPACE_TYPE_PARAMS = struct_NV0000_CTRL_CLIENT_GET_ADDR_SPACE_TYPE_PARAMS
class struct_NV0000_CTRL_CLIENT_GET_HANDLE_INFO_PARAMS(Structure):
    pass

class union_NV0000_CTRL_CLIENT_GET_HANDLE_INFO_PARAMS_data(Union):
    pass

union_NV0000_CTRL_CLIENT_GET_HANDLE_INFO_PARAMS_data._pack_ = 1 # source:False
union_NV0000_CTRL_CLIENT_GET_HANDLE_INFO_PARAMS_data._fields_ = [
    ('hResult', ctypes.c_uint32),
    ('iResult', ctypes.c_uint64),
]

struct_NV0000_CTRL_CLIENT_GET_HANDLE_INFO_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_CLIENT_GET_HANDLE_INFO_PARAMS._fields_ = [
    ('hObject', ctypes.c_uint32),
    ('index', ctypes.c_uint32),
    ('data', union_NV0000_CTRL_CLIENT_GET_HANDLE_INFO_PARAMS_data),
]

NV0000_CTRL_CLIENT_GET_HANDLE_INFO_PARAMS = struct_NV0000_CTRL_CLIENT_GET_HANDLE_INFO_PARAMS
class struct_NV0000_CTRL_CLIENT_GET_ACCESS_RIGHTS_PARAMS(Structure):
    pass

struct_NV0000_CTRL_CLIENT_GET_ACCESS_RIGHTS_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_CLIENT_GET_ACCESS_RIGHTS_PARAMS._fields_ = [
    ('hObject', ctypes.c_uint32),
    ('hClient', ctypes.c_uint32),
    ('maskResult', struct_RS_ACCESS_MASK),
]

NV0000_CTRL_CLIENT_GET_ACCESS_RIGHTS_PARAMS = struct_NV0000_CTRL_CLIENT_GET_ACCESS_RIGHTS_PARAMS
class struct_NV0000_CTRL_CLIENT_SET_INHERITED_SHARE_POLICY_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('sharePolicy', struct_RS_SHARE_POLICY),
     ]

NV0000_CTRL_CLIENT_SET_INHERITED_SHARE_POLICY_PARAMS = struct_NV0000_CTRL_CLIENT_SET_INHERITED_SHARE_POLICY_PARAMS
class struct_NV0000_CTRL_CMD_CLIENT_GET_CHILD_HANDLE_PARAMS(Structure):
    pass

struct_NV0000_CTRL_CMD_CLIENT_GET_CHILD_HANDLE_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_CMD_CLIENT_GET_CHILD_HANDLE_PARAMS._fields_ = [
    ('hParent', ctypes.c_uint32),
    ('classId', ctypes.c_uint32),
    ('hObject', ctypes.c_uint32),
]

NV0000_CTRL_CMD_CLIENT_GET_CHILD_HANDLE_PARAMS = struct_NV0000_CTRL_CMD_CLIENT_GET_CHILD_HANDLE_PARAMS
class struct_NV0000_CTRL_CLIENT_SHARE_OBJECT_PARAMS(Structure):
    pass

struct_NV0000_CTRL_CLIENT_SHARE_OBJECT_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_CLIENT_SHARE_OBJECT_PARAMS._fields_ = [
    ('hObject', ctypes.c_uint32),
    ('sharePolicy', struct_RS_SHARE_POLICY),
]

NV0000_CTRL_CLIENT_SHARE_OBJECT_PARAMS = struct_NV0000_CTRL_CLIENT_SHARE_OBJECT_PARAMS
class struct_NV0000_CTRL_CLIENT_OBJECTS_ARE_DUPLICATES_PARAMS(Structure):
    pass

struct_NV0000_CTRL_CLIENT_OBJECTS_ARE_DUPLICATES_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_CLIENT_OBJECTS_ARE_DUPLICATES_PARAMS._fields_ = [
    ('hObject1', ctypes.c_uint32),
    ('hObject2', ctypes.c_uint32),
    ('bDuplicates', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV0000_CTRL_CLIENT_OBJECTS_ARE_DUPLICATES_PARAMS = struct_NV0000_CTRL_CLIENT_OBJECTS_ARE_DUPLICATES_PARAMS
class struct_NV0000_CTRL_CLIENT_SUBSCRIBE_TO_IMEX_CHANNEL_PARAMS(Structure):
    pass

struct_NV0000_CTRL_CLIENT_SUBSCRIBE_TO_IMEX_CHANNEL_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_CLIENT_SUBSCRIBE_TO_IMEX_CHANNEL_PARAMS._fields_ = [
    ('devDescriptor', ctypes.c_uint64),
    ('channel', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NV0000_CTRL_CLIENT_SUBSCRIBE_TO_IMEX_CHANNEL_PARAMS = struct_NV0000_CTRL_CLIENT_SUBSCRIBE_TO_IMEX_CHANNEL_PARAMS
NV0000_CTRL_CMD_DIAG_GET_LOCK_METER_STATE = (0x480) # macro
NV0000_CTRL_DIAG_GET_LOCK_METER_STATE_PARAMS_MESSAGE_ID = (0x80) # macro
NV0000_CTRL_DIAG_GET_LOCK_METER_STATE_DISABLED = (0x00000000) # macro
NV0000_CTRL_DIAG_GET_LOCK_METER_STATE_ENABLED = (0x00000001) # macro
NV0000_CTRL_DIAG_LOCK_METER_MAX_TABLE_ENTRIES = (0x20000) # macro
NV0000_CTRL_CMD_DIAG_SET_LOCK_METER_STATE = (0x481) # macro
NV0000_CTRL_DIAG_SET_LOCK_METER_STATE_PARAMS_MESSAGE_ID = (0x81) # macro
NV0000_CTRL_DIAG_SET_LOCK_METER_STATE_DISABLE = (0x00000000) # macro
NV0000_CTRL_DIAG_SET_LOCK_METER_STATE_ENABLE = (0x00000001) # macro
NV0000_CTRL_DIAG_SET_LOCK_METER_STATE_RESET = (0x00000002) # macro
NV0000_CTRL_DIAG_LOCK_METER_ENTRY_FILENAME_LENGTH = (0xc) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_ACQUIRE_SEMA = (0x00000001) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_ACQUIRE_SEMA_FORCED = (0x00000002) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_ACQUIRE_SEMA_COND = (0x00000003) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_RELEASE_SEMA = (0x00000004) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_ACQUIRE_API = (0x00000010) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_RELEASE_API = (0x00000011) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_ACQUIRE_GPUS = (0x00000020) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_RELEASE_GPUS = (0x00000021) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_DATA = (0x00000100) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_RMCTRL = (0x00001000) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_CFG_GET = (0x00002000) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_CFG_SET = (0x00002001) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_CFG_GETEX = (0x00002002) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_CFG_SETEX = (0x00002003) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_VIDHEAP = (0x00003000) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_MAPMEM = (0x00003001) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_UNMAPMEM = (0x00003002) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_MAPMEM_DMA = (0x00003003) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_UNMAPMEM_DMA = (0x00003004) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_ALLOC = (0x00004000) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_ALLOC_MEM = (0x00004001) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_DUP_OBJECT = (0x00004010) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_FREE_CLIENT = (0x00005000) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_FREE_DEVICE = (0x00005001) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_FREE_SUBDEVICE = (0x00005002) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_FREE_SUBDEVICE_DIAG = (0x00005003) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_FREE_DISP = (0x00005004) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_FREE_DISP_CMN = (0x00005005) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_FREE_CHANNEL = (0x00005006) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_FREE_CHANNEL_MPEG = (0x00005007) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_FREE_CHANNEL_DISP = (0x00005008) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_FREE_MEMORY = (0x00005009) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_FREE_FBMEM = (0x0000500A) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_FREE_OBJECT = (0x0000500B) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_FREE_EVENT = (0x0000500C) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_IDLE_CHANNELS = (0x00006000) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_BIND_CTXDMA = (0x00007000) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_ALLOC_CTXDMA = (0x00007001) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_ISR = (0x0000F000) # macro
NV0000_CTRL_DIAG_LOCK_METER_TAG_DPC = (0x0000F00F) # macro
NV0000_CTRL_CMD_DIAG_GET_LOCK_METER_ENTRIES = (0x485) # macro
NV0000_CTRL_DIAG_GET_LOCK_METER_ENTRIES_MAX = (0x40) # macro
NV0000_CTRL_DIAG_GET_LOCK_METER_ENTRIES_PARAMS_MESSAGE_ID = (0x85) # macro
NV0000_CTRL_CMD_DIAG_PROFILE_RPC = (0x488) # macro
NV0000_CTRL_DIAG_PROFILE_RPC_PARAMS_MESSAGE_ID = (0x88) # macro
NV0000_CTRL_PROFILE_RPC_CMD_DISABLE = (0x00000000) # macro
NV0000_CTRL_PROFILE_RPC_CMD_ENABLE = (0x00000001) # macro
NV0000_CTRL_PROFILE_RPC_CMD_RESET = (0x00000002) # macro
NV0000_CTRL_CMD_DIAG_DUMP_RPC = (0x489) # macro
NV0000_CTRL_DIAG_RPC_MAX_ENTRIES = (100) # macro
NV0000_CTRL_DIAG_DUMP_RPC_PARAMS_MESSAGE_ID = (0x89) # macro
class struct_NV0000_CTRL_DIAG_GET_LOCK_METER_STATE_PARAMS(Structure):
    pass

struct_NV0000_CTRL_DIAG_GET_LOCK_METER_STATE_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_DIAG_GET_LOCK_METER_STATE_PARAMS._fields_ = [
    ('state', ctypes.c_uint32),
    ('count', ctypes.c_uint32),
    ('missedCount', ctypes.c_uint32),
    ('bCircularBuffer', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV0000_CTRL_DIAG_GET_LOCK_METER_STATE_PARAMS = struct_NV0000_CTRL_DIAG_GET_LOCK_METER_STATE_PARAMS
class struct_NV0000_CTRL_DIAG_SET_LOCK_METER_STATE_PARAMS(Structure):
    pass

struct_NV0000_CTRL_DIAG_SET_LOCK_METER_STATE_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_DIAG_SET_LOCK_METER_STATE_PARAMS._fields_ = [
    ('state', ctypes.c_uint32),
    ('bCircularBuffer', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV0000_CTRL_DIAG_SET_LOCK_METER_STATE_PARAMS = struct_NV0000_CTRL_DIAG_SET_LOCK_METER_STATE_PARAMS
class struct_NV0000_CTRL_DIAG_LOCK_METER_ENTRY(Structure):
    pass

struct_NV0000_CTRL_DIAG_LOCK_METER_ENTRY._pack_ = 1 # source:False
struct_NV0000_CTRL_DIAG_LOCK_METER_ENTRY._fields_ = [
    ('counter', ctypes.c_uint64),
    ('line', ctypes.c_uint32),
    ('filename', ctypes.c_ubyte * 12),
    ('tag', ctypes.c_uint16),
    ('cpuNum', ctypes.c_ubyte),
    ('irql', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('threadId', ctypes.c_uint64),
    ('data0', ctypes.c_uint32),
    ('data1', ctypes.c_uint32),
    ('data2', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

NV0000_CTRL_DIAG_LOCK_METER_ENTRY = struct_NV0000_CTRL_DIAG_LOCK_METER_ENTRY
class struct_NV0000_CTRL_DIAG_GET_LOCK_METER_ENTRIES_PARAMS(Structure):
    pass

struct_NV0000_CTRL_DIAG_GET_LOCK_METER_ENTRIES_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_DIAG_GET_LOCK_METER_ENTRIES_PARAMS._fields_ = [
    ('entryCount', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('entries', struct_NV0000_CTRL_DIAG_LOCK_METER_ENTRY * 64),
]

NV0000_CTRL_DIAG_GET_LOCK_METER_ENTRIES_PARAMS = struct_NV0000_CTRL_DIAG_GET_LOCK_METER_ENTRIES_PARAMS
class struct_RPC_METER_ENTRY(Structure):
    pass

struct_RPC_METER_ENTRY._pack_ = 1 # source:False
struct_RPC_METER_ENTRY._fields_ = [
    ('startTimeInNs', ctypes.c_uint64),
    ('endTimeInNs', ctypes.c_uint64),
    ('rpcDataTag', ctypes.c_uint64),
    ('rpcExtraData', ctypes.c_uint64),
]

RPC_METER_ENTRY = struct_RPC_METER_ENTRY
class struct_NV0000_CTRL_DIAG_PROFILE_RPC_PARAMS(Structure):
    pass

struct_NV0000_CTRL_DIAG_PROFILE_RPC_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_DIAG_PROFILE_RPC_PARAMS._fields_ = [
    ('rpcProfileCmd', ctypes.c_uint32),
]

NV0000_CTRL_DIAG_PROFILE_RPC_PARAMS = struct_NV0000_CTRL_DIAG_PROFILE_RPC_PARAMS
class struct_NV0000_CTRL_DIAG_DUMP_RPC_PARAMS(Structure):
    pass

struct_NV0000_CTRL_DIAG_DUMP_RPC_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_DIAG_DUMP_RPC_PARAMS._fields_ = [
    ('firstEntryOffset', ctypes.c_uint32),
    ('outputEntryCount', ctypes.c_uint32),
    ('remainingEntryCount', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('elapsedTimeInNs', ctypes.c_uint64),
    ('rpcProfilerBuffer', struct_RPC_METER_ENTRY * 100),
]

NV0000_CTRL_DIAG_DUMP_RPC_PARAMS = struct_NV0000_CTRL_DIAG_DUMP_RPC_PARAMS
NV0000_CTRL_CMD_EVENT_SET_NOTIFICATION = (0x501) # macro
NV0000_CTRL_EVENT_SET_NOTIFICATION_PARAMS_MESSAGE_ID = (0x1) # macro
NV0000_CTRL_EVENT_SET_NOTIFICATION_ACTION_DISABLE = (0x00000000) # macro
NV0000_CTRL_EVENT_SET_NOTIFICATION_ACTION_SINGLE = (0x00000001) # macro
NV0000_CTRL_EVENT_SET_NOTIFICATION_ACTION_REPEAT = (0x00000002) # macro
NV0000_CTRL_CMD_GET_SYSTEM_EVENT_STATUS = (0x502) # macro
NV0000_CTRL_GET_SYSTEM_EVENT_STATUS_PARAMS_MESSAGE_ID = (0x2) # macro
class struct_NV0000_CTRL_EVENT_SET_NOTIFICATION_PARAMS(Structure):
    pass

struct_NV0000_CTRL_EVENT_SET_NOTIFICATION_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_EVENT_SET_NOTIFICATION_PARAMS._fields_ = [
    ('event', ctypes.c_uint32),
    ('action', ctypes.c_uint32),
]

NV0000_CTRL_EVENT_SET_NOTIFICATION_PARAMS = struct_NV0000_CTRL_EVENT_SET_NOTIFICATION_PARAMS
class struct_NV0000_CTRL_GET_SYSTEM_EVENT_STATUS_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GET_SYSTEM_EVENT_STATUS_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GET_SYSTEM_EVENT_STATUS_PARAMS._fields_ = [
    ('event', ctypes.c_uint32),
    ('status', ctypes.c_uint32),
]

NV0000_CTRL_GET_SYSTEM_EVENT_STATUS_PARAMS = struct_NV0000_CTRL_GET_SYSTEM_EVENT_STATUS_PARAMS
NV0000_CTRL_CMD_SYSTEM_GET_FEATURES = (0x1f0) # macro
NV0000_CTRL_SYSTEM_GET_FEATURES_PARAMS_MESSAGE_ID = (0xF0) # macro
NV0000_CTRL_SYSTEM_GET_FEATURES_SLI = ['0', ':', '0'] # macro
NV0000_CTRL_SYSTEM_GET_FEATURES_SLI_FALSE = (0x00000000) # macro
NV0000_CTRL_SYSTEM_GET_FEATURES_SLI_TRUE = (0x00000001) # macro
NV0000_CTRL_SYSTEM_GET_FEATURES_UEFI = ['1', ':', '1'] # macro
NV0000_CTRL_SYSTEM_GET_FEATURES_UEFI_FALSE = (0x00000000) # macro
NV0000_CTRL_SYSTEM_GET_FEATURES_UEFI_TRUE = (0x00000001) # macro
NV0000_CTRL_SYSTEM_GET_FEATURES_IS_EFI_INIT = ['2', ':', '2'] # macro
NV0000_CTRL_SYSTEM_GET_FEATURES_IS_EFI_INIT_FALSE = (0x00000000) # macro
NV0000_CTRL_SYSTEM_GET_FEATURES_IS_EFI_INIT_TRUE = (0x00000001) # macro
NV0000_CTRL_SYSTEM_GET_FEATURES_UUID_BASED_MEM_SHARING = ['3', ':', '3'] # macro
NV0000_CTRL_SYSTEM_GET_FEATURES_UUID_BASED_MEM_SHARING_FALSE = (0x00000000) # macro
NV0000_CTRL_SYSTEM_GET_FEATURES_UUID_BASED_MEM_SHARING_TRUE = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_GET_BUILD_VERSION = (0x101) # macro
NV0000_CTRL_SYSTEM_GET_BUILD_VERSION_PARAMS_MESSAGE_ID = (0x1) # macro
NV0000_CTRL_CMD_SYSTEM_GET_CPU_INFO = (0x102) # macro
NV0000_CTRL_SYSTEM_GET_CPU_INFO_PARAMS_MESSAGE_ID = (0x2) # macro
NV0000_CTRL_SYSTEM_CPU_FAMILY = ['3', ':', '0'] # macro
NV0000_CTRL_SYSTEM_CPU_EXTENDED_FAMILY = ['11', ':', '4'] # macro
NV0000_CTRL_SYSTEM_CPU_MODEL = ['3', ':', '0'] # macro
NV0000_CTRL_SYSTEM_CPU_EXTENDED_MODEL = ['7', ':', '4'] # macro
NV0000_CTRL_SYSTEM_CPU_ID_AMD_FAMILY = 0xF # macro
NV0000_CTRL_SYSTEM_CPU_ID_AMD_EXTENDED_FAMILY = 0xA # macro
NV0000_CTRL_SYSTEM_CPU_ID_AMD_MODEL = 0x0 # macro
NV0000_CTRL_SYSTEM_CPU_ID_AMD_EXTENDED_MODEL = 0x4 # macro
NV0000_CTRL_SYSTEM_CPU_ID_INTEL_FAMILY = 0x6 # macro
NV0000_CTRL_SYSTEM_CPU_ID_INTEL_EXTENDED_FAMILY = 0x0 # macro
NV0000_CTRL_SYSTEM_CPU_ID_INTEL_CORE_S_MODEL = 0x7 # macro
NV0000_CTRL_SYSTEM_CPU_ID_INTEL_CORE_P_MODEL = 0xA # macro
NV0000_CTRL_SYSTEM_CPU_ID_INTEL_EXTENDED_MODEL = 0x9 # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_UNKNOWN = (0x00000000) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_P5 = (0x00000001) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_P55 = (0x00000002) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_P6 = (0x00000003) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_P2 = (0x00000004) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_P2XC = (0x00000005) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_CELA = (0x00000006) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_P3 = (0x00000007) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_P3_INTL2 = (0x00000008) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_P4 = (0x00000009) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_CORE2 = (0x00000010) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_CELN_M16H = (0x00000011) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_CORE2_EXTRM = (0x00000012) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_ATOM = (0x00000013) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_XEON_SPR = (0x00000014) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_K5 = (0x00000030) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_K6 = (0x00000031) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_K62 = (0x00000032) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_K63 = (0x00000033) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_K7 = (0x00000034) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_K8 = (0x00000035) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_K10 = (0x00000036) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_K11 = (0x00000037) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_RYZEN = (0x00000038) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_C6 = (0x00000060) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_C62 = (0x00000061) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_GX = (0x00000070) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_M1 = (0x00000071) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_M2 = (0x00000072) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_MGX = (0x00000073) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_TM_CRUSOE = (0x00000080) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_PPC603 = (0x00000090) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_PPC604 = (0x00000091) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_PPC750 = (0x00000092) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_POWERN = (0x00000093) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_ARM_UNKNOWN = (0xA0000000) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_ARM_A9 = (0xA0000009) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_ARM_A15 = (0xA000000F) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_NV_DENVER_1_0 = (0xA0001000) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_NV_DENVER_2_0 = (0xA0002000) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_ARMV8A_GENERIC = (0xA00FF000) # macro
NV0000_CTRL_SYSTEM_CPU_TYPE_ARMV9A_GENERIC = (0xA00FF001) # macro
NV0000_CTRL_SYSTEM_CPU_CAP_MMX = (0x00000001) # macro
NV0000_CTRL_SYSTEM_CPU_CAP_SSE = (0x00000002) # macro
NV0000_CTRL_SYSTEM_CPU_CAP_3DNOW = (0x00000004) # macro
NV0000_CTRL_SYSTEM_CPU_CAP_SSE2 = (0x00000008) # macro
NV0000_CTRL_SYSTEM_CPU_CAP_SFENCE = (0x00000010) # macro
NV0000_CTRL_SYSTEM_CPU_CAP_WRITE_COMBINING = (0x00000020) # macro
NV0000_CTRL_SYSTEM_CPU_CAP_ALTIVEC = (0x00000040) # macro
NV0000_CTRL_SYSTEM_CPU_CAP_PUT_NEEDS_IO = (0x00000080) # macro
NV0000_CTRL_SYSTEM_CPU_CAP_NEEDS_WC_WORKAROUND = (0x00000100) # macro
NV0000_CTRL_SYSTEM_CPU_CAP_3DNOW_EXT = (0x00000200) # macro
NV0000_CTRL_SYSTEM_CPU_CAP_MMX_EXT = (0x00000400) # macro
NV0000_CTRL_SYSTEM_CPU_CAP_CMOV = (0x00000800) # macro
NV0000_CTRL_SYSTEM_CPU_CAP_CLFLUSH = (0x00001000) # macro
NV0000_CTRL_SYSTEM_CPU_CAP_NEEDS_WAR_190854 = (0x00002000) # macro
NV0000_CTRL_SYSTEM_CPU_CAP_SSE3 = (0x00004000) # macro
NV0000_CTRL_SYSTEM_CPU_CAP_NEEDS_WAR_124888 = (0x00008000) # macro
NV0000_CTRL_SYSTEM_CPU_CAP_HT_CAPABLE = (0x00010000) # macro
NV0000_CTRL_SYSTEM_CPU_CAP_SSE41 = (0x00020000) # macro
NV0000_CTRL_SYSTEM_CPU_CAP_SSE42 = (0x00040000) # macro
NV0000_CTRL_SYSTEM_CPU_CAP_AVX = (0x00080000) # macro
NV0000_CTRL_SYSTEM_CPU_CAP_ERMS = (0x00100000) # macro
NV0000_CTRL_CMD_SYSTEM_GET_CHIPSET_INFO = (0x104) # macro
NV0000_SYSTEM_MAX_CHIPSET_STRING_LENGTH = (0x0000020) # macro
NV0000_SYSTEM_CHIPSET_INVALID_ID = (0xffff) # macro
NV0000_CTRL_SYSTEM_GET_CHIPSET_INFO_PARAMS_MESSAGE_ID = (0x4) # macro
NV0000_CTRL_SYSTEM_CHIPSET_FLAG_HAS_RESIZABLE_BAR_ISSUE = ['0', ':', '0'] # macro
NV0000_CTRL_SYSTEM_CHIPSET_FLAG_HAS_RESIZABLE_BAR_ISSUE_NO = (0x00000000) # macro
NV0000_CTRL_SYSTEM_CHIPSET_FLAG_HAS_RESIZABLE_BAR_ISSUE_YES = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_GET_LOCK_TIMES = (0x109) # macro
NV0000_CTRL_SYSTEM_GET_LOCK_TIMES_PARAMS_MESSAGE_ID = (0x9) # macro
NV0000_CTRL_CMD_SYSTEM_GET_CLASSLIST = (0x108) # macro
NV0000_CTRL_SYSTEM_MAX_CLASSLIST_SIZE = (32) # macro
NV0000_CTRL_SYSTEM_GET_CLASSLIST_PARAMS_MESSAGE_ID = (0x8) # macro
NV0000_CTRL_CMD_SYSTEM_NOTIFY_EVENT = (0x110) # macro
NV0000_CTRL_SYSTEM_NOTIFY_EVENT_PARAMS_MESSAGE_ID = (0x10) # macro
NV0000_CTRL_SYSTEM_EVENT_TYPE_LID_STATE = (0x00000000) # macro
NV0000_CTRL_SYSTEM_EVENT_TYPE_POWER_SOURCE = (0x00000001) # macro
NV0000_CTRL_SYSTEM_EVENT_TYPE_DOCK_STATE = (0x00000002) # macro
NV0000_CTRL_SYSTEM_EVENT_TYPE_TRUST_LID = (0x00000003) # macro
NV0000_CTRL_SYSTEM_EVENT_TYPE_TRUST_DOCK = (0x00000004) # macro
NV0000_CTRL_SYSTEM_EVENT_DATA_LID_OPEN = (0x00000000) # macro
NV0000_CTRL_SYSTEM_EVENT_DATA_LID_CLOSED = (0x00000001) # macro
NV0000_CTRL_SYSTEM_EVENT_DATA_POWER_BATTERY = (0x00000000) # macro
NV0000_CTRL_SYSTEM_EVENT_DATA_POWER_AC = (0x00000001) # macro
NV0000_CTRL_SYSTEM_EVENT_DATA_UNDOCKED = (0x00000000) # macro
NV0000_CTRL_SYSTEM_EVENT_DATA_DOCKED = (0x00000001) # macro
NV0000_CTRL_SYSTEM_EVENT_DATA_TRUST_LID_DSM = (0x00000000) # macro
NV0000_CTRL_SYSTEM_EVENT_DATA_TRUST_LID_DCS = (0x00000001) # macro
NV0000_CTRL_SYSTEM_EVENT_DATA_TRUST_LID_NVIF = (0x00000002) # macro
NV0000_CTRL_SYSTEM_EVENT_DATA_TRUST_LID_ACPI = (0x00000003) # macro
NV0000_CTRL_SYSTEM_EVENT_DATA_TRUST_LID_POLL = (0x00000004) # macro
NV0000_CTRL_SYSTEM_EVENT_DATA_TRUST_LID_COUNT = (0x5) # macro
NV0000_CTRL_SYSTEM_EVENT_DATA_TRUST_DOCK_DSM = (0x00000000) # macro
NV0000_CTRL_SYSTEM_EVENT_DATA_TRUST_DOCK_DCS = (0x00000001) # macro
NV0000_CTRL_SYSTEM_EVENT_DATA_TRUST_DOCK_NVIF = (0x00000002) # macro
NV0000_CTRL_SYSTEM_EVENT_DATA_TRUST_DOCK_ACPI = (0x00000003) # macro
NV0000_CTRL_SYSTEM_EVENT_DATA_TRUST_DOCK_POLL = (0x00000004) # macro
NV0000_CTRL_SYSTEM_EVENT_DATA_TRUST_DOCK_COUNT = (0x5) # macro
NV0000_CTRL_SYSTEM_EVENT_DATA_FORCED_FALSE = (0x00000000) # macro
NV0000_CTRL_SYSTEM_EVENT_DATA_FORCED_TRUE = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_GET_PLATFORM_TYPE = (0x111) # macro
NV0000_CTRL_CMD_SYSTEM_GET_PLATFORM_TYPE_PARAMS_MESSAGE_ID = (0x11) # macro
NV0000_CTRL_SYSTEM_GET_PLATFORM_TYPE_DESKTOP = (0x000000) # macro
NV0000_CTRL_SYSTEM_GET_PLATFORM_TYPE_MOBILE_GENERIC = (0x000001) # macro
NV0000_CTRL_SYSTEM_GET_PLATFORM_TYPE_MOBILE_TOSHIBA = (0x000002) # macro
NV0000_CTRL_SYSTEM_GET_PLATFORM_TYPE_SOC = (0x000003) # macro
NV0000_CTRL_CMD_SYSTEM_DEBUG_RMMSG_CTRL = (0x121) # macro
NV0000_CTRL_SYSTEM_DEBUG_RMMSG_SIZE = 512 # macro
NV0000_CTRL_SYSTEM_DEBUG_RMMSG_CTRL_CMD_GET = (0x00000000) # macro
NV0000_CTRL_SYSTEM_DEBUG_RMMSG_CTRL_CMD_SET = (0x00000001) # macro
NV0000_CTRL_SYSTEM_DEBUG_RMMSG_CTRL_PARAMS_MESSAGE_ID = (0x21) # macro
NV0000_CTRL_SYSTEM_HWBC_INVALID_ID = (0xFFFFFFFF) # macro
NV0000_CTRL_CMD_SYSTEM_GET_HWBC_INFO = (0x124) # macro
NV0000_CTRL_SYSTEM_MAX_HWBCS = (0x00000080) # macro
NV0000_CTRL_SYSTEM_GET_HWBC_INFO_PARAMS_MESSAGE_ID = (0x24) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CONTROL = (0x122) # macro
NV0000_CTRL_SYSTEM_GPS_CONTROL_PARAMS_MESSAGE_ID = (0x22) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_INVALID = (0xFFFF) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_GET_INIT = (0x0000) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_SET_EXEC = (0x0001) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_GET_EXEC = (0x0002) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_SET_ACTIONS = (0x0003) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_GET_ACTIONS = (0x0004) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_SET_LOGIC = (0x0005) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_GET_LOGIC = (0x0006) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_SET_PREFERENCE = (0x0007) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_GET_PREFERENCE = (0x0008) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_SET_GPU2CPU_LIMIT = (0x0009) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_GET_GPU2CPU_LIMIT = (0x000A) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_SET_PMU_GPS_STATE = (0x000B) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_GET_PMU_GPS_STATE = (0x000C) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_SET_MAX_POWER = (0x0100) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_GET_MAX_POWER = (0x0101) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_SET_COOLING_BUDGET = (0x0102) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_GET_COOLING_BUDGET = (0x0103) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_SET_INTEGRAL_PERIOD = (0x0104) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_GET_INTEGRAL_PERIOD = (0x0105) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_SET_RULESET = (0x0106) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_GET_RULESET = (0x0107) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_GET_RULE_COUNT = (0x0108) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_SET_APP_BOOST = (0x0109) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_GET_APP_BOOST = (0x010A) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_SET_PWR_SUPPLY_MODE = (0x010B) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_GET_PWR_SUPPLY_MODE = (0x010C) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_GET_VCT_SUPPORT_INFO = (0x010D) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_GET_SUPPORTED_FUNCTIONS = (0x010E) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_GET_POWER = (0x0200) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_GET_POWER_DELTA = (0x0201) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_GET_POWER_FUTURE = (0x0202) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_GET_POWER_LTMAVG = (0x0203) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_GET_POWER_INTEGRAL = (0x0204) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_GET_POWER_BURDEN = (0x0205) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_GET_POWER_INTERMEDIATE = (0x0206) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_GET_SENSOR_PARAMETERS = (0x0210) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_GET_TEMP = (0x0220) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_GET_TEMP_DELTA = (0x0221) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_GET_TEMP_FUTURE = (0x0222) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_GET_PSTATE = (0x0240) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_GET_PSTATE_CAP = (0x0241) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_GET_PSTATE_MIN = (0x0242) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_GET_PSTATE_MAX = (0x0243) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_GET_PSTATE_ACTION = (0x0244) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_GET_PSTATE_SLFM_PRESENT = (0x0245) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_SET_POWER_SIM_STATE = (0x0250) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_GET_POWER_SIM_STATE = (0x0251) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_SET_POWER_SIM_DATA = (0x0252) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_GET_POWER_SIM_DATA = (0x0253) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_INIT_USING_SBIOS_AND_ACK = (0x0320) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_PING_SBIOS_FOR_EVENT = (0x0321) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_LOCALE_INVALID = (0xFFFF) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_LOCALE_SYSTEM = (0x0000) # macro
# def NV0000_CTRL_CMD_SYSTEM_GPS_LOCALE_CPU(i):  # macro
#    return (0x0100+((i)%0x100))
# def NV0000_CTRL_CMD_SYSTEM_GPS_LOCALE_GPU(i):  # macro
#    return (0x0200+((i)%0x100))
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_DEF_INVALID = (0x80000000) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_DEF_INIT_NO = (0x00000000) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_DEF_INIT_YES = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_DEF_EXEC_STOP = (0x00000000) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_DEF_EXEC_START = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_DEF_ACTIONS_OFF = (0x00000000) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_DEF_ACTIONS_ON = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_DEF_LOGIC_OFF = (0x00000000) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_DEF_LOGIC_FUZZY = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_DEF_LOGIC_DETERMINISTIC = (0x00000002) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_DEF_PREFERENCE_CPU = (0x00000000) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_DEF_PREFERENCE_GPU = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_DEF_PREFERENCE_BOTH = (0x00000002) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_DEF_NO_MAP_OVERRIDE = (0xFFFFFFFF) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_DEF_PMU_GPS_STATE_OFF = (0x00000000) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CMD_DEF_PMU_GPS_STATE_ON = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_DEF_PWR_SUPPLY_REAL = (0x00000000) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_DEF_PWR_SUPPLY_FAKE_AC = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_DEF_PWR_SUPPLY_FAKE_BATT = (0x00000002) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_DEF_FUNC_SUPPORT = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_DEF_FUNC_VENTURASTATUS = (0x00000002) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_DEF_FUNC_GETPSS = (0x00000004) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_DEF_FUNC_SETPPC = (0x00000008) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_DEF_FUNC_GETPPC = (0x00000010) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_DEF_FUNC_VENTURACB = (0x00000020) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SYS_DEF_FUNC_SYSPARAMS = (0x00000040) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_DEF_ACTION_DEC_TO_P0 = (0x00000000) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_DEF_ACTION_DEC_BY_1 = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_DEF_ACTION_DO_NOTHING = (0x00000002) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_DEF_ACTION_SET_CURRENT = (0x00000003) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_DEF_ACTION_INC_BY_1 = (0x00000004) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_DEF_ACTION_INC_BY_2 = (0x00000005) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_DEF_ACTION_INC_TO_LFM = (0x00000006) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_DEF_ACTION_INC_TO_SLFM = (0x00000007) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_DEF_SLFM_PRESENT_NO = (0x00000000) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_DEF_SLFM_PRESENT_YES = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_DEF_POWER_SIM_STATE_OFF = (0x00000000) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_DATA_DEF_POWER_SIM_STATE_ON = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_BATCH_CONTROL = (0x123) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_BATCH_COMMAND_MAX = (16) # macro
NV0000_CTRL_SYSTEM_GPS_BATCH_CONTROL_PARAMS_MESSAGE_ID = (0x23) # macro
NV0000_CTRL_CMD_SYSTEM_GET_P2P_CAPS = (0x127) # macro
NV0000_CTRL_SYSTEM_MAX_ATTACHED_GPUS = 32 # macro
NV0000_CTRL_SYSTEM_MAX_ATTACHED_GPUS_SQUARED = 1024 # macro
NV0000_CTRL_SYSTEM_MAX_P2P_GROUP_GPUS = 8 # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_INVALID_PEER = 0xffffffff # macro
NV0000_CTRL_P2P_CAPS_INDEX_READ = 0 # macro
NV0000_CTRL_P2P_CAPS_INDEX_WRITE = 1 # macro
NV0000_CTRL_P2P_CAPS_INDEX_NVLINK = 2 # macro
NV0000_CTRL_P2P_CAPS_INDEX_ATOMICS = 3 # macro
NV0000_CTRL_P2P_CAPS_INDEX_PROP = 4 # macro
NV0000_CTRL_P2P_CAPS_INDEX_LOOPBACK = 5 # macro
NV0000_CTRL_P2P_CAPS_INDEX_PCI = 6 # macro
NV0000_CTRL_P2P_CAPS_INDEX_C2C = 7 # macro
NV0000_CTRL_P2P_CAPS_INDEX_PCI_BAR1 = 8 # macro
NV0000_CTRL_P2P_CAPS_INDEX_TABLE_SIZE = 9 # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_PARAMS_MESSAGE_ID = (0x27) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_WRITES_SUPPORTED = ['0', ':', '0'] # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_WRITES_SUPPORTED_FALSE = (0x00000000) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_WRITES_SUPPORTED_TRUE = (0x00000001) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_READS_SUPPORTED = ['1', ':', '1'] # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_READS_SUPPORTED_FALSE = (0x00000000) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_READS_SUPPORTED_TRUE = (0x00000001) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_PROP_SUPPORTED = ['2', ':', '2'] # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_PROP_SUPPORTED_FALSE = (0x00000000) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_PROP_SUPPORTED_TRUE = (0x00000001) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_NVLINK_SUPPORTED = ['3', ':', '3'] # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_NVLINK_SUPPORTED_FALSE = (0x00000000) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_NVLINK_SUPPORTED_TRUE = (0x00000001) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_ATOMICS_SUPPORTED = ['4', ':', '4'] # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_ATOMICS_SUPPORTED_FALSE = (0x00000000) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_ATOMICS_SUPPORTED_TRUE = (0x00000001) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_LOOPBACK_SUPPORTED = ['5', ':', '5'] # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_LOOPBACK_SUPPORTED_FALSE = (0x00000000) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_LOOPBACK_SUPPORTED_TRUE = (0x00000001) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_PCI_SUPPORTED = ['6', ':', '6'] # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_PCI_SUPPORTED_FALSE = (0x00000000) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_PCI_SUPPORTED_TRUE = (0x00000001) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_INDIRECT_WRITES_SUPPORTED = ['7', ':', '7'] # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_INDIRECT_WRITES_SUPPORTED_FALSE = (0x00000000) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_INDIRECT_WRITES_SUPPORTED_TRUE = (0x00000001) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_INDIRECT_READS_SUPPORTED = ['8', ':', '8'] # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_INDIRECT_READS_SUPPORTED_FALSE = (0x00000000) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_INDIRECT_READS_SUPPORTED_TRUE = (0x00000001) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_INDIRECT_ATOMICS_SUPPORTED = ['9', ':', '9'] # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_INDIRECT_ATOMICS_SUPPORTED_FALSE = (0x00000000) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_INDIRECT_ATOMICS_SUPPORTED_TRUE = (0x00000001) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_INDIRECT_NVLINK_SUPPORTED = ['10', ':', '10'] # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_INDIRECT_NVLINK_SUPPORTED_FALSE = (0x00000000) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_INDIRECT_NVLINK_SUPPORTED_TRUE = (0x00000001) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_C2C_SUPPORTED = ['12', ':', '12'] # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_C2C_SUPPORTED_FALSE = (0x00000000) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_C2C_SUPPORTED_TRUE = (0x00000001) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_PCI_BAR1_SUPPORTED = ['13', ':', '13'] # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_PCI_BAR1_SUPPORTED_FALSE = (0x00000000) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_PCI_BAR1_SUPPORTED_TRUE = (0x00000001) # macro
NV0000_P2P_CAPS_STATUS_OK = (0x00) # macro
NV0000_P2P_CAPS_STATUS_CHIPSET_NOT_SUPPORTED = (0x01) # macro
NV0000_P2P_CAPS_STATUS_GPU_NOT_SUPPORTED = (0x02) # macro
NV0000_P2P_CAPS_STATUS_IOH_TOPOLOGY_NOT_SUPPORTED = (0x03) # macro
NV0000_P2P_CAPS_STATUS_DISABLED_BY_REGKEY = (0x04) # macro
NV0000_P2P_CAPS_STATUS_NOT_SUPPORTED = (0x05) # macro
NV0000_CTRL_CMD_SYSTEM_GET_P2P_CAPS_V2 = (0x12b) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_V2_PARAMS_MESSAGE_ID = (0x2B) # macro
NV0000_CTRL_CMD_SYSTEM_GET_P2P_CAPS_MATRIX = (0x13a) # macro
NV0000_CTRL_SYSTEM_GET_P2P_CAPS_MATRIX_PARAMS_MESSAGE_ID = (0x3A) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CTRL = (0x12a) # macro
NV0000_CTRL_SYSTEM_GPS_CTRL_PARAMS_MESSAGE_ID = (0x2A) # macro
NV0000_CTRL_GPS_PSHARE_PARAMS_PSP_CURRENT_VERSION = (0x00010000) # macro
NV0000_CTRL_GPS_CMD_TYPE_GET_THERM_LIMIT = (0x00000002) # macro
NV0000_CTRL_GPS_INPUT_SENSOR_INDEX = (0x00000000) # macro
NV0000_CTRL_GPS_RESULT_THERMAL_LIMIT = (0x00000000) # macro
NV0000_CTRL_GPS_RESULT_MIN_LIMIT = (0x00000001) # macro
NV0000_CTRL_GPS_RESULT_MAX_LIMIT = (0x00000002) # macro
NV0000_CTRL_GPS_RESULT_LIMIT_SOURCE = (0x00000003) # macro
NV0000_CTRL_GPS_CMD_TYPE_SET_THERM_LIMIT = (0x00000003) # macro
NV0000_CTRL_GPS_INPUT_THERMAL_LIMIT = (0x00000001) # macro
NV0000_CTRL_GPS_CMD_TYPE_GET_TEMP_CTRL_DOWN_N_DELTA = (0x00000004) # macro
NV0000_CTRL_GPS_RESULT_TEMP_CTRL_DOWN_N_DELTA = (0x00000000) # macro
NV0000_CTRL_GPS_CMD_TYPE_SET_TEMP_CTRL_DOWN_N_DELTA = (0x00000005) # macro
NV0000_CTRL_GPS_INPUT_TEMP_CTRL_DOWN_N_DELTA = (0x00000001) # macro
NV0000_CTRL_GPS_CMD_TYPE_GET_TEMP_CTRL_HOLD_DELTA = (0x00000006) # macro
NV0000_CTRL_GPS_RESULT_TEMP_CTRL_HOLD_DELTA = (0x00000000) # macro
NV0000_CTRL_GPS_CMD_TYPE_SET_TEMP_CTRL_HOLD_DELTA = (0x00000007) # macro
NV0000_CTRL_GPS_INPUT_TEMP_CTRL_HOLD_DELTA = (0x00000001) # macro
NV0000_CTRL_GPS_CMD_TYPE_GET_TEMP_CTRL_UP_DELTA = (0x00000008) # macro
NV0000_CTRL_GPS_RESULT_TEMP_CTRL_UP_DELTA = (0x00000000) # macro
NV0000_CTRL_GPS_CMD_TYPE_SET_TEMP_CTRL_UP_DELTA = (0x00000009) # macro
NV0000_CTRL_GPS_INPUT_TEMP_CTRL_UP_DELTA = (0x00000001) # macro
NV0000_CTRL_GPS_CMD_TYPE_GET_TEMP_CTRL_ENGAGE_DELTA = (0x0000000A) # macro
NV0000_CTRL_GPS_RESULT_TEMP_CTRL_ENGAGE_DELTA = (0x00000000) # macro
NV0000_CTRL_GPS_CMD_TYPE_SET_TEMP_CTRL_ENGAGE_DELTA = (0x0000000B) # macro
NV0000_CTRL_GPS_INPUT_TEMP_CTRL_ENGAGE_DELTA = (0x00000001) # macro
NV0000_CTRL_GPS_CMD_TYPE_GET_TEMP_CTRL_DISENGAGE_DELTA = (0x0000000C) # macro
NV0000_CTRL_GPS_RESULT_TEMP_CTRL_DISENGAGE_DELTA = (0x00000000) # macro
NV0000_CTRL_GPS_CMD_TYPE_SET_TEMP_CTRL_DISENGAGE_DELTA = (0x0000000D) # macro
NV0000_CTRL_GPS_INPUT_TEMP_CTRL_DISENGAGE_DELTA = (0x00000000) # macro
NV0000_CTRL_GPS_CMD_TYPE_GET_TEMP_CTRL_STATUS = (0x00000016) # macro
NV0000_CTRL_GPS_RESULT_TEMP_CTRL_STATUS = (0x00000000) # macro
NV0000_CTRL_GPS_CMD_TYPE_SET_TEMP_CTRL_STATUS = (0x00000017) # macro
NV0000_CTRL_GPS_INPUT_TEMP_CTRL_STATUS = (0x00000000) # macro
NV0000_CTRL_GPS_CMD_TYPE_GET_CPU_GET_UTIL_AVG_NUM = (0x00000018) # macro
NV0000_CTRL_GPS_RESULT_CPU_SET_UTIL_AVG_NUM = (0x00000000) # macro
NV0000_CTRL_GPS_CMD_TYPE_SET_CPU_SET_UTIL_AVG_NUM = (0x00000019) # macro
NV0000_CTRL_GPS_INPUT_CPU_GET_UTIL_AVG_NUM = (0x00000000) # macro
NV0000_CTRL_GPS_CMD_TYPE_GET_PERF_SENSOR = (0x0000001A) # macro
NV0000_CTRL_GPS_INPUT_NEXT_EXPECTED_POLL = (0x00000001) # macro
NV0000_CTRL_GPS_RESULT_PERF_SENSOR_VALUE = (0x00000000) # macro
NV0000_CTRL_GPS_RESULT_PERF_SENSOR_AVAILABLE = (0x00000001) # macro
NV0000_CTRL_GPS_CMD_TYPE_CALL_ACPI = (0x0000001B) # macro
NV0000_CTRL_GPS_INPUT_ACPI_CMD = (0x00000000) # macro
NV0000_CTRL_GPS_INPUT_ACPI_PARAM_IN = (0x00000001) # macro
NV0000_CTRL_GPS_OUTPUT_ACPI_RESULT_1 = (0x00000000) # macro
NV0000_CTRL_GPS_OUTPUT_ACPI_RESULT_2 = (0x00000001) # macro
NV0000_CTRL_GPS_OUTPUT_ACPI_PSHAREPARAM_STATUS = (0x00000000) # macro
NV0000_CTRL_GPS_OUTPUT_ACPI_PSHAREPARAM_VERSION = (0x00000001) # macro
NV0000_CTRL_GPS_OUTPUT_ACPI_PSHAREPARAM_SZ = (0x00000002) # macro
NV0000_CTRL_GPS_OUTPUT_ACPI_PSS_SZ = (0x00000000) # macro
NV0000_CTRL_GPS_OUTPUT_ACPI_PSS_COUNT = (0x00000001) # macro
NV0000_CTRL_GPS_CMD_TYPE_SET_IGPU_TURBO = (0x0000001C) # macro
NV0000_CTRL_GPS_INPUT_SET_IGPU_TURBO = (0x00000000) # macro
NV0000_CTRL_GPS_CMD_TYPE_SET_TEMP_PERIOD = (0x00000026) # macro
NV0000_CTRL_GPS_INPUT_TEMP_PERIOD = (0x00000000) # macro
NV0000_CTRL_GPS_CMD_TYPE_GET_TEMP_PERIOD = (0x00000027) # macro
NV0000_CTRL_GPS_RESULT_TEMP_PERIOD = (0x00000000) # macro
NV0000_CTRL_GPS_CMD_TYPE_SET_TEMP_NUDGE_FACTOR = (0x00000028) # macro
NV0000_CTRL_GPS_INPUT_TEMP_NUDGE_UP = (0x00000000) # macro
NV0000_CTRL_GPS_INPUT_TEMP_NUDGE_DOWN = (0x00000001) # macro
NV0000_CTRL_GPS_CMD_TYPE_GET_TEMP_NUDGE_FACTOR = (0x00000029) # macro
NV0000_CTRL_GPS_RESULT_TEMP_NUDGE_UP = (0x00000000) # macro
NV0000_CTRL_GPS_RESULT_TEMP_NUDGE_DOWN = (0x00000001) # macro
NV0000_CTRL_GPS_CMD_TYPE_SET_TEMP_THRESHOLD_SAMPLES = (0x0000002A) # macro
NV0000_CTRL_GPS_INPUT_TEMP_THRESHOLD_SAMPLE_HOLD = (0x00000000) # macro
NV0000_CTRL_GPS_INPUT_TEMP_THRESHOLD_SAMPLE_STEP = (0x00000001) # macro
NV0000_CTRL_GPS_CMD_TYPE_GET_TEMP_THRESHOLD_SAMPLES = (0x0000002B) # macro
NV0000_CTRL_GPS_RESULT_TEMP_THRESHOLD_SAMPLE_HOLD = (0x00000000) # macro
NV0000_CTRL_GPS_RESULT_TEMP_THRESHOLD_SAMPLE_STEP = (0x00000001) # macro
NV0000_CTRL_GPS_CMD_TYPE_SET_TEMP_PERF_LIMITS = (0x0000002C) # macro
NV0000_CTRL_GPS_INPUT_TEMP_PERF_LIMIT_UPPER = (0x00000000) # macro
NV0000_CTRL_GPS_INPUT_TEMP_PERF_LIMIT_LOWER = (0x00000001) # macro
NV0000_CTRL_GPS_CMD_TYPE_GET_TEMP_PERF_LIMITS = (0x0000002D) # macro
NV0000_CTRL_GPS_RESULT_TEMP_PERF_LIMIT_UPPER = (0x00000000) # macro
NV0000_CTRL_GPS_RESULT_TEMP_PERF_LIMIT_LOWER = (0x00000001) # macro
NV0000_CTRL_GPS_CMD_TYPE_SET_PM1_AVAILABLE = (0x0000002E) # macro
NV0000_CTRL_GPS_INPUT_PM1_AVAILABLE = (0x00000000) # macro
NV0000_CTRL_GPS_CMD_TYPE_GET_PM1_AVAILABLE = (0x0000002F) # macro
NV0000_CTRL_GPS_OUTPUT_PM1_AVAILABLE = (0x00000000) # macro
NV0000_CTRL_GPS_CMD_TYPE_GET_CPU_PACKAGE_LIMITS = (0x00000044) # macro
NV0000_CTRL_GPS_CMD_TYPE_GET_CPU_PACKAGE_LIMITS_PL1 = (0x00000000) # macro
NV0000_CTRL_GPS_CMD_TYPE_GET_CPU_PACKAGE_LIMITS_PL2 = (0x00000001) # macro
NV0000_CTRL_GPS_CMD_TYPE_SET_CPU_PACKAGE_LIMITS = (0x00000045) # macro
NV0000_CTRL_GPS_CMD_TYPE_SET_CPU_PACKAGE_LIMITS_PL1 = (0x00000000) # macro
NV0000_CTRL_GPS_CMD_TYPE_GET_CPU_FREQ_LIMIT = (0x00000046) # macro
NV0000_CTRL_GPS_CMD_TYPE_GET_CPU_FREQ_LIMIT_MHZ = (0000000000) # macro
NV0000_CTRL_GPS_CMD_TYPE_SET_CPU_FREQ_LIMIT = (0x00000047) # macro
NV0000_CTRL_GPS_CMD_TYPE_SET_CPU_FREQ_LIMIT_MHZ = (0000000000) # macro
NV0000_CTRL_GPS_CMD_TYPE_GET_PPM = (0x00000048) # macro
NV0000_CTRL_GPS_CMD_TYPE_GET_PPM_INDEX = (0000000000) # macro
NV0000_CTRL_GPS_CMD_TYPE_GET_PPM_AVAILABLE_MASK = 1 # macro
NV0000_CTRL_GPS_CMD_TYPE_SET_PPM = (0x00000049) # macro
NV0000_CTRL_GPS_CMD_TYPE_SET_PPM_INDEX = (0000000000) # macro
NV0000_CTRL_GPS_CMD_TYPE_SET_PPM_INDEX_MAX = (2) # macro
NV0000_CTRL_GPS_PPM_INDEX = ['7', ':', '0'] # macro
NV0000_CTRL_GPS_PPM_INDEX_MAXPERF = (0) # macro
NV0000_CTRL_GPS_PPM_INDEX_BALANCED = (1) # macro
NV0000_CTRL_GPS_PPM_INDEX_QUIET = (2) # macro
NV0000_CTRL_GPS_PPM_INDEX_INVALID = (0xFF) # macro
NV0000_CTRL_GPS_PPM_MASK = ['15', ':', '8'] # macro
NV0000_CTRL_GPS_PPM_MASK_INVALID = (0) # macro
NV0000_CTRL_GPS_CMD_PS_STATUS_OFF = (0) # macro
NV0000_CTRL_GPS_CMD_PS_STATUS_ON = (1) # macro
NV0000_CTRL_CMD_SYSTEM_SET_SECURITY_SETTINGS = (0x129) # macro
GPS_MAX_COUNTERS_PER_BLOCK = 32 # macro
NV0000_CTRL_SYSTEM_GPS_GET_PERF_SENSOR_COUNTERS_PARAMS_MESSAGE_ID = (0x29) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_GET_PERF_SENSORS = (0x12c) # macro
NV0000_CTRL_SYSTEM_GPS_GET_PERF_SENSORS_PARAMS_MESSAGE_ID = (0x2C) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_GET_EXTENDED_PERF_SENSORS = (0x12e) # macro
NV0000_CTRL_SYSTEM_GPS_GET_EXTENDED_PERF_SENSORS_PARAMS_MESSAGE_ID = (0x2E) # macro
GPS_MAX_ACPI_OUTPUT_BUFFER_SIZE = 288 # macro
NV0000_CTRL_SYSTEM_GPS_CALL_ACPI_PARAMS_MESSAGE_ID = (0x2D) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_CALL_ACPI = (0x12d) # macro
NV0000_CTRL_SYSTEM_PARAM_TGPU = (0x00000000) # macro
NV0000_CTRL_SYSTEM_PARAM_PDTS = (0x00000001) # macro
NV0000_CTRL_SYSTEM_PARAM_SFAN = (0x00000002) # macro
NV0000_CTRL_SYSTEM_PARAM_SKNT = (0x00000003) # macro
NV0000_CTRL_SYSTEM_PARAM_CPUE = (0x00000004) # macro
NV0000_CTRL_SYSTEM_PARAM_TMP1 = (0x00000005) # macro
NV0000_CTRL_SYSTEM_PARAM_TMP2 = (0x00000006) # macro
NV0000_CTRL_SYSTEM_PARAM_CTGP = (0x00000007) # macro
NV0000_CTRL_SYSTEM_PARAM_PPMD = (0x00000008) # macro
NV0000_CTRL_SYSTEM_PARAM_COUNT = (0x00000009) # macro
NV0000_CTRL_CMD_SYSTEM_EXECUTE_ACPI_METHOD = (0x130) # macro
NV0000_CTRL_SYSTEM_EXECUTE_ACPI_METHOD_PARAMS_MESSAGE_ID = (0x30) # macro
NV0000_CTRL_SYSTEM_EXECUTE_ACPI_METHOD_DSM_NVOP_OPTIMUSCAPS = (0x00000000) # macro
NV0000_CTRL_SYSTEM_EXECUTE_ACPI_METHOD_DSM_NVOP_OPTIMUSFLAG = (0x00000001) # macro
NV0000_CTRL_SYSTEM_EXECUTE_ACPI_METHOD_DSM_JT_CAPS = (0x00000002) # macro
NV0000_CTRL_SYSTEM_EXECUTE_ACPI_METHOD_DSM_JT_PLATPOLICY = (0x00000003) # macro
NV0000_CTRL_CMD_SYSTEM_ENABLE_ETW_EVENTS = (0x131) # macro
NV0000_CTRL_SYSTEM_ENABLE_ETW_EVENTS_PARAMS_MESSAGE_ID = (0x31) # macro
NV0000_CTRL_SYSTEM_RMTRACE_MODULE_ALL = (0x00000001) # macro
NV0000_CTRL_SYSTEM_RMTRACE_MODULE_NOFREQ = (0x00000002) # macro
NV0000_CTRL_SYSTEM_RMTRACE_MODULE_FLUSH = (0x00000004) # macro
NV0000_CTRL_SYSTEM_RMTRACE_MODULE_PERF = (0x00000010) # macro
NV0000_CTRL_SYSTEM_RMTRACE_MODULE_ELPG = (0x00000020) # macro
NV0000_CTRL_SYSTEM_RMTRACE_MODULE_NVDPS = (0x00000040) # macro
NV0000_CTRL_SYSTEM_RMTRACE_MODULE_POWER = (0x00000080) # macro
NV0000_CTRL_SYSTEM_RMTRACE_MODULE_DISP = (0x00000100) # macro
NV0000_CTRL_SYSTEM_RMTRACE_MODULE_RMAPI = (0x00000200) # macro
NV0000_CTRL_SYSTEM_RMTRACE_MODULE_INTR = (0x00000400) # macro
NV0000_CTRL_SYSTEM_RMTRACE_MODULE_LOCK = (0x00000800) # macro
NV0000_CTRL_SYSTEM_RMTRACE_MODULE_RCJOURNAL = (0x00001000) # macro
NV0000_CTRL_SYSTEM_RMTRACE_MODULE_GENERIC = (0x00002000) # macro
NV0000_CTRL_SYSTEM_RMTRACE_MODULE_THERM = (0x00004000) # macro
NV0000_CTRL_SYSTEM_RMTRACE_MODULE_GPS = (0x00008000) # macro
NV0000_CTRL_SYSTEM_RMTRACE_MODULE_PCIE = (0x00010000) # macro
NV0000_CTRL_SYSTEM_RMTRACE_MODULE_NVTELEMETRY = (0x00020000) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_GET_FRM_DATA = (0x12f) # macro
NV0000_CTRL_SYSTEM_GPS_FRM_DATA_SAMPLE_SIZE = 64 # macro
NV0000_CTRL_SYSTEM_GPS_GET_FRM_DATA_PARAMS_MESSAGE_ID = (0x2F) # macro
NV0000_CTRL_CMD_SYSTEM_GPS_SET_FRM_DATA = (0x132) # macro
NV0000_CTRL_SYSTEM_GPS_SET_FRM_DATA_PARAMS_MESSAGE_ID = (0x32) # macro
NV0000_CTRL_CMD_SYSTEM_GET_VGX_SYSTEM_INFO_BUFFER_SIZE = 256 # macro
NV0000_CTRL_CMD_SYSTEM_GET_VGX_SYSTEM_INFO = (0x133) # macro
NV0000_CTRL_SYSTEM_GET_VGX_SYSTEM_INFO_PARAMS_MESSAGE_ID = (0x33) # macro
NV0000_CTRL_CMD_SYSTEM_GET_GPUS_POWER_STATUS = (0x134) # macro
NV0000_CTRL_SYSTEM_GET_GPUS_POWER_STATUS_PARAMS_MESSAGE_ID = (0x34) # macro
NV0000_CTRL_SYSTEM_GPU_EXTERNAL_POWER_STATUS_CONNECTED = 0 # macro
NV0000_CTRL_SYSTEM_GPU_EXTERNAL_POWER_STATUS_NOT_CONNECTED = 1 # macro
NV0000_CTRL_CMD_SYSTEM_GET_PRIVILEGED_STATUS = (0x135) # macro
NV0000_CTRL_SYSTEM_GET_PRIVILEGED_STATUS_PARAMS_MESSAGE_ID = (0x35) # macro
NV0000_CTRL_SYSTEM_GET_PRIVILEGED_STATUS_PRIV_USER_FLAG = (0x00000001) # macro
NV0000_CTRL_SYSTEM_GET_PRIVILEGED_STATUS_KERNEL_HANDLE_FLAG = (0x00000002) # macro
NV0000_CTRL_SYSTEM_GET_PRIVILEGED_STATUS_PRIV_HANDLE_FLAG = (0x00000004) # macro
NV0000_CTRL_CMD_SYSTEM_GET_FABRIC_STATUS = (0x136) # macro
NV0000_CTRL_SYSTEM_GET_FABRIC_STATUS_PARAMS_MESSAGE_ID = (0x36) # macro
NV0000_CTRL_VGPU_GET_VGPU_VERSION = (0x137) # macro
NV0000_CTRL_VGPU_GET_VGPU_VERSION_PARAMS_MESSAGE_ID = (0x37) # macro
NV0000_CTRL_VGPU_SET_VGPU_VERSION = (0x138) # macro
NV0000_CTRL_VGPU_SET_VGPU_VERSION_PARAMS_MESSAGE_ID = (0x38) # macro
NV0000_CTRL_CMD_SYSTEM_GET_RM_INSTANCE_ID = (0x139) # macro
NV0000_CTRL_SYSTEM_GET_RM_INSTANCE_ID_PARAMS_MESSAGE_ID = (0x39) # macro
NV0000_CTRL_CMD_SYSTEM_NVPCF_GET_POWER_MODE_INFO = (0x13b) # macro
NV0000_CTRL_CMD_SYSTEM_NVPCF_GET_POWER_MODE_INFO_PARAMS_MESSAGE_ID = (0x3B) # macro
CONTROLLER_FILTER_TYPE_EMWA = 0 # macro
CONTROLLER_FILTER_TYPE_MOVING_MAX = 1 # macro
NVPCF0100_CTRL_CONFIG_DSM_2X_FUNC_GET_SUPPORTED_CASE = 2 # macro
NVPCF0100_CTRL_CONFIG_DSM_2X_FUNC_GET_DYNAMIC_CASE = 3 # macro
NVPCF0100_CTRL_CONFIG_DSM_2X_FUNC_GET_STATIC_CASE = 4 # macro
NVPCF0100_CTRL_CONFIG_DSM_1X_FUNC_GET_SUPPORTED = (0x00000000) # macro
NVPCF0100_CTRL_CONFIG_DSM_1X_FUNC_GET_DYNAMIC_PARAMS = (0x00000002) # macro
NVPCF0100_CTRL_CONFIG_DSM_FUNC_GET_SUPPORTED_IS_SUPPORTED = ['0', ':', '0'] # macro
NVPCF0100_CTRL_CONFIG_DSM_FUNC_GET_SUPPORTED_IS_SUPPORTED_YES = 1 # macro
NVPCF0100_CTRL_CONFIG_DSM_FUNC_GET_SUPPORTED_IS_SUPPORTED_NO = 0 # macro
NVPCF0100_CTRL_CONFIG_DSM_2X_VERSION = (0x00000200) # macro
NVPCF0100_CTRL_CONFIG_DSM_2X_FUNC_GET_SUPPORTED = (0x00000000) # macro
NVPCF0100_CTRL_CONFIG_DSM_2X_FUNC_GET_STATIC_CONFIG_TABLES = (0x00000001) # macro
NVPCF0100_CTRL_CONFIG_DSM_2X_FUNC_GET_DYNAMIC_PARAMS = (0x00000002) # macro
NVPCF0100_CTRL_CONFIG_2X_BUFF_SIZE_MAX = (255) # macro
NV0000_CTRL_CMD_SYSTEM_SYNC_EXTERNAL_FABRIC_MGMT = (0x13c) # macro
NV0000_CTRL_CMD_SYSTEM_SYNC_EXTERNAL_FABRIC_MGMT_PARAMS_MESSAGE_ID = (0x3C) # macro
NV0000_CTRL_CMD_SYSTEM_GET_CLIENT_DATABASE_INFO = (0x13d) # macro
NV0000_CTRL_SYSTEM_GET_CLIENT_DATABASE_INFO_PARAMS_MESSAGE_ID = (0x3D) # macro
NV0000_CTRL_SYSTEM_GET_BUILD_VERSION_V2_MAX_STRING_SIZE = 256 # macro
NV0000_CTRL_CMD_SYSTEM_GET_BUILD_VERSION_V2 = (0x13e) # macro
NV0000_CTRL_SYSTEM_GET_BUILD_VERSION_V2_PARAMS_MESSAGE_ID = (0x3E) # macro
NV0000_CTRL_CMD_SYSTEM_RMCTRL_CACHE_MODE_CTRL = (0x13f) # macro
NV0000_CTRL_SYSTEM_RMCTRL_CACHE_MODE_CTRL_PARAMS_MESSAGE_ID = (0x3F) # macro
NV0000_CTRL_SYSTEM_RMCTRL_CACHE_MODE_CTRL_CMD_GET = (0x00000000) # macro
NV0000_CTRL_SYSTEM_RMCTRL_CACHE_MODE_CTRL_CMD_SET = (0x00000001) # macro
NV0000_CTRL_SYSTEM_RMCTRL_CACHE_MODE_CTRL_MODE_DISABLE = (0x00000000) # macro
NV0000_CTRL_SYSTEM_RMCTRL_CACHE_MODE_CTRL_MODE_ENABLE = (0x00000001) # macro
NV0000_CTRL_SYSTEM_RMCTRL_CACHE_MODE_CTRL_MODE_VERIFY_ONLY = (0x00000002) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CONTROL = (0x140) # macro
NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_CONTROL_PARAMS_MESSAGE_ID = (0x40) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_INVALID = (0xFFFF) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_GET_INIT = (0x0000) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_SET_EXEC = (0x0001) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_GET_EXEC = (0x0002) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_SET_ACTIONS = (0x0003) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_GET_ACTIONS = (0x0004) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_SET_LOGIC = (0x0005) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_GET_LOGIC = (0x0006) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_SET_PREFERENCE = (0x0007) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_GET_PREFERENCE = (0x0008) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_SET_GPU2CPU_LIMIT = (0x0009) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_GET_GPU2CPU_LIMIT = (0x000A) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_SET_PMU_PFM_REQ_HNDLR_STATE = (0x000B) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_GET_PMU_PFM_REQ_HNDLR_STATE = (0x000C) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_SET_MAX_POWER = (0x0100) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_GET_MAX_POWER = (0x0101) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_SET_COOLING_BUDGET = (0x0102) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_GET_COOLING_BUDGET = (0x0103) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_SET_INTEGRAL_PERIOD = (0x0104) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_GET_INTEGRAL_PERIOD = (0x0105) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_SET_RULESET = (0x0106) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_GET_RULESET = (0x0107) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_GET_RULE_COUNT = (0x0108) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_SET_APP_BOOST = (0x0109) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_GET_APP_BOOST = (0x010A) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_SET_PWR_SUPPLY_MODE = (0x010B) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_GET_PWR_SUPPLY_MODE = (0x010C) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_GET_VCT_SUPPORT_INFO = (0x010D) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_GET_SUPPORTED_FUNCTIONS = (0x010E) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_GET_POWER = (0x0200) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_GET_POWER_DELTA = (0x0201) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_GET_POWER_FUTURE = (0x0202) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_GET_POWER_LTMAVG = (0x0203) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_GET_POWER_INTEGRAL = (0x0204) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_GET_POWER_BURDEN = (0x0205) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_GET_POWER_INTERMEDIATE = (0x0206) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_GET_SENSOR_PARAMETERS = (0x0210) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_GET_TEMP = (0x0220) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_GET_TEMP_DELTA = (0x0221) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_GET_TEMP_FUTURE = (0x0222) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_GET_PSTATE = (0x0240) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_GET_PSTATE_CAP = (0x0241) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_GET_PSTATE_MIN = (0x0242) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_GET_PSTATE_MAX = (0x0243) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_GET_PSTATE_ACTION = (0x0244) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_GET_PSTATE_SLFM_PRESENT = (0x0245) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_SET_POWER_SIM_STATE = (0x0250) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_GET_POWER_SIM_STATE = (0x0251) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_SET_POWER_SIM_DATA = (0x0252) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_GET_POWER_SIM_DATA = (0x0253) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_INIT_USING_SBIOS_AND_ACK = (0x0320) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_PING_SBIOS_FOR_EVENT = (0x0321) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_LOCALE_INVALID = (0xFFFF) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_LOCALE_SYSTEM = (0x0000) # macro
# def NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_LOCALE_CPU(i):  # macro
#    return (0x0100+((i)%0x100))
# def NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_LOCALE_GPU(i):  # macro
#    return (0x0200+((i)%0x100))
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_DEF_INVALID = (0x80000000) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_DEF_INIT_NO = (0x00000000) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_DEF_INIT_YES = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_DEF_EXEC_STOP = (0x00000000) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_DEF_EXEC_START = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_DEF_ACTIONS_OFF = (0x00000000) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_DEF_ACTIONS_ON = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_DEF_LOGIC_OFF = (0x00000000) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_DEF_LOGIC_FUZZY = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_DEF_LOGIC_DETERMINISTIC = (0x00000002) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_DEF_PREFERENCE_CPU = (0x00000000) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_DEF_PREFERENCE_GPU = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_DEF_PREFERENCE_BOTH = (0x00000002) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_DEF_NO_MAP_OVERRIDE = (0xFFFFFFFF) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_DEF_PMU_PFM_REQ_HNDLR_STATE_OFF = (0x00000000) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CMD_DEF_PMU_PFM_REQ_HNDLR_STATE_ON = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_DEF_PWR_SUPPLY_REAL = (0x00000000) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_DEF_PWR_SUPPLY_FAKE_AC = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_DEF_PWR_SUPPLY_FAKE_BATT = (0x00000002) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_DEF_FUNC_SUPPORT = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_DEF_FUNC_VENTURASTATUS = (0x00000002) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_DEF_FUNC_GETPSS = (0x00000004) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_DEF_FUNC_SETPPC = (0x00000008) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_DEF_FUNC_GETPPC = (0x00000010) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_DEF_FUNC_VENTURACB = (0x00000020) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SYS_DEF_FUNC_SYSPARAMS = (0x00000040) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_DEF_ACTION_DEC_TO_P0 = (0x00000000) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_DEF_ACTION_DEC_BY_1 = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_DEF_ACTION_DO_NOTHING = (0x00000002) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_DEF_ACTION_SET_CURRENT = (0x00000003) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_DEF_ACTION_INC_BY_1 = (0x00000004) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_DEF_ACTION_INC_BY_2 = (0x00000005) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_DEF_ACTION_INC_TO_LFM = (0x00000006) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_DEF_ACTION_INC_TO_SLFM = (0x00000007) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_DEF_SLFM_PRESENT_NO = (0x00000000) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_DEF_SLFM_PRESENT_YES = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_DEF_POWER_SIM_STATE_OFF = (0x00000000) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_DATA_DEF_POWER_SIM_STATE_ON = (0x00000001) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_BATCH_CONTROL = (0x141) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_BATCH_COMMAND_MAX = (16) # macro
NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_BATCH_CONTROL_PARAMS_MESSAGE_ID = (0x41) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CTRL = (0x142) # macro
NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_CTRL_PARAMS_MESSAGE_ID = (0x42) # macro
NV0000_CTRL_PFM_REQ_HNDLR_PSHARE_PARAMS_PSP_CURRENT_VERSION = (0x00010000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_GET_THERM_LIMIT = (0x00000002) # macro
NV0000_CTRL_PFM_REQ_HNDLR_INPUT_SENSOR_INDEX = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_RESULT_THERMAL_LIMIT = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_RESULT_MIN_LIMIT = (0x00000001) # macro
NV0000_CTRL_PFM_REQ_HNDLR_RESULT_MAX_LIMIT = (0x00000002) # macro
NV0000_CTRL_PFM_REQ_HNDLR_RESULT_LIMIT_SOURCE = (0x00000003) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_SET_THERM_LIMIT = (0x00000003) # macro
NV0000_CTRL_PFM_REQ_HNDLR_INPUT_THERMAL_LIMIT = (0x00000001) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_GET_TEMP_CTRL_DOWN_N_DELTA = (0x00000004) # macro
NV0000_CTRL_PFM_REQ_HNDLR_RESULT_TEMP_CTRL_DOWN_N_DELTA = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_SET_TEMP_CTRL_DOWN_N_DELTA = (0x00000005) # macro
NV0000_CTRL_PFM_REQ_HNDLR_INPUT_TEMP_CTRL_DOWN_N_DELTA = (0x00000001) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_GET_TEMP_CTRL_HOLD_DELTA = (0x00000006) # macro
NV0000_CTRL_PFM_REQ_HNDLR_RESULT_TEMP_CTRL_HOLD_DELTA = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_SET_TEMP_CTRL_HOLD_DELTA = (0x00000007) # macro
NV0000_CTRL_PFM_REQ_HNDLR_INPUT_TEMP_CTRL_HOLD_DELTA = (0x00000001) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_GET_TEMP_CTRL_UP_DELTA = (0x00000008) # macro
NV0000_CTRL_PFM_REQ_HNDLR_RESULT_TEMP_CTRL_UP_DELTA = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_SET_TEMP_CTRL_UP_DELTA = (0x00000009) # macro
NV0000_CTRL_PFM_REQ_HNDLR_INPUT_TEMP_CTRL_UP_DELTA = (0x00000001) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_GET_TEMP_CTRL_ENGAGE_DELTA = (0x0000000A) # macro
NV0000_CTRL_PFM_REQ_HNDLR_RESULT_TEMP_CTRL_ENGAGE_DELTA = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_SET_TEMP_CTRL_ENGAGE_DELTA = (0x0000000B) # macro
NV0000_CTRL_PFM_REQ_HNDLR_INPUT_TEMP_CTRL_ENGAGE_DELTA = (0x00000001) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_GET_TEMP_CTRL_DISENGAGE_DELTA = (0x0000000C) # macro
NV0000_CTRL_PFM_REQ_HNDLR_RESULT_TEMP_CTRL_DISENGAGE_DELTA = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_SET_TEMP_CTRL_DISENGAGE_DELTA = (0x0000000D) # macro
NV0000_CTRL_PFM_REQ_HNDLR_INPUT_TEMP_CTRL_DISENGAGE_DELTA = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_GET_TEMP_CTRL_STATUS = (0x00000016) # macro
NV0000_CTRL_PFM_REQ_HNDLR_RESULT_TEMP_CTRL_STATUS = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_SET_TEMP_CTRL_STATUS = (0x00000017) # macro
NV0000_CTRL_PFM_REQ_HNDLR_INPUT_TEMP_CTRL_STATUS = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_GET_CPU_GET_UTIL_AVG_NUM = (0x00000018) # macro
NV0000_CTRL_PFM_REQ_HNDLR_RESULT_CPU_SET_UTIL_AVG_NUM = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_SET_CPU_SET_UTIL_AVG_NUM = (0x00000019) # macro
NV0000_CTRL_PFM_REQ_HNDLR_INPUT_CPU_GET_UTIL_AVG_NUM = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_GET_PERF_SENSOR = (0x0000001A) # macro
NV0000_CTRL_PFM_REQ_HNDLR_INPUT_NEXT_EXPECTED_POLL = (0x00000001) # macro
NV0000_CTRL_PFM_REQ_HNDLR_RESULT_PERF_SENSOR_VALUE = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_RESULT_PERF_SENSOR_AVAILABLE = (0x00000001) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_CALL_ACPI = (0x0000001B) # macro
NV0000_CTRL_PFM_REQ_HNDLR_INPUT_ACPI_CMD = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_INPUT_ACPI_PARAM_IN = (0x00000001) # macro
NV0000_CTRL_PFM_REQ_HNDLR_OUTPUT_ACPI_RESULT_1 = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_OUTPUT_ACPI_RESULT_2 = (0x00000001) # macro
NV0000_CTRL_PFM_REQ_HNDLR_OUTPUT_ACPI_PSHAREPARAM_STATUS = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_OUTPUT_ACPI_PSHAREPARAM_VERSION = (0x00000001) # macro
NV0000_CTRL_PFM_REQ_HNDLR_OUTPUT_ACPI_PSHAREPARAM_SZ = (0x00000002) # macro
NV0000_CTRL_PFM_REQ_HNDLR_OUTPUT_ACPI_PSS_SZ = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_OUTPUT_ACPI_PSS_COUNT = (0x00000001) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_SET_IGPU_TURBO = (0x0000001C) # macro
NV0000_CTRL_PFM_REQ_HNDLR_INPUT_SET_IGPU_TURBO = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_SET_TEMP_PERIOD = (0x00000026) # macro
NV0000_CTRL_PFM_REQ_HNDLR_INPUT_TEMP_PERIOD = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_GET_TEMP_PERIOD = (0x00000027) # macro
NV0000_CTRL_PFM_REQ_HNDLR_RESULT_TEMP_PERIOD = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_SET_TEMP_NUDGE_FACTOR = (0x00000028) # macro
NV0000_CTRL_PFM_REQ_HNDLR_INPUT_TEMP_NUDGE_UP = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_INPUT_TEMP_NUDGE_DOWN = (0x00000001) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_GET_TEMP_NUDGE_FACTOR = (0x00000029) # macro
NV0000_CTRL_PFM_REQ_HNDLR_RESULT_TEMP_NUDGE_UP = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_RESULT_TEMP_NUDGE_DOWN = (0x00000001) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_SET_TEMP_THRESHOLD_SAMPLES = (0x0000002A) # macro
NV0000_CTRL_PFM_REQ_HNDLR_INPUT_TEMP_THRESHOLD_SAMPLE_HOLD = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_INPUT_TEMP_THRESHOLD_SAMPLE_STEP = (0x00000001) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_GET_TEMP_THRESHOLD_SAMPLES = (0x0000002B) # macro
NV0000_CTRL_PFM_REQ_HNDLR_RESULT_TEMP_THRESHOLD_SAMPLE_HOLD = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_RESULT_TEMP_THRESHOLD_SAMPLE_STEP = (0x00000001) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_SET_TEMP_PERF_LIMITS = (0x0000002C) # macro
NV0000_CTRL_PFM_REQ_HNDLR_INPUT_TEMP_PERF_LIMIT_UPPER = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_INPUT_TEMP_PERF_LIMIT_LOWER = (0x00000001) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_GET_TEMP_PERF_LIMITS = (0x0000002D) # macro
NV0000_CTRL_PFM_REQ_HNDLR_RESULT_TEMP_PERF_LIMIT_UPPER = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_RESULT_TEMP_PERF_LIMIT_LOWER = (0x00000001) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_SET_PM1_AVAILABLE = (0x0000002E) # macro
NV0000_CTRL_PFM_REQ_HNDLR_INPUT_PM1_AVAILABLE = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_GET_PM1_AVAILABLE = (0x0000002F) # macro
NV0000_CTRL_PFM_REQ_HNDLR_OUTPUT_PM1_AVAILABLE = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_GET_CPU_PACKAGE_LIMITS = (0x00000044) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_GET_CPU_PACKAGE_LIMITS_PL1 = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_GET_CPU_PACKAGE_LIMITS_PL2 = (0x00000001) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_SET_CPU_PACKAGE_LIMITS = (0x00000045) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_SET_CPU_PACKAGE_LIMITS_PL1 = (0x00000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_GET_CPU_FREQ_LIMIT = (0x00000046) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_GET_CPU_FREQ_LIMIT_MHZ = (0000000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_SET_CPU_FREQ_LIMIT = (0x00000047) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_SET_CPU_FREQ_LIMIT_MHZ = (0000000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_GET_PPM = (0x00000048) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_GET_PPM_INDEX = (0000000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_GET_PPM_AVAILABLE_MASK = 1 # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_SET_PPM = (0x00000049) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_SET_PPM_INDEX = (0000000000) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_TYPE_SET_PPM_INDEX_MAX = (2) # macro
NV0000_CTRL_PFM_REQ_HNDLR_PPM_INDEX = ['7', ':', '0'] # macro
NV0000_CTRL_PFM_REQ_HNDLR_PPM_INDEX_MAXPERF = (0) # macro
NV0000_CTRL_PFM_REQ_HNDLR_PPM_INDEX_BALANCED = (1) # macro
NV0000_CTRL_PFM_REQ_HNDLR_PPM_INDEX_QUIET = (2) # macro
NV0000_CTRL_PFM_REQ_HNDLR_PPM_INDEX_INVALID = (0xFF) # macro
NV0000_CTRL_PFM_REQ_HNDLR_PPM_MASK = ['15', ':', '8'] # macro
NV0000_CTRL_PFM_REQ_HNDLR_PPM_MASK_INVALID = (0) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_PS_STATUS_OFF = (0) # macro
NV0000_CTRL_PFM_REQ_HNDLR_CMD_PS_STATUS_ON = (1) # macro
PFM_REQ_HNDLR_MAX_COUNTERS_PER_BLOCK = 32 # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_GET_PERF_SENSORS = (0x146) # macro
NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_GET_PERF_SENSORS_PARAMS_MESSAGE_ID = (0x46) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_GET_EXTENDED_PERF_SENSORS = (0x147) # macro
NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_GET_EXTENDED_PERF_SENSORS_PARAMS_MESSAGE_ID = (0x47) # macro
PFM_REQ_HNDLR_MAX_ACPI_OUTPUT_BUFFER_SIZE = 288 # macro
NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_CALL_ACPI_PARAMS_MESSAGE_ID = (0x43) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_CALL_ACPI = (0x143) # macro
NV0000_CTRL_SYSTEM_RMTRACE_MODULE_PFM_REQ_HNDLR = (0x00008000) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_GET_FRM_DATA = (0x144) # macro
NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_FRM_DATA_SAMPLE_SIZE = 64 # macro
NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_GET_FRM_DATA_PARAMS_MESSAGE_ID = (0x44) # macro
NV0000_CTRL_CMD_SYSTEM_PFM_REQ_HNDLR_SET_FRM_DATA = (0x145) # macro
NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_SET_FRM_DATA_PARAMS_MESSAGE_ID = (0x45) # macro
NV0000_CTRL_CMD_GPU_GET_ATTACHED_IDS = (0x201) # macro
NV0000_CTRL_GPU_MAX_ATTACHED_GPUS = 32 # macro
NV0000_CTRL_GPU_INVALID_ID = (0xffffffff) # macro
NV0000_CTRL_GPU_GET_ATTACHED_IDS_PARAMS_MESSAGE_ID = (0x1) # macro
NV0000_CTRL_CMD_GPU_GET_ID_INFO = (0x202) # macro
NV0000_CTRL_GPU_MAX_SZNAME = 128 # macro
NV0000_CTRL_NO_NUMA_NODE = (-1) # macro
NV0000_CTRL_GPU_GET_ID_INFO_PARAMS_MESSAGE_ID = (0x2) # macro
NV0000_CTRL_SLI_STATUS_OK = (0x00000000) # macro
NV0000_CTRL_SLI_STATUS_OS_NOT_SUPPORTED = (0x00000002) # macro
NV0000_CTRL_SLI_STATUS_GPU_NOT_SUPPORTED = (0x00000040) # macro
NV0000_CTRL_SLI_STATUS_INVALID_GPU_COUNT = (0x00000001) # macro
NV0000_CTRL_CMD_GPU_GET_ID_INFO_V2 = (0x205) # macro
NV0000_CTRL_GPU_GET_ID_INFO_V2_PARAMS_MESSAGE_ID = (0x5) # macro
NV0000_CTRL_GPU_ID_INFO_IN_USE = ['0', ':', '0'] # macro
NV0000_CTRL_GPU_ID_INFO_IN_USE_FALSE = (0x00000000) # macro
NV0000_CTRL_GPU_ID_INFO_IN_USE_TRUE = (0x00000001) # macro
NV0000_CTRL_GPU_ID_INFO_LINKED_INTO_SLI_DEVICE = ['1', ':', '1'] # macro
NV0000_CTRL_GPU_ID_INFO_LINKED_INTO_SLI_DEVICE_FALSE = (0x00000000) # macro
NV0000_CTRL_GPU_ID_INFO_LINKED_INTO_SLI_DEVICE_TRUE = (0x00000001) # macro
NV0000_CTRL_GPU_ID_INFO_MOBILE = ['2', ':', '2'] # macro
NV0000_CTRL_GPU_ID_INFO_MOBILE_FALSE = (0x00000000) # macro
NV0000_CTRL_GPU_ID_INFO_MOBILE_TRUE = (0x00000001) # macro
NV0000_CTRL_GPU_ID_INFO_BOOT_MASTER = ['3', ':', '3'] # macro
NV0000_CTRL_GPU_ID_INFO_BOOT_MASTER_FALSE = (0x00000000) # macro
NV0000_CTRL_GPU_ID_INFO_BOOT_MASTER_TRUE = (0x00000001) # macro
NV0000_CTRL_GPU_ID_INFO_SOC = ['5', ':', '5'] # macro
NV0000_CTRL_GPU_ID_INFO_SOC_FALSE = (0x00000000) # macro
NV0000_CTRL_GPU_ID_INFO_SOC_TRUE = (0x00000001) # macro
NV0000_CTRL_GPU_ID_INFO_ATS_ENABLED = ['6', ':', '6'] # macro
NV0000_CTRL_GPU_ID_INFO_ATS_ENABLED_FALSE = (0x00000000) # macro
NV0000_CTRL_GPU_ID_INFO_ATS_ENABLED_TRUE = (0x00000001) # macro
NV0000_CTRL_CMD_GPU_GET_INIT_STATUS = (0x203) # macro
NV0000_CTRL_GPU_GET_INIT_STATUS_PARAMS_MESSAGE_ID = (0x3) # macro
NV0000_CTRL_CMD_GPU_GET_DEVICE_IDS = (0x204) # macro
NV0000_CTRL_GPU_GET_DEVICE_IDS_PARAMS_MESSAGE_ID = (0x4) # macro
NV0000_CTRL_CMD_GPU_GET_PROBED_IDS = (0x214) # macro
# NV0000_CTRL_GPU_MAX_PROBED_GPUS = NV_MAX_DEVICES # macro
NV0000_CTRL_GPU_GET_PROBED_IDS_PARAMS_MESSAGE_ID = (0x14) # macro
NV0000_CTRL_CMD_GPU_GET_PCI_INFO = (0x21b) # macro
NV0000_CTRL_GPU_GET_PCI_INFO_PARAMS_MESSAGE_ID = (0x1B) # macro
NV0000_CTRL_CMD_GPU_ATTACH_IDS = (0x215) # macro
NV0000_CTRL_GPU_ATTACH_ALL_PROBED_IDS = (0x0000ffff) # macro
NV0000_CTRL_GPU_ATTACH_IDS_PARAMS_MESSAGE_ID = (0x15) # macro
NV0000_CTRL_CMD_GPU_DETACH_IDS = (0x216) # macro
NV0000_CTRL_GPU_DETACH_ALL_ATTACHED_IDS = (0x0000ffff) # macro
NV0000_CTRL_GPU_DETACH_IDS_PARAMS_MESSAGE_ID = (0x16) # macro
NV0000_CTRL_CMD_GPU_GET_VIDEO_LINKS = (0x219) # macro
NV0000_CTRL_GPU_MAX_VIDEO_LINKS = 8 # macro
NV0000_CTRL_GPU_GET_VIDEO_LINKS_PARAMS_MESSAGE_ID = (0x19) # macro
NV0000_CTRL_CMD_GPU_GET_SVM_SIZE = (0x240) # macro
NV0000_CTRL_GPU_GET_SVM_SIZE_PARAMS_MESSAGE_ID = (0x40) # macro
NV0000_CTRL_CMD_GPU_GET_UUID_INFO = (0x274) # macro
NV0000_GPU_MAX_GID_LENGTH = (0x00000100) # macro
NV0000_CTRL_GPU_GET_UUID_INFO_PARAMS_MESSAGE_ID = (0x74) # macro
NV0000_CTRL_CMD_GPU_GET_UUID_INFO_FLAGS_FORMAT = ['1', ':', '0'] # macro
NV0000_CTRL_CMD_GPU_GET_UUID_INFO_FLAGS_FORMAT_ASCII = (0x00000000) # macro
NV0000_CTRL_CMD_GPU_GET_UUID_INFO_FLAGS_FORMAT_BINARY = (0x00000002) # macro
NV0000_CTRL_CMD_GPU_GET_UUID_INFO_FLAGS_TYPE = ['2', ':', '2'] # macro
NV0000_CTRL_CMD_GPU_GET_UUID_INFO_FLAGS_TYPE_SHA1 = (0x00000000) # macro
NV0000_CTRL_CMD_GPU_GET_UUID_INFO_FLAGS_TYPE_SHA256 = (0x00000001) # macro
NV0000_CTRL_CMD_GPU_GET_UUID_FROM_GPU_ID = (0x275) # macro
NV0000_CTRL_GPU_GET_UUID_FROM_GPU_ID_PARAMS_MESSAGE_ID = (0x75) # macro
NV0000_CTRL_CMD_GPU_GET_UUID_FROM_GPU_ID_FLAGS_FORMAT = ['1', ':', '0'] # macro
NV0000_CTRL_CMD_GPU_GET_UUID_FROM_GPU_ID_FLAGS_FORMAT_ASCII = (0x00000000) # macro
NV0000_CTRL_CMD_GPU_GET_UUID_FROM_GPU_ID_FLAGS_FORMAT_BINARY = (0x00000002) # macro
NV0000_CTRL_CMD_GPU_GET_UUID_FROM_GPU_ID_FLAGS_TYPE = ['2', ':', '2'] # macro
NV0000_CTRL_CMD_GPU_GET_UUID_FROM_GPU_ID_FLAGS_TYPE_SHA1 = (0x00000000) # macro
NV0000_CTRL_CMD_GPU_GET_UUID_FROM_GPU_ID_FLAGS_TYPE_SHA256 = (0x00000001) # macro
NV0000_CTRL_CMD_GPU_MODIFY_DRAIN_STATE = (0x278) # macro
NV0000_CTRL_GPU_DRAIN_STATE_DISABLED = (0x00000000) # macro
NV0000_CTRL_GPU_DRAIN_STATE_ENABLED = (0x00000001) # macro
NV0000_CTRL_GPU_DRAIN_STATE_FLAG_REMOVE_DEVICE = (0x00000001) # macro
NV0000_CTRL_GPU_DRAIN_STATE_FLAG_LINK_DISABLE = (0x00000002) # macro
NV0000_CTRL_GPU_MODIFY_DRAIN_STATE_PARAMS_MESSAGE_ID = (0x78) # macro
NV0000_CTRL_CMD_GPU_QUERY_DRAIN_STATE = (0x279) # macro
NV0000_CTRL_GPU_QUERY_DRAIN_STATE_PARAMS_MESSAGE_ID = (0x79) # macro
NV0000_CTRL_CMD_GPU_DISCOVER = (0x27a) # macro
NV0000_CTRL_CMD_GPU_GET_MEMOP_ENABLE = (0x27b) # macro
NV0000_CTRL_GPU_GET_MEMOP_ENABLE_PARAMS_MESSAGE_ID = (0x7B) # macro
NV0000_CTRL_GPU_FLAGS_MEMOP_ENABLE = (0x00000001) # macro
NV0000_CTRL_CMD_GPU_DISABLE_NVLINK_INIT = (0x281) # macro
NV0000_CTRL_GPU_DISABLE_NVLINK_INIT_PARAMS_MESSAGE_ID = (0x81) # macro
NV0000_CTRL_GPU_LEGACY_CONFIG_MAX_PARAM_DATA = 0x00000175 # macro
NV0000_CTRL_GPU_LEGACY_CONFIG_MAX_PROPERTIES_IN = 6 # macro
NV0000_CTRL_GPU_LEGACY_CONFIG_MAX_PROPERTIES_OUT = 5 # macro
NV0000_CTRL_CMD_GPU_LEGACY_CONFIG = (0x282) # macro
NV0000_CTRL_GPU_LEGACY_CONFIG_PARAMS_MESSAGE_ID = (0x82) # macro
NV0000_CTRL_GPU_LEGACY_CONFIG_OP_TYPE_SET = (0x00000001) # macro
NV0000_CTRL_GPU_LEGACY_CONFIG_OP_TYPE_GET_EX = (0x00000002) # macro
NV0000_CTRL_GPU_LEGACY_CONFIG_OP_TYPE_SET_EX = (0x00000003) # macro
NV0000_CTRL_GPU_LEGACY_CONFIG_OP_TYPE_RESERVED = (0x00000004) # macro
NV0000_CTRL_CMD_IDLE_CHANNELS = (0x283) # macro
NV0000_CTRL_GPU_IDLE_CHANNELS_PARAMS_MESSAGE_ID = (0x83) # macro
NV0000_CTRL_GPU_IMAGE_TYPE_GSP = (0x00000001) # macro
NV0000_CTRL_GPU_IMAGE_TYPE_GSP_LOG = (0x00000002) # macro
NV0000_CTRL_CMD_PUSH_GSP_UCODE = (0x285) # macro
NV0000_CTRL_GPU_PUSH_GSP_UCODE_PARAMS_MESSAGE_ID = (0x85) # macro
NV0000_CTRL_CMD_GPU_NVLINK_BW_MODE_FULL = (0x00) # macro
NV0000_CTRL_CMD_GPU_NVLINK_BW_MODE_OFF = (0x01) # macro
NV0000_CTRL_CMD_GPU_NVLINK_BW_MODE_MIN = (0x02) # macro
NV0000_CTRL_CMD_GPU_NVLINK_BW_MODE_HALF = (0x03) # macro
NV0000_CTRL_CMD_GPU_NVLINK_BW_MODE_3QUARTER = (0x04) # macro
NV0000_CTRL_CMD_GPU_SET_NVLINK_BW_MODE = (0x286) # macro
NV0000_CTRL_GPU_SET_NVLINK_BW_MODE_PARAMS_MESSAGE_ID = (0x86) # macro
NV0000_CTRL_CMD_GPU_GET_NVLINK_BW_MODE = (0x287) # macro
NV0000_CTRL_GPU_GET_NVLINK_BW_MODE_PARAMS_MESSAGE_ID = (0x87) # macro
NV0000_CTRL_CMD_GPU_GET_ACTIVE_DEVICE_IDS = (0x288) # macro
NV0000_CTRL_GPU_MAX_ACTIVE_DEVICES = 256 # macro
NV0000_CTRL_GPU_GET_ACTIVE_DEVICE_IDS_PARAMS_MESSAGE_ID = (0x88) # macro
NV0000_CTRL_CMD_GPU_ASYNC_ATTACH_ID = (0x289) # macro
NV0000_CTRL_GPU_ASYNC_ATTACH_ID_PARAMS_MESSAGE_ID = (0x89) # macro
NV0000_CTRL_CMD_GPU_WAIT_ATTACH_ID = (0x290) # macro
NV0000_CTRL_GPU_WAIT_ATTACH_ID_PARAMS_MESSAGE_ID = (0x90) # macro
class struct_NV0000_CTRL_SYSTEM_GET_FEATURES_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_GET_FEATURES_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_GET_FEATURES_PARAMS._fields_ = [
    ('featuresMask', ctypes.c_uint32),
]

NV0000_CTRL_SYSTEM_GET_FEATURES_PARAMS = struct_NV0000_CTRL_SYSTEM_GET_FEATURES_PARAMS
class struct_NV0000_CTRL_SYSTEM_GET_BUILD_VERSION_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_GET_BUILD_VERSION_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_GET_BUILD_VERSION_PARAMS._fields_ = [
    ('sizeOfStrings', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('pDriverVersionBuffer', ctypes.POINTER(None)),
    ('pVersionBuffer', ctypes.POINTER(None)),
    ('pTitleBuffer', ctypes.POINTER(None)),
    ('changelistNumber', ctypes.c_uint32),
    ('officialChangelistNumber', ctypes.c_uint32),
]

NV0000_CTRL_SYSTEM_GET_BUILD_VERSION_PARAMS = struct_NV0000_CTRL_SYSTEM_GET_BUILD_VERSION_PARAMS
class struct_NV0000_CTRL_SYSTEM_GET_CPU_INFO_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_GET_CPU_INFO_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_GET_CPU_INFO_PARAMS._fields_ = [
    ('type', ctypes.c_uint32),
    ('capabilities', ctypes.c_uint32),
    ('clock', ctypes.c_uint32),
    ('L1DataCacheSize', ctypes.c_uint32),
    ('L2DataCacheSize', ctypes.c_uint32),
    ('dataCacheLineSize', ctypes.c_uint32),
    ('numLogicalCpus', ctypes.c_uint32),
    ('numPhysicalCpus', ctypes.c_uint32),
    ('name', ctypes.c_ubyte * 52),
    ('family', ctypes.c_uint32),
    ('model', ctypes.c_uint32),
    ('stepping', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('coresOnDie', ctypes.c_uint32),
    ('bCCEnabled', ctypes.c_ubyte),
    ('PADDING_1', ctypes.c_ubyte * 3),
]

NV0000_CTRL_SYSTEM_GET_CPU_INFO_PARAMS = struct_NV0000_CTRL_SYSTEM_GET_CPU_INFO_PARAMS
class struct_NV0000_CTRL_SYSTEM_GET_CHIPSET_INFO_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_GET_CHIPSET_INFO_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_GET_CHIPSET_INFO_PARAMS._fields_ = [
    ('vendorId', ctypes.c_uint16),
    ('deviceId', ctypes.c_uint16),
    ('subSysVendorId', ctypes.c_uint16),
    ('subSysDeviceId', ctypes.c_uint16),
    ('HBvendorId', ctypes.c_uint16),
    ('HBdeviceId', ctypes.c_uint16),
    ('HBsubSysVendorId', ctypes.c_uint16),
    ('HBsubSysDeviceId', ctypes.c_uint16),
    ('sliBondId', ctypes.c_uint32),
    ('vendorNameString', ctypes.c_ubyte * 32),
    ('subSysVendorNameString', ctypes.c_ubyte * 32),
    ('chipsetNameString', ctypes.c_ubyte * 32),
    ('sliBondNameString', ctypes.c_ubyte * 32),
    ('flags', ctypes.c_uint32),
]

NV0000_CTRL_SYSTEM_GET_CHIPSET_INFO_PARAMS = struct_NV0000_CTRL_SYSTEM_GET_CHIPSET_INFO_PARAMS
class struct_NV0000_CTRL_SYSTEM_GET_LOCK_TIMES_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_GET_LOCK_TIMES_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_GET_LOCK_TIMES_PARAMS._fields_ = [
    ('waitApiLock', ctypes.c_uint64),
    ('holdRoApiLock', ctypes.c_uint64),
    ('holdRwApiLock', ctypes.c_uint64),
    ('waitGpuLock', ctypes.c_uint64),
    ('holdGpuLock', ctypes.c_uint64),
]

NV0000_CTRL_SYSTEM_GET_LOCK_TIMES_PARAMS = struct_NV0000_CTRL_SYSTEM_GET_LOCK_TIMES_PARAMS
class struct_NV0000_CTRL_SYSTEM_GET_CLASSLIST_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_GET_CLASSLIST_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_GET_CLASSLIST_PARAMS._fields_ = [
    ('numClasses', ctypes.c_uint32),
    ('classes', ctypes.c_uint32 * 32),
]

NV0000_CTRL_SYSTEM_GET_CLASSLIST_PARAMS = struct_NV0000_CTRL_SYSTEM_GET_CLASSLIST_PARAMS
class struct_NV0000_CTRL_SYSTEM_NOTIFY_EVENT_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_NOTIFY_EVENT_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_NOTIFY_EVENT_PARAMS._fields_ = [
    ('eventType', ctypes.c_uint32),
    ('eventData', ctypes.c_uint32),
    ('bEventDataForced', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV0000_CTRL_SYSTEM_NOTIFY_EVENT_PARAMS = struct_NV0000_CTRL_SYSTEM_NOTIFY_EVENT_PARAMS
class struct_NV0000_CTRL_CMD_SYSTEM_GET_PLATFORM_TYPE_PARAMS(Structure):
    pass

struct_NV0000_CTRL_CMD_SYSTEM_GET_PLATFORM_TYPE_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_CMD_SYSTEM_GET_PLATFORM_TYPE_PARAMS._fields_ = [
    ('systemType', ctypes.c_uint32),
]

NV0000_CTRL_CMD_SYSTEM_GET_PLATFORM_TYPE_PARAMS = struct_NV0000_CTRL_CMD_SYSTEM_GET_PLATFORM_TYPE_PARAMS
class struct_NV0000_CTRL_SYSTEM_DEBUG_RMMSG_CTRL_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_DEBUG_RMMSG_CTRL_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_DEBUG_RMMSG_CTRL_PARAMS._fields_ = [
    ('cmd', ctypes.c_uint32),
    ('count', ctypes.c_uint32),
    ('data', ctypes.c_ubyte * 512),
]

NV0000_CTRL_SYSTEM_DEBUG_RMMSG_CTRL_PARAMS = struct_NV0000_CTRL_SYSTEM_DEBUG_RMMSG_CTRL_PARAMS
class struct_NV0000_CTRL_SYSTEM_HWBC_INFO(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_HWBC_INFO._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_HWBC_INFO._fields_ = [
    ('hwbcId', ctypes.c_uint32),
    ('firmwareVersion', ctypes.c_uint32),
    ('subordinateBus', ctypes.c_uint32),
    ('secondaryBus', ctypes.c_uint32),
]

NV0000_CTRL_SYSTEM_HWBC_INFO = struct_NV0000_CTRL_SYSTEM_HWBC_INFO
class struct_NV0000_CTRL_SYSTEM_GET_HWBC_INFO_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('hwbcInfo', struct_NV0000_CTRL_SYSTEM_HWBC_INFO * 128),
     ]

NV0000_CTRL_SYSTEM_GET_HWBC_INFO_PARAMS = struct_NV0000_CTRL_SYSTEM_GET_HWBC_INFO_PARAMS
class struct_NV0000_CTRL_SYSTEM_GPS_CONTROL_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_GPS_CONTROL_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_GPS_CONTROL_PARAMS._fields_ = [
    ('command', ctypes.c_uint16),
    ('locale', ctypes.c_uint16),
    ('data', ctypes.c_uint32),
]

NV0000_CTRL_SYSTEM_GPS_CONTROL_PARAMS = struct_NV0000_CTRL_SYSTEM_GPS_CONTROL_PARAMS
class struct_NV0000_CTRL_SYSTEM_GPS_BATCH_CONTROL_PARAMS(Structure):
    pass

class struct_NV0000_CTRL_SYSTEM_GPS_BATCH_CONTROL_PARAMS_0(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_GPS_BATCH_CONTROL_PARAMS_0._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_GPS_BATCH_CONTROL_PARAMS_0._fields_ = [
    ('command', ctypes.c_uint16),
    ('locale', ctypes.c_uint16),
    ('data', ctypes.c_uint32),
]

struct_NV0000_CTRL_SYSTEM_GPS_BATCH_CONTROL_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_GPS_BATCH_CONTROL_PARAMS._fields_ = [
    ('cmdCount', ctypes.c_uint32),
    ('succeeded', ctypes.c_uint32),
    ('cmdData', struct_NV0000_CTRL_SYSTEM_GPS_BATCH_CONTROL_PARAMS_0 * 16),
]

NV0000_CTRL_SYSTEM_GPS_BATCH_CONTROL_PARAMS = struct_NV0000_CTRL_SYSTEM_GPS_BATCH_CONTROL_PARAMS
class struct_NV0000_CTRL_SYSTEM_GET_P2P_CAPS_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_GET_P2P_CAPS_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_GET_P2P_CAPS_PARAMS._fields_ = [
    ('gpuIds', ctypes.c_uint32 * 32),
    ('gpuCount', ctypes.c_uint32),
    ('p2pCaps', ctypes.c_uint32),
    ('p2pOptimalReadCEs', ctypes.c_uint32),
    ('p2pOptimalWriteCEs', ctypes.c_uint32),
    ('p2pCapsStatus', ctypes.c_ubyte * 9),
    ('PADDING_0', ctypes.c_ubyte * 7),
    ('busPeerIds', ctypes.POINTER(None)),
    ('busEgmPeerIds', ctypes.POINTER(None)),
]

NV0000_CTRL_SYSTEM_GET_P2P_CAPS_PARAMS = struct_NV0000_CTRL_SYSTEM_GET_P2P_CAPS_PARAMS
class struct_NV0000_CTRL_SYSTEM_GET_P2P_CAPS_V2_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_GET_P2P_CAPS_V2_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_GET_P2P_CAPS_V2_PARAMS._fields_ = [
    ('gpuIds', ctypes.c_uint32 * 32),
    ('gpuCount', ctypes.c_uint32),
    ('p2pCaps', ctypes.c_uint32),
    ('p2pOptimalReadCEs', ctypes.c_uint32),
    ('p2pOptimalWriteCEs', ctypes.c_uint32),
    ('p2pCapsStatus', ctypes.c_ubyte * 9),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('busPeerIds', ctypes.c_uint32 * 1024),
    ('busEgmPeerIds', ctypes.c_uint32 * 1024),
]

NV0000_CTRL_SYSTEM_GET_P2P_CAPS_V2_PARAMS = struct_NV0000_CTRL_SYSTEM_GET_P2P_CAPS_V2_PARAMS
NV0000_CTRL_P2P_CAPS_MATRIX_ROW = ctypes.c_uint32 * 8
class struct_NV0000_CTRL_SYSTEM_GET_P2P_CAPS_MATRIX_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_GET_P2P_CAPS_MATRIX_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_GET_P2P_CAPS_MATRIX_PARAMS._fields_ = [
    ('grpACount', ctypes.c_uint32),
    ('grpBCount', ctypes.c_uint32),
    ('gpuIdGrpA', ctypes.c_uint32 * 8),
    ('gpuIdGrpB', ctypes.c_uint32 * 8),
    ('p2pCaps', ctypes.c_uint32 * 8 * 8),
    ('a2bOptimalReadCes', ctypes.c_uint32 * 8 * 8),
    ('a2bOptimalWriteCes', ctypes.c_uint32 * 8 * 8),
    ('b2aOptimalReadCes', ctypes.c_uint32 * 8 * 8),
    ('b2aOptimalWriteCes', ctypes.c_uint32 * 8 * 8),
]

NV0000_CTRL_SYSTEM_GET_P2P_CAPS_MATRIX_PARAMS = struct_NV0000_CTRL_SYSTEM_GET_P2P_CAPS_MATRIX_PARAMS
class struct_NV0000_CTRL_SYSTEM_GPS_CTRL_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_GPS_CTRL_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_GPS_CTRL_PARAMS._fields_ = [
    ('cmd', ctypes.c_uint32),
    ('input', ctypes.c_int32 * 2),
    ('result', ctypes.c_int32 * 4),
]

NV0000_CTRL_SYSTEM_GPS_CTRL_PARAMS = struct_NV0000_CTRL_SYSTEM_GPS_CTRL_PARAMS
class struct_NV0000_CTRL_SYSTEM_GPS_GET_PERF_SENSOR_COUNTERS_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_GPS_GET_PERF_SENSOR_COUNTERS_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_GPS_GET_PERF_SENSOR_COUNTERS_PARAMS._fields_ = [
    ('objHndl', ctypes.c_uint32),
    ('blockId', ctypes.c_uint32),
    ('nextExpectedSampleTimems', ctypes.c_uint32),
    ('countersReq', ctypes.c_uint32),
    ('countersReturned', ctypes.c_uint32),
    ('counterBlock', ctypes.c_uint32 * 32),
]

NV0000_CTRL_SYSTEM_GPS_GET_PERF_SENSOR_COUNTERS_PARAMS = struct_NV0000_CTRL_SYSTEM_GPS_GET_PERF_SENSOR_COUNTERS_PARAMS
NV0000_CTRL_SYSTEM_GPS_GET_PERF_SENSORS_PARAMS = struct_NV0000_CTRL_SYSTEM_GPS_GET_PERF_SENSOR_COUNTERS_PARAMS
NV0000_CTRL_SYSTEM_GPS_GET_EXTENDED_PERF_SENSORS_PARAMS = struct_NV0000_CTRL_SYSTEM_GPS_GET_PERF_SENSOR_COUNTERS_PARAMS
class struct_NV0000_CTRL_SYSTEM_GPS_CALL_ACPI_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_GPS_CALL_ACPI_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_GPS_CALL_ACPI_PARAMS._fields_ = [
    ('cmd', ctypes.c_uint32),
    ('input', ctypes.c_uint32),
    ('resultSz', ctypes.c_uint32),
    ('result', ctypes.c_uint32 * 288),
]

NV0000_CTRL_SYSTEM_GPS_CALL_ACPI_PARAMS = struct_NV0000_CTRL_SYSTEM_GPS_CALL_ACPI_PARAMS
class struct_NV0000_CTRL_SYSTEM_EXECUTE_ACPI_METHOD_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_EXECUTE_ACPI_METHOD_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_EXECUTE_ACPI_METHOD_PARAMS._fields_ = [
    ('method', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('inData', ctypes.POINTER(None)),
    ('inDataSize', ctypes.c_uint16),
    ('PADDING_1', ctypes.c_ubyte * 2),
    ('outStatus', ctypes.c_uint32),
    ('outData', ctypes.POINTER(None)),
    ('outDataSize', ctypes.c_uint16),
    ('PADDING_2', ctypes.c_ubyte * 6),
]

NV0000_CTRL_SYSTEM_EXECUTE_ACPI_METHOD_PARAMS = struct_NV0000_CTRL_SYSTEM_EXECUTE_ACPI_METHOD_PARAMS
class struct_NV0000_CTRL_SYSTEM_ENABLE_ETW_EVENTS_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_ENABLE_ETW_EVENTS_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_ENABLE_ETW_EVENTS_PARAMS._fields_ = [
    ('moduleMask', ctypes.c_uint32),
]

NV0000_CTRL_SYSTEM_ENABLE_ETW_EVENTS_PARAMS = struct_NV0000_CTRL_SYSTEM_ENABLE_ETW_EVENTS_PARAMS
class struct_NV0000_CTRL_SYSTEM_GPS_FRM_DATA_SAMPLE(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_GPS_FRM_DATA_SAMPLE._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_GPS_FRM_DATA_SAMPLE._fields_ = [
    ('frameTime', ctypes.c_uint16),
    ('renderTime', ctypes.c_uint16),
    ('targetTime', ctypes.c_uint16),
    ('sleepTime', ctypes.c_ubyte),
    ('sampleNumber', ctypes.c_ubyte),
]

NV0000_CTRL_SYSTEM_GPS_FRM_DATA_SAMPLE = struct_NV0000_CTRL_SYSTEM_GPS_FRM_DATA_SAMPLE
class struct_NV0000_CTRL_SYSTEM_GPS_GET_FRM_DATA_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_GPS_GET_FRM_DATA_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_GPS_GET_FRM_DATA_PARAMS._fields_ = [
    ('samples', struct_NV0000_CTRL_SYSTEM_GPS_FRM_DATA_SAMPLE * 64),
    ('nextSampleNumber', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte),
]

NV0000_CTRL_SYSTEM_GPS_GET_FRM_DATA_PARAMS = struct_NV0000_CTRL_SYSTEM_GPS_GET_FRM_DATA_PARAMS
class struct_NV0000_CTRL_SYSTEM_GPS_SET_FRM_DATA_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('sampleData', NV0000_CTRL_SYSTEM_GPS_FRM_DATA_SAMPLE),
     ]

NV0000_CTRL_SYSTEM_GPS_SET_FRM_DATA_PARAMS = struct_NV0000_CTRL_SYSTEM_GPS_SET_FRM_DATA_PARAMS
class struct_NV0000_CTRL_SYSTEM_GET_VGX_SYSTEM_INFO_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_GET_VGX_SYSTEM_INFO_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_GET_VGX_SYSTEM_INFO_PARAMS._fields_ = [
    ('szHostDriverVersionBuffer', ctypes.c_char * 256),
    ('szHostVersionBuffer', ctypes.c_char * 256),
    ('szHostTitleBuffer', ctypes.c_char * 256),
    ('szPluginTitleBuffer', ctypes.c_char * 256),
    ('szHostUnameBuffer', ctypes.c_char * 256),
    ('iHostChangelistNumber', ctypes.c_uint32),
    ('iPluginChangelistNumber', ctypes.c_uint32),
]

NV0000_CTRL_SYSTEM_GET_VGX_SYSTEM_INFO_PARAMS = struct_NV0000_CTRL_SYSTEM_GET_VGX_SYSTEM_INFO_PARAMS
class struct_NV0000_CTRL_SYSTEM_GET_GPUS_POWER_STATUS_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_GET_GPUS_POWER_STATUS_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_GET_GPUS_POWER_STATUS_PARAMS._fields_ = [
    ('gpuCount', ctypes.c_ubyte),
    ('gpuBus', ctypes.c_ubyte * 32),
    ('gpuExternalPowerStatus', ctypes.c_ubyte * 32),
]

NV0000_CTRL_SYSTEM_GET_GPUS_POWER_STATUS_PARAMS = struct_NV0000_CTRL_SYSTEM_GET_GPUS_POWER_STATUS_PARAMS
class struct_NV0000_CTRL_SYSTEM_GET_PRIVILEGED_STATUS_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_GET_PRIVILEGED_STATUS_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_GET_PRIVILEGED_STATUS_PARAMS._fields_ = [
    ('privStatusFlags', ctypes.c_ubyte),
]

NV0000_CTRL_SYSTEM_GET_PRIVILEGED_STATUS_PARAMS = struct_NV0000_CTRL_SYSTEM_GET_PRIVILEGED_STATUS_PARAMS

# values for enumeration 'NV0000_CTRL_GET_SYSTEM_FABRIC_STATUS'
NV0000_CTRL_GET_SYSTEM_FABRIC_STATUS__enumvalues = {
    1: 'NV0000_CTRL_GET_SYSTEM_FABRIC_STATUS_SKIP',
    2: 'NV0000_CTRL_GET_SYSTEM_FABRIC_STATUS_UNINITIALIZED',
    3: 'NV0000_CTRL_GET_SYSTEM_FABRIC_STATUS_IN_PROGRESS',
    4: 'NV0000_CTRL_GET_SYSTEM_FABRIC_STATUS_INITIALIZED',
}
NV0000_CTRL_GET_SYSTEM_FABRIC_STATUS_SKIP = 1
NV0000_CTRL_GET_SYSTEM_FABRIC_STATUS_UNINITIALIZED = 2
NV0000_CTRL_GET_SYSTEM_FABRIC_STATUS_IN_PROGRESS = 3
NV0000_CTRL_GET_SYSTEM_FABRIC_STATUS_INITIALIZED = 4
NV0000_CTRL_GET_SYSTEM_FABRIC_STATUS = ctypes.c_uint32 # enum
class struct_NV0000_CTRL_SYSTEM_GET_FABRIC_STATUS_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('fabricStatus', NV0000_CTRL_GET_SYSTEM_FABRIC_STATUS),
     ]

NV0000_CTRL_SYSTEM_GET_FABRIC_STATUS_PARAMS = struct_NV0000_CTRL_SYSTEM_GET_FABRIC_STATUS_PARAMS
class struct_NV0000_CTRL_VGPU_GET_VGPU_VERSION_PARAMS(Structure):
    pass

struct_NV0000_CTRL_VGPU_GET_VGPU_VERSION_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_VGPU_GET_VGPU_VERSION_PARAMS._fields_ = [
    ('host_min_supported_version', ctypes.c_uint32),
    ('host_max_supported_version', ctypes.c_uint32),
    ('user_min_supported_version', ctypes.c_uint32),
    ('user_max_supported_version', ctypes.c_uint32),
]

NV0000_CTRL_VGPU_GET_VGPU_VERSION_PARAMS = struct_NV0000_CTRL_VGPU_GET_VGPU_VERSION_PARAMS
class struct_NV0000_CTRL_VGPU_SET_VGPU_VERSION_PARAMS(Structure):
    pass

struct_NV0000_CTRL_VGPU_SET_VGPU_VERSION_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_VGPU_SET_VGPU_VERSION_PARAMS._fields_ = [
    ('min_version', ctypes.c_uint32),
    ('max_version', ctypes.c_uint32),
]

NV0000_CTRL_VGPU_SET_VGPU_VERSION_PARAMS = struct_NV0000_CTRL_VGPU_SET_VGPU_VERSION_PARAMS
class struct_NV0000_CTRL_SYSTEM_GET_RM_INSTANCE_ID_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_GET_RM_INSTANCE_ID_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_GET_RM_INSTANCE_ID_PARAMS._fields_ = [
    ('rm_instance_id', ctypes.c_uint64),
]

NV0000_CTRL_SYSTEM_GET_RM_INSTANCE_ID_PARAMS = struct_NV0000_CTRL_SYSTEM_GET_RM_INSTANCE_ID_PARAMS
class struct_NV0000_CTRL_CMD_SYSTEM_NVPCF_GET_POWER_MODE_INFO_PARAMS(Structure):
    pass

class union_NV0000_CTRL_CMD_SYSTEM_NVPCF_GET_POWER_MODE_INFO_PARAMS_filterParam(Union):
    pass

union_NV0000_CTRL_CMD_SYSTEM_NVPCF_GET_POWER_MODE_INFO_PARAMS_filterParam._pack_ = 1 # source:False
union_NV0000_CTRL_CMD_SYSTEM_NVPCF_GET_POWER_MODE_INFO_PARAMS_filterParam._fields_ = [
    ('weight', ctypes.c_ubyte),
    ('windowSize', ctypes.c_ubyte),
]

struct_NV0000_CTRL_CMD_SYSTEM_NVPCF_GET_POWER_MODE_INFO_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_CMD_SYSTEM_NVPCF_GET_POWER_MODE_INFO_PARAMS._fields_ = [
    ('gpuId', ctypes.c_uint32),
    ('tpp', ctypes.c_uint32),
    ('ratedTgp', ctypes.c_uint32),
    ('subFunc', ctypes.c_uint32),
    ('ctgpOffsetmW', ctypes.c_int32),
    ('targetTppOffsetmW', ctypes.c_int32),
    ('maxOutputOffsetmW', ctypes.c_int32),
    ('minOutputOffsetmW', ctypes.c_int32),
    ('version', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte),
    ('samplingPeriodmS', ctypes.c_uint16),
    ('samplingMulti', ctypes.c_uint16),
    ('filterType', ctypes.c_ubyte),
    ('filterParam', union_NV0000_CTRL_CMD_SYSTEM_NVPCF_GET_POWER_MODE_INFO_PARAMS_filterParam),
    ('filterReserved', ctypes.c_uint16),
    ('bIsBoostController', ctypes.c_ubyte),
    ('PADDING_1', ctypes.c_ubyte),
    ('incRatio', ctypes.c_uint16),
    ('decRatio', ctypes.c_uint16),
    ('bSupportBatt', ctypes.c_ubyte),
    ('cpuType', ctypes.c_ubyte),
    ('gpuType', ctypes.c_ubyte),
    ('PADDING_2', ctypes.c_ubyte),
]

NV0000_CTRL_CMD_SYSTEM_NVPCF_GET_POWER_MODE_INFO_PARAMS = struct_NV0000_CTRL_CMD_SYSTEM_NVPCF_GET_POWER_MODE_INFO_PARAMS
class struct_NV0000_CTRL_CMD_SYSTEM_SYNC_EXTERNAL_FABRIC_MGMT_PARAMS(Structure):
    pass

struct_NV0000_CTRL_CMD_SYSTEM_SYNC_EXTERNAL_FABRIC_MGMT_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_CMD_SYSTEM_SYNC_EXTERNAL_FABRIC_MGMT_PARAMS._fields_ = [
    ('bExternalFabricMgmt', ctypes.c_ubyte),
]

NV0000_CTRL_CMD_SYSTEM_SYNC_EXTERNAL_FABRIC_MGMT_PARAMS = struct_NV0000_CTRL_CMD_SYSTEM_SYNC_EXTERNAL_FABRIC_MGMT_PARAMS
class struct_NV0000_CTRL_SYSTEM_GET_CLIENT_DATABASE_INFO_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_GET_CLIENT_DATABASE_INFO_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_GET_CLIENT_DATABASE_INFO_PARAMS._fields_ = [
    ('clientCount', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('resourceCount', ctypes.c_uint64),
]

NV0000_CTRL_SYSTEM_GET_CLIENT_DATABASE_INFO_PARAMS = struct_NV0000_CTRL_SYSTEM_GET_CLIENT_DATABASE_INFO_PARAMS
class struct_NV0000_CTRL_SYSTEM_GET_BUILD_VERSION_V2_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_GET_BUILD_VERSION_V2_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_GET_BUILD_VERSION_V2_PARAMS._fields_ = [
    ('driverVersionBuffer', ctypes.c_char * 256),
    ('versionBuffer', ctypes.c_char * 256),
    ('titleBuffer', ctypes.c_char * 256),
    ('changelistNumber', ctypes.c_uint32),
    ('officialChangelistNumber', ctypes.c_uint32),
]

NV0000_CTRL_SYSTEM_GET_BUILD_VERSION_V2_PARAMS = struct_NV0000_CTRL_SYSTEM_GET_BUILD_VERSION_V2_PARAMS
class struct_NV0000_CTRL_SYSTEM_RMCTRL_CACHE_MODE_CTRL_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_RMCTRL_CACHE_MODE_CTRL_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_RMCTRL_CACHE_MODE_CTRL_PARAMS._fields_ = [
    ('cmd', ctypes.c_uint32),
    ('mode', ctypes.c_uint32),
]

NV0000_CTRL_SYSTEM_RMCTRL_CACHE_MODE_CTRL_PARAMS = struct_NV0000_CTRL_SYSTEM_RMCTRL_CACHE_MODE_CTRL_PARAMS
class struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_CONTROL_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_CONTROL_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_CONTROL_PARAMS._fields_ = [
    ('command', ctypes.c_uint16),
    ('locale', ctypes.c_uint16),
    ('data', ctypes.c_uint32),
]

NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_CONTROL_PARAMS = struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_CONTROL_PARAMS
class struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_BATCH_CONTROL_PARAMS(Structure):
    pass

class struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_BATCH_CONTROL_PARAMS_0(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_BATCH_CONTROL_PARAMS_0._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_BATCH_CONTROL_PARAMS_0._fields_ = [
    ('command', ctypes.c_uint16),
    ('locale', ctypes.c_uint16),
    ('data', ctypes.c_uint32),
]

struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_BATCH_CONTROL_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_BATCH_CONTROL_PARAMS._fields_ = [
    ('cmdCount', ctypes.c_uint32),
    ('succeeded', ctypes.c_uint32),
    ('cmdData', struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_BATCH_CONTROL_PARAMS_0 * 16),
]

NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_BATCH_CONTROL_PARAMS = struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_BATCH_CONTROL_PARAMS
class struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_CTRL_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_CTRL_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_CTRL_PARAMS._fields_ = [
    ('cmd', ctypes.c_uint32),
    ('input', ctypes.c_int32 * 2),
    ('result', ctypes.c_int32 * 4),
]

NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_CTRL_PARAMS = struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_CTRL_PARAMS
class struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_GET_PERF_SENSOR_COUNTERS_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_GET_PERF_SENSOR_COUNTERS_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_GET_PERF_SENSOR_COUNTERS_PARAMS._fields_ = [
    ('objHndl', ctypes.c_uint32),
    ('blockId', ctypes.c_uint32),
    ('nextExpectedSampleTimems', ctypes.c_uint32),
    ('countersReq', ctypes.c_uint32),
    ('countersReturned', ctypes.c_uint32),
    ('counterBlock', ctypes.c_uint32 * 32),
]

NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_GET_PERF_SENSOR_COUNTERS_PARAMS = struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_GET_PERF_SENSOR_COUNTERS_PARAMS
NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_GET_PERF_SENSORS_PARAMS = struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_GET_PERF_SENSOR_COUNTERS_PARAMS
NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_GET_EXTENDED_PERF_SENSORS_PARAMS = struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_GET_PERF_SENSOR_COUNTERS_PARAMS
class struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_CALL_ACPI_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_CALL_ACPI_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_CALL_ACPI_PARAMS._fields_ = [
    ('cmd', ctypes.c_uint32),
    ('input', ctypes.c_uint32),
    ('resultSz', ctypes.c_uint32),
    ('result', ctypes.c_uint32 * 288),
]

NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_CALL_ACPI_PARAMS = struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_CALL_ACPI_PARAMS
class struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_FRM_DATA_SAMPLE(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_FRM_DATA_SAMPLE._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_FRM_DATA_SAMPLE._fields_ = [
    ('frameTime', ctypes.c_uint16),
    ('renderTime', ctypes.c_uint16),
    ('targetTime', ctypes.c_uint16),
    ('sleepTime', ctypes.c_ubyte),
    ('sampleNumber', ctypes.c_ubyte),
]

NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_FRM_DATA_SAMPLE = struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_FRM_DATA_SAMPLE
class struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_GET_FRM_DATA_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_GET_FRM_DATA_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_GET_FRM_DATA_PARAMS._fields_ = [
    ('samples', struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_FRM_DATA_SAMPLE * 64),
    ('nextSampleNumber', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte),
]

NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_GET_FRM_DATA_PARAMS = struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_GET_FRM_DATA_PARAMS
class struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_SET_FRM_DATA_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('sampleData', NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_FRM_DATA_SAMPLE),
     ]

NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_SET_FRM_DATA_PARAMS = struct_NV0000_CTRL_SYSTEM_PFM_REQ_HNDLR_SET_FRM_DATA_PARAMS
class struct_NV0000_CTRL_GPU_GET_ATTACHED_IDS_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPU_GET_ATTACHED_IDS_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_GET_ATTACHED_IDS_PARAMS._fields_ = [
    ('gpuIds', ctypes.c_uint32 * 32),
]

NV0000_CTRL_GPU_GET_ATTACHED_IDS_PARAMS = struct_NV0000_CTRL_GPU_GET_ATTACHED_IDS_PARAMS
class struct_NV0000_CTRL_GPU_GET_ID_INFO_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPU_GET_ID_INFO_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_GET_ID_INFO_PARAMS._fields_ = [
    ('gpuId', ctypes.c_uint32),
    ('gpuFlags', ctypes.c_uint32),
    ('deviceInstance', ctypes.c_uint32),
    ('subDeviceInstance', ctypes.c_uint32),
    ('szName', ctypes.POINTER(None)),
    ('sliStatus', ctypes.c_uint32),
    ('boardId', ctypes.c_uint32),
    ('gpuInstance', ctypes.c_uint32),
    ('numaId', ctypes.c_int32),
]

NV0000_CTRL_GPU_GET_ID_INFO_PARAMS = struct_NV0000_CTRL_GPU_GET_ID_INFO_PARAMS
class struct_NV0000_CTRL_GPU_GET_ID_INFO_V2_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPU_GET_ID_INFO_V2_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_GET_ID_INFO_V2_PARAMS._fields_ = [
    ('gpuId', ctypes.c_uint32),
    ('gpuFlags', ctypes.c_uint32),
    ('deviceInstance', ctypes.c_uint32),
    ('subDeviceInstance', ctypes.c_uint32),
    ('sliStatus', ctypes.c_uint32),
    ('boardId', ctypes.c_uint32),
    ('gpuInstance', ctypes.c_uint32),
    ('numaId', ctypes.c_int32),
]

NV0000_CTRL_GPU_GET_ID_INFO_V2_PARAMS = struct_NV0000_CTRL_GPU_GET_ID_INFO_V2_PARAMS
class struct_NV0000_CTRL_GPU_GET_INIT_STATUS_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPU_GET_INIT_STATUS_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_GET_INIT_STATUS_PARAMS._fields_ = [
    ('gpuId', ctypes.c_uint32),
    ('status', ctypes.c_uint32),
]

NV0000_CTRL_GPU_GET_INIT_STATUS_PARAMS = struct_NV0000_CTRL_GPU_GET_INIT_STATUS_PARAMS
class struct_NV0000_CTRL_GPU_GET_DEVICE_IDS_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPU_GET_DEVICE_IDS_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_GET_DEVICE_IDS_PARAMS._fields_ = [
    ('deviceIds', ctypes.c_uint32),
]

NV0000_CTRL_GPU_GET_DEVICE_IDS_PARAMS = struct_NV0000_CTRL_GPU_GET_DEVICE_IDS_PARAMS
class struct_NV0000_CTRL_GPU_GET_PROBED_IDS_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPU_GET_PROBED_IDS_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_GET_PROBED_IDS_PARAMS._fields_ = [
    ('gpuIds', ctypes.c_uint32 * 32),
    ('excludedGpuIds', ctypes.c_uint32 * 32),
]

NV0000_CTRL_GPU_GET_PROBED_IDS_PARAMS = struct_NV0000_CTRL_GPU_GET_PROBED_IDS_PARAMS
class struct_NV0000_CTRL_GPU_GET_PCI_INFO_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPU_GET_PCI_INFO_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_GET_PCI_INFO_PARAMS._fields_ = [
    ('gpuId', ctypes.c_uint32),
    ('domain', ctypes.c_uint32),
    ('bus', ctypes.c_uint16),
    ('slot', ctypes.c_uint16),
]

NV0000_CTRL_GPU_GET_PCI_INFO_PARAMS = struct_NV0000_CTRL_GPU_GET_PCI_INFO_PARAMS
class struct_NV0000_CTRL_GPU_ATTACH_IDS_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPU_ATTACH_IDS_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_ATTACH_IDS_PARAMS._fields_ = [
    ('gpuIds', ctypes.c_uint32 * 32),
    ('failedId', ctypes.c_uint32),
]

NV0000_CTRL_GPU_ATTACH_IDS_PARAMS = struct_NV0000_CTRL_GPU_ATTACH_IDS_PARAMS
class struct_NV0000_CTRL_GPU_DETACH_IDS_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPU_DETACH_IDS_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_DETACH_IDS_PARAMS._fields_ = [
    ('gpuIds', ctypes.c_uint32 * 32),
]

NV0000_CTRL_GPU_DETACH_IDS_PARAMS = struct_NV0000_CTRL_GPU_DETACH_IDS_PARAMS
class struct_NV0000_CTRL_GPU_VIDEO_LINKS(Structure):
    pass

struct_NV0000_CTRL_GPU_VIDEO_LINKS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_VIDEO_LINKS._fields_ = [
    ('gpuId', ctypes.c_uint32),
    ('connectedGpuIds', ctypes.c_uint32 * 8),
]

NV0000_CTRL_GPU_VIDEO_LINKS = struct_NV0000_CTRL_GPU_VIDEO_LINKS
class struct_NV0000_CTRL_GPU_GET_VIDEO_LINKS_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('links', struct_NV0000_CTRL_GPU_VIDEO_LINKS * 32),
     ]

NV0000_CTRL_GPU_GET_VIDEO_LINKS_PARAMS = struct_NV0000_CTRL_GPU_GET_VIDEO_LINKS_PARAMS
class struct_NV0000_CTRL_GPU_GET_SVM_SIZE_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPU_GET_SVM_SIZE_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_GET_SVM_SIZE_PARAMS._fields_ = [
    ('gpuId', ctypes.c_uint32),
    ('svmSize', ctypes.c_uint32),
]

NV0000_CTRL_GPU_GET_SVM_SIZE_PARAMS = struct_NV0000_CTRL_GPU_GET_SVM_SIZE_PARAMS
class struct_NV0000_CTRL_GPU_GET_UUID_INFO_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPU_GET_UUID_INFO_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_GET_UUID_INFO_PARAMS._fields_ = [
    ('gpuUuid', ctypes.c_ubyte * 256),
    ('flags', ctypes.c_uint32),
    ('gpuId', ctypes.c_uint32),
    ('deviceInstance', ctypes.c_uint32),
    ('subdeviceInstance', ctypes.c_uint32),
]

NV0000_CTRL_GPU_GET_UUID_INFO_PARAMS = struct_NV0000_CTRL_GPU_GET_UUID_INFO_PARAMS
class struct_NV0000_CTRL_GPU_GET_UUID_FROM_GPU_ID_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPU_GET_UUID_FROM_GPU_ID_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_GET_UUID_FROM_GPU_ID_PARAMS._fields_ = [
    ('gpuId', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('gpuUuid', ctypes.c_ubyte * 256),
    ('uuidStrLen', ctypes.c_uint32),
]

NV0000_CTRL_GPU_GET_UUID_FROM_GPU_ID_PARAMS = struct_NV0000_CTRL_GPU_GET_UUID_FROM_GPU_ID_PARAMS
class struct_NV0000_CTRL_GPU_MODIFY_DRAIN_STATE_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPU_MODIFY_DRAIN_STATE_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_MODIFY_DRAIN_STATE_PARAMS._fields_ = [
    ('gpuId', ctypes.c_uint32),
    ('newState', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
]

NV0000_CTRL_GPU_MODIFY_DRAIN_STATE_PARAMS = struct_NV0000_CTRL_GPU_MODIFY_DRAIN_STATE_PARAMS
class struct_NV0000_CTRL_GPU_QUERY_DRAIN_STATE_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPU_QUERY_DRAIN_STATE_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_QUERY_DRAIN_STATE_PARAMS._fields_ = [
    ('gpuId', ctypes.c_uint32),
    ('drainState', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
]

NV0000_CTRL_GPU_QUERY_DRAIN_STATE_PARAMS = struct_NV0000_CTRL_GPU_QUERY_DRAIN_STATE_PARAMS
class struct_NV0000_CTRL_GPU_DISCOVER_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPU_DISCOVER_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_DISCOVER_PARAMS._fields_ = [
    ('domain', ctypes.c_uint32),
    ('bus', ctypes.c_ubyte),
    ('slot', ctypes.c_ubyte),
    ('function', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte),
]

NV0000_CTRL_GPU_DISCOVER_PARAMS = struct_NV0000_CTRL_GPU_DISCOVER_PARAMS
class struct_NV0000_CTRL_GPU_GET_MEMOP_ENABLE_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPU_GET_MEMOP_ENABLE_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_GET_MEMOP_ENABLE_PARAMS._fields_ = [
    ('enableMask', ctypes.c_uint32),
]

NV0000_CTRL_GPU_GET_MEMOP_ENABLE_PARAMS = struct_NV0000_CTRL_GPU_GET_MEMOP_ENABLE_PARAMS
class struct_NV0000_CTRL_GPU_DISABLE_NVLINK_INIT_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPU_DISABLE_NVLINK_INIT_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_DISABLE_NVLINK_INIT_PARAMS._fields_ = [
    ('gpuId', ctypes.c_uint32),
    ('mask', ctypes.c_uint32),
    ('bSkipHwNvlinkDisable', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV0000_CTRL_GPU_DISABLE_NVLINK_INIT_PARAMS = struct_NV0000_CTRL_GPU_DISABLE_NVLINK_INIT_PARAMS
class struct_NV0000_CTRL_GPU_LEGACY_CONFIG_PARAMS(Structure):
    pass

class union_NV0000_CTRL_GPU_LEGACY_CONFIG_PARAMS_data(Union):
    pass

class struct_NV0000_CTRL_GPU_LEGACY_CONFIG_PARAMS_0_configSet(Structure):
    pass

struct_NV0000_CTRL_GPU_LEGACY_CONFIG_PARAMS_0_configSet._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_LEGACY_CONFIG_PARAMS_0_configSet._fields_ = [
    ('newValue', ctypes.c_uint32),
    ('oldValue', ctypes.c_uint32),
]

class struct_NV0000_CTRL_GPU_LEGACY_CONFIG_PARAMS_0_configEx(Structure):
    pass

struct_NV0000_CTRL_GPU_LEGACY_CONFIG_PARAMS_0_configEx._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_LEGACY_CONFIG_PARAMS_0_configEx._fields_ = [
    ('paramData', ctypes.c_ubyte * 373),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('paramSize', ctypes.c_uint32),
]

class struct_NV0000_CTRL_GPU_LEGACY_CONFIG_PARAMS_0_reservedProperty(Structure):
    pass

struct_NV0000_CTRL_GPU_LEGACY_CONFIG_PARAMS_0_reservedProperty._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_LEGACY_CONFIG_PARAMS_0_reservedProperty._fields_ = [
    ('propertyId', ctypes.c_uint32),
    ('propertyIn', ctypes.c_uint32 * 6),
    ('propertyOut', ctypes.c_uint32 * 5),
]

union_NV0000_CTRL_GPU_LEGACY_CONFIG_PARAMS_data._pack_ = 1 # source:False
union_NV0000_CTRL_GPU_LEGACY_CONFIG_PARAMS_data._fields_ = [
    ('configSet', struct_NV0000_CTRL_GPU_LEGACY_CONFIG_PARAMS_0_configSet),
    ('configEx', struct_NV0000_CTRL_GPU_LEGACY_CONFIG_PARAMS_0_configEx),
    ('reservedProperty', struct_NV0000_CTRL_GPU_LEGACY_CONFIG_PARAMS_0_reservedProperty),
    ('PADDING_0', ctypes.c_ubyte * 332),
]

struct_NV0000_CTRL_GPU_LEGACY_CONFIG_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_LEGACY_CONFIG_PARAMS._fields_ = [
    ('hContext', ctypes.c_uint32),
    ('opType', ctypes.c_uint32),
    ('index', ctypes.c_uint32),
    ('dataType', ctypes.c_uint32),
    ('data', union_NV0000_CTRL_GPU_LEGACY_CONFIG_PARAMS_data),
]

NV0000_CTRL_GPU_LEGACY_CONFIG_PARAMS = struct_NV0000_CTRL_GPU_LEGACY_CONFIG_PARAMS
class struct_NV0000_CTRL_GPU_IDLE_CHANNELS_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPU_IDLE_CHANNELS_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_IDLE_CHANNELS_PARAMS._fields_ = [
    ('hDevice', ctypes.c_uint32),
    ('hChannel', ctypes.c_uint32),
    ('numChannels', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('phClients', ctypes.POINTER(None)),
    ('phDevices', ctypes.POINTER(None)),
    ('phChannels', ctypes.POINTER(None)),
    ('flags', ctypes.c_uint32),
    ('timeout', ctypes.c_uint32),
]

NV0000_CTRL_GPU_IDLE_CHANNELS_PARAMS = struct_NV0000_CTRL_GPU_IDLE_CHANNELS_PARAMS
class struct_NV0000_CTRL_GPU_PUSH_GSP_UCODE_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPU_PUSH_GSP_UCODE_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_PUSH_GSP_UCODE_PARAMS._fields_ = [
    ('image', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 7),
    ('totalSize', ctypes.c_uint64),
    ('pData', ctypes.POINTER(None)),
]

NV0000_CTRL_GPU_PUSH_GSP_UCODE_PARAMS = struct_NV0000_CTRL_GPU_PUSH_GSP_UCODE_PARAMS
class struct_NV0000_CTRL_GPU_SET_NVLINK_BW_MODE_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPU_SET_NVLINK_BW_MODE_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_SET_NVLINK_BW_MODE_PARAMS._fields_ = [
    ('mode', ctypes.c_ubyte),
]

NV0000_CTRL_GPU_SET_NVLINK_BW_MODE_PARAMS = struct_NV0000_CTRL_GPU_SET_NVLINK_BW_MODE_PARAMS
class struct_NV0000_CTRL_GPU_GET_NVLINK_BW_MODE_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPU_GET_NVLINK_BW_MODE_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_GET_NVLINK_BW_MODE_PARAMS._fields_ = [
    ('mode', ctypes.c_ubyte),
]

NV0000_CTRL_GPU_GET_NVLINK_BW_MODE_PARAMS = struct_NV0000_CTRL_GPU_GET_NVLINK_BW_MODE_PARAMS
class struct_NV0000_CTRL_GPU_ACTIVE_DEVICE(Structure):
    pass

struct_NV0000_CTRL_GPU_ACTIVE_DEVICE._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_ACTIVE_DEVICE._fields_ = [
    ('gpuId', ctypes.c_uint32),
    ('gpuInstanceId', ctypes.c_uint32),
    ('computeInstanceId', ctypes.c_uint32),
]

NV0000_CTRL_GPU_ACTIVE_DEVICE = struct_NV0000_CTRL_GPU_ACTIVE_DEVICE
class struct_NV0000_CTRL_GPU_GET_ACTIVE_DEVICE_IDS_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPU_GET_ACTIVE_DEVICE_IDS_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_GET_ACTIVE_DEVICE_IDS_PARAMS._fields_ = [
    ('numDevices', ctypes.c_uint32),
    ('devices', struct_NV0000_CTRL_GPU_ACTIVE_DEVICE * 256),
]

NV0000_CTRL_GPU_GET_ACTIVE_DEVICE_IDS_PARAMS = struct_NV0000_CTRL_GPU_GET_ACTIVE_DEVICE_IDS_PARAMS
class struct_NV0000_CTRL_GPU_ASYNC_ATTACH_ID_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPU_ASYNC_ATTACH_ID_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_ASYNC_ATTACH_ID_PARAMS._fields_ = [
    ('gpuId', ctypes.c_uint32),
]

NV0000_CTRL_GPU_ASYNC_ATTACH_ID_PARAMS = struct_NV0000_CTRL_GPU_ASYNC_ATTACH_ID_PARAMS
class struct_NV0000_CTRL_GPU_WAIT_ATTACH_ID_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPU_WAIT_ATTACH_ID_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPU_WAIT_ATTACH_ID_PARAMS._fields_ = [
    ('gpuId', ctypes.c_uint32),
]

NV0000_CTRL_GPU_WAIT_ATTACH_ID_PARAMS = struct_NV0000_CTRL_GPU_WAIT_ATTACH_ID_PARAMS
NV0000_CTRL_CMD_GPUACCT_SET_ACCOUNTING_STATE = (0xb01) # macro
NV0000_CTRL_GPU_ACCOUNTING_STATE_ENABLED = (0x00000000) # macro
NV0000_CTRL_GPU_ACCOUNTING_STATE_DISABLED = (0x00000001) # macro
NV0000_CTRL_GPUACCT_SET_ACCOUNTING_STATE_PARAMS_MESSAGE_ID = (0x1) # macro
NV0000_CTRL_CMD_GPUACCT_GET_ACCOUNTING_STATE = (0xb02) # macro
NV0000_CTRL_GPUACCT_GET_ACCOUNTING_STATE_PARAMS_MESSAGE_ID = (0x2) # macro
NV0000_CTRL_CMD_GPUACCT_GET_PROC_ACCOUNTING_INFO = (0xb03) # macro
NV0000_CTRL_GPUACCT_GET_PROC_ACCOUNTING_INFO_PARAMS_MESSAGE_ID = (0x3) # macro
NV0000_CTRL_CMD_GPUACCT_GET_ACCOUNTING_PIDS = (0xb04) # macro
NV0000_GPUACCT_PID_MAX_COUNT = 4000 # macro
NV0000_CTRL_GPUACCT_GET_ACCOUNTING_PIDS_PARAMS_MESSAGE_ID = (0x4) # macro
NV0000_CTRL_CMD_GPUACCT_CLEAR_ACCOUNTING_DATA = (0xb05) # macro
NV0000_CTRL_GPUACCT_CLEAR_ACCOUNTING_DATA_PARAMS_MESSAGE_ID = (0x5) # macro
class struct_NV0000_CTRL_GPUACCT_SET_ACCOUNTING_STATE_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPUACCT_SET_ACCOUNTING_STATE_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPUACCT_SET_ACCOUNTING_STATE_PARAMS._fields_ = [
    ('gpuId', ctypes.c_uint32),
    ('pid', ctypes.c_uint32),
    ('newState', ctypes.c_uint32),
]

NV0000_CTRL_GPUACCT_SET_ACCOUNTING_STATE_PARAMS = struct_NV0000_CTRL_GPUACCT_SET_ACCOUNTING_STATE_PARAMS
class struct_NV0000_CTRL_GPUACCT_GET_ACCOUNTING_STATE_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPUACCT_GET_ACCOUNTING_STATE_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPUACCT_GET_ACCOUNTING_STATE_PARAMS._fields_ = [
    ('gpuId', ctypes.c_uint32),
    ('pid', ctypes.c_uint32),
    ('state', ctypes.c_uint32),
]

NV0000_CTRL_GPUACCT_GET_ACCOUNTING_STATE_PARAMS = struct_NV0000_CTRL_GPUACCT_GET_ACCOUNTING_STATE_PARAMS
class struct_NV0000_CTRL_GPUACCT_GET_PROC_ACCOUNTING_INFO_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPUACCT_GET_PROC_ACCOUNTING_INFO_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPUACCT_GET_PROC_ACCOUNTING_INFO_PARAMS._fields_ = [
    ('gpuId', ctypes.c_uint32),
    ('pid', ctypes.c_uint32),
    ('subPid', ctypes.c_uint32),
    ('gpuUtil', ctypes.c_uint32),
    ('fbUtil', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('maxFbUsage', ctypes.c_uint64),
    ('startTime', ctypes.c_uint64),
    ('endTime', ctypes.c_uint64),
]

NV0000_CTRL_GPUACCT_GET_PROC_ACCOUNTING_INFO_PARAMS = struct_NV0000_CTRL_GPUACCT_GET_PROC_ACCOUNTING_INFO_PARAMS
class struct_NV0000_CTRL_GPUACCT_GET_ACCOUNTING_PIDS_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPUACCT_GET_ACCOUNTING_PIDS_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPUACCT_GET_ACCOUNTING_PIDS_PARAMS._fields_ = [
    ('gpuId', ctypes.c_uint32),
    ('pid', ctypes.c_uint32),
    ('pidTbl', ctypes.c_uint32 * 4000),
    ('pidCount', ctypes.c_uint32),
]

NV0000_CTRL_GPUACCT_GET_ACCOUNTING_PIDS_PARAMS = struct_NV0000_CTRL_GPUACCT_GET_ACCOUNTING_PIDS_PARAMS
class struct_NV0000_CTRL_GPUACCT_CLEAR_ACCOUNTING_DATA_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GPUACCT_CLEAR_ACCOUNTING_DATA_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GPUACCT_CLEAR_ACCOUNTING_DATA_PARAMS._fields_ = [
    ('gpuId', ctypes.c_uint32),
    ('pid', ctypes.c_uint32),
]

NV0000_CTRL_GPUACCT_CLEAR_ACCOUNTING_DATA_PARAMS = struct_NV0000_CTRL_GPUACCT_CLEAR_ACCOUNTING_DATA_PARAMS
NV0000_CTRL_CMD_GSYNC_GET_ATTACHED_IDS = (0x301) # macro
NV0000_CTRL_GSYNC_GET_ATTACHED_IDS_PARAMS_MESSAGE_ID = (0x1) # macro
NV0000_CTRL_GSYNC_INVALID_ID = (0xffffffff) # macro
NV0000_CTRL_CMD_GSYNC_GET_ID_INFO = (0x302) # macro
NV0000_CTRL_GSYNC_GET_ID_INFO_PARAMS_MESSAGE_ID = (0x2) # macro
class struct_NV0000_CTRL_GSYNC_GET_ATTACHED_IDS_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GSYNC_GET_ATTACHED_IDS_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GSYNC_GET_ATTACHED_IDS_PARAMS._fields_ = [
    ('gsyncIds', ctypes.c_uint32 * 4),
]

NV0000_CTRL_GSYNC_GET_ATTACHED_IDS_PARAMS = struct_NV0000_CTRL_GSYNC_GET_ATTACHED_IDS_PARAMS
class struct_NV0000_CTRL_GSYNC_GET_ID_INFO_PARAMS(Structure):
    pass

struct_NV0000_CTRL_GSYNC_GET_ID_INFO_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_GSYNC_GET_ID_INFO_PARAMS._fields_ = [
    ('gsyncId', ctypes.c_uint32),
    ('gsyncFlags', ctypes.c_uint32),
    ('gsyncInstance', ctypes.c_uint32),
]

NV0000_CTRL_GSYNC_GET_ID_INFO_PARAMS = struct_NV0000_CTRL_GSYNC_GET_ID_INFO_PARAMS
NV0000_CTRL_NVD_DUMP_COMPONENT_SYS = (0x400) # macro
NV0000_CTRL_NVD_DUMP_COMPONENT_NVLOG = (0x800) # macro
NV0000_CTRL_NVD_DUMP_COMPONENT_RESERVED = (0xB00) # macro
NV0000_CTRL_CMD_NVD_GET_DUMP_SIZE = (0x601) # macro
NV0000_CTRL_NVD_GET_DUMP_SIZE_PARAMS_MESSAGE_ID = (0x1) # macro
NV0000_CTRL_NVD_MAX_DUMP_SIZE = (1000000) # macro
NV0000_CTRL_CMD_NVD_GET_DUMP = (0x602) # macro
NV0000_CTRL_NVD_GET_DUMP_PARAMS_MESSAGE_ID = (0x2) # macro
NV0000_NVD_CPU_TIME_CLK_ID_DEFAULT = (0x00000000) # macro
NV0000_NVD_CPU_TIME_CLK_ID_OSTIME = (0x00000001) # macro
NV0000_NVD_CPU_TIME_CLK_ID_TSC = (0x00000002) # macro
NV0000_NVD_CPU_TIME_CLK_ID_PLATFORM_API = (0x00000003) # macro
NV0000_CTRL_CMD_NVD_GET_TIMESTAMP = (0x603) # macro
NV0000_CTRL_NVD_GET_TIMESTAMP_PARAMS_MESSAGE_ID = (0x3) # macro
NV0000_CTRL_CMD_NVD_GET_NVLOG_INFO = (0x604) # macro
NV0000_CTRL_NVD_MAX_RUNTIME_SIZES = (16) # macro
NV0000_CTRL_NVD_SIGNATURE_SIZE = (4) # macro
NV0000_CTRL_NVD_MAX_BUFFERS = (256) # macro
NV0000_CTRL_NVD_GET_NVLOG_INFO_PARAMS_MESSAGE_ID = (0x4) # macro
NV0000_CTRL_NVD_RUNTIME_SIZE_UNUSED = (0) # macro
NV0000_CTRL_NVD_RUNTIME_SIZE_INT = (1) # macro
NV0000_CTRL_NVD_RUNTIME_SIZE_LONG_LONG = (2) # macro
NV0000_CTRL_NVD_RUNTIME_SIZE_STRING = (3) # macro
NV0000_CTRL_NVD_RUNTIME_SIZE_PTR = (4) # macro
NV0000_CTRL_NVD_RUNTIME_SIZE_CHAR = (5) # macro
NV0000_CTRL_NVD_RUNTIME_SIZE_FLOAT = (6) # macro
NV0000_CTRL_NVD_NVLOG_INFO_PRINTFLAGS_BUFFER_INFO = ['7', ':', '0'] # macro
NV0000_CTRL_NVD_NVLOG_INFO_PRINTFLAGS_BUFFER_SIZE = ['23', ':', '8'] # macro
NV0000_CTRL_NVD_NVLOG_INFO_PRINTFLAGS_BUFFER_SIZE_DISABLE = (0x00000000) # macro
NV0000_CTRL_NVD_NVLOG_INFO_PRINTFLAGS_BUFFER_SIZE_DEFAULT = (0x00000004) # macro
NV0000_CTRL_NVD_NVLOG_INFO_PRINTFLAGS_RUNTIME_LEVEL = ['28', ':', '25'] # macro
NV0000_CTRL_NVD_NVLOG_INFO_PRINTFLAGS_TIMESTAMP = ['30', ':', '29'] # macro
NV0000_CTRL_NVD_NVLOG_INFO_PRINTFLAGS_TIMESTAMP_NONE = (0x00000000) # macro
NV0000_CTRL_NVD_NVLOG_INFO_PRINTFLAGS_TIMESTAMP_32 = (0x00000001) # macro
NV0000_CTRL_NVD_NVLOG_INFO_PRINTFLAGS_TIMESTAMP_64 = (0x00000002) # macro
NV0000_CTRL_NVD_NVLOG_INFO_PRINTFLAGS_TIMESTAMP_32_DIFF = (0x00000003) # macro
NV0000_CTRL_NVD_NVLOG_INFO_PRINTFLAGS_INITED = ['31', ':', '31'] # macro
NV0000_CTRL_NVD_NVLOG_INFO_PRINTFLAGS_INITED_NO = (0x00000000) # macro
NV0000_CTRL_NVD_NVLOG_INFO_PRINTFLAGS_INITED_YES = (0x00000001) # macro
NV0000_CTRL_CMD_NVD_GET_NVLOG_BUFFER_INFO = (0x605) # macro
NV0000_CTRL_NVD_GET_NVLOG_BUFFER_INFO_PARAMS_MESSAGE_ID = (0x5) # macro
NV0000_CTRL_NVD_NVLOG_BUFFER_INFO_FLAGS_PAUSE = ['0', ':', '0'] # macro
NV0000_CTRL_NVD_NVLOG_BUFFER_INFO_FLAGS_PAUSE_NO = (0x00000000) # macro
NV0000_CTRL_NVD_NVLOG_BUFFER_INFO_FLAGS_PAUSE_YES = (0x00000001) # macro
NV0000_CTRL_NVD_NVLOG_BUFFER_INFO_FLAGS_DISABLED = ['0', ':', '0'] # macro
NV0000_CTRL_NVD_NVLOG_BUFFER_INFO_FLAGS_DISABLED_NO = (0x00000000) # macro
NV0000_CTRL_NVD_NVLOG_BUFFER_INFO_FLAGS_DISABLED_YES = (0x00000001) # macro
NV0000_CTRL_NVD_NVLOG_BUFFER_INFO_FLAGS_TYPE = ['1', ':', '1'] # macro
NV0000_CTRL_NVD_NVLOG_BUFFER_INFO_FLAGS_TYPE_RING = (0x00000000) # macro
NV0000_CTRL_NVD_NVLOG_BUFFER_INFO_FLAGS_TYPE_NOWRAP = (0x00000001) # macro
NV0000_CTRL_NVD_NVLOG_BUFFER_INFO_FLAGS_EXPANDABLE = ['2', ':', '2'] # macro
NV0000_CTRL_NVD_NVLOG_BUFFER_INFO_FLAGS_EXPANDABLE_NO = (0x00000000) # macro
NV0000_CTRL_NVD_NVLOG_BUFFER_INFO_FLAGS_EXPANDABLE_YES = (0x00000001) # macro
NV0000_CTRL_NVD_NVLOG_BUFFER_INFO_FLAGS_NONPAGED = ['3', ':', '3'] # macro
NV0000_CTRL_NVD_NVLOG_BUFFER_INFO_FLAGS_NONPAGED_NO = (0x00000000) # macro
NV0000_CTRL_NVD_NVLOG_BUFFER_INFO_FLAGS_NONPAGED_YES = (0x00000001) # macro
NV0000_CTRL_NVD_NVLOG_BUFFER_INFO_FLAGS_LOCKING = ['5', ':', '4'] # macro
NV0000_CTRL_NVD_NVLOG_BUFFER_INFO_FLAGS_LOCKING_NONE = (0x00000000) # macro
NV0000_CTRL_NVD_NVLOG_BUFFER_INFO_FLAGS_LOCKING_STATE = (0x00000001) # macro
NV0000_CTRL_NVD_NVLOG_BUFFER_INFO_FLAGS_LOCKING_FULL = (0x00000002) # macro
NV0000_CTRL_NVD_NVLOG_BUFFER_INFO_FLAGS_OCA = ['6', ':', '6'] # macro
NV0000_CTRL_NVD_NVLOG_BUFFER_INFO_FLAGS_OCA_NO = (0x00000000) # macro
NV0000_CTRL_NVD_NVLOG_BUFFER_INFO_FLAGS_OCA_YES = (0x00000001) # macro
NV0000_CTRL_CMD_NVD_GET_NVLOG = (0x606) # macro
NV0000_CTRL_NVLOG_MAX_BLOCK_SIZE = (4000) # macro
NV0000_CTRL_NVD_GET_NVLOG_PARAMS_MESSAGE_ID = (0x6) # macro
NV0000_CTRL_CMD_NVD_GET_RCERR_RPT = (0x607) # macro
NV0000_CTRL_CMD_NVD_RCERR_RPT_MAX_ENTRIES = 200 # macro
NV0000_CTRL_CMD_NVD_RCERR_RPT_TYPE_TEST = 0 # macro
NV0000_CTRL_CMD_NVD_RCERR_RPT_TYPE_GRSTATUS = 1 # macro
NV0000_CTRL_CMD_NVD_RCERR_RPT_TYPE_GPCSTATUS = 2 # macro
NV0000_CTRL_CMD_NVD_RCERR_RPT_TYPE_MMU_FAULT_STATUS = 3 # macro
NV0000_CTRL_CMD_NVD_RCERR_RPT_REG_EMPTY = 0x00000000 # macro
NV0000_CTRL_CMD_NVD_RCERR_RPT_REG_OVERFLOWED = 0x00000001 # macro
NV0000_CTRL_CMD_NVD_RCERR_RPT_REG_MAX_PSEDO_REG = 0x0000000f # macro
NV0000_CTRL_CMD_NVD_RCERR_RPT_FLAGS_POS_FIRST = 0x00000001 # macro
NV0000_CTRL_CMD_NVD_RCERR_RPT_FLAGS_POS_LAST = 0x00000002 # macro
NV0000_CTRL_CMD_NVD_RCERR_RPT_FLAGS_RANGE_VALID = 0x00000004 # macro
NV0000_CTRL_CMD_NVD_RCERR_RPT_FLAGS_DATA_VALID = 0x00000008 # macro
# def TPC_REG_ATTR(gpcId, tpcId):  # macro
#    return ((gpcId<<8)|(tpcId))
# def ROP_REG_ATTR(gpcId, ropId):  # macro
#    return ((gpcId<<8)|(ropId))
# def SM_REG_ATTR(gpcId, tpcId, smId):  # macro
#    return ((((gpcId)<<16)|((tpcId)<<8))|(smId))
NV0000_CTRL_CMD_NVD_RCERR_RPT_ANY_PROCESS_ID = 0x00000000 # macro
NV0000_CTRL_CMD_NVD_RCERR_RPT_ANY_OWNER_ID = 0xFFFFFFFF # macro
NV0000_CTRL_CMD_NVD_GET_RCERR_RPT_PARAMS_MESSAGE_ID = (0x7) # macro
NV0000_CTRL_CMD_NVD_GET_DPC_ISR_TS = (0x608) # macro
NV0000_CTRL_NVD_GET_DPC_ISR_TS_PARAMS_MESSAGE_ID = (0x8) # macro
class struct_NV0000_CTRL_NVD_GET_DUMP_SIZE_PARAMS(Structure):
    pass

struct_NV0000_CTRL_NVD_GET_DUMP_SIZE_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_NVD_GET_DUMP_SIZE_PARAMS._fields_ = [
    ('component', ctypes.c_uint32),
    ('size', ctypes.c_uint32),
]

NV0000_CTRL_NVD_GET_DUMP_SIZE_PARAMS = struct_NV0000_CTRL_NVD_GET_DUMP_SIZE_PARAMS
class struct_NV0000_CTRL_NVD_GET_DUMP_PARAMS(Structure):
    pass

struct_NV0000_CTRL_NVD_GET_DUMP_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_NVD_GET_DUMP_PARAMS._fields_ = [
    ('pBuffer', ctypes.POINTER(None)),
    ('component', ctypes.c_uint32),
    ('size', ctypes.c_uint32),
]

NV0000_CTRL_NVD_GET_DUMP_PARAMS = struct_NV0000_CTRL_NVD_GET_DUMP_PARAMS
class struct_NV0000_CTRL_NVD_GET_TIMESTAMP_PARAMS(Structure):
    pass

struct_NV0000_CTRL_NVD_GET_TIMESTAMP_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_NVD_GET_TIMESTAMP_PARAMS._fields_ = [
    ('timestamp', ctypes.c_uint64),
    ('cpuClkId', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 7),
]

NV0000_CTRL_NVD_GET_TIMESTAMP_PARAMS = struct_NV0000_CTRL_NVD_GET_TIMESTAMP_PARAMS
class struct_NV0000_CTRL_NVD_GET_NVLOG_INFO_PARAMS(Structure):
    pass

struct_NV0000_CTRL_NVD_GET_NVLOG_INFO_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_NVD_GET_NVLOG_INFO_PARAMS._fields_ = [
    ('component', ctypes.c_uint32),
    ('version', ctypes.c_uint32),
    ('runtimeSizes', ctypes.c_ubyte * 16),
    ('printFlags', ctypes.c_uint32),
    ('signature', ctypes.c_uint32 * 4),
    ('bufferTags', ctypes.c_uint32 * 256),
]

NV0000_CTRL_NVD_GET_NVLOG_INFO_PARAMS = struct_NV0000_CTRL_NVD_GET_NVLOG_INFO_PARAMS
class struct_NV0000_CTRL_NVD_GET_NVLOG_BUFFER_INFO_PARAMS(Structure):
    pass

struct_NV0000_CTRL_NVD_GET_NVLOG_BUFFER_INFO_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_NVD_GET_NVLOG_BUFFER_INFO_PARAMS._fields_ = [
    ('component', ctypes.c_uint32),
    ('buffer', ctypes.c_uint32),
    ('tag', ctypes.c_uint32),
    ('size', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('pos', ctypes.c_uint32),
    ('overflow', ctypes.c_uint32),
]

NV0000_CTRL_NVD_GET_NVLOG_BUFFER_INFO_PARAMS = struct_NV0000_CTRL_NVD_GET_NVLOG_BUFFER_INFO_PARAMS
class struct_NV0000_CTRL_NVD_GET_NVLOG_PARAMS(Structure):
    pass

struct_NV0000_CTRL_NVD_GET_NVLOG_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_NVD_GET_NVLOG_PARAMS._fields_ = [
    ('component', ctypes.c_uint32),
    ('buffer', ctypes.c_uint32),
    ('blockNum', ctypes.c_uint32),
    ('size', ctypes.c_uint32),
    ('data', ctypes.c_ubyte * 4000),
]

NV0000_CTRL_NVD_GET_NVLOG_PARAMS = struct_NV0000_CTRL_NVD_GET_NVLOG_PARAMS
class struct_NV0000_CTRL_CMD_NVD_RCERR_RPT_REG_ENTRY(Structure):
    pass

struct_NV0000_CTRL_CMD_NVD_RCERR_RPT_REG_ENTRY._pack_ = 1 # source:False
struct_NV0000_CTRL_CMD_NVD_RCERR_RPT_REG_ENTRY._fields_ = [
    ('tag', ctypes.c_uint32),
    ('value', ctypes.c_uint32),
    ('attribute', ctypes.c_uint32),
]

NV0000_CTRL_CMD_NVD_RCERR_RPT_REG_ENTRY = struct_NV0000_CTRL_CMD_NVD_RCERR_RPT_REG_ENTRY
class struct_NV0000_CTRL_CMD_NVD_GET_RCERR_RPT_PARAMS(Structure):
    pass

struct_NV0000_CTRL_CMD_NVD_GET_RCERR_RPT_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_CMD_NVD_GET_RCERR_RPT_PARAMS._fields_ = [
    ('reqIdx', ctypes.c_uint16),
    ('rptIdx', ctypes.c_uint16),
    ('GPUTag', ctypes.c_uint32),
    ('rptTime', ctypes.c_uint32),
    ('startIdx', ctypes.c_uint16),
    ('endIdx', ctypes.c_uint16),
    ('rptType', ctypes.c_uint16),
    ('PADDING_0', ctypes.c_ubyte * 2),
    ('flags', ctypes.c_uint32),
    ('rptCount', ctypes.c_uint16),
    ('PADDING_1', ctypes.c_ubyte * 2),
    ('owner', ctypes.c_uint32),
    ('processId', ctypes.c_uint32),
    ('report', struct_NV0000_CTRL_CMD_NVD_RCERR_RPT_REG_ENTRY * 200),
]

NV0000_CTRL_CMD_NVD_GET_RCERR_RPT_PARAMS = struct_NV0000_CTRL_CMD_NVD_GET_RCERR_RPT_PARAMS
class struct_NV0000_CTRL_NVD_GET_DPC_ISR_TS_PARAMS(Structure):
    pass

struct_NV0000_CTRL_NVD_GET_DPC_ISR_TS_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_NVD_GET_DPC_ISR_TS_PARAMS._fields_ = [
    ('tsBufferSize', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('pTSBuffer', ctypes.POINTER(None)),
]

NV0000_CTRL_NVD_GET_DPC_ISR_TS_PARAMS = struct_NV0000_CTRL_NVD_GET_DPC_ISR_TS_PARAMS
NV0000_CTRL_SET_SUB_PROCESS_ID_PARAMS_MESSAGE_ID = (0x1) # macro
NV0000_CTRL_DISABLE_SUB_PROCESS_USERD_ISOLATION_PARAMS_MESSAGE_ID = (0x2) # macro
NV0000_CTRL_CMD_SET_SUB_PROCESS_ID = (0x901) # macro
NV0000_CTRL_CMD_DISABLE_SUB_PROCESS_USERD_ISOLATION = (0x902) # macro
class struct_NV0000_CTRL_SET_SUB_PROCESS_ID_PARAMS(Structure):
    pass

struct_NV0000_CTRL_SET_SUB_PROCESS_ID_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_SET_SUB_PROCESS_ID_PARAMS._fields_ = [
    ('subProcessID', ctypes.c_uint32),
    ('subProcessName', ctypes.c_char * 100),
]

NV0000_CTRL_SET_SUB_PROCESS_ID_PARAMS = struct_NV0000_CTRL_SET_SUB_PROCESS_ID_PARAMS
class struct_NV0000_CTRL_DISABLE_SUB_PROCESS_USERD_ISOLATION_PARAMS(Structure):
    pass

struct_NV0000_CTRL_DISABLE_SUB_PROCESS_USERD_ISOLATION_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_DISABLE_SUB_PROCESS_USERD_ISOLATION_PARAMS._fields_ = [
    ('bIsSubProcessDisabled', ctypes.c_ubyte),
]

NV0000_CTRL_DISABLE_SUB_PROCESS_USERD_ISOLATION_PARAMS = struct_NV0000_CTRL_DISABLE_SUB_PROCESS_USERD_ISOLATION_PARAMS
NV0000_SYNC_GPU_BOOST_MAX_GROUPS = (0x10) # macro
NV0000_SYNC_GPU_BOOST_INVALID_GROUP_ID = 0xFFFFFFFF # macro
NV0000_CTRL_CMD_SYNC_GPU_BOOST_INFO = (0xa01) # macro
NV0000_SYNC_GPU_BOOST_INFO_PARAMS_MESSAGE_ID = (0x1) # macro
NV0000_CTRL_CMD_SYNC_GPU_BOOST_GROUP_CREATE = (0xa02) # macro
NV0000_SYNC_GPU_BOOST_GROUP_CREATE_PARAMS_MESSAGE_ID = (0x2) # macro
NV0000_CTRL_CMD_SYNC_GPU_BOOST_GROUP_DESTROY = (0xa03) # macro
NV0000_SYNC_GPU_BOOST_GROUP_DESTROY_PARAMS_MESSAGE_ID = (0x3) # macro
NV0000_CTRL_CMD_SYNC_GPU_BOOST_GROUP_INFO = (0xa04) # macro
NV0000_SYNC_GPU_BOOST_GROUP_INFO_PARAMS_MESSAGE_ID = (0x4) # macro
class struct_NV0000_SYNC_GPU_BOOST_INFO_PARAMS(Structure):
    pass

struct_NV0000_SYNC_GPU_BOOST_INFO_PARAMS._pack_ = 1 # source:False
struct_NV0000_SYNC_GPU_BOOST_INFO_PARAMS._fields_ = [
    ('bEnabled', ctypes.c_ubyte),
]

NV0000_SYNC_GPU_BOOST_INFO_PARAMS = struct_NV0000_SYNC_GPU_BOOST_INFO_PARAMS
class struct_NV0000_SYNC_GPU_BOOST_GROUP_CONFIG(Structure):
    pass

struct_NV0000_SYNC_GPU_BOOST_GROUP_CONFIG._pack_ = 1 # source:False
struct_NV0000_SYNC_GPU_BOOST_GROUP_CONFIG._fields_ = [
    ('gpuCount', ctypes.c_uint32),
    ('gpuIds', ctypes.c_uint32 * 32),
    ('boostGroupId', ctypes.c_uint32),
    ('bBridgeless', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV0000_SYNC_GPU_BOOST_GROUP_CONFIG = struct_NV0000_SYNC_GPU_BOOST_GROUP_CONFIG
class struct_NV0000_SYNC_GPU_BOOST_GROUP_CREATE_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('boostConfig', NV0000_SYNC_GPU_BOOST_GROUP_CONFIG),
     ]

NV0000_SYNC_GPU_BOOST_GROUP_CREATE_PARAMS = struct_NV0000_SYNC_GPU_BOOST_GROUP_CREATE_PARAMS
class struct_NV0000_SYNC_GPU_BOOST_GROUP_DESTROY_PARAMS(Structure):
    pass

struct_NV0000_SYNC_GPU_BOOST_GROUP_DESTROY_PARAMS._pack_ = 1 # source:False
struct_NV0000_SYNC_GPU_BOOST_GROUP_DESTROY_PARAMS._fields_ = [
    ('boostGroupId', ctypes.c_uint32),
]

NV0000_SYNC_GPU_BOOST_GROUP_DESTROY_PARAMS = struct_NV0000_SYNC_GPU_BOOST_GROUP_DESTROY_PARAMS
class struct_NV0000_SYNC_GPU_BOOST_GROUP_INFO_PARAMS(Structure):
    pass

struct_NV0000_SYNC_GPU_BOOST_GROUP_INFO_PARAMS._pack_ = 1 # source:False
struct_NV0000_SYNC_GPU_BOOST_GROUP_INFO_PARAMS._fields_ = [
    ('groupCount', ctypes.c_uint32),
    ('pBoostGroups', struct_NV0000_SYNC_GPU_BOOST_GROUP_CONFIG * 16),
]

NV0000_SYNC_GPU_BOOST_GROUP_INFO_PARAMS = struct_NV0000_SYNC_GPU_BOOST_GROUP_INFO_PARAMS
NV0000_CTRL_CMD_OS_UNIX_FLUSH_USER_CACHE = (0x3d02) # macro
NV0000_CTRL_OS_UNIX_FLUSH_USER_CACHE_PARAMS_MESSAGE_ID = (0x2) # macro
NV0000_CTRL_OS_UNIX_FLAGS_USER_CACHE_FLUSH = (0x00000001) # macro
NV0000_CTRL_OS_UNIX_FLAGS_USER_CACHE_INVALIDATE = (0x00000002) # macro
NV0000_CTRL_OS_UNIX_FLAGS_USER_CACHE_FLUSH_INVALIDATE = (0x00000003) # macro
NV0000_CTRL_CMD_OS_UNIX_GET_CONTROL_FILE_DESCRIPTOR = (0x3d04) # macro
NV0000_CTRL_CMD_OS_UNIX_EXPORT_OBJECT_TO_FD = (0x3d05) # macro
NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_TO_FD_PARAMS_MESSAGE_ID = (0x5) # macro
NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_TO_FD_FLAGS_EMPTY_FD = ['0', ':', '0'] # macro
NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_TO_FD_FLAGS_EMPTY_FD_FALSE = (0x00000000) # macro
NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_TO_FD_FLAGS_EMPTY_FD_TRUE = (0x00000001) # macro
NV0000_CTRL_CMD_OS_UNIX_IMPORT_OBJECT_FROM_FD = (0x3d06) # macro
NV0000_CTRL_OS_UNIX_IMPORT_OBJECT_FROM_FD_PARAMS_MESSAGE_ID = (0x6) # macro
NV0000_CTRL_CMD_OS_GET_GPU_INFO = (0x3d07) # macro
NV0000_CTRL_CMD_OS_UNIX_GET_EXPORT_OBJECT_INFO = (0x3d08) # macro
NV0000_OS_UNIX_EXPORT_OBJECT_FD_BUFFER_SIZE = 64 # macro
NV0000_CTRL_OS_UNIX_GET_EXPORT_OBJECT_INFO_PARAMS_MESSAGE_ID = (0x8) # macro
NV0000_CTRL_CMD_OS_UNIX_REFRESH_RMAPI_DEVICE_LIST = (0x3d09) # macro
NV0000_CTRL_CMD_OS_UNIX_CREATE_EXPORT_OBJECT_FD = (0x3d0a) # macro
NV0000_CTRL_OS_UNIX_CREATE_EXPORT_OBJECT_FD_BUFFER_SIZE = 64 # macro
NV0000_CTRL_OS_UNIX_CREATE_EXPORT_OBJECT_FD_PARAMS_MESSAGE_ID = (0xA) # macro
NV0000_CTRL_CMD_OS_UNIX_EXPORT_OBJECTS_TO_FD = (0x3d0b) # macro
NV0000_CTRL_OS_UNIX_EXPORT_OBJECTS_TO_FD_MAX_OBJECTS = 512 # macro
NV0000_CTRL_OS_UNIX_EXPORT_OBJECTS_TO_FD_PARAMS_MESSAGE_ID = (0xB) # macro
NV0000_CTRL_CMD_OS_UNIX_IMPORT_OBJECTS_FROM_FD = (0x3d0c) # macro
NV0000_CTRL_OS_UNIX_IMPORT_OBJECTS_TO_FD_MAX_OBJECTS = 128 # macro
NV0000_CTRL_CMD_OS_UNIX_IMPORT_OBJECT_TYPE_NONE = 0 # macro
NV0000_CTRL_CMD_OS_UNIX_IMPORT_OBJECT_TYPE_VIDMEM = 1 # macro
NV0000_CTRL_CMD_OS_UNIX_IMPORT_OBJECT_TYPE_SYSMEM = 2 # macro
NV0000_CTRL_CMD_OS_UNIX_IMPORT_OBJECT_TYPE_FABRIC = 3 # macro
NV0000_CTRL_CMD_OS_UNIX_IMPORT_OBJECT_TYPE_FABRIC_MC = 4 # macro
NV0000_CTRL_OS_UNIX_IMPORT_OBJECTS_FROM_FD_PARAMS_MESSAGE_ID = (0xC) # macro
class struct_NV0000_CTRL_OS_UNIX_FLUSH_USER_CACHE_PARAMS(Structure):
    pass

struct_NV0000_CTRL_OS_UNIX_FLUSH_USER_CACHE_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_OS_UNIX_FLUSH_USER_CACHE_PARAMS._fields_ = [
    ('offset', ctypes.c_uint64),
    ('length', ctypes.c_uint64),
    ('cacheOps', ctypes.c_uint32),
    ('hDevice', ctypes.c_uint32),
    ('hObject', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('internalOnly', ctypes.c_uint64),
]

NV0000_CTRL_OS_UNIX_FLUSH_USER_CACHE_PARAMS = struct_NV0000_CTRL_OS_UNIX_FLUSH_USER_CACHE_PARAMS
class struct_NV0000_CTRL_OS_UNIX_GET_CONTROL_FILE_DESCRIPTOR_PARAMS(Structure):
    pass

struct_NV0000_CTRL_OS_UNIX_GET_CONTROL_FILE_DESCRIPTOR_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_OS_UNIX_GET_CONTROL_FILE_DESCRIPTOR_PARAMS._fields_ = [
    ('fd', ctypes.c_int32),
]

NV0000_CTRL_OS_UNIX_GET_CONTROL_FILE_DESCRIPTOR_PARAMS = struct_NV0000_CTRL_OS_UNIX_GET_CONTROL_FILE_DESCRIPTOR_PARAMS

# values for enumeration 'NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_TYPE'
NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_TYPE__enumvalues = {
    0: 'NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_TYPE_NONE',
    1: 'NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_TYPE_RM',
}
NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_TYPE_NONE = 0
NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_TYPE_RM = 1
NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_TYPE = ctypes.c_uint32 # enum
class struct_NV0000_CTRL_OS_UNIX_EXPORT_OBJECT(Structure):
    pass

class union_NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_data(Union):
    pass

class struct_NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_0_rmObject(Structure):
    pass

struct_NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_0_rmObject._pack_ = 1 # source:False
struct_NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_0_rmObject._fields_ = [
    ('hDevice', ctypes.c_uint32),
    ('hParent', ctypes.c_uint32),
    ('hObject', ctypes.c_uint32),
]

union_NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_data._pack_ = 1 # source:False
union_NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_data._fields_ = [
    ('rmObject', struct_NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_0_rmObject),
]

struct_NV0000_CTRL_OS_UNIX_EXPORT_OBJECT._pack_ = 1 # source:False
struct_NV0000_CTRL_OS_UNIX_EXPORT_OBJECT._fields_ = [
    ('type', NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_TYPE),
    ('data', union_NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_data),
]

NV0000_CTRL_OS_UNIX_EXPORT_OBJECT = struct_NV0000_CTRL_OS_UNIX_EXPORT_OBJECT
class struct_NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_TO_FD_PARAMS(Structure):
    pass

struct_NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_TO_FD_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_TO_FD_PARAMS._fields_ = [
    ('object', NV0000_CTRL_OS_UNIX_EXPORT_OBJECT),
    ('fd', ctypes.c_int32),
    ('flags', ctypes.c_uint32),
]

NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_TO_FD_PARAMS = struct_NV0000_CTRL_OS_UNIX_EXPORT_OBJECT_TO_FD_PARAMS
class struct_NV0000_CTRL_OS_UNIX_IMPORT_OBJECT_FROM_FD_PARAMS(Structure):
    pass

struct_NV0000_CTRL_OS_UNIX_IMPORT_OBJECT_FROM_FD_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_OS_UNIX_IMPORT_OBJECT_FROM_FD_PARAMS._fields_ = [
    ('fd', ctypes.c_int32),
    ('object', NV0000_CTRL_OS_UNIX_EXPORT_OBJECT),
]

NV0000_CTRL_OS_UNIX_IMPORT_OBJECT_FROM_FD_PARAMS = struct_NV0000_CTRL_OS_UNIX_IMPORT_OBJECT_FROM_FD_PARAMS
class struct_NV0000_CTRL_OS_GET_GPU_INFO_PARAMS(Structure):
    pass

struct_NV0000_CTRL_OS_GET_GPU_INFO_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_OS_GET_GPU_INFO_PARAMS._fields_ = [
    ('gpuId', ctypes.c_uint32),
    ('minorNum', ctypes.c_uint32),
]

NV0000_CTRL_OS_GET_GPU_INFO_PARAMS = struct_NV0000_CTRL_OS_GET_GPU_INFO_PARAMS
class struct_NV0000_CTRL_OS_UNIX_GET_EXPORT_OBJECT_INFO_PARAMS(Structure):
    pass

struct_NV0000_CTRL_OS_UNIX_GET_EXPORT_OBJECT_INFO_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_OS_UNIX_GET_EXPORT_OBJECT_INFO_PARAMS._fields_ = [
    ('fd', ctypes.c_int32),
    ('deviceInstance', ctypes.c_uint32),
    ('gpuInstanceId', ctypes.c_uint32),
    ('maxObjects', ctypes.c_uint16),
    ('metadata', ctypes.c_ubyte * 64),
    ('PADDING_0', ctypes.c_ubyte * 2),
]

NV0000_CTRL_OS_UNIX_GET_EXPORT_OBJECT_INFO_PARAMS = struct_NV0000_CTRL_OS_UNIX_GET_EXPORT_OBJECT_INFO_PARAMS
class struct_NV0000_CTRL_OS_UNIX_CREATE_EXPORT_OBJECT_FD_PARAMS(Structure):
    pass

struct_NV0000_CTRL_OS_UNIX_CREATE_EXPORT_OBJECT_FD_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_OS_UNIX_CREATE_EXPORT_OBJECT_FD_PARAMS._fields_ = [
    ('hDevice', ctypes.c_uint32),
    ('maxObjects', ctypes.c_uint16),
    ('metadata', ctypes.c_ubyte * 64),
    ('PADDING_0', ctypes.c_ubyte * 2),
    ('fd', ctypes.c_int32),
]

NV0000_CTRL_OS_UNIX_CREATE_EXPORT_OBJECT_FD_PARAMS = struct_NV0000_CTRL_OS_UNIX_CREATE_EXPORT_OBJECT_FD_PARAMS
class struct_NV0000_CTRL_OS_UNIX_EXPORT_OBJECTS_TO_FD_PARAMS(Structure):
    pass

struct_NV0000_CTRL_OS_UNIX_EXPORT_OBJECTS_TO_FD_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_OS_UNIX_EXPORT_OBJECTS_TO_FD_PARAMS._fields_ = [
    ('fd', ctypes.c_int32),
    ('hDevice', ctypes.c_uint32),
    ('maxObjects', ctypes.c_uint16),
    ('metadata', ctypes.c_ubyte * 64),
    ('PADDING_0', ctypes.c_ubyte * 2),
    ('objects', ctypes.c_uint32 * 512),
    ('numObjects', ctypes.c_uint16),
    ('index', ctypes.c_uint16),
]

NV0000_CTRL_OS_UNIX_EXPORT_OBJECTS_TO_FD_PARAMS = struct_NV0000_CTRL_OS_UNIX_EXPORT_OBJECTS_TO_FD_PARAMS
class struct_NV0000_CTRL_OS_UNIX_IMPORT_OBJECTS_FROM_FD_PARAMS(Structure):
    pass

struct_NV0000_CTRL_OS_UNIX_IMPORT_OBJECTS_FROM_FD_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_OS_UNIX_IMPORT_OBJECTS_FROM_FD_PARAMS._fields_ = [
    ('fd', ctypes.c_int32),
    ('hParent', ctypes.c_uint32),
    ('objects', ctypes.c_uint32 * 128),
    ('objectTypes', ctypes.c_ubyte * 128),
    ('numObjects', ctypes.c_uint16),
    ('index', ctypes.c_uint16),
]

NV0000_CTRL_OS_UNIX_IMPORT_OBJECTS_FROM_FD_PARAMS = struct_NV0000_CTRL_OS_UNIX_IMPORT_OBJECTS_FROM_FD_PARAMS
# def NV2080_CTRL_CMD(cat, idx):  # macro
#    return NVXXXX_CTRL_CMD(0x2080,NV2080_CTRL_##cat,idx)
NV2080_CTRL_RESERVED = (0x00) # macro
NV2080_CTRL_GPU = (0x01) # macro
NV2080_CTRL_GPU_LEGACY_NON_PRIVILEGED = (0x81) # macro
NV2080_CTRL_FUSE = (0x02) # macro
NV2080_CTRL_FUSE_LEGACY_NON_PRIVILEGED = (0x82) # macro
NV2080_CTRL_EVENT = (0x03) # macro
NV2080_CTRL_TIMER = (0x04) # macro
NV2080_CTRL_THERMAL = (0x05) # macro
NV2080_CTRL_THERMAL_LEGACY_PRIVILEGED = (0xc5) # macro
NV2080_CTRL_THERMAL_LEGACY_NON_PRIVILEGED = (0x85) # macro
NV2080_CTRL_I2C = (0x06) # macro
NV2080_CTRL_EXTI2C = (0x07) # macro
NV2080_CTRL_BIOS = (0x08) # macro
NV2080_CTRL_CIPHER = (0x09) # macro
NV2080_CTRL_INTERNAL = (0x0A) # macro
NV2080_CTRL_CLK_LEGACY_PRIVILEGED = (0xd0) # macro
NV2080_CTRL_CLK_LEGACY_NON_PRIVILEGED = (0x90) # macro
NV2080_CTRL_CLK = (0x10) # macro
NV2080_CTRL_FIFO = (0x11) # macro
NV2080_CTRL_GR = (0x12) # macro
NV2080_CTRL_FB = (0x13) # macro
NV2080_CTRL_MC = (0x17) # macro
NV2080_CTRL_BUS = (0x18) # macro
NV2080_CTRL_PERF_LEGACY_PRIVILEGED = (0xe0) # macro
NV2080_CTRL_PERF_LEGACY_NON_PRIVILEGED = (0xa0) # macro
NV2080_CTRL_PERF = (0x20) # macro
NV2080_CTRL_NVIF = (0x21) # macro
NV2080_CTRL_RC = (0x22) # macro
NV2080_CTRL_GPIO = (0x23) # macro
NV2080_CTRL_GPIO_LEGACY_NON_PRIVILEGED = (0xa3) # macro
NV2080_CTRL_NVD = (0x24) # macro
NV2080_CTRL_DMA = (0x25) # macro
NV2080_CTRL_PMGR = (0x26) # macro
NV2080_CTRL_PMGR_LEGACY_PRIVILEGED = (0xe6) # macro
NV2080_CTRL_PMGR_LEGACY_NON_PRIVILEGED = (0xa6) # macro
NV2080_CTRL_POWER = (0x27) # macro
NV2080_CTRL_POWER_LEGACY_NON_PRIVILEGED = (0xa7) # macro
NV2080_CTRL_LPWR = (0x28) # macro
NV2080_CTRL_LPWR_LEGACY_NON_PRIVILEGED = (0xa8) # macro
NV2080_CTRL_LPWR_LEGACY_PRIVILEGED = (0xe8) # macro
NV2080_CTRL_ACR = (0x29) # macro
NV2080_CTRL_CE = (0x2A) # macro
NV2080_CTRL_SPI = (0x2B) # macro
NV2080_CTRL_NVLINK = (0x30) # macro
NV2080_CTRL_FLCN = (0x31) # macro
NV2080_CTRL_VOLT = (0x32) # macro
NV2080_CTRL_VOLT_LEGACY_PRIVILEGED = (0xf2) # macro
NV2080_CTRL_VOLT_LEGACY_NON_PRIVILEGED = (0xb2) # macro
NV2080_CTRL_FAS = (0x33) # macro
NV2080_CTRL_ECC = (0x34) # macro
NV2080_CTRL_ECC_NON_PRIVILEGED = (0xb4) # macro
NV2080_CTRL_FLA = (0x35) # macro
NV2080_CTRL_GSP = (0x36) # macro
NV2080_CTRL_NNE = (0x37) # macro
NV2080_CTRL_NNE_LEGACY_NON_PRIVILEGED = (0xb7) # macro
NV2080_CTRL_GRMGR = (0x38) # macro
NV2080_CTRL_UCODE_FUZZER = (0x39) # macro
NV2080_CTRL_DMABUF = (0x3A) # macro
NV2080_CTRL_BIF = (0x3B) # macro
NV2080_CTRL_OS_WINDOWS = (0x3F) # macro
NV2080_CTRL_OS_MACOS = (0x3E) # macro
NV2080_CTRL_OS_UNIX = (0x3D) # macro
NV2080_CTRL_CMD_NULL = (0x20800000) # macro
# def NV0080_CTRL_CMD(cat, idx):  # macro
#    return NVXXXX_CTRL_CMD(0x0080,NV0080_CTRL_##cat,idx)
NV0080_CTRL_RESERVED = (0x00) # macro
NV0080_CTRL_BIF = (0x01) # macro
NV0080_CTRL_GPU = (0x02) # macro
NV0080_CTRL_CLK = (0x10) # macro
NV0080_CTRL_GR = (0x11) # macro
NV0080_CTRL_CIPHER = (0x12) # macro
NV0080_CTRL_FB = (0x13) # macro
NV0080_CTRL_HOST = (0x14) # macro
NV0080_CTRL_VIDEO = (0x15) # macro
NV0080_CTRL_FIFO = (0x17) # macro
NV0080_CTRL_DMA = (0x18) # macro
NV0080_CTRL_PERF = (0x19) # macro
NV0080_CTRL_PERF_LEGACY_NON_PRIVILEGED = (0x99) # macro
NV0080_CTRL_MSENC = (0x1B) # macro
NV0080_CTRL_BSP = (0x1C) # macro
NV0080_CTRL_RC = (0x1D) # macro
NV0080_CTRL_OS_UNIX = (0x1E) # macro
NV0080_CTRL_NVJPG = (0x1F) # macro
NV0080_CTRL_INTERNAL = (0x20) # macro
NV0080_CTRL_NVLINK = (0x21) # macro
NV0080_CTRL_CMD_NULL = (0x800000) # macro
# def NV0080_CTRL_GET_CAP(cat, tbl, c):  # macro
#    return NV0080_CTRL_##cat##_GET_CAP(tbl,NV0080_CTRL_##cat##_CAPS_##c)
NV0080_CTRL_CMD_GR_GET_CAPS = (0x801102) # macro
NV0080_CTRL_GR_GET_CAPS_PARAMS_MESSAGE_ID = (0x2) # macro
# def NV0080_CTRL_GR_GET_CAP(tbl, c):  # macro
#    return (((NvU8)tbl[(1?c)])&(0?c))
NV0080_CTRL_GR_CAPS_TBL_SIZE = 23 # macro
NV0080_CTRL_GR_INFO_INDEX_MAXCLIPS = (0x00000000) # macro
NV0080_CTRL_GR_INFO_INDEX_MIN_ATTRS_BUG_261894 = (0x00000001) # macro
NV0080_CTRL_GR_INFO_XBUF_MAX_PSETS_PER_BANK = (0x00000002) # macro
NV0080_CTRL_GR_INFO_INDEX_BUFFER_ALIGNMENT = (0x00000003) # macro
NV0080_CTRL_GR_INFO_INDEX_SWIZZLE_ALIGNMENT = (0x00000004) # macro
NV0080_CTRL_GR_INFO_INDEX_VERTEX_CACHE_SIZE = (0x00000005) # macro
NV0080_CTRL_GR_INFO_INDEX_VPE_COUNT = (0x00000006) # macro
NV0080_CTRL_GR_INFO_INDEX_SHADER_PIPE_COUNT = (0x00000007) # macro
NV0080_CTRL_GR_INFO_INDEX_THREAD_STACK_SCALING_FACTOR = (0x00000008) # macro
NV0080_CTRL_GR_INFO_INDEX_SHADER_PIPE_SUB_COUNT = (0x00000009) # macro
NV0080_CTRL_GR_INFO_INDEX_SM_REG_BANK_COUNT = (0x0000000A) # macro
NV0080_CTRL_GR_INFO_INDEX_SM_REG_BANK_REG_COUNT = (0x0000000B) # macro
NV0080_CTRL_GR_INFO_INDEX_SM_VERSION = (0x0000000C) # macro
NV0080_CTRL_GR_INFO_INDEX_MAX_WARPS_PER_SM = (0x0000000D) # macro
NV0080_CTRL_GR_INFO_INDEX_MAX_THREADS_PER_WARP = (0x0000000E) # macro
NV0080_CTRL_GR_INFO_INDEX_GEOM_GS_OBUF_ENTRIES = (0x0000000F) # macro
NV0080_CTRL_GR_INFO_INDEX_GEOM_XBUF_ENTRIES = (0x00000010) # macro
NV0080_CTRL_GR_INFO_INDEX_FB_MEMORY_REQUEST_GRANULARITY = (0x00000011) # macro
NV0080_CTRL_GR_INFO_INDEX_HOST_MEMORY_REQUEST_GRANULARITY = (0x00000012) # macro
NV0080_CTRL_GR_INFO_INDEX_MAX_SP_PER_SM = (0x00000013) # macro
NV0080_CTRL_GR_INFO_INDEX_LITTER_NUM_GPCS = (0x00000014) # macro
NV0080_CTRL_GR_INFO_INDEX_LITTER_NUM_FBPS = (0x00000015) # macro
NV0080_CTRL_GR_INFO_INDEX_LITTER_NUM_ZCULL_BANKS = (0x00000016) # macro
NV0080_CTRL_GR_INFO_INDEX_LITTER_NUM_TPC_PER_GPC = (0x00000017) # macro
NV0080_CTRL_GR_INFO_INDEX_LITTER_NUM_MIN_FBPS = (0x00000018) # macro
NV0080_CTRL_GR_INFO_INDEX_LITTER_NUM_MXBAR_FBP_PORTS = (0x00000019) # macro
NV0080_CTRL_GR_INFO_INDEX_TIMESLICE_ENABLED = (0x0000001A) # macro
NV0080_CTRL_GR_INFO_INDEX_LITTER_NUM_FBPAS = (0x0000001B) # macro
NV0080_CTRL_GR_INFO_INDEX_LITTER_NUM_PES_PER_GPC = (0x0000001C) # macro
NV0080_CTRL_GR_INFO_INDEX_GPU_CORE_COUNT = (0x0000001D) # macro
NV0080_CTRL_GR_INFO_INDEX_LITTER_NUM_TPCS_PER_PES = (0x0000001E) # macro
NV0080_CTRL_GR_INFO_INDEX_LITTER_NUM_MXBAR_HUB_PORTS = (0x0000001F) # macro
NV0080_CTRL_GR_INFO_INDEX_LITTER_NUM_SM_PER_TPC = (0x00000020) # macro
NV0080_CTRL_GR_INFO_INDEX_LITTER_NUM_HSHUB_FBP_PORTS = (0x00000021) # macro
NV0080_CTRL_GR_INFO_INDEX_RT_CORE_COUNT = (0x00000022) # macro
NV0080_CTRL_GR_INFO_INDEX_TENSOR_CORE_COUNT = (0x00000023) # macro
NV0080_CTRL_GR_INFO_INDEX_LITTER_NUM_GRS = (0x00000024) # macro
NV0080_CTRL_GR_INFO_INDEX_LITTER_NUM_LTCS = (0x00000025) # macro
NV0080_CTRL_GR_INFO_INDEX_LITTER_NUM_LTC_SLICES = (0x00000026) # macro
NV0080_CTRL_GR_INFO_INDEX_LITTER_NUM_GPCMMU_PER_GPC = (0x00000027) # macro
NV0080_CTRL_GR_INFO_INDEX_LITTER_NUM_LTC_PER_FBP = (0x00000028) # macro
NV0080_CTRL_GR_INFO_INDEX_LITTER_NUM_ROP_PER_GPC = (0x00000029) # macro
NV0080_CTRL_GR_INFO_INDEX_FAMILY_MAX_TPC_PER_GPC = (0x0000002A) # macro
NV0080_CTRL_GR_INFO_INDEX_LITTER_NUM_FBPA_PER_FBP = (0x0000002B) # macro
NV0080_CTRL_GR_INFO_INDEX_MAX_SUBCONTEXT_COUNT = (0x0000002C) # macro
NV0080_CTRL_GR_INFO_INDEX_MAX_LEGACY_SUBCONTEXT_COUNT = (0x0000002D) # macro
NV0080_CTRL_GR_INFO_INDEX_MAX_PER_ENGINE_SUBCONTEXT_COUNT = (0x0000002E) # macro
NV0080_CTRL_GR_INFO_INDEX_LITTER_NUM_SLICES_PER_LTC = (0x00000032) # macro
NV0080_CTRL_GR_INFO_INDEX_DUMMY = (0x00000033) # macro
NV0080_CTRL_GR_INFO_INDEX_GFX_CAPABILITIES = (0x00000034) # macro
NV0080_CTRL_GR_INFO_INDEX_MAX_MIG_ENGINES = (0x00000035) # macro
NV0080_CTRL_GR_INFO_INDEX_MAX_PARTITIONABLE_GPCS = (0x00000036) # macro
NV0080_CTRL_GR_INFO_INDEX_LITTER_MIN_SUBCTX_PER_SMC_ENG = (0x00000037) # macro
NV0080_CTRL_GR_INFO_INDEX_MAX = (0x00000037) # macro
NV0080_CTRL_GR_INFO_MAX_SIZE = (0x38) # macro
NV0080_CTRL_CMD_GR_GET_INFO = (0x801104) # macro
NV0080_CTRL_GR_GET_INFO_PARAMS_MESSAGE_ID = (0x4) # macro
NV0080_CTRL_CMD_GR_GET_TPC_PARTITION_MODE = (0x801107) # macro
NV0080_CTRL_CMD_GR_SET_TPC_PARTITION_MODE = (0x801108) # macro
NV0080_CTRL_GR_GET_TPC_PARTITION_MODE_PARAMS_MESSAGE_ID = (0x7) # macro
NV0080_CTRL_GR_SET_TPC_PARTITION_MODE_PARAMS_MESSAGE_ID = (0x8) # macro
NV0080_CTRL_CMD_GR_GET_CAPS_V2 = (0x801109) # macro
NV0080_CTRL_GR_GET_CAPS_V2_PARAMS_MESSAGE_ID = (0x9) # macro
NV0080_CTRL_CMD_GR_GET_INFO_V2 = (0x801110) # macro
NV0080_CTRL_GR_GET_INFO_V2_PARAMS_MESSAGE_ID = (0x10) # macro
NV2080_CTRL_GR_ROUTE_INFO_FLAGS_TYPE = ['1', ':', '0'] # macro
NV2080_CTRL_GR_ROUTE_INFO_FLAGS_TYPE_NONE = 0x0 # macro
NV2080_CTRL_GR_ROUTE_INFO_FLAGS_TYPE_ENGID = 0x1 # macro
NV2080_CTRL_GR_ROUTE_INFO_FLAGS_TYPE_CHANNEL = 0x2 # macro
NV2080_CTRL_GR_ROUTE_INFO_DATA_CHANNEL_HANDLE = ['31', ':', '0'] # macro
NV2080_CTRL_GR_ROUTE_INFO_DATA_ENGID = ['31', ':', '0'] # macro
NV2080_CTRL_GR_INFO_INDEX_MAXCLIPS = (0x00000000) # macro
NV2080_CTRL_GR_INFO_INDEX_MIN_ATTRS_BUG_261894 = (0x00000001) # macro
NV2080_CTRL_GR_INFO_XBUF_MAX_PSETS_PER_BANK = (0x00000002) # macro
NV2080_CTRL_GR_INFO_INDEX_BUFFER_ALIGNMENT = (0x00000003) # macro
NV2080_CTRL_GR_INFO_INDEX_SWIZZLE_ALIGNMENT = (0x00000004) # macro
NV2080_CTRL_GR_INFO_INDEX_VERTEX_CACHE_SIZE = (0x00000005) # macro
NV2080_CTRL_GR_INFO_INDEX_VPE_COUNT = (0x00000006) # macro
NV2080_CTRL_GR_INFO_INDEX_SHADER_PIPE_COUNT = (0x00000007) # macro
NV2080_CTRL_GR_INFO_INDEX_THREAD_STACK_SCALING_FACTOR = (0x00000008) # macro
NV2080_CTRL_GR_INFO_INDEX_SHADER_PIPE_SUB_COUNT = (0x00000009) # macro
NV2080_CTRL_GR_INFO_INDEX_SM_REG_BANK_COUNT = (0x0000000A) # macro
NV2080_CTRL_GR_INFO_INDEX_SM_REG_BANK_REG_COUNT = (0x0000000B) # macro
NV2080_CTRL_GR_INFO_INDEX_SM_VERSION = (0x0000000C) # macro
NV2080_CTRL_GR_INFO_INDEX_MAX_WARPS_PER_SM = (0x0000000D) # macro
NV2080_CTRL_GR_INFO_INDEX_MAX_THREADS_PER_WARP = (0x0000000E) # macro
NV2080_CTRL_GR_INFO_INDEX_GEOM_GS_OBUF_ENTRIES = (0x0000000F) # macro
NV2080_CTRL_GR_INFO_INDEX_GEOM_XBUF_ENTRIES = (0x00000010) # macro
NV2080_CTRL_GR_INFO_INDEX_FB_MEMORY_REQUEST_GRANULARITY = (0x00000011) # macro
NV2080_CTRL_GR_INFO_INDEX_HOST_MEMORY_REQUEST_GRANULARITY = (0x00000012) # macro
NV2080_CTRL_GR_INFO_INDEX_MAX_SP_PER_SM = (0x00000013) # macro
NV2080_CTRL_GR_INFO_INDEX_LITTER_NUM_GPCS = (0x00000014) # macro
NV2080_CTRL_GR_INFO_INDEX_LITTER_NUM_FBPS = (0x00000015) # macro
NV2080_CTRL_GR_INFO_INDEX_LITTER_NUM_ZCULL_BANKS = (0x00000016) # macro
NV2080_CTRL_GR_INFO_INDEX_LITTER_NUM_TPC_PER_GPC = (0x00000017) # macro
NV2080_CTRL_GR_INFO_INDEX_LITTER_NUM_MIN_FBPS = (0x00000018) # macro
NV2080_CTRL_GR_INFO_INDEX_LITTER_NUM_MXBAR_FBP_PORTS = (0x00000019) # macro
NV2080_CTRL_GR_INFO_INDEX_TIMESLICE_ENABLED = (0x0000001A) # macro
NV2080_CTRL_GR_INFO_INDEX_LITTER_NUM_FBPAS = (0x0000001B) # macro
NV2080_CTRL_GR_INFO_INDEX_LITTER_NUM_PES_PER_GPC = (0x0000001C) # macro
NV2080_CTRL_GR_INFO_INDEX_GPU_CORE_COUNT = (0x0000001D) # macro
NV2080_CTRL_GR_INFO_INDEX_LITTER_NUM_TPCS_PER_PES = (0x0000001E) # macro
NV2080_CTRL_GR_INFO_INDEX_LITTER_NUM_MXBAR_HUB_PORTS = (0x0000001F) # macro
NV2080_CTRL_GR_INFO_INDEX_LITTER_NUM_SM_PER_TPC = (0x00000020) # macro
NV2080_CTRL_GR_INFO_INDEX_LITTER_NUM_HSHUB_FBP_PORTS = (0x00000021) # macro
NV2080_CTRL_GR_INFO_INDEX_RT_CORE_COUNT = (0x00000022) # macro
NV2080_CTRL_GR_INFO_INDEX_TENSOR_CORE_COUNT = (0x00000023) # macro
NV2080_CTRL_GR_INFO_INDEX_LITTER_NUM_GRS = (0x00000024) # macro
NV2080_CTRL_GR_INFO_INDEX_LITTER_NUM_LTCS = (0x00000025) # macro
NV2080_CTRL_GR_INFO_INDEX_LITTER_NUM_LTC_SLICES = (0x00000026) # macro
NV2080_CTRL_GR_INFO_INDEX_LITTER_NUM_GPCMMU_PER_GPC = (0x00000027) # macro
NV2080_CTRL_GR_INFO_INDEX_LITTER_NUM_LTC_PER_FBP = (0x00000028) # macro
NV2080_CTRL_GR_INFO_INDEX_LITTER_NUM_ROP_PER_GPC = (0x00000029) # macro
NV2080_CTRL_GR_INFO_INDEX_FAMILY_MAX_TPC_PER_GPC = (0x0000002A) # macro
NV2080_CTRL_GR_INFO_INDEX_LITTER_NUM_FBPA_PER_FBP = (0x0000002B) # macro
NV2080_CTRL_GR_INFO_INDEX_MAX_SUBCONTEXT_COUNT = (0x0000002C) # macro
NV2080_CTRL_GR_INFO_INDEX_MAX_LEGACY_SUBCONTEXT_COUNT = (0x0000002D) # macro
NV2080_CTRL_GR_INFO_INDEX_MAX_PER_ENGINE_SUBCONTEXT_COUNT = (0x0000002E) # macro
# NV2080_CTRL_GR_INFO_INDEX_LITTER_NUM_SINGLETON_GPCS = NV0080_CTRL_GR_INFO_INDEX_LITTER_NUM_SINGLETON_GPCS # macro
# NV2080_CTRL_GR_INFO_INDEX_LITTER_NUM_GFXC_GPCS = NV0080_CTRL_GR_INFO_INDEX_LITTER_NUM_GFXC_GPCS # macro
# NV2080_CTRL_GR_INFO_INDEX_LITTER_NUM_GFXC_TPCS_PER_GFXC_GPC = NV0080_CTRL_GR_INFO_INDEX_LITTER_NUM_GFXC_TPCS_PER_GFXC_GPC # macro
NV2080_CTRL_GR_INFO_INDEX_LITTER_NUM_SLICES_PER_LTC = (0x00000032) # macro
NV2080_CTRL_GR_INFO_INDEX_DUMMY = (0x00000033) # macro
NV2080_CTRL_GR_INFO_INDEX_GFX_CAPABILITIES = (0x00000034) # macro
NV2080_CTRL_GR_INFO_INDEX_MAX_MIG_ENGINES = (0x00000035) # macro
NV2080_CTRL_GR_INFO_INDEX_MAX_PARTITIONABLE_GPCS = (0x00000036) # macro
NV2080_CTRL_GR_INFO_INDEX_LITTER_MIN_SUBCTX_PER_SMC_ENG = (0x00000037) # macro
NV2080_CTRL_GR_INFO_INDEX_MAX = (0x00000037) # macro
NV2080_CTRL_GR_INFO_MAX_SIZE = (0x38) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_NONE = (0x00000000) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_1_05 = (0x00000105) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_1_1 = (0x00000110) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_1_2 = (0x00000120) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_1_3 = (0x00000130) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_1_4 = (0x00000140) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_1_5 = (0x00000150) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_2_0 = (0x00000200) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_2_1 = (0x00000210) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_2_2 = (0x00000220) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_3_0 = (0x00000300) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_3_1 = (0x00000310) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_3_2 = (0x00000320) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_3_3 = (0x00000330) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_3_5 = (0x00000350) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_3_6 = (0x00000360) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_3_8 = (0x00000380) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_3_9 = (0x00000390) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_4_0 = (0x00000400) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_5_0 = (0x00000500) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_5_02 = (0x00000502) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_5_03 = (0x00000503) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_6_0 = (0x00000600) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_6_01 = (0x00000601) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_6_02 = (0x00000602) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_7_0 = (0x00000700) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_7_01 = (0x00000701) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_7_02 = (0x00000702) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_7_03 = (0x00000703) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_7_05 = (0x00000705) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_8_02 = (0x00000802) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_8_06 = (0x00000806) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_8_07 = (0x00000807) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_8_08 = (0x00000808) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_8_09 = (0x00000809) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_9_00 = (0x00000900) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_5_2 = ((0x00000502)) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_5_3 = ((0x00000503)) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_6_1 = ((0x00000601)) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_6_2 = ((0x00000602)) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_7_1 = ((0x00000701)) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_7_2 = ((0x00000702)) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_7_3 = ((0x00000703)) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_7_5 = ((0x00000705)) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_8_2 = ((0x00000802)) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_8_6 = ((0x00000806)) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_8_7 = ((0x00000807)) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_8_8 = ((0x00000808)) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_8_9 = ((0x00000809)) # macro
NV2080_CTRL_GR_INFO_SM_VERSION_9_0 = ((0x00000900)) # macro
NV2080_CTRL_GR_INFO_GFX_CAPABILITIES_2D = ['0', ':', '0'] # macro
NV2080_CTRL_GR_INFO_GFX_CAPABILITIES_2D_FALSE = 0x0 # macro
NV2080_CTRL_GR_INFO_GFX_CAPABILITIES_2D_TRUE = 0x1 # macro
NV2080_CTRL_GR_INFO_GFX_CAPABILITIES_3D = ['1', ':', '1'] # macro
NV2080_CTRL_GR_INFO_GFX_CAPABILITIES_3D_FALSE = 0x0 # macro
NV2080_CTRL_GR_INFO_GFX_CAPABILITIES_3D_TRUE = 0x1 # macro
NV2080_CTRL_GR_INFO_GFX_CAPABILITIES_COMPUTE = ['2', ':', '2'] # macro
NV2080_CTRL_GR_INFO_GFX_CAPABILITIES_COMPUTE_FALSE = 0x0 # macro
NV2080_CTRL_GR_INFO_GFX_CAPABILITIES_COMPUTE_TRUE = 0x1 # macro
NV2080_CTRL_GR_INFO_GFX_CAPABILITIES_I2M = ['3', ':', '3'] # macro
NV2080_CTRL_GR_INFO_GFX_CAPABILITIES_I2M_FALSE = 0x0 # macro
NV2080_CTRL_GR_INFO_GFX_CAPABILITIES_I2M_TRUE = 0x1 # macro
NV2080_CTRL_CMD_GR_GET_INFO = (0x20801201) # macro
NV2080_CTRL_GR_GET_INFO_PARAMS_MESSAGE_ID = (0x1) # macro
NV2080_CTRL_CMD_GR_CTXSW_ZCULL_MODE = (0x20801205) # macro
NV2080_CTRL_GR_CTXSW_ZCULL_MODE_PARAMS_MESSAGE_ID = (0x5) # macro
NV2080_CTRL_CTXSW_ZCULL_MODE_GLOBAL = (0x00000000) # macro
NV2080_CTRL_CTXSW_ZCULL_MODE_NO_CTXSW = (0x00000001) # macro
NV2080_CTRL_CTXSW_ZCULL_MODE_SEPARATE_BUFFER = (0x00000002) # macro
NV2080_CTRL_CMD_GR_GET_ZCULL_INFO = (0x20801206) # macro
NV2080_CTRL_GR_GET_ZCULL_INFO_PARAMS_SUBREGION_SUPPORTED = True # macro
NV2080_CTRL_GR_GET_ZCULL_INFO_PARAMS_MESSAGE_ID = (0x6) # macro
NV2080_CTRL_CMD_GR_CTXSW_PM_MODE = (0x20801207) # macro
NV2080_CTRL_GR_CTXSW_PM_MODE_PARAMS_MESSAGE_ID = (0x7) # macro
NV2080_CTRL_CTXSW_PM_MODE_NO_CTXSW = (0x00000000) # macro
NV2080_CTRL_CTXSW_PM_MODE_CTXSW = (0x00000001) # macro
NV2080_CTRL_CTXSW_PM_MODE_STREAM_OUT_CTXSW = (0x00000002) # macro
NV2080_CTRL_CMD_GR_CTXSW_ZCULL_BIND = (0x20801208) # macro
NV2080_CTRL_GR_CTXSW_ZCULL_BIND_PARAMS_MESSAGE_ID = (0x8) # macro
NV2080_CTRL_CMD_GR_CTXSW_PM_BIND = (0x20801209) # macro
NV2080_CTRL_GR_CTXSW_PM_BIND_PARAMS_MESSAGE_ID = (0x9) # macro
NV2080_CTRL_CMD_GR_CTXSW_SETUP_BIND = (0x2080123a) # macro
NV2080_CTRL_GR_CTXSW_SETUP_BIND_PARAMS_MESSAGE_ID = (0x3A) # macro
NV2080_CTRL_GR_SET_GPC_TILE_MAP_MAX_VALUES = 128 # macro
NV2080_CTRL_CMD_GR_SET_GPC_TILE_MAP = (0x2080120a) # macro
NV2080_CTRL_GR_SET_GPC_TILE_MAP_PARAMS_MESSAGE_ID = (0xA) # macro
NV2080_CTRL_CMD_GR_CTXSW_SMPC_MODE = (0x2080120e) # macro
NV2080_CTRL_GR_CTXSW_SMPC_MODE_PARAMS_MESSAGE_ID = (0xE) # macro
NV2080_CTRL_CTXSW_SMPC_MODE_NO_CTXSW = (0x00000000) # macro
NV2080_CTRL_CTXSW_SMPC_MODE_CTXSW = (0x00000001) # macro
NV2080_CTRL_CMD_GR_GET_SM_TO_GPC_TPC_MAPPINGS = (0x2080120f) # macro
NV2080_CTRL_GR_GET_SM_TO_GPC_TPC_MAPPINGS_MAX_SM_COUNT = 144 # macro
NV2080_CTRL_GR_GET_SM_TO_GPC_TPC_MAPPINGS_PARAMS_MESSAGE_ID = (0xF) # macro
NV2080_CTRL_CMD_GR_SET_CTXSW_PREEMPTION_MODE = (0x20801210) # macro
NV2080_CTRL_GR_SET_CTXSW_PREEMPTION_MODE_PARAMS_MESSAGE_ID = (0x10) # macro
NV2080_CTRL_GR_SET_CTXSW_PREEMPTION_MODE_FLAGS_CILP = ['0', ':', '0'] # macro
NV2080_CTRL_GR_SET_CTXSW_PREEMPTION_MODE_FLAGS_CILP_IGNORE = (0x00000000) # macro
NV2080_CTRL_GR_SET_CTXSW_PREEMPTION_MODE_FLAGS_CILP_SET = (0x00000001) # macro
NV2080_CTRL_GR_SET_CTXSW_PREEMPTION_MODE_FLAGS_GFXP = ['1', ':', '1'] # macro
NV2080_CTRL_GR_SET_CTXSW_PREEMPTION_MODE_FLAGS_GFXP_IGNORE = (0x00000000) # macro
NV2080_CTRL_GR_SET_CTXSW_PREEMPTION_MODE_FLAGS_GFXP_SET = (0x00000001) # macro
NV2080_CTRL_SET_CTXSW_PREEMPTION_MODE_GFX_WFI = (0x00000000) # macro
NV2080_CTRL_SET_CTXSW_PREEMPTION_MODE_GFX_GFXP = (0x00000001) # macro
NV2080_CTRL_SET_CTXSW_PREEMPTION_MODE_GFX_GFXP_POOL = (0x00000002) # macro
NV2080_CTRL_SET_CTXSW_PREEMPTION_MODE_COMPUTE_WFI = (0x00000000) # macro
NV2080_CTRL_SET_CTXSW_PREEMPTION_MODE_COMPUTE_CTA = (0x00000001) # macro
NV2080_CTRL_SET_CTXSW_PREEMPTION_MODE_COMPUTE_CILP = (0x00000002) # macro
NV2080_CTRL_CMD_GR_CTXSW_PREEMPTION_BIND = (0x20801211) # macro
NV2080_CTRL_GR_CTXSW_PREEMPTION_BIND_PARAMS_MESSAGE_ID = (0x11) # macro
NV2080_CTRL_CMD_GR_PC_SAMPLING_MODE = (0x20801212) # macro
NV2080_CTRL_GR_PC_SAMPLING_MODE_PARAMS_MESSAGE_ID = (0x12) # macro
NV2080_CTRL_PC_SAMPLING_MODE_DISABLED = (0x00000000) # macro
NV2080_CTRL_PC_SAMPLING_MODE_ENABLED = (0x00000001) # macro
NV2080_CTRL_CMD_GR_GET_ROP_INFO = (0x20801213) # macro
NV2080_CTRL_GR_GET_ROP_INFO_PARAMS_MESSAGE_ID = (0x13) # macro
NV2080_CTRL_CMD_GR_GET_CTXSW_STATS = (0x20801215) # macro
NV2080_CTRL_GR_GET_CTXSW_STATS_PARAMS_MESSAGE_ID = (0x15) # macro
NV2080_CTRL_GR_GET_CTXSW_STATS_FLAGS_RESET = ['0', ':', '0'] # macro
NV2080_CTRL_GR_GET_CTXSW_STATS_FLAGS_RESET_FALSE = (0x00000000) # macro
NV2080_CTRL_GR_GET_CTXSW_STATS_FLAGS_RESET_TRUE = (0x00000001) # macro
NV2080_CTRL_CMD_GR_GET_CTX_BUFFER_SIZE = (0x20801218) # macro
NV2080_CTRL_GR_GET_CTX_BUFFER_SIZE_PARAMS_MESSAGE_ID = (0x18) # macro
NV2080_CTRL_GR_MAX_CTX_BUFFER_COUNT = 64 # macro
NV2080_CTRL_CMD_GR_GET_CTX_BUFFER_INFO = (0x20801219) # macro
NV2080_CTRL_GR_GET_CTX_BUFFER_INFO_PARAMS_MESSAGE_ID = (0x19) # macro
NV2080_CTRL_GR_CTX_BUFFER_INFO_APERTURE_UNKNOWN = 0 # macro
NV2080_CTRL_GR_CTX_BUFFER_INFO_APERTURE_SYSMEM = 1 # macro
NV2080_CTRL_GR_CTX_BUFFER_INFO_APERTURE_FBMEM = 2 # macro
NV2080_CTRL_CMD_GR_GET_GLOBAL_SM_ORDER = (0x2080121b) # macro
NV2080_CTRL_CMD_GR_GET_GLOBAL_SM_ORDER_MAX_SM_COUNT = 512 # macro
NV2080_CTRL_GR_DISABLED_SM_VGPC_ID = 0xFF # macro
NV2080_CTRL_GR_GET_GLOBAL_SM_ORDER_PARAMS_MESSAGE_ID = (0x1B) # macro
NV2080_CTRL_CMD_GR_GET_CURRENT_RESIDENT_CHANNEL = (0x2080121c) # macro
NV2080_CTRL_GR_GET_CURRENT_RESIDENT_CHANNEL_PARAMS_MESSAGE_ID = (0x1C) # macro
NV2080_CTRL_CMD_GR_GET_VAT_ALARM_MAX_GPC_COUNT = 10 # macro
NV2080_CTRL_CMD_GR_GET_VAT_ALARM_MAX_TPC_PER_GPC_COUNT = 10 # macro
NV2080_CTRL_CMD_GR_GET_VAT_ALARM_DATA = (0x2080121d) # macro
NV2080_CTRL_GR_GET_VAT_ALARM_DATA_PARAMS_MESSAGE_ID = (0x1D) # macro
NV2080_CTRL_CMD_GR_GET_ATTRIBUTE_BUFFER_SIZE = (0x2080121e) # macro
NV2080_CTRL_GR_GET_ATTRIBUTE_BUFFER_SIZE_PARAMS_MESSAGE_ID = (0x1E) # macro
NV2080_CTRL_CMD_GR_GFX_POOL_QUERY_SIZE = (0x2080121f) # macro
NV2080_CTRL_GR_GFX_POOL_QUERY_SIZE_PARAMS_MESSAGE_ID = (0x1F) # macro
NV2080_CTRL_CMD_GR_GFX_POOL_INITIALIZE = (0x20801220) # macro
NV2080_CTRL_GR_GFX_POOL_INITIALIZE_PARAMS_MESSAGE_ID = (0x20) # macro
NV2080_CTRL_GR_GFX_POOL_MAX_SLOTS = 64 # macro
NV2080_CTRL_CMD_GR_GFX_POOL_ADD_SLOTS = (0x20801221) # macro
NV2080_CTRL_GR_GFX_POOL_ADD_SLOTS_PARAMS_MESSAGE_ID = (0x21) # macro
NV2080_CTRL_CMD_GR_GFX_POOL_REMOVE_SLOTS = (0x20801222) # macro
NV2080_CTRL_GR_GFX_POOL_REMOVE_SLOTS_PARAMS_MESSAGE_ID = (0x22) # macro
NV2080_CTRL_CMD_GR_GET_CAPS_V2 = (0x20801227) # macro
NV2080_CTRL_GR_GET_CAPS_V2_PARAMS_MESSAGE_ID = (0x27) # macro
NV2080_CTRL_CMD_GR_GET_INFO_V2 = (0x20801228) # macro
NV2080_CTRL_GR_GET_INFO_V2_PARAMS_MESSAGE_ID = (0x28) # macro
NV2080_CTRL_CMD_GR_GET_GPC_MASK = (0x2080122a) # macro
NV2080_CTRL_GR_GET_GPC_MASK_PARAMS_MESSAGE_ID = (0x2A) # macro
NV2080_CTRL_CMD_GR_GET_TPC_MASK = (0x2080122b) # macro
NV2080_CTRL_GR_GET_TPC_MASK_PARAMS_MESSAGE_ID = (0x2B) # macro
NV2080_CTRL_CMD_GR_SET_TPC_PARTITION_MODE = (0x2080122c) # macro
NV2080_CTRL_GR_SET_TPC_PARTITION_MODE_PARAMS_MESSAGE_ID = (0x2C) # macro
NV2080_CTRL_CMD_GR_GET_ENGINE_CONTEXT_PROPERTIES = (0x2080122d) # macro
NV2080_CTRL_GR_GET_ENGINE_CONTEXT_PROPERTIES_PARAMS_MESSAGE_ID = (0x2D) # macro
NV2080_CTRL_CMD_GR_GET_SM_ISSUE_RATE_MODIFIER = (0x20801230) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA0_FULL_SPEED = (0x0) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA0_REDUCED_SPEED_1_2 = (0x1) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA0_REDUCED_SPEED_1_4 = (0x2) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA0_REDUCED_SPEED_1_8 = (0x3) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA0_REDUCED_SPEED_1_16 = (0x4) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA0_REDUCED_SPEED_1_32 = (0x5) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA0_REDUCED_SPEED_1_64 = (0x6) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_FMLA16_FULL_SPEED = (0x0) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_FMLA16_REDUCED_SPEED_1_2 = (0x1) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_FMLA16_REDUCED_SPEED_1_4 = (0x2) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_FMLA16_REDUCED_SPEED_1_8 = (0x3) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_FMLA16_REDUCED_SPEED_1_16 = (0x4) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_FMLA16_REDUCED_SPEED_1_32 = (0x5) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_DP_FULL_SPEED = (0x0) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_DP_REDUCED_SPEED = (0x1) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_FMLA32_FULL_SPEED = (0x0) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_FMLA32_REDUCED_SPEED_1_2 = (0x1) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_FMLA32_REDUCED_SPEED_1_4 = (0x2) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_FMLA32_REDUCED_SPEED_1_8 = (0x3) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_FMLA32_REDUCED_SPEED_1_16 = (0x4) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_FMLA32_REDUCED_SPEED_1_32 = (0x5) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_FFMA_FULL_SPEED = (0x0) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_FFMA_REDUCED_SPEED_1_2 = (0x1) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_FFMA_REDUCED_SPEED_1_4 = (0x2) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_FFMA_REDUCED_SPEED_1_8 = (0x3) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_FFMA_REDUCED_SPEED_1_16 = (0x4) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_FFMA_REDUCED_SPEED_1_32 = (0x5) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA1_FULL_SPEED = (0x0) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA1_REDUCED_SPEED_1_2 = (0x1) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA1_REDUCED_SPEED_1_4 = (0x2) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA1_REDUCED_SPEED_1_8 = (0x3) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA1_REDUCED_SPEED_1_16 = (0x4) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA1_REDUCED_SPEED_1_32 = (0x5) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA1_REDUCED_SPEED_1_64 = (0x6) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA2_FULL_SPEED = (0x0) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA2_REDUCED_SPEED_1_2 = (0x1) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA2_REDUCED_SPEED_1_4 = (0x2) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA2_REDUCED_SPEED_1_8 = (0x3) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA2_REDUCED_SPEED_1_16 = (0x4) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA2_REDUCED_SPEED_1_32 = (0x5) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA2_REDUCED_SPEED_1_64 = (0x6) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA3_FULL_SPEED = (0x0) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA3_REDUCED_SPEED_1_2 = (0x1) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA3_REDUCED_SPEED_1_4 = (0x2) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA3_REDUCED_SPEED_1_8 = (0x3) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA3_REDUCED_SPEED_1_16 = (0x4) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA3_REDUCED_SPEED_1_32 = (0x5) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA3_REDUCED_SPEED_1_64 = (0x6) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA4_FULL_SPEED = (0x0) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA4_REDUCED_SPEED_1_2 = (0x1) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA4_REDUCED_SPEED_1_4 = (0x2) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA4_REDUCED_SPEED_1_8 = (0x3) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA4_REDUCED_SPEED_1_16 = (0x4) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA4_REDUCED_SPEED_1_32 = (0x5) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_IMLA4_REDUCED_SPEED_1_64 = (0x6) # macro
NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_PARAMS_MESSAGE_ID = (0x30) # macro
NV2080_CTRL_CMD_GR_FECS_BIND_EVTBUF_FOR_UID = (0x20801231) # macro
NV2080_CTRL_GR_FECS_BIND_EVTBUF_FOR_UID_PARAMS_MESSAGE_ID = (0x31) # macro
NV2080_CTRL_CMD_GR_GET_PHYS_GPC_MASK = (0x20801232) # macro
NV2080_CTRL_GR_GET_PHYS_GPC_MASK_PARAMS_MESSAGE_ID = (0x32) # macro
NV2080_CTRL_CMD_GR_GET_PPC_MASK = (0x20801233) # macro
NV2080_CTRL_GR_GET_PPC_MASK_PARAMS_MESSAGE_ID = (0x33) # macro
NV2080_CTRL_CMD_GR_GET_NUM_TPCS_FOR_GPC = (0x20801234) # macro
NV2080_CTRL_GR_GET_NUM_TPCS_FOR_GPC_PARAMS_MESSAGE_ID = (0x34) # macro
NV2080_CTRL_CMD_GR_GET_CTXSW_MODES = (0x20801235) # macro
NV2080_CTRL_GR_GET_CTXSW_MODES_PARAMS_MESSAGE_ID = (0x35) # macro
NV2080_CTRL_CMD_GR_GET_GPC_TILE_MAP = (0x20801236) # macro
NV2080_CTRL_GR_GET_GPC_TILE_MAP_PARAMS_MESSAGE_ID = (0x36) # macro
NV2080_CTRL_CMD_GR_GET_ZCULL_MASK = (0x20801237) # macro
NV2080_CTRL_GR_GET_ZCULL_MASK_PARAMS_MESSAGE_ID = (0x37) # macro
NV2080_CTRL_CMD_GR_FECS_BIND_EVTBUF_FOR_UID_V2 = (0x20801238) # macro
NV2080_CTRL_GR_FECS_BIND_EVTBUF_FOR_UID_V2_PARAMS_MESSAGE_ID = (0x38) # macro
NV2080_CTRL_CMD_GR_GET_GFX_GPC_AND_TPC_INFO = (0x20801239) # macro
NV2080_CTRL_GR_GET_GFX_GPC_AND_TPC_INFO_PARAMS_MESSAGE_ID = (0x39) # macro
NV_GRID_LICENSE_INFO_MAX_LENGTH = (128) # macro
NV_GRID_LICENSE_FEATURE_VPC_EDITION = "GRID-Virtual-PC,2.0;Quadro-Virtual-DWS,5.0;GRID-Virtual-WS,2.0;GRID-Virtual-WS-Ext,2.0" # macro
NV_GRID_LICENSE_FEATURE_VAPPS_EDITION = "GRID-Virtual-Apps,3.0" # macro
NV_GRID_LICENSE_FEATURE_VIRTUAL_WORKSTATION_EDITION = "Quadro-Virtual-DWS,5.0;GRID-Virtual-WS,2.0;GRID-Virtual-WS-Ext,2.0" # macro
NV_GRID_LICENSE_FEATURE_GAMING_EDITION = "GRID-vGaming,8.0" # macro
NV_GRID_LICENSE_FEATURE_COMPUTE_EDITION = "NVIDIA-vComputeServer,9.0;Quadro-Virtual-DWS,5.0" # macro
NV_GRID_LICENSED_PRODUCT_VWS = "NVIDIA RTX Virtual Workstation" # macro
NV_GRID_LICENSED_PRODUCT_GAMING = "NVIDIA Cloud Gaming" # macro
NV_GRID_LICENSED_PRODUCT_VPC = "NVIDIA Virtual PC" # macro
NV_GRID_LICENSED_PRODUCT_VAPPS = "NVIDIA Virtual Applications" # macro
NV_GRID_LICENSED_PRODUCT_COMPUTE = "NVIDIA Virtual Compute Server" # macro
NV2080_CTRL_GPU_INFO_INDEX_MINOR_REVISION_EXT = (0x00000004) # macro
NV2080_CTRL_GPU_INFO_INDEX_NETLIST_REV0 = (0x00000012) # macro
NV2080_CTRL_GPU_INFO_INDEX_NETLIST_REV1 = (0x00000013) # macro
NV2080_CTRL_GPU_INFO_INDEX_SYSMEM_ACCESS = (0x0000001f) # macro
NV2080_CTRL_GPU_INFO_INDEX_GEMINI_BOARD = (0x00000022) # macro
NV2080_CTRL_GPU_INFO_INDEX_SURPRISE_REMOVAL_POSSIBLE = (0x00000025) # macro
NV2080_CTRL_GPU_INFO_INDEX_IBMNPU_RELAXED_ORDERING = (0x00000026) # macro
NV2080_CTRL_GPU_INFO_INDEX_GLOBAL_POISON_FUSE_ENABLED = (0x00000027) # macro
NV2080_CTRL_GPU_INFO_INDEX_NVSWITCH_PROXY_DETECTED = (0x00000028) # macro
NV2080_CTRL_GPU_INFO_INDEX_GPU_SR_SUPPORT = (0x00000029) # macro
NV2080_CTRL_GPU_INFO_INDEX_GPU_SMC_MODE = (0x0000002a) # macro
NV2080_CTRL_GPU_INFO_INDEX_SPLIT_VAS_MGMT_SERVER_CLIENT_RM = (0x0000002b) # macro
NV2080_CTRL_GPU_INFO_INDEX_GPU_SM_VERSION = (0x0000002c) # macro
NV2080_CTRL_GPU_INFO_INDEX_GPU_FLA_CAPABILITY = (0x0000002d) # macro
NV2080_CTRL_GPU_INFO_INDEX_PER_RUNLIST_CHANNEL_RAM = (0x0000002f) # macro
NV2080_CTRL_GPU_INFO_INDEX_GPU_ATS_CAPABILITY = (0x00000030) # macro
NV2080_CTRL_GPU_INFO_INDEX_NVENC_STATS_REPORTING_STATE = (0x00000031) # macro
NV2080_CTRL_GPU_INFO_INDEX_4K_PAGE_ISOLATION_REQUIRED = (0x00000033) # macro
NV2080_CTRL_GPU_INFO_INDEX_DISPLAY_ENABLED = (0x00000034) # macro
NV2080_CTRL_GPU_INFO_INDEX_MOBILE_CONFIG_ENABLED = (0x00000035) # macro
NV2080_CTRL_GPU_INFO_INDEX_GPU_PROFILING_CAPABILITY = (0x00000036) # macro
NV2080_CTRL_GPU_INFO_INDEX_GPU_DEBUGGING_CAPABILITY = (0x00000037) # macro
NV2080_CTRL_GPU_INFO_INDEX_GPU_LOCAL_EGM_CAPABILITY = (0x0000003a) # macro
NV2080_CTRL_GPU_INFO_INDEX_GPU_SELF_HOSTED_CAPABILITY = (0x0000003b) # macro
NV2080_CTRL_GPU_INFO_INDEX_CMP_SKU = (0x0000003c) # macro
NV2080_CTRL_GPU_INFO_INDEX_DMABUF_CAPABILITY = (0x0000003d) # macro
NV2080_CTRL_GPU_INFO_INDEX_IS_RESETLESS_MIG_SUPPORTED = (0x0000003f) # macro
NV2080_CTRL_GPU_INFO_MAX_LIST_SIZE = (0x00000041) # macro
NV2080_CTRL_GPU_INFO_MINOR_REVISION_EXT_NONE = (0x00000000) # macro
NV2080_CTRL_GPU_INFO_MINOR_REVISION_EXT_P = (0x00000001) # macro
NV2080_CTRL_GPU_INFO_MINOR_REVISION_EXT_V = (0x00000002) # macro
NV2080_CTRL_GPU_INFO_MINOR_REVISION_EXT_PV = (0x00000003) # macro
NV2080_CTRL_GPU_INFO_SYSMEM_ACCESS_NO = (0x00000000) # macro
NV2080_CTRL_GPU_INFO_SYSMEM_ACCESS_YES = (0x00000001) # macro
NV2080_CTRL_GPU_INFO_INDEX_GEMINI_BOARD_NO = (0x00000000) # macro
NV2080_CTRL_GPU_INFO_INDEX_GEMINI_BOARD_YES = (0x00000001) # macro
NV2080_CTRL_GPU_INFO_INDEX_SURPRISE_REMOVAL_POSSIBLE_NO = (0x00000000) # macro
NV2080_CTRL_GPU_INFO_INDEX_SURPRISE_REMOVAL_POSSIBLE_YES = (0x00000001) # macro
NV2080_CTRL_GPU_INFO_IBMNPU_RELAXED_ORDERING_DISABLED = (0x00000000) # macro
NV2080_CTRL_GPU_INFO_IBMNPU_RELAXED_ORDERING_ENABLED = (0x00000001) # macro
NV2080_CTRL_GPU_INFO_IBMNPU_RELAXED_ORDERING_UNSUPPORTED = (0xFFFFFFFF) # macro
NV2080_CTRL_GPU_INFO_INDEX_GLOBAL_POISON_FUSE_ENABLED_NO = (0x00000000) # macro
NV2080_CTRL_GPU_INFO_INDEX_GLOBAL_POISON_FUSE_ENABLED_YES = (0x00000001) # macro
NV2080_CTRL_GPU_INFO_NVSWITCH_PROXY_DETECTED_NO = (0x00000000) # macro
NV2080_CTRL_GPU_INFO_NVSWITCH_PROXY_DETECTED_YES = (0x00000001) # macro
NV2080_CTRL_GPU_INFO_INDEX_GPU_SR_SUPPORT_NO = (0x00000000) # macro
NV2080_CTRL_GPU_INFO_INDEX_GPU_SR_SUPPORT_YES = (0x00000001) # macro
NV2080_CTRL_GPU_INFO_GPU_SMC_MODE_UNSUPPORTED = (0x00000000) # macro
NV2080_CTRL_GPU_INFO_GPU_SMC_MODE_ENABLED = (0x00000001) # macro
NV2080_CTRL_GPU_INFO_GPU_SMC_MODE_DISABLED = (0x00000002) # macro
NV2080_CTRL_GPU_INFO_GPU_SMC_MODE_ENABLE_PENDING = (0x00000003) # macro
NV2080_CTRL_GPU_INFO_GPU_SMC_MODE_DISABLE_PENDING = (0x00000004) # macro
NV2080_CTRL_GPU_INFO_SPLIT_VAS_MGMT_SERVER_CLIENT_RM_NO = (0x00000000) # macro
NV2080_CTRL_GPU_INFO_SPLIT_VAS_MGMT_SERVER_CLIENT_RM_YES = (0x00000001) # macro
NV2080_CTRL_GPU_INFO_INDEX_GPU_FLA_CAPABILITY_NO = (0x00000000) # macro
NV2080_CTRL_GPU_INFO_INDEX_GPU_FLA_CAPABILITY_YES = (0x00000001) # macro
NV2080_CTRL_GPU_INFO_INDEX_PER_RUNLIST_CHANNEL_RAM_DISABLED = (0x00000000) # macro
NV2080_CTRL_GPU_INFO_INDEX_PER_RUNLIST_CHANNEL_RAM_ENABLED = (0x00000001) # macro
NV2080_CTRL_GPU_INFO_INDEX_GPU_ATS_CAPABILITY_NO = (0x00000000) # macro
NV2080_CTRL_GPU_INFO_INDEX_GPU_ATS_CAPABILITY_YES = (0x00000001) # macro
NV2080_CTRL_GPU_INFO_NVENC_STATS_REPORTING_STATE_DISABLED = (0x00000000) # macro
NV2080_CTRL_GPU_INFO_NVENC_STATS_REPORTING_STATE_ENABLED = (0x00000001) # macro
NV2080_CTRL_GPU_INFO_NVENC_STATS_REPORTING_STATE_NOT_SUPPORTED = (0x00000002) # macro
NV2080_CTRL_GPU_INFO_INDEX_4K_PAGE_ISOLATION_REQUIRED_NO = (0x00000000) # macro
NV2080_CTRL_GPU_INFO_INDEX_4K_PAGE_ISOLATION_REQUIRED_YES = (0x00000001) # macro
NV2080_CTRL_GPU_INFO_DISPLAY_ENABLED_NO = (0x00000000) # macro
NV2080_CTRL_GPU_INFO_DISPLAY_ENABLED_YES = (0x00000001) # macro
NV2080_CTRL_GPU_INFO_INDEX_MOBILE_CONFIG_ENABLED_NO = (0x00000000) # macro
NV2080_CTRL_GPU_INFO_INDEX_MOBILE_CONFIG_ENABLED_YES = (0x00000001) # macro
NV2080_CTRL_GPU_INFO_INDEX_GPU_PROFILING_CAPABILITY_DISABLED = (0x00000000) # macro
NV2080_CTRL_GPU_INFO_INDEX_GPU_PROFILING_CAPABILITY_ENABLED = (0x00000001) # macro
NV2080_CTRL_GPU_INFO_INDEX_GPU_DEBUGGING_CAPABILITY_DISABLED = (0x00000000) # macro
NV2080_CTRL_GPU_INFO_INDEX_GPU_DEBUGGING_CAPABILITY_ENABLED = (0x00000001) # macro
NV2080_CTRL_GPU_INFO_INDEX_GPU_LOCAL_EGM_CAPABILITY_NO = (0x00000000) # macro
NV2080_CTRL_GPU_INFO_INDEX_GPU_LOCAL_EGM_CAPABILITY_YES = (0x00000001) # macro
NV2080_CTRL_GPU_INFO_INDEX_GPU_LOCAL_EGM_PEERID = ['31', ':', '1'] # macro
NV2080_CTRL_GPU_INFO_INDEX_GPU_SELF_HOSTED_CAPABILITY_NO = (0x00000000) # macro
NV2080_CTRL_GPU_INFO_INDEX_GPU_SELF_HOSTED_CAPABILITY_YES = (0x00000001) # macro
NV2080_CTRL_GPU_INFO_INDEX_CMP_SKU_NO = (0x00000000) # macro
NV2080_CTRL_GPU_INFO_INDEX_CMP_SKU_YES = (0x00000001) # macro
NV2080_CTRL_GPU_INFO_INDEX_DMABUF_CAPABILITY_NO = (0x00000000) # macro
NV2080_CTRL_GPU_INFO_INDEX_DMABUF_CAPABILITY_YES = (0x00000001) # macro
NV2080_CTRL_GPU_INFO_INDEX_IS_RESETLESS_MIG_SUPPORTED_NO = (0x00000000) # macro
NV2080_CTRL_GPU_INFO_INDEX_IS_RESETLESS_MIG_SUPPORTED_YES = (0x00000001) # macro
NV2080_CTRL_CMD_GPU_GET_INFO = (0x20800101) # macro
NV2080_CTRL_GPU_GET_INFO_PARAMS_MESSAGE_ID = (0x1) # macro
NV2080_CTRL_CMD_GPU_GET_INFO_V2 = (0x20800102) # macro
NV2080_CTRL_GPU_GET_INFO_V2_PARAMS_MESSAGE_ID = (0x2) # macro
NV2080_CTRL_CMD_GPU_GET_NAME_STRING = (0x20800110) # macro
NV2080_GPU_MAX_NAME_STRING_LENGTH = (0x0000040) # macro
NV2080_CTRL_GPU_GET_NAME_STRING_FLAGS_TYPE = ['31', ':', '0'] # macro
NV2080_CTRL_GPU_GET_NAME_STRING_FLAGS_TYPE_ASCII = (0x00000000) # macro
NV2080_CTRL_GPU_GET_NAME_STRING_FLAGS_TYPE_UNICODE = (0x00000001) # macro
NV2080_CTRL_GPU_GET_NAME_STRING_PARAMS_MESSAGE_ID = (0x10) # macro
NV2080_CTRL_CMD_GPU_GET_SHORT_NAME_STRING = (0x20800111) # macro
NV2080_CTRL_GPU_GET_SHORT_NAME_STRING_PARAMS_MESSAGE_ID = (0x11) # macro
NV2080_CTRL_CMD_GPU_SET_POWER = (0x20800112) # macro
NV2080_CTRL_GPU_SET_POWER_PARAMS_MESSAGE_ID = (0x12) # macro
NV2080_CTRL_GPU_SET_POWER_STATE_GPU_LEVEL_0 = (0x00000000) # macro
NV2080_CTRL_GPU_SET_POWER_STATE_GPU_LEVEL_1 = (0x00000001) # macro
NV2080_CTRL_GPU_SET_POWER_STATE_GPU_LEVEL_2 = (0x00000002) # macro
NV2080_CTRL_GPU_SET_POWER_STATE_GPU_LEVEL_3 = (0x00000003) # macro
NV2080_CTRL_GPU_SET_POWER_STATE_GPU_LEVEL_4 = (0x00000004) # macro
NV2080_CTRL_GPU_SET_POWER_STATE_GPU_LEVEL_7 = (0x00000007) # macro
NV2080_CTRL_CMD_GPU_GET_SDM = (0x20800118) # macro
NV2080_CTRL_GPU_GET_SDM_PARAMS_MESSAGE_ID = (0x18) # macro
NV2080_CTRL_CMD_GPU_SET_SDM = (0x20800120) # macro
NV2080_CTRL_GPU_SET_SDM_PARAMS_MESSAGE_ID = (0x20) # macro
NV2080_CTRL_CMD_GPU_GET_SIMULATION_INFO = (0x20800119) # macro
NV2080_CTRL_GPU_GET_SIMULATION_INFO_PARAMS_MESSAGE_ID = (0x19) # macro
NV2080_CTRL_GPU_GET_SIMULATION_INFO_TYPE_NONE = (0x00000000) # macro
NV2080_CTRL_GPU_GET_SIMULATION_INFO_TYPE_MODS_AMODEL = (0x00000001) # macro
NV2080_CTRL_GPU_GET_SIMULATION_INFO_TYPE_LIVE_AMODEL = (0x00000002) # macro
NV2080_CTRL_GPU_GET_SIMULATION_INFO_TYPE_FMODEL = (0x00000003) # macro
NV2080_CTRL_GPU_GET_SIMULATION_INFO_TYPE_RTL = (0x00000004) # macro
NV2080_CTRL_GPU_GET_SIMULATION_INFO_TYPE_EMU = (0x00000005) # macro
NV2080_CTRL_GPU_GET_SIMULATION_INFO_TYPE_EMU_LOW_POWER = (0x00000006) # macro
NV2080_CTRL_GPU_GET_SIMULATION_INFO_TYPE_DFPGA = (0x00000007) # macro
NV2080_CTRL_GPU_GET_SIMULATION_INFO_TYPE_DFPGA_RTL = (0x00000008) # macro
NV2080_CTRL_GPU_GET_SIMULATION_INFO_TYPE_DFPGA_FMODEL = (0x00000009) # macro
NV2080_CTRL_GPU_GET_SIMULATION_INFO_TYPE_UNKNOWN = (0xFFFFFFFF) # macro
NV2080_CTRL_GPU_REG_OP_READ_32 = (0x00000000) # macro
NV2080_CTRL_GPU_REG_OP_WRITE_32 = (0x00000001) # macro
NV2080_CTRL_GPU_REG_OP_READ_64 = (0x00000002) # macro
NV2080_CTRL_GPU_REG_OP_WRITE_64 = (0x00000003) # macro
NV2080_CTRL_GPU_REG_OP_READ_08 = (0x00000004) # macro
NV2080_CTRL_GPU_REG_OP_WRITE_08 = (0x00000005) # macro
NV2080_CTRL_GPU_REG_OP_TYPE_GLOBAL = (0x00000000) # macro
NV2080_CTRL_GPU_REG_OP_TYPE_GR_CTX = (0x00000001) # macro
NV2080_CTRL_GPU_REG_OP_TYPE_GR_CTX_TPC = (0x00000002) # macro
NV2080_CTRL_GPU_REG_OP_TYPE_GR_CTX_SM = (0x00000004) # macro
NV2080_CTRL_GPU_REG_OP_TYPE_GR_CTX_CROP = (0x00000008) # macro
NV2080_CTRL_GPU_REG_OP_TYPE_GR_CTX_ZROP = (0x00000010) # macro
NV2080_CTRL_GPU_REG_OP_TYPE_FB = (0x00000020) # macro
NV2080_CTRL_GPU_REG_OP_TYPE_GR_CTX_QUAD = (0x00000040) # macro
NV2080_CTRL_GPU_REG_OP_TYPE_DEVICE = (0x00000080) # macro
NV2080_CTRL_GPU_REG_OP_STATUS_SUCCESS = (0x00) # macro
NV2080_CTRL_GPU_REG_OP_STATUS_INVALID_OP = (0x01) # macro
NV2080_CTRL_GPU_REG_OP_STATUS_INVALID_TYPE = (0x02) # macro
NV2080_CTRL_GPU_REG_OP_STATUS_INVALID_OFFSET = (0x04) # macro
NV2080_CTRL_GPU_REG_OP_STATUS_UNSUPPORTED_OP = (0x08) # macro
NV2080_CTRL_GPU_REG_OP_STATUS_INVALID_MASK = (0x10) # macro
NV2080_CTRL_GPU_REG_OP_STATUS_NOACCESS = (0x20) # macro
NV2080_CTRL_CMD_GPU_EXEC_REG_OPS = (0x20800122) # macro
NV2080_CTRL_GPU_EXEC_REG_OPS_PARAMS_MESSAGE_ID = (0x22) # macro
NV2080_CTRL_CMD_GPU_GET_ENGINES = (0x20800123) # macro
NV2080_CTRL_GPU_GET_ENGINES_PARAMS_MESSAGE_ID = (0x23) # macro
NV2080_CTRL_CMD_GPU_GET_ENGINES_V2 = (0x20800170) # macro
NV2080_GPU_MAX_ENGINES_LIST_SIZE = 0x40 # macro
NV2080_CTRL_GPU_GET_ENGINES_V2_PARAMS_MESSAGE_ID = (0x70) # macro
NV2080_CTRL_CMD_GPU_GET_ENGINE_CLASSLIST = (0x20800124) # macro
NV2080_CTRL_GPU_GET_ENGINE_CLASSLIST_PARAMS_MESSAGE_ID = (0x24) # macro
NV2080_CTRL_CMD_GPU_GET_ENGINE_FAULT_INFO = (0x20800125) # macro
NV2080_CTRL_GPU_GET_ENGINE_FAULT_INFO_PARAMS_MESSAGE_ID = (0x25) # macro
NV2080_CTRL_CMD_GPU_QUERY_MODE = (0x20800128) # macro
NV2080_CTRL_GPU_QUERY_MODE_UNKNOWN_MODE = (0x00000000) # macro
NV2080_CTRL_GPU_QUERY_MODE_GRAPHICS_MODE = (0x00000001) # macro
NV2080_CTRL_GPU_QUERY_MODE_COMPUTE_MODE = (0x00000002) # macro
NV2080_CTRL_GPU_QUERY_MODE_PARAMS_MESSAGE_ID = (0x28) # macro
NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ID_MAIN = 0 # macro
NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ID_PM = 1 # macro
NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ID_PATCH = 2 # macro
NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ID_BUFFER_BUNDLE_CB = 3 # macro
NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ID_PAGEPOOL = 4 # macro
NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ID_ATTRIBUTE_CB = 5 # macro
NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ID_RTV_CB_GLOBAL = 6 # macro
NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ID_GFXP_POOL = 7 # macro
NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ID_GFXP_CTRL_BLK = 8 # macro
NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ID_FECS_EVENT = 9 # macro
NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ID_PRIV_ACCESS_MAP = 10 # macro
NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ID_UNRESTRICTED_PRIV_ACCESS_MAP = 11 # macro
NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ID_GLOBAL_PRIV_ACCESS_MAP = 12 # macro
NV2080_CTRL_GPU_PROMOTE_CONTEXT_MAX_ENTRIES = 16 # macro
NV2080_CTRL_CMD_GPU_PROMOTE_CTX = (0x2080012b) # macro
NV2080_CTRL_GPU_PROMOTE_CTX_PARAMS_MESSAGE_ID = (0x2B) # macro
NV2080_CTRL_CMD_GPU_EVICT_CTX = (0x2080012c) # macro
NV2080_CTRL_GPU_EVICT_CTX_PARAMS_MESSAGE_ID = (0x2C) # macro
NV2080_CTRL_CMD_GPU_INITIALIZE_CTX = (0x2080012d) # macro
NV2080_CTRL_GPU_INITIALIZE_CTX_PARAMS_MESSAGE_ID = (0x2D) # macro
NV2080_CTRL_GPU_INITIALIZE_CTX_APERTURE = ['1', ':', '0'] # macro
NV2080_CTRL_GPU_INITIALIZE_CTX_APERTURE_VIDMEM = (0x00000000) # macro
NV2080_CTRL_GPU_INITIALIZE_CTX_APERTURE_COH_SYS = (0x00000001) # macro
NV2080_CTRL_GPU_INITIALIZE_CTX_APERTURE_NCOH_SYS = (0x00000002) # macro
NV2080_CTRL_GPU_INITIALIZE_CTX_GPU_CACHEABLE = ['2', ':', '2'] # macro
NV2080_CTRL_GPU_INITIALIZE_CTX_GPU_CACHEABLE_YES = (0x00000000) # macro
NV2080_CTRL_GPU_INITIALIZE_CTX_GPU_CACHEABLE_NO = (0x00000001) # macro
NV2080_CTRL_GPU_INITIALIZE_CTX_PRESERVE_CTX = ['3', ':', '3'] # macro
NV2080_CTRL_GPU_INITIALIZE_CTX_PRESERVE_CTX_NO = (0x00000000) # macro
NV2080_CTRL_GPU_INITIALIZE_CTX_PRESERVE_CTX_YES = (0x00000001) # macro
NV2080_CTRL_CMD_GPU_QUERY_ECC_INTR = (0x2080012e) # macro
NV2080_CTRL_CMD_GPU_QUERY_ECC_STATUS = (0x2080012f) # macro
NV2080_CTRL_GPU_ECC_UNIT_COUNT = (0x00000019) # macro
NV2080_CTRL_GPU_QUERY_ECC_STATUS_FLAGS_TYPE = ['0', ':', '0'] # macro
NV2080_CTRL_GPU_QUERY_ECC_STATUS_FLAGS_TYPE_FILTERED = (0x00000000) # macro
NV2080_CTRL_GPU_QUERY_ECC_STATUS_FLAGS_TYPE_RAW = (0x00000001) # macro
NV2080_CTRL_GPU_QUERY_ECC_STATUS_UNC_ERR_FALSE = 0 # macro
NV2080_CTRL_GPU_QUERY_ECC_STATUS_UNC_ERR_TRUE = 1 # macro
NV2080_CTRL_GPU_QUERY_ECC_STATUS_UNC_ERR_INDETERMINATE = 2 # macro
NV2080_CTRL_GPU_QUERY_ECC_STATUS_PARAMS_MESSAGE_ID = (0x2F) # macro
NV2080_CTRL_CMD_GPU_SET_COMPUTE_MODE_RULES = (0x20800130) # macro
NV2080_CTRL_GPU_COMPUTE_MODE_RULES_NONE = (0x00000000) # macro
NV2080_CTRL_GPU_COMPUTE_MODE_RULES_EXCLUSIVE_COMPUTE = (0x00000001) # macro
NV2080_CTRL_GPU_COMPUTE_MODE_RULES_COMPUTE_PROHIBITED = (0x00000002) # macro
NV2080_CTRL_GPU_COMPUTE_MODE_RULES_EXCLUSIVE_COMPUTE_PROCESS = (0x00000003) # macro
NV2080_CTRL_GPU_SET_COMPUTE_MODE_RULES_PARAMS_MESSAGE_ID = (0x30) # macro
NV2080_CTRL_CMD_GPU_QUERY_COMPUTE_MODE_RULES = (0x20800131) # macro
NV2080_CTRL_GPU_QUERY_COMPUTE_MODE_RULES_PARAMS_MESSAGE_ID = (0x31) # macro
NV2080_CTRL_CMD_GPU_QUERY_ECC_CONFIGURATION = (0x20800133) # macro
NV2080_CTRL_GPU_ECC_CONFIGURATION_DISABLED = (0x00000000) # macro
NV2080_CTRL_GPU_ECC_CONFIGURATION_ENABLED = (0x00000001) # macro
NV2080_CTRL_GPU_QUERY_ECC_CONFIGURATION_PARAMS_MESSAGE_ID = (0x33) # macro
NV2080_CTRL_CMD_GPU_SET_ECC_CONFIGURATION = (0x20800134) # macro
NV2080_CTRL_GPU_ECC_CONFIGURATION_DISABLE = (0x00000000) # macro
NV2080_CTRL_GPU_ECC_CONFIGURATION_ENABLE = (0x00000001) # macro
NV2080_CTRL_GPU_SET_ECC_CONFIGURATION_PARAMS_MESSAGE_ID = (0x34) # macro
NV2080_CTRL_CMD_GPU_RESET_ECC_ERROR_STATUS = (0x20800136) # macro
NV2080_CTRL_GPU_ECC_ERROR_STATUS_NONE = (0x00000000) # macro
NV2080_CTRL_GPU_ECC_ERROR_STATUS_VOLATILE = (0x00000001) # macro
NV2080_CTRL_GPU_ECC_ERROR_STATUS_AGGREGATE = (0x00000002) # macro
NV2080_CTRL_GPU_RESET_ECC_ERROR_STATUS_FLAGS_FORCE_PURGE = ['0', ':', '0'] # macro
NV2080_CTRL_GPU_RESET_ECC_ERROR_STATUS_FLAGS_FORCE_PURGE_FALSE = 0 # macro
NV2080_CTRL_GPU_RESET_ECC_ERROR_STATUS_FLAGS_FORCE_PURGE_TRUE = 1 # macro
NV2080_CTRL_GPU_RESET_ECC_ERROR_STATUS_PARAMS_MESSAGE_ID = (0x36) # macro
NV2080_CTRL_CMD_GPU_GET_FERMI_GPC_INFO = (0x20800137) # macro
NV2080_CTRL_GPU_GET_FERMI_GPC_INFO_PARAMS_MESSAGE_ID = (0x37) # macro
NV2080_CTRL_CMD_GPU_GET_FERMI_TPC_INFO = (0x20800138) # macro
NV2080_CTRL_GPU_GET_FERMI_TPC_INFO_PARAMS_MESSAGE_ID = (0x38) # macro
NV2080_CTRL_CMD_GPU_GET_FERMI_ZCULL_INFO = (0x20800139) # macro
NV2080_CTRL_GPU_GET_FERMI_ZCULL_INFO_PARAMS_MESSAGE_ID = (0x39) # macro
NV2080_CTRL_CMD_GPU_GET_OEM_BOARD_INFO = (0x2080013f) # macro
NV2080_GPU_MAX_MARKETING_NAME_LENGTH = (0x00000018) # macro
NV2080_GPU_MAX_SERIAL_NUMBER_LENGTH = (0x00000010) # macro
NV2080_GPU_MAX_MEMORY_PART_ID_LENGTH = (0x00000014) # macro
NV2080_GPU_MAX_MEMORY_DATE_CODE_LENGTH = (0x00000006) # macro
NV2080_GPU_MAX_PRODUCT_PART_NUMBER_LENGTH = (0x00000014) # macro
NV2080_CTRL_GPU_GET_OEM_BOARD_INFO_PARAMS_MESSAGE_ID = (0x3F) # macro
NV2080_CTRL_CMD_GPU_GET_ID = (0x20800142) # macro
NV2080_CTRL_GPU_GET_ID_PARAMS_MESSAGE_ID = (0x42) # macro
NV2080_CTRL_CMD_GPU_SET_GPU_DEBUG_MODE = (0x20800143) # macro
NV2080_CTRL_GPU_SET_GPU_DEBUG_MODE_PARAMS_MESSAGE_ID = (0x43) # macro
NV2080_CTRL_GPU_DEBUG_MODE_ENABLED = (0x00000001) # macro
NV2080_CTRL_GPU_DEBUG_MODE_DISABLED = (0x00000002) # macro
NV2080_CTRL_CMD_GPU_GET_GPU_DEBUG_MODE = (0x20800144) # macro
NV2080_CTRL_GPU_GET_GPU_DEBUG_MODE_PARAMS_MESSAGE_ID = (0x44) # macro
NV2080_CTRL_CMD_GPU_GET_ENGINE_PARTNERLIST = (0x20800147) # macro
NV2080_CTRL_GPU_MAX_ENGINE_PARTNERS = (0x00000020) # macro
NV2080_CTRL_GPU_GET_ENGINE_PARTNERLIST_PARAMS_MESSAGE_ID = (0x47) # macro
NV2080_CTRL_CMD_GPU_GET_GID_INFO = (0x2080014a) # macro
NV2080_GPU_MAX_GID_LENGTH = (0x000000100) # macro
NV2080_GPU_MAX_SHA1_BINARY_GID_LENGTH = (0x000000010) # macro
NV2080_CTRL_GPU_GET_GID_INFO_PARAMS_MESSAGE_ID = (0x4A) # macro
NV2080_GPU_CMD_GPU_GET_GID_FLAGS_FORMAT = ['1', ':', '0'] # macro
NV2080_GPU_CMD_GPU_GET_GID_FLAGS_FORMAT_ASCII = (0x00000000) # macro
NV2080_GPU_CMD_GPU_GET_GID_FLAGS_FORMAT_BINARY = (0x00000002) # macro
NV2080_GPU_CMD_GPU_GET_GID_FLAGS_TYPE = ['2', ':', '2'] # macro
NV2080_GPU_CMD_GPU_GET_GID_FLAGS_TYPE_SHA1 = (0x00000000) # macro
NV2080_CTRL_CMD_GPU_GET_INFOROM_OBJECT_VERSION = (0x2080014b) # macro
NV2080_CTRL_GPU_INFOROM_OBJ_TYPE_LEN = 3 # macro
NV2080_CTRL_GPU_GET_INFOROM_OBJECT_VERSION_PARAMS_MESSAGE_ID = (0x4B) # macro
NV2080_CTRL_CMD_SET_GPU_OPTIMUS_INFO = (0x2080014c) # macro
NV2080_CTRL_GPU_OPTIMUS_INFO_PARAMS_MESSAGE_ID = (0x4C) # macro
NV2080_CTRL_CMD_GPU_GET_IP_VERSION = (0x2080014d) # macro
NV2080_CTRL_GPU_GET_IP_VERSION_PARAMS_MESSAGE_ID = (0x4D) # macro
NV2080_CTRL_GPU_GET_IP_VERSION_DISPLAY = (0x00000001) # macro
NV2080_CTRL_GPU_GET_IP_VERSION_HDACODEC = (0x00000002) # macro
NV2080_CTRL_GPU_GET_IP_VERSION_PMGR = (0x00000003) # macro
NV2080_CTRL_GPU_GET_IP_VERSION_PPWR_PMU = (0x00000004) # macro
NV2080_CTRL_GPU_GET_IP_VERSION_DISP_FALCON = (0x00000005) # macro
NV2080_CTRL_GPU_ILLUM_ATTRIB_LOGO_BRIGHTNESS = 0 # macro
NV2080_CTRL_GPU_ILLUM_ATTRIB_SLI_BRIGHTNESS = 1 # macro
NV2080_CTRL_CMD_GPU_QUERY_ILLUM_SUPPORT = (0x20800153) # macro
NV2080_CTRL_CMD_GPU_QUERY_ILLUM_SUPPORT_PARAMS_MESSAGE_ID = (0x53) # macro
NV2080_CTRL_CMD_GPU_GET_ILLUM = (0x20800154) # macro
NV2080_CTRL_GPU_GET_ILLUM_PARAMS_MESSAGE_ID = (0x54) # macro
NV2080_CTRL_CMD_GPU_SET_ILLUM = (0x20800155) # macro
NV2080_CTRL_GPU_SET_ILLUM_PARAMS_MESSAGE_ID = (0x55) # macro
NV2080_CTRL_CMD_GPU_GET_INFOROM_IMAGE_VERSION = (0x20800156) # macro
NV2080_CTRL_GPU_INFOROM_IMAGE_VERSION_LEN = 16 # macro
NV2080_CTRL_GPU_GET_INFOROM_IMAGE_VERSION_PARAMS_MESSAGE_ID = (0x56) # macro
NV2080_CTRL_CMD_GPU_QUERY_INFOROM_ECC_SUPPORT = (0x20800157) # macro
NV2080_CTRL_CMD_GPU_GET_PHYSICAL_BRIDGE_VERSION_INFO = (0x2080015a) # macro
NV2080_CTRL_MAX_PHYSICAL_BRIDGE = (100) # macro
NV2080_CTRL_GPU_GET_PHYSICAL_BRIDGE_VERSION_INFO_PARAMS_MESSAGE_ID = (0x5A) # macro
NV2080_CTRL_CMD_GPU_GET_ALL_BRIDGES_UPSTREAM_OF_GPU = (0x2080015b) # macro
NV2080_CTRL_GPU_GET_ALL_BRIDGES_UPSTREAM_OF_GPU_PARAMS_MESSAGE_ID = (0x5B) # macro
NV2080_CTRL_CMD_GPU_QUERY_SCRUBBER_STATUS = (0x2080015f) # macro
NV2080_CTRL_GPU_QUERY_SCRUBBER_STATUS_PARAMS_MESSAGE_ID = (0x5F) # macro
NV2080_CTRL_GPU_QUERY_SCRUBBER_STATUS_SCRUBBER_RUNNING = (0x00000000) # macro
NV2080_CTRL_GPU_QUERY_SCRUBBER_STATUS_SCRUBBER_IDLE = (0x00000001) # macro
NV2080_CTRL_CMD_GPU_GET_VPR_CAPS = (0x20800160) # macro
NV2080_CTRL_GPU_GET_VPR_CAPS_PARAMS_MESSAGE_ID = (0x60) # macro
NV2080_CTRL_CMD_GPU_HANDLE_GPU_SR = (0x20800167) # macro
NV2080_CTRL_CMD_GPU_GET_PES_INFO = (0x20800168) # macro
NV2080_CTRL_CMD_GPU_GET_PES_INFO_MAX_TPC_PER_GPC_COUNT = 10 # macro
NV2080_CTRL_GPU_GET_PES_INFO_PARAMS_MESSAGE_ID = (0x68) # macro
NV2080_CTRL_CMD_GPU_GET_OEM_INFO = (0x20800169) # macro
NV2080_GPU_MAX_OEM_INFO_LENGTH = (0x000001F8) # macro
NV2080_CTRL_GPU_GET_OEM_INFO_PARAMS_MESSAGE_ID = (0x69) # macro
NV2080_CTRL_CMD_GPU_GET_VPR_INFO = (0x2080016b) # macro
NV2080_CTRL_GPU_GET_VPR_INFO_PARAMS_MESSAGE_ID = (0x6B) # macro
NV2080_CTRL_CMD_GPU_GET_ENCODER_CAPACITY = (0x2080016c) # macro
NV2080_CTRL_GPU_GET_ENCODER_CAPACITY_PARAMS_MESSAGE_ID = (0x6C) # macro
NV2080_CTRL_GPU_GET_NVENC_SW_SESSION_STATS = (0x2080016d) # macro
NV2080_CTRL_GPU_GET_NVENC_SW_SESSION_STATS_PARAMS_MESSAGE_ID = (0x6D) # macro
NV2080_CTRL_GPU_NVENC_SESSION_INFO_MAX_COPYOUT_ENTRIES = 0x200 # macro
NV2080_CTRL_GPU_GET_NVENC_SW_SESSION_INFO_PARAMS_MESSAGE_ID = (0x6E) # macro
NV2080_CTRL_GPU_GET_NVENC_SW_SESSION_INFO = (0x2080016e) # macro
NV2080_CTRL_GPU_SET_FABRIC_BASE_ADDR_PARAMS_MESSAGE_ID = (0x6F) # macro
NV2080_CTRL_CMD_GPU_SET_FABRIC_BASE_ADDR = (0x2080016f) # macro
NV2080_CTRL_GPU_VIRTUAL_INTERRUPT_PARAMS_MESSAGE_ID = (0x72) # macro
NV2080_CTRL_CMD_GPU_VIRTUAL_INTERRUPT = (0x20800172) # macro
NV2080_CTRL_CMD_GPU_QUERY_FUNCTION_STATUS_PARAMS_MESSAGE_ID = (0x73) # macro
NV2080_CTRL_CMD_GPU_QUERY_FUNCTION_STATUS = (0x20800173) # macro
NV_GI_UUID_LEN = 16 # macro
PARTITIONID_INVALID = 0xFFFFFFFF # macro
NV2080_CTRL_GPU_PARTITION_ID_INVALID = 0xFFFFFFFF # macro
NV2080_CTRL_GPU_MAX_PARTITIONS = 0x00000008 # macro
NV2080_CTRL_GPU_MAX_PARTITION_IDS = 0x00000009 # macro
NV2080_CTRL_GPU_MAX_SMC_IDS = 0x00000008 # macro
NV2080_CTRL_GPU_MAX_GPC_PER_SMC = 0x0000000c # macro
NV2080_CTRL_GPU_MAX_CE_PER_SMC = 0x00000008 # macro
NV2080_CTRL_GPU_PARTITION_FLAG_MEMORY_SIZE = ['1', ':', '0'] # macro
NV2080_CTRL_GPU_PARTITION_FLAG_MEMORY_SIZE_FULL = 0x00000000 # macro
NV2080_CTRL_GPU_PARTITION_FLAG_MEMORY_SIZE_HALF = 0x00000001 # macro
NV2080_CTRL_GPU_PARTITION_FLAG_MEMORY_SIZE_QUARTER = 0x00000002 # macro
NV2080_CTRL_GPU_PARTITION_FLAG_MEMORY_SIZE_EIGHTH = 0x00000003 # macro
NV2080_CTRL_GPU_PARTITION_FLAG_MEMORY_SIZE__SIZE = 4 # macro
NV2080_CTRL_GPU_PARTITION_FLAG_COMPUTE_SIZE = ['4', ':', '2'] # macro
NV2080_CTRL_GPU_PARTITION_FLAG_COMPUTE_SIZE_FULL = 0x00000000 # macro
NV2080_CTRL_GPU_PARTITION_FLAG_COMPUTE_SIZE_HALF = 0x00000001 # macro
NV2080_CTRL_GPU_PARTITION_FLAG_COMPUTE_SIZE_MINI_HALF = 0x00000002 # macro
NV2080_CTRL_GPU_PARTITION_FLAG_COMPUTE_SIZE_QUARTER = 0x00000003 # macro
NV2080_CTRL_GPU_PARTITION_FLAG_COMPUTE_SIZE_MINI_QUARTER = 0x00000004 # macro
NV2080_CTRL_GPU_PARTITION_FLAG_COMPUTE_SIZE_EIGHTH = 0x00000005 # macro
NV2080_CTRL_GPU_PARTITION_FLAG_COMPUTE_SIZE__SIZE = 6 # macro
NV2080_CTRL_GPU_PARTITION_MAX_TYPES = 20 # macro
NV2080_CTRL_GPU_PARTITION_FLAG_REQ_DEC_JPG_OFA = ['30', ':', '30'] # macro
NV2080_CTRL_GPU_PARTITION_FLAG_REQ_DEC_JPG_OFA_DISABLE = 0 # macro
NV2080_CTRL_GPU_PARTITION_FLAG_REQ_DEC_JPG_OFA_ENABLE = 1 # macro
NV2080_CTRL_GPU_PARTITION_FLAG_PLACE_AT_SPAN = ['31', ':', '31'] # macro
NV2080_CTRL_GPU_PARTITION_FLAG_PLACE_AT_SPAN_DISABLE = 0 # macro
NV2080_CTRL_GPU_PARTITION_FLAG_PLACE_AT_SPAN_ENABLE = 1 # macro
# def NV2080_CTRL_GPU_PARTITION_FLAG_FULL_GPU(DRF_DEF(2080, _CTRL_GPU_PARTITION_FLAG, _MEMORY_SIZE, _FULL):  # macro
#    return |DRF_DEF(2080,_CTRL_GPU_PARTITION_FLAG,_COMPUTE_SIZE,_FULL))
# def NV2080_CTRL_GPU_PARTITION_FLAG_ONE_HALF_GPU(DRF_DEF(2080, _CTRL_GPU_PARTITION_FLAG, _MEMORY_SIZE, _HALF):  # macro
#    return |DRF_DEF(2080,_CTRL_GPU_PARTITION_FLAG,_COMPUTE_SIZE,_HALF))
# def NV2080_CTRL_GPU_PARTITION_FLAG_ONE_MINI_HALF_GPU(DRF_DEF(2080, _CTRL_GPU_PARTITION_FLAG, _MEMORY_SIZE, _HALF):  # macro
#    return |DRF_DEF(2080,_CTRL_GPU_PARTITION_FLAG,_COMPUTE_SIZE,_MINI_HALF))
# def NV2080_CTRL_GPU_PARTITION_FLAG_ONE_QUARTER_GPU(DRF_DEF(2080, _CTRL_GPU_PARTITION_FLAG, _MEMORY_SIZE, _QUARTER):  # macro
#    return |DRF_DEF(2080,_CTRL_GPU_PARTITION_FLAG,_COMPUTE_SIZE,_QUARTER))
# def NV2080_CTRL_GPU_PARTITION_FLAG_ONE_MINI_QUARTER_GPU(DRF_DEF(2080, _CTRL_GPU_PARTITION_FLAG, _MEMORY_SIZE, _QUARTER):  # macro
#    return |DRF_DEF(2080,_CTRL_GPU_PARTITION_FLAG,_COMPUTE_SIZE,_MINI_QUARTER))
# def NV2080_CTRL_GPU_PARTITION_FLAG_ONE_EIGHTHED_GPU(DRF_DEF(2080, _CTRL_GPU_PARTITION_FLAG, _MEMORY_SIZE, _EIGHTH):  # macro
#    return |DRF_DEF(2080,_CTRL_GPU_PARTITION_FLAG,_COMPUTE_SIZE,_EIGHTH))
NV2080_CTRL_GPU_SET_PARTITIONS_PARAMS_MESSAGE_ID = (0x74) # macro
NV2080_CTRL_CMD_GPU_SET_PARTITIONS = (0x20800174) # macro
NV2080_CTRL_GPU_GET_PARTITIONS_PARAMS_MESSAGE_ID = (0x75) # macro
NV2080_CTRL_CMD_GPU_GET_PARTITIONS = (0x20800175) # macro
NV2080_CTRL_CMD_GPU_CONFIGURE_PARTITION = (0x20800176) # macro
NV2080_CTRL_GPU_CONFIGURE_PARTITION_PARAMS_MESSAGE_ID = (0x76) # macro
NV2080_CTRL_GPU_FAULT_PACKET_SIZE = 32 # macro
NV2080_CTRL_CMD_GPU_REPORT_NON_REPLAYABLE_FAULT = (0x20800177) # macro
NV2080_CTRL_GPU_REPORT_NON_REPLAYABLE_FAULT_PARAMS_MESSAGE_ID = (0x77) # macro
NV2080_CTRL_CMD_GPU_EXEC_REG_OPS_VGPU = (0x20800178) # macro
NV2080_CTRL_GPU_EXEC_REG_OPS_VGPU_PARAMS_MESSAGE_ID = (0x78) # macro
NV2080_CTRL_CMD_GPU_GET_ENGINE_RUNLIST_PRI_BASE = (0x20800179) # macro
NV2080_CTRL_GPU_GET_ENGINE_RUNLIST_PRI_BASE_PARAMS_MESSAGE_ID = (0x79) # macro
NV2080_CTRL_GPU_GET_ENGINE_RUNLIST_PRI_BASE_NULL = (0xFFFFFFFF) # macro
NV2080_CTRL_GPU_GET_ENGINE_RUNLIST_PRI_BASE_ERROR = (0xFFFFFFFB) # macro
NV2080_CTRL_CMD_GPU_GET_HW_ENGINE_ID = (0x2080017a) # macro
NV2080_CTRL_GPU_GET_HW_ENGINE_ID_PARAMS_MESSAGE_ID = (0x7A) # macro
NV2080_CTRL_GPU_GET_HW_ENGINE_ID_NULL = (0xFFFFFFFF) # macro
NV2080_CTRL_GPU_GET_HW_ENGINE_ID_ERROR = (0xFFFFFFFB) # macro
NV2080_CTRL_GPU_GET_NVFBC_SW_SESSION_STATS = (0x2080017b) # macro
NV2080_CTRL_GPU_GET_NVFBC_SW_SESSION_STATS_PARAMS_MESSAGE_ID = (0x7B) # macro
NV2080_CTRL_NVFBC_SESSION_FLAG_DIFFMAP_ENABLED = 0x00000001 # macro
NV2080_CTRL_NVFBC_SESSION_FLAG_CLASSIFICATIONMAP_ENABLED = 0x00000002 # macro
NV2080_CTRL_NVFBC_SESSION_FLAG_CAPTURE_WITH_WAIT_NO_WAIT = 0x00000004 # macro
NV2080_CTRL_NVFBC_SESSION_FLAG_CAPTURE_WITH_WAIT_INFINITE = 0x00000008 # macro
NV2080_CTRL_NVFBC_SESSION_FLAG_CAPTURE_WITH_WAIT_TIMEOUT = 0x00000010 # macro
NV2080_GPU_NVFBC_MAX_SESSION_COUNT = 256 # macro
NV2080_CTRL_GPU_GET_NVFBC_SW_SESSION_INFO_PARAMS_MESSAGE_ID = (0x7C) # macro
NV2080_CTRL_GPU_GET_NVFBC_SW_SESSION_INFO = (0x2080017c) # macro
NV2080_CTRL_CMD_GPU_GET_VMMU_SEGMENT_SIZE = (0x2080017e) # macro
NV2080_CTRL_GPU_GET_VMMU_SEGMENT_SIZE_PARAMS_MESSAGE_ID = (0x7E) # macro
NV2080_CTRL_GPU_VMMU_SEGMENT_SIZE_32MB = 0x02000000 # macro
NV2080_CTRL_GPU_VMMU_SEGMENT_SIZE_64MB = 0x04000000 # macro
NV2080_CTRL_GPU_VMMU_SEGMENT_SIZE_128MB = 0x08000000 # macro
NV2080_CTRL_GPU_VMMU_SEGMENT_SIZE_256MB = 0x10000000 # macro
NV2080_CTRL_GPU_VMMU_SEGMENT_SIZE_512MB = 0x20000000 # macro
NV2080_CTRL_CMD_GPU_GET_PARTITION_CAPACITY = (0x20800181) # macro
NV2080_CTRL_GPU_GET_PARTITION_CAPACITY_PARAMS_MESSAGE_ID = (0x81) # macro
NV2080_CTRL_CMD_GPU_GET_CACHED_INFO = (0x20800182) # macro
NV2080_CTRL_GPU_GET_CACHED_INFO_PARAMS_MESSAGE_ID = (0x82) # macro
NV2080_CTRL_CMD_GPU_SET_PARTITIONING_MODE = (0x20800183) # macro
NV2080_CTRL_GPU_SET_PARTITIONING_MODE_REPARTITIONING = ['1', ':', '0'] # macro
NV2080_CTRL_GPU_SET_PARTITIONING_MODE_REPARTITIONING_LEGACY = 0 # macro
NV2080_CTRL_GPU_SET_PARTITIONING_MODE_REPARTITIONING_MAX_PERF = 1 # macro
NV2080_CTRL_GPU_SET_PARTITIONING_MODE_REPARTITIONING_FAST_RECONFIG = 2 # macro
NV2080_CTRL_GPU_SET_PARTITIONING_MODE_PARAMS_MESSAGE_ID = (0x83) # macro
NV2080_CTRL_GPU_DESCRIBE_PARTITIONS_PARAMS_MESSAGE_ID = (0x85) # macro
NV2080_CTRL_CMD_GPU_DESCRIBE_PARTITIONS = (0x20800185) # macro
NV2080_CTRL_CMD_GPU_GET_MAX_SUPPORTED_PAGE_SIZE = (0x20800188) # macro
NV2080_CTRL_GPU_GET_MAX_SUPPORTED_PAGE_SIZE_PARAMS_MESSAGE_ID = (0x88) # macro
NV2080_CTRL_GPU_GET_NUM_MMUS_PER_GPC_PARAMS_MESSAGE_ID = (0x8A) # macro
NV2080_CTRL_CMD_GPU_GET_NUM_MMUS_PER_GPC = (0x2080018a) # macro
NV2080_CTRL_GPU_GET_ACTIVE_PARTITION_IDS_PARAMS_MESSAGE_ID = (0x8B) # macro
NV2080_CTRL_CMD_GPU_GET_ACTIVE_PARTITION_IDS = (0x2080018b) # macro
NV2080_CTRL_CMD_GPU_GET_PIDS = (0x2080018d) # macro
NV2080_CTRL_GPU_GET_PIDS_MAX_COUNT = 950 # macro
NV2080_CTRL_GPU_GET_PIDS_PARAMS_MESSAGE_ID = (0x8D) # macro
NV2080_CTRL_GPU_GET_PIDS_ID_TYPE_CLASS = (0x00000000) # macro
NV2080_CTRL_GPU_GET_PIDS_ID_TYPE_VGPU_GUEST = (0x00000001) # macro
NV2080_CTRL_GPU_PID_INFO_INDEX_VIDEO_MEMORY_USAGE = (0x00000000) # macro
NV2080_CTRL_GPU_PID_INFO_INDEX_MAX = (0x00000000) # macro
NV2080_CTRL_CMD_GPU_GET_PID_INFO = (0x2080018e) # macro
NV2080_CTRL_GPU_GET_PID_INFO_MAX_COUNT = 200 # macro
NV2080_CTRL_GPU_GET_PID_INFO_PARAMS_MESSAGE_ID = (0x8E) # macro
NV2080_CTRL_CMD_GPU_HANDLE_VF_PRI_FAULT = (0x20800192) # macro
NV2080_CTRL_CMD_GPU_HANDLE_VF_PRI_FAULT_TYPE_INVALID = 0 # macro
NV2080_CTRL_CMD_GPU_HANDLE_VF_PRI_FAULT_TYPE_BAR1 = 1 # macro
NV2080_CTRL_CMD_GPU_HANDLE_VF_PRI_FAULT_TYPE_BAR2 = 2 # macro
NV2080_CTRL_CMD_GPU_HANDLE_VF_PRI_FAULT_TYPE_PHYSICAL = 3 # macro
NV2080_CTRL_CMD_GPU_HANDLE_VF_PRI_FAULT_TYPE_UNBOUND_INSTANCE = 4 # macro
NV2080_CTRL_CMD_GPU_HANDLE_VF_PRI_FAULT_PARAMS_MESSAGE_ID = (0x92) # macro
NV2080_CTRL_GPU_COMPUTE_POLICY_TIMESLICE = 0 # macro
NV2080_CTRL_GPU_COMPUTE_POLICY_MAX = 1 # macro
NV2080_CTRL_GPU_SET_COMPUTE_POLICY_CONFIG_PARAMS_MESSAGE_ID = (0x94) # macro
NV2080_CTRL_CMD_GPU_GET_COMPUTE_POLICY_CONFIG = (0x20800195) # macro
NV2080_CTRL_GPU_COMPUTE_POLICY_CONFIG_LIST_MAX = 32 # macro
NV2080_CTRL_GPU_GET_COMPUTE_POLICY_CONFIG_PARAMS_MESSAGE_ID = (0x95) # macro
NV2080_CTRL_CMD_GPU_GET_GFID = (0x20800196) # macro
NV2080_CTRL_GPU_GET_GFID_PARAMS_MESSAGE_ID = (0x96) # macro
NV2080_CTRL_CMD_GPU_UPDATE_GFID_P2P_CAPABILITY = (0x20800197) # macro
NV2080_CTRL_CMD_GPU_UPDATE_GFID_P2P_CAPABILITY_PARAMS_MESSAGE_ID = (0x97) # macro
NV2080_CTRL_CMD_GPU_VALIDATE_MEM_MAP_REQUEST = (0x20800198) # macro
NV2080_CTRL_GPU_VALIDATE_MEM_MAP_REQUEST_PARAMS_MESSAGE_ID = (0x98) # macro
NV2080_CTRL_CMD_GPU_SET_EGM_GPA_FABRIC_BASE_ADDR = (0x20800199) # macro
NV2080_CTRL_GPU_SET_EGM_GPA_FABRIC_BASE_ADDR_PARAMS_MESSAGE_ID = (0x99) # macro
NV2080_CTRL_CMD_GPU_GET_ENGINE_LOAD_TIMES = (0x2080019b) # macro
NV2080_CTRL_GPU_MAX_ENGINE_OBJECTS = 0xC8 # macro
NV2080_CTRL_GPU_GET_ENGINE_LOAD_TIMES_PARAMS_MESSAGE_ID = (0x9B) # macro
NV2080_CTRL_CMD_GPU_GET_ID_NAME_MAPPING = (0x2080019c) # macro
NV2080_CTRL_GPU_GET_ID_NAME_MAPPING_PARAMS_MESSAGE_ID = (0x9C) # macro
NV2080_CTRL_CMD_GPU_EXEC_REG_OPS_NOPTRS = (0x2080019d) # macro
NV2080_CTRL_REG_OPS_ARRAY_MAX = 100 # macro
NV2080_CTRL_GPU_EXEC_REG_OPS_NOPTRS_PARAMS_MESSAGE_ID = (0x9D) # macro
NV2080_GET_P2P_CAPS_UUID_LEN = 16 # macro
NV2080_CTRL_CMD_GET_P2P_CAPS = (0x208001a0) # macro
NV2080_CTRL_GET_P2P_CAPS_PARAMS_MESSAGE_ID = (0xA0) # macro
NV2080_CTRL_GPU_GET_COMPUTE_PROFILES_PARAMS_MESSAGE_ID = (0xA2) # macro
NV2080_CTRL_CMD_GPU_GET_COMPUTE_PROFILES = (0x208001a2) # macro
NV2080_CTRL_GPU_FABRIC_PROBE_STATE_UNSUPPORTED = 0 # macro
NV2080_CTRL_GPU_FABRIC_PROBE_STATE_NOT_STARTED = 1 # macro
NV2080_CTRL_GPU_FABRIC_PROBE_STATE_IN_PROGRESS = 2 # macro
NV2080_CTRL_GPU_FABRIC_PROBE_STATE_COMPLETE = 3 # macro
NV2080_GPU_FABRIC_CLUSTER_UUID_LEN = 16 # macro
# NV2080_CTRL_GPU_FABRIC_PROBE_CAP_MC_SUPPORTED = NVBIT64 ( 0 ) # macro
# NV2080_CTRL_GPU_FABRIC_PROBE_CAP_MC_MUTLINODE_SUPPORTED = NVBIT64 ( 1 ) # macro
NV2080_CTRL_GPU_FABRIC_HEALTH_MASK_DEGRADED_BW = ['1', ':', '0'] # macro
NV2080_CTRL_GPU_FABRIC_HEALTH_MASK_DEGRADED_BW_NOT_SUPPORTED = 0 # macro
NV2080_CTRL_GPU_FABRIC_HEALTH_MASK_DEGRADED_BW_TRUE = 1 # macro
NV2080_CTRL_GPU_FABRIC_HEALTH_MASK_DEGRADED_BW_FALSE = 2 # macro
NV2080_CTRL_CMD_GET_GPU_FABRIC_PROBE_INFO_PARAMS_MESSAGE_ID = (0xA3) # macro
NV2080_CTRL_CMD_GET_GPU_FABRIC_PROBE_INFO = (0x208001a3) # macro
NV2080_CTRL_CMD_GPU_GET_CHIP_DETAILS = (0x208001a4) # macro
GPU_PART_NUMBER_FMT = "%04X-%s-%X%X" # macro
NV2080_MAX_CHIP_SKU_LENGTH = 0x00000004 # macro
NV2080_CTRL_GPU_GET_CHIP_DETAILS_PARAMS_MESSAGE_ID = (0xA4) # macro
NV2080_CTRL_CMD_GPU_MOVE_RUNLISTS_ALLOCATION_TO_SUBHEAP = (0x208001a5) # macro
NV2080_CTRL_GPU_MOVE_RUNLISTS_ALLOCATION_TO_SUBHEAP_PARAMS_MESSAGE_ID = (0xA5) # macro
NV2080_CTRL_CMD_GPU_MIGRATABLE_OPS = (0x208001a6) # macro
NV2080_CTRL_CMD_GPU_MIGRATABLE_OPS_GSP = (0x208001a7) # macro
NV2080_CTRL_CMD_GPU_MIGRATABLE_OPS_VGPU = (0x208001a8) # macro
NV2080_CTRL_MIGRATABLE_OPS_ARRAY_MAX = 50 # macro
NV2080_CTRL_GPU_MIGRATABLE_OPS_PARAMS_MESSAGE_ID = (0xA6) # macro
NV2080_CTRL_GPU_MIGRATABLE_OPS_GSP_PARAMS_MESSAGE_ID = (0xA7) # macro
NV2080_CTRL_GPU_MIGRATABLE_OPS_VGPU_PARAMS_MESSAGE_ID = (0xA8) # macro
NV2080_CTRL_CMD_GPU_MARK_DEVICE_FOR_RESET = (0x208001a9) # macro
NV2080_CTRL_CMD_GPU_UNMARK_DEVICE_FOR_RESET = (0x208001aa) # macro
NV2080_CTRL_CMD_GPU_GET_RESET_STATUS = (0x208001ab) # macro
NV2080_CTRL_GPU_GET_RESET_STATUS_PARAMS_MESSAGE_ID = (0xAB) # macro
NV2080_CTRL_CMD_GPU_MARK_DEVICE_FOR_DRAIN_AND_RESET = (0x208001ac) # macro
NV2080_CTRL_CMD_GPU_UNMARK_DEVICE_FOR_DRAIN_AND_RESET = (0x208001ad) # macro
NV2080_CTRL_CMD_GPU_GET_DRAIN_AND_RESET_STATUS = (0x208001ae) # macro
NV2080_CTRL_GPU_GET_DRAIN_AND_RESET_STATUS_PARAMS_MESSAGE_ID = (0xAE) # macro
NV2080_CTRL_GPU_GET_NVENC_SW_SESSION_INFO_V2_PARAMS_MESSAGE_ID = (0xAF) # macro
NV2080_CTRL_GPU_GET_NVENC_SW_SESSION_INFO_V2 = (0x208001af) # macro
NV2080_CTRL_GPU_MAX_CONSTRUCTED_FALCONS = 0x40 # macro
NV2080_CTRL_CMD_GPU_GET_CONSTRUCTED_FALCON_INFO = (0x208001b0) # macro
NV2080_CTRL_GPU_GET_CONSTRUCTED_FALCON_INFO_PARAMS_MESSAGE_ID = (0xB0) # macro
NV2080_CTRL_GPU_GET_FIPS_STATUS_PARAMS_MESSAGE_ID = (0xe4) # macro
NV2080_CTRL_GPU_GET_FIPS_STATUS = (0x208001e4) # macro
NV0000_CTRL_CMD_VGPU_GET_START_DATA = (0xc01) # macro
NV0000_CTRL_VGPU_GET_START_DATA_PARAMS_MESSAGE_ID = (0x1) # macro
class struct_NV0080_CTRL_GR_ROUTE_INFO(Structure):
    pass

struct_NV0080_CTRL_GR_ROUTE_INFO._pack_ = 1 # source:False
struct_NV0080_CTRL_GR_ROUTE_INFO._fields_ = [
    ('flags', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('route', ctypes.c_uint64),
]

NV0080_CTRL_GR_ROUTE_INFO = struct_NV0080_CTRL_GR_ROUTE_INFO
class struct_NV0080_CTRL_GR_GET_CAPS_PARAMS(Structure):
    pass

struct_NV0080_CTRL_GR_GET_CAPS_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_GR_GET_CAPS_PARAMS._fields_ = [
    ('capsTblSize', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('capsTbl', ctypes.POINTER(None)),
]

NV0080_CTRL_GR_GET_CAPS_PARAMS = struct_NV0080_CTRL_GR_GET_CAPS_PARAMS
class struct_NVXXXX_CTRL_XXX_INFO(Structure):
    pass

struct_NVXXXX_CTRL_XXX_INFO._pack_ = 1 # source:False
struct_NVXXXX_CTRL_XXX_INFO._fields_ = [
    ('index', ctypes.c_uint32),
    ('data', ctypes.c_uint32),
]

NV0080_CTRL_GR_INFO = struct_NVXXXX_CTRL_XXX_INFO
class struct_NV0080_CTRL_GR_GET_INFO_PARAMS(Structure):
    pass

struct_NV0080_CTRL_GR_GET_INFO_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_GR_GET_INFO_PARAMS._fields_ = [
    ('grInfoListSize', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('grInfoList', ctypes.POINTER(None)),
]

NV0080_CTRL_GR_GET_INFO_PARAMS = struct_NV0080_CTRL_GR_GET_INFO_PARAMS

# values for enumeration 'NV0080_CTRL_GR_TPC_PARTITION_MODE'
NV0080_CTRL_GR_TPC_PARTITION_MODE__enumvalues = {
    0: 'NV0080_CTRL_GR_TPC_PARTITION_MODE_NONE',
    1: 'NV0080_CTRL_GR_TPC_PARTITION_MODE_STATIC',
    2: 'NV0080_CTRL_GR_TPC_PARTITION_MODE_DYNAMIC',
}
NV0080_CTRL_GR_TPC_PARTITION_MODE_NONE = 0
NV0080_CTRL_GR_TPC_PARTITION_MODE_STATIC = 1
NV0080_CTRL_GR_TPC_PARTITION_MODE_DYNAMIC = 2
NV0080_CTRL_GR_TPC_PARTITION_MODE = ctypes.c_uint32 # enum
class struct_NV0080_CTRL_GR_TPC_PARTITION_MODE_PARAMS(Structure):
    pass

struct_NV0080_CTRL_GR_TPC_PARTITION_MODE_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_GR_TPC_PARTITION_MODE_PARAMS._fields_ = [
    ('hChannelGroup', ctypes.c_uint32),
    ('mode', NV0080_CTRL_GR_TPC_PARTITION_MODE),
    ('bEnableAllTpcs', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 7),
    ('grRouteInfo', NV0080_CTRL_GR_ROUTE_INFO),
]

NV0080_CTRL_GR_TPC_PARTITION_MODE_PARAMS = struct_NV0080_CTRL_GR_TPC_PARTITION_MODE_PARAMS
NV0080_CTRL_GR_GET_TPC_PARTITION_MODE_PARAMS = struct_NV0080_CTRL_GR_TPC_PARTITION_MODE_PARAMS
NV0080_CTRL_GR_SET_TPC_PARTITION_MODE_PARAMS = struct_NV0080_CTRL_GR_TPC_PARTITION_MODE_PARAMS
class struct_NV0080_CTRL_GR_GET_CAPS_V2_PARAMS(Structure):
    pass

struct_NV0080_CTRL_GR_GET_CAPS_V2_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_GR_GET_CAPS_V2_PARAMS._fields_ = [
    ('capsTbl', ctypes.c_ubyte * 23),
    ('PADDING_0', ctypes.c_ubyte),
    ('grRouteInfo', NV0080_CTRL_GR_ROUTE_INFO),
    ('bCapsPopulated', ctypes.c_ubyte),
    ('PADDING_1', ctypes.c_ubyte * 7),
]

NV0080_CTRL_GR_GET_CAPS_V2_PARAMS = struct_NV0080_CTRL_GR_GET_CAPS_V2_PARAMS
class struct_NV0080_CTRL_GR_GET_INFO_V2_PARAMS(Structure):
    pass

struct_NV0080_CTRL_GR_GET_INFO_V2_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_GR_GET_INFO_V2_PARAMS._fields_ = [
    ('grInfoListSize', ctypes.c_uint32),
    ('grInfoList', struct_NVXXXX_CTRL_XXX_INFO * 56),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('grRouteInfo', NV0080_CTRL_GR_ROUTE_INFO),
]

NV0080_CTRL_GR_GET_INFO_V2_PARAMS = struct_NV0080_CTRL_GR_GET_INFO_V2_PARAMS
NV2080_CTRL_GR_ROUTE_INFO = struct_NV0080_CTRL_GR_ROUTE_INFO
NV2080_CTRL_GR_INFO = struct_NVXXXX_CTRL_XXX_INFO
class struct_NV2080_CTRL_GR_GET_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_GET_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GET_INFO_PARAMS._fields_ = [
    ('grInfoListSize', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('grInfoList', ctypes.POINTER(None)),
    ('grRouteInfo', NV2080_CTRL_GR_ROUTE_INFO),
]

NV2080_CTRL_GR_GET_INFO_PARAMS = struct_NV2080_CTRL_GR_GET_INFO_PARAMS
class struct_NV2080_CTRL_GR_CTXSW_ZCULL_MODE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_CTXSW_ZCULL_MODE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_CTXSW_ZCULL_MODE_PARAMS._fields_ = [
    ('hChannel', ctypes.c_uint32),
    ('hShareClient', ctypes.c_uint32),
    ('hShareChannel', ctypes.c_uint32),
    ('zcullMode', ctypes.c_uint32),
]

NV2080_CTRL_GR_CTXSW_ZCULL_MODE_PARAMS = struct_NV2080_CTRL_GR_CTXSW_ZCULL_MODE_PARAMS
class struct_NV2080_CTRL_GR_GET_ZCULL_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_GET_ZCULL_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GET_ZCULL_INFO_PARAMS._fields_ = [
    ('widthAlignPixels', ctypes.c_uint32),
    ('heightAlignPixels', ctypes.c_uint32),
    ('pixelSquaresByAliquots', ctypes.c_uint32),
    ('aliquotTotal', ctypes.c_uint32),
    ('zcullRegionByteMultiplier', ctypes.c_uint32),
    ('zcullRegionHeaderSize', ctypes.c_uint32),
    ('zcullSubregionHeaderSize', ctypes.c_uint32),
    ('subregionCount', ctypes.c_uint32),
    ('subregionWidthAlignPixels', ctypes.c_uint32),
    ('subregionHeightAlignPixels', ctypes.c_uint32),
]

NV2080_CTRL_GR_GET_ZCULL_INFO_PARAMS = struct_NV2080_CTRL_GR_GET_ZCULL_INFO_PARAMS
class struct_NV2080_CTRL_GR_CTXSW_PM_MODE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_CTXSW_PM_MODE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_CTXSW_PM_MODE_PARAMS._fields_ = [
    ('hChannel', ctypes.c_uint32),
    ('pmMode', ctypes.c_uint32),
    ('grRouteInfo', NV2080_CTRL_GR_ROUTE_INFO),
]

NV2080_CTRL_GR_CTXSW_PM_MODE_PARAMS = struct_NV2080_CTRL_GR_CTXSW_PM_MODE_PARAMS
class struct_NV2080_CTRL_GR_CTXSW_ZCULL_BIND_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_CTXSW_ZCULL_BIND_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_CTXSW_ZCULL_BIND_PARAMS._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hChannel', ctypes.c_uint32),
    ('vMemPtr', ctypes.c_uint64),
    ('zcullMode', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NV2080_CTRL_GR_CTXSW_ZCULL_BIND_PARAMS = struct_NV2080_CTRL_GR_CTXSW_ZCULL_BIND_PARAMS
class struct_NV2080_CTRL_GR_CTXSW_PM_BIND_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_CTXSW_PM_BIND_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_CTXSW_PM_BIND_PARAMS._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hChannel', ctypes.c_uint32),
    ('vMemPtr', ctypes.c_uint64),
    ('pmMode', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('grRouteInfo', NV2080_CTRL_GR_ROUTE_INFO),
]

NV2080_CTRL_GR_CTXSW_PM_BIND_PARAMS = struct_NV2080_CTRL_GR_CTXSW_PM_BIND_PARAMS
class struct_NV2080_CTRL_GR_CTXSW_SETUP_BIND_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_CTXSW_SETUP_BIND_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_CTXSW_SETUP_BIND_PARAMS._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hChannel', ctypes.c_uint32),
    ('vMemPtr', ctypes.c_uint64),
]

NV2080_CTRL_GR_CTXSW_SETUP_BIND_PARAMS = struct_NV2080_CTRL_GR_CTXSW_SETUP_BIND_PARAMS
class struct_NV2080_CTRL_GR_SET_GPC_TILE_MAP_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_SET_GPC_TILE_MAP_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_SET_GPC_TILE_MAP_PARAMS._fields_ = [
    ('mapValueCount', ctypes.c_uint32),
    ('mapValues', ctypes.c_ubyte * 128),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('grRouteInfo', NV2080_CTRL_GR_ROUTE_INFO),
]

NV2080_CTRL_GR_SET_GPC_TILE_MAP_PARAMS = struct_NV2080_CTRL_GR_SET_GPC_TILE_MAP_PARAMS
class struct_NV2080_CTRL_GR_CTXSW_SMPC_MODE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_CTXSW_SMPC_MODE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_CTXSW_SMPC_MODE_PARAMS._fields_ = [
    ('hChannel', ctypes.c_uint32),
    ('smpcMode', ctypes.c_uint32),
    ('grRouteInfo', NV2080_CTRL_GR_ROUTE_INFO),
]

NV2080_CTRL_GR_CTXSW_SMPC_MODE_PARAMS = struct_NV2080_CTRL_GR_CTXSW_SMPC_MODE_PARAMS
class struct_NV2080_CTRL_GR_GET_SM_TO_GPC_TPC_MAPPINGS_PARAMS(Structure):
    pass

class struct_NV2080_CTRL_GR_GET_SM_TO_GPC_TPC_MAPPINGS_PARAMS_0(Structure):
    pass

struct_NV2080_CTRL_GR_GET_SM_TO_GPC_TPC_MAPPINGS_PARAMS_0._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GET_SM_TO_GPC_TPC_MAPPINGS_PARAMS_0._fields_ = [
    ('gpcId', ctypes.c_uint32),
    ('tpcId', ctypes.c_uint32),
]

struct_NV2080_CTRL_GR_GET_SM_TO_GPC_TPC_MAPPINGS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GET_SM_TO_GPC_TPC_MAPPINGS_PARAMS._fields_ = [
    ('smId', struct_NV2080_CTRL_GR_GET_SM_TO_GPC_TPC_MAPPINGS_PARAMS_0 * 144),
    ('smCount', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('grRouteInfo', NV2080_CTRL_GR_ROUTE_INFO),
]

NV2080_CTRL_GR_GET_SM_TO_GPC_TPC_MAPPINGS_PARAMS = struct_NV2080_CTRL_GR_GET_SM_TO_GPC_TPC_MAPPINGS_PARAMS
class struct_NV2080_CTRL_GR_SET_CTXSW_PREEMPTION_MODE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_SET_CTXSW_PREEMPTION_MODE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_SET_CTXSW_PREEMPTION_MODE_PARAMS._fields_ = [
    ('flags', ctypes.c_uint32),
    ('hChannel', ctypes.c_uint32),
    ('gfxpPreemptMode', ctypes.c_uint32),
    ('cilpPreemptMode', ctypes.c_uint32),
    ('grRouteInfo', NV2080_CTRL_GR_ROUTE_INFO),
]

NV2080_CTRL_GR_SET_CTXSW_PREEMPTION_MODE_PARAMS = struct_NV2080_CTRL_GR_SET_CTXSW_PREEMPTION_MODE_PARAMS

# values for enumeration 'NV2080_CTRL_CMD_GR_CTXSW_PREEMPTION_BIND_BUFFERS'
NV2080_CTRL_CMD_GR_CTXSW_PREEMPTION_BIND_BUFFERS__enumvalues = {
    0: 'NV2080_CTRL_CMD_GR_CTXSW_PREEMPTION_BIND_BUFFERS_MAIN',
    1: 'NV2080_CTRL_CMD_GR_CTXSW_PREEMPTION_BIND_BUFFERS_SPILL',
    2: 'NV2080_CTRL_CMD_GR_CTXSW_PREEMPTION_BIND_BUFFERS_PAGEPOOL',
    3: 'NV2080_CTRL_CMD_GR_CTXSW_PREEMPTION_BIND_BUFFERS_BETACB',
    4: 'NV2080_CTRL_CMD_GR_CTXSW_PREEMPTION_BIND_BUFFERS_RTV',
    5: 'NV2080_CTRL_CMD_GR_CTXSW_PREEMPTION_BIND_BUFFERS_CONTEXT_POOL',
    6: 'NV2080_CTRL_CMD_GR_CTXSW_PREEMPTION_BIND_BUFFERS_CONTEXT_POOL_CONTROL',
    7: 'NV2080_CTRL_CMD_GR_CTXSW_PREEMPTION_BIND_BUFFERS_CONTEXT_POOL_CONTROL_CPU',
    8: 'NV2080_CTRL_CMD_GR_CTXSW_PREEMPTION_BIND_BUFFERS_END',
}
NV2080_CTRL_CMD_GR_CTXSW_PREEMPTION_BIND_BUFFERS_MAIN = 0
NV2080_CTRL_CMD_GR_CTXSW_PREEMPTION_BIND_BUFFERS_SPILL = 1
NV2080_CTRL_CMD_GR_CTXSW_PREEMPTION_BIND_BUFFERS_PAGEPOOL = 2
NV2080_CTRL_CMD_GR_CTXSW_PREEMPTION_BIND_BUFFERS_BETACB = 3
NV2080_CTRL_CMD_GR_CTXSW_PREEMPTION_BIND_BUFFERS_RTV = 4
NV2080_CTRL_CMD_GR_CTXSW_PREEMPTION_BIND_BUFFERS_CONTEXT_POOL = 5
NV2080_CTRL_CMD_GR_CTXSW_PREEMPTION_BIND_BUFFERS_CONTEXT_POOL_CONTROL = 6
NV2080_CTRL_CMD_GR_CTXSW_PREEMPTION_BIND_BUFFERS_CONTEXT_POOL_CONTROL_CPU = 7
NV2080_CTRL_CMD_GR_CTXSW_PREEMPTION_BIND_BUFFERS_END = 8
NV2080_CTRL_CMD_GR_CTXSW_PREEMPTION_BIND_BUFFERS = ctypes.c_uint32 # enum
class struct_NV2080_CTRL_GR_CTXSW_PREEMPTION_BIND_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_CTXSW_PREEMPTION_BIND_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_CTXSW_PREEMPTION_BIND_PARAMS._fields_ = [
    ('flags', ctypes.c_uint32),
    ('hClient', ctypes.c_uint32),
    ('hChannel', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('vMemPtrs', ctypes.c_uint64 * 8),
    ('gfxpPreemptMode', ctypes.c_uint32),
    ('cilpPreemptMode', ctypes.c_uint32),
    ('grRouteInfo', NV2080_CTRL_GR_ROUTE_INFO),
]

NV2080_CTRL_GR_CTXSW_PREEMPTION_BIND_PARAMS = struct_NV2080_CTRL_GR_CTXSW_PREEMPTION_BIND_PARAMS
class struct_NV2080_CTRL_GR_PC_SAMPLING_MODE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_PC_SAMPLING_MODE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_PC_SAMPLING_MODE_PARAMS._fields_ = [
    ('hChannel', ctypes.c_uint32),
    ('samplingMode', ctypes.c_uint32),
    ('grRouteInfo', NV2080_CTRL_GR_ROUTE_INFO),
]

NV2080_CTRL_GR_PC_SAMPLING_MODE_PARAMS = struct_NV2080_CTRL_GR_PC_SAMPLING_MODE_PARAMS
class struct_NV2080_CTRL_GR_GET_ROP_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_GET_ROP_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GET_ROP_INFO_PARAMS._fields_ = [
    ('ropUnitCount', ctypes.c_uint32),
    ('ropOperationsFactor', ctypes.c_uint32),
    ('ropOperationsCount', ctypes.c_uint32),
]

NV2080_CTRL_GR_GET_ROP_INFO_PARAMS = struct_NV2080_CTRL_GR_GET_ROP_INFO_PARAMS
class struct_NV2080_CTRL_GR_GET_CTXSW_STATS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_GET_CTXSW_STATS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GET_CTXSW_STATS_PARAMS._fields_ = [
    ('hChannel', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('saveCnt', ctypes.c_uint32),
    ('restoreCnt', ctypes.c_uint32),
    ('wfiSaveCnt', ctypes.c_uint32),
    ('ctaSaveCnt', ctypes.c_uint32),
    ('cilpSaveCnt', ctypes.c_uint32),
    ('gfxpSaveCnt', ctypes.c_uint32),
]

NV2080_CTRL_GR_GET_CTXSW_STATS_PARAMS = struct_NV2080_CTRL_GR_GET_CTXSW_STATS_PARAMS
class struct_NV2080_CTRL_GR_GET_CTX_BUFFER_SIZE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_GET_CTX_BUFFER_SIZE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GET_CTX_BUFFER_SIZE_PARAMS._fields_ = [
    ('hChannel', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('totalBufferSize', ctypes.c_uint64),
]

NV2080_CTRL_GR_GET_CTX_BUFFER_SIZE_PARAMS = struct_NV2080_CTRL_GR_GET_CTX_BUFFER_SIZE_PARAMS
class struct_NV2080_CTRL_GR_CTX_BUFFER_INFO(Structure):
    pass

struct_NV2080_CTRL_GR_CTX_BUFFER_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_CTX_BUFFER_INFO._fields_ = [
    ('alignment', ctypes.c_uint64),
    ('size', ctypes.c_uint64),
    ('bufferHandle', ctypes.POINTER(None)),
    ('pageCount', ctypes.c_uint64),
    ('physAddr', ctypes.c_uint64),
    ('bufferType', ctypes.c_uint32),
    ('aperture', ctypes.c_uint32),
    ('kind', ctypes.c_uint32),
    ('pageSize', ctypes.c_uint32),
    ('bIsContigous', ctypes.c_ubyte),
    ('bGlobalBuffer', ctypes.c_ubyte),
    ('bLocalBuffer', ctypes.c_ubyte),
    ('bDeviceDescendant', ctypes.c_ubyte),
    ('uuid', ctypes.c_ubyte * 16),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NV2080_CTRL_GR_CTX_BUFFER_INFO = struct_NV2080_CTRL_GR_CTX_BUFFER_INFO
PNV2080_CTRL_GR_CTX_BUFFER_INFO = ctypes.POINTER(struct_NV2080_CTRL_GR_CTX_BUFFER_INFO)
class struct_NV2080_CTRL_GR_GET_CTX_BUFFER_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_GET_CTX_BUFFER_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GET_CTX_BUFFER_INFO_PARAMS._fields_ = [
    ('hUserClient', ctypes.c_uint32),
    ('hChannel', ctypes.c_uint32),
    ('bufferCount', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('ctxBufferInfo', struct_NV2080_CTRL_GR_CTX_BUFFER_INFO * 64),
]

NV2080_CTRL_GR_GET_CTX_BUFFER_INFO_PARAMS = struct_NV2080_CTRL_GR_GET_CTX_BUFFER_INFO_PARAMS
class struct_NV2080_CTRL_GR_GET_GLOBAL_SM_ORDER_PARAMS(Structure):
    pass

class struct_NV2080_CTRL_GR_GET_GLOBAL_SM_ORDER_PARAMS_0(Structure):
    pass

struct_NV2080_CTRL_GR_GET_GLOBAL_SM_ORDER_PARAMS_0._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GET_GLOBAL_SM_ORDER_PARAMS_0._fields_ = [
    ('gpcId', ctypes.c_uint16),
    ('localTpcId', ctypes.c_uint16),
    ('localSmId', ctypes.c_uint16),
    ('globalTpcId', ctypes.c_uint16),
    ('virtualGpcId', ctypes.c_uint16),
    ('migratableTpcId', ctypes.c_uint16),
]

struct_NV2080_CTRL_GR_GET_GLOBAL_SM_ORDER_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GET_GLOBAL_SM_ORDER_PARAMS._fields_ = [
    ('globalSmId', struct_NV2080_CTRL_GR_GET_GLOBAL_SM_ORDER_PARAMS_0 * 512),
    ('numSm', ctypes.c_uint16),
    ('numTpc', ctypes.c_uint16),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('grRouteInfo', NV2080_CTRL_GR_ROUTE_INFO),
]

NV2080_CTRL_GR_GET_GLOBAL_SM_ORDER_PARAMS = struct_NV2080_CTRL_GR_GET_GLOBAL_SM_ORDER_PARAMS
class struct_NV2080_CTRL_GR_GET_CURRENT_RESIDENT_CHANNEL_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_GET_CURRENT_RESIDENT_CHANNEL_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GET_CURRENT_RESIDENT_CHANNEL_PARAMS._fields_ = [
    ('chID', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('grRouteInfo', NV2080_CTRL_GR_ROUTE_INFO),
]

NV2080_CTRL_GR_GET_CURRENT_RESIDENT_CHANNEL_PARAMS = struct_NV2080_CTRL_GR_GET_CURRENT_RESIDENT_CHANNEL_PARAMS
class struct_NV2080_CTRL_GR_VAT_ALARM_DATA_PER_TPC(Structure):
    pass

struct_NV2080_CTRL_GR_VAT_ALARM_DATA_PER_TPC._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_VAT_ALARM_DATA_PER_TPC._fields_ = [
    ('errorCounter', ctypes.c_uint64),
    ('errorTimestamp', ctypes.c_uint64),
    ('warningCounter', ctypes.c_uint64),
    ('warningTimestamp', ctypes.c_uint64),
]

NV2080_CTRL_GR_VAT_ALARM_DATA_PER_TPC = struct_NV2080_CTRL_GR_VAT_ALARM_DATA_PER_TPC
class struct_NV2080_CTRL_GR_VAT_ALARM_DATA_PER_GPC(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('tpc', struct_NV2080_CTRL_GR_VAT_ALARM_DATA_PER_TPC * 10),
     ]

NV2080_CTRL_GR_VAT_ALARM_DATA_PER_GPC = struct_NV2080_CTRL_GR_VAT_ALARM_DATA_PER_GPC
class struct_NV2080_CTRL_GR_VAT_ALARM_DATA(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('gpc', struct_NV2080_CTRL_GR_VAT_ALARM_DATA_PER_GPC * 10),
     ]

NV2080_CTRL_GR_VAT_ALARM_DATA = struct_NV2080_CTRL_GR_VAT_ALARM_DATA
class struct_NV2080_CTRL_GR_GET_VAT_ALARM_DATA_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_GET_VAT_ALARM_DATA_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GET_VAT_ALARM_DATA_PARAMS._fields_ = [
    ('smVatAlarm', NV2080_CTRL_GR_VAT_ALARM_DATA),
    ('maxGpcCount', ctypes.c_uint32),
    ('maxTpcPerGpcCount', ctypes.c_uint32),
]

NV2080_CTRL_GR_GET_VAT_ALARM_DATA_PARAMS = struct_NV2080_CTRL_GR_GET_VAT_ALARM_DATA_PARAMS
PNV2080_CTRL_GR_GET_VAT_ALARM_DATA_PARAMS = ctypes.POINTER(struct_NV2080_CTRL_GR_GET_VAT_ALARM_DATA_PARAMS)
class struct_NV2080_CTRL_GR_GET_ATTRIBUTE_BUFFER_SIZE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_GET_ATTRIBUTE_BUFFER_SIZE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GET_ATTRIBUTE_BUFFER_SIZE_PARAMS._fields_ = [
    ('attribBufferSize', ctypes.c_uint32),
]

NV2080_CTRL_GR_GET_ATTRIBUTE_BUFFER_SIZE_PARAMS = struct_NV2080_CTRL_GR_GET_ATTRIBUTE_BUFFER_SIZE_PARAMS
class struct_NV2080_CTRL_GR_GFX_POOL_QUERY_SIZE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_GFX_POOL_QUERY_SIZE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GFX_POOL_QUERY_SIZE_PARAMS._fields_ = [
    ('maxSlots', ctypes.c_uint32),
    ('slotStride', ctypes.c_uint32),
    ('ctrlStructSize', ctypes.c_uint64),
    ('ctrlStructAlign', ctypes.c_uint64),
    ('poolSize', ctypes.c_uint64),
    ('poolAlign', ctypes.c_uint64),
]

NV2080_CTRL_GR_GFX_POOL_QUERY_SIZE_PARAMS = struct_NV2080_CTRL_GR_GFX_POOL_QUERY_SIZE_PARAMS
class struct_NV2080_CTRL_GR_GFX_POOL_INITIALIZE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_GFX_POOL_INITIALIZE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GFX_POOL_INITIALIZE_PARAMS._fields_ = [
    ('maxSlots', ctypes.c_uint32),
    ('hMemory', ctypes.c_uint32),
    ('offset', ctypes.c_uint32),
    ('size', ctypes.c_uint32),
]

NV2080_CTRL_GR_GFX_POOL_INITIALIZE_PARAMS = struct_NV2080_CTRL_GR_GFX_POOL_INITIALIZE_PARAMS
class struct_NV2080_CTRL_GR_GFX_POOL_ADD_SLOTS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_GFX_POOL_ADD_SLOTS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GFX_POOL_ADD_SLOTS_PARAMS._fields_ = [
    ('numSlots', ctypes.c_uint32),
    ('slots', ctypes.c_uint32 * 64),
    ('hMemory', ctypes.c_uint32),
    ('offset', ctypes.c_uint32),
    ('size', ctypes.c_uint32),
]

NV2080_CTRL_GR_GFX_POOL_ADD_SLOTS_PARAMS = struct_NV2080_CTRL_GR_GFX_POOL_ADD_SLOTS_PARAMS
class struct_NV2080_CTRL_GR_GFX_POOL_REMOVE_SLOTS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_GFX_POOL_REMOVE_SLOTS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GFX_POOL_REMOVE_SLOTS_PARAMS._fields_ = [
    ('numSlots', ctypes.c_uint32),
    ('slots', ctypes.c_uint32 * 64),
    ('bRemoveSpecificSlots', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('hMemory', ctypes.c_uint32),
    ('offset', ctypes.c_uint32),
    ('size', ctypes.c_uint32),
]

NV2080_CTRL_GR_GFX_POOL_REMOVE_SLOTS_PARAMS = struct_NV2080_CTRL_GR_GFX_POOL_REMOVE_SLOTS_PARAMS
NV2080_CTRL_GR_GET_CAPS_V2_PARAMS = struct_NV0080_CTRL_GR_GET_CAPS_V2_PARAMS
NV2080_CTRL_GR_GET_INFO_V2_PARAMS = struct_NV0080_CTRL_GR_GET_INFO_V2_PARAMS
class struct_NV2080_CTRL_GR_GET_GPC_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_GET_GPC_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GET_GPC_MASK_PARAMS._fields_ = [
    ('grRouteInfo', NV2080_CTRL_GR_ROUTE_INFO),
    ('gpcMask', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NV2080_CTRL_GR_GET_GPC_MASK_PARAMS = struct_NV2080_CTRL_GR_GET_GPC_MASK_PARAMS
class struct_NV2080_CTRL_GR_GET_TPC_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_GET_TPC_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GET_TPC_MASK_PARAMS._fields_ = [
    ('grRouteInfo', NV2080_CTRL_GR_ROUTE_INFO),
    ('gpcId', ctypes.c_uint32),
    ('tpcMask', ctypes.c_uint32),
]

NV2080_CTRL_GR_GET_TPC_MASK_PARAMS = struct_NV2080_CTRL_GR_GET_TPC_MASK_PARAMS
NV2080_CTRL_GR_SET_TPC_PARTITION_MODE_PARAMS = struct_NV0080_CTRL_GR_TPC_PARTITION_MODE_PARAMS
class struct_NV2080_CTRL_GR_GET_ENGINE_CONTEXT_PROPERTIES_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_GET_ENGINE_CONTEXT_PROPERTIES_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GET_ENGINE_CONTEXT_PROPERTIES_PARAMS._fields_ = [
    ('grRouteInfo', NV2080_CTRL_GR_ROUTE_INFO),
    ('engineId', ctypes.c_uint32),
    ('alignment', ctypes.c_uint32),
    ('size', ctypes.c_uint32),
    ('bInfoPopulated', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_GR_GET_ENGINE_CONTEXT_PROPERTIES_PARAMS = struct_NV2080_CTRL_GR_GET_ENGINE_CONTEXT_PROPERTIES_PARAMS
class struct_NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_PARAMS._fields_ = [
    ('grRouteInfo', NV2080_CTRL_GR_ROUTE_INFO),
    ('imla0', ctypes.c_ubyte),
    ('fmla16', ctypes.c_ubyte),
    ('dp', ctypes.c_ubyte),
    ('fmla32', ctypes.c_ubyte),
    ('ffma', ctypes.c_ubyte),
    ('imla1', ctypes.c_ubyte),
    ('imla2', ctypes.c_ubyte),
    ('imla3', ctypes.c_ubyte),
    ('imla4', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 7),
]

NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_PARAMS = struct_NV2080_CTRL_GR_GET_SM_ISSUE_RATE_MODIFIER_PARAMS

# values for enumeration 'NV2080_CTRL_GR_FECS_BIND_EVTBUF_LOD'
NV2080_CTRL_GR_FECS_BIND_EVTBUF_LOD__enumvalues = {
    0: 'NV2080_CTRL_GR_FECS_BIND_EVTBUF_LOD_FULL',
    1: 'NV2080_CTRL_GR_FECS_BIND_EVTBUF_LOD_SIMPLE',
    2: 'NV2080_CTRL_GR_FECS_BIND_EVTBUF_LOD_COMPAT',
    3: 'NV2080_CTRL_GR_FECS_BIND_EVTBUF_LOD_CUSTOM',
}
NV2080_CTRL_GR_FECS_BIND_EVTBUF_LOD_FULL = 0
NV2080_CTRL_GR_FECS_BIND_EVTBUF_LOD_SIMPLE = 1
NV2080_CTRL_GR_FECS_BIND_EVTBUF_LOD_COMPAT = 2
NV2080_CTRL_GR_FECS_BIND_EVTBUF_LOD_CUSTOM = 3
NV2080_CTRL_GR_FECS_BIND_EVTBUF_LOD = ctypes.c_uint32 # enum
class struct_NV2080_CTRL_GR_FECS_BIND_EVTBUF_FOR_UID_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_FECS_BIND_EVTBUF_FOR_UID_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_FECS_BIND_EVTBUF_FOR_UID_PARAMS._fields_ = [
    ('hEventBuffer', ctypes.c_uint32),
    ('recordSize', ctypes.c_uint32),
    ('levelOfDetail', NV2080_CTRL_GR_FECS_BIND_EVTBUF_LOD),
    ('eventFilter', ctypes.c_uint32),
    ('bAllUsers', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_GR_FECS_BIND_EVTBUF_FOR_UID_PARAMS = struct_NV2080_CTRL_GR_FECS_BIND_EVTBUF_FOR_UID_PARAMS
class struct_NV2080_CTRL_GR_GET_PHYS_GPC_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_GET_PHYS_GPC_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GET_PHYS_GPC_MASK_PARAMS._fields_ = [
    ('physSyspipeId', ctypes.c_uint32),
    ('gpcMask', ctypes.c_uint32),
]

NV2080_CTRL_GR_GET_PHYS_GPC_MASK_PARAMS = struct_NV2080_CTRL_GR_GET_PHYS_GPC_MASK_PARAMS
class struct_NV2080_CTRL_GR_GET_PPC_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_GET_PPC_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GET_PPC_MASK_PARAMS._fields_ = [
    ('grRouteInfo', NV2080_CTRL_GR_ROUTE_INFO),
    ('gpcId', ctypes.c_uint32),
    ('ppcMask', ctypes.c_uint32),
]

NV2080_CTRL_GR_GET_PPC_MASK_PARAMS = struct_NV2080_CTRL_GR_GET_PPC_MASK_PARAMS
class struct_NV2080_CTRL_GR_GET_NUM_TPCS_FOR_GPC_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_GET_NUM_TPCS_FOR_GPC_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GET_NUM_TPCS_FOR_GPC_PARAMS._fields_ = [
    ('gpcId', ctypes.c_uint32),
    ('numTpcs', ctypes.c_uint32),
]

NV2080_CTRL_GR_GET_NUM_TPCS_FOR_GPC_PARAMS = struct_NV2080_CTRL_GR_GET_NUM_TPCS_FOR_GPC_PARAMS
class struct_NV2080_CTRL_GR_GET_CTXSW_MODES_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_GET_CTXSW_MODES_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GET_CTXSW_MODES_PARAMS._fields_ = [
    ('hChannel', ctypes.c_uint32),
    ('zcullMode', ctypes.c_uint32),
    ('pmMode', ctypes.c_uint32),
    ('smpcMode', ctypes.c_uint32),
    ('cilpPreemptMode', ctypes.c_uint32),
    ('gfxpPreemptMode', ctypes.c_uint32),
]

NV2080_CTRL_GR_GET_CTXSW_MODES_PARAMS = struct_NV2080_CTRL_GR_GET_CTXSW_MODES_PARAMS
NV2080_CTRL_GR_GET_GPC_TILE_MAP_PARAMS = struct_NV2080_CTRL_GR_SET_GPC_TILE_MAP_PARAMS
class struct_NV2080_CTRL_GR_GET_ZCULL_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_GET_ZCULL_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GET_ZCULL_MASK_PARAMS._fields_ = [
    ('gpcId', ctypes.c_uint32),
    ('zcullMask', ctypes.c_uint32),
]

NV2080_CTRL_GR_GET_ZCULL_MASK_PARAMS = struct_NV2080_CTRL_GR_GET_ZCULL_MASK_PARAMS

# values for enumeration 'NV2080_CTRL_GR_FECS_BIND_EVTBUF_REASON_CODE'
NV2080_CTRL_GR_FECS_BIND_EVTBUF_REASON_CODE__enumvalues = {
    0: 'NV2080_CTRL_GR_FECS_BIND_REASON_CODE_NONE',
    1: 'NV2080_CTRL_GR_FECS_BIND_REASON_CODE_GPU_TOO_OLD',
    2: 'NV2080_CTRL_GR_FECS_BIND_REASON_CODE_NOT_ENABLED_GPU',
    3: 'NV2080_CTRL_GR_FECS_BIND_REASON_CODE_NOT_ENABLED',
    4: 'NV2080_CTRL_GR_FECS_BIND_REASON_CODE_NEED_ADMIN',
    5: 'NV2080_CTRL_GR_FECS_BIND_REASON_CODE_NEED_CAPABILITY',
}
NV2080_CTRL_GR_FECS_BIND_REASON_CODE_NONE = 0
NV2080_CTRL_GR_FECS_BIND_REASON_CODE_GPU_TOO_OLD = 1
NV2080_CTRL_GR_FECS_BIND_REASON_CODE_NOT_ENABLED_GPU = 2
NV2080_CTRL_GR_FECS_BIND_REASON_CODE_NOT_ENABLED = 3
NV2080_CTRL_GR_FECS_BIND_REASON_CODE_NEED_ADMIN = 4
NV2080_CTRL_GR_FECS_BIND_REASON_CODE_NEED_CAPABILITY = 5
NV2080_CTRL_GR_FECS_BIND_EVTBUF_REASON_CODE = ctypes.c_uint32 # enum
class struct_NV2080_CTRL_GR_FECS_BIND_EVTBUF_FOR_UID_V2_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_FECS_BIND_EVTBUF_FOR_UID_V2_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_FECS_BIND_EVTBUF_FOR_UID_V2_PARAMS._fields_ = [
    ('hEventBuffer', ctypes.c_uint32),
    ('recordSize', ctypes.c_uint32),
    ('levelOfDetail', NV2080_CTRL_GR_FECS_BIND_EVTBUF_LOD),
    ('eventFilter', ctypes.c_uint32),
    ('bAllUsers', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('reasonCode', ctypes.c_uint32),
]

NV2080_CTRL_GR_FECS_BIND_EVTBUF_FOR_UID_V2_PARAMS = struct_NV2080_CTRL_GR_FECS_BIND_EVTBUF_FOR_UID_V2_PARAMS
class struct_NV2080_CTRL_GR_GET_GFX_GPC_AND_TPC_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GR_GET_GFX_GPC_AND_TPC_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GR_GET_GFX_GPC_AND_TPC_INFO_PARAMS._fields_ = [
    ('grRouteInfo', NV2080_CTRL_GR_ROUTE_INFO),
    ('physGfxGpcMask', ctypes.c_uint32),
    ('numGfxTpc', ctypes.c_uint32),
]

NV2080_CTRL_GR_GET_GFX_GPC_AND_TPC_INFO_PARAMS = struct_NV2080_CTRL_GR_GET_GFX_GPC_AND_TPC_INFO_PARAMS
NV2080_CTRL_GPU_INFO = struct_NVXXXX_CTRL_XXX_INFO
class struct_NV2080_CTRL_GPU_GET_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_INFO_PARAMS._fields_ = [
    ('gpuInfoListSize', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('gpuInfoList', ctypes.POINTER(None)),
]

NV2080_CTRL_GPU_GET_INFO_PARAMS = struct_NV2080_CTRL_GPU_GET_INFO_PARAMS
class struct_NV2080_CTRL_GPU_GET_INFO_V2_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_INFO_V2_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_INFO_V2_PARAMS._fields_ = [
    ('gpuInfoListSize', ctypes.c_uint32),
    ('gpuInfoList', struct_NVXXXX_CTRL_XXX_INFO * 65),
]

NV2080_CTRL_GPU_GET_INFO_V2_PARAMS = struct_NV2080_CTRL_GPU_GET_INFO_V2_PARAMS
class struct_NV2080_CTRL_GPU_GET_NAME_STRING_PARAMS(Structure):
    pass

class union_NV2080_CTRL_GPU_GET_NAME_STRING_PARAMS_gpuNameString(Union):
    pass

union_NV2080_CTRL_GPU_GET_NAME_STRING_PARAMS_gpuNameString._pack_ = 1 # source:False
union_NV2080_CTRL_GPU_GET_NAME_STRING_PARAMS_gpuNameString._fields_ = [
    ('ascii', ctypes.c_ubyte * 64),
    ('unicode', ctypes.c_uint16 * 64),
]

struct_NV2080_CTRL_GPU_GET_NAME_STRING_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_NAME_STRING_PARAMS._fields_ = [
    ('gpuNameStringFlags', ctypes.c_uint32),
    ('gpuNameString', union_NV2080_CTRL_GPU_GET_NAME_STRING_PARAMS_gpuNameString),
]

NV2080_CTRL_GPU_GET_NAME_STRING_PARAMS = struct_NV2080_CTRL_GPU_GET_NAME_STRING_PARAMS
class struct_NV2080_CTRL_GPU_GET_SHORT_NAME_STRING_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_SHORT_NAME_STRING_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_SHORT_NAME_STRING_PARAMS._fields_ = [
    ('gpuShortNameString', ctypes.c_ubyte * 64),
]

NV2080_CTRL_GPU_GET_SHORT_NAME_STRING_PARAMS = struct_NV2080_CTRL_GPU_GET_SHORT_NAME_STRING_PARAMS
class struct_NV2080_CTRL_GPU_SET_POWER_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_SET_POWER_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_SET_POWER_PARAMS._fields_ = [
    ('target', ctypes.c_uint32),
    ('newLevel', ctypes.c_uint32),
    ('oldLevel', ctypes.c_uint32),
]

NV2080_CTRL_GPU_SET_POWER_PARAMS = struct_NV2080_CTRL_GPU_SET_POWER_PARAMS
class struct_NV2080_CTRL_GPU_GET_SDM_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_SDM_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_SDM_PARAMS._fields_ = [
    ('subdeviceMask', ctypes.c_uint32),
]

NV2080_CTRL_GPU_GET_SDM_PARAMS = struct_NV2080_CTRL_GPU_GET_SDM_PARAMS
class struct_NV2080_CTRL_GPU_SET_SDM_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_SET_SDM_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_SET_SDM_PARAMS._fields_ = [
    ('subdeviceMask', ctypes.c_uint32),
]

NV2080_CTRL_GPU_SET_SDM_PARAMS = struct_NV2080_CTRL_GPU_SET_SDM_PARAMS
class struct_NV2080_CTRL_GPU_GET_SIMULATION_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_SIMULATION_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_SIMULATION_INFO_PARAMS._fields_ = [
    ('type', ctypes.c_uint32),
]

NV2080_CTRL_GPU_GET_SIMULATION_INFO_PARAMS = struct_NV2080_CTRL_GPU_GET_SIMULATION_INFO_PARAMS
class struct_NV2080_CTRL_GPU_REG_OP(Structure):
    pass

struct_NV2080_CTRL_GPU_REG_OP._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_REG_OP._fields_ = [
    ('regOp', ctypes.c_ubyte),
    ('regType', ctypes.c_ubyte),
    ('regStatus', ctypes.c_ubyte),
    ('regQuad', ctypes.c_ubyte),
    ('regGroupMask', ctypes.c_uint32),
    ('regSubGroupMask', ctypes.c_uint32),
    ('regOffset', ctypes.c_uint32),
    ('regValueHi', ctypes.c_uint32),
    ('regValueLo', ctypes.c_uint32),
    ('regAndNMaskHi', ctypes.c_uint32),
    ('regAndNMaskLo', ctypes.c_uint32),
]

NV2080_CTRL_GPU_REG_OP = struct_NV2080_CTRL_GPU_REG_OP
class struct_NV2080_CTRL_GPU_EXEC_REG_OPS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_EXEC_REG_OPS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_EXEC_REG_OPS_PARAMS._fields_ = [
    ('hClientTarget', ctypes.c_uint32),
    ('hChannelTarget', ctypes.c_uint32),
    ('bNonTransactional', ctypes.c_uint32),
    ('reserved00', ctypes.c_uint32 * 2),
    ('regOpCount', ctypes.c_uint32),
    ('regOps', ctypes.POINTER(None)),
    ('grRouteInfo', NV2080_CTRL_GR_ROUTE_INFO),
]

NV2080_CTRL_GPU_EXEC_REG_OPS_PARAMS = struct_NV2080_CTRL_GPU_EXEC_REG_OPS_PARAMS
class struct_NV2080_CTRL_GPU_GET_ENGINES_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_ENGINES_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_ENGINES_PARAMS._fields_ = [
    ('engineCount', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('engineList', ctypes.POINTER(None)),
]

NV2080_CTRL_GPU_GET_ENGINES_PARAMS = struct_NV2080_CTRL_GPU_GET_ENGINES_PARAMS
class struct_NV2080_CTRL_GPU_GET_ENGINES_V2_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_ENGINES_V2_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_ENGINES_V2_PARAMS._fields_ = [
    ('engineCount', ctypes.c_uint32),
    ('engineList', ctypes.c_uint32 * 64),
]

NV2080_CTRL_GPU_GET_ENGINES_V2_PARAMS = struct_NV2080_CTRL_GPU_GET_ENGINES_V2_PARAMS
class struct_NV2080_CTRL_GPU_GET_ENGINE_CLASSLIST_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_ENGINE_CLASSLIST_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_ENGINE_CLASSLIST_PARAMS._fields_ = [
    ('engineType', ctypes.c_uint32),
    ('numClasses', ctypes.c_uint32),
    ('classList', ctypes.POINTER(None)),
]

NV2080_CTRL_GPU_GET_ENGINE_CLASSLIST_PARAMS = struct_NV2080_CTRL_GPU_GET_ENGINE_CLASSLIST_PARAMS
class struct_NV2080_CTRL_GPU_GET_ENGINE_FAULT_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_ENGINE_FAULT_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_ENGINE_FAULT_INFO_PARAMS._fields_ = [
    ('engineType', ctypes.c_uint32),
    ('mmuFaultId', ctypes.c_uint32),
    ('bSubcontextSupported', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_GPU_GET_ENGINE_FAULT_INFO_PARAMS = struct_NV2080_CTRL_GPU_GET_ENGINE_FAULT_INFO_PARAMS
class struct_NV2080_CTRL_GPU_QUERY_MODE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_QUERY_MODE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_QUERY_MODE_PARAMS._fields_ = [
    ('mode', ctypes.c_uint32),
]

NV2080_CTRL_GPU_QUERY_MODE_PARAMS = struct_NV2080_CTRL_GPU_QUERY_MODE_PARAMS
class struct_NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ENTRY(Structure):
    pass

struct_NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ENTRY._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ENTRY._fields_ = [
    ('gpuPhysAddr', ctypes.c_uint64),
    ('gpuVirtAddr', ctypes.c_uint64),
    ('size', ctypes.c_uint64),
    ('physAttr', ctypes.c_uint32),
    ('bufferId', ctypes.c_uint16),
    ('bInitialize', ctypes.c_ubyte),
    ('bNonmapped', ctypes.c_ubyte),
]

NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ENTRY = struct_NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ENTRY
class struct_NV2080_CTRL_GPU_PROMOTE_CTX_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_PROMOTE_CTX_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_PROMOTE_CTX_PARAMS._fields_ = [
    ('engineType', ctypes.c_uint32),
    ('hClient', ctypes.c_uint32),
    ('ChID', ctypes.c_uint32),
    ('hChanClient', ctypes.c_uint32),
    ('hObject', ctypes.c_uint32),
    ('hVirtMemory', ctypes.c_uint32),
    ('virtAddress', ctypes.c_uint64),
    ('size', ctypes.c_uint64),
    ('entryCount', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('promoteEntry', struct_NV2080_CTRL_GPU_PROMOTE_CTX_BUFFER_ENTRY * 16),
]

NV2080_CTRL_GPU_PROMOTE_CTX_PARAMS = struct_NV2080_CTRL_GPU_PROMOTE_CTX_PARAMS
PNV2080_CTRL_GPU_PROMOTE_CTX_PARAMS = ctypes.POINTER(struct_NV2080_CTRL_GPU_PROMOTE_CTX_PARAMS)
class struct_NV2080_CTRL_GPU_EVICT_CTX_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_EVICT_CTX_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_EVICT_CTX_PARAMS._fields_ = [
    ('engineType', ctypes.c_uint32),
    ('hClient', ctypes.c_uint32),
    ('ChID', ctypes.c_uint32),
    ('hChanClient', ctypes.c_uint32),
    ('hObject', ctypes.c_uint32),
]

NV2080_CTRL_GPU_EVICT_CTX_PARAMS = struct_NV2080_CTRL_GPU_EVICT_CTX_PARAMS
PNV2080_CTRL_GPU_EVICT_CTX_PARAMS = ctypes.POINTER(struct_NV2080_CTRL_GPU_EVICT_CTX_PARAMS)
class struct_NV2080_CTRL_GPU_INITIALIZE_CTX_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_INITIALIZE_CTX_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_INITIALIZE_CTX_PARAMS._fields_ = [
    ('engineType', ctypes.c_uint32),
    ('hClient', ctypes.c_uint32),
    ('ChID', ctypes.c_uint32),
    ('hChanClient', ctypes.c_uint32),
    ('hObject', ctypes.c_uint32),
    ('hVirtMemory', ctypes.c_uint32),
    ('physAddress', ctypes.c_uint64),
    ('physAttr', ctypes.c_uint32),
    ('hDmaHandle', ctypes.c_uint32),
    ('index', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('size', ctypes.c_uint64),
]

NV2080_CTRL_GPU_INITIALIZE_CTX_PARAMS = struct_NV2080_CTRL_GPU_INITIALIZE_CTX_PARAMS
PNV2080_CTRL_GPU_INITIALIZE_CTX_PARAMS = ctypes.POINTER(struct_NV2080_CTRL_GPU_INITIALIZE_CTX_PARAMS)
class struct_NV2080_CTRL_GPU_QUERY_ECC_INTR_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_QUERY_ECC_INTR_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_QUERY_ECC_INTR_PARAMS._fields_ = [
    ('eccIntrStatus', ctypes.c_uint32),
]

NV2080_CTRL_GPU_QUERY_ECC_INTR_PARAMS = struct_NV2080_CTRL_GPU_QUERY_ECC_INTR_PARAMS
class struct_NV2080_CTRL_GPU_QUERY_ECC_EXCEPTION_STATUS(Structure):
    pass

struct_NV2080_CTRL_GPU_QUERY_ECC_EXCEPTION_STATUS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_QUERY_ECC_EXCEPTION_STATUS._fields_ = [
    ('count', ctypes.c_uint64),
]

NV2080_CTRL_GPU_QUERY_ECC_EXCEPTION_STATUS = struct_NV2080_CTRL_GPU_QUERY_ECC_EXCEPTION_STATUS
class struct_NV2080_CTRL_GPU_QUERY_ECC_UNIT_STATUS(Structure):
    pass

struct_NV2080_CTRL_GPU_QUERY_ECC_UNIT_STATUS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_QUERY_ECC_UNIT_STATUS._fields_ = [
    ('enabled', ctypes.c_ubyte),
    ('scrubComplete', ctypes.c_ubyte),
    ('supported', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 5),
    ('dbe', NV2080_CTRL_GPU_QUERY_ECC_EXCEPTION_STATUS),
    ('dbeNonResettable', NV2080_CTRL_GPU_QUERY_ECC_EXCEPTION_STATUS),
    ('sbe', NV2080_CTRL_GPU_QUERY_ECC_EXCEPTION_STATUS),
    ('sbeNonResettable', NV2080_CTRL_GPU_QUERY_ECC_EXCEPTION_STATUS),
]

NV2080_CTRL_GPU_QUERY_ECC_UNIT_STATUS = struct_NV2080_CTRL_GPU_QUERY_ECC_UNIT_STATUS
class struct_NV2080_CTRL_GPU_QUERY_ECC_STATUS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_QUERY_ECC_STATUS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_QUERY_ECC_STATUS_PARAMS._fields_ = [
    ('units', struct_NV2080_CTRL_GPU_QUERY_ECC_UNIT_STATUS * 25),
    ('bFatalPoisonError', ctypes.c_ubyte),
    ('uncorrectableError', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 2),
    ('flags', ctypes.c_uint32),
    ('grRouteInfo', NV2080_CTRL_GR_ROUTE_INFO),
]

NV2080_CTRL_GPU_QUERY_ECC_STATUS_PARAMS = struct_NV2080_CTRL_GPU_QUERY_ECC_STATUS_PARAMS
class struct_NV2080_CTRL_GPU_SET_COMPUTE_MODE_RULES_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_SET_COMPUTE_MODE_RULES_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_SET_COMPUTE_MODE_RULES_PARAMS._fields_ = [
    ('rules', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
]

NV2080_CTRL_GPU_SET_COMPUTE_MODE_RULES_PARAMS = struct_NV2080_CTRL_GPU_SET_COMPUTE_MODE_RULES_PARAMS
class struct_NV2080_CTRL_GPU_QUERY_COMPUTE_MODE_RULES_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_QUERY_COMPUTE_MODE_RULES_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_QUERY_COMPUTE_MODE_RULES_PARAMS._fields_ = [
    ('rules', ctypes.c_uint32),
]

NV2080_CTRL_GPU_QUERY_COMPUTE_MODE_RULES_PARAMS = struct_NV2080_CTRL_GPU_QUERY_COMPUTE_MODE_RULES_PARAMS
class struct_NV2080_CTRL_GPU_QUERY_ECC_CONFIGURATION_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_QUERY_ECC_CONFIGURATION_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_QUERY_ECC_CONFIGURATION_PARAMS._fields_ = [
    ('currentConfiguration', ctypes.c_uint32),
    ('defaultConfiguration', ctypes.c_uint32),
]

NV2080_CTRL_GPU_QUERY_ECC_CONFIGURATION_PARAMS = struct_NV2080_CTRL_GPU_QUERY_ECC_CONFIGURATION_PARAMS
class struct_NV2080_CTRL_GPU_SET_ECC_CONFIGURATION_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_SET_ECC_CONFIGURATION_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_SET_ECC_CONFIGURATION_PARAMS._fields_ = [
    ('newConfiguration', ctypes.c_uint32),
]

NV2080_CTRL_GPU_SET_ECC_CONFIGURATION_PARAMS = struct_NV2080_CTRL_GPU_SET_ECC_CONFIGURATION_PARAMS
class struct_NV2080_CTRL_GPU_RESET_ECC_ERROR_STATUS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_RESET_ECC_ERROR_STATUS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_RESET_ECC_ERROR_STATUS_PARAMS._fields_ = [
    ('statuses', ctypes.c_uint32),
    ('flags', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_GPU_RESET_ECC_ERROR_STATUS_PARAMS = struct_NV2080_CTRL_GPU_RESET_ECC_ERROR_STATUS_PARAMS
class struct_NV2080_CTRL_GPU_GET_FERMI_GPC_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_FERMI_GPC_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_FERMI_GPC_INFO_PARAMS._fields_ = [
    ('gpcMask', ctypes.c_uint32),
]

NV2080_CTRL_GPU_GET_FERMI_GPC_INFO_PARAMS = struct_NV2080_CTRL_GPU_GET_FERMI_GPC_INFO_PARAMS
class struct_NV2080_CTRL_GPU_GET_FERMI_TPC_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_FERMI_TPC_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_FERMI_TPC_INFO_PARAMS._fields_ = [
    ('gpcId', ctypes.c_uint32),
    ('tpcMask', ctypes.c_uint32),
]

NV2080_CTRL_GPU_GET_FERMI_TPC_INFO_PARAMS = struct_NV2080_CTRL_GPU_GET_FERMI_TPC_INFO_PARAMS
class struct_NV2080_CTRL_GPU_GET_FERMI_ZCULL_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_FERMI_ZCULL_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_FERMI_ZCULL_INFO_PARAMS._fields_ = [
    ('gpcId', ctypes.c_uint32),
    ('zcullMask', ctypes.c_uint32),
]

NV2080_CTRL_GPU_GET_FERMI_ZCULL_INFO_PARAMS = struct_NV2080_CTRL_GPU_GET_FERMI_ZCULL_INFO_PARAMS
class struct_NV2080_CTRL_GPU_GET_OEM_BOARD_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_OEM_BOARD_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_OEM_BOARD_INFO_PARAMS._fields_ = [
    ('buildDate', ctypes.c_uint32),
    ('marketingName', ctypes.c_ubyte * 24),
    ('serialNumber', ctypes.c_ubyte * 16),
    ('memoryManufacturer', ctypes.c_ubyte),
    ('memoryPartID', ctypes.c_ubyte * 20),
    ('memoryDateCode', ctypes.c_ubyte * 6),
    ('productPartNumber', ctypes.c_ubyte * 20),
    ('boardRevision', ctypes.c_ubyte * 3),
    ('boardType', ctypes.c_ubyte),
    ('board699PartNumber', ctypes.c_ubyte * 20),
    ('board965PartNumber', ctypes.c_ubyte * 20),
    ('PADDING_0', ctypes.c_ubyte),
]

NV2080_CTRL_GPU_GET_OEM_BOARD_INFO_PARAMS = struct_NV2080_CTRL_GPU_GET_OEM_BOARD_INFO_PARAMS
class struct_NV2080_CTRL_GPU_GET_ID_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_ID_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_ID_PARAMS._fields_ = [
    ('gpuId', ctypes.c_uint32),
]

NV2080_CTRL_GPU_GET_ID_PARAMS = struct_NV2080_CTRL_GPU_GET_ID_PARAMS
class struct_NV2080_CTRL_GPU_SET_GPU_DEBUG_MODE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_SET_GPU_DEBUG_MODE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_SET_GPU_DEBUG_MODE_PARAMS._fields_ = [
    ('mode', ctypes.c_uint32),
]

NV2080_CTRL_GPU_SET_GPU_DEBUG_MODE_PARAMS = struct_NV2080_CTRL_GPU_SET_GPU_DEBUG_MODE_PARAMS
class struct_NV2080_CTRL_GPU_GET_GPU_DEBUG_MODE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_GPU_DEBUG_MODE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_GPU_DEBUG_MODE_PARAMS._fields_ = [
    ('currentMode', ctypes.c_uint32),
]

NV2080_CTRL_GPU_GET_GPU_DEBUG_MODE_PARAMS = struct_NV2080_CTRL_GPU_GET_GPU_DEBUG_MODE_PARAMS
class struct_NV2080_CTRL_GPU_GET_ENGINE_PARTNERLIST_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_ENGINE_PARTNERLIST_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_ENGINE_PARTNERLIST_PARAMS._fields_ = [
    ('engineType', ctypes.c_uint32),
    ('partnershipClassId', ctypes.c_uint32),
    ('runqueue', ctypes.c_uint32),
    ('numPartners', ctypes.c_uint32),
    ('partnerList', ctypes.c_uint32 * 32),
]

NV2080_CTRL_GPU_GET_ENGINE_PARTNERLIST_PARAMS = struct_NV2080_CTRL_GPU_GET_ENGINE_PARTNERLIST_PARAMS
class struct_NV2080_CTRL_GPU_GET_GID_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_GID_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_GID_INFO_PARAMS._fields_ = [
    ('index', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('length', ctypes.c_uint32),
    ('data', ctypes.c_ubyte * 256),
]

NV2080_CTRL_GPU_GET_GID_INFO_PARAMS = struct_NV2080_CTRL_GPU_GET_GID_INFO_PARAMS
class struct_NV2080_CTRL_GPU_GET_INFOROM_OBJECT_VERSION_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_INFOROM_OBJECT_VERSION_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_INFOROM_OBJECT_VERSION_PARAMS._fields_ = [
    ('objectType', ctypes.c_char * 3),
    ('version', ctypes.c_ubyte),
    ('subversion', ctypes.c_ubyte),
]

NV2080_CTRL_GPU_GET_INFOROM_OBJECT_VERSION_PARAMS = struct_NV2080_CTRL_GPU_GET_INFOROM_OBJECT_VERSION_PARAMS
class struct_NV2080_CTRL_GPU_OPTIMUS_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_OPTIMUS_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_OPTIMUS_INFO_PARAMS._fields_ = [
    ('isOptimusEnabled', ctypes.c_ubyte),
]

NV2080_CTRL_GPU_OPTIMUS_INFO_PARAMS = struct_NV2080_CTRL_GPU_OPTIMUS_INFO_PARAMS
class struct_NV2080_CTRL_GPU_GET_IP_VERSION_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_IP_VERSION_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_IP_VERSION_PARAMS._fields_ = [
    ('targetEngine', ctypes.c_uint32),
    ('ipVersion', ctypes.c_uint32),
]

NV2080_CTRL_GPU_GET_IP_VERSION_PARAMS = struct_NV2080_CTRL_GPU_GET_IP_VERSION_PARAMS
class struct_NV2080_CTRL_CMD_GPU_QUERY_ILLUM_SUPPORT_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_GPU_QUERY_ILLUM_SUPPORT_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_GPU_QUERY_ILLUM_SUPPORT_PARAMS._fields_ = [
    ('attribute', ctypes.c_uint32),
    ('bSupported', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_CMD_GPU_QUERY_ILLUM_SUPPORT_PARAMS = struct_NV2080_CTRL_CMD_GPU_QUERY_ILLUM_SUPPORT_PARAMS
class struct_NV2080_CTRL_CMD_GPU_ILLUM_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_GPU_ILLUM_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_GPU_ILLUM_PARAMS._fields_ = [
    ('attribute', ctypes.c_uint32),
    ('value', ctypes.c_uint32),
]

NV2080_CTRL_CMD_GPU_ILLUM_PARAMS = struct_NV2080_CTRL_CMD_GPU_ILLUM_PARAMS
NV2080_CTRL_GPU_GET_ILLUM_PARAMS = struct_NV2080_CTRL_CMD_GPU_ILLUM_PARAMS
NV2080_CTRL_GPU_SET_ILLUM_PARAMS = struct_NV2080_CTRL_CMD_GPU_ILLUM_PARAMS
class struct_NV2080_CTRL_GPU_GET_INFOROM_IMAGE_VERSION_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_INFOROM_IMAGE_VERSION_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_INFOROM_IMAGE_VERSION_PARAMS._fields_ = [
    ('version', ctypes.c_ubyte * 16),
]

NV2080_CTRL_GPU_GET_INFOROM_IMAGE_VERSION_PARAMS = struct_NV2080_CTRL_GPU_GET_INFOROM_IMAGE_VERSION_PARAMS
class struct_NV2080_CTRL_GPU_PHYSICAL_BRIDGE_VERSION_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_PHYSICAL_BRIDGE_VERSION_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_PHYSICAL_BRIDGE_VERSION_PARAMS._fields_ = [
    ('fwVersion', ctypes.c_uint32),
    ('oemVersion', ctypes.c_ubyte),
    ('siliconRevision', ctypes.c_ubyte),
    ('hwbcResourceType', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte),
]

NV2080_CTRL_GPU_PHYSICAL_BRIDGE_VERSION_PARAMS = struct_NV2080_CTRL_GPU_PHYSICAL_BRIDGE_VERSION_PARAMS
class struct_NV2080_CTRL_GPU_GET_PHYSICAL_BRIDGE_VERSION_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_PHYSICAL_BRIDGE_VERSION_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_PHYSICAL_BRIDGE_VERSION_INFO_PARAMS._fields_ = [
    ('bridgeCount', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('hPhysicalBridges', ctypes.c_uint32 * 100),
    ('bridgeList', struct_NV2080_CTRL_GPU_PHYSICAL_BRIDGE_VERSION_PARAMS * 100),
]

NV2080_CTRL_GPU_GET_PHYSICAL_BRIDGE_VERSION_INFO_PARAMS = struct_NV2080_CTRL_GPU_GET_PHYSICAL_BRIDGE_VERSION_INFO_PARAMS
class struct_NV2080_CTRL_GPU_BRIDGE_VERSION_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_BRIDGE_VERSION_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_BRIDGE_VERSION_PARAMS._fields_ = [
    ('bus', ctypes.c_ubyte),
    ('device', ctypes.c_ubyte),
    ('func', ctypes.c_ubyte),
    ('oemVersion', ctypes.c_ubyte),
    ('siliconRevision', ctypes.c_ubyte),
    ('hwbcResourceType', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 2),
    ('domain', ctypes.c_uint32),
    ('fwVersion', ctypes.c_uint32),
]

NV2080_CTRL_GPU_BRIDGE_VERSION_PARAMS = struct_NV2080_CTRL_GPU_BRIDGE_VERSION_PARAMS
class struct_NV2080_CTRL_GPU_GET_ALL_BRIDGES_UPSTREAM_OF_GPU_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_ALL_BRIDGES_UPSTREAM_OF_GPU_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_ALL_BRIDGES_UPSTREAM_OF_GPU_PARAMS._fields_ = [
    ('bridgeCount', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('physicalBridgeIds', ctypes.c_uint32 * 100),
    ('bridgeList', struct_NV2080_CTRL_GPU_BRIDGE_VERSION_PARAMS * 100),
]

NV2080_CTRL_GPU_GET_ALL_BRIDGES_UPSTREAM_OF_GPU_PARAMS = struct_NV2080_CTRL_GPU_GET_ALL_BRIDGES_UPSTREAM_OF_GPU_PARAMS
class struct_NV2080_CTRL_GPU_QUERY_SCRUBBER_STATUS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_QUERY_SCRUBBER_STATUS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_QUERY_SCRUBBER_STATUS_PARAMS._fields_ = [
    ('scrubberStatus', ctypes.c_uint32),
    ('remainingTimeMs', ctypes.c_uint32),
    ('scrubStartAddr', ctypes.c_uint64),
    ('scrubEndAddr', ctypes.c_uint64),
]

NV2080_CTRL_GPU_QUERY_SCRUBBER_STATUS_PARAMS = struct_NV2080_CTRL_GPU_QUERY_SCRUBBER_STATUS_PARAMS
class struct_NV2080_CTRL_GPU_GET_VPR_CAPS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_VPR_CAPS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_VPR_CAPS_PARAMS._fields_ = [
    ('minStartAddr', ctypes.c_uint64),
    ('maxEndAddr', ctypes.c_uint64),
]

NV2080_CTRL_GPU_GET_VPR_CAPS_PARAMS = struct_NV2080_CTRL_GPU_GET_VPR_CAPS_PARAMS
class struct_NV2080_CTRL_GPU_GET_PES_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_PES_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_PES_INFO_PARAMS._fields_ = [
    ('gpcId', ctypes.c_uint32),
    ('numPesInGpc', ctypes.c_uint32),
    ('activePesMask', ctypes.c_uint32),
    ('maxTpcPerGpcCount', ctypes.c_uint32),
    ('tpcToPesMap', ctypes.c_uint32 * 10),
]

NV2080_CTRL_GPU_GET_PES_INFO_PARAMS = struct_NV2080_CTRL_GPU_GET_PES_INFO_PARAMS
class struct_NV2080_CTRL_GPU_GET_OEM_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_OEM_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_OEM_INFO_PARAMS._fields_ = [
    ('oemInfo', ctypes.c_ubyte * 504),
]

NV2080_CTRL_GPU_GET_OEM_INFO_PARAMS = struct_NV2080_CTRL_GPU_GET_OEM_INFO_PARAMS

# values for enumeration 'NV2080_CTRL_VPR_INFO_QUERY_TYPE'
NV2080_CTRL_VPR_INFO_QUERY_TYPE__enumvalues = {
    0: 'NV2080_CTRL_GPU_GET_VPR_INFO_QUERY_VPR_CAPS',
    1: 'NV2080_CTRL_GPU_GET_VPR_INFO_QUERY_CUR_VPR_RANGE',
}
NV2080_CTRL_GPU_GET_VPR_INFO_QUERY_VPR_CAPS = 0
NV2080_CTRL_GPU_GET_VPR_INFO_QUERY_CUR_VPR_RANGE = 1
NV2080_CTRL_VPR_INFO_QUERY_TYPE = ctypes.c_uint32 # enum
class struct_NV2080_CTRL_GPU_GET_VPR_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_VPR_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_VPR_INFO_PARAMS._fields_ = [
    ('queryType', NV2080_CTRL_VPR_INFO_QUERY_TYPE),
    ('bIsVprEnabled', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('vprStartAddressInBytes', ctypes.c_uint64),
    ('vprEndAddressInBytes', ctypes.c_uint64),
]

NV2080_CTRL_GPU_GET_VPR_INFO_PARAMS = struct_NV2080_CTRL_GPU_GET_VPR_INFO_PARAMS

# values for enumeration 'NV2080_CTRL_ENCODER_CAPACITY_QUERY_TYPE'
NV2080_CTRL_ENCODER_CAPACITY_QUERY_TYPE__enumvalues = {
    0: 'NV2080_CTRL_GPU_GET_ENCODER_CAPACITY_H264',
    1: 'NV2080_CTRL_GPU_GET_ENCODER_CAPACITY_HEVC',
    2: 'NV2080_CTRL_GPU_GET_ENCODER_CAPACITY_AV1',
}
NV2080_CTRL_GPU_GET_ENCODER_CAPACITY_H264 = 0
NV2080_CTRL_GPU_GET_ENCODER_CAPACITY_HEVC = 1
NV2080_CTRL_GPU_GET_ENCODER_CAPACITY_AV1 = 2
NV2080_CTRL_ENCODER_CAPACITY_QUERY_TYPE = ctypes.c_uint32 # enum
class struct_NV2080_CTRL_GPU_GET_ENCODER_CAPACITY_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_ENCODER_CAPACITY_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_ENCODER_CAPACITY_PARAMS._fields_ = [
    ('queryType', NV2080_CTRL_ENCODER_CAPACITY_QUERY_TYPE),
    ('encoderCapacity', ctypes.c_uint32),
]

NV2080_CTRL_GPU_GET_ENCODER_CAPACITY_PARAMS = struct_NV2080_CTRL_GPU_GET_ENCODER_CAPACITY_PARAMS
class struct_NV2080_CTRL_GPU_GET_NVENC_SW_SESSION_STATS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_NVENC_SW_SESSION_STATS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_NVENC_SW_SESSION_STATS_PARAMS._fields_ = [
    ('encoderSessionCount', ctypes.c_uint32),
    ('averageEncodeFps', ctypes.c_uint32),
    ('averageEncodeLatency', ctypes.c_uint32),
]

NV2080_CTRL_GPU_GET_NVENC_SW_SESSION_STATS_PARAMS = struct_NV2080_CTRL_GPU_GET_NVENC_SW_SESSION_STATS_PARAMS
class struct_NV2080_CTRL_NVENC_SW_SESSION_INFO(Structure):
    pass

struct_NV2080_CTRL_NVENC_SW_SESSION_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_NVENC_SW_SESSION_INFO._fields_ = [
    ('processId', ctypes.c_uint32),
    ('subProcessId', ctypes.c_uint32),
    ('sessionId', ctypes.c_uint32),
    ('codecType', ctypes.c_uint32),
    ('hResolution', ctypes.c_uint32),
    ('vResolution', ctypes.c_uint32),
    ('averageEncodeFps', ctypes.c_uint32),
    ('averageEncodeLatency', ctypes.c_uint32),
]

NV2080_CTRL_NVENC_SW_SESSION_INFO = struct_NV2080_CTRL_NVENC_SW_SESSION_INFO
class struct_NV2080_CTRL_GPU_GET_NVENC_SW_SESSION_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_NVENC_SW_SESSION_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_NVENC_SW_SESSION_INFO_PARAMS._fields_ = [
    ('sessionInfoTblEntry', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('sessionInfoTbl', ctypes.POINTER(None)),
]

NV2080_CTRL_GPU_GET_NVENC_SW_SESSION_INFO_PARAMS = struct_NV2080_CTRL_GPU_GET_NVENC_SW_SESSION_INFO_PARAMS
class struct_NV2080_CTRL_GPU_SET_FABRIC_BASE_ADDR_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_SET_FABRIC_BASE_ADDR_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_SET_FABRIC_BASE_ADDR_PARAMS._fields_ = [
    ('fabricBaseAddr', ctypes.c_uint64),
]

NV2080_CTRL_GPU_SET_FABRIC_BASE_ADDR_PARAMS = struct_NV2080_CTRL_GPU_SET_FABRIC_BASE_ADDR_PARAMS
class struct_NV2080_CTRL_GPU_VIRTUAL_INTERRUPT_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_VIRTUAL_INTERRUPT_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_VIRTUAL_INTERRUPT_PARAMS._fields_ = [
    ('handle', ctypes.c_uint32),
]

NV2080_CTRL_GPU_VIRTUAL_INTERRUPT_PARAMS = struct_NV2080_CTRL_GPU_VIRTUAL_INTERRUPT_PARAMS
class struct_NV2080_CTRL_CMD_GPU_QUERY_FUNCTION_STATUS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_GPU_QUERY_FUNCTION_STATUS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_GPU_QUERY_FUNCTION_STATUS_PARAMS._fields_ = [
    ('statusMask', ctypes.c_uint32),
    ('xusbData', ctypes.c_uint32),
    ('ppcData', ctypes.c_uint32),
]

NV2080_CTRL_CMD_GPU_QUERY_FUNCTION_STATUS_PARAMS = struct_NV2080_CTRL_CMD_GPU_QUERY_FUNCTION_STATUS_PARAMS
class struct_NV2080_CTRL_GPU_PARTITION_SPAN(Structure):
    pass

struct_NV2080_CTRL_GPU_PARTITION_SPAN._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_PARTITION_SPAN._fields_ = [
    ('lo', ctypes.c_uint64),
    ('hi', ctypes.c_uint64),
]

NV2080_CTRL_GPU_PARTITION_SPAN = struct_NV2080_CTRL_GPU_PARTITION_SPAN
class struct_NV2080_CTRL_GPU_SET_PARTITION_INFO(Structure):
    pass

struct_NV2080_CTRL_GPU_SET_PARTITION_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_SET_PARTITION_INFO._fields_ = [
    ('swizzId', ctypes.c_uint32),
    ('uuid', ctypes.c_ubyte * 16),
    ('partitionFlag', ctypes.c_uint32),
    ('bValid', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 7),
    ('placement', NV2080_CTRL_GPU_PARTITION_SPAN),
]

NV2080_CTRL_GPU_SET_PARTITION_INFO = struct_NV2080_CTRL_GPU_SET_PARTITION_INFO
class struct_NV2080_CTRL_GPU_SET_PARTITIONS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_SET_PARTITIONS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_SET_PARTITIONS_PARAMS._fields_ = [
    ('partitionCount', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('partitionInfo', struct_NV2080_CTRL_GPU_SET_PARTITION_INFO * 8),
]

NV2080_CTRL_GPU_SET_PARTITIONS_PARAMS = struct_NV2080_CTRL_GPU_SET_PARTITIONS_PARAMS
class struct_NV2080_CTRL_GPU_GET_PARTITION_INFO(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_PARTITION_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_PARTITION_INFO._fields_ = [
    ('swizzId', ctypes.c_uint32),
    ('partitionFlag', ctypes.c_uint32),
    ('grEngCount', ctypes.c_uint32),
    ('veidCount', ctypes.c_uint32),
    ('smCount', ctypes.c_uint32),
    ('ceCount', ctypes.c_uint32),
    ('nvEncCount', ctypes.c_uint32),
    ('nvDecCount', ctypes.c_uint32),
    ('nvJpgCount', ctypes.c_uint32),
    ('nvOfaCount', ctypes.c_uint32),
    ('gpcCount', ctypes.c_uint32),
    ('virtualGpcCount', ctypes.c_uint32),
    ('gfxGpcCount', ctypes.c_uint32),
    ('gpcsPerGr', ctypes.c_uint32 * 8),
    ('virtualGpcsPerGr', ctypes.c_uint32 * 8),
    ('gfxGpcPerGr', ctypes.c_uint32 * 8),
    ('veidsPerGr', ctypes.c_uint32 * 8),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('memSize', ctypes.c_uint64),
    ('span', NV2080_CTRL_GPU_PARTITION_SPAN),
    ('bValid', ctypes.c_ubyte),
    ('bPartitionError', ctypes.c_ubyte),
    ('PADDING_1', ctypes.c_ubyte * 6),
    ('validCTSIdMask', ctypes.c_uint64),
    ('validGfxCTSIdMask', ctypes.c_uint64),
]

NV2080_CTRL_GPU_GET_PARTITION_INFO = struct_NV2080_CTRL_GPU_GET_PARTITION_INFO
class struct_NV2080_CTRL_GPU_GET_PARTITIONS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_PARTITIONS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_PARTITIONS_PARAMS._fields_ = [
    ('queryPartitionInfo', struct_NV2080_CTRL_GPU_GET_PARTITION_INFO * 8),
    ('validPartitionCount', ctypes.c_uint32),
    ('bGetAllPartitionInfo', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_GPU_GET_PARTITIONS_PARAMS = struct_NV2080_CTRL_GPU_GET_PARTITIONS_PARAMS
class struct_NV2080_CTRL_GPU_CONFIGURE_PARTITION_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_CONFIGURE_PARTITION_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_CONFIGURE_PARTITION_PARAMS._fields_ = [
    ('swizzId', ctypes.c_uint32),
    ('gpcCountPerSmcEng', ctypes.c_uint32 * 8),
    ('updateSmcEngMask', ctypes.c_uint32),
    ('bUseAllGPCs', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_GPU_CONFIGURE_PARTITION_PARAMS = struct_NV2080_CTRL_GPU_CONFIGURE_PARTITION_PARAMS
class struct_NV2080_CTRL_GPU_FAULT_PACKET(Structure):
    pass

struct_NV2080_CTRL_GPU_FAULT_PACKET._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_FAULT_PACKET._fields_ = [
    ('data', ctypes.c_ubyte * 32),
]

NV2080_CTRL_GPU_FAULT_PACKET = struct_NV2080_CTRL_GPU_FAULT_PACKET
class struct_NV2080_CTRL_GPU_REPORT_NON_REPLAYABLE_FAULT_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('faultPacket', NV2080_CTRL_GPU_FAULT_PACKET),
     ]

NV2080_CTRL_GPU_REPORT_NON_REPLAYABLE_FAULT_PARAMS = struct_NV2080_CTRL_GPU_REPORT_NON_REPLAYABLE_FAULT_PARAMS
NV2080_CTRL_GPU_EXEC_REG_OPS_VGPU_PARAMS = struct_NV2080_CTRL_GPU_EXEC_REG_OPS_PARAMS
class struct_NV2080_CTRL_GPU_GET_ENGINE_RUNLIST_PRI_BASE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_ENGINE_RUNLIST_PRI_BASE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_ENGINE_RUNLIST_PRI_BASE_PARAMS._fields_ = [
    ('engineList', ctypes.c_uint32 * 64),
    ('runlistPriBase', ctypes.c_uint32 * 64),
]

NV2080_CTRL_GPU_GET_ENGINE_RUNLIST_PRI_BASE_PARAMS = struct_NV2080_CTRL_GPU_GET_ENGINE_RUNLIST_PRI_BASE_PARAMS
class struct_NV2080_CTRL_GPU_GET_HW_ENGINE_ID_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_HW_ENGINE_ID_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_HW_ENGINE_ID_PARAMS._fields_ = [
    ('engineList', ctypes.c_uint32 * 64),
    ('hwEngineID', ctypes.c_uint32 * 64),
]

NV2080_CTRL_GPU_GET_HW_ENGINE_ID_PARAMS = struct_NV2080_CTRL_GPU_GET_HW_ENGINE_ID_PARAMS
class struct_NV2080_CTRL_GPU_GET_NVFBC_SW_SESSION_STATS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_NVFBC_SW_SESSION_STATS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_NVFBC_SW_SESSION_STATS_PARAMS._fields_ = [
    ('sessionCount', ctypes.c_uint32),
    ('averageFPS', ctypes.c_uint32),
    ('averageLatency', ctypes.c_uint32),
]

NV2080_CTRL_GPU_GET_NVFBC_SW_SESSION_STATS_PARAMS = struct_NV2080_CTRL_GPU_GET_NVFBC_SW_SESSION_STATS_PARAMS
class struct_NV2080_CTRL_NVFBC_SW_SESSION_INFO(Structure):
    pass

struct_NV2080_CTRL_NVFBC_SW_SESSION_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_NVFBC_SW_SESSION_INFO._fields_ = [
    ('processId', ctypes.c_uint32),
    ('subProcessId', ctypes.c_uint32),
    ('vgpuInstanceId', ctypes.c_uint32),
    ('sessionId', ctypes.c_uint32),
    ('sessionType', ctypes.c_uint32),
    ('displayOrdinal', ctypes.c_uint32),
    ('sessionFlags', ctypes.c_uint32),
    ('hMaxResolution', ctypes.c_uint32),
    ('vMaxResolution', ctypes.c_uint32),
    ('hResolution', ctypes.c_uint32),
    ('vResolution', ctypes.c_uint32),
    ('averageFPS', ctypes.c_uint32),
    ('averageLatency', ctypes.c_uint32),
]

NV2080_CTRL_NVFBC_SW_SESSION_INFO = struct_NV2080_CTRL_NVFBC_SW_SESSION_INFO
class struct_NV2080_CTRL_GPU_GET_NVFBC_SW_SESSION_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_NVFBC_SW_SESSION_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_NVFBC_SW_SESSION_INFO_PARAMS._fields_ = [
    ('sessionInfoCount', ctypes.c_uint32),
    ('sessionInfoTbl', struct_NV2080_CTRL_NVFBC_SW_SESSION_INFO * 256),
]

NV2080_CTRL_GPU_GET_NVFBC_SW_SESSION_INFO_PARAMS = struct_NV2080_CTRL_GPU_GET_NVFBC_SW_SESSION_INFO_PARAMS
class struct_NV2080_CTRL_GPU_GET_VMMU_SEGMENT_SIZE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_VMMU_SEGMENT_SIZE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_VMMU_SEGMENT_SIZE_PARAMS._fields_ = [
    ('vmmuSegmentSize', ctypes.c_uint64),
]

NV2080_CTRL_GPU_GET_VMMU_SEGMENT_SIZE_PARAMS = struct_NV2080_CTRL_GPU_GET_VMMU_SEGMENT_SIZE_PARAMS
class struct_NV2080_CTRL_GPU_GET_PARTITION_CAPACITY_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_PARTITION_CAPACITY_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_PARTITION_CAPACITY_PARAMS._fields_ = [
    ('partitionFlag', ctypes.c_uint32),
    ('partitionCount', ctypes.c_uint32),
    ('availableSpans', struct_NV2080_CTRL_GPU_PARTITION_SPAN * 8),
    ('availableSpansCount', ctypes.c_uint32),
    ('totalPartitionCount', ctypes.c_uint32),
    ('totalSpans', struct_NV2080_CTRL_GPU_PARTITION_SPAN * 8),
    ('totalSpansCount', ctypes.c_uint32),
    ('bStaticInfo', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_GPU_GET_PARTITION_CAPACITY_PARAMS = struct_NV2080_CTRL_GPU_GET_PARTITION_CAPACITY_PARAMS
NV2080_CTRL_GPU_GET_CACHED_INFO_PARAMS = struct_NV2080_CTRL_GPU_GET_INFO_V2_PARAMS
class struct_NV2080_CTRL_GPU_SET_PARTITIONING_MODE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_SET_PARTITIONING_MODE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_SET_PARTITIONING_MODE_PARAMS._fields_ = [
    ('partitioningMode', ctypes.c_uint32),
]

NV2080_CTRL_GPU_SET_PARTITIONING_MODE_PARAMS = struct_NV2080_CTRL_GPU_SET_PARTITIONING_MODE_PARAMS
class struct_NV2080_CTRL_GPU_DESCRIBE_PARTITIONS_INFO(Structure):
    pass

struct_NV2080_CTRL_GPU_DESCRIBE_PARTITIONS_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_DESCRIBE_PARTITIONS_INFO._fields_ = [
    ('partitionFlag', ctypes.c_uint32),
    ('grCount', ctypes.c_uint32),
    ('gfxGrCount', ctypes.c_uint32),
    ('gpcCount', ctypes.c_uint32),
    ('virtualGpcCount', ctypes.c_uint32),
    ('gfxGpcCount', ctypes.c_uint32),
    ('veidCount', ctypes.c_uint32),
    ('smCount', ctypes.c_uint32),
    ('ceCount', ctypes.c_uint32),
    ('nvEncCount', ctypes.c_uint32),
    ('nvDecCount', ctypes.c_uint32),
    ('nvJpgCount', ctypes.c_uint32),
    ('nvOfaCount', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('memorySize', ctypes.c_uint64),
]

NV2080_CTRL_GPU_DESCRIBE_PARTITIONS_INFO = struct_NV2080_CTRL_GPU_DESCRIBE_PARTITIONS_INFO
class struct_NV2080_CTRL_GPU_DESCRIBE_PARTITIONS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_DESCRIBE_PARTITIONS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_DESCRIBE_PARTITIONS_PARAMS._fields_ = [
    ('descCount', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('partitionDescs', struct_NV2080_CTRL_GPU_DESCRIBE_PARTITIONS_INFO * 20),
]

NV2080_CTRL_GPU_DESCRIBE_PARTITIONS_PARAMS = struct_NV2080_CTRL_GPU_DESCRIBE_PARTITIONS_PARAMS
class struct_NV2080_CTRL_GPU_GET_MAX_SUPPORTED_PAGE_SIZE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_MAX_SUPPORTED_PAGE_SIZE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_MAX_SUPPORTED_PAGE_SIZE_PARAMS._fields_ = [
    ('maxSupportedPageSize', ctypes.c_uint64),
]

NV2080_CTRL_GPU_GET_MAX_SUPPORTED_PAGE_SIZE_PARAMS = struct_NV2080_CTRL_GPU_GET_MAX_SUPPORTED_PAGE_SIZE_PARAMS
class struct_NV2080_CTRL_GPU_GET_NUM_MMUS_PER_GPC_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_NUM_MMUS_PER_GPC_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_NUM_MMUS_PER_GPC_PARAMS._fields_ = [
    ('gpcId', ctypes.c_uint32),
    ('count', ctypes.c_uint32),
    ('grRouteInfo', NV2080_CTRL_GR_ROUTE_INFO),
]

NV2080_CTRL_GPU_GET_NUM_MMUS_PER_GPC_PARAMS = struct_NV2080_CTRL_GPU_GET_NUM_MMUS_PER_GPC_PARAMS
class struct_NV2080_CTRL_GPU_GET_ACTIVE_PARTITION_IDS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_ACTIVE_PARTITION_IDS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_ACTIVE_PARTITION_IDS_PARAMS._fields_ = [
    ('swizzId', ctypes.c_uint32 * 9),
    ('partitionCount', ctypes.c_uint32),
]

NV2080_CTRL_GPU_GET_ACTIVE_PARTITION_IDS_PARAMS = struct_NV2080_CTRL_GPU_GET_ACTIVE_PARTITION_IDS_PARAMS
class struct_NV2080_CTRL_GPU_GET_PIDS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_PIDS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_PIDS_PARAMS._fields_ = [
    ('idType', ctypes.c_uint32),
    ('id', ctypes.c_uint32),
    ('pidTblCount', ctypes.c_uint32),
    ('pidTbl', ctypes.c_uint32 * 950),
]

NV2080_CTRL_GPU_GET_PIDS_PARAMS = struct_NV2080_CTRL_GPU_GET_PIDS_PARAMS
class struct_NV2080_CTRL_SMC_SUBSCRIPTION_INFO(Structure):
    pass

struct_NV2080_CTRL_SMC_SUBSCRIPTION_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_SMC_SUBSCRIPTION_INFO._fields_ = [
    ('computeInstanceId', ctypes.c_uint32),
    ('gpuInstanceId', ctypes.c_uint32),
]

NV2080_CTRL_SMC_SUBSCRIPTION_INFO = struct_NV2080_CTRL_SMC_SUBSCRIPTION_INFO
class struct_NV2080_CTRL_GPU_PID_INFO_VIDEO_MEMORY_USAGE_DATA(Structure):
    pass

struct_NV2080_CTRL_GPU_PID_INFO_VIDEO_MEMORY_USAGE_DATA._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_PID_INFO_VIDEO_MEMORY_USAGE_DATA._fields_ = [
    ('memPrivate', ctypes.c_uint64),
    ('memSharedOwned', ctypes.c_uint64),
    ('memSharedDuped', ctypes.c_uint64),
    ('protectedMemPrivate', ctypes.c_uint64),
    ('protectedMemSharedOwned', ctypes.c_uint64),
    ('protectedMemSharedDuped', ctypes.c_uint64),
]

NV2080_CTRL_GPU_PID_INFO_VIDEO_MEMORY_USAGE_DATA = struct_NV2080_CTRL_GPU_PID_INFO_VIDEO_MEMORY_USAGE_DATA
class union_NV2080_CTRL_GPU_PID_INFO_DATA(Union):
    _pack_ = 1 # source:False
    _fields_ = [
    ('vidMemUsage', NV2080_CTRL_GPU_PID_INFO_VIDEO_MEMORY_USAGE_DATA),
     ]

NV2080_CTRL_GPU_PID_INFO_DATA = union_NV2080_CTRL_GPU_PID_INFO_DATA
class struct_NV2080_CTRL_GPU_PID_INFO(Structure):
    pass

struct_NV2080_CTRL_GPU_PID_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_PID_INFO._fields_ = [
    ('pid', ctypes.c_uint32),
    ('index', ctypes.c_uint32),
    ('result', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('data', NV2080_CTRL_GPU_PID_INFO_DATA),
    ('smcSubscription', NV2080_CTRL_SMC_SUBSCRIPTION_INFO),
]

NV2080_CTRL_GPU_PID_INFO = struct_NV2080_CTRL_GPU_PID_INFO
class struct_NV2080_CTRL_GPU_GET_PID_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_PID_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_PID_INFO_PARAMS._fields_ = [
    ('pidInfoListCount', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('pidInfoList', struct_NV2080_CTRL_GPU_PID_INFO * 200),
]

NV2080_CTRL_GPU_GET_PID_INFO_PARAMS = struct_NV2080_CTRL_GPU_GET_PID_INFO_PARAMS
class struct_NV2080_CTRL_CMD_GPU_HANDLE_VF_PRI_FAULT_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_GPU_HANDLE_VF_PRI_FAULT_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_GPU_HANDLE_VF_PRI_FAULT_PARAMS._fields_ = [
    ('faultType', ctypes.c_uint32),
]

NV2080_CTRL_CMD_GPU_HANDLE_VF_PRI_FAULT_PARAMS = struct_NV2080_CTRL_CMD_GPU_HANDLE_VF_PRI_FAULT_PARAMS

# values for enumeration 'NV2080_CTRL_GPU_COMPUTE_POLICY_CONFIG_DATA_TIMESLICE'
NV2080_CTRL_GPU_COMPUTE_POLICY_CONFIG_DATA_TIMESLICE__enumvalues = {
    0: 'NV2080_CTRL_CMD_GPU_COMPUTE_TIMESLICE_DEFAULT',
    1: 'NV2080_CTRL_CMD_GPU_COMPUTE_TIMESLICE_SHORT',
    2: 'NV2080_CTRL_CMD_GPU_COMPUTE_TIMESLICE_MEDIUM',
    3: 'NV2080_CTRL_CMD_GPU_COMPUTE_TIMESLICE_LONG',
    4: 'NV2080_CTRL_CMD_GPU_COMPUTE_TIMESLICE_MAX',
}
NV2080_CTRL_CMD_GPU_COMPUTE_TIMESLICE_DEFAULT = 0
NV2080_CTRL_CMD_GPU_COMPUTE_TIMESLICE_SHORT = 1
NV2080_CTRL_CMD_GPU_COMPUTE_TIMESLICE_MEDIUM = 2
NV2080_CTRL_CMD_GPU_COMPUTE_TIMESLICE_LONG = 3
NV2080_CTRL_CMD_GPU_COMPUTE_TIMESLICE_MAX = 4
NV2080_CTRL_GPU_COMPUTE_POLICY_CONFIG_DATA_TIMESLICE = ctypes.c_uint32 # enum
class struct_NV2080_CTRL_GPU_COMPUTE_POLICY_CONFIG(Structure):
    pass

class union_NV2080_CTRL_GPU_COMPUTE_POLICY_CONFIG_data(Union):
    _pack_ = 1 # source:False
    _fields_ = [
    ('timeslice', NV2080_CTRL_GPU_COMPUTE_POLICY_CONFIG_DATA_TIMESLICE),
     ]

struct_NV2080_CTRL_GPU_COMPUTE_POLICY_CONFIG._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_COMPUTE_POLICY_CONFIG._fields_ = [
    ('type', ctypes.c_uint32),
    ('data', union_NV2080_CTRL_GPU_COMPUTE_POLICY_CONFIG_data),
]

NV2080_CTRL_GPU_COMPUTE_POLICY_CONFIG = struct_NV2080_CTRL_GPU_COMPUTE_POLICY_CONFIG
class struct_NV2080_CTRL_GPU_SET_COMPUTE_POLICY_CONFIG_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('config', NV2080_CTRL_GPU_COMPUTE_POLICY_CONFIG),
     ]

NV2080_CTRL_GPU_SET_COMPUTE_POLICY_CONFIG_PARAMS = struct_NV2080_CTRL_GPU_SET_COMPUTE_POLICY_CONFIG_PARAMS
class struct_NV2080_CTRL_GPU_GET_COMPUTE_POLICY_CONFIG_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_COMPUTE_POLICY_CONFIG_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_COMPUTE_POLICY_CONFIG_PARAMS._fields_ = [
    ('numConfigs', ctypes.c_uint32),
    ('configList', struct_NV2080_CTRL_GPU_COMPUTE_POLICY_CONFIG * 32),
]

NV2080_CTRL_GPU_GET_COMPUTE_POLICY_CONFIG_PARAMS = struct_NV2080_CTRL_GPU_GET_COMPUTE_POLICY_CONFIG_PARAMS
class struct_NV2080_CTRL_GPU_GET_GFID_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_GFID_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_GFID_PARAMS._fields_ = [
    ('domain', ctypes.c_uint32),
    ('bus', ctypes.c_ubyte),
    ('device', ctypes.c_ubyte),
    ('func', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte),
    ('gfid', ctypes.c_uint32),
    ('gfidMask', ctypes.c_uint32),
]

NV2080_CTRL_GPU_GET_GFID_PARAMS = struct_NV2080_CTRL_GPU_GET_GFID_PARAMS
class struct_NV2080_CTRL_CMD_GPU_UPDATE_GFID_P2P_CAPABILITY_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_GPU_UPDATE_GFID_P2P_CAPABILITY_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_GPU_UPDATE_GFID_P2P_CAPABILITY_PARAMS._fields_ = [
    ('gfid', ctypes.c_uint32),
    ('bEnable', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('fabricPartitionId', ctypes.c_uint32),
]

NV2080_CTRL_CMD_GPU_UPDATE_GFID_P2P_CAPABILITY_PARAMS = struct_NV2080_CTRL_CMD_GPU_UPDATE_GFID_P2P_CAPABILITY_PARAMS
class struct_NV2080_CTRL_GPU_VALIDATE_MEM_MAP_REQUEST_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_VALIDATE_MEM_MAP_REQUEST_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_VALIDATE_MEM_MAP_REQUEST_PARAMS._fields_ = [
    ('addressStart', ctypes.c_uint64),
    ('addressLength', ctypes.c_uint64),
    ('protection', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NV2080_CTRL_GPU_VALIDATE_MEM_MAP_REQUEST_PARAMS = struct_NV2080_CTRL_GPU_VALIDATE_MEM_MAP_REQUEST_PARAMS
class struct_NV2080_CTRL_GPU_SET_EGM_GPA_FABRIC_BASE_ADDR_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_SET_EGM_GPA_FABRIC_BASE_ADDR_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_SET_EGM_GPA_FABRIC_BASE_ADDR_PARAMS._fields_ = [
    ('egmGpaFabricBaseAddr', ctypes.c_uint64),
]

NV2080_CTRL_GPU_SET_EGM_GPA_FABRIC_BASE_ADDR_PARAMS = struct_NV2080_CTRL_GPU_SET_EGM_GPA_FABRIC_BASE_ADDR_PARAMS
class struct_NV2080_CTRL_GPU_GET_ENGINE_LOAD_TIMES_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_ENGINE_LOAD_TIMES_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_ENGINE_LOAD_TIMES_PARAMS._fields_ = [
    ('engineCount', ctypes.c_uint32),
    ('engineList', ctypes.c_uint32 * 200),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('engineStateLoadTime', ctypes.c_uint64 * 200),
    ('engineIsInit', ctypes.c_ubyte * 200),
]

NV2080_CTRL_GPU_GET_ENGINE_LOAD_TIMES_PARAMS = struct_NV2080_CTRL_GPU_GET_ENGINE_LOAD_TIMES_PARAMS
class struct_NV2080_CTRL_GPU_GET_ID_NAME_MAPPING_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_ID_NAME_MAPPING_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_ID_NAME_MAPPING_PARAMS._fields_ = [
    ('engineCount', ctypes.c_uint32),
    ('engineID', ctypes.c_uint32 * 200),
    ('engineName', ctypes.c_char * 100 * 200),
]

NV2080_CTRL_GPU_GET_ID_NAME_MAPPING_PARAMS = struct_NV2080_CTRL_GPU_GET_ID_NAME_MAPPING_PARAMS
class struct_NV2080_CTRL_GPU_EXEC_REG_OPS_NOPTRS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_EXEC_REG_OPS_NOPTRS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_EXEC_REG_OPS_NOPTRS_PARAMS._fields_ = [
    ('hClientTarget', ctypes.c_uint32),
    ('hChannelTarget', ctypes.c_uint32),
    ('bNonTransactional', ctypes.c_uint32),
    ('reserved00', ctypes.c_uint32 * 2),
    ('regOpCount', ctypes.c_uint32),
    ('regOps', struct_NV2080_CTRL_GPU_REG_OP * 100),
    ('grRouteInfo', NV2080_CTRL_GR_ROUTE_INFO),
]

NV2080_CTRL_GPU_EXEC_REG_OPS_NOPTRS_PARAMS = struct_NV2080_CTRL_GPU_EXEC_REG_OPS_NOPTRS_PARAMS
class struct_NV2080_CTRL_GPU_P2P_PEER_CAPS_PEER_INFO(Structure):
    pass

struct_NV2080_CTRL_GPU_P2P_PEER_CAPS_PEER_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_P2P_PEER_CAPS_PEER_INFO._fields_ = [
    ('gpuId', ctypes.c_uint32),
    ('gpuUuid', ctypes.c_ubyte * 16),
    ('p2pCaps', ctypes.c_uint32),
    ('p2pOptimalReadCEs', ctypes.c_uint32),
    ('p2pOptimalWriteCEs', ctypes.c_uint32),
    ('p2pCapsStatus', ctypes.c_ubyte * 9),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('busPeerId', ctypes.c_uint32),
]

NV2080_CTRL_GPU_P2P_PEER_CAPS_PEER_INFO = struct_NV2080_CTRL_GPU_P2P_PEER_CAPS_PEER_INFO
class struct_NV2080_CTRL_GET_P2P_CAPS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GET_P2P_CAPS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GET_P2P_CAPS_PARAMS._fields_ = [
    ('bAllCaps', ctypes.c_ubyte),
    ('bUseUuid', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 2),
    ('peerGpuCount', ctypes.c_uint32),
    ('peerGpuCaps', struct_NV2080_CTRL_GPU_P2P_PEER_CAPS_PEER_INFO * 32),
]

NV2080_CTRL_GET_P2P_CAPS_PARAMS = struct_NV2080_CTRL_GET_P2P_CAPS_PARAMS
class struct_NV2080_CTRL_GPU_COMPUTE_PROFILE(Structure):
    pass

struct_NV2080_CTRL_GPU_COMPUTE_PROFILE._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_COMPUTE_PROFILE._fields_ = [
    ('computeSize', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('gfxGpcCount', ctypes.c_uint32),
    ('gpcCount', ctypes.c_uint32),
    ('veidCount', ctypes.c_uint32),
    ('smCount', ctypes.c_uint32),
]

NV2080_CTRL_GPU_COMPUTE_PROFILE = struct_NV2080_CTRL_GPU_COMPUTE_PROFILE
class struct_NV2080_CTRL_GPU_GET_COMPUTE_PROFILES_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_COMPUTE_PROFILES_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_COMPUTE_PROFILES_PARAMS._fields_ = [
    ('profileCount', ctypes.c_uint32),
    ('profiles', struct_NV2080_CTRL_GPU_COMPUTE_PROFILE * 6),
]

NV2080_CTRL_GPU_GET_COMPUTE_PROFILES_PARAMS = struct_NV2080_CTRL_GPU_GET_COMPUTE_PROFILES_PARAMS
class struct_NV2080_CTRL_CMD_GET_GPU_FABRIC_PROBE_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_GET_GPU_FABRIC_PROBE_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_GET_GPU_FABRIC_PROBE_INFO_PARAMS._fields_ = [
    ('state', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('status', ctypes.c_uint32),
    ('clusterUuid', ctypes.c_ubyte * 16),
    ('fabricPartitionId', ctypes.c_uint16),
    ('PADDING_1', ctypes.c_ubyte * 6),
    ('fabricCaps', ctypes.c_uint64),
    ('fabricCliqueId', ctypes.c_uint32),
    ('fabricHealthMask', ctypes.c_uint32),
]

NV2080_CTRL_CMD_GET_GPU_FABRIC_PROBE_INFO_PARAMS = struct_NV2080_CTRL_CMD_GET_GPU_FABRIC_PROBE_INFO_PARAMS
class struct_NV2080_CTRL_GPU_GET_CHIP_DETAILS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_CHIP_DETAILS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_CHIP_DETAILS_PARAMS._fields_ = [
    ('pciDevId', ctypes.c_uint32),
    ('chipSku', ctypes.c_ubyte * 4),
    ('chipMajor', ctypes.c_uint32),
    ('chipMinor', ctypes.c_uint32),
]

NV2080_CTRL_GPU_GET_CHIP_DETAILS_PARAMS = struct_NV2080_CTRL_GPU_GET_CHIP_DETAILS_PARAMS
class struct_NV2080_CTRL_GPU_MOVE_RUNLISTS_ALLOCATION_TO_SUBHEAP_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_MOVE_RUNLISTS_ALLOCATION_TO_SUBHEAP_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_MOVE_RUNLISTS_ALLOCATION_TO_SUBHEAP_PARAMS._fields_ = [
    ('swizzId', ctypes.c_uint32),
]

NV2080_CTRL_GPU_MOVE_RUNLISTS_ALLOCATION_TO_SUBHEAP_PARAMS = struct_NV2080_CTRL_GPU_MOVE_RUNLISTS_ALLOCATION_TO_SUBHEAP_PARAMS
class struct_NV2080_CTRL_GPU_MIGRATABLE_OPS_CMN_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_MIGRATABLE_OPS_CMN_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_MIGRATABLE_OPS_CMN_PARAMS._fields_ = [
    ('hClientTarget', ctypes.c_uint32),
    ('hChannelTarget', ctypes.c_uint32),
    ('bNonTransactional', ctypes.c_uint32),
    ('regOpCount', ctypes.c_uint32),
    ('smIds', ctypes.c_uint32 * 50),
    ('regOps', struct_NV2080_CTRL_GPU_REG_OP * 50),
    ('grRouteInfo', NV2080_CTRL_GR_ROUTE_INFO),
]

NV2080_CTRL_GPU_MIGRATABLE_OPS_CMN_PARAMS = struct_NV2080_CTRL_GPU_MIGRATABLE_OPS_CMN_PARAMS
NV2080_CTRL_GPU_MIGRATABLE_OPS_PARAMS = struct_NV2080_CTRL_GPU_MIGRATABLE_OPS_CMN_PARAMS
NV2080_CTRL_GPU_MIGRATABLE_OPS_GSP_PARAMS = struct_NV2080_CTRL_GPU_MIGRATABLE_OPS_CMN_PARAMS
NV2080_CTRL_GPU_MIGRATABLE_OPS_VGPU_PARAMS = struct_NV2080_CTRL_GPU_MIGRATABLE_OPS_CMN_PARAMS
class struct_NV2080_CTRL_GPU_GET_RESET_STATUS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_RESET_STATUS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_RESET_STATUS_PARAMS._fields_ = [
    ('bResetRequired', ctypes.c_ubyte),
]

NV2080_CTRL_GPU_GET_RESET_STATUS_PARAMS = struct_NV2080_CTRL_GPU_GET_RESET_STATUS_PARAMS
class struct_NV2080_CTRL_GPU_GET_DRAIN_AND_RESET_STATUS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_DRAIN_AND_RESET_STATUS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_DRAIN_AND_RESET_STATUS_PARAMS._fields_ = [
    ('bDrainRecommended', ctypes.c_ubyte),
]

NV2080_CTRL_GPU_GET_DRAIN_AND_RESET_STATUS_PARAMS = struct_NV2080_CTRL_GPU_GET_DRAIN_AND_RESET_STATUS_PARAMS
class struct_NV2080_CTRL_GPU_GET_NVENC_SW_SESSION_INFO_V2_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_NVENC_SW_SESSION_INFO_V2_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_NVENC_SW_SESSION_INFO_V2_PARAMS._fields_ = [
    ('sessionInfoTblEntry', ctypes.c_uint32),
    ('sessionInfoTbl', struct_NV2080_CTRL_NVENC_SW_SESSION_INFO * 512),
]

NV2080_CTRL_GPU_GET_NVENC_SW_SESSION_INFO_V2_PARAMS = struct_NV2080_CTRL_GPU_GET_NVENC_SW_SESSION_INFO_V2_PARAMS
class struct_NV2080_CTRL_GPU_CONSTRUCTED_FALCON_INFO(Structure):
    pass

struct_NV2080_CTRL_GPU_CONSTRUCTED_FALCON_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_CONSTRUCTED_FALCON_INFO._fields_ = [
    ('engDesc', ctypes.c_uint32),
    ('ctxAttr', ctypes.c_uint32),
    ('ctxBufferSize', ctypes.c_uint32),
    ('addrSpaceList', ctypes.c_uint32),
    ('registerBase', ctypes.c_uint32),
]

NV2080_CTRL_GPU_CONSTRUCTED_FALCON_INFO = struct_NV2080_CTRL_GPU_CONSTRUCTED_FALCON_INFO
class struct_NV2080_CTRL_GPU_GET_CONSTRUCTED_FALCON_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_CONSTRUCTED_FALCON_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_CONSTRUCTED_FALCON_INFO_PARAMS._fields_ = [
    ('numConstructedFalcons', ctypes.c_uint32),
    ('constructedFalconsTable', struct_NV2080_CTRL_GPU_CONSTRUCTED_FALCON_INFO * 64),
]

NV2080_CTRL_GPU_GET_CONSTRUCTED_FALCON_INFO_PARAMS = struct_NV2080_CTRL_GPU_GET_CONSTRUCTED_FALCON_INFO_PARAMS
class struct_NV2080_CTRL_GPU_GET_FIPS_STATUS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GPU_GET_FIPS_STATUS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GPU_GET_FIPS_STATUS_PARAMS._fields_ = [
    ('bFipsEnabled', ctypes.c_ubyte),
]

NV2080_CTRL_GPU_GET_FIPS_STATUS_PARAMS = struct_NV2080_CTRL_GPU_GET_FIPS_STATUS_PARAMS
class struct_NV0000_CTRL_VGPU_GET_START_DATA_PARAMS(Structure):
    pass

struct_NV0000_CTRL_VGPU_GET_START_DATA_PARAMS._pack_ = 1 # source:False
struct_NV0000_CTRL_VGPU_GET_START_DATA_PARAMS._fields_ = [
    ('mdevUuid', ctypes.c_ubyte * 16),
    ('configParams', ctypes.c_ubyte * 1024),
    ('qemuPid', ctypes.c_uint32),
    ('gpuPciId', ctypes.c_uint32),
    ('vgpuId', ctypes.c_uint16),
    ('PADDING_0', ctypes.c_ubyte * 2),
    ('gpuPciBdf', ctypes.c_uint32),
]

NV0000_CTRL_VGPU_GET_START_DATA_PARAMS = struct_NV0000_CTRL_VGPU_GET_START_DATA_PARAMS
NV0080_CTRL_CMD_BIF_RESET = (0x800102) # macro
NV0080_CTRL_BIF_RESET_PARAMS_MESSAGE_ID = (0x2) # macro
NV0080_CTRL_BIF_RESET_FLAGS_TYPE = ['4', ':', '0'] # macro
NV0080_CTRL_BIF_RESET_FLAGS_TYPE_SW_RESET = 0x1 # macro
NV0080_CTRL_BIF_RESET_FLAGS_TYPE_SBR = 0x2 # macro
NV0080_CTRL_BIF_RESET_FLAGS_TYPE_FUNDAMENTAL = 0x3 # macro
NV0080_CTRL_BIF_RESET_FLAGS_TYPE_BOOT_DEVICE_FUSE = 0x4 # macro
NV0080_CTRL_BIF_RESET_FLAGS_TYPE_BOOT_DEVICE = 0x5 # macro
NV0080_CTRL_BIF_RESET_FLAGS_TYPE_PEX = 0x6 # macro
NV0080_CTRL_BIF_RESET_FLAGS_TYPE_OOBHUB_TRIGGER = 0x7 # macro
NV0080_CTRL_BIF_RESET_FLAGS_TYPE_BASE = 0x8 # macro
NV0080_CTRL_CMD_BIF_GET_DMA_BASE_SYSMEM_ADDR = (0x800103) # macro
NV0080_CTRL_BIF_GET_DMA_BASE_SYSMEM_ADDR_PARAMS_MESSAGE_ID = (0x3) # macro
NV0080_CTRL_CMD_BIF_SET_ASPM_FEATURE = (0x800104) # macro
NV0080_CTRL_BIF_SET_ASPM_FEATURE_PARAMS_MESSAGE_ID = (0x4) # macro
NV0080_CTRL_BIF_ASPM_FEATURE_DT_L0S = ['0', ':', '0'] # macro
NV0080_CTRL_BIF_ASPM_FEATURE_DT_L0S_ENABLED = 0x000000001 # macro
NV0080_CTRL_BIF_ASPM_FEATURE_DT_L0S_DISABLED = 0x000000000 # macro
NV0080_CTRL_BIF_ASPM_FEATURE_DT_L1 = ['1', ':', '1'] # macro
NV0080_CTRL_BIF_ASPM_FEATURE_DT_L1_ENABLED = 0x000000001 # macro
NV0080_CTRL_BIF_ASPM_FEATURE_DT_L1_DISABLED = 0x000000000 # macro
NV0080_CTRL_CMD_BIF_ASPM_CYA_UPDATE = (0x800105) # macro
NV0080_CTRL_BIF_ASPM_CYA_UPDATE_PARAMS_MESSAGE_ID = (0x5) # macro
NV0080_CTRL_CMD_BIF_GET_PCIE_POWER_CONTROL_MASK = (0x800106) # macro
NV0080_CTRL_CMD_BIF_GET_PCIE_POWER_CONTROL_MASK_PARAMS_MESSAGE_ID = (0x6) # macro
class struct_NV0080_CTRL_BIF_RESET_PARAMS(Structure):
    pass

struct_NV0080_CTRL_BIF_RESET_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_BIF_RESET_PARAMS._fields_ = [
    ('flags', ctypes.c_uint32),
]

NV0080_CTRL_BIF_RESET_PARAMS = struct_NV0080_CTRL_BIF_RESET_PARAMS
class struct_NV0080_CTRL_BIF_GET_DMA_BASE_SYSMEM_ADDR_PARAMS(Structure):
    pass

struct_NV0080_CTRL_BIF_GET_DMA_BASE_SYSMEM_ADDR_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_BIF_GET_DMA_BASE_SYSMEM_ADDR_PARAMS._fields_ = [
    ('baseDmaSysmemAddr', ctypes.c_uint64),
]

NV0080_CTRL_BIF_GET_DMA_BASE_SYSMEM_ADDR_PARAMS = struct_NV0080_CTRL_BIF_GET_DMA_BASE_SYSMEM_ADDR_PARAMS
class struct_NV0080_CTRL_BIF_SET_ASPM_FEATURE_PARAMS(Structure):
    pass

struct_NV0080_CTRL_BIF_SET_ASPM_FEATURE_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_BIF_SET_ASPM_FEATURE_PARAMS._fields_ = [
    ('aspmFeatureSupported', ctypes.c_uint32),
]

NV0080_CTRL_BIF_SET_ASPM_FEATURE_PARAMS = struct_NV0080_CTRL_BIF_SET_ASPM_FEATURE_PARAMS
class struct_NV0080_CTRL_BIF_ASPM_CYA_UPDATE_PARAMS(Structure):
    pass

struct_NV0080_CTRL_BIF_ASPM_CYA_UPDATE_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_BIF_ASPM_CYA_UPDATE_PARAMS._fields_ = [
    ('bL0sEnable', ctypes.c_ubyte),
    ('bL1Enable', ctypes.c_ubyte),
]

NV0080_CTRL_BIF_ASPM_CYA_UPDATE_PARAMS = struct_NV0080_CTRL_BIF_ASPM_CYA_UPDATE_PARAMS
class struct_NV0080_CTRL_CMD_BIF_GET_PCIE_POWER_CONTROL_MASK_PARAMS(Structure):
    pass

struct_NV0080_CTRL_CMD_BIF_GET_PCIE_POWER_CONTROL_MASK_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_CMD_BIF_GET_PCIE_POWER_CONTROL_MASK_PARAMS._fields_ = [
    ('pciePowerControlMask', ctypes.c_uint32),
    ('pciePowerControlIdentifiedKeyOrder', ctypes.c_uint32),
    ('pciePowerControlIdentifiedKeyLocation', ctypes.c_uint32),
]

NV0080_CTRL_CMD_BIF_GET_PCIE_POWER_CONTROL_MASK_PARAMS = struct_NV0080_CTRL_CMD_BIF_GET_PCIE_POWER_CONTROL_MASK_PARAMS
NV0080_CTRL_CMD_BSP_GET_CAPS = (0x801c01) # macro
NV0080_CTRL_BSP_GET_CAPS_PARAMS_MESSAGE_ID = (0x1) # macro
NV0080_CTRL_BSP_CAPS_TBL_SIZE = 8 # macro
NV0080_CTRL_CMD_BSP_GET_CAPS_V2 = (0x801c02) # macro
NV0080_CTRL_BSP_GET_CAPS_PARAMS_V2_MESSAGE_ID = (0x2) # macro
class struct_NV0080_CTRL_BSP_GET_CAPS_PARAMS(Structure):
    pass

struct_NV0080_CTRL_BSP_GET_CAPS_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_BSP_GET_CAPS_PARAMS._fields_ = [
    ('capsTblSize', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('capsTbl', ctypes.POINTER(None)),
    ('instanceId', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

NV0080_CTRL_BSP_GET_CAPS_PARAMS = struct_NV0080_CTRL_BSP_GET_CAPS_PARAMS
class struct_NV0080_CTRL_BSP_GET_CAPS_PARAMS_V2(Structure):
    pass

struct_NV0080_CTRL_BSP_GET_CAPS_PARAMS_V2._pack_ = 1 # source:False
struct_NV0080_CTRL_BSP_GET_CAPS_PARAMS_V2._fields_ = [
    ('capsTbl', ctypes.c_ubyte * 8),
    ('instanceId', ctypes.c_uint32),
]

NV0080_CTRL_BSP_GET_CAPS_PARAMS_V2 = struct_NV0080_CTRL_BSP_GET_CAPS_PARAMS_V2
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_VALID = ['0', ':', '0'] # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_VALID_FALSE = (0x00000000) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_VALID_TRUE = (0x00000001) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_ENCRYPTED = ['2', ':', '1'] # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_ENCRYPTED_FALSE = (0x00000000) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_ENCRYPTED_TRUE = (0x00000001) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_ENCRYPTED_NOT_SUPPORTED = (0x00000002) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_APERTURE = ['6', ':', '3'] # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_APERTURE_VIDEO_MEMORY = (0x00000000) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_APERTURE_PEER_MEMORY = (0x00000001) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_APERTURE_SYSTEM_COHERENT_MEMORY = (0x00000002) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_APERTURE_SYSTEM_NON_COHERENT_MEMORY = (0x00000003) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_COMPTAGS = ['10', ':', '7'] # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_COMPTAGS_NONE = (0x00000000) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_COMPTAGS_1 = (0x00000001) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_COMPTAGS_2 = (0x00000002) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_COMPTAGS_4 = (0x00000004) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_GPU_CACHED = ['12', ':', '11'] # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_GPU_CACHED_FALSE = (0x00000000) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_GPU_CACHED_TRUE = (0x00000001) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_GPU_CACHED_NOT_SUPPORTED = (0x00000002) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_SHADER_ACCESS = ['14', ':', '13'] # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_SHADER_ACCESS_READ_WRITE = (0x00000000) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_SHADER_ACCESS_READ_ONLY = (0x00000001) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_SHADER_ACCESS_WRITE_ONLY = (0x00000002) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_SHADER_ACCESS_NOT_SUPPORTED = (0x00000003) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_READ_ONLY = ['15', ':', '15'] # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_READ_ONLY_FALSE = (0x00000000) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_READ_ONLY_TRUE = (0x00000001) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_ATOMIC = ['16', ':', '16'] # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_ATOMIC_DISABLE = (0x00000000) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_ATOMIC_ENABLE = (0x00000001) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_ACCESS_COUNTING = ['17', ':', '17'] # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_ACCESS_COUNTING_DISABLE = (0x00000000) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_ACCESS_COUNTING_ENABLE = (0x00000001) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_PRIVILEGED = ['18', ':', '18'] # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_PRIVILEGED_FALSE = (0x00000000) # macro
NV0080_CTRL_DMA_PTE_INFO_PARAMS_FLAGS_PRIVILEGED_TRUE = (0x00000001) # macro
NV0080_CTRL_CMD_DMA_GET_PTE_INFO = (0x801801) # macro
NV0080_CTRL_DMA_GET_PTE_INFO_PTE_BLOCKS = 5 # macro
NV0080_CTRL_DMA_GET_PTE_INFO_PARAMS_MESSAGE_ID = (0x1) # macro
NV0080_CTRL_CMD_DMA_SET_PTE_INFO = (0x80180a) # macro
NV0080_CTRL_DMA_SET_PTE_INFO_PTE_BLOCKS = 5 # macro
NV0080_CTRL_DMA_SET_PTE_INFO_PARAMS_MESSAGE_ID = (0xA) # macro
NV0080_CTRL_CMD_DMA_FILL_PTE_MEM = (0x801802) # macro
NV0080_CTRL_DMA_FILL_PTE_MEM_PARAMS_MESSAGE_ID = (0x2) # macro
NV0080_CTRL_CMD_DMA_FLUSH = (0x801805) # macro
NV0080_CTRL_DMA_FLUSH_PARAMS_MESSAGE_ID = (0x5) # macro
NV0080_CTRL_DMA_FLUSH_TARGET_UNIT_L2 = ['0', ':', '0'] # macro
NV0080_CTRL_DMA_FLUSH_TARGET_UNIT_L2_DISABLE = (0x00000000) # macro
NV0080_CTRL_DMA_FLUSH_TARGET_UNIT_L2_ENABLE = (0x00000001) # macro
NV0080_CTRL_DMA_FLUSH_TARGET_UNIT_COMPTAG = ['1', ':', '1'] # macro
NV0080_CTRL_DMA_FLUSH_TARGET_UNIT_COMPTAG_DISABLE = (0x00000000) # macro
NV0080_CTRL_DMA_FLUSH_TARGET_UNIT_COMPTAG_ENABLE = (0x00000001) # macro
NV0080_CTRL_DMA_FLUSH_TARGET_UNIT_FB = ['2', ':', '2'] # macro
NV0080_CTRL_DMA_FLUSH_TARGET_UNIT_FB_DISABLE = (0x00000000) # macro
NV0080_CTRL_DMA_FLUSH_TARGET_UNIT_FB_ENABLE = (0x00000001) # macro
NV0080_CTRL_DMA_FLUSH_TARGET_UNIT_L2_INVALIDATE = ['4', ':', '3'] # macro
NV0080_CTRL_DMA_FLUSH_TARGET_UNIT_L2_INVALIDATE_SYSMEM = (0x00000001) # macro
NV0080_CTRL_DMA_FLUSH_TARGET_UNIT_L2_INVALIDATE_PEERMEM = (0x00000002) # macro
NV0080_CTRL_CMD_DMA_ADV_SCHED_GET_VA_CAPS = (0x801806) # macro
NV0080_CTRL_DMA_ADV_SCHED_GET_VA_CAPS_MAX_NUM_PAGE_TABLE_FORMATS = (16) # macro
NV0080_CTRL_DMA_ADV_SCHED_GET_VA_CAPS_PARAMS_MESSAGE_ID = (0x6) # macro
NV0080_CTRL_CMD_DMA_ADV_SCHED_GET_VA_CAPS_WITH_VA_RANGE_LO = 0x1 # macro
NV0080_CTRL_CMD_DMA_GET_PDE_INFO = (0x801809) # macro
NV0080_CTRL_DMA_GET_PDE_INFO_PARAMS_PTE_ADDR_SPACE_VIDEO_MEMORY = (0x00000000) # macro
NV0080_CTRL_DMA_GET_PDE_INFO_PARAMS_PTE_ADDR_SPACE_SYSTEM_COHERENT_MEMORY = (0x00000001) # macro
NV0080_CTRL_DMA_GET_PDE_INFO_PARAMS_PTE_ADDR_SPACE_SYSTEM_NON_COHERENT_MEMORY = (0x00000002) # macro
NV0080_CTRL_DMA_PDE_INFO_PTE_BLOCKS = 5 # macro
NV0080_CTRL_DMA_GET_PDE_INFO_PARAMS_MESSAGE_ID = (0x9) # macro
NV0080_CTRL_DMA_GET_PDE_INFO_PARAMS_PDE_ADDR_SPACE_VIDEO_MEMORY = (0x00000000) # macro
NV0080_CTRL_DMA_GET_PDE_INFO_PARAMS_PDE_ADDR_SPACE_SYSTEM_COHERENT_MEMORY = (0x00000001) # macro
NV0080_CTRL_DMA_GET_PDE_INFO_PARAMS_PDE_ADDR_SPACE_SYSTEM_NON_COHERENT_MEMORY = (0x00000002) # macro
NV0080_CTRL_DMA_GET_PDE_INFO_PARAMS_PDE_SIZE_FULL = 1 # macro
NV0080_CTRL_DMA_GET_PDE_INFO_PARAMS_PDE_SIZE_HALF = 2 # macro
NV0080_CTRL_DMA_GET_PDE_INFO_PARAMS_PDE_SIZE_QUARTER = 3 # macro
NV0080_CTRL_DMA_GET_PDE_INFO_PARAMS_PDE_SIZE_EIGHTH = 4 # macro
NV0080_CTRL_CMD_DMA_INVALIDATE_TLB = (0x80180c) # macro
NV0080_CTRL_DMA_INVALIDATE_TLB_PARAMS_MESSAGE_ID = (0xC) # macro
NV0080_CTRL_DMA_INVALIDATE_TLB_ALL = ['0', ':', '0'] # macro
NV0080_CTRL_DMA_INVALIDATE_TLB_ALL_FALSE = (0x00000000) # macro
NV0080_CTRL_DMA_INVALIDATE_TLB_ALL_TRUE = (0x00000001) # macro
NV0080_CTRL_CMD_DMA_GET_CAPS = (0x80180d) # macro
NV0080_CTRL_DMA_CAPS_TBL_SIZE = 8 # macro
NV0080_CTRL_DMA_GET_CAPS_PARAMS_MESSAGE_ID = (0xD) # macro
# def NV0080_CTRL_DMA_GET_CAP(tbl, c):  # macro
#    return (((NvU8)tbl[(1?c)])&(0?c))
NV0080_CTRL_DMA_CAPS_32BIT_POINTER_ENFORCED = ['0', ':', '0x01'] # macro
NV0080_CTRL_DMA_CAPS_SHADER_ACCESS_SUPPORTED = ['0', ':', '0x04'] # macro
NV0080_CTRL_DMA_CAPS_SPARSE_VIRTUAL_SUPPORTED = ['0', ':', '0x08'] # macro
NV0080_CTRL_DMA_CAPS_MULTIPLE_VA_SPACES_SUPPORTED = ['0', ':', '0x10'] # macro
NV0080_CTRL_CMD_DMA_SET_VA_SPACE_SIZE = (0x80180e) # macro
NV0080_CTRL_DMA_SET_VA_SPACE_SIZE_PARAMS_MESSAGE_ID = (0xE) # macro
NV0080_CTRL_DMA_SET_VA_SPACE_SIZE_MAX = (0xFFFFFFFFFFFFFFFF) # macro
NV0080_CTRL_CMD_DMA_UPDATE_PDE_2 = (0x80180f) # macro
NV0080_CTRL_DMA_UPDATE_PDE_2_PT_APERTURE_INVALID = (0x00000000) # macro
NV0080_CTRL_DMA_UPDATE_PDE_2_PT_APERTURE_VIDEO_MEMORY = (0x00000001) # macro
NV0080_CTRL_DMA_UPDATE_PDE_2_PT_APERTURE_SYSTEM_COHERENT_MEMORY = (0x00000002) # macro
NV0080_CTRL_DMA_UPDATE_PDE_2_PT_APERTURE_SYSTEM_NON_COHERENT_MEMORY = (0x00000003) # macro
NV0080_CTRL_DMA_UPDATE_PDE_2_PT_IDX_SMALL = 0 # macro
NV0080_CTRL_DMA_UPDATE_PDE_2_PT_IDX_BIG = 1 # macro
NV0080_CTRL_DMA_UPDATE_PDE_2_PT_IDX__SIZE = 2 # macro
NV0080_CTRL_DMA_UPDATE_PDE_2_PARAMS_MESSAGE_ID = (0xF) # macro
NV0080_CTRL_DMA_UPDATE_PDE_2_FLAGS_FLUSH_PDE_CACHE = ['0', ':', '0'] # macro
NV0080_CTRL_DMA_UPDATE_PDE_2_FLAGS_FLUSH_PDE_CACHE_FALSE = (0x00000000) # macro
NV0080_CTRL_DMA_UPDATE_PDE_2_FLAGS_FLUSH_PDE_CACHE_TRUE = (0x00000001) # macro
NV0080_CTRL_DMA_UPDATE_PDE_2_FLAGS_FORCE_OVERRIDE = ['1', ':', '1'] # macro
NV0080_CTRL_DMA_UPDATE_PDE_2_FLAGS_FORCE_OVERRIDE_FALSE = (0x00000000) # macro
NV0080_CTRL_DMA_UPDATE_PDE_2_FLAGS_FORCE_OVERRIDE_TRUE = (0x00000001) # macro
NV0080_CTRL_DMA_UPDATE_PDE_2_FLAGS_PDE_SIZE = ['3', ':', '2'] # macro
NV0080_CTRL_DMA_UPDATE_PDE_2_FLAGS_PDE_SIZE_FULL = (0x00000000) # macro
NV0080_CTRL_DMA_UPDATE_PDE_2_FLAGS_PDE_SIZE_HALF = (0x00000001) # macro
NV0080_CTRL_DMA_UPDATE_PDE_2_FLAGS_PDE_SIZE_QUARTER = (0x00000002) # macro
NV0080_CTRL_DMA_UPDATE_PDE_2_FLAGS_PDE_SIZE_EIGHTH = (0x00000003) # macro
NV0080_CTRL_DMA_UPDATE_PDE_2_FLAGS_SPARSE = ['4', ':', '4'] # macro
NV0080_CTRL_DMA_UPDATE_PDE_2_FLAGS_SPARSE_FALSE = (0x00000000) # macro
NV0080_CTRL_DMA_UPDATE_PDE_2_FLAGS_SPARSE_TRUE = (0x00000001) # macro
NV0080_CTRL_DMA_ENABLE_PRIVILEGED_RANGE = (0x801810) # macro
NV0080_CTRL_DMA_ENABLE_PRIVILEGED_RANGE_PARAMS_MESSAGE_ID = (0x10) # macro
NV0080_CTRL_DMA_SET_DEFAULT_VASPACE = (0x801812) # macro
NV0080_CTRL_DMA_SET_DEFAULT_VASPACE_PARAMS_MESSAGE_ID = (0x12) # macro
NV0080_CTRL_CMD_DMA_SET_PAGE_DIRECTORY = (0x801813) # macro
NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_PARAMS_MESSAGE_ID = (0x13) # macro
NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_FLAGS_APERTURE = ['1', ':', '0'] # macro
NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_FLAGS_APERTURE_VIDMEM = (0x00000000) # macro
NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_FLAGS_APERTURE_SYSMEM_COH = (0x00000001) # macro
NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_FLAGS_APERTURE_SYSMEM_NONCOH = (0x00000002) # macro
NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_FLAGS_PRESERVE_PDES = ['2', ':', '2'] # macro
NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_FLAGS_PRESERVE_PDES_FALSE = (0x00000000) # macro
NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_FLAGS_PRESERVE_PDES_TRUE = (0x00000001) # macro
NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_FLAGS_ALL_CHANNELS = ['3', ':', '3'] # macro
NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_FLAGS_ALL_CHANNELS_FALSE = (0x00000000) # macro
NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_FLAGS_ALL_CHANNELS_TRUE = (0x00000001) # macro
NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_FLAGS_IGNORE_CHANNEL_BUSY = ['4', ':', '4'] # macro
NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_FLAGS_IGNORE_CHANNEL_BUSY_FALSE = (0x00000000) # macro
NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_FLAGS_IGNORE_CHANNEL_BUSY_TRUE = (0x00000001) # macro
NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_FLAGS_EXTEND_VASPACE = ['5', ':', '5'] # macro
NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_FLAGS_EXTEND_VASPACE_FALSE = (0x00000000) # macro
NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_FLAGS_EXTEND_VASPACE_TRUE = (0x00000001) # macro
NV0080_CTRL_CMD_DMA_UNSET_PAGE_DIRECTORY = (0x801814) # macro
NV0080_CTRL_DMA_UNSET_PAGE_DIRECTORY_PARAMS_MESSAGE_ID = (0x14) # macro
class struct_NV0080_CTRL_DMA_PTE_INFO_PTE_BLOCK(Structure):
    pass

struct_NV0080_CTRL_DMA_PTE_INFO_PTE_BLOCK._pack_ = 1 # source:False
struct_NV0080_CTRL_DMA_PTE_INFO_PTE_BLOCK._fields_ = [
    ('pageSize', ctypes.c_uint64),
    ('pteEntrySize', ctypes.c_uint64),
    ('comptagLine', ctypes.c_uint32),
    ('kind', ctypes.c_uint32),
    ('pteFlags', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NV0080_CTRL_DMA_PTE_INFO_PTE_BLOCK = struct_NV0080_CTRL_DMA_PTE_INFO_PTE_BLOCK
class struct_NV0080_CTRL_DMA_GET_PTE_INFO_PARAMS(Structure):
    pass

struct_NV0080_CTRL_DMA_GET_PTE_INFO_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_DMA_GET_PTE_INFO_PARAMS._fields_ = [
    ('gpuAddr', ctypes.c_uint64),
    ('subDeviceId', ctypes.c_uint32),
    ('skipVASpaceInit', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('pteBlocks', struct_NV0080_CTRL_DMA_PTE_INFO_PTE_BLOCK * 5),
    ('hVASpace', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

NV0080_CTRL_DMA_GET_PTE_INFO_PARAMS = struct_NV0080_CTRL_DMA_GET_PTE_INFO_PARAMS
class struct_NV0080_CTRL_DMA_SET_PTE_INFO_PARAMS(Structure):
    pass

struct_NV0080_CTRL_DMA_SET_PTE_INFO_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_DMA_SET_PTE_INFO_PARAMS._fields_ = [
    ('gpuAddr', ctypes.c_uint64),
    ('subDeviceId', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('pteBlocks', struct_NV0080_CTRL_DMA_PTE_INFO_PTE_BLOCK * 5),
    ('hVASpace', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

NV0080_CTRL_DMA_SET_PTE_INFO_PARAMS = struct_NV0080_CTRL_DMA_SET_PTE_INFO_PARAMS
class struct_NV0080_CTRL_DMA_FILL_PTE_MEM_PARAMS(Structure):
    pass

class struct_NV0080_CTRL_DMA_FILL_PTE_MEM_PARAMS_hwResource(Structure):
    pass

struct_NV0080_CTRL_DMA_FILL_PTE_MEM_PARAMS_hwResource._pack_ = 1 # source:False
struct_NV0080_CTRL_DMA_FILL_PTE_MEM_PARAMS_hwResource._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hDevice', ctypes.c_uint32),
    ('hMemory', ctypes.c_uint32),
    ('subDeviceId', ctypes.c_uint32),
]

class struct_NV0080_CTRL_DMA_FILL_PTE_MEM_PARAMS_comprInfo(Structure):
    pass

struct_NV0080_CTRL_DMA_FILL_PTE_MEM_PARAMS_comprInfo._pack_ = 1 # source:False
struct_NV0080_CTRL_DMA_FILL_PTE_MEM_PARAMS_comprInfo._fields_ = [
    ('fbKind', ctypes.c_uint32),
    ('sysKind', ctypes.c_uint32),
    ('compTagStartOffset', ctypes.c_uint32),
]

struct_NV0080_CTRL_DMA_FILL_PTE_MEM_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_DMA_FILL_PTE_MEM_PARAMS._fields_ = [
    ('pageCount', ctypes.c_uint32),
    ('hwResource', struct_NV0080_CTRL_DMA_FILL_PTE_MEM_PARAMS_hwResource),
    ('comprInfo', struct_NV0080_CTRL_DMA_FILL_PTE_MEM_PARAMS_comprInfo),
    ('offset', ctypes.c_uint64),
    ('gpuAddr', ctypes.c_uint64),
    ('pageArray', ctypes.POINTER(None)),
    ('pteMem', ctypes.POINTER(None)),
    ('pteMemPfn', ctypes.c_uint32),
    ('pageSize', ctypes.c_uint32),
    ('startPageIndex', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('hSrcVASpace', ctypes.c_uint32),
    ('hTgtVASpace', ctypes.c_uint32),
    ('peerId', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NV0080_CTRL_DMA_FILL_PTE_MEM_PARAMS = struct_NV0080_CTRL_DMA_FILL_PTE_MEM_PARAMS
class struct_NV0080_CTRL_DMA_FLUSH_PARAMS(Structure):
    pass

struct_NV0080_CTRL_DMA_FLUSH_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_DMA_FLUSH_PARAMS._fields_ = [
    ('targetUnit', ctypes.c_uint32),
]

NV0080_CTRL_DMA_FLUSH_PARAMS = struct_NV0080_CTRL_DMA_FLUSH_PARAMS
class struct_NV0080_CTRL_DMA_ADV_SCHED_GET_VA_CAPS_PAGE_TABLE_FORMAT(Structure):
    pass

struct_NV0080_CTRL_DMA_ADV_SCHED_GET_VA_CAPS_PAGE_TABLE_FORMAT._pack_ = 1 # source:False
struct_NV0080_CTRL_DMA_ADV_SCHED_GET_VA_CAPS_PAGE_TABLE_FORMAT._fields_ = [
    ('pageTableSize', ctypes.c_uint32),
    ('pageTableCoverage', ctypes.c_uint32),
]

NV0080_CTRL_DMA_ADV_SCHED_GET_VA_CAPS_PAGE_TABLE_FORMAT = struct_NV0080_CTRL_DMA_ADV_SCHED_GET_VA_CAPS_PAGE_TABLE_FORMAT
class struct_NV0080_CTRL_DMA_ADV_SCHED_GET_VA_CAPS_PARAMS(Structure):
    pass

struct_NV0080_CTRL_DMA_ADV_SCHED_GET_VA_CAPS_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_DMA_ADV_SCHED_GET_VA_CAPS_PARAMS._fields_ = [
    ('vaBitCount', ctypes.c_uint32),
    ('pdeCoverageBitCount', ctypes.c_uint32),
    ('num4KPageTableFormats', ctypes.c_uint32),
    ('bigPageSize', ctypes.c_uint32),
    ('compressionPageSize', ctypes.c_uint32),
    ('dualPageTableSupported', ctypes.c_uint32),
    ('idealVRAMPageSize', ctypes.c_uint32),
    ('pageTableBigFormat', NV0080_CTRL_DMA_ADV_SCHED_GET_VA_CAPS_PAGE_TABLE_FORMAT),
    ('pageTable4KFormat', struct_NV0080_CTRL_DMA_ADV_SCHED_GET_VA_CAPS_PAGE_TABLE_FORMAT * 16),
    ('hVASpace', ctypes.c_uint32),
    ('vaRangeLo', ctypes.c_uint64),
    ('vaSpaceId', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('supportedPageSizeMask', ctypes.c_uint64),
]

NV0080_CTRL_DMA_ADV_SCHED_GET_VA_CAPS_PARAMS = struct_NV0080_CTRL_DMA_ADV_SCHED_GET_VA_CAPS_PARAMS
class struct_NV0080_CTRL_DMA_PDE_INFO_PTE_BLOCK(Structure):
    pass

struct_NV0080_CTRL_DMA_PDE_INFO_PTE_BLOCK._pack_ = 1 # source:False
struct_NV0080_CTRL_DMA_PDE_INFO_PTE_BLOCK._fields_ = [
    ('ptePhysAddr', ctypes.c_uint64),
    ('pteCacheAttrib', ctypes.c_uint32),
    ('pteEntrySize', ctypes.c_uint32),
    ('pageSize', ctypes.c_uint32),
    ('pteAddrSpace', ctypes.c_uint32),
    ('pdeVASpaceSize', ctypes.c_uint32),
    ('pdeFlags', ctypes.c_uint32),
]

NV0080_CTRL_DMA_PDE_INFO_PTE_BLOCK = struct_NV0080_CTRL_DMA_PDE_INFO_PTE_BLOCK
class struct_NV0080_CTRL_DMA_GET_PDE_INFO_PARAMS(Structure):
    pass

struct_NV0080_CTRL_DMA_GET_PDE_INFO_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_DMA_GET_PDE_INFO_PARAMS._fields_ = [
    ('gpuAddr', ctypes.c_uint64),
    ('pdeVirtAddr', ctypes.c_uint64),
    ('pdeEntrySize', ctypes.c_uint32),
    ('pdeAddrSpace', ctypes.c_uint32),
    ('pdeSize', ctypes.c_uint32),
    ('subDeviceId', ctypes.c_uint32),
    ('pteBlocks', struct_NV0080_CTRL_DMA_PDE_INFO_PTE_BLOCK * 5),
    ('pdbAddr', ctypes.c_uint64),
    ('hVASpace', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NV0080_CTRL_DMA_GET_PDE_INFO_PARAMS = struct_NV0080_CTRL_DMA_GET_PDE_INFO_PARAMS
class struct_NV0080_CTRL_DMA_INVALIDATE_TLB_PARAMS(Structure):
    pass

struct_NV0080_CTRL_DMA_INVALIDATE_TLB_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_DMA_INVALIDATE_TLB_PARAMS._fields_ = [
    ('hVASpace', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
]

NV0080_CTRL_DMA_INVALIDATE_TLB_PARAMS = struct_NV0080_CTRL_DMA_INVALIDATE_TLB_PARAMS
class struct_NV0080_CTRL_DMA_GET_CAPS_PARAMS(Structure):
    pass

struct_NV0080_CTRL_DMA_GET_CAPS_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_DMA_GET_CAPS_PARAMS._fields_ = [
    ('capsTblSize', ctypes.c_uint32),
    ('capsTbl', ctypes.c_ubyte * 8),
]

NV0080_CTRL_DMA_GET_CAPS_PARAMS = struct_NV0080_CTRL_DMA_GET_CAPS_PARAMS
class struct_NV0080_CTRL_DMA_SET_VA_SPACE_SIZE_PARAMS(Structure):
    pass

struct_NV0080_CTRL_DMA_SET_VA_SPACE_SIZE_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_DMA_SET_VA_SPACE_SIZE_PARAMS._fields_ = [
    ('vaSpaceSize', ctypes.c_uint64),
    ('hVASpace', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NV0080_CTRL_DMA_SET_VA_SPACE_SIZE_PARAMS = struct_NV0080_CTRL_DMA_SET_VA_SPACE_SIZE_PARAMS
class struct_NV0080_CTRL_DMA_UPDATE_PDE_2_PAGE_TABLE_PARAMS(Structure):
    pass

struct_NV0080_CTRL_DMA_UPDATE_PDE_2_PAGE_TABLE_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_DMA_UPDATE_PDE_2_PAGE_TABLE_PARAMS._fields_ = [
    ('physAddr', ctypes.c_uint64),
    ('numEntries', ctypes.c_uint32),
    ('aperture', ctypes.c_uint32),
]

NV0080_CTRL_DMA_UPDATE_PDE_2_PAGE_TABLE_PARAMS = struct_NV0080_CTRL_DMA_UPDATE_PDE_2_PAGE_TABLE_PARAMS
class struct_NV0080_CTRL_DMA_UPDATE_PDE_2_PARAMS(Structure):
    pass

struct_NV0080_CTRL_DMA_UPDATE_PDE_2_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_DMA_UPDATE_PDE_2_PARAMS._fields_ = [
    ('pdeIndex', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('ptParams', struct_NV0080_CTRL_DMA_UPDATE_PDE_2_PAGE_TABLE_PARAMS * 2),
    ('hVASpace', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('pPdeBuffer', ctypes.POINTER(None)),
    ('subDeviceId', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

NV0080_CTRL_DMA_UPDATE_PDE_2_PARAMS = struct_NV0080_CTRL_DMA_UPDATE_PDE_2_PARAMS
class struct_NV0080_CTRL_DMA_ENABLE_PRIVILEGED_RANGE_PARAMS(Structure):
    pass

struct_NV0080_CTRL_DMA_ENABLE_PRIVILEGED_RANGE_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_DMA_ENABLE_PRIVILEGED_RANGE_PARAMS._fields_ = [
    ('hVASpace', ctypes.c_uint32),
]

NV0080_CTRL_DMA_ENABLE_PRIVILEGED_RANGE_PARAMS = struct_NV0080_CTRL_DMA_ENABLE_PRIVILEGED_RANGE_PARAMS
class struct_NV0080_CTRL_DMA_SET_DEFAULT_VASPACE_PARAMS(Structure):
    pass

struct_NV0080_CTRL_DMA_SET_DEFAULT_VASPACE_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_DMA_SET_DEFAULT_VASPACE_PARAMS._fields_ = [
    ('hVASpace', ctypes.c_uint32),
]

NV0080_CTRL_DMA_SET_DEFAULT_VASPACE_PARAMS = struct_NV0080_CTRL_DMA_SET_DEFAULT_VASPACE_PARAMS
class struct_NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_PARAMS(Structure):
    pass

struct_NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_PARAMS._fields_ = [
    ('physAddress', ctypes.c_uint64),
    ('numEntries', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('hVASpace', ctypes.c_uint32),
    ('chId', ctypes.c_uint32),
    ('subDeviceId', ctypes.c_uint32),
    ('pasid', ctypes.c_uint32),
]

NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_PARAMS = struct_NV0080_CTRL_DMA_SET_PAGE_DIRECTORY_PARAMS
class struct_NV0080_CTRL_DMA_UNSET_PAGE_DIRECTORY_PARAMS(Structure):
    pass

struct_NV0080_CTRL_DMA_UNSET_PAGE_DIRECTORY_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_DMA_UNSET_PAGE_DIRECTORY_PARAMS._fields_ = [
    ('hVASpace', ctypes.c_uint32),
    ('subDeviceId', ctypes.c_uint32),
]

NV0080_CTRL_DMA_UNSET_PAGE_DIRECTORY_PARAMS = struct_NV0080_CTRL_DMA_UNSET_PAGE_DIRECTORY_PARAMS
NV0080_CTRL_CMD_FB_GET_CAPS = (0x801301) # macro
NV0080_CTRL_FB_GET_CAPS_PARAMS_MESSAGE_ID = (0x1) # macro
# def NV0080_CTRL_FB_GET_CAP(tbl, c):  # macro
#    return (((NvU8)tbl[(1?c)])&(0?c))
NV0080_CTRL_FB_CAPS_SUPPORT_RENDER_TO_SYSMEM = ['0', ':', '0x01'] # macro
NV0080_CTRL_FB_CAPS_BLOCKLINEAR = ['0', ':', '0x02'] # macro
NV0080_CTRL_FB_CAPS_SUPPORT_SCANOUT_FROM_SYSMEM = ['0', ':', '0x04'] # macro
NV0080_CTRL_FB_CAPS_SUPPORT_CACHED_SYSMEM = ['0', ':', '0x08'] # macro
NV0080_CTRL_FB_CAPS_SUPPORT_C24_COMPRESSION = ['0', ':', '0x10'] # macro
NV0080_CTRL_FB_CAPS_SUPPORT_SYSMEM_COMPRESSION = ['0', ':', '0x20'] # macro
NV0080_CTRL_FB_CAPS_NISO_CFG0_BUG_534680 = ['0', ':', '0x40'] # macro
NV0080_CTRL_FB_CAPS_ISO_FETCH_ALIGN_BUG_561630 = ['0', ':', '0x80'] # macro
NV0080_CTRL_FB_CAPS_BLOCKLINEAR_GOBS_512 = ['1', ':', '0x01'] # macro
NV0080_CTRL_FB_CAPS_L2_TAG_BUG_632241 = ['1', ':', '0x02'] # macro
NV0080_CTRL_FB_CAPS_SINGLE_FB_UNIT = ['1', ':', '0x04'] # macro
NV0080_CTRL_FB_CAPS_CE_RMW_DISABLE_BUG_897745 = ['1', ':', '0x08'] # macro
NV0080_CTRL_FB_CAPS_OS_OWNS_HEAP_NEED_ECC_SCRUB = ['1', ':', '0x10'] # macro
NV0080_CTRL_FB_CAPS_ASYNC_CE_L2_BYPASS_SET = ['1', ':', '0x20'] # macro
NV0080_CTRL_FB_CAPS_DISABLE_TILED_CACHING_INVALIDATES_WITH_ECC_BUG_1521641 = ['1', ':', '0x40'] # macro
NV0080_CTRL_FB_CAPS_GENERIC_PAGE_KIND = ['1', ':', '0x80'] # macro
NV0080_CTRL_FB_CAPS_DISABLE_MSCG_WITH_VR_BUG_1681803 = ['2', ':', '0x01'] # macro
NV0080_CTRL_FB_CAPS_VIDMEM_ALLOCS_ARE_CLEARED = ['2', ':', '0x02'] # macro
NV0080_CTRL_FB_CAPS_DISABLE_PLC_GLOBALLY = ['2', ':', '0x04'] # macro
NV0080_CTRL_FB_CAPS_PLC_BUG_3046774 = ['2', ':', '0x08'] # macro
NV0080_CTRL_FB_CAPS_TBL_SIZE = 3 # macro
NV0080_CTRL_CMD_FB_GET_COMPBIT_STORE_INFO = (0x801306) # macro
NV0080_CTRL_FB_GET_COMPBIT_STORE_INFO_PARAMS_MESSAGE_ID = (0x6) # macro
NV0080_CTRL_CMD_FB_GET_COMPBIT_STORE_INFO_ADDRESS_SPACE_UNKNOWN = 0 # macro
NV0080_CTRL_CMD_FB_GET_COMPBIT_STORE_INFO_ADDRESS_SPACE_SYSMEM = 1 # macro
NV0080_CTRL_CMD_FB_GET_COMPBIT_STORE_INFO_ADDRESS_SPACE_FBMEM = 2 # macro
NV0080_CTRL_CMD_FB_GET_COMPBIT_STORE_INFO_POLICY_LEGACY = 0 # macro
NV0080_CTRL_CMD_FB_GET_COMPBIT_STORE_INFO_POLICY_1TO1 = 1 # macro
NV0080_CTRL_CMD_FB_GET_COMPBIT_STORE_INFO_POLICY_1TO4 = 2 # macro
NV0080_CTRL_CMD_FB_GET_COMPBIT_STORE_INFO_POLICY_RAWMODE = 3 # macro
NV0080_CTRL_CMD_FB_GET_CAPS_V2 = (0x801307) # macro
NV0080_CTRL_FB_GET_CAPS_V2_PARAMS_MESSAGE_ID = (0x7) # macro
NV0080_CTRL_CMD_FB_SET_DEFAULT_VIDMEM_PHYSICALITY = (0x801308) # macro
NV0080_CTRL_FB_SET_DEFAULT_VIDMEM_PHYSICALITY_PARAMS_MESSAGE_ID = (0x8) # macro
class struct_NV0080_CTRL_FB_GET_CAPS_PARAMS(Structure):
    pass

struct_NV0080_CTRL_FB_GET_CAPS_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_FB_GET_CAPS_PARAMS._fields_ = [
    ('capsTblSize', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('capsTbl', ctypes.POINTER(None)),
]

NV0080_CTRL_FB_GET_CAPS_PARAMS = struct_NV0080_CTRL_FB_GET_CAPS_PARAMS
class struct_NV0080_CTRL_FB_GET_COMPBIT_STORE_INFO_PARAMS(Structure):
    pass

struct_NV0080_CTRL_FB_GET_COMPBIT_STORE_INFO_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_FB_GET_COMPBIT_STORE_INFO_PARAMS._fields_ = [
    ('Size', ctypes.c_uint64),
    ('Address', ctypes.c_uint64),
    ('AddressSpace', ctypes.c_uint32),
    ('MaxCompbitLine', ctypes.c_uint32),
    ('comptagsPerCacheLine', ctypes.c_uint32),
    ('cacheLineSize', ctypes.c_uint32),
    ('cacheLineSizePerSlice', ctypes.c_uint32),
    ('cacheLineFetchAlignment', ctypes.c_uint32),
    ('backingStoreBase', ctypes.c_uint64),
    ('gobsPerComptagPerSlice', ctypes.c_uint32),
    ('backingStoreCbcBase', ctypes.c_uint32),
    ('comptaglineAllocationPolicy', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('privRegionStartOffset', ctypes.c_uint64),
    ('cbcCoveragePerSlice', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

NV0080_CTRL_FB_GET_COMPBIT_STORE_INFO_PARAMS = struct_NV0080_CTRL_FB_GET_COMPBIT_STORE_INFO_PARAMS
class struct_NV0080_CTRL_FB_GET_CAPS_V2_PARAMS(Structure):
    pass

struct_NV0080_CTRL_FB_GET_CAPS_V2_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_FB_GET_CAPS_V2_PARAMS._fields_ = [
    ('capsTbl', ctypes.c_ubyte * 3),
]

NV0080_CTRL_FB_GET_CAPS_V2_PARAMS = struct_NV0080_CTRL_FB_GET_CAPS_V2_PARAMS
class struct_NV0080_CTRL_FB_SET_DEFAULT_VIDMEM_PHYSICALITY_PARAMS(Structure):
    pass

struct_NV0080_CTRL_FB_SET_DEFAULT_VIDMEM_PHYSICALITY_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_FB_SET_DEFAULT_VIDMEM_PHYSICALITY_PARAMS._fields_ = [
    ('value', ctypes.c_uint32),
]

NV0080_CTRL_FB_SET_DEFAULT_VIDMEM_PHYSICALITY_PARAMS = struct_NV0080_CTRL_FB_SET_DEFAULT_VIDMEM_PHYSICALITY_PARAMS

# values for enumeration 'NV0080_CTRL_FB_DEFAULT_VIDMEM_PHYSICALITY'
NV0080_CTRL_FB_DEFAULT_VIDMEM_PHYSICALITY__enumvalues = {
    0: 'NV0080_CTRL_FB_DEFAULT_VIDMEM_PHYSICALITY_DEFAULT',
    1: 'NV0080_CTRL_FB_DEFAULT_VIDMEM_PHYSICALITY_NONCONTIGUOUS',
    2: 'NV0080_CTRL_FB_DEFAULT_VIDMEM_PHYSICALITY_CONTIGUOUS',
    3: 'NV0080_CTRL_FB_DEFAULT_VIDMEM_PHYSICALITY_ALLOW_NONCONTIGUOUS',
}
NV0080_CTRL_FB_DEFAULT_VIDMEM_PHYSICALITY_DEFAULT = 0
NV0080_CTRL_FB_DEFAULT_VIDMEM_PHYSICALITY_NONCONTIGUOUS = 1
NV0080_CTRL_FB_DEFAULT_VIDMEM_PHYSICALITY_CONTIGUOUS = 2
NV0080_CTRL_FB_DEFAULT_VIDMEM_PHYSICALITY_ALLOW_NONCONTIGUOUS = 3
NV0080_CTRL_FB_DEFAULT_VIDMEM_PHYSICALITY = ctypes.c_uint32 # enum
NV0080_CTRL_CMD_FIFO_GET_CAPS = (0x801701) # macro
NV0080_CTRL_FIFO_GET_CAPS_PARAMS_MESSAGE_ID = (0x1) # macro
# def NV0080_CTRL_FIFO_GET_CAP(tbl, c):  # macro
#    return (((NvU8)tbl[(1?c)])&(0?c))
NV0080_CTRL_FIFO_CAPS_SUPPORT_SCHED_EVENT = ['0', ':', '0x01'] # macro
NV0080_CTRL_FIFO_CAPS_SUPPORT_PCI_PB = ['0', ':', '0x02'] # macro
NV0080_CTRL_FIFO_CAPS_SUPPORT_VID_PB = ['0', ':', '0x04'] # macro
NV0080_CTRL_FIFO_CAPS_USERD_IN_SYSMEM = ['0', ':', '0x40'] # macro
NV0080_CTRL_FIFO_CAPS_NO_PIPELINED_PTE_BLIT = ['0', ':', '0x80'] # macro
NV0080_CTRL_FIFO_CAPS_GPU_MAP_CHANNEL = ['1', ':', '0x01'] # macro
NV0080_CTRL_FIFO_CAPS_BUFFEREDMODE_SCHEDULING = ['1', ':', '0x02'] # macro
NV0080_CTRL_FIFO_CAPS_WFI_BUG_898467 = ['1', ':', '0x08'] # macro
NV0080_CTRL_FIFO_CAPS_HAS_HOST_LB_OVERFLOW_BUG_1667921 = ['1', ':', '0x10'] # macro
NV0080_CTRL_FIFO_CAPS_MULTI_VAS_PER_CHANGRP = ['1', ':', '0x20'] # macro
NV0080_CTRL_FIFO_CAPS_SUPPORT_WDDM_INTERLEAVING = ['1', ':', '0x40'] # macro
NV0080_CTRL_FIFO_CAPS_TBL_SIZE = 2 # macro
NV0080_CTRL_CMD_FIFO_START_SELECTED_CHANNELS = (0x801705) # macro
NV0080_CTRL_FIFO_START_SELECTED_CHANNELS_PARAMS_MESSAGE_ID = (0x5) # macro
NV0080_CTRL_FIFO_ENGINE_ID_GRAPHICS = (0x00000000) # macro
NV0080_CTRL_FIFO_ENGINE_ID_MPEG = (0x00000001) # macro
NV0080_CTRL_FIFO_ENGINE_ID_MOTION_ESTIMATION = (0x00000002) # macro
NV0080_CTRL_FIFO_ENGINE_ID_VIDEO = (0x00000003) # macro
NV0080_CTRL_FIFO_ENGINE_ID_BITSTREAM = (0x00000004) # macro
NV0080_CTRL_FIFO_ENGINE_ID_ENCRYPTION = (0x00000005) # macro
NV0080_CTRL_FIFO_ENGINE_ID_FGT = (0x00000006) # macro
NV0080_CTRL_CMD_FIFO_GET_ENGINE_CONTEXT_PROPERTIES = (0x801707) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID = ['4', ':', '0'] # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS = (0x00000000) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_VLD = (0x00000001) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_VIDEO = (0x00000002) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_MPEG = (0x00000003) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_CAPTURE = (0x00000004) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_DISPLAY = (0x00000005) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_ENCRYPTION = (0x00000006) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_POSTPROCESS = (0x00000007) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_ZCULL = (0x00000008) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_PM = (0x00000009) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_COMPUTE_PREEMPT = (0x0000000a) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_PREEMPT = (0x0000000b) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_SPILL = (0x0000000c) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_PAGEPOOL = (0x0000000d) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_BETACB = (0x0000000e) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_RTV = (0x0000000f) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_PATCH = (0x00000010) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_BUNDLE_CB = (0x00000011) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_PAGEPOOL_GLOBAL = (0x00000012) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_ATTRIBUTE_CB = (0x00000013) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_RTV_CB_GLOBAL = (0x00000014) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_GFXP_POOL = (0x00000015) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_GFXP_CTRL_BLK = (0x00000016) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_FECS_EVENT = (0x00000017) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_PRIV_ACCESS_MAP = (0x00000018) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_GRAPHICS_SETUP = (0x00000019) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_COUNT = (0x0000001a) # macro
NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_PARAMS_MESSAGE_ID = (0x7) # macro
NV0080_CTRL_CMD_FIFO_RUNLIST_GROUP_CHANNELS = (0x801709) # macro
NV0080_CTRL_FIFO_RUNLIST_GROUP_MAX_CHANNELS = (8) # macro
NV0080_CTRL_CMD_FIFO_RUNLIST_DIVIDE_TIMESLICE = (0x80170b) # macro
NV0080_CTRL_FIFO_RUNLIST_MAX_TIMESLICE_DIVISOR = (12) # macro
NV0080_CTRL_CMD_FIFO_PREEMPT_RUNLIST = (0x80170c) # macro
NV0080_CTRL_CMD_FIFO_GET_CHANNELLIST = (0x80170d) # macro
NV0080_CTRL_FIFO_GET_CHANNELLIST_PARAMS_MESSAGE_ID = (0xD) # macro
NV0080_CTRL_CMD_FIFO_GET_LATENCY_BUFFER_SIZE = (0x80170e) # macro
NV0080_CTRL_FIFO_GET_LATENCY_BUFFER_SIZE_PARAMS_MESSAGE_ID = (0xE) # macro
NV0080_CTRL_FIFO_GET_CHANNELLIST_INVALID_CHANNEL = (0xffffffff) # macro
NV0080_CTRL_CMD_FIFO_SET_CHANNEL_PROPERTIES = (0x80170f) # macro
NV0080_CTRL_FIFO_SET_CHANNEL_PROPERTIES_PARAMS_MESSAGE_ID = (0xF) # macro
NV0080_CTRL_FIFO_SET_CHANNEL_PROPERTIES_ENGINETIMESLICEINMICROSECONDS = (0x00000000) # macro
NV0080_CTRL_FIFO_SET_CHANNEL_PROPERTIES_PBDMATIMESLICEINMICROSECONDS = (0x00000001) # macro
NV0080_CTRL_FIFO_SET_CHANNEL_PROPERTIES_ENGINETIMESLICEDISABLE = (0x00000002) # macro
NV0080_CTRL_FIFO_SET_CHANNEL_PROPERTIES_PBDMATIMESLICEDISABLE = (0x00000003) # macro
NV0080_CTRL_FIFO_SET_CHANNEL_PROPERTIES_INVALIDATE_PDB_TARGET = (0x00000004) # macro
NV0080_CTRL_FIFO_SET_CHANNEL_PROPERTIES_RESETENGINECONTEXT = (0x00000005) # macro
NV0080_CTRL_FIFO_SET_CHANNEL_PROPERTIES_NOOP = (0x00000007) # macro
NV0080_CTRL_FIFO_SET_CHANNEL_PROPERTIES_RESETENGINECONTEXT_NOPREEMPT = (0x00000008) # macro
NV0080_CTRL_CMD_FIFO_STOP_RUNLIST = (0x801711) # macro
NV0080_CTRL_FIFO_STOP_RUNLIST_PARAMS_MESSAGE_ID = (0x11) # macro
NV0080_CTRL_CMD_FIFO_START_RUNLIST = (0x801712) # macro
NV0080_CTRL_FIFO_START_RUNLIST_PARAMS_MESSAGE_ID = (0x12) # macro
NV0080_CTRL_CMD_FIFO_GET_CAPS_V2 = (0x801713) # macro
NV0080_CTRL_FIFO_GET_CAPS_V2_PARAMS_MESSAGE_ID = (0x13) # macro
NV0080_CTRL_CMD_FIFO_IDLE_CHANNELS = (0x801714) # macro
NV0080_CTRL_CMD_FIFO_IDLE_CHANNELS_MAX_CHANNELS = 4096 # macro
NV0080_CTRL_FIFO_IDLE_CHANNELS_PARAMS_MESSAGE_ID = (0x14) # macro
class struct_NV0080_CTRL_FIFO_GET_CAPS_PARAMS(Structure):
    pass

struct_NV0080_CTRL_FIFO_GET_CAPS_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_FIFO_GET_CAPS_PARAMS._fields_ = [
    ('capsTblSize', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('capsTbl', ctypes.POINTER(None)),
]

NV0080_CTRL_FIFO_GET_CAPS_PARAMS = struct_NV0080_CTRL_FIFO_GET_CAPS_PARAMS
class struct_NV0080_CTRL_FIFO_CHANNEL(Structure):
    pass

struct_NV0080_CTRL_FIFO_CHANNEL._pack_ = 1 # source:False
struct_NV0080_CTRL_FIFO_CHANNEL._fields_ = [
    ('hChannel', ctypes.c_uint32),
]

NV0080_CTRL_FIFO_CHANNEL = struct_NV0080_CTRL_FIFO_CHANNEL
class struct_NV0080_CTRL_FIFO_START_SELECTED_CHANNELS_PARAMS(Structure):
    pass

struct_NV0080_CTRL_FIFO_START_SELECTED_CHANNELS_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_FIFO_START_SELECTED_CHANNELS_PARAMS._fields_ = [
    ('fifoStartChannelListCount', ctypes.c_uint32),
    ('channelHandle', ctypes.c_uint32 * 8),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('fifoStartChannelList', ctypes.POINTER(None)),
]

NV0080_CTRL_FIFO_START_SELECTED_CHANNELS_PARAMS = struct_NV0080_CTRL_FIFO_START_SELECTED_CHANNELS_PARAMS
class struct_NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_PARAMS(Structure):
    pass

struct_NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_PARAMS._fields_ = [
    ('engineId', ctypes.c_uint32),
    ('alignment', ctypes.c_uint32),
    ('size', ctypes.c_uint32),
]

NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_PARAMS = struct_NV0080_CTRL_FIFO_GET_ENGINE_CONTEXT_PROPERTIES_PARAMS
class struct_NV0080_CTRL_FIFO_RUNLIST_GROUP_CHANNELS_PARAM(Structure):
    pass

struct_NV0080_CTRL_FIFO_RUNLIST_GROUP_CHANNELS_PARAM._pack_ = 1 # source:False
struct_NV0080_CTRL_FIFO_RUNLIST_GROUP_CHANNELS_PARAM._fields_ = [
    ('hChannel1', ctypes.c_uint32),
    ('hChannel2', ctypes.c_uint32),
]

NV0080_CTRL_FIFO_RUNLIST_GROUP_CHANNELS_PARAM = struct_NV0080_CTRL_FIFO_RUNLIST_GROUP_CHANNELS_PARAM
class struct_NV0080_CTRL_FIFO_RUNLIST_DIVIDE_TIMESLICE_PARAM(Structure):
    pass

struct_NV0080_CTRL_FIFO_RUNLIST_DIVIDE_TIMESLICE_PARAM._pack_ = 1 # source:False
struct_NV0080_CTRL_FIFO_RUNLIST_DIVIDE_TIMESLICE_PARAM._fields_ = [
    ('hChannel', ctypes.c_uint32),
    ('tsDivisor', ctypes.c_uint32),
]

NV0080_CTRL_FIFO_RUNLIST_DIVIDE_TIMESLICE_PARAM = struct_NV0080_CTRL_FIFO_RUNLIST_DIVIDE_TIMESLICE_PARAM
class struct_NV0080_CTRL_FIFO_PREEMPT_RUNLIST_PARAMS(Structure):
    pass

struct_NV0080_CTRL_FIFO_PREEMPT_RUNLIST_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_FIFO_PREEMPT_RUNLIST_PARAMS._fields_ = [
    ('hRunlist', ctypes.c_uint32),
    ('engineID', ctypes.c_uint32),
]

NV0080_CTRL_FIFO_PREEMPT_RUNLIST_PARAMS = struct_NV0080_CTRL_FIFO_PREEMPT_RUNLIST_PARAMS
class struct_NV0080_CTRL_FIFO_GET_CHANNELLIST_PARAMS(Structure):
    pass

struct_NV0080_CTRL_FIFO_GET_CHANNELLIST_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_FIFO_GET_CHANNELLIST_PARAMS._fields_ = [
    ('numChannels', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('pChannelHandleList', ctypes.POINTER(None)),
    ('pChannelList', ctypes.POINTER(None)),
]

NV0080_CTRL_FIFO_GET_CHANNELLIST_PARAMS = struct_NV0080_CTRL_FIFO_GET_CHANNELLIST_PARAMS
class struct_NV0080_CTRL_FIFO_GET_LATENCY_BUFFER_SIZE_PARAMS(Structure):
    pass

struct_NV0080_CTRL_FIFO_GET_LATENCY_BUFFER_SIZE_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_FIFO_GET_LATENCY_BUFFER_SIZE_PARAMS._fields_ = [
    ('engineID', ctypes.c_uint32),
    ('gpEntries', ctypes.c_uint32),
    ('pbEntries', ctypes.c_uint32),
]

NV0080_CTRL_FIFO_GET_LATENCY_BUFFER_SIZE_PARAMS = struct_NV0080_CTRL_FIFO_GET_LATENCY_BUFFER_SIZE_PARAMS
class struct_NV0080_CTRL_FIFO_SET_CHANNEL_PROPERTIES_PARAMS(Structure):
    pass

struct_NV0080_CTRL_FIFO_SET_CHANNEL_PROPERTIES_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_FIFO_SET_CHANNEL_PROPERTIES_PARAMS._fields_ = [
    ('hChannel', ctypes.c_uint32),
    ('property', ctypes.c_uint32),
    ('value', ctypes.c_uint64),
]

NV0080_CTRL_FIFO_SET_CHANNEL_PROPERTIES_PARAMS = struct_NV0080_CTRL_FIFO_SET_CHANNEL_PROPERTIES_PARAMS
class struct_NV0080_CTRL_FIFO_STOP_RUNLIST_PARAMS(Structure):
    pass

struct_NV0080_CTRL_FIFO_STOP_RUNLIST_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_FIFO_STOP_RUNLIST_PARAMS._fields_ = [
    ('engineID', ctypes.c_uint32),
]

NV0080_CTRL_FIFO_STOP_RUNLIST_PARAMS = struct_NV0080_CTRL_FIFO_STOP_RUNLIST_PARAMS
class struct_NV0080_CTRL_FIFO_START_RUNLIST_PARAMS(Structure):
    pass

struct_NV0080_CTRL_FIFO_START_RUNLIST_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_FIFO_START_RUNLIST_PARAMS._fields_ = [
    ('engineID', ctypes.c_uint32),
]

NV0080_CTRL_FIFO_START_RUNLIST_PARAMS = struct_NV0080_CTRL_FIFO_START_RUNLIST_PARAMS
class struct_NV0080_CTRL_FIFO_GET_CAPS_V2_PARAMS(Structure):
    pass

struct_NV0080_CTRL_FIFO_GET_CAPS_V2_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_FIFO_GET_CAPS_V2_PARAMS._fields_ = [
    ('capsTbl', ctypes.c_ubyte * 2),
]

NV0080_CTRL_FIFO_GET_CAPS_V2_PARAMS = struct_NV0080_CTRL_FIFO_GET_CAPS_V2_PARAMS
class struct_NV0080_CTRL_FIFO_IDLE_CHANNELS_PARAMS(Structure):
    pass

struct_NV0080_CTRL_FIFO_IDLE_CHANNELS_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_FIFO_IDLE_CHANNELS_PARAMS._fields_ = [
    ('numChannels', ctypes.c_uint32),
    ('hChannels', ctypes.c_uint32 * 4096),
    ('flags', ctypes.c_uint32),
    ('timeout', ctypes.c_uint32),
]

NV0080_CTRL_FIFO_IDLE_CHANNELS_PARAMS = struct_NV0080_CTRL_FIFO_IDLE_CHANNELS_PARAMS
NV0080_CTRL_CMD_GPU_GET_CLASSLIST = (0x800201) # macro
NV0080_CTRL_GPU_GET_CLASSLIST_PARAMS_MESSAGE_ID = (0x1) # macro
NV0080_CTRL_CMD_GPU_GET_NUM_SUBDEVICES = (0x800280) # macro
NV0080_CTRL_GPU_GET_NUM_SUBDEVICES_PARAMS_MESSAGE_ID = (0x80) # macro
NV0080_CTRL_CMD_GPU_GET_VIDLINK_ORDER = (0x800281) # macro
NV0080_CTRL_GPU_GET_VIDLINK_ORDER_PARAMS_MESSAGE_ID = (0x81) # macro
NV0080_CTRL_CMD_GPU_SET_DISPLAY_OWNER = (0x800282) # macro
NV0080_CTRL_GPU_SET_DISPLAY_OWNER_PARAMS_MESSAGE_ID = (0x82) # macro
NV0080_CTRL_CMD_GPU_GET_DISPLAY_OWNER = (0x800283) # macro
NV0080_CTRL_GPU_GET_DISPLAY_OWNER_PARAMS_MESSAGE_ID = (0x83) # macro
NV0080_CTRL_CMD_GPU_SET_VIDLINK = (0x800285) # macro
NV0080_CTRL_GPU_SET_VIDLINK_PARAMS_MESSAGE_ID = (0x85) # macro
NV0080_CTRL_GPU_SET_VIDLINK_ENABLE_FALSE = (0x00000000) # macro
NV0080_CTRL_GPU_SET_VIDLINK_ENABLE_TRUE = (0x00000001) # macro
NV0080_CTRL_CMD_GPU_VIDEO_POWERGATE_GET_STATUS = 0 # macro
NV0080_CTRL_CMD_GPU_VIDEO_POWERGATE_POWERDOWN = 1 # macro
NV0080_CTRL_CMD_GPU_VIDEO_POWERGATE_POWERUP = 2 # macro
NV0080_CTRL_CMD_GPU_VIDEO_POWERGATE_STATUS_POWER_ON = 0 # macro
NV0080_CTRL_CMD_GPU_VIDEO_POWERGATE_STATUS_POWERING_DOWN = 1 # macro
NV0080_CTRL_CMD_GPU_VIDEO_POWERGATE_STATUS_GATED = 2 # macro
NV0080_CTRL_CMD_GPU_VIDEO_POWERGATE_STATUS_POWERING_UP = 3 # macro
NV0080_CTRL_CMD_GPU_MODIFY_SW_STATE_PERSISTENCE = (0x800287) # macro
NV0080_CTRL_GPU_SW_STATE_PERSISTENCE_ENABLED = (0x00000000) # macro
NV0080_CTRL_GPU_SW_STATE_PERSISTENCE_DISABLED = (0x00000001) # macro
NV0080_CTRL_GPU_MODIFY_SW_STATE_PERSISTENCE_PARAMS_MESSAGE_ID = (0x87) # macro
NV0080_CTRL_CMD_GPU_QUERY_SW_STATE_PERSISTENCE = (0x800288) # macro
NV0080_CTRL_GPU_QUERY_SW_STATE_PERSISTENCE_PARAMS_MESSAGE_ID = (0x88) # macro
NV0080_CTRL_CMD_GPU_GET_VIRTUALIZATION_MODE = (0x800289) # macro
NV0080_CTRL_GPU_VIRTUALIZATION_MODE_NONE = (0x00000000) # macro
NV0080_CTRL_GPU_VIRTUALIZATION_MODE_NMOS = (0x00000001) # macro
NV0080_CTRL_GPU_VIRTUALIZATION_MODE_VGX = (0x00000002) # macro
NV0080_CTRL_GPU_VIRTUALIZATION_MODE_HOST = (0x00000003) # macro
NV0080_CTRL_GPU_VIRTUALIZATION_MODE_HOST_VGPU = (0x00000003) # macro
NV0080_CTRL_GPU_VIRTUALIZATION_MODE_HOST_VSGA = (0x00000004) # macro
NV0080_CTRL_GPU_GET_VIRTUALIZATION_MODE_PARAMS_MESSAGE_ID = (0x89) # macro
NV0080_CTRL_CMD_GPU_GET_SPARSE_TEXTURE_COMPUTE_MODE = (0x80028c) # macro
NV0080_CTRL_GPU_GET_SPARSE_TEXTURE_COMPUTE_MODE_PARAMS_MESSAGE_ID = (0x8C) # macro
NV0080_CTRL_CMD_GPU_SET_SPARSE_TEXTURE_COMPUTE_MODE = (0x80028d) # macro
NV0080_CTRL_GPU_SET_SPARSE_TEXTURE_COMPUTE_MODE_PARAMS_MESSAGE_ID = (0x8D) # macro
NV0080_CTRL_GPU_SPARSE_TEXTURE_COMPUTE_MODE_DEFAULT = 0 # macro
NV0080_CTRL_GPU_SPARSE_TEXTURE_COMPUTE_MODE_OPTIMIZE_COMPUTE = 1 # macro
NV0080_CTRL_GPU_SPARSE_TEXTURE_COMPUTE_MODE_OPTIMIZE_SPARSE_TEXTURE = 2 # macro
NV0080_CTRL_CMD_GPU_GET_VGX_CAPS = (0x80028e) # macro
NV0080_CTRL_GPU_GET_VGX_CAPS_PARAMS_MESSAGE_ID = (0x8E) # macro
NV0080_CTRL_CMD_GPU_GET_SRIOV_CAPS = (0x800291) # macro
NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS_MESSAGE_ID = (0x91) # macro
NV0080_CTRL_GPU_CLASSLIST_MAX_SIZE = 174 # macro
NV0080_CTRL_CMD_GPU_GET_CLASSLIST_V2 = (0x800292) # macro
NV0080_CTRL_GPU_GET_CLASSLIST_V2_PARAMS_MESSAGE_ID = (0x92) # macro
NV0080_CTRL_CMD_GPU_FIND_SUBDEVICE_HANDLE = (0x800293) # macro
NV0080_CTRL_GPU_FIND_SUBDEVICE_HANDLE_PARAM_MESSAGE_ID = (0x93) # macro
NV0080_CTRL_GPU_GET_BRAND_CAPS_QUADRO  = (1 << 0) # macro
NV0080_CTRL_GPU_GET_BRAND_CAPS_NVS  = (1 << 1) # macro
NV0080_CTRL_GPU_GET_BRAND_CAPS_TITAN  = (1 << 2) # macro
NV0080_CTRL_CMD_GPU_GET_BRAND_CAPS = (0x800294) # macro
NV0080_CTRL_GPU_GET_BRAND_CAPS_PARAMS_MESSAGE_ID = (0x94) # macro
NV0080_CTRL_GPU_VGPU_VF_BAR1_SIZE_64M = (1<<6) # macro
NV0080_CTRL_GPU_VGPU_VF_BAR1_SIZE_128M = (1<<7) # macro
NV0080_CTRL_GPU_VGPU_VF_BAR1_SIZE_256M = (1<<8) # macro
NV0080_CTRL_GPU_VGPU_VF_BAR1_SIZE_512M = (1<<9) # macro
NV0080_CTRL_GPU_VGPU_VF_BAR1_SIZE_1G = (1<<10) # macro
NV0080_CTRL_GPU_VGPU_VF_BAR1_SIZE_2G = (1<<11) # macro
NV0080_CTRL_GPU_VGPU_VF_BAR1_SIZE_4G = (1<<12) # macro
NV0080_CTRL_GPU_VGPU_VF_BAR1_SIZE_8G = (1<<13) # macro
NV0080_CTRL_GPU_VGPU_VF_BAR1_SIZE_16G = (1<<14) # macro
NV0080_CTRL_GPU_VGPU_VF_BAR1_SIZE_32G = (1<<15) # macro
NV0080_CTRL_GPU_VGPU_VF_BAR1_SIZE_64G = (1<<16) # macro
NV0080_CTRL_GPU_VGPU_VF_BAR1_SIZE_128G = (1<<17) # macro
NV0080_CTRL_GPU_VGPU_VF_BAR1_SIZE_256G = (1<<18) # macro
NV0080_CTRL_GPU_VGPU_VF_BAR1_SIZE_MIN = (1<<6) # macro
NV0080_CTRL_GPU_VGPU_VF_BAR1_SIZE_MAX = (1<<18) # macro
NV0080_CTRL_GPU_VGPU_NUM_VFS_INVALID = 0x0 # macro
NV0080_CTRL_GPU_SET_VGPU_VF_BAR1_SIZE = (0x800296) # macro
NV0080_CTRL_GPU_SET_VGPU_VF_BAR1_SIZE_PARAMS_MESSAGE_ID = (0x96) # macro
NV0080_CTRL_CMD_GPU_SET_VGPU_HETEROGENEOUS_MODE = (0x800297) # macro
NV0080_CTRL_GPU_SET_VGPU_HETEROGENEOUS_MODE_PARAMS_MESSAGE_ID = (0x97) # macro
NV0080_CTRL_CMD_GPU_GET_VGPU_HETEROGENEOUS_MODE = (0x800298) # macro
NV0080_CTRL_GPU_GET_VGPU_HETEROGENEOUS_MODE_PARAMS_MESSAGE_ID = (0x98) # macro
class struct_NV0080_CTRL_GPU_GET_CLASSLIST_PARAMS(Structure):
    pass

struct_NV0080_CTRL_GPU_GET_CLASSLIST_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_GPU_GET_CLASSLIST_PARAMS._fields_ = [
    ('numClasses', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('classList', ctypes.POINTER(None)),
]

NV0080_CTRL_GPU_GET_CLASSLIST_PARAMS = struct_NV0080_CTRL_GPU_GET_CLASSLIST_PARAMS
class struct_NV0080_CTRL_GPU_GET_NUM_SUBDEVICES_PARAMS(Structure):
    pass

struct_NV0080_CTRL_GPU_GET_NUM_SUBDEVICES_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_GPU_GET_NUM_SUBDEVICES_PARAMS._fields_ = [
    ('numSubDevices', ctypes.c_uint32),
]

NV0080_CTRL_GPU_GET_NUM_SUBDEVICES_PARAMS = struct_NV0080_CTRL_GPU_GET_NUM_SUBDEVICES_PARAMS
class struct_NV0080_CTRL_GPU_GET_VIDLINK_ORDER_PARAMS(Structure):
    pass

struct_NV0080_CTRL_GPU_GET_VIDLINK_ORDER_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_GPU_GET_VIDLINK_ORDER_PARAMS._fields_ = [
    ('ConnectionCount', ctypes.c_uint32),
    ('Order', ctypes.c_uint32 * 8),
]

NV0080_CTRL_GPU_GET_VIDLINK_ORDER_PARAMS = struct_NV0080_CTRL_GPU_GET_VIDLINK_ORDER_PARAMS
class struct_NV0080_CTRL_GPU_SET_DISPLAY_OWNER_PARAMS(Structure):
    pass

struct_NV0080_CTRL_GPU_SET_DISPLAY_OWNER_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_GPU_SET_DISPLAY_OWNER_PARAMS._fields_ = [
    ('subDeviceInstance', ctypes.c_uint32),
]

NV0080_CTRL_GPU_SET_DISPLAY_OWNER_PARAMS = struct_NV0080_CTRL_GPU_SET_DISPLAY_OWNER_PARAMS
class struct_NV0080_CTRL_GPU_GET_DISPLAY_OWNER_PARAMS(Structure):
    pass

struct_NV0080_CTRL_GPU_GET_DISPLAY_OWNER_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_GPU_GET_DISPLAY_OWNER_PARAMS._fields_ = [
    ('subDeviceInstance', ctypes.c_uint32),
]

NV0080_CTRL_GPU_GET_DISPLAY_OWNER_PARAMS = struct_NV0080_CTRL_GPU_GET_DISPLAY_OWNER_PARAMS
class struct_NV0080_CTRL_GPU_SET_VIDLINK_PARAMS(Structure):
    pass

struct_NV0080_CTRL_GPU_SET_VIDLINK_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_GPU_SET_VIDLINK_PARAMS._fields_ = [
    ('enable', ctypes.c_uint32),
]

NV0080_CTRL_GPU_SET_VIDLINK_PARAMS = struct_NV0080_CTRL_GPU_SET_VIDLINK_PARAMS
class struct_NV0080_CTRL_GPU_MODIFY_SW_STATE_PERSISTENCE_PARAMS(Structure):
    pass

struct_NV0080_CTRL_GPU_MODIFY_SW_STATE_PERSISTENCE_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_GPU_MODIFY_SW_STATE_PERSISTENCE_PARAMS._fields_ = [
    ('newState', ctypes.c_uint32),
]

NV0080_CTRL_GPU_MODIFY_SW_STATE_PERSISTENCE_PARAMS = struct_NV0080_CTRL_GPU_MODIFY_SW_STATE_PERSISTENCE_PARAMS
class struct_NV0080_CTRL_GPU_QUERY_SW_STATE_PERSISTENCE_PARAMS(Structure):
    pass

struct_NV0080_CTRL_GPU_QUERY_SW_STATE_PERSISTENCE_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_GPU_QUERY_SW_STATE_PERSISTENCE_PARAMS._fields_ = [
    ('swStatePersistence', ctypes.c_uint32),
]

NV0080_CTRL_GPU_QUERY_SW_STATE_PERSISTENCE_PARAMS = struct_NV0080_CTRL_GPU_QUERY_SW_STATE_PERSISTENCE_PARAMS
class struct_NV0080_CTRL_GPU_GET_VIRTUALIZATION_MODE_PARAMS(Structure):
    pass

struct_NV0080_CTRL_GPU_GET_VIRTUALIZATION_MODE_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_GPU_GET_VIRTUALIZATION_MODE_PARAMS._fields_ = [
    ('virtualizationMode', ctypes.c_uint32),
]

NV0080_CTRL_GPU_GET_VIRTUALIZATION_MODE_PARAMS = struct_NV0080_CTRL_GPU_GET_VIRTUALIZATION_MODE_PARAMS
class struct_NV0080_CTRL_GPU_GET_SPARSE_TEXTURE_COMPUTE_MODE_PARAMS(Structure):
    pass

struct_NV0080_CTRL_GPU_GET_SPARSE_TEXTURE_COMPUTE_MODE_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_GPU_GET_SPARSE_TEXTURE_COMPUTE_MODE_PARAMS._fields_ = [
    ('defaultSetting', ctypes.c_uint32),
    ('currentSetting', ctypes.c_uint32),
    ('pendingSetting', ctypes.c_uint32),
]

NV0080_CTRL_GPU_GET_SPARSE_TEXTURE_COMPUTE_MODE_PARAMS = struct_NV0080_CTRL_GPU_GET_SPARSE_TEXTURE_COMPUTE_MODE_PARAMS
class struct_NV0080_CTRL_GPU_SET_SPARSE_TEXTURE_COMPUTE_MODE_PARAMS(Structure):
    pass

struct_NV0080_CTRL_GPU_SET_SPARSE_TEXTURE_COMPUTE_MODE_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_GPU_SET_SPARSE_TEXTURE_COMPUTE_MODE_PARAMS._fields_ = [
    ('setting', ctypes.c_uint32),
]

NV0080_CTRL_GPU_SET_SPARSE_TEXTURE_COMPUTE_MODE_PARAMS = struct_NV0080_CTRL_GPU_SET_SPARSE_TEXTURE_COMPUTE_MODE_PARAMS
class struct_NV0080_CTRL_GPU_GET_VGX_CAPS_PARAMS(Structure):
    pass

struct_NV0080_CTRL_GPU_GET_VGX_CAPS_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_GPU_GET_VGX_CAPS_PARAMS._fields_ = [
    ('isVgx', ctypes.c_ubyte),
]

NV0080_CTRL_GPU_GET_VGX_CAPS_PARAMS = struct_NV0080_CTRL_GPU_GET_VGX_CAPS_PARAMS
class struct_NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS(Structure):
    pass

struct_NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS._fields_ = [
    ('totalVFs', ctypes.c_uint32),
    ('firstVfOffset', ctypes.c_uint32),
    ('vfFeatureMask', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('FirstVFBar0Address', ctypes.c_uint64),
    ('FirstVFBar1Address', ctypes.c_uint64),
    ('FirstVFBar2Address', ctypes.c_uint64),
    ('bar0Size', ctypes.c_uint64),
    ('bar1Size', ctypes.c_uint64),
    ('bar2Size', ctypes.c_uint64),
    ('b64bitBar0', ctypes.c_ubyte),
    ('b64bitBar1', ctypes.c_ubyte),
    ('b64bitBar2', ctypes.c_ubyte),
    ('bSriovEnabled', ctypes.c_ubyte),
    ('bSriovHeavyEnabled', ctypes.c_ubyte),
    ('bEmulateVFBar0TlbInvalidationRegister', ctypes.c_ubyte),
    ('bClientRmAllocatedCtxBuffer', ctypes.c_ubyte),
    ('bNonPowerOf2ChannelCountSupported', ctypes.c_ubyte),
    ('bVfResizableBAR1Supported', ctypes.c_ubyte),
    ('PADDING_1', ctypes.c_ubyte * 7),
]

NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS = struct_NV0080_CTRL_GPU_GET_SRIOV_CAPS_PARAMS
class struct_NV0080_CTRL_GPU_GET_CLASSLIST_V2_PARAMS(Structure):
    pass

struct_NV0080_CTRL_GPU_GET_CLASSLIST_V2_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_GPU_GET_CLASSLIST_V2_PARAMS._fields_ = [
    ('numClasses', ctypes.c_uint32),
    ('classList', ctypes.c_uint32 * 174),
]

NV0080_CTRL_GPU_GET_CLASSLIST_V2_PARAMS = struct_NV0080_CTRL_GPU_GET_CLASSLIST_V2_PARAMS
class struct_NV0080_CTRL_GPU_FIND_SUBDEVICE_HANDLE_PARAM(Structure):
    pass

struct_NV0080_CTRL_GPU_FIND_SUBDEVICE_HANDLE_PARAM._pack_ = 1 # source:False
struct_NV0080_CTRL_GPU_FIND_SUBDEVICE_HANDLE_PARAM._fields_ = [
    ('subDeviceInst', ctypes.c_uint32),
    ('hSubDevice', ctypes.c_uint32),
]

NV0080_CTRL_GPU_FIND_SUBDEVICE_HANDLE_PARAM = struct_NV0080_CTRL_GPU_FIND_SUBDEVICE_HANDLE_PARAM
class struct_NV0080_CTRL_GPU_GET_BRAND_CAPS_PARAMS(Structure):
    pass

struct_NV0080_CTRL_GPU_GET_BRAND_CAPS_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_GPU_GET_BRAND_CAPS_PARAMS._fields_ = [
    ('brands', ctypes.c_uint32),
]

NV0080_CTRL_GPU_GET_BRAND_CAPS_PARAMS = struct_NV0080_CTRL_GPU_GET_BRAND_CAPS_PARAMS
class struct_NV0080_CTRL_GPU_SET_VGPU_VF_BAR1_SIZE_PARAMS(Structure):
    pass

struct_NV0080_CTRL_GPU_SET_VGPU_VF_BAR1_SIZE_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_GPU_SET_VGPU_VF_BAR1_SIZE_PARAMS._fields_ = [
    ('vfBar1SizeMB', ctypes.c_uint32),
    ('numVfs', ctypes.c_uint32),
]

NV0080_CTRL_GPU_SET_VGPU_VF_BAR1_SIZE_PARAMS = struct_NV0080_CTRL_GPU_SET_VGPU_VF_BAR1_SIZE_PARAMS
class struct_NV0080_CTRL_GPU_SET_VGPU_HETEROGENEOUS_MODE_PARAMS(Structure):
    pass

struct_NV0080_CTRL_GPU_SET_VGPU_HETEROGENEOUS_MODE_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_GPU_SET_VGPU_HETEROGENEOUS_MODE_PARAMS._fields_ = [
    ('bHeterogeneousMode', ctypes.c_ubyte),
]

NV0080_CTRL_GPU_SET_VGPU_HETEROGENEOUS_MODE_PARAMS = struct_NV0080_CTRL_GPU_SET_VGPU_HETEROGENEOUS_MODE_PARAMS
class struct_NV0080_CTRL_GPU_GET_VGPU_HETEROGENEOUS_MODE_PARAMS(Structure):
    pass

struct_NV0080_CTRL_GPU_GET_VGPU_HETEROGENEOUS_MODE_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_GPU_GET_VGPU_HETEROGENEOUS_MODE_PARAMS._fields_ = [
    ('bHeterogeneousMode', ctypes.c_ubyte),
]

NV0080_CTRL_GPU_GET_VGPU_HETEROGENEOUS_MODE_PARAMS = struct_NV0080_CTRL_GPU_GET_VGPU_HETEROGENEOUS_MODE_PARAMS
NV0080_CTRL_CMD_HOST_GET_CAPS = (0x801401) # macro
NV0080_CTRL_HOST_GET_CAPS_PARAMS_MESSAGE_ID = (0x1) # macro
# def NV0080_CTRL_HOST_GET_CAP(tbl, c):  # macro
#    return (((NvU8)tbl[(1?c)])&(0?c))
NV0080_CTRL_HOST_CAPS_SEMA_ACQUIRE_BUG_105665 = ['0', ':', '0x01'] # macro
NV0080_CTRL_HOST_CAPS_DUP_CMPLT_BUG_126020 = ['0', ':', '0x02'] # macro
NV0080_CTRL_HOST_CAPS_GPU_COHERENT_MAPPING_SUPPORTED = ['0', ':', '0x04'] # macro
NV0080_CTRL_HOST_CAPS_SYS_SEMA_DEADLOCK_BUG_148216 = ['0', ':', '0x08'] # macro
NV0080_CTRL_HOST_CAPS_SLOWSLI = ['0', ':', '0x10'] # macro
NV0080_CTRL_HOST_CAPS_SEMA_READ_ONLY_BUG = ['0', ':', '0x20'] # macro
NV0080_CTRL_HOST_CAPS_LARGE_NONCOH_UPSTR_WRITE_BUG_114871 = ['0', ':', '0x40'] # macro
NV0080_CTRL_HOST_CAPS_LARGE_UPSTREAM_WRITE_BUG_115115 = ['0', ':', '0x80'] # macro
NV0080_CTRL_HOST_CAPS_SEP_VIDMEM_PB_NOTIFIERS_BUG_83923 = ['1', ':', '0x02'] # macro
NV0080_CTRL_HOST_CAPS_P2P_4_WAY = ['1', ':', '0x08'] # macro
NV0080_CTRL_HOST_CAPS_P2P_8_WAY = ['1', ':', '0x10'] # macro
NV0080_CTRL_HOST_CAPS_P2P_DEADLOCK_BUG_203825 = ['1', ':', '0x20'] # macro
NV0080_CTRL_HOST_CAPS_BUG_254580 = ['1', ':', '0x80'] # macro
NV0080_CTRL_HOST_CAPS_COMPRESSED_BL_P2P_BUG_257072 = ['2', ':', '0x02'] # macro
NV0080_CTRL_HOST_CAPS_CROSS_BLITS_BUG_270260 = ['2', ':', '0x04'] # macro
NV0080_CTRL_HOST_CAPS_MEM2MEM_BUG_365782 = ['2', ':', '0x10'] # macro
NV0080_CTRL_HOST_CAPS_CPU_WRITE_WAR_BUG_420495 = ['2', ':', '0x20'] # macro
NV0080_CTRL_HOST_CAPS_EXPLICIT_CACHE_FLUSH_REQD = ['2', ':', '0x40'] # macro
NV0080_CTRL_HOST_CAPS_BAR1_READ_DEADLOCK_BUG_511418 = ['2', ':', '0x80'] # macro
NV0080_CTRL_HOST_CAPS_TBL_SIZE = 3 # macro
NV0080_CTRL_CMD_HOST_GET_CAPS_V2 = (0x801402) # macro
NV0080_CTRL_HOST_GET_CAPS_V2_PARAMS_MESSAGE_ID = (0x2) # macro
class struct_NV0080_CTRL_HOST_GET_CAPS_PARAMS(Structure):
    pass

struct_NV0080_CTRL_HOST_GET_CAPS_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_HOST_GET_CAPS_PARAMS._fields_ = [
    ('capsTblSize', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('capsTbl', ctypes.POINTER(None)),
]

NV0080_CTRL_HOST_GET_CAPS_PARAMS = struct_NV0080_CTRL_HOST_GET_CAPS_PARAMS
class struct_NV0080_CTRL_HOST_GET_CAPS_V2_PARAMS(Structure):
    pass

struct_NV0080_CTRL_HOST_GET_CAPS_V2_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_HOST_GET_CAPS_V2_PARAMS._fields_ = [
    ('capsTbl', ctypes.c_ubyte * 3),
]

NV0080_CTRL_HOST_GET_CAPS_V2_PARAMS = struct_NV0080_CTRL_HOST_GET_CAPS_V2_PARAMS
NV0080_CTRL_PERF_SLI_GPU_BOOST_SYNC_CONTROL_PARAMS_MESSAGE_ID = (0x7) # macro
NV0080_CTRL_PERF_CUDA_LIMIT_CONTROL_PARAMS_MESSAGE_ID = (0x9) # macro
NV0080_CTRL_CMD_PERF_CUDA_LIMIT_SET_CONTROL = (0x801909) # macro
NV0080_CTRL_CMD_INTERNAL_GR_GET_TPC_PARTITION_MODE = (0x802002) # macro
NV0080_CTRL_CMD_INTERNAL_GR_GET_TPC_PARTITION_MODE_FINN_PARAMS_MESSAGE_ID = (0x2) # macro
NV0080_CTRL_CMD_INTERNAL_GR_SET_TPC_PARTITION_MODE = (0x802003) # macro
NV0080_CTRL_CMD_INTERNAL_GR_SET_TPC_PARTITION_MODE_FINN_PARAMS_MESSAGE_ID = (0x3) # macro
NV0080_CTRL_CMD_INTERNAL_PERF_CUDA_LIMIT_SET_CONTROL = (0x802009) # macro
NV0080_CTRL_CMD_INTERNAL_PERF_CUDA_LIMIT_DISABLE = (0x802004) # macro
NV0080_CTRL_CMD_INTERNAL_PERF_SLI_GPU_BOOST_SYNC_SET_CONTROL = (0x802007) # macro
NV0080_CTRL_CMD_INTERNAL_FIFO_RC_AND_PERMANENTLY_DISABLE_CHANNELS = (0x802008) # macro
NV_FIFO_PERMANENTLY_DISABLE_CHANNELS_MAX_CLIENTS = 200 # macro
NV0080_CTRL_INTERNAL_FIFO_RC_AND_PERMANENTLY_DISABLE_CHANNELS_PARAMS_MESSAGE_ID = (0x08) # macro
class struct_NV0080_CTRL_PERF_SLI_GPU_BOOST_SYNC_CONTROL_PARAMS(Structure):
    pass

struct_NV0080_CTRL_PERF_SLI_GPU_BOOST_SYNC_CONTROL_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_PERF_SLI_GPU_BOOST_SYNC_CONTROL_PARAMS._fields_ = [
    ('bActivate', ctypes.c_ubyte),
]

NV0080_CTRL_PERF_SLI_GPU_BOOST_SYNC_CONTROL_PARAMS = struct_NV0080_CTRL_PERF_SLI_GPU_BOOST_SYNC_CONTROL_PARAMS
class struct_NV0080_CTRL_PERF_CUDA_LIMIT_CONTROL_PARAMS(Structure):
    pass

struct_NV0080_CTRL_PERF_CUDA_LIMIT_CONTROL_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_PERF_CUDA_LIMIT_CONTROL_PARAMS._fields_ = [
    ('bCudaLimit', ctypes.c_ubyte),
]

NV0080_CTRL_PERF_CUDA_LIMIT_CONTROL_PARAMS = struct_NV0080_CTRL_PERF_CUDA_LIMIT_CONTROL_PARAMS
class struct_NV0080_CTRL_CMD_INTERNAL_GR_GET_TPC_PARTITION_MODE_FINN_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('params', NV0080_CTRL_GR_TPC_PARTITION_MODE_PARAMS),
     ]

NV0080_CTRL_CMD_INTERNAL_GR_GET_TPC_PARTITION_MODE_FINN_PARAMS = struct_NV0080_CTRL_CMD_INTERNAL_GR_GET_TPC_PARTITION_MODE_FINN_PARAMS
class struct_NV0080_CTRL_CMD_INTERNAL_GR_SET_TPC_PARTITION_MODE_FINN_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('params', NV0080_CTRL_GR_TPC_PARTITION_MODE_PARAMS),
     ]

NV0080_CTRL_CMD_INTERNAL_GR_SET_TPC_PARTITION_MODE_FINN_PARAMS = struct_NV0080_CTRL_CMD_INTERNAL_GR_SET_TPC_PARTITION_MODE_FINN_PARAMS
class struct_NV0080_CTRL_INTERNAL_FIFO_RC_AND_PERMANENTLY_DISABLE_CHANNELS_PARAMS(Structure):
    pass

struct_NV0080_CTRL_INTERNAL_FIFO_RC_AND_PERMANENTLY_DISABLE_CHANNELS_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_INTERNAL_FIFO_RC_AND_PERMANENTLY_DISABLE_CHANNELS_PARAMS._fields_ = [
    ('numClients', ctypes.c_uint32),
    ('clientHandles', ctypes.c_uint32 * 200),
]

NV0080_CTRL_INTERNAL_FIFO_RC_AND_PERMANENTLY_DISABLE_CHANNELS_PARAMS = struct_NV0080_CTRL_INTERNAL_FIFO_RC_AND_PERMANENTLY_DISABLE_CHANNELS_PARAMS
NV0080_CTRL_CMD_MSENC_GET_CAPS = (0x801b01) # macro
NV0080_CTRL_MSENC_GET_CAPS_PARAMS_MESSAGE_ID = (0x1) # macro
NV0080_CTRL_MSENC_CAPS_TBL_SIZE = 4 # macro
NV0080_CTRL_CMD_MSENC_GET_CAPS_V2 = (0x801b02) # macro
NV0080_CTRL_MSENC_GET_CAPS_V2_PARAMS_MESSAGE_ID = (0x2) # macro
class struct_NV0080_CTRL_MSENC_GET_CAPS_PARAMS(Structure):
    pass

struct_NV0080_CTRL_MSENC_GET_CAPS_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_MSENC_GET_CAPS_PARAMS._fields_ = [
    ('capsTblSize', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('capsTbl', ctypes.POINTER(None)),
]

NV0080_CTRL_MSENC_GET_CAPS_PARAMS = struct_NV0080_CTRL_MSENC_GET_CAPS_PARAMS
class struct_NV0080_CTRL_MSENC_GET_CAPS_V2_PARAMS(Structure):
    pass

struct_NV0080_CTRL_MSENC_GET_CAPS_V2_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_MSENC_GET_CAPS_V2_PARAMS._fields_ = [
    ('capsTbl', ctypes.c_ubyte * 4),
    ('instanceId', ctypes.c_uint32),
]

NV0080_CTRL_MSENC_GET_CAPS_V2_PARAMS = struct_NV0080_CTRL_MSENC_GET_CAPS_V2_PARAMS
NV0080_CTRL_NVJPG_CAPS_TBL_SIZE = 9 # macro
NV0080_CTRL_CMD_NVJPG_GET_CAPS_V2 = (0x801f02) # macro
NV0080_CTRL_NVJPG_GET_CAPS_V2_PARAMS_MESSAGE_ID = (0x2) # macro
class struct_NV0080_CTRL_NVJPG_GET_CAPS_V2_PARAMS(Structure):
    pass

struct_NV0080_CTRL_NVJPG_GET_CAPS_V2_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_NVJPG_GET_CAPS_V2_PARAMS._fields_ = [
    ('capsTbl', ctypes.c_ubyte * 9),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('instanceId', ctypes.c_uint32),
]

NV0080_CTRL_NVJPG_GET_CAPS_V2_PARAMS = struct_NV0080_CTRL_NVJPG_GET_CAPS_V2_PARAMS
NV0080_CTRL_CMD_OS_UNIX_VT_SWITCH = (0x801e01) # macro
NV0080_CTRL_OS_UNIX_VT_SWITCH_PARAMS_MESSAGE_ID = (0x1) # macro
NV0080_CTRL_OS_UNIX_VT_SWITCH_CMD_SAVE_VT_STATE = (0x00000001) # macro
NV0080_CTRL_OS_UNIX_VT_SWITCH_CMD_RESTORE_VT_STATE = (0x00000002) # macro
NV0080_CTRL_OS_UNIX_VT_SWITCH_CMD_CONSOLE_RESTORED = (0x00000003) # macro
NV0080_CTRL_CMD_OS_UNIX_VT_GET_FB_INFO = (0x801e02) # macro
NV0080_CTRL_OS_UNIX_VT_GET_FB_INFO_PARAMS_MESSAGE_ID = (0x2) # macro
class struct_NV0080_CTRL_OS_UNIX_VT_SWITCH_PARAMS(Structure):
    pass

struct_NV0080_CTRL_OS_UNIX_VT_SWITCH_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_OS_UNIX_VT_SWITCH_PARAMS._fields_ = [
    ('cmd', ctypes.c_uint32),
]

NV0080_CTRL_OS_UNIX_VT_SWITCH_PARAMS = struct_NV0080_CTRL_OS_UNIX_VT_SWITCH_PARAMS
class struct_NV0080_CTRL_OS_UNIX_VT_GET_FB_INFO_PARAMS(Structure):
    pass

struct_NV0080_CTRL_OS_UNIX_VT_GET_FB_INFO_PARAMS._pack_ = 1 # source:False
struct_NV0080_CTRL_OS_UNIX_VT_GET_FB_INFO_PARAMS._fields_ = [
    ('subDeviceInstance', ctypes.c_uint32),
    ('width', ctypes.c_uint16),
    ('height', ctypes.c_uint16),
    ('depth', ctypes.c_uint16),
    ('pitch', ctypes.c_uint16),
]

NV0080_CTRL_OS_UNIX_VT_GET_FB_INFO_PARAMS = struct_NV0080_CTRL_OS_UNIX_VT_GET_FB_INFO_PARAMS
NV2080_CTRL_BIOS_INFO_MAX_SIZE = (0x0000000F) # macro
NV2080_CTRL_BIOS_INFO_INDEX_REVISION = (0x00000000) # macro
NV2080_CTRL_BIOS_INFO_INDEX_OEM_REVISION = (0x00000001) # macro
NV2080_CTRL_CMD_BIOS_GET_INFO = (0x20800802) # macro
NV2080_CTRL_CMD_BIOS_GET_INFO_V2 = (0x20800810) # macro
NV2080_CTRL_BIOS_GET_INFO_V2_PARAMS_MESSAGE_ID = (0x10) # macro
NV2080_CTRL_BIOS_NBSI_MAX_REG_STRING_LENGTH = (0x00000100) # macro
NV2080_CTRL_BIOS_NBSI_STRING_TYPE_ASCII = (0x00000000) # macro
NV2080_CTRL_BIOS_NBSI_STRING_TYPE_UNICODE = (0x00000001) # macro
NV2080_CTRL_BIOS_NBSI_STRING_TYPE_HASH = (0x00000002) # macro
NV2080_CTRL_BIOS_NBSI_MODULE_ROOT = (0x00000000) # macro
NV2080_CTRL_BIOS_NBSI_MODULE_RM = (0x00000001) # macro
NV2080_CTRL_BIOS_NBSI_MODULE_DISPLAYDRIVER = (0x00000002) # macro
NV2080_CTRL_BIOS_NBSI_MODULE_VIDEO = (0x00000003) # macro
NV2080_CTRL_BIOS_NBSI_MODULE_CPL = (0x00000004) # macro
NV2080_CTRL_BIOS_NBSI_MODULE_D3D = (0x00000005) # macro
NV2080_CTRL_BIOS_NBSI_MODULE_OGL = (0x00000006) # macro
NV2080_CTRL_BIOS_NBSI_MODULE_PMU = (0x00000007) # macro
NV2080_CTRL_BIOS_NBSI_MODULE_MODE = (0x00000008) # macro
NV2080_CTRL_BIOS_NBSI_NUM_MODULES = (0x00000009) # macro
NV2080_CTRL_BIOS_NBSI_MODULE_UNKNOWN = (0x80000000) # macro
NV2080_CTRL_BIOS_GET_NBSI_SUCCESS = (0x00000000) # macro
NV2080_CTRL_BIOS_GET_NBSI_OVERRIDE = (0x00000001) # macro
NV2080_CTRL_BIOS_GET_NBSI_BAD_HASH = (0xFFFFFFFA) # macro
NV2080_CTRL_BIOS_GET_NBSI_APITEST_SUCCESS = (0xFFFFFFFB) # macro
NV2080_CTRL_BIOS_GET_NBSI_BAD_TABLE = (0xFFFFFFFC) # macro
NV2080_CTRL_BIOS_GET_NBSI_NO_TABLE = (0xFFFFFFFD) # macro
NV2080_CTRL_BIOS_GET_NBSI_INCOMPLETE = (0xFFFFFFFE) # macro
NV2080_CTRL_BIOS_GET_NBSI_NOT_FOUND = (0xFFFFFFFF) # macro
NV2080_CTRL_CMD_BIOS_GET_NBSI = (0x20800803) # macro
NV2080_CTRL_BIOS_GET_NBSI_PARAMS_MESSAGE_ID = (0x3) # macro
NV2080_CTRL_CMD_BIOS_GET_NBSI_V2 = (0x2080080e) # macro
NV2080_BIOS_GET_NBSI_MAX_RET_SIZE = (0x100) # macro
NV2080_CTRL_BIOS_GET_NBSI_V2_PARAMS_MESSAGE_ID = (0xE) # macro
NV2080_CTRL_CMD_BIOS_GET_NBSI_OBJ = (0x20800806) # macro
NV2080_CTRL_BIOS_GET_NBSI_OBJ_PARAMS_MESSAGE_ID = (0x6) # macro
GLOB_TYPE_GET_NBSI_DIR = 0xfffe # macro
GLOB_TYPE_APITEST = 0xffff # macro
GLOB_TYPE_GET_NBSI_ACPI_RAW = 0xfffd # macro
NV2080_CTRL_CMD_BIOS_GET_SKU_INFO = (0x20800808) # macro
NV2080_CTRL_BIOS_GET_SKU_INFO_PARAMS_MESSAGE_ID = (0x8) # macro
NV2080_CTRL_CMD_BIOS_GET_POST_TIME = (0x20800809) # macro
NV2080_CTRL_CMD_BIOS_GET_POST_TIME_PARAMS_MESSAGE_ID = (0x9) # macro
NV2080_CTRL_CMD_BIOS_GET_UEFI_SUPPORT = (0x2080080b) # macro
NV2080_CTRL_BIOS_GET_UEFI_SUPPORT_PARAMS_MESSAGE_ID = (0xB) # macro
NV2080_CTRL_BIOS_UEFI_SUPPORT_FLAGS_PRESENCE = ['1', ':', '0'] # macro
NV2080_CTRL_BIOS_UEFI_SUPPORT_FLAGS_PRESENCE_NO = (0x00000000) # macro
NV2080_CTRL_BIOS_UEFI_SUPPORT_FLAGS_PRESENCE_YES = (0x00000001) # macro
NV2080_CTRL_BIOS_UEFI_SUPPORT_FLAGS_PRESENCE_PLACEHOLDER = (0x00000002) # macro
NV2080_CTRL_BIOS_UEFI_SUPPORT_FLAGS_PRESENCE_HIDDEN = (0x00000003) # macro
NV2080_CTRL_BIOS_UEFI_SUPPORT_FLAGS_RUNNING = ['2', ':', '2'] # macro
NV2080_CTRL_BIOS_UEFI_SUPPORT_FLAGS_RUNNING_FALSE = (0x00000000) # macro
NV2080_CTRL_BIOS_UEFI_SUPPORT_FLAGS_RUNNING_TRUE = (0x00000001) # macro
NV2080_CTRL_BIOS_INFO = struct_NVXXXX_CTRL_XXX_INFO
class struct_NV2080_CTRL_BIOS_GET_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BIOS_GET_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BIOS_GET_INFO_PARAMS._fields_ = [
    ('biosInfoListSize', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('biosInfoList', ctypes.POINTER(None)),
]

NV2080_CTRL_BIOS_GET_INFO_PARAMS = struct_NV2080_CTRL_BIOS_GET_INFO_PARAMS
class struct_NV2080_CTRL_BIOS_GET_INFO_V2_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BIOS_GET_INFO_V2_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BIOS_GET_INFO_V2_PARAMS._fields_ = [
    ('biosInfoListSize', ctypes.c_uint32),
    ('biosInfoList', struct_NVXXXX_CTRL_XXX_INFO * 15),
]

NV2080_CTRL_BIOS_GET_INFO_V2_PARAMS = struct_NV2080_CTRL_BIOS_GET_INFO_V2_PARAMS
class struct_NV2080_CTRL_BIOS_NBSI_REG_STRING(Structure):
    pass

class union_NV2080_CTRL_BIOS_NBSI_REG_STRING_value(Union):
    pass

union_NV2080_CTRL_BIOS_NBSI_REG_STRING_value._pack_ = 1 # source:False
union_NV2080_CTRL_BIOS_NBSI_REG_STRING_value._fields_ = [
    ('ascii', ctypes.c_ubyte * 256),
    ('unicode', ctypes.c_uint16 * 256),
    ('hash', ctypes.c_uint16),
    ('PADDING_0', ctypes.c_ubyte * 510),
]

struct_NV2080_CTRL_BIOS_NBSI_REG_STRING._pack_ = 1 # source:False
struct_NV2080_CTRL_BIOS_NBSI_REG_STRING._fields_ = [
    ('size', ctypes.c_uint32),
    ('type', ctypes.c_uint32),
    ('value', union_NV2080_CTRL_BIOS_NBSI_REG_STRING_value),
]

NV2080_CTRL_BIOS_NBSI_REG_STRING = struct_NV2080_CTRL_BIOS_NBSI_REG_STRING
class struct_NV2080_CTRL_BIOS_GET_NBSI_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BIOS_GET_NBSI_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BIOS_GET_NBSI_PARAMS._fields_ = [
    ('module', ctypes.c_uint32),
    ('path', NV2080_CTRL_BIOS_NBSI_REG_STRING),
    ('valueName', NV2080_CTRL_BIOS_NBSI_REG_STRING),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('retBuf', ctypes.POINTER(None)),
    ('retSize', ctypes.c_uint32),
    ('errorCode', ctypes.c_uint32),
]

NV2080_CTRL_BIOS_GET_NBSI_PARAMS = struct_NV2080_CTRL_BIOS_GET_NBSI_PARAMS
class struct_NV2080_CTRL_BIOS_GET_NBSI_V2_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BIOS_GET_NBSI_V2_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BIOS_GET_NBSI_V2_PARAMS._fields_ = [
    ('module', ctypes.c_uint32),
    ('path', NV2080_CTRL_BIOS_NBSI_REG_STRING),
    ('valueName', NV2080_CTRL_BIOS_NBSI_REG_STRING),
    ('retBuf', ctypes.c_ubyte * 256),
    ('retSize', ctypes.c_uint32),
    ('errorCode', ctypes.c_uint32),
]

NV2080_CTRL_BIOS_GET_NBSI_V2_PARAMS = struct_NV2080_CTRL_BIOS_GET_NBSI_V2_PARAMS
class struct_NV2080_CTRL_BIOS_GET_NBSI_OBJ_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BIOS_GET_NBSI_OBJ_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BIOS_GET_NBSI_OBJ_PARAMS._fields_ = [
    ('globType', ctypes.c_uint16),
    ('globIndex', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte),
    ('globSource', ctypes.c_uint16),
    ('PADDING_1', ctypes.c_ubyte * 2),
    ('retBufOffset', ctypes.c_uint32),
    ('PADDING_2', ctypes.c_ubyte * 4),
    ('retBuf', ctypes.POINTER(None)),
    ('retSize', ctypes.c_uint32),
    ('totalObjSize', ctypes.c_uint32),
    ('errorCode', ctypes.c_uint32),
    ('PADDING_3', ctypes.c_ubyte * 4),
]

NV2080_CTRL_BIOS_GET_NBSI_OBJ_PARAMS = struct_NV2080_CTRL_BIOS_GET_NBSI_OBJ_PARAMS
class struct_NV2080_CTRL_BIOS_GET_SKU_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BIOS_GET_SKU_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BIOS_GET_SKU_INFO_PARAMS._fields_ = [
    ('BoardID', ctypes.c_uint32),
    ('chipSKU', ctypes.c_char * 9),
    ('chipSKUMod', ctypes.c_char * 5),
    ('PADDING_0', ctypes.c_ubyte * 2),
    ('skuConfigVersion', ctypes.c_uint32),
    ('project', ctypes.c_char * 5),
    ('projectSKU', ctypes.c_char * 5),
    ('CDP', ctypes.c_char * 6),
    ('projectSKUMod', ctypes.c_char * 2),
    ('PADDING_1', ctypes.c_ubyte * 2),
    ('businessCycle', ctypes.c_uint32),
]

NV2080_CTRL_BIOS_GET_SKU_INFO_PARAMS = struct_NV2080_CTRL_BIOS_GET_SKU_INFO_PARAMS
class struct_NV2080_CTRL_CMD_BIOS_GET_POST_TIME_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_BIOS_GET_POST_TIME_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_BIOS_GET_POST_TIME_PARAMS._fields_ = [
    ('vbiosPostTime', ctypes.c_uint64),
]

NV2080_CTRL_CMD_BIOS_GET_POST_TIME_PARAMS = struct_NV2080_CTRL_CMD_BIOS_GET_POST_TIME_PARAMS
class struct_NV2080_CTRL_BIOS_GET_UEFI_SUPPORT_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BIOS_GET_UEFI_SUPPORT_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BIOS_GET_UEFI_SUPPORT_PARAMS._fields_ = [
    ('version', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
]

NV2080_CTRL_BIOS_GET_UEFI_SUPPORT_PARAMS = struct_NV2080_CTRL_BIOS_GET_UEFI_SUPPORT_PARAMS
NV2080_CTRL_CMD_BUS_GET_PCI_INFO = (0x20801801) # macro
NV2080_CTRL_BUS_GET_PCI_INFO_PARAMS_MESSAGE_ID = (0x1) # macro
NV2080_CTRL_BUS_INFO_INDEX_TYPE = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_INDEX_INTLINE = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_INDEX_CAPS = (0x00000002) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_GPU_LINK_CAPS = (0x00000003) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_ROOT_LINK_CAPS = (0x00000004) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_UPSTREAM_LINK_CAPS = (0x00000005) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_DOWNSTREAM_LINK_CAPS = (0x00000006) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_GPU_LINK_CTRL_STATUS = (0x00000007) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_ROOT_LINK_CTRL_STATUS = (0x00000008) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_UPSTREAM_LINK_CTRL_STATUS = (0x00000009) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_DOWNSTREAM_LINK_CTRL_STATUS = (0x0000000A) # macro
NV2080_CTRL_BUS_INFO_INDEX_COHERENT_DMA_FLAGS = (0x0000000B) # macro
NV2080_CTRL_BUS_INFO_INDEX_NONCOHERENT_DMA_FLAGS = (0x0000000C) # macro
NV2080_CTRL_BUS_INFO_INDEX_GPU_GART_SIZE = (0x0000000D) # macro
NV2080_CTRL_BUS_INFO_INDEX_GPU_GART_FLAGS = (0x0000000E) # macro
NV2080_CTRL_BUS_INFO_INDEX_BUS_NUMBER = (0x0000000F) # macro
NV2080_CTRL_BUS_INFO_INDEX_DEVICE_NUMBER = (0x00000010) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_GPU_LINK_ERRORS = (0x00000011) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_ROOT_LINK_ERRORS = (0x00000012) # macro
NV2080_CTRL_BUS_INFO_INDEX_INTERFACE_TYPE = (0x00000013) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_GEN2_INFO = (0x00000014) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_GPU_LINK_AER = (0x00000015) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_BOARD_LINK_CAPS = (0x00000016) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_BOARD_LINK_CTRL_STATUS = (0x00000017) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_ASLM_STATUS = (0x00000018) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_LINK_WIDTH_SWITCH_ERROR_COUNT = (0x00000019) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_LINK_SPEED_SWITCH_ERROR_COUNT = (0x0000001A) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_GPU_CYA_ASPM = (0x0000001B) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_GPU_LINK_LINECODE_ERRORS = (0x0000001C) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_GPU_LINK_CRC_ERRORS = (0x0000001D) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_GPU_LINK_NAKS_RECEIVED = (0x0000001E) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_GPU_LINK_FAILED_L0S_EXITS = (0x0000001F) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_GPU_LINK_LINECODE_ERRORS_CLEAR = (0x00000020) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_GPU_LINK_CRC_ERRORS_CLEAR = (0x00000021) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_GPU_LINK_NAKS_RECEIVED_CLEAR = (0x00000022) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_GPU_LINK_FAILED_L0S_EXITS_CLEAR = (0x00000023) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_GPU_LINK_CORRECTABLE_ERRORS = (0x00000024) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_GPU_LINK_NONFATAL_ERRORS = (0x00000025) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_GPU_LINK_FATAL_ERRORS = (0x00000026) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_GPU_LINK_UNSUPPORTED_REQUESTS = (0x00000027) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_GPU_LINK_CORRECTABLE_ERRORS_CLEAR = (0x00000028) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_GPU_LINK_NONFATAL_ERRORS_CLEAR = (0x00000029) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_GPU_LINK_FATAL_ERRORS_CLEAR = (0x0000002A) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_GPU_LINK_UNSUPPORTED_REQUESTS_CLEAR = (0x0000002B) # macro
NV2080_CTRL_BUS_INFO_INDEX_DOMAIN_NUMBER = (0x0000002C) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_GEN_INFO = (0x0000002D) # macro
NV2080_CTRL_BUS_INFO_INDEX_GPU_INTERFACE_TYPE = (0x0000002E) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_UPSTREAM_GEN_INFO = (0x0000002F) # macro
NV2080_CTRL_BUS_INFO_INDEX_PCIE_BOARD_GEN_INFO = (0x00000030) # macro
NV2080_CTRL_BUS_INFO_INDEX_MSI_INFO = (0x00000031) # macro
NV2080_CTRL_BUS_INFO_INDEX_GPU_GART_SIZE_HI = (0x00000032) # macro
NV2080_CTRL_BUS_INFO_INDEX_SYSMEM_CONNECTION_TYPE = (0x00000033) # macro
NV2080_CTRL_BUS_INFO_INDEX_MAX = (0x00000033) # macro
NV2080_CTRL_BUS_INFO_MAX_LIST_SIZE = (0x00000034) # macro
NV2080_CTRL_BUS_INFO_TYPE_PCI = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_TYPE_PCI_EXPRESS = (0x00000003) # macro
NV2080_CTRL_BUS_INFO_TYPE_FPCI = (0x00000004) # macro
NV2080_CTRL_BUS_INFO_TYPE_AXI = (0x00000008) # macro
NV2080_CTRL_BUS_INFO_CAPS_NEED_IO_FLUSH = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_CAPS_CHIP_INTEGRATED = (0x00000002) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_MAX_SPEED = ['3', ':', '0'] # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_MAX_SPEED_2500MBPS = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_MAX_SPEED_5000MBPS = (0x00000002) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_MAX_SPEED_8000MBPS = (0x00000003) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_MAX_SPEED_16000MBPS = (0x00000004) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_MAX_SPEED_32000MBPS = (0x00000005) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_MAX_SPEED_64000MBPS = (0x00000006) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_MAX_WIDTH = ['9', ':', '4'] # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_ASPM = ['11', ':', '10'] # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_ASPM_NONE = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_ASPM_L0S = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_ASPM_L0S_L1 = (0x00000003) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_GEN = ['15', ':', '12'] # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_GEN_GEN1 = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_GEN_GEN2 = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_GEN_GEN3 = (0x00000002) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_GEN_GEN4 = (0x00000003) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_GEN_GEN5 = (0x00000004) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_GEN_GEN6 = (0x00000005) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_CURR_LEVEL = ['19', ':', '16'] # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_CURR_LEVEL_GEN1 = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_CURR_LEVEL_GEN2 = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_CURR_LEVEL_GEN3 = (0x00000002) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_CURR_LEVEL_GEN4 = (0x00000003) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_CURR_LEVEL_GEN5 = (0x00000004) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_CURR_LEVEL_GEN6 = (0x00000005) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_GPU_GEN = ['23', ':', '20'] # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_GPU_GEN_GEN1 = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_GPU_GEN_GEN2 = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_GPU_GEN_GEN3 = (0x00000002) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_GPU_GEN_GEN4 = (0x00000003) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_GPU_GEN_GEN5 = (0x00000004) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_GPU_GEN_GEN6 = (0x00000005) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_SPEED_CHANGES = ['24', ':', '24'] # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_SPEED_CHANGES_ENABLED = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CAP_SPEED_CHANGES_DISABLED = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CTRL_STATUS_ASPM = ['1', ':', '0'] # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CTRL_STATUS_ASPM_DISABLED = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CTRL_STATUS_ASPM_L0S = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CTRL_STATUS_ASPM_L1 = (0x00000002) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CTRL_STATUS_ASPM_L0S_L1 = (0x00000003) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CTRL_STATUS_LINK_SPEED = ['19', ':', '16'] # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CTRL_STATUS_LINK_SPEED_2500MBPS = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CTRL_STATUS_LINK_SPEED_5000MBPS = (0x00000002) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CTRL_STATUS_LINK_SPEED_8000MBPS = (0x00000003) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CTRL_STATUS_LINK_SPEED_16000MBPS = (0x00000004) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CTRL_STATUS_LINK_SPEED_32000MBPS = (0x00000005) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CTRL_STATUS_LINK_SPEED_64000MBPS = (0x00000006) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CTRL_STATUS_LINK_WIDTH = ['25', ':', '20'] # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CTRL_STATUS_LINK_WIDTH_UNDEFINED = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CTRL_STATUS_LINK_WIDTH_X1 = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CTRL_STATUS_LINK_WIDTH_X2 = (0x00000002) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CTRL_STATUS_LINK_WIDTH_X4 = (0x00000004) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CTRL_STATUS_LINK_WIDTH_X8 = (0x00000008) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CTRL_STATUS_LINK_WIDTH_X12 = (0x0000000C) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CTRL_STATUS_LINK_WIDTH_X16 = (0x00000010) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_CTRL_STATUS_LINK_WIDTH_X32 = (0x00000020) # macro
NV2080_CTRL_BUS_INFO_COHERENT_DMA_FLAGS_CTXDMA = ['0', ':', '0'] # macro
NV2080_CTRL_BUS_INFO_COHERENT_DMA_FLAGS_CTXDMA_FALSE = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_COHERENT_DMA_FLAGS_CTXDMA_TRUE = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_COHERENT_DMA_FLAGS_GPUGART = ['2', ':', '2'] # macro
NV2080_CTRL_BUS_INFO_COHERENT_DMA_FLAGS_GPUGART_FALSE = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_COHERENT_DMA_FLAGS_GPUGART_TRUE = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_NONCOHERENT_DMA_FLAGS_CTXDMA = ['0', ':', '0'] # macro
NV2080_CTRL_BUS_INFO_NONCOHERENT_DMA_FLAGS_CTXDMA_FALSE = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_NONCOHERENT_DMA_FLAGS_CTXDMA_TRUE = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_NONCOHERENT_DMA_FLAGS_GPUGART = ['2', ':', '2'] # macro
NV2080_CTRL_BUS_INFO_NONCOHERENT_DMA_FLAGS_GPUGART_FALSE = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_NONCOHERENT_DMA_FLAGS_GPUGART_TRUE = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_NONCOHERENT_DMA_FLAGS_COH_MODE = ['3', ':', '3'] # macro
NV2080_CTRL_BUS_INFO_NONCOHERENT_DMA_FLAGS_COH_MODE_FALSE = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_NONCOHERENT_DMA_FLAGS_COH_MODE_TRUE = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_GPU_GART_FLAGS_REQFLUSH = ['0', ':', '0'] # macro
NV2080_CTRL_BUS_INFO_GPU_GART_FLAGS_REQFLUSH_FALSE = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_GPU_GART_FLAGS_REQFLUSH_TRUE = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_GPU_GART_FLAGS_UNIFIED = ['1', ':', '1'] # macro
NV2080_CTRL_BUS_INFO_GPU_GART_FLAGS_UNIFIED_FALSE = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_GPU_GART_FLAGS_UNIFIED_TRUE = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_ERRORS_CORR_ERROR = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_ERRORS_NON_FATAL_ERROR = (0x00000002) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_ERRORS_FATAL_ERROR = (0x00000004) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_ERRORS_UNSUPP_REQUEST = (0x00000008) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_ERRORS_ENTERED_RECOVERY = (0x00000010) # macro
NV2080_CTRL_BUS_INFO_PCIE_GEN2_INFO_CAP = ['0', ':', '0'] # macro
NV2080_CTRL_BUS_INFO_PCIE_GEN2_INFO_CAP_FALSE = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_GEN2_INFO_CAP_TRUE = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_GEN2_INFO_CURR_LEVEL = ['1', ':', '1'] # macro
NV2080_CTRL_BUS_INFO_PCIE_GEN2_INFO_CURR_LEVEL_GEN1 = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_GEN2_INFO_CURR_LEVEL_GEN2 = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_AER_UNCORR_TRAINING_ERR = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_AER_UNCORR_DLINK_PROTO_ERR = (0x00000002) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_AER_UNCORR_POISONED_TLP = (0x00000004) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_AER_UNCORR_FC_PROTO_ERR = (0x00000008) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_AER_UNCORR_CPL_TIMEOUT = (0x00000010) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_AER_UNCORR_CPL_ABORT = (0x00000020) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_AER_UNCORR_UNEXP_CPL = (0x00000040) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_AER_UNCORR_RCVR_OVERFLOW = (0x00000080) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_AER_UNCORR_MALFORMED_TLP = (0x00000100) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_AER_UNCORR_ECRC_ERROR = (0x00000200) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_AER_UNCORR_UNSUPPORTED_REQ = (0x00000400) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_AER_CORR_RCV_ERR = (0x00010000) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_AER_CORR_BAD_TLP = (0x00020000) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_AER_CORR_BAD_DLLP = (0x00040000) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_AER_CORR_RPLY_ROLLOVER = (0x00080000) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_AER_CORR_RPLY_TIMEOUT = (0x00100000) # macro
NV2080_CTRL_BUS_INFO_PCIE_LINK_AER_CORR_ADVISORY_NONFATAL = (0x00200000) # macro
NV2080_CTRL_BUS_INFO_PCIE_ASLM_STATUS_PCIE = ['0', ':', '0'] # macro
NV2080_CTRL_BUS_INFO_PCIE_ASLM_STATUS_PCIE_ERROR = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_ASLM_STATUS_PCIE_PRESENT = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_ASLM_STATUS_SUPPORTED = ['1', ':', '1'] # macro
NV2080_CTRL_BUS_INFO_PCIE_ASLM_STATUS_SUPPORTED_NO = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_ASLM_STATUS_SUPPORTED_YES = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_ASLM_STATUS_CL_CAPABLE = ['2', ':', '2'] # macro
NV2080_CTRL_BUS_INFO_PCIE_ASLM_STATUS_CL_CAPABLE_NO = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_ASLM_STATUS_CL_CAPABLE_YES = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_ASLM_STATUS_OS_SUPPORTED = ['3', ':', '3'] # macro
NV2080_CTRL_BUS_INFO_PCIE_ASLM_STATUS_OS_SUPPORTED_NO = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_ASLM_STATUS_OS_SUPPORTED_YES = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_ASLM_STATUS_BR04 = ['4', ':', '4'] # macro
NV2080_CTRL_BUS_INFO_PCIE_ASLM_STATUS_BR04_MISSING = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_ASLM_STATUS_BR04_PRESENT = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_GPU_CYA_ASPM_VALID = ['0', ':', '0'] # macro
NV2080_CTRL_BUS_INFO_PCIE_GPU_CYA_ASPM_VALID_NO = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_GPU_CYA_ASPM_VALID_YES = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_GPU_CYA_ASPM = ['2', ':', '1'] # macro
NV2080_CTRL_BUS_INFO_PCIE_GPU_CYA_ASPM_DISABLED = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_GPU_CYA_ASPM_L0S = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_GPU_CYA_ASPM_L1 = (0x00000002) # macro
NV2080_CTRL_BUS_INFO_PCIE_GPU_CYA_ASPM_L0S_L1 = (0x00000003) # macro
NV2080_CTRL_BUS_INFO_MSI_STATUS = ['0', ':', '0'] # macro
NV2080_CTRL_BUS_INFO_MSI_STATUS_DISABLED = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_MSI_STATUS_ENABLED = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CAP_PCIPM_L1_2_SUPPORTED = ['0', ':', '0'] # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CAP_PCIPM_L1_2_SUPPORTED_YES = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CAP_PCIPM_L1_2_SUPPORTED_NO = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CAP_PCIPM_L1_1_SUPPORTED = ['1', ':', '1'] # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CAP_PCIPM_L1_1_SUPPORTED_YES = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CAP_PCIPM_L1_1_SUPPORTED_NO = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CAP_ASPM_L1_2_SUPPORTED = ['2', ':', '2'] # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CAP_ASPM_L1_2_SUPPORTED_YES = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CAP_ASPM_L1_2_SUPPORTED_NO = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CAP_ASPM_L1_1_SUPPORTED = ['3', ':', '3'] # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CAP_ASPM_L1_1_SUPPORTED_YES = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CAP_ASPM_L1_1_SUPPORTED_NO = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CAP_L1PM_SUPPORTED = ['4', ':', '4'] # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CAP_L1PM_SUPPORTED_YES = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CAP_L1PM_SUPPORTED_NO = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CAP_RESERVED = ['7', ':', '5'] # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CAP_PORT_RESTORE_TIME = ['15', ':', '8'] # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CAP_T_POWER_ON_SCALE = ['17', ':', '16'] # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CAP_T_POWER_ON_VALUE = ['23', ':', '19'] # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CTRL1_PCIPM_L1_2_ENABLED = ['0', ':', '0'] # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CTRL1_PCIPM_L1_2_ENABLED_YES = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CTRL1_PCIPM_L1_2_ENABLED_NO = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CTRL1_PCIPM_L1_1_ENABLED = ['1', ':', '1'] # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CTRL1_PCIPM_L1_1_ENABLED_YES = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CTRL1_PCIPM_L1_1_ENABLED_NO = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CTRL1_ASPM_L1_2_ENABLED = ['2', ':', '2'] # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CTRL1_ASPM_L1_2_ENABLED_YES = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CTRL1_ASPM_L1_2_ENABLED_NO = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CTRL1_ASPM_L1_1_ENABLED = ['3', ':', '3'] # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CTRL1_ASPM_L1_1_ENABLED_YES = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CTRL1_ASPM_L1_1_ENABLED_NO = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CTRL1_COMMON_MODE_RESTORE_TIME = ['15', ':', '8'] # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CTRL1_LTR_L1_2_THRESHOLD_VALUE = ['25', ':', '16'] # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CTRL1_LTR_L1_2_THRESHOLD_SCALE = ['31', ':', '29'] # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CTRL2_T_POWER_ON_SCALE = ['1', ':', '0'] # macro
NV2080_CTRL_BUS_INFO_PCIE_L1_SS_CTRL2_T_POWER_ON_VALUE = ['7', ':', '3'] # macro
NV2080_CTRL_BUS_INFO_INDEX_SYSMEM_CONNECTION_TYPE_PCIE = (0x00000000) # macro
NV2080_CTRL_BUS_INFO_INDEX_SYSMEM_CONNECTION_TYPE_NVLINK = (0x00000001) # macro
NV2080_CTRL_BUS_INFO_INDEX_SYSMEM_CONNECTION_TYPE_C2C = (0x00000002) # macro
NV2080_CTRL_CMD_BUS_GET_INFO = (0x20801802) # macro
NV2080_CTRL_BUS_GET_INFO_PARAMS_MESSAGE_ID = (0x2) # macro
NV2080_CTRL_CMD_BUS_GET_INFO_V2 = (0x20801823) # macro
NV2080_CTRL_BUS_GET_INFO_V2_PARAMS_MESSAGE_ID = (0x23) # macro
NV2080_CTRL_CMD_BUS_GET_PCI_BAR_INFO = (0x20801803) # macro
NV2080_CTRL_BUS_MAX_PCI_BARS = (8) # macro
NV2080_CTRL_BUS_GET_PCI_BAR_INFO_PARAMS_MESSAGE_ID = (0x3) # macro
NV2080_CTRL_CMD_BUS_SET_PCIE_LINK_WIDTH = (0x20801804) # macro
NV2080_CTRL_BUS_SET_PCIE_LINK_WIDTH_PARAMS_MESSAGE_ID = (0x4) # macro
NV2080_CTRL_BUS_SET_PCIE_LINK_WIDTH_ERROR_PSTATE = (0x00000001) # macro
NV2080_CTRL_BUS_SET_PCIE_LINK_WIDTH_ERROR_PCIE_CFG_ACCESS = (0x00000002) # macro
NV2080_CTRL_BUS_SET_PCIE_LINK_WIDTH_ERROR_TRAINING = (0x00000004) # macro
NV2080_CTRL_CMD_BUS_SET_PCIE_SPEED = (0x20801805) # macro
NV2080_CTRL_BUS_SET_PCIE_SPEED_PARAMS_MESSAGE_ID = (0x5) # macro
NV2080_CTRL_BUS_SET_PCIE_SPEED_2500MBPS = (0x00000001) # macro
NV2080_CTRL_BUS_SET_PCIE_SPEED_5000MBPS = (0x00000002) # macro
NV2080_CTRL_BUS_SET_PCIE_SPEED_8000MBPS = (0x00000003) # macro
NV2080_CTRL_BUS_SET_PCIE_SPEED_16000MBPS = (0x00000004) # macro
NV2080_CTRL_BUS_SET_PCIE_SPEED_32000MBPS = (0x00000005) # macro
NV2080_CTRL_BUS_SET_PCIE_SPEED_64000MBPS = (0x00000006) # macro
NV2080_CTRL_CMD_BUS_SET_HWBC_UPSTREAM_PCIE_SPEED = (0x20801806) # macro
NV2080_CTRL_BUS_SET_HWBC_UPSTREAM_PCIE_SPEED_PARAMS_MESSAGE_ID = (0x6) # macro
NV2080_CTRL_BUS_SET_HWBC_UPSTREAM_PCIE_SPEED_2500MBPS = (0x00000001) # macro
NV2080_CTRL_BUS_SET_HWBC_UPSTREAM_PCIE_SPEED_5000MBPS = (0x00000002) # macro
NV2080_CTRL_CMD_BUS_GET_HWBC_UPSTREAM_PCIE_SPEED = (0x20801807) # macro
NV2080_CTRL_BUS_GET_HWBC_UPSTREAM_PCIE_SPEED_PARAMS_MESSAGE_ID = (0x7) # macro
NV2080_CTRL_BUS_GET_HWBC_UPSTREAM_PCIE_SPEED_2500MBPS = (0x00000001) # macro
NV2080_CTRL_BUS_GET_HWBC_UPSTREAM_PCIE_SPEED_5000MBPS = (0x00000002) # macro
NV2080_CTRL_CMD_BUS_MAP_BAR2 = (0x20801809) # macro
NV2080_CTRL_BUS_MAP_BAR2_PARAMS_MESSAGE_ID = (0x9) # macro
NV2080_CTRL_CMD_BUS_UNMAP_BAR2 = (0x2080180a) # macro
NV2080_CTRL_BUS_UNMAP_BAR2_PARAMS_MESSAGE_ID = (0xA) # macro
NV2080_CTRL_CMD_BUS_VERIFY_BAR2 = (0x2080180b) # macro
NV2080_CTRL_BUS_VERIFY_BAR2_PARAMS_MESSAGE_ID = (0xB) # macro
NV2080_CTRL_CMD_BUS_HWBC_GET_UPSTREAM_BAR0 = (0x2080180e) # macro
NV2080_CTRL_BUS_HWBC_GET_UPSTREAM_BAR0_PARAMS_MESSAGE_ID = (0xE) # macro
NV2080_CTRL_CMD_BUS_SERVICE_GPU_MULTIFUNC_STATE = (0x20801812) # macro
NV2080_CTRL_BUS_SERVICE_GPU_MULTIFUNC_STATE_PARAMS_MESSAGE_ID = (0x12) # macro
NV2080_CTRL_BUS_ENABLE_GPU_MULTIFUNC_STATE = (0x00000000) # macro
NV2080_CTRL_BUS_DISABLE_GPU_MULTIFUNC_STATE = (0x00000001) # macro
NV2080_CTRL_BUS_GET_GPU_MULTIFUNC_STATE = (0x00000002) # macro
NV2080_CTRL_CMD_BUS_GET_PEX_COUNTERS = (0x20801813) # macro
NV2080_CTRL_PEX_MAX_COUNTER_TYPES = 31 # macro
NV2080_CTRL_BUS_GET_PEX_COUNTERS_PARAMS_MESSAGE_ID = (0x13) # macro
NV2080_CTRL_BUS_PEX_COUNTER_TYPE = 0x00000000 # macro
NV2080_CTRL_BUS_PEX_COUNTER_RECEIVER_ERRORS = 0x00000001 # macro
NV2080_CTRL_BUS_PEX_COUNTER_REPLAY_COUNT = 0x00000002 # macro
NV2080_CTRL_BUS_PEX_COUNTER_REPLAY_ROLLOVER_COUNT = 0x00000004 # macro
NV2080_CTRL_BUS_PEX_COUNTER_BAD_DLLP_COUNT = 0x00000008 # macro
NV2080_CTRL_BUS_PEX_COUNTER_BAD_TLP_COUNT = 0x00000010 # macro
NV2080_CTRL_BUS_PEX_COUNTER_8B10B_ERRORS_COUNT = 0x00000020 # macro
NV2080_CTRL_BUS_PEX_COUNTER_SYNC_HEADER_ERRORS_COUNT = 0x00000040 # macro
NV2080_CTRL_BUS_PEX_COUNTER_LCRC_ERRORS_COUNT = 0x00000080 # macro
NV2080_CTRL_BUS_PEX_COUNTER_FAILED_L0S_EXITS_COUNT = 0x00000100 # macro
NV2080_CTRL_BUS_PEX_COUNTER_NAKS_SENT_COUNT = 0x00000200 # macro
NV2080_CTRL_BUS_PEX_COUNTER_NAKS_RCVD_COUNT = 0x00000400 # macro
NV2080_CTRL_BUS_PEX_COUNTER_LANE_ERRORS = 0x00000800 # macro
NV2080_CTRL_BUS_PEX_COUNTER_L1_TO_RECOVERY_COUNT = 0x00001000 # macro
NV2080_CTRL_BUS_PEX_COUNTER_L0_TO_RECOVERY_COUNT = 0x00002000 # macro
NV2080_CTRL_BUS_PEX_COUNTER_RECOVERY_COUNT = 0x00004000 # macro
NV2080_CTRL_BUS_PEX_COUNTER_CHIPSET_XMIT_L0S_ENTRY_COUNT = 0x00008000 # macro
NV2080_CTRL_BUS_PEX_COUNTER_GPU_XMIT_L0S_ENTRY_COUNT = 0x00010000 # macro
NV2080_CTRL_BUS_PEX_COUNTER_L1_ENTRY_COUNT = 0x00020000 # macro
NV2080_CTRL_BUS_PEX_COUNTER_L1P_ENTRY_COUNT = 0x00040000 # macro
NV2080_CTRL_BUS_PEX_COUNTER_DEEP_L1_ENTRY_COUNT = 0x00080000 # macro
NV2080_CTRL_BUS_PEX_COUNTER_ASLM_COUNT = 0x00100000 # macro
NV2080_CTRL_BUS_PEX_COUNTER_TOTAL_CORR_ERROR_COUNT = 0x00200000 # macro
NV2080_CTRL_BUS_PEX_COUNTER_CORR_ERROR_COUNT = 0x00400000 # macro
NV2080_CTRL_BUS_PEX_COUNTER_NON_FATAL_ERROR_COUNT = 0x00800000 # macro
NV2080_CTRL_BUS_PEX_COUNTER_FATAL_ERROR_COUNT = 0x01000000 # macro
NV2080_CTRL_BUS_PEX_COUNTER_UNSUPP_REQ_COUNT = 0x02000000 # macro
NV2080_CTRL_BUS_PEX_COUNTER_L1_1_ENTRY_COUNT = 0x04000000 # macro
NV2080_CTRL_BUS_PEX_COUNTER_L1_2_ENTRY_COUNT = 0x08000000 # macro
NV2080_CTRL_BUS_PEX_COUNTER_L1_2_ABORT_COUNT = 0x10000000 # macro
NV2080_CTRL_BUS_PEX_COUNTER_L1SS_TO_DEEP_L1_TIMEOUT_COUNT = 0x20000000 # macro
NV2080_CTRL_BUS_PEX_COUNTER_L1_SHORT_DURATION_COUNT = 0x40000000 # macro
NV2080_CTRL_CMD_BUS_CLEAR_PEX_COUNTERS = (0x20801814) # macro
NV2080_CTRL_BUS_CLEAR_PEX_COUNTERS_PARAMS_MESSAGE_ID = (0x14) # macro
NV2080_CTRL_CMD_BUS_FREEZE_PEX_COUNTERS = (0x20801815) # macro
NV2080_CTRL_BUS_FREEZE_PEX_COUNTERS_PARAMS_MESSAGE_ID = (0x15) # macro
NV2080_CTRL_CMD_BUS_GET_PEX_LANE_COUNTERS = (0x20801816) # macro
NV2080_CTRL_PEX_MAX_LANES = 16 # macro
NV2080_CTRL_CMD_BUS_GET_PEX_LANE_COUNTERS_PARAMS_MESSAGE_ID = (0x16) # macro
NV2080_CTRL_BUS_PEX_COUNTER_LANE_TYPE = 0x00000000 # macro
NV2080_CTRL_BUS_PEX_COUNTER_LANE_SYNC_HDR_CODING_ERR = 0x00000001 # macro
NV2080_CTRL_BUS_PEX_COUNTER_LANE_SYNC_HDR_ORDER_ERR = 0x00000002 # macro
NV2080_CTRL_BUS_PEX_COUNTER_LANE_OS_DATA_SEQ_ERR = 0x00000004 # macro
NV2080_CTRL_BUS_PEX_COUNTER_LANE_TSX_DATA_SEQ_ERR = 0x00000008 # macro
NV2080_CTRL_BUS_PEX_COUNTER_LANE_SKPOS_LFSR_ERR = 0x00000010 # macro
NV2080_CTRL_BUS_PEX_COUNTER_LANE_RX_CLK_FIFO_OVERFLOW = 0x00000020 # macro
NV2080_CTRL_BUS_PEX_COUNTER_LANE_ELASTIC_FIFO_OVERFLOW = 0x00000040 # macro
NV2080_CTRL_BUS_PEX_COUNTER_LANE_RCVD_LINK_NUM_ERR = 0x00000080 # macro
NV2080_CTRL_BUS_PEX_COUNTER_LANE_RCVD_LANE_NUM_ERR = 0x00000100 # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_LTR_LATENCY = (0x20801817) # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_LTR_LATENCY_PARAMS_MESSAGE_ID = (0x17) # macro
NV2080_CTRL_CMD_BUS_SET_PCIE_LTR_LATENCY = (0x20801818) # macro
NV2080_CTRL_CMD_BUS_SET_PCIE_LTR_LATENCY_PARAMS_MESSAGE_ID = (0x18) # macro
NV2080_CTRL_BUS_PEX_UTIL_COUNTER_TX_BYTES = 0x00000001 # macro
NV2080_CTRL_BUS_PEX_UTIL_COUNTER_RX_BYTES = 0x00000002 # macro
NV2080_CTRL_BUS_PEX_UTIL_COUNTER_TX_L0 = 0x00000004 # macro
NV2080_CTRL_BUS_PEX_UTIL_COUNTER_RX_L0 = 0x00000008 # macro
NV2080_CTRL_BUS_PEX_UTIL_COUNTER_TX_L0S = 0x00000010 # macro
NV2080_CTRL_BUS_PEX_UTIL_COUNTER_RX_L0S = 0x00000020 # macro
NV2080_CTRL_BUS_PEX_UTIL_COUNTER_NON_L0_L0S = 0x00000040 # macro
NV2080_CTRL_PEX_UTIL_MAX_COUNTER_TYPES = 7 # macro
NV2080_CTRL_CMD_BUS_GET_PEX_UTIL_COUNTERS = (0x20801819) # macro
NV2080_CTRL_BUS_GET_PEX_UTIL_COUNTERS_PARAMS_MESSAGE_ID = (0x19) # macro
NV2080_CTRL_CMD_BUS_CLEAR_PEX_UTIL_COUNTERS = (0x20801820) # macro
NV2080_CTRL_BUS_CLEAR_PEX_UTIL_COUNTERS_PARAMS_MESSAGE_ID = (0x20) # macro
NV2080_CTRL_CMD_BUS_GET_BFD = (0x20801821) # macro
NV2080_CTRL_BUS_GET_BFD_PARAMSARR_MESSAGE_ID = (0x21) # macro
NV2080_CTRL_ASPM_DISABLE_FLAGS_L1_MASK_REGKEY_OVERRIDE = 0x00000000 # macro
NV2080_CTRL_ASPM_DISABLE_FLAGS_OS_RM_MAKES_POLICY_DECISIONS = 0x00000001 # macro
NV2080_CTRL_ASPM_DISABLE_FLAGS_GPU_BEHIND_BRIDGE = 0x00000002 # macro
NV2080_CTRL_ASPM_DISABLE_FLAGS_GPU_UPSTREAM_PORT_L1_UNSUPPORTED = 0x00000003 # macro
NV2080_CTRL_ASPM_DISABLE_FLAGS_GPU_UPSTREAM_PORT_L1_POR_SUPPORTED = 0x00000004 # macro
NV2080_CTRL_ASPM_DISABLE_FLAGS_GPU_UPSTREAM_PORT_L1_POR_MOBILE_ONLY = 0x00000005 # macro
NV2080_CTRL_ASPM_DISABLE_FLAGS_CL_ASPM_L1_CHIPSET_DISABLED = 0x00000006 # macro
NV2080_CTRL_ASPM_DISABLE_FLAGS_CL_ASPM_L1_CHIPSET_ENABLED_MOBILE_ONLY = 0x00000007 # macro
NV2080_CTRL_ASPM_DISABLE_FLAGS_BIF_ENABLE_ASPM_DT_L1 = 0x00000008 # macro
NV2080_CTRL_ASPM_DISABLE_FLAGS_MAX_FLAGS = 9 # macro
NV2080_CTRL_CMD_BUS_GET_ASPM_DISABLE_FLAGS = (0x20801822) # macro
NV2080_CTRL_BUS_GET_ASPM_DISABLE_FLAGS_PARAMS_MESSAGE_ID = (0x22) # macro
NV2080_CTRL_CMD_BUS_CONTROL_PUBLIC_ASPM_BITS = (0x20801824) # macro
NV2080_CTRL_CMD_BUS_CONTROL_PUBLIC_ASPM_BITS_PARAMS_MESSAGE_ID = (0x24) # macro
NV2080_CTRL_CMD_BUS_GET_NVLINK_PEER_ID_MASK = (0x20801825) # macro
NV2080_CTRL_BUS_MAX_NUM_GPUS = 32 # macro
NV2080_CTRL_BUS_GET_NVLINK_PEER_ID_MASK_PARAMS_MESSAGE_ID = (0x25) # macro
NV2080_CTRL_CMD_BUS_SET_EOM_PARAMETERS = (0x20801826) # macro
NV2080_CTRL_CMD_BUS_SET_EOM_PARAMETERS_PARAMS_MESSAGE_ID = (0x26) # macro
NV2080_CTRL_CMD_BUS_GET_UPHY_DLN_CFG_SPACE = (0x20801827) # macro
NV2080_CTRL_CMD_BUS_GET_UPHY_DLN_CFG_SPACE_PARAMS_MESSAGE_ID = (0x27) # macro
NV2080_CTRL_CMD_BUS_GET_EOM_STATUS = (0x20801828) # macro
NV2080_CTRL_BUS_MAX_NUM_LANES = 32 # macro
NV2080_CTRL_BUS_GET_EOM_STATUS_PARAMS_MESSAGE_ID = (0x28) # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS = (0x20801829) # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_PARAMS_MESSAGE_ID = (0x29) # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_FETCHADD_32 = ['0', ':', '0'] # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_FETCHADD_32_YES = (0x00000001) # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_FETCHADD_32_NO = (0x00000000) # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_FETCHADD_64 = ['1', ':', '1'] # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_FETCHADD_64_YES = (0x00000001) # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_FETCHADD_64_NO = (0x00000000) # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_SWAP_32 = ['2', ':', '2'] # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_SWAP_32_YES = (0x00000001) # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_SWAP_32_NO = (0x00000000) # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_SWAP_64 = ['3', ':', '3'] # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_SWAP_64_YES = (0x00000001) # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_SWAP_64_NO = (0x00000000) # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_CAS_32 = ['4', ':', '4'] # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_CAS_32_YES = (0x00000001) # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_CAS_32_NO = (0x00000000) # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_CAS_64 = ['5', ':', '5'] # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_CAS_64_YES = (0x00000001) # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_CAS_64_NO = (0x00000000) # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_CAS_128 = ['6', ':', '6'] # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_CAS_128_YES = (0x00000001) # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_CAS_128_NO = (0x00000000) # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_SUPPORTED_GPU_ATOMICS = (0x2080182a) # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_OP_TYPE_IADD = 0 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_OP_TYPE_IMIN = 1 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_OP_TYPE_IMAX = 2 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_OP_TYPE_INC = 3 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_OP_TYPE_DEC = 4 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_OP_TYPE_IAND = 5 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_OP_TYPE_IOR = 6 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_OP_TYPE_IXOR = 7 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_OP_TYPE_EXCH = 8 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_OP_TYPE_CAS = 9 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_OP_TYPE_FADD = 10 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_OP_TYPE_FMIN = 11 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_OP_TYPE_FMAX = 12 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_OP_TYPE_COUNT = 13 # macro
NV2080_CTRL_CMD_BUS_GET_PCIE_SUPPORTED_GPU_ATOMICS_PARAMS_MESSAGE_ID = (0x2A) # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_ATTRIB_SCALAR = ['0', ':', '0'] # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_ATTRIB_SCALAR_YES = 1 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_ATTRIB_SCALAR_NO = 0 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_ATTRIB_VECTOR = ['1', ':', '1'] # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_ATTRIB_VECTOR_YES = 1 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_ATTRIB_VECTOR_NO = 0 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_ATTRIB_REDUCTION = ['2', ':', '2'] # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_ATTRIB_REDUCTION_YES = 1 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_ATTRIB_REDUCTION_NO = 0 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_ATTRIB_SIZE_32 = ['3', ':', '3'] # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_ATTRIB_SIZE_32_YES = 1 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_ATTRIB_SIZE_32_NO = 0 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_ATTRIB_SIZE_64 = ['4', ':', '4'] # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_ATTRIB_SIZE_64_YES = 1 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_ATTRIB_SIZE_64_NO = 0 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_ATTRIB_SIZE_128 = ['5', ':', '5'] # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_ATTRIB_SIZE_128_YES = 1 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_ATTRIB_SIZE_128_NO = 0 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_ATTRIB_SIGNED = ['6', ':', '6'] # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_ATTRIB_SIGNED_YES = 1 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_ATTRIB_SIGNED_NO = 0 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_ATTRIB_UNSIGNED = ['7', ':', '7'] # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_ATTRIB_UNSIGNED_YES = 1 # macro
NV2080_CTRL_PCIE_SUPPORTED_GPU_ATOMICS_ATTRIB_UNSIGNED_NO = 0 # macro
NV2080_CTRL_CMD_BUS_GET_C2C_INFO = (0x2080182b) # macro
NV2080_CTRL_CMD_BUS_GET_C2C_INFO_PARAMS_MESSAGE_ID = (0x2B) # macro
NV2080_CTRL_BUS_GET_C2C_INFO_REMOTE_TYPE_CPU = 1 # macro
NV2080_CTRL_BUS_GET_C2C_INFO_REMOTE_TYPE_GPU = 2 # macro
NV2080_CTRL_CMD_BUS_SYSMEM_ACCESS = (0x2080182c) # macro
NV2080_CTRL_BUS_SYSMEM_ACCESS_PARAMS_MESSAGE_ID = (0x2C) # macro
NV2080_CTRL_CMD_BUS_SET_P2P_MAPPING = (0x2080182e) # macro
NV2080_CTRL_CMD_BUS_SET_P2P_MAPPING_CONNECTION_TYPE_INVALID = 0 # macro
NV2080_CTRL_CMD_BUS_SET_P2P_MAPPING_CONNECTION_TYPE_NVLINK = 1 # macro
NV2080_CTRL_CMD_BUS_SET_P2P_MAPPING_CONNECTION_TYPE_PCIE = 2 # macro
NV2080_CTRL_CMD_BUS_SET_P2P_MAPPING_CONNECTION_TYPE_PCIE_BAR1 = 3 # macro
NV2080_CTRL_CMD_BUS_SET_P2P_MAPPING_CONNECTION_TYPE_C2C = 4 # macro
NV2080_SET_P2P_MAPPING_UUID_LEN = 16 # macro
NV2080_CTRL_BUS_SET_P2P_MAPPING_PARAMS_MESSAGE_ID = (0x2E) # macro
NV2080_CTRL_CMD_BUS_UNSET_P2P_MAPPING = (0x2080182f) # macro
NV2080_CTRL_BUS_UNSET_P2P_MAPPING_PARAMS_MESSAGE_ID = (0x2F) # macro
class struct_NV2080_CTRL_BUS_GET_PCI_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_GET_PCI_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_GET_PCI_INFO_PARAMS._fields_ = [
    ('pciDeviceId', ctypes.c_uint32),
    ('pciSubSystemId', ctypes.c_uint32),
    ('pciRevisionId', ctypes.c_uint32),
    ('pciExtDeviceId', ctypes.c_uint32),
]

NV2080_CTRL_BUS_GET_PCI_INFO_PARAMS = struct_NV2080_CTRL_BUS_GET_PCI_INFO_PARAMS
NV2080_CTRL_BUS_INFO = struct_NVXXXX_CTRL_XXX_INFO
class struct_NV2080_CTRL_BUS_GET_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_GET_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_GET_INFO_PARAMS._fields_ = [
    ('busInfoListSize', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('busInfoList', ctypes.POINTER(None)),
]

NV2080_CTRL_BUS_GET_INFO_PARAMS = struct_NV2080_CTRL_BUS_GET_INFO_PARAMS
class struct_NV2080_CTRL_BUS_GET_INFO_V2_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_GET_INFO_V2_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_GET_INFO_V2_PARAMS._fields_ = [
    ('busInfoListSize', ctypes.c_uint32),
    ('busInfoList', struct_NVXXXX_CTRL_XXX_INFO * 52),
]

NV2080_CTRL_BUS_GET_INFO_V2_PARAMS = struct_NV2080_CTRL_BUS_GET_INFO_V2_PARAMS
class struct_NV2080_CTRL_BUS_PCI_BAR_INFO(Structure):
    pass

struct_NV2080_CTRL_BUS_PCI_BAR_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_PCI_BAR_INFO._fields_ = [
    ('flags', ctypes.c_uint32),
    ('barSize', ctypes.c_uint32),
    ('barSizeBytes', ctypes.c_uint64),
    ('barOffset', ctypes.c_uint64),
]

NV2080_CTRL_BUS_PCI_BAR_INFO = struct_NV2080_CTRL_BUS_PCI_BAR_INFO
class struct_NV2080_CTRL_BUS_GET_PCI_BAR_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_GET_PCI_BAR_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_GET_PCI_BAR_INFO_PARAMS._fields_ = [
    ('pciBarCount', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('pciBarInfo', struct_NV2080_CTRL_BUS_PCI_BAR_INFO * 8),
]

NV2080_CTRL_BUS_GET_PCI_BAR_INFO_PARAMS = struct_NV2080_CTRL_BUS_GET_PCI_BAR_INFO_PARAMS
class struct_NV2080_CTRL_BUS_SET_PCIE_LINK_WIDTH_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_SET_PCIE_LINK_WIDTH_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_SET_PCIE_LINK_WIDTH_PARAMS._fields_ = [
    ('pcieLinkWidth', ctypes.c_uint32),
    ('failingReason', ctypes.c_uint32),
]

NV2080_CTRL_BUS_SET_PCIE_LINK_WIDTH_PARAMS = struct_NV2080_CTRL_BUS_SET_PCIE_LINK_WIDTH_PARAMS
class struct_NV2080_CTRL_BUS_SET_PCIE_SPEED_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_SET_PCIE_SPEED_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_SET_PCIE_SPEED_PARAMS._fields_ = [
    ('busSpeed', ctypes.c_uint32),
]

NV2080_CTRL_BUS_SET_PCIE_SPEED_PARAMS = struct_NV2080_CTRL_BUS_SET_PCIE_SPEED_PARAMS
class struct_NV2080_CTRL_BUS_SET_HWBC_UPSTREAM_PCIE_SPEED_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_SET_HWBC_UPSTREAM_PCIE_SPEED_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_SET_HWBC_UPSTREAM_PCIE_SPEED_PARAMS._fields_ = [
    ('busSpeed', ctypes.c_uint32),
    ('primaryBus', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_BUS_SET_HWBC_UPSTREAM_PCIE_SPEED_PARAMS = struct_NV2080_CTRL_BUS_SET_HWBC_UPSTREAM_PCIE_SPEED_PARAMS
class struct_NV2080_CTRL_BUS_GET_HWBC_UPSTREAM_PCIE_SPEED_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_GET_HWBC_UPSTREAM_PCIE_SPEED_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_GET_HWBC_UPSTREAM_PCIE_SPEED_PARAMS._fields_ = [
    ('busSpeed', ctypes.c_uint32),
    ('primaryBus', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_BUS_GET_HWBC_UPSTREAM_PCIE_SPEED_PARAMS = struct_NV2080_CTRL_BUS_GET_HWBC_UPSTREAM_PCIE_SPEED_PARAMS
class struct_NV2080_CTRL_BUS_MAP_BAR2_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_MAP_BAR2_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_MAP_BAR2_PARAMS._fields_ = [
    ('hMemory', ctypes.c_uint32),
]

NV2080_CTRL_BUS_MAP_BAR2_PARAMS = struct_NV2080_CTRL_BUS_MAP_BAR2_PARAMS
class struct_NV2080_CTRL_BUS_UNMAP_BAR2_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_UNMAP_BAR2_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_UNMAP_BAR2_PARAMS._fields_ = [
    ('hMemory', ctypes.c_uint32),
]

NV2080_CTRL_BUS_UNMAP_BAR2_PARAMS = struct_NV2080_CTRL_BUS_UNMAP_BAR2_PARAMS
class struct_NV2080_CTRL_BUS_VERIFY_BAR2_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_VERIFY_BAR2_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_VERIFY_BAR2_PARAMS._fields_ = [
    ('hMemory', ctypes.c_uint32),
    ('offset', ctypes.c_uint32),
    ('size', ctypes.c_uint32),
]

NV2080_CTRL_BUS_VERIFY_BAR2_PARAMS = struct_NV2080_CTRL_BUS_VERIFY_BAR2_PARAMS
class struct_NV2080_CTRL_BUS_HWBC_GET_UPSTREAM_BAR0_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_HWBC_GET_UPSTREAM_BAR0_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_HWBC_GET_UPSTREAM_BAR0_PARAMS._fields_ = [
    ('physBAR0', ctypes.c_uint64),
    ('primaryBus', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 7),
]

NV2080_CTRL_BUS_HWBC_GET_UPSTREAM_BAR0_PARAMS = struct_NV2080_CTRL_BUS_HWBC_GET_UPSTREAM_BAR0_PARAMS
class struct_NV2080_CTRL_BUS_SERVICE_GPU_MULTIFUNC_STATE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_SERVICE_GPU_MULTIFUNC_STATE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_SERVICE_GPU_MULTIFUNC_STATE_PARAMS._fields_ = [
    ('command', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('deviceState', ctypes.c_uint32),
]

NV2080_CTRL_BUS_SERVICE_GPU_MULTIFUNC_STATE_PARAMS = struct_NV2080_CTRL_BUS_SERVICE_GPU_MULTIFUNC_STATE_PARAMS
class struct_NV2080_CTRL_BUS_GET_PEX_COUNTERS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_GET_PEX_COUNTERS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_GET_PEX_COUNTERS_PARAMS._fields_ = [
    ('pexCounterMask', ctypes.c_uint32),
    ('pexTotalCorrectableErrors', ctypes.c_uint32),
    ('pexCorrectableErrors', ctypes.c_uint16),
    ('pexTotalNonFatalErrors', ctypes.c_ubyte),
    ('pexTotalFatalErrors', ctypes.c_ubyte),
    ('pexTotalUnsupportedReqs', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte),
    ('pexCounters', ctypes.c_uint16 * 31),
]

NV2080_CTRL_BUS_GET_PEX_COUNTERS_PARAMS = struct_NV2080_CTRL_BUS_GET_PEX_COUNTERS_PARAMS
class struct_NV2080_CTRL_BUS_CLEAR_PEX_COUNTERS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_CLEAR_PEX_COUNTERS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_CLEAR_PEX_COUNTERS_PARAMS._fields_ = [
    ('pexCounterMask', ctypes.c_uint32),
]

NV2080_CTRL_BUS_CLEAR_PEX_COUNTERS_PARAMS = struct_NV2080_CTRL_BUS_CLEAR_PEX_COUNTERS_PARAMS
class struct_NV2080_CTRL_BUS_FREEZE_PEX_COUNTERS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_FREEZE_PEX_COUNTERS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_FREEZE_PEX_COUNTERS_PARAMS._fields_ = [
    ('pexCounterMask', ctypes.c_uint32),
    ('bFreezeRmCounter', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_BUS_FREEZE_PEX_COUNTERS_PARAMS = struct_NV2080_CTRL_BUS_FREEZE_PEX_COUNTERS_PARAMS
class struct_NV2080_CTRL_CMD_BUS_GET_PEX_LANE_COUNTERS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_BUS_GET_PEX_LANE_COUNTERS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_BUS_GET_PEX_LANE_COUNTERS_PARAMS._fields_ = [
    ('pexLaneErrorStatus', ctypes.c_uint16),
    ('pexLaneCounter', ctypes.c_ubyte * 16),
]

NV2080_CTRL_CMD_BUS_GET_PEX_LANE_COUNTERS_PARAMS = struct_NV2080_CTRL_CMD_BUS_GET_PEX_LANE_COUNTERS_PARAMS
class struct_NV2080_CTRL_CMD_BUS_GET_PCIE_LTR_LATENCY_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_BUS_GET_PCIE_LTR_LATENCY_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_BUS_GET_PCIE_LTR_LATENCY_PARAMS._fields_ = [
    ('bPexLtrRegkeyOverride', ctypes.c_ubyte),
    ('bPexRootPortLtrSupported', ctypes.c_ubyte),
    ('bPexGpuLtrSupported', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte),
    ('pexLtrSnoopLatencyValue', ctypes.c_uint16),
    ('pexLtrSnoopLatencyScale', ctypes.c_ubyte),
    ('PADDING_1', ctypes.c_ubyte),
    ('pexLtrNoSnoopLatencyValue', ctypes.c_uint16),
    ('pexLtrNoSnoopLatencyScale', ctypes.c_ubyte),
    ('PADDING_2', ctypes.c_ubyte),
]

NV2080_CTRL_CMD_BUS_GET_PCIE_LTR_LATENCY_PARAMS = struct_NV2080_CTRL_CMD_BUS_GET_PCIE_LTR_LATENCY_PARAMS
class struct_NV2080_CTRL_CMD_BUS_SET_PCIE_LTR_LATENCY_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_BUS_SET_PCIE_LTR_LATENCY_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_BUS_SET_PCIE_LTR_LATENCY_PARAMS._fields_ = [
    ('pexLtrSnoopLatencyValue', ctypes.c_uint16),
    ('pexLtrSnoopLatencyScale', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte),
    ('pexLtrNoSnoopLatencyValue', ctypes.c_uint16),
    ('pexLtrNoSnoopLatencyScale', ctypes.c_ubyte),
    ('PADDING_1', ctypes.c_ubyte),
]

NV2080_CTRL_CMD_BUS_SET_PCIE_LTR_LATENCY_PARAMS = struct_NV2080_CTRL_CMD_BUS_SET_PCIE_LTR_LATENCY_PARAMS
class struct_NV2080_CTRL_BUS_GET_PEX_UTIL_COUNTERS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_GET_PEX_UTIL_COUNTERS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_GET_PEX_UTIL_COUNTERS_PARAMS._fields_ = [
    ('pexCounterMask', ctypes.c_uint32),
    ('pexCounters', ctypes.c_uint32 * 7),
]

NV2080_CTRL_BUS_GET_PEX_UTIL_COUNTERS_PARAMS = struct_NV2080_CTRL_BUS_GET_PEX_UTIL_COUNTERS_PARAMS
class struct_NV2080_CTRL_BUS_CLEAR_PEX_UTIL_COUNTERS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_CLEAR_PEX_UTIL_COUNTERS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_CLEAR_PEX_UTIL_COUNTERS_PARAMS._fields_ = [
    ('pexCounterMask', ctypes.c_uint32),
]

NV2080_CTRL_BUS_CLEAR_PEX_UTIL_COUNTERS_PARAMS = struct_NV2080_CTRL_BUS_CLEAR_PEX_UTIL_COUNTERS_PARAMS
class struct_NV2080_CTRL_BUS_GET_BFD_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_GET_BFD_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_GET_BFD_PARAMS._fields_ = [
    ('valid', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte),
    ('deviceID', ctypes.c_uint16),
    ('vendorID', ctypes.c_uint16),
    ('PADDING_1', ctypes.c_ubyte * 2),
    ('domain', ctypes.c_uint32),
    ('bus', ctypes.c_uint16),
    ('device', ctypes.c_uint16),
    ('function', ctypes.c_ubyte),
    ('PADDING_2', ctypes.c_ubyte * 3),
]

NV2080_CTRL_BUS_GET_BFD_PARAMS = struct_NV2080_CTRL_BUS_GET_BFD_PARAMS
class struct_NV2080_CTRL_BUS_GET_BFD_PARAMSARR(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('params', struct_NV2080_CTRL_BUS_GET_BFD_PARAMS * 32),
     ]

NV2080_CTRL_BUS_GET_BFD_PARAMSARR = struct_NV2080_CTRL_BUS_GET_BFD_PARAMSARR
class struct_NV2080_CTRL_BUS_GET_ASPM_DISABLE_FLAGS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_GET_ASPM_DISABLE_FLAGS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_GET_ASPM_DISABLE_FLAGS_PARAMS._fields_ = [
    ('aspmDisableFlags', ctypes.c_ubyte * 9),
]

NV2080_CTRL_BUS_GET_ASPM_DISABLE_FLAGS_PARAMS = struct_NV2080_CTRL_BUS_GET_ASPM_DISABLE_FLAGS_PARAMS
class struct_NV2080_CTRL_CMD_BUS_CONTROL_PUBLIC_ASPM_BITS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_BUS_CONTROL_PUBLIC_ASPM_BITS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_BUS_CONTROL_PUBLIC_ASPM_BITS_PARAMS._fields_ = [
    ('bEnable', ctypes.c_ubyte),
]

NV2080_CTRL_CMD_BUS_CONTROL_PUBLIC_ASPM_BITS_PARAMS = struct_NV2080_CTRL_CMD_BUS_CONTROL_PUBLIC_ASPM_BITS_PARAMS
class struct_NV2080_CTRL_BUS_GET_NVLINK_PEER_ID_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_GET_NVLINK_PEER_ID_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_GET_NVLINK_PEER_ID_MASK_PARAMS._fields_ = [
    ('nvlinkPeerIdMask', ctypes.c_uint32 * 32),
]

NV2080_CTRL_BUS_GET_NVLINK_PEER_ID_MASK_PARAMS = struct_NV2080_CTRL_BUS_GET_NVLINK_PEER_ID_MASK_PARAMS
class struct_NV2080_CTRL_CMD_BUS_SET_EOM_PARAMETERS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_BUS_SET_EOM_PARAMETERS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_BUS_SET_EOM_PARAMETERS_PARAMS._fields_ = [
    ('eomMode', ctypes.c_ubyte),
    ('eomNblks', ctypes.c_ubyte),
    ('eomNerrs', ctypes.c_ubyte),
]

NV2080_CTRL_CMD_BUS_SET_EOM_PARAMETERS_PARAMS = struct_NV2080_CTRL_CMD_BUS_SET_EOM_PARAMETERS_PARAMS
class struct_NV2080_CTRL_CMD_BUS_GET_UPHY_DLN_CFG_SPACE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_BUS_GET_UPHY_DLN_CFG_SPACE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_BUS_GET_UPHY_DLN_CFG_SPACE_PARAMS._fields_ = [
    ('regAddress', ctypes.c_uint32),
    ('laneSelectMask', ctypes.c_uint32),
    ('regValue', ctypes.c_uint16),
    ('PADDING_0', ctypes.c_ubyte * 2),
]

NV2080_CTRL_CMD_BUS_GET_UPHY_DLN_CFG_SPACE_PARAMS = struct_NV2080_CTRL_CMD_BUS_GET_UPHY_DLN_CFG_SPACE_PARAMS
class struct_NV2080_CTRL_BUS_GET_EOM_STATUS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_GET_EOM_STATUS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_GET_EOM_STATUS_PARAMS._fields_ = [
    ('eomMode', ctypes.c_ubyte),
    ('eomNblks', ctypes.c_ubyte),
    ('eomNerrs', ctypes.c_ubyte),
    ('eomBerEyeSel', ctypes.c_ubyte),
    ('eomPamEyeSel', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('laneMask', ctypes.c_uint32),
    ('eomStatus', ctypes.c_uint16 * 32),
]

NV2080_CTRL_BUS_GET_EOM_STATUS_PARAMS = struct_NV2080_CTRL_BUS_GET_EOM_STATUS_PARAMS
class struct_NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_PARAMS._fields_ = [
    ('atomicsCaps', ctypes.c_uint32),
]

NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_PARAMS = struct_NV2080_CTRL_CMD_BUS_GET_PCIE_REQ_ATOMICS_CAPS_PARAMS
class struct_NV2080_CTRL_CMD_BUS_GET_PCIE_SUPPORTED_GPU_ATOMICS_PARAMS(Structure):
    pass

class struct_NV2080_CTRL_CMD_BUS_GET_PCIE_SUPPORTED_GPU_ATOMICS_PARAMS_0(Structure):
    pass

struct_NV2080_CTRL_CMD_BUS_GET_PCIE_SUPPORTED_GPU_ATOMICS_PARAMS_0._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_BUS_GET_PCIE_SUPPORTED_GPU_ATOMICS_PARAMS_0._fields_ = [
    ('bSupported', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('attributes', ctypes.c_uint32),
]

struct_NV2080_CTRL_CMD_BUS_GET_PCIE_SUPPORTED_GPU_ATOMICS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_BUS_GET_PCIE_SUPPORTED_GPU_ATOMICS_PARAMS._fields_ = [
    ('atomicOp', struct_NV2080_CTRL_CMD_BUS_GET_PCIE_SUPPORTED_GPU_ATOMICS_PARAMS_0 * 13),
]

NV2080_CTRL_CMD_BUS_GET_PCIE_SUPPORTED_GPU_ATOMICS_PARAMS = struct_NV2080_CTRL_CMD_BUS_GET_PCIE_SUPPORTED_GPU_ATOMICS_PARAMS
class struct_NV2080_CTRL_CMD_BUS_GET_C2C_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_BUS_GET_C2C_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_BUS_GET_C2C_INFO_PARAMS._fields_ = [
    ('bIsLinkUp', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('nrLinks', ctypes.c_uint32),
    ('maxNrLinks', ctypes.c_uint32),
    ('linkMask', ctypes.c_uint32),
    ('perLinkBwMBps', ctypes.c_uint32),
    ('perLinkLaneWidth', ctypes.c_uint32),
    ('remoteType', ctypes.c_uint32),
]

NV2080_CTRL_CMD_BUS_GET_C2C_INFO_PARAMS = struct_NV2080_CTRL_CMD_BUS_GET_C2C_INFO_PARAMS
class struct_NV2080_CTRL_BUS_SYSMEM_ACCESS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_SYSMEM_ACCESS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_SYSMEM_ACCESS_PARAMS._fields_ = [
    ('bDisable', ctypes.c_ubyte),
]

NV2080_CTRL_BUS_SYSMEM_ACCESS_PARAMS = struct_NV2080_CTRL_BUS_SYSMEM_ACCESS_PARAMS
class struct_NV2080_CTRL_BUS_SET_P2P_MAPPING_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_SET_P2P_MAPPING_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_SET_P2P_MAPPING_PARAMS._fields_ = [
    ('connectionType', ctypes.c_uint32),
    ('peerId', ctypes.c_uint32),
    ('bEgmPeer', ctypes.c_ubyte),
    ('bSpaAccessOnly', ctypes.c_ubyte),
    ('bUseUuid', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte),
    ('remoteGpuId', ctypes.c_uint32),
    ('remoteGpuUuid', ctypes.c_ubyte * 16),
]

NV2080_CTRL_BUS_SET_P2P_MAPPING_PARAMS = struct_NV2080_CTRL_BUS_SET_P2P_MAPPING_PARAMS
class struct_NV2080_CTRL_BUS_UNSET_P2P_MAPPING_PARAMS(Structure):
    pass

struct_NV2080_CTRL_BUS_UNSET_P2P_MAPPING_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_BUS_UNSET_P2P_MAPPING_PARAMS._fields_ = [
    ('connectionType', ctypes.c_uint32),
    ('peerId', ctypes.c_uint32),
    ('bUseUuid', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('remoteGpuId', ctypes.c_uint32),
    ('remoteGpuUuid', ctypes.c_ubyte * 16),
]

NV2080_CTRL_BUS_UNSET_P2P_MAPPING_PARAMS = struct_NV2080_CTRL_BUS_UNSET_P2P_MAPPING_PARAMS
NV2080_CTRL_CMD_CE_GET_CAPS = (0x20802a01) # macro
NV2080_CTRL_CE_CAPS_TBL_SIZE = 2 # macro
NV2080_CTRL_CE_GET_CAPS_PARAMS_MESSAGE_ID = (0x1) # macro
NV2080_CTRL_CMD_CE_GET_CAPS_V2 = (0x20802a03) # macro
NV2080_CTRL_CE_GET_CAPS_V2_PARAMS_MESSAGE_ID = (0x3) # macro
# def NV2080_CTRL_CE_GET_CAP(tbl, c):  # macro
#    return (((NvU8)tbl[(1?c)])&(0?c))
NV2080_CTRL_CE_CAPS_CE_GRCE = ['0', ':', '0x01'] # macro
NV2080_CTRL_CE_CAPS_CE_SHARED = ['0', ':', '0x02'] # macro
NV2080_CTRL_CE_CAPS_CE_SYSMEM_READ = ['0', ':', '0x04'] # macro
NV2080_CTRL_CE_CAPS_CE_SYSMEM_WRITE = ['0', ':', '0x08'] # macro
NV2080_CTRL_CE_CAPS_CE_NVLINK_P2P = ['0', ':', '0x10'] # macro
NV2080_CTRL_CE_CAPS_CE_SYSMEM = ['0', ':', '0x20'] # macro
NV2080_CTRL_CE_CAPS_CE_P2P = ['0', ':', '0x40'] # macro
NV2080_CTRL_CE_CAPS_CE_BL_SIZE_GT_64K_SUPPORTED = ['0', ':', '0x80'] # macro
NV2080_CTRL_CE_CAPS_CE_SUPPORTS_NONPIPELINED_BL = ['1', ':', '0x01'] # macro
NV2080_CTRL_CE_CAPS_CE_SUPPORTS_PIPELINED_BL = ['1', ':', '0x02'] # macro
NV2080_CTRL_CE_CAPS_CE_CC_SECURE = ['1', ':', '0x04'] # macro
NV2080_CTRL_CMD_CE_GET_CE_PCE_MASK = (0x20802a02) # macro
NV2080_CTRL_CE_GET_CE_PCE_MASK_PARAMS_MESSAGE_ID = (0x2) # macro
NV2080_CTRL_CMD_CE_SET_PCE_LCE_CONFIG = (0x20802a04) # macro
NV2080_CTRL_MAX_PCES = 32 # macro
NV2080_CTRL_MAX_GRCES = 4 # macro
NV2080_CTRL_CE_SET_PCE_LCE_CONFIG_PARAMS_MESSAGE_ID = (0x4) # macro
NV2080_CTRL_CMD_CE_UPDATE_PCE_LCE_MAPPINGS = (0x20802a05) # macro
NV2080_CTRL_CE_UPDATE_PCE_LCE_MAPPINGS_PARAMS_MESSAGE_ID = (0x5) # macro
NV2080_CTRL_CE_UPDATE_PCE_LCE_MAPPINGS_INVALID_LCE = 0xf # macro
NV2080_CTRL_CMD_CE_UPDATE_CLASS_DB = (0x20802a06) # macro
NV2080_CTRL_CE_UPDATE_CLASS_DB_PARAMS_MESSAGE_ID = (0x6) # macro
NV2080_CTRL_CMD_CE_GET_PHYSICAL_CAPS = (0x20802a07) # macro
NV2080_CTRL_CE_GET_PHYSICAL_CAPS_PARAMS_MESSAGE_ID = (0x7) # macro
NV2080_CTRL_CE_GET_FAULT_METHOD_BUFFER_SIZE_PARAMS_MESSAGE_ID = (0x8) # macro
NV2080_CTRL_CMD_CE_GET_FAULT_METHOD_BUFFER_SIZE = (0x20802a08) # macro
NV2080_CTRL_CMD_CE_GET_HUB_PCE_MASK = (0x20802a09) # macro
NV2080_CTRL_CE_MAX_HSHUBS = 32 # macro
NV2080_CTRL_CE_GET_HUB_PCE_MASK_PARAMS_MESSAGE_ID = (0x9) # macro
NV2080_CTRL_CMD_CE_GET_ALL_CAPS = (0x20802a0a) # macro
NV2080_CTRL_MAX_CES = 64 # macro
NV2080_CTRL_CE_GET_ALL_CAPS_PARAMS_MESSAGE_ID = (0xa) # macro
NV2080_CTRL_CMD_CE_GET_ALL_PHYSICAL_CAPS = (0x20802a0b) # macro
NV2080_CTRL_CE_GET_ALL_PHYSICAL_CAPS_PARAMS_MESSAGE_ID = (0xb) # macro
class struct_NV2080_CTRL_CE_GET_CAPS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CE_GET_CAPS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CE_GET_CAPS_PARAMS._fields_ = [
    ('ceEngineType', ctypes.c_uint32),
    ('capsTblSize', ctypes.c_uint32),
    ('capsTbl', ctypes.POINTER(None)),
]

NV2080_CTRL_CE_GET_CAPS_PARAMS = struct_NV2080_CTRL_CE_GET_CAPS_PARAMS
class struct_NV2080_CTRL_CE_GET_CAPS_V2_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CE_GET_CAPS_V2_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CE_GET_CAPS_V2_PARAMS._fields_ = [
    ('ceEngineType', ctypes.c_uint32),
    ('capsTbl', ctypes.c_ubyte * 2),
    ('PADDING_0', ctypes.c_ubyte * 2),
]

NV2080_CTRL_CE_GET_CAPS_V2_PARAMS = struct_NV2080_CTRL_CE_GET_CAPS_V2_PARAMS
class struct_NV2080_CTRL_CE_GET_CE_PCE_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CE_GET_CE_PCE_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CE_GET_CE_PCE_MASK_PARAMS._fields_ = [
    ('ceEngineType', ctypes.c_uint32),
    ('pceMask', ctypes.c_uint32),
]

NV2080_CTRL_CE_GET_CE_PCE_MASK_PARAMS = struct_NV2080_CTRL_CE_GET_CE_PCE_MASK_PARAMS
class struct_NV2080_CTRL_CE_SET_PCE_LCE_CONFIG_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CE_SET_PCE_LCE_CONFIG_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CE_SET_PCE_LCE_CONFIG_PARAMS._fields_ = [
    ('ceEngineType', ctypes.c_uint32),
    ('pceLceMap', ctypes.c_uint32 * 32),
    ('grceSharedLceMap', ctypes.c_uint32 * 4),
]

NV2080_CTRL_CE_SET_PCE_LCE_CONFIG_PARAMS = struct_NV2080_CTRL_CE_SET_PCE_LCE_CONFIG_PARAMS
class struct_NV2080_CTRL_CE_UPDATE_PCE_LCE_MAPPINGS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CE_UPDATE_PCE_LCE_MAPPINGS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CE_UPDATE_PCE_LCE_MAPPINGS_PARAMS._fields_ = [
    ('pceLceMap', ctypes.c_uint32 * 32),
    ('grceConfig', ctypes.c_uint32 * 4),
    ('exposeCeMask', ctypes.c_uint32),
    ('bUpdateNvlinkPceLce', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_CE_UPDATE_PCE_LCE_MAPPINGS_PARAMS = struct_NV2080_CTRL_CE_UPDATE_PCE_LCE_MAPPINGS_PARAMS
class struct_NV2080_CTRL_CE_UPDATE_CLASS_DB_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CE_UPDATE_CLASS_DB_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CE_UPDATE_CLASS_DB_PARAMS._fields_ = [
    ('stubbedCeMask', ctypes.c_uint32),
]

NV2080_CTRL_CE_UPDATE_CLASS_DB_PARAMS = struct_NV2080_CTRL_CE_UPDATE_CLASS_DB_PARAMS
NV2080_CTRL_CE_GET_PHYSICAL_CAPS_PARAMS = struct_NV2080_CTRL_CE_GET_CAPS_V2_PARAMS
class struct_NV2080_CTRL_CE_GET_FAULT_METHOD_BUFFER_SIZE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CE_GET_FAULT_METHOD_BUFFER_SIZE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CE_GET_FAULT_METHOD_BUFFER_SIZE_PARAMS._fields_ = [
    ('size', ctypes.c_uint32),
]

NV2080_CTRL_CE_GET_FAULT_METHOD_BUFFER_SIZE_PARAMS = struct_NV2080_CTRL_CE_GET_FAULT_METHOD_BUFFER_SIZE_PARAMS
class struct_NV2080_CTRL_CE_GET_HUB_PCE_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CE_GET_HUB_PCE_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CE_GET_HUB_PCE_MASK_PARAMS._fields_ = [
    ('hshubPceMasks', ctypes.c_uint32 * 32),
    ('fbhubPceMask', ctypes.c_uint32),
]

NV2080_CTRL_CE_GET_HUB_PCE_MASK_PARAMS = struct_NV2080_CTRL_CE_GET_HUB_PCE_MASK_PARAMS
class struct_NV2080_CTRL_CE_GET_ALL_CAPS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CE_GET_ALL_CAPS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CE_GET_ALL_CAPS_PARAMS._fields_ = [
    ('capsTbl', ctypes.c_ubyte * 2 * 64),
    ('present', ctypes.c_uint64),
]

NV2080_CTRL_CE_GET_ALL_CAPS_PARAMS = struct_NV2080_CTRL_CE_GET_ALL_CAPS_PARAMS
NV2080_CTRL_CE_GET_ALL_PHYSICAL_CAPS_PARAMS = struct_NV2080_CTRL_CE_GET_ALL_CAPS_PARAMS
NV2080_CTRL_GPUMON_SAMPLE_TYPE_PWR_MONITOR_STATUS = 0x00000001 # macro
NV2080_CTRL_GPUMON_SAMPLE_TYPE_PERFMON_UTIL = 0x00000002 # macro
# def NV2080_GPUMON_PID_INVALID((NvU32):  # macro
#    return (~0))
class struct_NV2080_CTRL_GPUMON_SAMPLE(Structure):
    pass

struct_NV2080_CTRL_GPUMON_SAMPLE._pack_ = 1 # source:False
struct_NV2080_CTRL_GPUMON_SAMPLE._fields_ = [
    ('timeStamp', ctypes.c_uint64),
]

NV2080_CTRL_GPUMON_SAMPLE = struct_NV2080_CTRL_GPUMON_SAMPLE
class struct_NV2080_CTRL_GPUMON_SAMPLES(Structure):
    pass

struct_NV2080_CTRL_GPUMON_SAMPLES._pack_ = 1 # source:False
struct_NV2080_CTRL_GPUMON_SAMPLES._fields_ = [
    ('type', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('bufSize', ctypes.c_uint32),
    ('count', ctypes.c_uint32),
    ('tracker', ctypes.c_uint32),
    ('pSamples', ctypes.POINTER(None)),
]

NV2080_CTRL_GPUMON_SAMPLES = struct_NV2080_CTRL_GPUMON_SAMPLES
NV2080_CTRL_CMD_DMA_INVALIDATE_TLB = (0x20802502) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_PARAMS_MESSAGE_ID = (0x2) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_GRAPHICS = ['0', ':', '0'] # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_GRAPHICS_FALSE = (0x00000000) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_GRAPHICS_TRUE = (0x00000001) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_VIDEO = ['1', ':', '1'] # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_VIDEO_FALSE = (0x00000000) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_VIDEO_TRUE = (0x00000001) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_DISPLAY = ['2', ':', '2'] # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_DISPLAY_FALSE = (0x00000000) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_DISPLAY_TRUE = (0x00000001) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_CAPTURE = ['3', ':', '3'] # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_CAPTURE_FALSE = (0x00000000) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_CAPTURE_TRUE = (0x00000001) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_IFB = ['4', ':', '4'] # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_IFB_FALSE = (0x00000000) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_IFB_TRUE = (0x00000001) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_MV = ['5', ':', '5'] # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_MV_FALSE = (0x00000000) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_MV_TRUE = (0x00000001) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_MPEG = ['6', ':', '6'] # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_MPEG_FALSE = (0x00000000) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_MPEG_TRUE = (0x00000001) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_VLD = ['7', ':', '7'] # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_VLD_FALSE = (0x00000000) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_VLD_TRUE = (0x00000001) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_ENCRYPTION = ['8', ':', '8'] # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_ENCRYPTION_FALSE = (0x00000000) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_ENCRYPTION_TRUE = (0x00000001) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_PERFMON = ['9', ':', '9'] # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_PERFMON_FALSE = (0x00000000) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_PERFMON_TRUE = (0x00000001) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_POSTPROCESS = ['10', ':', '10'] # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_POSTPROCESS_FALSE = (0x00000000) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_POSTPROCESS_TRUE = (0x00000001) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_BAR = ['11', ':', '11'] # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_BAR_FALSE = (0x00000000) # macro
NV2080_CTRL_DMA_INVALIDATE_TLB_ENGINE_BAR_TRUE = (0x00000001) # macro
NV2080_CTRL_DMA_INFO_INDEX_SYSTEM_ADDRESS_SIZE = (0x000000000) # macro
NV2080_CTRL_DMA_INFO_INDEX_MAX = (0x000000000) # macro
NV2080_CTRL_CMD_DMA_GET_INFO = (0x20802503) # macro
NV2080_CTRL_DMA_GET_INFO_MAX_ENTRIES = (256) # macro
NV2080_CTRL_DMA_GET_INFO_PARAMS_MESSAGE_ID = (0x3) # macro
class struct_NV2080_CTRL_DMA_INVALIDATE_TLB_PARAMS(Structure):
    pass

struct_NV2080_CTRL_DMA_INVALIDATE_TLB_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_DMA_INVALIDATE_TLB_PARAMS._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hDevice', ctypes.c_uint32),
    ('engine', ctypes.c_uint32),
    ('hVASpace', ctypes.c_uint32),
]

NV2080_CTRL_DMA_INVALIDATE_TLB_PARAMS = struct_NV2080_CTRL_DMA_INVALIDATE_TLB_PARAMS
NV2080_CTRL_DMA_INFO = struct_NVXXXX_CTRL_XXX_INFO
class struct_NV2080_CTRL_DMA_GET_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_DMA_GET_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_DMA_GET_INFO_PARAMS._fields_ = [
    ('dmaInfoTblSize', ctypes.c_uint32),
    ('dmaInfoTbl', struct_NVXXXX_CTRL_XXX_INFO * 256),
]

NV2080_CTRL_DMA_GET_INFO_PARAMS = struct_NV2080_CTRL_DMA_GET_INFO_PARAMS
class struct_NV2080_CTRL_DMA_UPDATE_COMPTAG_INFO_TILE_INFO(Structure):
    pass

struct_NV2080_CTRL_DMA_UPDATE_COMPTAG_INFO_TILE_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_DMA_UPDATE_COMPTAG_INFO_TILE_INFO._fields_ = [
    ('srcAddr', ctypes.c_uint32),
    ('dstAddr', ctypes.c_uint32),
    ('relComptagIndex', ctypes.c_uint16),
    ('PADDING_0', ctypes.c_ubyte * 2),
]

NV2080_CTRL_DMA_UPDATE_COMPTAG_INFO_TILE_INFO = struct_NV2080_CTRL_DMA_UPDATE_COMPTAG_INFO_TILE_INFO
NV2080_CTRL_CMD_DMABUF_EXPORT_OBJECTS_TO_FD = (0x20803a01) # macro
NV2080_CTRL_DMABUF_MAX_HANDLES = 128 # macro
NV2080_CTRL_DMABUF_EXPORT_MEM_PARAMS_MESSAGE_ID = (0x1) # macro
class struct_NV2080_CTRL_DMABUF_MEM_HANDLE_INFO(Structure):
    pass

struct_NV2080_CTRL_DMABUF_MEM_HANDLE_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_DMABUF_MEM_HANDLE_INFO._fields_ = [
    ('hMemory', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('offset', ctypes.c_uint64),
    ('size', ctypes.c_uint64),
]

NV2080_CTRL_DMABUF_MEM_HANDLE_INFO = struct_NV2080_CTRL_DMABUF_MEM_HANDLE_INFO
class struct_NV2080_CTRL_DMABUF_EXPORT_MEM_PARAMS(Structure):
    pass

struct_NV2080_CTRL_DMABUF_EXPORT_MEM_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_DMABUF_EXPORT_MEM_PARAMS._fields_ = [
    ('fd', ctypes.c_int32),
    ('totalObjects', ctypes.c_uint32),
    ('numObjects', ctypes.c_uint32),
    ('index', ctypes.c_uint32),
    ('totalSize', ctypes.c_uint64),
    ('handles', struct_NV2080_CTRL_DMABUF_MEM_HANDLE_INFO * 128),
]

NV2080_CTRL_DMABUF_EXPORT_MEM_PARAMS = struct_NV2080_CTRL_DMABUF_EXPORT_MEM_PARAMS
NV2080_CTRL_CMD_ECC_GET_CLIENT_EXPOSED_COUNTERS = (0x20803400) # macro
NV2080_CTRL_ECC_GET_CLIENT_EXPOSED_COUNTERS_PARAMS_MESSAGE_ID = (0x0) # macro
NV2080_CTRL_CMD_ECC_GET_ECI_COUNTERS = (0x20803401) # macro
NV2080_CTRL_ECC_GET_ECI_COUNTERS_PARAMS_MESSAGE_ID = (0x1) # macro
NV2080_CTRL_CMD_ECC_GET_VOLATILE_COUNTS = (0x20803402) # macro
NV2080_CTRL_ECC_GET_VOLATILE_COUNTS_PARAMS_MESSAGE_ID = (0x2) # macro
class struct_NV2080_CTRL_ECC_GET_CLIENT_EXPOSED_COUNTERS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_ECC_GET_CLIENT_EXPOSED_COUNTERS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_ECC_GET_CLIENT_EXPOSED_COUNTERS_PARAMS._fields_ = [
    ('sramLastClearedTimestamp', ctypes.c_uint32),
    ('dramLastClearedTimestamp', ctypes.c_uint32),
    ('sramCorrectedTotalCounts', ctypes.c_uint64),
    ('sramUncorrectedTotalCounts', ctypes.c_uint64),
    ('dramCorrectedTotalCounts', ctypes.c_uint64),
    ('dramUncorrectedTotalCounts', ctypes.c_uint64),
]

NV2080_CTRL_ECC_GET_CLIENT_EXPOSED_COUNTERS_PARAMS = struct_NV2080_CTRL_ECC_GET_CLIENT_EXPOSED_COUNTERS_PARAMS
class struct_NV2080_CTRL_ECC_GET_ECI_COUNTERS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_ECC_GET_ECI_COUNTERS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_ECC_GET_ECI_COUNTERS_PARAMS._fields_ = [
    ('sramParityUncorrectedUnique', ctypes.c_uint64),
    ('sramSecDedUncorrectedUnique', ctypes.c_uint64),
    ('sramCorrectedTotal', ctypes.c_uint64),
    ('dramUncorrectedTotal', ctypes.c_uint64),
    ('dramCorrectedTotal', ctypes.c_uint64),
    ('lastClearedTimestamp', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('sramBucketL2', ctypes.c_uint64),
    ('sramBucketSM', ctypes.c_uint64),
    ('sramBucketPcie', ctypes.c_uint64),
    ('sramBucketFirmware', ctypes.c_uint64),
    ('sramBucketOther', ctypes.c_uint64),
    ('sramErrorThresholdExceeded', ctypes.c_ubyte),
    ('PADDING_1', ctypes.c_ubyte * 7),
]

NV2080_CTRL_ECC_GET_ECI_COUNTERS_PARAMS = struct_NV2080_CTRL_ECC_GET_ECI_COUNTERS_PARAMS
class struct_NV2080_CTRL_ECC_GET_VOLATILE_COUNTS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_ECC_GET_VOLATILE_COUNTS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_ECC_GET_VOLATILE_COUNTS_PARAMS._fields_ = [
    ('sramCorUni', ctypes.c_uint64),
    ('sramUncParityUni', ctypes.c_uint64),
    ('sramUncSecDedUni', ctypes.c_uint64),
    ('dramCorTot', ctypes.c_uint64),
    ('dramUncTot', ctypes.c_uint64),
]

NV2080_CTRL_ECC_GET_VOLATILE_COUNTS_PARAMS = struct_NV2080_CTRL_ECC_GET_VOLATILE_COUNTS_PARAMS
NV2080_CTRL_CMD_EVENT_SET_NOTIFICATION = (0x20800301) # macro
NV2080_CTRL_EVENT_SET_NOTIFICATION_PARAMS_MESSAGE_ID = (0x1) # macro
NV2080_CTRL_EVENT_SET_NOTIFICATION_ACTION_DISABLE = (0x00000000) # macro
NV2080_CTRL_EVENT_SET_NOTIFICATION_ACTION_SINGLE = (0x00000001) # macro
NV2080_CTRL_EVENT_SET_NOTIFICATION_ACTION_REPEAT = (0x00000002) # macro
NV2080_EVENT_DSTATE_XUSB_D0 = (0x00000000) # macro
NV2080_EVENT_DSTATE_XUSB_D3 = (0x00000003) # macro
NV2080_EVENT_DSTATE_XUSB_INVALID = (0xFFFFFFFF) # macro
NV2080_EVENT_DSTATE_PPC_D0 = (0x00000000) # macro
NV2080_EVENT_DSTATE_PPC_D3 = (0x00000003) # macro
NV2080_EVENT_DSTATE_PPC_INVALID = (0xFFFFFFFF) # macro
NV2080_CTRL_CMD_EVENT_SET_TRIGGER = (0x20800302) # macro
NV2080_CTRL_CMD_EVENT_SET_MEMORY_NOTIFIES = (0x20800303) # macro
NV2080_CTRL_EVENT_SET_MEMORY_NOTIFIES_PARAMS_MESSAGE_ID = (0x3) # macro
NV2080_EVENT_MEMORY_NOTIFIES_STATUS_NOTIFIED = 0 # macro
NV2080_EVENT_MEMORY_NOTIFIES_STATUS_PENDING = 1 # macro
NV2080_EVENT_MEMORY_NOTIFIES_STATUS_ERROR = 2 # macro
NV2080_CTRL_CMD_EVENT_SET_SEMAPHORE_MEMORY = (0x20800304) # macro
NV2080_CTRL_EVENT_SET_SEMAPHORE_MEMORY_PARAMS_MESSAGE_ID = (0x4) # macro
NV2080_CTRL_CMD_EVENT_SET_GUEST_MSI = (0x20800305) # macro
NV2080_CTRL_EVENT_SET_GUEST_MSI_PARAMS_MESSAGE_ID = (0x5) # macro
NV2080_CTRL_CMD_EVENT_SET_SEMA_MEM_VALIDATION = (0x20800306) # macro
NV2080_CTRL_EVENT_SET_SEMA_MEM_VALIDATION_PARAMS_MESSAGE_ID = (0x6) # macro
NV2080_CTRL_CMD_EVENT_SET_TRIGGER_FIFO = (0x20800308) # macro
NV2080_CTRL_EVENT_SET_TRIGGER_FIFO_PARAMS_MESSAGE_ID = (0x8) # macro
NV2080_CTRL_CMD_EVENT_VIDEO_BIND_EVTBUF = (0x20800309) # macro
NV2080_CTRL_EVENT_VIDEO_BIND_EVTBUF_PARAMS_MESSAGE_ID = (0x9) # macro
NV2080_CTRL_CMD_EVENT_RATS_GSP_TRACE_BIND_EVTBUF = (0x2080030a) # macro
NV2080_CTRL_EVENT_RATS_GSP_TRACE_BIND_EVTBUF_PARAMS_MESSAGE_ID = (0xA) # macro
class struct_NV2080_CTRL_EVENT_SET_NOTIFICATION_PARAMS(Structure):
    pass

struct_NV2080_CTRL_EVENT_SET_NOTIFICATION_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_EVENT_SET_NOTIFICATION_PARAMS._fields_ = [
    ('event', ctypes.c_uint32),
    ('action', ctypes.c_uint32),
    ('bNotifyState', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('info32', ctypes.c_uint32),
    ('info16', ctypes.c_uint16),
    ('PADDING_1', ctypes.c_ubyte * 2),
]

NV2080_CTRL_EVENT_SET_NOTIFICATION_PARAMS = struct_NV2080_CTRL_EVENT_SET_NOTIFICATION_PARAMS

# values for enumeration 'NV2080_EVENT_HDACODEC_DSTATE'
NV2080_EVENT_HDACODEC_DSTATE__enumvalues = {
    0: 'NV2080_EVENT_HDACODEC_DEVICE_DSTATE_D0',
    1: 'NV2080_EVENT_HDACODEC_DEVICE_DSTATE_D1',
    2: 'NV2080_EVENT_HDACODEC_DEVICE_DSTATE_D2',
    3: 'NV2080_EVENT_HDACODEC_DEVICE_DSTATE_D3_HOT',
    4: 'NV2080_EVENT_HDACODEC_DEVICE_DSTATE_D3_COLD',
    5: 'NV2080_EVENT_HDACODEC_DEVICE_DSTATE_DSTATE_MAX',
}
NV2080_EVENT_HDACODEC_DEVICE_DSTATE_D0 = 0
NV2080_EVENT_HDACODEC_DEVICE_DSTATE_D1 = 1
NV2080_EVENT_HDACODEC_DEVICE_DSTATE_D2 = 2
NV2080_EVENT_HDACODEC_DEVICE_DSTATE_D3_HOT = 3
NV2080_EVENT_HDACODEC_DEVICE_DSTATE_D3_COLD = 4
NV2080_EVENT_HDACODEC_DEVICE_DSTATE_DSTATE_MAX = 5
NV2080_EVENT_HDACODEC_DSTATE = ctypes.c_uint32 # enum
class struct_NV2080_CTRL_EVENT_SET_MEMORY_NOTIFIES_PARAMS(Structure):
    pass

struct_NV2080_CTRL_EVENT_SET_MEMORY_NOTIFIES_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_EVENT_SET_MEMORY_NOTIFIES_PARAMS._fields_ = [
    ('hMemory', ctypes.c_uint32),
]

NV2080_CTRL_EVENT_SET_MEMORY_NOTIFIES_PARAMS = struct_NV2080_CTRL_EVENT_SET_MEMORY_NOTIFIES_PARAMS
class struct_NV2080_CTRL_EVENT_SET_SEMAPHORE_MEMORY_PARAMS(Structure):
    pass

struct_NV2080_CTRL_EVENT_SET_SEMAPHORE_MEMORY_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_EVENT_SET_SEMAPHORE_MEMORY_PARAMS._fields_ = [
    ('hSemMemory', ctypes.c_uint32),
    ('semOffset', ctypes.c_uint32),
]

NV2080_CTRL_EVENT_SET_SEMAPHORE_MEMORY_PARAMS = struct_NV2080_CTRL_EVENT_SET_SEMAPHORE_MEMORY_PARAMS
class struct_NV2080_CTRL_EVENT_SET_GUEST_MSI_PARAMS(Structure):
    pass

struct_NV2080_CTRL_EVENT_SET_GUEST_MSI_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_EVENT_SET_GUEST_MSI_PARAMS._fields_ = [
    ('guestMSIAddr', ctypes.c_uint64),
    ('guestMSIData', ctypes.c_uint32),
    ('hSemMemory', ctypes.c_uint32),
    ('isReset', ctypes.c_ubyte),
    ('vgpuUuid', ctypes.c_ubyte * 16),
    ('PADDING_0', ctypes.c_ubyte * 7),
    ('domainId', ctypes.c_uint64),
]

NV2080_CTRL_EVENT_SET_GUEST_MSI_PARAMS = struct_NV2080_CTRL_EVENT_SET_GUEST_MSI_PARAMS
class struct_NV2080_CTRL_EVENT_SET_SEMA_MEM_VALIDATION_PARAMS(Structure):
    pass

struct_NV2080_CTRL_EVENT_SET_SEMA_MEM_VALIDATION_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_EVENT_SET_SEMA_MEM_VALIDATION_PARAMS._fields_ = [
    ('hSemMemory', ctypes.c_uint32),
    ('isSemaMemValidationEnabled', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_EVENT_SET_SEMA_MEM_VALIDATION_PARAMS = struct_NV2080_CTRL_EVENT_SET_SEMA_MEM_VALIDATION_PARAMS
class struct_NV2080_CTRL_EVENT_SET_TRIGGER_FIFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_EVENT_SET_TRIGGER_FIFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_EVENT_SET_TRIGGER_FIFO_PARAMS._fields_ = [
    ('hEvent', ctypes.c_uint32),
]

NV2080_CTRL_EVENT_SET_TRIGGER_FIFO_PARAMS = struct_NV2080_CTRL_EVENT_SET_TRIGGER_FIFO_PARAMS

# values for enumeration 'NV2080_CTRL_EVENT_VIDEO_BIND_EVTBUF_LOD'
NV2080_CTRL_EVENT_VIDEO_BIND_EVTBUF_LOD__enumvalues = {
    0: 'NV2080_CTRL_EVENT_VIDEO_BIND_EVTBUF_LOD_FULL',
    1: 'NV2080_CTRL_EVENT_VIDEO_BIND_EVTBUF_LOD_SIMPLE',
    2: 'NV2080_CTRL_EVENT_VIDEO_BIND_EVTBUF_LOD_CUSTOM',
}
NV2080_CTRL_EVENT_VIDEO_BIND_EVTBUF_LOD_FULL = 0
NV2080_CTRL_EVENT_VIDEO_BIND_EVTBUF_LOD_SIMPLE = 1
NV2080_CTRL_EVENT_VIDEO_BIND_EVTBUF_LOD_CUSTOM = 2
NV2080_CTRL_EVENT_VIDEO_BIND_EVTBUF_LOD = ctypes.c_uint32 # enum
class struct_NV2080_CTRL_EVENT_VIDEO_BIND_EVTBUF_PARAMS(Structure):
    pass

struct_NV2080_CTRL_EVENT_VIDEO_BIND_EVTBUF_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_EVENT_VIDEO_BIND_EVTBUF_PARAMS._fields_ = [
    ('hEventBuffer', ctypes.c_uint32),
    ('recordSize', ctypes.c_uint32),
    ('levelOfDetail', NV2080_CTRL_EVENT_VIDEO_BIND_EVTBUF_LOD),
    ('eventFilter', ctypes.c_uint32),
    ('bAllUsers', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_EVENT_VIDEO_BIND_EVTBUF_PARAMS = struct_NV2080_CTRL_EVENT_VIDEO_BIND_EVTBUF_PARAMS
class struct_NV2080_CTRL_EVENT_RATS_GSP_TRACE_BIND_EVTBUF_PARAMS(Structure):
    pass

struct_NV2080_CTRL_EVENT_RATS_GSP_TRACE_BIND_EVTBUF_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_EVENT_RATS_GSP_TRACE_BIND_EVTBUF_PARAMS._fields_ = [
    ('hEventBuffer', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('tracepointMask', ctypes.c_uint64),
    ('gspLoggingBufferSize', ctypes.c_uint32),
    ('gspLoggingBufferWatermark', ctypes.c_uint32),
]

NV2080_CTRL_EVENT_RATS_GSP_TRACE_BIND_EVTBUF_PARAMS = struct_NV2080_CTRL_EVENT_RATS_GSP_TRACE_BIND_EVTBUF_PARAMS
NV2080_CTRL_FB_INFO_INDEX_TILE_REGION_COUNT = (0x00000000) # macro
NV2080_CTRL_FB_INFO_INDEX_COMPRESSION_SIZE = (0x00000001) # macro
NV2080_CTRL_FB_INFO_INDEX_DRAM_PAGE_STRIDE = (0x00000002) # macro
NV2080_CTRL_FB_INFO_INDEX_TILE_REGION_FREE_COUNT = (0x00000003) # macro
NV2080_CTRL_FB_INFO_INDEX_PARTITION_COUNT = (0x00000004) # macro
NV2080_CTRL_FB_INFO_INDEX_BAR1_SIZE = (0x00000005) # macro
NV2080_CTRL_FB_INFO_INDEX_BANK_SWIZZLE_ALIGNMENT = (0x00000006) # macro
NV2080_CTRL_FB_INFO_INDEX_RAM_SIZE = (0x00000007) # macro
NV2080_CTRL_FB_INFO_INDEX_TOTAL_RAM_SIZE = (0x00000008) # macro
NV2080_CTRL_FB_INFO_INDEX_HEAP_SIZE = (0x00000009) # macro
NV2080_CTRL_FB_INFO_INDEX_MAPPABLE_HEAP_SIZE = (0x0000000A) # macro
NV2080_CTRL_FB_INFO_INDEX_BUS_WIDTH = (0x0000000B) # macro
NV2080_CTRL_FB_INFO_INDEX_RAM_CFG = (0x0000000C) # macro
NV2080_CTRL_FB_INFO_INDEX_RAM_TYPE = (0x0000000D) # macro
NV2080_CTRL_FB_INFO_INDEX_BANK_COUNT = (0x0000000E) # macro
NV2080_CTRL_FB_INFO_INDEX_OVERLAY_OFFSET_ADJUSTMENT = (0x0000000F) # macro
NV2080_CTRL_FB_INFO_INDEX_GPU_VADDR_SPACE_SIZE_KB = (0x0000000F) # macro
NV2080_CTRL_FB_INFO_INDEX_GPU_VADDR_HEAP_SIZE_KB = (0x0000000F) # macro
NV2080_CTRL_FB_INFO_INDEX_GPU_VADDR_MAPPBLE_SIZE_KB = (0x0000000F) # macro
NV2080_CTRL_FB_INFO_INDEX_EFFECTIVE_BW = (0x0000000F) # macro
NV2080_CTRL_FB_INFO_INDEX_FB_TAX_SIZE_KB = (0x00000010) # macro
NV2080_CTRL_FB_INFO_INDEX_HEAP_BASE_KB = (0x00000011) # macro
NV2080_CTRL_FB_INFO_INDEX_LARGEST_FREE_REGION_SIZE_KB = (0x00000012) # macro
NV2080_CTRL_FB_INFO_INDEX_LARGEST_FREE_REGION_BASE_KB = (0x00000013) # macro
NV2080_CTRL_FB_INFO_INDEX_PARTITION_MASK = (0x00000014) # macro
NV2080_CTRL_FB_INFO_INDEX_VISTA_RESERVED_HEAP_SIZE = (0x00000015) # macro
NV2080_CTRL_FB_INFO_INDEX_HEAP_FREE = (0x00000016) # macro
NV2080_CTRL_FB_INFO_INDEX_RAM_LOCATION = (0x00000017) # macro
NV2080_CTRL_FB_INFO_INDEX_FB_IS_BROKEN = (0x00000018) # macro
NV2080_CTRL_FB_INFO_INDEX_FBP_COUNT = (0x00000019) # macro
NV2080_CTRL_FB_INFO_INDEX_FBP_MASK = (0x0000001A) # macro
NV2080_CTRL_FB_INFO_INDEX_L2CACHE_SIZE = (0x0000001B) # macro
NV2080_CTRL_FB_INFO_INDEX_MEMORYINFO_VENDOR_ID = (0x0000001C) # macro
NV2080_CTRL_FB_INFO_INDEX_BAR1_AVAIL_SIZE = (0x0000001D) # macro
NV2080_CTRL_FB_INFO_INDEX_HEAP_START = (0x0000001E) # macro
NV2080_CTRL_FB_INFO_INDEX_BAR1_MAX_CONTIGUOUS_AVAIL_SIZE = (0x0000001F) # macro
NV2080_CTRL_FB_INFO_INDEX_USABLE_RAM_SIZE = (0x00000020) # macro
NV2080_CTRL_FB_INFO_INDEX_TRAINIG_2T = (0x00000021) # macro
NV2080_CTRL_FB_INFO_INDEX_LTC_COUNT = (0x00000022) # macro
NV2080_CTRL_FB_INFO_INDEX_LTS_COUNT = (0x00000023) # macro
NV2080_CTRL_FB_INFO_INDEX_L2CACHE_ONLY_MODE = (0x00000024) # macro
NV2080_CTRL_FB_INFO_INDEX_PSEUDO_CHANNEL_MODE = (0x00000025) # macro
NV2080_CTRL_FB_INFO_INDEX_SMOOTHDISP_RSVD_BAR1_SIZE = (0x00000026) # macro
NV2080_CTRL_FB_INFO_INDEX_HEAP_OFFLINE_SIZE = (0x00000027) # macro
NV2080_CTRL_FB_INFO_INDEX_1TO1_COMPTAG_ENABLED = (0x00000028) # macro
NV2080_CTRL_FB_INFO_INDEX_SUSPEND_RESUME_RSVD_SIZE = (0x00000029) # macro
NV2080_CTRL_FB_INFO_INDEX_ALLOW_PAGE_RETIREMENT = (0x0000002A) # macro
NV2080_CTRL_FB_INFO_INDEX_LTC_MASK = (0x0000002B) # macro
NV2080_CTRL_FB_INFO_POISON_FUSE_ENABLED = (0x0000002C) # macro
NV2080_CTRL_FB_INFO_FBPA_ECC_ENABLED = (0x0000002D) # macro
NV2080_CTRL_FB_INFO_DYNAMIC_PAGE_OFFLINING_ENABLED = (0x0000002E) # macro
NV2080_CTRL_FB_INFO_INDEX_FORCED_BAR1_64KB_MAPPING_ENABLED = (0x0000002F) # macro
NV2080_CTRL_FB_INFO_INDEX_P2P_MAILBOX_SIZE = (0x00000030) # macro
NV2080_CTRL_FB_INFO_INDEX_P2P_MAILBOX_ALIGNMENT = (0x00000031) # macro
NV2080_CTRL_FB_INFO_INDEX_P2P_MAILBOX_BAR1_MAX_OFFSET_64KB = (0x00000032) # macro
NV2080_CTRL_FB_INFO_INDEX_PROTECTED_MEM_SIZE_TOTAL_KB = (0x00000033) # macro
NV2080_CTRL_FB_INFO_INDEX_PROTECTED_MEM_SIZE_FREE_KB = (0x00000034) # macro
NV2080_CTRL_FB_INFO_INDEX_ECC_STATUS_SIZE = (0x00000035) # macro
NV2080_CTRL_FB_INFO_INDEX_IS_ZERO_FB = (0x00000036) # macro
NV2080_CTRL_FB_INFO_MAX_LIST_SIZE = (0x00000037) # macro
NV2080_CTRL_FB_INFO_INDEX_MAX = (0x36) # macro
NV2080_CTRL_FB_INFO_RAM_TYPE_UNKNOWN = (0x00000000) # macro
NV2080_CTRL_FB_INFO_RAM_TYPE_SDRAM = (0x00000001) # macro
NV2080_CTRL_FB_INFO_RAM_TYPE_DDR1 = (0x00000002) # macro
NV2080_CTRL_FB_INFO_RAM_TYPE_SDDR2 = (0x00000003) # macro
NV2080_CTRL_FB_INFO_RAM_TYPE_DDR2 = (0x00000003) # macro
NV2080_CTRL_FB_INFO_RAM_TYPE_GDDR2 = (0x00000004) # macro
NV2080_CTRL_FB_INFO_RAM_TYPE_GDDR3 = (0x00000005) # macro
NV2080_CTRL_FB_INFO_RAM_TYPE_GDDR4 = (0x00000006) # macro
NV2080_CTRL_FB_INFO_RAM_TYPE_SDDR3 = (0x00000007) # macro
NV2080_CTRL_FB_INFO_RAM_TYPE_DDR3 = (0x00000007) # macro
NV2080_CTRL_FB_INFO_RAM_TYPE_GDDR5 = (0x00000008) # macro
NV2080_CTRL_FB_INFO_RAM_TYPE_LPDDR2 = (0x00000009) # macro
NV2080_CTRL_FB_INFO_RAM_TYPE_SDDR4 = (0x0000000C) # macro
NV2080_CTRL_FB_INFO_RAM_TYPE_LPDDR4 = (0x0000000D) # macro
NV2080_CTRL_FB_INFO_RAM_TYPE_HBM1 = (0x0000000E) # macro
NV2080_CTRL_FB_INFO_RAM_TYPE_HBM2 = (0x0000000F) # macro
NV2080_CTRL_FB_INFO_RAM_TYPE_GDDR5X = (0x00000010) # macro
NV2080_CTRL_FB_INFO_RAM_TYPE_GDDR6 = (0x00000011) # macro
NV2080_CTRL_FB_INFO_RAM_TYPE_GDDR6X = (0x00000012) # macro
NV2080_CTRL_FB_INFO_RAM_TYPE_LPDDR5 = (0x00000013) # macro
NV2080_CTRL_FB_INFO_RAM_TYPE_HBM3 = (0x00000014) # macro
NV2080_CTRL_FB_INFO_RAM_LOCATION_GPU_DEDICATED = (0x00000000) # macro
NV2080_CTRL_FB_INFO_RAM_LOCATION_SYS_SHARED = (0x00000001) # macro
NV2080_CTRL_FB_INFO_RAM_LOCATION_SYS_DEDICATED = (0x00000002) # macro
NV2080_CTRL_FB_INFO_MEMORYINFO_VENDOR_ID_SAMSUNG = (0x00000001) # macro
NV2080_CTRL_FB_INFO_MEMORYINFO_VENDOR_ID_QIMONDA = (0x00000002) # macro
NV2080_CTRL_FB_INFO_MEMORYINFO_VENDOR_ID_ELPIDA = (0x00000003) # macro
NV2080_CTRL_FB_INFO_MEMORYINFO_VENDOR_ID_ETRON = (0x00000004) # macro
NV2080_CTRL_FB_INFO_MEMORYINFO_VENDOR_ID_NANYA = (0x00000005) # macro
NV2080_CTRL_FB_INFO_MEMORYINFO_VENDOR_ID_HYNIX = (0x00000006) # macro
NV2080_CTRL_FB_INFO_MEMORYINFO_VENDOR_ID_MOSEL = (0x00000007) # macro
NV2080_CTRL_FB_INFO_MEMORYINFO_VENDOR_ID_WINBOND = (0x00000008) # macro
NV2080_CTRL_FB_INFO_MEMORYINFO_VENDOR_ID_ESMT = (0x00000009) # macro
NV2080_CTRL_FB_INFO_MEMORYINFO_VENDOR_ID_MICRON = (0x0000000F) # macro
NV2080_CTRL_FB_INFO_MEMORYINFO_VENDOR_ID_UNKNOWN = (0xFFFFFFFF) # macro
NV2080_CTRL_FB_INFO_PSEUDO_CHANNEL_MODE_UNSUPPORTED = (0x00000000) # macro
NV2080_CTRL_FB_INFO_PSEUDO_CHANNEL_MODE_DISABLED = (0x00000001) # macro
NV2080_CTRL_FB_INFO_PSEUDO_CHANNEL_MODE_ENABLED = (0x00000002) # macro
NV2080_CTRL_CMD_FB_GET_INFO = (0x20801301) # macro
NV2080_CTRL_FB_GET_INFO_PARAMS_MESSAGE_ID = (0x1) # macro
NV2080_CTRL_CMD_FB_GET_INFO_V2 = (0x20801303) # macro
NV2080_CTRL_FB_GET_INFO_V2_PARAMS_MESSAGE_ID = (0x3) # macro
NV2080_CTRL_CMD_FB_GET_BAR1_OFFSET = (0x20801310) # macro
NV2080_CTRL_FB_GET_BAR1_OFFSET_PARAMS_MESSAGE_ID = (0x10) # macro
NV2080_CTRL_CMD_FB_GET_CARVEOUT_ADDRESS_INFO = (0x2080130b) # macro
NV2080_CTRL_FB_GET_SYSTEM_CARVEOUT_ADDRESS_SPACE_INFO_MESSAGE_ID = (0xB) # macro
NV2080_CTRL_CMD_FB_GET_CALIBRATION_LOCK_FAILED = (0x2080130c) # macro
NV2080_CTRL_FB_GET_CALIBRATION_LOCK_FAILED_PARAMS_MESSAGE_ID = (0xC) # macro
NV2080_CTRL_CMD_FB_GET_CAL_FLAG_NONE = (0x00000000) # macro
NV2080_CTRL_CMD_FB_GET_CAL_FLAG_RESET = (0x00000001) # macro
NV2080_CTRL_CMD_FB_FLUSH_GPU_CACHE_IRQL = (0x2080130d) # macro
NV2080_CTRL_CMD_FB_FLUSH_GPU_CACHE_IRQL_PARAMS_MESSAGE_ID = (0xD) # macro
NV2080_CTRL_CMD_FB_FLUSH_GPU_CACHE_IRQL_FLAGS_WRITE_BACK = ['0', ':', '0'] # macro
NV2080_CTRL_CMD_FB_FLUSH_GPU_CACHE_IRQL_FLAGS_WRITE_BACK_NO = (0x00000000) # macro
NV2080_CTRL_CMD_FB_FLUSH_GPU_CACHE_IRQL_FLAGS_WRITE_BACK_YES = (0x00000001) # macro
NV2080_CTRL_CMD_FB_FLUSH_GPU_CACHE_IRQL_FLAGS_INVALIDATE = ['1', ':', '1'] # macro
NV2080_CTRL_CMD_FB_FLUSH_GPU_CACHE_IRQL_FLAGS_INVALIDATE_NO = (0x00000000) # macro
NV2080_CTRL_CMD_FB_FLUSH_GPU_CACHE_IRQL_FLAGS_INVALIDATE_YES = (0x00000001) # macro
NV2080_CTRL_CMD_FB_FLUSH_GPU_CACHE_IRQL_FLAGS_FB_FLUSH = ['2', ':', '2'] # macro
NV2080_CTRL_CMD_FB_FLUSH_GPU_CACHE_IRQL_FLAGS_FB_FLUSH_NO = (0x00000000) # macro
NV2080_CTRL_CMD_FB_FLUSH_GPU_CACHE_IRQL_FLAGS_FB_FLUSH_YES = (0x00000001) # macro
NV2080_CTRL_CMD_FB_FLUSH_GPU_CACHE = (0x2080130e) # macro
NV2080_CTRL_FB_FLUSH_GPU_CACHE_MAX_ADDRESSES = 500 # macro
NV2080_CTRL_FB_FLUSH_GPU_CACHE_PARAMS_MESSAGE_ID = (0xE) # macro
NV2080_CTRL_FB_FLUSH_GPU_CACHE_FLAGS_APERTURE = ['1', ':', '0'] # macro
NV2080_CTRL_FB_FLUSH_GPU_CACHE_FLAGS_APERTURE_VIDEO_MEMORY = (0x00000000) # macro
NV2080_CTRL_FB_FLUSH_GPU_CACHE_FLAGS_APERTURE_SYSTEM_MEMORY = (0x00000001) # macro
NV2080_CTRL_FB_FLUSH_GPU_CACHE_FLAGS_APERTURE_PEER_MEMORY = (0x00000002) # macro
NV2080_CTRL_FB_FLUSH_GPU_CACHE_FLAGS_WRITE_BACK = ['2', ':', '2'] # macro
NV2080_CTRL_FB_FLUSH_GPU_CACHE_FLAGS_WRITE_BACK_NO = (0x00000000) # macro
NV2080_CTRL_FB_FLUSH_GPU_CACHE_FLAGS_WRITE_BACK_YES = (0x00000001) # macro
NV2080_CTRL_FB_FLUSH_GPU_CACHE_FLAGS_INVALIDATE = ['3', ':', '3'] # macro
NV2080_CTRL_FB_FLUSH_GPU_CACHE_FLAGS_INVALIDATE_NO = (0x00000000) # macro
NV2080_CTRL_FB_FLUSH_GPU_CACHE_FLAGS_INVALIDATE_YES = (0x00000001) # macro
NV2080_CTRL_FB_FLUSH_GPU_CACHE_FLAGS_FLUSH_MODE = ['4', ':', '4'] # macro
NV2080_CTRL_FB_FLUSH_GPU_CACHE_FLAGS_FLUSH_MODE_ADDRESS_ARRAY = (0x00000000) # macro
NV2080_CTRL_FB_FLUSH_GPU_CACHE_FLAGS_FLUSH_MODE_FULL_CACHE = (0x00000001) # macro
NV2080_CTRL_FB_FLUSH_GPU_CACHE_FLAGS_FB_FLUSH = ['5', ':', '5'] # macro
NV2080_CTRL_FB_FLUSH_GPU_CACHE_FLAGS_FB_FLUSH_NO = (0x00000000) # macro
NV2080_CTRL_FB_FLUSH_GPU_CACHE_FLAGS_FB_FLUSH_YES = (0x00000001) # macro
NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_READS = ['0', ':', '0'] # macro
NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_READS_NO = (0x00000000) # macro
NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_READS_YES = (0x00000001) # macro
NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_WRITES = ['1', ':', '1'] # macro
NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_WRITES_NO = (0x00000000) # macro
NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_WRITES_YES = (0x00000001) # macro
NV2080_CTRL_CMD_FB_SET_GPU_CACHE_ALLOC_POLICY = (0x2080130f) # macro
NV2080_CTRL_FB_SET_GPU_CACHE_ALLOC_POLICY_PARAMS_MESSAGE_ID = (0xF) # macro
NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_ENTRY_SIZE = 11 # macro
NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_READS = ['0', ':', '0'] # macro
NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_READS_DISABLE = (0x00000000) # macro
NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_READS_ENABLE = (0x00000001) # macro
NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_READS_ALLOW = ['1', ':', '1'] # macro
NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_READS_ALLOW_NO = (0x00000000) # macro
NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_READS_ALLOW_YES = (0x00000001) # macro
NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_WRITES = ['2', ':', '2'] # macro
NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_WRITES_DISABLE = (0x00000000) # macro
NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_WRITES_ENABLE = (0x00000001) # macro
NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_WRITES_ALLOW = ['3', ':', '3'] # macro
NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_WRITES_ALLOW_NO = (0x00000000) # macro
NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_WRITES_ALLOW_YES = (0x00000001) # macro
NV2080_CTRL_CMD_FB_SET_GPU_CACHE_ALLOC_POLICY_V2 = (0x20801318) # macro
NV2080_CTRL_FB_SET_GPU_CACHE_ALLOC_POLICY_V2_PARAMS_MESSAGE_ID = (0x18) # macro
NV2080_CTRL_CMD_FB_GET_GPU_CACHE_ALLOC_POLICY = (0x20801312) # macro
NV2080_CTRL_FB_GET_GPU_CACHE_ALLOC_POLICY_PARAMS_MESSAGE_ID = (0x12) # macro
NV2080_CTRL_CMD_FB_GET_GPU_CACHE_ALLOC_POLICY_V2 = (0x20801319) # macro
NV2080_CTRL_FB_GET_GPU_CACHE_ALLOC_POLICY_V2_PARAMS_MESSAGE_ID = (0x19) # macro
NV2080_CTRL_CMD_FB_IS_KIND = (0x20801313) # macro
NV2080_CTRL_FB_IS_KIND_PARAMS_MESSAGE_ID = (0x13) # macro
NV2080_CTRL_FB_IS_KIND_OPERATION_SUPPORTED = (0x00000000) # macro
NV2080_CTRL_FB_IS_KIND_OPERATION_COMPRESSIBLE = (0x00000001) # macro
NV2080_CTRL_FB_IS_KIND_OPERATION_COMPRESSIBLE_1 = (0x00000002) # macro
NV2080_CTRL_FB_IS_KIND_OPERATION_COMPRESSIBLE_2 = (0x00000003) # macro
NV2080_CTRL_FB_IS_KIND_OPERATION_COMPRESSIBLE_4 = (0x00000004) # macro
NV2080_CTRL_FB_IS_KIND_OPERATION_ZBC = (0x00000005) # macro
NV2080_CTRL_FB_IS_KIND_OPERATION_ZBC_ALLOWS_1 = (0x00000006) # macro
NV2080_CTRL_FB_IS_KIND_OPERATION_ZBC_ALLOWS_2 = (0x00000007) # macro
NV2080_CTRL_FB_IS_KIND_OPERATION_ZBC_ALLOWS_4 = (0x00000008) # macro
NV2080_CTRL_CMD_FB_GET_GPU_CACHE_INFO = (0x20801315) # macro
NV2080_CTRL_FB_GET_GPU_CACHE_INFO_PARAMS_MESSAGE_ID = (0x15) # macro
NV2080_CTRL_FB_GET_GPU_CACHE_INFO_POWER_STATE_ENABLED = (0x00000000) # macro
NV2080_CTRL_FB_GET_GPU_CACHE_INFO_POWER_STATE_DISABLED = (0x00000001) # macro
NV2080_CTRL_FB_GET_GPU_CACHE_INFO_WRITE_MODE_WRITETHROUGH = (0x00000000) # macro
NV2080_CTRL_FB_GET_GPU_CACHE_INFO_WRITE_MODE_WRITEBACK = (0x00000001) # macro
NV2080_CTRL_FB_GET_GPU_CACHE_INFO_BYPASS_MODE_DISABLED = (0x00000000) # macro
NV2080_CTRL_FB_GET_GPU_CACHE_INFO_BYPASS_MODE_ENABLED = (0x00000001) # macro
NV2080_CTRL_FB_GET_GPU_CACHE_INFO_RCM_STATE_FULL = (0x00000000) # macro
NV2080_CTRL_FB_GET_GPU_CACHE_INFO_RCM_STATE_TRANSITIONING = (0x00000001) # macro
NV2080_CTRL_FB_GET_GPU_CACHE_INFO_RCM_STATE_REDUCED = (0x00000002) # macro
NV2080_CTRL_FB_GET_GPU_CACHE_INFO_RCM_STATE_ZERO_CACHE = (0x00000003) # macro
NV2080_CTRL_FB_GPU_CACHE_PROMOTION_POLICY_NONE = (0x00000000) # macro
NV2080_CTRL_FB_GPU_CACHE_PROMOTION_POLICY_QUARTER = (0x00000001) # macro
NV2080_CTRL_FB_GPU_CACHE_PROMOTION_POLICY_HALF = (0x00000002) # macro
NV2080_CTRL_FB_GPU_CACHE_PROMOTION_POLICY_FULL = (0x00000003) # macro
NV2080_CTRL_CMD_FB_SET_GPU_CACHE_PROMOTION_POLICY = (0x20801316) # macro
NV2080_CTRL_CMD_FB_GET_GPU_CACHE_PROMOTION_POLICY = (0x20801317) # macro
NV2080_CTRL_CMD_FB_GET_FB_REGION_INFO = (0x20801320) # macro
NV2080_CTRL_CMD_FB_GET_FB_REGION_INFO_MEM_TYPES = 17 # macro
NV2080_CTRL_CMD_FB_GET_FB_REGION_INFO_MAX_ENTRIES = 16 # macro
NV2080_CTRL_CMD_FB_GET_FB_REGION_INFO_PARAMS_MESSAGE_ID = (0x20) # macro
NV2080_CTRL_CMD_FB_OFFLINE_PAGES = (0x20801321) # macro
NV2080_CTRL_FB_OFFLINED_PAGES_MAX_PAGES = (0x00000040) # macro
NV2080_CTRL_FB_OFFLINED_PAGES_INVALID_ADDRESS = (0xffffffffffffffff) # macro
NV2080_CTRL_FB_OFFLINED_PAGES_PAGE_SIZE_4K = (0x00000000) # macro
NV2080_CTRL_FB_OFFLINED_PAGES_PAGE_SIZE_64K = (0x00000001) # macro
NV2080_CTRL_FB_OFFLINED_PAGES_PAGE_SIZE_128K = (0x00000002) # macro
NV2080_CTRL_FB_OFFLINED_PAGES_SOURCE_DPR_MULTIPLE_SBE = (0x00000002) # macro
NV2080_CTRL_FB_OFFLINED_PAGES_SOURCE_DPR_DBE = (0x00000004) # macro
NV2080_CTRL_FB_OFFLINED_PAGES_STATUS_OK = (0x00000000) # macro
NV2080_CTRL_FB_OFFLINED_PAGES_STATUS_PENDING_RETIREMENT = (0x00000001) # macro
NV2080_CTRL_FB_OFFLINED_PAGES_STATUS_BLACKLISTING_FAILED = (0x00000002) # macro
NV2080_CTRL_FB_OFFLINED_PAGES_STATUS_TABLE_FULL = (0x00000003) # macro
NV2080_CTRL_FB_OFFLINED_PAGES_STATUS_INTERNAL_ERROR = (0x00000004) # macro
NV2080_CTRL_FB_OFFLINED_PAGES_SOURCE_MULTIPLE_SBE = (0x00000002) # macro
NV2080_CTRL_FB_OFFLINED_PAGES_SOURCE_DBE = (0x00000004) # macro
NV2080_CTRL_FB_OFFLINE_PAGES_PARAMS_MESSAGE_ID = (0x21) # macro
NV2080_CTRL_CMD_FB_GET_OFFLINED_PAGES = (0x20801322) # macro
NV2080_CTRL_FB_GET_OFFLINED_PAGES_RETIREMENT_PENDING_SBE = ['0', ':', '0'] # macro
NV2080_CTRL_FB_GET_OFFLINED_PAGES_RETIREMENT_PENDING_SBE_FALSE = 0 # macro
NV2080_CTRL_FB_GET_OFFLINED_PAGES_RETIREMENT_PENDING_SBE_TRUE = 1 # macro
NV2080_CTRL_FB_GET_OFFLINED_PAGES_RETIREMENT_PENDING_DBE = ['1', ':', '1'] # macro
NV2080_CTRL_FB_GET_OFFLINED_PAGES_RETIREMENT_PENDING_DBE_FALSE = 0 # macro
NV2080_CTRL_FB_GET_OFFLINED_PAGES_RETIREMENT_PENDING_DBE_TRUE = 1 # macro
NV2080_CTRL_FB_GET_OFFLINED_PAGES_PARAMS_MESSAGE_ID = (0x22) # macro
NV2080_CTRL_CMD_FB_QUERY_ACR_REGION = (0x20801325) # macro
NV2080_CTRL_CMD_FB_ACR_CLIENT_ID = 2 # macro
NV2080_CTRL_CMD_FB_QUERY_ACR_REGION_PARAMS_MESSAGE_ID = (0x25) # macro
NV2080_CTRL_CMD_FB_CLEAR_OFFLINED_PAGES = (0x20801326) # macro
NV2080_CTRL_FB_CLEAR_OFFLINED_PAGES_PARAMS_MESSAGE_ID = (0x26) # macro
NV2080_CTRL_CMD_FB_GET_COMPBITCOPY_INFO = (0x20801327) # macro
NV2080_CTRL_CMD_FB_GET_COMPBITCOPY_INFO_PARAMS_MESSAGE_ID = (0x27) # macro
NV2080_CTRL_CMD_FB_GET_LTC_INFO_FOR_FBP = (0x20801328) # macro
NV2080_CTRL_FB_GET_LTC_INFO_FOR_FBP_PARAMS_MESSAGE_ID = (0x28) # macro
NV2080_CTRL_CMD_FB_COMPBITCOPY_SET_CONTEXT = (0x20801329) # macro
NV2080_CTRL_CMD_FB_COMPBITCOPY_GET_COMPBITS = (0x2080132a) # macro
NV2080_CTRL_CMD_FB_COMPBITCOPY_PUT_COMPBITS = (0x2080132b) # macro
NV2080_CTRL_CMD_FB_COMPBITCOPY_READ_COMPBITS64KB = (0x2080132c) # macro
NV2080_CTRL_CMD_FB_COMPBITCOPY_WRITE_COMPBITS64KB = (0x2080132d) # macro
NV2080_CTRL_CMD_FB_COMPBITCOPY_SET_FORCE_BAR1 = (0x20801335) # macro
NV2080_CTRL_CMD_FB_GET_AMAP_CONF = (0x20801336) # macro
NV2080_CTRL_CMD_FB_GET_AMAP_CONF_PARAMS_MESSAGE_ID = (0x36) # macro
NV2080_CTRL_CMD_FB_CBC_OP = (0x20801337) # macro
NV2080_CTRL_CMD_FB_CBC_OP_PARAMS_MESSAGE_ID = (0x37) # macro
NV2080_CTRL_CMD_FB_GET_CTAGS_FOR_CBC_EVICTION = (0x20801338) # macro
NV2080_MAX_CTAGS_FOR_CBC_EVICTION = 0x7F # macro
NV2080_CTRL_FB_GET_CTAGS_FOR_CBC_EVICTION_PARAMS_MESSAGE_ID = (0x38) # macro
NV2080_CTRL_CMD_FB_ALLOC_COMP_RESOURCE = (0x20801339) # macro
NV2080_CTRL_CMD_FB_ALLOC_COMP_RESOURCE_PARAMS_MESSAGE_ID = (0x39) # macro
NV2080_CTRL_CMD_FB_FREE_TILE = (0x2080133a) # macro
NV2080_CTRL_CMD_FB_FREE_TILE_PARAMS_MESSAGE_ID = (0x3A) # macro
NV2080_CTRL_CMD_FB_SETUP_VPR_REGION = (0x2080133b) # macro
NV2080_CTRL_CMD_FB_SETUP_VPR_REGION_PARAMS_MESSAGE_ID = (0x3B) # macro
NV2080_CTRL_CMD_FB_GET_CLI_MANAGED_OFFLINED_PAGES = (0x2080133c) # macro
NV2080_CTRL_FB_GET_CLI_MANAGED_OFFLINED_PAGES_PARAMS_MESSAGE_ID = (0x3C) # macro
NV2080_CTRL_CMD_FB_GET_COMPBITCOPY_CONSTRUCT_INFO = (0x2080133d) # macro
NV2080_CTRL_CMD_FB_GET_COMPBITCOPY_CONSTRUCT_INFO_PARAMS_MESSAGE_ID = (0x3D) # macro
NV2080_CTRL_CMD_FB_SET_RRD = (0x2080133e) # macro
# def NV2080_CTRL_FB_SET_RRD_RESET_VALUE(~((NvU32):  # macro
#    return 0))
NV2080_CTRL_FB_SET_RRD_PARAMS_MESSAGE_ID = (0x3E) # macro
NV2080_CTRL_FB_SET_READ_WRITE_LIMIT_RESET_VALUE = (0xff) # macro
NV2080_CTRL_CMD_FB_SET_READ_LIMIT = (0x2080133f) # macro
NV2080_CTRL_FB_SET_READ_LIMIT_RESET_VALUE = (0xff) # macro
NV2080_CTRL_FB_SET_READ_LIMIT_PARAMS_MESSAGE_ID = (0x3F) # macro
NV2080_CTRL_CMD_FB_SET_WRITE_LIMIT = (0x20801340) # macro
NV2080_CTRL_FB_SET_WRITE_LIMIT_RESET_VALUE = (0xff) # macro
NV2080_CTRL_FB_SET_WRITE_LIMIT_PARAMS_MESSAGE_ID = (0x40) # macro
NV2080_CTRL_CMD_FB_PATCH_PBR_FOR_MINING = (0x20801341) # macro
NV2080_CTRL_FB_PATCH_PBR_FOR_MINING_PARAMS_MESSAGE_ID = (0x41) # macro
NV2080_CTRL_CMD_FB_GET_MEM_ALIGNMENT = (0x20801342) # macro
NV2080_CTRL_FB_GET_MEM_ALIGNMENT_MAX_BANKS = (4) # macro
NV2080_CTRL_FB_GET_MEM_ALIGNMENT_PARAMS_MESSAGE_ID = (0x42) # macro
NV2080_CTRL_CMD_FB_GET_CBC_BASE_ADDR = (0x20801343) # macro
NV2080_CTRL_CMD_FB_GET_CBC_BASE_ADDR_PARAMS_MESSAGE_ID = (0x43) # macro
NV2080_CTRL_FB_REMAP_ENTRY_FLAGS_PENDING = ['0', ':', '0'] # macro
NV2080_CTRL_FB_REMAP_ENTRY_FLAGS_PENDING_FALSE = 0 # macro
NV2080_CTRL_FB_REMAP_ENTRY_FLAGS_PENDING_TRUE = 1 # macro
NV2080_CTRL_FB_REMAPPED_ROW_SOURCE_SBE_FIELD = (0x00000002) # macro
NV2080_CTRL_FB_REMAPPED_ROW_SOURCE_DBE_FIELD = (0x00000003) # macro
NV2080_CTRL_FB_REMAPPED_ROWS_MAX_ROWS = (0x00000200) # macro
NV2080_CTRL_CMD_FB_GET_REMAPPED_ROWS = (0x20801344) # macro
NV2080_CTRL_FB_GET_REMAPPED_ROWS_FLAGS_PENDING = ['0', ':', '0'] # macro
NV2080_CTRL_FB_GET_REMAPPED_ROWS_FLAGS_PENDING_FALSE = 0 # macro
NV2080_CTRL_FB_GET_REMAPPED_ROWS_FLAGS_PENDING_TRUE = 1 # macro
NV2080_CTRL_FB_GET_REMAPPED_ROWS_FLAGS_FAILURE = ['1', ':', '1'] # macro
NV2080_CTRL_FB_GET_REMAPPED_ROWS_FLAGS_FAILURE_FALSE = 0 # macro
NV2080_CTRL_FB_GET_REMAPPED_ROWS_FLAGS_FAILURE_TRUE = 1 # macro
NV2080_CTRL_FB_GET_REMAPPED_ROWS_PARAMS_MESSAGE_ID = (0x44) # macro
NV2080_CTRL_FB_FS_INFO_MAX_QUERY_SIZE = 24 # macro
NV2080_CTRL_FB_FS_INFO_INVALID_QUERY = 0x0 # macro
NV2080_CTRL_FB_FS_INFO_FBP_MASK = 0x1 # macro
NV2080_CTRL_FB_FS_INFO_LTC_MASK = 0x2 # macro
NV2080_CTRL_FB_FS_INFO_LTS_MASK = 0x3 # macro
NV2080_CTRL_FB_FS_INFO_FBPA_MASK = 0x4 # macro
NV2080_CTRL_FB_FS_INFO_ROP_MASK = 0x5 # macro
NV2080_CTRL_FB_FS_INFO_PROFILER_MON_LTC_MASK = 0x6 # macro
NV2080_CTRL_FB_FS_INFO_PROFILER_MON_LTS_MASK = 0x7 # macro
NV2080_CTRL_FB_FS_INFO_PROFILER_MON_FBPA_MASK = 0x8 # macro
NV2080_CTRL_FB_FS_INFO_PROFILER_MON_ROP_MASK = 0x9 # macro
NV2080_CTRL_FB_FS_INFO_FBPA_SUBP_MASK = 0xA # macro
NV2080_CTRL_FB_FS_INFO_PROFILER_MON_FBPA_SUBP_MASK = 0xB # macro
NV2080_CTRL_FB_FS_INFO_FBP_LOGICAL_MAP = 0xC # macro
NV2080_CTRL_SYSL2_FS_INFO_SYSLTC_MASK = 0xD # macro
NV2080_CTRL_FB_FS_INFO_PAC_MASK = 0xE # macro
NV2080_CTRL_FB_FS_INFO_MAX_QUERIES = 120 # macro
NV2080_CTRL_FB_GET_FS_INFO_PARAMS_MESSAGE_ID = (0x46) # macro
NV2080_CTRL_CMD_FB_GET_FS_INFO = (0x20801346) # macro
NV2080_CTRL_FB_HISTOGRAM_IDX_NO_REMAPPED_ROWS = (0x0) # macro
NV2080_CTRL_FB_HISTOGRAM_IDX_SINGLE_REMAPPED_ROW = (0x1) # macro
NV2080_CTRL_FB_HISTOGRAM_IDX_MIXED_REMAPPED_REMAINING_ROWS = (0x2) # macro
NV2080_CTRL_FB_HISTOGRAM_IDX_SINGLE_REMAINING_ROW = (0x3) # macro
NV2080_CTRL_FB_HISTOGRAM_IDX_MAX_REMAPPED_ROWS = (0x4) # macro
NV2080_CTRL_FB_GET_ROW_REMAPPER_HISTOGRAM_PARAMS_MESSAGE_ID = (0x47) # macro
NV2080_CTRL_CMD_FB_GET_ROW_REMAPPER_HISTOGRAM = (0x20801347) # macro
NV2080_CTRL_CMD_FB_GET_DYNAMIC_OFFLINED_PAGES = (0x20801348) # macro
NV2080_CTRL_FB_DYNAMIC_BLACKLIST_MAX_PAGES = 512 # macro
NV2080_CTRL_FB_DYNAMIC_BLACKLIST_MAX_ENTRIES = 64 # macro
NV2080_CTRL_FB_GET_DYNAMIC_OFFLINED_PAGES_PARAMS_MESSAGE_ID = (0x48) # macro
NV2080_CTRL_FB_DYNAMIC_BLACKLISTED_PAGES_SOURCE_INVALID = (0x00000000) # macro
NV2080_CTRL_FB_DYNAMIC_BLACKLISTED_PAGES_SOURCE_DPR_DBE = (0x00000001) # macro
NV2080_CTRL_CMD_FB_GET_CLIENT_ALLOCATION_INFO = (0x20801349) # macro
NV2080_CTRL_CMD_FB_ALLOCATION_FLAGS_TYPE = ['4', ':', '0'] # macro
NV2080_CTRL_CMD_FB_ALLOCATION_FLAGS_TYPE_SYSMEM = 0 # macro
NV2080_CTRL_CMD_FB_ALLOCATION_FLAGS_TYPE_VIDMEM = 1 # macro
NV2080_CTRL_CMD_FB_ALLOCATION_FLAGS_SHARED = ['5', ':', '5'] # macro
NV2080_CTRL_CMD_FB_ALLOCATION_FLAGS_SHARED_FALSE = 0 # macro
NV2080_CTRL_CMD_FB_ALLOCATION_FLAGS_SHARED_TRUE = 1 # macro
NV2080_CTRL_CMD_FB_ALLOCATION_FLAGS_OWNER = ['6', ':', '6'] # macro
NV2080_CTRL_CMD_FB_ALLOCATION_FLAGS_OWNER_FALSE = 0 # macro
NV2080_CTRL_CMD_FB_ALLOCATION_FLAGS_OWNER_TRUE = 1 # macro
NV2080_CTRL_CMD_FB_GET_CLIENT_ALLOCATION_INFO_PARAMS_MESSAGE_ID = (0x49) # macro
NV2080_CTRL_CMD_FB_UPDATE_NUMA_STATUS = (0x20801350) # macro
NV2080_CTRL_FB_UPDATE_NUMA_STATUS_PARAMS_MESSAGE_ID = (0x50) # macro
NV2080_CTRL_CMD_FB_GET_NUMA_INFO = (0x20801351) # macro
NV2080_CTRL_FB_NUMA_INFO_MAX_OFFLINE_ADDRESSES = 64 # macro
NV2080_CTRL_FB_GET_NUMA_INFO_PARAMS_MESSAGE_ID = (0x51) # macro
NV2080_CTRL_CMD_FB_GET_SEMAPHORE_SURFACE_LAYOUT = (0x20801352) # macro
NV2080_CTRL_FB_GET_SEMAPHORE_SURFACE_LAYOUT_CAPS_MONITORED_FENCE_SUPPORTED = (0x00000001) # macro
NV2080_CTRL_FB_GET_SEMAPHORE_SURFACE_LAYOUT_CAPS_64BIT_SEMAPHORES_SUPPORTED = (0x00000002) # macro
NV2080_CTRL_FB_GET_SEMAPHORE_SURFACE_LAYOUT_PARAMS_MESSAGE_ID = (0x52) # macro
NV2080_CTRL_CMD_FB_STATS_MAX_OWNER = 200 # macro
NV2080_CTRL_CMD_FB_STATS_GET = (0x2080132a) # macro
NV2080_CTRL_CMD_FB_STATS_GET_PARAMS_MESSAGE_ID = (0x2A) # macro
NV2080_CTRL_FB_INFO = struct_NVXXXX_CTRL_XXX_INFO
class struct_NV2080_CTRL_FB_GET_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_GET_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_GET_INFO_PARAMS._fields_ = [
    ('fbInfoListSize', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('fbInfoList', ctypes.POINTER(None)),
]

NV2080_CTRL_FB_GET_INFO_PARAMS = struct_NV2080_CTRL_FB_GET_INFO_PARAMS
class struct_NV2080_CTRL_FB_GET_INFO_V2_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_GET_INFO_V2_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_GET_INFO_V2_PARAMS._fields_ = [
    ('fbInfoListSize', ctypes.c_uint32),
    ('fbInfoList', struct_NVXXXX_CTRL_XXX_INFO * 55),
]

NV2080_CTRL_FB_GET_INFO_V2_PARAMS = struct_NV2080_CTRL_FB_GET_INFO_V2_PARAMS
class struct_NV2080_CTRL_FB_GET_BAR1_OFFSET_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_GET_BAR1_OFFSET_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_GET_BAR1_OFFSET_PARAMS._fields_ = [
    ('cpuVirtAddress', ctypes.POINTER(None)),
    ('gpuVirtAddress', ctypes.c_uint64),
]

NV2080_CTRL_FB_GET_BAR1_OFFSET_PARAMS = struct_NV2080_CTRL_FB_GET_BAR1_OFFSET_PARAMS
class struct_NV2080_CTRL_FB_GET_SYSTEM_CARVEOUT_ADDRESS_SPACE_INFO(Structure):
    pass

struct_NV2080_CTRL_FB_GET_SYSTEM_CARVEOUT_ADDRESS_SPACE_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_GET_SYSTEM_CARVEOUT_ADDRESS_SPACE_INFO._fields_ = [
    ('StartAddr', ctypes.c_uint64),
    ('SpaceSize', ctypes.c_uint64),
]

NV2080_CTRL_FB_GET_SYSTEM_CARVEOUT_ADDRESS_SPACE_INFO = struct_NV2080_CTRL_FB_GET_SYSTEM_CARVEOUT_ADDRESS_SPACE_INFO
class struct_NV2080_CTRL_FB_GET_CALIBRATION_LOCK_FAILED_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_GET_CALIBRATION_LOCK_FAILED_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_GET_CALIBRATION_LOCK_FAILED_PARAMS._fields_ = [
    ('flags', ctypes.c_uint32),
    ('driveStrengthRiseCount', ctypes.c_uint32),
    ('driveStrengthFallCount', ctypes.c_uint32),
    ('driveStrengthTermCount', ctypes.c_uint32),
    ('slewStrengthRiseCount', ctypes.c_uint32),
    ('slewStrengthFallCount', ctypes.c_uint32),
]

NV2080_CTRL_FB_GET_CALIBRATION_LOCK_FAILED_PARAMS = struct_NV2080_CTRL_FB_GET_CALIBRATION_LOCK_FAILED_PARAMS
class struct_NV2080_CTRL_CMD_FB_FLUSH_GPU_CACHE_IRQL_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_FB_FLUSH_GPU_CACHE_IRQL_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_FB_FLUSH_GPU_CACHE_IRQL_PARAMS._fields_ = [
    ('flags', ctypes.c_uint32),
]

NV2080_CTRL_CMD_FB_FLUSH_GPU_CACHE_IRQL_PARAMS = struct_NV2080_CTRL_CMD_FB_FLUSH_GPU_CACHE_IRQL_PARAMS
class struct_NV2080_CTRL_FB_FLUSH_GPU_CACHE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_FLUSH_GPU_CACHE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_FLUSH_GPU_CACHE_PARAMS._fields_ = [
    ('addressArray', ctypes.c_uint64 * 500),
    ('addressArraySize', ctypes.c_uint32),
    ('addressAlign', ctypes.c_uint32),
    ('memBlockSizeBytes', ctypes.c_uint64),
    ('flags', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NV2080_CTRL_FB_FLUSH_GPU_CACHE_PARAMS = struct_NV2080_CTRL_FB_FLUSH_GPU_CACHE_PARAMS
class struct_NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_PARAMS._fields_ = [
    ('engine', ctypes.c_uint32),
    ('allocPolicy', ctypes.c_uint32),
]

NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_PARAMS = struct_NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_PARAMS
NV2080_CTRL_FB_SET_GPU_CACHE_ALLOC_POLICY_PARAMS = struct_NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_PARAMS
class struct_NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_ENTRY(Structure):
    pass

struct_NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_ENTRY._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_ENTRY._fields_ = [
    ('client', ctypes.c_uint32),
    ('allocPolicy', ctypes.c_uint32),
]

NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_ENTRY = struct_NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_ENTRY
class struct_NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_PARAMS._fields_ = [
    ('count', ctypes.c_uint32),
    ('entry', struct_NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_ENTRY * 11),
]

NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_PARAMS = struct_NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_PARAMS
NV2080_CTRL_FB_SET_GPU_CACHE_ALLOC_POLICY_V2_PARAMS = struct_NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_PARAMS
NV2080_CTRL_FB_GET_GPU_CACHE_ALLOC_POLICY_PARAMS = struct_NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_PARAMS
NV2080_CTRL_FB_GET_GPU_CACHE_ALLOC_POLICY_V2_PARAMS = struct_NV2080_CTRL_FB_GPU_CACHE_ALLOC_POLICY_V2_PARAMS
class struct_NV2080_CTRL_FB_IS_KIND_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_IS_KIND_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_IS_KIND_PARAMS._fields_ = [
    ('operation', ctypes.c_uint32),
    ('kind', ctypes.c_uint32),
    ('result', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_FB_IS_KIND_PARAMS = struct_NV2080_CTRL_FB_IS_KIND_PARAMS
class struct_NV2080_CTRL_FB_GET_GPU_CACHE_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_GET_GPU_CACHE_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_GET_GPU_CACHE_INFO_PARAMS._fields_ = [
    ('powerState', ctypes.c_uint32),
    ('writeMode', ctypes.c_uint32),
    ('bypassMode', ctypes.c_uint32),
    ('rcmState', ctypes.c_uint32),
]

NV2080_CTRL_FB_GET_GPU_CACHE_INFO_PARAMS = struct_NV2080_CTRL_FB_GET_GPU_CACHE_INFO_PARAMS
class struct_NV2080_CTRL_FB_GPU_CACHE_PROMOTION_POLICY_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_GPU_CACHE_PROMOTION_POLICY_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_GPU_CACHE_PROMOTION_POLICY_PARAMS._fields_ = [
    ('engine', ctypes.c_uint32),
    ('promotionPolicy', ctypes.c_uint32),
]

NV2080_CTRL_FB_GPU_CACHE_PROMOTION_POLICY_PARAMS = struct_NV2080_CTRL_FB_GPU_CACHE_PROMOTION_POLICY_PARAMS
NV2080_CTRL_CMD_FB_GET_FB_REGION_SURFACE_MEM_TYPE_FLAG = ctypes.c_ubyte * 17
class struct_NV2080_CTRL_CMD_FB_GET_FB_REGION_FB_REGION_INFO(Structure):
    pass

struct_NV2080_CTRL_CMD_FB_GET_FB_REGION_FB_REGION_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_FB_GET_FB_REGION_FB_REGION_INFO._fields_ = [
    ('base', ctypes.c_uint64),
    ('limit', ctypes.c_uint64),
    ('reserved', ctypes.c_uint64),
    ('performance', ctypes.c_uint32),
    ('supportCompressed', ctypes.c_ubyte),
    ('supportISO', ctypes.c_ubyte),
    ('bProtected', ctypes.c_ubyte),
    ('blackList', ctypes.c_ubyte * 17),
]

NV2080_CTRL_CMD_FB_GET_FB_REGION_FB_REGION_INFO = struct_NV2080_CTRL_CMD_FB_GET_FB_REGION_FB_REGION_INFO
class struct_NV2080_CTRL_CMD_FB_GET_FB_REGION_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_FB_GET_FB_REGION_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_FB_GET_FB_REGION_INFO_PARAMS._fields_ = [
    ('numFBRegions', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('fbRegion', struct_NV2080_CTRL_CMD_FB_GET_FB_REGION_FB_REGION_INFO * 16),
]

NV2080_CTRL_CMD_FB_GET_FB_REGION_INFO_PARAMS = struct_NV2080_CTRL_CMD_FB_GET_FB_REGION_INFO_PARAMS
class struct_NV2080_CTRL_FB_OFFLINED_ADDRESS_INFO(Structure):
    pass

struct_NV2080_CTRL_FB_OFFLINED_ADDRESS_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_OFFLINED_ADDRESS_INFO._fields_ = [
    ('pageAddressWithEccOn', ctypes.c_uint64),
    ('pageAddressWithEccOff', ctypes.c_uint64),
    ('rbcAddress', ctypes.c_uint32),
    ('source', ctypes.c_uint32),
    ('status', ctypes.c_uint32),
    ('timestamp', ctypes.c_uint32),
]

NV2080_CTRL_FB_OFFLINED_ADDRESS_INFO = struct_NV2080_CTRL_FB_OFFLINED_ADDRESS_INFO
class struct_NV2080_CTRL_FB_OFFLINE_PAGES_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_OFFLINE_PAGES_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_OFFLINE_PAGES_PARAMS._fields_ = [
    ('offlined', struct_NV2080_CTRL_FB_OFFLINED_ADDRESS_INFO * 64),
    ('pageSize', ctypes.c_uint32),
    ('validEntries', ctypes.c_uint32),
    ('numPagesAdded', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NV2080_CTRL_FB_OFFLINE_PAGES_PARAMS = struct_NV2080_CTRL_FB_OFFLINE_PAGES_PARAMS
class struct_NV2080_CTRL_FB_GET_OFFLINED_PAGES_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_GET_OFFLINED_PAGES_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_GET_OFFLINED_PAGES_PARAMS._fields_ = [
    ('offlined', struct_NV2080_CTRL_FB_OFFLINED_ADDRESS_INFO * 64),
    ('validEntries', ctypes.c_uint32),
    ('bRetirementPending', ctypes.c_ubyte),
    ('retirementPending', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 2),
]

NV2080_CTRL_FB_GET_OFFLINED_PAGES_PARAMS = struct_NV2080_CTRL_FB_GET_OFFLINED_PAGES_PARAMS

# values for enumeration 'NV2080_CTRL_CMD_FB_ACR_QUERY_TYPE'
NV2080_CTRL_CMD_FB_ACR_QUERY_TYPE__enumvalues = {
    0: 'NV2080_CTRL_CMD_FB_ACR_QUERY_GET_CLIENT_REGION_STATUS',
    1: 'NV2080_CTRL_CMD_FB_ACR_QUERY_GET_REGION_PROPERTY',
    2: 'NV2080_CTRL_CMD_FB_ACR_QUERY_GET_FALCON_STATUS',
}
NV2080_CTRL_CMD_FB_ACR_QUERY_GET_CLIENT_REGION_STATUS = 0
NV2080_CTRL_CMD_FB_ACR_QUERY_GET_REGION_PROPERTY = 1
NV2080_CTRL_CMD_FB_ACR_QUERY_GET_FALCON_STATUS = 2
NV2080_CTRL_CMD_FB_ACR_QUERY_TYPE = ctypes.c_uint32 # enum

# values for enumeration 'NV2080_CTRL_CMD_FB_ACR_QUERY_ERROR_CODE'
NV2080_CTRL_CMD_FB_ACR_QUERY_ERROR_CODE__enumvalues = {
    0: 'NV2080_CTRL_CMD_FB_ACR_QUERY_ERROR_NONE',
    1: 'NV2080_CTRL_CMD_FB_ACR_QUERY_ERROR_INVALID_CLIENT_REQUEST',
}
NV2080_CTRL_CMD_FB_ACR_QUERY_ERROR_NONE = 0
NV2080_CTRL_CMD_FB_ACR_QUERY_ERROR_INVALID_CLIENT_REQUEST = 1
NV2080_CTRL_CMD_FB_ACR_QUERY_ERROR_CODE = ctypes.c_uint32 # enum
class struct_ACR_REQUEST_PARAMS(Structure):
    pass

struct_ACR_REQUEST_PARAMS._pack_ = 1 # source:False
struct_ACR_REQUEST_PARAMS._fields_ = [
    ('clientId', ctypes.c_uint32),
    ('reqReadMask', ctypes.c_uint32),
    ('reqWriteMask', ctypes.c_uint32),
    ('regionSize', ctypes.c_uint32),
]

ACR_REQUEST_PARAMS = struct_ACR_REQUEST_PARAMS
class struct_ACR_REGION_ID_PROP(Structure):
    pass

struct_ACR_REGION_ID_PROP._pack_ = 1 # source:False
struct_ACR_REGION_ID_PROP._fields_ = [
    ('regionId', ctypes.c_uint32),
    ('readMask', ctypes.c_uint32),
    ('writeMask', ctypes.c_uint32),
    ('regionSize', ctypes.c_uint32),
    ('clientMask', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('physicalAddress', ctypes.c_uint64),
]

ACR_REGION_ID_PROP = struct_ACR_REGION_ID_PROP
class struct_ACR_STATUS_PARAMS(Structure):
    pass

struct_ACR_STATUS_PARAMS._pack_ = 1 # source:False
struct_ACR_STATUS_PARAMS._fields_ = [
    ('allocStatus', ctypes.c_uint32),
    ('regionId', ctypes.c_uint32),
    ('physicalAddress', ctypes.c_uint64),
]

ACR_STATUS_PARAMS = struct_ACR_STATUS_PARAMS
class struct_ACR_REGION_HANDLE(Structure):
    pass

struct_ACR_REGION_HANDLE._pack_ = 1 # source:False
struct_ACR_REGION_HANDLE._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hParent', ctypes.c_uint32),
    ('hMemory', ctypes.c_uint32),
    ('hClass', ctypes.c_uint32),
    ('hDevice', ctypes.c_uint32),
]

ACR_REGION_HANDLE = struct_ACR_REGION_HANDLE
class struct_ACR_FALCON_LS_STATUS(Structure):
    pass

struct_ACR_FALCON_LS_STATUS._pack_ = 1 # source:False
struct_ACR_FALCON_LS_STATUS._fields_ = [
    ('falconId', ctypes.c_uint16),
    ('bIsInLs', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte),
]

ACR_FALCON_LS_STATUS = struct_ACR_FALCON_LS_STATUS
class struct_NV2080_CTRL_CMD_FB_QUERY_ACR_REGION_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('queryType', NV2080_CTRL_CMD_FB_ACR_QUERY_TYPE),
    ('errorCode', NV2080_CTRL_CMD_FB_ACR_QUERY_ERROR_CODE),
    ('acrRegionIdProp', ACR_REGION_ID_PROP),
    ('clientReq', ACR_REQUEST_PARAMS),
    ('clientReqStatus', ACR_STATUS_PARAMS),
    ('handle', ACR_REGION_HANDLE),
    ('falconStatus', ACR_FALCON_LS_STATUS),
     ]

NV2080_CTRL_CMD_FB_QUERY_ACR_REGION_PARAMS = struct_NV2080_CTRL_CMD_FB_QUERY_ACR_REGION_PARAMS
class struct_NV2080_CTRL_FB_CLEAR_OFFLINED_PAGES_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_CLEAR_OFFLINED_PAGES_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_CLEAR_OFFLINED_PAGES_PARAMS._fields_ = [
    ('sourceMask', ctypes.c_uint32),
]

NV2080_CTRL_FB_CLEAR_OFFLINED_PAGES_PARAMS = struct_NV2080_CTRL_FB_CLEAR_OFFLINED_PAGES_PARAMS
class struct_NV2080_CTRL_CMD_FB_GET_COMPBITCOPY_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_FB_GET_COMPBITCOPY_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_FB_GET_COMPBITCOPY_INFO_PARAMS._fields_ = [
    ('pCompBitCopyObj', ctypes.POINTER(None)),
    ('pSwizzleParams', ctypes.POINTER(None)),
]

NV2080_CTRL_CMD_FB_GET_COMPBITCOPY_INFO_PARAMS = struct_NV2080_CTRL_CMD_FB_GET_COMPBITCOPY_INFO_PARAMS
class struct_NV2080_CTRL_FB_GET_LTC_INFO_FOR_FBP_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_GET_LTC_INFO_FOR_FBP_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_GET_LTC_INFO_FOR_FBP_PARAMS._fields_ = [
    ('fbpIndex', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('ltcMask', ctypes.c_uint32),
    ('ltcCount', ctypes.c_uint32),
    ('ltsMask', ctypes.c_uint32),
    ('ltsCount', ctypes.c_uint32),
]

NV2080_CTRL_FB_GET_LTC_INFO_FOR_FBP_PARAMS = struct_NV2080_CTRL_FB_GET_LTC_INFO_FOR_FBP_PARAMS
class struct_NV2080_CTRL_CMD_FB_COMPBITCOPY_SET_CONTEXT_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_FB_COMPBITCOPY_SET_CONTEXT_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_FB_COMPBITCOPY_SET_CONTEXT_PARAMS._fields_ = [
    ('CBCBaseAddress', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('backingStorePA', ctypes.c_uint64),
    ('backingStoreVA', ctypes.POINTER(ctypes.c_ubyte)),
    ('backingStoreChunkPA', ctypes.c_uint64),
    ('backingStoreChunkVA', ctypes.POINTER(ctypes.c_ubyte)),
    ('backingStoreChunkSize', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
    ('cacheWriteBitMap', ctypes.POINTER(ctypes.c_ubyte)),
    ('backingStoreChunkOverfetch', ctypes.c_ubyte),
    ('PADDING_2', ctypes.c_ubyte * 3),
    ('PageSizeSrc', ctypes.c_uint32),
    ('PageSizeDest', ctypes.c_uint32),
    ('PADDING_3', ctypes.c_ubyte * 4),
]

NV2080_CTRL_CMD_FB_COMPBITCOPY_SET_CONTEXT_PARAMS = struct_NV2080_CTRL_CMD_FB_COMPBITCOPY_SET_CONTEXT_PARAMS
class struct_NV2080_CTRL_CMD_FB_COMPBITCOPY_GET_COMPBITS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_FB_COMPBITCOPY_GET_COMPBITS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_FB_COMPBITCOPY_GET_COMPBITS_PARAMS._fields_ = [
    ('fcbits', ctypes.POINTER(ctypes.c_uint32)),
    ('compbits', ctypes.POINTER(ctypes.c_uint32)),
    ('dataPhysicalStart', ctypes.c_uint64),
    ('surfaceOffset', ctypes.c_uint64),
    ('comptagLine', ctypes.c_uint32),
    ('upper64KBCompbitSel', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_CMD_FB_COMPBITCOPY_GET_COMPBITS_PARAMS = struct_NV2080_CTRL_CMD_FB_COMPBITCOPY_GET_COMPBITS_PARAMS
class struct_NV2080_CTRL_CMD_FB_COMPBITCOPY_PUT_COMPBITS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_FB_COMPBITCOPY_PUT_COMPBITS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_FB_COMPBITCOPY_PUT_COMPBITS_PARAMS._fields_ = [
    ('fcbits', ctypes.c_uint32),
    ('compbits', ctypes.c_uint32),
    ('writeFc', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 7),
    ('dataPhysicalStart', ctypes.c_uint64),
    ('surfaceOffset', ctypes.c_uint64),
    ('comptagLine', ctypes.c_uint32),
    ('upper64KBCompbitSel', ctypes.c_ubyte),
    ('PADDING_1', ctypes.c_ubyte * 3),
]

NV2080_CTRL_CMD_FB_COMPBITCOPY_PUT_COMPBITS_PARAMS = struct_NV2080_CTRL_CMD_FB_COMPBITCOPY_PUT_COMPBITS_PARAMS
class struct_NV2080_CTRL_CMD_FB_COMPBITCOPY_READ_COMPBITS64KB_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_FB_COMPBITCOPY_READ_COMPBITS64KB_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_FB_COMPBITCOPY_READ_COMPBITS64KB_PARAMS._fields_ = [
    ('SrcDataPhysicalStart', ctypes.c_uint64),
    ('SrcComptagLine', ctypes.c_uint32),
    ('page64KB', ctypes.c_uint32),
    ('compbitBuffer', ctypes.POINTER(ctypes.c_uint32)),
    ('upper64KBCompbitSel', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 7),
]

NV2080_CTRL_CMD_FB_COMPBITCOPY_READ_COMPBITS64KB_PARAMS = struct_NV2080_CTRL_CMD_FB_COMPBITCOPY_READ_COMPBITS64KB_PARAMS
class struct_NV2080_CTRL_CMD_FB_COMPBITCOPY_WRITE_COMPBITS64KB_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_FB_COMPBITCOPY_WRITE_COMPBITS64KB_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_FB_COMPBITCOPY_WRITE_COMPBITS64KB_PARAMS._fields_ = [
    ('DstDataPhysicalStart', ctypes.c_uint64),
    ('DstComptagLine', ctypes.c_uint32),
    ('page64KB', ctypes.c_uint32),
    ('compbitBuffer', ctypes.POINTER(ctypes.c_uint32)),
    ('upper64KBCompbitSel', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 7),
]

NV2080_CTRL_CMD_FB_COMPBITCOPY_WRITE_COMPBITS64KB_PARAMS = struct_NV2080_CTRL_CMD_FB_COMPBITCOPY_WRITE_COMPBITS64KB_PARAMS
class struct_NV2080_CTRL_CMD_FB_COMPBITCOPY_SET_FORCE_BAR1_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_FB_COMPBITCOPY_SET_FORCE_BAR1_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_FB_COMPBITCOPY_SET_FORCE_BAR1_PARAMS._fields_ = [
    ('bForceBar1', ctypes.c_ubyte),
]

NV2080_CTRL_CMD_FB_COMPBITCOPY_SET_FORCE_BAR1_PARAMS = struct_NV2080_CTRL_CMD_FB_COMPBITCOPY_SET_FORCE_BAR1_PARAMS
class struct_NV2080_CTRL_CMD_FB_GET_AMAP_CONF_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_FB_GET_AMAP_CONF_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_FB_GET_AMAP_CONF_PARAMS._fields_ = [
    ('pAmapConfParams', ctypes.POINTER(None)),
    ('pCbcSwizzleParams', ctypes.POINTER(None)),
]

NV2080_CTRL_CMD_FB_GET_AMAP_CONF_PARAMS = struct_NV2080_CTRL_CMD_FB_GET_AMAP_CONF_PARAMS

# values for enumeration 'CTRL_CMD_FB_CBC_OP'
CTRL_CMD_FB_CBC_OP__enumvalues = {
    0: 'CTRL_CMD_FB_CBC_OP_CLEAN',
    1: 'CTRL_CMD_FB_CBC_OP_INVALIDATE',
}
CTRL_CMD_FB_CBC_OP_CLEAN = 0
CTRL_CMD_FB_CBC_OP_INVALIDATE = 1
CTRL_CMD_FB_CBC_OP = ctypes.c_uint32 # enum
class struct_NV2080_CTRL_CMD_FB_CBC_OP_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('fbCBCOp', CTRL_CMD_FB_CBC_OP),
     ]

NV2080_CTRL_CMD_FB_CBC_OP_PARAMS = struct_NV2080_CTRL_CMD_FB_CBC_OP_PARAMS
class struct_NV2080_CTRL_FB_GET_CTAGS_FOR_CBC_EVICTION_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_GET_CTAGS_FOR_CBC_EVICTION_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_GET_CTAGS_FOR_CBC_EVICTION_PARAMS._fields_ = [
    ('pCompTags', ctypes.c_uint32 * 127),
    ('numCompTags', ctypes.c_uint32),
]

NV2080_CTRL_FB_GET_CTAGS_FOR_CBC_EVICTION_PARAMS = struct_NV2080_CTRL_FB_GET_CTAGS_FOR_CBC_EVICTION_PARAMS
class struct_NV2080_CTRL_CMD_FB_ALLOC_COMP_RESOURCE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_FB_ALLOC_COMP_RESOURCE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_FB_ALLOC_COMP_RESOURCE_PARAMS._fields_ = [
    ('attr', ctypes.c_uint32),
    ('attr2', ctypes.c_uint32),
    ('size', ctypes.c_uint32),
    ('ctagOffset', ctypes.c_uint32),
    ('hwResId', ctypes.c_uint32),
    ('retCompTagLineMin', ctypes.c_uint32),
    ('retCompTagLineMax', ctypes.c_uint32),
]

NV2080_CTRL_CMD_FB_ALLOC_COMP_RESOURCE_PARAMS = struct_NV2080_CTRL_CMD_FB_ALLOC_COMP_RESOURCE_PARAMS
class struct_NV2080_CTRL_CMD_FB_FREE_TILE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_FB_FREE_TILE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_FB_FREE_TILE_PARAMS._fields_ = [
    ('hwResId', ctypes.c_uint32),
]

NV2080_CTRL_CMD_FB_FREE_TILE_PARAMS = struct_NV2080_CTRL_CMD_FB_FREE_TILE_PARAMS

# values for enumeration 'NV2080_CTRL_CMD_FB_VPR_REQUEST_TYPE'
NV2080_CTRL_CMD_FB_VPR_REQUEST_TYPE__enumvalues = {
    0: 'NV2080_CTRL_CMD_FB_SET_VPR',
}
NV2080_CTRL_CMD_FB_SET_VPR = 0
NV2080_CTRL_CMD_FB_VPR_REQUEST_TYPE = ctypes.c_uint32 # enum

# values for enumeration 'NV2080_CTRL_CMD_FB_VPR_ERROR_CODE'
NV2080_CTRL_CMD_FB_VPR_ERROR_CODE__enumvalues = {
    0: 'NV2080_CTRL_CMD_FB_VPR_ERROR_GENERIC',
    1: 'NV2080_CTRL_CMD_FB_VPR_ERROR_INVALID_CLIENT_REQUEST',
}
NV2080_CTRL_CMD_FB_VPR_ERROR_GENERIC = 0
NV2080_CTRL_CMD_FB_VPR_ERROR_INVALID_CLIENT_REQUEST = 1
NV2080_CTRL_CMD_FB_VPR_ERROR_CODE = ctypes.c_uint32 # enum
class struct_VPR_REQUEST_PARAMS(Structure):
    pass

struct_VPR_REQUEST_PARAMS._pack_ = 1 # source:False
struct_VPR_REQUEST_PARAMS._fields_ = [
    ('startAddr', ctypes.c_uint32),
    ('size', ctypes.c_uint32),
]

VPR_REQUEST_PARAMS = struct_VPR_REQUEST_PARAMS
class struct_VPR_STATUS_PARAMS(Structure):
    pass

struct_VPR_STATUS_PARAMS._pack_ = 1 # source:False
struct_VPR_STATUS_PARAMS._fields_ = [
    ('status', ctypes.c_uint32),
]

VPR_STATUS_PARAMS = struct_VPR_STATUS_PARAMS
class struct_NV2080_CTRL_CMD_FB_SETUP_VPR_REGION_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('requestType', NV2080_CTRL_CMD_FB_VPR_REQUEST_TYPE),
    ('requestParams', VPR_REQUEST_PARAMS),
    ('statusParams', VPR_STATUS_PARAMS),
     ]

NV2080_CTRL_CMD_FB_SETUP_VPR_REGION_PARAMS = struct_NV2080_CTRL_CMD_FB_SETUP_VPR_REGION_PARAMS
PNV2080_CTRL_CMD_FB_SETUP_VPR_REGION_PARAMS = ctypes.POINTER(struct_NV2080_CTRL_CMD_FB_SETUP_VPR_REGION_PARAMS)
class struct_NV2080_CTRL_FB_GET_CLI_MANAGED_OFFLINED_PAGES_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_GET_CLI_MANAGED_OFFLINED_PAGES_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_GET_CLI_MANAGED_OFFLINED_PAGES_PARAMS._fields_ = [
    ('offlinedPages', ctypes.c_uint32 * 64),
    ('pageSize', ctypes.c_uint32),
    ('validEntries', ctypes.c_uint32),
]

NV2080_CTRL_FB_GET_CLI_MANAGED_OFFLINED_PAGES_PARAMS = struct_NV2080_CTRL_FB_GET_CLI_MANAGED_OFFLINED_PAGES_PARAMS
class struct_NV2080_CTRL_CMD_FB_GET_COMPBITCOPY_CONSTRUCT_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_FB_GET_COMPBITCOPY_CONSTRUCT_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_FB_GET_COMPBITCOPY_CONSTRUCT_INFO_PARAMS._fields_ = [
    ('defaultPageSize', ctypes.c_uint32),
    ('comptagsPerCacheLine', ctypes.c_uint32),
    ('unpackedComptagLinesPerCacheLine', ctypes.c_uint32),
    ('compCacheLineSizePerLTC', ctypes.c_uint32),
    ('unpackedCompCacheLineSizePerLTC', ctypes.c_uint32),
    ('slicesPerLTC', ctypes.c_uint32),
    ('numActiveLTCs', ctypes.c_uint32),
    ('familyName', ctypes.c_uint32),
    ('chipName', ctypes.c_uint32),
    ('bitsPerRAMEntry', ctypes.c_uint32),
    ('ramBankWidth', ctypes.c_uint32),
    ('bitsPerComptagLine', ctypes.c_uint32),
    ('ramEntriesPerCompCacheLine', ctypes.c_uint32),
    ('comptagLineSize', ctypes.c_uint32),
]

NV2080_CTRL_CMD_FB_GET_COMPBITCOPY_CONSTRUCT_INFO_PARAMS = struct_NV2080_CTRL_CMD_FB_GET_COMPBITCOPY_CONSTRUCT_INFO_PARAMS
class struct_NV2080_CTRL_FB_SET_RRD_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_SET_RRD_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_SET_RRD_PARAMS._fields_ = [
    ('rrd', ctypes.c_uint32),
]

NV2080_CTRL_FB_SET_RRD_PARAMS = struct_NV2080_CTRL_FB_SET_RRD_PARAMS
class struct_NV2080_CTRL_FB_SET_READ_WRITE_LIMIT_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_SET_READ_WRITE_LIMIT_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_SET_READ_WRITE_LIMIT_PARAMS._fields_ = [
    ('limit', ctypes.c_ubyte),
]

NV2080_CTRL_FB_SET_READ_WRITE_LIMIT_PARAMS = struct_NV2080_CTRL_FB_SET_READ_WRITE_LIMIT_PARAMS
NV2080_CTRL_FB_SET_READ_LIMIT_PARAMS = struct_NV2080_CTRL_FB_SET_READ_WRITE_LIMIT_PARAMS
NV2080_CTRL_FB_SET_WRITE_LIMIT_PARAMS = struct_NV2080_CTRL_FB_SET_READ_WRITE_LIMIT_PARAMS
class struct_NV2080_CTRL_FB_PATCH_PBR_FOR_MINING_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_PATCH_PBR_FOR_MINING_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_PATCH_PBR_FOR_MINING_PARAMS._fields_ = [
    ('bEnable', ctypes.c_ubyte),
]

NV2080_CTRL_FB_PATCH_PBR_FOR_MINING_PARAMS = struct_NV2080_CTRL_FB_PATCH_PBR_FOR_MINING_PARAMS
class struct_NV2080_CTRL_FB_GET_MEM_ALIGNMENT_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_GET_MEM_ALIGNMENT_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_GET_MEM_ALIGNMENT_PARAMS._fields_ = [
    ('alignType', ctypes.c_uint32),
    ('alignAttr', ctypes.c_uint32),
    ('alignInputFlags', ctypes.c_uint32),
    ('alignHead', ctypes.c_uint32),
    ('alignSize', ctypes.c_uint64),
    ('alignHeight', ctypes.c_uint32),
    ('alignWidth', ctypes.c_uint32),
    ('alignPitch', ctypes.c_uint32),
    ('alignPad', ctypes.c_uint32),
    ('alignMask', ctypes.c_uint32),
    ('alignOutputFlags', ctypes.c_uint32 * 4),
    ('alignBank', ctypes.c_uint32 * 4),
    ('alignKind', ctypes.c_uint32),
    ('alignAdjust', ctypes.c_uint32),
    ('alignAttr2', ctypes.c_uint32),
]

NV2080_CTRL_FB_GET_MEM_ALIGNMENT_PARAMS = struct_NV2080_CTRL_FB_GET_MEM_ALIGNMENT_PARAMS
class struct_NV2080_CTRL_CMD_FB_GET_CBC_BASE_ADDR_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_FB_GET_CBC_BASE_ADDR_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_FB_GET_CBC_BASE_ADDR_PARAMS._fields_ = [
    ('cbcBaseAddress', ctypes.c_uint32),
    ('compCacheLineSize', ctypes.c_uint32),
    ('backingStoreStartPA', ctypes.c_uint64),
    ('backingStoreAllocPA', ctypes.c_uint64),
    ('backingStoreChunkOverfetch', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NV2080_CTRL_CMD_FB_GET_CBC_BASE_ADDR_PARAMS = struct_NV2080_CTRL_CMD_FB_GET_CBC_BASE_ADDR_PARAMS
class struct_NV2080_CTRL_FB_REMAP_ENTRY(Structure):
    pass

struct_NV2080_CTRL_FB_REMAP_ENTRY._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_REMAP_ENTRY._fields_ = [
    ('remapRegVal', ctypes.c_uint32),
    ('timestamp', ctypes.c_uint32),
    ('fbpa', ctypes.c_ubyte),
    ('sublocation', ctypes.c_ubyte),
    ('source', ctypes.c_ubyte),
    ('flags', ctypes.c_ubyte),
]

NV2080_CTRL_FB_REMAP_ENTRY = struct_NV2080_CTRL_FB_REMAP_ENTRY
class struct_NV2080_CTRL_FB_GET_REMAPPED_ROWS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_GET_REMAPPED_ROWS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_GET_REMAPPED_ROWS_PARAMS._fields_ = [
    ('entryCount', ctypes.c_uint32),
    ('flags', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('entries', struct_NV2080_CTRL_FB_REMAP_ENTRY * 512),
]

NV2080_CTRL_FB_GET_REMAPPED_ROWS_PARAMS = struct_NV2080_CTRL_FB_GET_REMAPPED_ROWS_PARAMS
class struct_NV2080_CTRL_FB_FS_INFO_INVALID_QUERY_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_FS_INFO_INVALID_QUERY_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_FS_INFO_INVALID_QUERY_PARAMS._fields_ = [
    ('data', ctypes.c_ubyte * 24),
]

NV2080_CTRL_FB_FS_INFO_INVALID_QUERY_PARAMS = struct_NV2080_CTRL_FB_FS_INFO_INVALID_QUERY_PARAMS
class struct_NV2080_CTRL_FB_FS_INFO_FBP_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_FS_INFO_FBP_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_FS_INFO_FBP_MASK_PARAMS._fields_ = [
    ('swizzId', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('fbpEnMask', ctypes.c_uint64),
]

NV2080_CTRL_FB_FS_INFO_FBP_MASK_PARAMS = struct_NV2080_CTRL_FB_FS_INFO_FBP_MASK_PARAMS
class struct_NV2080_CTRL_FB_FS_INFO_LTC_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_FS_INFO_LTC_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_FS_INFO_LTC_MASK_PARAMS._fields_ = [
    ('fbpIndex', ctypes.c_uint32),
    ('ltcEnMask', ctypes.c_uint32),
]

NV2080_CTRL_FB_FS_INFO_LTC_MASK_PARAMS = struct_NV2080_CTRL_FB_FS_INFO_LTC_MASK_PARAMS
class struct_NV2080_CTRL_FB_FS_INFO_LTS_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_FS_INFO_LTS_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_FS_INFO_LTS_MASK_PARAMS._fields_ = [
    ('fbpIndex', ctypes.c_uint32),
    ('ltsEnMask', ctypes.c_uint32),
]

NV2080_CTRL_FB_FS_INFO_LTS_MASK_PARAMS = struct_NV2080_CTRL_FB_FS_INFO_LTS_MASK_PARAMS
class struct_NV2080_CTRL_FB_FS_INFO_FBPA_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_FS_INFO_FBPA_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_FS_INFO_FBPA_MASK_PARAMS._fields_ = [
    ('fbpIndex', ctypes.c_uint32),
    ('fbpaEnMask', ctypes.c_uint32),
]

NV2080_CTRL_FB_FS_INFO_FBPA_MASK_PARAMS = struct_NV2080_CTRL_FB_FS_INFO_FBPA_MASK_PARAMS
class struct_NV2080_CTRL_FB_FS_INFO_FBPA_SUBP_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_FS_INFO_FBPA_SUBP_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_FS_INFO_FBPA_SUBP_MASK_PARAMS._fields_ = [
    ('fbpIndex', ctypes.c_uint32),
    ('fbpaSubpEnMask', ctypes.c_uint32),
]

NV2080_CTRL_FB_FS_INFO_FBPA_SUBP_MASK_PARAMS = struct_NV2080_CTRL_FB_FS_INFO_FBPA_SUBP_MASK_PARAMS
class struct_NV2080_CTRL_FB_FS_INFO_FBP_LOGICAL_MAP_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_FS_INFO_FBP_LOGICAL_MAP_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_FS_INFO_FBP_LOGICAL_MAP_PARAMS._fields_ = [
    ('fbpIndex', ctypes.c_uint32),
    ('fbpLogicalIndex', ctypes.c_uint32),
]

NV2080_CTRL_FB_FS_INFO_FBP_LOGICAL_MAP_PARAMS = struct_NV2080_CTRL_FB_FS_INFO_FBP_LOGICAL_MAP_PARAMS
class struct_NV2080_CTRL_FB_FS_INFO_ROP_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_FS_INFO_ROP_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_FS_INFO_ROP_MASK_PARAMS._fields_ = [
    ('fbpIndex', ctypes.c_uint32),
    ('ropEnMask', ctypes.c_uint32),
]

NV2080_CTRL_FB_FS_INFO_ROP_MASK_PARAMS = struct_NV2080_CTRL_FB_FS_INFO_ROP_MASK_PARAMS
class struct_NV2080_CTRL_FB_FS_INFO_PROFILER_MON_LTC_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_FS_INFO_PROFILER_MON_LTC_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_FS_INFO_PROFILER_MON_LTC_MASK_PARAMS._fields_ = [
    ('fbpIndex', ctypes.c_uint32),
    ('swizzId', ctypes.c_uint32),
    ('ltcEnMask', ctypes.c_uint32),
]

NV2080_CTRL_FB_FS_INFO_PROFILER_MON_LTC_MASK_PARAMS = struct_NV2080_CTRL_FB_FS_INFO_PROFILER_MON_LTC_MASK_PARAMS
class struct_NV2080_CTRL_FB_FS_INFO_PROFILER_MON_LTS_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_FS_INFO_PROFILER_MON_LTS_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_FS_INFO_PROFILER_MON_LTS_MASK_PARAMS._fields_ = [
    ('fbpIndex', ctypes.c_uint32),
    ('swizzId', ctypes.c_uint32),
    ('ltsEnMask', ctypes.c_uint32),
]

NV2080_CTRL_FB_FS_INFO_PROFILER_MON_LTS_MASK_PARAMS = struct_NV2080_CTRL_FB_FS_INFO_PROFILER_MON_LTS_MASK_PARAMS
class struct_NV2080_CTRL_FB_FS_INFO_PROFILER_MON_FBPA_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_FS_INFO_PROFILER_MON_FBPA_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_FS_INFO_PROFILER_MON_FBPA_MASK_PARAMS._fields_ = [
    ('fbpIndex', ctypes.c_uint32),
    ('swizzId', ctypes.c_uint32),
    ('fbpaEnMask', ctypes.c_uint32),
]

NV2080_CTRL_FB_FS_INFO_PROFILER_MON_FBPA_MASK_PARAMS = struct_NV2080_CTRL_FB_FS_INFO_PROFILER_MON_FBPA_MASK_PARAMS
class struct_NV2080_CTRL_FB_FS_INFO_PROFILER_MON_ROP_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_FS_INFO_PROFILER_MON_ROP_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_FS_INFO_PROFILER_MON_ROP_MASK_PARAMS._fields_ = [
    ('fbpIndex', ctypes.c_uint32),
    ('swizzId', ctypes.c_uint32),
    ('ropEnMask', ctypes.c_uint32),
]

NV2080_CTRL_FB_FS_INFO_PROFILER_MON_ROP_MASK_PARAMS = struct_NV2080_CTRL_FB_FS_INFO_PROFILER_MON_ROP_MASK_PARAMS
class struct_NV2080_CTRL_FB_FS_INFO_PROFILER_MON_FBPA_SUBP_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_FS_INFO_PROFILER_MON_FBPA_SUBP_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_FS_INFO_PROFILER_MON_FBPA_SUBP_MASK_PARAMS._fields_ = [
    ('fbpIndex', ctypes.c_uint32),
    ('swizzId', ctypes.c_uint32),
    ('fbpaSubpEnMask', ctypes.c_uint64),
]

NV2080_CTRL_FB_FS_INFO_PROFILER_MON_FBPA_SUBP_MASK_PARAMS = struct_NV2080_CTRL_FB_FS_INFO_PROFILER_MON_FBPA_SUBP_MASK_PARAMS
class struct_NV2080_CTRL_SYSL2_FS_INFO_SYSLTC_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_SYSL2_FS_INFO_SYSLTC_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_SYSL2_FS_INFO_SYSLTC_MASK_PARAMS._fields_ = [
    ('sysIdx', ctypes.c_uint32),
    ('sysl2LtcEnMask', ctypes.c_uint32),
]

NV2080_CTRL_SYSL2_FS_INFO_SYSLTC_MASK_PARAMS = struct_NV2080_CTRL_SYSL2_FS_INFO_SYSLTC_MASK_PARAMS
class struct_NV2080_CTRL_FB_FS_INFO_PAC_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_FS_INFO_PAC_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_FS_INFO_PAC_MASK_PARAMS._fields_ = [
    ('fbpIndex', ctypes.c_uint32),
    ('pacEnMask', ctypes.c_uint32),
]

NV2080_CTRL_FB_FS_INFO_PAC_MASK_PARAMS = struct_NV2080_CTRL_FB_FS_INFO_PAC_MASK_PARAMS
class struct_NV2080_CTRL_FB_FS_INFO_QUERY(Structure):
    pass

class union_NV2080_CTRL_FB_FS_INFO_QUERY_queryParams(Union):
    pass

union_NV2080_CTRL_FB_FS_INFO_QUERY_queryParams._pack_ = 1 # source:False
union_NV2080_CTRL_FB_FS_INFO_QUERY_queryParams._fields_ = [
    ('inv', NV2080_CTRL_FB_FS_INFO_INVALID_QUERY_PARAMS),
    ('fbp', NV2080_CTRL_FB_FS_INFO_FBP_MASK_PARAMS),
    ('ltc', NV2080_CTRL_FB_FS_INFO_LTC_MASK_PARAMS),
    ('lts', NV2080_CTRL_FB_FS_INFO_LTS_MASK_PARAMS),
    ('fbpa', NV2080_CTRL_FB_FS_INFO_FBPA_MASK_PARAMS),
    ('rop', NV2080_CTRL_FB_FS_INFO_ROP_MASK_PARAMS),
    ('dmLtc', NV2080_CTRL_FB_FS_INFO_PROFILER_MON_LTC_MASK_PARAMS),
    ('dmLts', NV2080_CTRL_FB_FS_INFO_PROFILER_MON_LTS_MASK_PARAMS),
    ('dmFbpa', NV2080_CTRL_FB_FS_INFO_PROFILER_MON_FBPA_MASK_PARAMS),
    ('dmRop', NV2080_CTRL_FB_FS_INFO_PROFILER_MON_ROP_MASK_PARAMS),
    ('dmFbpaSubp', NV2080_CTRL_FB_FS_INFO_PROFILER_MON_FBPA_SUBP_MASK_PARAMS),
    ('fbpaSubp', NV2080_CTRL_FB_FS_INFO_FBPA_SUBP_MASK_PARAMS),
    ('fbpLogicalMap', NV2080_CTRL_FB_FS_INFO_FBP_LOGICAL_MAP_PARAMS),
    ('sysl2Ltc', NV2080_CTRL_SYSL2_FS_INFO_SYSLTC_MASK_PARAMS),
    ('pac', NV2080_CTRL_FB_FS_INFO_PAC_MASK_PARAMS),
    ('PADDING_0', ctypes.c_ubyte * 16),
]

struct_NV2080_CTRL_FB_FS_INFO_QUERY._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_FS_INFO_QUERY._fields_ = [
    ('queryType', ctypes.c_uint16),
    ('reserved', ctypes.c_ubyte * 2),
    ('status', ctypes.c_uint32),
    ('queryParams', union_NV2080_CTRL_FB_FS_INFO_QUERY_queryParams),
]

NV2080_CTRL_FB_FS_INFO_QUERY = struct_NV2080_CTRL_FB_FS_INFO_QUERY
class struct_NV2080_CTRL_FB_GET_FS_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_GET_FS_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_GET_FS_INFO_PARAMS._fields_ = [
    ('numQueries', ctypes.c_uint16),
    ('reserved', ctypes.c_ubyte * 6),
    ('queries', struct_NV2080_CTRL_FB_FS_INFO_QUERY * 120),
]

NV2080_CTRL_FB_GET_FS_INFO_PARAMS = struct_NV2080_CTRL_FB_GET_FS_INFO_PARAMS
class struct_NV2080_CTRL_FB_GET_ROW_REMAPPER_HISTOGRAM_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_GET_ROW_REMAPPER_HISTOGRAM_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_GET_ROW_REMAPPER_HISTOGRAM_PARAMS._fields_ = [
    ('histogram', ctypes.c_uint32 * 5),
]

NV2080_CTRL_FB_GET_ROW_REMAPPER_HISTOGRAM_PARAMS = struct_NV2080_CTRL_FB_GET_ROW_REMAPPER_HISTOGRAM_PARAMS
class struct_NV2080_CTRL_FB_DYNAMIC_OFFLINED_ADDRESS_INFO(Structure):
    pass

struct_NV2080_CTRL_FB_DYNAMIC_OFFLINED_ADDRESS_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_DYNAMIC_OFFLINED_ADDRESS_INFO._fields_ = [
    ('pageNumber', ctypes.c_uint64),
    ('source', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 7),
]

NV2080_CTRL_FB_DYNAMIC_OFFLINED_ADDRESS_INFO = struct_NV2080_CTRL_FB_DYNAMIC_OFFLINED_ADDRESS_INFO
class struct_NV2080_CTRL_FB_GET_DYNAMIC_OFFLINED_PAGES_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_GET_DYNAMIC_OFFLINED_PAGES_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_GET_DYNAMIC_OFFLINED_PAGES_PARAMS._fields_ = [
    ('offlined', struct_NV2080_CTRL_FB_DYNAMIC_OFFLINED_ADDRESS_INFO * 64),
    ('validEntries', ctypes.c_uint32),
    ('baseIndex', ctypes.c_uint32),
    ('bMore', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 7),
]

NV2080_CTRL_FB_GET_DYNAMIC_OFFLINED_PAGES_PARAMS = struct_NV2080_CTRL_FB_GET_DYNAMIC_OFFLINED_PAGES_PARAMS
class struct_NV2080_CTRL_CMD_FB_ALLOCATION_INFO(Structure):
    pass

struct_NV2080_CTRL_CMD_FB_ALLOCATION_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_FB_ALLOCATION_INFO._fields_ = [
    ('client', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('beginAddr', ctypes.c_uint64),
    ('size', ctypes.c_uint64),
]

NV2080_CTRL_CMD_FB_ALLOCATION_INFO = struct_NV2080_CTRL_CMD_FB_ALLOCATION_INFO
class struct_NV2080_CTRL_CMD_FB_CLIENT_INFO(Structure):
    pass

struct_NV2080_CTRL_CMD_FB_CLIENT_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_FB_CLIENT_INFO._fields_ = [
    ('handle', ctypes.c_uint32),
    ('pid', ctypes.c_uint32),
    ('subProcessID', ctypes.c_uint32),
    ('subProcessName', ctypes.c_char * 100),
]

NV2080_CTRL_CMD_FB_CLIENT_INFO = struct_NV2080_CTRL_CMD_FB_CLIENT_INFO
class struct_NV2080_CTRL_CMD_FB_GET_CLIENT_ALLOCATION_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_FB_GET_CLIENT_ALLOCATION_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_FB_GET_CLIENT_ALLOCATION_INFO_PARAMS._fields_ = [
    ('allocCount', ctypes.c_uint64),
    ('pAllocInfo', ctypes.POINTER(None)),
    ('clientCount', ctypes.c_uint64),
    ('pClientInfo', ctypes.POINTER(None)),
]

NV2080_CTRL_CMD_FB_GET_CLIENT_ALLOCATION_INFO_PARAMS = struct_NV2080_CTRL_CMD_FB_GET_CLIENT_ALLOCATION_INFO_PARAMS
class struct_NV2080_CTRL_FB_UPDATE_NUMA_STATUS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_UPDATE_NUMA_STATUS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_UPDATE_NUMA_STATUS_PARAMS._fields_ = [
    ('bOnline', ctypes.c_ubyte),
]

NV2080_CTRL_FB_UPDATE_NUMA_STATUS_PARAMS = struct_NV2080_CTRL_FB_UPDATE_NUMA_STATUS_PARAMS
class struct_NV2080_CTRL_FB_GET_NUMA_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_GET_NUMA_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_GET_NUMA_INFO_PARAMS._fields_ = [
    ('numaNodeId', ctypes.c_int32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('numaMemAddr', ctypes.c_uint64),
    ('numaMemSize', ctypes.c_uint64),
    ('numaOfflineAddressesCount', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
    ('numaOfflineAddresses', ctypes.c_uint64 * 64),
]

NV2080_CTRL_FB_GET_NUMA_INFO_PARAMS = struct_NV2080_CTRL_FB_GET_NUMA_INFO_PARAMS
class struct_NV2080_CTRL_FB_GET_SEMAPHORE_SURFACE_LAYOUT_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FB_GET_SEMAPHORE_SURFACE_LAYOUT_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FB_GET_SEMAPHORE_SURFACE_LAYOUT_PARAMS._fields_ = [
    ('maxSubmittedSemaphoreValueOffset', ctypes.c_uint64),
    ('monitoredFenceThresholdOffset', ctypes.c_uint64),
    ('size', ctypes.c_uint64),
    ('caps', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NV2080_CTRL_FB_GET_SEMAPHORE_SURFACE_LAYOUT_PARAMS = struct_NV2080_CTRL_FB_GET_SEMAPHORE_SURFACE_LAYOUT_PARAMS
class struct_NV2080_CTRL_CMD_FB_STATS_ENTRY(Structure):
    pass

struct_NV2080_CTRL_CMD_FB_STATS_ENTRY._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_FB_STATS_ENTRY._fields_ = [
    ('totalSize', ctypes.c_uint64),
    ('rsvdSize', ctypes.c_uint64),
    ('osSize', ctypes.c_uint64),
    ('r1Size', ctypes.c_uint64),
    ('r2Size', ctypes.c_uint64),
    ('freeSize', ctypes.c_uint64),
]

NV2080_CTRL_CMD_FB_STATS_ENTRY = struct_NV2080_CTRL_CMD_FB_STATS_ENTRY
class struct_NV2080_CTRL_CMD_FB_STATS_OWNER_INFO(Structure):
    pass

struct_NV2080_CTRL_CMD_FB_STATS_OWNER_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_FB_STATS_OWNER_INFO._fields_ = [
    ('allocSize', ctypes.c_uint64),
    ('numBlocks', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('rsvdSize', ctypes.c_uint64),
]

NV2080_CTRL_CMD_FB_STATS_OWNER_INFO = struct_NV2080_CTRL_CMD_FB_STATS_OWNER_INFO
class struct_NV2080_CTRL_CMD_FB_STATS_GET_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_FB_STATS_GET_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_FB_STATS_GET_PARAMS._fields_ = [
    ('version', ctypes.c_uint64),
    ('fbSizeInfo', NV2080_CTRL_CMD_FB_STATS_ENTRY),
    ('fbBlockInfo', struct_NV2080_CTRL_CMD_FB_STATS_OWNER_INFO * 200),
]

NV2080_CTRL_CMD_FB_STATS_GET_PARAMS = struct_NV2080_CTRL_CMD_FB_STATS_GET_PARAMS
NV2080_CTRL_CMD_SET_GPFIFO = (0x20801102) # macro
NV2080_CTRL_CMD_SET_GPFIFO_PARAMS_MESSAGE_ID = (0x2) # macro
NV2080_CTRL_FIFO_BIND_ENGINES_MAX_CHANNELS = (16) # macro
NV2080_CTRL_FIFO_BIND_ENGINES_PARAMS_MESSAGE_ID = (0x3) # macro
NV2080_CTRL_CMD_FIFO_BIND_ENGINES = (0x20801103) # macro
NV2080_CTRL_CMD_SET_OPERATIONAL_PROPERTIES = (0x20801104) # macro
NV2080_CTRL_CMD_SET_OPERATIONAL_PROPERTIES_PARAMS_MESSAGE_ID = (0x4) # macro
NV2080_CTRL_CMD_SET_OPERATIONAL_PROPERTIES_FLAGS_ERROR_ON_STUCK_SEMAPHORE = ['0', ':', '0'] # macro
NV2080_CTRL_CMD_SET_OPERATIONAL_PROPERTIES_FLAGS_ERROR_ON_STUCK_SEMAPHORE_FALSE = (0x00000000) # macro
NV2080_CTRL_CMD_SET_OPERATIONAL_PROPERTIES_FLAGS_ERROR_ON_STUCK_SEMAPHORE_TRUE = (0x00000001) # macro
NV2080_CTRL_CMD_FIFO_GET_PHYSICAL_CHANNEL_COUNT = (0x20801108) # macro
NV2080_CTRL_FIFO_GET_PHYSICAL_CHANNEL_COUNT_PARAMS_MESSAGE_ID = (0x8) # macro
NV2080_CTRL_FIFO_INFO_INDEX_INSTANCE_TOTAL = (0x000000000) # macro
NV2080_CTRL_FIFO_INFO_INDEX_MAX_CHANNEL_GROUPS = (0x000000001) # macro
NV2080_CTRL_FIFO_INFO_INDEX_MAX_CHANNELS_PER_GROUP = (0x000000002) # macro
NV2080_CTRL_FIFO_INFO_INDEX_MAX_SUBCONTEXT_PER_GROUP = (0x000000003) # macro
NV2080_CTRL_FIFO_INFO_INDEX_BAR1_USERD_START_OFFSET = (0x000000004) # macro
NV2080_CTRL_FIFO_INFO_INDEX_DEFAULT_CHANNEL_TIMESLICE = (0x000000005) # macro
NV2080_CTRL_FIFO_INFO_INDEX_CHANNEL_GROUPS_IN_USE = (0x000000006) # macro
NV2080_CTRL_FIFO_INFO_INDEX_IS_PER_RUNLIST_CHANNEL_RAM_SUPPORTED = (0x000000007) # macro
NV2080_CTRL_FIFO_INFO_INDEX_MAX_CHANNEL_GROUPS_PER_ENGINE = (0x000000008) # macro
NV2080_CTRL_FIFO_INFO_INDEX_CHANNEL_GROUPS_IN_USE_PER_ENGINE = (0x000000009) # macro
NV2080_CTRL_FIFO_INFO_INDEX_MAX = (0x000000005) # macro
NV2080_CTRL_FIFO_GET_INFO_USERD_OFFSET_SHIFT = (12) # macro
NV2080_CTRL_CMD_FIFO_GET_INFO = (0x20801109) # macro
NV2080_CTRL_FIFO_GET_INFO_MAX_ENTRIES = (256) # macro
NV2080_CTRL_FIFO_GET_INFO_PARAMS_MESSAGE_ID = (0x9) # macro
NV2080_CTRL_CMD_FIFO_CHANNEL_PREEMPTIVE_REMOVAL = (0x2080110a) # macro
NV2080_CTRL_FIFO_CHANNEL_PREEMPTIVE_REMOVAL_PARAMS_MESSAGE_ID = (0xA) # macro
NV2080_CTRL_CMD_FIFO_DISABLE_CHANNELS = (0x2080110b) # macro
NV2080_CTRL_FIFO_DISABLE_CHANNELS_MAX_ENTRIES = (64) # macro
NV2080_CTRL_FIFO_DISABLE_CHANNELS_PARAMS_MESSAGE_ID = (0xB) # macro
NV2080_CTRL_FIFO_DISABLE_CHANNEL_FALSE = (0x00000000) # macro
NV2080_CTRL_FIFO_DISABLE_CHANNEL_TRUE = (0x00000001) # macro
NV2080_CTRL_FIFO_ONLY_DISABLE_SCHEDULING_FALSE = (0x00000000) # macro
NV2080_CTRL_FIFO_ONLY_DISABLE_SCHEDULING_TRUE = (0x00000001) # macro
NV2080_CTRL_FIFO_GET_CHANNEL_MEM_INFO_MAX_COUNT = 0x2 # macro
NV2080_CTRL_CMD_FIFO_GET_CHANNEL_MEM_INFO = (0x2080110c) # macro
NV2080_CTRL_CMD_FIFO_GET_CHANNEL_MEM_INFO_PARAMS_MESSAGE_ID = (0xC) # macro
NV2080_CTRL_CMD_FIFO_GET_CHANNEL_MEM_APERTURE_INVALID = 0x00000000 # macro
NV2080_CTRL_CMD_FIFO_GET_CHANNEL_MEM_APERTURE_VIDMEM = 0x00000001 # macro
NV2080_CTRL_CMD_FIFO_GET_CHANNEL_MEM_APERTURE_SYSMEM_COH = 0x00000002 # macro
NV2080_CTRL_CMD_FIFO_GET_CHANNEL_MEM_APERTURE_SYSMEM_NCOH = 0x00000003 # macro
NV2080_CTRL_CMD_FIFO_GET_USERD_LOCATION = (0x2080110d) # macro
NV2080_CTRL_CMD_FIFO_GET_USERD_LOCATION_PARAMS_MESSAGE_ID = (0xD) # macro
NV2080_CTRL_CMD_FIFO_GET_USERD_LOCATION_APERTURE_VIDMEM = 0x00000000 # macro
NV2080_CTRL_CMD_FIFO_GET_USERD_LOCATION_APERTURE_SYSMEM = 0x00000001 # macro
NV2080_CTRL_CMD_FIFO_GET_USERD_LOCATION_ATTRIBUTE_CACHED = 0x00000000 # macro
NV2080_CTRL_CMD_FIFO_GET_USERD_LOCATION_ATTRIBUTE_UNCACHED = 0X00000001 # macro
NV2080_CTRL_CMD_FIFO_GET_USERD_LOCATION_ATTRIBUTE_WRITECOMBINED = 0X00000002 # macro
NV2080_CTRL_CMD_VGPU_SCHEDULER_POLICY_UNKNOWN = 0 # macro
NV2080_CTRL_CMD_VGPU_SCHEDULER_POLICY_OTHER = 1 # macro
NV2080_CTRL_CMD_VGPU_SCHEDULER_POLICY_BEST_EFFORT = 2 # macro
NV2080_CTRL_CMD_VGPU_SCHEDULER_POLICY_EQUAL_SHARE = 3 # macro
NV2080_CTRL_CMD_VGPU_SCHEDULER_POLICY_FIXED_SHARE = 4 # macro
NV2080_CTRL_CMD_SUPPORTED_VGPU_SCHEDULER_POLICY_COUNT = 3 # macro
NV2080_CTRL_CMD_VGPU_SCHEDULER_ARR_DEFAULT = 0 # macro
NV2080_CTRL_CMD_VGPU_SCHEDULER_ARR_DISABLE = 1 # macro
NV2080_CTRL_CMD_VGPU_SCHEDULER_ARR_ENABLE = 2 # macro
NV2080_CTRL_CMD_FIFO_OBJSCHED_SW_GET_LOG = (0x2080110e) # macro
NV2080_CTRL_FIFO_OBJSCHED_SW_COUNT = 32 # macro
NV2080_CTRL_FIFO_OBJSCHED_SW_NCOUNTERS = 8 # macro
NV2080_CTRL_FIFO_OBJSCHED_SW_GET_LOG_ENTRIES = 200 # macro
NV2080_CTRL_FIFO_OBJSCHED_SW_GET_LOG_PARAMS_MESSAGE_ID = (0xE) # macro
NV2080_CTRL_CMD_FIFO_GET_DEVICE_INFO_TABLE = (0x20801112) # macro
NV2080_CTRL_FIFO_GET_DEVICE_INFO_TABLE_MAX_DEVICES = 256 # macro
NV2080_CTRL_FIFO_GET_DEVICE_INFO_TABLE_MAX_ENTRIES = 32 # macro
NV2080_CTRL_FIFO_GET_DEVICE_INFO_TABLE_ENGINE_DATA_TYPES = 16 # macro
NV2080_CTRL_FIFO_GET_DEVICE_INFO_TABLE_ENGINE_MAX_PBDMA = 2 # macro
NV2080_CTRL_FIFO_GET_DEVICE_INFO_TABLE_ENGINE_MAX_NAME_LEN = 16 # macro
NV2080_CTRL_FIFO_GET_DEVICE_INFO_TABLE_PARAMS_MESSAGE_ID = (0x12) # macro
NV2080_CTRL_CMD_FIFO_CLEAR_FAULTED_BIT = (0x20801113) # macro
NV2080_CTRL_FIFO_CLEAR_FAULTED_BIT_FAULT_TYPE_ENGINE = 0x00000001 # macro
NV2080_CTRL_FIFO_CLEAR_FAULTED_BIT_FAULT_TYPE_PBDMA = 0x00000002 # macro
NV2080_CTRL_CMD_FIFO_CLEAR_FAULTED_BIT_PARAMS_MESSAGE_ID = (0x13) # macro
NV2080_CTRL_CMD_FIFO_RUNLIST_SET_SCHED_POLICY = (0x20801115) # macro
NV2080_CTRL_FIFO_RUNLIST_SCHED_POLICY_DEFAULT = 0x0 # macro
NV2080_CTRL_FIFO_RUNLIST_SCHED_POLICY_CHANNEL_INTERLEAVED = 0x1 # macro
NV2080_CTRL_FIFO_RUNLIST_SCHED_POLICY_CHANNEL_INTERLEAVED_WDDM = 0x2 # macro
NV2080_CTRL_CMD_FIFO_RUNLIST_SET_SCHED_POLICY_FLAGS_RESTORE = ['0', ':', '0'] # macro
NV2080_CTRL_CMD_FIFO_RUNLIST_SET_SCHED_POLICY_FLAGS_RESTORE_FALSE = (0x00000000) # macro
NV2080_CTRL_CMD_FIFO_RUNLIST_SET_SCHED_POLICY_FLAGS_RESTORE_TRUE = (0x00000001) # macro
NV2080_CTRL_FIFO_RUNLIST_SET_SCHED_POLICY_PARAMS_MESSAGE_ID = (0x15) # macro
NV2080_CTRL_CMD_FIFO_UPDATE_CHANNEL_INFO = (0x20801116) # macro
NV2080_CTRL_FIFO_UPDATE_CHANNEL_INFO_PARAMS_MESSAGE_ID = (0x16) # macro
NV2080_CTRL_CMD_FIFO_DISABLE_USERMODE_CHANNELS = (0x20801117) # macro
NV2080_CTRL_FIFO_DISABLE_USERMODE_CHANNELS_PARAMS_MESSAGE_ID = (0x17) # macro
NV2080_CTRL_CMD_FIFO_SETUP_VF_ZOMBIE_SUBCTX_PDB = (0x20801118) # macro
NV2080_CTRL_FIFO_SETUP_VF_ZOMBIE_SUBCTX_PDB_PARAMS_MESSAGE_ID = (0x18) # macro
NV2080_CTRL_CMD_FIFO_GET_ALLOCATED_CHANNELS = (0x20801119) # macro
NV2080_CTRL_FIFO_GET_ALLOCATED_CHANNELS_MAX_CHANNELS = 4096 # macro
NV2080_CTRL_FIFO_GET_ALLOCATED_CHANNELS_PARAMS_MESSAGE_ID = (0x19) # macro
NV2080_CTRL_CMD_FIFO_DISABLE_CHANNELS_FOR_KEY_ROTATION = (0x2080111a) # macro
NV2080_CTRL_FIFO_DISABLE_CHANNELS_FOR_KEY_ROTATION_MAX_ENTRIES = (64) # macro
NV2080_CTRL_FIFO_DISABLE_CHANNELS_FOR_KEY_ROTATION_PARAMS_MESSAGE_ID = (0x1A) # macro
NV2080_CTRL_CMD_FIFO_OBJSCHED_GET_STATE = (0x20801120) # macro
NV2080_CTRL_FIFO_OBJSCHED_GET_STATE_PARAMS_MESSAGE_ID = (0x20) # macro
NV2080_CTRL_CMD_FIFO_OBJSCHED_SET_STATE = (0x20801121) # macro
NV2080_CTRL_FIFO_OBJSCHED_SET_STATE_PARAMS_MESSAGE_ID = (0x21) # macro
NV2080_CTRL_CMD_FIFO_OBJSCHED_GET_CAPS = (0x20801122) # macro
NV2080_CTRL_FIFO_OBJSCHED_GET_CAPS_PARAMS_MESSAGE_ID = (0x22) # macro
class struct_NV2080_CTRL_CMD_SET_GPFIFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_SET_GPFIFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_SET_GPFIFO_PARAMS._fields_ = [
    ('hChannel', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('base', ctypes.c_uint64),
    ('numEntries', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

NV2080_CTRL_CMD_SET_GPFIFO_PARAMS = struct_NV2080_CTRL_CMD_SET_GPFIFO_PARAMS
class struct_NV2080_CTRL_FIFO_BIND_CHANNEL(Structure):
    pass

struct_NV2080_CTRL_FIFO_BIND_CHANNEL._pack_ = 1 # source:False
struct_NV2080_CTRL_FIFO_BIND_CHANNEL._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hChannel', ctypes.c_uint32),
]

NV2080_CTRL_FIFO_BIND_CHANNEL = struct_NV2080_CTRL_FIFO_BIND_CHANNEL
class struct_NV2080_CTRL_FIFO_BIND_ENGINES_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FIFO_BIND_ENGINES_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FIFO_BIND_ENGINES_PARAMS._fields_ = [
    ('bindChannelCount', ctypes.c_uint32),
    ('bindChannels', struct_NV2080_CTRL_FIFO_BIND_CHANNEL * 16),
]

NV2080_CTRL_FIFO_BIND_ENGINES_PARAMS = struct_NV2080_CTRL_FIFO_BIND_ENGINES_PARAMS
class struct_NV2080_CTRL_CMD_SET_OPERATIONAL_PROPERTIES_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_SET_OPERATIONAL_PROPERTIES_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_SET_OPERATIONAL_PROPERTIES_PARAMS._fields_ = [
    ('flags', ctypes.c_uint32),
]

NV2080_CTRL_CMD_SET_OPERATIONAL_PROPERTIES_PARAMS = struct_NV2080_CTRL_CMD_SET_OPERATIONAL_PROPERTIES_PARAMS
class struct_NV2080_CTRL_FIFO_GET_PHYSICAL_CHANNEL_COUNT_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FIFO_GET_PHYSICAL_CHANNEL_COUNT_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FIFO_GET_PHYSICAL_CHANNEL_COUNT_PARAMS._fields_ = [
    ('physChannelCount', ctypes.c_uint32),
    ('physChannelCountInUse', ctypes.c_uint32),
]

NV2080_CTRL_FIFO_GET_PHYSICAL_CHANNEL_COUNT_PARAMS = struct_NV2080_CTRL_FIFO_GET_PHYSICAL_CHANNEL_COUNT_PARAMS
NV2080_CTRL_FIFO_INFO = struct_NVXXXX_CTRL_XXX_INFO
class struct_NV2080_CTRL_FIFO_GET_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FIFO_GET_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FIFO_GET_INFO_PARAMS._fields_ = [
    ('fifoInfoTblSize', ctypes.c_uint32),
    ('fifoInfoTbl', struct_NVXXXX_CTRL_XXX_INFO * 256),
    ('engineType', ctypes.c_uint32),
]

NV2080_CTRL_FIFO_GET_INFO_PARAMS = struct_NV2080_CTRL_FIFO_GET_INFO_PARAMS
class struct_NV2080_CTRL_FIFO_CHANNEL_PREEMPTIVE_REMOVAL_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FIFO_CHANNEL_PREEMPTIVE_REMOVAL_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FIFO_CHANNEL_PREEMPTIVE_REMOVAL_PARAMS._fields_ = [
    ('hChannel', ctypes.c_uint32),
]

NV2080_CTRL_FIFO_CHANNEL_PREEMPTIVE_REMOVAL_PARAMS = struct_NV2080_CTRL_FIFO_CHANNEL_PREEMPTIVE_REMOVAL_PARAMS
class struct_NV2080_CTRL_FIFO_DISABLE_CHANNELS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FIFO_DISABLE_CHANNELS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FIFO_DISABLE_CHANNELS_PARAMS._fields_ = [
    ('bDisable', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('numChannels', ctypes.c_uint32),
    ('bOnlyDisableScheduling', ctypes.c_ubyte),
    ('bRewindGpPut', ctypes.c_ubyte),
    ('PADDING_1', ctypes.c_ubyte * 6),
    ('pRunlistPreemptEvent', ctypes.POINTER(None)),
    ('hClientList', ctypes.c_uint32 * 64),
    ('hChannelList', ctypes.c_uint32 * 64),
]

NV2080_CTRL_FIFO_DISABLE_CHANNELS_PARAMS = struct_NV2080_CTRL_FIFO_DISABLE_CHANNELS_PARAMS
class struct_NV2080_CTRL_FIFO_MEM_INFO(Structure):
    pass

struct_NV2080_CTRL_FIFO_MEM_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_FIFO_MEM_INFO._fields_ = [
    ('aperture', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('base', ctypes.c_uint64),
    ('size', ctypes.c_uint64),
]

NV2080_CTRL_FIFO_MEM_INFO = struct_NV2080_CTRL_FIFO_MEM_INFO
class struct_NV2080_CTRL_FIFO_CHANNEL_MEM_INFO(Structure):
    pass

struct_NV2080_CTRL_FIFO_CHANNEL_MEM_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_FIFO_CHANNEL_MEM_INFO._fields_ = [
    ('inst', NV2080_CTRL_FIFO_MEM_INFO),
    ('ramfc', NV2080_CTRL_FIFO_MEM_INFO),
    ('methodBuf', struct_NV2080_CTRL_FIFO_MEM_INFO * 2),
    ('methodBufCount', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NV2080_CTRL_FIFO_CHANNEL_MEM_INFO = struct_NV2080_CTRL_FIFO_CHANNEL_MEM_INFO
class struct_NV2080_CTRL_CMD_FIFO_GET_CHANNEL_MEM_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_FIFO_GET_CHANNEL_MEM_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_FIFO_GET_CHANNEL_MEM_INFO_PARAMS._fields_ = [
    ('hChannel', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('chMemInfo', NV2080_CTRL_FIFO_CHANNEL_MEM_INFO),
]

NV2080_CTRL_CMD_FIFO_GET_CHANNEL_MEM_INFO_PARAMS = struct_NV2080_CTRL_CMD_FIFO_GET_CHANNEL_MEM_INFO_PARAMS
class struct_NV2080_CTRL_CMD_FIFO_GET_USERD_LOCATION_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_FIFO_GET_USERD_LOCATION_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_FIFO_GET_USERD_LOCATION_PARAMS._fields_ = [
    ('aperture', ctypes.c_uint32),
    ('attribute', ctypes.c_uint32),
]

NV2080_CTRL_CMD_FIFO_GET_USERD_LOCATION_PARAMS = struct_NV2080_CTRL_CMD_FIFO_GET_USERD_LOCATION_PARAMS
class struct_NV2080_CTRL_FIFO_OBJSCHED_SW_GET_LOG_PARAMS(Structure):
    pass

class struct_NV2080_CTRL_FIFO_OBJSCHED_SW_GET_LOG_PARAMS_0(Structure):
    pass

struct_NV2080_CTRL_FIFO_OBJSCHED_SW_GET_LOG_PARAMS_0._pack_ = 1 # source:False
struct_NV2080_CTRL_FIFO_OBJSCHED_SW_GET_LOG_PARAMS_0._fields_ = [
    ('timestampNs', ctypes.c_uint64),
    ('timeRunTotalNs', ctypes.c_int64),
    ('timeRunNs', ctypes.c_uint32),
    ('swrlId', ctypes.c_uint32),
    ('targetTimeSlice', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('cumulativePreemptionTime', ctypes.c_uint64),
    ('counters', ctypes.c_uint64 * 8),
]

struct_NV2080_CTRL_FIFO_OBJSCHED_SW_GET_LOG_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FIFO_OBJSCHED_SW_GET_LOG_PARAMS._fields_ = [
    ('engineId', ctypes.c_uint32),
    ('count', ctypes.c_uint32),
    ('entry', struct_NV2080_CTRL_FIFO_OBJSCHED_SW_GET_LOG_PARAMS_0 * 200),
    ('schedPolicy', ctypes.c_uint32),
    ('arrEnabled', ctypes.c_uint32),
    ('arrAvgFactor', ctypes.c_uint32),
    ('targetTimesliceNs', ctypes.c_uint32),
]

NV2080_CTRL_FIFO_OBJSCHED_SW_GET_LOG_PARAMS = struct_NV2080_CTRL_FIFO_OBJSCHED_SW_GET_LOG_PARAMS
class struct_NV2080_CTRL_FIFO_DEVICE_ENTRY(Structure):
    pass

struct_NV2080_CTRL_FIFO_DEVICE_ENTRY._pack_ = 1 # source:False
struct_NV2080_CTRL_FIFO_DEVICE_ENTRY._fields_ = [
    ('engineData', ctypes.c_uint32 * 16),
    ('pbdmaIds', ctypes.c_uint32 * 2),
    ('pbdmaFaultIds', ctypes.c_uint32 * 2),
    ('numPbdmas', ctypes.c_uint32),
    ('engineName', ctypes.c_char * 16),
]

NV2080_CTRL_FIFO_DEVICE_ENTRY = struct_NV2080_CTRL_FIFO_DEVICE_ENTRY
class struct_NV2080_CTRL_FIFO_GET_DEVICE_INFO_TABLE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FIFO_GET_DEVICE_INFO_TABLE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FIFO_GET_DEVICE_INFO_TABLE_PARAMS._fields_ = [
    ('baseIndex', ctypes.c_uint32),
    ('numEntries', ctypes.c_uint32),
    ('bMore', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('entries', struct_NV2080_CTRL_FIFO_DEVICE_ENTRY * 32),
]

NV2080_CTRL_FIFO_GET_DEVICE_INFO_TABLE_PARAMS = struct_NV2080_CTRL_FIFO_GET_DEVICE_INFO_TABLE_PARAMS
class struct_NV2080_CTRL_CMD_FIFO_CLEAR_FAULTED_BIT_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_FIFO_CLEAR_FAULTED_BIT_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_FIFO_CLEAR_FAULTED_BIT_PARAMS._fields_ = [
    ('engineType', ctypes.c_uint32),
    ('vChid', ctypes.c_uint32),
    ('faultType', ctypes.c_uint32),
]

NV2080_CTRL_CMD_FIFO_CLEAR_FAULTED_BIT_PARAMS = struct_NV2080_CTRL_CMD_FIFO_CLEAR_FAULTED_BIT_PARAMS
class struct_NV2080_CTRL_FIFO_RUNLIST_SET_SCHED_POLICY_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FIFO_RUNLIST_SET_SCHED_POLICY_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FIFO_RUNLIST_SET_SCHED_POLICY_PARAMS._fields_ = [
    ('flags', ctypes.c_uint32),
    ('schedPolicy', ctypes.c_uint32),
]

NV2080_CTRL_FIFO_RUNLIST_SET_SCHED_POLICY_PARAMS = struct_NV2080_CTRL_FIFO_RUNLIST_SET_SCHED_POLICY_PARAMS
class struct_NV2080_CTRL_FIFO_UPDATE_CHANNEL_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FIFO_UPDATE_CHANNEL_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FIFO_UPDATE_CHANNEL_INFO_PARAMS._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hChannel', ctypes.c_uint32),
    ('hUserdMemory', ctypes.c_uint32),
    ('gpFifoEntries', ctypes.c_uint32),
    ('gpFifoOffset', ctypes.c_uint64),
    ('userdOffset', ctypes.c_uint64),
]

NV2080_CTRL_FIFO_UPDATE_CHANNEL_INFO_PARAMS = struct_NV2080_CTRL_FIFO_UPDATE_CHANNEL_INFO_PARAMS
class struct_NV2080_CTRL_FIFO_DISABLE_USERMODE_CHANNELS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FIFO_DISABLE_USERMODE_CHANNELS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FIFO_DISABLE_USERMODE_CHANNELS_PARAMS._fields_ = [
    ('bDisable', ctypes.c_ubyte),
]

NV2080_CTRL_FIFO_DISABLE_USERMODE_CHANNELS_PARAMS = struct_NV2080_CTRL_FIFO_DISABLE_USERMODE_CHANNELS_PARAMS
class struct_NV2080_CTRL_FIFO_SETUP_VF_ZOMBIE_SUBCTX_PDB_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FIFO_SETUP_VF_ZOMBIE_SUBCTX_PDB_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FIFO_SETUP_VF_ZOMBIE_SUBCTX_PDB_PARAMS._fields_ = [
    ('base', ctypes.c_uint64),
    ('size', ctypes.c_uint64),
    ('addressSpace', ctypes.c_uint32),
    ('cacheAttrib', ctypes.c_uint32),
]

NV2080_CTRL_FIFO_SETUP_VF_ZOMBIE_SUBCTX_PDB_PARAMS = struct_NV2080_CTRL_FIFO_SETUP_VF_ZOMBIE_SUBCTX_PDB_PARAMS
class struct_NV2080_CTRL_FIFO_GET_ALLOCATED_CHANNELS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FIFO_GET_ALLOCATED_CHANNELS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FIFO_GET_ALLOCATED_CHANNELS_PARAMS._fields_ = [
    ('runlistId', ctypes.c_uint32),
    ('bitMask', ctypes.c_uint32 * 128),
]

NV2080_CTRL_FIFO_GET_ALLOCATED_CHANNELS_PARAMS = struct_NV2080_CTRL_FIFO_GET_ALLOCATED_CHANNELS_PARAMS
class struct_NV2080_CTRL_FIFO_DISABLE_CHANNELS_FOR_KEY_ROTATION_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FIFO_DISABLE_CHANNELS_FOR_KEY_ROTATION_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FIFO_DISABLE_CHANNELS_FOR_KEY_ROTATION_PARAMS._fields_ = [
    ('numChannels', ctypes.c_uint32),
    ('hClientList', ctypes.c_uint32 * 64),
    ('hChannelList', ctypes.c_uint32 * 64),
    ('bEnableAfterKeyRotation', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_FIFO_DISABLE_CHANNELS_FOR_KEY_ROTATION_PARAMS = struct_NV2080_CTRL_FIFO_DISABLE_CHANNELS_FOR_KEY_ROTATION_PARAMS
class struct_NV2080_CTRL_FIFO_OBJSCHED_GET_STATE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FIFO_OBJSCHED_GET_STATE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FIFO_OBJSCHED_GET_STATE_PARAMS._fields_ = [
    ('engineId', ctypes.c_uint32),
    ('schedPolicy', ctypes.c_uint32),
    ('arrEnabled', ctypes.c_uint32),
    ('targetTimesliceNs', ctypes.c_uint32),
    ('arrAvgFactor', ctypes.c_uint32),
]

NV2080_CTRL_FIFO_OBJSCHED_GET_STATE_PARAMS = struct_NV2080_CTRL_FIFO_OBJSCHED_GET_STATE_PARAMS
class struct_NV2080_CTRL_FIFO_OBJSCHED_SET_STATE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FIFO_OBJSCHED_SET_STATE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FIFO_OBJSCHED_SET_STATE_PARAMS._fields_ = [
    ('engineId', ctypes.c_uint32),
    ('schedPolicy', ctypes.c_uint32),
    ('enableArr', ctypes.c_uint32),
    ('timesliceTargetNs', ctypes.c_uint32),
    ('frequencyForARR', ctypes.c_uint32),
    ('avgFactorForARR', ctypes.c_uint32),
]

NV2080_CTRL_FIFO_OBJSCHED_SET_STATE_PARAMS = struct_NV2080_CTRL_FIFO_OBJSCHED_SET_STATE_PARAMS
class struct_NV2080_CTRL_FIFO_OBJSCHED_GET_CAPS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FIFO_OBJSCHED_GET_CAPS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FIFO_OBJSCHED_GET_CAPS_PARAMS._fields_ = [
    ('engineId', ctypes.c_uint32),
    ('supportedSchedulers', ctypes.c_uint32 * 3),
    ('bIsArrModeSupported', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('maxTimesliceNs', ctypes.c_uint32),
    ('minTimesliceNs', ctypes.c_uint32),
    ('maxFrequencyForARR', ctypes.c_uint32),
    ('minFrequencyForARR', ctypes.c_uint32),
    ('maxAvgFactorForARR', ctypes.c_uint32),
    ('minAvgFactorForARR', ctypes.c_uint32),
]

NV2080_CTRL_FIFO_OBJSCHED_GET_CAPS_PARAMS = struct_NV2080_CTRL_FIFO_OBJSCHED_GET_CAPS_PARAMS
NV2080_CTRL_CMD_FLA_RANGE = (0x20803501) # macro
NV2080_CTRL_FLA_RANGE_PARAMS_MESSAGE_ID = (0x1) # macro
NV2080_CTRL_FLA_RANGE_PARAMS_MODE_NONE = 0x00000000 # macro
NV2080_CTRL_FLA_RANGE_PARAMS_MODE_INITIALIZE  = (1 << 0) # macro
NV2080_CTRL_FLA_RANGE_PARAMS_MODE_DESTROY  = (1 << 1) # macro
NV2080_CTRL_FLA_RANGE_PARAMS_MODE_HOST_MANAGED_VAS_INITIALIZE  = (1 << 2) # macro
NV2080_CTRL_FLA_RANGE_PARAMS_MODE_HOST_MANAGED_VAS_DESTROY  = (1 << 3) # macro
NV2080_CTRL_CMD_FLA_SETUP_INSTANCE_MEM_BLOCK = (0x20803502) # macro
NV2080_CTRL_FLA_SETUP_INSTANCE_MEM_BLOCK_PARAMS_MESSAGE_ID = (0x2) # macro
NV2080_CTRL_CMD_FLA_GET_RANGE = (0x20803503) # macro
NV2080_CTRL_FLA_GET_RANGE_PARAMS_MESSAGE_ID = (0x3) # macro
NV2080_CTRL_CMD_FLA_GET_FABRIC_MEM_STATS = (0x20803504) # macro
NV2080_CTRL_FLA_GET_FABRIC_MEM_STATS_PARAMS_MESSAGE_ID = (0x4) # macro
class struct_NV2080_CTRL_FLA_RANGE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FLA_RANGE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FLA_RANGE_PARAMS._fields_ = [
    ('base', ctypes.c_uint64),
    ('size', ctypes.c_uint64),
    ('mode', ctypes.c_uint32),
    ('hVASpace', ctypes.c_uint32),
]

NV2080_CTRL_FLA_RANGE_PARAMS = struct_NV2080_CTRL_FLA_RANGE_PARAMS

# values for enumeration 'NV2080_CTRL_FLA_ADDRSPACE'
NV2080_CTRL_FLA_ADDRSPACE__enumvalues = {
    0: 'NV2080_CTRL_FLA_ADDRSPACE_SYSMEM',
    1: 'NV2080_CTRL_FLA_ADDRSPACE_FBMEM',
}
NV2080_CTRL_FLA_ADDRSPACE_SYSMEM = 0
NV2080_CTRL_FLA_ADDRSPACE_FBMEM = 1
NV2080_CTRL_FLA_ADDRSPACE = ctypes.c_uint32 # enum

# values for enumeration 'NV2080_CTRL_FLA_ACTION'
NV2080_CTRL_FLA_ACTION__enumvalues = {
    0: 'NV2080_CTRL_FLA_ACTION_BIND',
    1: 'NV2080_CTRL_FLA_ACTION_UNBIND',
}
NV2080_CTRL_FLA_ACTION_BIND = 0
NV2080_CTRL_FLA_ACTION_UNBIND = 1
NV2080_CTRL_FLA_ACTION = ctypes.c_uint32 # enum
class struct_NV2080_CTRL_FLA_SETUP_INSTANCE_MEM_BLOCK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FLA_SETUP_INSTANCE_MEM_BLOCK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FLA_SETUP_INSTANCE_MEM_BLOCK_PARAMS._fields_ = [
    ('imbPhysAddr', ctypes.c_uint64),
    ('addrSpace', NV2080_CTRL_FLA_ADDRSPACE),
    ('flaAction', NV2080_CTRL_FLA_ACTION),
]

NV2080_CTRL_FLA_SETUP_INSTANCE_MEM_BLOCK_PARAMS = struct_NV2080_CTRL_FLA_SETUP_INSTANCE_MEM_BLOCK_PARAMS
class struct_NV2080_CTRL_FLA_GET_RANGE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FLA_GET_RANGE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FLA_GET_RANGE_PARAMS._fields_ = [
    ('base', ctypes.c_uint64),
    ('size', ctypes.c_uint64),
]

NV2080_CTRL_FLA_GET_RANGE_PARAMS = struct_NV2080_CTRL_FLA_GET_RANGE_PARAMS
class struct_NV2080_CTRL_FLA_GET_FABRIC_MEM_STATS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FLA_GET_FABRIC_MEM_STATS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FLA_GET_FABRIC_MEM_STATS_PARAMS._fields_ = [
    ('totalSize', ctypes.c_uint64),
    ('freeSize', ctypes.c_uint64),
]

NV2080_CTRL_FLA_GET_FABRIC_MEM_STATS_PARAMS = struct_NV2080_CTRL_FLA_GET_FABRIC_MEM_STATS_PARAMS
FALCON_ID_PMU = ((0x00000029)) # macro
FALCON_ID_DPU = ((0x00000028)) # macro
FALCON_ID_SEC2 = ((0x00000026)) # macro
FALCON_ID_FBFLCN = ((0x0000002a)) # macro
NV2080_CTRL_CMD_FLCN_GET_DMEM_USAGE = (0x20803101) # macro
NV2080_CTRL_FLCN_GET_DMEM_USAGE_PARAMS_MESSAGE_ID = (0x1) # macro
NV2080_CTRL_FLCN_NVOS_INST_EVT_RSVD_DO_NOT_USE = 0x00 # macro
NV2080_CTRL_FLCN_NVOS_INST_EVT_CTXSW_END = 0x01 # macro
NV2080_CTRL_FLCN_NVOS_INST_EVT_HW_IRQ_BEGIN = 0x02 # macro
NV2080_CTRL_FLCN_NVOS_INST_EVT_HW_IRQ_END = 0x03 # macro
NV2080_CTRL_FLCN_NVOS_INST_EVT_TIMER_TICK = 0x04 # macro
NV2080_CTRL_FLCN_NVOS_INST_EVT_TASK_EVENT_BEGIN = 0x05 # macro
NV2080_CTRL_FLCN_NVOS_INST_EVT_TASK_EVENT_END = 0x06 # macro
NV2080_CTRL_FLCN_NVOS_INST_EVT_RM_QUEUE_LATENCY = 0x07 # macro
NV2080_CTRL_FLCN_NVOS_INST_EVT_TASK_SPECIAL_EVENT = 0x08 # macro
NV2080_CTRL_FLCN_NVOS_INST_EVT_UNUSED_0 = 0x09 # macro
NV2080_CTRL_FLCN_NVOS_INST_EVT_DMA_END = 0x0A # macro
NV2080_CTRL_FLCN_NVOS_INST_EVT_GENERIC_BEGIN = 0x0B # macro
NV2080_CTRL_FLCN_NVOS_INST_EVT_GENERIC_END = 0x0C # macro
NV2080_CTRL_FLCN_NVOS_INST_EVT_TASK_EVENT_LATENCY = 0x0D # macro
NV2080_CTRL_FLCN_NVOS_INST_INVALID_TASK_ID = 0xFF # macro
NV2080_CTRL_CMD_FLCN_GET_ENGINE_ARCH = (0x20803118) # macro
NV2080_CTRL_FLCN_GET_ENGINE_ARCH_PARAMS_MESSAGE_ID = (0x18) # macro
NV2080_CTRL_FLCN_GET_ENGINE_ARCH_DEFAULT = 0x0 # macro
NV2080_CTRL_FLCN_GET_ENGINE_ARCH_FALCON = 0x1 # macro
NV2080_CTRL_FLCN_GET_ENGINE_ARCH_RISCV = 0x2 # macro
NV2080_CTRL_FLCN_GET_ENGINE_ARCH_RISCV_EB = 0x3 # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_COMM_FLAG = ['31', ':', '31'] # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_COMM_HEAD = ['30', ':', '30'] # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_VARIABLE = ['29', ':', '29'] # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_EXTEND = ['28', ':', '28'] # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_EVENTID_DRF_EXTENT = (27) # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_EVENTID_DRF_BASE = (20) # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_EVENTID = ((27)) # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_EVENTIDCOMPACT_DRF_EXTENT = (28) # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_EVENTIDCOMPACT_DRF_BASE = (24) # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_EVENTIDCOMPACT = ((28)) # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_LENGTH = ['19', ':', '8'] # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOAD = ['7', ':', '0'] # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT = ['23', ':', '0'] # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_HEAD_TIME = ['29', ':', '0'] # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_DATA_PAYLOAD = ['30', ':', '0'] # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_CTXSW_END_TASK_ID = ['7', ':', '0'] # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_CTXSW_END_REASON = ['10', ':', '8'] # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_CTXSW_END_REASON_YIELD = 0x0 # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_CTXSW_END_REASON_INT0 = 0x1 # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_CTXSW_END_REASON_TIMER_TICK = 0x2 # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_CTXSW_END_REASON_QUEUE_BLOCK = 0x3 # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_CTXSW_END_REASON_DMA_SUSPENDED = 0x4 # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_CTXSW_END_ODP_MISS_COUNT = ['23', ':', '11'] # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_TIMER_TICK_TIME_SLIP = ['23', ':', '0'] # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_TASK_EVENT_BEGIN_TASK_ID = ['7', ':', '0'] # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_TASK_EVENT_BEGIN_UNIT_ID = ['15', ':', '8'] # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_TASK_EVENT_BEGIN_EVENT_TYPE = ['23', ':', '16'] # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_TASK_EVENT_END_TASK_ID = ['7', ':', '0'] # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_TASK_EVENT_END_CALLBACK_ID = ['15', ':', '8'] # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_TASK_EVENT_END_RPC_FUNC = ['15', ':', '8'] # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_TASK_EVENT_END_RPC_FUNC_BOBJ_CMD_BASE = 0xF0 # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_TASK_EVENT_END_CLASS_ID = ['23', ':', '16'] # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_RM_QUEUE_LATENCY_SHIFT = 10 # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_TASK_SPECIAL_EVENT_TASK_ID = ['7', ':', '0'] # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_TASK_SPECIAL_EVENT_ID = ['23', ':', '8'] # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_TASK_SPECIAL_EVENT_ID_RESERVED = 0x000000 # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_TASK_SPECIAL_EVENT_ID_CB_ENQUEUE_FAIL = 0x000001 # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_TASK_EVENT_LATENCY_SHIFT = 6 # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_GENERIC_ID = ['11', ':', '0'] # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_GENERIC_ID_INVALID = 0x000 # macro
NV2080_CTRL_FLCN_USTREAMER_EVENT_TAIL_PAYLOADCOMPACT_GENERIC_ID_VF_SWITCH_TOTAL = 0x001 # macro
NV2080_CTRL_FLCN_USTREAMER_FEATURE_DEFAULT = 0 # macro
NV2080_CTRL_FLCN_USTREAMER_FEATURE_PMUMON = 1 # macro
NV2080_CTRL_FLCN_USTREAMER_FEATURE__COUNT = 2 # macro
NV2080_CTRL_FLCN_USTREAMER_QUEUE_POLICY_IDLE_FLUSH = ['0', ':', '0'] # macro
NV2080_CTRL_FLCN_USTREAMER_QUEUE_POLICY_IDLE_FLUSH_DISABLED = 0 # macro
NV2080_CTRL_FLCN_USTREAMER_QUEUE_POLICY_IDLE_FLUSH_ENABLED = 1 # macro
NV2080_CTRL_FLCN_USTREAMER_QUEUE_POLICY_FULL_FLUSH = ['1', ':', '1'] # macro
NV2080_CTRL_FLCN_USTREAMER_QUEUE_POLICY_FULL_FLUSH_DISABLED = 0 # macro
NV2080_CTRL_FLCN_USTREAMER_QUEUE_POLICY_FULL_FLUSH_ENABLED = 1 # macro
NV2080_CTRL_FLCN_USTREAMER_QUEUE_POLICY_IMMEDIATE_FLUSH = ['2', ':', '2'] # macro
NV2080_CTRL_FLCN_USTREAMER_QUEUE_POLICY_IMMEDIATE_FLUSH_DISABLED = 0 # macro
NV2080_CTRL_FLCN_USTREAMER_QUEUE_POLICY_IMMEDIATE_FLUSH_ENABLED = 1 # macro
NV2080_CTRL_FLCN_USTREAMER_QUEUE_POLICY_IDLE_THRESHOLD = ['31', ':', '8'] # macro
NV2080_CTRL_FLCN_USTREAMER_NUM_EVT_TYPES_COMPACT = (0x20) # macro
NV2080_CTRL_FLCN_USTREAMER_NUM_EVT_TYPES = (0x120) # macro
NV2080_CTRL_FLCN_USTREAMER_MASK_SIZE_BYTES = (0x24) # macro
NV2080_CTRL_CMD_FLCN_USTREAMER_QUEUE_INFO = (0x20803120) # macro
NV2080_CTRL_FLCN_USTREAMER_QUEUE_INFO_PARAMS_MESSAGE_ID = (0x20) # macro
NV2080_CTRL_CMD_FLCN_USTREAMER_CONTROL_GET = (0x20803122) # macro
NV2080_CTRL_CMD_FLCN_USTREAMER_CONTROL_SET = (0x20803123) # macro
NV2080_CTRL_FLCN_USTREAMER_CONTROL_GET_PARAMS_MESSAGE_ID = (0x22) # macro
NV2080_CTRL_FLCN_USTREAMER_CONTROL_SET_PARAMS_MESSAGE_ID = (0x23) # macro
NV2080_CTRL_CMD_FLCN_GET_CTX_BUFFER_INFO = (0x20803124) # macro
NV2080_CTRL_FLCN_GET_CTX_BUFFER_INFO_PARAMS_MESSAGE_ID = (0x24) # macro
# NV2080_CTRL_FLCN_CTX_BUFFER_INFO_APERTURE_UNKNWON = ADDR_UNKNOWN # macro
# NV2080_CTRL_FLCN_CTX_BUFFER_INFO_APERTURE_SYSMEM = ADDR_SYSMEM # macro
# NV2080_CTRL_FLCN_CTX_BUFFER_INFO_APERTURE_FBMEM = ADDR_FBMEM # macro
NV2080_CTRL_CMD_FLCN_GET_CTX_BUFFER_SIZE = (0x20803125) # macro
NV2080_CTRL_FLCN_GET_CTX_BUFFER_SIZE_PARAMS_MESSAGE_ID = (0x25) # macro
class struct_NV2080_CTRL_FLCN_GET_DMEM_USAGE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FLCN_GET_DMEM_USAGE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FLCN_GET_DMEM_USAGE_PARAMS._fields_ = [
    ('flcnID', ctypes.c_uint32),
    ('heapSize', ctypes.c_uint32),
    ('heapFree', ctypes.c_uint32),
]

NV2080_CTRL_FLCN_GET_DMEM_USAGE_PARAMS = struct_NV2080_CTRL_FLCN_GET_DMEM_USAGE_PARAMS
class struct_NV2080_CTRL_FLCN_GET_ENGINE_ARCH_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FLCN_GET_ENGINE_ARCH_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FLCN_GET_ENGINE_ARCH_PARAMS._fields_ = [
    ('engine', ctypes.c_uint32),
    ('engineArch', ctypes.c_uint32),
]

NV2080_CTRL_FLCN_GET_ENGINE_ARCH_PARAMS = struct_NV2080_CTRL_FLCN_GET_ENGINE_ARCH_PARAMS
class struct_NV2080_CTRL_FLCN_USTREAMER_EVENT_FILTER(Structure):
    pass

struct_NV2080_CTRL_FLCN_USTREAMER_EVENT_FILTER._pack_ = 1 # source:False
struct_NV2080_CTRL_FLCN_USTREAMER_EVENT_FILTER._fields_ = [
    ('mask', ctypes.c_ubyte * 36),
]

NV2080_CTRL_FLCN_USTREAMER_EVENT_FILTER = struct_NV2080_CTRL_FLCN_USTREAMER_EVENT_FILTER
class struct_NV2080_CTRL_FLCN_USTREAMER_QUEUE_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FLCN_USTREAMER_QUEUE_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FLCN_USTREAMER_QUEUE_INFO_PARAMS._fields_ = [
    ('engine', ctypes.c_uint32),
    ('pageSize', ctypes.c_uint32),
    ('offset', ctypes.c_uint64),
    ('size', ctypes.c_uint32),
    ('queueFeatureId', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_FLCN_USTREAMER_QUEUE_INFO_PARAMS = struct_NV2080_CTRL_FLCN_USTREAMER_QUEUE_INFO_PARAMS
class struct_NV2080_CTRL_FLCN_USTREAMER_CONTROL_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FLCN_USTREAMER_CONTROL_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FLCN_USTREAMER_CONTROL_PARAMS._fields_ = [
    ('engine', ctypes.c_uint32),
    ('eventFilter', NV2080_CTRL_FLCN_USTREAMER_EVENT_FILTER),
    ('queueId', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_FLCN_USTREAMER_CONTROL_PARAMS = struct_NV2080_CTRL_FLCN_USTREAMER_CONTROL_PARAMS
NV2080_CTRL_FLCN_USTREAMER_CONTROL_GET_PARAMS = struct_NV2080_CTRL_FLCN_USTREAMER_CONTROL_PARAMS
NV2080_CTRL_FLCN_USTREAMER_CONTROL_SET_PARAMS = struct_NV2080_CTRL_FLCN_USTREAMER_CONTROL_PARAMS
class struct_NV2080_CTRL_FLCN_GET_CTX_BUFFER_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FLCN_GET_CTX_BUFFER_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FLCN_GET_CTX_BUFFER_INFO_PARAMS._fields_ = [
    ('hUserClient', ctypes.c_uint32),
    ('hChannel', ctypes.c_uint32),
    ('alignment', ctypes.c_uint64),
    ('size', ctypes.c_uint64),
    ('bufferHandle', ctypes.POINTER(None)),
    ('pageCount', ctypes.c_uint64),
    ('physAddr', ctypes.c_uint64),
    ('aperture', ctypes.c_uint32),
    ('kind', ctypes.c_uint32),
    ('pageSize', ctypes.c_uint32),
    ('bIsContigous', ctypes.c_ubyte),
    ('bDeviceDescendant', ctypes.c_ubyte),
    ('uuid', ctypes.c_ubyte * 16),
    ('PADDING_0', ctypes.c_ubyte * 2),
]

NV2080_CTRL_FLCN_GET_CTX_BUFFER_INFO_PARAMS = struct_NV2080_CTRL_FLCN_GET_CTX_BUFFER_INFO_PARAMS
class struct_NV2080_CTRL_FLCN_GET_CTX_BUFFER_SIZE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_FLCN_GET_CTX_BUFFER_SIZE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_FLCN_GET_CTX_BUFFER_SIZE_PARAMS._fields_ = [
    ('hChannel', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('totalBufferSize', ctypes.c_uint64),
]

NV2080_CTRL_FLCN_GET_CTX_BUFFER_SIZE_PARAMS = struct_NV2080_CTRL_FLCN_GET_CTX_BUFFER_SIZE_PARAMS
NV2080_CTRL_CMD_INTERNAL_GPIO_PROGRAM_DIRECTION = (0x20802300) # macro
NV2080_CTRL_INTERNAL_GPIO_PROGRAM_DIRECTION_PARAMS_MESSAGE_ID = (0x00) # macro
NV2080_CTRL_CMD_INTERNAL_GPIO_PROGRAM_OUTPUT = (0x20802301) # macro
NV2080_CTRL_INTERNAL_GPIO_PROGRAM_OUTPUT_PARAMS_MESSAGE_ID = (0x01) # macro
NV2080_CTRL_CMD_INTERNAL_GPIO_READ_INPUT = (0x20802302) # macro
NV2080_CTRL_INTERNAL_GPIO_READ_INPUT_PARAMS_MESSAGE_ID = (0x02) # macro
NV2080_CTRL_CMD_INTERNAL_GPIO_ACTIVATE_HW_FUNCTION = (0x20802303) # macro
NV2080_CTRL_INTERNAL_GPIO_ACTIVATE_HW_FUNCTION_PARAMS_MESSAGE_ID = (0x03) # macro
class struct_NV2080_CTRL_INTERNAL_GPIO_PROGRAM_DIRECTION_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GPIO_PROGRAM_DIRECTION_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GPIO_PROGRAM_DIRECTION_PARAMS._fields_ = [
    ('gpioPin', ctypes.c_uint32),
    ('bInput', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_INTERNAL_GPIO_PROGRAM_DIRECTION_PARAMS = struct_NV2080_CTRL_INTERNAL_GPIO_PROGRAM_DIRECTION_PARAMS
class struct_NV2080_CTRL_INTERNAL_GPIO_PROGRAM_OUTPUT_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GPIO_PROGRAM_OUTPUT_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GPIO_PROGRAM_OUTPUT_PARAMS._fields_ = [
    ('gpioPin', ctypes.c_uint32),
    ('value', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_GPIO_PROGRAM_OUTPUT_PARAMS = struct_NV2080_CTRL_INTERNAL_GPIO_PROGRAM_OUTPUT_PARAMS
class struct_NV2080_CTRL_INTERNAL_GPIO_READ_INPUT_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GPIO_READ_INPUT_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GPIO_READ_INPUT_PARAMS._fields_ = [
    ('gpioPin', ctypes.c_uint32),
    ('value', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_GPIO_READ_INPUT_PARAMS = struct_NV2080_CTRL_INTERNAL_GPIO_READ_INPUT_PARAMS
class struct_NV2080_CTRL_INTERNAL_GPIO_ACTIVATE_HW_FUNCTION_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GPIO_ACTIVATE_HW_FUNCTION_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GPIO_ACTIVATE_HW_FUNCTION_PARAMS._fields_ = [
    ('function', ctypes.c_uint32),
    ('pin', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_GPIO_ACTIVATE_HW_FUNCTION_PARAMS = struct_NV2080_CTRL_INTERNAL_GPIO_ACTIVATE_HW_FUNCTION_PARAMS
NV2080_CTRL_CMD_GRMGR_GET_GR_FS_INFO = (0x20803801) # macro
NV2080_CTRL_GRMGR_GR_FS_INFO_MAX_QUERIES = 96 # macro
NV2080_CTRL_GRMGR_GR_FS_INFO_QUERY_MAX_SIZE = 32 # macro
NV2080_CTRL_GRMGR_MAX_SMC_IDS = 8 # macro
NV2080_CTRL_GRMGR_GET_GR_FS_INFO_PARAMS_MESSAGE_ID = (0x1) # macro
NV2080_CTRL_GRMGR_GR_FS_INFO_QUERY_INVALID = 0 # macro
NV2080_CTRL_GRMGR_GR_FS_INFO_QUERY_GPC_COUNT = 1 # macro
NV2080_CTRL_GRMGR_GR_FS_INFO_QUERY_CHIPLET_GPC_MAP = 2 # macro
NV2080_CTRL_GRMGR_GR_FS_INFO_QUERY_TPC_MASK = 3 # macro
NV2080_CTRL_GRMGR_GR_FS_INFO_QUERY_PPC_MASK = 4 # macro
NV2080_CTRL_GRMGR_GR_FS_INFO_QUERY_PARTITION_CHIPLET_GPC_MAP = 5 # macro
NV2080_CTRL_GRMGR_GR_FS_INFO_QUERY_CHIPLET_SYSPIPE_MASK = 6 # macro
NV2080_CTRL_GRMGR_GR_FS_INFO_QUERY_PARTITION_CHIPLET_SYSPIPE_IDS = 7 # macro
NV2080_CTRL_GRMGR_GR_FS_INFO_QUERY_PROFILER_MON_GPC_MASK = 8 # macro
NV2080_CTRL_GRMGR_GR_FS_INFO_QUERY_PARTITION_SYSPIPE_ID = 9 # macro
NV2080_CTRL_GRMGR_GR_FS_INFO_QUERY_ROP_MASK = 10 # macro
class struct_NV2080_CTRL_GRMGR_GR_FS_INFO_GPC_COUNT_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GRMGR_GR_FS_INFO_GPC_COUNT_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GRMGR_GR_FS_INFO_GPC_COUNT_PARAMS._fields_ = [
    ('gpcCount', ctypes.c_uint32),
]

NV2080_CTRL_GRMGR_GR_FS_INFO_GPC_COUNT_PARAMS = struct_NV2080_CTRL_GRMGR_GR_FS_INFO_GPC_COUNT_PARAMS
class struct_NV2080_CTRL_GRMGR_GR_FS_INFO_CHIPLET_GPC_MAP_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GRMGR_GR_FS_INFO_CHIPLET_GPC_MAP_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GRMGR_GR_FS_INFO_CHIPLET_GPC_MAP_PARAMS._fields_ = [
    ('gpcId', ctypes.c_uint32),
    ('chipletGpcMap', ctypes.c_uint32),
]

NV2080_CTRL_GRMGR_GR_FS_INFO_CHIPLET_GPC_MAP_PARAMS = struct_NV2080_CTRL_GRMGR_GR_FS_INFO_CHIPLET_GPC_MAP_PARAMS
class struct_NV2080_CTRL_GRMGR_GR_FS_INFO_TPC_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GRMGR_GR_FS_INFO_TPC_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GRMGR_GR_FS_INFO_TPC_MASK_PARAMS._fields_ = [
    ('gpcId', ctypes.c_uint32),
    ('tpcMask', ctypes.c_uint32),
]

NV2080_CTRL_GRMGR_GR_FS_INFO_TPC_MASK_PARAMS = struct_NV2080_CTRL_GRMGR_GR_FS_INFO_TPC_MASK_PARAMS
class struct_NV2080_CTRL_GRMGR_GR_FS_INFO_PPC_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GRMGR_GR_FS_INFO_PPC_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GRMGR_GR_FS_INFO_PPC_MASK_PARAMS._fields_ = [
    ('gpcId', ctypes.c_uint32),
    ('ppcMask', ctypes.c_uint32),
]

NV2080_CTRL_GRMGR_GR_FS_INFO_PPC_MASK_PARAMS = struct_NV2080_CTRL_GRMGR_GR_FS_INFO_PPC_MASK_PARAMS
class struct_NV2080_CTRL_GRMGR_GR_FS_INFO_PARTITION_CHIPLET_GPC_MAP_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GRMGR_GR_FS_INFO_PARTITION_CHIPLET_GPC_MAP_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GRMGR_GR_FS_INFO_PARTITION_CHIPLET_GPC_MAP_PARAMS._fields_ = [
    ('swizzId', ctypes.c_uint32),
    ('gpcId', ctypes.c_uint32),
    ('chipletGpcMap', ctypes.c_uint32),
]

NV2080_CTRL_GRMGR_GR_FS_INFO_PARTITION_CHIPLET_GPC_MAP_PARAMS = struct_NV2080_CTRL_GRMGR_GR_FS_INFO_PARTITION_CHIPLET_GPC_MAP_PARAMS
class struct_NV2080_CTRL_GRMGR_GR_FS_INFO_ROP_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GRMGR_GR_FS_INFO_ROP_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GRMGR_GR_FS_INFO_ROP_MASK_PARAMS._fields_ = [
    ('gpcId', ctypes.c_uint32),
    ('ropMask', ctypes.c_uint32),
]

NV2080_CTRL_GRMGR_GR_FS_INFO_ROP_MASK_PARAMS = struct_NV2080_CTRL_GRMGR_GR_FS_INFO_ROP_MASK_PARAMS
class struct_NV2080_CTRL_GRMGR_GR_FS_INFO_CHIPLET_SYSPIPE_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GRMGR_GR_FS_INFO_CHIPLET_SYSPIPE_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GRMGR_GR_FS_INFO_CHIPLET_SYSPIPE_MASK_PARAMS._fields_ = [
    ('chipletSyspipeMask', ctypes.c_uint32),
]

NV2080_CTRL_GRMGR_GR_FS_INFO_CHIPLET_SYSPIPE_MASK_PARAMS = struct_NV2080_CTRL_GRMGR_GR_FS_INFO_CHIPLET_SYSPIPE_MASK_PARAMS
class struct_NV2080_CTRL_GRMGR_GR_FS_INFO_PARTITION_CHIPLET_SYSPIPE_IDS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GRMGR_GR_FS_INFO_PARTITION_CHIPLET_SYSPIPE_IDS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GRMGR_GR_FS_INFO_PARTITION_CHIPLET_SYSPIPE_IDS_PARAMS._fields_ = [
    ('swizzId', ctypes.c_uint16),
    ('physSyspipeIdCount', ctypes.c_uint16),
    ('physSyspipeId', ctypes.c_ubyte * 8),
]

NV2080_CTRL_GRMGR_GR_FS_INFO_PARTITION_CHIPLET_SYSPIPE_IDS_PARAMS = struct_NV2080_CTRL_GRMGR_GR_FS_INFO_PARTITION_CHIPLET_SYSPIPE_IDS_PARAMS
class struct_NV2080_CTRL_GRMGR_GR_FS_INFO_PROFILER_MON_GPC_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GRMGR_GR_FS_INFO_PROFILER_MON_GPC_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GRMGR_GR_FS_INFO_PROFILER_MON_GPC_MASK_PARAMS._fields_ = [
    ('swizzId', ctypes.c_uint32),
    ('grIdx', ctypes.c_uint32),
    ('gpcEnMask', ctypes.c_uint32),
]

NV2080_CTRL_GRMGR_GR_FS_INFO_PROFILER_MON_GPC_MASK_PARAMS = struct_NV2080_CTRL_GRMGR_GR_FS_INFO_PROFILER_MON_GPC_MASK_PARAMS
class struct_NV2080_CTRL_GRMGR_GR_FS_INFO_PARTITION_SYSPIPE_ID_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GRMGR_GR_FS_INFO_PARTITION_SYSPIPE_ID_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GRMGR_GR_FS_INFO_PARTITION_SYSPIPE_ID_PARAMS._fields_ = [
    ('syspipeId', ctypes.c_uint32),
]

NV2080_CTRL_GRMGR_GR_FS_INFO_PARTITION_SYSPIPE_ID_PARAMS = struct_NV2080_CTRL_GRMGR_GR_FS_INFO_PARTITION_SYSPIPE_ID_PARAMS
class struct_NV2080_CTRL_GRMGR_GR_FS_INFO_QUERY_PARAMS(Structure):
    pass

class union_NV2080_CTRL_GRMGR_GR_FS_INFO_QUERY_PARAMS_queryData(Union):
    pass

union_NV2080_CTRL_GRMGR_GR_FS_INFO_QUERY_PARAMS_queryData._pack_ = 1 # source:False
union_NV2080_CTRL_GRMGR_GR_FS_INFO_QUERY_PARAMS_queryData._fields_ = [
    ('gpcCountData', NV2080_CTRL_GRMGR_GR_FS_INFO_GPC_COUNT_PARAMS),
    ('chipletGpcMapData', NV2080_CTRL_GRMGR_GR_FS_INFO_CHIPLET_GPC_MAP_PARAMS),
    ('tpcMaskData', NV2080_CTRL_GRMGR_GR_FS_INFO_TPC_MASK_PARAMS),
    ('ppcMaskData', NV2080_CTRL_GRMGR_GR_FS_INFO_PPC_MASK_PARAMS),
    ('partitionGpcMapData', NV2080_CTRL_GRMGR_GR_FS_INFO_PARTITION_CHIPLET_GPC_MAP_PARAMS),
    ('syspipeMaskData', NV2080_CTRL_GRMGR_GR_FS_INFO_CHIPLET_SYSPIPE_MASK_PARAMS),
    ('partitionChipletSyspipeData', NV2080_CTRL_GRMGR_GR_FS_INFO_PARTITION_CHIPLET_SYSPIPE_IDS_PARAMS),
    ('dmGpcMaskData', NV2080_CTRL_GRMGR_GR_FS_INFO_PROFILER_MON_GPC_MASK_PARAMS),
    ('partitionSyspipeIdData', NV2080_CTRL_GRMGR_GR_FS_INFO_PARTITION_SYSPIPE_ID_PARAMS),
    ('ropMaskData', NV2080_CTRL_GRMGR_GR_FS_INFO_ROP_MASK_PARAMS),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

struct_NV2080_CTRL_GRMGR_GR_FS_INFO_QUERY_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GRMGR_GR_FS_INFO_QUERY_PARAMS._fields_ = [
    ('queryType', ctypes.c_uint16),
    ('reserved', ctypes.c_ubyte * 2),
    ('status', ctypes.c_uint32),
    ('queryData', union_NV2080_CTRL_GRMGR_GR_FS_INFO_QUERY_PARAMS_queryData),
]

NV2080_CTRL_GRMGR_GR_FS_INFO_QUERY_PARAMS = struct_NV2080_CTRL_GRMGR_GR_FS_INFO_QUERY_PARAMS
class struct_NV2080_CTRL_GRMGR_GET_GR_FS_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GRMGR_GET_GR_FS_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GRMGR_GET_GR_FS_INFO_PARAMS._fields_ = [
    ('numQueries', ctypes.c_uint16),
    ('reserved', ctypes.c_ubyte * 6),
    ('queries', struct_NV2080_CTRL_GRMGR_GR_FS_INFO_QUERY_PARAMS * 96),
]

NV2080_CTRL_GRMGR_GET_GR_FS_INFO_PARAMS = struct_NV2080_CTRL_GRMGR_GET_GR_FS_INFO_PARAMS
NV2080_CTRL_CMD_GSP_GET_FEATURES = (0x20803601) # macro
NV2080_GSP_MAX_BUILD_VERSION_LENGTH = (0x0000040) # macro
NV2080_CTRL_GSP_GET_FEATURES_PARAMS_MESSAGE_ID = (0x1) # macro
NV2080_CTRL_GSP_GET_FEATURES_UVM_ENABLED = ['0', ':', '0'] # macro
NV2080_CTRL_GSP_GET_FEATURES_UVM_ENABLED_FALSE = (0x00000000) # macro
NV2080_CTRL_GSP_GET_FEATURES_UVM_ENABLED_TRUE = (0x00000001) # macro
NV2080_CTRL_GSP_GET_FEATURES_VGPU_GSP_MIG_REFACTORING_ENABLED = ['1', ':', '1'] # macro
NV2080_CTRL_GSP_GET_FEATURES_VGPU_GSP_MIG_REFACTORING_ENABLED_FALSE = (0x00000000) # macro
NV2080_CTRL_GSP_GET_FEATURES_VGPU_GSP_MIG_REFACTORING_ENABLED_TRUE = (0x00000001) # macro
NV2080_CTRL_CMD_GSP_GET_RM_HEAP_STATS = (0x20803602) # macro
NV2080_CTRL_GSP_GET_RM_HEAP_STATS_PARAMS_MESSAGE_ID = (0x2) # macro
class struct_NV2080_CTRL_GSP_GET_FEATURES_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GSP_GET_FEATURES_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GSP_GET_FEATURES_PARAMS._fields_ = [
    ('gspFeatures', ctypes.c_uint32),
    ('bValid', ctypes.c_ubyte),
    ('bDefaultGspRmGpu', ctypes.c_ubyte),
    ('firmwareVersion', ctypes.c_ubyte * 64),
    ('PADDING_0', ctypes.c_ubyte * 2),
]

NV2080_CTRL_GSP_GET_FEATURES_PARAMS = struct_NV2080_CTRL_GSP_GET_FEATURES_PARAMS
class struct_NV2080_CTRL_GSP_RM_HEAP_STATS_SNAPSHOT(Structure):
    pass

struct_NV2080_CTRL_GSP_RM_HEAP_STATS_SNAPSHOT._pack_ = 1 # source:False
struct_NV2080_CTRL_GSP_RM_HEAP_STATS_SNAPSHOT._fields_ = [
    ('allocatedSize', ctypes.c_uint64),
    ('usableSize', ctypes.c_uint64),
    ('memTrackOverhead', ctypes.c_uint64),
    ('allocationCount', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NV2080_CTRL_GSP_RM_HEAP_STATS_SNAPSHOT = struct_NV2080_CTRL_GSP_RM_HEAP_STATS_SNAPSHOT
class struct_NV2080_CTRL_GSP_GET_RM_HEAP_STATS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_GSP_GET_RM_HEAP_STATS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_GSP_GET_RM_HEAP_STATS_PARAMS._fields_ = [
    ('managedSize', ctypes.c_uint64),
    ('current', NV2080_CTRL_GSP_RM_HEAP_STATS_SNAPSHOT),
    ('peak', NV2080_CTRL_GSP_RM_HEAP_STATS_SNAPSHOT),
]

NV2080_CTRL_GSP_GET_RM_HEAP_STATS_PARAMS = struct_NV2080_CTRL_GSP_GET_RM_HEAP_STATS_PARAMS
NV2080_CTRL_CMD_HSHUB_GET_AVAILABLE_MASK_PARAMS_MESSAGE_ID = (0x1) # macro
NV2080_CTRL_CMD_HSHUB_GET_AVAILABLE_MASK = (0x20804101) # macro
NV2080_CTRL_CMD_HSHUB_SET_EC_THROTTLE_MODE_PARAMS_MESSAGE_ID = (0x2) # macro
NV2080_CTRL_CMD_HSHUB_SET_EC_THROTTLE_MODE = (0x20804102) # macro
class struct_NV2080_CTRL_CMD_HSHUB_GET_AVAILABLE_MASK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_HSHUB_GET_AVAILABLE_MASK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_HSHUB_GET_AVAILABLE_MASK_PARAMS._fields_ = [
    ('hshubNcisocMask', ctypes.c_uint32),
    ('hshubNvlMask', ctypes.c_uint32),
]

NV2080_CTRL_CMD_HSHUB_GET_AVAILABLE_MASK_PARAMS = struct_NV2080_CTRL_CMD_HSHUB_GET_AVAILABLE_MASK_PARAMS
class struct_NV2080_CTRL_CMD_HSHUB_SET_EC_THROTTLE_MODE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_HSHUB_SET_EC_THROTTLE_MODE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_HSHUB_SET_EC_THROTTLE_MODE_PARAMS._fields_ = [
    ('ecMode', ctypes.c_uint32),
    ('status', ctypes.c_uint32),
]

NV2080_CTRL_CMD_HSHUB_SET_EC_THROTTLE_MODE_PARAMS = struct_NV2080_CTRL_CMD_HSHUB_SET_EC_THROTTLE_MODE_PARAMS
NV2080_CTRL_I2C_VERSION_0 = 0x00 # macro
NV2080_CTRL_I2C_MAX_ENTRIES = 256 # macro
NV2080_CTRL_I2C_MAX_REG_LEN = 8 # macro
NV2080_CTRL_I2C_MAX_ADDR_ENTRIES = 20 # macro
NV2080_CTRL_I2C_FLAGS_NONSTD_SI1930UC = (0x00000001) # macro
NV2080_CTRL_I2C_FLAGS_PRIVILEGE = (0x00000002) # macro
NV2080_CTRL_I2C_FLAGS_DATA_ENCRYPTED = (0x00000004) # macro
NV2080_CTRL_I2C_FLAGS_PX3540 = (0x00000010) # macro
NV2080_CTRL_I2C_FLAGS_ADDR_AUTO_INC_NOT_SUPPORTED = (0x00000008) # macro
NV2080_CTRL_I2C_READ_BUFFER_PARAMS_MESSAGE_ID = (0x1) # macro
NV2080_CTRL_CMD_I2C_READ_BUFFER = (0x20800601) # macro
NV2080_CTRL_I2C_WRITE_BUFFER_PARAMS_MESSAGE_ID = (0x2) # macro
NV2080_CTRL_CMD_I2C_WRITE_BUFFER = (0x20800602) # macro
NV2080_CTRL_CMD_I2C_READ_REG = (0x20800603) # macro
NV2080_CTRL_I2C_READ_REG_PARAMS_MESSAGE_ID = (0x3) # macro
NV2080_CTRL_CMD_I2C_WRITE_REG = (0x20800604) # macro
NV2080_CTRL_I2C_WRITE_REG_PARAMS_MESSAGE_ID = (0x4) # macro
NV2080_CTRL_CMD_I2C_ACCESS = (0x20800610) # macro
NV2080_CTRL_I2C_ACCESS_PARAMS_MESSAGE_ID = (0x10) # macro
NV2080_CTRL_I2C_ACCESS_CMD_ACQUIRE = 0x1 # macro
NV2080_CTRL_I2C_ACCESS_CMD_RELEASE = 0x2 # macro
NV2080_CTRL_I2C_ACCESS_CMD_WRITE_BYTE = 0x3 # macro
NV2080_CTRL_I2C_ACCESS_CMD_READ_BYTE = 0x4 # macro
NV2080_CTRL_I2C_ACCESS_CMD_NULL = 0x5 # macro
NV2080_CTRL_I2C_ACCESS_CMD_RESET = 0x6 # macro
NV2080_CTRL_I2C_ACCESS_CMD_TEST_PORT = 0x11 # macro
NV2080_CTRL_I2C_ACCESS_CMD_SET_FAST_MODE = 0x12 # macro
NV2080_CTRL_I2C_ACCESS_CMD_SET_NORMAL_MODE = 0x13 # macro
NV2080_CTRL_I2C_ACCESS_CMD_WRITE_BUFFER = 0x14 # macro
NV2080_CTRL_I2C_ACCESS_CMD_READ_BUFFER = 0x15 # macro
NV2080_CTRL_I2C_ACCESS_CMD_START = 0x17 # macro
NV2080_CTRL_I2C_ACCESS_CMD_STOP = 0x18 # macro
NV2080_CTRL_I2C_ACCESS_CMD_SET_SLOW_MODE = 0x20 # macro
NV2080_CTRL_I2C_ACCESS_FLAG_START = 0x1 # macro
NV2080_CTRL_I2C_ACCESS_FLAG_STOP = 0x2 # macro
NV2080_CTRL_I2C_ACCESS_FLAG_ACK = 0x4 # macro
NV2080_CTRL_I2C_ACCESS_FLAG_RAB = 0x8 # macro
NV2080_CTRL_I2C_ACCESS_FLAG_ADDR_10BITS = 0x10 # macro
NV2080_CTRL_I2C_ACCESS_FLAG_PRIVILEGE = 0x20 # macro
NV2080_CTRL_I2C_ACCESS_FLAG_DATA_ENCRYPTED = 0x40 # macro
NV2080_CTRL_I2C_ACCESS_FLAG_RESTART = 0x80 # macro
NV2080_CTRL_I2C_ACCESS_FLAG_SLOW_MODE_33_33PCT = 0x100 # macro
NV2080_CTRL_I2C_ACCESS_FLAG_SLOW_MODE_33PCT = 0x200 # macro
NV2080_CTRL_I2C_ACCESS_FLAG_SLOW_MODE_10PCT = 0x400 # macro
NV2080_CTRL_I2C_ACCESS_FLAG_SLOW_MODE_3_33PCT = 0x800 # macro
NV2080_CTRL_I2C_ACCESS_FLAG_SLOW_MODE_3PCT = 0x1000 # macro
NV2080_CTRL_I2C_ACCESS_PORT_DYNAMIC = 0x0 # macro
NV2080_CTRL_I2C_ACCESS_PORT_PRIMARY = 0x1 # macro
NV2080_CTRL_I2C_ACCESS_PORT_SECONDARY = 0x2 # macro
NV2080_CTRL_I2C_ACCESS_PORT_TERTIARY = 0x3 # macro
NV2080_CTRL_I2C_ACCESS_PORT_QUARTIARY = 0x4 # macro
NV2080_CTRL_I2C_ACCESS_PORT_1 = 0x1 # macro
NV2080_CTRL_I2C_ACCESS_PORT_2 = 0x2 # macro
NV2080_CTRL_I2C_ACCESS_PORT_3 = 0x3 # macro
NV2080_CTRL_I2C_ACCESS_PORT_4 = 0x4 # macro
NV2080_CTRL_I2C_ACCESS_PORT_5 = 0x5 # macro
NV2080_CTRL_I2C_ACCESS_PORT_6 = 0x6 # macro
NV2080_CTRL_I2C_ACCESS_PORT_7 = 0x7 # macro
NV2080_CTRL_I2C_ACCESS_PORT_8 = 0x8 # macro
NV2080_CTRL_I2C_ACCESS_PORT_9 = 0x9 # macro
NV2080_CTRL_I2C_ACCESS_PORT_10 = 0x10 # macro
NV2080_CTRL_I2C_ACCESS_NUM_PORTS = 0x10 # macro
NV2080_CTRL_I2C_ACCESS_STATUS_SUCCESS = 0x0 # macro
NV2080_CTRL_I2C_ACCESS_STATUS_ERROR = 0x1 # macro
NV2080_CTRL_I2C_ACCESS_STATUS_PROTOCOL_ERROR = 0x2 # macro
NV2080_CTRL_I2C_ACCESS_STATUS_DEVICE_BUSY = 0x3 # macro
NV2080_CTRL_I2C_ACCESS_STATUS_NACK_AFTER_SEND = 0x4 # macro
NV2080_CTRL_I2C_ACCESS_STATUS_DP2TMDS_DONGLE_MISSING = 0x5 # macro
NV2080_CTRL_CMD_I2C_ENABLE_MONITOR_3D_MODE = (0x20800620) # macro
NV2080_CTRL_I2C_ENABLE_MONITOR_3D_MODE_PARAMS_MESSAGE_ID = (0x20) # macro
class struct_NV2080_CTRL_I2C_READ_BUFFER_PARAMS(Structure):
    pass

struct_NV2080_CTRL_I2C_READ_BUFFER_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_I2C_READ_BUFFER_PARAMS._fields_ = [
    ('version', ctypes.c_uint32),
    ('port', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('inputCount', ctypes.c_uint32),
    ('inputBuffer', ctypes.c_ubyte * 256),
    ('outputCount', ctypes.c_uint32),
    ('outputBuffer', ctypes.c_ubyte * 256),
]

NV2080_CTRL_I2C_READ_BUFFER_PARAMS = struct_NV2080_CTRL_I2C_READ_BUFFER_PARAMS
class struct_NV2080_CTRL_I2C_WRITE_BUFFER_PARAMS(Structure):
    pass

struct_NV2080_CTRL_I2C_WRITE_BUFFER_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_I2C_WRITE_BUFFER_PARAMS._fields_ = [
    ('version', ctypes.c_uint32),
    ('port', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('inputCount', ctypes.c_uint32),
    ('inputBuffer', ctypes.c_ubyte * 256),
    ('encrClientID', ctypes.c_uint32),
]

NV2080_CTRL_I2C_WRITE_BUFFER_PARAMS = struct_NV2080_CTRL_I2C_WRITE_BUFFER_PARAMS
class struct_NV2080_CTRL_I2C_RW_REG_PARAMS(Structure):
    pass

struct_NV2080_CTRL_I2C_RW_REG_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_I2C_RW_REG_PARAMS._fields_ = [
    ('version', ctypes.c_uint32),
    ('port', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('addr', ctypes.c_uint32),
    ('reg', ctypes.c_ubyte),
    ('bufsize', ctypes.c_ubyte),
    ('buffer', ctypes.c_ubyte * 255),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_I2C_RW_REG_PARAMS = struct_NV2080_CTRL_I2C_RW_REG_PARAMS
NV2080_CTRL_I2C_READ_REG_PARAMS = struct_NV2080_CTRL_I2C_RW_REG_PARAMS
NV2080_CTRL_I2C_WRITE_REG_PARAMS = struct_NV2080_CTRL_I2C_RW_REG_PARAMS
class struct_NV2080_CTRL_I2C_ACCESS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_I2C_ACCESS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_I2C_ACCESS_PARAMS._fields_ = [
    ('token', ctypes.c_uint32),
    ('cmd', ctypes.c_uint32),
    ('port', ctypes.c_uint32),
    ('flags', ctypes.c_uint32),
    ('data', ctypes.POINTER(None)),
    ('status', ctypes.c_uint32),
    ('dataBuffSize', ctypes.c_uint32),
    ('speed', ctypes.c_uint32),
    ('encrClientID', ctypes.c_uint32),
]

NV2080_CTRL_I2C_ACCESS_PARAMS = struct_NV2080_CTRL_I2C_ACCESS_PARAMS
class struct_NV2080_CTRL_I2C_ENABLE_MONITOR_3D_MODE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_I2C_ENABLE_MONITOR_3D_MODE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_I2C_ENABLE_MONITOR_3D_MODE_PARAMS._fields_ = [
    ('head', ctypes.c_uint32),
    ('authType', ctypes.c_uint32),
    ('status', ctypes.c_uint32),
]

NV2080_CTRL_I2C_ENABLE_MONITOR_3D_MODE_PARAMS = struct_NV2080_CTRL_I2C_ENABLE_MONITOR_3D_MODE_PARAMS
NV2080_CTRL_CMD_INTERNAL_DISPLAY_GET_STATIC_INFO = (0x20800a01) # macro
NV2080_CTRL_INTERNAL_DISPLAY_GET_STATIC_INFO_PARAMS_MESSAGE_ID = (0x1) # macro
NV2080_CTRL_INTERNAL_MEMSYS_GET_STATIC_CONFIG_PARAMS_MESSAGE_ID = (0x1C) # macro
NV2080_CTRL_CMD_INTERNAL_MEMSYS_GET_STATIC_CONFIG = (0x20800a1c) # macro
NV2080_CTRL_CMD_INTERNAL_UVM_REGISTER_ACCESS_CNTR_BUFFER = (0x20800a1d) # macro
NV2080_CTRL_INTERNAL_UVM_ACCESS_CNTR_BUFFER_MAX_PAGES = 64 # macro
NV2080_CTRL_INTERNAL_UVM_REGISTER_ACCESS_CNTR_BUFFER_PARAMS_MESSAGE_ID = (0x1D) # macro
NV2080_CTRL_CMD_INTERNAL_UVM_UNREGISTER_ACCESS_CNTR_BUFFER = (0x20800a1e) # macro
NV2080_CTRL_INTERNAL_UVM_UNREGISTER_ACCESS_CNTR_BUFFER_PARAMS_MESSAGE_ID = (0x1E) # macro
NV2080_CTRL_INTERNAL_GR_MAX_ENGINES = 8 # macro
NV2080_CTRL_INTERNAL_STATIC_GR_GET_CAPS_PARAMS_MESSAGE_ID = (0x20) # macro
NV2080_CTRL_CMD_INTERNAL_STATIC_KGR_GET_CAPS = (0x20800a1f) # macro
NV2080_CTRL_INTERNAL_STATIC_KGR_GET_CAPS_PARAMS_MESSAGE_ID = (0x1F) # macro
NV2080_CTRL_CMD_INTERNAL_FLCN_SET_VIDEO_EVENT_BUFFER_FLAGS = (0x20800a21) # macro
NV2080_CTRL_INTERNAL_FLCN_SET_VIDEO_EVENT_BUFFER_FLAGS_PARAMS_MESSAGE_ID = (0x21) # macro
NV2080_CTRL_INTERNAL_GR_MAX_SM = 240 # macro
NV2080_CTRL_INTERNAL_STATIC_GR_GET_GLOBAL_SM_ORDER_PARAMS_MESSAGE_ID = (0x23) # macro
NV2080_CTRL_CMD_INTERNAL_STATIC_KGR_GET_GLOBAL_SM_ORDER = (0x20800a22) # macro
NV2080_CTRL_INTERNAL_STATIC_KGR_GET_GLOBAL_SM_ORDER_PARAMS_MESSAGE_ID = (0x22) # macro
NV2080_CTRL_CMD_INTERNAL_BSP_GET_CAPS = (0x20800a24) # macro
NV2080_CTRL_CMD_INTERNAL_MAX_BSPS = 8 # macro
NV2080_CTRL_INTERNAL_BSP_GET_CAPS_PARAMS_MESSAGE_ID = (0x24) # macro
NV2080_CTRL_CMD_INTERNAL_MSENC_GET_CAPS = (0x20800a25) # macro
NV2080_CTRL_CMD_INTERNAL_MAX_MSENCS = 8 # macro
NV2080_CTRL_INTERNAL_MSENC_GET_CAPS_PARAMS_MESSAGE_ID = (0x25) # macro
NV2080_CTRL_INTERNAL_GR_MAX_GPC = 12 # macro
NV2080_CTRL_INTERNAL_MAX_TPC_PER_GPC_COUNT = 10 # macro
NV2080_CTRL_INTERNAL_STATIC_GR_GET_FLOORSWEEPING_MASKS_PARAMS_MESSAGE_ID = (0x27) # macro
NV2080_CTRL_CMD_INTERNAL_STATIC_KGR_GET_FLOORSWEEPING_MASKS = (0x20800a26) # macro
NV2080_CTRL_INTERNAL_STATIC_KGR_GET_FLOORSWEEPING_MASKS_PARAMS_MESSAGE_ID = (0x26) # macro
NV2080_CTRL_KGR_MAX_BUFFER_PTES = 128 # macro
NV2080_CTRL_CMD_KGR_GET_CTX_BUFFER_PTES = (0x20800a28) # macro
NV2080_CTRL_KGR_GET_CTX_BUFFER_PTES_PARAMS_MESSAGE_ID = (0x28) # macro
NV2080_CTRL_CMD_INTERNAL_FLCN_SET_VIDEO_EVENT_BUFFER_MEMORY = (0x20800a29) # macro
NV2080_CTRL_INTERNAL_FLCN_SET_VIDEO_EVENT_BUFFER_MEMORY_PARAMS_MESSAGE_ID = (0x29) # macro
NV2080_CTRL_INTERNAL_STATIC_GR_GET_INFO_PARAMS_MESSAGE_ID = (0x2B) # macro
NV2080_CTRL_CMD_INTERNAL_STATIC_KGR_GET_INFO = (0x20800a2a) # macro
NV2080_CTRL_INTERNAL_STATIC_KGR_GET_INFO_PARAMS_MESSAGE_ID = (0x2A) # macro
NV2080_CTRL_INTERNAL_STATIC_GR_GET_ZCULL_INFO_PARAMS_MESSAGE_ID = (0x2D) # macro
NV2080_CTRL_CMD_INTERNAL_STATIC_KGR_GET_ZCULL_INFO = (0x20800a2c) # macro
NV2080_CTRL_INTERNAL_STATIC_KGR_GET_ZCULL_INFO_PARAMS_MESSAGE_ID = (0x2C) # macro
NV2080_CTRL_INTERNAL_STATIC_GR_GET_ROP_INFO_PARAMS_MESSAGE_ID = (0x2F) # macro
NV2080_CTRL_CMD_INTERNAL_STATIC_KGR_GET_ROP_INFO = (0x20800a2e) # macro
NV2080_CTRL_INTERNAL_STATIC_KGR_GET_ROP_INFO_PARAMS_MESSAGE_ID = (0x2E) # macro
NV2080_CTRL_INTERNAL_STATIC_GR_GET_PPC_MASKS_PARAMS_MESSAGE_ID = (0x31) # macro
NV2080_CTRL_CMD_INTERNAL_STATIC_KGR_GET_PPC_MASKS = (0x20800a30) # macro
NV2080_CTRL_INTERNAL_STATIC_KGR_GET_PPC_MASKS_PARAMS_MESSAGE_ID = (0x30) # macro
NV2080_CTRL_INTERNAL_ENGINE_CONTEXT_PROPERTIES_ENGINE_ID_COUNT = 0x1a # macro
NV2080_CTRL_INTERNAL_STATIC_GR_GET_CONTEXT_BUFFERS_INFO_PARAMS_MESSAGE_ID = (0x33) # macro
NV2080_CTRL_CMD_INTERNAL_STATIC_KGR_GET_CONTEXT_BUFFERS_INFO = (0x20800a32) # macro
NV2080_CTRL_INTERNAL_STATIC_KGR_GET_CONTEXT_BUFFERS_INFO_PARAMS_MESSAGE_ID = (0x32) # macro
NV2080_CTRL_INTERNAL_STATIC_GR_GET_SM_ISSUE_RATE_MODIFIER_PARAMS_MESSAGE_ID = (0x35) # macro
NV2080_CTRL_CMD_INTERNAL_STATIC_KGR_GET_SM_ISSUE_RATE_MODIFIER = (0x20800a34) # macro
NV2080_CTRL_INTERNAL_STATIC_KGR_GET_SM_ISSUE_RATE_MODIFIER_PARAMS_MESSAGE_ID = (0x34) # macro
NV2080_CTRL_CMD_INTERNAL_GPU_GET_CHIP_INFO = (0x20800a36) # macro
NV2080_CTRL_INTERNAL_GET_CHIP_INFO_REG_BASE_MAX = 16 # macro
NV2080_CTRL_INTERNAL_GPU_GET_CHIP_INFO_PARAMS_MESSAGE_ID = (0x36) # macro
NV2080_CTRL_CMD_INTERNAL_GR_SET_FECS_TRACE_HW_ENABLE = (0x20800a37) # macro
NV2080_CTRL_CMD_INTERNAL_GR_GET_FECS_TRACE_HW_ENABLE = (0x20800a38) # macro
NV2080_CTRL_INTERNAL_GR_SET_FECS_TRACE_HW_ENABLE_PARAMS_MESSAGE_ID = (0x37) # macro
NV2080_CTRL_INTERNAL_GR_GET_FECS_TRACE_HW_ENABLE_PARAMS_MESSAGE_ID = (0x38) # macro
NV2080_CTRL_CMD_INTERNAL_GR_SET_FECS_TRACE_RD_OFFSET = (0x20800a39) # macro
NV2080_CTRL_CMD_INTERNAL_GR_SET_FECS_TRACE_WR_OFFSET = (0x20800a3a) # macro
NV2080_CTRL_CMD_INTERNAL_GR_GET_FECS_TRACE_RD_OFFSET = (0x20800a3b) # macro
NV2080_CTRL_INTERNAL_GR_SET_FECS_TRACE_RD_OFFSET_PARAMS_MESSAGE_ID = (0x39) # macro
NV2080_CTRL_INTERNAL_GR_SET_FECS_TRACE_WR_OFFSET_PARAMS_MESSAGE_ID = (0x3A) # macro
NV2080_CTRL_INTERNAL_GR_GET_FECS_TRACE_RD_OFFSET_PARAMS_MESSAGE_ID = (0x3B) # macro
NV2080_CTRL_CMD_INTERNAL_STATIC_KGR_GET_FECS_RECORD_SIZE = (0x20800a3d) # macro
NV2080_CTRL_INTERNAL_STATIC_GR_GET_FECS_RECORD_SIZE_PARAMS_MESSAGE_ID = (0x3C) # macro
NV2080_CTRL_CMD_INTERNAL_STATIC_KGR_GET_FECS_RECORD_SIZE_PARAMS_MESSAGE_ID = (0x3D) # macro
NV2080_CTRL_INTERNAL_STATIC_GR_GET_FECS_TRACE_DEFINES_PARAMS_MESSAGE_ID = (0x3E) # macro
NV2080_CTRL_CMD_INTERNAL_STATIC_KGR_GET_FECS_TRACE_DEFINES = (0x20800a3f) # macro
NV2080_CTRL_INTERNAL_STATIC_KGR_GET_FECS_TRACE_DEFINES_PARAMS_MESSAGE_ID = (0x3F) # macro
NV2080_CTRL_CMD_INTERNAL_DEVICE_INFO_MAX_ENTRIES = 256 # macro
NV2080_CTRL_CMD_INTERNAL_GET_DEVICE_INFO_TABLE = (0x20800a40) # macro
NV2080_CTRL_INTERNAL_GET_DEVICE_INFO_TABLE_PARAMS_MESSAGE_ID = (0x40) # macro
NV2080_CTRL_CMD_INTERNAL_GPU_GET_USER_REGISTER_ACCESS_MAP = (0x20800a41) # macro
NV2080_CTRL_INTERNAL_GPU_USER_REGISTER_ACCESS_MAP_MAX_COMPRESSED_SIZE = 4096 # macro
NV2080_CTRL_INTERNAL_GPU_USER_REGISTER_ACCESS_MAP_MAX_PROFILING_RANGES = 4096 # macro
NV2080_CTRL_INTERNAL_GPU_GET_USER_REGISTER_ACCESS_MAP_PARAMS_MESSAGE_ID = (0x41) # macro
NV2080_CTRL_INTERNAL_MIGMGR_PROMOTE_GPU_INSTANCE_MEM_RANGE_PARAMS_MESSAGE_ID = (0x43) # macro
NV2080_CTRL_CMD_INTERNAL_KMIGMGR_PROMOTE_GPU_INSTANCE_MEM_RANGE = (0x20800a44) # macro
NV2080_CTRL_INTERNAL_KMIGMGR_PROMOTE_GPU_INSTANCE_MEM_RANGE_PARAMS_MESSAGE_ID = (0x44) # macro
NV2080_CTRL_CMD_INTERNAL_MIGMGR_PROMOTE_GPU_INSTANCE_MEM_RANGE = (0x20800a43) # macro
NV2080_CTRL_INTERNAL_STATIC_GR_GET_PDB_PROPERTIES_PARAMS_MESSAGE_ID = (0x47) # macro
NV2080_CTRL_CMD_INTERNAL_STATIC_KGR_GET_PDB_PROPERTIES = (0x20800a48) # macro
NV2080_CTRL_INTERNAL_STATIC_KGR_GET_PDB_PROPERTIES_PARAMS_MESSAGE_ID = (0x48) # macro
NV2080_CTRL_CMD_INTERNAL_DISPLAY_WRITE_INST_MEM = (0x20800a49) # macro
NV2080_CTRL_INTERNAL_DISPLAY_WRITE_INST_MEM_PARAMS_MESSAGE_ID = (0x49) # macro
NV2080_CTRL_CMD_INTERNAL_RECOVER_ALL_COMPUTE_CONTEXTS = (0x20800a4a) # macro
NV2080_CTRL_CMD_INTERNAL_DISPLAY_GET_IP_VERSION = (0x20800a4b) # macro
NV2080_CTRL_INTERNAL_DISPLAY_GET_IP_VERSION_PARAMS_MESSAGE_ID = (0x4B) # macro
NV2080_CTRL_CMD_INTERNAL_GPU_GET_SMC_MODE = (0x20800a4c) # macro
NV2080_CTRL_INTERNAL_GPU_GET_SMC_MODE_PARAMS_MESSAGE_ID = (0x4C) # macro
NV2080_CTRL_CMD_INTERNAL_DISPLAY_SETUP_RG_LINE_INTR = (0x20800a4d) # macro
NV2080_CTRL_INTERNAL_DISPLAY_SETUP_RG_LINE_INTR_PARAMS_MESSAGE_ID = (0x4D) # macro
NV2080_CTRL_INTERNAL_GRMGR_PARTITION_MAX_TYPES = 60 # macro
NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_PROFILES_PARAMS_MESSAGE_ID = (0x4F) # macro
NV2080_CTRL_CMD_INTERNAL_MEMSYS_SET_PARTITIONABLE_MEM = (0x20800a51) # macro
NV2080_CTRL_INTERNAL_MEMSYS_SET_PARTITIONABLE_MEM_PARAMS_MESSAGE_ID = (0x51) # macro
NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_PARTITIONABLE_ENGINES_MAX_ENGINES_MASK_SIZE = 4 # macro
NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_PARTITIONABLE_ENGINES_PARAMS_MESSAGE_ID = (0x52) # macro
NV2080_CTRL_INTERNAL_FIFO_MAX_RUNLIST_BUFFERS = 2 # macro
NV2080_CTRL_INTERNAL_FIFO_MAX_RUNLIST_ID = 64 # macro
NV2080_CTRL_CMD_INTERNAL_FIFO_PROMOTE_RUNLIST_BUFFERS = (0x20800a53) # macro
NV2080_CTRL_INTERNAL_FIFO_PROMOTE_RUNLIST_BUFFERS_PARAMS_MESSAGE_ID = (0x53) # macro
NV2080_CTRL_CMD_INTERNAL_DISPLAY_SET_IMP_INIT_INFO = (0x20800a54) # macro
NV2080_CTRL_INTERNAL_DISPLAY_SET_IMP_INIT_INFO_PARAMS_MESSAGE_ID = (0x54) # macro
NV2080_CTRL_CMD_INTERNAL_GET_EGPU_BRIDGE_INFO = (0x20800a55) # macro
NV2080_CTRL_INTERNAL_GET_EGPU_BRIDGE_INFO_PARAMS_MESSAGE_ID = (0x55) # macro
NV2080_CTRL_INTERNAL_EGPU_BUS_TYPE_NONE = (0x00000000) # macro
NV2080_CTRL_INTERNAL_EGPU_BUS_TYPE_CUSTOM = (0x00000001) # macro
NV2080_CTRL_INTERNAL_EGPU_BUS_TYPE_TB2 = (0x00000002) # macro
NV2080_CTRL_INTERNAL_EGPU_BUS_TYPE_TB3 = (0x00000003) # macro
NV2080_CTRL_CMD_INTERNAL_BUS_FLUSH_WITH_SYSMEMBAR = (0x20800a70) # macro
NV2080_CTRL_CMD_INTERNAL_BUS_SETUP_P2P_MAILBOX_LOCAL = (0x20800a71) # macro
NV2080_CTRL_CMD_INTERNAL_BUS_SETUP_P2P_MAILBOX_LOCAL_PARAMS_MESSAGE_ID = (0x71) # macro
NV2080_CTRL_CMD_INTERNAL_BUS_SETUP_P2P_MAILBOX_REMOTE = (0x20800a72) # macro
NV2080_CTRL_CMD_INTERNAL_BUS_SETUP_P2P_MAILBOX_REMOTE_PARAMS_MESSAGE_ID = (0x72) # macro
NV2080_CTRL_CMD_INTERNAL_BUS_DESTROY_P2P_MAILBOX = (0x20800a73) # macro
NV2080_CTRL_INTERNAL_BUS_DESTROY_P2P_MAILBOX_PARAMS_MESSAGE_ID = (0x73) # macro
NV2080_CTRL_CMD_INTERNAL_BUS_CREATE_C2C_PEER_MAPPING = (0x20800a74) # macro
NV2080_CTRL_INTERNAL_BUS_CREATE_C2C_PEER_MAPPING_PARAMS_MESSAGE_ID = (0x74) # macro
NV2080_CTRL_CMD_INTERNAL_BUS_REMOVE_C2C_PEER_MAPPING = (0x20800a75) # macro
NV2080_CTRL_INTERNAL_BUS_REMOVE_C2C_PEER_MAPPING_PARAMS_MESSAGE_ID = (0x75) # macro
NV2080_CTRL_CMD_INTERNAL_VMMU_GET_SPA_FOR_GPA_ENTRIES = (0x20800a57) # macro
NV2080_CTRL_INTERNAL_VMMU_MAX_SPA_FOR_GPA_ENTRIES = 128 # macro
NV2080_CTRL_INTERNAL_VMMU_GET_SPA_FOR_GPA_ENTRIES_PARAMS_MESSAGE_ID = (0x57) # macro
NV2080_CTRL_CMD_INTERNAL_DISPLAY_CHANNEL_PUSHBUFFER = (0x20800a58) # macro
NV2080_CTRL_INTERNAL_DISPLAY_CHANNEL_PUSHBUFFER_PARAMS_MESSAGE_ID = (0x58) # macro
NV2080_CTRL_CMD_INTERNAL_GMMU_GET_STATIC_INFO = (0x20800a59) # macro
NV2080_CTRL_INTERNAL_GMMU_GET_STATIC_INFO_PARAMS_MESSAGE_ID = (0x59) # macro
NV2080_CTRL_CMD_INTERNAL_GR_GET_CTXSW_MODES = (0x20800a5a) # macro
NV2080_CTRL_INTERNAL_GR_GET_CTXSW_MODES_PARAMS_MESSAGE_ID = (0x5A) # macro
NV2080_CTRL_CMD_INTERNAL_FB_GET_HEAP_RESERVATION_SIZE = (0x20800a5b) # macro
NV2080_CTRL_INTERNAL_FB_GET_HEAP_RESERVATION_SIZE_PARAMS_MESSAGE_ID = (0x5B) # macro
NV2080_CTRL_CMD_INTERNAL_INTR_GET_KERNEL_TABLE = (0x20800a5c) # macro
NV2080_CTRL_INTERNAL_INTR_MAX_TABLE_SIZE = 128 # macro
# NV2080_INTR_INVALID_SUBTREE = NV_U8_MAX # macro
NV2080_CTRL_INTERNAL_INTR_GET_KERNEL_TABLE_PARAMS_MESSAGE_ID = (0x5C) # macro
NV2080_CTRL_INTERNAL_FB_GET_HEAP_RESERVATION_SIZE_GR = (0x00000000) # macro
NV2080_CTRL_CMD_INTERNAL_PERF_PERFMON_CLIENT_RESERVATION_CHECK = (0x20800a98) # macro
NV2080_CTRL_INTERNAL_PERF_PERFMON_CLIENT_RESERVATION_CHECK_PARAMS_MESSAGE_ID = (0x98) # macro
NV2080_CTRL_CMD_INTERNAL_PERF_PERFMON_CLIENT_RESERVATION_SET = (0x20800a99) # macro
NV2080_CTRL_INTERNAL_PERF_PERFMON_CLIENT_RESERVATION_SET_PARAMS_MESSAGE_ID = (0x99) # macro
NV2080_CTRL_CMD_INTERNAL_DISPLAY_GET_ACTIVE_DISPLAY_DEVICES = (0x20800a5d) # macro
NV2080_CTRL_INTERNAL_DISPLAY_GET_ACTIVE_DISPLAY_DEVICES_PARAMS_MESSAGE_ID = (0x5D) # macro
NV2080_CTRL_CMD_INTERNAL_STATIC_MIGMGR_GET_SWIZZ_ID_FB_MEM_PAGE_RANGES = (0x20800a60) # macro
NV2080_CTRL_INTERNAL_MAX_SWIZZ_ID = 15 # macro
NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_SWIZZ_ID_FB_MEM_PAGE_RANGES_PARAMS_MESSAGE_ID = (0x60) # macro
NV2080_CTRL_CMD_INTERNAL_FIFO_GET_NUM_CHANNELS = (0x20800a61) # macro
NV2080_CTRL_INTERNAL_FIFO_GET_NUM_CHANNELS_PARAMS_MESSAGE_ID = (0x61) # macro
NV2080_CTRL_CMD_INTERNAL_STATIC_KMIGMGR_GET_PROFILES = (0x20800a63) # macro
NV2080_CTRL_INTERNAL_STATIC_KMIGMGR_GET_PROFILES_PARAMS_MESSAGE_ID = (0x63) # macro
NV2080_CTRL_CMD_INTERNAL_STATIC_KMIGMGR_GET_PARTITIONABLE_ENGINES = (0x20800a65) # macro
NV2080_CTRL_INTERNAL_STATIC_KMIGMGR_GET_PARTITIONABLE_ENGINES_PARAMS_MESSAGE_ID = (0x65) # macro
NV2080_CTRL_CMD_INTERNAL_STATIC_KMIGMGR_GET_SWIZZ_ID_FB_MEM_PAGE_RANGES = (0x20800a66) # macro
NV2080_CTRL_INTERNAL_STATIC_KMIGMGR_GET_SWIZZ_ID_FB_MEM_PAGE_RANGES_PARAMS_MESSAGE_ID = (0x66) # macro
NV2080_CTRL_CMD_INTERNAL_MEMSYS_GET_MIG_MEMORY_CONFIG = (0x20800a68) # macro
NV2080_CTRL_INTERNAL_MEMSYS_GET_MIG_MEMORY_CONFIG_PARAMS_MESSAGE_ID = (0x68) # macro
NV2080_CTRL_CMD_INTERNAL_KMEMSYS_GET_MIG_MEMORY_CONFIG = (0x20800a67) # macro
NV2080_CTRL_INTERNAL_KMEMSYS_GET_MIG_MEMORY_CONFIG_PARAMS_MESSAGE_ID = (0x67) # macro
NV2080_CTRL_CMD_INTERNAL_MEMSYS_GET_MIG_MEMORY_PARTITION_TABLE = (0x20800a6b) # macro
NV2080_CTRL_INTERNAL_MEMSYS_GET_MIG_MEMORY_PARTITION_TABLE_SIZE = 8 # macro
NV2080_CTRL_INTERNAL_MEMSYS_GET_MIG_MEMORY_PARTITION_TABLE_PARAMS_MESSAGE_ID = (0x6B) # macro
NV2080_CTRL_CMD_INTERNAL_RC_WATCHDOG_TIMEOUT = (0x20800a6a) # macro
NV2080_CTRL_CMD_INTERNAL_PERF_CUDA_LIMIT_DISABLE = (0x20800a7a) # macro
NV2080_CTRL_CMD_INTERNAL_PERF_OPTP_CLI_CLEAR = (0x20800a7c) # macro
NV2080_CTRL_CMD_INTERNAL_PERF_GET_AUX_POWER_STATE = (0x20800a81) # macro
NV2080_CTRL_INTERNAL_PERF_GET_AUX_POWER_STATE_PARAMS_MESSAGE_ID = (0x81) # macro
NV2080_CTRL_CMD_INTERNAL_PERF_BOOST_SET_2X = (0x20800a9a) # macro
NV2080_CTRL_INTERNAL_PERF_BOOST_SET_PARAMS_2X_MESSAGE_ID = (0x9A) # macro
NV2080_CTRL_INTERNAL_PERF_SYNC_GPU_BOOST_LIMITS_PSTATE = 0 # macro
NV2080_CTRL_INTERNAL_PERF_SYNC_GPU_BOOST_LIMITS_GPCCLK = 1 # macro
NV2080_CTRL_INTERNAL_PERF_SYNC_GPU_BOOST_LIMITS_LAST = 1 # macro
NV2080_CTRL_INTERNAL_PERF_SYNC_GPU_BOOST_LIMITS_NUM = (0x2) # macro
NV2080_CTRL_CMD_INTERNAL_PERF_GPU_BOOST_SYNC_SET_CONTROL = (0x20800a7e) # macro
NV2080_CTRL_INTERNAL_PERF_GPU_BOOST_SYNC_CONTROL_PARAMS_MESSAGE_ID = (0x7E) # macro
NV2080_CTRL_CMD_INTERNAL_PERF_GPU_BOOST_SYNC_SET_LIMITS = (0x20800a7f) # macro
NV2080_CTRL_INTERNAL_PERF_GPU_BOOST_SYNC_SET_LIMITS_PARAMS_MESSAGE_ID = (0x7F) # macro
NV2080_CTRL_CMD_INTERNAL_PERF_GPU_BOOST_SYNC_GET_INFO = (0x20800a80) # macro
NV2080_CTRL_INTERNAL_PERF_GPU_BOOST_SYNC_GET_INFO_PARAMS_MESSAGE_ID = (0x80) # macro
NV2080_CTRL_CMD_INTERNAL_GMMU_REGISTER_FAULT_BUFFER = (0x20800a9b) # macro
NV2080_CTRL_INTERNAL_GMMU_FAULT_BUFFER_MAX_PAGES = 256 # macro
NV2080_CTRL_INTERNAL_GMMU_REGISTER_FAULT_BUFFER_PARAMS_MESSAGE_ID = (0x9B) # macro
NV2080_CTRL_CMD_INTERNAL_GMMU_UNREGISTER_FAULT_BUFFER = (0x20800a9c) # macro
NV2080_CTRL_FAULT_BUFFER_NON_REPLAYABLE = (0x00000000) # macro
NV2080_CTRL_FAULT_BUFFER_REPLAYABLE = (0x00000001) # macro
NV2080_CTRL_CMD_INTERNAL_GMMU_REGISTER_CLIENT_SHADOW_FAULT_BUFFER = (0x20800a9d) # macro
NV2080_CTRL_INTERNAL_GMMU_CLIENT_SHADOW_FAULT_BUFFER_MAX_PAGES = 3000 # macro
NV2080_CTRL_INTERNAL_GMMU_REGISTER_CLIENT_SHADOW_FAULT_BUFFER_PARAMS_MESSAGE_ID = (0x9D) # macro
NV2080_CTRL_CMD_INTERNAL_GMMU_UNREGISTER_CLIENT_SHADOW_FAULT_BUFFER = (0x20800a9e) # macro
NV2080_CTRL_INTERNAL_GMMU_UNREGISTER_CLIENT_SHADOW_FAULT_BUFFER_PARAMS_MESSAGE_ID = (0x9E) # macro
NV2080_CTRL_CMD_INTERNAL_GMMU_COPY_RESERVED_SPLIT_GVASPACE_PDES_TO_SERVER = (0x20800a9f) # macro
NV2080_CTRL_INTERNAL_GMMU_COPY_RESERVED_SPLIT_GVASPACE_PDES_TO_SERVER_PARAMS_MESSAGE_ID = (0x9F) # macro
NV2080_CTRL_CMD_INTERNAL_PERF_BOOST_SET_3X = (0x20800aa0) # macro
NV2080_CTRL_INTERNAL_PERF_BOOST_SET_PARAMS_3X_MESSAGE_ID = (0xA0) # macro
NV2080_CTRL_CMD_INTERNAL_PERF_BOOST_CLEAR_3X = (0x20800aa1) # macro
NV2080_CTRL_INTERNAL_PERF_BOOST_CLEAR_PARAMS_3X_MESSAGE_ID = (0xA1) # macro
NV2080_CTRL_CMD_INTERNAL_STATIC_GRMGR_GET_SKYLINE_INFO = (0x20800aa2) # macro
NV2080_CTRL_INTERNAL_GRMGR_SKYLINE_INFO_MAX_SKYLINES = 8 # macro
NV2080_CTRL_INTERNAL_GRMGR_SKYLINE_INFO_MAX_NON_SINGLETON_VGPCS = 12 # macro
NV2080_CTRL_INTERNAL_STATIC_GRMGR_GET_SKYLINE_INFO_PARAMS_MESSAGE_ID = (0xA2) # macro
NV2080_CTRL_CMD_INTERNAL_MIGMGR_SET_PARTITIONING_MODE = (0x20800aa3) # macro
NV2080_CTRL_INTERNAL_MIGMGR_SET_PARTITIONING_MODE_PARAMS_MESSAGE_ID = (0xA3) # macro
NV2080_CTRL_CMD_INTERNAL_MIGMGR_CONFIGURE_GPU_INSTANCE = (0x20800aa4) # macro
NV2080_CTRL_INTERNAL_MIGMGR_CONFIGURE_GPU_INSTANCE_PARAMS_MESSAGE_ID = (0xA4) # macro
NV2080_CTRL_CMD_INTERNAL_MIGMGR_SET_GPU_INSTANCES = (0x20800aa5) # macro
NV2080_CTRL_INTERNAL_MIGMGR_SET_GPU_INSTANCES_PARAMS_MESSAGE_ID = (0xA5) # macro
NV2080_CTRL_CMD_INTERNAL_MIGMGR_GET_GPU_INSTANCES = (0x20800aa6) # macro
NV2080_CTRL_INTERNAL_MIGMGR_GET_GPU_INSTANCES_PARAMS_MESSAGE_ID = (0xA6) # macro
NV2080_CTRL_CMD_INTERNAL_MEMSYS_SET_ZBC_REFERENCED = (0x20800a69) # macro
NV2080_CTRL_INTERNAL_MEMSYS_SET_ZBC_REFERENCED_PARAMS_MESSAGE_ID = (0x69) # macro
NV2080_CTRL_CMD_INTERNAL_KMIGMGR_EXPORT_GPU_INSTANCE = (0x20800aa7) # macro
NV2080_CTRL_CMD_INTERNAL_MIGMGR_EXPORT_GPU_INSTANCE = (0x20800aa8) # macro
NV2080_CTRL_CMD_INTERNAL_KMIGMGR_IMPORT_GPU_INSTANCE = (0x20800aa9) # macro
NV2080_CTRL_CMD_INTERNAL_MIGMGR_IMPORT_GPU_INSTANCE = (0x20800aaa) # macro
NV2080_CTRL_INTERNAL_KMIGMGR_EXPORTED_GPU_INSTANCE_MAX_ENGINES_MASK_SIZE = 4 # macro
NV2080_CTRL_INTERNAL_KMIGMGR_EXPORT_GPU_INSTANCE_PARAMS_MESSAGE_ID = (0xA7) # macro
NV2080_CTRL_INTERNAL_MIGMGR_EXPORT_GPU_INSTANCE_PARAMS_MESSAGE_ID = (0xA8) # macro
NV2080_CTRL_INTERNAL_KMIGMGR_IMPORT_GPU_INSTANCE_PARAMS_MESSAGE_ID = (0xA9) # macro
NV2080_CTRL_INTERNAL_MIGMGR_IMPORT_GPU_INSTANCE_PARAMS_MESSAGE_ID = (0xAA) # macro
NV2080_CTRL_CMD_INTERNAL_MEMSYS_L2_INVALIDATE_EVICT = (0x20800a6c) # macro
NV2080_CTRL_INTERNAL_MEMSYS_L2_INVALIDATE_EVICT_PARAMS_MESSAGE_ID = (0x6c) # macro
NV2080_CTRL_INTERNAL_MEMSYS_L2_INVALIDATE_EVICT_FLAGS_ALL = (0x00000001) # macro
NV2080_CTRL_INTERNAL_MEMSYS_L2_INVALIDATE_EVICT_FLAGS_FIRST = (0x00000002) # macro
NV2080_CTRL_INTERNAL_MEMSYS_L2_INVALIDATE_EVICT_FLAGS_LAST = (0x00000004) # macro
NV2080_CTRL_INTERNAL_MEMSYS_L2_INVALIDATE_EVICT_FLAGS_NORMAL = (0x00000008) # macro
NV2080_CTRL_INTERNAL_MEMSYS_L2_INVALIDATE_EVICT_FLAGS_CLEAN = (0x00000010) # macro
NV2080_CTRL_INTERNAL_MEMSYS_L2_INVALIDATE_EVICT_FLAGS_WAIT_FB_PULL = (0x00000020) # macro
NV2080_CTRL_CMD_INTERNAL_MEMSYS_FLUSH_L2_ALL_RAMS_AND_CACHES = (0x20800a6d) # macro
NV2080_CTRL_CMD_INTERNAL_BIF_GET_STATIC_INFO = (0x20800aac) # macro
NV2080_CTRL_INTERNAL_BIF_GET_STATIC_INFO_PARAMS_MESSAGE_ID = (0xac) # macro
NV2080_CTRL_CMD_INTERNAL_HSHUB_PEER_CONN_CONFIG = (0x20800a88) # macro
NV2080_CTRL_INTERNAL_HSHUB_PEER_CONN_CONFIG_PARAMS_MESSAGE_ID = (0x88) # macro
NV2080_CTRL_CMD_INTERNAL_HSHUB_FIRST_LINK_PEER_ID = (0x20800a89) # macro
NV2080_CTRL_INTERNAL_HSHUB_FIRST_LINK_PEER_ID_INVALID_PEER = 0xffffffff # macro
NV2080_CTRL_INTERNAL_HSHUB_FIRST_LINK_PEER_ID_PARAMS_MESSAGE_ID = (0x89) # macro
NV2080_CTRL_CMD_INTERNAL_HSHUB_GET_HSHUB_ID_FOR_LINKS = (0x20800a8a) # macro
NV2080_CTRL_INTERNAL_HSHUB_GET_HSHUB_ID_FOR_LINKS_TABLE_SIZE = 32 # macro
NV2080_CTRL_INTERNAL_HSHUB_GET_HSHUB_ID_FOR_LINKS_PARAMS_MESSAGE_ID = (0x8a) # macro
NV2080_CTRL_CMD_INTERNAL_HSHUB_GET_NUM_UNITS = (0x20800a8b) # macro
NV2080_CTRL_INTERNAL_HSHUB_GET_NUM_UNITS_PARAMS_MESSAGE_ID = (0x8b) # macro
NV2080_CTRL_CMD_INTERNAL_HSHUB_NEXT_HSHUB_ID = (0x20800a8c) # macro
NV2080_CTRL_INTERNAL_HSHUB_NEXT_HSHUB_ID_PARAMS_MESSAGE_ID = (0x8c) # macro
NV2080_CTRL_CMD_INTERNAL_HSHUB_EGM_CONFIG = (0x20800a8d) # macro
NV2080_CTRL_INTERNAL_HSHUB_EGM_CONFIG_PARAMS_MESSAGE_ID = (0x8d) # macro
NV2080_CTRL_CMD_INTERNAL_NVLINK_ENABLE_COMPUTE_PEER_ADDR = (0x20800aad) # macro
NV2080_CTRL_INTERNAL_NVLINK_GET_SET_NVSWITCH_FABRIC_ADDR_PARAMS_MESSAGE_ID = (0xae) # macro
NV2080_CTRL_CMD_INTERNAL_NVLINK_GET_SET_NVSWITCH_FABRIC_ADDR = (0x20800aae) # macro
NV2080_CTRL_CMD_INTERNAL_BIF_GET_ASPM_L1_FLAGS = (0x20800ab0) # macro
NV2080_CTRL_INTERNAL_BIF_GET_ASPM_L1_FLAGS_PARAMS_MESSAGE_ID = (0xb0) # macro
NV2080_CTRL_CMD_INTERNAL_PERF_CF_CONTROLLERS_SET_MAX_VGPU_VM_COUNT = (0x20800ab1) # macro
NV2080_CTRL_CMD_INTERNAL_PERF_CF_CONTROLLERS_MAX_ACTIVE_VGPU_VM_COUNT_MAX_VALUE = 32 # macro
NV2080_CTRL_INTERNAL_PERF_CF_CONTROLLERS_SET_MAX_VGPU_VM_COUNT_PARAMS_MESSAGE_ID = (0xB1) # macro
NV2080_CTRL_CMD_INTERNAL_MEMSYS_DISABLE_NVLINK_PEERS = (0x20800a6e) # macro
NV2080_CTRL_CMD_INTERNAL_MEMSYS_PROGRAM_RAW_COMPRESSION_MODE = (0x20800a6f) # macro
NV2080_CTRL_INTERNAL_MEMSYS_PROGRAM_RAW_COMPRESSION_MODE_PARAMS_MESSAGE_ID = (0x6f) # macro
NV2080_CTRL_CMD_INTERNAL_CCU_MAP = (0x20800ab3) # macro
NV2080_CTRL_INTERNAL_CCU_DEV_SHRBUF_COUNT_MAX = 1 # macro
NV2080_CTRL_INTERNAL_CCU_MAP_INFO_PARAMS_MESSAGE_ID = (0xB3) # macro
NV2080_CTRL_CMD_INTERNAL_CCU_UNMAP = (0x20800ab4) # macro
NV2080_CTRL_INTERNAL_CCU_UNMAP_INFO_PARAMS_MESSAGE_ID = (0xB4) # macro
NV2080_CTRL_CMD_INTERNAL_SET_P2P_CAPS = (0x20800ab5) # macro
NV2080_CTRL_INTERNAL_SET_P2P_CAPS_PARAMS_MESSAGE_ID = (0xB5) # macro
NV2080_CTRL_CMD_INTERNAL_REMOVE_P2P_CAPS = (0x20800ab6) # macro
NV2080_CTRL_INTERNAL_REMOVE_P2P_CAPS_PARAMS_MESSAGE_ID = (0xB6) # macro
NV2080_CTRL_CMD_INTERNAL_GET_PCIE_P2P_CAPS = (0x20800ab8) # macro
NV2080_CTRL_INTERNAL_GET_PCIE_P2P_CAPS_PARAMS_MESSAGE_ID = (0xB8) # macro
NV2080_CTRL_CMD_INTERNAL_BIF_SET_PCIE_RO = (0x20800ab9) # macro
NV2080_CTRL_INTERNAL_BIF_SET_PCIE_RO_PARAMS_MESSAGE_ID = (0xB9) # macro
NV2080_CTRL_CMD_INTERNAL_DISPLAY_PRE_UNIX_CONSOLE = (0x20800a76) # macro
NV2080_CTRL_CMD_INTERNAL_DISPLAY_PRE_UNIX_CONSOLE_PARAMS_MESSAGE_ID = (0x76) # macro
NV2080_CTRL_CMD_INTERNAL_DISPLAY_POST_UNIX_CONSOLE = (0x20800a77) # macro
NV2080_CTRL_CMD_INTERNAL_DISPLAY_POST_UNIX_CONSOLE_PARAMS_MESSAGE_ID = (0x77) # macro
NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_COMPUTE_PROFILES_PARAMS_MESSAGE_ID = (0xBB) # macro
NV2080_CTRL_CMD_INTERNAL_STATIC_KMIGMGR_GET_COMPUTE_PROFILES = (0x20800aba) # macro
NV2080_CTRL_INTERNAL_STATIC_KMIGMGR_GET_COMPUTE_PROFILES_PARAMS_MESSAGE_ID = (0xBA) # macro
NV2080_CTRL_CMD_INTERNAL_CCU_SET_STREAM_STATE = (0x20800abd) # macro
NV2080_CTRL_INTERNAL_CCU_STREAM_STATE_PARAMS_MESSAGE_ID = (0xBD) # macro
NV2080_CTRL_CMD_INTERNAL_GSYNC_ATTACH_AND_INIT = (0x20800abe) # macro
NV2080_CTRL_INTERNAL_GSYNC_ATTACH_AND_INIT_PARAMS_MESSAGE_ID = (0xBE) # macro
NV2080_CTRL_CMD_INTERNAL_GSYNC_OPTIMIZE_TIMING_PARAMETERS = (0x20800abf) # macro
NV2080_CTRL_INTERNAL_GSYNC_OPTIMIZE_TIMING_PARAMETERS_PARAMS_MESSAGE_ID = (0xBF) # macro
NV2080_CTRL_CMD_INTERNAL_GSYNC_GET_DISPLAY_IDS = (0x20800ac0) # macro
NV2080_MAX_NUM_HEADS = 4 # macro
NV2080_CTRL_INTERNAL_GSYNC_GET_DISPLAY_IDS_PARAMS_MESSAGE_ID = (0xC0) # macro
NV2080_CTRL_CMD_INTERNAL_GSYNC_SET_STREO_SYNC = (0x20800ac1) # macro
NV2080_CTRL_INTERNAL_GSYNC_SET_STREO_SYNC_PARAMS_MESSAGE_ID = (0xC1) # macro
NV2080_CTRL_CMD_INTERNAL_GSYNC_GET_VERTICAL_ACTIVE_LINES = (0x20800ac4) # macro
NV2080_CTRL_INTERNAL_GSYNC_GET_VERTICAL_ACTIVE_LINES_PARAMS_MESSAGE_ID = (0xC4) # macro
NV2080_CTRL_CMD_INTERNAL_GSYNC_IS_DISPLAYID_VALID = (0x20800ac9) # macro
NV2080_CTRL_INTERNAL_GSYNC_IS_DISPLAYID_VALID_PARAMS_MESSAGE_ID = (0xC9) # macro
NV2080_CTRL_CMD_INTERNAL_GSYNC_SET_OR_RESTORE_RASTER_SYNC = (0x20800aca) # macro
NV2080_CTRL_INTERNAL_GSYNC_SET_OR_RESTORE_RASTER_SYNC_PARAMS_MESSAGE_ID = (0xCA) # macro
NV2080_CTRL_CMD_INTERNAL_FBSR_INIT = (0x20800ac2) # macro
NV2080_CTRL_INTERNAL_FBSR_INIT_PARAMS_MESSAGE_ID = (0xC2) # macro
NV2080_CTRL_CMD_INTERNAL_FBSR_SEND_REGION_INFO = (0x20800ac3) # macro
NV2080_CTRL_INTERNAL_FBSR_SEND_REGION_INFO_PARAMS_MESSAGE_ID = (0xC3) # macro
NV2080_CTRL_CMD_INTERNAL_MEMMGR_GET_VGPU_CONFIG_HOST_RESERVED_FB = (0x20800ac5) # macro
NV2080_CTRL_INTERNAL_MEMMGR_GET_VGPU_CONFIG_HOST_RESERVED_FB_PARAMS_MESSAGE_ID = (0xC5) # macro
NV2080_CTRL_CMD_INTERNAL_INIT_BRIGHTC_STATE_LOAD = (0x20800ac6) # macro
NV2080_CTRL_ACPI_DSM_READ_SIZE = (0x1000) # macro
NV2080_CTRL_INTERNAL_INIT_BRIGHTC_STATE_LOAD_PARAMS_MESSAGE_ID = (0xC6) # macro
NV2080_CTRL_INTERNAL_NVLINK_GET_NUM_ACTIVE_LINK_PER_IOCTRL_PARAMS_MESSAGE_ID = (0xC7) # macro
NV2080_CTRL_INTERNAL_NVLINK_GET_NUM_ACTIVE_LINK_PER_IOCTRL = (0x20800ac7) # macro
NV2080_CTRL_INTERNAL_NVLINK_GET_TOTAL_NUM_LINK_PER_IOCTRL_PARAMS_MESSAGE_ID = (0xC8) # macro
NV2080_CTRL_INTERNAL_NVLINK_GET_TOTAL_NUM_LINK_PER_IOCTRL = (0x20800ac8) # macro
NV2080_CTRL_CMD_INTERNAL_SMBPBI_PFM_REQ_HNDLR_CAP_UPDATE = (0x20800acb) # macro
NV2080_CTRL_INTERNAL_SMBPBI_PFM_REQ_HNDLR_CAP_UPDATE_PARAMS_MESSAGE_ID = (0xCB) # macro
NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_DATA_TYPE_PMGR = 0x00 # macro
NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_DATA_TYPE_THERM = 0x01 # macro
NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_DATA_TYPE_SMBPBI = 0x02 # macro
NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_FLAGS_PMGR_LOAD = 0x00 # macro
NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_FLAGS_THERM_INIT = 0x01 # macro
NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_FLAGS_SMBPBI_OP_CLEAR = 0x02 # macro
NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_FLAGS_SMBPBI_OP_SET = 0x03 # macro
NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_STATE_LOAD_SYNC = (0x20800acc) # macro
NV2080_CTRL_INTERNAL_PMGR_PFM_REQ_HNDLR_STATE_LOAD_SYNC_PARAMS_MESSAGE_ID = (0xCC) # macro
NV2080_CTRL_CMD_INTERNAL_THERM_PFM_REQ_HNDLR_STATE_INIT_SYNC = (0x20800acd) # macro
NV2080_CTRL_INTERNAL_THERM_PFM_REQ_HNDLR_STATE_INIT_SYNC_PARAMS_MESSAGE_ID = (0xCD) # macro
NV2080_CTRL_CMD_INTERNAL_GET_COHERENT_FB_APERTURE_SIZE = (0x20800ada) # macro
NV2080_CTRL_INTERNAL_GET_COHERENT_FB_APERTURE_SIZE_PARAMS_MESSAGE_ID = (0xDA) # macro
NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_GET_PM1_FORCED_OFF_STATUS = 0x00 # macro
NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_GET_PM1_STATUS = 0x01 # macro
NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_GET_PM1_STATE = (0x20800ace) # macro
NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_GET_PM1_STATE_PARAMS_MESSAGE_ID = (0xCE) # macro
NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_SET_PM1_STATE = (0x20800acf) # macro
NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_SET_PM1_STATE_PARAMS_MESSAGE_ID = (0xCF) # macro
NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_UPDATE_EDPP_LIMIT = (0x20800ad0) # macro
NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_UPDATE_EDPP_LIMIT_PARAMS_MESSAGE_ID = (0xD0) # macro
NV2080_CTRL_CMD_INTERNAL_THERM_PFM_REQ_HNDLR_UPDATE_TGPU_LIMIT = (0x20800ad1) # macro
NV2080_CTRL_CMD_INTERNAL_THERM_PFM_REQ_HNDLR_UPDATE_TGPU_LIMIT_PARAMS_MESSAGE_ID = (0xD1) # macro
NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_CONFIGURE_TGP_MODE = (0x20800ad2) # macro
NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_CONFIGURE_TGP_MODE_PARAMS_MESSAGE_ID = (0xD2) # macro
NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_CONFIGURE_TURBO_V2 = (0x20800ad3) # macro
NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_CONFIGURE_TURBO_V2_PARAMS_MESSAGE_ID = (0xD3) # macro
NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_GET_VPSTATE_INFO = (0x20800ad4) # macro
NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_GET_VPSTATE_INFO_PARAMS_MESSAGE_ID = (0xD4) # macro
NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_GET_VPSTATE_MAPPING = (0x20800ad5) # macro
NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_GET_VPSTATE_MAPPING_PARAMS_MESSAGE_ID = (0xD5) # macro
NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_SET_VPSTATE = (0x20800ad6) # macro
NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_SET_VPSTATE_PARAMS_MESSAGE_ID = (0xD6) # macro
NV2080_CTRL_CMD_INTERNAL_GCX_ENTRY_PREREQUISITE = (0x2080a7d7) # macro
NV2080_CTRL_INTERNAL_GCX_ENTRY_PREREQUISITE_PARAMS_MESSAGE_ID = (0xD7) # macro
NV2080_CTRL_CMD_INTERNAL_PMGR_UNSET_DYNAMIC_BOOST_LIMIT = (0x20800a7b) # macro
NV2080_CTRL_CMD_INTERNAL_FIFO_GET_NUM_SECURE_CHANNELS = (0x20800ad8) # macro
NV2080_CTRL_INTERNAL_FIFO_GET_NUM_SECURE_CHANNELS_PARAMS_MESSAGE_ID = (0xD8) # macro
NV2080_CTRL_CMD_INTERNAL_BIF_DISABLE_SYSTEM_MEMORY_ACCESS = (0x20800adb) # macro
NV2080_CTRL_INTERNAL_BIF_DISABLE_SYSTEM_MEMORY_ACCESS_PARAMS_MESSAGE_ID = (0xDB) # macro
NV2080_CTRL_CMD_INTERNAL_DISP_PINSETS_TO_LOCKPINS = (0x20800adc) # macro
NV2080_CTRL_INTERNAL_DISP_PINSETS_TO_LOCKPINS_PARAMS_MESSAGE_ID = (0xDC) # macro
NV2080_CTRL_CMD_INTERNAL_DETECT_HS_VIDEO_BRIDGE = (0x20800add) # macro
NV2080_CTRL_CMD_INTERNAL_DISP_SET_SLI_LINK_GPIO_SW_CONTROL = (0x20800ade) # macro
NV2080_CTRL_INTERNAL_DISP_SET_SLI_LINK_GPIO_SW_CONTROL_PARAMS_MESSAGE_ID = (0xDE) # macro
NV2080_CTRL_CMD_INTERNAL_SET_STATIC_EDID_DATA = (0x20800adf) # macro
MAX_EDID_SIZE_FROM_SBIOS = 512 # macro
NV2080_CTRL_CMD_INTERNAL_SET_STATIC_EDID_DATA_PARAMS_MESSAGE_ID = (0xDF) # macro
NV2080_CTRL_CMD_INTERNAL_DISPLAY_ACPI_SUBSYSTEM_ACTIVATED = (0x20800af0) # macro
NV2080_CTRL_CMD_INTERNAL_DISPLAY_PRE_MODESET = (0x20800af1) # macro
NV2080_CTRL_CMD_INTERNAL_DISPLAY_POST_MODESET = (0x20800af2) # macro
NV2080_CTRL_CMD_INTERNAL_GET_GPU_FABRIC_PROBE_INFO_PARAMS_MESSAGE_ID = (0xF4) # macro
NV2080_CTRL_CMD_INTERNAL_GPU_GET_FABRIC_PROBE_INFO = (0x208001f4) # macro
NV2080_CTRL_CMD_INTERNAL_START_GPU_FABRIC_PROBE_INFO_PARAMS_MESSAGE_ID = (0xF5) # macro
NV2080_CTRL_CMD_INTERNAL_GPU_START_FABRIC_PROBE = (0x208001f5) # macro
NV2080_CTRL_CMD_INTERNAL_GPU_STOP_FABRIC_PROBE = (0x208001f6) # macro
NV2080_CTRL_CMD_INTERNAL_GPU_SUSPEND_FABRIC_PROBE = (0x208001f7) # macro
NV2080_CTRL_CMD_INTERNAL_RESUME_GPU_FABRIC_PROBE_INFO_PARAMS_MESSAGE_ID = (0xF8) # macro
NV2080_CTRL_CMD_INTERNAL_GPU_RESUME_FABRIC_PROBE = (0x208001f8) # macro
NV2080_CTRL_CMD_INTERNAL_GPU_INVALIDATE_FABRIC_PROBE = (0x208001f9) # macro
NV2080_CTRL_CMD_INTERNAL_CONF_COMPUTE_GET_STATIC_INFO = (0x20800af3) # macro
NV2080_CTRL_INTERNAL_CONF_COMPUTE_GET_STATIC_INFO_PARAMS_MESSAGE_ID = (0xF3) # macro
NV2080_CTRL_CMD_INTERNAL_CONF_COMPUTE_DERIVE_SWL_KEYS = (0x20800ae1) # macro
NV2080_CTRL_INTERNAL_CONF_COMPUTE_IVMASK_SIZE = 3 # macro
NV2080_CTRL_INTERNAL_CONF_COMPUTE_IVMASK_SWL_KERNEL = 0 # macro
NV2080_CTRL_INTERNAL_CONF_COMPUTE_IVMASK_SWL_USER = 1 # macro
NV2080_CTRL_INTERNAL_CONF_COMPUTE_IVMASK_SWL_COUNT = 2 # macro
NV2080_CTRL_INTERNAL_CONF_COMPUTE_IVMASK_LCE_COUNT = 6 # macro
NV2080_CTRL_INTERNAL_CONF_COMPUTE_DERIVE_SWL_KEYS_PARAMS_MESSAGE_ID = (0xE1) # macro
NV2080_CTRL_CMD_INTERNAL_CONF_COMPUTE_DERIVE_LCE_KEYS = (0x20800ae2) # macro
NV2080_CTRL_INTERNAL_CONF_COMPUTE_DERIVE_LCE_KEYS_PARAMS_MESSAGE_ID = (0xE2) # macro
NV2080_CTRL_CMD_INTERNAL_CONF_COMPUTE_SET_GPU_STATE = (0x20800ae7) # macro
NV2080_CTRL_CMD_INTERNAL_CONF_COMPUTE_SET_GPU_STATE_PARAMS_MESSAGE_ID = (0xE7) # macro
NV2080_CTRL_CMD_INTERNAL_MEMMGR_MEMORY_TRANSFER_WITH_GSP = (0x20800afa) # macro
CC_AES_256_GCM_AUTH_TAG_SIZE_BYTES = (0x10) # macro
NV2080_CTRL_INTERNAL_MEMMGR_MEMORY_TRANSFER_WITH_GSP_PARAMS_MESSAGE_ID = (0xFA) # macro
NV2080_CTRL_CMD_INTERNAL_MEMSYS_GET_LOCAL_ATS_CONFIG = (0x20800afb) # macro
NV2080_CTRL_INTERNAL_MEMSYS_GET_LOCAL_ATS_CONFIG_PARAMS_MESSAGE_ID = (0xFB) # macro
NV2080_CTRL_CMD_INTERNAL_MEMSYS_SET_PEER_ATS_CONFIG = (0x20800afc) # macro
NV2080_CTRL_INTERNAL_MEMSYS_SET_PEER_ATS_CONFIG_PARAMS_MESSAGE_ID = (0xFC) # macro
NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_GET_EDPP_LIMIT_INFO = (0x20800afd) # macro
NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_GET_EDPP_LIMIT_INFO_PARAMS_MESSAGE_ID = (0xFD) # macro
NV2080_CTRL_INTERNAL_INIT_USER_SHARED_DATA_PARAMS_MESSAGE_ID = (0xFE) # macro
NV2080_CTRL_CMD_INTERNAL_INIT_USER_SHARED_DATA = (0x20800afe) # macro
NV2080_CTRL_INTERNAL_USER_SHARED_DATA_SET_DATA_POLL_PARAMS_MESSAGE_ID = (0xFF) # macro
NV2080_CTRL_CMD_INTERNAL_USER_SHARED_DATA_SET_DATA_POLL = (0x20800aff) # macro
NV2080_CTRL_CMD_INTERNAL_GSP_START_TRACE_INFO_PARAMS_MESSAGE_ID = (0xE3) # macro
NV2080_CTRL_CMD_INTERNAL_GSP_START_TRACE = (0x208001e3) # macro
NV2080_CTRL_CMD_INTERNAL_GET_ENABLED_SEC2_CLASSES_PARAMS_MESSAGE_ID = (0xAF) # macro
NV2080_CTRL_CMD_INTERNAL_GET_ENABLED_SEC2_CLASSES = (0x20800aaf) # macro
NV2080_CTRL_CMD_INTERNAL_GR_CTXSW_SETUP_BIND = (0x20800ae4) # macro
NV2080_CTRL_INTERNAL_GR_CTXSW_SETUP_BIND_PARAMS_MESSAGE_ID = (0xE4) # macro
class struct_NV2080_CTRL_INTERNAL_DISPLAY_GET_STATIC_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_DISPLAY_GET_STATIC_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_DISPLAY_GET_STATIC_INFO_PARAMS._fields_ = [
    ('feHwSysCap', ctypes.c_uint32),
    ('windowPresentMask', ctypes.c_uint32),
    ('bFbRemapperEnabled', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('numHeads', ctypes.c_uint32),
    ('bPrimaryVga', ctypes.c_ubyte),
    ('PADDING_1', ctypes.c_ubyte * 3),
    ('i2cPort', ctypes.c_uint32),
    ('internalDispActiveMask', ctypes.c_uint32),
    ('embeddedDisplayPortMask', ctypes.c_uint32),
    ('bExternalMuxSupported', ctypes.c_ubyte),
    ('bInternalMuxSupported', ctypes.c_ubyte),
    ('PADDING_2', ctypes.c_ubyte * 2),
]

NV2080_CTRL_INTERNAL_DISPLAY_GET_STATIC_INFO_PARAMS = struct_NV2080_CTRL_INTERNAL_DISPLAY_GET_STATIC_INFO_PARAMS
class struct_NV2080_CTRL_INTERNAL_MEMSYS_GET_STATIC_CONFIG_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_MEMSYS_GET_STATIC_CONFIG_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_MEMSYS_GET_STATIC_CONFIG_PARAMS._fields_ = [
    ('bOneToOneComptagLineAllocation', ctypes.c_ubyte),
    ('bUseOneToFourComptagLineAllocation', ctypes.c_ubyte),
    ('bUseRawModeComptaglineAllocation', ctypes.c_ubyte),
    ('bDisableCompbitBacking', ctypes.c_ubyte),
    ('bDisablePostL2Compression', ctypes.c_ubyte),
    ('bEnabledEccFBPA', ctypes.c_ubyte),
    ('bL2PreFill', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte),
    ('l2CacheSize', ctypes.c_uint64),
    ('bFbpaPresent', ctypes.c_ubyte),
    ('PADDING_1', ctypes.c_ubyte * 3),
    ('comprPageSize', ctypes.c_uint32),
    ('comprPageShift', ctypes.c_uint32),
    ('ramType', ctypes.c_uint32),
    ('ltcCount', ctypes.c_uint32),
    ('ltsPerLtcCount', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_MEMSYS_GET_STATIC_CONFIG_PARAMS = struct_NV2080_CTRL_INTERNAL_MEMSYS_GET_STATIC_CONFIG_PARAMS
class struct_NV2080_CTRL_INTERNAL_UVM_REGISTER_ACCESS_CNTR_BUFFER_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_UVM_REGISTER_ACCESS_CNTR_BUFFER_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_UVM_REGISTER_ACCESS_CNTR_BUFFER_PARAMS._fields_ = [
    ('accessCounterIndex', ctypes.c_uint32),
    ('bufferSize', ctypes.c_uint32),
    ('bufferPteArray', ctypes.c_uint64 * 64),
]

NV2080_CTRL_INTERNAL_UVM_REGISTER_ACCESS_CNTR_BUFFER_PARAMS = struct_NV2080_CTRL_INTERNAL_UVM_REGISTER_ACCESS_CNTR_BUFFER_PARAMS
class struct_NV2080_CTRL_INTERNAL_UVM_UNREGISTER_ACCESS_CNTR_BUFFER_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_UVM_UNREGISTER_ACCESS_CNTR_BUFFER_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_UVM_UNREGISTER_ACCESS_CNTR_BUFFER_PARAMS._fields_ = [
    ('accessCounterIndex', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_UVM_UNREGISTER_ACCESS_CNTR_BUFFER_PARAMS = struct_NV2080_CTRL_INTERNAL_UVM_UNREGISTER_ACCESS_CNTR_BUFFER_PARAMS
class struct_NV2080_CTRL_INTERNAL_STATIC_GR_CAPS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_STATIC_GR_CAPS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_STATIC_GR_CAPS._fields_ = [
    ('capsTbl', ctypes.c_ubyte * 23),
]

NV2080_CTRL_INTERNAL_STATIC_GR_CAPS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_CAPS
class struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_CAPS_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('engineCaps', struct_NV2080_CTRL_INTERNAL_STATIC_GR_CAPS * 8),
     ]

NV2080_CTRL_INTERNAL_STATIC_GR_GET_CAPS_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_CAPS_PARAMS
NV2080_CTRL_INTERNAL_STATIC_KGR_GET_CAPS_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_CAPS_PARAMS
class struct_NV2080_CTRL_INTERNAL_FLCN_SET_VIDEO_EVENT_BUFFER_FLAGS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_FLCN_SET_VIDEO_EVENT_BUFFER_FLAGS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_FLCN_SET_VIDEO_EVENT_BUFFER_FLAGS_PARAMS._fields_ = [
    ('flags', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_FLCN_SET_VIDEO_EVENT_BUFFER_FLAGS_PARAMS = struct_NV2080_CTRL_INTERNAL_FLCN_SET_VIDEO_EVENT_BUFFER_FLAGS_PARAMS
class struct_NV2080_CTRL_INTERNAL_STATIC_GR_GLOBAL_SM_ORDER(Structure):
    pass

class struct_NV2080_CTRL_INTERNAL_STATIC_GR_GLOBAL_SM_ORDER_0(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_STATIC_GR_GLOBAL_SM_ORDER_0._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_STATIC_GR_GLOBAL_SM_ORDER_0._fields_ = [
    ('gpcId', ctypes.c_uint16),
    ('localTpcId', ctypes.c_uint16),
    ('localSmId', ctypes.c_uint16),
    ('globalTpcId', ctypes.c_uint16),
    ('virtualGpcId', ctypes.c_uint16),
    ('migratableTpcId', ctypes.c_uint16),
]

struct_NV2080_CTRL_INTERNAL_STATIC_GR_GLOBAL_SM_ORDER._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_STATIC_GR_GLOBAL_SM_ORDER._fields_ = [
    ('globalSmId', struct_NV2080_CTRL_INTERNAL_STATIC_GR_GLOBAL_SM_ORDER_0 * 240),
    ('numSm', ctypes.c_uint16),
    ('numTpc', ctypes.c_uint16),
]

NV2080_CTRL_INTERNAL_STATIC_GR_GLOBAL_SM_ORDER = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GLOBAL_SM_ORDER
class struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_GLOBAL_SM_ORDER_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('globalSmOrder', struct_NV2080_CTRL_INTERNAL_STATIC_GR_GLOBAL_SM_ORDER * 8),
     ]

NV2080_CTRL_INTERNAL_STATIC_GR_GET_GLOBAL_SM_ORDER_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_GLOBAL_SM_ORDER_PARAMS
NV2080_CTRL_INTERNAL_STATIC_KGR_GET_GLOBAL_SM_ORDER_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_GLOBAL_SM_ORDER_PARAMS
class struct_NV2080_CTRL_INTERNAL_BSP_CAPS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_BSP_CAPS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_BSP_CAPS._fields_ = [
    ('capsTbl', ctypes.c_ubyte * 8),
]

NV2080_CTRL_INTERNAL_BSP_CAPS = struct_NV2080_CTRL_INTERNAL_BSP_CAPS
class struct_NV2080_CTRL_INTERNAL_BSP_GET_CAPS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_BSP_GET_CAPS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_BSP_GET_CAPS_PARAMS._fields_ = [
    ('caps', struct_NV2080_CTRL_INTERNAL_BSP_CAPS * 8),
    ('valid', ctypes.c_ubyte * 8),
]

NV2080_CTRL_INTERNAL_BSP_GET_CAPS_PARAMS = struct_NV2080_CTRL_INTERNAL_BSP_GET_CAPS_PARAMS
class struct_NV2080_CTRL_INTERNAL_MSENC_CAPS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_MSENC_CAPS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_MSENC_CAPS._fields_ = [
    ('capsTbl', ctypes.c_ubyte * 4),
]

NV2080_CTRL_INTERNAL_MSENC_CAPS = struct_NV2080_CTRL_INTERNAL_MSENC_CAPS
class struct_NV2080_CTRL_INTERNAL_MSENC_GET_CAPS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_MSENC_GET_CAPS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_MSENC_GET_CAPS_PARAMS._fields_ = [
    ('caps', struct_NV2080_CTRL_INTERNAL_MSENC_CAPS * 8),
    ('valid', ctypes.c_ubyte * 8),
]

NV2080_CTRL_INTERNAL_MSENC_GET_CAPS_PARAMS = struct_NV2080_CTRL_INTERNAL_MSENC_GET_CAPS_PARAMS
class struct_NV2080_CTRL_INTERNAL_STATIC_GR_FLOORSWEEPING_MASKS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_STATIC_GR_FLOORSWEEPING_MASKS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_STATIC_GR_FLOORSWEEPING_MASKS._fields_ = [
    ('gpcMask', ctypes.c_uint32),
    ('tpcMask', ctypes.c_uint32 * 12),
    ('tpcCount', ctypes.c_uint32 * 12),
    ('physGpcMask', ctypes.c_uint32),
    ('mmuPerGpc', ctypes.c_uint32 * 12),
    ('tpcToPesMap', ctypes.c_uint32 * 10),
    ('numPesPerGpc', ctypes.c_uint32 * 12),
    ('zcullMask', ctypes.c_uint32 * 12),
    ('physGfxGpcMask', ctypes.c_uint32),
    ('numGfxTpc', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_STATIC_GR_FLOORSWEEPING_MASKS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_FLOORSWEEPING_MASKS
class struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_FLOORSWEEPING_MASKS_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('floorsweepingMasks', struct_NV2080_CTRL_INTERNAL_STATIC_GR_FLOORSWEEPING_MASKS * 8),
     ]

NV2080_CTRL_INTERNAL_STATIC_GR_GET_FLOORSWEEPING_MASKS_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_FLOORSWEEPING_MASKS_PARAMS
NV2080_CTRL_INTERNAL_STATIC_KGR_GET_FLOORSWEEPING_MASKS_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_FLOORSWEEPING_MASKS_PARAMS
class struct_NV2080_CTRL_KGR_GET_CTX_BUFFER_PTES_PARAMS(Structure):
    pass

struct_NV2080_CTRL_KGR_GET_CTX_BUFFER_PTES_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_KGR_GET_CTX_BUFFER_PTES_PARAMS._fields_ = [
    ('hUserClient', ctypes.c_uint32),
    ('hChannel', ctypes.c_uint32),
    ('bufferType', ctypes.c_uint32),
    ('firstPage', ctypes.c_uint32),
    ('numPages', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('physAddrs', ctypes.c_uint64 * 128),
    ('bNoMorePages', ctypes.c_ubyte),
    ('PADDING_1', ctypes.c_ubyte * 7),
]

NV2080_CTRL_KGR_GET_CTX_BUFFER_PTES_PARAMS = struct_NV2080_CTRL_KGR_GET_CTX_BUFFER_PTES_PARAMS
class struct_NV2080_CTRL_INTERNAL_MEMDESC_INFO(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_MEMDESC_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_MEMDESC_INFO._fields_ = [
    ('base', ctypes.c_uint64),
    ('size', ctypes.c_uint64),
    ('alignment', ctypes.c_uint64),
    ('addressSpace', ctypes.c_uint32),
    ('cpuCacheAttrib', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_MEMDESC_INFO = struct_NV2080_CTRL_INTERNAL_MEMDESC_INFO
class struct_NV2080_CTRL_INTERNAL_FLCN_SET_VIDEO_EVENT_BUFFER_MEMORY_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_FLCN_SET_VIDEO_EVENT_BUFFER_MEMORY_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_FLCN_SET_VIDEO_EVENT_BUFFER_MEMORY_PARAMS._fields_ = [
    ('memDescInfo', NV2080_CTRL_INTERNAL_MEMDESC_INFO),
    ('engDesc', ctypes.c_uint32),
    ('bEngineFound', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_INTERNAL_FLCN_SET_VIDEO_EVENT_BUFFER_MEMORY_PARAMS = struct_NV2080_CTRL_INTERNAL_FLCN_SET_VIDEO_EVENT_BUFFER_MEMORY_PARAMS
class struct_NV2080_CTRL_INTERNAL_GR_INFO(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GR_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GR_INFO._fields_ = [
    ('index', ctypes.c_uint32),
    ('data', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_GR_INFO = struct_NV2080_CTRL_INTERNAL_GR_INFO
class struct_NV2080_CTRL_INTERNAL_STATIC_GR_INFO(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('infoList', struct_NV2080_CTRL_INTERNAL_GR_INFO * 56),
     ]

NV2080_CTRL_INTERNAL_STATIC_GR_INFO = struct_NV2080_CTRL_INTERNAL_STATIC_GR_INFO
class struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_INFO_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('engineInfo', struct_NV2080_CTRL_INTERNAL_STATIC_GR_INFO * 8),
     ]

NV2080_CTRL_INTERNAL_STATIC_GR_GET_INFO_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_INFO_PARAMS
NV2080_CTRL_INTERNAL_STATIC_KGR_GET_INFO_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_INFO_PARAMS
class struct_NV2080_CTRL_INTERNAL_STATIC_GR_ZCULL_INFO(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_STATIC_GR_ZCULL_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_STATIC_GR_ZCULL_INFO._fields_ = [
    ('widthAlignPixels', ctypes.c_uint32),
    ('heightAlignPixels', ctypes.c_uint32),
    ('pixelSquaresByAliquots', ctypes.c_uint32),
    ('aliquotTotal', ctypes.c_uint32),
    ('zcullRegionByteMultiplier', ctypes.c_uint32),
    ('zcullRegionHeaderSize', ctypes.c_uint32),
    ('zcullSubregionHeaderSize', ctypes.c_uint32),
    ('subregionCount', ctypes.c_uint32),
    ('subregionWidthAlignPixels', ctypes.c_uint32),
    ('subregionHeightAlignPixels', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_STATIC_GR_ZCULL_INFO = struct_NV2080_CTRL_INTERNAL_STATIC_GR_ZCULL_INFO
class struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_ZCULL_INFO_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('engineZcullInfo', struct_NV2080_CTRL_INTERNAL_STATIC_GR_ZCULL_INFO * 8),
     ]

NV2080_CTRL_INTERNAL_STATIC_GR_GET_ZCULL_INFO_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_ZCULL_INFO_PARAMS
NV2080_CTRL_INTERNAL_STATIC_KGR_GET_ZCULL_INFO_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_ZCULL_INFO_PARAMS
class struct_NV2080_CTRL_INTERNAL_STATIC_GR_ROP_INFO(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_STATIC_GR_ROP_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_STATIC_GR_ROP_INFO._fields_ = [
    ('ropUnitCount', ctypes.c_uint32),
    ('ropOperationsFactor', ctypes.c_uint32),
    ('ropOperationsCount', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_STATIC_GR_ROP_INFO = struct_NV2080_CTRL_INTERNAL_STATIC_GR_ROP_INFO
class struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_ROP_INFO_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('engineRopInfo', struct_NV2080_CTRL_INTERNAL_STATIC_GR_ROP_INFO * 8),
     ]

NV2080_CTRL_INTERNAL_STATIC_GR_GET_ROP_INFO_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_ROP_INFO_PARAMS
NV2080_CTRL_INTERNAL_STATIC_KGR_GET_ROP_INFO_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_ROP_INFO_PARAMS
class struct_NV2080_CTRL_INTERNAL_STATIC_GR_PPC_MASKS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_STATIC_GR_PPC_MASKS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_STATIC_GR_PPC_MASKS._fields_ = [
    ('mask', ctypes.c_uint32 * 12),
]

NV2080_CTRL_INTERNAL_STATIC_GR_PPC_MASKS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_PPC_MASKS
class struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_PPC_MASKS_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('enginePpcMasks', struct_NV2080_CTRL_INTERNAL_STATIC_GR_PPC_MASKS * 8),
     ]

NV2080_CTRL_INTERNAL_STATIC_GR_GET_PPC_MASKS_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_PPC_MASKS_PARAMS
NV2080_CTRL_INTERNAL_STATIC_KGR_GET_PPC_MASKS_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_PPC_MASKS_PARAMS
class struct_NV2080_CTRL_INTERNAL_ENGINE_CONTEXT_BUFFER_INFO(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_ENGINE_CONTEXT_BUFFER_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_ENGINE_CONTEXT_BUFFER_INFO._fields_ = [
    ('size', ctypes.c_uint32),
    ('alignment', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_ENGINE_CONTEXT_BUFFER_INFO = struct_NV2080_CTRL_INTERNAL_ENGINE_CONTEXT_BUFFER_INFO
class struct_NV2080_CTRL_INTERNAL_STATIC_GR_CONTEXT_BUFFERS_INFO(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('engine', struct_NV2080_CTRL_INTERNAL_ENGINE_CONTEXT_BUFFER_INFO * 26),
     ]

NV2080_CTRL_INTERNAL_STATIC_GR_CONTEXT_BUFFERS_INFO = struct_NV2080_CTRL_INTERNAL_STATIC_GR_CONTEXT_BUFFERS_INFO
class struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_CONTEXT_BUFFERS_INFO_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('engineContextBuffersInfo', struct_NV2080_CTRL_INTERNAL_STATIC_GR_CONTEXT_BUFFERS_INFO * 8),
     ]

NV2080_CTRL_INTERNAL_STATIC_GR_GET_CONTEXT_BUFFERS_INFO_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_CONTEXT_BUFFERS_INFO_PARAMS
NV2080_CTRL_INTERNAL_STATIC_KGR_GET_CONTEXT_BUFFERS_INFO_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_CONTEXT_BUFFERS_INFO_PARAMS
class struct_NV2080_CTRL_INTERNAL_STATIC_GR_SM_ISSUE_RATE_MODIFIER(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_STATIC_GR_SM_ISSUE_RATE_MODIFIER._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_STATIC_GR_SM_ISSUE_RATE_MODIFIER._fields_ = [
    ('imla0', ctypes.c_ubyte),
    ('fmla16', ctypes.c_ubyte),
    ('dp', ctypes.c_ubyte),
    ('fmla32', ctypes.c_ubyte),
    ('ffma', ctypes.c_ubyte),
    ('imla1', ctypes.c_ubyte),
    ('imla2', ctypes.c_ubyte),
    ('imla3', ctypes.c_ubyte),
    ('imla4', ctypes.c_ubyte),
]

NV2080_CTRL_INTERNAL_STATIC_GR_SM_ISSUE_RATE_MODIFIER = struct_NV2080_CTRL_INTERNAL_STATIC_GR_SM_ISSUE_RATE_MODIFIER
class struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_SM_ISSUE_RATE_MODIFIER_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('smIssueRateModifier', struct_NV2080_CTRL_INTERNAL_STATIC_GR_SM_ISSUE_RATE_MODIFIER * 8),
     ]

NV2080_CTRL_INTERNAL_STATIC_GR_GET_SM_ISSUE_RATE_MODIFIER_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_SM_ISSUE_RATE_MODIFIER_PARAMS
NV2080_CTRL_INTERNAL_STATIC_KGR_GET_SM_ISSUE_RATE_MODIFIER_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_SM_ISSUE_RATE_MODIFIER_PARAMS
class struct_NV2080_CTRL_INTERNAL_GPU_GET_CHIP_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GPU_GET_CHIP_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GPU_GET_CHIP_INFO_PARAMS._fields_ = [
    ('chipSubRev', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('emulationRev1', ctypes.c_uint32),
    ('isCmpSku', ctypes.c_ubyte),
    ('PADDING_1', ctypes.c_ubyte * 3),
    ('pciDeviceId', ctypes.c_uint32),
    ('pciSubDeviceId', ctypes.c_uint32),
    ('pciRevisionId', ctypes.c_uint32),
    ('regBases', ctypes.c_uint32 * 16),
]

NV2080_CTRL_INTERNAL_GPU_GET_CHIP_INFO_PARAMS = struct_NV2080_CTRL_INTERNAL_GPU_GET_CHIP_INFO_PARAMS
class struct_NV2080_CTRL_INTERNAL_GR_FECS_TRACE_HW_ENABLE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GR_FECS_TRACE_HW_ENABLE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GR_FECS_TRACE_HW_ENABLE_PARAMS._fields_ = [
    ('grRouteInfo', NV2080_CTRL_GR_ROUTE_INFO),
    ('bEnable', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 7),
]

NV2080_CTRL_INTERNAL_GR_FECS_TRACE_HW_ENABLE_PARAMS = struct_NV2080_CTRL_INTERNAL_GR_FECS_TRACE_HW_ENABLE_PARAMS
NV2080_CTRL_INTERNAL_GR_SET_FECS_TRACE_HW_ENABLE_PARAMS = struct_NV2080_CTRL_INTERNAL_GR_FECS_TRACE_HW_ENABLE_PARAMS
NV2080_CTRL_INTERNAL_GR_GET_FECS_TRACE_HW_ENABLE_PARAMS = struct_NV2080_CTRL_INTERNAL_GR_FECS_TRACE_HW_ENABLE_PARAMS
class struct_NV2080_CTRL_INTERNAL_GR_FECS_TRACE_OFFSET_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GR_FECS_TRACE_OFFSET_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GR_FECS_TRACE_OFFSET_PARAMS._fields_ = [
    ('grRouteInfo', NV2080_CTRL_GR_ROUTE_INFO),
    ('offset', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NV2080_CTRL_INTERNAL_GR_FECS_TRACE_OFFSET_PARAMS = struct_NV2080_CTRL_INTERNAL_GR_FECS_TRACE_OFFSET_PARAMS
NV2080_CTRL_INTERNAL_GR_SET_FECS_TRACE_RD_OFFSET_PARAMS = struct_NV2080_CTRL_INTERNAL_GR_FECS_TRACE_OFFSET_PARAMS
NV2080_CTRL_INTERNAL_GR_SET_FECS_TRACE_WR_OFFSET_PARAMS = struct_NV2080_CTRL_INTERNAL_GR_FECS_TRACE_OFFSET_PARAMS
NV2080_CTRL_INTERNAL_GR_GET_FECS_TRACE_RD_OFFSET_PARAMS = struct_NV2080_CTRL_INTERNAL_GR_FECS_TRACE_OFFSET_PARAMS
class struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_FECS_RECORD_SIZE(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_FECS_RECORD_SIZE._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_FECS_RECORD_SIZE._fields_ = [
    ('fecsRecordSize', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_STATIC_GR_GET_FECS_RECORD_SIZE = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_FECS_RECORD_SIZE
class struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_FECS_RECORD_SIZE_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('fecsRecordSize', struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_FECS_RECORD_SIZE * 8),
     ]

NV2080_CTRL_INTERNAL_STATIC_GR_GET_FECS_RECORD_SIZE_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_FECS_RECORD_SIZE_PARAMS
NV2080_CTRL_CMD_INTERNAL_STATIC_KGR_GET_FECS_RECORD_SIZE_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_FECS_RECORD_SIZE_PARAMS
class struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_FECS_TRACE_DEFINES(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_FECS_TRACE_DEFINES._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_FECS_TRACE_DEFINES._fields_ = [
    ('fecsRecordSize', ctypes.c_uint32),
    ('timestampHiTagMask', ctypes.c_uint32),
    ('timestampHiTagShift', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 7),
    ('timestampVMask', ctypes.c_uint64),
    ('numLowerBitsZeroShift', ctypes.c_ubyte),
    ('PADDING_1', ctypes.c_ubyte * 7),
]

NV2080_CTRL_INTERNAL_STATIC_GR_GET_FECS_TRACE_DEFINES = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_FECS_TRACE_DEFINES
class struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_FECS_TRACE_DEFINES_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('fecsTraceDefines', struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_FECS_TRACE_DEFINES * 8),
     ]

NV2080_CTRL_INTERNAL_STATIC_GR_GET_FECS_TRACE_DEFINES_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_FECS_TRACE_DEFINES_PARAMS
NV2080_CTRL_INTERNAL_STATIC_KGR_GET_FECS_TRACE_DEFINES_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_FECS_TRACE_DEFINES_PARAMS
class struct_NV2080_CTRL_INTERNAL_DEVICE_INFO(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_DEVICE_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_DEVICE_INFO._fields_ = [
    ('faultId', ctypes.c_uint32),
    ('instanceId', ctypes.c_uint32),
    ('typeEnum', ctypes.c_uint32),
    ('resetId', ctypes.c_uint32),
    ('devicePriBase', ctypes.c_uint32),
    ('isEngine', ctypes.c_uint32),
    ('rlEngId', ctypes.c_uint32),
    ('runlistPriBase', ctypes.c_uint32),
    ('groupId', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_DEVICE_INFO = struct_NV2080_CTRL_INTERNAL_DEVICE_INFO
class struct_NV2080_CTRL_INTERNAL_GET_DEVICE_INFO_TABLE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GET_DEVICE_INFO_TABLE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GET_DEVICE_INFO_TABLE_PARAMS._fields_ = [
    ('numEntries', ctypes.c_uint32),
    ('deviceInfoTable', struct_NV2080_CTRL_INTERNAL_DEVICE_INFO * 256),
]

NV2080_CTRL_INTERNAL_GET_DEVICE_INFO_TABLE_PARAMS = struct_NV2080_CTRL_INTERNAL_GET_DEVICE_INFO_TABLE_PARAMS
class struct_NV2080_CTRL_INTERNAL_GPU_GET_USER_REGISTER_ACCESS_MAP_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GPU_GET_USER_REGISTER_ACCESS_MAP_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GPU_GET_USER_REGISTER_ACCESS_MAP_PARAMS._fields_ = [
    ('userRegisterAccessMapSize', ctypes.c_uint32),
    ('compressedSize', ctypes.c_uint32),
    ('compressedData', ctypes.c_ubyte * 4096),
    ('profilingRangesSize', ctypes.c_uint32),
    ('profilingRanges', ctypes.c_ubyte * 4096),
]

NV2080_CTRL_INTERNAL_GPU_GET_USER_REGISTER_ACCESS_MAP_PARAMS = struct_NV2080_CTRL_INTERNAL_GPU_GET_USER_REGISTER_ACCESS_MAP_PARAMS
class struct_NV2080_CTRL_INTERNAL_NV_RANGE(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_NV_RANGE._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_NV_RANGE._fields_ = [
    ('lo', ctypes.c_uint64),
    ('hi', ctypes.c_uint64),
]

NV2080_CTRL_INTERNAL_NV_RANGE = struct_NV2080_CTRL_INTERNAL_NV_RANGE
class struct_NV2080_CTRL_INTERNAL_MIGMGR_PROMOTE_GPU_INSTANCE_MEM_RANGE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_MIGMGR_PROMOTE_GPU_INSTANCE_MEM_RANGE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_MIGMGR_PROMOTE_GPU_INSTANCE_MEM_RANGE_PARAMS._fields_ = [
    ('swizzId', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('memAddrRange', NV2080_CTRL_INTERNAL_NV_RANGE),
]

NV2080_CTRL_INTERNAL_MIGMGR_PROMOTE_GPU_INSTANCE_MEM_RANGE_PARAMS = struct_NV2080_CTRL_INTERNAL_MIGMGR_PROMOTE_GPU_INSTANCE_MEM_RANGE_PARAMS
NV2080_CTRL_INTERNAL_KMIGMGR_PROMOTE_GPU_INSTANCE_MEM_RANGE_PARAMS = struct_NV2080_CTRL_INTERNAL_MIGMGR_PROMOTE_GPU_INSTANCE_MEM_RANGE_PARAMS
class struct_NV2080_CTRL_INTERNAL_STATIC_GR_PDB_PROPERTIES(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_STATIC_GR_PDB_PROPERTIES._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_STATIC_GR_PDB_PROPERTIES._fields_ = [
    ('bPerSubCtxheaderSupported', ctypes.c_ubyte),
]

NV2080_CTRL_INTERNAL_STATIC_GR_PDB_PROPERTIES = struct_NV2080_CTRL_INTERNAL_STATIC_GR_PDB_PROPERTIES
class struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_PDB_PROPERTIES_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('pdbTable', struct_NV2080_CTRL_INTERNAL_STATIC_GR_PDB_PROPERTIES * 8),
     ]

NV2080_CTRL_INTERNAL_STATIC_GR_GET_PDB_PROPERTIES_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_PDB_PROPERTIES_PARAMS
NV2080_CTRL_INTERNAL_STATIC_KGR_GET_PDB_PROPERTIES_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GR_GET_PDB_PROPERTIES_PARAMS
class struct_NV2080_CTRL_INTERNAL_DISPLAY_WRITE_INST_MEM_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_DISPLAY_WRITE_INST_MEM_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_DISPLAY_WRITE_INST_MEM_PARAMS._fields_ = [
    ('instMemPhysAddr', ctypes.c_uint64),
    ('instMemSize', ctypes.c_uint64),
    ('instMemAddrSpace', ctypes.c_uint32),
    ('instMemCpuCacheAttr', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_DISPLAY_WRITE_INST_MEM_PARAMS = struct_NV2080_CTRL_INTERNAL_DISPLAY_WRITE_INST_MEM_PARAMS
class struct_NV2080_CTRL_INTERNAL_DISPLAY_GET_IP_VERSION_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_DISPLAY_GET_IP_VERSION_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_DISPLAY_GET_IP_VERSION_PARAMS._fields_ = [
    ('ipVersion', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_DISPLAY_GET_IP_VERSION_PARAMS = struct_NV2080_CTRL_INTERNAL_DISPLAY_GET_IP_VERSION_PARAMS
class struct_NV2080_CTRL_INTERNAL_GPU_GET_SMC_MODE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GPU_GET_SMC_MODE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GPU_GET_SMC_MODE_PARAMS._fields_ = [
    ('smcMode', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_GPU_GET_SMC_MODE_PARAMS = struct_NV2080_CTRL_INTERNAL_GPU_GET_SMC_MODE_PARAMS
class struct_NV2080_CTRL_INTERNAL_DISPLAY_SETUP_RG_LINE_INTR_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_DISPLAY_SETUP_RG_LINE_INTR_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_DISPLAY_SETUP_RG_LINE_INTR_PARAMS._fields_ = [
    ('head', ctypes.c_uint32),
    ('rgLineNum', ctypes.c_uint32),
    ('intrLine', ctypes.c_uint32),
    ('bEnable', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_INTERNAL_DISPLAY_SETUP_RG_LINE_INTR_PARAMS = struct_NV2080_CTRL_INTERNAL_DISPLAY_SETUP_RG_LINE_INTR_PARAMS
class struct_NV2080_CTRL_INTERNAL_MIGMGR_PROFILE_INFO(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_MIGMGR_PROFILE_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_MIGMGR_PROFILE_INFO._fields_ = [
    ('partitionFlag', ctypes.c_uint32),
    ('grCount', ctypes.c_uint32),
    ('gfxGrCount', ctypes.c_uint32),
    ('gpcCount', ctypes.c_uint32),
    ('virtualGpcCount', ctypes.c_uint32),
    ('gfxGpcCount', ctypes.c_uint32),
    ('veidCount', ctypes.c_uint32),
    ('smCount', ctypes.c_uint32),
    ('ceCount', ctypes.c_uint32),
    ('nvEncCount', ctypes.c_uint32),
    ('nvDecCount', ctypes.c_uint32),
    ('nvJpgCount', ctypes.c_uint32),
    ('nvOfaCount', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('validCTSIdMask', ctypes.c_uint64),
    ('validGfxCTSIdMask', ctypes.c_uint64),
]

NV2080_CTRL_INTERNAL_MIGMGR_PROFILE_INFO = struct_NV2080_CTRL_INTERNAL_MIGMGR_PROFILE_INFO
class struct_NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_PROFILES_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_PROFILES_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_PROFILES_PARAMS._fields_ = [
    ('count', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('table', struct_NV2080_CTRL_INTERNAL_MIGMGR_PROFILE_INFO * 60),
]

NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_PROFILES_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_PROFILES_PARAMS
class struct_NV2080_CTRL_INTERNAL_MEMSYS_SET_PARTITIONABLE_MEM_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_MEMSYS_SET_PARTITIONABLE_MEM_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_MEMSYS_SET_PARTITIONABLE_MEM_PARAMS._fields_ = [
    ('partitionableMemSize', ctypes.c_uint64),
    ('bottomRsvdSize', ctypes.c_uint64),
    ('topRsvdSize', ctypes.c_uint64),
    ('partitionableStartAddr', ctypes.c_uint64),
    ('partitionableEndAddr', ctypes.c_uint64),
]

NV2080_CTRL_INTERNAL_MEMSYS_SET_PARTITIONABLE_MEM_PARAMS = struct_NV2080_CTRL_INTERNAL_MEMSYS_SET_PARTITIONABLE_MEM_PARAMS
class struct_NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_PARTITIONABLE_ENGINES_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_PARTITIONABLE_ENGINES_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_PARTITIONABLE_ENGINES_PARAMS._fields_ = [
    ('engineMask', ctypes.c_uint64 * 4),
]

NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_PARTITIONABLE_ENGINES_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_PARTITIONABLE_ENGINES_PARAMS
class struct_NV2080_CTRL_INTERNAL_FIFO_PROMOTE_RUNLIST_BUFFERS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_FIFO_PROMOTE_RUNLIST_BUFFERS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_FIFO_PROMOTE_RUNLIST_BUFFERS_PARAMS._fields_ = [
    ('rlBuffers', struct_NV2080_CTRL_INTERNAL_MEMDESC_INFO * 2 * 64),
    ('runlistIdMask', ctypes.c_uint64),
    ('swizzId', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NV2080_CTRL_INTERNAL_FIFO_PROMOTE_RUNLIST_BUFFERS_PARAMS = struct_NV2080_CTRL_INTERNAL_FIFO_PROMOTE_RUNLIST_BUFFERS_PARAMS
class struct_NV2080_CTRL_INTERNAL_DISPLAY_SET_IMP_INIT_INFO_PARAMS(Structure):
    pass

class struct_TEGRA_IMP_IMPORT_DATA(Structure):
    pass

class struct_DRAM_CLK_INSTANCE(Structure):
    pass

struct_DRAM_CLK_INSTANCE._pack_ = 1 # source:False
struct_DRAM_CLK_INSTANCE._fields_ = [
    ('dram_clk_freq_khz', ctypes.c_uint32),
    ('mchub_clk_khz', ctypes.c_uint32),
    ('mc_clk_khz', ctypes.c_uint32),
    ('max_iso_bw_kbps', ctypes.c_uint32),
    ('switch_latency_ns', ctypes.c_uint32),
]

struct_TEGRA_IMP_IMPORT_DATA._pack_ = 1 # source:False
struct_TEGRA_IMP_IMPORT_DATA._fields_ = [
    ('max_iso_bw_kbps', ctypes.c_uint32),
    ('dram_type', ctypes.c_uint32),
    ('num_dram_channels', ctypes.c_uint32),
    ('num_dram_clk_entries', ctypes.c_uint32),
    ('dram_clk_instance', struct_DRAM_CLK_INSTANCE * 24),
]

struct_NV2080_CTRL_INTERNAL_DISPLAY_SET_IMP_INIT_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_DISPLAY_SET_IMP_INIT_INFO_PARAMS._fields_ = [
    ('tegraImpImportData', struct_TEGRA_IMP_IMPORT_DATA),
]

NV2080_CTRL_INTERNAL_DISPLAY_SET_IMP_INIT_INFO_PARAMS = struct_NV2080_CTRL_INTERNAL_DISPLAY_SET_IMP_INIT_INFO_PARAMS
class struct_NV2080_CTRL_INTERNAL_GET_EGPU_BRIDGE_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GET_EGPU_BRIDGE_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GET_EGPU_BRIDGE_INFO_PARAMS._fields_ = [
    ('pciDeviceId', ctypes.c_uint16),
    ('pciSubDeviceId', ctypes.c_uint16),
    ('iseGPUBridge', ctypes.c_ubyte),
    ('approvedBusType', ctypes.c_ubyte),
]

NV2080_CTRL_INTERNAL_GET_EGPU_BRIDGE_INFO_PARAMS = struct_NV2080_CTRL_INTERNAL_GET_EGPU_BRIDGE_INFO_PARAMS
class struct_NV2080_CTRL_CMD_INTERNAL_BUS_SETUP_P2P_MAILBOX_LOCAL_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_INTERNAL_BUS_SETUP_P2P_MAILBOX_LOCAL_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_INTERNAL_BUS_SETUP_P2P_MAILBOX_LOCAL_PARAMS._fields_ = [
    ('local2Remote', ctypes.c_uint32),
    ('remote2Local', ctypes.c_uint32),
    ('localP2PDomainRemoteAddr', ctypes.c_uint64),
    ('remoteP2PDomainLocalAddr', ctypes.c_uint64),
    ('remoteWMBoxLocalAddr', ctypes.c_uint64),
    ('p2pWmbTag', ctypes.c_uint64),
    ('bNeedWarBug999673', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 7),
]

NV2080_CTRL_CMD_INTERNAL_BUS_SETUP_P2P_MAILBOX_LOCAL_PARAMS = struct_NV2080_CTRL_CMD_INTERNAL_BUS_SETUP_P2P_MAILBOX_LOCAL_PARAMS
class struct_NV2080_CTRL_CMD_INTERNAL_BUS_SETUP_P2P_MAILBOX_REMOTE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_INTERNAL_BUS_SETUP_P2P_MAILBOX_REMOTE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_INTERNAL_BUS_SETUP_P2P_MAILBOX_REMOTE_PARAMS._fields_ = [
    ('local2Remote', ctypes.c_uint32),
    ('remote2Local', ctypes.c_uint32),
    ('localP2PDomainRemoteAddr', ctypes.c_uint64),
    ('remoteP2PDomainLocalAddr', ctypes.c_uint64),
    ('remoteWMBoxAddrU64', ctypes.c_uint64),
    ('p2pWmbTag', ctypes.c_uint64),
]

NV2080_CTRL_CMD_INTERNAL_BUS_SETUP_P2P_MAILBOX_REMOTE_PARAMS = struct_NV2080_CTRL_CMD_INTERNAL_BUS_SETUP_P2P_MAILBOX_REMOTE_PARAMS
class struct_NV2080_CTRL_INTERNAL_BUS_DESTROY_P2P_MAILBOX_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_BUS_DESTROY_P2P_MAILBOX_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_BUS_DESTROY_P2P_MAILBOX_PARAMS._fields_ = [
    ('peerIdx', ctypes.c_uint32),
    ('bNeedWarBug999673', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_INTERNAL_BUS_DESTROY_P2P_MAILBOX_PARAMS = struct_NV2080_CTRL_INTERNAL_BUS_DESTROY_P2P_MAILBOX_PARAMS
class struct_NV2080_CTRL_INTERNAL_BUS_CREATE_C2C_PEER_MAPPING_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_BUS_CREATE_C2C_PEER_MAPPING_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_BUS_CREATE_C2C_PEER_MAPPING_PARAMS._fields_ = [
    ('peerId', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_BUS_CREATE_C2C_PEER_MAPPING_PARAMS = struct_NV2080_CTRL_INTERNAL_BUS_CREATE_C2C_PEER_MAPPING_PARAMS
class struct_NV2080_CTRL_INTERNAL_BUS_REMOVE_C2C_PEER_MAPPING_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_BUS_REMOVE_C2C_PEER_MAPPING_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_BUS_REMOVE_C2C_PEER_MAPPING_PARAMS._fields_ = [
    ('peerId', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_BUS_REMOVE_C2C_PEER_MAPPING_PARAMS = struct_NV2080_CTRL_INTERNAL_BUS_REMOVE_C2C_PEER_MAPPING_PARAMS
class struct_NV2080_CTRL_INTERNAL_VMMU_GET_SPA_FOR_GPA_ENTRIES_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_VMMU_GET_SPA_FOR_GPA_ENTRIES_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_VMMU_GET_SPA_FOR_GPA_ENTRIES_PARAMS._fields_ = [
    ('gfid', ctypes.c_uint32),
    ('numEntries', ctypes.c_uint32),
    ('gpaEntries', ctypes.c_uint64 * 128),
    ('spaEntries', ctypes.c_uint64 * 128),
]

NV2080_CTRL_INTERNAL_VMMU_GET_SPA_FOR_GPA_ENTRIES_PARAMS = struct_NV2080_CTRL_INTERNAL_VMMU_GET_SPA_FOR_GPA_ENTRIES_PARAMS
class struct_NV2080_CTRL_INTERNAL_DISPLAY_CHANNEL_PUSHBUFFER_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_DISPLAY_CHANNEL_PUSHBUFFER_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_DISPLAY_CHANNEL_PUSHBUFFER_PARAMS._fields_ = [
    ('addressSpace', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('physicalAddr', ctypes.c_uint64),
    ('limit', ctypes.c_uint64),
    ('cacheSnoop', ctypes.c_uint32),
    ('hclass', ctypes.c_uint32),
    ('channelInstance', ctypes.c_uint32),
    ('valid', ctypes.c_ubyte),
    ('PADDING_1', ctypes.c_ubyte * 3),
    ('pbTargetAperture', ctypes.c_uint32),
    ('PADDING_2', ctypes.c_ubyte * 4),
]

NV2080_CTRL_INTERNAL_DISPLAY_CHANNEL_PUSHBUFFER_PARAMS = struct_NV2080_CTRL_INTERNAL_DISPLAY_CHANNEL_PUSHBUFFER_PARAMS
class struct_NV2080_CTRL_INTERNAL_GMMU_GET_STATIC_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GMMU_GET_STATIC_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GMMU_GET_STATIC_INFO_PARAMS._fields_ = [
    ('replayableFaultBufferSize', ctypes.c_uint32),
    ('replayableShadowFaultBufferMetadataSize', ctypes.c_uint32),
    ('nonReplayableFaultBufferSize', ctypes.c_uint32),
    ('nonReplayableShadowFaultBufferMetadataSize', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_GMMU_GET_STATIC_INFO_PARAMS = struct_NV2080_CTRL_INTERNAL_GMMU_GET_STATIC_INFO_PARAMS
NV2080_CTRL_INTERNAL_GR_GET_CTXSW_MODES_PARAMS = struct_NV2080_CTRL_GR_GET_CTXSW_MODES_PARAMS
class struct_NV2080_CTRL_INTERNAL_FB_GET_HEAP_RESERVATION_SIZE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_FB_GET_HEAP_RESERVATION_SIZE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_FB_GET_HEAP_RESERVATION_SIZE_PARAMS._fields_ = [
    ('moduleIndex', ctypes.c_uint32),
    ('size', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_FB_GET_HEAP_RESERVATION_SIZE_PARAMS = struct_NV2080_CTRL_INTERNAL_FB_GET_HEAP_RESERVATION_SIZE_PARAMS

# values for enumeration 'NV2080_INTR_CATEGORY'
NV2080_INTR_CATEGORY__enumvalues = {
    0: 'NV2080_INTR_CATEGORY_DEFAULT',
    1: 'NV2080_INTR_CATEGORY_ESCHED_DRIVEN_ENGINE',
    2: 'NV2080_INTR_CATEGORY_ESCHED_DRIVEN_ENGINE_NOTIFICATION',
    3: 'NV2080_INTR_CATEGORY_RUNLIST',
    4: 'NV2080_INTR_CATEGORY_RUNLIST_NOTIFICATION',
    5: 'NV2080_INTR_CATEGORY_UVM_OWNED',
    6: 'NV2080_INTR_CATEGORY_UVM_SHARED',
    7: 'NV2080_INTR_CATEGORY_ENUM_COUNT',
}
NV2080_INTR_CATEGORY_DEFAULT = 0
NV2080_INTR_CATEGORY_ESCHED_DRIVEN_ENGINE = 1
NV2080_INTR_CATEGORY_ESCHED_DRIVEN_ENGINE_NOTIFICATION = 2
NV2080_INTR_CATEGORY_RUNLIST = 3
NV2080_INTR_CATEGORY_RUNLIST_NOTIFICATION = 4
NV2080_INTR_CATEGORY_UVM_OWNED = 5
NV2080_INTR_CATEGORY_UVM_SHARED = 6
NV2080_INTR_CATEGORY_ENUM_COUNT = 7
NV2080_INTR_CATEGORY = ctypes.c_uint32 # enum
class struct_NV2080_INTR_CATEGORY_SUBTREE_MAP(Structure):
    pass

struct_NV2080_INTR_CATEGORY_SUBTREE_MAP._pack_ = 1 # source:False
struct_NV2080_INTR_CATEGORY_SUBTREE_MAP._fields_ = [
    ('subtreeStart', ctypes.c_ubyte),
    ('subtreeEnd', ctypes.c_ubyte),
]

NV2080_INTR_CATEGORY_SUBTREE_MAP = struct_NV2080_INTR_CATEGORY_SUBTREE_MAP
class struct_NV2080_CTRL_INTERNAL_INTR_GET_KERNEL_TABLE_ENTRY(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_INTR_GET_KERNEL_TABLE_ENTRY._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_INTR_GET_KERNEL_TABLE_ENTRY._fields_ = [
    ('engineIdx', ctypes.c_uint16),
    ('PADDING_0', ctypes.c_ubyte * 2),
    ('pmcIntrMask', ctypes.c_uint32),
    ('vectorStall', ctypes.c_uint32),
    ('vectorNonStall', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_INTR_GET_KERNEL_TABLE_ENTRY = struct_NV2080_CTRL_INTERNAL_INTR_GET_KERNEL_TABLE_ENTRY
class struct_NV2080_CTRL_INTERNAL_INTR_GET_KERNEL_TABLE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_INTR_GET_KERNEL_TABLE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_INTR_GET_KERNEL_TABLE_PARAMS._fields_ = [
    ('tableLen', ctypes.c_uint32),
    ('table', struct_NV2080_CTRL_INTERNAL_INTR_GET_KERNEL_TABLE_ENTRY * 128),
    ('subtreeMap', struct_NV2080_INTR_CATEGORY_SUBTREE_MAP * 7),
    ('PADDING_0', ctypes.c_ubyte * 2),
]

NV2080_CTRL_INTERNAL_INTR_GET_KERNEL_TABLE_PARAMS = struct_NV2080_CTRL_INTERNAL_INTR_GET_KERNEL_TABLE_PARAMS
class struct_NV2080_CTRL_INTERNAL_PERF_PERFMON_CLIENT_RESERVATION_CHECK_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_PERF_PERFMON_CLIENT_RESERVATION_CHECK_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_PERF_PERFMON_CLIENT_RESERVATION_CHECK_PARAMS._fields_ = [
    ('bReservation', ctypes.c_ubyte),
]

NV2080_CTRL_INTERNAL_PERF_PERFMON_CLIENT_RESERVATION_CHECK_PARAMS = struct_NV2080_CTRL_INTERNAL_PERF_PERFMON_CLIENT_RESERVATION_CHECK_PARAMS
class struct_NV2080_CTRL_INTERNAL_PERF_PERFMON_CLIENT_RESERVATION_SET_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_PERF_PERFMON_CLIENT_RESERVATION_SET_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_PERF_PERFMON_CLIENT_RESERVATION_SET_PARAMS._fields_ = [
    ('bReservation', ctypes.c_ubyte),
    ('bClientHandlesGrGating', ctypes.c_ubyte),
    ('bRmHandlesIdleSlow', ctypes.c_ubyte),
]

NV2080_CTRL_INTERNAL_PERF_PERFMON_CLIENT_RESERVATION_SET_PARAMS = struct_NV2080_CTRL_INTERNAL_PERF_PERFMON_CLIENT_RESERVATION_SET_PARAMS
class struct_NV2080_CTRL_INTERNAL_DISPLAY_GET_ACTIVE_DISPLAY_DEVICES_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_DISPLAY_GET_ACTIVE_DISPLAY_DEVICES_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_DISPLAY_GET_ACTIVE_DISPLAY_DEVICES_PARAMS._fields_ = [
    ('displayMask', ctypes.c_uint32),
    ('numHeads', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_DISPLAY_GET_ACTIVE_DISPLAY_DEVICES_PARAMS = struct_NV2080_CTRL_INTERNAL_DISPLAY_GET_ACTIVE_DISPLAY_DEVICES_PARAMS
class struct_NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_SWIZZ_ID_FB_MEM_PAGE_RANGES_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('fbMemPageRanges', struct_NV2080_CTRL_INTERNAL_NV_RANGE * 15),
     ]

NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_SWIZZ_ID_FB_MEM_PAGE_RANGES_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_SWIZZ_ID_FB_MEM_PAGE_RANGES_PARAMS
class struct_NV2080_CTRL_INTERNAL_FIFO_GET_NUM_CHANNELS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_FIFO_GET_NUM_CHANNELS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_FIFO_GET_NUM_CHANNELS_PARAMS._fields_ = [
    ('runlistId', ctypes.c_uint32),
    ('numChannels', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_FIFO_GET_NUM_CHANNELS_PARAMS = struct_NV2080_CTRL_INTERNAL_FIFO_GET_NUM_CHANNELS_PARAMS
NV2080_CTRL_INTERNAL_STATIC_KMIGMGR_GET_PROFILES_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_PROFILES_PARAMS
NV2080_CTRL_INTERNAL_STATIC_KMIGMGR_GET_PARTITIONABLE_ENGINES_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_PARTITIONABLE_ENGINES_PARAMS
NV2080_CTRL_INTERNAL_STATIC_KMIGMGR_GET_SWIZZ_ID_FB_MEM_PAGE_RANGES_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_SWIZZ_ID_FB_MEM_PAGE_RANGES_PARAMS
class struct_NV2080_CTRL_INTERNAL_MEMSYS_GET_MIG_MEMORY_CONFIG_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_MEMSYS_GET_MIG_MEMORY_CONFIG_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_MEMSYS_GET_MIG_MEMORY_CONFIG_PARAMS._fields_ = [
    ('memBoundaryCfgA', ctypes.c_uint64),
    ('memBoundaryCfgB', ctypes.c_uint64),
    ('memBoundaryCfgC', ctypes.c_uint32),
    ('memBoundaryCfg', ctypes.c_uint32),
    ('memBoundaryCfgValInit', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NV2080_CTRL_INTERNAL_MEMSYS_GET_MIG_MEMORY_CONFIG_PARAMS = struct_NV2080_CTRL_INTERNAL_MEMSYS_GET_MIG_MEMORY_CONFIG_PARAMS
NV2080_CTRL_INTERNAL_KMEMSYS_GET_MIG_MEMORY_CONFIG_PARAMS = struct_NV2080_CTRL_INTERNAL_MEMSYS_GET_MIG_MEMORY_CONFIG_PARAMS
class struct_NV2080_CTRL_INTERNAL_MEMSYS_GET_MIG_MEMORY_PARTITION_TABLE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_MEMSYS_GET_MIG_MEMORY_PARTITION_TABLE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_MEMSYS_GET_MIG_MEMORY_PARTITION_TABLE_PARAMS._fields_ = [
    ('data', ctypes.c_uint32 * 8),
]

NV2080_CTRL_INTERNAL_MEMSYS_GET_MIG_MEMORY_PARTITION_TABLE_PARAMS = struct_NV2080_CTRL_INTERNAL_MEMSYS_GET_MIG_MEMORY_PARTITION_TABLE_PARAMS
class struct_NV2080_CTRL_INTERNAL_PERF_GET_AUX_POWER_STATE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_PERF_GET_AUX_POWER_STATE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_PERF_GET_AUX_POWER_STATE_PARAMS._fields_ = [
    ('powerState', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_PERF_GET_AUX_POWER_STATE_PARAMS = struct_NV2080_CTRL_INTERNAL_PERF_GET_AUX_POWER_STATE_PARAMS
class struct_NV2080_CTRL_INTERNAL_PERF_BOOST_SET_PARAMS_2X(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_PERF_BOOST_SET_PARAMS_2X._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_PERF_BOOST_SET_PARAMS_2X._fields_ = [
    ('flags', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('duration', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_PERF_BOOST_SET_PARAMS_2X = struct_NV2080_CTRL_INTERNAL_PERF_BOOST_SET_PARAMS_2X
class struct_NV2080_CTRL_INTERNAL_PERF_GPU_BOOST_SYNC_CONTROL_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_PERF_GPU_BOOST_SYNC_CONTROL_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_PERF_GPU_BOOST_SYNC_CONTROL_PARAMS._fields_ = [
    ('bActivate', ctypes.c_ubyte),
]

NV2080_CTRL_INTERNAL_PERF_GPU_BOOST_SYNC_CONTROL_PARAMS = struct_NV2080_CTRL_INTERNAL_PERF_GPU_BOOST_SYNC_CONTROL_PARAMS
class struct_NV2080_CTRL_INTERNAL_PERF_GPU_BOOST_SYNC_SET_LIMITS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_PERF_GPU_BOOST_SYNC_SET_LIMITS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_PERF_GPU_BOOST_SYNC_SET_LIMITS_PARAMS._fields_ = [
    ('flags', ctypes.c_uint32),
    ('bBridgeless', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('currLimits', ctypes.c_uint32 * 2),
]

NV2080_CTRL_INTERNAL_PERF_GPU_BOOST_SYNC_SET_LIMITS_PARAMS = struct_NV2080_CTRL_INTERNAL_PERF_GPU_BOOST_SYNC_SET_LIMITS_PARAMS
class struct_NV2080_CTRL_INTERNAL_PERF_GPU_BOOST_SYNC_GET_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_PERF_GPU_BOOST_SYNC_GET_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_PERF_GPU_BOOST_SYNC_GET_INFO_PARAMS._fields_ = [
    ('hysteresisus', ctypes.c_uint64),
    ('bHystersisEnable', ctypes.c_ubyte),
    ('bSliGpuBoostSyncEnable', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 6),
]

NV2080_CTRL_INTERNAL_PERF_GPU_BOOST_SYNC_GET_INFO_PARAMS = struct_NV2080_CTRL_INTERNAL_PERF_GPU_BOOST_SYNC_GET_INFO_PARAMS
class struct_NV2080_CTRL_INTERNAL_GMMU_REGISTER_FAULT_BUFFER_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GMMU_REGISTER_FAULT_BUFFER_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GMMU_REGISTER_FAULT_BUFFER_PARAMS._fields_ = [
    ('hClient', ctypes.c_uint32),
    ('hObject', ctypes.c_uint32),
    ('faultBufferSize', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('faultBufferPteArray', ctypes.c_uint64 * 256),
]

NV2080_CTRL_INTERNAL_GMMU_REGISTER_FAULT_BUFFER_PARAMS = struct_NV2080_CTRL_INTERNAL_GMMU_REGISTER_FAULT_BUFFER_PARAMS
class struct_NV2080_CTRL_INTERNAL_GMMU_REGISTER_CLIENT_SHADOW_FAULT_BUFFER_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GMMU_REGISTER_CLIENT_SHADOW_FAULT_BUFFER_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GMMU_REGISTER_CLIENT_SHADOW_FAULT_BUFFER_PARAMS._fields_ = [
    ('shadowFaultBufferQueuePhysAddr', ctypes.c_uint64),
    ('shadowFaultBufferSize', ctypes.c_uint32),
    ('shadowFaultBufferMetadataSize', ctypes.c_uint32),
    ('shadowFaultBufferPteArray', ctypes.c_uint64 * 3000),
    ('shadowFaultBufferType', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('faultBufferSharedMemoryPhysAddr', ctypes.c_uint64),
]

NV2080_CTRL_INTERNAL_GMMU_REGISTER_CLIENT_SHADOW_FAULT_BUFFER_PARAMS = struct_NV2080_CTRL_INTERNAL_GMMU_REGISTER_CLIENT_SHADOW_FAULT_BUFFER_PARAMS
class struct_NV2080_CTRL_INTERNAL_GMMU_UNREGISTER_CLIENT_SHADOW_FAULT_BUFFER_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GMMU_UNREGISTER_CLIENT_SHADOW_FAULT_BUFFER_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GMMU_UNREGISTER_CLIENT_SHADOW_FAULT_BUFFER_PARAMS._fields_ = [
    ('shadowFaultBufferType', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_GMMU_UNREGISTER_CLIENT_SHADOW_FAULT_BUFFER_PARAMS = struct_NV2080_CTRL_INTERNAL_GMMU_UNREGISTER_CLIENT_SHADOW_FAULT_BUFFER_PARAMS
class struct_NV2080_CTRL_INTERNAL_GMMU_COPY_RESERVED_SPLIT_GVASPACE_PDES_TO_SERVER_PARAMS(Structure):
    pass

class struct_NV90F1_CTRL_VASPACE_COPY_SERVER_RESERVED_PDES_PARAMS(Structure):
    pass

class struct_NV90F1_CTRL_VASPACE_COPY_SERVER_RESERVED_PDES_PARAMS_0(Structure):
    pass

struct_NV90F1_CTRL_VASPACE_COPY_SERVER_RESERVED_PDES_PARAMS_0._pack_ = 1 # source:False
struct_NV90F1_CTRL_VASPACE_COPY_SERVER_RESERVED_PDES_PARAMS_0._fields_ = [
    ('physAddress', ctypes.c_uint64),
    ('size', ctypes.c_uint64),
    ('aperture', ctypes.c_uint32),
    ('pageShift', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

struct_NV90F1_CTRL_VASPACE_COPY_SERVER_RESERVED_PDES_PARAMS._pack_ = 1 # source:False
struct_NV90F1_CTRL_VASPACE_COPY_SERVER_RESERVED_PDES_PARAMS._fields_ = [
    ('hSubDevice', ctypes.c_uint32),
    ('subDeviceId', ctypes.c_uint32),
    ('pageSize', ctypes.c_uint64),
    ('virtAddrLo', ctypes.c_uint64),
    ('virtAddrHi', ctypes.c_uint64),
    ('numLevelsToCopy', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('levels', struct_NV90F1_CTRL_VASPACE_COPY_SERVER_RESERVED_PDES_PARAMS_0 * 6),
]

struct_NV2080_CTRL_INTERNAL_GMMU_COPY_RESERVED_SPLIT_GVASPACE_PDES_TO_SERVER_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GMMU_COPY_RESERVED_SPLIT_GVASPACE_PDES_TO_SERVER_PARAMS._fields_ = [
    ('PdeCopyParams', struct_NV90F1_CTRL_VASPACE_COPY_SERVER_RESERVED_PDES_PARAMS),
]

NV2080_CTRL_INTERNAL_GMMU_COPY_RESERVED_SPLIT_GVASPACE_PDES_TO_SERVER_PARAMS = struct_NV2080_CTRL_INTERNAL_GMMU_COPY_RESERVED_SPLIT_GVASPACE_PDES_TO_SERVER_PARAMS
class struct_NV2080_CTRL_INTERNAL_PERF_BOOST_SET_PARAMS_3X(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_PERF_BOOST_SET_PARAMS_3X._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_PERF_BOOST_SET_PARAMS_3X._fields_ = [
    ('flags', ctypes.c_uint32),
    ('boostDuration', ctypes.c_uint32),
    ('gfId', ctypes.c_uint32),
    ('bOverrideInfinite', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_INTERNAL_PERF_BOOST_SET_PARAMS_3X = struct_NV2080_CTRL_INTERNAL_PERF_BOOST_SET_PARAMS_3X
class struct_NV2080_CTRL_INTERNAL_PERF_BOOST_CLEAR_PARAMS_3X(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_PERF_BOOST_CLEAR_PARAMS_3X._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_PERF_BOOST_CLEAR_PARAMS_3X._fields_ = [
    ('bIsCudaClient', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('gfId', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_PERF_BOOST_CLEAR_PARAMS_3X = struct_NV2080_CTRL_INTERNAL_PERF_BOOST_CLEAR_PARAMS_3X
class struct_NV2080_CTRL_INTERNAL_GRMGR_SKYLINE_INFO(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GRMGR_SKYLINE_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GRMGR_SKYLINE_INFO._fields_ = [
    ('skylineVgpcSize', ctypes.c_ubyte * 12),
    ('singletonVgpcMask', ctypes.c_uint32),
    ('maxInstances', ctypes.c_uint32),
    ('computeSizeFlag', ctypes.c_uint32),
    ('numNonSingletonVgpcs', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_GRMGR_SKYLINE_INFO = struct_NV2080_CTRL_INTERNAL_GRMGR_SKYLINE_INFO
class struct_NV2080_CTRL_INTERNAL_STATIC_GRMGR_GET_SKYLINE_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_STATIC_GRMGR_GET_SKYLINE_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_STATIC_GRMGR_GET_SKYLINE_INFO_PARAMS._fields_ = [
    ('skylineTable', struct_NV2080_CTRL_INTERNAL_GRMGR_SKYLINE_INFO * 8),
    ('validEntries', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_STATIC_GRMGR_GET_SKYLINE_INFO_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_GRMGR_GET_SKYLINE_INFO_PARAMS
NV2080_CTRL_INTERNAL_MIGMGR_SET_PARTITIONING_MODE_PARAMS = struct_NV2080_CTRL_GPU_SET_PARTITIONING_MODE_PARAMS
NV2080_CTRL_INTERNAL_MIGMGR_CONFIGURE_GPU_INSTANCE_PARAMS = struct_NV2080_CTRL_GPU_CONFIGURE_PARTITION_PARAMS
NV2080_CTRL_INTERNAL_MIGMGR_SET_GPU_INSTANCES_PARAMS = struct_NV2080_CTRL_GPU_SET_PARTITIONS_PARAMS
NV2080_CTRL_INTERNAL_MIGMGR_GET_GPU_INSTANCES_PARAMS = struct_NV2080_CTRL_GPU_GET_PARTITIONS_PARAMS
class struct_NV2080_CTRL_INTERNAL_MEMSYS_SET_ZBC_REFERENCED_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_MEMSYS_SET_ZBC_REFERENCED_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_MEMSYS_SET_ZBC_REFERENCED_PARAMS._fields_ = [
    ('bZbcSurfacesExist', ctypes.c_ubyte),
]

NV2080_CTRL_INTERNAL_MEMSYS_SET_ZBC_REFERENCED_PARAMS = struct_NV2080_CTRL_INTERNAL_MEMSYS_SET_ZBC_REFERENCED_PARAMS
class struct_NV2080_CTRL_INTERNAL_KMIGMGR_EXPORTED_GPU_INSTANCE_INFO(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_KMIGMGR_EXPORTED_GPU_INSTANCE_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_KMIGMGR_EXPORTED_GPU_INSTANCE_INFO._fields_ = [
    ('enginesMask', ctypes.c_uint64 * 4),
    ('partitionFlags', ctypes.c_uint32),
    ('gpcMask', ctypes.c_uint32),
    ('virtualGpcCount', ctypes.c_uint32),
    ('veidOffset', ctypes.c_uint32),
    ('veidCount', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NV2080_CTRL_INTERNAL_KMIGMGR_EXPORTED_GPU_INSTANCE_INFO = struct_NV2080_CTRL_INTERNAL_KMIGMGR_EXPORTED_GPU_INSTANCE_INFO
class struct_NV2080_CTRL_INTERNAL_KMIGMGR_IMPORT_EXPORT_GPU_INSTANCE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_KMIGMGR_IMPORT_EXPORT_GPU_INSTANCE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_KMIGMGR_IMPORT_EXPORT_GPU_INSTANCE_PARAMS._fields_ = [
    ('swizzId', ctypes.c_uint32),
    ('uuid', ctypes.c_ubyte * 16),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('info', NV2080_CTRL_INTERNAL_KMIGMGR_EXPORTED_GPU_INSTANCE_INFO),
]

NV2080_CTRL_INTERNAL_KMIGMGR_IMPORT_EXPORT_GPU_INSTANCE_PARAMS = struct_NV2080_CTRL_INTERNAL_KMIGMGR_IMPORT_EXPORT_GPU_INSTANCE_PARAMS
NV2080_CTRL_INTERNAL_KMIGMGR_EXPORT_GPU_INSTANCE_PARAMS = struct_NV2080_CTRL_INTERNAL_KMIGMGR_IMPORT_EXPORT_GPU_INSTANCE_PARAMS
NV2080_CTRL_INTERNAL_MIGMGR_EXPORT_GPU_INSTANCE_PARAMS = struct_NV2080_CTRL_INTERNAL_KMIGMGR_IMPORT_EXPORT_GPU_INSTANCE_PARAMS
NV2080_CTRL_INTERNAL_KMIGMGR_IMPORT_GPU_INSTANCE_PARAMS = struct_NV2080_CTRL_INTERNAL_KMIGMGR_IMPORT_EXPORT_GPU_INSTANCE_PARAMS
NV2080_CTRL_INTERNAL_MIGMGR_IMPORT_GPU_INSTANCE_PARAMS = struct_NV2080_CTRL_INTERNAL_KMIGMGR_IMPORT_EXPORT_GPU_INSTANCE_PARAMS
class struct_NV2080_CTRL_INTERNAL_MEMSYS_L2_INVALIDATE_EVICT_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_MEMSYS_L2_INVALIDATE_EVICT_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_MEMSYS_L2_INVALIDATE_EVICT_PARAMS._fields_ = [
    ('flags', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_MEMSYS_L2_INVALIDATE_EVICT_PARAMS = struct_NV2080_CTRL_INTERNAL_MEMSYS_L2_INVALIDATE_EVICT_PARAMS
class struct_NV2080_CTRL_INTERNAL_BIF_GET_STATIC_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_BIF_GET_STATIC_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_BIF_GET_STATIC_INFO_PARAMS._fields_ = [
    ('bPcieGen4Capable', ctypes.c_ubyte),
    ('bIsC2CLinkUp', ctypes.c_ubyte),
    ('bIsDeviceMultiFunction', ctypes.c_ubyte),
    ('bGcxPmuCfgSpaceRestore', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('dmaWindowStartAddress', ctypes.c_uint64),
]

NV2080_CTRL_INTERNAL_BIF_GET_STATIC_INFO_PARAMS = struct_NV2080_CTRL_INTERNAL_BIF_GET_STATIC_INFO_PARAMS
class struct_NV2080_CTRL_INTERNAL_HSHUB_PEER_CONN_CONFIG_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_HSHUB_PEER_CONN_CONFIG_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_HSHUB_PEER_CONN_CONFIG_PARAMS._fields_ = [
    ('programPeerMask', ctypes.c_uint32),
    ('invalidatePeerMask', ctypes.c_uint32),
    ('programPciePeerMask', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_HSHUB_PEER_CONN_CONFIG_PARAMS = struct_NV2080_CTRL_INTERNAL_HSHUB_PEER_CONN_CONFIG_PARAMS
class struct_NV2080_CTRL_INTERNAL_HSHUB_FIRST_LINK_PEER_ID_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_HSHUB_FIRST_LINK_PEER_ID_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_HSHUB_FIRST_LINK_PEER_ID_PARAMS._fields_ = [
    ('linkMask', ctypes.c_uint32),
    ('peerId', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_HSHUB_FIRST_LINK_PEER_ID_PARAMS = struct_NV2080_CTRL_INTERNAL_HSHUB_FIRST_LINK_PEER_ID_PARAMS
class struct_NV2080_CTRL_INTERNAL_HSHUB_GET_HSHUB_ID_FOR_LINKS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_HSHUB_GET_HSHUB_ID_FOR_LINKS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_HSHUB_GET_HSHUB_ID_FOR_LINKS_PARAMS._fields_ = [
    ('linkMask', ctypes.c_uint32),
    ('hshubIds', ctypes.c_ubyte * 32),
]

NV2080_CTRL_INTERNAL_HSHUB_GET_HSHUB_ID_FOR_LINKS_PARAMS = struct_NV2080_CTRL_INTERNAL_HSHUB_GET_HSHUB_ID_FOR_LINKS_PARAMS
class struct_NV2080_CTRL_INTERNAL_HSHUB_GET_NUM_UNITS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_HSHUB_GET_NUM_UNITS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_HSHUB_GET_NUM_UNITS_PARAMS._fields_ = [
    ('numHshubs', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_HSHUB_GET_NUM_UNITS_PARAMS = struct_NV2080_CTRL_INTERNAL_HSHUB_GET_NUM_UNITS_PARAMS
class struct_NV2080_CTRL_INTERNAL_HSHUB_NEXT_HSHUB_ID_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_HSHUB_NEXT_HSHUB_ID_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_HSHUB_NEXT_HSHUB_ID_PARAMS._fields_ = [
    ('hshubId', ctypes.c_ubyte),
]

NV2080_CTRL_INTERNAL_HSHUB_NEXT_HSHUB_ID_PARAMS = struct_NV2080_CTRL_INTERNAL_HSHUB_NEXT_HSHUB_ID_PARAMS
class struct_NV2080_CTRL_INTERNAL_HSHUB_EGM_CONFIG_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_HSHUB_EGM_CONFIG_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_HSHUB_EGM_CONFIG_PARAMS._fields_ = [
    ('egmPeerId', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_HSHUB_EGM_CONFIG_PARAMS = struct_NV2080_CTRL_INTERNAL_HSHUB_EGM_CONFIG_PARAMS
class struct_NV2080_CTRL_INTERNAL_NVLINK_GET_SET_NVSWITCH_FABRIC_ADDR_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_NVLINK_GET_SET_NVSWITCH_FABRIC_ADDR_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_NVLINK_GET_SET_NVSWITCH_FABRIC_ADDR_PARAMS._fields_ = [
    ('bGet', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 7),
    ('addr', ctypes.c_uint64),
]

NV2080_CTRL_INTERNAL_NVLINK_GET_SET_NVSWITCH_FABRIC_ADDR_PARAMS = struct_NV2080_CTRL_INTERNAL_NVLINK_GET_SET_NVSWITCH_FABRIC_ADDR_PARAMS
class struct_NV2080_CTRL_INTERNAL_BIF_GET_ASPM_L1_FLAGS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_BIF_GET_ASPM_L1_FLAGS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_BIF_GET_ASPM_L1_FLAGS_PARAMS._fields_ = [
    ('bCyaMaskL1', ctypes.c_ubyte),
    ('bEnableAspmDtL1', ctypes.c_ubyte),
]

NV2080_CTRL_INTERNAL_BIF_GET_ASPM_L1_FLAGS_PARAMS = struct_NV2080_CTRL_INTERNAL_BIF_GET_ASPM_L1_FLAGS_PARAMS
class struct_NV2080_CTRL_INTERNAL_PERF_CF_CONTROLLERS_SET_MAX_VGPU_VM_COUNT_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_PERF_CF_CONTROLLERS_SET_MAX_VGPU_VM_COUNT_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_PERF_CF_CONTROLLERS_SET_MAX_VGPU_VM_COUNT_PARAMS._fields_ = [
    ('maxActiveVGpuVMCount', ctypes.c_ubyte),
]

NV2080_CTRL_INTERNAL_PERF_CF_CONTROLLERS_SET_MAX_VGPU_VM_COUNT_PARAMS = struct_NV2080_CTRL_INTERNAL_PERF_CF_CONTROLLERS_SET_MAX_VGPU_VM_COUNT_PARAMS
class struct_NV2080_CTRL_INTERNAL_MEMSYS_PROGRAM_RAW_COMPRESSION_MODE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_MEMSYS_PROGRAM_RAW_COMPRESSION_MODE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_MEMSYS_PROGRAM_RAW_COMPRESSION_MODE_PARAMS._fields_ = [
    ('bRawMode', ctypes.c_ubyte),
]

NV2080_CTRL_INTERNAL_MEMSYS_PROGRAM_RAW_COMPRESSION_MODE_PARAMS = struct_NV2080_CTRL_INTERNAL_MEMSYS_PROGRAM_RAW_COMPRESSION_MODE_PARAMS
class struct_NV2080_CTRL_INTERNAL_CCU_MAP_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_CCU_MAP_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_CCU_MAP_INFO_PARAMS._fields_ = [
    ('phyAddr', ctypes.c_uint64 * 9),
]

NV2080_CTRL_INTERNAL_CCU_MAP_INFO_PARAMS = struct_NV2080_CTRL_INTERNAL_CCU_MAP_INFO_PARAMS
class struct_NV2080_CTRL_INTERNAL_CCU_UNMAP_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_CCU_UNMAP_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_CCU_UNMAP_INFO_PARAMS._fields_ = [
    ('bDevShrBuf', ctypes.c_ubyte),
    ('bMigShrBuf', ctypes.c_ubyte),
]

NV2080_CTRL_INTERNAL_CCU_UNMAP_INFO_PARAMS = struct_NV2080_CTRL_INTERNAL_CCU_UNMAP_INFO_PARAMS
class struct_NV2080_CTRL_INTERNAL_SET_P2P_CAPS_PEER_INFO(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_SET_P2P_CAPS_PEER_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_SET_P2P_CAPS_PEER_INFO._fields_ = [
    ('gpuId', ctypes.c_uint32),
    ('gpuInstance', ctypes.c_uint32),
    ('p2pCaps', ctypes.c_uint32),
    ('p2pOptimalReadCEs', ctypes.c_uint32),
    ('p2pOptimalWriteCEs', ctypes.c_uint32),
    ('p2pCapsStatus', ctypes.c_ubyte * 9),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('busPeerId', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_SET_P2P_CAPS_PEER_INFO = struct_NV2080_CTRL_INTERNAL_SET_P2P_CAPS_PEER_INFO
class struct_NV2080_CTRL_INTERNAL_SET_P2P_CAPS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_SET_P2P_CAPS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_SET_P2P_CAPS_PARAMS._fields_ = [
    ('peerGpuCount', ctypes.c_uint32),
    ('peerGpuInfos', struct_NV2080_CTRL_INTERNAL_SET_P2P_CAPS_PEER_INFO * 32),
]

NV2080_CTRL_INTERNAL_SET_P2P_CAPS_PARAMS = struct_NV2080_CTRL_INTERNAL_SET_P2P_CAPS_PARAMS
class struct_NV2080_CTRL_INTERNAL_REMOVE_P2P_CAPS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_REMOVE_P2P_CAPS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_REMOVE_P2P_CAPS_PARAMS._fields_ = [
    ('peerGpuIdCount', ctypes.c_uint32),
    ('peerGpuIds', ctypes.c_uint32 * 32),
]

NV2080_CTRL_INTERNAL_REMOVE_P2P_CAPS_PARAMS = struct_NV2080_CTRL_INTERNAL_REMOVE_P2P_CAPS_PARAMS
class struct_NV2080_CTRL_INTERNAL_GET_PCIE_P2P_CAPS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GET_PCIE_P2P_CAPS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GET_PCIE_P2P_CAPS_PARAMS._fields_ = [
    ('bCommonPciSwitchFound', ctypes.c_ubyte),
    ('p2pReadCapsStatus', ctypes.c_ubyte),
    ('p2pWriteCapsStatus', ctypes.c_ubyte),
]

NV2080_CTRL_INTERNAL_GET_PCIE_P2P_CAPS_PARAMS = struct_NV2080_CTRL_INTERNAL_GET_PCIE_P2P_CAPS_PARAMS
class struct_NV2080_CTRL_INTERNAL_BIF_SET_PCIE_RO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_BIF_SET_PCIE_RO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_BIF_SET_PCIE_RO_PARAMS._fields_ = [
    ('enableRo', ctypes.c_ubyte),
]

NV2080_CTRL_INTERNAL_BIF_SET_PCIE_RO_PARAMS = struct_NV2080_CTRL_INTERNAL_BIF_SET_PCIE_RO_PARAMS
class struct_NV2080_CTRL_CMD_INTERNAL_DISPLAY_PRE_UNIX_CONSOLE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_INTERNAL_DISPLAY_PRE_UNIX_CONSOLE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_INTERNAL_DISPLAY_PRE_UNIX_CONSOLE_PARAMS._fields_ = [
    ('bSave', ctypes.c_ubyte),
    ('bUseVbios', ctypes.c_ubyte),
]

NV2080_CTRL_CMD_INTERNAL_DISPLAY_PRE_UNIX_CONSOLE_PARAMS = struct_NV2080_CTRL_CMD_INTERNAL_DISPLAY_PRE_UNIX_CONSOLE_PARAMS
class struct_NV2080_CTRL_CMD_INTERNAL_DISPLAY_POST_UNIX_CONSOLE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_INTERNAL_DISPLAY_POST_UNIX_CONSOLE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_INTERNAL_DISPLAY_POST_UNIX_CONSOLE_PARAMS._fields_ = [
    ('bSave', ctypes.c_ubyte),
    ('bUseVbios', ctypes.c_ubyte),
    ('bVbiosCallSuccessful', ctypes.c_ubyte),
]

NV2080_CTRL_CMD_INTERNAL_DISPLAY_POST_UNIX_CONSOLE_PARAMS = struct_NV2080_CTRL_CMD_INTERNAL_DISPLAY_POST_UNIX_CONSOLE_PARAMS
class struct_NV2080_CTRL_INTERNAL_MIGMGR_COMPUTE_PROFILE(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_MIGMGR_COMPUTE_PROFILE._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_MIGMGR_COMPUTE_PROFILE._fields_ = [
    ('computeSize', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('gfxGpcCount', ctypes.c_uint32),
    ('gpcCount', ctypes.c_uint32),
    ('veidCount', ctypes.c_uint32),
    ('smCount', ctypes.c_uint32),
    ('physicalSlots', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_MIGMGR_COMPUTE_PROFILE = struct_NV2080_CTRL_INTERNAL_MIGMGR_COMPUTE_PROFILE
class struct_NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_COMPUTE_PROFILES_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_COMPUTE_PROFILES_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_COMPUTE_PROFILES_PARAMS._fields_ = [
    ('profileCount', ctypes.c_uint32),
    ('profiles', struct_NV2080_CTRL_INTERNAL_MIGMGR_COMPUTE_PROFILE * 6),
]

NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_COMPUTE_PROFILES_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_COMPUTE_PROFILES_PARAMS
NV2080_CTRL_INTERNAL_STATIC_KMIGMGR_GET_COMPUTE_PROFILES_PARAMS = struct_NV2080_CTRL_INTERNAL_STATIC_MIGMGR_GET_COMPUTE_PROFILES_PARAMS
class struct_NV2080_CTRL_INTERNAL_CCU_STREAM_STATE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_CCU_STREAM_STATE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_CCU_STREAM_STATE_PARAMS._fields_ = [
    ('bStreamState', ctypes.c_ubyte),
]

NV2080_CTRL_INTERNAL_CCU_STREAM_STATE_PARAMS = struct_NV2080_CTRL_INTERNAL_CCU_STREAM_STATE_PARAMS
class struct_NV2080_CTRL_INTERNAL_GSYNC_ATTACH_AND_INIT_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GSYNC_ATTACH_AND_INIT_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GSYNC_ATTACH_AND_INIT_PARAMS._fields_ = [
    ('bExtDevFound', ctypes.c_ubyte),
]

NV2080_CTRL_INTERNAL_GSYNC_ATTACH_AND_INIT_PARAMS = struct_NV2080_CTRL_INTERNAL_GSYNC_ATTACH_AND_INIT_PARAMS
class struct_NV2080_CTRL_INTERNAL_GSYNC_OPTIMIZE_TIMING_PARAMETERS_PARAMS(Structure):
    pass

class struct_NV30F1_CTRL_GSYNC_GET_OPTIMIZED_TIMING_PARAMS(Structure):
    pass

struct_NV30F1_CTRL_GSYNC_GET_OPTIMIZED_TIMING_PARAMS._pack_ = 1 # source:False
struct_NV30F1_CTRL_GSYNC_GET_OPTIMIZED_TIMING_PARAMS._fields_ = [
    ('gpuId', ctypes.c_uint32),
    ('output', ctypes.c_uint32),
    ('protocol', ctypes.c_uint32),
    ('structure', ctypes.c_uint32),
    ('adjust', ctypes.c_uint32),
    ('hDeltaStep', ctypes.c_uint32),
    ('hDeltaMax', ctypes.c_uint32),
    ('vDeltaStep', ctypes.c_uint32),
    ('vDeltaMax', ctypes.c_uint32),
    ('hSyncEnd', ctypes.c_uint32),
    ('hBlankEnd', ctypes.c_uint32),
    ('hBlankStart', ctypes.c_uint32),
    ('hTotal', ctypes.c_uint32),
    ('vSyncEnd', ctypes.c_uint32),
    ('vBlankEnd', ctypes.c_uint32),
    ('vBlankStart', ctypes.c_uint32),
    ('vInterlacedBlankEnd', ctypes.c_uint32),
    ('vInterlacedBlankStart', ctypes.c_uint32),
    ('vTotal', ctypes.c_uint32),
    ('refreshX10K', ctypes.c_uint32),
    ('pixelClockHz', ctypes.c_uint32),
    ('bOptimized', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

struct_NV2080_CTRL_INTERNAL_GSYNC_OPTIMIZE_TIMING_PARAMETERS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GSYNC_OPTIMIZE_TIMING_PARAMETERS_PARAMS._fields_ = [
    ('timingParameters', struct_NV30F1_CTRL_GSYNC_GET_OPTIMIZED_TIMING_PARAMS),
]

NV2080_CTRL_INTERNAL_GSYNC_OPTIMIZE_TIMING_PARAMETERS_PARAMS = struct_NV2080_CTRL_INTERNAL_GSYNC_OPTIMIZE_TIMING_PARAMETERS_PARAMS
class struct_NV2080_CTRL_INTERNAL_GSYNC_GET_DISPLAY_IDS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GSYNC_GET_DISPLAY_IDS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GSYNC_GET_DISPLAY_IDS_PARAMS._fields_ = [
    ('displayIds', ctypes.c_uint32 * 4),
]

NV2080_CTRL_INTERNAL_GSYNC_GET_DISPLAY_IDS_PARAMS = struct_NV2080_CTRL_INTERNAL_GSYNC_GET_DISPLAY_IDS_PARAMS
class struct_NV2080_CTRL_INTERNAL_GSYNC_SET_STREO_SYNC_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GSYNC_SET_STREO_SYNC_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GSYNC_SET_STREO_SYNC_PARAMS._fields_ = [
    ('slave', ctypes.c_uint32 * 4),
    ('localSlave', ctypes.c_uint32 * 4),
    ('master', ctypes.c_uint32 * 4),
    ('regStatus', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_GSYNC_SET_STREO_SYNC_PARAMS = struct_NV2080_CTRL_INTERNAL_GSYNC_SET_STREO_SYNC_PARAMS
class struct_NV2080_CTRL_INTERNAL_GSYNC_GET_VERTICAL_ACTIVE_LINES_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GSYNC_GET_VERTICAL_ACTIVE_LINES_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GSYNC_GET_VERTICAL_ACTIVE_LINES_PARAMS._fields_ = [
    ('headIdx', ctypes.c_uint32),
    ('vActiveLines', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_GSYNC_GET_VERTICAL_ACTIVE_LINES_PARAMS = struct_NV2080_CTRL_INTERNAL_GSYNC_GET_VERTICAL_ACTIVE_LINES_PARAMS
class struct_NV2080_CTRL_INTERNAL_GSYNC_IS_DISPLAYID_VALID_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GSYNC_IS_DISPLAYID_VALID_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GSYNC_IS_DISPLAYID_VALID_PARAMS._fields_ = [
    ('displays', ctypes.c_uint32),
    ('displayId', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_GSYNC_IS_DISPLAYID_VALID_PARAMS = struct_NV2080_CTRL_INTERNAL_GSYNC_IS_DISPLAYID_VALID_PARAMS
class struct_NV2080_CTRL_INTERNAL_GSYNC_SET_OR_RESTORE_RASTER_SYNC_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GSYNC_SET_OR_RESTORE_RASTER_SYNC_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GSYNC_SET_OR_RESTORE_RASTER_SYNC_PARAMS._fields_ = [
    ('bEnableMaster', ctypes.c_ubyte),
    ('bRasterSyncGpioSaved', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 2),
    ('bRasterSyncGpioDirection', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_GSYNC_SET_OR_RESTORE_RASTER_SYNC_PARAMS = struct_NV2080_CTRL_INTERNAL_GSYNC_SET_OR_RESTORE_RASTER_SYNC_PARAMS
class struct_NV2080_CTRL_INTERNAL_FBSR_INIT_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_FBSR_INIT_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_FBSR_INIT_PARAMS._fields_ = [
    ('fbsrType', ctypes.c_uint32),
    ('numRegions', ctypes.c_uint32),
    ('hClient', ctypes.c_uint32),
    ('hSysMem', ctypes.c_uint32),
    ('gspFbAllocsSysOffset', ctypes.c_uint64),
    ('bEnteringGcoffState', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 7),
]

NV2080_CTRL_INTERNAL_FBSR_INIT_PARAMS = struct_NV2080_CTRL_INTERNAL_FBSR_INIT_PARAMS
class struct_NV2080_CTRL_INTERNAL_FBSR_SEND_REGION_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_FBSR_SEND_REGION_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_FBSR_SEND_REGION_INFO_PARAMS._fields_ = [
    ('fbsrType', ctypes.c_uint32),
    ('hClient', ctypes.c_uint32),
    ('hVidMem', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('vidOffset', ctypes.c_uint64),
    ('sysOffset', ctypes.c_uint64),
    ('size', ctypes.c_uint64),
]

NV2080_CTRL_INTERNAL_FBSR_SEND_REGION_INFO_PARAMS = struct_NV2080_CTRL_INTERNAL_FBSR_SEND_REGION_INFO_PARAMS
class struct_NV2080_CTRL_INTERNAL_MEMMGR_GET_VGPU_CONFIG_HOST_RESERVED_FB_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_MEMMGR_GET_VGPU_CONFIG_HOST_RESERVED_FB_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_MEMMGR_GET_VGPU_CONFIG_HOST_RESERVED_FB_PARAMS._fields_ = [
    ('hostReservedFb', ctypes.c_uint64),
    ('vgpuTypeId', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NV2080_CTRL_INTERNAL_MEMMGR_GET_VGPU_CONFIG_HOST_RESERVED_FB_PARAMS = struct_NV2080_CTRL_INTERNAL_MEMMGR_GET_VGPU_CONFIG_HOST_RESERVED_FB_PARAMS
class struct_NV2080_CTRL_INTERNAL_INIT_BRIGHTC_STATE_LOAD_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_INIT_BRIGHTC_STATE_LOAD_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_INIT_BRIGHTC_STATE_LOAD_PARAMS._fields_ = [
    ('status', ctypes.c_uint32),
    ('backLightDataSize', ctypes.c_uint16),
    ('backLightData', ctypes.c_ubyte * 4096),
    ('PADDING_0', ctypes.c_ubyte * 2),
]

NV2080_CTRL_INTERNAL_INIT_BRIGHTC_STATE_LOAD_PARAMS = struct_NV2080_CTRL_INTERNAL_INIT_BRIGHTC_STATE_LOAD_PARAMS
class struct_NV2080_CTRL_INTERNAL_NVLINK_GET_NUM_ACTIVE_LINK_PER_IOCTRL_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_NVLINK_GET_NUM_ACTIVE_LINK_PER_IOCTRL_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_NVLINK_GET_NUM_ACTIVE_LINK_PER_IOCTRL_PARAMS._fields_ = [
    ('numActiveLinksPerIoctrl', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_NVLINK_GET_NUM_ACTIVE_LINK_PER_IOCTRL_PARAMS = struct_NV2080_CTRL_INTERNAL_NVLINK_GET_NUM_ACTIVE_LINK_PER_IOCTRL_PARAMS
class struct_NV2080_CTRL_INTERNAL_NVLINK_GET_TOTAL_NUM_LINK_PER_IOCTRL_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_NVLINK_GET_TOTAL_NUM_LINK_PER_IOCTRL_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_NVLINK_GET_TOTAL_NUM_LINK_PER_IOCTRL_PARAMS._fields_ = [
    ('numLinksPerIoctrl', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_NVLINK_GET_TOTAL_NUM_LINK_PER_IOCTRL_PARAMS = struct_NV2080_CTRL_INTERNAL_NVLINK_GET_TOTAL_NUM_LINK_PER_IOCTRL_PARAMS
class struct_NV2080_CTRL_INTERNAL_SMBPBI_PFM_REQ_HNDLR_CAP_UPDATE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_SMBPBI_PFM_REQ_HNDLR_CAP_UPDATE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_SMBPBI_PFM_REQ_HNDLR_CAP_UPDATE_PARAMS._fields_ = [
    ('bIsSysCtrlSupported', ctypes.c_ubyte),
    ('bIsPlatformLegacy', ctypes.c_ubyte),
]

NV2080_CTRL_INTERNAL_SMBPBI_PFM_REQ_HNDLR_CAP_UPDATE_PARAMS = struct_NV2080_CTRL_INTERNAL_SMBPBI_PFM_REQ_HNDLR_CAP_UPDATE_PARAMS
class struct_NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_DATA_SMBPBI(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_DATA_SMBPBI._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_DATA_SMBPBI._fields_ = [
    ('sensorId', ctypes.c_uint32),
    ('limit', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_DATA_SMBPBI = struct_NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_DATA_SMBPBI
class struct_NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_DATA(Structure):
    pass

class union_NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_DATA_data(Union):
    _pack_ = 1 # source:False
    _fields_ = [
    ('smbpbi', NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_DATA_SMBPBI),
     ]

struct_NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_DATA._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_DATA._fields_ = [
    ('type', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('data', union_NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_DATA_data),
]

NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_DATA = struct_NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_DATA
class struct_NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_PARAMS._fields_ = [
    ('flags', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('syncData', NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_DATA),
]

NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_PARAMS = struct_NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_PARAMS
NV2080_CTRL_INTERNAL_PMGR_PFM_REQ_HNDLR_STATE_LOAD_SYNC_PARAMS = struct_NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_PARAMS
NV2080_CTRL_INTERNAL_THERM_PFM_REQ_HNDLR_STATE_INIT_SYNC_PARAMS = struct_NV2080_CTRL_INTERNAL_PFM_REQ_HNDLR_STATE_SYNC_PARAMS
class struct_NV2080_CTRL_INTERNAL_GET_COHERENT_FB_APERTURE_SIZE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GET_COHERENT_FB_APERTURE_SIZE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GET_COHERENT_FB_APERTURE_SIZE_PARAMS._fields_ = [
    ('coherentFbApertureSize', ctypes.c_uint64),
]

NV2080_CTRL_INTERNAL_GET_COHERENT_FB_APERTURE_SIZE_PARAMS = struct_NV2080_CTRL_INTERNAL_GET_COHERENT_FB_APERTURE_SIZE_PARAMS
class struct_NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_GET_PM1_STATE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_GET_PM1_STATE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_GET_PM1_STATE_PARAMS._fields_ = [
    ('flag', ctypes.c_ubyte),
    ('bStatus', ctypes.c_ubyte),
]

NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_GET_PM1_STATE_PARAMS = struct_NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_GET_PM1_STATE_PARAMS
class struct_NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_SET_PM1_STATE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_SET_PM1_STATE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_SET_PM1_STATE_PARAMS._fields_ = [
    ('bEnable', ctypes.c_ubyte),
]

NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_SET_PM1_STATE_PARAMS = struct_NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_SET_PM1_STATE_PARAMS
class struct_NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_UPDATE_EDPP_LIMIT_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_UPDATE_EDPP_LIMIT_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_UPDATE_EDPP_LIMIT_PARAMS._fields_ = [
    ('bEnable', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('clientLimit', ctypes.c_uint32),
]

NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_UPDATE_EDPP_LIMIT_PARAMS = struct_NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_UPDATE_EDPP_LIMIT_PARAMS
class struct_NV2080_CTRL_CMD_INTERNAL_THERM_PFM_REQ_HNDLR_UPDATE_TGPU_LIMIT_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_INTERNAL_THERM_PFM_REQ_HNDLR_UPDATE_TGPU_LIMIT_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_INTERNAL_THERM_PFM_REQ_HNDLR_UPDATE_TGPU_LIMIT_PARAMS._fields_ = [
    ('targetTemp', ctypes.c_int32),
]

NV2080_CTRL_CMD_INTERNAL_THERM_PFM_REQ_HNDLR_UPDATE_TGPU_LIMIT_PARAMS = struct_NV2080_CTRL_CMD_INTERNAL_THERM_PFM_REQ_HNDLR_UPDATE_TGPU_LIMIT_PARAMS
class struct_NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_CONFIGURE_TGP_MODE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_CONFIGURE_TGP_MODE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_CONFIGURE_TGP_MODE_PARAMS._fields_ = [
    ('bEnable', ctypes.c_ubyte),
]

NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_CONFIGURE_TGP_MODE_PARAMS = struct_NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_CONFIGURE_TGP_MODE_PARAMS
class struct_NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_CONFIGURE_TURBO_V2_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_CONFIGURE_TURBO_V2_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_CONFIGURE_TURBO_V2_PARAMS._fields_ = [
    ('ctgpOffsetmW', ctypes.c_uint32),
]

NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_CONFIGURE_TURBO_V2_PARAMS = struct_NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_CONFIGURE_TURBO_V2_PARAMS
class struct_NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_GET_VPSTATE_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_GET_VPSTATE_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_GET_VPSTATE_INFO_PARAMS._fields_ = [
    ('bVpsPs20Supported', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('vPstateIdxHighest', ctypes.c_uint32),
]

NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_GET_VPSTATE_INFO_PARAMS = struct_NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_GET_VPSTATE_INFO_PARAMS
class struct_NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_GET_VPSTATE_MAPPING_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_GET_VPSTATE_MAPPING_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_GET_VPSTATE_MAPPING_PARAMS._fields_ = [
    ('pStateIdx', ctypes.c_uint32),
    ('vPstateIdxMapping', ctypes.c_uint32),
]

NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_GET_VPSTATE_MAPPING_PARAMS = struct_NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_GET_VPSTATE_MAPPING_PARAMS
class struct_NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_SET_VPSTATE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_SET_VPSTATE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_SET_VPSTATE_PARAMS._fields_ = [
    ('vPstateIdx', ctypes.c_uint32),
]

NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_SET_VPSTATE_PARAMS = struct_NV2080_CTRL_CMD_INTERNAL_PERF_PFM_REQ_HNDLR_SET_VPSTATE_PARAMS
class struct_NV2080_CTRL_INTERNAL_GCX_ENTRY_PREREQUISITE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_GCX_ENTRY_PREREQUISITE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_GCX_ENTRY_PREREQUISITE_PARAMS._fields_ = [
    ('bIsGC6Satisfied', ctypes.c_ubyte),
    ('bIsGCOFFSatisfied', ctypes.c_ubyte),
]

NV2080_CTRL_INTERNAL_GCX_ENTRY_PREREQUISITE_PARAMS = struct_NV2080_CTRL_INTERNAL_GCX_ENTRY_PREREQUISITE_PARAMS
class struct_NV2080_CTRL_INTERNAL_FIFO_GET_NUM_SECURE_CHANNELS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_FIFO_GET_NUM_SECURE_CHANNELS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_FIFO_GET_NUM_SECURE_CHANNELS_PARAMS._fields_ = [
    ('maxSec2SecureChannels', ctypes.c_uint32),
    ('maxCeSecureChannels', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_FIFO_GET_NUM_SECURE_CHANNELS_PARAMS = struct_NV2080_CTRL_INTERNAL_FIFO_GET_NUM_SECURE_CHANNELS_PARAMS
class struct_NV2080_CTRL_INTERNAL_BIF_DISABLE_SYSTEM_MEMORY_ACCESS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_BIF_DISABLE_SYSTEM_MEMORY_ACCESS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_BIF_DISABLE_SYSTEM_MEMORY_ACCESS_PARAMS._fields_ = [
    ('bDisable', ctypes.c_ubyte),
]

NV2080_CTRL_INTERNAL_BIF_DISABLE_SYSTEM_MEMORY_ACCESS_PARAMS = struct_NV2080_CTRL_INTERNAL_BIF_DISABLE_SYSTEM_MEMORY_ACCESS_PARAMS
class struct_NV2080_CTRL_INTERNAL_DISP_PINSETS_TO_LOCKPINS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_DISP_PINSETS_TO_LOCKPINS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_DISP_PINSETS_TO_LOCKPINS_PARAMS._fields_ = [
    ('pinSetIn', ctypes.c_uint32),
    ('pinSetOut', ctypes.c_uint32),
    ('bMasterScanLock', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('masterScanLockPin', ctypes.c_uint32),
    ('bSlaveScanLock', ctypes.c_ubyte),
    ('PADDING_1', ctypes.c_ubyte * 3),
    ('slaveScanLockPin', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_DISP_PINSETS_TO_LOCKPINS_PARAMS = struct_NV2080_CTRL_INTERNAL_DISP_PINSETS_TO_LOCKPINS_PARAMS
class struct_NV2080_CTRL_INTERNAL_DISP_SET_SLI_LINK_GPIO_SW_CONTROL_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_DISP_SET_SLI_LINK_GPIO_SW_CONTROL_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_DISP_SET_SLI_LINK_GPIO_SW_CONTROL_PARAMS._fields_ = [
    ('pinSet', ctypes.c_uint32),
    ('gpioFunction', ctypes.c_uint32),
    ('gpioPin', ctypes.c_uint32),
    ('gpioDirection', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_INTERNAL_DISP_SET_SLI_LINK_GPIO_SW_CONTROL_PARAMS = struct_NV2080_CTRL_INTERNAL_DISP_SET_SLI_LINK_GPIO_SW_CONTROL_PARAMS
class struct_NV2080_CTRL_INTERNAL_EDID_DATA(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_EDID_DATA._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_EDID_DATA._fields_ = [
    ('status', ctypes.c_uint32),
    ('acpiId', ctypes.c_uint32),
    ('bufferSize', ctypes.c_uint32),
    ('edidBuffer', ctypes.c_ubyte * 512),
]

NV2080_CTRL_INTERNAL_EDID_DATA = struct_NV2080_CTRL_INTERNAL_EDID_DATA
class struct_NV2080_CTRL_CMD_INTERNAL_SET_STATIC_EDID_DATA_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_INTERNAL_SET_STATIC_EDID_DATA_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_INTERNAL_SET_STATIC_EDID_DATA_PARAMS._fields_ = [
    ('tableLen', ctypes.c_uint32),
    ('edidTable', struct_NV2080_CTRL_INTERNAL_EDID_DATA * 16),
]

NV2080_CTRL_CMD_INTERNAL_SET_STATIC_EDID_DATA_PARAMS = struct_NV2080_CTRL_CMD_INTERNAL_SET_STATIC_EDID_DATA_PARAMS
class struct_NV2080_CTRL_CMD_INTERNAL_GET_GPU_FABRIC_PROBE_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_INTERNAL_GET_GPU_FABRIC_PROBE_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_INTERNAL_GET_GPU_FABRIC_PROBE_INFO_PARAMS._fields_ = [
    ('numProbes', ctypes.c_uint64),
]

NV2080_CTRL_CMD_INTERNAL_GET_GPU_FABRIC_PROBE_INFO_PARAMS = struct_NV2080_CTRL_CMD_INTERNAL_GET_GPU_FABRIC_PROBE_INFO_PARAMS
class struct_NV2080_CTRL_CMD_INTERNAL_START_GPU_FABRIC_PROBE_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_INTERNAL_START_GPU_FABRIC_PROBE_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_INTERNAL_START_GPU_FABRIC_PROBE_INFO_PARAMS._fields_ = [
    ('bwMode', ctypes.c_ubyte),
]

NV2080_CTRL_CMD_INTERNAL_START_GPU_FABRIC_PROBE_INFO_PARAMS = struct_NV2080_CTRL_CMD_INTERNAL_START_GPU_FABRIC_PROBE_INFO_PARAMS
class struct_NV2080_CTRL_CMD_INTERNAL_RESUME_GPU_FABRIC_PROBE_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_INTERNAL_RESUME_GPU_FABRIC_PROBE_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_INTERNAL_RESUME_GPU_FABRIC_PROBE_INFO_PARAMS._fields_ = [
    ('bwMode', ctypes.c_ubyte),
]

NV2080_CTRL_CMD_INTERNAL_RESUME_GPU_FABRIC_PROBE_INFO_PARAMS = struct_NV2080_CTRL_CMD_INTERNAL_RESUME_GPU_FABRIC_PROBE_INFO_PARAMS
class struct_NV2080_CTRL_INTERNAL_CONF_COMPUTE_GET_STATIC_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_CONF_COMPUTE_GET_STATIC_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_CONF_COMPUTE_GET_STATIC_INFO_PARAMS._fields_ = [
    ('bIsBar1Trusted', ctypes.c_ubyte),
    ('bIsPcieTrusted', ctypes.c_ubyte),
]

NV2080_CTRL_INTERNAL_CONF_COMPUTE_GET_STATIC_INFO_PARAMS = struct_NV2080_CTRL_INTERNAL_CONF_COMPUTE_GET_STATIC_INFO_PARAMS
class struct_NV2080_CTRL_INTERNAL_CONF_COMPUTE_IVMASK(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_CONF_COMPUTE_IVMASK._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_CONF_COMPUTE_IVMASK._fields_ = [
    ('ivMask', ctypes.c_uint32 * 3),
]

NV2080_CTRL_INTERNAL_CONF_COMPUTE_IVMASK = struct_NV2080_CTRL_INTERNAL_CONF_COMPUTE_IVMASK
class struct_NV2080_CTRL_INTERNAL_CONF_COMPUTE_DERIVE_SWL_KEYS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_CONF_COMPUTE_DERIVE_SWL_KEYS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_CONF_COMPUTE_DERIVE_SWL_KEYS_PARAMS._fields_ = [
    ('engineId', ctypes.c_uint32),
    ('ivMaskSet', struct_NV2080_CTRL_INTERNAL_CONF_COMPUTE_IVMASK * 2),
]

NV2080_CTRL_INTERNAL_CONF_COMPUTE_DERIVE_SWL_KEYS_PARAMS = struct_NV2080_CTRL_INTERNAL_CONF_COMPUTE_DERIVE_SWL_KEYS_PARAMS
class struct_NV2080_CTRL_INTERNAL_CONF_COMPUTE_DERIVE_LCE_KEYS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_CONF_COMPUTE_DERIVE_LCE_KEYS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_CONF_COMPUTE_DERIVE_LCE_KEYS_PARAMS._fields_ = [
    ('engineId', ctypes.c_uint32),
    ('ivMaskSet', struct_NV2080_CTRL_INTERNAL_CONF_COMPUTE_IVMASK * 6),
]

NV2080_CTRL_INTERNAL_CONF_COMPUTE_DERIVE_LCE_KEYS_PARAMS = struct_NV2080_CTRL_INTERNAL_CONF_COMPUTE_DERIVE_LCE_KEYS_PARAMS
class struct_NV2080_CTRL_CMD_INTERNAL_CONF_COMPUTE_SET_GPU_STATE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_INTERNAL_CONF_COMPUTE_SET_GPU_STATE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_INTERNAL_CONF_COMPUTE_SET_GPU_STATE_PARAMS._fields_ = [
    ('bAcceptClientRequest', ctypes.c_ubyte),
]

NV2080_CTRL_CMD_INTERNAL_CONF_COMPUTE_SET_GPU_STATE_PARAMS = struct_NV2080_CTRL_CMD_INTERNAL_CONF_COMPUTE_SET_GPU_STATE_PARAMS

# values for enumeration 'NV2080_CTRL_MEMMGR_MEMORY_OP'
NV2080_CTRL_MEMMGR_MEMORY_OP__enumvalues = {
    0: 'NV2080_CTRL_MEMMGR_MEMORY_OP_MEMCPY',
    1: 'NV2080_CTRL_MEMMGR_MEMORY_OP_MEMSET',
}
NV2080_CTRL_MEMMGR_MEMORY_OP_MEMCPY = 0
NV2080_CTRL_MEMMGR_MEMORY_OP_MEMSET = 1
NV2080_CTRL_MEMMGR_MEMORY_OP = ctypes.c_uint32 # enum
class struct_NV2080_CTRL_INTERNAL_TRANSFER_SURFACE_INFO(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_TRANSFER_SURFACE_INFO._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_TRANSFER_SURFACE_INFO._fields_ = [
    ('baseAddr', ctypes.c_uint64),
    ('size', ctypes.c_uint64),
    ('offset', ctypes.c_uint64),
    ('aperture', ctypes.c_uint32),
    ('cpuCacheAttrib', ctypes.c_uint32),
]

NV2080_CTRL_INTERNAL_TRANSFER_SURFACE_INFO = struct_NV2080_CTRL_INTERNAL_TRANSFER_SURFACE_INFO
class struct_NV2080_CTRL_INTERNAL_MEMMGR_MEMORY_TRANSFER_WITH_GSP_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_MEMMGR_MEMORY_TRANSFER_WITH_GSP_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_MEMMGR_MEMORY_TRANSFER_WITH_GSP_PARAMS._fields_ = [
    ('src', NV2080_CTRL_INTERNAL_TRANSFER_SURFACE_INFO),
    ('authTag', ctypes.c_ubyte * 16),
    ('dst', NV2080_CTRL_INTERNAL_TRANSFER_SURFACE_INFO),
    ('transferSize', ctypes.c_uint64),
    ('value', ctypes.c_uint32),
    ('memop', NV2080_CTRL_MEMMGR_MEMORY_OP),
]

NV2080_CTRL_INTERNAL_MEMMGR_MEMORY_TRANSFER_WITH_GSP_PARAMS = struct_NV2080_CTRL_INTERNAL_MEMMGR_MEMORY_TRANSFER_WITH_GSP_PARAMS
class struct_NV2080_CTRL_INTERNAL_MEMSYS_GET_LOCAL_ATS_CONFIG_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_MEMSYS_GET_LOCAL_ATS_CONFIG_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_MEMSYS_GET_LOCAL_ATS_CONFIG_PARAMS._fields_ = [
    ('addrSysPhys', ctypes.c_uint64),
    ('addrWidth', ctypes.c_uint32),
    ('mask', ctypes.c_uint32),
    ('maskWidth', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

NV2080_CTRL_INTERNAL_MEMSYS_GET_LOCAL_ATS_CONFIG_PARAMS = struct_NV2080_CTRL_INTERNAL_MEMSYS_GET_LOCAL_ATS_CONFIG_PARAMS
class struct_NV2080_CTRL_INTERNAL_MEMSYS_SET_PEER_ATS_CONFIG_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_MEMSYS_SET_PEER_ATS_CONFIG_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_MEMSYS_SET_PEER_ATS_CONFIG_PARAMS._fields_ = [
    ('peerId', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('addrSysPhys', ctypes.c_uint64),
    ('addrWidth', ctypes.c_uint32),
    ('mask', ctypes.c_uint32),
    ('maskWidth', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
]

NV2080_CTRL_INTERNAL_MEMSYS_SET_PEER_ATS_CONFIG_PARAMS = struct_NV2080_CTRL_INTERNAL_MEMSYS_SET_PEER_ATS_CONFIG_PARAMS
class struct_NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_GET_EDPP_LIMIT_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_GET_EDPP_LIMIT_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_GET_EDPP_LIMIT_INFO_PARAMS._fields_ = [
    ('limitMin', ctypes.c_uint32),
    ('limitRated', ctypes.c_uint32),
    ('limitMax', ctypes.c_uint32),
    ('limitCurr', ctypes.c_uint32),
    ('limitBattRated', ctypes.c_uint32),
    ('limitBattMax', ctypes.c_uint32),
]

NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_GET_EDPP_LIMIT_INFO_PARAMS = struct_NV2080_CTRL_CMD_INTERNAL_PMGR_PFM_REQ_HNDLR_GET_EDPP_LIMIT_INFO_PARAMS
class struct_NV2080_CTRL_INTERNAL_INIT_USER_SHARED_DATA_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_INIT_USER_SHARED_DATA_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_INIT_USER_SHARED_DATA_PARAMS._fields_ = [
    ('physAddr', ctypes.c_uint64),
]

NV2080_CTRL_INTERNAL_INIT_USER_SHARED_DATA_PARAMS = struct_NV2080_CTRL_INTERNAL_INIT_USER_SHARED_DATA_PARAMS
class struct_NV2080_CTRL_INTERNAL_USER_SHARED_DATA_SET_DATA_POLL_PARAMS(Structure):
    pass

struct_NV2080_CTRL_INTERNAL_USER_SHARED_DATA_SET_DATA_POLL_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_INTERNAL_USER_SHARED_DATA_SET_DATA_POLL_PARAMS._fields_ = [
    ('polledDataMask', ctypes.c_uint64),
]

NV2080_CTRL_INTERNAL_USER_SHARED_DATA_SET_DATA_POLL_PARAMS = struct_NV2080_CTRL_INTERNAL_USER_SHARED_DATA_SET_DATA_POLL_PARAMS
class struct_NV2080_CTRL_CMD_INTERNAL_GSP_START_TRACE_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_INTERNAL_GSP_START_TRACE_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_INTERNAL_GSP_START_TRACE_INFO_PARAMS._fields_ = [
    ('tracepointMask', ctypes.c_uint64),
    ('bufferSize', ctypes.c_uint32),
    ('bufferWatermark', ctypes.c_uint32),
    ('bStart', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 7),
]

NV2080_CTRL_CMD_INTERNAL_GSP_START_TRACE_INFO_PARAMS = struct_NV2080_CTRL_CMD_INTERNAL_GSP_START_TRACE_INFO_PARAMS
class struct_NV2080_CTRL_CMD_INTERNAL_GET_ENABLED_SEC2_CLASSES_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_INTERNAL_GET_ENABLED_SEC2_CLASSES_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_INTERNAL_GET_ENABLED_SEC2_CLASSES_PARAMS._fields_ = [
    ('bMaxwellSec2Enabled', ctypes.c_ubyte),
    ('bNv95A1TsecEnabled', ctypes.c_ubyte),
    ('bHopperSec2WorkLaunchAEnabled', ctypes.c_ubyte),
]

NV2080_CTRL_CMD_INTERNAL_GET_ENABLED_SEC2_CLASSES_PARAMS = struct_NV2080_CTRL_CMD_INTERNAL_GET_ENABLED_SEC2_CLASSES_PARAMS
NV2080_CTRL_INTERNAL_GR_CTXSW_SETUP_BIND_PARAMS = struct_NV2080_CTRL_GR_CTXSW_SETUP_BIND_PARAMS
NV2080_CTRL_CMD_LPWR_DIFR_CTRL = (0x20802801) # macro
NV2080_CTRL_LPWR_DIFR_CTRL_DISABLE = (0x00000001) # macro
NV2080_CTRL_LPWR_DIFR_CTRL_ENABLE = (0x00000002) # macro
NV2080_CTRL_LPWR_DIFR_CTRL_SUPPORT_STATUS = (0x00000003) # macro
NV2080_CTRL_CMD_LPWR_DIFR_CTRL_PARAMS_MESSAGE_ID = (0x1) # macro
NV2080_CTRL_LPWR_DIFR_SUPPORTED = (0x00000001) # macro
NV2080_CTRL_LPWR_DIFR_NOT_SUPPORTED = (0x00000002) # macro
NV2080_CTRL_CMD_LPWR_DIFR_PREFETCH_RESPONSE = (0x20802802) # macro
NV2080_CTRL_LPWR_DIFR_PREFETCH_SUCCESS = (0x00000001) # macro
NV2080_CTRL_LPWR_DIFR_PREFETCH_FAIL_OS_FLIPS_ENABLED = (0x00000002) # macro
NV2080_CTRL_LPWR_DIFR_PREFETCH_FAIL_INSUFFICIENT_L2_SIZE = (0x00000003) # macro
NV2080_CTRL_LPWR_DIFR_PREFETCH_FAIL_CE_HW_ERROR = (0x00000004) # macro
NV2080_CTRL_CMD_LPWR_DIFR_PREFETCH_RESPONSE_PARAMS_MESSAGE_ID = (0x2) # macro
class struct_NV2080_CTRL_CMD_LPWR_DIFR_CTRL_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_LPWR_DIFR_CTRL_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_LPWR_DIFR_CTRL_PARAMS._fields_ = [
    ('ctrlParamVal', ctypes.c_uint32),
]

NV2080_CTRL_CMD_LPWR_DIFR_CTRL_PARAMS = struct_NV2080_CTRL_CMD_LPWR_DIFR_CTRL_PARAMS
class struct_NV2080_CTRL_CMD_LPWR_DIFR_PREFETCH_RESPONSE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_LPWR_DIFR_PREFETCH_RESPONSE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_LPWR_DIFR_PREFETCH_RESPONSE_PARAMS._fields_ = [
    ('responseVal', ctypes.c_uint32),
]

NV2080_CTRL_CMD_LPWR_DIFR_PREFETCH_RESPONSE_PARAMS = struct_NV2080_CTRL_CMD_LPWR_DIFR_PREFETCH_RESPONSE_PARAMS
NV2080_CTRL_CMD_MC_GET_ARCH_INFO = (0x20801701) # macro
NV2080_CTRL_MC_GET_ARCH_INFO_PARAMS_MESSAGE_ID = (0x1) # macro
NV2080_CTRL_MC_ARCH_INFO_ARCHITECTURE_T23X = (0xE0000023) # macro
NV2080_CTRL_MC_ARCH_INFO_ARCHITECTURE_TU100 = (0x00000160) # macro
NV2080_CTRL_MC_ARCH_INFO_ARCHITECTURE_GA100 = (0x00000170) # macro
NV2080_CTRL_MC_ARCH_INFO_IMPLEMENTATION_T234 = (0x00000004) # macro
NV2080_CTRL_MC_ARCH_INFO_IMPLEMENTATION_T234D = (0x00000005) # macro
NV2080_CTRL_MC_ARCH_INFO_IMPLEMENTATION_TU100 = (0x00000000) # macro
NV2080_CTRL_MC_ARCH_INFO_IMPLEMENTATION_TU102 = (0x00000002) # macro
NV2080_CTRL_MC_ARCH_INFO_IMPLEMENTATION_TU104 = (0x00000004) # macro
NV2080_CTRL_MC_ARCH_INFO_IMPLEMENTATION_TU106 = (0x00000006) # macro
NV2080_CTRL_MC_ARCH_INFO_IMPLEMENTATION_TU116 = (0x00000008) # macro
NV2080_CTRL_MC_ARCH_INFO_IMPLEMENTATION_TU117 = (0x00000007) # macro
NV2080_CTRL_MC_ARCH_INFO_IMPLEMENTATION_GA100 = (0x00000000) # macro
NV2080_CTRL_MC_ARCH_INFO_IMPLEMENTATION_GA102 = (0x00000002) # macro
NV2080_CTRL_MC_ARCH_INFO_IMPLEMENTATION_GA103 = (0x00000003) # macro
NV2080_CTRL_MC_ARCH_INFO_IMPLEMENTATION_GA104 = (0x00000004) # macro
NV2080_CTRL_MC_ARCH_INFO_IMPLEMENTATION_GA106 = (0x00000006) # macro
NV2080_CTRL_MC_ARCH_INFO_IMPLEMENTATION_GA107 = (0x00000007) # macro
NV2080_CTRL_MC_ARCH_INFO_IMPLEMENTATION_GA10B = (0x0000000B) # macro
NV2080_CTRL_MC_ARCH_INFO_SUBREVISION_NO_SUBREVISION = (0x00000000) # macro
NV2080_CTRL_MC_ARCH_INFO_SUBREVISION_P = (0x00000001) # macro
NV2080_CTRL_MC_ARCH_INFO_SUBREVISION_Q = (0x00000002) # macro
NV2080_CTRL_MC_ARCH_INFO_SUBREVISION_R = (0x00000003) # macro
NV2080_CTRL_CMD_MC_SERVICE_INTERRUPTS = (0x20801702) # macro
NV2080_CTRL_MC_ENGINE_ID_GRAPHICS = 0x00000001 # macro
NV2080_CTRL_MC_ENGINE_ID_ALL = 0xFFFFFFFF # macro
NV2080_CTRL_MC_SERVICE_INTERRUPTS_PARAMS_MESSAGE_ID = (0x2) # macro
NV2080_CTRL_CMD_MC_GET_MANUFACTURER = (0x20801703) # macro
NV2080_CTRL_MC_GET_MANUFACTURER_PARAMS_MESSAGE_ID = (0x3) # macro
NV2080_CTRL_CMD_MC_QUERY_HOSTCLK_SLOWDOWN_STATUS = (0x20801708) # macro
NV2080_CTRL_MC_QUERY_HOSTCLK_SLOWDOWN_STATUS_PARAMS_MESSAGE_ID = (0x8) # macro
NV2080_CTRL_CMD_MC_SET_HOSTCLK_SLOWDOWN_STATUS = (0x20801709) # macro
NV2080_CTRL_MC_SET_HOSTCLK_SLOWDOWN_STATUS_PARAMS_MESSAGE_ID = (0x9) # macro
NV2080_CTRL_CMD_MC_CHANGE_REPLAYABLE_FAULT_OWNERSHIP = (0x2080170c) # macro
NV2080_CTRL_MC_CHANGE_REPLAYABLE_FAULT_OWNERSHIP_PARAMS_MESSAGE_ID = (0xC) # macro
NV2080_CTRL_CMD_MC_GET_ENGINE_NOTIFICATION_INTR_VECTORS = (0x2080170d) # macro
NV2080_CTRL_MC_GET_ENGINE_NOTIFICATION_INTR_VECTORS_MAX_ENGINES = 256 # macro
NV2080_CTRL_MC_GET_ENGINE_NOTIFICATION_INTR_VECTORS_PARAMS_MESSAGE_ID = (0xD) # macro
NV2080_CTRL_CMD_MC_GET_STATIC_INTR_TABLE = (0x2080170e) # macro
NV2080_CTRL_MC_GET_STATIC_INTR_TABLE_MAX = 32 # macro
NV2080_INTR_TYPE_NULL = (0x00000000) # macro
NV2080_INTR_TYPE_NON_REPLAYABLE_FAULT = (0x00000001) # macro
NV2080_INTR_TYPE_NON_REPLAYABLE_FAULT_ERROR = (0x00000002) # macro
NV2080_INTR_TYPE_INFO_FAULT = (0x00000003) # macro
NV2080_INTR_TYPE_REPLAYABLE_FAULT = (0x00000004) # macro
NV2080_INTR_TYPE_REPLAYABLE_FAULT_ERROR = (0x00000005) # macro
NV2080_INTR_TYPE_ACCESS_CNTR = (0x00000006) # macro
NV2080_INTR_TYPE_TMR = (0x00000007) # macro
NV2080_INTR_TYPE_CPU_DOORBELL = (0x00000008) # macro
NV2080_INTR_TYPE_GR0_FECS_LOG = (0x00000009) # macro
NV2080_INTR_TYPE_GR1_FECS_LOG = (0x0000000A) # macro
NV2080_INTR_TYPE_GR2_FECS_LOG = (0x0000000B) # macro
NV2080_INTR_TYPE_GR3_FECS_LOG = (0x0000000C) # macro
NV2080_INTR_TYPE_GR4_FECS_LOG = (0x0000000D) # macro
NV2080_INTR_TYPE_GR5_FECS_LOG = (0x0000000E) # macro
NV2080_INTR_TYPE_GR6_FECS_LOG = (0x0000000F) # macro
NV2080_INTR_TYPE_GR7_FECS_LOG = (0x00000010) # macro
NV2080_CTRL_MC_GET_STATIC_INTR_TABLE_PARAMS_MESSAGE_ID = (0xE) # macro
class struct_NV2080_CTRL_MC_GET_ARCH_INFO_PARAMS(Structure):
    pass

struct_NV2080_CTRL_MC_GET_ARCH_INFO_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_MC_GET_ARCH_INFO_PARAMS._fields_ = [
    ('architecture', ctypes.c_uint32),
    ('implementation', ctypes.c_uint32),
    ('revision', ctypes.c_uint32),
    ('subRevision', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080_CTRL_MC_GET_ARCH_INFO_PARAMS = struct_NV2080_CTRL_MC_GET_ARCH_INFO_PARAMS
class struct_NV2080_CTRL_MC_SERVICE_INTERRUPTS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_MC_SERVICE_INTERRUPTS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_MC_SERVICE_INTERRUPTS_PARAMS._fields_ = [
    ('engines', ctypes.c_uint32),
]

NV2080_CTRL_MC_SERVICE_INTERRUPTS_PARAMS = struct_NV2080_CTRL_MC_SERVICE_INTERRUPTS_PARAMS
class struct_NV2080_CTRL_MC_GET_MANUFACTURER_PARAMS(Structure):
    pass

struct_NV2080_CTRL_MC_GET_MANUFACTURER_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_MC_GET_MANUFACTURER_PARAMS._fields_ = [
    ('manufacturer', ctypes.c_uint32),
]

NV2080_CTRL_MC_GET_MANUFACTURER_PARAMS = struct_NV2080_CTRL_MC_GET_MANUFACTURER_PARAMS
class struct_NV2080_CTRL_MC_QUERY_HOSTCLK_SLOWDOWN_STATUS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_MC_QUERY_HOSTCLK_SLOWDOWN_STATUS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_MC_QUERY_HOSTCLK_SLOWDOWN_STATUS_PARAMS._fields_ = [
    ('bDisabled', ctypes.c_ubyte),
]

NV2080_CTRL_MC_QUERY_HOSTCLK_SLOWDOWN_STATUS_PARAMS = struct_NV2080_CTRL_MC_QUERY_HOSTCLK_SLOWDOWN_STATUS_PARAMS
class struct_NV2080_CTRL_MC_SET_HOSTCLK_SLOWDOWN_STATUS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_MC_SET_HOSTCLK_SLOWDOWN_STATUS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_MC_SET_HOSTCLK_SLOWDOWN_STATUS_PARAMS._fields_ = [
    ('bDisable', ctypes.c_ubyte),
]

NV2080_CTRL_MC_SET_HOSTCLK_SLOWDOWN_STATUS_PARAMS = struct_NV2080_CTRL_MC_SET_HOSTCLK_SLOWDOWN_STATUS_PARAMS
class struct_NV2080_CTRL_MC_CHANGE_REPLAYABLE_FAULT_OWNERSHIP_PARAMS(Structure):
    pass

struct_NV2080_CTRL_MC_CHANGE_REPLAYABLE_FAULT_OWNERSHIP_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_MC_CHANGE_REPLAYABLE_FAULT_OWNERSHIP_PARAMS._fields_ = [
    ('bOwnedByRm', ctypes.c_ubyte),
]

NV2080_CTRL_MC_CHANGE_REPLAYABLE_FAULT_OWNERSHIP_PARAMS = struct_NV2080_CTRL_MC_CHANGE_REPLAYABLE_FAULT_OWNERSHIP_PARAMS
class struct_NV2080_CTRL_MC_ENGINE_NOTIFICATION_INTR_VECTOR_ENTRY(Structure):
    pass

struct_NV2080_CTRL_MC_ENGINE_NOTIFICATION_INTR_VECTOR_ENTRY._pack_ = 1 # source:False
struct_NV2080_CTRL_MC_ENGINE_NOTIFICATION_INTR_VECTOR_ENTRY._fields_ = [
    ('nv2080EngineType', ctypes.c_uint32),
    ('notificationIntrVector', ctypes.c_uint32),
]

NV2080_CTRL_MC_ENGINE_NOTIFICATION_INTR_VECTOR_ENTRY = struct_NV2080_CTRL_MC_ENGINE_NOTIFICATION_INTR_VECTOR_ENTRY
class struct_NV2080_CTRL_MC_GET_ENGINE_NOTIFICATION_INTR_VECTORS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_MC_GET_ENGINE_NOTIFICATION_INTR_VECTORS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_MC_GET_ENGINE_NOTIFICATION_INTR_VECTORS_PARAMS._fields_ = [
    ('numEntries', ctypes.c_uint32),
    ('entries', struct_NV2080_CTRL_MC_ENGINE_NOTIFICATION_INTR_VECTOR_ENTRY * 256),
]

NV2080_CTRL_MC_GET_ENGINE_NOTIFICATION_INTR_VECTORS_PARAMS = struct_NV2080_CTRL_MC_GET_ENGINE_NOTIFICATION_INTR_VECTORS_PARAMS
class struct_NV2080_CTRL_MC_STATIC_INTR_ENTRY(Structure):
    pass

struct_NV2080_CTRL_MC_STATIC_INTR_ENTRY._pack_ = 1 # source:False
struct_NV2080_CTRL_MC_STATIC_INTR_ENTRY._fields_ = [
    ('nv2080IntrType', ctypes.c_uint32),
    ('pmcIntrMask', ctypes.c_uint32),
    ('intrVectorStall', ctypes.c_uint32),
    ('intrVectorNonStall', ctypes.c_uint32),
]

NV2080_CTRL_MC_STATIC_INTR_ENTRY = struct_NV2080_CTRL_MC_STATIC_INTR_ENTRY
class struct_NV2080_CTRL_MC_GET_STATIC_INTR_TABLE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_MC_GET_STATIC_INTR_TABLE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_MC_GET_STATIC_INTR_TABLE_PARAMS._fields_ = [
    ('numEntries', ctypes.c_uint32),
    ('entries', struct_NV2080_CTRL_MC_STATIC_INTR_ENTRY * 32),
]

NV2080_CTRL_MC_GET_STATIC_INTR_TABLE_PARAMS = struct_NV2080_CTRL_MC_GET_STATIC_INTR_TABLE_PARAMS
NV2080_CTRL_CMD_NVD_GET_DUMP_SIZE = (0x20802401) # macro
NV2080_CTRL_NVD_GET_DUMP_SIZE_PARAMS_MESSAGE_ID = (0x1) # macro
NV2080_CTRL_CMD_NVD_GET_DUMP = (0x20802402) # macro
NV2080_CTRL_NVD_GET_DUMP_PARAMS_MESSAGE_ID = (0x2) # macro
NV2080_CTRL_CMD_NVD_GET_NOCAT_JOURNAL = (0x20802409) # macro
NV2080_NOCAT_JOURNAL_MAX_DIAG_BUFFER = 1024 # macro
NV2080_NOCAT_JOURNAL_MAX_STR_LEN = 65 # macro
NV2080_NOCAT_JOURNAL_MAX_JOURNAL_RECORDS = 10 # macro
NV2080_NOCAT_JOURNAL_MAX_ASSERT_RECORDS = 32 # macro
NV2080_NOCAT_JOURNAL_REC_TYPE_UNKNOWN = 0 # macro
NV2080_NOCAT_JOURNAL_REC_TYPE_BUGCHECK = 1 # macro
NV2080_NOCAT_JOURNAL_REC_TYPE_ENGINE = 2 # macro
NV2080_NOCAT_JOURNAL_REC_TYPE_TDR = 3 # macro
NV2080_NOCAT_JOURNAL_REC_TYPE_RC = 4 # macro
NV2080_NOCAT_JOURNAL_REC_TYPE_ASSERT = 5 # macro
NV2080_NOCAT_JOURNAL_REC_TYPE_ANY = 6 # macro
NV2080_NOCAT_JOURNAL_REC_TYPE_COUNT = (0x7) # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_COLLECT_REQ_IDX = 0 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_GRANDFATHERED_RECORD_IDX = 1 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_ALLOCATED_IDX = 2 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_COLLECTED_IDX = 3 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_NOTIFICATIONS_IDX = 4 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_ALLOC_FAILED_IDX = 5 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_COLLECT_FAILED_IDX = 6 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_COLLECT_LOCKED_OUT_IDX = 7 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_CTRL_INSERT_RECORDS_IDX = 8 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_RPC_INSERT_RECORDS_IDX = 9 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_JOURNAL_LOCKED_IDX = 10 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_JOURNAL_LOCK_UPDATED_IDX = 11 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_JOURNAL_UNLOCKED_IDX = 12 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_NO_RECORDS_IDX = 13 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_BAD_BUFFER_IDX = 14 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_MATCH_FOUND_IDX = 15 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_NO_MATCH_IDX = 16 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_CLOSEST_FOUND_IDX = 17 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_REQUESTED_IDX = 18 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_REPORTED_IDX = 19 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_DROPPED_IDX = 20 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_UPDATE_REQ_IDX = 21 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_UPDATED_IDX = 22 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_UPDATE_FAILED_IDX = 23 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_BUSY_IDX = 24 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_BAD_PARAM_IDX = 25 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_BAD_TYPE_IDX = 26 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_RES5_IDX = 27 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_RES4_IDX = 28 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_RES3_IDX = 29 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_RES2_IDX = 30 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_RES1_IDX = 31 # macro
NV2080_NOCAT_JOURNAL_REPORT_ACTIVITY_COUNTER_COUNT = (0x20) # macro
NV2080_CTRL_NOCAT_GET_COUNTERS_ONLY = ['0', ':', '0'] # macro
NV2080_CTRL_NOCAT_GET_COUNTERS_ONLY_YES = 1 # macro
NV2080_CTRL_NOCAT_GET_COUNTERS_ONLY_NO = 0 # macro
NV2080_CTRL_NOCAT_GET_RESET_COUNTERS = ['1', ':', '1'] # macro
NV2080_CTRL_NOCAT_GET_RESET_COUNTERS_YES = 1 # macro
NV2080_CTRL_NOCAT_GET_RESET_COUNTERS_NO = 0 # macro
NV2080_CTRL_NVD_GET_NOCAT_JOURNAL_PARAMS_MESSAGE_ID = (0x9) # macro
NV2080_CTRL_CMD_NVD_SET_NOCAT_JOURNAL_DATA = (0x2080240b) # macro
NV2080_CTRL_NOCAT_JOURNAL_DATA_TYPE_EMPTY = 0 # macro
NV2080_CTRL_NOCAT_JOURNAL_DATA_TYPE_TDR_REASON = 1 # macro
NV2080_CTRL_NOCAT_JOURNAL_DATA_TYPE_SET_TAG = 2 # macro
NV2080_CTRL_NOCAT_JOURNAL_DATA_TYPE_RCLOG = 3 # macro
NV2080_CTRL_NOCAT_TDR_TYPE_NONE = 0 # macro
NV2080_CTRL_NOCAT_TDR_TYPE_LEGACY = 1 # macro
NV2080_CTRL_NOCAT_TDR_TYPE_FULLCHIP = 2 # macro
NV2080_CTRL_NOCAT_TDR_TYPE_BUSRESET = 3 # macro
NV2080_CTRL_NOCAT_TDR_TYPE_GC6_RESET = 4 # macro
NV2080_CTRL_NOCAT_TDR_TYPE_SURPRISE_REMOVAL = 5 # macro
NV2080_CTRL_NOCAT_TDR_TYPE_UCODE_RESET = 6 # macro
NV2080_CTRL_NOCAT_TDR_TYPE_TEST = 7 # macro
NV2080_CTRL_NOCAT_TAG_CLEAR = ['0', ':', '0'] # macro
NV2080_CTRL_NOCAT_TAG_CLEAR_YES = 1 # macro
NV2080_CTRL_NOCAT_TAG_CLEAR_NO = 0 # macro
NV2080_CTRL_NVD_SET_NOCAT_JOURNAL_DATA_PARAMS_MESSAGE_ID = (0xB) # macro
NV2080_CTRL_CMD_NVD_INSERT_NOCAT_JOURNAL_RECORD = (0x2080240c) # macro
NV2080_CTRL_NOCAT_INSERT_ALLOW_NULL_STR = ['0', ':', '0'] # macro
NV2080_CTRL_NOCAT_INSERT_ALLOW_NULL_STR_YES = 1 # macro
NV2080_CTRL_NOCAT_INSERT_ALLOW_NULL_STR_NO = 0 # macro
NV2080_CTRL_NOCAT_INSERT_ALLOW_0_LEN_BUFFER = ['1', ':', '1'] # macro
NV2080_CTRL_NOCAT_INSERT_ALLOW_0_LEN_BUFFER_YES = 1 # macro
NV2080_CTRL_NOCAT_INSERT_ALLOW_0_LEN_BUFFER_NO = 0 # macro
NV2080_CTRL_CMD_NVD_INSERT_NOCAT_JOURNAL_RECORD_PARAMS_MESSAGE_ID = (0xC) # macro
class struct_NV2080_CTRL_NVD_GET_DUMP_SIZE_PARAMS(Structure):
    pass

struct_NV2080_CTRL_NVD_GET_DUMP_SIZE_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_NVD_GET_DUMP_SIZE_PARAMS._fields_ = [
    ('component', ctypes.c_uint32),
    ('size', ctypes.c_uint32),
]

NV2080_CTRL_NVD_GET_DUMP_SIZE_PARAMS = struct_NV2080_CTRL_NVD_GET_DUMP_SIZE_PARAMS
class struct_NV2080_CTRL_NVD_GET_DUMP_PARAMS(Structure):
    pass

struct_NV2080_CTRL_NVD_GET_DUMP_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_NVD_GET_DUMP_PARAMS._fields_ = [
    ('pBuffer', ctypes.POINTER(None)),
    ('component', ctypes.c_uint32),
    ('size', ctypes.c_uint32),
]

NV2080_CTRL_NVD_GET_DUMP_PARAMS = struct_NV2080_CTRL_NVD_GET_DUMP_PARAMS
class struct_NV2080_NOCAT_JOURNAL_OVERCLOCK_DETAILS(Structure):
    pass

struct_NV2080_NOCAT_JOURNAL_OVERCLOCK_DETAILS._pack_ = 1 # source:False
struct_NV2080_NOCAT_JOURNAL_OVERCLOCK_DETAILS._fields_ = [
    ('userMinOffset', ctypes.c_int32),
    ('userMaxOffset', ctypes.c_int32),
    ('factoryMinOffset', ctypes.c_uint32),
    ('factoryMaxOffset', ctypes.c_uint32),
    ('lastActiveClock', ctypes.c_uint32),
    ('lastActiveVolt', ctypes.c_uint32),
    ('lastActivePoint', ctypes.c_uint32),
    ('kappa', ctypes.c_uint32),
]

NV2080_NOCAT_JOURNAL_OVERCLOCK_DETAILS = struct_NV2080_NOCAT_JOURNAL_OVERCLOCK_DETAILS
class struct_NV2080_NOCAT_JOURNAL_OVERCLOCK_CFG(Structure):
    pass

struct_NV2080_NOCAT_JOURNAL_OVERCLOCK_CFG._pack_ = 1 # source:False
struct_NV2080_NOCAT_JOURNAL_OVERCLOCK_CFG._fields_ = [
    ('pstateVer', ctypes.c_uint32),
    ('gpcOverclock', NV2080_NOCAT_JOURNAL_OVERCLOCK_DETAILS),
    ('mclkOverclock', NV2080_NOCAT_JOURNAL_OVERCLOCK_DETAILS),
    ('bUserOverclocked', ctypes.c_ubyte),
    ('bFactoryOverclocked', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 2),
]

NV2080_NOCAT_JOURNAL_OVERCLOCK_CFG = struct_NV2080_NOCAT_JOURNAL_OVERCLOCK_CFG
class struct_NV2080_NOCAT_JOURNAL_GPU_STATE(Structure):
    pass

struct_NV2080_NOCAT_JOURNAL_GPU_STATE._pack_ = 1 # source:False
struct_NV2080_NOCAT_JOURNAL_GPU_STATE._fields_ = [
    ('bValid', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('strap', ctypes.c_uint32),
    ('deviceId', ctypes.c_uint16),
    ('vendorId', ctypes.c_uint16),
    ('subsystemVendor', ctypes.c_uint16),
    ('subsystemId', ctypes.c_uint16),
    ('revision', ctypes.c_uint16),
    ('type', ctypes.c_uint16),
    ('vbiosVersion', ctypes.c_uint32),
    ('bOptimus', ctypes.c_ubyte),
    ('bMsHybrid', ctypes.c_ubyte),
    ('bFullPower', ctypes.c_ubyte),
    ('PADDING_1', ctypes.c_ubyte),
    ('vbiosOemVersion', ctypes.c_uint32),
    ('memoryType', ctypes.c_uint16),
    ('tag', ctypes.c_ubyte * 65),
    ('vbiosProject', ctypes.c_ubyte * 65),
    ('bInFullchipReset', ctypes.c_ubyte),
    ('bInSecBusReset', ctypes.c_ubyte),
    ('bInGc6Reset', ctypes.c_ubyte),
    ('PADDING_2', ctypes.c_ubyte),
    ('overclockCfg', NV2080_NOCAT_JOURNAL_OVERCLOCK_CFG),
]

NV2080_NOCAT_JOURNAL_GPU_STATE = struct_NV2080_NOCAT_JOURNAL_GPU_STATE
class struct_NV2080_NOCAT_JOURNAL_ENTRY(Structure):
    pass

struct_NV2080_NOCAT_JOURNAL_ENTRY._pack_ = 1 # source:False
struct_NV2080_NOCAT_JOURNAL_ENTRY._fields_ = [
    ('recType', ctypes.c_ubyte),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('bugcheck', ctypes.c_uint32),
    ('tdrBucketId', ctypes.c_uint32),
    ('source', ctypes.c_ubyte * 65),
    ('PADDING_1', ctypes.c_ubyte * 3),
    ('subsystem', ctypes.c_uint32),
    ('PADDING_2', ctypes.c_ubyte * 4),
    ('errorCode', ctypes.c_uint64),
    ('diagBufferLen', ctypes.c_uint32),
    ('diagBuffer', ctypes.c_ubyte * 1024),
    ('faultingEngine', ctypes.c_ubyte * 65),
    ('PADDING_3', ctypes.c_ubyte * 3),
    ('mmuFaultType', ctypes.c_uint32),
    ('mmuErrorSrc', ctypes.c_uint32),
    ('tdrReason', ctypes.c_ubyte * 65),
    ('PADDING_4', ctypes.c_ubyte * 7),
]

NV2080_NOCAT_JOURNAL_ENTRY = struct_NV2080_NOCAT_JOURNAL_ENTRY
class struct_NV2080_NOCAT_JOURNAL_RECORD(Structure):
    pass

struct_NV2080_NOCAT_JOURNAL_RECORD._pack_ = 1 # source:False
struct_NV2080_NOCAT_JOURNAL_RECORD._fields_ = [
    ('GPUTag', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('loadAddress', ctypes.c_uint64),
    ('timeStamp', ctypes.c_uint64),
    ('stateMask', ctypes.c_uint64),
    ('nocatGpuState', NV2080_NOCAT_JOURNAL_GPU_STATE),
    ('nocatJournalEntry', NV2080_NOCAT_JOURNAL_ENTRY),
]

NV2080_NOCAT_JOURNAL_RECORD = struct_NV2080_NOCAT_JOURNAL_RECORD
class struct_NV2080_CTRL_NVD_GET_NOCAT_JOURNAL_PARAMS(Structure):
    pass

struct_NV2080_CTRL_NVD_GET_NOCAT_JOURNAL_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_NVD_GET_NOCAT_JOURNAL_PARAMS._fields_ = [
    ('flags', ctypes.c_uint32),
    ('nocatRecordCount', ctypes.c_uint32),
    ('nocatOutstandingRecordCount', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('journalRecords', struct_NV2080_NOCAT_JOURNAL_RECORD * 10),
    ('activityCounters', ctypes.c_uint32 * 32),
    ('reserved', ctypes.c_ubyte * 65),
    ('PADDING_1', ctypes.c_ubyte * 7),
]

NV2080_CTRL_NVD_GET_NOCAT_JOURNAL_PARAMS = struct_NV2080_CTRL_NVD_GET_NOCAT_JOURNAL_PARAMS
class struct_NV2080CtrlNocatJournalDataTdrReason(Structure):
    pass

struct_NV2080CtrlNocatJournalDataTdrReason._pack_ = 1 # source:False
struct_NV2080CtrlNocatJournalDataTdrReason._fields_ = [
    ('flags', ctypes.c_uint32),
    ('source', ctypes.c_ubyte * 65),
    ('PADDING_0', ctypes.c_ubyte * 3),
    ('subsystem', ctypes.c_uint32),
    ('PADDING_1', ctypes.c_ubyte * 4),
    ('errorCode', ctypes.c_uint64),
    ('reasonCode', ctypes.c_uint32),
    ('PADDING_2', ctypes.c_ubyte * 4),
]

NV2080CtrlNocatJournalDataTdrReason = struct_NV2080CtrlNocatJournalDataTdrReason
class struct_NV2080CtrlNocatJournalSetTag(Structure):
    pass

struct_NV2080CtrlNocatJournalSetTag._pack_ = 1 # source:False
struct_NV2080CtrlNocatJournalSetTag._fields_ = [
    ('flags', ctypes.c_uint32),
    ('tag', ctypes.c_ubyte * 65),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080CtrlNocatJournalSetTag = struct_NV2080CtrlNocatJournalSetTag
class struct_NV2080CtrlNocatJournalRclog(Structure):
    pass

struct_NV2080CtrlNocatJournalRclog._pack_ = 1 # source:False
struct_NV2080CtrlNocatJournalRclog._fields_ = [
    ('flags', ctypes.c_uint32),
    ('rclogSize', ctypes.c_uint32),
    ('rmGpuId', ctypes.c_uint32),
    ('APIType', ctypes.c_uint32),
    ('contextType', ctypes.c_uint32),
    ('exceptType', ctypes.c_uint32),
    ('processImageName', ctypes.c_ubyte * 65),
    ('PADDING_0', ctypes.c_ubyte * 3),
]

NV2080CtrlNocatJournalRclog = struct_NV2080CtrlNocatJournalRclog
class struct_NV2080_CTRL_NVD_SET_NOCAT_JOURNAL_DATA_PARAMS(Structure):
    pass

class union_NV2080_CTRL_NVD_SET_NOCAT_JOURNAL_DATA_PARAMS_nocatJournalData(Union):
    pass

union_NV2080_CTRL_NVD_SET_NOCAT_JOURNAL_DATA_PARAMS_nocatJournalData._pack_ = 1 # source:False
union_NV2080_CTRL_NVD_SET_NOCAT_JOURNAL_DATA_PARAMS_nocatJournalData._fields_ = [
    ('tdrReason', NV2080CtrlNocatJournalDataTdrReason),
    ('tagData', NV2080CtrlNocatJournalSetTag),
    ('rclog', NV2080CtrlNocatJournalRclog),
    ('PADDING_0', ctypes.c_ubyte * 4),
]

struct_NV2080_CTRL_NVD_SET_NOCAT_JOURNAL_DATA_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_NVD_SET_NOCAT_JOURNAL_DATA_PARAMS._fields_ = [
    ('dataType', ctypes.c_uint32),
    ('targetRecordType', ctypes.c_uint32),
    ('nocatJournalData', union_NV2080_CTRL_NVD_SET_NOCAT_JOURNAL_DATA_PARAMS_nocatJournalData),
]

NV2080_CTRL_NVD_SET_NOCAT_JOURNAL_DATA_PARAMS = struct_NV2080_CTRL_NVD_SET_NOCAT_JOURNAL_DATA_PARAMS
class struct_NV2080CtrlNocatJournalInsertRecord(Structure):
    pass

struct_NV2080CtrlNocatJournalInsertRecord._pack_ = 1 # source:False
struct_NV2080CtrlNocatJournalInsertRecord._fields_ = [
    ('flags', ctypes.c_uint32),
    ('PADDING_0', ctypes.c_ubyte * 4),
    ('timestamp', ctypes.c_uint64),
    ('recType', ctypes.c_ubyte),
    ('PADDING_1', ctypes.c_ubyte * 3),
    ('bugcheck', ctypes.c_uint32),
    ('source', ctypes.c_char * 65),
    ('PADDING_2', ctypes.c_ubyte * 3),
    ('subsystem', ctypes.c_uint32),
    ('errorCode', ctypes.c_uint64),
    ('faultingEngine', ctypes.c_char * 65),
    ('PADDING_3', ctypes.c_ubyte * 3),
    ('tdrReason', ctypes.c_uint32),
    ('diagBufferLen', ctypes.c_uint32),
    ('diagBuffer', ctypes.c_ubyte * 1024),
    ('PADDING_4', ctypes.c_ubyte * 4),
]

NV2080CtrlNocatJournalInsertRecord = struct_NV2080CtrlNocatJournalInsertRecord
class struct_NV2080_CTRL_CMD_NVD_INSERT_NOCAT_JOURNAL_RECORD_PARAMS(Structure):
    _pack_ = 1 # source:False
    _fields_ = [
    ('nocatJournalRecord', NV2080CtrlNocatJournalInsertRecord),
     ]

NV2080_CTRL_CMD_NVD_INSERT_NOCAT_JOURNAL_RECORD_PARAMS = struct_NV2080_CTRL_CMD_NVD_INSERT_NOCAT_JOURNAL_RECORD_PARAMS
NV2080_CTRL_CMD_NVLINK_GET_NVLINK_CAPS_PARAMS_MESSAGE_ID = (0x1) # macro
# def NV2080_CTRL_NVLINK_GET_CAP(tbl, c):  # macro
#    return (((NvU8)tbl[(1?c)])&(0?c))
NV2080_CTRL_NVLINK_CAPS_SUPPORTED = ['0', ':', '0x01'] # macro
NV2080_CTRL_NVLINK_CAPS_P2P_SUPPORTED = ['0', ':', '0x02'] # macro
NV2080_CTRL_NVLINK_CAPS_SYSMEM_ACCESS = ['0', ':', '0x04'] # macro
NV2080_CTRL_NVLINK_CAPS_P2P_ATOMICS = ['0', ':', '0x08'] # macro
NV2080_CTRL_NVLINK_CAPS_SYSMEM_ATOMICS = ['0', ':', '0x10'] # macro
NV2080_CTRL_NVLINK_CAPS_PEX_TUNNELING = ['0', ':', '0x20'] # macro
NV2080_CTRL_NVLINK_CAPS_SLI_BRIDGE = ['0', ':', '0x40'] # macro
NV2080_CTRL_NVLINK_CAPS_SLI_BRIDGE_SENSABLE = ['0', ':', '0x80'] # macro
NV2080_CTRL_NVLINK_CAPS_POWER_STATE_L0 = ['1', ':', '0x01'] # macro
NV2080_CTRL_NVLINK_CAPS_POWER_STATE_L1 = ['1', ':', '0x02'] # macro
NV2080_CTRL_NVLINK_CAPS_POWER_STATE_L2 = ['1', ':', '0x04'] # macro
NV2080_CTRL_NVLINK_CAPS_POWER_STATE_L3 = ['1', ':', '0x08'] # macro
NV2080_CTRL_NVLINK_CAPS_VALID = ['1', ':', '0x10'] # macro
NV2080_CTRL_NVLINK_CAPS_TBL_SIZE = 2 # macro
NV2080_CTRL_NVLINK_CAPS_NVLINK_VERSION_INVALID = (0x00000000) # macro
NV2080_CTRL_NVLINK_CAPS_NVLINK_VERSION_1_0 = (0x00000001) # macro
NV2080_CTRL_NVLINK_CAPS_NVLINK_VERSION_2_0 = (0x00000002) # macro
NV2080_CTRL_NVLINK_CAPS_NVLINK_VERSION_2_2 = (0x00000004) # macro
NV2080_CTRL_NVLINK_CAPS_NVLINK_VERSION_3_0 = (0x00000005) # macro
NV2080_CTRL_NVLINK_CAPS_NVLINK_VERSION_3_1 = (0x00000006) # macro
NV2080_CTRL_NVLINK_CAPS_NVLINK_VERSION_4_0 = (0x00000007) # macro
NV2080_CTRL_NVLINK_CAPS_NCI_VERSION_INVALID = (0x00000000) # macro
NV2080_CTRL_NVLINK_CAPS_NCI_VERSION_1_0 = (0x00000001) # macro
NV2080_CTRL_NVLINK_CAPS_NCI_VERSION_2_0 = (0x00000002) # macro
NV2080_CTRL_NVLINK_CAPS_NCI_VERSION_2_2 = (0x00000004) # macro
NV2080_CTRL_NVLINK_CAPS_NCI_VERSION_3_0 = (0x00000005) # macro
NV2080_CTRL_NVLINK_CAPS_NCI_VERSION_3_1 = (0x00000006) # macro
NV2080_CTRL_NVLINK_CAPS_NCI_VERSION_4_0 = (0x00000007) # macro
NV2080_CTRL_CMD_NVLINK_GET_NVLINK_CAPS = (0x20803001) # macro
NV2080_CTRL_NVLINK_DEVICE_INFO_DEVICE_ID_FLAGS = ['31', ':', '0'] # macro
NV2080_CTRL_NVLINK_DEVICE_INFO_DEVICE_ID_FLAGS_NONE = (0x00000000) # macro
NV2080_CTRL_NVLINK_DEVICE_INFO_DEVICE_ID_FLAGS_PCI = (0x00000001) # macro
NV2080_CTRL_NVLINK_DEVICE_INFO_DEVICE_ID_FLAGS_UUID = (0x00000002) # macro
NV2080_CTRL_NVLINK_DEVICE_INFO_DEVICE_TYPE_EBRIDGE = (0x00000000) # macro
NV2080_CTRL_NVLINK_DEVICE_INFO_DEVICE_TYPE_NPU = (0x00000001) # macro
NV2080_CTRL_NVLINK_DEVICE_INFO_DEVICE_TYPE_GPU = (0x00000002) # macro
NV2080_CTRL_NVLINK_DEVICE_INFO_DEVICE_TYPE_SWITCH = (0x00000003) # macro
NV2080_CTRL_NVLINK_DEVICE_INFO_DEVICE_TYPE_TEGRA = (0x00000004) # macro
NV2080_CTRL_NVLINK_DEVICE_INFO_DEVICE_TYPE_NONE = (0x000000FF) # macro
NV2080_CTRL_NVLINK_DEVICE_INFO_DEVICE_UUID_INVALID = (0xFFFFFFFF) # macro
NV2080_CTRL_NVLINK_STATUS_LINK_STATE_INIT = (0x00000000) # macro
NV2080_CTRL_NVLINK_STATUS_LINK_STATE_HWCFG = (0x00000001) # macro
NV2080_CTRL_NVLINK_STATUS_LINK_STATE_SWCFG = (0x00000002) # macro
NV2080_CTRL_NVLINK_STATUS_LINK_STATE_ACTIVE = (0x00000003) # macro
NV2080_CTRL_NVLINK_STATUS_LINK_STATE_FAULT = (0x00000004) # macro
NV2080_CTRL_NVLINK_STATUS_LINK_STATE_SLEEP = (0x00000005) # macro
NV2080_CTRL_NVLINK_STATUS_LINK_STATE_RECOVERY = (0x00000006) # macro
NV2080_CTRL_NVLINK_STATUS_LINK_STATE_RECOVERY_AC = (0x00000008) # macro
NV2080_CTRL_NVLINK_STATUS_LINK_STATE_RECOVERY_RX = (0x0000000a) # macro
NV2080_CTRL_NVLINK_STATUS_LINK_STATE_INVALID = (0xFFFFFFFF) # macro
NV2080_CTRL_NVLINK_STATUS_SUBLINK_RX_STATE_HIGH_SPEED_1 = (0x00000000) # macro
NV2080_CTRL_NVLINK_STATUS_SUBLINK_RX_STATE_SINGLE_LANE = (0x00000004) # macro
NV2080_CTRL_NVLINK_STATUS_SUBLINK_RX_STATE_LOW_POWER = (0x00000004) # macro
NV2080_CTRL_NVLINK_STATUS_SUBLINK_RX_STATE_TRAINING = (0x00000005) # macro
NV2080_CTRL_NVLINK_STATUS_SUBLINK_RX_STATE_SAFE_MODE = (0x00000006) # macro
NV2080_CTRL_NVLINK_STATUS_SUBLINK_RX_STATE_OFF = (0x00000007) # macro
NV2080_CTRL_NVLINK_STATUS_SUBLINK_RX_STATE_TEST = (0x00000008) # macro
NV2080_CTRL_NVLINK_STATUS_SUBLINK_RX_STATE_FAULT = (0x0000000e) # macro
NV2080_CTRL_NVLINK_STATUS_SUBLINK_RX_STATE_INVALID = (0x000000FF) # macro
NV2080_CTRL_NVLINK_STATUS_SUBLINK_TX_STATE_HIGH_SPEED_1 = (0x00000000) # macro
NV2080_CTRL_NVLINK_STATUS_SUBLINK_TX_STATE_SINGLE_LANE = (0x00000004) # macro
NV2080_CTRL_NVLINK_STATUS_SUBLINK_TX_STATE_LOW_POWER = (0x00000004) # macro
NV2080_CTRL_NVLINK_STATUS_SUBLINK_TX_STATE_TRAINING = (0x00000005) # macro
NV2080_CTRL_NVLINK_STATUS_SUBLINK_TX_STATE_SAFE_MODE = (0x00000006) # macro
NV2080_CTRL_NVLINK_STATUS_SUBLINK_TX_STATE_OFF = (0x00000007) # macro
NV2080_CTRL_NVLINK_STATUS_SUBLINK_TX_STATE_TEST = (0x00000008) # macro
NV2080_CTRL_NVLINK_STATUS_SUBLINK_TX_STATE_FAULT = (0x0000000e) # macro
NV2080_CTRL_NVLINK_STATUS_SUBLINK_TX_STATE_INVALID = (0x000000FF) # macro
NV2080_CTRL_NVLINK_STATUS_PHY_NVHS = (0x00000001) # macro
NV2080_CTRL_NVLINK_STATUS_PHY_GRS = (0x00000002) # macro
NV2080_CTRL_NVLINK_STATUS_PHY_INVALID = (0x000000FF) # macro
NV2080_CTRL_NVLINK_STATUS_NVLINK_VERSION_1_0 = (0x00000001) # macro
NV2080_CTRL_NVLINK_STATUS_NVLINK_VERSION_2_0 = (0x00000002) # macro
NV2080_CTRL_NVLINK_STATUS_NVLINK_VERSION_2_2 = (0x00000004) # macro
NV2080_CTRL_NVLINK_STATUS_NVLINK_VERSION_3_0 = (0x00000005) # macro
NV2080_CTRL_NVLINK_STATUS_NVLINK_VERSION_3_1 = (0x00000006) # macro
NV2080_CTRL_NVLINK_STATUS_NVLINK_VERSION_4_0 = (0x00000007) # macro
NV2080_CTRL_NVLINK_STATUS_NVLINK_VERSION_INVALID = (0x000000FF) # macro
NV2080_CTRL_NVLINK_STATUS_NCI_VERSION_1_0 = (0x00000001) # macro
NV2080_CTRL_NVLINK_STATUS_NCI_VERSION_2_0 = (0x00000002) # macro
NV2080_CTRL_NVLINK_STATUS_NCI_VERSION_2_2 = (0x00000004) # macro
NV2080_CTRL_NVLINK_STATUS_NCI_VERSION_3_0 = (0x00000005) # macro
NV2080_CTRL_NVLINK_STATUS_NCI_VERSION_3_1 = (0x00000006) # macro
NV2080_CTRL_NVLINK_STATUS_NCI_VERSION_4_0 = (0x00000007) # macro
NV2080_CTRL_NVLINK_STATUS_NCI_VERSION_INVALID = (0x000000FF) # macro
NV2080_CTRL_NVLINK_STATUS_NVHS_VERSION_1_0 = (0x00000001) # macro
NV2080_CTRL_NVLINK_STATUS_NVHS_VERSION_INVALID = (0x000000FF) # macro
NV2080_CTRL_NVLINK_STATUS_GRS_VERSION_1_0 = (0x00000001) # macro
NV2080_CTRL_NVLINK_STATUS_GRS_VERSION_INVALID = (0x000000FF) # macro
NV2080_CTRL_NVLINK_STATUS_CONNECTED_TRUE = (0x00000001) # macro
NV2080_CTRL_NVLINK_STATUS_CONNECTED_FALSE = (0x00000000) # macro
NV2080_CTRL_NVLINK_STATUS_LOOP_PROPERTY_LOOPBACK = (0x00000001) # macro
NV2080_CTRL_NVLINK_STATUS_LOOP_PROPERTY_LOOPOUT = (0x00000002) # macro
NV2080_CTRL_NVLINK_STATUS_LOOP_PROPERTY_NONE = (0x00000000) # macro
NV2080_CTRL_NVLINK_STATUS_REMOTE_LINK_NUMBER_INVALID = (0x000000FF) # macro
NV2080_CTRL_NVLINK_MAX_LINKS = 32 # macro
NV2080_CTRL_NVLINK_REFCLK_TYPE_INVALID = (0x00) # macro
NV2080_CTRL_NVLINK_REFCLK_TYPE_NVHS = (0x01) # macro
NV2080_CTRL_NVLINK_REFCLK_TYPE_PEX = (0x02) # macro
NV2080_CTRL_CMD_NVLINK_GET_NVLINK_STATUS_PARAMS_MESSAGE_ID = (0x2) # macro
NV2080_CTRL_CMD_NVLINK_GET_NVLINK_STATUS = (0x20803002) # macro
# def NV2080_CTRL_NVLINK_GET_TL_ERRLOG_BIT(intr, i):  # macro
#    return (((1<<i)&(intr))>>i)
# def NV2080_CTRL_NVLINK_GET_TL_INTEN_BIT(intr, i):  # macro
#    return (((1<<i)&(intr))>>i)(intr,i)
NV2080_CTRL_NVLINK_TL_ERRLOG_TRUE = (0x00000001) # macro
NV2080_CTRL_NVLINK_TL_ERRLOG_FALSE = (0x00000000) # macro
NV2080_CTRL_NVLINK_TL_INTEN_TRUE = (0x00000001) # macro
NV2080_CTRL_NVLINK_TL_INTEN_FALSE = (0x00000000) # macro
NV2080_CTRL_NVLINK_TL_INTEN_IDX_RXDLDATAPARITYEN = 0 # macro
NV2080_CTRL_NVLINK_TL_INTEN_IDX_RXDLCTRLPARITYEN = 1 # macro
NV2080_CTRL_NVLINK_TL_INTEN_IDX_RXPROTOCOLEN = 2 # macro
NV2080_CTRL_NVLINK_TL_INTEN_IDX_RXOVERFLOWEN = 3 # macro
NV2080_CTRL_NVLINK_TL_INTEN_IDX_RXRAMDATAPARITYEN = 4 # macro
NV2080_CTRL_NVLINK_TL_INTEN_IDX_RXRAMHDRPARITYEN = 5 # macro
NV2080_CTRL_NVLINK_TL_INTEN_IDX_RXRESPEN = 6 # macro
NV2080_CTRL_NVLINK_TL_INTEN_IDX_RXPOISONEN = 7 # macro
NV2080_CTRL_NVLINK_TL_INTEN_IDX_TXRAMDATAPARITYEN = 8 # macro
NV2080_CTRL_NVLINK_TL_INTEN_IDX_TXRAMHDRPARITYEN = 9 # macro
NV2080_CTRL_NVLINK_TL_INTEN_IDX_DLFLOWPARITYEN = 10 # macro
NV2080_CTRL_NVLINK_TL_INTEN_IDX_DLHDRPARITYEN = 12 # macro
NV2080_CTRL_NVLINK_TL_INTEN_IDX_TXCREDITEN = 13 # macro
NV2080_CTRL_NVLINK_TL_INTEN_IDX_MAX = 14 # macro
NV2080_CTRL_NVLINK_TL_ERRLOG_IDX_RXDLDATAPARITYERR = 0 # macro
NV2080_CTRL_NVLINK_TL_ERRLOG_IDX_RXDLCTRLPARITYERR = 1 # macro
NV2080_CTRL_NVLINK_TL_ERRLOG_IDX_RXPROTOCOLERR = 2 # macro
NV2080_CTRL_NVLINK_TL_ERRLOG_IDX_RXOVERFLOWERR = 3 # macro
NV2080_CTRL_NVLINK_TL_ERRLOG_IDX_RXRAMDATAPARITYERR = 4 # macro
NV2080_CTRL_NVLINK_TL_ERRLOG_IDX_RXRAMHDRPARITYERR = 5 # macro
NV2080_CTRL_NVLINK_TL_ERRLOG_IDX_RXRESPERR = 6 # macro
NV2080_CTRL_NVLINK_TL_ERRLOG_IDX_RXPOISONERR = 7 # macro
NV2080_CTRL_NVLINK_TL_ERRLOG_IDX_TXRAMDATAPARITYERR = 8 # macro
NV2080_CTRL_NVLINK_TL_ERRLOG_IDX_TXRAMHDRPARITYERR = 9 # macro
NV2080_CTRL_NVLINK_TL_ERRLOG_IDX_DLFLOWPARITYERR = 10 # macro
NV2080_CTRL_NVLINK_TL_ERRLOG_IDX_DLHDRPARITYERR = 12 # macro
NV2080_CTRL_NVLINK_TL_ERRLOG_IDX_TXCREDITERR = 13 # macro
NV2080_CTRL_NVLINK_TL_ERRLOG_IDX_MAX = 14 # macro
NV2080_CTRL_NVLINK_SL0_SLSM_STATUS_TX_PRIMARY_STATE_HS = (0x00000000) # macro
NV2080_CTRL_NVLINK_SL0_SLSM_STATUS_TX_PRIMARY_STATE_SINGLE_LANE = (0x00000004) # macro
NV2080_CTRL_NVLINK_SL0_SLSM_STATUS_TX_PRIMARY_STATE_TRAIN = (0x00000005) # macro
NV2080_CTRL_NVLINK_SL0_SLSM_STATUS_TX_PRIMARY_STATE_SAFE = (0x00000006) # macro
NV2080_CTRL_NVLINK_SL0_SLSM_STATUS_TX_PRIMARY_STATE_OFF = (0x00000007) # macro
NV2080_CTRL_NVLINK_SL1_SLSM_STATUS_RX_PRIMARY_STATE_HS = (0x00000000) # macro
NV2080_CTRL_NVLINK_SL1_SLSM_STATUS_RX_PRIMARY_STATE_SINGLE_LANE = (0x00000004) # macro
NV2080_CTRL_NVLINK_SL1_SLSM_STATUS_RX_PRIMARY_STATE_TRAIN = (0x00000005) # macro
NV2080_CTRL_NVLINK_SL1_SLSM_STATUS_RX_PRIMARY_STATE_SAFE = (0x00000006) # macro
NV2080_CTRL_NVLINK_SL1_SLSM_STATUS_RX_PRIMARY_STATE_OFF = (0x00000007) # macro
NV2080_CTRL_NVLINK_ERR_INFO_FLAGS_DEFAULT = (0x0) # macro
NV2080_CTRL_NVLINK_ERR_INFO_FLAGS_INTR_STATUS = (0x1) # macro
NV2080_CTRL_NVLINK_ERR_INFO_FLAGS_ALI_STATUS = (0x2) # macro
NV2080_CTRL_NVLINK_MAX_IOCTRLS = 3 # macro
NV2080_CTRL_NVLINK_GET_ERR_INFO_PARAMS_MESSAGE_ID = (0x3) # macro
NV2080_CTRL_CMD_NVLINK_GET_ERR_INFO = (0x20803003) # macro
NV2080_CTRL_NVLINK_COUNTER_INVALID = 0x00000000 # macro
NV2080_CTRL_NVLINK_COUNTER_TL_TX0 = 0x00000001 # macro
NV2080_CTRL_NVLINK_COUNTER_TL_TX1 = 0x00000002 # macro
NV2080_CTRL_NVLINK_COUNTER_TL_RX0 = 0x00000004 # macro
NV2080_CTRL_NVLINK_COUNTER_TL_RX1 = 0x00000008 # macro
NV2080_CTRL_NVLINK_LP_COUNTERS_DL = 0x00000010 # macro
# def NV2080_CTRL_NVLINK_COUNTER_DL_RX_ERR_ECC_LANE_L(i):  # macro
#    return (1<<(i+8))
NV2080_CTRL_NVLINK_COUNTER_DL_RX_ERR_ECC_LANE__SIZE = 4 # macro
NV2080_CTRL_NVLINK_COUNTER_DL_RX_ERR_ECC_LANE_L0 = 0x00000100 # macro
NV2080_CTRL_NVLINK_COUNTER_DL_RX_ERR_ECC_LANE_L1 = 0x00000200 # macro
NV2080_CTRL_NVLINK_COUNTER_DL_RX_ERR_ECC_LANE_L2 = 0x00000400 # macro
NV2080_CTRL_NVLINK_COUNTER_DL_RX_ERR_ECC_LANE_L3 = 0x00000800 # macro
NV2080_CTRL_NVLINK_COUNTER_DL_RX_ERR_CRC_FLIT = 0x00010000 # macro
# def NV2080_CTRL_NVLINK_COUNTER_DL_RX_ERR_CRC_LANE_L(i):  # macro
#    return (1<<(i+17))
NV2080_CTRL_NVLINK_COUNTER_DL_RX_ERR_CRC_LANE__SIZE = 8 # macro
NV2080_CTRL_NVLINK_COUNTER_DL_RX_ERR_CRC_LANE_L0 = 0x00020000 # macro
NV2080_CTRL_NVLINK_COUNTER_DL_RX_ERR_CRC_LANE_L1 = 0x00040000 # macro
NV2080_CTRL_NVLINK_COUNTER_DL_RX_ERR_CRC_LANE_L2 = 0x00080000 # macro
NV2080_CTRL_NVLINK_COUNTER_DL_RX_ERR_CRC_LANE_L3 = 0x00100000 # macro
NV2080_CTRL_NVLINK_COUNTER_DL_RX_ERR_CRC_LANE_L4 = 0x00200000 # macro
NV2080_CTRL_NVLINK_COUNTER_DL_RX_ERR_CRC_LANE_L5 = 0x00400000 # macro
NV2080_CTRL_NVLINK_COUNTER_DL_RX_ERR_CRC_LANE_L6 = 0x00800000 # macro
NV2080_CTRL_NVLINK_COUNTER_DL_RX_ERR_CRC_LANE_L7 = 0x01000000 # macro
NV2080_CTRL_NVLINK_COUNTER_DL_TX_ERR_REPLAY = 0x02000000 # macro
NV2080_CTRL_NVLINK_COUNTER_DL_TX_ERR_RECOVERY = 0x04000000 # macro
NV2080_CTRL_NVLINK_COUNTER_DL_RX_ERR_REPLAY = 0x08000000 # macro
NV2080_CTRL_NVLINK_COUNTER_DL_RX_ERR_CRC_MASKED = 0x10000000 # macro
NV2080_CTRL_NVLINK_COUNTER_MAX_TYPES = 32 # macro
NV2080_CTRL_NVLINK_GET_COUNTERS_PARAMS_MESSAGE_ID = (0x4) # macro
NV2080_CTRL_CMD_NVLINK_GET_COUNTERS = (0x20803004) # macro
NV2080_CTRL_CMD_NVLINK_CLEAR_COUNTERS = (0x20803005) # macro
NV2080_CTRL_NVLINK_CLEAR_COUNTERS_PARAMS_MESSAGE_ID = (0x5) # macro
NV2080_CTRL_CMD_NVLINK_INJECT_ERROR = (0x20803006) # macro
NV2080_CTRL_NVLINK_INJECT_ERROR_PARAMS_MESSAGE_ID = (0x6) # macro
NV2080_CTRL_NVLINK_UNIT_DL = 0x01 # macro
NV2080_CTRL_NVLINK_UNIT_TL = 0x02 # macro
NV2080_CTRL_NVLINK_UNIT_TLC_RX_0 = 0x03 # macro
NV2080_CTRL_NVLINK_UNIT_TLC_RX_1 = 0x04 # macro
NV2080_CTRL_NVLINK_UNIT_TLC_TX_0 = 0x05 # macro
NV2080_CTRL_NVLINK_UNIT_MIF_RX_0 = 0x06 # macro
NV2080_CTRL_NVLINK_UNIT_MIF_TX_0 = 0x07 # macro
NV2080_CTRL_NVLINK_UNIT_MINION = 0x08 # macro
NV2080_CTRL_CMD_NVLINK_GET_ERROR_RECOVERIES = (0x20803007) # macro
NV2080_CTRL_CMD_NVLINK_GET_ERROR_RECOVERIES_PARAMS_MESSAGE_ID = (0x7) # macro
NV2080_CTRL_CMD_NVLINK_GET_LINK_LAST_ERROR_REMOTE_TYPE = (0x20803008) # macro
NV2080_CTRL_NVLINK_GET_LINK_LAST_ERROR_REMOTE_TYPE_PARAMS_MESSAGE_ID = (0x8) # macro
NV2080_CTRL_CMD_NVLINK_GET_LINK_FATAL_ERROR_COUNTS = (0x20803009) # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TL_RX_DL_DATA_PARITY = 0 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TL_RX_DL_CTRL_PARITY = 1 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TL_RX_PROTOCOL = 2 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TL_RX_OVERFLOW = 3 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TL_RX_RAM_DATA_PARITY = 4 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TL_RX_RAM_HDR_PARITY = 5 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TL_RX_RESP = 6 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TL_RX_POISON = 7 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TL_TX_RAM_DATA_PARITY = 8 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TL_TX_RAM_HDR_PARITY = 9 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TL_TX_CREDIT = 10 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TL_DL_FLOW_CTRL_PARITY = 11 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TL_DL_HDR_PARITY = 12 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_DL_TX_RECOVERY_LONG = 13 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_DL_TX_FAULT_RAM = 14 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_DL_TX_FAULT_INTERFACE = 15 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_DL_TX_FAULT_SUBLINK_CHANGE = 16 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_DL_RX_FAULT_SUBLINK_CHANGE = 17 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_DL_RX_FAULT_DL_PROTOCOL = 18 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_DL_LTSSM_FAULT = 19 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_DL_DATA_PARITY = 0 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_DL_CTRL_PARITY = 1 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_RAM_DATA_PARITY = 4 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_RAM_HDR_PARITY = 5 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_DATA_POISONED_PKT_RCVD = 7 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_TX_RAM_DATA_PARITY = 8 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_TX_RAM_HDR_PARITY = 9 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_TX_DL_FLOW_CONTROL_PARITY = 11 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_DL_HDR_PARITY = 20 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_INVALID_AE_FLIT_RCVD = 21 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_INVALID_BE_FLIT_RCVD = 22 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_INVALID_ADDR_ALIGN = 23 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_PKT_LEN = 24 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_RSVD_CMD_ENC = 25 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_RSVD_DAT_LEN_ENC = 26 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_RSVD_ADDR_TYPE = 27 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_RSVD_RSP_STATUS = 28 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_RSVD_PKT_STATUS = 29 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_RSVD_CACHE_ATTR_ENC_IN_PROBE_REQ = 30 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_RSVD_CACHE_ATTR_ENC_IN_PROBE_RESP = 31 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_DAT_LEN_GT_ATOMIC_REQ_MAX_SIZE = 32 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_DAT_LEN_GT_RMW_REQ_MAX_SIZE = 33 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_DAT_LEN_LT_ATR_RESP_MIN_SIZE = 34 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_INVALID_PO_FOR_CACHE_ATTR = 35 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_INVALID_COMPRESSED_RESP = 36 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_RESP_STATUS_TARGET = 37 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_RESP_STATUS_UNSUPPORTED_REQUEST = 38 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_HDR_OVERFLOW = 39 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_DATA_OVERFLOW = 40 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_STOMPED_PKT_RCVD = 41 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_CORRECTABLE_INTERNAL = 42 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_UNSUPPORTED_VC_OVERFLOW = 43 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_UNSUPPORTED_NVLINK_CREDIT_RELEASE = 44 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_UNSUPPORTED_NCISOC_CREDIT_RELEASE = 45 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_TX_HDR_CREDIT_OVERFLOW = 46 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_TX_DATA_CREDIT_OVERFLOW = 47 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_TX_DL_REPLAY_CREDIT_OVERFLOW = 48 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_TX_UNSUPPORTED_VC_OVERFLOW = 49 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_TX_STOMPED_PKT_SENT = 50 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_TX_DATA_POISONED_PKT_SENT = 51 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_TX_RESP_STATUS_TARGET = 52 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_TX_RESP_STATUS_UNSUPPORTED_REQUEST = 53 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_MIF_RX_RAM_DATA_PARITY = 54 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_MIF_RX_RAM_HDR_PARITY = 55 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_MIF_TX_RAM_DATA_PARITY = 56 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_MIF_TX_RAM_HDR_PARITY = 57 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_RX_INVALID_COLLAPSED_RESPONSE = 58 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_TX_NCISOC_HDR_ECC_DBE = 59 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_TLC_TX_NCISOC_PARITY = 60 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_DL_LTSSM_FAULT_UP = 61 # macro
NV2080_CTRL_NVLINK_FATAL_ERROR_TYPE_DL_LTSSM_FAULT_DOWN = 62 # macro
NV2080_CTRL_NVLINK_NUM_FATAL_ERROR_TYPES = 63 # macro
# def NV2080_CTRL_NVLINK_IS_FATAL_ERROR_COUNT_VALID(count, supportedCounts):  # macro
#    return (!!((supportedCounts)&NVBIT64(count)))
NV2080_CTRL_NVLINK_GET_LINK_FATAL_ERROR_COUNTS_PARAMS_MESSAGE_ID = (0x9) # macro
NV2080_CTRL_CMD_NVLINK_GET_LINK_NONFATAL_ERROR_RATES = (0x2080300a) # macro
NV2080_CTRL_NVLINK_NONFATAL_ERROR_RATE_ENTRIES = 5 # macro
NV2080_CTRL_NVLINK_GET_LINK_NONFATAL_ERROR_RATES_PARAMS_MESSAGE_ID = (0xA) # macro
NV2080_CTRL_CMD_NVLINK_SET_ERROR_INJECTION_MODE = (0x2080300b) # macro
NV2080_CTRL_NVLINK_SET_ERROR_INJECTION_MODE_PARAMS_MESSAGE_ID = (0xB) # macro
NV2080_CTRL_CMD_NVLINK_SETUP_EOM = (0x2080300c) # macro
NV2080_CTRL_CMD_NVLINK_SETUP_EOM_PARAMS_MESSAGE_ID = (0xC) # macro
NV2080_CTRL_CMD_NVLINK_SET_POWER_STATE = (0x2080300d) # macro
NV2080_CTRL_NVLINK_SET_POWER_STATE_PARAMS_MESSAGE_ID = (0xD) # macro
NV2080_CTRL_NVLINK_POWER_STATE_L0 = (0x00) # macro
NV2080_CTRL_NVLINK_POWER_STATE_L1 = (0x01) # macro
NV2080_CTRL_NVLINK_POWER_STATE_L2 = (0x02) # macro
NV2080_CTRL_NVLINK_POWER_STATE_L3 = (0x03) # macro
NV2080_CTRL_CMD_NVLINK_GET_POWER_STATE = (0x2080300e) # macro
NV2080_CTRL_NVLINK_GET_POWER_STATE_PARAMS_MESSAGE_ID = (0xE) # macro
NV2080_CTRL_CMD_NVLINK_INJECT_TLC_ERROR = (0x2080300f) # macro
NV2080_CTRL_NVLINK_INJECT_TLC_ERROR_PARAMS_MESSAGE_ID = (0xF) # macro
NV2080_CTRL_CMD_NVLINK_GET_LINK_FOM_VALUES = (0x20803011) # macro
NV2080_CTRL_NVLINK_MAX_LANES = 4 # macro
NV2080_CTRL_CMD_NVLINK_GET_LINK_FOM_VALUES_PARAMS_MESSAGE_ID = (0x11) # macro
NV2080_CTRL_CMD_NVLINK_SET_NVLINK_PEER = (0x20803012) # macro
NV2080_CTRL_NVLINK_SET_NVLINK_PEER_PARAMS_MESSAGE_ID = (0x12) # macro
NV2080_CTRL_CMD_NVLINK_READ_UPHY_PAD_LANE_REG = (0x20803013) # macro
NV2080_CTRL_NVLINK_READ_UPHY_PAD_LANE_REG_PARAMS_MESSAGE_ID = (0x13) # macro
NV2080_CTRL_NVLINK_GET_NVLINK_ECC_ERRORS_PARAMS_MESSAGE_ID = (0x14) # macro
NV2080_CTRL_CMD_NVLINK_GET_NVLINK_ECC_ERRORS = (0x20803014) # macro
NV2080_CTRL_NVLINK_READ_TP_COUNTERS_TYPE_DATA_TX = 0 # macro
NV2080_CTRL_NVLINK_READ_TP_COUNTERS_TYPE_DATA_RX = 1 # macro
NV2080_CTRL_NVLINK_READ_TP_COUNTERS_TYPE_RAW_TX = 2 # macro
NV2080_CTRL_NVLINK_READ_TP_COUNTERS_TYPE_RAW_RX = 3 # macro
NV2080_CTRL_NVLINK_READ_TP_COUNTERS_TYPE_MAX = 4 # macro
NV2080_CTRL_NVLINK_READ_TP_COUNTERS_PARAMS_MESSAGE_ID = (0x15) # macro
NV2080_CTRL_CMD_NVLINK_READ_TP_COUNTERS = (0x20803015) # macro
NV2080_CTRL_CMD_NVLINK_LOCK_LINK_POWER_STATE = (0x20803016) # macro
NV2080_CTRL_CMD_NVLINK_LOCK_LINK_POWER_STATE_PARAMS_MESSAGE_ID = (0x16) # macro
NV2080_CTRL_CMD_NVLINK_ENABLE_NVLINK_PEER = (0x20803017) # macro
NV2080_CTRL_NVLINK_ENABLE_NVLINK_PEER_PARAMS_MESSAGE_ID = (0x17) # macro
NV2080_CTRL_NVLINK_GET_LP_COUNTERS_COUNT_TX_NVHS = 0 # macro
NV2080_CTRL_NVLINK_GET_LP_COUNTERS_COUNT_TX_EIGHTH = 1 # macro
NV2080_CTRL_NVLINK_GET_LP_COUNTERS_COUNT_TX_OTHER = 2 # macro
NV2080_CTRL_NVLINK_GET_LP_COUNTERS_NUM_TX_LP_ENTER = 3 # macro
NV2080_CTRL_NVLINK_GET_LP_COUNTERS_NUM_TX_LP_EXIT = 4 # macro
NV2080_CTRL_NVLINK_GET_LP_COUNTERS_COUNT_TX_SLEEP = 5 # macro
NV2080_CTRL_NVLINK_GET_LP_COUNTERS_HS_TIME = 6 # macro
NV2080_CTRL_NVLINK_GET_LP_COUNTERS_LOCAL_FULL_BW_EXIT_TIME = 7 # macro
NV2080_CTRL_NVLINK_GET_LP_COUNTERS_LOCAL_LP_ENTRY_TIME = 8 # macro
NV2080_CTRL_NVLINK_GET_LP_COUNTERS_LOCAL_LP_EXIT_TIME = 9 # macro
NV2080_CTRL_NVLINK_GET_LP_COUNTERS_LOCAL_FULL_BW_ENTRY_TIME = 10 # macro
NV2080_CTRL_NVLINK_GET_LP_COUNTERS_REMOTE_FULL_BW_EXIT_TIME = 11 # macro
NV2080_CTRL_NVLINK_GET_LP_COUNTERS_REMOTE_LP_ENTRY_TIME = 12 # macro
NV2080_CTRL_NVLINK_GET_LP_COUNTERS_REMOTE_LP_EXIT_TIME = 13 # macro
NV2080_CTRL_NVLINK_GET_LP_COUNTERS_REMOTE_FULL_BW_ENTRY_TIME = 14 # macro
NV2080_CTRL_NVLINK_GET_LP_COUNTERS_OTHER_STATE_TIME = 15 # macro
NV2080_CTRL_NVLINK_GET_LP_COUNTERS_MAX_COUNTERS = 16 # macro
NV2080_CTRL_NVLINK_GET_LP_COUNTERS_PARAMS_MESSAGE_ID = (0x18) # macro
NV2080_CTRL_CMD_NVLINK_GET_LP_COUNTERS = (0x20803018) # macro
NV2080_CTRL_CMD_NVLINK_CLEAR_LP_COUNTERS = (0x20803052) # macro
NV2080_NVLINK_CORE_LINK_STATE_OFF = 0x00 # macro
NV2080_NVLINK_CORE_LINK_STATE_HS = 0x01 # macro
NV2080_NVLINK_CORE_LINK_STATE_SAFE = 0x02 # macro
NV2080_NVLINK_CORE_LINK_STATE_FAULT = 0x03 # macro
NV2080_NVLINK_CORE_LINK_STATE_RECOVERY = 0x04 # macro
NV2080_NVLINK_CORE_LINK_STATE_FAIL = 0x05 # macro
NV2080_NVLINK_CORE_LINK_STATE_DETECT = 0x06 # macro
NV2080_NVLINK_CORE_LINK_STATE_RESET = 0x07 # macro
NV2080_NVLINK_CORE_LINK_STATE_ENABLE_PM = 0x08 # macro
NV2080_NVLINK_CORE_LINK_STATE_DISABLE_PM = 0x09 # macro
NV2080_NVLINK_CORE_LINK_STATE_SLEEP = 0x0A # macro
NV2080_NVLINK_CORE_LINK_STATE_SAVE_STATE = 0x0B # macro
NV2080_NVLINK_CORE_LINK_STATE_RESTORE_STATE = 0x0C # macro
NV2080_NVLINK_CORE_LINK_STATE_PRE_HS = 0x0E # macro
NV2080_NVLINK_CORE_LINK_STATE_DISABLE_ERR_DETECT = 0x0F # macro
NV2080_NVLINK_CORE_LINK_STATE_LANE_DISABLE = 0x10 # macro
NV2080_NVLINK_CORE_LINK_STATE_LANE_SHUTDOWN = 0x11 # macro
NV2080_NVLINK_CORE_LINK_STATE_TRAFFIC_SETUP = 0x12 # macro
NV2080_NVLINK_CORE_LINK_STATE_INITPHASE1 = 0x13 # macro
NV2080_NVLINK_CORE_LINK_STATE_INITNEGOTIATE = 0x14 # macro
NV2080_NVLINK_CORE_LINK_STATE_POST_INITNEGOTIATE = 0x15 # macro
NV2080_NVLINK_CORE_LINK_STATE_INITOPTIMIZE = 0x16 # macro
NV2080_NVLINK_CORE_LINK_STATE_POST_INITOPTIMIZE = 0x17 # macro
NV2080_NVLINK_CORE_LINK_STATE_DISABLE_HEARTBEAT = 0x18 # macro
NV2080_NVLINK_CORE_LINK_STATE_CONTAIN = 0x19 # macro
NV2080_NVLINK_CORE_LINK_STATE_INITTL = 0x1A # macro
NV2080_NVLINK_CORE_LINK_STATE_INITPHASE5 = 0x1B # macro
NV2080_NVLINK_CORE_LINK_STATE_ALI = 0x1C # macro
NV2080_NVLINK_CORE_LINK_STATE_ACTIVE_PENDING = 0x1D # macro
NV2080_NVLINK_CORE_LINK_STATE_INVALID = 0xFF # macro
NV2080_NVLINK_CORE_SUBLINK_STATE_TX_HS = 0x00 # macro
NV2080_NVLINK_CORE_SUBLINK_STATE_TX_SINGLE_LANE = 0x04 # macro
NV2080_NVLINK_CORE_SUBLINK_STATE_TX_LOW_POWER = 0x04 # macro
NV2080_NVLINK_CORE_SUBLINK_STATE_TX_TRAIN = 0x05 # macro
NV2080_NVLINK_CORE_SUBLINK_STATE_TX_SAFE = 0x06 # macro
NV2080_NVLINK_CORE_SUBLINK_STATE_TX_OFF = 0x07 # macro
NV2080_NVLINK_CORE_SUBLINK_STATE_TX_COMMON_MODE = 0x08 # macro
NV2080_NVLINK_CORE_SUBLINK_STATE_TX_COMMON_MODE_DISABLE = 0x09 # macro
NV2080_NVLINK_CORE_SUBLINK_STATE_TX_DATA_READY = 0x0A # macro
NV2080_NVLINK_CORE_SUBLINK_STATE_TX_EQ = 0x0B # macro
NV2080_NVLINK_CORE_SUBLINK_STATE_TX_PRBS_EN = 0x0C # macro
NV2080_NVLINK_CORE_SUBLINK_STATE_TX_POST_HS = 0x0D # macro
NV2080_NVLINK_CORE_SUBLINK_STATE_RX_HS = 0x00 # macro
NV2080_NVLINK_CORE_SUBLINK_STATE_RX_SINGLE_LANE = 0x04 # macro
NV2080_NVLINK_CORE_SUBLINK_STATE_RX_LOW_POWER = 0x04 # macro
NV2080_NVLINK_CORE_SUBLINK_STATE_RX_TRAIN = 0x05 # macro
NV2080_NVLINK_CORE_SUBLINK_STATE_RX_SAFE = 0x06 # macro
NV2080_NVLINK_CORE_SUBLINK_STATE_RX_OFF = 0x07 # macro
NV2080_NVLINK_CORE_SUBLINK_STATE_RX_RXCAL = 0x08 # macro
NV2080_NVLINK_CORE_SUBLINK_STATE_RX_INIT_TERM = 0x09 # macro
NV2080_CTRL_NVLINK_MAX_SEED_NUM = 6 # macro
NV2080_CTRL_NVLINK_MAX_SEED_BUFFER_SIZE = (0x7) # macro
NV2080_CTRL_NVLINK_CALLBACK_TYPE_GET_DL_LINK_MODE = 0x00 # macro
NV2080_CTRL_NVLINK_CALLBACK_TYPE_SET_DL_LINK_MODE = 0x01 # macro
NV2080_CTRL_NVLINK_CALLBACK_TYPE_GET_TL_LINK_MODE = 0x02 # macro
NV2080_CTRL_NVLINK_CALLBACK_TYPE_SET_TL_LINK_MODE = 0x03 # macro
NV2080_CTRL_NVLINK_CALLBACK_TYPE_GET_TX_SUBLINK_MODE = 0x04 # macro
NV2080_CTRL_NVLINK_CALLBACK_TYPE_SET_TX_SUBLINK_MODE = 0x05 # macro
NV2080_CTRL_NVLINK_CALLBACK_TYPE_GET_RX_SUBLINK_MODE = 0x06 # macro
NV2080_CTRL_NVLINK_CALLBACK_TYPE_SET_RX_SUBLINK_MODE = 0x07 # macro
NV2080_CTRL_NVLINK_CALLBACK_TYPE_GET_RX_SUBLINK_DETECT = 0x08 # macro
NV2080_CTRL_NVLINK_CALLBACK_TYPE_SET_RX_SUBLINK_DETECT = 0x09 # macro
NV2080_CTRL_NVLINK_CALLBACK_TYPE_WRITE_DISCOVERY_TOKEN = 0x0A # macro
NV2080_CTRL_NVLINK_CALLBACK_TYPE_READ_DISCOVERY_TOKEN = 0x0B # macro
NV2080_CTRL_NVLINK_CALLBACK_TYPE_TRAINING_COMPLETE = 0x0C # macro
NV2080_CTRL_NVLINK_CALLBACK_TYPE_GET_UPHY_LOAD = 0x0D # macro
NV2080_CTRL_NVLINK_CORE_CALLBACK_PARAMS_MESSAGE_ID = (0x19) # macro
NV2080_CTRL_CMD_NVLINK_CORE_CALLBACK = (0x20803019) # macro
NV2080_CTRL_NVLINK_GET_ALI_ENABLED_PARAMS_MESSAGE_ID = (0x1a) # macro
NV2080_CTRL_CMD_NVLINK_GET_ALI_ENABLED = (0x2080301a) # macro
NV2080_CTRL_NVLINK_UPDATE_REMOTE_LOCAL_SID_PARAMS_MESSAGE_ID = (0x1b) # macro
NV2080_CTRL_CMD_NVLINK_UPDATE_REMOTE_LOCAL_SID = (0x2080301b) # macro
NV2080_CTRL_NVLINK_UPDATE_HSHUB_MUX_TYPE_PROGRAM = 0x0 # macro
NV2080_CTRL_NVLINK_UPDATE_HSHUB_MUX_TYPE_RESET = 0x1 # macro
NV2080_CTRL_NVLINK_UPDATE_HSHUB_MUX_PARAMS_MESSAGE_ID = (0x1c) # macro
NV2080_CTRL_CMD_NVLINK_UPDATE_HSHUB_MUX = (0x2080301c) # macro
NV2080_CTRL_NVLINK_PRE_SETUP_NVLINK_PEER_PARAMS_MESSAGE_ID = (0x1d) # macro
NV2080_CTRL_CMD_NVLINK_PRE_SETUP_NVLINK_PEER = (0x2080301d) # macro
NV2080_CTRL_NVLINK_POST_SETUP_NVLINK_PEER_PARAMS_MESSAGE_ID = (0x1e) # macro
NV2080_CTRL_CMD_NVLINK_POST_SETUP_NVLINK_PEER = (0x2080301e) # macro
NV2080_CTRL_NVLINK_REMOVE_NVLINK_MAPPING_TYPE_SYSMEM = 0x1 # macro
NV2080_CTRL_NVLINK_REMOVE_NVLINK_MAPPING_TYPE_PEER = 0x2 # macro
NV2080_CTRL_NVLINK_REMOVE_NVLINK_MAPPING_PARAMS_MESSAGE_ID = (0x1f) # macro
NV2080_CTRL_CMD_NVLINK_REMOVE_NVLINK_MAPPING = (0x2080301f) # macro
NV2080_CTRL_NVLINK_SAVE_RESTORE_HSHUB_STATE_PARAMS_MESSAGE_ID = (0x20) # macro
NV2080_CTRL_CMD_NVLINK_SAVE_RESTORE_HSHUB_STATE = (0x20803020) # macro
NV2080_CTRL_NVLINK_PROGRAM_BUFFERREADY_FLAGS_SET = (0x00000000) # macro
NV2080_CTRL_NVLINK_PROGRAM_BUFFERREADY_FLAGS_SAVE = (0x00000001) # macro
NV2080_CTRL_NVLINK_PROGRAM_BUFFERREADY_FLAGS_RESTORE = (0x00000002) # macro
NV2080_CTRL_NVLINK_PROGRAM_BUFFERREADY_PARAMS_MESSAGE_ID = (0x21) # macro
NV2080_CTRL_CMD_NVLINK_PROGRAM_BUFFERREADY = (0x20803021) # macro
NV2080_CTRL_NVLINK_UPDATE_CURRENT_CONFIG_PARAMS_MESSAGE_ID = (0x22) # macro
NV2080_CTRL_CMD_NVLINK_UPDATE_CURRENT_CONFIG = (0x20803022) # macro
NV2080_CTRL_NVLINK_SET_LOOPBACK_MODE_DEFAULT = (0x00000000) # macro
NV2080_CTRL_NVLINK_SET_LOOPBACK_MODE_NEA = (0x00000001) # macro
NV2080_CTRL_NVLINK_SET_LOOPBACK_MODE_NEDR = (0x00000002) # macro
NV2080_CTRL_NVLINK_SET_LOOPBACK_MODE_NEDW = (0x00000003) # macro
NV2080_CTRL_NVLINK_SET_LOOPBACK_MODE_PARAMS_MESSAGE_ID = (0x23) # macro
NV2080_CTRL_CMD_NVLINK_SET_LOOPBACK_MODE = (0x20803023) # macro
NV2080_CTRL_NVLINK_UPDATE_PEER_LINK_MASK_PARAMS_MESSAGE_ID = (0x24) # macro
NV2080_CTRL_CMD_NVLINK_UPDATE_PEER_LINK_MASK = (0x20803024) # macro
NV2080_CTRL_NVLINK_UPDATE_LINK_CONNECTION_PARAMS_MESSAGE_ID = (0x25) # macro
NV2080_CTRL_CMD_NVLINK_UPDATE_LINK_CONNECTION = (0x20803025) # macro
NV2080_CTRL_NVLINK_ENABLE_LINKS_POST_TOPOLOGY_PARAMS_MESSAGE_ID = (0x26) # macro
NV2080_CTRL_CMD_NVLINK_ENABLE_LINKS_POST_TOPOLOGY = (0x20803026) # macro
NV2080_CTRL_NVLINK_PRE_LINK_TRAIN_ALI_PARAMS_MESSAGE_ID = (0x27) # macro
NV2080_CTRL_CMD_NVLINK_PRE_LINK_TRAIN_ALI = (0x20803027) # macro
NV2080_CTRL_NVLINK_MAX_LINK_COUNT = 32 # macro
NV2080_CTRL_NVLINK_GET_REFRESH_COUNTERS_PARAMS_MESSAGE_ID = (0x28) # macro
NV2080_CTRL_CMD_NVLINK_GET_REFRESH_COUNTERS = (0x20803028) # macro
NV2080_CTRL_NVLINK_CLEAR_REFRESH_COUNTERS_PARAMS_MESSAGE_ID = (0x29) # macro
NV2080_CTRL_CMD_NVLINK_CLEAR_REFRESH_COUNTERS = (0x20803029) # macro
NV2080_CTRL_NVLINK_GET_LINK_MASK_POST_RX_DET_PARAMS_MESSAGE_ID = (0x2a) # macro
NV2080_CTRL_CMD_NVLINK_GET_LINK_MASK_POST_RX_DET = (0x2080302a) # macro
NV2080_CTRL_NVLINK_LINK_TRAIN_ALI_PARAMS_MESSAGE_ID = (0x2b) # macro
NV2080_CTRL_CMD_NVLINK_LINK_TRAIN_ALI = (0x2080302b) # macro
NV2080_CTRL_NVLINK_GET_NVLINK_DEVICE_INFO_PARAMS_MESSAGE_ID = (0x2c) # macro
NV2080_CTRL_CMD_NVLINK_GET_NVLINK_DEVICE_INFO = (0x2080302c) # macro
NV2080_CTRL_NVLINK_MAX_LINKS_PER_IOCTRL_SW = 6 # macro
NV2080_CTRL_NVLINK_GET_IOCTRL_DEVICE_INFO_PARAMS_MESSAGE_ID = (0x2d) # macro
NV2080_CTRL_CMD_NVLINK_GET_IOCTRL_DEVICE_INFO = (0x2080302d) # macro
NV2080_CTRL_NVLINK_PROGRAM_LINK_SPEED_PARAMS_MESSAGE_ID = (0x2e) # macro
NV2080_CTRL_CMD_NVLINK_PROGRAM_LINK_SPEED = (0x2080302e) # macro
NV2080_CTRL_NVLINK_ARE_LINKS_TRAINED_PARAMS_MESSAGE_ID = (0x2f) # macro
NV2080_CTRL_CMD_NVLINK_ARE_LINKS_TRAINED = (0x2080302f) # macro
NV2080_CTRL_NVLINK_RESET_FLAGS_ASSERT = (0x00000000) # macro
NV2080_CTRL_NVLINK_RESET_FLAGS_DEASSERT = (0x00000001) # macro
NV2080_CTRL_NVLINK_RESET_FLAGS_TOGGLE = (0x00000002) # macro
NV2080_CTRL_NVLINK_RESET_LINKS_PARAMS_MESSAGE_ID = (0x30) # macro
NV2080_CTRL_CMD_NVLINK_RESET_LINKS = (0x20803030) # macro
NV2080_CTRL_NVLINK_DISABLE_DL_INTERRUPTS_PARAMS_MESSAGE_ID = (0x31) # macro
NV2080_CTRL_CMD_NVLINK_DISABLE_DL_INTERRUPTS = (0x20803031) # macro
NV2080_CTRL_NVLINK_GET_LINK_AND_CLOCK_INFO_PARAMS_MESSAGE_ID = (0x32) # macro
NV2080_CTRL_CMD_NVLINK_GET_LINK_AND_CLOCK_INFO = (0x20803032) # macro
NV2080_CTRL_NVLINK_SETUP_NVLINK_SYSMEM_PARAMS_MESSAGE_ID = (0x33) # macro
NV2080_CTRL_CMD_NVLINK_SETUP_NVLINK_SYSMEM = (0x20803033) # macro
NV2080_CTRL_NVLINK_PROCESS_FORCED_CONFIGS_PARAMS_MESSAGE_ID = (0x34) # macro
NV2080_CTRL_CMD_NVLINK_PROCESS_FORCED_CONFIGS = (0x20803034) # macro
NV2080_CTRL_NVLINK_SYNC_NVLINK_SHUTDOWN_PROPS_PARAMS_MESSAGE_ID = (0x35) # macro
NV2080_CTRL_CMD_NVLINK_SYNC_NVLINK_SHUTDOWN_PROPS = (0x20803035) # macro
NV2080_CTRL_NVLINK_ENABLE_SYSMEM_NVLINK_ATS_PARAMS_MESSAGE_ID = (0x36) # macro
NV2080_CTRL_CMD_NVLINK_ENABLE_SYSMEM_NVLINK_ATS = (0x20803036) # macro
NV2080_CTRL_NVLINK_HSHUB_GET_SYSMEM_NVLINK_MASK_PARAMS_MESSAGE_ID = (0x37) # macro
NV2080_CTRL_CMD_NVLINK_HSHUB_GET_SYSMEM_NVLINK_MASK = (0x20803037) # macro
NV2080_CTRL_NVLINK_GET_SET_NVSWITCH_FLA_ADDR_PARAMS_MESSAGE_ID = (0x38) # macro
NV2080_CTRL_CMD_NVLINK_GET_SET_NVSWITCH_FLA_ADDR = (0x20803038) # macro
NV2080_CTRL_NVLINK_SYNC_LINK_MASKS_AND_VBIOS_INFO_PARAMS_MESSAGE_ID = (0x39) # macro
NV2080_CTRL_CMD_NVLINK_SYNC_LINK_MASKS_AND_VBIOS_INFO = (0x20803039) # macro
NV2080_CTRL_CMD_NVLINK_ENABLE_LINKS = (0x2080303a) # macro
NV2080_CTRL_NVLINK_PROCESS_INIT_DISABLED_LINKS_PARAMS_MESSAGE_ID = (0x3b) # macro
NV2080_CTRL_CMD_NVLINK_PROCESS_INIT_DISABLED_LINKS = (0x2080303b) # macro
NV2080_CTRL_NVLINK_EOM_CONTROL_PARAMS_MESSAGE_ID = (0x3c) # macro
NV2080_CTRL_CMD_NVLINK_EOM_CONTROL = (0x2080303c) # macro
NV2080_CTRL_NVLINK_INBAND_MAX_DATA_SIZE = 5120 # macro
NV2080_CTRL_NVLINK_INBAND_RECEIVED_DATA_PARAMS_MESSAGE_ID = (0x3d) # macro
NV2080_CTRL_CMD_READ_NVLINK_INBAND_RESPONSE = (0x2080303d) # macro
NV2080_CTRL_NVLINK_SET_L1_THRESHOLD_PARAMS_MESSAGE_ID = (0x3e) # macro
NV2080_CTRL_CMD_NVLINK_SET_L1_THRESHOLD = (0x2080303e) # macro
NV2080_CTRL_NVLINK_GET_L1_THRESHOLD_PARAMS_MESSAGE_ID = (0x3f) # macro
NV2080_CTRL_CMD_NVLINK_GET_L1_THRESHOLD = (0x2080303f) # macro
NV2080_CTRL_NVLINK_INBAND_SEND_DATA_PARAMS_MESSAGE_ID = (0x40) # macro
NV2080_CTRL_CMD_NVLINK_INBAND_SEND_DATA = (0x20803040) # macro
NV2080_CTRL_NVLINK_IS_GPU_DEGRADED_PARAMS_MESSAGE_ID = (0x41) # macro
NV2080_CTRL_CMD_NVLINK_IS_GPU_DEGRADED = (0x20803041) # macro
NV2080_CTRL_NVLINK_DIRECT_CONNECT_CHECK_PARAMS_MESSAGE_ID = (0x42) # macro
NV2080_CTRL_CMD_NVLINK_DIRECT_CONNECT_CHECK = (0x20803042) # macro
NV2080_CTRL_NVLINK_POST_FAULT_UP_PARAMS_MESSAGE_ID = (0x43) # macro
NV2080_CTRL_CMD_NVLINK_POST_FAULT_UP = (0x20803043) # macro
NV2080_CTRL_NVLINK_PORT_EVENT_COUNT_SIZE = 64 # macro
NV2080_CTRL_NVLINK_GET_PORT_EVENTS_PARAMS_MESSAGE_ID = (0x44) # macro
NV2080_CTRL_CMD_NVLINK_GET_PORT_EVENTS = (0x20803044) # macro
NV2080_CTRL_NVLINK_CYCLE_LINK_PARAMS_MESSAGE_ID = (0x45) # macro
NV2080_CTRL_CMD_NVLINK_CYCLE_LINK = (0x20803045) # macro
NV2080_CTRL_NVLINK_IS_REDUCED_CONFIG_PARAMS_MESSAGE_ID = (0x46) # macro
NV2080_CTRL_CMD_NVLINK_IS_REDUCED_CONFIG = (0x20803046) # macro
NV2080_CTRL_CMD_NVLINK_FATAL_ERROR_RECOVERY = (0x20803048) # macro
class struct_NV2080_CTRL_CMD_NVLINK_GET_NVLINK_CAPS_PARAMS(Structure):
    pass

struct_NV2080_CTRL_CMD_NVLINK_GET_NVLINK_CAPS_PARAMS._pack_ = 1 # source:False
struct_NV2080_CTRL_CMD_NVLINK_GET_NVLINK_CAPS_PARAMS._fields_ = [
    ('capsTbl', ctypes.c_uint32),
    ('lowestNvlinkVersion', ctypes.c_ubyte),
    ('highestNvlinkVersion', ctypes.c_ubyte),
    ('lowestNciVersion', ctypes.c_ubyte),
    ('highestNciVersion', ctypes.c_ubyte),
    ('discoveredLinkMask', ctypes.c_uint32),
    ('enabledLinkMask', ctypes.c_uint32),
]

NV2080_CTRL_CMD_NVLINK_G