# -*- coding: utf-8 -*-
# Generated by Django 1.11 on 2017-10-12 23:29
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion
import django.utils.timezone
import jacc.models
import jutil.cache


class Migration(migrations.Migration):

    initial = True

    dependencies = []

    operations = [
        migrations.CreateModel(
            name="Account",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "currency",
                    models.CharField(
                        blank=True,
                        choices=[("EUR", "EUR"), ("USD", "USD")],
                        default="EUR",
                        max_length=3,
                        verbose_name="currency",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                ("last_modified", models.DateTimeField(auto_now=True, db_index=True, verbose_name="last modified")),
            ],
            options={
                "verbose_name_plural": "accounts",
                "verbose_name": "account",
            },
        ),
        migrations.CreateModel(
            name="AccountEntry",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                ("last_modified", models.DateTimeField(auto_now=True, db_index=True, verbose_name="last modified")),
                (
                    "timestamp",
                    models.DateTimeField(
                        blank=True, db_index=True, default=django.utils.timezone.now, verbose_name="timestamp"
                    ),
                ),
                ("description", models.CharField(blank=True, default="", max_length=256, verbose_name="description")),
                ("amount", models.DecimalField(decimal_places=2, max_digits=10, verbose_name="amount")),
                (
                    "account",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.PROTECT,
                        related_name="accountentry_set",
                        to="jacc.Account",
                        verbose_name="account",
                    ),
                ),
                (
                    "parent",
                    models.ForeignKey(
                        blank=True,
                        default=None,
                        null=True,
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="child_set",
                        to="jacc.AccountEntry",
                        verbose_name="account.entry.parent",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "account entries",
                "verbose_name": "account entry",
            },
        ),
        migrations.CreateModel(
            name="AccountEntrySource",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("name", models.CharField(blank=True, db_index=True, default="", max_length=255, verbose_name="name")),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                ("last_modified", models.DateTimeField(auto_now=True, db_index=True, verbose_name="last modified")),
            ],
            options={
                "verbose_name_plural": "account entry sources",
                "verbose_name": "account entry source",
            },
        ),
        migrations.CreateModel(
            name="AccountType",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("code", models.CharField(db_index=True, max_length=32, unique=True, verbose_name="code")),
                ("name", models.CharField(db_index=True, max_length=64, unique=True, verbose_name="name")),
                ("is_debit", models.BooleanField(verbose_name="is debit")),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                ("last_modified", models.DateTimeField(auto_now=True, db_index=True, verbose_name="last modified")),
            ],
            options={
                "verbose_name_plural": "account types",
                "verbose_name": "account type",
            },
        ),
        migrations.CreateModel(
            name="Contract",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                ("last_modified", models.DateTimeField(auto_now=True, db_index=True, verbose_name="last modified")),
                ("name", models.CharField(blank=True, db_index=True, default="", max_length=128, verbose_name="name")),
            ],
            options={
                "verbose_name_plural": "contracts",
                "verbose_name": "contract",
            },
        ),
        migrations.CreateModel(
            name="EntryType",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                ("code", models.CharField(db_index=True, max_length=32, unique=True, verbose_name="code")),
                ("name", models.CharField(db_index=True, max_length=64, unique=True, verbose_name="name")),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                ("last_modified", models.DateTimeField(auto_now=True, db_index=True, verbose_name="last modified")),
                (
                    "payback_priority",
                    models.SmallIntegerField(blank=True, db_index=True, default=0, verbose_name="payback priority"),
                ),
                ("is_settlement", models.BooleanField(db_index=True, default=False, verbose_name="is settlement")),
                ("is_payment", models.BooleanField(db_index=True, default=False, verbose_name="is payment")),
            ],
            options={
                "verbose_name_plural": "entry types",
                "verbose_name": "entry type",
            },
        ),
        migrations.CreateModel(
            name="Invoice",
            fields=[
                ("id", models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name="ID")),
                (
                    "type",
                    models.CharField(
                        blank=True,
                        choices=[("I1", "Invoice"), ("I2", "Credit Note")],
                        db_index=True,
                        default="I1",
                        max_length=2,
                        verbose_name="type",
                    ),
                ),
                (
                    "created",
                    models.DateTimeField(
                        blank=True,
                        db_index=True,
                        default=django.utils.timezone.now,
                        editable=False,
                        verbose_name="created",
                    ),
                ),
                ("last_modified", models.DateTimeField(auto_now=True, db_index=True, verbose_name="last modified")),
                ("sent", models.DateTimeField(blank=True, db_index=True, default=None, null=True, verbose_name="sent")),
                (
                    "due_date",
                    models.DateTimeField(
                        db_index=True, default=jacc.models.get_default_due_date, verbose_name="due date"
                    ),
                ),
                ("notes", models.TextField(blank=True, default="", verbose_name="notes")),
                (
                    "filename",
                    models.CharField(blank=True, db_index=True, default="", max_length=255, verbose_name="filename"),
                ),
                (
                    "amount",
                    models.DecimalField(blank=True, decimal_places=2, default=0, max_digits=10, verbose_name="amount"),
                ),
                (
                    "paid_amount",
                    models.DecimalField(
                        blank=True,
                        db_index=True,
                        decimal_places=2,
                        default=None,
                        editable=False,
                        max_digits=10,
                        null=True,
                        verbose_name="paid amount",
                    ),
                ),
                (
                    "unpaid_amount",
                    models.DecimalField(
                        blank=True,
                        db_index=True,
                        decimal_places=2,
                        default=None,
                        editable=False,
                        max_digits=10,
                        null=True,
                        verbose_name="unpaid amount",
                    ),
                ),
                (
                    "overpaid_amount",
                    models.DecimalField(
                        blank=True,
                        db_index=True,
                        decimal_places=2,
                        default=None,
                        editable=False,
                        max_digits=10,
                        null=True,
                        verbose_name="overpaid amount",
                    ),
                ),
                (
                    "close_date",
                    models.DateTimeField(blank=True, db_index=True, default=None, null=True, verbose_name="close date"),
                ),
                (
                    "late_days",
                    models.SmallIntegerField(
                        blank=True, db_index=True, default=None, null=True, verbose_name="late days"
                    ),
                ),
                (
                    "state",
                    models.CharField(
                        blank=True,
                        choices=[("N", "Not due yet"), ("D", "Due"), ("L", "Late"), ("P", "Paid")],
                        db_index=True,
                        default="",
                        max_length=1,
                        verbose_name="state",
                    ),
                ),
            ],
            options={
                "verbose_name_plural": "invoices",
                "verbose_name": "invoice",
            },
            bases=(models.Model, jutil.cache.CachedFieldsMixin),
        ),
        migrations.AddField(
            model_name="accountentry",
            name="settled_invoice",
            field=models.ForeignKey(
                blank=True,
                default=None,
                help_text="For incoming settlements",
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="jacc.Invoice",
                verbose_name="settled invoice",
            ),
        ),
        migrations.AddField(
            model_name="accountentry",
            name="settled_item",
            field=models.ForeignKey(
                blank=True,
                default=None,
                help_text="For matched settlements",
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="settlement_set",
                to="jacc.AccountEntry",
                verbose_name="settled item",
            ),
        ),
        migrations.AddField(
            model_name="accountentry",
            name="source",
            field=models.ForeignKey(
                blank=True,
                default=None,
                help_text="Source for account entry, e.g. received payment (if any)",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="jacc.AccountEntrySource",
                verbose_name="source",
            ),
        ),
        migrations.AddField(
            model_name="accountentry",
            name="source_invoice",
            field=models.ForeignKey(
                blank=True,
                default=None,
                help_text="For invoice items",
                null=True,
                on_delete=django.db.models.deletion.CASCADE,
                related_name="+",
                to="jacc.Invoice",
                verbose_name="source invoice",
            ),
        ),
        migrations.AddField(
            model_name="accountentry",
            name="type",
            field=models.ForeignKey(
                blank=True,
                default=None,
                null=True,
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="jacc.EntryType",
                verbose_name="type",
            ),
        ),
        migrations.AddField(
            model_name="account",
            name="type",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.PROTECT,
                related_name="+",
                to="jacc.AccountType",
                verbose_name="type",
            ),
        ),
    ]
