# coding: utf-8

"""
    CLOUD API

    IONOS Enterprise-grade Infrastructure as a Service (IaaS) solutions can be managed through the Cloud API, in addition or as an alternative to the \"Data Center Designer\" (DCD) browser-based tool.    Both methods employ consistent concepts and features, deliver similar power and flexibility, and can be used to perform a multitude of management tasks, including adding servers, volumes, configuring networks, and so on.  # noqa: E501

    The version of the OpenAPI document: 6.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from ionoscloud.configuration import Configuration


class TemplateProperties(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {

        'name': 'str',

        'cores': 'float',

        'ram': 'float',

        'storage_size': 'float',
    }

    attribute_map = {

        'name': 'name',

        'cores': 'cores',

        'ram': 'ram',

        'storage_size': 'storageSize',
    }

    def __init__(self, name=None, cores=None, ram=None, storage_size=None, local_vars_configuration=None):  # noqa: E501
        """TemplateProperties - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._name = None
        self._cores = None
        self._ram = None
        self._storage_size = None
        self.discriminator = None

        self.name = name
        self.cores = cores
        self.ram = ram
        self.storage_size = storage_size


    @property
    def name(self):
        """Gets the name of this TemplateProperties.  # noqa: E501

        The name of the  resource.  # noqa: E501

        :return: The name of this TemplateProperties.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this TemplateProperties.

        The name of the  resource.  # noqa: E501

        :param name: The name of this TemplateProperties.  # noqa: E501
        :type name: str
        """
        if self.local_vars_configuration.client_side_validation and name is None:  # noqa: E501
            raise ValueError("Invalid value for `name`, must not be `None`")  # noqa: E501

        self._name = name

    @property
    def cores(self):
        """Gets the cores of this TemplateProperties.  # noqa: E501

        The CPU cores count.  # noqa: E501

        :return: The cores of this TemplateProperties.  # noqa: E501
        :rtype: float
        """
        return self._cores

    @cores.setter
    def cores(self, cores):
        """Sets the cores of this TemplateProperties.

        The CPU cores count.  # noqa: E501

        :param cores: The cores of this TemplateProperties.  # noqa: E501
        :type cores: float
        """
        if self.local_vars_configuration.client_side_validation and cores is None:  # noqa: E501
            raise ValueError("Invalid value for `cores`, must not be `None`")  # noqa: E501

        self._cores = cores

    @property
    def ram(self):
        """Gets the ram of this TemplateProperties.  # noqa: E501

        The RAM size in MB.  # noqa: E501

        :return: The ram of this TemplateProperties.  # noqa: E501
        :rtype: float
        """
        return self._ram

    @ram.setter
    def ram(self, ram):
        """Sets the ram of this TemplateProperties.

        The RAM size in MB.  # noqa: E501

        :param ram: The ram of this TemplateProperties.  # noqa: E501
        :type ram: float
        """
        if self.local_vars_configuration.client_side_validation and ram is None:  # noqa: E501
            raise ValueError("Invalid value for `ram`, must not be `None`")  # noqa: E501

        self._ram = ram

    @property
    def storage_size(self):
        """Gets the storage_size of this TemplateProperties.  # noqa: E501

        The storage size in GB.  # noqa: E501

        :return: The storage_size of this TemplateProperties.  # noqa: E501
        :rtype: float
        """
        return self._storage_size

    @storage_size.setter
    def storage_size(self, storage_size):
        """Sets the storage_size of this TemplateProperties.

        The storage size in GB.  # noqa: E501

        :param storage_size: The storage_size of this TemplateProperties.  # noqa: E501
        :type storage_size: float
        """
        if self.local_vars_configuration.client_side_validation and storage_size is None:  # noqa: E501
            raise ValueError("Invalid value for `storage_size`, must not be `None`")  # noqa: E501

        self._storage_size = storage_size
    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, TemplateProperties):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, TemplateProperties):
            return True

        return self.to_dict() != other.to_dict()
