/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.PPsource;

import ModelInterface.BatchRunner;
import ModelInterface.InterfaceMain;
import ModelInterface.MenuAdder;
import ModelInterface.ModelGUI2.XMLFilter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.SpringLayout;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class PPViewer
implements ActionListener,
MenuAdder,
BatchRunner {
    public static String controlStr = "PPViewer";
    private JFrame parentFrame;
    private File currFile;
    private JPanel pane;
    private JTextArea textArea;
    private JTextField fileNameField;
    private XMLFilter xmlFilter = new XMLFilter();

    public PPViewer() {
        this.parentFrame = InterfaceMain.getInstance().getFrame();
        this.parentFrame.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("Control")) {
                    if (propertyChangeEvent.getOldValue().equals(controlStr) || propertyChangeEvent.getOldValue().equals(controlStr + "Same")) {
                        PPViewer.this.parentFrame.getContentPane().removeAll();
                    }
                    if (propertyChangeEvent.getNewValue().equals(controlStr)) {
                        PPViewer.this.setupPane();
                    }
                }
            }
        });
    }

    @Override
    public void addMenuItems(InterfaceMain.MenuManager menuManager) {
        JMenuItem jMenuItem = new JMenuItem("Preprocessor file");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(80, 8));
        jMenuItem.addActionListener(this);
        menuManager.getSubMenuManager(0).getSubMenuManager(5).addMenuItem(jMenuItem, 10);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = false;
        String string = actionEvent.getActionCommand();
        if (string.equals("Preprocessor file")) {
            bl = this.openPPFile();
            if (bl) {
                this.displayFile();
                this.parentFrame.setTitle("[" + this.currFile + "] - ModelInterface");
            }
        } else if (string.equals("Create")) {
            int n = JOptionPane.showConfirmDialog(this.parentFrame, "Are you sure you want to run the Preprocessor now?", "Run Preprocessor?", 0, -1);
            if (n == 1) {
                return;
            }
            this.writeFile();
            this.runPreprocess();
        } else if (string.equals("stub")) {
            // empty if block
        }
    }

    private boolean openPPFile() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setDialogTitle("Open XML File");
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setCurrentDirectory(new File(InterfaceMain.getInstance().getProperties().getProperty("lastDirectory", ".")));
        jFileChooser.setFileFilter(this.xmlFilter);
        int n = jFileChooser.showOpenDialog(this.parentFrame);
        if (n == 1) {
            return false;
        }
        if (n != 0) {
            return false;
        }
        InterfaceMain.getInstance().fireControlChange(controlStr);
        this.currFile = jFileChooser.getSelectedFile();
        InterfaceMain.getInstance().getProperties().setProperty("lastDirectory", jFileChooser.getCurrentDirectory().toString());
        return true;
    }

    private void displayFile() {
        if (this.currFile == null) {
            return;
        }
        try {
            int n = 0;
            String string = "";
            FileReader fileReader = new FileReader(this.currFile);
            while ((n = fileReader.read()) != -1) {
                char c = (char)n;
                string = string + c;
            }
            fileReader.close();
            this.textArea.setText(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("The file " + this.currFile.getName() + " does not exist, how I dont know.");
        }
        catch (IOException iOException) {
            System.out.println("Encountered an error while attempting to read from " + this.currFile.getName() + ".");
        }
    }

    private void setupPane() {
        this.pane = new JPanel();
        SpringLayout springLayout = new SpringLayout();
        this.pane.setLayout(springLayout);
        JLabel jLabel = new JLabel("File Name:");
        springLayout.putConstraint("West", (Component)jLabel, 10, "West", (Component)this.pane);
        springLayout.putConstraint("North", (Component)jLabel, 10, "North", (Component)this.pane);
        this.fileNameField = new JTextField(30);
        this.fileNameField.setActionCommand("Create");
        this.fileNameField.addActionListener(this);
        this.fileNameField.setMaximumSize(this.fileNameField.getPreferredSize());
        springLayout.putConstraint("West", (Component)this.fileNameField, 5, "East", (Component)jLabel);
        springLayout.putConstraint("North", (Component)this.fileNameField, 10, "North", (Component)this.pane);
        JLabel jLabel2 = new JLabel("Definition:");
        springLayout.putConstraint("North", (Component)jLabel2, 5, "South", (Component)this.fileNameField);
        springLayout.putConstraint("West", (Component)jLabel2, 10, "West", (Component)this.pane);
        JButton jButton = new JButton("Create");
        jButton.setActionCommand("Create");
        jButton.addActionListener(this);
        springLayout.putConstraint("North", (Component)jButton, 10, "North", (Component)this.pane);
        springLayout.putConstraint("East", (Component)jButton, -10, "East", (Component)this.pane);
        this.textArea = new JTextArea(25, 80);
        JScrollPane jScrollPane = new JScrollPane(this.textArea, 22, 30);
        this.textArea.setEditable(true);
        this.textArea.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        springLayout.putConstraint("West", (Component)jScrollPane, 10, "West", (Component)this.pane);
        springLayout.putConstraint("North", (Component)jScrollPane, 5, "South", (Component)jLabel2);
        springLayout.putConstraint("East", (Component)this.pane, 10, "East", (Component)jScrollPane);
        springLayout.putConstraint("South", (Component)this.pane, 10, "South", (Component)jScrollPane);
        this.pane.add(jLabel);
        this.pane.add(this.fileNameField);
        this.pane.add(jLabel2);
        this.pane.add(jButton);
        this.pane.add(jScrollPane);
        this.parentFrame.setContentPane(this.pane);
        this.parentFrame.pack();
    }

    private void writeFile() {
        if (this.currFile == null) {
            return;
        }
        try {
            FileWriter fileWriter = new FileWriter(this.currFile);
            fileWriter.write(this.textArea.getText());
            fileWriter.flush();
            fileWriter.close();
        }
        catch (IOException iOException) {
            System.out.println("Encountered an error while attempting to write to " + this.currFile.getName() + ".");
        }
    }

    private void runPreprocess() {
        Logger logger = Logger.getLogger("Preprocess");
        logger.setLevel(Level.parse("WARNING"));
        logger.setUseParentHandlers(false);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.WARNING);
        logger.addHandler(consoleHandler);
        try {
            FileHandler fileHandler = new FileHandler("PPLog.log");
            fileHandler.setLevel(Level.ALL);
            fileHandler.setFormatter(new SimpleFormatter());
            logger.addHandler(fileHandler);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        String string = this.currFile.getName();
        String string2 = "inputR.xml";
        String string3 = this.fileNameField.getText();
        if (string3 == null) {
            string3 = "modelInterfacePPoutput";
        } else if (!string3.endsWith(".xml")) {
            string3 = string3.concat(".xml");
        }
        logger.log(Level.INFO, "creating DataBuilder to run preprocessing");
        throw new UnsupportedOperationException("This feature is not available in this version.");
    }

    @Override
    public void runBatch(Node node) {
        Logger logger = Logger.getLogger("Preprocess");
        logger.setLevel(Level.parse("WARNING"));
        logger.setUseParentHandlers(false);
        ConsoleHandler consoleHandler = new ConsoleHandler();
        consoleHandler.setLevel(Level.WARNING);
        logger.addHandler(consoleHandler);
        try {
            FileHandler fileHandler = new FileHandler("PPLog.log");
            fileHandler.setLevel(Level.ALL);
            fileHandler.setFormatter(new SimpleFormatter());
            logger.addHandler(fileHandler);
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        NodeList nodeList = node.getChildNodes();
        String string = null;
        String string2 = null;
        String string3 = null;
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1) continue;
            String string4 = ((Element)node2).getNodeName();
            if (string4.equals("data")) {
                string = ((Element)node2).getAttribute("file");
                continue;
            }
            if (string4.equals("region")) {
                string2 = ((Element)node2).getAttribute("file");
                continue;
            }
            if (string4.equals("output")) {
                string3 = ((Element)node2).getAttribute("file");
                continue;
            }
            if (string4.equals("log")) {
                logger.setLevel(Level.parse(((Element)node2).getAttribute("level")));
                continue;
            }
            logger.warning("Unreckognized command: " + string4);
        }
        if (string != null && string2 != null && string3 != null) {
            throw new UnsupportedOperationException("This feature is not available in this version.");
        }
        logger.severe("Not enough information to run data manipulator");
    }
}

