/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2.xmldb;

import ModelInterface.InterfaceMain;
import ModelInterface.ModelGUI2.queries.QueryGenerator;
import ModelInterface.ModelGUI2.xmldb.DbProcInterrupt;
import ModelInterface.ModelGUI2.xmldb.QueryBinding;
import ModelInterface.ModelGUI2.xmldb.QueryBindingFactory;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import org.basex.core.BaseXException;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.cmd.Add;
import org.basex.core.cmd.Close;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.Delete;
import org.basex.core.cmd.Open;
import org.basex.core.jobs.Job;
import org.basex.io.IO;
import org.basex.io.IOFile;
import org.basex.io.out.PrintOutput;
import org.basex.io.serial.Serializer;
import org.basex.query.QueryProcessor;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class XMLDB {
    private static XMLDB xmldbInstance = null;
    private Context context = null;
    private String contName = null;
    private boolean wasContextAdopted;

    public static XMLDB getInstance() {
        if (xmldbInstance == null) {
            System.out.println("The database is not open.");
        }
        return xmldbInstance;
    }

    public static void openDatabase(String string) throws Exception {
        if (xmldbInstance != null) {
            throw new Exception("Could not open databse because " + XMLDB.xmldbInstance.contName + " is still open");
        }
        xmldbInstance = new XMLDB(string);
    }

    public static void openDatabase(Context context) throws Exception {
        if (xmldbInstance != null) {
            throw new Exception("Could not open databse because " + XMLDB.xmldbInstance.contName + " is still open");
        }
        xmldbInstance = new XMLDB(context);
    }

    public static void closeDatabase() {
        if (xmldbInstance != null) {
            try {
                if (!XMLDB.xmldbInstance.wasContextAdopted) {
                    new Close().execute(XMLDB.xmldbInstance.context);
                }
            }
            catch (BaseXException baseXException) {
                baseXException.printStackTrace();
            }
            finally {
                XMLDB.xmldbInstance.context = null;
                XMLDB.xmldbInstance.contName = null;
                xmldbInstance = null;
            }
        }
    }

    private XMLDB(String string) throws Exception {
        this.wasContextAdopted = false;
        this.openDB(string);
    }

    public XMLDB(Context context) throws Exception {
        this.wasContextAdopted = true;
        this.context = context;
    }

    private void openDB(String string) throws Exception {
        File file = new File(string).getAbsoluteFile();
        String string2 = file.getParentFile().getCanonicalPath();
        String string3 = file.getName();
        this.contName = IO.get((String)string3).dbName();
        if (!string3.equals(this.contName)) {
            System.out.println("WARNING: " + string3 + " contains invalid characters, it has been changed to: " + this.contName);
            System.out.println("WARNING: container name '" + string3 + "' contains invalid characters, it has been changed to: '" + this.contName + "'");
        }
        System.setProperty("org.basex.DBPATH", string2);
        this.context = new Context();
        this.context.options.set(MainOptions.ATTRINDEX, false);
        this.context.options.set(MainOptions.FTINDEX, false);
        this.context.options.set(MainOptions.UPDINDEX, false);
        this.context.options.set(MainOptions.CHOP, true);
        this.context.options.set(MainOptions.ADDCACHE, true);
        this.context.options.set(MainOptions.INTPARSE, true);
        try {
            new Open(this.contName).execute(this.context);
        }
        catch (BaseXException baseXException) {
            baseXException.printStackTrace();
            int n = InterfaceMain.getInstance().showConfirmDialog("Could not open the database.  Attempt to create a new one?\nWARNING doing so will delete all files in the directory.", "Open DB Error", 0, 2, 1);
            if (n == 0) {
                new CreateDB(this.contName).execute(this.context);
            }
            throw baseXException;
        }
    }

    public void addFile(String string) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("ddMMyy-hhmmss");
        this.addFile("run_" + simpleDateFormat.format(new Date()) + ".xml", string);
    }

    public void addFile(String string, String string2) {
        try {
            new Add(string, string2).execute(this.context);
        }
        catch (BaseXException baseXException) {
            baseXException.printStackTrace();
        }
    }

    public void removeDoc(String string) {
        try {
            System.out.println("Removing :" + string);
            new Delete(string).execute(this.context);
        }
        catch (BaseXException baseXException) {
            baseXException.printStackTrace();
        }
    }

    public boolean exportDoc(String string, File file) {
        try {
            int[] nArray = this.context.data().resources.docs(string).toArray();
            if (nArray.length != 1) {
                System.err.println(string + " matched " + nArray.length + " docs; != 1");
                return false;
            }
            PrintOutput printOutput = new PrintOutput(new IOFile(file));
            Serializer serializer = Serializer.get((OutputStream)printOutput);
            serializer.serialize((Item)new DBNode(this.context.data(), nArray[0]));
            serializer.close();
            printOutput.close();
            return true;
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return false;
        }
    }

    public String getContainer() {
        return this.contName;
    }

    public QueryProcessor createQuery(String string, Vector<String> vector, Object[] objectArray, Object[] objectArray2) {
        return this.createQuery(QueryBindingFactory.getQueryBinding(string, vector, this.contName), objectArray, objectArray2);
    }

    public QueryProcessor createQuery(QueryGenerator queryGenerator, Object[] objectArray, Object[] objectArray2) {
        return this.createQuery(queryGenerator, objectArray, objectArray2, null);
    }

    public QueryProcessor createQuery(QueryGenerator queryGenerator, Object[] objectArray, Object[] objectArray2, DbProcInterrupt dbProcInterrupt) {
        return this.createQuery(QueryBindingFactory.getQueryBinding(queryGenerator, this.contName), objectArray, objectArray2, dbProcInterrupt);
    }

    public QueryProcessor createQuery(QueryBinding queryBinding, Object[] objectArray, Object[] objectArray2) {
        return this.createQuery(queryBinding, objectArray, objectArray2, null);
    }

    public QueryProcessor createQuery(QueryBinding queryBinding, Object[] objectArray, Object[] objectArray2, DbProcInterrupt dbProcInterrupt) {
        String string = queryBinding.bindToQuery(objectArray, objectArray2);
        System.out.println("About to perform query: " + string);
        QueryProcessor queryProcessor = new QueryProcessor(string, this.context);
        if (dbProcInterrupt != null) {
            dbProcInterrupt.setProc((Job)queryProcessor);
        }
        return queryProcessor;
    }

    public static Map<String, String> getAttrMap(Node node) {
        NamedNodeMap namedNodeMap = node.getAttributes();
        TreeMap<String, String> treeMap = new TreeMap<String, String>();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node2 = namedNodeMap.item(i);
            treeMap.put(node2.getNodeName(), node2.getNodeValue());
        }
        return treeMap;
    }

    public static Map<String, String> getAttrMapWithCache(Node node) {
        return XMLDB.getAttrMap(node);
    }

    public static String getAllAttr(Map<String, String> map, List<String> list) {
        String string = map.get("name");
        string = string != null ? "," + string : "";
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if ((entry.getKey().equals("name") || entry.getKey().equals("type") || entry.getKey().equals("unit") || entry.getKey().equals("year")) && (list == null || !list.contains(entry.getKey()))) continue;
            string = string + "," + entry.getKey() + "=" + entry.getValue();
        }
        return !string.equals("") ? string.substring(1) : string;
    }

    public String getQueryFunctionAsDistinctNames() {
        return "declare function local:distinct-node-names ($args as node()*) as xs:string* { fn:distinct-values(for $nname in $args return fn:local-name($nname)) }; local:distinct-node-names";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValue(ANode aNode, String string) {
        try (QueryProcessor queryProcessor = new QueryProcessor("declare variable $newValue as xs:string external; replace value of node self::node() with $newValue", this.context);){
            queryProcessor.context((Value)aNode);
            queryProcessor.bind("newValue", (Object)string, "xs:string");
            queryProcessor.iter();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSingleCacheValue(ANode aNode, int n, String string) {
        try (QueryProcessor queryProcessor = new QueryProcessor("declare variable $hashId as xs:integer external; declare variable $newCacheValue as xs:string external; if(exists(self::node()/cache[@id=$hashId])) then replace value of node self::node()/cache[@id=$hashId] with $newCacheValue else insert node element cache{ attribute id { $hashId }, text { $newCacheValue } } into self::node()", this.context);){
            queryProcessor.context((Value)aNode);
            queryProcessor.bind("hashId", (Object)n, "xs:integer");
            queryProcessor.bind("newCacheValue", (Object)string, "xs:string");
            queryProcessor.iter();
        }
    }

    public void addVarMetaData() {
    }

    public static JDialog createProgressBarGUI(JProgressBar jProgressBar, String string, String string2) {
        JFrame jFrame = InterfaceMain.getInstance().getFrame();
        if (jProgressBar.getMaximum() == 0) {
            return null;
        }
        JDialog jDialog = new JDialog(jFrame, string, false);
        jDialog.setAlwaysOnTop(true);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jProgressBar.setPreferredSize(new Dimension(200, 20));
        JLabel jLabel = new JLabel(string2);
        Container container = jDialog.getContentPane();
        jPanel.add((Component)jLabel, "First");
        jPanel.add(Box.createVerticalStrut(10));
        jPanel.add(jProgressBar);
        jPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        container.add((Component)jPanel, "First");
        jDialog.pack();
        jDialog.setVisible(true);
        return jDialog;
    }
}

