/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2.tables;

import ModelInterface.InterfaceMain;
import ModelInterface.ModelGUI2.DOMmodel;
import ModelInterface.ModelGUI2.Documentation;
import ModelInterface.ModelGUI2.tables.BaseTableModel;
import ModelInterface.ModelGUI2.tables.MultiTableModel;
import ModelInterface.ModelGUI2.undo.FlipUndoableEdit;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.JFrame;
import javax.swing.table.TableCellRenderer;
import javax.swing.tree.TreePath;
import javax.swing.undo.UndoManager;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpression;
import javax.xml.xpath.XPathExpressionException;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.encoders.SunJPEGEncoderAdapter;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StackedXYAreaRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.xy.DefaultTableXYDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NewDataTableModel
extends BaseTableModel {
    private static final long serialVersionUID = 1L;
    Vector indCol;
    Vector indRow;
    String ind1Name;
    String ind2Name;
    Map data;
    boolean flipped;
    String w3;
    JFreeChart chart;
    TableCellRenderer documentationRenderer;
    int chartLabelCol = -1;

    public NewDataTableModel(TreePath treePath, Document document, String string, Documentation documentation) {
        super(treePath, document, string, documentation);
        this.indCol = new Vector();
        this.indRow = new Vector();
        this.data = new TreeMap();
        this.w3 = "";
        this.wild = this.chooseTableHeaders(treePath);
        this.wild.set(0, ((DOMmodel.DOMNodeAdapter)this.wild.get(0)).getNode().getNodeName());
        this.wild.set(1, ((DOMmodel.DOMNodeAdapter)this.wild.get(1)).getNode().getNodeName());
        this.buildTable(this.treePathtoXPath(treePath, document.getDocumentElement(), 1));
        this.ind1Name = (String)this.wild.get(0);
        this.ind2Name = (String)this.wild.get(1);
        this.indCol.add(0, this.ind1Name);
        this.flipped = false;
        this.documentationRenderer = this.getDocumentationRenderer();
    }

    @Override
    public TableCellRenderer getCellRenderer(int n, int n2) {
        if (n2 == 0) {
            return null;
        }
        return this.documentationRenderer;
    }

    @Override
    protected void buildTable(XPathExpression xPathExpression) {
        NodeList nodeList = null;
        try {
            nodeList = (NodeList)xPathExpression.evaluate(this.doc.getDocumentElement(), XPathConstants.NODESET);
        }
        catch (XPathExpressionException xPathExpressionException) {
            xPathExpressionException.printStackTrace();
        }
        xPathExpression = null;
        TreeSet<Object> treeSet = new TreeSet<Object>();
        TreeSet<Object> treeSet2 = new TreeSet<Object>();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            Object[] objectArray = this.getRegionAndYearFromNode(node.getParentNode());
            treeSet.add(objectArray[0]);
            treeSet2.add(objectArray[1]);
            this.data.put((String)objectArray[0] + ";" + (String)objectArray[1], node);
        }
        this.indCol = new Vector(treeSet);
        this.indRow = new Vector(treeSet2);
    }

    private Object[] getRegionAndYearFromNode(Node node) {
        Vector<String> vector = new Vector<String>(2, 0);
        do {
            if (!node.getNodeName().equals((String)this.wild.get(0)) && !node.getNodeName().equals((String)this.wild.get(1))) continue;
            if (!node.hasAttributes()) {
                vector.add(node.getNodeName());
                continue;
            }
            vector.add(this.getOneAttrVal(node));
        } while ((node = node.getParentNode()).getNodeType() != 9);
        return vector.toArray();
    }

    public void filterData(JFrame jFrame) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void doFilter(Vector vector) {
        throw new UnsupportedOperationException();
    }

    public NewDataTableModel(Collection collection, String string, Collection collection2, String string2, String string3, Map map, Document document, Documentation documentation, Collection<String> collection3) {
        this.documentation = documentation;
        this.title = this.w3 = string3;
        this.indCol = new Vector(collection);
        this.indCol.add(0, string);
        this.indRow = new Vector(collection2);
        if (this.indCol.contains("Units")) {
            Iterator iterator = this.indRow.iterator();
            while (iterator.hasNext()) {
                String string4 = (String)iterator.next();
                if (map.containsKey("Units;" + string4) || collection3 != null && collection3.contains(string4)) continue;
                iterator.remove();
            }
        }
        this.data = map;
        this.flipped = false;
        this.doc = document;
        this.ind1Name = string;
        this.ind2Name = string2;
        this.documentationRenderer = this.getDocumentationRenderer();
    }

    @Override
    public void flip(int n, int n2) {
        Vector vector = this.indCol;
        this.indCol = this.indRow;
        this.indRow = vector;
        this.indRow.remove(0);
        String string = this.ind1Name;
        this.ind1Name = this.ind2Name;
        this.ind2Name = string;
        this.indCol.add(0, this.ind1Name);
        this.flipped = !this.flipped;
        this.fireTableStructureChanged();
        InterfaceMain interfaceMain = InterfaceMain.getInstance();
        if (n >= 0 && n2 >= 0) {
            UndoManager undoManager = interfaceMain.getUndoManager();
            undoManager.addEdit(new FlipUndoableEdit(this));
        }
        interfaceMain.refreshUndoRedo();
    }

    @Override
    public int getColumnCount() {
        return this.indCol.size();
    }

    @Override
    public int getRowCount() {
        return this.indRow.size();
    }

    @Override
    protected Node getNodeAt(int n, int n2) {
        if (n2 == 0) {
            return null;
        }
        return (Node)this.data.get(this.getKey(n, n2));
    }

    @Override
    public Object getValueAt(int n, int n2) {
        if (n2 == 0) {
            return this.indRow.get(n);
        }
        if (this.doc == null) {
            Object v = this.data.get(this.getKey(n, n2));
            if (v == null) {
                return new Double(0.0);
            }
            return v;
        }
        Node node = (Node)this.data.get(this.getKey(n, n2));
        if (node == null) {
            return "";
        }
        return node.getNodeValue();
    }

    @Override
    public String getColumnName(int n) {
        return (String)this.indCol.get(n);
    }

    public Class getColumnClass(int n) {
        if (this.doc != null) {
            return String.class;
        }
        return 1 <= n && n < this.getColumnCount() - 1 ? Double.class : String.class;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.doc == null) {
            return false;
        }
        return n2 > 0;
    }

    private String getKey(int n, int n2) {
        if (this.flipped) {
            return (String)this.indRow.get(n) + ";" + (String)this.indCol.get(n2);
        }
        return (String)this.indCol.get(n2) + ";" + (String)this.indRow.get(n);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        Node node = (Node)this.data.get(this.getKey(n, n2));
        if (node != null) {
            node.setNodeValue(object.toString());
        } else {
            String string;
            int n3;
            node = this.doc.createTextNode(object.toString());
            Node node2 = null;
            Node node3 = null;
            for (n3 = 0; n3 < this.getRowCount() && (node2 = (Node)this.data.get(this.getKey(n3, n2))) == null; ++n3) {
            }
            for (n3 = 1; n3 < this.getColumnCount() && (node3 = (Node)this.data.get(this.getKey(n, n3))) == null; ++n3) {
            }
            if (node2 == null || node3 == null) {
                System.out.println("Couldn't gather enough info to create Node");
                InterfaceMain.getInstance().showMessageDialog("Couldn't gather enough information to \ncreate the data", "Set Value Error", 0);
                return;
            }
            ArrayList<Node> arrayList = new ArrayList<Node>();
            Node node4 = node3.getParentNode();
            String string2 = this.ind1Name;
            String string3 = this.ind2Name;
            String string4 = this.getKey(n, n2);
            String[] stringArray = string4.split(";", 2);
            if (this.flipped) {
                string = string2;
                string2 = string3;
                string3 = string;
            }
            string = null;
            String string5 = stringArray[1];
            String string6 = null;
            String string7 = stringArray[0];
            while (!node4.getNodeName().equals(string2)) {
                arrayList.add(node4);
                node4 = node4.getParentNode();
            }
            NamedNodeMap namedNodeMap = node4.getAttributes();
            string = namedNodeMap.getLength() > 0 ? namedNodeMap.item(0).getNodeName() : null;
            node4 = node4.getParentNode();
            node4 = this.checkPath(node4, string2, string, string5);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Element element = (Element)arrayList.get(i);
                if (element.getNodeName().equals(string3)) {
                    namedNodeMap = element.getAttributes();
                    string6 = namedNodeMap.getLength() > 0 ? namedNodeMap.item(0).getNodeName() : null;
                    node4 = this.checkPath(node4, string3, string6, string7);
                    continue;
                }
                Node node5 = element.getAttributes().item(0);
                node4 = node5 == null ? this.checkPath(node4, element.getNodeName(), null, null) : this.checkPath(node4, element.getNodeName(), node5.getNodeName(), node5.getNodeValue());
            }
            node4.appendChild(node);
            this.data.put(this.getKey(n, n2), node);
        }
        this.fireTableCellUpdated(n, n2);
    }

    private Node checkPath(Node node, String string, String string2, String string3) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            if (element.getNodeName().equals(string) && string3 == null) {
                return element;
            }
            if (!element.getNodeName().equals(string) || !element.getAttribute(string2).equals(string3)) continue;
            return element;
        }
        Element element = this.doc.createElement(string);
        if (string2 != null) {
            element.setAttribute(string2, string3);
        }
        node.appendChild(element);
        return element;
    }

    @Override
    public JFreeChart createChart(int n, int n2) {
        XYSeries xYSeries;
        String string;
        String string2;
        DefaultTableXYDataset defaultTableXYDataset = new DefaultTableXYDataset();
        for (int i = 0; i < this.getRowCount(); ++i) {
            string2 = this.chartLabelCol >= 0 ? (String)this.getValueAt(i, this.chartLabelCol) : (String)this.getValueAt(i, 0);
            if (string2.equals("Total")) continue;
            string = string2;
            xYSeries = new XYSeries(string, false, false);
            for (int j = 1; j < this.getColumnCount(); ++j) {
                String string3 = this.getColumnName(j);
                if (string3.equals("Units")) continue;
                boolean bl = true;
                for (int k = 0; k < this.getRowCount() && bl; ++k) {
                    bl = this.data.get(this.getKey(k, j)) == null;
                }
                if (bl) continue;
                Object object = this.getValueAt(i, j);
                double d = object == null ? 0.0 : (object instanceof Double ? (Double)object : Double.parseDouble(object.toString()));
                if (string3.indexOf(61) != -1) {
                    string3 = string3.split("=")[1];
                }
                int n3 = Integer.parseInt(string3);
                xYSeries.add((double)n3, d);
            }
            defaultTableXYDataset.addSeries(xYSeries);
        }
        NumberAxis numberAxis = new NumberAxis("Year");
        string2 = this.units != null ? " (" + this.units + ")" : "";
        string = new NumberAxis(this.ind2Name + string2);
        numberAxis.setAutoRangeIncludesZero(false);
        numberAxis.setAutoRange(true);
        string.setAutoRange(true);
        xYSeries = new XYPlot((XYDataset)defaultTableXYDataset, (ValueAxis)numberAxis, (ValueAxis)string, (XYItemRenderer)new StackedXYAreaRenderer());
        this.chart = new JFreeChart((Plot)xYSeries);
        TextTitle textTitle = new TextTitle(this.title);
        this.chart.setTitle(textTitle);
        return this.chart;
    }

    public void setColNameIndex(String string) {
        if (string != null) {
            for (int i = 0; i < this.getColumnCount(); ++i) {
                if (!string.equals(this.getColumnName(i))) continue;
                this.chartLabelCol = i;
                return;
            }
        }
        this.chartLabelCol = -1;
    }

    @Override
    public void exportToExcel(HSSFSheet hSSFSheet, HSSFWorkbook hSSFWorkbook, HSSFPatriarch hSSFPatriarch) {
        int n;
        HSSFRow hSSFRow = hSSFSheet.createRow(hSSFSheet.getLastRowNum() + 1);
        for (n = 0; n < this.getColumnCount(); ++n) {
            hSSFRow.createCell((short)n).setCellValue(this.getColumnName(n));
        }
        for (n = 0; n < this.getRowCount(); ++n) {
            hSSFRow = hSSFSheet.createRow(hSSFSheet.getLastRowNum() + 1);
            for (int i = 0; i < this.getColumnCount(); ++i) {
                Object object = this.sortedTable.getValueAt(n, i);
                if (object instanceof Double) {
                    hSSFRow.createCell((short)i).setCellValue(((Double)object).doubleValue());
                    continue;
                }
                hSSFRow.createCell((short)i).setCellValue(this.getValueAt(n, i).toString());
            }
        }
        if (hSSFPatriarch == null) {
            return;
        }
        try {
            double d = this.getRowCount() / 6 * 10;
            double d2 = 1.4;
            int n2 = (int)(350.0 * d2);
            int n3 = (int)(d2 * (350.0 + d));
            BufferedImage bufferedImage = this.createChart(0, 0).createBufferedImage(n2, n3);
            int n4 = 8;
            short s = (short)(hSSFSheet.getLastRowNum() - this.getRowCount());
            short s2 = (short)(hSSFSheet.getRow((int)s).getLastCellNum() + 2);
            short s3 = (short)(n2 / (n4 * hSSFSheet.getColumnWidth((short)(this.getColumnCount() + 1))) + s2);
            short s4 = (short)((float)n3 / (hSSFSheet.getDefaultRowHeightInPoints() * 5.0f / 3.0f) + (float)s);
            int n5 = hSSFWorkbook.addPicture(new SunJPEGEncoderAdapter().encode(bufferedImage), 5);
            hSSFPatriarch.createPicture(new HSSFClientAnchor(0, 0, 255, 255, s2, (int)s, s3, (int)s4), n5);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof BaseTableModel) || object == null) {
            return false;
        }
        if (object instanceof MultiTableModel) {
            return ((MultiTableModel)object).equals(this);
        }
        return false;
    }

    @Override
    public void annotate(int[] nArray, int[] nArray2, Documentation documentation) {
        Vector<Node> vector = new Vector<Node>(nArray.length * nArray2.length, 0);
        for (int i = 0; i < nArray.length; ++i) {
            for (int j = 0; j < nArray2.length; ++j) {
                vector.add(this.getNodeAt(nArray[i], nArray2[j]));
            }
        }
        documentation.getDocumentation(vector, nArray, nArray2);
    }
}

