/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2.queries;

import ModelInterface.ModelGUI2.QueryTreeModel;
import ModelInterface.ModelGUI2.ScenarioListItem;
import ModelInterface.ModelGUI2.queries.QueryGenerator;
import ModelInterface.ModelGUI2.undo.EditQueryUndoableEdit;
import ModelInterface.ModelGUI2.undo.MiUndoableEditListener;
import ModelInterface.ModelGUI2.xmldb.DbProcInterrupt;
import ModelInterface.ModelGUI2.xmldb.QueryBinding;
import ModelInterface.ModelGUI2.xmldb.QueryBindingFactory;
import ModelInterface.ModelGUI2.xmldb.SingleQueryListQueryBinding;
import ModelInterface.ModelGUI2.xmldb.SingleQueryQueryBinding;
import ModelInterface.ModelGUI2.xmldb.XMLDB;
import ModelInterface.common.DataPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.JTree;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.tree.TreePath;
import org.basex.query.QueryProcessor;
import org.basex.query.iter.Iter;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;

public class SingleQueryExtension
implements TreeSelectionListener,
ListSelectionListener,
MiUndoableEditListener {
    private List<SingleQueryValue> currValues;
    private DataPair<List<ScenarioListItem>, List<String>> currSelection;
    private Map<DataPair<List<ScenarioListItem>, List<String>>, List<SingleQueryValue>> singleLevelCache;
    private QueryGenerator qg;
    private volatile boolean isSelected;
    private final SingleQueryValue generatingLabel = new SingleQueryValue("Generating List..");
    private final List<SingleQueryValue> generatingList = new ArrayList<SingleQueryValue>(1);
    private final SingleQueryValue noResults = new SingleQueryValue("Could not generate list.");
    private final List<SingleQueryValue> noResultsList = new ArrayList<SingleQueryValue>(1);
    private boolean isEnabled;
    private Runnable doDisable = null;
    private Runnable doEnable = null;
    private Thread gatherThread = null;
    private DbProcInterrupt gatherContext = null;

    public SingleQueryExtension(QueryGenerator queryGenerator) {
        this.qg = queryGenerator;
        this.isSelected = false;
        this.singleLevelCache = new HashMap<DataPair<List<ScenarioListItem>, List<String>>, List<SingleQueryValue>>();
        this.generatingList.add(this.generatingLabel);
        this.noResultsList.add(this.noResults);
        this.currSelection = null;
        this.isEnabled = true;
    }

    public void setSelection(ScenarioListItem[] scenarioListItemArray, String[] stringArray) {
        if (this.currSelection == null) {
            this.currSelection = new DataPair();
        }
        if (scenarioListItemArray.length != 0) {
            this.currSelection.setKey(Arrays.asList(scenarioListItemArray));
        } else {
            this.currSelection.setKey(null);
        }
        if (stringArray.length != 0) {
            this.currSelection.setValue(Arrays.asList(stringArray));
        } else {
            this.currSelection.setValue(null);
        }
    }

    private TreePath shouldSelect(TreeSelectionEvent treeSelectionEvent) {
        TreePath[] treePathArray = ((JTree)treeSelectionEvent.getSource()).getSelectionPaths();
        if (treePathArray == null) {
            return null;
        }
        for (TreePath treePath : treePathArray) {
            Object[] objectArray = treePath.getPath();
            if (objectArray.length <= 1 || objectArray[objectArray.length - 1] != this.qg && objectArray[objectArray.length - 2] != this.qg) continue;
            return treePath;
        }
        return null;
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (!this.isEnabled) {
            return;
        }
        if (!(treeSelectionEvent.getSource() instanceof JTree)) {
            return;
        }
        final JTree jTree = (JTree)treeSelectionEvent.getSource();
        final QueryTreeModel queryTreeModel = (QueryTreeModel)jTree.getModel();
        boolean bl = this.isSelected;
        TreePath treePath = this.shouldSelect(treeSelectionEvent);
        if (treePath != null && treePath.getLastPathComponent() instanceof SingleQueryValue) {
            treePath = treePath.getParentPath();
        }
        boolean bl2 = this.isSelected = treePath != null;
        if (!bl && this.isSelected) {
            if (this.doDisable == null) {
                final TreePath treePath2 = treePath;
                this.doDisable = new Runnable(){

                    @Override
                    public void run() {
                        SingleQueryExtension.this.isSelected = false;
                        SingleQueryExtension.this.hideList(queryTreeModel, treePath2);
                        SingleQueryExtension.this.resetList();
                    }
                };
                this.doEnable = new Runnable(){

                    @Override
                    public void run() {
                        SingleQueryExtension.this.isSelected = true;
                        SingleQueryExtension.this.showList(queryTreeModel, treePath2, jTree);
                    }
                };
            }
            this.showList(queryTreeModel, treePath, jTree);
        } else if (bl && !this.isSelected) {
            for (TreePath treePath3 : treeSelectionEvent.getPaths()) {
                Object[] objectArray = treePath3.getPath();
                if (objectArray.length <= 1 || objectArray[objectArray.length - 1] != this.qg && objectArray[objectArray.length - 2] != this.qg) continue;
                treePath = treePath3;
                break;
            }
            if (treePath == null) {
                System.out.println("Trouble: wasn't able to find parent in old selection");
                this.doDisable.run();
                return;
            }
            if (treePath.getLastPathComponent() instanceof SingleQueryValue) {
                treePath = treePath.getParentPath();
            }
            this.hideList(queryTreeModel, treePath);
        }
    }

    @Override
    public void undoPerformed(UndoableEditEvent undoableEditEvent) {
        if (!(undoableEditEvent.getSource() instanceof EditQueryUndoableEdit)) {
            return;
        }
        EditQueryUndoableEdit editQueryUndoableEdit = (EditQueryUndoableEdit)undoableEditEvent.getSource();
        if (editQueryUndoableEdit.didXPathChange() || editQueryUndoableEdit.didNodeLevelChange()) {
            this.resetCache();
        }
    }

    @Override
    public void redoPerformed(UndoableEditEvent undoableEditEvent) {
        if (!(undoableEditEvent.getSource() instanceof EditQueryUndoableEdit)) {
            return;
        }
        EditQueryUndoableEdit editQueryUndoableEdit = (EditQueryUndoableEdit)undoableEditEvent.getSource();
        if (editQueryUndoableEdit.didXPathChange() || editQueryUndoableEdit.didNodeLevelChange()) {
            this.resetCache();
        }
    }

    private void showList(QueryTreeModel queryTreeModel, TreePath treePath, JTree jTree) {
        this.setGatherThread(null);
        if (this.currSelection == null || this.currSelection.getKey() == null || this.currSelection.getValue() == null) {
            this.currValues = this.noResultsList;
        } else if (this.singleLevelCache.containsKey(this.currSelection)) {
            this.currValues = this.singleLevelCache.get(this.currSelection);
        } else {
            this.currValues = this.generatingList;
            this.setGatherThread(new Thread(this.getRunnableGetListQuery(queryTreeModel, treePath, jTree)));
            this.gatherThread.start();
        }
        if (this.gatherThread == null || this.gatherThread.isAlive()) {
            queryTreeModel.showSingleQuery(this, treePath);
            jTree.makeVisible(treePath.pathByAddingChild(this.getSingleQueryValueAt(this.getNumValues() / 2)));
        }
    }

    private void hideList(QueryTreeModel queryTreeModel, TreePath treePath) {
        queryTreeModel.hideSingleQuery(this, treePath);
    }

    public void interruptGatherThread() {
        this.setGatherThread(null);
    }

    private synchronized void setGatherThread(Thread thread) {
        if (this.gatherThread != null && this.gatherThread.isAlive()) {
            this.gatherThread.interrupt();
        }
        if (this.gatherContext != null) {
            this.gatherContext.interrupt();
        }
        this.gatherThread = thread;
        this.gatherContext = new DbProcInterrupt();
    }

    private void resetCache() {
        this.singleLevelCache.clear();
        if (this.isSelected && this.isEnabled) {
            this.doDisable.run();
            this.doEnable.run();
        }
    }

    public void resetList() {
        this.currValues = null;
    }

    public int getNumValues() {
        if (this.currValues == null) {
            return 0;
        }
        return this.currValues.size();
    }

    public SingleQueryValue getSingleQueryValueAt(int n) {
        return this.currValues.get(n);
    }

    public int getIndexOfValue(SingleQueryValue singleQueryValue) {
        return this.currValues.indexOf(singleQueryValue);
    }

    public void setEnabled(boolean bl) {
        if (this.isEnabled && !bl && this.doDisable != null) {
            this.isEnabled = false;
            this.doDisable.run();
        } else if (!this.isEnabled && bl && this.doEnable != null) {
            this.isEnabled = true;
            this.doEnable.run();
        }
        this.isEnabled = bl;
    }

    private Runnable getRunnableCreateListQuery(final QueryTreeModel queryTreeModel, final TreePath treePath, final JTree jTree) {
        final SingleQueryExtension singleQueryExtension = this;
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<SingleQueryValue> arrayList;
                Object[] objectArray = ((List)SingleQueryExtension.this.currSelection.getKey()).toArray();
                Object[] objectArray2 = ((List)SingleQueryExtension.this.currSelection.getValue()).toArray();
                long l = System.currentTimeMillis();
                try (QueryProcessor queryProcessor = XMLDB.getInstance().createQuery(new SingleQueryListQueryBinding(SingleQueryExtension.this.qg, XMLDB.getInstance().getContainer(), SingleQueryExtension.this.qg.getCollapseOnList()), objectArray, objectArray2, SingleQueryExtension.this.gatherContext);){
                    Iter iter = queryProcessor.iter();
                    if (iter.size() == 0L) {
                        arrayList = SingleQueryExtension.this.noResultsList;
                    } else {
                        Object object;
                        arrayList = new ArrayList<SingleQueryValue>();
                        TreeSet<Object> treeSet = new TreeSet<Object>();
                        Item item = null;
                        while ((item = iter.next()) != null) {
                            object = (String)item.toJava();
                            SingleQueryValue singleQueryValue = new SingleQueryValue((String)object);
                            arrayList.add(singleQueryValue);
                            treeSet.add(object);
                        }
                        if (queryTreeModel != null) {
                            object = SingleQueryExtension.this.qg.getNodeLevelRewriteMap();
                            SingleQueryExtension.this.addRewriteListValues((Map)object, arrayList, treeSet);
                        }
                        if (SingleQueryExtension.this.qg.isGroup() && queryTreeModel != null) {
                            arrayList.add(new SingleQueryValue("Total"));
                        }
                    }
                }
                System.out.println("Time : " + (System.currentTimeMillis() - l));
                SingleQueryExtension.this.singleLevelCache.put(SingleQueryExtension.this.currSelection, arrayList);
                boolean bl = Thread.interrupted();
                if (SingleQueryExtension.this.isSelected && !bl) {
                    if (queryTreeModel == null) {
                        SingleQueryExtension.this.currValues = arrayList;
                    } else {
                        SingleQueryExtension.this.hideList(queryTreeModel, treePath);
                        SingleQueryExtension.this.currValues = arrayList;
                        queryTreeModel.showSingleQuery(singleQueryExtension, treePath);
                        jTree.makeVisible(treePath.pathByAddingChild(SingleQueryExtension.this.getSingleQueryValueAt(SingleQueryExtension.this.getNumValues() / 2)));
                    }
                }
            }
        };
    }

    private Runnable getRunnableGetListQuery(final QueryTreeModel queryTreeModel, final TreePath treePath, final JTree jTree) {
        final SingleQueryExtension singleQueryExtension = this;
        return new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList<SingleQueryValue> arrayList = null;
                long l = System.currentTimeMillis();
                try (QueryProcessor queryProcessor = XMLDB.getInstance().createQuery("/singleQueryListCache/cache[@id=" + SingleQueryExtension.this.qg.getStorageHashCode() + "]/text()", null, null, null);){
                    String[] stringArray;
                    boolean bl = false;
                    Iter iter = queryProcessor.iter();
                    ANode aNode = (ANode)iter.next();
                    if (!(aNode == null || (stringArray = aNode.toJava().getNodeValue().split(";")).length == 1 && stringArray[0].equals(""))) {
                        bl = true;
                        arrayList = new ArrayList<SingleQueryValue>(stringArray.length + 1);
                        Map<String, String> map = SingleQueryExtension.this.qg.getNodeLevelRewriteMap();
                        TreeSet<String> treeSet = new TreeSet<String>();
                        for (String string : stringArray) {
                            if (map == null || !map.containsKey(string)) {
                                SingleQueryValue singleQueryValue = new SingleQueryValue(string);
                                arrayList.add(singleQueryValue);
                                continue;
                            }
                            treeSet.add(string);
                        }
                        SingleQueryExtension.this.addRewriteListValues(map, arrayList, treeSet);
                        if (SingleQueryExtension.this.qg.isGroup()) {
                            arrayList.add(new SingleQueryValue("Total"));
                        }
                    }
                    if (!bl) {
                        arrayList = SingleQueryExtension.this.noResultsList;
                    }
                }
                System.out.println("Time : " + (System.currentTimeMillis() - l));
                SingleQueryExtension.this.singleLevelCache.put(SingleQueryExtension.this.currSelection, arrayList);
                if (SingleQueryExtension.this.isSelected && !Thread.currentThread().isInterrupted()) {
                    SingleQueryExtension.this.hideList(queryTreeModel, treePath);
                    SingleQueryExtension.this.currValues = arrayList;
                    queryTreeModel.showSingleQuery(singleQueryExtension, treePath);
                    jTree.makeVisible(treePath.pathByAddingChild(SingleQueryExtension.this.getSingleQueryValueAt(SingleQueryExtension.this.getNumValues() / 2)));
                }
            }
        };
    }

    public void createSingleQueryListCache(ANode aNode, ScenarioListItem[] scenarioListItemArray, String[] stringArray) {
        this.setSelection(scenarioListItemArray, stringArray);
        boolean bl = this.isSelected;
        this.isSelected = true;
        try {
            this.setGatherThread(new Thread(this.getRunnableCreateListQuery(null, null, null)));
            this.gatherThread.start();
            this.gatherThread.join();
            if (this.currValues != this.noResultsList) {
                StringBuffer stringBuffer = new StringBuffer();
                Iterator<SingleQueryValue> iterator = this.currValues.iterator();
                while (iterator.hasNext()) {
                    stringBuffer.append(iterator.next().toString()).append(";");
                }
                System.out.println("About to cache " + this.qg.getStorageHashCode() + " -> " + stringBuffer.toString());
                XMLDB.getInstance().updateSingleCacheValue(aNode, this.qg.getStorageHashCode(), stringBuffer.toString());
            }
        }
        catch (InterruptedException interruptedException) {
            Thread.currentThread().interrupt();
            this.gatherThread.interrupt();
        }
        this.singleLevelCache.clear();
        this.resetList();
        this.isSelected = bl;
    }

    public boolean isInitialized() {
        return this.doDisable != null;
    }

    private void addRewriteListValues(Map<String, String> map, List<SingleQueryValue> list, Set<String> set) {
        if (map == null) {
            return;
        }
        HashMap<String, ArrayList<String>> hashMap = new HashMap<String, ArrayList<String>>();
        boolean bl = this.qg.shouldAppendRewriteValues();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (!bl && !set.contains(entry.getKey())) continue;
            ArrayList<String> arrayList = (ArrayList<String>)hashMap.get(entry.getValue());
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
                hashMap.put(entry.getValue(), arrayList);
            }
            arrayList.add(entry.getKey());
        }
        for (Map.Entry<String, String> entry : hashMap.entrySet()) {
            if (entry.getKey().equals("")) continue;
            list.add(new SingleQueryValue(entry.getKey(), (List)((Object)entry.getValue())));
        }
    }

    public class SingleQueryValue {
        private String displayValue;
        private List<String> values;

        public SingleQueryValue(String string) {
            this.displayValue = string;
            this.values = new ArrayList<String>(1);
            this.values.add(string);
        }

        public SingleQueryValue(String string, List<String> list) {
            this.displayValue = string;
            this.values = list;
        }

        public String toString() {
            return this.displayValue;
        }

        public List<String> getValues() {
            return this.values;
        }

        public boolean canExecute() {
            return !this.displayValue.equals("Generating List..") && !this.displayValue.equals("Could not generate list.");
        }

        public QueryBinding getAsQueryBinding() {
            if (!this.displayValue.equals("Total")) {
                return new SingleQueryQueryBinding(this.values, SingleQueryExtension.this.qg, XMLDB.getInstance().getContainer());
            }
            return QueryBindingFactory.getQueryBinding(SingleQueryExtension.this.qg, XMLDB.getInstance().getContainer());
        }

        public QueryGenerator getParent() {
            return SingleQueryExtension.this.qg;
        }
    }
}

