/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2.csvconv;

import ModelInterface.ModelGUI2.csvconv.HeaderEntity;

public class Header {
    private HeaderEntity grandParent = null;
    private HeaderEntity parent = null;
    private HeaderEntity child = null;
    private boolean isGPPathOnly = false;
    private int headerPos;

    public Header(String string, int n) throws Exception {
        this.headerPos = n;
        this.parseHeaderStr(string);
        assert (this.child != null);
    }

    private void parseHeaderStr(String string) throws Exception {
        String[] stringArray = string.split("/");
        if (stringArray.length == 1) {
            this.child = new HeaderEntity(stringArray[0]);
        } else if (stringArray.length == 2) {
            this.isGPPathOnly = stringArray[0].startsWith("@");
            this.parent = new HeaderEntity(stringArray[0]);
            this.child = new HeaderEntity(stringArray[1]);
        } else if (stringArray.length == 4) {
            this.grandParent = new HeaderEntity(stringArray[0]);
            this.parent = new HeaderEntity(stringArray[2]);
            this.child = new HeaderEntity(stringArray[3]);
        } else {
            throw new Exception("Invalid header: " + string);
        }
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public boolean isCompleteGPPath() {
        return this.isGPPathOnly;
    }

    public boolean hasGrandParent() {
        return this.grandParent != null;
    }

    public boolean doesSpecifyParent() {
        return this.grandParent != null || this.parent.doesSpecifyAttrValue();
    }

    public String getChildName() {
        return this.child.getName();
    }

    public int getReadColumnPos() {
        if (this.child.willRead()) {
            return this.headerPos;
        }
        return -1;
    }

    public HeaderEntity getGrandParentEntity() {
        return this.grandParent;
    }

    public HeaderEntity getParentEntity() {
        return this.parent;
    }

    public HeaderEntity getChildEntity() {
        return this.child;
    }

    public boolean shouldBeChild(String string) {
        if (this.isRoot()) {
            return false;
        }
        return this.parent.getName().equals(string);
    }

    public String toString() {
        String string = this.isGPPathOnly ? "@" : "";
        if (this.grandParent != null) {
            string = string + this.grandParent + "/.../";
        }
        if (this.parent != null) {
            string = string + this.parent + "/";
        }
        return string + this.child;
    }
}

