/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2;

import ModelInterface.ModelGUI2.ParseFilter;
import ModelInterface.ModelGUI2.QueryTreeModel;
import ModelInterface.ModelGUI2.queries.QueryGenerator;
import ModelInterface.ModelGUI2.queries.SingleQueryExtension;
import ModelInterface.common.DataPair;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

public class QueryTransferHandler
extends TransferHandler {
    private Document doc;
    private DOMImplementationLS implls;
    private LSParser parser;
    private static DataFlavor localQueryGeneratorFlavor;
    private static DataFlavor localQueryGroupFlavor;
    private static DataFlavor localNodeFlavor;
    private static final DataFlavor serialQueryGeneratorFlavor;
    private static final DataFlavor serialQueryGroupFlavor;
    private static final DataFlavor serialNodeFlavor;
    private static final String localQueryGeneratorType = "application/x-java-jvm-local-objectref;class=ModelInterface.ModelGUI2.queries.QueryGenerator";
    private static final String localQueryGroupType = "application/x-java-jvm-local-objectref;class=ModelInterface.ModelGUI2.QueryTreeModel$QueryGroup";
    private static final String localNodeType = "application/x-java-jvm-local-objectref;class=org.w3c.dom.Node";
    private int lastAction;
    private TreePath[] dragPaths = null;

    public QueryTransferHandler(Document document, DOMImplementationLS dOMImplementationLS) {
        this.doc = document;
        this.implls = dOMImplementationLS;
        try {
            this.parser = this.implls.createLSParser((short)1, null);
            this.parser.setFilter(new ParseFilter());
        }
        catch (DOMException dOMException) {
            dOMException.printStackTrace();
        }
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        Object object;
        Node node;
        QueryTreeModel.QueryGroup queryGroup;
        QueryGenerator queryGenerator;
        block28: {
            DataFlavor[] dataFlavorArray = transferable.getTransferDataFlavors();
            if (!this.canImport(jComponent, dataFlavorArray)) {
                return false;
            }
            queryGenerator = null;
            queryGroup = null;
            node = null;
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            boolean bl7 = false;
            for (DataFlavor dataFlavor : dataFlavorArray) {
                if (localQueryGeneratorFlavor.equals(dataFlavor)) {
                    bl = true;
                    continue;
                }
                if (serialQueryGeneratorFlavor.equals(dataFlavor)) {
                    bl2 = true;
                    continue;
                }
                if (localQueryGroupFlavor.equals(dataFlavor)) {
                    bl3 = true;
                    continue;
                }
                if (serialQueryGroupFlavor.equals(dataFlavor)) {
                    bl4 = true;
                    continue;
                }
                if (localNodeFlavor.equals(dataFlavor)) {
                    bl5 = true;
                    continue;
                }
                if (serialNodeFlavor.equals(dataFlavor)) {
                    bl6 = true;
                    continue;
                }
                if (!dataFlavor.isFlavorTextType()) continue;
                bl7 = true;
            }
            try {
                if (bl && this.lastAction == 2) {
                    queryGenerator = (QueryGenerator)transferable.getTransferData(localQueryGeneratorFlavor);
                    queryGenerator.resetQueryBuilder();
                    break block28;
                }
                if (bl2) {
                    queryGenerator = (QueryGenerator)transferable.getTransferData(serialQueryGeneratorFlavor);
                    queryGenerator.resetQueryBuilder();
                    break block28;
                }
                if (bl3 && this.lastAction == 2) {
                    queryGroup = (QueryTreeModel.QueryGroup)transferable.getTransferData(localQueryGroupFlavor);
                    queryGroup.resetQueryBuilders();
                    break block28;
                }
                if (bl4) {
                    queryGroup = (QueryTreeModel.QueryGroup)transferable.getTransferData(serialQueryGroupFlavor);
                    queryGroup.resetQueryBuilders();
                    break block28;
                }
                if (bl5) {
                    node = (Node)transferable.getTransferData(localNodeFlavor);
                    break block28;
                }
                if (bl6) {
                    node = (Node)transferable.getTransferData(serialNodeFlavor);
                    break block28;
                }
                if (bl7) {
                    object = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    LSInput lSInput = this.implls.createLSInput();
                    lSInput.setStringData((String)object);
                    node = this.doc.adoptNode(this.parser.parse(lSInput).getDocumentElement());
                    break block28;
                }
                return false;
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
                unsupportedFlavorException.printStackTrace();
                return false;
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
                return false;
            }
        }
        object = (JTree)jComponent;
        TreePath treePath = ((JTree)object).getSelectionPath();
        QueryTreeModel queryTreeModel = (QueryTreeModel)((JTree)object).getModel();
        if (node != null) {
            if (node.getNodeName().equals("queryGroup")) {
                queryGroup = queryTreeModel.createQueryGroup(node);
            } else {
                queryGenerator = new QueryGenerator(node);
                if (!queryGenerator.isValid()) {
                    queryGenerator = null;
                }
            }
        }
        if (queryGenerator != null) {
            queryTreeModel.add(treePath, queryGenerator);
            return true;
        }
        if (queryGroup != null) {
            if (!queryGroup.getName().equals("MultipleQuerySelection")) {
                queryTreeModel.add(treePath, queryGroup);
            } else {
                ArrayList arrayList = queryGroup.getQueryList();
                for (int i = 0; i < arrayList.size(); ++i) {
                    DataFlavor dataFlavor;
                    dataFlavor = arrayList.get(i);
                    if (dataFlavor instanceof QueryGenerator) {
                        queryTreeModel.add(treePath, (QueryGenerator)((Object)dataFlavor));
                        continue;
                    }
                    if (!(dataFlavor instanceof QueryTreeModel.QueryGroup)) continue;
                    queryTreeModel.add(treePath, (QueryTreeModel.QueryGroup)((Object)dataFlavor));
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        for (DataFlavor dataFlavor : dataFlavorArray) {
            if (!localQueryGeneratorFlavor.equals(dataFlavor) && !serialQueryGeneratorFlavor.equals(dataFlavor) && !localQueryGroupFlavor.equals(dataFlavor) && !serialQueryGroupFlavor.equals(dataFlavor) && !localNodeFlavor.equals(dataFlavor) && !serialNodeFlavor.equals(dataFlavor) && !dataFlavor.isFlavorTextType()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected Transferable createTransferable(JComponent jComponent) {
        return new TransferableQuery((JTree)jComponent);
    }

    @Override
    public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
        this.dragPaths = ((JTree)jComponent).getSelectionPaths();
        super.exportAsDrag(jComponent, inputEvent, n);
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        this.lastAction = n;
        if (n == 2) {
            TreePath[] treePathArray;
            QueryTreeModel queryTreeModel = (QueryTreeModel)((JTree)jComponent).getModel();
            if (this.dragPaths != null) {
                treePathArray = this.dragPaths;
                this.dragPaths = null;
            } else {
                treePathArray = ((JTree)jComponent).getSelectionPaths();
            }
            for (TreePath treePath : treePathArray) {
                if (treePath.getLastPathComponent() instanceof SingleQueryExtension.SingleQueryValue) continue;
                queryTreeModel.remove(treePath);
            }
        } else if (n == 0) {
            this.dragPaths = null;
        }
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 3;
    }

    static {
        serialQueryGeneratorFlavor = new DataFlavor(QueryGenerator.class, "QueryGenerator");
        serialQueryGroupFlavor = new DataFlavor(QueryTreeModel.QueryGroup.class, "QueryGroup");
        serialNodeFlavor = new DataFlavor(QueryTreeModel.QueryGroup.class, "QueryGroup");
        try {
            localQueryGeneratorFlavor = new DataFlavor(localQueryGeneratorType);
            localQueryGroupFlavor = new DataFlavor(localQueryGroupType);
            localNodeFlavor = new DataFlavor(localNodeType);
        }
        catch (ClassNotFoundException classNotFoundException) {
            classNotFoundException.printStackTrace();
        }
    }

    private class TransferableQuery
    implements Transferable {
        private JTree qt;
        private DataFlavor[] transFlavors;
        private Object data;

        public TransferableQuery(JTree jTree) {
            this.qt = jTree;
            TreePath[] treePathArray = jTree.getSelectionPaths();
            if (treePathArray.length == 1) {
                if (treePathArray[0].getLastPathComponent() instanceof SingleQueryExtension.SingleQueryValue) {
                    List<String> list = ((SingleQueryExtension.SingleQueryValue)treePathArray[0].getLastPathComponent()).getValues();
                    DataPair<QueryGenerator, List<String>> dataPair = new DataPair<QueryGenerator, List<String>>(this.getSingleQueryParent(treePathArray[0]), list);
                    this.data = this.convertSingleToQueryGenerator(dataPair);
                } else {
                    this.data = treePathArray[0].getLastPathComponent();
                }
            } else {
                ArrayList<Object> arrayList = new ArrayList<Object>(treePathArray.length);
                HashMap<QueryGenerator, ArrayList<String>> hashMap = new HashMap<QueryGenerator, ArrayList<String>>();
                for (TreePath treePath : treePathArray) {
                    if (treePath.getLastPathComponent() instanceof SingleQueryExtension.SingleQueryValue) {
                        QueryGenerator queryGenerator = this.getSingleQueryParent(treePath);
                        ArrayList<String> arrayList2 = (ArrayList<String>)hashMap.get(queryGenerator);
                        if (arrayList2 == null) {
                            arrayList2 = new ArrayList<String>();
                        }
                        arrayList2.addAll(((SingleQueryExtension.SingleQueryValue)treePath.getLastPathComponent()).getValues());
                        hashMap.put(queryGenerator, arrayList2);
                        continue;
                    }
                    arrayList.add(treePath.getLastPathComponent());
                }
                Iterator iterator = hashMap.entrySet().iterator();
                while (iterator.hasNext()) {
                    arrayList.add(this.convertSingleToQueryGenerator((Map.Entry)iterator.next()));
                }
                this.data = ((QueryTreeModel)jTree.getModel()).createQueryGroup("MultipleQuerySelection", arrayList);
            }
            this.transFlavors = new DataFlavor[4];
            if (this.data instanceof QueryGenerator) {
                this.transFlavors[0] = localQueryGeneratorFlavor;
                this.transFlavors[1] = serialQueryGeneratorFlavor;
            } else {
                this.transFlavors[0] = localQueryGroupFlavor;
                this.transFlavors[1] = serialQueryGroupFlavor;
            }
            this.transFlavors[2] = DataFlavor.stringFlavor;
            this.transFlavors[3] = localNodeFlavor;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.transFlavors;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            for (DataFlavor dataFlavor2 : this.transFlavors) {
                if (!dataFlavor2.equals(dataFlavor)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            Node node;
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            if (this.transFlavors[0].equals(dataFlavor) || this.transFlavors[1].equals(dataFlavor)) {
                return this.data;
            }
            if (this.data instanceof QueryGenerator) {
                node = ((QueryGenerator)this.data).getAsNode(QueryTransferHandler.this.doc);
            } else {
                node = QueryTransferHandler.this.doc.createElement("queryGroup");
                node.setAttribute("name", ((QueryTreeModel.QueryGroup)this.data).getName());
                ((QueryTreeModel)this.qt.getModel()).addQueryGroup(QueryTransferHandler.this.doc, node, (QueryTreeModel.QueryGroup)this.data);
                if (node.getFirstChild() == null) {
                    node.appendChild(QueryTransferHandler.this.doc.createTextNode(""));
                }
            }
            if (dataFlavor.isFlavorTextType()) {
                LSSerializer lSSerializer = QueryTransferHandler.this.implls.createLSSerializer();
                DOMConfiguration dOMConfiguration = lSSerializer.getDomConfig();
                boolean bl = Boolean.parseBoolean(System.getProperty("ModelInterface.pretty-print", "true"));
                dOMConfiguration.setParameter("format-pretty-print", bl);
                dOMConfiguration.setParameter("xml-declaration", false);
                return lSSerializer.writeToString(node);
            }
            return node;
        }

        private QueryGenerator getSingleQueryParent(TreePath treePath) {
            if (!(treePath.getLastPathComponent() instanceof SingleQueryExtension.SingleQueryValue)) {
                return null;
            }
            return (QueryGenerator)treePath.getParentPath().getLastPathComponent();
        }

        private QueryGenerator convertSingleToQueryGenerator(Map.Entry<QueryGenerator, List<String>> entry) {
            QueryGenerator queryGenerator = new QueryGenerator(entry.getKey().getAsNode(QueryTransferHandler.this.doc));
            List<String> list = entry.getValue();
            String string = list.size() == 1 ? list.get(0) : "single values (" + list.size() + ")";
            queryGenerator.setTitle(queryGenerator.toString() + ": " + string);
            queryGenerator.setXPath(queryGenerator.getXPath() + queryGenerator.getForNodeLevelPath(list));
            queryGenerator.setGroup(false);
            queryGenerator.setBuildList(false);
            return queryGenerator;
        }
    }
}

