/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ModelGUI2;

import ModelInterface.BatchRunner;
import ModelInterface.InterfaceMain;
import ModelInterface.MenuAdder;
import ModelInterface.ModelGUI2.CSVFilter;
import ModelInterface.ModelGUI2.DOMTransferHandler;
import ModelInterface.ModelGUI2.DOMTreeCellEditor;
import ModelInterface.ModelGUI2.DOMmodel;
import ModelInterface.ModelGUI2.Documentation;
import ModelInterface.ModelGUI2.ParseFilter;
import ModelInterface.ModelGUI2.XMLFilter;
import ModelInterface.ModelGUI2.csvconv.CSVToXMLMain;
import ModelInterface.ModelGUI2.tables.BaseTableModel;
import ModelInterface.ModelGUI2.tables.TableSelector;
import ModelInterface.ModelGUI2.tables.TableSorter;
import ModelInterface.common.FileChooser;
import ModelInterface.common.FileChooserFactory;
import ModelInterface.common.RecentFilesList;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import javax.swing.tree.TreePath;
import org.jfree.chart.JFreeChart;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSParser;
import org.w3c.dom.ls.LSSerializer;

public class InputViewer
implements ActionListener,
TableModelListener,
MenuAdder,
BatchRunner {
    private InputViewer thisViewer;
    private Document doc;
    private LSInput lsInput;
    private LSParser lsParser;
    private DOMImplementationLS implls;
    private int lastFlipX = 0;
    private int lastFlipY = 0;
    public static String controlStr = "InputViewer";
    JSplitPane splitPane;
    JLabel infoLabel;
    JTree jtree;
    private JPopupMenu treeMenu;
    private TreePath selectedPath;
    private JDialog addChildDialog;
    private JPopupMenu tableMenu;
    private JFrame chartWindow = null;
    private JPanel chartPanel = null;
    XMLFilter xmlFilter = new XMLFilter();
    CSVFilter csvFilter = new CSVFilter();
    private TableSelector tableSelector;
    private File file;
    private int leftWidth;
    private Documentation documentation;

    public InputViewer() {
        Object object;
        final InterfaceMain interfaceMain = InterfaceMain.getInstance();
        final JFrame jFrame = interfaceMain.getFrame();
        try {
            object = DOMImplementationRegistry.newInstance();
            this.implls = (DOMImplementationLS)((Object)((DOMImplementationRegistry)object).getDOMImplementation("XML 3.0"));
            if (this.implls == null) {
                System.out.println("Could not find a DOM3 Load-Save compliant parser.");
                InterfaceMain.getInstance().showMessageDialog("Could not find a DOM3 Load-Save compliant parser.", "Initialization Error", 0);
                return;
            }
            this.lsInput = this.implls.createLSInput();
            this.lsParser = this.implls.createLSParser((short)1, null);
            this.lsParser.setFilter(new ParseFilter());
        }
        catch (Exception exception) {
            System.err.println("Couldn't initialize DOMImplementation: " + exception);
            InterfaceMain.getInstance().showMessageDialog("Couldn't initialize DOMImplementation\n" + exception, "Initialization Error", 0);
            exception.printStackTrace();
        }
        this.thisViewer = this;
        if (jFrame == null) {
            return;
        }
        this.chartWindow = new JFrame("Charts");
        this.chartPanel = new JPanel();
        this.chartPanel.setLayout(new BoxLayout(this.chartPanel, 1));
        this.chartPanel.setAutoscrolls(true);
        this.chartPanel.addMouseMotionListener(new MouseMotionListener(){

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                System.out.println("Dragging");
                Rectangle rectangle = new Rectangle(mouseEvent.getX(), mouseEvent.getY(), 1, 1);
                InputViewer.this.chartPanel.scrollRectToVisible(rectangle);
            }

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
            }
        });
        this.chartWindow.setContentPane(new JScrollPane(this.chartPanel));
        ((JScrollPane)this.chartWindow.getContentPane()).setPreferredSize(new Dimension(520, 530));
        this.chartWindow.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                InputViewer.this.chartPanel.removeAll();
            }
        });
        object = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("Document-Modified")) {
                    interfaceMain.getSaveMenu().setEnabled(true);
                } else if (propertyChangeEvent.getPropertyName().equals("Document-Save")) {
                    interfaceMain.getSaveMenu().setEnabled(false);
                }
            }
        };
        jFrame.addPropertyChangeListener(new PropertyChangeListener((PropertyChangeListener)object){
            final /* synthetic */ PropertyChangeListener val$savePropListener;
            {
                this.val$savePropListener = propertyChangeListener;
            }

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("Control")) {
                    if (propertyChangeEvent.getOldValue().equals(controlStr) || propertyChangeEvent.getOldValue().equals(controlStr + "Same")) {
                        interfaceMain.getSaveMenu().removeActionListener(InputViewer.this.thisViewer);
                        interfaceMain.getSaveAsMenu().removeActionListener(InputViewer.this.thisViewer);
                        interfaceMain.getSaveAsMenu().setEnabled(false);
                        jFrame.removePropertyChangeListener(this.val$savePropListener);
                        interfaceMain.getSaveMenu().setEnabled(false);
                        InputViewer.this.doc = null;
                        InputViewer.this.documentation = null;
                        interfaceMain.getUndoManager().discardAllEdits();
                        interfaceMain.refreshUndoRedo();
                        jFrame.getContentPane().removeAll();
                        jFrame.setTitle("ModelInterface");
                        if (InputViewer.this.splitPane != null) {
                            interfaceMain.getProperties().setProperty("dividerLocation", String.valueOf(InputViewer.this.splitPane.getDividerLocation()));
                        }
                    }
                    if (propertyChangeEvent.getNewValue().equals(controlStr)) {
                        interfaceMain.getSaveMenu().addActionListener(InputViewer.this.thisViewer);
                        interfaceMain.getSaveAsMenu().addActionListener(InputViewer.this.thisViewer);
                        interfaceMain.getSaveAsMenu().setEnabled(true);
                        jFrame.addPropertyChangeListener(this.val$savePropListener);
                        InputViewer.this.leftWidth = Integer.parseInt(interfaceMain.getProperties().getProperty("dividerLocation", "200"));
                    }
                }
            }
        });
        this.tableSelector = new TableSelector();
    }

    @Override
    public void addMenuItems(InterfaceMain.MenuManager menuManager) {
        JFrame jFrame = InterfaceMain.getInstance().getFrame();
        JMenuItem jMenuItem = new JMenuItem("XML file");
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(50, 8));
        jMenuItem.addActionListener(this);
        menuManager.getSubMenuManager(0).getSubMenuManager(5).addMenuItem(jMenuItem, 10);
        jMenuItem = new JMenuItem("CSV file");
        jMenuItem.addActionListener(this);
        menuManager.getSubMenuManager(0).getSubMenuManager(5).addMenuItem(jMenuItem, 20);
        int n = menuManager.addMenuItem(new JMenu("Table"), 10);
        final JMenuItem jMenuItem2 = this.makeMenuItem("Filter");
        jMenuItem2.setEnabled(false);
        menuManager.getSubMenuManager(n).addMenuItem(jMenuItem2, 0);
        jFrame.addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (propertyChangeEvent.getPropertyName().equals("Control")) {
                    jMenuItem2.setEnabled(false);
                } else if (propertyChangeEvent.getPropertyName().equals("Table")) {
                    jMenuItem2.setEnabled(true);
                }
            }
        });
    }

    public void displayJtree() {
        JFrame jFrame = InterfaceMain.getInstance().getFrame();
        Container container = jFrame.getContentPane();
        container.removeAll();
        this.jtree = new JTree(new DOMmodel(this.doc));
        this.jtree.setEditable(true);
        this.jtree.getSelectionModel().setSelectionMode(1);
        this.jtree.setShowsRootHandles(true);
        this.jtree.getModel().addTreeModelListener(new MyTreeModelListener());
        this.jtree.setCellEditor(new DOMTreeCellEditor());
        this.jtree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                this.maybeShowPopup(mouseEvent);
            }

            private void maybeShowPopup(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    InputViewer.this.selectedPath = InputViewer.this.jtree.getClosestPathForLocation(mouseEvent.getX(), mouseEvent.getY());
                    InputViewer.this.jtree.setSelectionPath(InputViewer.this.selectedPath);
                    MenuElement[] menuElementArray = InputViewer.this.treeMenu.getSubElements();
                    for (int i = 0; i < menuElementArray.length; ++i) {
                        Node node;
                        if (((JMenuItem)menuElementArray[i]).getText().equals("Display Table")) {
                            node = ((DOMmodel.DOMNodeAdapter)InputViewer.this.jtree.getLastSelectedPathComponent()).getNode();
                            if (node.getFirstChild() != null && node.getFirstChild().getNodeType() == 3) {
                                ((JMenuItem)menuElementArray[i]).setEnabled(true);
                            } else {
                                ((JMenuItem)menuElementArray[i]).setEnabled(false);
                            }
                        }
                        if (((JMenuItem)menuElementArray[i]).getText().equals("Add Child")) {
                            node = ((DOMmodel.DOMNodeAdapter)InputViewer.this.jtree.getLastSelectedPathComponent()).getNode();
                            if (node.getNodeType() == 3) {
                                ((JMenuItem)menuElementArray[i]).setEnabled(false);
                            } else {
                                ((JMenuItem)menuElementArray[i]).setEnabled(true);
                            }
                        }
                        if (!((JMenuItem)menuElementArray[i]).getText().equals("Annotate")) continue;
                        node = ((DOMmodel.DOMNodeAdapter)InputViewer.this.jtree.getLastSelectedPathComponent()).getNode();
                        if (node.getNodeType() == 3 && InputViewer.this.documentation != null) {
                            ((JMenuItem)menuElementArray[i]).setEnabled(true);
                            continue;
                        }
                        ((JMenuItem)menuElementArray[i]).setEnabled(false);
                    }
                    InputViewer.this.treeMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.jtree);
        jScrollPane.setPreferredSize(new Dimension(this.leftWidth, jFrame.getHeight()));
        JScrollPane jScrollPane2 = new JScrollPane();
        jScrollPane2.setPreferredSize(new Dimension(jFrame.getWidth() - this.leftWidth, jFrame.getHeight()));
        this.splitPane = new JSplitPane(1, jScrollPane, jScrollPane2);
        this.splitPane.setContinuousLayout(true);
        this.splitPane.setDividerLocation(this.leftWidth);
        this.splitPane.setPreferredSize(new Dimension(jFrame.getWidth() + 10, jFrame.getHeight() + 10));
        container.add("Center", this.splitPane);
        this.treeMenu = this.makePopupTreeMenu();
        this.makeAddChildDialog();
        jFrame.setVisible(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        InterfaceMain interfaceMain = InterfaceMain.getInstance();
        JFrame jFrame = interfaceMain.getFrame();
        boolean bl = false;
        String string = actionEvent.getActionCommand();
        if (string.equals("XML file")) {
            bl = this.openXMLFile(actionEvent);
            if (this.doc == null) {
                return;
            }
            if (bl) {
                this.displayJtree();
                this.jtree.setTransferHandler(new DOMTransferHandler(this.doc, this.implls));
                this.jtree.setDragEnabled(true);
                jFrame.setTitle("[" + this.file + "] - ModelInterface");
            }
        } else if (string.equals("CSV file")) {
            bl = this.openCSVFile(actionEvent);
            if (bl) {
                this.displayJtree();
                jFrame.setTitle("[" + this.file + "] - ModelInterface");
            }
        } else if (string.equals("Save")) {
            bl = !this.file.getAbsolutePath().endsWith(".xml") ? this.saveFile() : this.saveFile(this.file);
            if (!bl) {
                interfaceMain.showMessageDialog("IO error in saving file!!", "File Save Error", 0);
                return;
            }
            jFrame.setTitle("[" + this.file + "] - ModelInterface");
            interfaceMain.fireProperty("Document-Save", null, this.doc);
        } else if (string.equals("Save As")) {
            bl = this.saveFile();
            if (!bl) {
                interfaceMain.showMessageDialog("IO error in saving file!!", "File Save Error", 0);
                return;
            }
            jFrame.setTitle("[" + this.file + "] - ModelInterface");
            interfaceMain.fireProperty("Document-Save", null, this.doc);
        } else if (string.equals("Filter")) {
            interfaceMain.fireProperty("Filter", null, 1);
        } else if (string.equals("Add Child")) {
            this.jtree.setSelectionPath(this.selectedPath);
            Node node = ((DOMmodel.DOMNodeAdapter)this.jtree.getLastSelectedPathComponent()).getNode();
            if (node.getNodeType() != 3) {
                this.showAddChildDialog();
            }
        } else if (string.equals("Delete Node")) {
            this.jtree.setSelectionPath(this.selectedPath);
            this.deleteNode();
        } else if (string.equals("Display Table")) {
            this.displayTable();
        } else if (string.equals("Annotate")) {
            this.jtree.setSelectionPath(this.selectedPath);
            Node node = ((DOMmodel.DOMNodeAdapter)this.jtree.getLastSelectedPathComponent()).getNode();
            if (this.documentation != null) {
                Vector<Node> vector = new Vector<Node>(1, 0);
                vector.add(node);
                this.documentation.getDocumentation(vector);
            }
        }
    }

    String meregeXPaths(String string, String string2) {
        String[] stringArray = string.split("/");
        String[] stringArray2 = string2.split("/");
        StringBuffer stringBuffer = new StringBuffer();
        if (stringArray.length != stringArray2.length) {
            System.out.println("Can't merge " + string + " and " + string2);
            return null;
        }
        for (int i = 1; i < stringArray.length; ++i) {
            if (stringArray[i].equals(stringArray2[i])) {
                stringBuffer.append("/").append(stringArray[i]);
                continue;
            }
            if (stringArray[i].indexOf(91) == -1 && stringArray2[i].indexOf(91) == -1) {
                return null;
            }
            if (stringArray[i].indexOf(91) != -1 && stringArray2[i].indexOf(91) != -1 && !stringArray[i].substring(0, stringArray[i].indexOf(91)).equals(stringArray2[i].substring(0, stringArray2[i].indexOf(91)))) {
                return null;
            }
            if (stringArray[i].indexOf(91) == -1 && stringArray2[i].indexOf(91) != -1) {
                stringBuffer.append("/").append(stringArray2[i]);
                continue;
            }
            String[] stringArray3 = stringArray[i].substring(stringArray[i].indexOf(91) + 1, stringArray[i].indexOf(93)).split(" or ");
            String string3 = stringArray2[i].substring(stringArray2[i].indexOf(91) + 1, stringArray2[i].indexOf(93));
            boolean bl = false;
            for (int j = 0; j < stringArray3.length && !bl; ++j) {
                if (!stringArray3[j].equals(string3)) continue;
                stringBuffer.append("/").append(stringArray[i]);
                bl = true;
            }
            if (bl) continue;
            stringBuffer.append("/").append(stringArray[i].substring(0, stringArray[i].length() - 1)).append(" or ").append(string3).append("]");
        }
        return stringBuffer.toString();
    }

    private JMenuItem makeMenuItem(String string) {
        JMenuItem jMenuItem = new JMenuItem(string);
        jMenuItem.addActionListener(this);
        return jMenuItem;
    }

    private JPopupMenu makePopupTreeMenu() {
        this.treeMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Display Table");
        jMenuItem.addActionListener(this);
        this.treeMenu.add(jMenuItem);
        this.treeMenu.add(new JSeparator());
        jMenuItem = new JMenuItem("Add Child");
        jMenuItem.addActionListener(this);
        this.treeMenu.add(jMenuItem);
        this.treeMenu.add(new JSeparator());
        jMenuItem = new JMenuItem("Delete Node");
        jMenuItem.addActionListener(this);
        this.treeMenu.add(jMenuItem);
        jMenuItem = new JMenuItem("Annotate");
        jMenuItem.addActionListener(this);
        this.treeMenu.add(jMenuItem);
        return this.treeMenu;
    }

    private JPopupMenu makePopupTableMenu() {
        this.tableMenu = new JPopupMenu();
        JMenuItem jMenuItem = new JMenuItem("Flip");
        jMenuItem.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                mouseEvent.translatePoint(InputViewer.this.lastFlipX, InputViewer.this.lastFlipY);
                Point point = mouseEvent.getPoint();
                JTable jTable = (JTable)((JScrollPane)InputViewer.this.splitPane.getRightComponent()).getViewport().getView();
                int n = jTable.rowAtPoint(point);
                int n2 = jTable.columnAtPoint(point);
                if (jTable.getModel() instanceof TableSorter) {
                    ((BaseTableModel)((TableSorter)jTable.getModel()).getTableModel()).flip(n, n2);
                } else {
                    ((BaseTableModel)jTable.getModel()).flip(n, n2);
                }
            }
        });
        this.tableMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Annotate");
        jMenuItem2.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                JTable jTable = (JTable)((JScrollPane)InputViewer.this.splitPane.getRightComponent()).getViewport().getView();
                int[] nArray = jTable.getSelectedRows();
                int[] nArray2 = jTable.getSelectedColumns();
                if (jTable.getModel() instanceof TableSorter) {
                    ((BaseTableModel)((TableSorter)jTable.getModel()).getTableModel()).annotate(nArray, nArray2, InputViewer.this.documentation);
                } else {
                    ((BaseTableModel)jTable.getModel()).annotate(nArray, nArray2, InputViewer.this.documentation);
                }
            }
        });
        this.tableMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Chart");
        jMenuItem3.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                final MouseEvent mouseEvent2 = mouseEvent;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        JTable jTable = (JTable)((JScrollPane)InputViewer.this.splitPane.getRightComponent()).getViewport().getView();
                        mouseEvent2.translatePoint(InputViewer.this.lastFlipX, InputViewer.this.lastFlipY);
                        Point point = mouseEvent2.getPoint();
                        int n = jTable.rowAtPoint(point);
                        int n2 = jTable.columnAtPoint(point);
                        try {
                            JFreeChart jFreeChart = jTable.getModel() instanceof TableSorter ? ((BaseTableModel)((TableSorter)jTable.getModel()).getTableModel()).createChart(n, n2) : ((BaseTableModel)jTable.getModel()).createChart(n, n2);
                            BufferedImage bufferedImage = jFreeChart.createBufferedImage(500, 500);
                            JLabel jLabel = new JLabel();
                            jLabel.setIcon(new ImageIcon(bufferedImage));
                            InputViewer.this.chartPanel.add(jLabel);
                            InputViewer.this.chartPanel.add(Box.createVerticalStrut(10));
                            InputViewer.this.chartWindow.pack();
                            InputViewer.this.chartWindow.setVisible(true);
                        }
                        catch (NumberFormatException numberFormatException) {
                            InterfaceMain.getInstance().showMessageDialog("Could not create a chart: No year values to chart.", "Could Not Create", 0);
                        }
                    }
                });
            }
        });
        this.tableMenu.add(jMenuItem3);
        return this.tableMenu;
    }

    private void deleteNode() {
        String string = "Are you sure you want to delete this node";
        string = this.jtree.getModel().isLeaf(this.selectedPath.getLastPathComponent()) ? string + "?" : string + " and all of its children?";
        int n = InterfaceMain.getInstance().showConfirmDialog(string, "Delete Node", 0, 3, 0);
        if (n == 1) {
            return;
        }
        ((DOMmodel)this.jtree.getModel()).removeNodeFrom(this.selectedPath);
    }

    private void showAddChildDialog() {
        this.infoLabel.setText("Adding child to " + this.selectedPath.getLastPathComponent());
        this.addChildDialog.pack();
        this.addChildDialog.setLocationRelativeTo(this.addChildDialog.getParent());
        this.addChildDialog.setVisible(true);
    }

    public void makeAddChildDialog() {
        JFrame jFrame = InterfaceMain.getInstance().getFrame();
        this.addChildDialog = new JDialog(jFrame, "Add Child Node", true);
        Container container = this.addChildDialog.getContentPane();
        container.setLayout(new BoxLayout(this.addChildDialog.getContentPane(), 1));
        this.infoLabel = new JLabel(".");
        final JTextField jTextField = new JTextField();
        final JTextField jTextField2 = new JTextField();
        final JTextField jTextField3 = new JTextField();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 5, 5, 5));
        jPanel.add(this.infoLabel);
        jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel jLabel = new JLabel("Node Name (required): ");
        jPanel.add(jLabel);
        jPanel.add(Box.createRigidArea(new Dimension(0, 2)));
        jPanel.add(jTextField);
        jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel jLabel2 = new JLabel("Node Attribute(s) (optional list in the form name=node name, year=1975)");
        jPanel.add(jLabel2);
        jPanel.add(Box.createRigidArea(new Dimension(0, 2)));
        jPanel.add(jTextField2);
        jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        JLabel jLabel3 = new JLabel("Node Value ");
        jPanel.add(jLabel3);
        jPanel.add(Box.createRigidArea(new Dimension(0, 2)));
        jPanel.add(jTextField3);
        jPanel.add(Box.createRigidArea(new Dimension(0, 10)));
        container.add(jPanel);
        container.add(new JSeparator(0));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        JButton jButton = new JButton("Add Node");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (InputViewer.this.addChildNode(jTextField, jTextField2, jTextField3)) {
                    InputViewer.this.addChildDialog.setVisible(false);
                }
            }
        });
        JButton jButton2 = new JButton("Cancel");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                InputViewer.this.addChildDialog.setVisible(false);
            }
        });
        jPanel2.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel2.add(Box.createHorizontalGlue());
        jPanel2.add(jButton);
        jPanel2.add(Box.createRigidArea(new Dimension(5, 5)));
        jPanel2.add(jButton2);
        container.add(jPanel2);
    }

    private boolean addChildNode(JTextField jTextField, JTextField jTextField2, JTextField jTextField3) {
        String string = jTextField.getText();
        String string2 = jTextField2.getText();
        String string3 = jTextField3.getText();
        Element element = null;
        if (string.equals("")) {
            InterfaceMain.getInstance().showMessageDialog("You must supply a name", "Invalid Name", 0);
            return false;
        }
        try {
            element = this.doc.createElement(string);
        }
        catch (DOMException dOMException) {
            if (dOMException.code == 5) {
                InterfaceMain.getInstance().showMessageDialog("Invalid XML name, please Change your Node Name", "Invalid Name", 0);
            } else {
                InterfaceMain.getInstance().showMessageDialog(dOMException, "Invalid Name", 0);
            }
            return false;
        }
        if (!string2.equals("")) {
            boolean bl = false;
            Pattern pattern = Pattern.compile("\\s*([\\w\\-]+)=([^,]+)\\s*(,|\\z)");
            Matcher matcher = pattern.matcher(string2);
            while (matcher.find()) {
                try {
                    element.setAttribute(matcher.group(1), matcher.group(2));
                    bl = true;
                }
                catch (DOMException dOMException) {
                    if (dOMException.code == 5) {
                        InterfaceMain.getInstance().showMessageDialog("Invalid XML attribute name, please check your attribute names", "Invalid Attribute", 0);
                    } else {
                        InterfaceMain.getInstance().showMessageDialog(dOMException, "Invalid Name", 0);
                    }
                    return false;
                }
            }
            if (!bl) {
                InterfaceMain.getInstance().showMessageDialog("Please check the syntax of you Attributes", "Invalid Attributes", 0);
                return false;
            }
        }
        if (!string3.equals("")) {
            element.appendChild(this.doc.createTextNode(string3));
        }
        DOMmodel dOMmodel = (DOMmodel)this.jtree.getModel();
        dOMmodel.insertNodeInto(element, this.selectedPath);
        jTextField.setText("");
        jTextField2.setText("");
        jTextField3.setText("");
        return true;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        if (this.jtree != null && tableModelEvent.getType() == 0) {
            ((DOMmodel)this.jtree.getModel()).fireTreeNodesChanged(new TreeModelEvent(tableModelEvent.getSource(), this.selectedPath));
        }
    }

    boolean openXMLFile(ActionEvent actionEvent) {
        Object object;
        Object object2;
        File[] fileArray;
        InterfaceMain interfaceMain = InterfaceMain.getInstance();
        JFrame jFrame = interfaceMain.getFrame();
        if (actionEvent.getSource() instanceof RecentFilesList.RecentFile) {
            fileArray = ((RecentFilesList.RecentFile)actionEvent.getSource()).getFiles();
        } else {
            object2 = FileChooserFactory.getFileChooser();
            fileArray = object2.doFilePrompt(jFrame, "Open XML File", 0, new File(interfaceMain.getProperties().getProperty("lastDirectory", ".")), this.xmlFilter, this, "XML file");
        }
        if (fileArray == null) {
            return false;
        }
        interfaceMain.fireControlChange(controlStr);
        this.file = fileArray[0];
        interfaceMain.getProperties().setProperty("lastDirectory", this.file.getParent());
        this.doc = this.readXMLFile(this.file);
        object2 = this.doc.getDocumentURI();
        if (object2 == null) {
            object = this.file.toURI();
            this.doc.setDocumentURI(((URI)object).toString());
        }
        if (((String)(object = this.doc.getDocumentElement().getAttribute("documentation"))).equals("")) {
            this.documentation = new Documentation(this.doc, this.lsParser, this.lsInput);
        } else {
            try {
                URI uRI = new URI((String)object);
                System.out.println("DOCURI1: " + uRI.toString());
                String string = this.doc.getDocumentURI();
                if (string == null) {
                    Logger.global.log(Level.SEVERE, "Main document does not have a URI. Cannot relativize the documentation URI.");
                } else {
                    try {
                        URI uRI2 = new URI(string);
                        uRI = uRI2.resolve(uRI);
                        System.out.println("DOCUMENT URI = " + uRI.toString());
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        Logger.global.log(Level.SEVERE, "URI parsing failed of the main document URI failed. Cannot relativize the documentation URI.");
                    }
                }
                this.documentation = new Documentation(this.doc, uRI, this.lsParser, this.lsInput);
            }
            catch (URISyntaxException uRISyntaxException) {
                this.documentation = null;
                Logger.global.log(Level.SEVERE, "URI parsing failed. Cannot open the documentation XML file.");
            }
        }
        return true;
    }

    boolean openCSVFile(ActionEvent actionEvent) {
        File[] fileArray;
        File[] fileArray2;
        InterfaceMain interfaceMain = InterfaceMain.getInstance();
        JFrame jFrame = interfaceMain.getFrame();
        if (actionEvent.getSource() instanceof RecentFilesList.RecentFile) {
            File[] fileArray3 = ((RecentFilesList.RecentFile)actionEvent.getSource()).getFiles();
            fileArray2 = new File[fileArray3.length - 1];
            fileArray = new File[1];
            System.arraycopy(fileArray3, 0, fileArray2, 0, fileArray2.length);
            fileArray[0] = fileArray3[fileArray3.length - 1];
        } else {
            FileChooser fileChooser = FileChooserFactory.getFileChooser();
            fileArray2 = fileChooser.doFilePrompt(jFrame, "Open CSV Files", 0, new File(interfaceMain.getProperties().getProperty("lastDirectory", ".")), this.csvFilter, null, null);
            if (fileArray2 == null) {
                return false;
            }
            interfaceMain.getProperties().setProperty("lastDirectory", fileArray2[0].getPath());
            fileArray = fileChooser.doFilePrompt(jFrame, "Open Headers File", 0, new File(interfaceMain.getProperties().getProperty("lastDirectory", ".")), null, null, null);
            if (fileArray == null) {
                return false;
            }
            interfaceMain.getProperties().setProperty("lastDirectory", fileArray[0].getPath());
            File[] fileArray4 = new File[fileArray2.length + 1];
            System.arraycopy(fileArray2, 0, fileArray4, 0, fileArray2.length);
            fileArray4[fileArray4.length - 1] = fileArray[0];
            RecentFilesList.getInstance().addFile(fileArray4, this, "CSV file");
        }
        if (fileArray2 == null || fileArray == null) {
            return false;
        }
        interfaceMain.fireControlChange(controlStr);
        this.file = fileArray2[0];
        this.readCSVFile(fileArray2, fileArray[0]);
        return true;
    }

    boolean saveFile(File file) {
        return this.writeFile(file, this.doc);
    }

    boolean saveFile() {
        int n;
        File[] fileArray;
        InterfaceMain interfaceMain = InterfaceMain.getInstance();
        JFrame jFrame = interfaceMain.getFrame();
        FileChooser fileChooser = FileChooserFactory.getFileChooser();
        String string = this.file.getAbsolutePath();
        if (!string.endsWith(".xml")) {
            string = string.replaceAll("\\....$", ".xml");
        }
        if ((fileArray = fileChooser.doFilePrompt(jFrame, null, 1, new File(string), this.xmlFilter)) == null) {
            return true;
        }
        File file = fileArray[0];
        if (!file.getName().matches("[.]") && !file.getAbsolutePath().endsWith(".xml")) {
            file = new File(file.getAbsolutePath() + ".xml");
        }
        if (file.exists() && (n = InterfaceMain.getInstance().showConfirmDialog("Overwrite existing file?", "Confirm Overwrite", 2, 3, 0)) == 2) {
            return true;
        }
        interfaceMain.getProperties().setProperty("lastDirectory", file.getParent());
        return this.writeFile(file, this.doc);
    }

    public Document readXMLFile(File file) {
        try {
            this.lsInput.setByteStream(new FileInputStream(file));
            return this.lsParser.parse(this.lsInput);
        }
        catch (Exception exception) {
            System.out.println("Got Exception while creating XML document: " + exception);
            InterfaceMain.getInstance().showMessageDialog("Exception while creating XML document\n" + exception.getMessage(), "Exception", 0);
            return null;
        }
    }

    public void readCSVFile(File[] fileArray, File file) {
        this.doc = CSVToXMLMain.runCSVConversion(fileArray, file, InterfaceMain.getInstance().getFrame());
    }

    public boolean writeFile(File file, Document document) {
        LSSerializer lSSerializer = this.implls.createLSSerializer();
        DOMConfiguration dOMConfiguration = lSSerializer.getDomConfig();
        boolean bl = Boolean.parseBoolean(System.getProperty("ModelInterface.pretty-print", "true"));
        dOMConfiguration.setParameter("format-pretty-print", bl);
        try {
            LSOutput lSOutput = this.implls.createLSOutput();
            lSOutput.setByteStream(new FileOutputStream(file));
            lSSerializer.write(document, lSOutput);
        }
        catch (Exception exception) {
            System.err.println("Error outputing tree: " + exception);
            return false;
        }
        return true;
    }

    private BaseTableModel getTableModelFromScrollPane(JScrollPane jScrollPane) {
        try {
            TableModel tableModel = ((JTable)jScrollPane.getViewport().getView()).getModel();
            if (tableModel instanceof TableSorter) {
                return (BaseTableModel)((TableSorter)tableModel).getTableModel();
            }
            return (BaseTableModel)tableModel;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    public void displayTable() {
        InterfaceMain interfaceMain = InterfaceMain.getInstance();
        JFrame jFrame = interfaceMain.getFrame();
        if (!this.jtree.getModel().isLeaf(this.jtree.getLastSelectedPathComponent())) {
            JScrollPane jScrollPane = this.tableSelector.createSelection(this.selectedPath, this.doc, jFrame, this.thisViewer);
            if (jScrollPane == null) {
                return;
            }
            BaseTableModel baseTableModel = null;
            if (((JScrollPane)this.splitPane.getRightComponent()).getViewport().getView() != null) {
                baseTableModel = this.getTableModelFromScrollPane((JScrollPane)this.splitPane.getRightComponent());
            }
            interfaceMain.fireProperty("Table", baseTableModel, this.getTableModelFromScrollPane(jScrollPane));
            int n = this.splitPane.getDividerLocation();
            this.splitPane.setRightComponent(jScrollPane);
            this.splitPane.setDividerLocation(n);
            this.tableMenu = this.makePopupTableMenu();
            ((JTable)jScrollPane.getViewport().getView()).addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    this.maybeShowPopup(mouseEvent);
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    this.maybeShowPopup(mouseEvent);
                }

                private void maybeShowPopup(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        InputViewer.this.lastFlipX = mouseEvent.getX();
                        InputViewer.this.lastFlipY = mouseEvent.getY();
                        JTable jTable = (JTable)((JScrollPane)InputViewer.this.splitPane.getRightComponent()).getViewport().getView();
                        Point point = mouseEvent.getPoint();
                        int n = jTable.rowAtPoint(point);
                        int n2 = jTable.columnAtPoint(point);
                        System.out.println("row: " + n);
                        System.out.println("col: " + n2);
                        System.out.println("Point: " + point);
                        if (n != -1 && n2 != -1 && !jTable.isCellSelected(n, n2)) {
                            jTable.setRowSelectionInterval(n, n);
                            jTable.setColumnSelectionInterval(n2, n2);
                        }
                        if (n != -1 && n2 != -1 && jTable.getValueAt(n, n2) instanceof JScrollPane) {
                            TableCellEditor tableCellEditor = jTable.getCellEditor(n, n2);
                            JTable jTable2 = jTable;
                            if (jTable.editCellAt(n, n2)) {
                                System.out.println("Yes edit");
                            } else {
                                System.out.println("Couldn't edit");
                            }
                            jTable = (JTable)((JScrollPane)jTable.getModel().getValueAt(n, n2)).getViewport().getView();
                            System.out.println("Mouse Loc: " + jTable.getMousePosition());
                            System.out.println("Cols: " + jTable.getColumnCount());
                            point = jTable.getMousePosition();
                            n = jTable.rowAtPoint(point);
                            n2 = jTable.columnAtPoint(point);
                            System.out.println("row: " + n);
                            System.out.println("col: " + n2);
                            System.out.println("Point: " + point);
                            if (n != -1 && n2 != -1 && !jTable.isCellSelected(n, n2)) {
                                jTable.setRowSelectionInterval(n, n);
                                jTable.setColumnSelectionInterval(n2, n2);
                            }
                            System.out.println("TableCellEditor: " + tableCellEditor);
                            tableCellEditor.stopCellEditing();
                            if (jTable2.isEditing()) {
                                System.out.println("It is Editing");
                            } else {
                                System.out.println("It isn't Editing");
                            }
                        }
                        InputViewer.this.tableMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            });
        }
    }

    public Documentation getDocumentation() {
        return this.documentation;
    }

    @Override
    public void runBatch(Node node) {
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            String string;
            Node node2 = nodeList.item(i);
            if (node2.getNodeType() != 1 || (string = ((Element)node2).getAttribute("name")) == null) continue;
            if (string.equals("CSV file")) {
                File file = null;
                File file2 = null;
                ArrayList<File> arrayList = new ArrayList<File>();
                NodeList nodeList2 = node2.getChildNodes();
                for (int j = 0; j < nodeList2.getLength(); ++j) {
                    Node node3 = nodeList2.item(j);
                    if (node3.getNodeType() != 1) continue;
                    System.out.println("on " + node3.getNodeName());
                    File file3 = new File(node3.getTextContent());
                    if (node3.getNodeName().equals("headerFile")) {
                        file = file3;
                        continue;
                    }
                    if (node3.getNodeName().equals("outFile")) {
                        file2 = file3;
                        continue;
                    }
                    if (node3.getNodeName().equals("csvFile")) {
                        arrayList.add(file3);
                        continue;
                    }
                    System.out.println("Unknown tag: " + node3.getNodeName());
                }
                if (file != null && file2 != null && arrayList.size() != 0) {
                    File[] fileArray = new File[arrayList.size()];
                    fileArray = arrayList.toArray(fileArray);
                    this.readCSVFile(fileArray, file);
                    if (this.doc == null) continue;
                    this.writeFile(file2, this.doc);
                    this.doc = null;
                    continue;
                }
                System.out.println("Not enough info to run conversion");
                InterfaceMain.getInstance().showMessageDialog("Not enough info to run conversion", "Batch File Error", 0);
                continue;
            }
            System.out.println("Unknown command: " + string);
            InterfaceMain.getInstance().showMessageDialog("Unknown command: " + string, "Batch File Error", 0);
        }
    }

    class MyTreeModelListener
    implements TreeModelListener {
        MyTreeModelListener() {
        }

        @Override
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            try {
                if (treeModelEvent.getSource() instanceof DOMmodel) {
                    BaseTableModel baseTableModel = InputViewer.this.getTableModelFromScrollPane((JScrollPane)InputViewer.this.splitPane.getRightComponent());
                    if (baseTableModel != null) {
                        baseTableModel.fireTableRowsUpdated(0, baseTableModel.getRowCount());
                    }
                    InterfaceMain.getInstance().fireProperty("Document-Modified", null, InputViewer.this.doc);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        @Override
        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            InterfaceMain.getInstance().fireProperty("Document-Modified", null, InputViewer.this.doc);
        }

        @Override
        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            InterfaceMain.getInstance().fireProperty("Document-Modified", null, InputViewer.this.doc);
        }

        @Override
        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            InterfaceMain.getInstance().fireProperty("Document-Modified", null, InputViewer.this.doc);
        }
    }
}

