/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ConfigurationEditor.guihelpers;

import ModelInterface.ConfigurationEditor.utils.DOMUtils;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class NewNodeDialog
extends JDialog {
    private static final long serialVersionUID = -8042747643539685447L;
    private final transient Document mDocument;
    private transient Node mSelectedNode = null;
    private static final String VALUE_NAME = "Value";

    public NewNodeDialog(Frame frame, Document document) {
        super(frame, "Create a New Item", true);
        this.mDocument = document;
        this.initialize();
        this.pack();
    }

    private JDialog getTopLevelUI() {
        return this;
    }

    private void initialize() {
        this.setLayout(new BoxLayout(this.getContentPane(), 0));
        this.add(Box.createRigidArea(new Dimension(5, 30)));
        this.add(new JLabel("Name"));
        this.add(Box.createRigidArea(new Dimension(5, 30)));
        final JTextField jTextField = new JTextField();
        jTextField.setPreferredSize(new Dimension(200, 10));
        this.add(jTextField);
        this.add(Box.createRigidArea(new Dimension(10, 30)));
        this.add(new JLabel(VALUE_NAME));
        this.add(Box.createRigidArea(new Dimension(5, 30)));
        final JTextField jTextField2 = new JTextField();
        jTextField2.setPreferredSize(new Dimension(200, 10));
        this.add(jTextField2);
        this.add(Box.createRigidArea(new Dimension(10, 30)));
        JButton jButton = new JButton("OK");
        jButton.setMnemonic(79);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = jTextField.getText();
                String string2 = jTextField2.getText();
                if (string == null || string2 == null) {
                    JOptionPane.showMessageDialog(NewNodeDialog.this.getTopLevelUI(), "Cannot create node with null name or value.", "Invalid entries", 0);
                } else {
                    Element element = NewNodeDialog.this.mDocument.createElement(NewNodeDialog.VALUE_NAME);
                    DOMUtils.setNameAttrValue(element, string);
                    element.setTextContent(string2);
                    NewNodeDialog.this.mSelectedNode = element;
                    NewNodeDialog.this.setVisible(false);
                }
            }
        });
        this.add(jButton);
        this.add(Box.createRigidArea(new Dimension(5, 30)));
        jButton = new JButton("Cancel");
        jButton.setMnemonic(67);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NewNodeDialog.this.setVisible(false);
            }
        });
        this.add(jButton);
        this.add(Box.createRigidArea(new Dimension(5, 30)));
    }

    public Object getSelectedValue() {
        return this.mSelectedNode;
    }
}

