/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ConfigurationEditor.guicomponents;

import ModelInterface.ConfigurationEditor.utils.DOMUtils;
import ModelInterface.ConfigurationEditor.utils.Messages;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JTextField;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DOMTextFieldFactory
implements PropertyChangeListener {
    private transient Document mDocument;
    private transient Map<String, JTextField> mChildTextFields = new HashMap<String, JTextField>();

    public JTextField createTextField(String string, String string2) {
        String string3 = DOMTextFieldFactory.createXPath(string, string2);
        if (this.mChildTextFields.containsKey(string3)) {
            Logger.global.log(Level.WARNING, Messages.getString("DOMTextFieldFactory.2") + string2 + Messages.getString("DOMTextFieldFactory.3"));
            return null;
        }
        JTextField jTextField = new JTextField();
        this.mChildTextFields.put(string3, jTextField);
        Node node = DOMUtils.getResultNodeFromQuery(this.mDocument, string3);
        if (node != null && node.getTextContent() != null) {
            jTextField.setText(node.getTextContent());
        }
        jTextField.addFocusListener(new DOMTextFieldFocusListener(string3));
        return jTextField;
    }

    private static String createXPath(String string, String string2) {
        return "/Configuration/" + string + "/Value[@name='" + string2 + "']";
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("document-replaced")) {
            this.mDocument = (Document)propertyChangeEvent.getNewValue();
            for (String string : this.mChildTextFields.keySet()) {
                Node node = DOMUtils.getResultNodeFromQuery(this.mDocument, string);
                String string2 = null;
                if (node != null && node.getTextContent() != null) {
                    string2 = node.getTextContent();
                }
                JTextField jTextField = this.mChildTextFields.get(string);
                jTextField.setText(string2);
                jTextField.setEnabled(this.mDocument != null);
            }
        } else {
            Logger.global.log(Level.WARNING, "Property change listener added for the wrong property change.");
        }
    }

    private final class DOMTextFieldFocusListener
    implements FocusListener {
        private final transient String mXPath;

        public DOMTextFieldFocusListener(String string) {
            this.mXPath = string;
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            if (DOMTextFieldFactory.this.mDocument == null) {
                Logger.global.log(Level.WARNING, Messages.getString("DOMTextFieldFactory.0"));
                return;
            }
            Node node = DOMUtils.getResultNodeFromQuery(DOMTextFieldFactory.this.mDocument, this.mXPath);
            String string = ((JTextField)focusEvent.getSource()).getText();
            if (node == null && string.length() > 0) {
                Logger.global.log(Level.INFO, Messages.getString("DOMTextFieldFactory.1") + this.mXPath);
                node = DOMUtils.addNodesForXPath(DOMTextFieldFactory.this.mDocument, this.mXPath);
            }
            if (node != null && !node.getTextContent().equals(string)) {
                node.setTextContent(string);
            }
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
        }
    }
}

