/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ConfigurationEditor.configurationeditor;

import ModelInterface.ConfigurationEditor.configurationeditor.AbstractEditorPanel;
import ModelInterface.ConfigurationEditor.guicomponents.DOMTreeModel;
import ModelInterface.ConfigurationEditor.guihelpers.PopupMenuCreatorMouseAdapter;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import org.w3c.dom.Document;

public class AdvancedOptionsPanel
extends AbstractEditorPanel {
    private static final long serialVersionUID = -4745218032870665176L;

    public AdvancedOptionsPanel() {
        this.initialize();
    }

    private void initialize() {
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.addPropertyChangeListener("document-replaced", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                AdvancedOptionsPanel.this.createAdvancedTree((Document)propertyChangeEvent.getNewValue());
            }
        });
    }

    private void createAdvancedTree(Document document) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (!componentArray[i].getName().equals("content")) continue;
            this.remove(i);
        }
        if (document != null) {
            JTree jTree = new JTree(new DOMTreeModel(document.getDocumentElement(), "Value"));
            jTree.setVisible(true);
            jTree.setShowsRootHandles(true);
            jTree.setRootVisible(true);
            jTree.getSelectionModel().setSelectionMode(1);
            jTree.addMouseListener(new PopupMenuCreatorMouseAdapter());
            JScrollPane jScrollPane = new JScrollPane(jTree);
            jScrollPane.setPreferredSize(new Dimension(600, 250));
            jScrollPane.setName("content");
            this.add(jScrollPane);
        } else {
            JLabel jLabel = new JLabel("A configuration must be opened before the advanced editing options can be used.");
            jLabel.setName("content");
            this.add(jLabel);
        }
    }
}

