/*
 * Decompiled with CFR 0.152.
 */
package ModelInterface.ConfigurationEditor.actions;

import ModelInterface.ConfigurationEditor.configurationeditor.ConfigurationEditor;
import ModelInterface.ConfigurationEditor.utils.FileUtils;
import ModelInterface.ConfigurationEditor.utils.Messages;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.Serializable;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import org.w3c.dom.Document;

public class NewAction
extends AbstractAction {
    private static final long serialVersionUID = 4782184657425041505L;

    public NewAction() {
        super("New");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Serializable serializable;
        ConfigurationEditor configurationEditor = null;
        if (actionEvent.getSource() instanceof ConfigurationEditor) {
            configurationEditor = (ConfigurationEditor)actionEvent.getSource();
        } else {
            serializable = ((JComponent)actionEvent.getSource()).getParent();
            if (serializable instanceof JPopupMenu) {
                configurationEditor = (ConfigurationEditor)((JComponent)((JPopupMenu)serializable).getInvoker()).getTopLevelAncestor();
            } else if (serializable instanceof JToolBar) {
                configurationEditor = (ConfigurationEditor)((JToolBar)serializable).getTopLevelAncestor();
            } else assert (false);
        }
        if (!FileUtils.askForSave(configurationEditor)) {
            return;
        }
        serializable = FileUtils.getInitializedProperties(configurationEditor);
        String string = ((Properties)serializable).getProperty("template-path");
        if (string == null) {
            String string2 = Messages.getString("NewAction.1");
            String string3 = Messages.getString("NewAction.2");
            JOptionPane.showMessageDialog(configurationEditor, string2, string3, 0);
            return;
        }
        File file = new File(string);
        Document document = FileUtils.loadDocument(file, "Configuration");
        FileUtils.setDocumentFile(document, null);
        configurationEditor.setDocument(document);
    }
}

