/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.hash;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import org.basex.io.in.DataInput;
import org.basex.io.out.DataOutput;
import org.basex.util.hash.TokenSet;

public final class TokenIntMap
extends TokenSet {
    private int[] values;

    public TokenIntMap() {
        this.values = new int[this.capacity()];
    }

    public TokenIntMap(DataInput in) throws IOException {
        this.read(in);
    }

    @Override
    public void read(DataInput in) throws IOException {
        super.read(in);
        this.values = in.readNums();
    }

    @Override
    public void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeNums(this.values);
    }

    public void put(byte[] key, int value) {
        int i = this.put(key);
        this.values[i] = value;
    }

    public int get(byte[] key) {
        int i = this.id(key);
        return i == 0 ? -1 : this.values[i];
    }

    @Override
    public int remove(byte[] key) {
        int i = super.remove(key);
        this.values[i] = -1;
        return i;
    }

    @Override
    protected void rehash(int newSize) {
        super.rehash(newSize);
        this.values = Arrays.copyOf(this.values, newSize);
    }

    @Override
    public String toString() {
        ArrayList<Integer> v = new ArrayList<Integer>();
        for (int value : this.values) {
            v.add(value);
        }
        return this.toString((Object[])this.keys, v.toArray());
    }
}

