/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util;

import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenMap;

public final class XMLToken {
    private static final TokenMap ENTITIESMAP = new TokenMap();
    private static final byte[] UNDERSCORE = new byte[]{95};
    private static final String[] HTMLENTITIES = new String[]{"Aacute", "\u00c1", "aacute", "\u00e1", "Acirc", "\u00c2", "acirc", "\u00e2", "acute", "\u00b4", "AElig", "\u00c6", "aelig", "\u00e6", "Agrave", "\u00c0", "agrave", "\u00e0", "alefsym", "\u2135", "Alpha", "\u0391", "alpha", "\u03b1", "and", "\u2227", "ang", "\u2220", "Aring", "\u00c5", "aring", "\u00e5", "asymp", "\u2248", "Atilde", "\u00c3", "atilde", "\u00e3", "Auml", "\u00c4", "auml", "\u00e4", "bdquo", "\u201e", "Beta", "\u0392", "beta", "\u03b2", "brvbar", "\u00a6", "bull", "\u2022", "cap", "\u2229", "Ccedil", "\u00c7", "ccedil", "\u00e7", "cedil", "\u00b8", "cent", "\u00a2", "Chi", "\u03a7", "chi", "\u03c7", "circ", "\u02c6", "clubs", "\u2663", "cong", "\u2245", "copy", "\u00a9", "crarr", "\u21b5", "cup", "\u222a", "curren", "\u00a4", "dagger", "\u2020", "Dagger", "\u2021", "darr", "\u2193", "dArr", "\u21d3", "deg", "\u00b0", "Delta", "\u0394", "delta", "\u03b4", "diams", "\u2666", "divide", "\u00f7", "Eacute", "\u00c9", "eacute", "\u00e9", "Ecirc", "\u00ca", "ecirc", "\u00ea", "Egrave", "\u00c8", "egrave", "\u00e8", "empty", "\u2205", "emsp", "\u2003", "ensp", "\u2002", "Epsilon", "\u0395", "epsilon", "\u03b5", "equiv", "\u2261", "Eta", "\u0397", "eta", "\u03b7", "ETH", "\u00d0", "eth", "\u00f0", "Euml", "\u00cb", "euml", "\u00eb", "euro", "\u20ac", "exist", "\u2203", "fnof", "\u0192", "forall", "\u2200", "frac12", "\u00bd", "frac14", "\u00bc", "frac34", "\u00be", "frasl", "\u2044", "Gamma", "\u0393", "gamma", "\u03b3", "ge", "\u2265", "harr", "\u2194", "hArr", "\u21d4", "hearts", "\u2665", "hellip", "\u2026", "Iacute", "\u00cd", "iacute", "\u00ed", "Icirc", "\u00ce", "icirc", "\u00ee", "iexcl", "\u00a1", "Igrave", "\u00cc", "igrave", "\u00ec", "image", "\u2111", "infin", "\u221e", "int", "\u222b", "Iota", "\u0399", "iota", "\u03b9", "iquest", "\u00bf", "isin", "\u2208", "Iuml", "\u00cf", "iuml", "\u00ef", "Kappa", "\u039a", "kappa", "\u03ba", "Lambda", "\u039b", "lambda", "\u03bb", "lang", "\u2329", "laquo", "\u00ab", "larr", "\u2190", "lArr", "\u21d0", "lceil", "\u2308", "ldquo", "\u201c", "le", "\u2264", "lfloor", "\u230a", "lowast", "\u2217", "loz", "\u25ca", "lrm", "\u200e", "lsaquo", "\u2039", "lsquo", "\u2018", "macr", "\u00af", "mdash", "\u2014", "micro", "\u00b5", "middot", "\u00b7", "minus", "\u2212", "Mu", "\u039c", "mu", "\u03bc", "nabla", "\u2207", "nbsp", "\u00a0", "ndash", "\u2013", "ne", "\u2260", "ni", "\u220b", "not", "\u00ac", "notin", "\u2209", "nsub", "\u2284", "Ntilde", "\u00d1", "ntilde", "\u00f1", "Nu", "\u039d", "nu", "\u03bd", "Oacute", "\u00d3", "oacute", "\u00f3", "Ocirc", "\u00d4", "ocirc", "\u00f4", "OElig", "\u0152", "oelig", "\u0153", "Ograve", "\u00d2", "ograve", "\u00f2", "oline", "\u203e", "Omega", "\u03a9", "omega", "\u03c9", "Omicron", "\u039f", "omicron", "\u03bf", "oplus", "\u2295", "or", "\u2228", "ordf", "\u00aa", "ordm", "\u00ba", "Oslash", "\u00d8", "oslash", "\u00f8", "Otilde", "\u00d5", "otilde", "\u00f5", "otimes", "\u2297", "Ouml", "\u00d6", "ouml", "\u00f6", "para", "\u00b6", "part", "\u2202", "permil", "\u2030", "perp", "\u22a5", "Phi", "\u03a6", "phi", "\u03c6", "Pi", "\u03a0", "pi", "\u03c0", "piv", "\u03d6", "plusmn", "\u00b1", "pound", "\u00a3", "prime", "\u2032", "Prime", "\u2033", "prod", "\u220f", "prop", "\u221d", "Psi", "\u03a8", "psi", "\u03c8", "radic", "\u221a", "rang", "\u232a", "raquo", "\u00bb", "rarr", "\u2192", "rArr", "\u21d2", "rceil", "\u2309", "rdquo", "\u201d", "real", "\u211c", "reg", "\u00ae", "rfloor", "\u230b", "Rho", "\u03a1", "rho", "\u03c1", "rlm", "\u200f", "rsaquo", "\u203a", "rsquo", "\u2019", "sbquo", "\u201a", "Scaron", "\u0160", "scaron", "\u0161", "sdot", "\u22c5", "sect", "\u00a7", "shy", "\u00ad", "Sigma", "\u03a3", "sigma", "\u03c3", "sigmaf", "\u03c2", "sim", "\u223c", "spades", "\u2660", "sub", "\u2282", "sube", "\u2286", "sum", "\u2211", "sup", "\u2283", "sup1", "\u00b9", "sup2", "\u00b2", "sup3", "\u00b3", "supe", "\u2287", "szlig", "\u00df", "Tau", "\u03a4", "tau", "\u03c4", "there4", "\u2234", "Theta", "\u0398", "theta", "\u03b8", "thetasym", "\u03d1", "thinsp", "\u2009", "THORN", "\u00de", "thorn", "\u00fe", "tilde", "\u02dc", "times", "\u00d7", "trade", "\u2122", "Uacute", "\u00da", "uacute", "\u00fa", "uarr", "\u2191", "uArr", "\u21d1", "Ucirc", "\u00db", "ucirc", "\u00fb", "Ugrave", "\u00d9", "ugrave", "\u00f9", "uml", "\u00a8", "upsih", "\u03d2", "Upsilon", "\u03a5", "upsilon", "\u03c5", "Uuml", "\u00dc", "uuml", "\u00fc", "weierp", "\u2118", "Xi", "\u039e", "xi", "\u03be", "Yacute", "\u00dd", "yacute", "\u00fd", "yen", "\u00a5", "yuml", "\u00ff", "Yuml", "\u0178", "Zeta", "\u0396", "zeta", "\u03b6", "zwj", "\u200d", "zwnj", "\u200c"};

    private XMLToken() {
    }

    public static boolean valid(int ch) {
        return ch < 55296 ? ch >= 32 || ch == 10 || ch == 9 || ch == 13 : ch >= 57344 && ch <= 65533 || ch >= 65536 && ch <= 0x10FFFF;
    }

    public static boolean isNCStartChar(int ch) {
        return ch < 128 ? ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch == 95 : (ch < 768 ? ch >= 192 && ch != 215 && ch != 247 : ch >= 880 && ch <= 893 || ch >= 895 && ch <= 8191 || ch >= 8204 && ch <= 8205 || ch >= 8304 && ch <= 8591 || ch >= 11264 && ch <= 12031 || ch >= 12289 && ch <= 55295 || ch >= 63744 && ch <= 64975 || ch >= 65008 && ch <= 65533 || ch >= 65536 && ch <= 983039);
    }

    public static boolean isNCChar(int ch) {
        return XMLToken.isNCStartChar(ch) || (ch < 256 ? Token.digit(ch) || ch == 45 || ch == 46 || ch == 183 : ch >= 768 && ch <= 879 || ch == 8255 || ch == 8256);
    }

    public static boolean isStartChar(int ch) {
        return XMLToken.isNCStartChar(ch) || ch == 58;
    }

    public static boolean isChar(int ch) {
        return XMLToken.isNCChar(ch) || ch == 58;
    }

    public static boolean isNCName(byte[] value) {
        int l = value.length;
        return l != 0 && XMLToken.ncName(value, 0) == l;
    }

    public static boolean isName(byte[] value) {
        int l = value.length;
        for (int i = 0; i < l; i += Token.cl(value, i)) {
            int c = Token.cp(value, i);
            if (!(i == 0 ? !XMLToken.isStartChar(c) : !XMLToken.isChar(c))) continue;
            return false;
        }
        return l != 0;
    }

    public static boolean isNMToken(byte[] value) {
        int l = value.length;
        for (int i = 0; i < l; i += Token.cl(value, i)) {
            if (XMLToken.isChar(Token.cp(value, i))) continue;
            return false;
        }
        return l != 0;
    }

    public static boolean isQName(byte[] value) {
        int l = value.length;
        if (l == 0) {
            return false;
        }
        int i = XMLToken.ncName(value, 0);
        if (i == l) {
            return true;
        }
        if (i == 0 || value[i] != 58) {
            return false;
        }
        int j = XMLToken.ncName(value, i + 1);
        return j == l && j != i + 1;
    }

    private static int ncName(byte[] value, int start) {
        int l = value.length;
        for (int i = start; i < l; i += Token.cl(value, i)) {
            int c = Token.cp(value, i);
            if (!(i == start ? !XMLToken.isNCStartChar(c) : !XMLToken.isNCChar(c))) continue;
            return i;
        }
        return l;
    }

    public static boolean isId(byte[] name, boolean idref) {
        byte[] n = Token.lc(Token.local(name));
        return idref ? Token.contains(n, Token.REF) : Token.contains(n, Token.ID) && !Token.contains(n, Token.REF);
    }

    public static byte[] encode(byte[] name, boolean lax) {
        byte[] nm = lax ? Token.trim(name) : name;
        int nl = nm.length;
        if (nl == 0) {
            return UNDERSCORE;
        }
        for (int n = 0; n < nl; n += Token.cl(nm, n)) {
            int cp = Token.cp(nm, n);
            if (cp != 95 && !(n == 0 ? !XMLToken.isNCStartChar(cp) : !XMLToken.isNCChar(cp))) continue;
            TokenBuilder tb = new TokenBuilder(nl << 1).add(nm, 0, n);
            for (int m = n; m < nl; m += Token.cl(nm, m)) {
                cp = Token.cp(nm, m);
                if (lax) {
                    boolean nc = XMLToken.isNCChar(cp);
                    if (m == 0 && nc && !XMLToken.isNCStartChar(cp)) {
                        tb.add(95);
                    }
                    tb.add(nc ? cp : 95);
                    continue;
                }
                if (cp == 95) {
                    tb.add(95).add(95);
                    continue;
                }
                if (m == 0 ? XMLToken.isNCStartChar(cp) : XMLToken.isNCChar(cp)) {
                    tb.add(cp);
                    continue;
                }
                if (cp < 65536) {
                    XMLToken.addEsc(tb, cp);
                    continue;
                }
                int r = cp - 65536;
                XMLToken.addEsc(tb, (r >>> 10) + 55296);
                XMLToken.addEsc(tb, (r & 0x3FF) + 56320);
            }
            return tb.finish();
        }
        return nm;
    }

    private static void addEsc(TokenBuilder tb, int cp) {
        tb.addByte(UNDERSCORE[0]);
        int a = cp >>> 12;
        tb.addByte((byte)(a + (a > 9 ? 87 : 48)));
        int b = cp >>> 8 & 0xF;
        tb.addByte((byte)(b + (b > 9 ? 87 : 48)));
        int c = cp >>> 4 & 0xF;
        tb.addByte((byte)(c + (c > 9 ? 87 : 48)));
        int d = cp & 0xF;
        tb.addByte((byte)(d + (d > 9 ? 87 : 48)));
    }

    public static byte[] decode(byte[] name, boolean lax) {
        int nl = name.length;
        if (nl == 0) {
            return null;
        }
        if (lax) {
            return name;
        }
        TokenBuilder tb = new TokenBuilder();
        int mode = 0;
        int uc = 0;
        int n = 0;
        while (n < nl) {
            int cp = Token.cp(name, n);
            if (mode >= 3) {
                uc <<= 4;
                if (cp >= 48 && cp <= 57) {
                    uc += cp - 48;
                } else if (cp >= 65 && cp <= 70) {
                    uc += cp - 55;
                } else if (cp >= 97 && cp <= 102) {
                    uc += cp - 87;
                } else {
                    return null;
                }
                if (++mode == 7) {
                    tb.add(uc);
                    mode = 0;
                    uc = 0;
                }
            } else if (cp == 95) {
                if (++mode == 3) {
                    tb.add(95);
                    mode = 0;
                    continue;
                }
            } else {
                if (mode == 1) {
                    mode = 3;
                    continue;
                }
                if (mode == 2) {
                    tb.add(95);
                    mode = 0;
                    continue;
                }
                if (!(!tb.isEmpty() ? XMLToken.isNCChar(cp) : XMLToken.isNCStartChar(cp))) {
                    return null;
                }
                tb.add(cp);
                mode = 0;
            }
            n += Token.cl(name, n);
        }
        if (mode == 2) {
            tb.add(95);
        } else if (mode == 1 && !tb.isEmpty() || mode >= 3) {
            return null;
        }
        return tb.finish();
    }

    public static byte[] getEntity(byte[] key) {
        TokenMap map = ENTITIESMAP;
        if (map.isEmpty()) {
            String[] ents = HTMLENTITIES;
            int el = ents.length;
            for (int e = 0; e < el; e += 2) {
                map.put(ents[e], ents[e + 1]);
            }
        }
        return map.get(key);
    }
}

