/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.var;

import org.basex.data.Data;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.expr.Expr;
import org.basex.query.expr.ExprInfo;
import org.basex.query.expr.TypeCheck;
import org.basex.query.value.Value;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.ExprType;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.SeqType;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;

public final class Var
extends ExprInfo {
    public final QNm name;
    public final int id;
    public final InputInfo info;
    public SeqType declType;
    public boolean promote;
    int slot;
    private final ExprType exprType = new ExprType(SeqType.ITEM_ZM);
    private final StaticContext sc;
    private final boolean param;
    private Expr ex;

    public Var(QNm name, SeqType declType, boolean param, int slot, QueryContext qc, StaticContext sc, InputInfo info) {
        this.name = name;
        this.param = param;
        this.sc = sc;
        this.info = info;
        this.slot = slot;
        this.declType = declType == null || declType.eq(SeqType.ITEM_ZM) ? null : declType;
        this.promote = param;
        this.id = qc.varIDs++;
    }

    public Var(QNm name, SeqType declType, boolean param, QueryContext qc, StaticContext sc, InputInfo info) {
        this(name, declType, param, -1, qc, sc, info);
    }

    public Var(Var var, QueryContext qc, StaticContext sc) {
        this(var.name, var.declType, var.param, qc, sc, var.info);
        this.promote = var.promote;
        this.exprType.assign(var.exprType);
    }

    public SeqType seqType() {
        SeqType it;
        SeqType st = this.exprType.seqType();
        SeqType dt = this.declType;
        SeqType seqType = it = dt != null ? dt.intersect(st) : null;
        return it != null ? it : (dt != null ? dt : st);
    }

    public void expr(Expr expr) {
        this.ex = expr;
    }

    public long size() {
        return this.exprType.size();
    }

    public boolean ddo() {
        if (this.ex != null) {
            return this.ex.ddo();
        }
        SeqType st = this.seqType();
        return st.zeroOrOne() && st.type instanceof NodeType;
    }

    public Data data() {
        return this.ex != null ? this.ex.data() : null;
    }

    public SeqType declaredType() {
        return this.declType == null ? SeqType.ITEM_ZM : this.declType;
    }

    public void refineType(SeqType st, CompileContext cc) throws QueryException {
        this.refineType(st, st.zero() ? 0L : (st.one() ? 1L : -1L), cc);
    }

    public void refineType(SeqType st, long size, CompileContext cc) throws QueryException {
        SeqType it;
        SeqType dt;
        if (this.declType != null) {
            if (this.declType.occ.intersect(st.occ) == null) {
                throw QueryError.INVTREAT_X_X_X.get(this.info, st, this.declType, Token.concat(Character.valueOf('$'), this.name.string()));
            }
            if (st.instanceOf(this.declType)) {
                if (cc != null) {
                    cc.info("remove type check: %", this);
                }
                this.declType = null;
            } else if (!st.promotable(this.declType)) {
                return;
            }
        }
        if (!(dt = this.exprType.seqType()).instanceOf(st) && (it = dt.intersect(st)) != null) {
            this.exprType.assign(it, size);
        }
    }

    public boolean checksType() {
        return this.declType != null;
    }

    public Expr checked(Expr expr, CompileContext cc) throws QueryException {
        return this.checksType() ? new TypeCheck(this.sc, this.info, expr, this.declType, this.promote).optimize(cc) : expr;
    }

    public Value checkType(Value value, QueryContext qc, boolean opt) throws QueryException {
        if (!this.checksType() || this.declType.instance(value)) {
            return value;
        }
        if (this.promote) {
            return this.declType.promote(value, this.name, qc, this.sc, this.info, opt);
        }
        throw QueryError.typeError((Expr)value, this.declType, this.name, this.info, this.promote);
    }

    public void checkType(Expr expr) throws QueryException {
        SeqType et = expr.seqType();
        SeqType vt = this.seqType();
        if (!this.checksType() || vt.type.instanceOf(et.type) || et.type.instanceOf(vt.type) && et.occ.instanceOf(vt.occ)) {
            return;
        }
        if (!this.promote || !(et.type instanceof NodeType) && !et.promotable(vt)) {
            throw vt.type.nsSensitive() ? QueryError.NSSENS_X_X.get(this.info, et, vt) : QueryError.typeError(expr, vt, this.name, this.info, this.promote);
        }
    }

    public boolean is(Var var) {
        return this.id == var.id;
    }

    public boolean promotes() {
        return this.promote;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean adoptCheck(SeqType st, boolean prom) {
        if (this.declType == null || st.instanceOf(this.declType)) {
            this.declType = st;
        } else if (!this.declType.instanceOf(st)) {
            return false;
        }
        this.promote |= prom;
        return true;
    }

    public boolean equals(Object obj) {
        return obj instanceof Var && this.is((Var)obj);
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.attachVariable(plan.create(this, new Object[0]), this, true), new ExprInfo[0]);
    }

    public byte[] id() {
        return Token.concat("$", this.name.string(), "_", this.id);
    }

    @Override
    public void plan(QueryString qs) {
        qs.token(this.id());
        if (this.declType != null) {
            qs.token("as").token(this.declType);
        }
    }

    @Override
    public String toErrorString() {
        return Strings.concat("$", this.name.string());
    }
}

