/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.var;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.scope.StaticDecl;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.Value;
import org.basex.query.var.Var;
import org.basex.query.var.VarScope;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.Util;

public final class StaticVar
extends StaticDecl {
    public final boolean external;
    private final boolean lazy;
    Value value;

    StaticVar(VarScope vs, AnnList anns, Var var, Expr expr, boolean external, String doc) {
        super(anns, var.name, var.declType, vs, doc, var.info);
        this.expr = expr;
        this.external = external;
        this.lazy = anns.contains(Annotation._BASEX_LAZY);
    }

    @Override
    public void comp(CompileContext cc) throws QueryException {
        if (this.expr == null) {
            throw QueryError.VAREMPTY_X.get(this.info, this.name());
        }
        if (this.dontEnter) {
            throw QueryError.CIRCVAR_X.get(this.info, this.name());
        }
        if (this.compiled) {
            return;
        }
        this.compiled = true;
        this.dontEnter = true;
        cc.pushScope(this.vs);
        try {
            this.expr = this.expr.compile(cc);
        }
        catch (QueryException qe) {
            this.declType = null;
            if (this.lazy) {
                this.expr = cc.error(qe, this.expr);
                return;
            }
            throw qe.notCatchable();
        }
        finally {
            cc.removeScope(this);
            this.dontEnter = false;
        }
        if (this.expr instanceof Value || !this.lazy && !this.expr.has(Flag.NDT)) {
            cc.replaceWith(this.expr, this.value(cc.qc));
        }
    }

    Value value(QueryContext qc) throws QueryException {
        if (this.dontEnter) {
            throw QueryError.CIRCVAR_X.get(this.info, this.name());
        }
        if (this.lazy) {
            if (!this.compiled) {
                throw Util.notExpected(this + " was not compiled.", new Object[0]);
            }
        } else if (this.expr == null) {
            throw QueryError.VAREMPTY_X.get(this.info, this.name());
        }
        if (this.value != null) {
            return this.value;
        }
        this.dontEnter = true;
        int fp = this.vs.enter(qc);
        try {
            Value value = this.bindValue(this.expr.value(qc), qc);
            return value;
        }
        catch (QueryException qe) {
            if (this.lazy) {
                qe.notCatchable();
            }
            throw qe;
        }
        finally {
            VarScope.exit(fp, qc);
            this.dontEnter = false;
        }
    }

    void checkUp() throws QueryException {
        if (this.expr != null && this.expr.has(Flag.UPD)) {
            throw QueryError.UPNOT_X.get(this.info, this.description());
        }
    }

    void bind(Value val, QueryContext qc) throws QueryException {
        if (!this.external || this.compiled) {
            return;
        }
        this.bindValue(this.declType == null || this.declType.instance(val) ? val : this.declType.cast(val, true, qc, this.sc, this.info), qc);
    }

    private Value bindValue(Value val, QueryContext qc) throws QueryException {
        this.expr = val;
        this.value = val;
        if (this.declType != null) {
            this.declType.treat(val, this.name, qc, this.info);
        }
        return this.value;
    }

    @Override
    public boolean visit(ASTVisitor visitor) {
        return this.expr == null || this.expr.accept(visitor);
    }

    @Override
    public byte[] id() {
        return Token.concat(Token.DOLLAR, this.name.id());
    }

    private String name() {
        return Strings.concat(Token.DOLLAR, this.name.string());
    }

    boolean has(Flag ... flags) {
        if (this.dontEnter || this.expr == null) {
            return false;
        }
        this.dontEnter = true;
        boolean res = this.expr.has(flags);
        this.dontEnter = false;
        return res;
    }

    @Override
    public String description() {
        return "variable declaration";
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, "name", this.name.string()), this.expr);
    }

    @Override
    public void plan(QueryString qs) {
        qs.token("declare").token(this.anns).token("variable").token(this.name());
        if (this.declType != null) {
            qs.token("as").token(this.declType);
        }
        if (this.external) {
            qs.token("external");
        }
        if (this.expr != null) {
            qs.token(":=").token(this.expr);
        }
        qs.token(';');
    }
}

