/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import java.util.EnumMap;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.util.NSGlobal;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.Str;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;

public enum ListType implements Type
{
    NMTOKENS("NMTOKENS", AtomType.NMTOKEN),
    ENTITIES("ENTITIES", AtomType.ENTITY),
    IDREFS("IDREFS", AtomType.IDREF);

    private static final ListType[] VALUES;
    private final AtomType type;
    private final QNm name;
    private EnumMap<Occ, SeqType> seqTypes;

    private ListType(String name, AtomType type) {
        this.name = new QNm(name, QueryText.XS_URI);
        this.type = type;
    }

    @Override
    public final boolean isNumber() {
        return false;
    }

    @Override
    public final boolean isUntyped() {
        return false;
    }

    @Override
    public final boolean isNumberOrUntyped() {
        return false;
    }

    @Override
    public final boolean isStringOrUntyped() {
        return false;
    }

    @Override
    public final boolean isSortable() {
        return false;
    }

    @Override
    public final Value cast(Item item, QueryContext qc, StaticContext sc, InputInfo ii) throws QueryException {
        byte[][] values = Token.split(Token.normalize(item.string(ii)), 32);
        if (values.length == 0) {
            throw QueryError.FUNCCAST_X_X_X.get(ii, item.type, this, item);
        }
        ValueBuilder vb = new ValueBuilder(qc);
        for (byte[] value : values) {
            vb.add(this.type.cast(Str.get(value), qc, sc, ii));
        }
        return vb.value(this.type);
    }

    @Override
    public final Value cast(Object value, QueryContext qc, StaticContext sc, InputInfo ii) throws QueryException {
        return this.cast(Str.get(value, qc, ii), qc, sc, ii);
    }

    @Override
    public final Value castString(String value, QueryContext qc, StaticContext sc, InputInfo ii) throws QueryException {
        return this.cast(value, qc, sc, ii);
    }

    @Override
    public SeqType seqType(Occ occ) {
        if (this.seqTypes == null) {
            this.seqTypes = new EnumMap(Occ.class);
        }
        return this.seqTypes.computeIfAbsent(occ, o -> new SeqType(this, (Occ)((Object)o)));
    }

    @Override
    public final boolean eq(Type tp) {
        return this == tp;
    }

    @Override
    public final boolean instanceOf(Type tp) {
        return this == tp;
    }

    @Override
    public final Type union(Type tp) {
        return this == tp ? tp : AtomType.ITEM;
    }

    @Override
    public final Type intersect(Type tp) {
        return this == tp ? this : (tp.instanceOf(this) ? tp : null);
    }

    @Override
    public final AtomType atomic() {
        return this.type;
    }

    @Override
    public final Type.ID id() {
        return null;
    }

    @Override
    public final boolean nsSensitive() {
        return false;
    }

    @Override
    public final String toString() {
        return Strings.concat(NSGlobal.prefix(this.name.uri()), Character.valueOf(':'), this.name.string());
    }

    public static ListType find(QNm qname) {
        for (ListType lt : VALUES) {
            if (!lt.name.eq(qname)) continue;
            return lt;
        }
        return null;
    }

    static {
        VALUES = ListType.values();
    }
}

