/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import org.basex.query.expr.Expr;
import org.basex.query.value.type.Occ;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.Util;

public final class ExprType {
    private SeqType seqType;
    private long size = -1L;

    public ExprType(SeqType seqType) {
        this.assign(seqType);
    }

    public SeqType seqType() {
        return this.seqType;
    }

    public long size() {
        return this.size;
    }

    public void assign(SeqType st) {
        this.asg(st, st.zero() ? 0L : (st.one() ? 1L : -1L));
    }

    public void assign(Expr expr) {
        this.asg(expr.seqType(), expr.size());
    }

    public void assign(ExprType et) {
        this.asg(et.seqType, et.size);
    }

    public void assign(Type type) {
        this.seqType = SeqType.get(type, this.seqType.occ);
    }

    public void assign(Type type, Occ occ) {
        this.assign(SeqType.get(type, occ));
    }

    public void assign(Occ occ) {
        this.assign(this.seqType.with(occ));
    }

    public void assign(SeqType st, long sz) {
        if (sz >= 0L) {
            this.asg(st.with(sz == 0L ? Occ.ZERO : (sz == 1L ? Occ.EXACTLY_ONE : Occ.ONE_OR_MORE)), sz);
        } else {
            this.assign(st);
        }
    }

    public void assign(SeqType st, Occ occ, long sz) {
        this.assign(sz >= 0L ? st : st.with(occ), sz);
    }

    public void assign(SeqType st, long[] minMax) {
        long sz;
        long min = minMax[0];
        long max = minMax[1];
        long l = sz = min == max ? min : -1L;
        Occ occ = min > 0L ? Occ.ONE_OR_MORE : (max == 1L ? Occ.ZERO_OR_ONE : Occ.ZERO_OR_MORE);
        this.assign(st, occ, sz);
    }

    public void refine(Expr expr) {
        SeqType st = this.seqType.intersect(expr.seqType());
        if (st != null) {
            long es = expr.size();
            this.asg(st, es == this.size || this.size == -1L ? es : (es == -1L ? this.size : -1L));
        }
    }

    private void asg(SeqType st, long sz) {
        this.seqType = st;
        this.size = sz;
    }

    public String toString() {
        return Util.className(this) + '[' + this.seqType + ", " + this.size + ']';
    }
}

