/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.type;

import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.InputInfo;

public final class ArrayType
extends FuncType {
    ArrayType(SeqType declType) {
        super(declType, SeqType.INTEGER_O);
    }

    @Override
    public XQArray cast(Item item, QueryContext qc, StaticContext sc, InputInfo ii) throws QueryException {
        XQArray a;
        if (item instanceof XQArray && (a = (XQArray)item).instanceOf(this)) {
            return a;
        }
        throw QueryError.typeError(item, this, ii);
    }

    @Override
    public boolean eq(Type type) {
        return this == type || type instanceof ArrayType && this.declType.eq(((ArrayType)type).declType);
    }

    @Override
    public boolean instanceOf(Type type) {
        if (type.oneOf(SeqType.ARRAY, SeqType.FUNCTION, AtomType.ITEM)) {
            return true;
        }
        if (!(type instanceof FuncType) || type instanceof MapType) {
            return false;
        }
        FuncType ft = (FuncType)type;
        return this.declType.instanceOf(ft.declType) && (type instanceof ArrayType || ft.argTypes.length == 1 && ft.argTypes[0].instanceOf(SeqType.INTEGER_O));
    }

    @Override
    public Type union(Type type) {
        if (this.instanceOf(type)) {
            return type;
        }
        if (type.instanceOf(this)) {
            return this;
        }
        if (type instanceof ArrayType) {
            ArrayType at = (ArrayType)type;
            return ArrayType.get(this.declType.union(at.declType));
        }
        return type instanceof MapType ? SeqType.FUNCTION : (type instanceof FuncType ? type.union(this) : AtomType.ITEM);
    }

    @Override
    public Type intersect(Type type) {
        if (this.instanceOf(type)) {
            return this;
        }
        if (type.instanceOf(this)) {
            return type;
        }
        if (!(type instanceof FuncType) || type instanceof MapType) {
            return null;
        }
        FuncType ft = (FuncType)type;
        SeqType dt = this.declType.intersect(ft.declType);
        if (dt == null) {
            return null;
        }
        if (type instanceof ArrayType) {
            return ArrayType.get(dt);
        }
        return ft.argTypes.length == 1 && ft.argTypes[0].instanceOf(SeqType.INTEGER_O) ? new FuncType(dt, ft.argTypes[0].union(SeqType.INTEGER_O)) : null;
    }

    public static ArrayType get(SeqType declType) {
        return declType.eq(SeqType.ITEM_ZM) ? SeqType.ARRAY : new ArrayType(declType);
    }

    @Override
    public String toString() {
        Object[] objectArray;
        if (this == SeqType.ARRAY) {
            objectArray = WILDCARD;
        } else {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = this.declType;
        }
        Object[] param = objectArray;
        return new QueryString().token("array").params(param).toString();
    }
}

