/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.Expr;
import org.basex.query.func.Function;
import org.basex.query.value.Value;
import org.basex.query.value.item.Item;
import org.basex.query.value.node.ANode;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.util.InputInfo;

public final class SingletonSeq
extends Seq {
    private final Value value;

    private SingletonSeq(long size, Value value) {
        super(size, value.type);
        this.value = value;
    }

    @Override
    public Item ebv(QueryContext qc, InputInfo ii) throws QueryException {
        Item head = this.value.itemAt(0L);
        if (head instanceof ANode) {
            return head;
        }
        throw QueryError.EBV_X.get(ii, this);
    }

    @Override
    public void cache(boolean lazy, InputInfo ii) throws QueryException {
        this.value.cache(lazy, ii);
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo ii) throws QueryException {
        return SingletonSeq.get(this.value.atomValue(qc, ii), this.size);
    }

    @Override
    public long atomSize() {
        return this.value.atomSize();
    }

    @Override
    protected Seq subSeq(long offset, long length, QueryContext qc) {
        return this.value.size() == 1L ? new SingletonSeq(length, this.value) : super.subSeq(offset, length, qc);
    }

    @Override
    public Value insert(long pos, Item item, QueryContext qc) {
        return item.equals(this.value) ? SingletonSeq.get(this.value, this.size + 1L) : this.copyInsert(pos, item, qc);
    }

    @Override
    public Value remove(long pos, QueryContext qc) {
        return this.value.size() == 1L ? SingletonSeq.get(this.value, this.size - 1L) : this.copyRemove(pos, qc);
    }

    @Override
    public Value reverse(QueryContext qc) {
        return SingletonSeq.get(this.value.reverse(qc), this.size / this.value.size());
    }

    @Override
    public Item itemAt(long pos) {
        return this.value.itemAt(pos % this.value.size());
    }

    @Override
    public Expr simplifyFor(CompileContext.Simplify mode, CompileContext cc) throws QueryException {
        return mode == CompileContext.Simplify.DISTINCT ? cc.replaceWith(this, this.value) : super.simplifyFor(mode, cc);
    }

    @Override
    public String description() {
        return "singleton " + super.description();
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, new Object[0]), this.value);
    }

    @Override
    public void plan(QueryString qs) {
        qs.function(Function._UTIL_REPLICATE, this.value, this.size / this.value.size());
    }

    public boolean singleItem() {
        return this.value instanceof Item;
    }

    public static Value get(Value value, long count) {
        if (count == 1L) {
            return value;
        }
        long vs = value.size();
        long size = vs * count;
        if (size == 0L) {
            return Empty.VALUE;
        }
        Value val = value;
        if (val instanceof SingletonSeq) {
            val = ((SingletonSeq)val).value;
        } else if (vs > 1L) {
            Item item = val.itemAt(0L);
            int v = 0;
            while ((long)(++v) < vs && item.equals(val.itemAt(v))) {
            }
            if ((long)v == vs) {
                val = item;
            }
        }
        return size == 1L ? val : new SingletonSeq(size, val);
    }
}

