/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.ExprInfo;
import org.basex.query.func.Function;
import org.basex.query.value.Value;
import org.basex.query.value.item.Int;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.Seq;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;

public final class RangeSeq
extends Seq {
    private final long start;
    public final boolean asc;

    private RangeSeq(long start, long size, boolean asc) {
        super(size, AtomType.INTEGER);
        this.start = start;
        this.asc = asc;
    }

    public static Value get(long start, long size, boolean asc) {
        return size < 1L ? Empty.VALUE : (size == 1L ? Int.get(start) : new RangeSeq(start, size, asc));
    }

    public long[] range(boolean order) {
        long end = this.asc ? this.start + this.size - 1L : this.start - this.size + 1L;
        return new long[]{order || this.asc ? this.start : end, order || this.asc ? end : this.start};
    }

    @Override
    public Object toJava() {
        long[] obj = new long[(int)this.size];
        int s = 0;
        while ((long)s < this.size) {
            obj[s] = this.start + (long)(this.asc ? s : -s);
            ++s;
        }
        return obj;
    }

    @Override
    public Item ebv(QueryContext qc, InputInfo ii) throws QueryException {
        throw QueryError.EBV_X.get(ii, this);
    }

    @Override
    public Int itemAt(long pos) {
        return Int.get(this.start + (this.asc ? pos : -pos));
    }

    @Override
    protected Seq subSeq(long offset, long length, QueryContext qc) {
        return new RangeSeq(this.start + (this.asc ? offset : -offset), length, this.asc);
    }

    @Override
    public Value insert(long pos, Item item, QueryContext qc) {
        return this.copyInsert(pos, item, qc);
    }

    @Override
    public Value remove(long pos, QueryContext qc) {
        return pos == 0L || pos == this.size - 1L ? this.subSeq(pos == 0L ? 0L : 1L, this.size - 1L, qc) : this.copyRemove(pos, qc);
    }

    @Override
    public Value reverse(QueryContext qc) {
        return RangeSeq.get(this.range(true)[1], this.size(), !this.asc);
    }

    @Override
    public void cache(boolean lazy, InputInfo ii) {
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo ii) {
        return this;
    }

    @Override
    public long atomSize() {
        return this.size;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof RangeSeq)) {
            return super.equals(obj);
        }
        RangeSeq seq = (RangeSeq)obj;
        return this.start == seq.start && this.size == seq.size && this.asc == seq.asc;
    }

    @Override
    public String description() {
        return "range sequence";
    }

    @Override
    public void plan(QueryPlan plan) {
        long[] range = this.range(true);
        plan.add(plan.create(this, "from", range[0], "to", range[1]), new ExprInfo[0]);
    }

    @Override
    public void plan(QueryString qs) {
        long[] range = this.range(false);
        String arg = new QueryString().token(range[0]).token("to").token(range[1]).toString();
        if (this.asc) {
            qs.paren(arg);
        } else {
            qs.function(Function.REVERSE, ' ' + arg);
        }
    }
}

