/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Dbl;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.list.DoubleList;

public final class DblSeq
extends NativeSeq {
    private final double[] values;

    private DblSeq(double[] values) {
        super(values.length, (Type)AtomType.DOUBLE);
        this.values = values;
    }

    @Override
    public Dbl itemAt(long pos) {
        return Dbl.get(this.values[(int)pos]);
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        double[] tmp = new double[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.values[i];
        }
        return DblSeq.get(tmp);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || (obj instanceof DblSeq ? Arrays.equals(this.values, ((DblSeq)obj).values) : super.equals(obj));
    }

    public double[] toJava() {
        return this.values;
    }

    public static Value get(double[] values) {
        int vl = values.length;
        return vl == 0 ? Empty.VALUE : (vl == 1 ? Dbl.get(values[0]) : new DblSeq(values));
    }

    static Value get(int size, Value ... values) throws QueryException {
        DoubleList tmp = new DoubleList(size);
        for (Value value : values) {
            if (value instanceof DblSeq) {
                tmp.add(((DblSeq)value).values);
                continue;
            }
            for (Item item : value) {
                tmp.add(item.dbl(null));
            }
        }
        return DblSeq.get(tmp.finish());
    }
}

