/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.seq;

import java.util.Arrays;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.value.Value;
import org.basex.query.value.item.Bln;
import org.basex.query.value.item.Item;
import org.basex.query.value.seq.Empty;
import org.basex.query.value.seq.NativeSeq;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.Type;
import org.basex.util.list.BoolList;

public final class BlnSeq
extends NativeSeq {
    private final boolean[] values;

    private BlnSeq(boolean[] values) {
        super(values.length, (Type)AtomType.BOOLEAN);
        this.values = values;
    }

    @Override
    public Bln itemAt(long pos) {
        return Bln.get(this.values[(int)pos]);
    }

    @Override
    public Value reverse(QueryContext qc) {
        int sz = (int)this.size;
        boolean[] tmp = new boolean[sz];
        for (int i = 0; i < sz; ++i) {
            tmp[sz - i - 1] = this.values[i];
        }
        return BlnSeq.get(tmp);
    }

    public boolean[] toJava() {
        return this.values;
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || (obj instanceof BlnSeq ? Arrays.equals(this.values, ((BlnSeq)obj).values) : super.equals(obj));
    }

    public static Value get(boolean[] values) {
        int vl = values.length;
        return vl == 0 ? Empty.VALUE : (vl == 1 ? Bln.get(values[0]) : new BlnSeq(values));
    }

    static Value get(int size, Value ... values) throws QueryException {
        BoolList tmp = new BoolList(size);
        for (Value value : values) {
            if (value instanceof BlnSeq) {
                tmp.add(((BlnSeq)value).values);
                continue;
            }
            for (Item item : value) {
                tmp.add(item.bool(null));
            }
        }
        return BlnSeq.get(tmp.finish());
    }
}

