/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import java.util.Objects;
import org.basex.query.QueryContext;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.ExprInfo;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FAttr;
import org.basex.query.value.node.FComm;
import org.basex.query.value.node.FNSpace;
import org.basex.query.value.node.FNode;
import org.basex.query.value.node.FPI;
import org.basex.query.value.node.FTxt;
import org.basex.query.value.type.NodeType;
import org.basex.util.Atts;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;
import org.basex.util.hash.TokenMap;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public final class FElem
extends FNode {
    private final QNm name;
    private ANodeList children;
    private ANodeList atts;
    private Atts ns;

    public FElem(String name) {
        this(Token.token(name));
    }

    public FElem(byte[] name) {
        this(new QNm(name));
    }

    public FElem(byte[] local, byte[] uri) {
        this(Token.EMPTY, local, uri);
    }

    public FElem(String local, String uri) {
        this(Token.EMPTY, Token.token(local), Token.token(uri));
    }

    public FElem(String prefix, String local, String uri) {
        this(Token.token(prefix), Token.token(local), Token.token(uri));
    }

    public FElem(byte[] prefix, byte[] local, byte[] uri) {
        this(new QNm(prefix, local, uri));
    }

    public FElem(QNm name) {
        this(name, null, null, null);
    }

    public FElem(QNm name, Atts ns, ANodeList children, ANodeList atts) {
        super(NodeType.ELEMENT);
        this.name = name;
        this.children = children;
        this.atts = atts;
        this.ns = ns;
    }

    public FElem(Element elem, FNode parent, TokenMap nss) {
        super(NodeType.ELEMENT);
        this.parent = parent;
        String nu = elem.getNamespaceURI();
        this.name = new QNm(elem.getNodeName(), nu == null ? Token.EMPTY : Token.token(nu));
        this.ns = new Atts();
        NamedNodeMap at = elem.getAttributes();
        int as = at.getLength();
        for (int i = 0; i < as; ++i) {
            Attr att = (Attr)at.item(i);
            byte[] nm = Token.token(att.getName());
            byte[] uri = Token.token(att.getValue());
            if (Token.eq(nm, Token.XMLNS)) {
                this.ns.add(Token.EMPTY, uri);
                continue;
            }
            if (Token.startsWith(nm, Token.XMLNS_COLON)) {
                this.ns.add(Token.local(nm), uri);
                continue;
            }
            this.add(new FAttr(att));
        }
        int nl = this.ns.size();
        for (int n = 0; n < nl; ++n) {
            nss.put(this.ns.name(n), this.ns.value(n));
        }
        if (parent == null) {
            FElem.nsScope(elem.getParentNode(), nss);
            for (byte[] pref : nss) {
                if (this.ns.contains(pref)) continue;
                this.ns.add(pref, nss.get(pref));
            }
        }
        byte[] pref = this.name.prefix();
        byte[] uri = this.name.uri();
        byte[] old = nss.get(pref);
        if (old == null || !Token.eq(uri, old)) {
            this.ns.add(pref, uri);
            nss.put(pref, uri);
        }
        NodeList ch = elem.getChildNodes();
        block9: for (int i = 0; i < ch.getLength(); ++i) {
            Node child = ch.item(i);
            switch (child.getNodeType()) {
                case 3: {
                    this.add(new FTxt((Text)child));
                    continue block9;
                }
                case 8: {
                    this.add(new FComm((Comment)child));
                    continue block9;
                }
                case 7: {
                    this.add(new FPI((ProcessingInstruction)child));
                    continue block9;
                }
                case 1: {
                    this.add(new FElem((Element)child, this, nss));
                    continue block9;
                }
            }
        }
        this.optimize();
    }

    private static void nsScope(Node elem, TokenMap nss) {
        Node n = elem;
        while (n instanceof Element) {
            NamedNodeMap atts = n.getAttributes();
            byte[] pref = Token.token(n.getPrefix());
            if (nss.get(pref) != null) {
                nss.put(pref, Token.token(n.getNamespaceURI()));
            }
            int len = atts.getLength();
            for (int i = 0; i < len; ++i) {
                byte[] ln;
                Attr a = (Attr)atts.item(i);
                byte[] name = Token.token(a.getName());
                byte[] val = Token.token(a.getValue());
                if (Token.eq(name, Token.XMLNS)) {
                    if (nss.get(Token.EMPTY) != null) continue;
                    nss.put(Token.EMPTY, val);
                    continue;
                }
                if (!Token.startsWith(name, Token.XMLNS) || nss.get(ln = Token.local(name)) != null) continue;
                nss.put(ln, val);
            }
            n = n.getParentNode();
        }
    }

    @Override
    public FElem optimize() {
        if (this.children != null) {
            for (ANode node : this.children) {
                node.parent(this);
            }
            if (this.children.isEmpty()) {
                this.children = null;
            }
        }
        if (this.atts != null) {
            for (ANode node : this.atts) {
                node.parent(this);
            }
            if (this.atts.isEmpty()) {
                this.atts = null;
            }
        }
        if (this.ns != null && this.ns.isEmpty()) {
            this.ns = null;
        }
        return this;
    }

    public FElem declareNS() {
        this.namespaces().add(this.name.prefix(), this.name.uri());
        return this;
    }

    public FElem add(ANode node) {
        if (node.type == NodeType.ATTRIBUTE) {
            if (this.atts == null) {
                this.atts = new ANodeList();
            }
            this.atts.add(node);
        } else {
            if (this.children == null) {
                this.children = new ANodeList();
            }
            this.children.add(node);
        }
        node.parent(this);
        return this;
    }

    public FElem add(String nm, String val) {
        return this.add(Token.token(nm), Token.token(val));
    }

    public FElem add(byte[] nm, String val) {
        return this.add(nm, Token.token(val));
    }

    public FElem add(String nm, byte[] val) {
        return this.add(Token.token(nm), val);
    }

    public FElem add(byte[] nm, byte[] val) {
        return this.add(new FAttr(nm, val));
    }

    public FElem add(QNm nm, String val) {
        return this.add(nm, Token.token(val));
    }

    public FElem add(QNm nm, byte[] val) {
        return this.add(new FAttr(nm, val));
    }

    public FElem add(String text) {
        return this.add(Token.token(text));
    }

    public FElem add(byte[] text) {
        if (text.length != 0) {
            FTxt txt = new FTxt(text);
            if (this.children == null) {
                this.children = new ANodeList();
            }
            this.children.add(txt);
            txt.parent(this);
        }
        return this;
    }

    @Override
    public Atts namespaces() {
        if (this.ns == null) {
            this.ns = new Atts();
        }
        return this.ns;
    }

    @Override
    public byte[] string() {
        return this.children == null ? Token.EMPTY : this.string(this.children);
    }

    @Override
    public byte[] baseURI() {
        byte[] base = this.attribute(QNm.XML_BASE);
        return base != null ? base : Token.EMPTY;
    }

    @Override
    public QNm qname() {
        return this.name;
    }

    @Override
    public byte[] name() {
        return this.name.string();
    }

    @Override
    public BasicNodeIter attributeIter() {
        return this.atts != null ? this.atts.iter() : BasicNodeIter.EMPTY;
    }

    @Override
    public BasicNodeIter childIter() {
        return this.children != null ? this.children.iter() : BasicNodeIter.EMPTY;
    }

    @Override
    public boolean hasChildren() {
        return this.children != null && !this.children.isEmpty();
    }

    @Override
    public FElem materialize(QueryContext qc, boolean copy) {
        if (!copy) {
            return this;
        }
        ANodeList ch = this.children != null ? new ANodeList(this.children.size()) : null;
        ANodeList at = this.atts != null ? new ANodeList(this.atts.size()) : null;
        Atts as = this.ns != null ? new Atts() : null;
        FElem node = new FElem(this.name, as, ch, at);
        if (as != null) {
            int nl = this.ns.size();
            for (int n = 0; n < nl; ++n) {
                as.add(this.ns.name(n), this.ns.value(n));
            }
        }
        if (at != null) {
            for (ANode nd : this.atts) {
                at.add(nd.materialize(qc, true));
            }
        }
        if (ch != null) {
            for (ANode nd : this.children) {
                ch.add(nd.materialize(qc, true));
            }
        }
        return node.optimize();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FElem)) {
            return false;
        }
        FElem f = (FElem)obj;
        return this.name.eq(f.name) && Objects.equals(this.children, f.children) && Objects.equals(this.atts, f.atts) && Objects.equals(this.ns, f.ns) && super.equals(obj);
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, "name", this.name.string()), new ExprInfo[0]);
    }

    @Override
    public void plan(QueryString qs) {
        byte[] nm = this.name.string();
        TokenBuilder tb = new TokenBuilder().add(60).add(nm);
        if (this.ns != null) {
            int nl = this.ns.size();
            for (int n = 0; n < nl; ++n) {
                tb.add(32).add(new FNSpace(this.ns.name(n), this.ns.value(n)));
            }
        }
        if (this.atts != null) {
            for (ANode att : this.atts) {
                tb.add(32).add(att);
            }
        }
        if (this.hasChildren()) {
            tb.add(62);
            ANode child = (ANode)this.children.get(0);
            if (child.type == NodeType.TEXT && this.children.size() == 1) {
                tb.add(QueryString.toValue(child.value));
            } else {
                tb.add("...");
            }
            tb.add("</").add(nm).add(62);
        } else {
            tb.add("/>");
        }
        qs.token(tb.finish());
    }
}

