/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import org.basex.query.QueryContext;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.QueryText;
import org.basex.query.expr.ExprInfo;
import org.basex.query.iter.BasicNodeIter;
import org.basex.query.util.list.ANodeList;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FElem;
import org.basex.query.value.node.FNode;
import org.basex.query.value.type.NodeType;
import org.basex.query.value.type.Type;
import org.basex.util.Token;
import org.basex.util.hash.TokenMap;
import org.basex.util.list.ByteList;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class FDoc
extends FNode {
    private final ANodeList children;
    private final byte[] uri;

    public FDoc() {
        this(Token.EMPTY);
    }

    public FDoc(String uri) {
        this(Token.token(uri));
    }

    public FDoc(byte[] uri) {
        this(new ANodeList(), uri);
    }

    public FDoc(ANodeList children, byte[] uri) {
        super(NodeType.DOCUMENT_NODE);
        this.children = children;
        this.uri = uri;
        this.optimize();
    }

    public FDoc(DocumentFragment doc, byte[] bu) {
        this(bu);
        Node elem = doc.getFirstChild();
        if (elem instanceof Element) {
            this.children.add(new FElem((Element)elem, this, new TokenMap()));
        }
    }

    @Override
    public FDoc optimize() {
        for (ANode node : this.children) {
            node.parent(this);
        }
        return this;
    }

    public FDoc add(ANode node) {
        this.children.add(node);
        node.parent(this);
        return this;
    }

    @Override
    public byte[] string() {
        return this.string(this.children);
    }

    @Override
    public BasicNodeIter childIter() {
        return this.children.iter();
    }

    @Override
    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    @Override
    public byte[] baseURI() {
        return this.uri;
    }

    @Override
    public FDoc materialize(QueryContext qc, boolean copy) {
        return copy ? new FDoc(this.children, this.uri).optimize() : this;
    }

    @Override
    public byte[] xdmInfo() {
        return new ByteList().add(this.typeId().asByte()).add(this.uri).add(0).finish();
    }

    @Override
    public Type.ID typeId() {
        return (this.children.size() == 1 && ((ANode)this.children.get((int)0)).type == NodeType.ELEMENT ? NodeType.DOCUMENT_NODE_ELEMENT : this.type).id();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FDoc)) {
            return false;
        }
        FDoc f = (FDoc)obj;
        return this.children.equals(f.children) && Token.eq(this.uri, f.uri) && super.equals(obj);
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, QueryText.BASE, this.uri), new ExprInfo[0]);
    }

    @Override
    public void plan(QueryString qs) {
        qs.token("document").brace(this.uri.length == 0 ? "..." : (Object)QueryString.toQuoted(this.uri));
    }
}

