/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.node;

import org.basex.query.QueryContext;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.ExprInfo;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.FNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.Token;
import org.basex.util.list.ByteList;
import org.w3c.dom.Attr;

public final class FAttr
extends FNode {
    private final QNm name;

    public FAttr(String name, String value) {
        this(Token.token(name), Token.token(value));
    }

    public FAttr(byte[] name, byte[] value) {
        this(new QNm(name), value);
    }

    public FAttr(QNm name, byte[] value) {
        super(NodeType.ATTRIBUTE);
        this.name = name;
        this.value = value;
    }

    public FAttr(Attr attr) {
        this(new QNm(attr.getName()), Token.token(attr.getValue()));
    }

    @Override
    public QNm qname() {
        return this.name;
    }

    @Override
    public byte[] name() {
        return this.name.string();
    }

    @Override
    public FAttr materialize(QueryContext qc, boolean copy) {
        return copy ? new FAttr(this.name, this.value) : this;
    }

    @Override
    public byte[] xdmInfo() {
        return new ByteList().add(this.typeId().asByte()).add(this.name.uri()).add(0).finish();
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj || obj instanceof FAttr && this.name.eq(((FAttr)obj).name) && super.equals(obj);
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, "name", this.name.string(), "value", this.value), new ExprInfo[0]);
    }

    @Override
    public void plan(QueryString qs) {
        qs.concat(this.name.string(), "=", QueryString.toQuoted(this.value));
    }
}

