/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.QueryText;
import org.basex.query.StaticContext;
import org.basex.query.util.NSGlobal;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.Strings;
import org.basex.util.Token;
import org.basex.util.XMLToken;
import org.basex.util.list.ByteList;

public final class QNm
extends Item {
    public static final QNm EMPTY = new QNm(Token.EMPTY);
    public static final QNm XML_BASE = new QNm(QueryText.BASE, QueryText.XML_URI);
    public static final QNm REST_ERROR = new QNm(QueryText.ERROR, QueryText.REST_URI);
    public static final Pattern EQNAME = Pattern.compile("^Q?\\{(.*?)}(.+)$");
    private final byte[] name;
    private final int pref;
    private byte[] uri;

    public QNm(byte[] name) {
        super(AtomType.QNAME);
        this.name = name;
        this.pref = Token.indexOf(name, 58);
    }

    public QNm(String name) {
        this(Token.token(name));
    }

    public QNm(byte[] name, byte[] uri) {
        this(name);
        this.uri(uri);
    }

    public QNm(String name, byte[] uri) {
        this(Token.token(name), uri);
    }

    public QNm(String name, String uri) {
        this(Token.token(name), uri == null ? null : Token.token(uri));
    }

    public QNm(byte[] name, StaticContext sc) {
        this(name);
        this.uri(sc.ns.uri(this.prefix()));
    }

    public QNm(QName name) {
        this(Token.token(name.getPrefix().isEmpty() ? name.getLocalPart() : (Object)Token.concat(name.getPrefix(), Token.COLON, name.getLocalPart())), Token.token(name.getNamespaceURI()));
    }

    public QNm(byte[] prefix, String local, byte[] uri) {
        this(prefix, Token.token(local), uri);
    }

    public QNm(byte[] prefix, byte[] local, byte[] uri) {
        this(QNm.name(prefix, local), uri);
    }

    private static byte[] name(byte[] prefix, byte[] local) {
        return prefix.length == 0 ? local : Token.concat(prefix, Token.COLON, local);
    }

    public static QNm resolve(byte[] name, StaticContext sc) throws QueryException {
        return QNm.resolve(name, null, sc, null);
    }

    public static QNm resolve(byte[] name, byte[] def, StaticContext sc, InputInfo ii) throws QueryException {
        Matcher m = EQNAME.matcher(Token.string(name));
        byte[] uri = null;
        byte[] nm = name;
        if (m.find()) {
            uri = Token.token(m.group(1));
            nm = Token.token(m.group(2));
        } else {
            int i = Token.indexOf(nm, 58);
            if (i == -1) {
                uri = def;
            } else {
                if (sc != null) {
                    uri = sc.ns.uri(Token.substring(nm, 0, i));
                }
                if (uri == null) {
                    throw QueryError.NOURI_X.get(ii, new Object[]{name});
                }
            }
        }
        if (!XMLToken.isQName(nm)) {
            throw QueryError.BINDNAME_X.get(ii, new Object[]{name});
        }
        return new QNm(nm, uri);
    }

    public void uri(byte[] u) {
        this.uri = u == null ? null : Token.normalize(u);
    }

    public byte[] uri() {
        return this.uri == null ? Token.EMPTY : this.uri;
    }

    public boolean hasURI() {
        return this.uri != null;
    }

    @Override
    public byte[] string(InputInfo ii) {
        return this.name;
    }

    public byte[] string() {
        return this.name;
    }

    @Override
    public boolean eq(Item item, Collation coll, StaticContext sc, InputInfo ii) throws QueryException {
        QNm nm;
        if (item instanceof QNm) {
            nm = (QNm)item;
        } else if (item.type.isUntyped() && sc != null) {
            nm = new QNm(item.string(ii), sc);
            if (!nm.hasURI() && nm.hasPrefix()) {
                throw QueryError.NSDECL_X.get(ii, new Object[]{nm.string()});
            }
        } else {
            throw QueryError.diffError(this, item, ii);
        }
        return this.eq(nm);
    }

    public boolean eq(QNm qnm) {
        return qnm == this || Token.eq(this.uri(), qnm.uri()) && Token.eq(this.local(), qnm.local());
    }

    @Override
    public int diff(Item item, Collation coll, InputInfo ii) throws QueryException {
        throw QueryError.diffError(item, this, ii);
    }

    public boolean hasPrefix() {
        return this.pref != -1;
    }

    public byte[] prefix() {
        return this.pref == -1 ? Token.EMPTY : Token.substring(this.name, 0, this.pref);
    }

    public byte[] local() {
        return this.pref == -1 ? this.name : Token.substring(this.name, this.pref + 1);
    }

    public byte[] id() {
        return this.uri == null ? this.name : QNm.internal(null, this.local(), this.uri);
    }

    public byte[] eqName() {
        return QNm.eqName(this.uri(), this.local());
    }

    public byte[] prefixId() {
        return this.prefixId(null);
    }

    public byte[] prefixId(byte[] ns) {
        byte[] u = this.uri();
        if (ns != null && Token.eq(u, ns)) {
            return this.local();
        }
        byte[] p = NSGlobal.prefix(u);
        return p.length != 0 ? Token.concat(p, Token.token(":"), this.local()) : this.id();
    }

    public byte[] prefixString() {
        return this.hasPrefix() ? this.string() : this.prefixId();
    }

    @Override
    public QName toJava() {
        return new QName(Token.string(this.uri()), Token.string(this.local()), Token.string(this.prefix()));
    }

    @Override
    public int hash(InputInfo ii) {
        return Token.hash(this.id());
    }

    @Override
    public byte[] xdmInfo() {
        return new ByteList().add(this.typeId().asByte()).add(this.uri()).add(0).finish();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof QNm)) {
            return false;
        }
        QNm qnm = (QNm)obj;
        return Token.eq(this.uri(), qnm.uri()) && Token.eq(this.name, qnm.name);
    }

    @Override
    public void plan(QueryString qs) {
        qs.token(this.id());
    }

    public static byte[] eqName(byte[] uri, byte[] local) {
        return Token.concat("Q{", uri, "}", local);
    }

    public static String eqName(String uri, String local) {
        return Strings.concat("Q{", uri, "}", local);
    }

    private static byte[] internal(byte[] prefix, byte[] local, byte[] uri) {
        int pl;
        int ul = uri == null ? 0 : uri.length;
        int n = pl = prefix == null ? 0 : prefix.length;
        if (ul == 0 && pl == 0) {
            return local;
        }
        int l = (ul == 0 ? 0 : ul + 3) + (pl == 0 ? 0 : pl + 1) + local.length;
        byte[] key = new byte[l];
        int i = 0;
        if (ul != 0) {
            key[i++] = 81;
            key[i++] = 123;
            Array.copyFromStart(uri, ul, key, i);
            key[i + ul] = 125;
            i += ul + 1;
        }
        if (pl != 0) {
            Array.copyFromStart(prefix, pl, key, i);
            key[i + pl] = 58;
            i += pl + 1;
        }
        Array.copyFromStart(local, local.length, key, i);
        return key;
    }
}

