/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.util.Arrays;
import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.Bin;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;
import org.basex.util.TokenBuilder;

public final class Hex
extends Bin {
    public Hex(byte[] value) {
        super(value, AtomType.HEX_BINARY);
    }

    public Hex(byte[] value, InputInfo ii) throws QueryException {
        super(Hex.parse(Token.trim(value), ii), AtomType.HEX_BINARY);
    }

    public Hex(Bin bin, InputInfo ii) throws QueryException {
        this(bin.binary(ii));
    }

    @Override
    public byte[] string(InputInfo ii) throws QueryException {
        return Token.hex(this.binary(ii), true);
    }

    @Override
    public boolean eq(Item item, Collation coll, StaticContext sc, InputInfo ii) throws QueryException {
        byte[] bin = item instanceof Bin ? ((Bin)item).binary(ii) : Hex.parse(item, ii);
        return Token.eq(this.binary(ii), bin);
    }

    @Override
    public int diff(Item item, Collation coll, InputInfo ii) throws QueryException {
        byte[] bin = item instanceof Bin ? ((Bin)item).binary(ii) : Hex.parse(item, ii);
        return Token.diff(this.binary(ii), bin);
    }

    public static byte[] parse(Item item, InputInfo ii) throws QueryException {
        byte[] bytes = Hex.parse(item.string(ii));
        if (bytes != null) {
            return bytes;
        }
        throw AtomType.HEX_BINARY.castError(item, ii);
    }

    public static byte[] parse(byte[] value, InputInfo ii) throws QueryException {
        byte[] bytes = Hex.parse(value);
        if (bytes != null) {
            return bytes;
        }
        throw AtomType.HEX_BINARY.castError(value, ii);
    }

    private static byte[] parse(byte[] data) {
        int dl = data.length;
        if ((dl & 1) != 0) {
            return null;
        }
        byte[] value = new byte[dl >>> 1];
        for (int d = 0; d < dl; d += 2) {
            int n = Token.dec(data[d], data[d + 1]);
            if (n < 0) {
                return null;
            }
            value[d >>> 1] = (byte)n;
        }
        return value;
    }

    @Override
    public void plan(QueryString qs) {
        TokenBuilder tb = new TokenBuilder().add(34);
        if (this.data.length > 128) {
            tb.add(Token.hex(Arrays.copyOf(this.data, 128), true)).add("...");
        } else {
            tb.add(Token.hex(this.data, true));
        }
        qs.token(tb.add(34).finish());
    }
}

