/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import java.util.LinkedList;
import org.basex.query.CompileContext;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryFocus;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.ann.Annotation;
import org.basex.query.expr.Expr;
import org.basex.query.expr.TypeCheck;
import org.basex.query.expr.gflwor.Clause;
import org.basex.query.expr.gflwor.GFLWOR;
import org.basex.query.expr.gflwor.Let;
import org.basex.query.func.DynFuncCall;
import org.basex.query.func.StaticFunc;
import org.basex.query.scope.Scope;
import org.basex.query.util.ASTVisitor;
import org.basex.query.util.Flag;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.list.AnnList;
import org.basex.query.value.Value;
import org.basex.query.value.item.FItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.SeqType;
import org.basex.query.var.Var;
import org.basex.query.var.VarRef;
import org.basex.query.var.VarScope;
import org.basex.util.InputInfo;
import org.basex.util.hash.IntObjMap;
import org.basex.util.list.StringList;

public final class FuncItem
extends FItem
implements Scope {
    public final StaticContext sc;
    private final Expr expr;
    private final QNm name;
    private final Var[] params;
    private final QueryFocus focus;
    private final int stackSize;
    private final InputInfo info;

    public FuncItem(StaticContext sc, AnnList anns, QNm name, Var[] params, FuncType type, Expr expr, int stackSize, InputInfo info) {
        this(sc, anns, name, params, type, expr, null, stackSize, info);
    }

    public FuncItem(StaticContext sc, AnnList anns, QNm name, Var[] params, FuncType type, Expr expr, QueryFocus focus, int stackSize, InputInfo info) {
        super(type, anns);
        this.name = name;
        this.params = params;
        this.expr = expr;
        this.stackSize = stackSize;
        this.sc = sc;
        this.focus = focus;
        this.info = info;
    }

    @Override
    public int arity() {
        return this.params.length;
    }

    @Override
    public QNm funcName() {
        return this.name;
    }

    @Override
    public QNm paramName(int ps) {
        return this.params[ps].name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value invokeInternal(QueryContext qc, InputInfo ii, Value[] args) throws QueryException {
        QueryFocus qf = qc.focus;
        qc.focus = this.focus != null ? this.focus : new QueryFocus();
        try {
            int pl = this.params.length;
            for (int p = 0; p < pl; ++p) {
                qc.set(this.params[p], args[p]);
            }
            Value value = this.expr.value(qc);
            return value;
        }
        finally {
            qc.focus = qf;
        }
    }

    @Override
    public int stackFrameSize() {
        return this.stackSize;
    }

    @Override
    public FuncItem coerceTo(FuncType ft, QueryContext qc, InputInfo ii, boolean optimize) throws QueryException {
        SeqType dt;
        int pl = this.params.length;
        int al = ft.argTypes.length;
        if (pl != ft.argTypes.length) {
            throw QueryError.FUNARITY_X_X.get(this.info, QueryError.arguments(pl), al);
        }
        FuncType tp = this.funcType();
        if (optimize ? tp.eq(ft) : tp.instanceOf(ft)) {
            return this;
        }
        CompileContext cc = new CompileContext(qc);
        VarScope vs = new VarScope(this.sc);
        Var[] vars = new Var[pl];
        Expr[] args = new Expr[pl];
        int p = pl;
        while (p-- > 0) {
            vars[p] = vs.addNew(this.params[p].name, ft.argTypes[p], true, qc, ii);
            args[p] = new VarRef(ii, vars[p]).optimize(cc);
        }
        cc.pushScope(vs);
        boolean updating = this.anns.contains(Annotation.UPDATING) || this.expr.has(Flag.UPD);
        Expr body = new DynFuncCall(ii, this.sc, updating, false, (Expr)this, args);
        if (optimize) {
            body = body.optimize(cc);
        }
        if (!tp.declType.instanceOf(dt = ft.declType)) {
            body = new TypeCheck(this.sc, ii, body, dt, true);
            if (optimize) {
                body = body.optimize(cc);
            }
        }
        SeqType bt = body.seqType();
        tp = optimize && !bt.eq(dt) && bt.instanceOf(dt) ? FuncType.get(bt, ft.argTypes) : ft;
        body.markTailCalls(null);
        return new FuncItem(this.sc, this.anns, this.name, vars, tp, body, vs.stackSize(), ii);
    }

    @Override
    public boolean accept(ASTVisitor visitor) {
        return visitor.funcItem(this);
    }

    @Override
    public boolean visit(ASTVisitor visitor) {
        for (Var param : this.params) {
            if (visitor.declared(param)) continue;
            return false;
        }
        return this.expr.accept(visitor);
    }

    @Override
    public void comp(CompileContext cc) {
    }

    @Override
    public boolean compiled() {
        return true;
    }

    @Override
    public Object toJava() {
        return this;
    }

    @Override
    public Expr inline(Expr[] exprs, CompileContext cc) throws QueryException {
        if (!StaticFunc.inline(cc, this.anns, this.expr) || this.expr.has(Flag.CTX)) {
            return null;
        }
        cc.info("inline %", this);
        LinkedList<Clause> clauses = new LinkedList<Clause>();
        IntObjMap<Var> vm = new IntObjMap<Var>();
        int pl = this.params.length;
        for (int p = 0; p < pl; ++p) {
            clauses.add(new Let(cc.copy(this.params[p], vm), exprs[p]).optimize(cc));
        }
        Expr rtrn = this.expr.copy(cc, vm).optimize(cc);
        rtrn.accept(new InlineVisitor());
        return clauses.isEmpty() ? rtrn : new GFLWOR(this.info, clauses, rtrn).optimize(cc);
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo ii) throws QueryException {
        throw QueryError.FIATOM_X.get(this.info, this.type);
    }

    @Override
    public Item atomItem(QueryContext qc, InputInfo ii) throws QueryException {
        throw QueryError.FIATOM_X.get(this.info, this.type);
    }

    @Override
    public Item materialize(QueryContext qc, boolean copy) {
        return null;
    }

    @Override
    public boolean deep(Item item, Collation coll, InputInfo ii) throws QueryException {
        throw QueryError.FICMP_X.get(this.info, this.type);
    }

    @Override
    public boolean vacuousBody() {
        SeqType st = this.expr.seqType();
        return st != null && st.zero() && !this.expr.has(Flag.UPD);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public String description() {
        return "function item";
    }

    @Override
    public void plan(QueryPlan plan) {
        plan.add(plan.create(this, "name", this.name == null ? null : this.name.prefixId()), new Object[]{this.params, this.expr});
    }

    @Override
    public String toErrorString() {
        QueryString qs = new QueryString();
        StringList list = new StringList(this.params.length);
        for (Var param : this.params) {
            list.add(param.toErrorString());
        }
        this.toString(qs, list.finish());
        return qs.toString();
    }

    @Override
    public void plan(QueryString qs) {
        this.toString(qs, this.params);
    }

    private void toString(QueryString qs, Object[] list) {
        if (this.name != null) {
            qs.concat("(: ", this.name.prefixId(), "#", this.arity(), " :)");
        }
        qs.token(this.anns).token("function").params(list).token("as").token(this.funcType().declType).brace(this.expr);
    }

    private class InlineVisitor
    extends ASTVisitor {
        private InlineVisitor() {
        }

        @Override
        public boolean inlineFunc(Scope scope) {
            return scope.visit(this);
        }

        @Override
        public boolean dynFuncCall(DynFuncCall call) {
            call.markInlined(FuncItem.this);
            return true;
        }
    }
}

