/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.item;

import org.basex.query.QueryException;
import org.basex.query.QueryString;
import org.basex.query.StaticContext;
import org.basex.query.util.collation.Collation;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.AtomType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public abstract class AStr
extends Item {
    byte[] value;

    AStr() {
        super(AtomType.STRING);
    }

    AStr(AtomType type, byte[] value) {
        super(type);
        this.value = value;
    }

    @Override
    public final boolean bool(InputInfo ii) throws QueryException {
        return this.string(ii).length != 0;
    }

    @Override
    public final boolean comparable(Item item) {
        return item.type.isStringOrUntyped();
    }

    @Override
    public final boolean eq(Item item, Collation coll, StaticContext sc, InputInfo ii) throws QueryException {
        byte[] str1 = this.string(ii);
        byte[] str2 = item.string(ii);
        return coll == null ? Token.eq(str1, str2) : coll.compare(str1, str2) == 0;
    }

    @Override
    public boolean sameKey(Item item, InputInfo ii) throws QueryException {
        return item.type.isStringOrUntyped() && this.eq(item, null, null, ii);
    }

    @Override
    public final int diff(Item item, Collation coll, InputInfo ii) throws QueryException {
        byte[] str1 = this.string(ii);
        byte[] str2 = item.string(ii);
        return coll == null ? Token.diff(str1, str2) : coll.compare(str1, str2);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AStr)) {
            return false;
        }
        AStr a = (AStr)obj;
        return this.type == a.type && Token.eq(this.value, a.value);
    }

    @Override
    public void plan(QueryString qs) {
        qs.quoted(this.value);
    }
}

