/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.array;

import java.util.ArrayList;
import java.util.ListIterator;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.expr.ExprInfo;
import org.basex.query.func.fn.DeepEqual;
import org.basex.query.util.collation.Collation;
import org.basex.query.util.list.ExprList;
import org.basex.query.value.Value;
import org.basex.query.value.ValueBuilder;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.array.EmptyArray;
import org.basex.query.value.array.SmallArray;
import org.basex.query.value.item.FuncItem;
import org.basex.query.value.item.Item;
import org.basex.query.value.item.QNm;
import org.basex.query.value.item.XQData;
import org.basex.query.value.map.XQMap;
import org.basex.query.value.type.AtomType;
import org.basex.query.value.type.FuncType;
import org.basex.query.value.type.MapType;
import org.basex.query.value.type.SeqType;
import org.basex.query.value.type.Type;
import org.basex.util.Array;
import org.basex.util.InputInfo;
import org.basex.util.TokenBuilder;

public abstract class XQArray
extends XQData {
    static final int MIN_LEAF = 8;
    static final int MAX_LEAF = 15;
    static final int MIN_DIGIT = 4;
    static final int MAX_DIGIT = 19;
    static final int MAX_SMALL = 7;
    private Iterable<Value> iterable;

    XQArray() {
        super(SeqType.ARRAY);
    }

    public static XQArray empty() {
        return EmptyArray.INSTANCE;
    }

    public static XQArray singleton(Value elem) {
        return new SmallArray(new Value[]{elem});
    }

    @SafeVarargs
    public static XQArray from(Value ... values) {
        ArrayBuilder builder = new ArrayBuilder();
        for (Value value : values) {
            builder.append(value);
        }
        return builder.freeze();
    }

    public abstract XQArray cons(Value var1);

    public abstract XQArray snoc(Value var1);

    public abstract Value get(long var1);

    public abstract XQArray put(long var1, Value var3);

    public abstract long arraySize();

    public abstract XQArray concat(XQArray var1);

    public abstract Value head();

    public abstract Value last();

    public abstract XQArray init();

    public abstract XQArray tail();

    public abstract XQArray subArray(long var1, long var3, QueryContext var5);

    public abstract XQArray reverseArray(QueryContext var1);

    public abstract boolean isEmptyArray();

    public abstract XQArray insertBefore(long var1, Value var3, QueryContext var4);

    public abstract XQArray remove(long var1, QueryContext var3);

    @Override
    public final void cache(boolean lazy, InputInfo ii) throws QueryException {
        for (Value value : this.members()) {
            value.cache(lazy, ii);
        }
    }

    public abstract ListIterator<Value> iterator(long var1);

    public final Iterable<Value> members() {
        if (this.iterable == null) {
            this.iterable = () -> this.iterator(0L);
        }
        return this.iterable;
    }

    abstract XQArray prepend(SmallArray var1);

    static Value[] slice(Value[] values, int from, int to) {
        Value[] out = new Value[to - from];
        int in0 = Math.max(0, from);
        int in1 = Math.min(to, values.length);
        int out0 = Math.max(-from, 0);
        Array.copy(values, in0, in1 - in0, out, out0);
        return out;
    }

    static Value[] concat(Value[] values1, Value[] values2) {
        int l = values1.length;
        int r = values2.length;
        int n = l + r;
        Value[] out = new Value[n];
        Array.copy(values1, l, out);
        Array.copyFromStart(values2, r, out, l);
        return out;
    }

    abstract void checkInvariants();

    @Override
    public final Value get(Item key, InputInfo ii) throws QueryException {
        if (!key.type.instanceOf(AtomType.INTEGER) && !key.type.isUntyped()) {
            throw QueryError.typeError(key, AtomType.INTEGER, ii);
        }
        long pos = key.itr(ii);
        long size = this.arraySize();
        if (pos > 0L && pos <= size) {
            return this.get(pos - 1L);
        }
        throw (size == 0L ? QueryError.ARRAYEMPTY : QueryError.ARRAYBOUNDS_X_X).get(ii, pos, size);
    }

    @Override
    public final QNm paramName(int pos) {
        return new QNm("pos", "");
    }

    @Override
    public final Value atomValue(QueryContext qc, InputInfo ii) throws QueryException {
        if (this.arraySize() == 1L) {
            return this.get(0L).atomValue(qc, ii);
        }
        ValueBuilder vb = new ValueBuilder(qc);
        for (Value value : this.members()) {
            vb.add(value.atomValue(qc, ii));
        }
        return vb.value(AtomType.ANY_ATOMIC_TYPE);
    }

    @Override
    public final Item atomItem(QueryContext qc, InputInfo ii) throws QueryException {
        return this.atomValue(qc, ii).item(qc, ii);
    }

    @Override
    public final long atomSize() {
        long size = 0L;
        for (Value value : this.members()) {
            for (Item item : value) {
                size += item.atomSize();
            }
        }
        return size;
    }

    @Override
    public final void string(boolean indent, TokenBuilder tb, int level, InputInfo ii) throws QueryException {
        tb.add(91);
        int c = 0;
        for (Value value : this.members()) {
            long vs;
            if (c++ > 0) {
                tb.add(44);
                if (indent) {
                    tb.add(32);
                }
            }
            if ((vs = value.size()) != 1L) {
                tb.add(40);
            }
            int cc = 0;
            int i = 0;
            while ((long)i < vs) {
                Item item;
                if (cc++ > 0) {
                    tb.add(44);
                    if (indent) {
                        tb.add(32);
                    }
                }
                if ((item = value.itemAt(i)) instanceof XQArray) {
                    ((XQArray)item).string(indent, tb, level, ii);
                } else if (item instanceof XQMap) {
                    ((XQMap)item).string(indent, tb, level + 1, ii);
                } else {
                    tb.add(item.toString());
                }
                ++i;
            }
            if (vs == 1L) continue;
            tb.add(41);
        }
        tb.add(93);
    }

    @Override
    public Item materialize(QueryContext qc, boolean copy) {
        for (Value value : this.members()) {
            for (Item item : value) {
                if (!item.persistent() && item.materialize(null, false) != null) continue;
                return null;
            }
        }
        return this;
    }

    @Override
    public boolean instanceOf(Type tp) {
        if (this.type.instanceOf(tp)) {
            return true;
        }
        if (!(tp instanceof FuncType) || tp instanceof MapType) {
            return false;
        }
        FuncType ft = (FuncType)tp;
        if (ft.argTypes.length != 1 || !ft.argTypes[0].instanceOf(SeqType.INTEGER_O)) {
            return false;
        }
        SeqType dt = ft.declType;
        if (dt.eq(SeqType.ITEM_ZM)) {
            return true;
        }
        for (Value value : this.members()) {
            if (dt.instance(value)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final boolean deep(Item item, Collation coll, InputInfo ii) throws QueryException {
        if (item instanceof FuncItem) {
            throw QueryError.FICMP_X.get(ii, this.type);
        }
        if (item instanceof XQArray) {
            XQArray o = (XQArray)item;
            if (this.arraySize() != o.arraySize()) {
                return false;
            }
            ListIterator<Value> iter1 = this.iterator(0L);
            ListIterator<Value> iter2 = o.iterator(0L);
            while (iter1.hasNext()) {
                Value value1 = (Value)iter1.next();
                Value value2 = (Value)iter2.next();
                if (value1.size() == value2.size() && new DeepEqual(ii).collation(coll).equal(value1, value2)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public final Object[] toJava() throws QueryException {
        long size = this.arraySize();
        ArrayList<Object> list = new ArrayList<Object>((int)size);
        ListIterator<Value> iter = this.iterator(0L);
        while (iter.hasNext()) {
            list.add(((Value)iter.next()).toJava());
        }
        return list.toArray();
    }

    @Override
    public final String description() {
        return "array";
    }

    @Override
    public final void plan(QueryPlan plan) {
        ExprList list = new ExprList();
        long size = this.arraySize();
        int max = (int)Math.min(size, 5L);
        for (int i = 0; i < max; ++i) {
            list.add(this.get(i));
        }
        plan.add(plan.create(this, "entries", size), (ExprInfo[])list.finish());
    }

    @Override
    public void plan(QueryString qs) {
        TokenBuilder tb = new TokenBuilder();
        ListIterator<Value> iter = this.iterator(0L);
        boolean fst = true;
        while (iter.hasNext()) {
            tb.add(fst ? " " : ", ");
            Value value = (Value)iter.next();
            long vs = value.size();
            if (vs != 1L) {
                tb.add(40);
            }
            int i = 0;
            while ((long)i < vs) {
                if (i != 0) {
                    tb.add(", ");
                }
                tb.add(value.itemAt(i));
                ++i;
            }
            if (vs != 1L) {
                tb.add(41);
            }
            fst = false;
        }
        qs.bracket(tb.add(32).finish());
    }
}

