/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.util.pkg;

import java.io.IOException;
import org.basex.io.IO;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.util.pkg.JarDesc;
import org.basex.query.util.pkg.PkgText;
import org.basex.query.value.item.QNm;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.DBNode;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

final class JarParser {
    private final InputInfo info;

    JarParser(InputInfo info) {
        this.info = info;
    }

    public JarDesc parse(IO io) throws QueryException {
        JarDesc desc = new JarDesc();
        try {
            ANode node = new DBNode(io).childIter().next();
            for (ANode next : node.childIter()) {
                if (next.type != NodeType.ELEMENT) continue;
                QNm name = next.qname();
                if (Token.eq(PkgText.E_JAR, name.local())) {
                    desc.jars.add(next.string());
                    continue;
                }
                if (!Token.eq(PkgText.E_CLASS, name.local())) continue;
                desc.classes.add(next.string());
            }
            if (desc.jars.isEmpty()) {
                throw QueryError.REPO_PARSE_X_X.get(this.info, io.name(), "No jars specified");
            }
            if (desc.classes.isEmpty()) {
                throw QueryError.REPO_PARSE_X_X.get(this.info, io.name(), "No public classes specified");
            }
            return desc;
        }
        catch (IOException ex) {
            throw QueryError.REPO_PARSE_X_X.get(this.info, io.name(), ex);
        }
    }
}

