/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.up.primitives;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.basex.build.Builder;
import org.basex.build.DirParser;
import org.basex.build.DiskBuilder;
import org.basex.build.MemBuilder;
import org.basex.build.Parser;
import org.basex.core.Context;
import org.basex.core.MainOptions;
import org.basex.core.StaticOptions;
import org.basex.core.cmd.CreateDB;
import org.basex.core.cmd.DropDB;
import org.basex.data.Data;
import org.basex.data.DataClip;
import org.basex.data.MemData;
import org.basex.io.IOFile;
import org.basex.query.QueryContext;
import org.basex.query.QueryError;
import org.basex.query.QueryException;
import org.basex.query.up.primitives.DBOptions;
import org.basex.query.up.primitives.NewInput;
import org.basex.query.value.node.ANode;
import org.basex.query.value.node.FDoc;
import org.basex.query.value.type.NodeType;
import org.basex.util.InputInfo;
import org.basex.util.Token;

public final class DBNew {
    public final List<NewInput> inputs;
    private final QueryContext qc;
    private final InputInfo info;
    private final List<DBOptions> dboptions;
    private Data data;

    public DBNew(QueryContext qc, DBOptions options, InputInfo info, NewInput ... list) {
        this.qc = qc;
        this.info = info;
        int is = list.length;
        this.inputs = new ArrayList<NewInput>(is);
        this.dboptions = new ArrayList<DBOptions>(is);
        for (NewInput input : list) {
            this.inputs.add(input);
            this.dboptions.add(options);
        }
    }

    public void merge(DBNew add) {
        this.inputs.addAll(add.inputs);
        this.dboptions.addAll(add.dboptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataClip prepare(String name, boolean create) throws QueryException {
        try {
            long is = this.inputs.size();
            if (is > 0L) {
                boolean cache = this.cache(create);
                if (is == 1L) {
                    this.data = this.tmpData(name, 0, cache);
                } else {
                    Context ctx = this.qc.context;
                    MainOptions mopts = ctx.options;
                    StaticOptions sopts = ctx.soptions;
                    String dbname = cache ? sopts.createTempDb(name) : name;
                    this.data = cache ? CreateDB.create(dbname, Parser.emptyParser(mopts), ctx, mopts) : new MemData(mopts);
                    this.data.startUpdate(mopts);
                    try {
                        int i = 0;
                        while ((long)i < is) {
                            Data tmpData = this.tmpData(dbname, i, cache);
                            try {
                                DBNew.copy(tmpData, this.data);
                            }
                            finally {
                                DropDB.drop(tmpData, sopts);
                            }
                            ++i;
                        }
                    }
                    finally {
                        this.data.finishUpdate(mopts);
                    }
                }
            }
            DataClip dataClip = this.data == null ? null : new DataClip(this.data).context(this.qc.context);
            return dataClip;
        }
        catch (IOException ex) {
            if (this.data != null) {
                new DataClip(this.data).context(this.qc.context).finish();
            }
            throw QueryError.UPDBERROR_X.get(this.info, ex);
        }
        finally {
            this.dboptions.clear();
            this.inputs.clear();
        }
    }

    public void addTo(Data target) throws QueryException {
        try {
            DBNew.copy(this.data, target);
        }
        catch (IOException ex) {
            throw QueryError.UPDBERROR_X.get(this.info, ex);
        }
    }

    private boolean cache(boolean create) {
        for (DBOptions dbopts : this.dboptions) {
            Object v = dbopts.get(MainOptions.ADDCACHE);
            if (v instanceof Boolean && ((Boolean)v).booleanValue()) {
                return true;
            }
            if (!create) continue;
            if (dbopts.get(MainOptions.PARSER) == MainOptions.MainParser.RAW) {
                return true;
            }
            v = dbopts.get(MainOptions.ADDRAW);
            if (!(v instanceof Boolean) || !((Boolean)v).booleanValue()) continue;
            return true;
        }
        return false;
    }

    private Data tmpData(String name, int i, boolean cache) throws IOException {
        NewInput input = this.inputs.get(i);
        MainOptions mopts = this.dboptions.get(i).assignTo(new MainOptions(this.qc.context.options, true));
        this.inputs.set(i, null);
        this.dboptions.set(i, null);
        ANode node = input.node;
        if (node != null) {
            if (node.type != NodeType.DOCUMENT_NODE) {
                node = new FDoc(name).add(node);
            }
            MemData mdata = (MemData)node.copy(mopts, this.qc).data();
            mdata.update(0, 0, Token.token(input.path));
            return mdata;
        }
        StaticOptions sopts = this.qc.context.soptions;
        Parser parser = new DirParser(input.io, mopts).target(input.path);
        String dbname = cache ? sopts.createTempDb(name) : name;
        Builder builder = cache ? new DiskBuilder(dbname, parser, sopts, mopts) : new MemBuilder(dbname, parser);
        return builder.binaryDir(sopts.dbPath(dbname)).build();
    }

    private static void copy(Data source, Data target) throws IOException {
        target.insert(target.meta.size, -1, new DataClip(source));
        IOFile srcDir = source.meta.binaryDir();
        IOFile trgDir = target.meta.binaryDir();
        if (srcDir != null && srcDir.exists()) {
            trgDir.md();
            for (String file : srcDir.descendants()) {
                IOFile srcFile = new IOFile(srcDir, file);
                IOFile trgFile = new IOFile(trgDir, file);
                trgFile.delete();
                trgFile.parent().md();
                Files.move(Paths.get(srcFile.path(), new String[0]), Paths.get(trgFile.path(), new String[0]), new CopyOption[0]);
            }
        }
    }
}

